//=============================================================================
// 100JobCall.js
//=============================================================================

/*:
 * @target MZ
 * @plugindesc 保存データ
 * @help
 * 保存データに関する処理を行うサンプルです。
 * 
 * メインシーンのコマンド
 * 
 * トラック一覧
 * 0  - 待機
 * 1  - コマンド切り替え
 * 2  - 
 * 3  - 
 * 4  - 土台
 * 5  - 自主トレ
 * 6  - 
 * 7  - 
 * 8  - 
 * 9  - 
 * 10 - 選択
 */

(() => {
    let JobUI    = 100;
    let JobSwS   = 51; //アルバイト管理スイッチ
    let UIPic    = 30; //UIのピクチャ番号
    let JobSw    = 38;
    let JobTime  = 0; //現在時刻
    let JobTime2 = 0; //増加予定
    let JobTime3 = 0; //時間制御
    let JobMin   = 0;
    let JobMin2  = 0;
    let JobSS    = 0; //制御
    let JobHp    = 0; //現在HP
    let JobHp2   = 0; //減少予定HP
    let JobHp3   = 0; //HP制御
    let JobMoney = 0; //獲得予定金額
    let JobCall  = "";
    const wait  = frames => new Promise(r => setTimeout(r, frames * (1000/60)));

    const JobMapp = {
        "noname": "000",
        "AB1"   : "選択1",
        "AB2"   : "選択2",
        "AB3"   : "選択3",
        "AB4"   : "選択4",
        "AB5"   : "選択5",
    };

    const JobBonusMapp = {
        "引っ越し": [83,30,3500],
        "塾講師": [84,10,1100],
        "飲食店": [87,20,2500],
        "パパ活": [0]
    };

    const SelectMap = {
        0: ["000",0],
        1: ["選択1"],
        2: ["選択2","引っ越し"],
        3: ["選択3","塾講師"],
        4: ["選択4","飲食店"],
        5: ["選択5"]
    };

    const JobAnimeMapp = {
        1: ["引っ越し","引っ越し2"],
        2: ["塾講師","塾講師2"],
        3: ["飲食","飲食2"],
    };

    window.アルバイト呼び出し = async function() {
        $gameVariables.setValue(10,101);
        Pフェード = [1,65,74,0,5];
        Spine = "アルバイト";

        JobTime  = $gameVariables.value(103);
        JobTime2 = 1;
        JobTime3 = JobTime + JobTime2;
        JobHp    = $gameVariables.value(106);
        JobHp2   = 0;
        JobHp3   = 0;
        JobMin   = "00";
        JobMin2  = $gameVariables.value(104);
        JobCall  = "";
        JobMoney = 0;

        $gameVariables.setValue(521,JobHp2);
        $gameVariables.setValue(522,JobTime2);
        $gameVariables.setValue(523,JobMin);
        $gameVariables.setValue(524,JobMoney);

        アニメ更新 = [0,UIPic,5,"ステ消し"];
        アニメ更新 = [1,JobUI,0,"出現","出現2"];
        JobCall   = SelectMap[2][1];

        var TT  = 0;
        var tt  = 93;
        var Pic = 101;
        Dテキスト = [Pic++,-50,221 + tt,TT,"\\f[b]\\v[521]",45,"right"];
        Dテキスト = [Pic++,-140,288 + tt,TT,"\\f[b]\\v[522]",45,"right"];
        Dテキスト = [Pic++,-50,288 + tt,TT,"\\f[b]\\v[523]",45,"right"];
        Dテキスト = [Pic++,-105,515 + tt,TT,"\\f[b]\\v[524]",50,"right"];

        await wait(15);
        選択肢呼び出し("アルバイト");
        アルバイトリセット();
        $gameVariables.setValue(524,JobMoney);
        await wait(30);
        Pフェード = [1,101,105,255,5];
        $gameSwitches.setValue(JobSw,true);
        $gameVariables.setValue(10,102);
    }

    window.アルバイト選択 = async function() {
        var Call = $gameVariables.value(2);
        var Anime = JobMapp[Call];

        アニメ更新 = [0,JobUI,10,Anime];
        CallSe(3);
    }

    window.アルバイト選択2 = async function(Call) {
        var Anime = SelectMap[Call][0];
        アニメ更新 = [0, 200, 10, Anime];

        if (Call !== 0) CallSe(3);
    }

    window.アルバイト決定 = async function(Call) {
        JobCall   = SelectMap[Call][1];
        アルバイトリセット();
        CallSe(3);
    }

    window.アルバイト設定実行 = async function() {
        $gameVariables.setValue(10,105);
        var Call = $gameVariables.value(2);

        if(Call === "AB1") {
            アルバイトリセット();
        } else if(Call === "AB2") {
            アルバイト時間(1);
        } else if(Call === "AB3") {
            アルバイト時間(-1);
        }else if(Call === "AB4") {
            var Val = (JobCall === "引っ越し") ? 2 : (JobCall === "塾講師") ? 3 : 4;
            var JobData = JobBonusMapp[JobCall];
            var Hp2 = JobData[1] * JobTime2;
            var Hp  = $gameVariables.value(106);
            if (Hp2 > Hp || Hp2 === 0) {
                $gameVariables.setValue(10,102);
                CallSe(2);
                return;
            }
            アルバイト実行(Val);
        }

        CallSe(1);

        await wait(5);
        if(Call !== "AB4") $gameVariables.setValue(10,102);
    }

    window.アルバイト時間 = async function(Call) {
        JobSS    = false;
        JobHp2   = 0;
        JobHp3   = 0;
        JobTime3 = JobTime + JobTime2 + Call;

        if(JobTime3 >= 21) {
            CallSe(2);
            JobSS = true;
        }

        if(!JobSS) {
            JobTime2+=Call;
        }

        if(!JobSS && JobTime2 <= 1) {
            //下限
            JobTime2 = 1;
        }

        アルバイト行動計算();

        await wait(1);
        if(JobSS) return;
        アルバイト金額計算(JobTime2);
        $gameVariables.setValue(521,JobHp2);
        $gameVariables.setValue(522,JobTime2);
        $gameVariables.setValue(524,JobMoney);
    }

    window.アルバイトリセット = async function() {
        JobTime2 = 1;
        アルバイト行動計算();
        アルバイト金額計算(JobTime2);
        $gameVariables.setValue(521,JobHp2);
        $gameVariables.setValue(522,JobTime2);
        $gameVariables.setValue(524,JobMoney);
    }

    window.アルバイト行動計算 = async function() {
        var Call = JobBonusMapp[JobCall];

        JobHp3 = JobHp - (Call[1] * JobTime2);
        if(JobHp3 < 0) {
            JobTime2--;
            JobSS = true;
        } else {
            JobHp2 = Call[1] * JobTime2;
        }
    }

    window.アルバイト金額計算 = async function(TCall) {
        var Call  = JobBonusMapp[JobCall];
        var BonusNum = $gameVariables.value(Call[0]);
        var Bonus = (BonusNum * 1.1);
        if(Bonus === 0) Bonus = 1;
        JobMoney = Call[2] * TCall * Bonus;
        $gameVariables.setValue(4, JobMoney.toLocaleString());
        $gameVariables.setValue(5, JobMoney);
    }

    window.アルバイト実行 = async function(Call) {
        $gameVariables.setValue(10,110);
        SpineChoiceManager.cancel(99);
        Pフェード = [0,200,0,5];
        if(Call === 2) {
            //引っ越し
            アルバイト(1);
        } else if(Call === 3) {
            //塾講師
            アルバイト(2);
        } else if(Call === 4) {
            //飲食店
            アルバイト(3);
        } else if(Call === 5) {
            アルバイト終了();
        }

        CallSe(1);
    }

    window.アルバイト終了 = async function() {
        $gameVariables.setValue(10,105);
        $gameSwitches.setValue(JobSw,false);
        Pフェード = [1,100,106,0,5];

        await wait(15);
        アニメ更新 = [0,UIPic,5,"000"];
        P消去 = [1,100,106];
        P消去 = [0,200];
        Pフェード = [1,65,74,255,5];
        $gameVariables.setValue(10,0);
    }

    window.アルバイト = async function(Call) {
        JobTime3 = JobTime3 - 1;
        var Time = JobTime3 + JobMin2;
        var Anime = JobAnimeMapp[Call];
        $gameVariables.setValue(3,Call);
        $gameVariables.setValue(105,$gameVariables.value(105) + $gameVariables.value(5));
        $gameVariables.setValue(10,108);
        $gameScreen.startFadeOut(30);
        await wait(30);

        Spine = "アルバイト2";
        P消去 = [0,200];
        UI消去();
        UI金額更新();
        Pフェード = [1,100,106,0,1];
        Pフェード = [0,10,0,1];
        背景セット2 = [6,JobCall];
        アルバイト管理(10);
        行動消費($gameVariables.value(521));
        TimeSet = Time;

        await wait(15);
        $gameScreen.startFadeIn(30);

        await wait(15);
        アニメ更新 = [1,110,0,Anime[0],Anime[1]];
        CallSe(9);

        await wait(95);
        if(JobTime3 >= 18) {
            アルバイト管理(18);
        }
        await wait(130);
        if(JobTime3 >= 20) {
            アルバイト管理(20);
        }
        await wait(130);

        アニメ更新 = [0,110,0,Anime[1]];
        await NrTextFile.command("System/Job");
        await $gameSwitches.setValue(JobSwS,true);
    }

    window.アルバイト管理 = function(Call) {
        var Time = Call;
        var pictureId = 0;

        if (Time >= 7 && Time <= 16) pictureId = 6;
        if (Time >= 17 && Time <= 19) pictureId = 9;
        if (Time >= 20 && Time <= 24) pictureId = 8;
        if (Time >= 0 && Time <= 6)  pictureId = 8;

        if (pictureId === 6) {
            for (var i = 6; i <= 9; i++) {
                Pフェード = [0, i, 255, 30];
            }
        } else {
            for (var i = pictureId; i <= 9; i++) {
                Pフェード = [0, i, 0, 30];
            }
        }
    };

})();
