//=============================================================================
// 100MemoryCall.js
//=============================================================================

/*:
 * @target MZ
 * @plugindesc 保存データ
 * @help
 * 保存データに関する処理を行うサンプルです。
 * メインシーンのコマンド
 * 
 * 
 * トラック一覧
 * 0  - 待機
 * 1  - 
 * 2  - 
 * 3  - 
 * 4  - 
 * 5  - 
 * 6  - 
 * 7  - 
 * 8  - 
 * 9  - 
 * 10 - 選択
*/

(() => {
    let MUIPic   = 100; //回想UIのピクチャ番号
    let MemorySw = 190; //回想制御スイッチ番号
    let MPage    = 1;
    let MemoryBox = [];
    const wait  = frames => new Promise(r => setTimeout(r, frames * (1000/60)));

    const RbgMapp = {
        "Sw121": ["背景4","HMain/HScene8",324],
        "Sw122": ["背景5","HMain/HScene9",355],
        "Sw123": ["背景1","HMain/HScene1",123],
        "Sw124": ["背景1","HMain/HScene2",151],
        "Sw125": ["背景11","HMain/HScene3",198],
        "Sw126": ["背景2","HMain/HScene4",227],
        "Sw127": ["背景2","HMain/HScene5",253],
        "Sw128": ["背景2","HMain/HScene6",289],
        "Sw129": ["背景3","HMain/HScene7",314],
        "Sw130": ["背景6","HMain/HScene10",387],
        "Sw131": ["背景7","HMain/HScene11",419],
        "Sw132": ["背景8","HMain/HScene12",448],
        "Sw133": ["背景9","HMain/HScene13",488],
        "Sw134": ["背景12","HMain/HScene14",538],
        "Sw135": ["背景10","HMain/HScene15",577]
    };

    const RMMapp = {
        "noname" : ["000", 10],
        "RB1": ["選択1", 0],
        "RB2": ["選択2", 1],
        "RB3": ["選択3", 2],
        "RB4": ["選択4", 3],
        "RB5": ["選択5", 4],
        "RB6": ["選択6", 5],
        "RB7": ["選択7", 6],
        "RB8": ["選択8", 7],
        "RB9": ["選択9", 8],
        "RB10": ["選択10", 9]
    };

    window.回想呼び出し = async function() {
        $gameSystem.disableMenu();
        $gameScreen._brightness = 0;
        停止("BGM");
        $gameVariables.setValue(10,100);
        初期セット();
        $gameScreen.startFadeOut(60); //フェードアウト
        await wait(60);
        utakata.CommonSave.load();

        SpineFree2 = [100,"回想",98,100,0,0];
        MemoryBox = [];
        MPage    = 1;
        回想判定(MPage);

        await wait(30);
        $gameScreen.startFadeIn(60); //フェードアウト
        アニメ更新 = [1,MUIPic,0,"出現1","待機1"];
        await wait(60);

        $gameSwitches.setValue(MemorySw,true);
        $gameVariables.setValue(10,0);
        CallBgm(9);
    }

    window.回想選択 = async function(Call) {
        var Anime = RMMapp[Call];
        var CallN = Anime[1];

        アニメ更新 = [0,MUIPic,10,Anime[0]];
        if(Anime[1] <= 5) {
            var AnimeC = MemoryBox[CallN];
            var Anime2 = RbgMapp[AnimeC[0]][0];
            アニメ更新 = [0,MUIPic,5,Anime2];
            if(AnimeC[1] === true) {
                アニメ更新 = [0,MUIPic,6,"解放"];
            } else {
                アニメ更新 = [0,MUIPic,6,"000"];
            }
        }

        if(Anime[1] !== 10) CallSe(1);
    };

    window.回想実行 = async function(Call) {
        var MemCall = RMMapp[Call][1];

        if(MemCall <= 5) {
            回想開始(MemCall);
        } else if(MemCall === 6) {
            回想頁(1);
        } else if(MemCall === 7) {
            回想頁(2);
        } else if(MemCall === 8) {
            回想頁(3);
        } else if(MemCall === 9) {
            回想終了();
        }
    };

    window.回想頁 = async function(Call) {
        if(MPage === Call) return;
        CallSe(1);
        $gameVariables.setValue(10,74);
        MPage = Call;

        $gameScreen.startFadeOut(30); //フェードアウト
        await wait(30); 

        回想判定(MPage);
        await wait(1);
        var AnimeC = MemoryBox[0];
        var Anime2 = RbgMapp[AnimeC[0]][0];
        アニメ更新 = [0,MUIPic,5,Anime2];
        アニメ更新 = [0,MUIPic,0,"待機" + MPage];

        await wait(30);
        $gameScreen.startFadeIn(30); //フェードイン
        await wait(30);
        $gameVariables.setValue(10,0);
    };

    window.回想開始 = async function(MemCall) {
        const data = MemoryBox[MemCall];
        if (!data[1]) return;

        停止("BGM");
        $gameVariables.setValue(10,10);
        $gameSwitches.setValue(32,true);
        $gameSwitches.setValue(33,true);
        $gameScreen.startFadeOut(30);
        await wait(30);

        回想開始準備();
        const key = data[0];
        const info = RbgMapp[key];
        const path = info[1];
        console.log(path);

        await ストーリー開始();
        await NrTextFile.command(path);
        await ストーリー終了("回想");
        await 回想終了準備();
    };

    window.回想開始準備 = async function() {
        Pフェード = [0,100,0,1];
    }

    window.回想終了準備 = async function() {
        Pフェード = [0,100,255,1];
        await wait(5);

        $gameScreen.startFadeIn(30);
        await wait(30);
        $gameVariables.setValue(10,0);
        CallBgm(9);
    }

    window.回想開始準備 = async function() {
        Pフェード = [0,100,0,1];
    }

    window.回想終了 = async function() {
        $gameVariables.setValue(10,100);

        $gameScreen.startFadeOut(30);
        await wait(30);

        P消去 = [0,100];;
        $gameSwitches.setValue(MemorySw,false);

        await wait(30);
        await タイトル();
    }

    window.回想判定 = async function(Call) {
        var MSw121 = $gameSwitches.value(121);
        var MSw122 = $gameSwitches.value(122);
        var MSw123 = $gameSwitches.value(123);
        var MSw124 = $gameSwitches.value(124);
        var MSw125 = $gameSwitches.value(125);
        var MSw126 = $gameSwitches.value(126);
        var MSw127 = $gameSwitches.value(127);
        var MSw128 = $gameSwitches.value(128);
        var MSw129 = $gameSwitches.value(129);
        var MSw130 = $gameSwitches.value(130);
        var MSw131 = $gameSwitches.value(131);
        var MSw132 = $gameSwitches.value(132);
        var MSw133 = $gameSwitches.value(133);
        var MSw134 = $gameSwitches.value(134);
        var MSw135 = $gameSwitches.value(135);

        var Anime1 = "000";
        var Anime2 = "000";
        var Anime3 = "000";
        var Anime4 = "000";
        var Anime5 = "000";
        var Anime6 = "000";

        if (Call === 1) {
            if (MSw123) { Anime1 = "解放1"; }
            if (MSw126) { Anime2 = "解放2"; }
            if (MSw129) { Anime3 = "解放3"; }

            MemoryBox = [["Sw123", MSw123], ["Sw126", MSw126], ["Sw129", MSw129], ["000", true], ["000", true], ["000", true]];

        } else if (Call === 2) {
            if (MSw121) { Anime1 = "解放1"; }
            if (MSw124) { Anime2 = "解放2"; }
            if (MSw127) { Anime3 = "解放3"; }
            if (MSw130) { Anime4 = "解放4"; }
            if (MSw131) { Anime5 = "解放5"; }
            if (MSw133) { Anime6 = "解放6"; }

            MemoryBox = [["Sw121", MSw121], ["Sw124", MSw124], ["Sw127", MSw127], ["Sw130", MSw130], ["Sw131", MSw131], ["Sw133", MSw133]];

        } else if (Call === 3) {
            if (MSw122) { Anime1 = "解放1"; }
            if (MSw125) { Anime2 = "解放2"; }
            if (MSw128) { Anime3 = "解放3"; }
            if (MSw132) { Anime4 = "解放4"; }
            if (MSw134) { Anime5 = "解放5"; }
            if (MSw135) { Anime6 = "解放6"; }

            MemoryBox = [["Sw122", MSw122], ["Sw125", MSw125], ["Sw128", MSw128], ["Sw132", MSw132], ["Sw134", MSw134], ["Sw135", MSw135]];
        }

        var Call = MemoryBox[0];
        if(Call[1] === true) {
            アニメ更新 = [0,MUIPic,6,"解放"];
        } else {
            アニメ更新 = [0,MUIPic,6,"000"];
        }
    };

})();