//=============================================================================
// 100MessageCall.js
//=============================================================================

/*:
 * @target MZ
 * @plugindesc 保存データ
 * @help
 * 保存データに関する処理を行うサンプルです。
 * メッセージ系のコマンド
 * 
 * 
 * トラック一覧
 * 0  - 待機
 * 1  - オート / スキップ
 * 2  - 
 * 3  - 
 * 4  - 
 * 5  - ウィンドウ
 * 6  - 
 * 7  - 
 * 8  - 
 * 9  - 
 * 10 - 選択
*/

(() => {
    const TargetVarId = 1;
    let WinPic  = 50;
    let WinPic2 = 105;
    let WinSw   = false;
    let WinSwS  = false;
    let SWin    = false;
    let StorySw = 33;
    let AutoSw  = 18;
	let SkipSw  = 15;
    let HStory  = 33;
    let HStory2 = 19; //H中にウィンドウ非表示
    WindowsSw   = false;
    const wait  = frames => new Promise(r => setTimeout(r, frames * (1000/60)));

    const WinMap = {
        "noname": "000",
        "WB1": "選択1",
        "WB2": "選択2",
        "WB3": "選択3",
        "WB4": "選択4",
        "WB5": "選択5"
    };

    const alias_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function() {
        alias_update.apply(this, arguments);

        const currentValue = $gameVariables.value(TargetVarId);
        if (currentValue !== 0) {
            ウィンドウ表示($gameVariables.value(TargetVarId));
            $gameVariables.setValue(TargetVarId,0);
        }

        if (TouchInput.isTriggered() && $gameSwitches.value(SkipSw)) {
            if($gameSwitches.value(SkipSw)) {
                $gameSwitches.setValue(SkipSw,false);
                アニメ呼び出し = [0,WinPic,1,"000"];
            }
        }

        if(StorySw && $gameScreen.picture(WinPic)) {
            const isCtrlPressed = Input.isPressed('control');
            if(isCtrlPressed && !WinSwS) {
                $gameSwitches.setValue(15, isCtrlPressed)
                if($gameSwitches.value(14)) $gameSwitches.setValue(14,false);
                アニメ呼び出し = [0,WinPic,1,"スキップ"];;
                WinSwS = true;
            } else if(!isCtrlPressed && WinSwS) {
                $gameSwitches.setValue(15, isCtrlPressed);
                アニメ呼び出し = [0,WinPic,1,"000"];
                WinSwS = false;
            }

            if (TouchInput.isTriggered() && $gameSwitches.value(AutoSw) && $gameVariables.value(2) !== "WB3") {
                if($gameSwitches.value(14)) {
                    $gameSwitches.setValue(14,false);
                    アニメ呼び出し = [0,WinPic,1,"000"];
                }
            }
        }
    };

    window.ウィンドウ表示 = async function(WinCall) {
        if(WinCall >= 10) {
            ウィンドウ表示2(WinCall);
            return;
        }

        if(!$gameScreen.picture(WinPic)){
            Spine = "ウィンドウ"; //ウィンドウ表示
            await wait(1);
        }

        var Anime = "000";

        if($gameSwitches.value(32) && !WinSw){
            var Alp = $gameVariables.value(493) / 100;
            $gameScreen.spine(WinPic).setAlpha(5, Alp, true);
            アニメ呼び出し = [0,WinPic,0,"待機"];
            WinSw = true;
        }

        if(WinCall === 1) {
            if($gameSwitches.value(HStory) && $gameSwitches.value(HStory2)) {
                $gameScreen.spine(WinPic).setAlpha(5, 0, true);
            } else {
                $gameScreen.spine(WinPic).setAlpha(5, 1, true);
            }
            Anime = "ウィンドウ";
            アニメ呼び出し = [0,WinPic,5,Anime];
            WindowsSw = true;
            SWin      = true;
        } else if(WinCall === 2) {
            if($gameSwitches.value(HStory) && $gameSwitches.value(HStory2)) {
                $gameScreen.spine(WinPic).setAlpha(5, 0, true);
            } else {
                $gameScreen.spine(WinPic).setAlpha(5, 1, true);
            }
            Anime = "ウィンドウ2";
            アニメ呼び出し = [0,WinPic,5,Anime];
            WindowsSw = true;
            SWin      = true;
        } else if(WinCall === 3) {
            SWin      = false;
            Anime = "000";
            アニメ更新 = [1,WinPic,30,"閉じる","000"];
            await wait(5);
            アニメ呼び出し = [0,WinPic,0,Anime];
            アニメ呼び出し = [0,WinPic,5,Anime];
            WinSw = false;
            WindowsSw = true;
        } else if(WinCall === 4) {
            SWin  = false;
            Anime = "000";
            アニメ呼び出し = [0,WinPic,0,Anime];
            アニメ呼び出し = [0,WinPic,5,Anime];
            アニメ呼び出し = [0,WinPic,50,Anime];
            WinSw = false;
            WindowsSw = true;
        } else if(WinCall === 5) {
            if(!$gameScreen.picture(WinPic)) return;
            アニメ呼び出し = [0,WinPic,50,"ウィンドウ3"];
        } else if(WinCall === 6) {
            if(!$gameScreen.picture(WinPic)) return;
            アニメ呼び出し = [0,WinPic,50,"ウィンドウ4"];
        }

    }

    window.ウィンドウ表示2 = async function(WinCall) {
        if(!$gameScreen.picture(WinPic2)){
            Spine = "ウィンドウ2"; //ウィンドウ表示
            await wait(1);
        }

        var Anime = "000";

        if($gameSwitches.value(32) && !WinSw){
            アニメ呼び出し = [0,WinPic2,0,"待機"];
            WinSw = true;
        }

        if(WinCall === 10) {
            Anime = "ウィンドウ";
            アニメ呼び出し = [0,WinPic2,5,Anime];
            WindowsSw = true;
            SWin      = true;
        } else if(WinCall === 12) {
            Anime = "ウィンドウ2";
            アニメ呼び出し = [0,WinPic2,5,Anime];
            WindowsSw = true;
            SWin      = true;
        } else if(WinCall === 13) {
            SWin      = false;
            Anime = "000";
            アニメ更新 = [1,WinPic2,30,"閉じる","000"];
            await wait(5);
            アニメ呼び出し = [0,WinPic2,0,Anime];
            アニメ呼び出し = [0,WinPic2,5,Anime];
            WinSw = false;
            WindowsSw = true;
        } else if(WinCall === 14) {
            SWin  = false;
            Anime = "000";
            アニメ呼び出し = [0,WinPic2,0,Anime];
            アニメ呼び出し = [0,WinPic2,5,Anime];
            アニメ呼び出し = [0,WinPic2,50,Anime];
            WinSw = false;
            WindowsSw = true;
        } else if(WinCall === 15) {
            if(!$gameScreen.picture(WinPic2)) return;
            アニメ呼び出し = [0,WinPic2,50,"ウィンドウ3"];
        } else if(WinCall === 16) {
            if(!$gameScreen.picture(WinPic2)) return;
            アニメ呼び出し = [0,WinPic2,50,"ウィンドウ4"];
        }

    }

    window.ウィンドウ選択 = async function() {
        if($gameSwitches.value(30)) return;
        var WinSCall  = $gameVariables.value(2);
        var Anime     = WinMap[WinSCall];
        アニメ呼び出し = [0,WinPic,10,Anime];

        if(WinSCall !== "noname") {
            $gameSwitches.setValue(13,true);
            CallSe(3);
        } else {
            $gameSwitches.setValue(13,false);
        }
    }

    window.ウィンドウ実行 = async function() {
        if($gameSwitches.value(30) || !SWin) return;
        var WinSCall  = $gameVariables.value(2);

        if(WinSCall === "WB1") {
            オプション呼び出し();
        } else if(WinSCall === "WB2") {
            オート管理();
        } else if(WinSCall === "WB3") {
            スキップ管理();
        } else if(WinSCall === "WB4") {
            NovelGameLog.show();
        } else if(WinSCall === "WB5") {
            $gameSwitches.setValue(30,true);
        }
        CallSe(1);
    }

    window.オート管理 = async function() {
        if(WinSwS) WinSwS = false;
        var AutoSw = $gameSwitches.value(14);
        var SkipSw = $gameSwitches.value(15);
        var Anime = "000";

        if(SkipSw) $gameSwitches.setValue(15,false);

        if(AutoSw) {
            AutoSw = false;
        } else {
            AutoSw = true;
            Anime = "オート";
        }
        アニメ呼び出し = [0,WinPic,1,Anime];
        $gameSwitches.setValue(14,AutoSw);
    }

    window.スキップ管理 = async function() {
        var AutoSw = $gameSwitches.value(14);
        var SkipSw = $gameSwitches.value(15);
        var Anime = "000";
        if(AutoSw) $gameSwitches.setValue(14,false);

        if(SkipSw) {
            SkipSw = false;
        } else {
            SkipSw = true;
            Anime = "スキップ";
        }
        アニメ呼び出し = [0,WinPic,1,Anime];
        $gameSwitches.setValue(15,SkipSw);
    }
})();