//=============================================================================
// 100OptionCall.js
//=============================================================================

/*:
 * @target MZ
 * @plugindesc 保存データ
 * @help
 * 保存データに関する処理を行うサンプルです。
 * オプションシーンのコマンド
 * 
 * 
 * トラック一覧
 * 0  - 待機
 * 1  - 
 * 2  - ボイスカット
 * 3  - フルスクリーン
 * 4  - 画面サイズ
 * 5  - オート継続
 * 6  - スキップ継続
 * 7  - 左クリック
 * 8  - Hウィンドウ
 * 9  - 確認
 * 10 - 選択
 */

(() => {
    let OptionPic  = 150; //UIのピクチャ番号
    let OptionSw   = 23; //制御スイッチ番号
    let OpSNum     = 10;
    let OpSelNum   = 2;
    let AutoSSw    = false;
    let SkipSSw    = false;
    let OptionSS   = false;
    let OptionSw1  = false;
    let OptionSw2  = false;
    let OptionSw3  = false;
    let OptionSw4  = false;
    let OptionSw5  = false;
    let OpGagem    = 0;
    let OpGageM    = 0;
    let Opval2     = 0;
    let OptionX    = 0;
    const wait     = frames => new Promise(r => setTimeout(r, frames * (1000/60)));

    const OptionGageMap = {
        1 : [481,"master"],
        2 : [482,"bgm"],
        3 : [483,"bgs"],
        4 : [484,"se"],
        5 : [485,"voice"],
        6 : [491,""],
        7 : [492,""],
        8 : [493,""]
    };

    const OptionMap = {
        "noname": "000",
        "SB25": "選択1",
        "SB26": "選択2",
        "SB27": "選択3",
        "SB28": "選択4",
        "SB29": "選択5",
        "SB30": "選択6"
    };

    window.オプション呼び出し = async function(){
        $gameSwitches.setValue(30,true);
        $gameVariables.setValue(10,100);
        $gameScreen.startFadeOut(30);
        $gameSwitches.setValue(30,true);
        $gameSwitches.setValue(OptionSw,true);
        await wait(5);
        if($gameSwitches.value(14)) AutoSSw = true;
        if($gameSwitches.value(15)) SkipSSw = true;
        utakata.CommonSave.load();
        OptionSw1  = false;
        OptionSw2  = false;
        OptionSw3  = false;
        OptionSw4  = false;
        OptionSw5  = false;
        await wait(30);
        $gameSwitches.setValue(31, true);

        $gameVariables.setValue(481,ConfigManager.masterVolume);
        $gameVariables.setValue(482,ConfigManager.bgmVolume);
        $gameVariables.setValue(483,ConfigManager.bgsVolume);
        $gameVariables.setValue(484,ConfigManager.seVolume);
        $gameVariables.setValue(485,ConfigManager.voiceVolume);

        Spine = "オプション";
        var TT = 255;
        $gameSystem.showNrOptionNumber("オプション");
        /*
        Dテキスト = [151,726,262,TT,"\\f[b]\\v[481]",35,"center"];
        Dテキスト = [152,726,346,TT,"\\f[b]\\v[482]",35,"center"];
        Dテキスト = [153,726,427,TT,"\\f[b]\\v[483]",35,"center"];
        Dテキスト = [154,726,508,TT,"\\f[b]\\v[484]",35,"center"];
        Dテキスト = [155,726,589,TT,"\\f[b]\\v[485]",35,"center"];
        */

        アニメ呼び出し = [0,OptionPic,1,"表示"];
        if(!$gameSwitches.value(20)) アニメ呼び出し = [0,OptionPic,2,"ボイスカット"];
        var Anime = "000";
        if(Graphics._isFullScreen()) Anime = "フルスクリーン";
        アニメ呼び出し = [0,OptionPic,3,Anime];
        アニメ呼び出し = [0,OptionPic,4,"サイズ" + ConfigManager.screenSize];
        Anime = $gameSwitches.value(16) ? "オート継続" : "000";
        アニメ呼び出し = [0,OptionPic,5,Anime];
        Anime = $gameSwitches.value(17) ? "スキップ継続" : "000";
        アニメ呼び出し = [0,OptionPic,6,Anime];        
        Anime = $gameSwitches.value(18) ? "オート解除" : "000";
        アニメ呼び出し = [0,OptionPic,7,Anime];
        Anime = $gameSwitches.value(19) ? "非表示" : "000";
        アニメ呼び出し = [0,OptionPic,8,Anime];

        $gameScreen.spine(OptionPic).setAlpha(1, $gameVariables.value(493) / 100, true);
        NrSpineGage.forceUpdateAll();

        await wait(15);
        $gameScreen.startFadeIn(30);
        await wait(30);
        アニメ呼び出し = [0,OptionPic,0,"待機"];
        $gameSwitches.setValue(14,true);
        NrCustomMessage.create("テスト文章表示中……。");
        $gameVariables.setValue(10,0);
    }

    window.オプション選択 = async function(){
        if(OptionSS || !$gameScreen.picture(OptionPic)) return;
        var Call    = OptionMap[$gameVariables.value(OpSelNum)];

        アニメ呼び出し = [0,OptionPic,10,Call];
        if(Call !== "000") CallSe(3);
    }

    window.オプション実行 = async function(){
        if(OptionSS) return;
        var Call  = $gameVariables.value(OpSelNum);
        var SSw   = false;
        var SeSw  = false;

        if(Call === "SB1") {
            //マスター
            音量設定(1);
            SSw = true;
        } else if(Call === "SB2") {
            //BGM
            音量設定(2);
            SSw = true;
        } else if(Call === "SB3") {
            //BGS
            音量設定(3);
            SSw = true;
        } else if(Call === "SB4") {
            //SE
            音量設定(4);
            SSw = true;
        } else if(Call === "SB5") {
            //Voice
            音量設定(5);
            SSw = true;
        } else if(Call === "SB6") {
            //テキスト表示
            テキスト設定(6);
            SSw = true;
        } else if(Call === "SB7") {
            //オート速度
            テキスト設定(7);
            SSw = true;
        } else if(Call === "SB8") {
            //ウィンドウ透明度
            テキスト設定(8);
            SSw = true;
        } else if(Call === "SB9") {
            //VoiceCut ON
            ボイスカット設定(1);
            SeSw = true;
        } else if(Call === "SB10") {
            //VoiceCut OFF
            ボイスカット設定(2);
            SeSw = true;
        } else if(Call === "SB11") {
            //FullScreen
            フルスクリーン設定(1);
            SeSw = true;
        } else if(Call === "SB12") {
            //FullScreen
            フルスクリーン設定(2);
            SeSw = true;
        } else if(Call === "SB13") {
            //画面サイズ
            サイズ設定(1);
            SeSw = true;
        } else if(Call === "SB14") {
            //画面サイズ
            サイズ設定(2);
            SeSw = true;
        } else if(Call === "SB15") {
            //画面サイズ
            サイズ設定(3);
            SeSw = true;
        } else if(Call === "SB16") {
            //画面サイズ
            サイズ設定(4);
            SeSw = true;
        } else if(Call === "SB17") {
            //オート継続
            オート継続設定(2);
            SeSw = true;
        } else if(Call === "SB18") {
            //オート継続
            オート継続設定(1);
            SeSw = true;
        } else if(Call === "SB19") {
            //スキップ継続
            スキップ継続設定(2);
            SeSw = true;
        } else if(Call === "SB20") {
            //スキップ継続
            スキップ継続設定(1);
            SeSw = true;
        } else if(Call === "SB21") {
            //左クリック
            左クリック設定(2);
            SeSw = true;
        } else if(Call === "SB22") {
            //左クリック
            左クリック設定(1);
            SeSw = true;
        } else if(Call === "SB23") {
            //表示
            H表示設定(2);
            SeSw = true;
        } else if(Call === "SB24") {
            //表示
            H表示設定(1);
            SeSw = true;
        } else if(Call === "SB25") {
            //初期化
            初期化設定();
            SeSw = true;
        } else if(Call === "SB26") {
            //初期化
            確認設定(1);
            SeSw = true;
        } else if(Call === "SB27") {
            //ゲームに戻る
            if(TitleSS) {
                確認(2);
            } else {
                設定終了();
            }
            SeSw = true;
        } else if(Call === "SB28") {
            //タイトルに戻る
            確認設定(2);
            SeSw = true;
        } else if(Call === "SB29") {
            //確認　はい
            if(OptionSw4) {
                確認(1);
            } else {
                確認(2);
            }
            SeSw = true;
        } else if(Call === "SB30") {
            //確認　いいえ
            確認(3);
            SeSw = true;
        }

        if(SeSw) {
            CallSe(1);
            SeSw = false;
        }

        if(SSw) {
            OptionSS = true;
        }
    }

    window.音量設定 = async function(BoCall){
        OpGagem   = 310;
        OpGageM   = 820;
        OpNum     = OptionGageMap[BoCall];
        OptionSw1 = true;
    }

    window.テキスト設定 = async function(TeCall){
        OpGagem   = 1340;
        OpGageM   = 1860;
        OpNum     = OptionGageMap[TeCall];
        if(TeCall === 6) OptionSw2 = true;
        if(TeCall === 8) OptionSw3 = true;
    }

    window.ボイスカット設定 = async function(VcCall){
        var VC    = $gameSwitches.value(20);
        var Anime = "000";

        if(VcCall === 1 && !VC) {
            アニメ呼び出し = [0,OptionPic,2,Anime];
            $gameSwitches.setValue(20, true);
            utakata.CommonSave.save();
        }

        if(VcCall === 2 && VC) {
            Anime = "ボイスカット";
            アニメ呼び出し = [0,OptionPic,2,Anime];
            $gameSwitches.setValue(20, false);
            utakata.CommonSave.save();
        }
    }

    window.フルスクリーン設定 = async function(FullCall){
        var Anime = "000";
        if (Graphics._isFullScreen()) {
            if(FullCall === 1) return;
        } else {
            if(FullCall === 2) return;
            Anime = "フルスクリーン";
        }
        アニメ呼び出し = [0,OptionPic,3,Anime];
        toggleFullScreen();
    }

    window.サイズ設定 = async function(SizeCall){
        var Anime = "000";
        if (SizeCall === 1) {
            if(ConfigManager.screenSize === 1) return;
            Anime = "サイズ1";
        } else if (SizeCall === 2) {
            if(ConfigManager.screenSize === 2) return;
            Anime = "サイズ2";
        } else if (SizeCall === 3) {
            if(ConfigManager.screenSize === 3) return;
            Anime = "サイズ3";
        } else if (SizeCall === 4) {
            if(ConfigManager.screenSize === 4) return;
            Anime = "サイズ4";
        }

        アニメ呼び出し = [0,OptionPic,4,Anime];
        changeWindowSize(SizeCall);
    }

    window.オート継続設定 = async function(AutoCall){
        var Anime = "000";
        var AutoS = $gameSwitches.value(16);
        var SwNa  = false;
        if (!AutoS) {
            if(AutoCall === 1) return;
            Anime = "オート継続";
            SwNa  = true;
        } else {
            if(AutoCall === 2) return;
            SwNa  = false;
        }
        $gameSwitches.setValue(16,SwNa);
        アニメ呼び出し = [0,OptionPic,5,Anime];
        utakata.CommonSave.save();
    }

    window.スキップ継続設定 = async function(SkipCall){
        var Anime = "000";
        var SkipS = $gameSwitches.value(17);
        var SwNa  = false;
        if (!SkipS) {
            if(SkipCall === 1) return;
            Anime = "スキップ継続";
            SwNa  = true;
        } else {
            if(SkipCall === 2) return;
            SwNa  = false;
        }
        $gameSwitches.setValue(17,SwNa);
        アニメ呼び出し = [0,OptionPic,6,Anime];
        utakata.CommonSave.save();
    }    

    window.左クリック設定 = async function(ClickCall){
        var Anime  = "000";
        var ClickS = $gameSwitches.value(18);
        var SwNa   = false;
        if (!ClickS) {
            if(ClickCall === 1) return;
            Anime = "オート解除";
            SwNa  = true;
        } else {
            if(ClickCall === 2) return;
            SwNa  = false;
        }
        $gameSwitches.setValue(18,SwNa);
        アニメ呼び出し = [0,OptionPic,7,Anime];
        utakata.CommonSave.save();
    }    

    window.H表示設定 = async function(HCall){
        var Anime  = "000";
        var Hshow  = $gameSwitches.value(19);
        var SwNa   = false;
        if (!Hshow) {
            if(HCall === 1) return;
            Anime = "非表示";
            SwNa  = true;
        } else {
            if(HCall === 2) return;
            SwNa  = false;
        }
        $gameSwitches.setValue(19,SwNa);
        アニメ呼び出し = [0,OptionPic,8,Anime];
        utakata.CommonSave.save();
    }

    window.初期化設定 = async function() {
        ConfigManager.masterVolume = 100;
        ConfigManager.bgmVolume    = 100;
        ConfigManager.bgsVolume    = 100;
        ConfigManager.seVolume     = 100;
        ConfigManager.voiceVolume  = 100;

        AudioManager.masterVolume  = 100;
        AudioManager.bgmVolume     = 100;
        AudioManager.bgsVolume     = 100;
        AudioManager.seVolume      = 100;
        AudioManager.voiceVolume   = 100;

        $gameSwitches.setValue(16, false); // オート継続
        $gameSwitches.setValue(17, false); // スキップ継続
        $gameSwitches.setValue(18, false); // 左クリック
        $gameSwitches.setValue(19, false); // Hウィンドウ
        $gameSwitches.setValue(20, true); // ボイスカット

        $gameVariables.setValue(481, ConfigManager.masterVolume);
        $gameVariables.setValue(482, ConfigManager.bgmVolume);
        $gameVariables.setValue(483, ConfigManager.bgsVolume);
        $gameVariables.setValue(484, ConfigManager.seVolume);
        $gameVariables.setValue(485, ConfigManager.voiceVolume);
        $gameVariables.setValue(491,0);
        $gameVariables.setValue(492,0);
        $gameVariables.setValue(493,100);

        if($gameScreen.picture(OptionPic)) {
            アニメ呼び出し = [0, OptionPic, 2, "000"];
            アニメ呼び出し = [0, OptionPic, 5, "000"];
            アニメ呼び出し = [0, OptionPic, 6, "000"];
            アニメ呼び出し = [0, OptionPic, 7, "000"];
            アニメ呼び出し = [0, OptionPic, 8, "000"];
            $gameScreen.spine(OptionPic).setAlpha(1, $gameVariables.value(493) / 100, true);
            NrSpineGage.forceUpdateAll();
        }

        ConfigManager.save();
        utakata.CommonSave.save();
    };

    window.確認設定 = async function(Call){
        Pフェード = [1,152,155,0,1];
        if(Call === 1) {
            アニメ呼び出し = [0,OptionPic,0,"終了確認"];
            OptionSw4     = true;
        } else {
            アニメ呼び出し = [0,OptionPic,0,"タイトル確認"];
            OptionSw5     = true;
        }
    }

    window.確認 = async function(Call){
        if(Call === 1) {
            $gameVariables.setValue(OpSNum,100);
            $gameScreen.startFadeOut(30);
            NrCustomMessage.destroy();
            await wait(30);
            SceneManager.exit();
        } else if(Call === 2) {
            $gameVariables.setValue(OpSNum,100);
            $gameScreen.startFadeOut(30);
            NrCustomMessage.destroy();
            await wait(30);
            $gameSystem.hideNrOptionNumber();
            AudioManager.stopAll();
            SceneManager.goto(Scene_Title);
            $gameVariables.setValue(OpSNum,100);
            await wait(30);
            $gameVariables.setValue(OpSNum,0);
        } else if(Call === 3) {
            Pフェード = [1,152,155,255,1];
            アニメ呼び出し = [0,OptionPic,0,"待機"];
            OptionSw4     = false;
            OptionSw5     = false;
        }
    }

    window.設定終了 = async function(){
        $gameSwitches.setValue(14,false);
        $gameVariables.setValue(OpSNum,100);
        NrCustomMessage.hide();
        $gameScreen.startFadeOut(30);
        await wait(30);

        $gameSystem.hideNrOptionNumber();
        if($gameSwitches.value(32) && WindowsSw) {
            var Alp = $gameVariables.value(493) / 100;
            if($gameSwitches.value(19)) {
                Alp = 0;
            }
            $gameScreen.spine(50).setAlpha(5, Alp, true);
        }
        P消去 = [1,150,200];
        NrCustomMessage.destroy();

        await wait(15);
        if($gameSwitches.value(32)) $gameSwitches.setValue(31,false);
        $gameSwitches.setValue(30,false);
        $gameScreen.startFadeIn(30);
        await wait(30);
        if(MainCall) {
            MainCall = false;
            
        }
        $gameSwitches.setValue(OptionSw,false);
        if(AutoSSw) $gameSwitches.setValue(14,true);
        if(SkipSSw) $gameSwitches.setValue(15,true);
        $gameVariables.setValue(OpSNum,0);
    }

    //つまみ制御
    const _Scene_Map_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function() {
        _Scene_Map_update.apply(this, arguments);
        if (OptionSS && TouchInput.isReleased()) {
            //離したら停止
            if(OptionSw1) {
                if(OpNum[1] === "se") CallSe(1);
                if(OpNum[1] === "voice") ボイス再生(1051);;
                AudioManager[OpNum[1] + "Volume"] = Opval2;
                ConfigManager[OpNum[1] + "Volume"] = Opval2;
                ConfigManager.save();
                OptionSw1 = false;
            }
            if(OptionSw2) OptionSw2 = false;
            if(OptionSw3) OptionSw3 = false;
            utakata.CommonSave.save();
            OptionSS  = false;
        }

        if (OptionSS) {
            OptionX = TouchInput.x;
            this.updateOptionLoop();
        }
    };

    Scene_Map.prototype.updateOptionLoop = function() {
        var OPval = OptionX;

        //ここで最大値と最小値を制御
        if(OPval < OpGagem) OPval = OpGagem;
        if(OPval > OpGageM) OPval = OpGageM;

        var m = OPval - OpGagem;
        var M = OpGageM - OpGagem;
        if(OptionSw2) {
            OPval = Math.floor((m / M) * 10);
        } else {
            OPval = Math.floor((m / M) * 100);
        }

        if(OPval === Opval2) return;
        Opval2 = OPval;
        if(OpGageM === 1860 && !OptionSw3) {
            if(OptionSw2){
                Opval2 = 10 - Opval2;
            } else {
                Opval2 = 100 - Opval2;
            }
        }
        $gameVariables.setValue(OpNum[0],Opval2);
        if(OptionSw1) {
            AudioManager[OpNum[1] + "Volume"] = Opval2;
        }

        if(OptionSw3) {
            $gameScreen.spine(OptionPic).setAlpha(1, $gameVariables.value(493) / 100, true);
        }
    };

})();