//=============================================================================
// 100PlayerTraining.js
//=============================================================================

/*:
 * @target MZ
 * @plugindesc 保存データ。
 * @help
 * 保存データに関する処理を行うためのサンプルです。
 * 
 * 
 * トラック一覧（Mainからの引継ぎ）
 * 0  - 待機
 * 1  - コマンド切り替え
 * 2  - 
 * 3  - 
 * 4  - 土台
 * 5  - 自主トレ
 * 6  - 
 * 7  - 
 * 8  - 
 * 9  - 
 * 10 - 選択
 */

(() => {
    let UIPic   = 30; //UIのピクチャ番号
    let SelectPic   = 200; //選択肢のピクチャ番号
    TrainingNum = 0;
    let TraningBox = [];
    const wait  = frames => new Promise(r => setTimeout(r, frames * (1000/60)));

    const NrPlayerMapp = {
        0 : ["0",522,"\\C[0]0",525,"\\C[0]0"," "],
        2 : ["-25",522,7,525,3,"\\N[1]の筋力と精神力のスキルポイントが増えます。"],
        3 : ["-25",523,7,525,3,"\\N[1]の技術力と精神力のスキルポイントが増えます。"],
        4 : ["-25",524,5,526,5,"\\N[1]の知力と生命力のスキルポイントが増えます。"],
        5 : ["0",522,0,525,0,"自主トレを終了します。"],
    };

    const NrSelectMapp = {
        0 : "000",
        1 : "選択1",
        2 : "選択2",
        3 : "選択3",
        4 : "選択4",
        5 : "選択5"
    };

    window.自主トレ呼び出し = async function(){
        $gameVariables.setValue(10,101);
        $gameVariables.setValue(515," ");
        Pフェード = [1,65,73,0,5];
        アニメ更新 = [1,UIPic,5,"自主トレ","自主トレ2"];

        var TT  = 0;
        var tx = -5;
        var ty = 335 + 38; //+70
        var ty2 = 69;
        Dテキスト = [90,tx,ty,TT,"\\f[b]\\v[521] ",50,"right"];
        Dテキスト = [91,tx,ty + ty2,TT,"\\f[b]\\v[522] ",50,"right"];  //筋力
        Dテキスト = [92,tx,ty + ty2 * 2,TT,"\\f[b]\\v[523] ",50,"right"]; //技術
        Dテキスト = [93,tx,ty + ty2 * 3,TT,"\\f[b]\\v[524] ",50,"right"]; //知力
        Dテキスト = [94,tx,ty + ty2 * 4,TT,"\\f[b]\\v[525] ",50,"right"]; //精神
        Dテキスト = [95,tx,ty + ty2 * 5,TT,"\\f[b]\\v[526] ",50,"right"]; //生命
        自主トレテキスト(5);

        await wait(30);
        Pフェード = [1,90,95,255,15];
        選択肢呼び出し("自主トレ");
    }

    window.自主トレ選択 = async function(Call){
        自主トレテキスト(Call);
        var Anime = NrSelectMapp[Call];
        アニメ更新 = [0,SelectPic,10,Anime];
        CallSe(3);
    }

    window.自主トレテキスト = async function(Call){
        var CallText = NrPlayerMapp[Call];
        for (let i = 522; i < 527; i++) {
            if(i !== CallText[1] || i !== CallText[3]) {
                $gameVariables.setValue(i,"\\NrR\\NrOws[2]\\NrOwc[#000000]\\NRSH[#000000, 5, 200, 60, 5, 0]0");
            }
        }

        var CallTe  = 1;
        var CallTe2 = 1;
        if(Call === 0 || Call === 5) CallTe  = 0;
        if(Call === 5) CallTe2 = 0;
        var Te  = (CallTe === 0)  ? "\\NrR\\NrOws[2]\\NrOwc[#000000]\\NRSH[#000000, 5, 200, 60, 5, 0]" : "\\NrOws[2]\\NrOwc[#ffffff]\\NrCG[#b6325f,#ff887c,#b6325f|vertical|0.3,0.6,1.0]\\NRSH[#000000, 5, 200, 60, 5, 0]";
        var Te2 = (CallTe2 === 0) ? "\\NrR\\NrOws[2]\\NrOwc[#000000]\\NRSH[#000000, 5, 200, 60, 5, 0]" : "\\NrOws[2]\\NrOwc[#000000]\\NrCG[#a0e99a,#caf881,#a0e99a|vertical|0.3,0.6,1.0]\\NRSH[#000000, 5, 200, 60, 5, 0]+";

        自主トレボーナス(Call);

        $gameVariables.setValue(521,Te + CallText[0]);
        $gameVariables.setValue(CallText[1], Te2 + TraningBox[CallText[1] - 521]);
        $gameVariables.setValue(CallText[3], Te2 + TraningBox[CallText[3] - 521]);
    }

    window.自主トレ選択実行 = async function(Call){
        //2筋トレ,3AV,4座学,5やめる
        if([1, 2, 3, 4].includes(Call)) {
            自主トレ実行();
        } else if(Call === 4) {
            自主トレ終了();
        }
        CallSe(1);
    }

    function 自主トレボーナス(Call) {
        const data = NrPlayerMapp[Call];
        if (!data) return;

        const mainVarId = data[1];
        const baseMain  = data[2];
        const subVarId  = data[3];
        const baseSub   = data[4];

        let sum = 0;
        for (let i = 82; i <= 87; i++) {
            sum += $gameVariables.value(i);
        }
        const stage = Math.min(Math.floor(sum / 25), 10);

        let mainVal, subVal;
        if (mainVarId === 524) {
            [mainVal, subVal] = (stage === 10) ? [50, 50] : [5, 5];
        } else {
            mainVal = Math.round(baseMain * (1 + (stage / 10)));
            subVal  = Math.round(baseSub * (1 + (stage / 10)));
        }

        TraningBox = [Number(data[0]) || 0, 0, 0, 0, 0, 0];
        if (mainVarId >= 522 && mainVarId <= 526) {
            TraningBox[mainVarId - 521] = mainVal;
        }
        if (subVarId >= 522 && subVarId <= 526) {
            TraningBox[subVarId - 521] = subVal;
        }
    }

    window.自主トレ実行 = async function(Call){
        TrainingNum = Call;

        const Str = $gameVariables.value(90);
        const Tec = $gameVariables.value(91);
        const Int = $gameVariables.value(92);
        const Men = $gameVariables.value(93);
        const Vit = $gameVariables.value(94);

        行動消費(25);

        $gameVariables.setValue(90, Str + TraningBox[1]); // 筋力
        $gameVariables.setValue(91, Tec + TraningBox[2]); // 技術
        $gameVariables.setValue(92, Int + TraningBox[3]); // 知力
        $gameVariables.setValue(93, Men + TraningBox[4]); // 精神
        $gameVariables.setValue(94, Vit + TraningBox[5]); // 生命

        for (var i = 90; i <= 94; i++) {
            if($gameVariables.value(i) >= 999) {
                $gameVariables.setValue(i, 999);
            }
        }
        await NrTextFile.command("Talk/Training");
        await UI復帰();
        await 自主トレ終了();
    }

    window.自主トレ終了 = async function(){
        $gameVariables.setValue(1,3);
        Pフェード  = [1,90,95,0,5];
        アニメ更新 = [0,UIPic,5,"000"];

        await wait(10);
        Pフェード = [1,65,74,255,5];
        P消去 = [1,90,95];
        $gameVariables.setValue(10,0);
        アニメ更新 = [0,UIPic,1,"000"];
        アニメ更新 = [0,UIPic,0,"出現2"];
    }

})();
