//=============================================================================
// 100SaveLoad.js
//=============================================================================

/*:
 * @target MZ
 * @plugindesc 保存データ
 * @help
 * 保存データに関する処理を行うサンプルです。
 * セーブロードのコマンド
 * 
 * 
 * トラック一覧
 * 0  - セーブ/ロード
 * 1  - 待機/確認
 * 2  - 
 * 3  - 
 * 4  - 
 * 5  - 頁
 * 6  - 
 * 7  - 
 * 8  - 
 * 9  - 
 * 10 - 選択
 */

(() => {
    let SLPic    = 150;
    let SLPic2   = 199;
    let SLPic3   = 200;
    let SLSw     = 24;
    let SLSw2    = false;
    let SaveSw   = 0;
    let SaveSw2  = false;
    let SaveSw3  = false;
    let SLPage   = 0;
    const wait   = frames => new Promise(r => setTimeout(r, frames * (1000/60)));

    const SLMap = {
        "noname": [0,"000"],
        "SLB1": [0,"選択1"],
        "SLB2": [0,"選択2"],
        "SLB3": [0,"選択3"],
        "SLB4": [0,"選択4"],
        "SLB5": [0,"選択5"],
        "SLB6": [0,"選択6"],
        "SLB7": [0,"選択7"],
        "SLB8": [0,"選択8"],
        "SLB9": [0,"選択9"],
        "SLB10": [0,"選択10"],
        "SLB11": [1,"選択11"],
        "SLB12": [2,"選択12"],
        "SLB13": [3,"選択13"],
        "SLB14": [4,"選択14"],
        "SLB15": [5,"選択15"],
        "SLB16": [6,"選択16"],
        "SLB17": [7,"選択17"],
        "SLB18": [8,"選択18"],
        "SLB19": [9,"選択19"],
        "SLB20": [10,"選択20"],
        "SLB21": [11,"選択21"],
        "SLB22": [12,"選択22"],
        "SLB23": [0,"選択23"],
        "SLB24": [0,"選択24"],
        "SLB25": [0,"選択25"],
        "SLB26": [0,"選択26"],
        "SLB27": [0,"選択27"],
        "SLB28": [0,"選択28"],
    };

    const SLMap2 = {
        "noname": [0,"000"],
        "KB1": [0,"選択1"],
        "KB2": [0,"選択2"],
        "KB3": [0,"選択3"],
        "KB4": [0,"選択1"],
        "KB5": [0,"選択2"],
    };

    const SLP = {
        "SLB1": [1,"頁1"],
        "SLB2": [2,"頁2"],
        "SLB3": [3,"頁3"],
        "SLB4": [4,"頁4"],
        "SLB5": [5,"頁5"],
        "SLB6": [6,"頁6"],
        "SLB7": [7,"頁7"],
        "SLB8": [8,"頁8"],
        "SLB9": [9,"頁9"],
        "SLB10": [10,"頁10"],
    };

    const targetVars = [
        64,65,42,43,44,45,46,47,48,66,
        505,101,51,52,53,54,55,56,57,
        58,59,60,61,62
    ];

    window.SL呼び出し = async function(Call){
        $gameVariables.setValue(10,100);
        $gameSwitches.setValue(SLSw,true);
        await wait(5);
        NrSpineGage.setLabelVisible("行動", false);
        $gameScreen.startFadeOut(30);
        await wait(30);

        for (var i = 401; i < 450; i++) {
            $gameVariables.setValue(i, " ");
        }

        Spine   = "セーブ";
        Spine   = "セーブ2";
        Spine   = "確認";
        SLPage  = 1;
        SaveSw  = 0; //制御
        SaveSw2 = false; //ロード制御
        SaveSw3 = false; //セーブ制御
        アニメ呼び出し = [0,SLPic2,1,"透明"];
        $gameSwitches.setValue(26,false);
        $gameSwitches.setValue(27,false);
        if(Call === 1) {
            アニメ呼び出し = [0,SLPic,0,"セーブ"];
            アニメ呼び出し = [0,SLPic2,0,"セーブ"];
            $gameVariables.setValue(65,$gameVariables.value(507));
            $gameVariables.setValue(64, $gameActors.actor(2).name());
            SLSw2 = false;
        } else {
            if(TitleSS) {
                アニメ呼び出し = [0,SLPic,0,"ロード2"];
                アニメ呼び出し = [0,SLPic2,0,"ロード2"];
            } else {
                アニメ呼び出し = [0,SLPic,0,"ロード"];
                アニメ呼び出し = [0,SLPic2,0,"ロード"];
            }
            SLSw2 = true;
        }

        var TT  = 255;
        var sy  = 45;
        var sy2 = 35;
        Dテキスト = [151,40,157 + sy,TT,"\\f[b]\\v[401]",50,"right"]; //center,left,right
        Dテキスト = [152,40,257 + sy,TT,"\\f[b]\\v[402]",50,"right"];
        Dテキスト = [153,140,375 + sy2,TT,"\\f[b]\\v[403]",40,"right"];
        Dテキスト = [154,140,470 + sy2,TT,"\\f[b]\\v[404]",40,"right"];
        Dテキスト = [155,140,565 + sy2,TT,"\\f[b]\\v[405]",40,"right"];
        Dテキスト = [156,140,655 + sy2,TT,"\\f[b]\\v[406]",40,"right"];
        Dテキスト = [157,140,750 + sy2,TT,"\\f[b]\\v[407]",40,"right"];
        Dテキスト = [158,140,840 + sy2,TT,"\\f[b]\\v[408]",40,"right"];
        Dテキスト = [159,140,930 + sy2,TT,"\\f[b]\\v[409]",40,"right"];

        var sy5 = 25;
        var Sx  = 800;
        var Sx2 = 660;
        var Sx3 = 890;
        var Sy  = 314;
        var Sy2 = 348;
        var Sx4 = 1470;
        var Sx5 = 1330;
        var Sx6 = 1560;
        var Sy3 = 363;
        var Sy4 = 398;
        var i   = 0;
        var iy  = 110;
        var val = 410;
        var PPic = 160;

        while (i < 6) {
            if(i == 5) {
                var dy = (iy * i) + sy5 + 10;
            } else {
                var dy = (iy * i) + sy5;                
            }
            Dテキスト = [PPic++,Sx,Sy + dy,TT,"\\f[b]\\v[" + val + "]",30,"left"];
            val++;
            Dテキスト = [PPic++,Sx2,Sy2 + dy,TT,"\\f[b]\\v[" + val + "]",30,"right"];
            val++;
            Dテキスト = [PPic++,Sx3,Sy2 + dy,TT,"\\f[b]\\v[" + val + "]",30,"right"];
            val++;
            Dテキスト = [PPic++,Sx4,Sy3 + dy,TT,"\\f[b]\\v[" + val + "]",30,"left"];
            val++;
            Dテキスト = [PPic++,Sx5,Sy4 + dy,TT,"\\f[b]\\v[" + val + "]",30,"right"];
            val++;
            Dテキスト = [PPic++,Sx6,Sy4 + dy,TT,"\\f[b]\\v[" + val + "]",30,"right"];
            val++;
            i++;
        }

        await データ読み込み(1);

        if (セーブ有無(1)) {
            変数セットアップ(1);
        }

        for (let i = 2; i < 13; i++) {
            変数コマンドセットアップ(i);
        }

        NrSpineGage.forceUpdateAll();

        await wait(30);
        $gameScreen.startFadeIn(30);
        await wait(30);
        if(TitleSS) {
            アニメ呼び出し = [0,SLPic,1,"待機2"];
        } else {
            アニメ呼び出し = [0,SLPic,1,"待機"];
        }
        $gameVariables.setValue(10,0);
    }

    window.セーブ有無 = function(n) {
        const fs = require("fs");
        const path = require("path");
        const dir = path.join(process.mainModule.path, "save");
        const filePath = path.join(dir, `file${n}.rmmzsave`);
        const exists = fs.existsSync(filePath);
        return exists;
    };

    window.SL選択 = async function(){
        var Select = $gameVariables.value(2);

        if(SaveSw2 || SaveSw3) {
            var Call    = SLMap2[Select];
            アニメ呼び出し = [0,SLPic3,10,Call[1]];
        } else {
            var Call    = SLMap[Select];
            アニメ呼び出し = [0,SLPic2,10,Call[1]];
            if(Call[0] > 0) 変数セットアップ(Call[0]);
        }

        if(Call[1] !== "000") CallSe(3);
    }

    window.SL実行 = async function(){
        var Call    = $gameVariables.value(2);

        if (["SLB1","SLB2","SLB3","SLB4","SLB5","SLB6","SLB7","SLB8","SLB9","SLB10"].includes(Call)) {
            SL頁呼び出し();
        } else if (["SLB11","SLB12","SLB13","SLB14","SLB15","SLB16","SLB17","SLB18","SLB19","SLB20","SLB21","SLB22"].includes(Call)) {
            SLデータ呼び出し();
        } else if(Call === "SLB23") {
            アニメ呼び出し = [0,SLPic,1,"000"];
            アニメ呼び出し = [0,SLPic2,1,"終了確認"];
            SaveSw = 1;
            $gameSwitches.setValue(27,true);
        } else if(Call === "SLB24") {
            if(TitleSS) {
                タイトル();
            } else {
                SL終了();
            }
        } else if(Call === "SLB25") {
            if(TitleSS) {
                タイトル();
            } else {
                アニメ呼び出し = [0,SLPic,1,"000"];
                アニメ呼び出し = [0,SLPic2,1,"タイトル確認"];
                SaveSw = 2;
                $gameSwitches.setValue(27,true);
            }
        } else if(Call === "SLB26" || Call === "KB4") {
            SLYes();
        } else if(Call === "SLB27" || Call === "KB3" || Call === "KB5") {
            SLNo();
        } else if(Call === "KB1") {
            if(SaveSw3) {
                //セーブ
                アニメ呼び出し = [0,SLPic3,1,"上書き確認"];
                SaveSw = 3;
            } else if(SaveSw2) {
                var Val = SaveCall[0] + ((SLPage - 1) * 12);
                ロード(Val);
            }
        } else if(Call === "KB2") {
            アニメ呼び出し = [0,SLPic3,1,"消去確認"];
            SaveSw2 = true;
            SaveSw3 = true;
            SaveSw = 4;
        } else if(Call === "SLB28") {
            SL切り替え();
        }

        if(Call !== "000") CallSe(1);
    }

    window.SL切り替え = async function(){
        if(SLSw2) {
            //ロードからセーブへ
            SL呼び出し(1);
        } else {
            SL呼び出し(2);
        }
    }

    window.SLYes = async function(){
        var V = SaveSw;

        if(V === 1) {
            //終了
            終了();
        } else if(V === 2) {
            //タイトル
            タイトル();
        } else if(V === 3) {
            //セーブ上書き
            var Val = SaveCall[0] + ((SLPage - 1) * 12);
            セーブ([Val,SaveCall[0]]);
            await wait(15);
            SLNo();
        } else if(V === 4) {
            //データ消去
            SLデータ管理();
        }

        CallSe(1);
    }

    window.SLNo = async function(){
        var V = SaveSw;

        if([1,2].includes(V)) {
            //終了,タイトル
            アニメ呼び出し = [0,SLPic,1,"待機"];
            アニメ呼び出し = [0,SLPic2,1,"000"];
            アニメ呼び出し = [0,SLPic2,10,"000"];
            await wait(15);
            $gameSwitches.setValue(27,false);
        } else if([0,3,4].includes(V)) {
            アニメ呼び出し = [0,SLPic,1,"待機"];
            アニメ呼び出し = [0,SLPic3,1,"000"];
            アニメ呼び出し = [0,SLPic3,10,"000"];
            await wait(15);
            SaveSw2 = false;
            SaveSw3 = false;
            $gameSwitches.setValue(26,false);
            $gameSwitches.setValue(27,false);
        }

        SaveSw = 0;
    }

    window.SL頁呼び出し = async function(){
        var V = SLP[$gameVariables.value(2)];
        データ読み込み(V[0]);
        アニメ呼び出し = [0,SLPic,5,V[1]];
        SLPage = V[0];
        await データ読み込み(SLPage);
        変数セットアップ(1);
        for (let i = 2; i < 13; i++) {
            変数コマンドセットアップ(i);
        }
    }

    window.SLデータ呼び出し = async function(){
        SaveCall    = SLMap[$gameVariables.value(2)];
        if(SLSw2) {
            //ロード
            var Val = SaveCall[0] + ((SLPage - 1) * 12);
            if(セーブ有無(Val)) {
                アニメ呼び出し = [0,SLPic3,1,"ロード確認"];
                SaveSw2 = true;
                $gameSwitches.setValue(26,true);
            } else {
                return;
            }
        } else {
            //セーブ
            var Val = SaveCall[0] + ((SLPage - 1) * 12);
            if(セーブ有無(Val)) {
                アニメ呼び出し = [0,SLPic3,1,"セーブ確認"];
                SaveSw3 = true;
                $gameSwitches.setValue(26,true);
            } else {
                セーブ([Val,SaveCall[0]]);
            }
        }

    }

    window.SLデータ管理 = async function(){
        var Val = SaveCall[0] + ((SLPage - 1) * 12);
        データ消去(Val);
        await wait(15);
        await データ読み込み(SLPage);
        変数セットアップ(Val);
        SLNo();
        return true;
    };

    window.データ消去 = function(n) {
        const saveName = DataManager.makeSavename(n);
        if (StorageManager.exists(saveName)) {
            StorageManager.remove(saveName);
        }
    };

    window.セーブ = async function(n) {
        try {
            //セーブ時の日付などを記録
            const now = new Date();
            const year = now.getFullYear();
            const month = now.getMonth() + 1;
            const day = now.getDate();
            const hour = now.getHours().toString().padStart(2, '0');
            const minute = now.getMinutes().toString().padStart(2, '0');

            const formatted = `${year}/${month}/${day} ${hour}:${minute}`;
            $gameVariables.setValue(66, formatted); //変数66に記録

            $gameSystem.setSavefileId(n[0]);
            $gameSystem.onBeforeSave();
            const saveData = DataManager.makeSaveContents();

            const globalInfo = DataManager.loadGlobalInfo() || [];
            await StorageManager.saveObject(`file${n[0]}`, saveData);

            globalInfo[n[0]] = DataManager.makeSavefileInfo();
            DataManager.saveGlobalInfo(globalInfo);

            await データ読み込み(SLPage);
            変数セットアップ(n[1]);
            return true;
        } catch (e) {
            return false;
        }
    };

    window.ロード = async function(n) {
        if (!セーブ有無(n)) return false;

        await AudioManager.fadeOutBgm(10);
        $gameVariables.setValue(10,100);
        $gameScreen.startFadeOut(30);
        await wait(30);
        await DataManager.loadGame(n);
        $gamePlayer.reserveTransfer($gameMap.mapId(), $gamePlayer.x, $gamePlayer.y);
        $gamePlayer.requestMapReload();
        SceneManager.goto(Scene_Map);
        return true;
    };

    window.SL終了 = async function() {
        $gameVariables.setValue(10,100);
        $gameScreen.startFadeOut(30);
        await wait(30);

        P消去 = [1,150,200];
        $gameSwitches.setValue(SLSw,false);

        await wait(15);
        $gameScreen.startFadeIn(30);
        await wait(30);
        
        $gameVariables.setValue(10,0);
        CallBgm(3);
    };

    window.変数セットアップ = function(n) {
        const Data = window.データ[n-1];
        const safeData = Array.isArray(Data) ? Data : [];
        let ii = 0;
        for (let i = 401; i < 410; i++) {
            $gameVariables.setValue(i, safeData[ii++] ?? " ");
        }
        for (let j = 0; j < 3; j++) {
            const varId = 410 + j + (3 * (n - 1));
            $gameVariables.setValue(varId, safeData[ii++] ?? " ");
        }
        for (let i = 446; i < 458; i++) {
            let val = safeData[ii++];
            if (val === undefined || val === " ") {
                val = (i % 2 === 0) ? 0 : 100;
            }
            $gameVariables.setValue(i, val);
        }
    };

    window.変数コマンドセットアップ = function(n) {
        const Data = window.データ[n-1];
        const safeData = Array.isArray(Data) ? Data : [];
        let ii = 9;
        for (let j = 0; j < 3; j++) {
            const varId = 410 + j + (3 * (n - 1));
            $gameVariables.setValue(varId, safeData[ii++] ?? " ");
        }
    };    

    window.データ = [];

    window.データ読み込み = async function(group) {
        const fs = require("fs");
        const path = require("path");

        const startFile = (group - 1) * 12 + 1;
        const endFile = group * 12;

        for (let fileId = startFile; fileId <= endFile; fileId++) {
            const index = fileId - startFile;
            const filePath = path.join(process.mainModule.path, "save", `file${fileId}.rmmzsave`);

            try {
                const hasSave = fs.existsSync(filePath);
                if (hasSave) {
                    let saveData = null;
                    try {
                        saveData = await StorageManager.loadObject(`file${fileId}`);
                    } catch (e) {
                        console.error(`file${fileId} のロード失敗`, e);
                        saveData = null;
                    }
                    if (saveData && saveData.variables && saveData.variables._data) {
                        const vars = saveData.variables._data;
                        const data = targetVars.map(id => vars[id] ?? " ");
                        window.データ[index] = data;
                    } else {
                        console.warn(`セーブ${fileId}に変数データがありません`);
                        window.データ[index] = targetVars.map(() => " ");
                    }
                } else {
                    window.データ[index] = targetVars.map(() => " ");
                }
            } catch (e) {
                console.error(`file${fileId} の読み込み中にエラー:`, e);
                window.データ[index] = targetVars.map(() => " ");
            }
        }
    };

    //ロード後の判定
    const _correct = DataManager.correctDataErrors;
    DataManager.correctDataErrors = function() {
        try {
            _correct.call(this);
            $gameSwitches.setValue(26,false);
            $gameSwitches.setValue(27,false);
            $gameSwitches.setValue(25,true);
            $gameScreen._brightness = 0;
            TitleSS = false;
            NrSpineGage.forceUpdateAll();

            setTimeout(() => {
                アニメ更新 = [0,30,35,"000"];
                アニメ更新 = [0,30,36,"000"];
            }, 60 * (1000/60));
        } catch (e) {
            console.error("[デバッグ] correctDataErrors 失敗:", e);
            throw e;
        }
    };

})();
