//=============================================================================
// 100SelectCall.js
//=============================================================================

/*:
 * @target MZ
 * @plugindesc 保存データ
 * @help
 * 保存データに関する処理を行うサンプルです。
 * 選択肢のコマンド
 * 
 * 
 * イベント一覧
 * 0  - 
 * 1  - 
 * 2  - 
 * 3  - 
 * 4  - 
 * 5  - 
 * 6  - 
 * 7  - 
 * 8  - 
 * 9  - 
 * 10 - 
 */


(() => {
    let SelectUI   = 200;
    let ChoiceName = null;

    const SelectMap = {
        0: "000",
        1: "選択1",
        2: "選択2",
        3: "選択3",
        4: "選択4",
        5: "選択5"
    };

    const ChoiceMap = {
        "オープニング": ["", "EVSw = true","EVSw = false"],
    };

    window.選択肢呼び出し = async function(Call){
        SpineChoiceManager.show(Call);
        ChoiceName = Call;
        $gameScreen.startFadeIn(15);
    }

    window.選択肢 = async function(Call) {
        if(!$gameScreen.picture(200)) return;
        var Anime = SelectMap[Call];
        アニメ呼び出し = [0, SelectUI, 10, Anime];

        if (Call !== 0) CallSe(3);
    }

    window.選択肢待機 = async function() {
        const JudgeID = 6;

        return new Promise(resolve => {
            const interval = setInterval(() => {
                if ($gameVariables.value(JudgeID) > 0) {
                    clearInterval(interval);
                    resolve();
                }
            }, 16);
        });
    };

    window.選択肢実行 = async function(Call) {
        if(!$gameScreen.picture(200)) return;
        var SlChoice = ChoiceMap[ChoiceName];
        try {
            eval(SlChoice[Call]);
            CallSe(1);
        } catch (e) {
            console.warn("選択肢スクリプト実行エラー:", e);
        }
    }
})();