//=============================================================================
// 100TitleCall.js
//=============================================================================

/*:
 * @target MZ
 * @plugindesc 保存データ
 * @help
 * 保存データに関する処理を行うサンプルです。
 * タイトルシーンのコマンド
 * 
 * 
 */

(() => {
    let TitlePic  = 100; //UIのピクチャ番号
    TitleSw       = 21; //タイトル制御スイッチ番号
    TitleSS       = false;
    let TitleMs   = 1;
    let TitleSw2  = false;
    let TitleMs2  = 500;
    let TitleTime = 0;
    let TitleWatcherActive = false;
    let TitleNum  = 0;
    const wait    = ms => new Promise(resolve => setTimeout(resolve, ms));

    const TitleMap = {
        "noname": "000",
        "TB1": "選択1",
        "TB2": "選択2",
        "TB3": "選択3",
        "TB4": "選択4",
        "TB5": "選択5"
    };

    window.タイトル呼び出し = async function(){
        NrAutoBreak.setBreakLength(32);
        $gameVariables.setValue(10,100);
        $gameSwitches.setValue(TitleSw,true);
        TitleSS = false;
        TitleSw2  = false;
        TitleNum  = 0;
        $gameScreen._brightness = 0;
        await wait(30);
        utakata.CommonSave.load();
        await wait(1);
        if(!$gameSwitches.value(10)) {
            $gameSwitches.setValue(10,true);
            初期化設定();
        }

        Spine = "タイトル";

        $gameScreen.startFadeIn(30);
        アニメ呼び出し = [1,TitlePic,0,"出現","出現2"];
        await wait(15);

        ボイス再生(1055);
        CallBgm(1);
        $gameVariables.setValue(10,0);
    }

    window.タイトル選択 = async function(){
        if(TitleSS) return;
        var Call    = TitleMap[$gameVariables.value(2)];

        アニメ呼び出し = [0,TitlePic,10,Call];
        if(Call !== "000") CallSe(3);
    }

    window.タイトル実行 = async function(){
        if(TitleSS) return;
        var Call = $gameVariables.value(2);
        var SSw  = false;

        if(Call === "TB1") {
            $gameVariables.setValue(10, 100);
            ボイス再生(1047);
            TitleNum  = 1;
            エグジット();
            SSw = true;
        } else if(Call === "TB2") {
            $gameVariables.setValue(10, 100);
            ボイス再生(1048);
            ロードゲーム();
            SSw = true;
        } else if(Call === "TB3") {
            $gameVariables.setValue(10, 100);
            ボイス再生(1049);
            オプション();
            SSw = true;
        } else if(Call === "TB4") {
            $gameVariables.setValue(10, 100);
            ボイス再生(1050);
            エクストラ();
            SSw = true;
        } else if(Call === "TB5") {
            $gameVariables.setValue(10, 100);
            ボイス再生(1052);
            TitleNum  = 2;
            エグジット();
            SSw = true;
        }

        if(SSw) {
            TitleSS = true;
            CallSe(1);
        }
    }

    window.ニューゲーム = async function(){
        //ここにニューゲーム処理
        $gameScreen.startFadeOut(45);
        await wait(1000);
        AudioManager.stopAll();
        DataManager.setupNewGame();
        SceneManager.goto(Scene_Map);
        $gameSelfSwitches.setValue([1, 1, 'A'], true);
        TitleSS = false;
    }

    window.ロードゲーム = async function(){
        //ここにロード処理
        SL呼び出し(2);
    }

    window.オプション = async function(){
        オプション呼び出し();
    }

    window.エクストラ = async function(){
        //ここにおまけ処理
        $gameScreen.startFadeOut(45);
        await wait(1000);
        DataManager.setupNewGame();
        SceneManager.goto(Scene_Map);
        $gameSwitches.setValue(21, true);
        回想呼び出し();
    }

    window.エグジット = async function() {
        $gameVariables.setValue(10, 100);
        TitleWatcherActive = false;
        TitleTime = 0;
        TouchInput.clear();
        await wait(1);
        T監視開始();
    };

    async function TitleWatcher() {
        if (TitleWatcherActive) return;
        TitleWatcherActive = true;

        while (TitleSw2) {
            TitleTick();
            if(TouchInput.isTriggered()) {
                T監視停止();
                if(TitleNum === 1) {
                    ニューゲーム();
                } else {
                    T終了();
                }
            }
            await new Promise(resolve => setTimeout(resolve, TitleMs));
        }

        TitleWatcherActive = false;
    }

    window.TitleTick = async function() {
        TitleTime++;

        if(TitleTime >= TitleMs2) {
            T監視停止();
            if(TitleNum === 1) {
                ニューゲーム();
            } else {
                T終了();
            }
        }
    }

    window.T終了 = async function() {
            $gameScreen.startFadeOut(30);
            await wait(30);
            SceneManager.exit();
    }

    window.T監視開始 = function() {
        TitleSw2 = true;
        TitleWatcher();
    }

    window.T監視停止 = function() {
        TitleSw2 = false;
    }
})();