//=============================================================================
// NrCustomScene.js
//=============================================================================

/*:
 * @target MZ
 * @plugindesc オリジナルシーンプラグイン v1.0.0
 * @author NJ
 *
 * @param blockSwitchId
 * @text blockSwitchId
 * @type switch
 * @desc ONの間、決定キーやクリックによるメッセージ送りを無効にします。
 * @default 0
 *
 * バージョン
 * v1.0.0 初回
 *
 * 利用規約：
 *  プラグイン作者に無断で使用、改変、再配布は不可です。
 */

(() => {
  const parameters = PluginManager.parameters(document.currentScript.src.match(/([^\/]+)\.js$/)[1] || "NrCustomScene");
  const blockSwitchId = Number(parameters["blockSwitchId"] || 0);

  const _Window_Message_isTriggered = Window_Message.prototype.isTriggered;
  Window_Message.prototype.isTriggered = function() {
    if (blockSwitchId > 0 && $gameSwitches && $gameSwitches.value(blockSwitchId)) {
      return false;
    }
    return _Window_Message_isTriggered.call(this);
  };

  class Scene_NrCustomScene extends Scene_Base {
    create() {
      super.create();
      this._spriteset = new Spriteset_Base();
      this.addChild(this._spriteset);
    }
    update() {
      super.update();
      $gameScreen.update();
    }
  }

  window.Scene_NrCustomScene = Scene_NrCustomScene;
})();
