//=============================================================================
// NrOptionCommandVisibility.js
//=============================================================================

/*:
 * @target MZ
 * @plugindesc オプション項目の初期値・表示制御 v1.0.0
 * @author NJ
 *
 * @param alwaysDash
 * @text 常時ダッシュの初期値
 * @type boolean
 * @default true
 *
 * @param commandRemember
 * @text コマンド記憶の初期値
 * @type boolean
 * @default true
 *
 * @param touchUI
 * @text タッチUIの初期値
 * @type boolean
 * @default true
 *
 * @param showAlwaysDash
 * @text 常時ダッシュを表示
 * @type boolean
 * @default true
 *
 * @param showCommandRemember
 * @text コマンド記憶を表示
 * @type boolean
 * @default true
 *
 * @param showTouchUI
 * @text タッチUIを表示
 * @type boolean
 * @default true
 *
 * @help
 * バージョン
 *   1.0.0 - 初回
 *
 * 利用規約：
 *  プラグイン作者に無断で使用、改変、再配布は不可です。
 */

(() => {
    const p = PluginManager.parameters("NrOptionCommandVisibility");

    ConfigManager.alwaysDash = p.alwaysDash === "true";
    ConfigManager.commandRemember = p.commandRemember === "true";
    ConfigManager.touchUI = p.touchUI === "true";

    const showAlwaysDash = p.showAlwaysDash === "true";
    const showCommandRemember = p.showCommandRemember === "true";
    const showTouchUI = p.showTouchUI === "true";

    const _Window_Options_makeCommandList = Window_Options.prototype.makeCommandList;
    Window_Options.prototype.makeCommandList = function() {
        _Window_Options_makeCommandList.call(this);
        this._list = this._list.filter(cmd => {
            if (cmd.symbol === "alwaysDash" && !showAlwaysDash) return false;
            if (cmd.symbol === "commandRemember" && !showCommandRemember) return false;
            if (cmd.symbol === "touchUI" && !showTouchUI) return false;
            return true;
        });
        this.addCommand("閉じる", "close", false);
    };

    const _Window_Options_drawItem = Window_Options.prototype.drawItem;
    Window_Options.prototype.drawItem = function(index) {
        const symbol = this.commandSymbol(index);
        if (symbol === "close") {
            const rect = this.itemRect(index);
            this.resetTextColor();
            this.changePaintOpacity(true);
            this.drawText(this.commandName(index), rect.x, rect.y, rect.width, "center");
        } else {
            _Window_Options_drawItem.call(this, index);
        }
    };

    const _Window_Options_processOk = Window_Options.prototype.processOk;
    Window_Options.prototype.processOk = function() {
        const index = this.index();
        const symbol = this.commandSymbol(index);
        if (symbol === "close") {
            SceneManager.pop();
        } else {
            _Window_Options_processOk.call(this);
        }
    };

    function removeTouchUIButton(scene) {
        if (scene._buttonTouchUI) {
            scene._buttonTouchUI.visible = false;
            scene.removeChild(scene._buttonTouchUI);
            scene._buttonTouchUI = null;
        }
    }

    function overrideTouchUIButton(sceneClass) {
        const _createButtons = sceneClass.prototype.createButtons;
        sceneClass.prototype.createButtons = function() {
            _createButtons.call(this);
            if (!showTouchUI) {
                removeTouchUIButton(this);
            }
        };
    }

    overrideTouchUIButton(Scene_Title);
    overrideTouchUIButton(Scene_Map);
    overrideTouchUIButton(Scene_MenuBase);
    overrideTouchUIButton(Scene_Options);

    const _Scene_Map_createMenuButton = Scene_Map.prototype.createMenuButton;
    Scene_Map.prototype.createMenuButton = function() {
        _Scene_Map_createMenuButton.call(this);
        if (!showTouchUI && this._menuButton) {
            this._menuButton.visible = false;
            this.removeChild(this._menuButton);
            this._menuButton = null;
        }
    };
})();
