//=============================================================================
// RemoveTitleCommands.js
//=============================================================================

/*:
 * @target MZ
 * @plugindesc タイトル画面の既定コマンド（ニューゲーム等）を全て削除します。
 * @author
 *
 * @help
 * タイトル画面のコマンド（ニューゲーム、コンティニュー、オプション）を非表示にします。
 * 独自のUIでタイトル画面を作りたい場合に使用します。
 *
 * プラグインパラメータやコマンドはありません。
 */

(() => {
    Scene_Title.prototype.createCommandWindow = function() {
        const rect = this.commandWindowRect();
        this._commandWindow = new Window_TitleCommand(rect);
        this._commandWindow.setHandler("newGame", function() {});
        this._commandWindow.setHandler("continue", function() {});
        this._commandWindow.setHandler("options", function() {});
        this.addWindow(this._commandWindow);
        this._commandWindow.hide();
        this._commandWindow.deactivate();
    };

    Window_TitleCommand.prototype.makeCommandList = function() {
    };
})();
