//=============================================================================
// SwitchMacroTrigger_MZ.js
//=============================================================================

/*:
 * @target MZ
 * @plugindesc スイッチ変更時にスクリプトを自動実行するプラグイン V1.1.0 MZ対応
 * @author NJ
 * 
 * @param WatchList
 * @type struct<WatchItem>[]
 * @desc 監視するスイッチと実行スクリプトのリスト
 * @default []
 * 
 * @help
 * 【使い方】
 * 1. プラグインパラメータに監視するスイッチとスクリプトを登録。
 * 2. スイッチがONになると、対応スクリプトが自動実行されます。
 * 3. モードに応じてOFFに戻すか、継続実行を制御できます。
 *
 * 【モード】
 * - AutoOff：実行後に自動的にOFFに戻す
 * - Continuous：ONの間、間隔を空けて繰り返し実行
 *
 * 【更新履歴】
 * v1.1.0 ウェイト制御追加
 * v1.0.0 初版
 *
 * 利用規約：
 *  プラグイン作者に無断で使用、改変、再配布は不可です。
 */

/*~struct~WatchItem:
 * @param switchId
 * @desc 監視するスイッチID（数値のみ）
 * @type number
 * @min 1
 *
 * @param script
 * @desc 実行するスクリプト（Note形式）
 * @type note
 * 
 * @param mode
 * @desc 実行モード：AutoOff（1回実行）／Continuous（繰り返し）
 * @type select
 * @option AutoOff
 * @option Continuous
 * @default AutoOff
 *
 * @param interval
 * @desc Continuous時の繰り返し間隔（フレーム単位）
 * @type number
 * @min 1
 * @default 1
 *
 * @param timing
 * @desc intervalの適用タイミング（Before：実行前／After：実行後）
 * @type select
 * @option Before
 * @option After
 * @default After
 */

(() => {
    const PLUGIN_NAME = "SwitchMacroTrigger_MZ";
    const parameters = PluginManager.parameters(PLUGIN_NAME);
    const watchList = JSON.parse(parameters['WatchList'] || '[]').map(item => JSON.parse(item));
    const _switchTimers = {};

    const updateSwitchTriggers = () => {
        for (const entry of watchList) {
            const switchId = Number(entry.switchId);
            const script = JSON.parse(entry.script || '""');
            const mode = entry.mode || "AutoOff";
            const interval = Number(entry.interval || 1);
            const timing = entry.timing || "After";

            if (!_switchTimers[switchId]) {
                _switchTimers[switchId] = { timer: 0, locked: false };
            }

            const state = _switchTimers[switchId];

            if (!$gameSwitches.value(switchId)) {
                state.timer = 0;
                state.locked = false;
                continue;
            }

            if (mode === "AutoOff") {
                try {
                    eval(script);
                } catch (e) {
                    console.error(`[${PLUGIN_NAME}] Switch ${switchId} Error:`, e.message);
                }
                $gameSwitches.setValue(switchId, false);
            } else if (mode === "Continuous") {
                if (timing === "Before") {
                    state.timer++;
                    if (state.timer >= interval) {
                        try {
                            eval(script);
                        } catch (e) {
                            console.error(`[${PLUGIN_NAME}] Switch ${switchId} Error:`, e.message);
                        }
                        state.timer = 0;
                    }
                } else {
                    if (!state.locked) {
                        try {
                            eval(script);
                        } catch (e) {
                            console.error(`[${PLUGIN_NAME}] Switch ${switchId} Error:`, e.message);
                        }
                        state.locked = true;
                        state.timer = 0;
                    } else {
                        state.timer++;
                        if (state.timer >= interval) {
                            state.locked = false;
                        }
                    }
                }
            }
        }
    };

    const _Scene_Map_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function () {
        _Scene_Map_update.call(this);
        updateSwitchTriggers();
    };
})();
