/*:
 * @target MZ
 * @plugindesc 変数をウィンドウで表示するプラグイン（文字表示修正版） 
 * @author WXY
 *
 * @param VariableId
 * @type variable
 * @text 表示する変数
 * @default 1
 *
 * @param VariableName
 * @type string
 * @text 変数名
 * @default 値
 *
 * @param X
 * @type number
 * @text X座標
 * @default 0
 *
 * @param Y
 * @type number
 * @text Y座標
 * @default 0
 *
 * @param Width
 * @type number
 * @text ウィンドウ幅
 * @default 240
 *
 * @param Suffix
 * @type string
 * @text 後ろの文字列
 * @default
 *
 * @help
 * マップ画面に指定した変数を表示するウィンドウを追加します。
 */

(() => {
    const pluginName = document.currentScript && document.currentScript.src
        ? document.currentScript.src.match(/([^\/]+)\.js$/)[1]
        : "VariableDisplay"; // フォールバック
    const parameters = PluginManager.parameters(pluginName);
    const variableId   = Number(parameters["VariableId"] || 1);
    const variableName = String(parameters["VariableName"] || "値");
    const posX         = Number(parameters["X"] || 0);
    const posY         = Number(parameters["Y"] || 0);
    const winWidth     = Number(parameters["Width"] || 240);
    const suffix       = String(parameters["Suffix"] || "");

    class Window_VariableDisplay extends Window_Base {
        constructor() {
            // 仮の高さでsuper呼び出し
            const rect = new Rectangle(posX, posY, winWidth, 100);
            super(rect);

            // 正しい高さにリサイズ
            this.move(posX, posY, winWidth, this.fittingHeight(1));

            // contents を必ず作成
            this.createContents();

            this._lastValue = null;
            this.refresh();
        }

        refresh() {
            // if (!this.contents) this.createContents();
            // this.contents.clear();

            // const value = $gameVariables.value(variableId);
            // const text = `${variableName}: ${value}${suffix}`;
            // this.drawText(text, 0, 0, this.contentsWidth(), "left");

            // this._lastValue = value;

            if (!this.contents) this.createContents();
            this.contents.clear();

            const value = $gameVariables.value(variableId);
            const leftText = variableName;                 // 左に表示する部分
            const rightText = `${value}${suffix}`;         // 右に表示する部分

            // 左詰め表示（変数名）
            this.drawText(leftText, 0, 0, this.contentsWidth(), "left");

            // 右詰め表示（値＋サフィックス）
            this.drawText(rightText, 0, 0, this.contentsWidth(), "right");

            this._lastValue = value;
        }

        update() {
            super.update();
            const value = $gameVariables.value(variableId);
            if (this._lastValue !== value) {
                this.refresh();
            }
        }
    }

    const _Scene_Map_createAllWindows = Scene_Map.prototype.createAllWindows;
    Scene_Map.prototype.createAllWindows = function() {
        _Scene_Map_createAllWindows.call(this);
        this._variableWindow = new Window_VariableDisplay();
        this.addWindow(this._variableWindow);
    };
})();
