/*:
 * @target MZ
 * @plugindesc 敵・プレイヤーのスキル使用時にスキルIDと同じ番号のスイッチをON、ターン終了・戦闘終了時にOFF
 * @help
 * 戦闘中に敵・プレイヤーが使ったスキルIDと同じ番号のスイッチをON。
 * ターン終了時・戦闘終了時にONにしたスイッチは自動でOFFに戻ります。
 */

(() => {
  // ONにしたスイッチの配列を取得（$gameTempが未定義でも安全）
  function getActiveSwitches() {
    if (!$gameTemp) return [];
    if (!$gameTemp.activeSkillSwitches) $gameTemp.activeSkillSwitches = [];
    return $gameTemp.activeSkillSwitches;
  }

  // 敵・プレイヤーのスキル使用時
  const _Game_Action_apply = Game_Action.prototype.apply;
  Game_Action.prototype.apply = function(target) {
    const item = this.item();
    if (item && DataManager.isSkill(item)) {
      const skillId = item.id;
      const subject = this.subject();

      if (skillId > 0 && $gameSwitches) {
        // スキル使用者が敵かプレイヤーか関係なくON
        $gameSwitches.setValue(skillId, true);

        // ONにしたスイッチを記録
        const switches = getActiveSwitches();
        if (!switches.includes(skillId)) switches.push(skillId);
        console.log(skillId+"ON");
        
      }
    }

    _Game_Action_apply.call(this, target);
  };

  // ターン終了時にONにしたスイッチをOFF
  const _BattleManager_endTurn = BattleManager.endTurn;
  BattleManager.endTurn = function() {
    _BattleManager_endTurn.call(this);

    const switches = getActiveSwitches();
    if (switches.length > 0 && $gameSwitches) {
      switches.forEach(id => $gameSwitches.setValue(id, false));
      switches.length = 0;
      console.log("OFF");
    }
  };

  // 戦闘終了時にもスイッチをOFF
  const _BattleManager_endBattle = BattleManager.endBattle;
  BattleManager.endBattle = function(result) {
    const switches = getActiveSwitches();
    if (switches.length > 0 && $gameSwitches) {
      switches.forEach(id => $gameSwitches.setValue(id, false));
      switches.length = 0;
      console.log("OFF");
    }

    _BattleManager_endBattle.call(this, result);
  };

})();
