/*:
 * @target MZ
 * @plugindesc [战斗立绘&技能插图] 在战斗中显示敌人立绘，以及技能插图播放功能（支持自定义位置、缩放、持续时间，并可设置默认值）。
 * @author 你的名字
 *
 * @param DefaultEnemyX
 * @text 敌人立绘默认X位置
 * @type number
 * @default 600
 *
 * @param DefaultEnemyY
 * @text 敌人立绘默认Y位置
 * @type number
 * @default 100
 *
 * @param DefaultEnemyScale
 * @text 敌人立绘默认缩放
 * @type number
 * @decimals 2
 * @default 1.0
 *
 * @param DefaultSkillX
 * @text 技能插图默认X位置
 * @type number
 * @default 300
 *
 * @param DefaultSkillY
 * @text 技能插图默认Y位置
 * @type number
 * @default 200
 *
 * @param DefaultSkillDuration
 * @text 技能插图默认持续帧数
 * @type number
 * @default 60
 *
 * @help
 * 使用方法：
 * 
 * 1. 敌人立绘：
 *    - 在敌人的【备注】中添加：
 *      <EnemyPicture: 文件名, X, Y, Scale>
 *      例：<EnemyPicture: slime, 600, 100, 1.2>
 *      文件名不带扩展名，图片放在 img/pictures/。
 *      如果没有设置备注，则使用插件参数里的默认值。
 *
 * 2. 技能插图：
 *    - 在技能的【备注】中添加：
 *      <SkillPicture: 文件名, X, Y, Duration>
 *      例：<SkillPicture: fire, 300, 200, 60>
 *      文件名不带扩展名，图片放在 img/pictures/。
 *      如果没有设置备注，则使用插件参数里的默认值。
 *
 * 3. 默认值可在插件管理器中修改。
 */

(() => {
    const params = PluginManager.parameters(document.currentScript.src.match(/([^\/]+)\.js$/)[1]);

    const DefaultEnemyX = Number(params["DefaultEnemyX"] || 600);
    const DefaultEnemyY = Number(params["DefaultEnemyY"] || 100);
    const DefaultEnemyScale = Number(params["DefaultEnemyScale"] || 1.0);

    const DefaultSkillX = Number(params["DefaultSkillX"] || 300);
    const DefaultSkillY = Number(params["DefaultSkillY"] || 200);
    const DefaultSkillDuration = Number(params["DefaultSkillDuration"] || 60);

    // 读取敌人立绘
    const _Spriteset_Battle_createEnemies = Spriteset_Battle.prototype.createEnemies;
    Spriteset_Battle.prototype.createEnemies = function () {
        _Spriteset_Battle_createEnemies.call(this);
        this.createEnemyPictures();
    };

    Spriteset_Battle.prototype.createEnemyPictures = function () {
        this._enemyPictures = [];
        $gameTroop.members().forEach(enemy => {
            const note = enemy.enemy().note;
            let filename = null, x = DefaultEnemyX, y = DefaultEnemyY, scale = DefaultEnemyScale;

            const match = note.match(/<EnemyPicture:\s*(.+?),\s*(\d+),\s*(\d+),\s*([\d.]+)>/i);
            if (match) {
                filename = match[1].trim();
                x = Number(match[2]);
                y = Number(match[3]);
                scale = Number(match[4]);
            } else {
                // 如果没有备注，尝试读取敌人ID作为文件名
                filename = enemy.enemy().name; // 你也可以改成自动绑定文件
            }

            if (filename) {
                const sprite = new Sprite(ImageManager.loadPicture(filename));
                sprite.x = x;
                sprite.y = y;
                sprite.scale.x = scale;
                sprite.scale.y = scale;
                this._battleField.addChild(sprite);
                this._enemyPictures.push(sprite);
            }
        });
    };

    // 技能插图
    const _Scene_Battle_useItem = Scene_Battle.prototype.useItem;
    Scene_Battle.prototype.useItem = function () {
        _Scene_Battle_useItem.call(this);
        const item = this._subject.currentAction().item();
        let filename = null, x = DefaultSkillX, y = DefaultSkillY, duration = DefaultSkillDuration;

        const match = item.note.match(/<SkillPicture:\s*(.+?),\s*(\d+),\s*(\d+),\s*(\d+)>/i);
        if (match) {
            filename = match[1].trim();
            x = Number(match[2]);
            y = Number(match[3]);
            duration = Number(match[4]);
        }

        if (filename) {
            this.showSkillPicture(filename, x, y, duration);
        }
    };

    Scene_Battle.prototype.showSkillPicture = function (filename, x, y, duration) {
        const sprite = new Sprite(ImageManager.loadPicture(filename));
        sprite.x = x;
        sprite.y = y;
        this.addChild(sprite);

        let count = duration;
        const updateFunc = () => {
            count--;
            if (count <= 0) {
                this.removeChild(sprite);
                sprite.bitmap.destroy();
                Graphics.app.ticker.remove(updateFunc);
            }
        };
        Graphics.app.ticker.add(updateFunc);
    };
})();
