/*:
* @target MZ
* @author 小怪兽奇奇侠 extends Erebos
* @plugindesc 可以让你自定义对话框、姓名框的背景以及位置，建议对话框、姓名框大小和背景图片保持一致。
* @url http://rpg.blue/
*
* @param 对话框图像名称
* @desc 将你的对话框图像放置于system文件夹下，然后在这里填写图片名称。（无需后缀）
* 预设值 log
* @default log
*
* @param 对话框宽度
* @desc 重定义对话框宽度
* 预设值 800
* @default 800
*
* @param 对话框高度
* @desc 重定义对话框宽度
* 预设值 124
* @default 124
*
* @param 对话框x偏移量
* @desc 默认是居中效果。
* 预设值 0
* @default 0
*
*
*
* @param 对话框背景图片的X
* @desc 对话框背景图片X偏移量。
* 预设值 0
* @default 0
*
* @param 对话框背景图片的Y
* @desc 对话框背景图片Y偏移量（设计中可以写为负值）。
* 预设值 0
* @default 0
*
* @param 姓名图像名称
* @desc 将你的对话框图像放置于system文件夹下，然后在这里填写图片名称。（无需后缀）
* 预设值 name
* @default name
*
* @param 姓名框图片的X
* @desc 设置姓名框图片的X。
* 预设值 0
* @default 0
*
* @param 姓名框图片的Y
* @desc 设置姓名框图片的Y。
* 预设值 0
* @default 0
*
* @param 脸图x偏移量
* @desc 脸图相对于原位置的x偏移量。
* 预设值 0
* @default 0
*
* @param 脸图y偏移量
* @desc 脸图相对于原位置的y偏移量。
* 预设值 0
* @default 0
*
*
* @param 姓名框图片宽度
* @desc 填写你姓名框图片宽度。
* 预设值 200
* @default 200
*
* @param 姓名框图片高度
* @desc 填写姓名框图片宽度。
* 预设值 52
* @default 52
*
* @param 姓名框x
* @desc 姓名框的x偏移量。
* 预设值 0
* @default 0
*
* @param 姓名框y
* @desc 姓名框的y偏移量。
* 预设值 0
* @default 0
*/
(() => {
    // ---------------------------------------------------------------------------
    //                信息框背景
    // ---------------------------------------------------------------------------
	var SIAKOMobi = PluginManager.parameters('MessageBackround');
    const messageBackground = Scene_Message.prototype.createMessageWindow;
    Scene_Message.prototype.createMessageWindow = function() {
        messageBackground.call(this);
        this.createMessageBg();
    };
	
	//据我发现这里可以改变信息框宽度
	Scene_Message.prototype.messageWindowRect = function() {
    const ww = Number(SIAKOMobi['对话框宽度']||800);
    const wh = this.calcWindowHeight(4, false) + 8;
    const wx = (Graphics.boxWidth - ww) / 2;
    const wy = 0;
    return new Rectangle(wx+Number(SIAKOMobi['对话框x偏移量']||0), wy, ww, wh);
};

    Scene_Message.prototype.createMessageBg = function() {
		//this._messageWindow.width = 819;
		//this._messageWindow.height = 124;
        this._msgBg = new Sprite(ImageManager.loadSystem(SIAKOMobi['对话框图像名称']));
        this._msgBg.x = Number(SIAKOMobi['对话框背景图片的X']||0);
        this._msgBg.y = Number(SIAKOMobi['对话框背景图片的Y']||0);
        this._msgBg.scale.x = this._messageWindow.width / Number(SIAKOMobi['对话框宽度']||800);
        this._msgBg.scale.y = this._messageWindow.height / Number(SIAKOMobi['对话框高度']||124);
        this._messageWindow.addChildToBack(this._msgBg);
    };

    Window_Message.prototype.setBackgroundType = function() {
        this.opacity = 0;
        this.opacity = 0;
    };

    // ---------------------------------------------------------------------------
    //                名字框背景
    // ---------------------------------------------------------------------------
    const nameBox = Scene_Message.prototype.createNameBoxWindow;
    Scene_Message.prototype.createNameBoxWindow = function() {
        nameBox.call(this);
        this.createNameBg();
    };

    Scene_Message.prototype.createNameBg = function() {
        this._nameBg = new Sprite(ImageManager.loadSystem(SIAKOMobi['姓名图像名称']));
        this._nameBg.x = Number(SIAKOMobi['姓名框图片的X']||0);
        this._nameBg.y = Number(SIAKOMobi['姓名框图片的Y']||0);
        this._nameBoxWindow.addChildToBack(this._nameBg);
    };

    Window_NameBox.prototype.setBackgroundType = function() {
        this.opacity = 0;
    };
	//脸图位置重写
	Window_Message.prototype.drawMessageFace = function() {
    const faceName = $gameMessage.faceName();
    const faceIndex = $gameMessage.faceIndex();
    const rtl = $gameMessage.isRTL();
    const width = ImageManager.faceWidth;
    const height = this.innerHeight;
    const x = rtl ? this.innerWidth - width - 4 : 4;
    this.drawFace(faceName, faceIndex, x+Number(SIAKOMobi['脸图x偏移量']||0), Number(SIAKOMobi['脸图y偏移量']||0), width, height);
};

//-----------------------
//姓名框位置
//--------------------------------
Window_NameBox.prototype.updatePlacement = function() {
    this.width = this.windowWidth();
    this.height = this.windowHeight();
    const messageWindow = this._messageWindow;
    if ($gameMessage.isRTL()) {
        this.x = messageWindow.x + messageWindow.width - this.width+Number(SIAKOMobi['姓名框x']||0);
    } else {
        this.x = messageWindow.x+Number(SIAKOMobi['姓名框x']||0);
    }
    if (messageWindow.y > 0) {
        this.y = messageWindow.y - this.height+Number(SIAKOMobi['姓名框y']||0);
    } else {
        this.y = messageWindow.y + messageWindow.height+Number(SIAKOMobi['姓名框y']||0);
    }
};

    // ---------------------------------------------------------------------------
    //                刷新
    // ---------------------------------------------------------------------------
    const update = Scene_Message.prototype.update;
    Scene_Message.prototype.update = function() {
        update.call(this);
        this._nameBg.scale.x = this._nameBoxWindow.windowWidth() / Number(SIAKOMobi['姓名框图片宽度']||200);
        this._nameBg.scale.y = this._nameBoxWindow.windowHeight() / Number(SIAKOMobi['姓名框图片高度']||52);
    };

})();