/*:
 * @target MZ
 * @plugindesc Modify default face graphic size in RPG Maker MZ.
 * @help This plugin allows you to change the default face graphic size.
 *
 * @param faceWidth
 * @text Face Width
 * @type number
 * @default 144
 * @desc The new width of the face graphic.
 *
 * @param faceHeight
 * @text Face Height
 * @type number
 * @default 144
 * @desc The new height of the face graphic.
 */

(() => {
    const parameters = PluginManager.parameters('ModifyFaceSize');
    const faceWidth = Number(parameters['faceWidth'] || 144);
    const faceHeight = Number(parameters['faceHeight'] || 144);

    ImageManager.faceWidth = faceWidth;
    ImageManager.faceHeight = faceHeight;

    Window_Base.prototype.drawFace = function(faceName, faceIndex, x, y, width, height) {
        width = width || faceWidth;
        height = height || faceHeight;
        const bitmap = ImageManager.loadFace(faceName);
        const pw = faceWidth;
        const ph = faceHeight;
        const sw = Math.min(width, pw);
        const sh = Math.min(height, ph);
        const dx = Math.floor(x + Math.max(width - pw, 0) / 2);
        const dy = Math.floor(y + Math.max(height - ph, 0) / 2);
        const sx = (faceIndex % 4) * pw + (pw - sw) / 2;
        const sy = Math.floor(faceIndex / 4) * ph + (ph - sh) / 2;
        this.contents.blt(bitmap, sx, sy, sw, sh, dx, dy);
    };
})();
