﻿default attack_frame = "game_02_pet02.png"

transform zoom_attack(speed=0.1, scale=1.1):
    linear speed zoom scale
    linear speed zoom 1.0
    repeat 2

image player attack = At(
    DynamicDisplayable(get_attack_frame),
    zoom_attack(zoom_speed, zoom_scale)
)


init python:
    import random
    zoom_speed = 0.1
    zoom_scale = 1.1
    renpy.music.register_channel("sfx", mixer="sfx", loop=False)
    renpy.music.register_channel("sfx1", mixer="sfx", loop=False)

    flg = -1
    hit_counter = 0

    hover_x = 300
    hover_y = 75
    hover_w = 250
    hover_h = 200

    mousearea_w = 50
    mousearea_h = 50

    areas = [
        [hover_x+int(hover_w*1/6), hover_y-mousearea_h, int(hover_w*2/3), mousearea_h],   # 上
        [hover_x-mousearea_w, hover_y+int(hover_h*1/6), mousearea_w, int(hover_h*2/3)], # 左
        [hover_x+int(hover_w*1/6), hover_y+hover_h, int(hover_w*2/3),  mousearea_h],  # 下
        [hover_x+hover_w, hover_y+int(hover_h*1/6), mousearea_w, int(hover_h*2/3)], # 右
        [hover_x-mousearea_w, hover_y-mousearea_h, mousearea_w, mousearea_h],   # 左上
        [hover_x+hover_w, hover_y-mousearea_h, mousearea_w, mousearea_h],   # 右上
        [hover_x-mousearea_w, hover_y+hover_h, mousearea_w, mousearea_h],   # 左下
        [hover_x+hover_w, hover_y+hover_h, mousearea_w, mousearea_h],   # 右下
    ]

    image_list = ["game_02_pet04.png", "game_02_pet05.png", "game_02_pet06.png", "game_02_pet07.png", "game_02_pet08.png"]

    def select_area(area_id=2):
        """mousearea が選択されたときに flg を更新"""
        global flg
        flg = area_id

    def apply_area_effect_and_reset():
        global hit_counter
        """
        ホバー解除時などに呼び出され、選択結果を判定。
        正解( flg != -1 )なら attack アニメ。
        """
        global flg
        damage_se = ["damage01.mp3", "damage02.mp3", "damage03.mp3", "damage04.mp3", "damage05.mp3", "damage06.mp3", "damage07.mp3"]
        if flg == -1:
            renpy.show("player normal")
        else:
            # 攻撃音
            renpy.sound.play(damage_se[random.randint(0, len(damage_se)-1)], channel="sfx1")
            renpy.sound.play("punchi.mp3", channel="sfx")
            hit_counter += 1
            store.attack_frame = image_list[flg%5]
            # 攻撃アニメ画像を表示 (毎回再生)
            renpy.show("player attack")
            # renpy.notify(hit_counter)
            if hit_counter > 25:
                renpy.hide("player attack")
                renpy.hide_screen("test_screen")
                renpy.jump("after_lose")
            # 選択リセット
            flg = -1

    def get_attack_frame(st, at):
        # 攻撃中のアニメーション：0〜0.5秒はattack画像
        if st < 0.25:
            return Image(attack_frame), 0.0  # 0秒後に再評価なし（=固定）
        # 0.5秒以降は表示したい別の画像
        else:
            ret_img = ["game_02_pet01.png", "game_02_pet02.png", "game_02_pet03.png"]
            return ret_img[random.randint(0, len(ret_img)-1)], 0.35

screen test_screen():
    # 背景となる現在の画像を表示
    # add current_img

    use hover_click_area(hover_x, hover_y, hover_w, hover_h)

    use mouse_areas(areas[0][0], areas[0][1], areas[0][2], areas[0][3], select_area, 4)
    use mouse_areas(areas[1][0], areas[1][1], areas[1][2], areas[1][3], select_area, 1)
    use mouse_areas(areas[2][0], areas[2][1], areas[2][2], areas[2][3], select_area, 2)
    use mouse_areas(areas[3][0], areas[3][1], areas[3][2], areas[3][3], select_area, 3)
    use mouse_areas(areas[4][0], areas[4][1], areas[4][2], areas[4][3], select_area, 1)
    use mouse_areas(areas[5][0], areas[5][1], areas[5][2], areas[5][3], select_area, 4)
    use mouse_areas(areas[6][0], areas[6][1], areas[6][2], areas[6][3], select_area, 1)
    use mouse_areas(areas[7][0], areas[7][1], areas[7][2], areas[7][3], select_area, 2)

screen hover_click_area(x, y, w, h):
    # 透明なクリック/ホバー領域（100,100 に 400x300）
    button:
        area (x, y, w, h)
        # background None
        # background "#00ff0080"
        hover_background None
        focus_mask None

        hovered Function(apply_area_effect_and_reset)     # ホバー時 → img1
        # unhovered Function(apply_area_effect_and_reset)   # ホバー解除 → img2
        action [
            Function(select_area, 100), 
            Function(apply_area_effect_and_reset) 
        ]   # クリック時の画面変化

screen mouse_areas(x, y, w, h, func, arg1=1):
    # # デバッグ表示用（色付き矩形）
    # frame:
    #     xpos x
    #     ypos y
    #     xsize w
    #     ysize h
    #     background "#ff000080"    # 緑半透明
    mousearea:
        area (x, y, w, h)
        hovered Function(func, arg1)

label start:
    # ミニゲーム
    # play music "audio/mizuno_dokutsu.mp3" fadeout 0.5 fadein 0.5
    scene bg game_01
    # show player angry with dissolve
    # shigemori_ayu "呼ばれた理由は分かっているな。"
    # show player2 thiara01 with dissolve
    # hunahara_thiara "はーい。先生も私たちのペットになりたいってことですよね～。"
    # hunahara_thiara "スクールポリスのオバサン達ってぇ、ペット志願者ばかりなんですから、またかぁｗって思いましたぁ"
    # shigemori_ayu "糞餓鬼が。"
    # shigemori_ayu "船原沙羅佐！お前が黒幕で、この学校でお前らの存在を隠蔽しているクソ野郎の調べもついてる。"
    # shigemori_ayu "あとは、警察に任せて方の裁きを受けさせるだけだ。"
    # hunahara_thiara "さら姉？こいつどうする？"
    # hunahara_sarasa "ティアラちゃん、この玩具欲しい？"
    # hunahara_thiara "いらなーいｗｗｗ"
    # hunahara_sarasa "それじゃぁ、バレたら失職しちゃう高根沢センセにプレゼントしようか。"
    # shigemori_ayu "・・・"
    # shigemori_ayu "言いたいことはそれだけか？"
    # shigemori_ayu "お前ら、躾というものをされて来なかったんだろうな。"
    # hunahara_thiara "はい～。みんなティアラの可愛さにメロメロですからぁ"
    # shigemori_ayu "・・・少し、組手をしないか？"
    # hunahara_thiara "リンチですかぁ？"
    # shigemori_ayu "いや、お前ら、格闘技に自信があるんだろ？"
    # shigemori_ayu "その分野で思い知らせて、世の中が思う通りにならないということを教えてやるよ。"
    # hunahara_thiara "うふ。良いですよぉ～。さら姉は下がっててください。私が相手してあげます♪"
    # hide player2 thiara01 with dissolve
    # shigemori_ayu "子供だからと手加減してもらえると思うなよ？少しは腐った性根を叩きのめしてやる。"
    # show player2 thiara02 with dissolve
    # hunahara_thiara "好き放題いいますねぇ♪オバサンが負けたらぁ、どうなるか予想がつかないんですかぁ？"
    # shigemori_ayu "・・・？"
    # shigemori_ayu "なんだ？そのグローブは・・・"
    # hunahara_thiara "なにってぇハンデですよぉ。ハ・ン・デ"
    # hunahara_thiara "新しい玩具なんだもの。壊さないようにしないとｗ"
    # show player angry2 with dissolve
    # shigemori_ayu "な・・・舐めるなっ！"
    # hide player2 thiara02 with dissolve
    play music "audio/documentary01.mp3" fadeout 0.5 fadein 0.5
    show player game_setsumei with dissolve
    "ミニゲームの遊び方"
    "上下左右またはクリックで分からせよう！"
    show player normal
    call screen test_screen

    return

label after_lose:
    scene bg game_01
    hunahara_thiara "よ・わ・す・ぎぃｗｗｗ"
    # shigemori_ayu "あ、、、あぐっ。"
    # hunahara_sarasa "ひとまず、禊してもらおっか。ティアラちゃん。準備は良い？"
    # hunahara_thiara "はぁい。"
    # hunahara_sarasa "動くと危ないですよｗ"
    # shigemori_ayu "ひっ"
    # play music "audio/zuttoyuka_wo_miteru.mp3" fadeout 0.5 fadein 0.5
    # show event teimou01 with dissolve
    # hunahara_thiara "さら姉ぇ～？重くなぁい？"
    # hunahara_sarasa "重ぉい。だから暴れないでねｗ"
    # show event teimou02 with dissolve
    # hunahara_thiara "自信満々だったオバサンには来週もう一回再戦してあげる。"
    # hunahara_thiara "ただ、負け犬の罰ゲームは受けてもらうね。"
    # show event teimou03 with dissolve
    # shigemori_ayu "ひっ"
    # hunahara_sarasa "動くと本当に危ないですよぉｗ。安物のカミソリですしぃ"
    # shigemori_ayu "や・・・やめっ"
    # show event teimou04 with dissolve
    # play sound "audio/sorioto.mp3"
    # hunahara_thiara "うふふ。"
    # show event teimou05 with dissolve
    # play sound "audio/sorioto.mp3"
    # shigemori_ayu "あ、あ・・・あぁ"
    # show event teimou06 with dissolve
    # hunahara_thiara "本当だったらぁパイパンにしてあげるんところなんだけどぉ"
    # show player2 thiara03 with dissolve
    # hunahara_thiara "再戦予約として片方だけ剃ってあげましたぁｗｗｗ"
    # hunahara_thiara "あは。きったなーいｗ"
    # hunahara_thiara "せーんせｗ。来週再戦しましょうね。今度はグローブなしで戦ってあげますからぁ"
    # hide player2 thiara03 with dissolve
    # shigemori_ayu "・・・・・・"
    # hunahara_sarasa "オバサーン、ティアラちゃんが喋ってるのに返事しなきゃ失礼じゃない？"
    # shigemori_ayu "ぜ、絶対・・・泣き寝入りは・・・しっっうぐっっ"
    # play sound "audio/punchi.mp3"
    # with hpunch
    # hunahara_sarasa "頭悪いね。このオバサン。"
    # hunahara_sarasa "ティアラちゃん。壁に飾ってあるトロフィー持ってきてｗ"
    # hunahara_sarasa "表沙汰したらスカトロAVデビューさせてあげるからｗ"
    # shigemori_ayu "なっ！？"
    # hunahara_sarasa "何驚いてるのｗ。調べたんならペット全員、脱糞記念写真撮ってあげてるの知ってるでしょｗ？"
    # with vpunch
    # shigemori_ayu "うぎっっ"
    # hunahara_sarasa "うふふ。浣腸プレイは高根沢センセと楽しんでねｗ"
    # shigemori_ayu "か・・・体が動かっ・・・ふぐっ"
    # play sound "audio/geri.mp3"
    # hunahara_sarasa "即効性が凄いでしょ？体中の老廃物を掻き集めるツボ。"
    # hunahara_sarasa "そして、オバサンを過去の栄光のトロフィーに跨らせてぇ～"
    # hunahara_sarasa "ティアラちゃん♪防臭マスクした方が良いよｗ"
    # hunahara_thiara "はぁい♪"
    # play sound "audio/geri.mp3"
    # show event unko01 with dissolve
    # hunahara_sarasa "それじゃ、いつでも出していいからねぇｗｗｗ。"
    # shigemori_ayu "こ・・・こんな・・・"
    # hunahara_thiara "我慢しても無駄よぉｗ。今まで娘の耐えた最長の時間は52秒だしｗ"
    # play sound "audio/geri.mp3"
    # show event unko02 with dissolve
    # hunahara_thiara "オバサンは何秒耐えられるかなぁｗｗｗ"
    # shigemori_ayu "わ・・・私の・・・トロ・・・フィに・・・できるわけ・・・"
    # hunahara_thiara "嫌だったらいつでもトイレ行っていいですよぉｗ。動けたらですけどぉ♪"
    # shigemori_ayu "うご・・・けな・・・"
    # hunahara_thiara "そんなに力を入れて良いんですかぁｗ"
    # play sound "audio/geri.mp3"
    # show event unko03 with dissolve
    # shigemori_ayu "はぐっっっ！"
    # shigemori_ayu "も・・・・だめ・・・・"
    # show player2 thiara04 with dissolve
    # hunahara_thiara "それじゃぁ撮影しますねぇ"
    # hunahara_thiara "はい★チーズ★"
    # play sound "audio/unko.mp3"
    # shigemori_ayu "いやああああああああああああああああああああああああああ"
    # play sound "audio/Camera1.mp3"
    # hunahara_thiara "あーあｗ"
    # hunahara_sarasa "何秒耐えられた？"
    # hunahara_thiara "18秒ｗｗｗ"
    # hunahara_sarasa "あははは。根性って掛け軸貼ってるのにダッサーイｗ"
    # shigemori_ayu "う・・・うぐ・・・"
    # hunahara_thiara "せーんせｗ。再戦バックレたら、この映像と他のペットちゃん達の映像インターネットに流すからねぇ"
    # hide player2 thiara04 with dissolve
    # hunahara_thiara "もっと練習して、少しは楽しませてねｗ"
    # hunahara_thiara "それじゃ、私たち帰るけどぉ、高根沢センセに連絡しておくね。"
    # show event unko02 with dissolve
    # shigemori_ayu "・・・え・・・？"
    # hunahara_sarasa "だってぇ～動けないでしょｗ"
    # hunahara_sarasa "ツボの効果が切れるまで後2時間くらいかかるからさ。待ってるのもメンドイしｗ"
    # hunahara_sarasa "高根沢センセに引き継いでおくから安心してｗ"
    # shigemori_ayu "そ・・・そんな・・・"
    # hunahara_sarasa "あははははは。じゃねぇ♪"
    # hunahara_thiara "休日高根沢センセと遊んでたからって理由で、学校休んじゃ駄目だよぉ。"
    # hunahara_thiara "生徒指導(笑)の仕事があるんだからｗ"
    # shigemori_ayu "ま・・・待っ・・・"
    # hunahara_thiara "やーだ★"
    # hunahara_sarasa "ばいばーいｗ"
    scene black with fade
    "- 導入・エンディング・素材プレゼントは製品版をご購入くださいm(_ _)m -"
    return

image bg game_01 = "game_01_bg.png"
image bg game_01 = "event001_001.png"
image player normal = "game_02_pet01.png"
image player angry = "event13.png"
image player angry2 = "event14.png"
image player game_setsumei = "event132.png"
image event teimou01 = "event002_001.png"
image event teimou02 = "event002_002.png"
image event teimou03 = "event002_003.png"
image event teimou04 = "event002_004.png"
image event teimou05 = "event002_005.png"
image event teimou06 = "event002_006.png"
image event unko01 = "event003_002.png"
image event unko02 = "event003_003.png"
image event unko03 = "event003_004.png"
image player2 thiara01 = "game_thiara01.png"
image player2 thiara02 = "game_thiara02.png"
image player2 thiara03 = "game_thiara03.png"
image player2 thiara04 = "game_thiara04.png"

define hunahara_sarasa = Character("船原沙羅佐", who_color="#BF1E56", what_color="#D45D87")
define hunahara_thiara = Character("船原ティアラ", who_color="#ff8fb6", what_color="#f1a9c3")
define shigemori_ayu = Character("重盛歩", who_color="#3261AB", what_color="#6A8CC7")
