/*:
 * @target MZ
 * @plugindesc ゲームパッドサポート
 * @author MUMAMOMEMU
 * @url https://star-write-dream.com/
 * @help SunD_Input(ver1.0.1)
 * 
 * --------------------------
 * ■利用規約
 *
 * Copyright (c) 2025 sun_dandy
 * https://star-write-dream.com/
 *
 * 以下に定める条件に従い、本プラグインファイル（以下「ソフトウェア」）の
 * 購入者に対し、ソフトウェアを変更し、
 * 購入者の制作する作品（以下、制作物）に組み込むことを許可します。
 * 制作物の内容および公開形式に制約はありません。
 *
 * ソフトウェア単体で掲載、頒布、共有することはできません。
 * 上記の著作権表示および本許諾表示は変更できず、削除もできません。
 * 別途、制作物の重要な箇所にソフトウェアの著作権表示をする必要はありません。
 *
 * ソフトウェアは「現状のまま」で、明示であるか暗黙であるかを問わず、
 * 何らの保証もなく提供されます。ここでいう保証とは、商品性、
 * 特定の目的への適合性、および権利非侵害についての保証も含みますが、
 * それに限定されるものではありません。作者または著作権者は、契約行為、
 * 不法行為、またはそれ以外であろうと、ソフトウェアに起因または関連し、
 * あるいはソフトウェアの使用またはその他の扱いによって生じる一切の請求、
 * 損害、その他の義務について何らの責任も負わないものとします。
 * --------------------------
 * 
 * @param testMode
 * @type boolean
 * @text テストモード
 * @desc ON:マップ画面にプラグインの情報が表示されます。
 * @default false
 * 
 * @param ignoreConfig
 * @type boolean
 * @text 【テスト】キーコンフィグデータを無視する
 * @desc ON:保存されているキーコンフィグデータを無視します。
 * @default true
 * 
 * @param buttonMaster
 * @type struct<ButtonData>[]
 * @text ボタンマスタ
 * @desc ボタンマスタを定義します。
 * @default ["{\"name\":\"cross\",\"buttonNo\":\"0\",\"keyboard\":\"KeyZ\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"決定\",\"requiredFunc\":\"true\",\"orderNo\":\"0\",\"ignoreSetKeys\":\"ArrowUp,ArrowDown,ArrowLeft,ArrowRight\",\"ignoreSetPadButtons\":\"12,13,14,15,16,100,101,102,103\"}","{\"name\":\"circle\",\"buttonNo\":\"1\",\"keyboard\":\"KeyC\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"キャンセル\",\"requiredFunc\":\"true\",\"orderNo\":\"0\",\"ignoreSetKeys\":\"ArrowUp,ArrowDown,ArrowLeft,ArrowRight\",\"ignoreSetPadButtons\":\"12,13,14,15,16,100,101,102,103\"}","{\"name\":\"squere\",\"buttonNo\":\"2\",\"keyboard\":\"ShiftLeft\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"ダッシュ\",\"requiredFunc\":\"true\",\"orderNo\":\"0\",\"ignoreSetKeys\":\"ArrowUp,ArrowDown,ArrowLeft,ArrowRight\",\"ignoreSetPadButtons\":\"12,13,14,15,16,100,101,102,103\"}","{\"name\":\"triangle\",\"buttonNo\":\"3\",\"keyboard\":\"KeyX\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"メニュー\",\"requiredFunc\":\"true\",\"orderNo\":\"0\",\"ignoreSetKeys\":\"ArrowUp,ArrowDown,ArrowLeft,ArrowRight\",\"ignoreSetPadButtons\":\"12,13,14,15,16,100,101,102,103\"}","{\"name\":\"l1\",\"buttonNo\":\"4\",\"keyboard\":\"PageUp\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"ページ戻し\",\"requiredFunc\":\"true\",\"orderNo\":\"0\",\"ignoreSetKeys\":\"ArrowUp,ArrowDown,ArrowLeft,ArrowRight\",\"ignoreSetPadButtons\":\"12,13,14,15,16,100,101,102,103\"}","{\"name\":\"r1\",\"buttonNo\":\"5\",\"keyboard\":\"PageDown\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"ページ送り\",\"requiredFunc\":\"true\",\"orderNo\":\"0\",\"ignoreSetKeys\":\"ArrowUp,ArrowDown,ArrowLeft,ArrowRight\",\"ignoreSetPadButtons\":\"12,13,14,15,16,100,101,102,103\"}","{\"name\":\"l2\",\"buttonNo\":\"6\",\"keyboard\":\"\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"false\",\"orderNo\":\"0\",\"ignoreSetKeys\":\"ArrowUp,ArrowDown,ArrowLeft,ArrowRight\",\"ignoreSetPadButtons\":\"12,13,14,15,16,100,101,102,103\"}","{\"name\":\"r2\",\"buttonNo\":\"7\",\"keyboard\":\"\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"false\",\"orderNo\":\"0\",\"ignoreSetKeys\":\"ArrowUp,ArrowDown,ArrowLeft,ArrowRight\",\"ignoreSetPadButtons\":\"12,13,14,15,16,100,101,102,103\"}","{\"name\":\"share\",\"buttonNo\":\"8\",\"keyboard\":\"\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"false\",\"orderNo\":\"0\",\"ignoreSetKeys\":\"ArrowUp,ArrowDown,ArrowLeft,ArrowRight\",\"ignoreSetPadButtons\":\"12,13,14,15,16,100,101,102,103\"}","{\"name\":\"options\",\"buttonNo\":\"9\",\"keyboard\":\"\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"false\",\"orderNo\":\"0\",\"ignoreSetKeys\":\"ArrowUp,ArrowDown,ArrowLeft,ArrowRight\",\"ignoreSetPadButtons\":\"12,13,14,15,16,100,101,102,103\"}","{\"name\":\"l3\",\"buttonNo\":\"10\",\"keyboard\":\"\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"false\",\"orderNo\":\"0\",\"ignoreSetKeys\":\"ArrowUp,ArrowDown,ArrowLeft,ArrowRight\",\"ignoreSetPadButtons\":\"12,13,14,15,16,100,101,102,103\"}","{\"name\":\"r3\",\"buttonNo\":\"11\",\"keyboard\":\"\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"false\",\"orderNo\":\"0\",\"ignoreSetKeys\":\"ArrowUp,ArrowDown,ArrowLeft,ArrowRight\",\"ignoreSetPadButtons\":\"12,13,14,15,16,100,101,102,103\"}","{\"name\":\"up\",\"buttonNo\":\"12\",\"keyboard\":\"\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"false\",\"orderNo\":\"0\",\"ignoreSetKeys\":\"\",\"ignoreSetPadButtons\":\"16\"}","{\"name\":\"down\",\"buttonNo\":\"13\",\"keyboard\":\"\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"false\",\"orderNo\":\"0\",\"ignoreSetKeys\":\"\",\"ignoreSetPadButtons\":\"16\"}","{\"name\":\"left\",\"buttonNo\":\"14\",\"keyboard\":\"\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"false\",\"orderNo\":\"0\",\"ignoreSetKeys\":\"\",\"ignoreSetPadButtons\":\"16\"}","{\"name\":\"right\",\"buttonNo\":\"15\",\"keyboard\":\"\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"false\",\"orderNo\":\"0\",\"ignoreSetKeys\":\"\",\"ignoreSetPadButtons\":\"16\"}","{\"name\":\"home\",\"buttonNo\":\"16\",\"keyboard\":\"\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"false\",\"orderNo\":\"0\",\"ignoreSetKeys\":\"ArrowUp,ArrowDown,ArrowLeft,ArrowRight\",\"ignoreSetPadButtons\":\"12,13,14,15,16,100,101,102,103\"}","{\"name\":\"lsup\",\"buttonNo\":\"100\",\"keyboard\":\"ArrowUp\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"true\",\"orderNo\":\"0\",\"ignoreSetKeys\":\"ArrowUp,ArrowDown,ArrowLeft,ArrowRight\",\"ignoreSetPadButtons\":\"12,13,14,15,16,100,101,102,103\"}","{\"name\":\"lsdown\",\"buttonNo\":\"101\",\"keyboard\":\"ArrowDown\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"true\",\"orderNo\":\"0\",\"ignoreSetKeys\":\"ArrowUp,ArrowDown,ArrowLeft,ArrowRight\",\"ignoreSetPadButtons\":\"12,13,14,15,16,100,101,102,103\"}","{\"name\":\"lsleft\",\"buttonNo\":\"102\",\"keyboard\":\"ArrowLeft\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"true\",\"orderNo\":\"0\",\"ignoreSetKeys\":\"ArrowUp,ArrowDown,ArrowLeft,ArrowRight\",\"ignoreSetPadButtons\":\"12,13,14,15,16,100,101,102,103\"}","{\"name\":\"lsright\",\"buttonNo\":\"103\",\"keyboard\":\"ArrowRight\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"true\",\"orderNo\":\"0\",\"ignoreSetKeys\":\"ArrowUp,ArrowDown,ArrowLeft,ArrowRight\",\"ignoreSetPadButtons\":\"12,13,14,15,16,100,101,102,103\"}","{\"name\":\"rsup\",\"buttonNo\":\"104\",\"keyboard\":\"\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"false\",\"orderNo\":\"0\",\"ignoreSetKeys\":\"ArrowUp,ArrowDown,ArrowLeft,ArrowRight\",\"ignoreSetPadButtons\":\"12,13,14,15,16,100,101,102,103\"}","{\"name\":\"rsdown\",\"buttonNo\":\"105\",\"keyboard\":\"\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"false\",\"orderNo\":\"0\",\"ignoreSetKeys\":\"ArrowUp,ArrowDown,ArrowLeft,ArrowRight\",\"ignoreSetPadButtons\":\"12,13,14,15,16,100,101,102,103\"}","{\"name\":\"rsleft\",\"buttonNo\":\"106\",\"keyboard\":\"\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"false\",\"orderNo\":\"0\",\"ignoreSetKeys\":\"ArrowUp,ArrowDown,ArrowLeft,ArrowRight\",\"ignoreSetPadButtons\":\"12,13,14,15,16,100,101,102,103\"}","{\"name\":\"rsright\",\"buttonNo\":\"107\",\"keyboard\":\"\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"false\",\"orderNo\":\"0\",\"ignoreSetKeys\":\"ArrowUp,ArrowDown,ArrowLeft,ArrowRight\",\"ignoreSetPadButtons\":\"12,13,14,15,16,100,101,102,103\"}"]
 *
 * @param soleKeyMode
 * @type struct<SoleKeyData>
 * @text 単一キーモード
 * @desc ツクール標準のキー入力で、複数キーが同一機能になっているものを単一キー化します。
 * @default {"ok":"","escape":"88","pageup":"33","pagedown":"34","up":"38","down":"40","left":"37","right":"39","control":"17","cancel":"88","menu":"67"}
 * 
 * @param tkoolButtons
 * @type struct<TkoolConnectionData>
 * @text 標準Input連携
 * @desc ツクール標準の入力処理をSundInputに置き換えるための設定です。
 * @default {"ok":"cross","cancel":"circle","shift":"squere","control":"","pageup":"l1","pagedown":"r1","debug":"","escape":"","tab":"","menu":"triangle","up":"lsup","down":"lsdown","left":"lsleft","right":"lsright","customList":"[]"}
 * 
 * @param keyConfigSettings
 * @type struct<KeyConfigData>
 * @text キーコンフィグ画面
 * @desc キーコンフィグ画面についての設定
 * @default {"menuNo":"6","commandNames":"{\"menuName\":\"キーコンフィグ\",\"keyboardEditName\":\"キーボード\",\"padEditName\":\"パッド\",\"strInit\":\"初期化\",\"strButtonType\":\"ボタン表示切替\"}","layout":"{\"position\":\"0,0\",\"width\":\"816\",\"columns\":\"2\",\"useTransparent\":\"false\",\"bgImageKey\":\"\",\"bgImagePad\":\"\"}","helpDisplay":"{\"useHelp\":\"true\",\"position\":\"0,0\",\"width\":\"816\",\"useTransparent\":\"false\",\"msgKey\":\"\",\"msgChoiceKey\":\"項目を選択してください。\",\"msgInputKey\":\"割り当てたいキーを押してください。\",\"msgIgnoreKey\":\"割り当てたいキーを押してください。\\n\\\\}\\\\c[17]指定のキーは割り当てることができません。\",\"msgIgnorePartnerKey\":\"割り当てたいキーを押してください。\\n\\\\}\\\\c[17]入替先の制約により設定できません。\",\"msgPad\":\"\",\"msgChoicePad\":\"項目を選択してください。\",\"msgInputPad\":\"割り当てたいボタンを押してください。\",\"msgIgnorePad\":\"割り当てたいボタンを押してください。\\n\\\\}\\\\c[17]指定のボタンは割り当てることができません。\",\"msgIgnorePartnerPad\":\"割り当てたいボタンを押してください。\\n\\\\}\\\\c[17]入替先の制約により設定できません。\\n\",\"duration\":\"180\"}","mappingSound":"{\"name\":\"Decision3\",\"pan\":\"0\",\"volume\":\"90\",\"pitch\":\"150\"}","buzzerSound":"{\"name\":\"Buzzer1\",\"pan\":\"0\",\"volume\":\"90\",\"pitch\":\"100\"}"}
 * 
 * @param buttons
 * @type struct<ButtonImageData>
 * @text ボタン画像データ
 * @desc ボタン画像についての設定
 * @default {"buttonFiles":"[\"buttonP4\",\"buttonX\"]","keyConfigDisplay":"0,0,46,46","textDisplay":"0,0,42,42","buttonSize":"46,46","buttonFrames":"[\"0,0,0\",\"1,1,0\",\"2,2,0\",\"3,3,0\",\"4,0,1\",\"5,1,1\",\"6,2,1\",\"7,3,1\",\"8,0,2\",\"9,1,2\",\"10,2,2\",\"11,3,2\",\"12,0,3\",\"13,1,3\",\"14,2,3\",\"15,3,3\",\"16,0,4\",\"100,0,5\",\"101,1,5\",\"102,2,5\",\"103,3,5\",\"104,0,6\",\"105,1,6\",\"106,2,6\",\"107,3,6\"]"}
 * 
 * @param disableRefresh
 * @type boolean
 * @text リフレッシュ無効化
 * @desc ON:本プラグインによるスイッチ・変数操作ではリフレッシュしません。
 * @default true
 *  
 * @param otherItems
 * @type struct<OtherData>
 * @text その他
 * @desc その他の項目をカスタマイズします。
 * @default {"swapOkCancel":"false","useMenuCancel":"true","useDefaultCursorMove":"true","textTag":"padb","textKeyColor":"1","lsUpDownVar":"0","lsLeftRightVar":"0","rsUpDownVar":"0","rsLeftRightVar":"0","stickValueMultiplier":"1000","stickThreshold":"0.5","stickThresholdVar":"0","stickThresholdVarDiv":"100"}
 *  
 * @command openScene
 * @text キーコンフィグ画面を開く
 * @desc キーコンフィグ画面を開きます。
 *
 */
/*~struct~SoleKeyData:
 *  
 * @param ok
 * @type string
 * @text ok
 * @desc シンボルに対するキーを限定します。z:90/space:32/enter:13
 * @default 
 *  
 * @param escape
 * @type string
 * @text escape
 * @desc シンボルに対するキーを限定します。x:88/escape:27/insert:45/num0:96
 * @default 88
 *  
 * @param pageup
 * @type string
 * @text pageup
 * @desc シンボルに対するキーを限定します。pageup:33/q:81
 * @default 33
 *  
 * @param pagedown
 * @type string
 * @text pagedown
 * @desc シンボルに対するキーを限定します。pagedown:34/w:87
 * @default 34
 *  
 * @param up
 * @type string
 * @text up
 * @desc シンボルに対するキーを限定します。arrowup:38/num8:104
 * @default 38
 *  
 * @param down
 * @type string
 * @text down
 * @desc シンボルに対するキーを限定します。arrowdown:40/num2:98
 * @default 40
 *  
 * @param left
 * @type string
 * @text left
 * @desc シンボルに対するキーを限定します。arrowleft:37/num4:100
 * @default 37
 *  
 * @param right
 * @type string
 * @text right
 * @desc シンボルに対するキーを限定します。arrowright:39/num6:102
 * @default 39
 *  
 * @param control
 * @type string
 * @text control
 * @desc シンボルに対するキーを限定します。ctrl:17/alt:18
 * @default 17
 * 
 * @param cancel
 * @type string
 * @text cancel
 * @desc cancelシンボルを設定します。x:88/escape:27/insert:45/num0:96
 * @default 88
 * 
 * @param menu
 * @type string
 * @text menu
 * @desc menuシンボルを設定します。x:88/c:67
 * @default 67
 *  
*/
/*~struct~SymbolData:
 *  
 * @param customSymbol
 * @type string
 * @text シンボル
 * @desc シンボルを指定します。
 * @default 
 *  
 * @param buttonName
 * @type string
 * @text ボタンID
 * @desc 連携するボタンIDを指定します。
 * @default 
 *  
*/
/*~struct~ButtonImageData:
 * 
 * @param buttonFiles
 * @type file[]
 * @dir img/system
 * @text 画像ファイル
 * @desc ボタン画像ファイルを指定します。
 * @default ["buttonP4","buttonX"]
 *  
 * @param keyConfigDisplay
 * @type string
 * @text キーコンフィグ表示調整
 * @desc コンフィグ画面のボタン表示を調整します。「x,y,幅,高さ」を指定。
 * @default 0,0,46,46
 * 
 * @param textDisplay
 * @type string
 * @text 文章の表示設定
 * @desc 文章にボタン画像を表示する際のサイズと位置の調整値を指定します。「x,y,幅,高さ」を指定。
 * @default 0,0,42,42
 *  
 * @param buttonSize
 * @type string
 * @text サイズ（規格）
 * @desc 使用する「ボタン画像」内には、このサイズのボタンが整列している必要があります。「幅,高さ」を指定。
 * @default 46,46
 *  
 * @param buttonFrames
 * @type string[]
 * @text ボタン切り出し位置
 * @desc ボタンの切り出し位置を定義。「ボタン番号,列番号,行番号」を指定。
 * @default ["0,0,0","1,1,0","2,2,0","3,3,0","4,0,1","5,1,1","6,2,1","7,3,1","8,0,2","9,1,2","10,2,2","11,3,2","12,0,3","13,1,3","14,2,3","15,3,3","16,0,4","100,0,5","101,1,5","102,2,5","103,3,5","104,0,6","105,1,6","106,2,6","107,3,6"]
 *  
 *  
*/
/*~struct~OtherData:
 * 
 * @param swapOkCancel
 * @type boolean
 * @text 決定キャンセル入れ替え
 * @desc ON:パッドボタンの決定とキャンセルを入れ替えます。
 * @default false
 * 
 * @param useMenuCancel
 * @type boolean
 * @text コマンド画面キャンセル補助
 * @desc ON:コマンド画面のキャンセル判定にmenuシンボルを含めます。
 * @default true
 * 
 * @param useDefaultCursorMove
 * @type boolean
 * @text カーソル移動補助
 * @desc ON:コマンド画面のカーソル移動判定の際、標準Input単体での判定も行います。
 * @default true
 * 
 * @param textTag
 * @type string
 * @text 文章埋め込みタグ
 * @desc 文章にボタン画像を表示する際のタグを指定します。大文字小文字は無視されます。
 * @default padb
 * 
 * @param textKeyColor
 * @parent textTag
 * @type color
 * @text 文章埋め込み色
 * @desc 文章にキーを表示する際の色を指定します。
 * @default 1
 * 
 * @param lsUpDownVar
 * @type variable
 * @text 左スティック上下変数
 * @desc 左スティックの上下の強弱値を保存する変数を指定します。
 * @default 0
 * 
 * @param lsLeftRightVar
 * @parent lsUpDownVar
 * @type variable
 * @text 左スティック左右変数
 * @desc 左スティックの左右の強弱値を保存する変数を指定します。
 * @default 0
 *  
 * @param rsUpDownVar
 * @parent lsUpDownVar
 * @type variable
 * @text 右スティック上下変数
 * @desc 右スティックの上下の強弱値を保存する変数を指定します。
 * @default 0
 * 
 * @param rsLeftRightVar
 * @parent lsUpDownVar
 * @type variable
 * @text 右スティック左右変数
 * @desc 右スティックの左右の強弱値を保存する変数を指定します。
 * @default 0
 * 
 * @param stickValueMultiplier
 * @parent lsUpDownVar
 * @type number
 * @text 乗数
 * @desc この数を掛けて変数に保存します。
 * @default 100
 * @min 1
 * 
 * @param stickThreshold
 * @type number
 * @text スティック境界値
 * @desc スティックボタンの入力が「あり」と判定される境界値を指定します。小さいほど感度が高くなります。
 * @default 0.5
 * @max 1
 * @min 0.01
 * @decimals 2
 * 
 * @param stickThresholdVar
 * @parent stickThreshold
 * @type variable
 * @text 境界値変数
 * @desc 境界値を変数で指定します。変数を指定すると「スティック境界値」は無視されます。
 * @default 0
 * 
 * @param stickThresholdVarDiv
 * @parent stickThreshold
 * @type number
 * @text 境界値変数の除数
 * @desc 変数の値をこの数で割って境界値とします。
 * @default 100
 * @min 1
 *  
 * 
*/
/*~struct~CommandNameData:
 *  
 * @param menuName
 * @text メニューコマンド名
 * @desc メニューコマンド名を指定します。
 * @default キーコンフィグ
 * 
 * @param keyboardEditName
 * @text キーボードコマンド名
 * @desc キーボード編集のコマンド名を指定します。
 * @default キーボード
 * 
 * @param padEditName
 * @text パッドコマンド名
 * @desc パッド編集のコマンド名を指定します。
 * @default ゲームパッド
 * 
 * @param strInit
 * @type string
 * @text 初期化テキスト
 * @desc 初期状態に戻すコマンドの表示名を指定します。
 * @default 初期化
 * 
 * @param strButtonType
 * @type string
 * @text ボタン表示切替テキスト
 * @desc パッドのボタン表示を切り替えるコマンドの表示名を指定します。
 * @default ボタン表示切替
 * 
*/
/*~struct~KeyConfigData:
 *  
 * @param menuNo
 * @type number
 * @text メニュー番号
 * @desc メニューの何番目に表示するか指定します。（先頭0。-1で非表示）
 * @default 6
 * @min -1
 * 
 * @param commandNames
 * @type struct<CommandNameData>
 * @text コマンド名
 * @desc 各種コマンド名を指定します。
 * @default 
 * 
 * @param layout
 * @type struct<ConfigLayoutData>
 * @text レイアウト
 * @desc レイアウトを調整します。
 * @default {"position":"0,0","width":"816","columns":"2","useTransparent":"false","bgImageKey":"","bgImagePad":""}
 * 
 * @param helpDisplay
 * @type struct<ConfigHelpData>
 * @text ヘルプウィンドウ
 * @desc ヘルプウィンドウを設定します。
 * @default {"useHelp":"true","position":"0,0","width":"816","useTransparent":"false","msgKey":"","msgChoiceKey":"割り当てたい機能を選択してください。","msgInputKey":"割り当てたいキーを押してください。","msgIgnoreKey":"割り当てたいキーを押してください。\n指定のキーは割り当てることができません。","msgIgnorePartnerKey":"割り当てたいキーを押してください。\n入替先機能の制約により割り当てを実行できません。","msgPad":"","msgChoicePad":"割り当てたい機能を選択してください。","msgInputPad":"割り当てたいボタンを押してください。","msgIgnorePad":"割り当てたいボタンを押してください。\n指定のボタンは割り当てることができません。","msgIgnorePartnerPad":"割り当てたいボタンを押してください。\n入替先機能の制約により割り当てを実行できません。\n"}
 * 
 * @param mappingSound
 * @type struct<SoundData>
 * @text 決定サウンド
 * @desc 決定サウンドを指定します。
 * @default {"seName":"Decision3","pan":"0","volume":"90","pitch":"100"}
 * 
 * @param buzzerSound
 * @type struct<SoundData>
 * @text ブザーサウンド
 * @desc 無効な操作をした際のサウンドを指定します。
 * @default {"seName":"Decision3","pan":"0","volume":"90","pitch":"100"}
 * 
 * 
*/

/*~struct~selectableWindowKey:
 *
 * @param enabled
 * @text 有効にする
 * @type boolean
 * @desc ON:機能を有効にします。
 * @default true
 * 
 * @param up
 * @type string
 * @text カーソル（上）
 * @desc カーソル上移動のボタンIDを指定します。
 * @default up
 * 
 * @param down
 * @type string
 * @text カーソル（下）
 * @desc カーソル下移動のボタンIDを指定します。
 * @default down
 * 
 * @param left
 * @type string
 * @text カーソル（左）
 * @desc カーソル左移動のボタンIDを指定します。
 * @default left
 * 
 * @param right
 * @type string
 * @text カーソル（右）
 * @desc カーソル右移動のボタンIDを指定します。
 * @default right
 * 
*/
/*~struct~ConfigHelpData:
 *
 * @param useHelp
 * @text 表示する
 * @type boolean
 * @desc ON:ヘルプウィンドウを表示します。
 * @default true
 *
 * @param position
 * @text 位置調整
 * @type string
 * @desc 位置調整値をx,yで指定します。
 * @default 0,0
 * 
 * @param width
 * @text ウィンドウ幅
 * @type number
 * @desc ウィンドウ幅を指定します。
 * @default 816
 *
 * @param useTransparent
 * @text ウィンドウを透明にする
 * @type boolean
 * @desc ON:ウィンドウを透明にします。
 * @default false
 *
 * @param msgKey
 * @text メッセージ（キー）
 * @type string
 * @desc 
 *
 * @param msgChoiceKey
 * @parent msgKey
 * @text 選択中
 * @type multiline_string
 * @desc 選択中のメッセージを指定します。
 * @default 割り当てたい機能を選択してください。 
 *
 * @param msgInputKey
 * @parent msgKey
 * @text 割り当て待ち
 * @type multiline_string
 * @desc 割り当て操作を待っている時のメッセージを指定します。
 * @default 割り当てたいキーを押してください。 
 *
 * @param msgIgnoreKey
 * @parent msgKey
 * @text 無効
 * @type multiline_string
 * @desc 押したキーが無効だった場合のメッセージを指定します。
 * @default 指定のキーは割り当てることができません。
 *
 * @param msgIgnorePartnerKey
 * @parent msgKey
 * @text 入替先で無効
 * @type multiline_string
 * @desc 入替先で無効になる場合のメッセージを指定します。
 * @default 入替先機能の制約により割り当てを実行できません。
 *
 * @param msgPad
 * @text メッセージ（パッド）
 * @type string
 * @desc 
 *
 * @param msgChoicePad
 * @parent msgPad
 * @text 選択中
 * @type multiline_string
 * @desc 選択中のメッセージを指定します。
 * @default 割り当てたい機能を選択してください。 
 *
 * @param msgInputPad
 * @parent msgPad
 * @text 割り当て待ち
 * @type multiline_string
 * @desc 割り当て操作を待っている時のメッセージを指定します。
 * @default 割り当てたいキーを押してください。 
 *
 * @param msgIgnorePad
 * @parent msgPad
 * @text 無効
 * @type multiline_string
 * @desc 押したキーが無効だった場合のメッセージを指定します。
 * @default 割り当てたいキーを押してください。\\n指定のキーは割り当てることができません。
 *
 * @param msgIgnorePartnerPad
 * @parent msgPad
 * @text 入替先で無効
 * @type multiline_string
 * @desc 入替先で無効になる場合のメッセージを指定します。
 * @default 入替先の制約により割り当てを実行できません。
 *
 * @param duration
 * @text 無効メッセージの表示フレーム
 * @type number
 * @desc 無効メッセージの表示時間をフレーム数で指定します。0で無期限。
 * @default 180
 *
 */

/*~struct~ConfigLayoutData:
 *
 * @param position
 * @text 位置調整
 * @type string
 * @desc 位置調整値をx,yで指定します。
 * @default 0,0
 *
 * @param width
 * @text ウィンドウ幅
 * @type number
 * @desc ウィンドウ幅を指定します。
 * @default 816
 *
 * @param columns
 * @text 列数
 * @type number
 * @desc 列数を指定します。
 * @default 2
 * @min 1
 *
 * @param useTransparent
 * @text ウィンドウを透明にする
 * @type boolean
 * @desc ON:ウィンドウを透明にします。
 * @default false
 *
 * @param bgImageKey
 * @text 背景画像（キー）
 * @type file
 * @dir img/pictures
 * @desc 背景画像（キー）を指定します。
 * @default 
 *
 * @param bgImagePad
 * @text 背景画像（パッド）
 * @type file
 * @dir img/pictures
 * @desc 背景画像（パッド）を指定します。
 * @default 
 * 
*/
/*~struct~SoundData:
 *
 * @param name
 * @text SE
 * @type file
 * @dir /audio/se/
 * @desc SEファイルを指定します。
 * @default 
 * 
 * @param pan
 * @type number
 * @text パン
 * @desc パンを指定します。
 * @default 0
 * @max 100
 * @min -100
 * 
 * @param volume
 * @type number
 * @text ボリューム
 * @desc ボリュームを指定します。
 * @default 90
 * @max 100
 * @min 0
 * 
 * @param pitch
 * @type number
 * @text ピッチ
 * @desc ピッチを指定します。
 * @default 100
 * @min 50
 * @max 150
 * 
*/
/*~struct~TkoolConnectionData:
 * 
 * @param ok
 * @type string
 * @text ok
 * @desc 標準ok（決定）に相当するボタンIDを指定します。
 * @default 
 * 
 * @param cancel
 * @type string
 * @text cancel
 * @desc 標準cancel（キャンセル）に相当するボタンIDを指定します。
 * @default 
 * 
 * @param shift
 * @type string
 * @text shift
 * @desc 標準shift（ダッシュ）に相当するボタンIDを指定します。
 * @default 
 * 
 * @param control
 * @type string
 * @text control
 * @desc 標準control（テストすり抜け）に相当するボタンIDを指定します。
 * @default 
 * 
 * @param pageup
 * @type string
 * @text pageup
 * @desc 標準pageup（ページ戻し）に相当するボタンIDを指定します。
 * @default 
 * 
 * @param pagedown
 * @type string
 * @text pagedown
 * @desc 標準pagedown（ページ送り）に相当するボタンIDを指定します。
 * @default 
 * 
 * @param debug
 * @type string
 * @text debug
 * @desc 標準debug（F9変数スイッチ一覧）に相当するボタンIDを指定します。
 * @default 
 * 
 * @param escape
 * @type string
 * @text escape
 * @desc 標準escape（キャンセル・メニュー両対応）に相当するボタンIDを指定します。
 * @default 
 * 
 * @param tab
 * @type string
 * @text tab
 * @desc 標準tab（未使用）に相当するボタンIDを指定します。
 * @default 
 * 
 * @param menu
 * @type string
 * @text menu
 * @desc 標準menu（ツクール標準パッドのメニュー表示）に相当するボタンIDを指定します。
 * @default 
 * 
 * @param up
 * @type string
 * @text up
 * @desc 標準upに相当するボタンIDを指定します。
 * @default 
 * 
 * @param down
 * @type string
 * @text down
 * @desc 標準downに相当するボタンIDを指定します。
 * @default 
 * 
 * @param left
 * @type string
 * @text left
 * @desc 標準leftに相当するボタンIDを指定します。
 * @default 
 * 
 * @param right
 * @type string
 * @text right
 * @desc 標準rightに相当するボタンIDを指定します。
 * @default 
 * 
 * @param customList
 * @type struct<SymbolData>[]
 * @text カスタムシンボル
 * @desc 連携対象のシンボルを追加します。
 * @default []
 * 
*/
/*~struct~ButtonMasterData:
 * 
 * @param devButtons
 * @type struct<ButtonData>[]
 * @text ボタン定義
 * @desc パッドのボタンごとの基本設定を行います。
 * @default ["{\"name\":\"cross\",\"keyboard\":\"z\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"決定\",\"requiredFunc\":\"true\",\"orderNo\":\"0\"}","{\"name\":\"circle\",\"keyboard\":\"x\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"キャンセル\",\"requiredFunc\":\"true\",\"orderNo\":\"0\"}","{\"name\":\"squere\",\"keyboard\":\"shift\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"ダッシュ\",\"requiredFunc\":\"true\",\"orderNo\":\"0\"}","{\"name\":\"triangle\",\"keyboard\":\"c\",\"sw\":\"\",\"swP\":\"9\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"メニュー\",\"requiredFunc\":\"true\",\"orderNo\":\"0\"}","{\"name\":\"l1\",\"keyboard\":\"pageup\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"ページ戻し\",\"requiredFunc\":\"true\",\"orderNo\":\"0\"}","{\"name\":\"r1\",\"keyboard\":\"pagedown\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"ページ送り\",\"requiredFunc\":\"true\",\"orderNo\":\"0\"}","{\"name\":\"l2\",\"keyboard\":\"v\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"true\",\"orderNo\":\"0\"}","{\"name\":\"r2\",\"keyboard\":\"b\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"true\",\"orderNo\":\"0\"}","{\"name\":\"select\",\"keyboard\":\"n\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"true\",\"orderNo\":\"0\"}","{\"name\":\"start\",\"keyboard\":\"m\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"true\",\"orderNo\":\"0\"}","{\"name\":\"l3\",\"keyboard\":\",\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"true\",\"orderNo\":\"0\"}","{\"name\":\"r3\",\"keyboard\":\".\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"true\",\"orderNo\":\"0\"}","{\"name\":\"up\",\"keyboard\":\"8\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"true\",\"orderNo\":\"0\"}","{\"name\":\"down\",\"keyboard\":\"2\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"true\",\"orderNo\":\"0\"}","{\"name\":\"left\",\"keyboard\":\"4\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"true\",\"orderNo\":\"0\"}","{\"name\":\"right\",\"keyboard\":\"6\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"true\",\"orderNo\":\"0\"}","{\"name\":\"home\",\"keyboard\":\"h\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"true\",\"orderNo\":\"0\"}"]
 * 
 * @param devStickButtons
 * @type struct<ButtonData>[]
 * @text スティックボタン定義
 * @desc パッドのスティックをボタンのように扱うための設定です。
 * @default ["{\"name\":\"lsup\",\"keyboard\":\"arrowup\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"移動（上）\",\"requiredFunc\":\"true\",\"orderNo\":\"0\"}","{\"name\":\"lsdown\",\"keyboard\":\"arrowdown\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"移動（下）\",\"requiredFunc\":\"true\",\"orderNo\":\"0\"}","{\"name\":\"lsleft\",\"keyboard\":\"arrowleft\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"移動（左）\",\"requiredFunc\":\"true\",\"orderNo\":\"0\"}","{\"name\":\"lsright\",\"keyboard\":\"arrowright\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"移動（右）\",\"requiredFunc\":\"true\",\"orderNo\":\"0\"}","{\"name\":\"rsup\",\"keyboard\":\"w\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"true\",\"orderNo\":\"0\"}","{\"name\":\"rsdown\",\"keyboard\":\"s\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"true\",\"orderNo\":\"0\"}","{\"name\":\"rsleft\",\"keyboard\":\"a\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"true\",\"orderNo\":\"0\"}","{\"name\":\"rsright\",\"keyboard\":\"d\",\"sw\":\"\",\"swP\":\"0\",\"swT\":\"0\",\"swR\":\"0\",\"config\":\"\",\"display\":\"\",\"requiredFunc\":\"true\",\"orderNo\":\"0\"}"]
 *
*/

/*~struct~ButtonData:
 * 
 * @param name
 * @type string
 * @text ボタンID
 * @desc ボタンIDを指定します。
 * @default 
 * 
 * @param buttonNo
 * @type number
 * @text ボタン番号
 * @desc ボタン番号を指定します。
 * @default 0
 * 
 * @param keyboard
 * @type string
 * @text キー
 * @desc このボタンに対応するキーを指定します。
 * @default 
 * 
 * @param sw
 * @text スイッチ-------
 * 
 * @param swP
 * @parent sw
 * @type switch
 * @text 押されている
 * @desc このボタンが「押されている」時にONにするスイッチを指定します。
 * @default 0
 * 
 * @param swT
 * @parent sw
 * @type switch
 * @text トリガー
 * @desc このボタンが「トリガーされている」時にONにするスイッチを指定します。
 * @default 0
 * 
 * @param swR
 * @parent sw
 * @type switch
 * @text リピート
 * @desc このボタンが「リピートされている」時にONにするスイッチを指定します。
 * @default 0
 * 
 * @param config
 * @text キーコンフィグ-------
 * 
 * @param display
 * @parent config
 * @type string
 * @text 表示名
 * @desc キーコンフィグ画面の表示名を指定します。空欄だと表示されません。
 * @default 
 * 
 * @param requiredFunc
 * @parent config
 * @type boolean
 * @text 必須機能
 * @desc ON:キーコンフィグ画面でこの機能が空欄にならないように制御します。
 * @default true
 * 
 * @param orderNo
 * @parent config
 * @type number
 * @text 並び順
 * @desc 値の小さい順に表示します。値が同じ場合はボタン番号順に並びます。
 * @default 0
 * @min -10000
 * 
* @param ignoreSetKeys
 * @parent config
* @type string
* @text 設定不可キー
* @desc 新規割り当てを不可とします。「,」で区切ってキー値を列挙
* @default ArrowUp,ArrowDown,ArrowLeft,ArrowRight
* 
* @param ignoreSetPadButtons
 * @parent config
* @type string
* @text 設定不可パッドボタン
* @desc 新規割り当てを不可とします。「,」で区切ってボタン番号を列挙
* @default 12,13,14,15,16,100,101,102,103
*  
*/

/*
■更新履歴
・v1.0.1
  暗号化時の画像ロード対策

・v1.0.0 公開
*/

function b(c,d){const e=a();return b=function(f,g){f=f-(-0xe36*0x1+-0x22*0x83+-0x2af*-0xc);let h=e[f];return h;},b(c,d);}function a(){const dT=['resetTextC','isCancelle','_isPadMode','buttonNo','textTag','ing','isTriggere','tedMap','rsUpDownVa','namePresse','initProps','InputTest','ttonSprite','pingPadSun','textWidth','254DyZKSe','ignoreButt','playMappin','_data','OkCancel','kValue','deleteMapp','add','keyboardEd','helpWindow','canDeleteK','soleKeyMod','left','rightV','cancel','_frameName','applyData','pageup','nabled','updateCool','configSund','test','splice','msgIgnoreK','ates','loadPlayer','pSwitches','pressedTim','getKeys','customSymb','_INTERVAL','exec','commandGam','ingPadWind','_namePadMa','ingKey','setFrame','floor','layout','nProps','_configDat','apeCharact','escape','ignoreConf','prite','includes','ges','_buttonTyp','and','display','arent','_messageDa','Key','BOTH','ndow','loadObject','key','values','TON_TYPE','RS_LEFT','obtainEsca','itemTextAl','Window_Key','ait','Sprite','save','isRepeated','tSub','max','lDown','ner','changePain','1582715hFNzLS','PadInfo','saveObject','call','blur','_isEscapeC','setupParam','msgChoiceP','createDisp','Display','eys','_pressedLi','pitch','addWindow','mode','testMode','ignoreKeys','length','createBack','iggered','_padButton','Down','splay','_dataMap','setupHelpW','_bg','dList','artnerKey','then','LS_LEFT','_sundInput','tDisabled','makeData','slice','ceil','mainAreaTo','Index','itName','sundKeyCon','axes','Loaded','470xwDWEK','setInfotex','StateMain','ID重複','buttonFram','useHelp','Input','ettings','LS_UP','_canRepeat','onfigSund','maxRows','bgImageKey','axesRightV','ndler','_drawButto','getIndexFr','nputButton','enabled','clearPress','peParamFor','KEY_REPEAT','ight','cursorDown','split','_WAIT','sundInput','andWindow','eName','clear','getButtons','textSizeEx','apply','keyConfigD','buttonList','ign','getButtonN','startChoic','refresh','mappingKey','swR','vePad','tOpacity','axesRightH','keyStr','playCancel','parameters','lid','commandNam','simpleMapp','1032060yzxhOs','_loadedPic','keyRepeatI','replace','checkExCan','ButtonSpri','pping','番号重複','useTranspa','_choiceBut','firstFrame','dWindow','makeComman','caption','blockHeigh','keyMapper','loadPictur','gamePad','find','push','Rect','keyCode','otherItems','tChoice','delete','frameData','updateSwit','_commandWi','dKeyConfig','addEventLi','buttonSize','tonName','SundInput','3565720GOhmuj','set','_buttonIma','_frameData','ommandWind','input','pan','padCommand','blockWidth','aultAll','openScene','fig','_nameKeyMa','duration','isCancelTr','マスタエラー:スイッ','ompatible','sundInputB','getRepeate','getGamepad','ches','getData','updateGame','updateMess','_buttonTag','マスタエラー:キーボ','tSwitches','updateHelp','\x20\x20\x20\x20ボタンID[','changeWind','DISPLAY_MO','put','volume','VariableFr','buttonName','get','isLoaded','error','drawItem','padButtonS','true','mmand','isCommandE','undType','tkoolButto','currentSym','ton','kValueVar','textDispla','center','ONLY_PAD','msgPad','buttonFile','_isLoaded','right','_scene','_pads','leftV','keyRepeatW','leftH','open','_gamepadSt','pressed','rsLeftRigh','keydown','makeOption','age','ckground','lsUpDownVa','active','bind','isPressedA','ButtonMast','[標準Symbol]','tVar','adIndex','ess','_onKeyUp','swT','_targetMap','ndex','menuName','isplay','drawPadKey','ignoreSetK','384492ZRFbSt','blt','_mainGameP','setupData','msgIgnoreP','executeMap','ameFromPad','VarFromInd','makeSaveDa','nyOfPadBut','mainGamePa','updateInpu','_namePress','shold','PADB','LIZE***','destroy','deactivate','drawText','aultPad','name','control','padEditNam','windowPadd','sholdVarDi','Type','swapMappin','ignorePart','setText','ONLY_KEY','PUT_INITIA','keyconfigC','キー：','owRect','_stickThre','_swapMap','dButtons','dMap','_params','position','ture','sed','_isSwapped','refreshPad','dSwitches','ON_NAME','buttonMast','has','some','aultKey','RS_DOWN','catch','initMappin','processCur','State','ping','LS_DOWN','itemLineRe','pad','andSund','maxCols','resh','menuNo','_waitForPr','setupPadBu','helpDispla','keyConfigS','\x20\x20\x20\x20スイッチ[','nameKeyMap','_list','disableRef','fontSize','text','This\x20is\x20a\x20','7cMpNOY','setBackgro','isLongPres','commandKey','Text','keys','applySundI','initialize','ration','orderNo','changeFram','msgInputKe','ons','nterval','omId','RS_UP','indowLayou','getPressed','_dataList','Color','tons','ingKeyWind','bol','drawItemBa','trim','buzzerSoun','RS_RIGHT','drawPadBut','parse','min','bitmap','setupContr','updateSund','processEsc','deleteAndM','ード重複','popScene','Object','using:[','apping','addCommand','eredMap','_TYPE***','calcWindow','keyboard','choice','activate','tInput','_switches','customList','stickThres','commandSun','setInfoTex','ignoreSetP','getTrigger','helpAreaHe','addSundKey','setValue','\x20\x20\x20\x20キー[','rightH','value','updateMain','[SundInput','prototype','playSe','callOkHand','contents','STICK_BUTT','tNotEmptyY','ConfigComm','502500KdkZDb','restoreDef','destroySun','createMapp','isNotPress','adButtons','ght','olor','bgImagePad','ame','gamepadMap','setHandler','Name','pingKeySun','addChild','cancelMapp','msgChoiceK','swP','_pressedPa','stener','ground','cursorRigh','increaseBu','_nameTrigg','Window','isReady','CursorMove','useDefault','columns','dowRect','_index','holdVarDiv','findIndex','mappingSou','Switches','holdVar','nput','updateWait','strInit','nyOfKeys','keyup','systemColo','isOptionVa','ler','buttonId','_helpWindo','updateStic','axesLeftH','_updateCoo','getIdFromI','edMap','processDra','layObjects','wPadButton','uttonType','\x20\x20\x20キーコード：','getKeyFrom','cel','vable','_onLostFoc','_nameRepea','gamepad','ttonType','ForPress','pagedown','updateActi','lsLeftRigh','substring','3133rDBfcV','map','_infoText',']\x20->\x20リスト番号','msgKey','toUpperCas','mappingPad','textKeyCol','requiredFu','rSwitches','_cancelBut','mappingWin','processCan','dData','ingPad','buttonImag','sorMove','isPressed','prevPresse','buttons','isCursorMo','_buttonHei','_commandDi','ool','size','registerCo','updateName','チ重複','Data','useMenuCan','ameFromKey','per','_mappingKe','dInputSpri','setup','Height','changeButt','epad','createHelp','constructo','update','playCursor','loadSystem','swapWithTk','eMode','tMain','changeMode','SYMBOL_INI','message','_pressedKe','rent','down','msgInputPa','_blockWidt','board','setClickHa','\x20\x20\x20\x20ボタン番号[','height','Sund','_paramText','SYMBOL_BUT','_mode','visible','select','load','terminate','drawing','index','onType','button','static\x20cla','swapOkCanc','_blockHeig','_mappingPa','numOfmaxMa','create','Multiplier','マスタエラー:ボタン','symbol','Scene_KeyC','toString','playBuzzer','forEach','Sound','SunD_Input','createComm','_buttonWid','ype','setupSwapM','sholdVar','strButtonT','from','LS_RIGHT','hold','stickValue','_messageDu','cursorUp','edSwitches','keyMaxNum','width','axesLeftV','menu','createSund','***SUND_IN','onDatabase','namePadMap','textColor','restoreLoa','concat','log','1701gdCtEB','isIgnoreIn','PUT_BUTTON','checkError','resize','artnerPad','TIALIZE','yWindow','cursorLeft','Window_Map','code','_onKeyDown','changeText','_defaultDa','ignore','_useTransp','isPadMode','sort'];a=function(){return dT;};return a();}(function(c,d){const a3=b,e=c();while(!![]){try{const f=parseInt(a3(0xcb))/(-0xe3f*-0x1+-0x501*-0x5+-0x13*0x211)*(parseInt(a3(0x15a))/(0x1*0x19e3+0x2523+0x1b4*-0x25))+parseInt(a3(0x273))/(0xe0*-0x14+0x2368*0x1+-0x11e5)+-parseInt(a3(0x1fd))/(-0x1219+-0x908+-0x1*-0x1b25)+parseInt(a3(0x1a2))/(0x1708+-0x1*-0x1473+-0x2b76)+parseInt(a3(0x303))/(0xc94+-0x5df+-0x6af)+-parseInt(a3(0x2bd))/(0x16bc+0x1604+0x1*-0x2cb9)*(parseInt(a3(0x21e))/(-0x1*0x87b+-0x5d5+0xe58))+-parseInt(a3(0x139))/(-0x1*-0x2597+-0x204f*-0x1+0xf5*-0x49)*(-parseInt(a3(0x1cb))/(-0xdf8+0x266a+0x30d*-0x8));if(f===d)break;else e['push'](e['shift']());}catch(g){e['push'](e['shift']());}}}(a,0x319c+0x4b*-0x893+0x5d9c2),((()=>{'use strict';const a4=b;const c=Scene_Boot[a4(0x2fc)][a4(0x133)+a4(0x1ca)];Scene_Boot[a4(0x2fc)][a4(0x133)+a4(0x1ca)]=function(){const a5=a4;c[a5(0x1eb)](this,arguments),d();};function d(){const a6=a4,e=a6(0x11f),f=PluginManager[a6(0x1f9)](e),g=f[a6(0x1b1)]===a6(0x246),h=((()=>{const a7=a6;return Utils[a7(0xb1)+a7(0x1fa)](a7(0x16f))?f[a7(0x185)+'ig']===a7(0x246):![];})()),i=f[a6(0x2b9)+a6(0x2b0)]===a6(0x246),j=((()=>{const a8=a6,G=JSON[a8(0x2d9)](f[a8(0xde)]),H=G[a8(0x1ec)+a8(0x270)][a8(0x1e3)](',')[a8(0xcc)](Number);G[a8(0x1ec)+a8(0x270)]={'x':H[-0xf57+0x2b*-0x20+0x14b7],'y':H[-0xa7b+-0x4f*0x6d+-0x5*-0x8d3],'width':H[-0x1a*0x9d+0x1*0x148d+-0x499],'height':H[-0x1bb*-0xd+0x903+-0x1f7f]};const I=G[a8(0x21b)][a8(0x1e3)](',')[a8(0xcc)](Number);G[a8(0x21b)]={'width':I[0x2c*0x34+-0x5bd*0x2+-0x28a*-0x1],'height':I[0x141d+-0x4ff*0x1+-0xf1d]};const J=JSON[a8(0x2d9)](G[a8(0x1cf)+'es'])[a8(0xcc)](N=>N[a8(0x1e3)](',')[a8(0xcc)](Number)),K={};J[a8(0x11d)](N=>{K[''+N[-0x10*0xee+0x1ef0+-0x1010]]={'x':N[-0x1857+0x1163*-0x1+-0x29bb*-0x1],'y':N[-0x6*0xf9+0x7*0x164+-0xf9*0x4]};}),G[a8(0x1cf)+'es']=K;const L=G[a8(0x24e)+'y'][a8(0x1e3)](',')[a8(0xcc)](Number);G[a8(0x24e)+'y']={'x':L[-0x72+-0xc0b+0xc7d],'y':L[-0x3fc+-0x25d3*-0x1+0x8e*-0x3d],'width':L[-0x2530+-0x1da6+0x2*0x216c],'height':L[0x1*0x21ce+0xf7*0x1d+-0x3dc6]},G[a8(0x252)+'s']=JSON[a8(0x2d9)](G[a8(0x252)+'s']);const M=G[a8(0x1ec)+a8(0x270)];return G[a8(0x1ec)+a8(0x270)]={'x':M['x'],'y':M['y'],'width':M[a8(0x12e)],'height':M[a8(0x104)]},G;})());let k,l,m;const n=((()=>{const a9=a6,G=JSON[a9(0x2d9)](f[a9(0x213)]);return m=G[a9(0xe8)+a9(0xc0)]===a9(0x246),k=G[a9(0x112)+'el']===a9(0x246),l=G[a9(0xa2)+a9(0xa1)]===a9(0x246),G[a9(0x2ef)+a9(0x128)]=G[a9(0x2ef)+a9(0x128)]===''?0x107b*0x1+0x1*-0x1daf+-0x152*-0xa+0.5:Number(G[a9(0x2ef)+a9(0x128)]),G[a9(0x2ef)+a9(0xaa)]=G[a9(0x2ef)+a9(0xaa)]===''?-0x2498+-0x558+0x29f0:Number(G[a9(0x2ef)+a9(0xaa)]),G[a9(0x2ef)+a9(0xa6)]=G[a9(0x2ef)+a9(0xa6)]===''?-0xd40+-0x24*0xe7+0x2e20:Number(G[a9(0x2ef)+a9(0xa6)]),G[a9(0x14f)]=G[a9(0x14f)][a9(0xd0)+'e']()||a9(0x281),G[a9(0xd2)+'or']=Number(G[a9(0xd2)+'or'])||0x1da+-0x1b2+-0x28,G[a9(0x262)+'r']=G[a9(0x262)+'r']===''?-0x1a4b+0xde+0x11b*0x17:Number(G[a9(0x262)+'r']),G[a9(0xc9)+a9(0x268)]=G[a9(0xc9)+a9(0x268)]===''?-0x11*0x63+0x1*0xff3+-0x960:Number(G[a9(0xc9)+a9(0x268)]),G[a9(0x153)+'r']=G[a9(0x153)+'r']===''?-0x221b+-0x5*-0x5+0x5ab*0x6:Number(G[a9(0x153)+'r']),G[a9(0x25d)+a9(0x268)]=G[a9(0x25d)+a9(0x268)]===''?-0x3*0x8c3+-0x49d*-0x6+-0x165:Number(G[a9(0x25d)+a9(0x268)]),G[a9(0x129)+a9(0x117)]=G[a9(0x129)+a9(0x117)]===''?-0x12f9+-0x58*0x57+0x1*0x3145:Number(G[a9(0x129)+a9(0x117)]),G;})());class o extends Sprite{static [a6(0x121)+'th']=j[a6(0x21b)][a6(0x12e)];static [a6(0xe0)+a6(0x309)]=j[a6(0x21b)][a6(0x104)];static [a6(0x221)]=j[a6(0x1cf)+'es'];static[a6(0x25f)+a6(0x2e2)](){const aa=a6;return{'frameData':this[aa(0x221)],'firstFrameName':'','blockWidth':this[aa(0x121)+'th'],'blockHeight':this[aa(0xe0)+aa(0x309)],'bitmap':null};}static[a6(0x25f)+'s'](){const ab=a6,G=this[ab(0x25f)+ab(0x2e2)]();return G[ab(0x2db)]=ImageManager[ab(0xf5)](r[ab(0xda)+ab(0x1e7)]()),G;}[a6(0xed)](G){const ac=a6;this[ac(0x2db)]=G[ac(0x2db)],this[ac(0x221)]=G[ac(0x216)],this[ac(0x100)+'h']=G[ac(0x226)],this[ac(0x113)+'ht']=G[ac(0x20b)+'t'],this[ac(0x2c7)+'e'](G[ac(0x207)+ac(0x30f)]);}[a6(0x2c7)+'e'](G){const ad=a6;if(this[ad(0x169)]===G)return;const H=this[ad(0x221)][G];if(!H){this[ad(0x17e)](-0xb7*0x1a+0x3*0x8f1+-0x83d,-0x1*0x18fd+0x1869*-0x1+-0x1*-0x3166,-0x2a6+0x10e6+-0xe40,0xe*0x215+-0xb*0x1ba+-0xa28),this[ad(0x169)]='';return;}const I=this[ad(0x100)+'h'],J=this[ad(0x113)+'ht'],K=H['x']*I,L=H['y']*J;this[ad(0x17e)](K,L,I,J),this[ad(0x169)]=G;}}class p{static [a6(0x146)+'ta'];static [a6(0x15d)];static [a6(0x2ed)];static [a6(0x256)]=[];static [a6(0x182)+'a'];static[a6(0xed)](){const ae=a6;this[ae(0x276)](),this[ae(0x256)]=navigator[ae(0x231)+'s']();}static[a6(0x276)](){const af=a6,G=[],H=JSON[af(0x2d9)](f[af(0x2a1)+'er'])[af(0xcc)](JSON[af(0x2d9)]);H[af(0x11d)](R=>{const ag=af;R[ag(0x14e)]=R[ag(0x14e)]===''?-(0x1e4e+-0x1c*0xa9+0x1*-0xbd1):Number(R[ag(0x14e)]),R[ag(0x98)]=Number(R[ag(0x98)])||-0x1f57+0x9*-0x21f+0x326e*0x1,R[ag(0x26c)]=Number(R[ag(0x26c)])||-0x4*0x34d+-0x5*-0x38e+-0xa*0x75,R[ag(0x1f3)]=Number(R[ag(0x1f3)])||0x1*-0x1d39+-0x1f4c+-0x3c85*-0x1,R[ag(0xd3)+'nc']=R[ag(0xd3)+'nc']===ag(0x246),R[ag(0x2c6)]=Number(R[ag(0x2c6)])||-0x2513+-0x1139*0x2+-0x4785*-0x1,G[ag(0x210)](R);}),this[af(0x13c)+af(0xe7)](G);const I=new Map(),J=new Map(),K=new Map(),L=new Map(),M=new Map(),N=new Map(),O=new Map(),P=(R,S)=>{const ah=af;O[ah(0x2a2)](R)?O[ah(0x241)](R)[ah(0x210)](S):O[ah(0x21f)](R,[S]);};G[af(0x11d)]((R,S)=>{const ai=af,T=R[ai(0x287)];P(T,S),I[ai(0x21f)](T,R[ai(0x14e)]),J[ai(0x21f)](T,R[ai(0x2e9)]),K[ai(0x21f)](T,Number(R[ai(0x26c)])||-0x1*0xc07+0x27c*-0xf+-0x1*-0x314b),L[ai(0x21f)](T,Number(R[ai(0x98)])||-0xf67*0x1+0xd3b*-0x1+0x2dd*0xa),M[ai(0x21f)](T,Number(R[ai(0x1f3)])||0x1*0x1f09+-0x54*-0x16+-0x2641);const U=R[ai(0x272)+ai(0x1ac)][ai(0x1e3)](',')[ai(0xcc)](W=>W[ai(0x2d5)]()),V=R[ai(0x2f2)+ai(0x308)][ai(0x1e3)](',')[ai(0xcc)](Number);N[ai(0x21f)](T,{'display':R[ai(0x18b)],'requiredFunc':R[ai(0xd3)+'nc'],'orderNo':R[ai(0x2c6)],'ignoreKeys':U,'ignoreButtons':V});}),this[af(0x146)+'ta']={'buttons':I,'keys':J},this[af(0x2ed)]={'tSwitches':K,'pSwitches':L,'rSwitches':M},this[af(0x15d)]={'buttons':new Map(Array[af(0x126)](I)),'keys':new Map(Array[af(0x126)](J))};const Q=[];N[af(0x11d)]((R,S)=>{const aj=af;R[aj(0x18b)]!==''&&Q[aj(0x210)]({'buttonName':S,'displayName':R[aj(0x18b)],'requiredFunc':R[aj(0xd3)+'nc'],'orderNo':R[aj(0x2c6)]});}),Q[af(0x14a)]((R,S)=>R[af(0x2c6)]-S[af(0x2c6)]),this[af(0x182)+'a']=N;}static[a6(0x13c)+a6(0xe7)](G){const al=a6,H=(R,S,T)=>{const ak=b;S!==''&&(R[ak(0x2a2)](S)?R[ak(0x241)](S)[ak(0x210)](T+(0x1e94+-0xed*0x9+-0xb1f*0x2)):R[ak(0x21f)](S,[T+(-0xe*-0x233+0x1e68+-0x3d31)]));},I=(R,S,T)=>{S!==0x2663+0x11bd+-0x3820&&H(R,S,T);},J=new Map(),K=new Map(),L=new Map(),M=new Map();G[al(0x11d)]((R,S)=>{const am=al;H(J,R[am(0x287)],S),H(K,R[am(0x14e)],S),H(L,R[am(0x2e9)],S),I(M,R[am(0x26c)],S),I(M,R[am(0x98)],S),I(M,R[am(0x1f3)],S);});const N=Array[al(0x126)](J[al(0x193)]());N[al(0x2a3)](R=>R[al(0x1b3)]>-0x1*-0x25fd+-0x12e*-0x8+-0x2f6c)&&(console[al(0x243)](al(0x118)+al(0x1ce)),J[al(0x11d)]((R,S)=>{const an=al;R[an(0x1b3)]>0x2*-0x4eb+-0x16b1+0x2088&&console[an(0x138)](an(0x23a)+S+(an(0xce)+'[')+R[an(0x11b)]()+']');}));const O=Array[al(0x126)](K[al(0x193)]());O[al(0x2a3)](R=>R[al(0x1b3)]>-0x140c+-0x3d6+0x17e3)&&(console[al(0x243)](al(0x118)+al(0x204)),K[al(0x11d)]((R,S)=>{const ao=al;R[ao(0x1b3)]>0x125*0x8+-0x1*0x713+0x2*-0x10a&&console[ao(0x138)](ao(0x103)+S+(ao(0xce)+'[')+R[ao(0x11b)]()+']');}));const P=Array[al(0x126)](M[al(0x193)]());P[al(0x2a3)](R=>R[al(0x1b3)]>0x1d9d+0x2131+-0x2bb*0x17)&&(console[al(0x243)](al(0x22d)+al(0xe6)),M[al(0x11d)]((R,S)=>{const ap=al;R[ap(0x1b3)]>-0x156*0x13+0x205b+-0x6f8&&console[ap(0x138)](ap(0x2b6)+S+(ap(0xce)+'[')+R[ap(0x11b)]()+']');}));const Q=Array[al(0x126)](L[al(0x193)]());Q[al(0x2a3)](R=>R[al(0x1b3)]>-0x2337+-0x22*-0x79+0x1326)&&(console[al(0x243)](al(0x237)+al(0x2e0)),L[al(0x11d)]((R,S)=>{const aq=al;R[aq(0x1b3)]>-0x16a2+0x1f6d+-0x8ca&&console[aq(0x138)](aq(0x2f7)+S+(aq(0xce)+'[')+R[aq(0x11b)]()+']');}));}static[a6(0x304)+a6(0x2a4)](){const ar=a6,G=this[ar(0x15d)],H=this[ar(0x146)+'ta'];H[ar(0x2c2)][ar(0x11d)]((I,J)=>G[ar(0x2c2)][ar(0x21f)](J,I));}static[a6(0x304)+a6(0x286)](){const as=a6,G=this[as(0x15d)],H=this[as(0x146)+'ta'];H[as(0xde)][as(0x11d)]((I,J)=>G[as(0xde)][as(0x21f)](J,I));}static[a6(0x304)+a6(0x227)](){const at=a6,G=this[at(0x233)](),H=this[at(0x146)+'ta'][at(0x241)]();H[at(0xde)][at(0x11d)]((I,J)=>G[at(0xde)][at(0x21f)](J,I)),H[at(0x2c2)][at(0x11d)]((I,J)=>G[at(0x2c2)][at(0x21f)](J,I));}static[a6(0x27b)+'ta'](){const au=a6,G=this[au(0x15d)],H=[],I=Array[au(0x126)](G[au(0xde)][au(0x2c2)]()),J=Array[au(0x126)](G[au(0xde)][au(0x193)]()),K=Array[au(0x126)](G[au(0x2c2)][au(0x193)]());for(let L=-0xb15*0x2+0x5*-0x56+-0x8*-0x2fb;L<J[au(0x1b3)];L++){H[au(0x210)]({'id':I[L],'button':J[L],'key':K[L]});}return H;}static[a6(0x136)+a6(0xd8)](G){const av=a6,H=this[av(0x15d)];G[av(0x11d)](I=>{const aw=av,J=I['id'];H[aw(0xde)][aw(0x21f)](J,I[aw(0x110)]),H[aw(0x2c2)][aw(0x21f)](J,I[aw(0x192)]);});}static[a6(0x1e9)](){const ax=a6;return this[ax(0x15d)][ax(0xde)];}static[a6(0x176)](){const ay=a6;return this[ay(0x15d)][ay(0x2c2)];}static[a6(0x2ce)+a6(0xa9)](){const az=a6;return this[az(0x15d)][az(0x174)];}static[a6(0x2f3)+a6(0x12c)](){const aA=a6;return this[aA(0x15d)][aA(0x238)];}static[a6(0x230)+a6(0x29f)](){const aB=a6;return this[aB(0x15d)][aB(0xd4)];}}window[a6(0x266)+'er']=p,p[a6(0xed)]();class q{static [a6(0x15d)];static[a6(0xed)](){const aC=a6;this[aC(0x276)]();}static[a6(0x276)](){const aD=a6,G=JSON[aD(0x2d9)](f[aD(0x2b5)+aD(0x1d2)]),H=G[aD(0x2b1)]===''?-0x137+-0xea2+0xfdf:Number(G[aD(0x2b1)]),I=JSON[aD(0x2d9)](G[aD(0x180)]);I[aD(0xa3)]=Number(I[aD(0xa3)])||0xb38*0x1+0xa8+-0xbdf,I[aD(0x29a)]=((()=>{const aE=aD,U=I[aE(0x29a)][aE(0x1e3)](',')[aE(0xcc)](Number);return U[aE(0x1b3)]===0xf46+-0x23cf+0x3*0x6d9?{'x':U[-0xbff+-0x12f0+0x1*0x1eef],'y':U[-0xecd+0xbb*0x5+0xb27]}:{'x':0x0,'y':0x0};})()),I[aD(0x12e)]=Number(I[aD(0x12e)])||0x5ca+-0x6a*0x17+0x6ec,I[aD(0x205)+aD(0xfd)]=I[aD(0x205)+aD(0xfd)]===aD(0x246);const J=p[aD(0x182)+'a'],K=JSON[aD(0x2d9)](G[aD(0x1fb)+'es']),L=K[aD(0x26f)],M=K[aD(0x289)+'e'],N=K[aD(0x162)+aD(0x1c7)],O=K[aD(0xad)],P=K[aD(0x125)+aD(0x122)],Q=U=>{const aF=aD;U[aF(0x23e)]=Number(U[aF(0x23e)])||0x7*0x95+-0x23fd+0x2044,U[aF(0x1ae)]=Number(U[aF(0x1ae)])||-0x21*0x123+0x1d8a+-0x1*-0x85d,U[aF(0x224)]=Number(U[aF(0x224)])||-0xe1f+0x1d32+0xf13*-0x1;},R=JSON[aD(0x2d9)](G[aD(0xa8)+'nd']);Q(R);const S=JSON[aD(0x2d9)](G[aD(0x2d6)+'d']);Q(S);const T=((()=>{const aG=aD,U=JSON[aG(0x2d9)](G[aG(0x2b4)+'y']);delete U[aG(0xcf)],delete U[aG(0x251)];const V=U[aG(0x29a)][aG(0x1e3)](',')[aG(0xcc)](Number);return U[aG(0x29a)]={'x':V[0x775*-0x2+-0x253b+0x3425*0x1],'y':V[0x824*-0x1+0x1*-0x1c2b+0x2450]},U[aG(0x1d0)]=U[aG(0x1d0)]===aG(0x246),U[aG(0x205)+aG(0xfd)]=U[aG(0x205)+aG(0xfd)]===aG(0x246),U[aG(0x22b)]=Number(U[aG(0x22b)])||-0x178c+-0x10ad+-0x2839*-0x1,U[aG(0x12e)]=Number(U[aG(0x12e)])||-0x383+0x1d35+-0x1682,U;})());this[aD(0x15d)]={'menuNo':H,'buttonList':J,'strInit':O,'strButtonType':P,'menuName':L,'padEditName':M,'keyboardEditName':N,'mappingSound':R,'buzzerSound':S,'layout':I,'message':T};}}q[a6(0xed)]();class r{static [a6(0x1b9)]=new Map();static [a6(0x275)+a6(0x269)]=-0xbdf+-0xf8b+0x1b6a;static [a6(0x1e0)+a6(0x1e4)]=Input[a6(0x258)+a6(0x199)];static [a6(0x1e0)+a6(0x178)]=Input[a6(0x1ff)+a6(0x2ca)];static [a6(0x295)+a6(0x280)]=n[a6(0x2ef)+a6(0x128)];static [a6(0x295)+a6(0x124)]=n[a6(0x2ef)+a6(0xaa)];static [a6(0x295)+a6(0x28b)+'v']=n[a6(0x2ef)+a6(0xa6)];static [a6(0x29d)+a6(0x15e)]=![];static [a6(0x22a)+'p'];static [a6(0x17c)+'p'];static [a6(0x300)+a6(0x2a0)]={'LS_UP':0x64,'LS_DOWN':0x65,'LS_LEFT':0x66,'LS_RIGHT':0x67,'RS_UP':0x68,'RS_DOWN':0x69,'RS_LEFT':0x6a,'RS_RIGHT':0x6b};static [a6(0xfc)+'ys']=new Set();static [a6(0x99)+a6(0x297)]=new Set();static [a6(0x296)];static [a6(0x27f)+a6(0xb9)];static [a6(0x9e)+a6(0x2e6)];static [a6(0xc3)+a6(0x152)];static [a6(0x14d)]=![];static [a6(0x1b6)+a6(0x19a)];static [a6(0x106)+a6(0x1ab)]=j[a6(0x24e)+'y'];static [a6(0x220)+a6(0x188)]=j[a6(0x252)+'s'];static [a6(0x189)+'e']=-0x14d9+0x7c3*0x3+-0x30*0xd;static [a6(0x1c9)]={'leftV':0x0,'leftH':0x0,'rightV':0x0,'rightH':0x0};static[a6(0xed)](){const aH=a6;this[aH(0x2dc)+'ol'](),this[aH(0x123)+'ap'](),this[aH(0x29e)+aH(0x202)+'te'](),document[aH(0x21a)+aH(0x9a)](aH(0x25e),this[aH(0x144)][aH(0x264)](this)),document[aH(0x21a)+aH(0x9a)](aH(0xaf),this[aH(0x26b)][aH(0x264)](this)),window[aH(0x21a)+aH(0x9a)](aH(0x1a6),this[aH(0xc2)+'us'][aH(0x264)](this));}static[a6(0x2dc)+'ol'](){const aI=a6,G=p[aI(0x15d)];this[aI(0x22a)+'p']=G[aI(0x2c2)],this[aI(0x17c)+'p']=G[aI(0xde)];const H=p[aI(0x2ed)];this[aI(0x27f)+aI(0xb9)]=H[aI(0x174)],this[aI(0x9e)+aI(0x2e6)]=H[aI(0x238)],this[aI(0xc3)+aI(0x152)]=H[aI(0xd4)],this[aI(0x22a)+'p'][aI(0x11d)]((I,J)=>{const aJ=aI;this[aJ(0x1b9)][aJ(0x21f)](J,{'pressed':![],'pressedTime':0x0,'prevPressed':![]});}),this[aI(0x17c)+'p'][aI(0x11d)]((I,J)=>{const aK=aI;this[aK(0x1b9)][aK(0x21f)](J,{'pressed':![],'pressedTime':0x0,'prevPressed':![]});});}static[a6(0x123)+'ap'](){const aL=a6,G=new Map(),H=JSON[aL(0x2d9)](f[aL(0x24a)+'ns']),I=p[aL(0x176)](),J=p[aL(0x1e9)]();for(let L in H){const M=H[L];(I[aL(0x2a2)](M)||J[aL(0x2a2)](M))&&G[aL(0x21f)](L,M);}const K=JSON[aL(0x2d9)](H[aL(0x2ee)])[aL(0xcc)](JSON[aL(0x2d9)]);K[aL(0x11d)](N=>{const aM=aL;(I[aM(0x2a2)](N[aM(0x240)])||J[aM(0x2a2)](N[aM(0x240)]))&&G[aM(0x21f)](N[aM(0x177)+'ol'],N[aM(0x240)]);}),this[aL(0x296)]=G;}static[a6(0x20e)](G=-0x24a*-0x7+0x745+0x174b*-0x1){const aN=a6;return navigator[aN(0x231)+'s']()[G];}static[a6(0x27d)+'d'](){const aO=a6;if(navigator[aO(0x231)+'s']()[aO(0x1b3)]<this[aO(0x275)+aO(0x269)])return navigator[aO(0x231)+'s']()[0x149a+-0x1*0x1229+-0x5*0x7d];return navigator[aO(0x231)+'s']()[this[aO(0x275)+aO(0x269)]];}static[a6(0x1f2)](G,H){const aP=a6,I=p[aP(0x176)]();if(!I[aP(0x2a2)](G))return;I[aP(0x21f)](G,H);}static[a6(0x160)+a6(0x17d)](G){const aQ=a6,H=p[aQ(0x176)]();if(!H[aQ(0x2a2)](G))return;H[aQ(0x21f)](G,'');}static[a6(0xd1)](G,H){const aR=a6,I=p[aR(0x1e9)]();if(!I[aR(0x2a2)](G))return;I[aR(0x21f)](G,H);}static[a6(0x160)+a6(0xd9)](G){const aS=a6,H=p[aS(0x1e9)]();if(!H[aS(0x2a2)](G))return;H[aS(0x21f)](G,'');}static[a6(0xdc)](G){const aT=a6;return this[aT(0x1b9)][aT(0x241)](G)[aT(0x25c)];}static[a6(0x151)+'d'](G){const aU=a6,H=this[aU(0x1b9)][aU(0x241)](G);return H[aU(0x25c)]&&H[aU(0x175)+'e']===0x169a+-0x20*-0x31+0xe5d*-0x2;}static[a6(0x19c)](G){const aV=a6,H=this[aV(0x1b9)][aV(0x241)](G);return H[aV(0x25c)]&&H[aV(0x175)+'e']===0x1*-0x24a7+0xd81+0xb93*0x2||H[aV(0x175)+'e']>=this[aV(0x1e0)+aV(0x1e4)]&&H[aV(0x175)+'e']%this[aV(0x1e0)+aV(0x178)]===-0x1*0x1a6e+-0x43*-0x4f+0x5c1;}static[a6(0x2bf)+a6(0x29c)](G,H=this[a6(0x1e0)+a6(0x1e4)]){const aW=a6;return this[aW(0x1b9)][aW(0x241)](G)[aW(0x175)+'e']>=H;}static[a6(0x144)](G){const aX=a6;r[aX(0x14d)]=![],this[aX(0xfc)+'ys'][aX(0x161)](G[aX(0x143)]);}static[a6(0x26b)](G){const aY=a6;r[aY(0x14d)]=![],this[aY(0xfc)+'ys'][aY(0x215)](G[aY(0x143)]);}static[a6(0xf3)](){const aZ=a6;try{this[aZ(0xc8)+aZ(0x1f4)]();const G=this[aZ(0x27d)+'d']();this[aZ(0xb5)+aZ(0x15f)](G),this[aZ(0x234)+aZ(0x1a3)](G),this[aZ(0xe5)+aZ(0x2a9)](),this[aZ(0x217)+aZ(0x232)]();}catch{}}static[a6(0xc8)+a6(0x1f4)](){const b0=a6,G=Input[b0(0x25b)+b0(0x172)][b0(0xa7)](H=>H[b0(0x187)](!![]));if(G===-(0x1*0x24f5+-0x1*0x1337+-0x11bd))return;r[b0(0x275)+b0(0x269)]=G;}static [a6(0x217)+a6(0x232)]=()=>{};static#isPressedKey(G){const b1=a6;return this[b1(0xfc)+'ys'][b1(0x2a2)](this[b1(0x22a)+'p'][b1(0x241)](G));}static[a6(0x265)+a6(0xae)](){const b2=a6;return this[b2(0xfc)+'ys'][b2(0xe3)]>0x203b+0x524*-0x2+-0x15f3;}static[a6(0x265)+a6(0x27c)+a6(0x2d1)](){const b3=a6;return this[b3(0x99)+b3(0x297)][b3(0xe3)]>0xb78+0x1cbf+-0x2837;}static#isPressedPadButtons(G){const b4=a6;return this[b4(0x99)+b4(0x297)][b4(0x2a2)](this[b4(0x17c)+'p'][b4(0x241)](G));}static[a6(0xe5)+a6(0x2a9)](){const b5=a6;this[b5(0x1b9)][b5(0x11d)]((G,H)=>{const b6=b5;G[b6(0x25c)]=this.#isPressedKey(H)||this.#isPressedPadButtons(H),this[b6(0xe5)+b6(0x1cd)](G);});}static[a6(0xe5)+a6(0x1cd)](G){const b7=a6;if(G[b7(0x25c)]&&!G[b7(0xdd)+'d'])G[b7(0x175)+'e']=0x72e+-0x2*0x9b1+0xc34;else G[b7(0x25c)]?G[b7(0x175)+'e']++:G[b7(0x175)+'e']=0x25d8+-0x138+0x20*-0x125;G[b7(0xdd)+'d']=G[b7(0x25c)];}static[a6(0x234)+a6(0x1a3)](G){const b8=a6;if(!G)return;const H=this[b8(0x99)+b8(0x297)];G[b8(0xde)][b8(0x11d)]((K,L)=>{const b9=b8;K[b9(0x2f9)]>0x167e+0x133a+-0x29b8||K[b9(0x25c)]?(r[b9(0x14d)]=!![],H[b9(0x161)](L)):H[b9(0x215)](L);});const I=this[b8(0x1c9)],J=this[b8(0x2ef)+b8(0x128)]();I[b8(0x257)]<=-J?H[b8(0x161)](this[b8(0x300)+b8(0x2a0)][b8(0x1d3)]):H[b8(0x215)](this[b8(0x300)+b8(0x2a0)][b8(0x1d3)]),I[b8(0x257)]>=J?H[b8(0x161)](this[b8(0x300)+b8(0x2a0)][b8(0x2ab)]):H[b8(0x215)](this[b8(0x300)+b8(0x2a0)][b8(0x2ab)]),I[b8(0x259)]<=-J?H[b8(0x161)](this[b8(0x300)+b8(0x2a0)][b8(0x1bf)]):H[b8(0x215)](this[b8(0x300)+b8(0x2a0)][b8(0x1bf)]),I[b8(0x259)]>=J?H[b8(0x161)](this[b8(0x300)+b8(0x2a0)][b8(0x127)]):H[b8(0x215)](this[b8(0x300)+b8(0x2a0)][b8(0x127)]),I[b8(0x167)]<=-J?H[b8(0x161)](this[b8(0x300)+b8(0x2a0)][b8(0x2cc)]):H[b8(0x215)](this[b8(0x300)+b8(0x2a0)][b8(0x2cc)]),I[b8(0x167)]>=J?H[b8(0x161)](this[b8(0x300)+b8(0x2a0)][b8(0x2a5)]):H[b8(0x215)](this[b8(0x300)+b8(0x2a0)][b8(0x2a5)]),I[b8(0x2f8)]<=-J?H[b8(0x161)](this[b8(0x300)+b8(0x2a0)][b8(0x195)]):H[b8(0x215)](this[b8(0x300)+b8(0x2a0)][b8(0x195)]),I[b8(0x2f8)]>=J?H[b8(0x161)](this[b8(0x300)+b8(0x2a0)][b8(0x2d7)]):H[b8(0x215)](this[b8(0x300)+b8(0x2a0)][b8(0x2d7)]);}static[a6(0x1de)+'ed'](G){const ba=a6;if(!G)return;G[ba(0x25c)]=![],G[ba(0xdd)+'d']=![],G[ba(0x175)+'e']=-0xbfb+-0x19ba+0x25b5;}static[a6(0xc2)+'us'](){const bb=a6;this[bb(0x1b9)][bb(0x11d)](G=>this[bb(0x1de)+'ed'](G)),this[bb(0xfc)+'ys'][bb(0x1e8)](),this[bb(0x99)+bb(0x297)][bb(0x1e8)]();}static[a6(0xf6)+a6(0xe2)](G){const bc=a6;if(this[bc(0x296)][bc(0x2a2)](G))return this[bc(0x296)][bc(0x241)](G);return'';}static[a6(0x1ef)+a6(0xe9)](G){const bd=a6,H=Array[bd(0x126)](this[bd(0x22a)+'p']),I=H[bd(0x20f)](J=>J[-0xb5*0x1d+0xa6*0x2+0x1336*0x1]===G);if(I)return I[-0x14e0*-0x1+0xc*0x1d8+-0x2b00];return'';}static[a6(0x1ef)+a6(0x279)](G){const be=a6,H=Array[be(0x126)](this[be(0x17c)+'p']),I=H[be(0x20f)](J=>J[-0xe98+0x1eba+0x1021*-0x1]===G);if(I)return I[-0x55c+0x1*0x13ea+-0xe8e];return'';}static[a6(0x9d)+a6(0xc5)](){const bf=a6;let G=this[bf(0x189)+'e']+(-0x189a+0x2*0xf42+-0x5e9);G>=this[bf(0x220)+bf(0x188)][bf(0x1b3)]&&(G=-0x1*0x4a3+0x1*-0xd+0x50*0xf),this[bf(0x189)+'e']=G,this[bf(0x29e)+bf(0x202)+'te']();}static[a6(0x29e)+a6(0x202)+'te'](){const bg=a6;this[bg(0x1b6)+bg(0x19a)]?this[bg(0x1b6)+bg(0x19a)][bg(0x2db)]=ImageManager[bg(0xf5)](r[bg(0xda)+bg(0x1e7)]()):this[bg(0x220)+bg(0x188)][bg(0x11d)](I=>{const bh=bg,J=new Sprite();J[bh(0x2db)]=ImageManager[bh(0xf5)](I);});const G=new o(),H=o[bg(0x25f)+'s']();G[bg(0xed)](H),this[bg(0x245)+bg(0x186)]=G;}static get[a6(0x245)+a6(0x186)](){const bi=a6;return this[bi(0x1b6)+bi(0x19a)];}static set[a6(0x245)+a6(0x186)](G){const bj=a6;this[bj(0x1b6)+bj(0x19a)]=G;}static[a6(0x149)](){const bk=a6;return this[bk(0x14d)];}static[a6(0x134)](){const bl=a6;return r[bl(0x17c)+'p'];}static[a6(0x2b7)](){const bm=a6;return r[bm(0x22a)+'p'];}static[a6(0x154)+a6(0x298)](){const bn=a6;return r[bn(0x27f)+bn(0xb9)];}static[a6(0xb8)+a6(0x26e)](G){const bo=a6;return Array[bo(0x126)](this[bo(0x134)]()[bo(0x2c2)]())[G];}static[a6(0x1db)+a6(0x2cb)](G){const bp=a6;if(!this[bp(0x134)]()[bp(0x2a2)](G))return-(0x1a4b+0x621*0x4+-0x1*0x32ce);return this[bp(0x134)]()[bp(0x241)](G);}static[a6(0xbf)+a6(0x1c6)](G){const bq=a6;return Array[bq(0x126)](this[bq(0x2b7)]()[bq(0x193)]())[G];}static[a6(0xbf)+'Id'](G){const br=a6;if(!this[br(0x2b7)]()[br(0x2a2)](G))return'';return this[br(0x2b7)]()[br(0x241)](G);}static[a6(0x2ce)+a6(0x27a)+'ex'](G){const bs=a6;return Array[bs(0x126)](this[bs(0x154)+bs(0x298)]()[bs(0x193)]())[G];}static[a6(0x2ce)+a6(0x23f)+a6(0x2cb)](G){const bt=a6;if(!this[bt(0x154)+bt(0x298)]()[bt(0x2a2)](G))return-0x5c7+-0x67f*-0x5+-0x1ab4;return this[bt(0x154)+bt(0x298)]()[bt(0x241)](G);}static[a6(0xda)+a6(0x1e7)](){const bu=a6,G=this[bu(0x189)+'e']<this[bu(0x220)+bu(0x188)][bu(0x1b3)]?this[bu(0x189)+'e']:-0x1c*0xa1+0x4*0x370+-0x3dc*-0x1;return this[bu(0x220)+bu(0x188)][G];}static [a6(0x2ef)+a6(0x128)]=()=>{};static [a6(0xb5)+a6(0x15f)]=G=>{const bv=a6;if(G){const H=G[bv(0x1c9)];this[bv(0x1c9)][bv(0x257)]=H[-0x3*0x976+0x171d+0x546],this[bv(0x1c9)][bv(0x259)]=H[0x5*-0x2c8+-0x1*0x185+-0xb*-0x167],this[bv(0x1c9)][bv(0x167)]=H[-0x16c3+0x1fd6+-0x1d*0x50],this[bv(0x1c9)][bv(0x2f8)]=H[0xb3f*-0x3+0x4fc*-0x4+0x5f7*0x9];}else this[bv(0x1c9)][bv(0x257)]=-0x610+-0x21b1+0x27c1,this[bv(0x1c9)][bv(0x259)]=0x4cf*-0x1+-0xf23*0x2+0x2315,this[bv(0x1c9)][bv(0x167)]=-0x1a10+0x1028+-0x4*-0x27a,this[bv(0x1c9)][bv(0x2f8)]=-0x1223+-0x2160+0x3383*0x1;this[bv(0xb5)+bv(0x24d)](G);};static [a6(0xb5)+a6(0x24d)]=()=>{};static[a6(0x112)+'el'](){const bw=a6;if(r[bw(0x296)][bw(0x2a2)]('ok')||r[bw(0x296)][bw(0x2a2)](bw(0x168)))return;this[bw(0x29d)+bw(0x15e)]=!this[bw(0x29d)+bw(0x15e)],this[bw(0x29d)+bw(0x15e)]?(Input[bw(0x30d)+bw(0xea)]['0']=bw(0x168),Input[bw(0x30d)+bw(0xea)]['1']='ok'):(Input[bw(0x30d)+bw(0xea)]['1']='ok',Input[bw(0x30d)+bw(0xea)]['0']=bw(0x168));}static[a6(0x12f)](){const bx=a6;return this[bx(0x1c9)][bx(0x257)];}static[a6(0xb6)](){const by=a6;return this[by(0x1c9)][by(0x259)];}static[a6(0x1d8)](){const bz=a6;return this[bz(0x1c9)][bz(0x167)];}static[a6(0x1f6)](){const bA=a6;return this[bA(0x1c9)][bA(0x2f8)];}}r[a6(0xed)](),window[a6(0x21d)]=r;n[a6(0x2ef)+a6(0xaa)]===-0x2*0x132b+0x17*0x3b+0x1*0x2109?r[a6(0x2ef)+a6(0x128)]=function(){const bB=a6;return this[bB(0x295)+bB(0x280)];}:r[a6(0x2ef)+a6(0x128)]=function(){const bC=a6;return Math[bC(0x19e)](-0x1*0x217d+0x1d00+-0x1*-0x47d+0.01,$gameVariables[bC(0x2f9)](this[bC(0x295)+bC(0x124)])/this[bC(0x295)+bC(0x28b)+'v']);};(n[a6(0x262)+'r']!==-0x20f8+0xa9*-0x18+-0x8*-0x61a||n[a6(0xc9)+a6(0x268)]!==-0x241a+-0x146*-0x11+0xe74||n[a6(0x153)+'r']!==0x1*-0xd4b+0x1775+-0xa2a*0x1||n[a6(0x25d)+a6(0x268)]!==-0xa18+0x162*-0x19+-0x2caa*-0x1)&&(i?r[a6(0xb5)+a6(0x24d)]=function(G){const bD=a6;if(G){const H=G[bD(0x1c9)],I=n[bD(0x129)+bD(0x117)];$gameVariables[bD(0x15d)][n[bD(0x262)+'r']]=Math[bD(0x17f)](H[-0x299+0x3*0x687+-0x10fb]*I),$gameVariables[bD(0x15d)][n[bD(0xc9)+bD(0x268)]]=Math[bD(0x17f)](H[-0x2*0x763+0xffb+-0x3*0x67]*I),$gameVariables[bD(0x15d)][n[bD(0x153)+'r']]=Math[bD(0x17f)](H[-0x13de+-0x222+0x17*0xf5]*I),$gameVariables[bD(0x15d)][n[bD(0x25d)+bD(0x268)]]=Math[bD(0x17f)](H[0x19bf+-0x1e5+-0x6d*0x38]*I);}else $gameVariables[bD(0x15d)][n[bD(0x262)+'r']]=0xf7*-0x1+0x134b*-0x1+0x1442*0x1,$gameVariables[bD(0x15d)][n[bD(0xc9)+bD(0x268)]]=-0x13*-0xa3+-0x13d9+0x7c0,$gameVariables[bD(0x15d)][n[bD(0x153)+'r']]=-0x15b2+-0x25bf*0x1+0x1*0x3b71,$gameVariables[bD(0x15d)][n[bD(0x25d)+bD(0x268)]]=-0xa9c+-0x1484+-0x18*-0x14c;}:r[a6(0xb5)+a6(0x24d)]=function(G){const bE=a6;if(G){const H=G[bE(0x1c9)],I=n[bE(0x129)+bE(0x117)];$gameVariables[bE(0x2f6)](n[bE(0x262)+'r'],H[0x1891+0x137c+-0x2c0c]*I),$gameVariables[bE(0x2f6)](n[bE(0xc9)+bE(0x268)],H[-0x91*0xd+-0x1*-0x1f0b+0xe*-0x1b1]*I),$gameVariables[bE(0x2f6)](n[bE(0x153)+'r'],H[0x1365+0x1*-0x1da9+0xa47]*I),$gameVariables[bE(0x2f6)](n[bE(0x25d)+bE(0x268)],H[-0xaba+-0x99b*-0x1+-0x121*-0x1]*I);}else $gameVariables[bE(0x2f6)](n[bE(0x262)+'r'],-0x1*0x70c+-0x184b+-0x71*-0x47),$gameVariables[bE(0x2f6)](n[bE(0xc9)+bE(0x268)],-0x1*-0xc23+-0x1*0x1b01+0xede),$gameVariables[bE(0x2f6)](n[bE(0x153)+'r'],0x1ad6+0x1b98+-0x1b37*0x2),$gameVariables[bE(0x2f6)](n[bE(0x25d)+bE(0x268)],-0xcf9+-0x4*-0x56f+-0x8c3);});i?r[a6(0x217)+a6(0x232)]=function(){const bF=a6;if(!$gameSwitches)return;this[bF(0x27f)+bF(0xb9)][bF(0x11d)]((G,H)=>{const bG=bF;$gameSwitches[bG(0x15d)][G]=this[bG(0xdc)](H);}),this[bF(0x9e)+bF(0x2e6)][bF(0x11d)]((G,H)=>{const bH=bF;$gameSwitches[bH(0x15d)][G]=this[bH(0x151)+'d'](H);}),this[bF(0xc3)+bF(0x152)][bF(0x11d)]((G,H)=>{const bI=bF;$gameSwitches[bI(0x15d)][G]=this[bI(0x19c)](H);});}:r[a6(0x217)+a6(0x232)]=function(){const bJ=a6;if(!$gameSwitches)return;this[bJ(0x27f)+bJ(0xb9)][bJ(0x11d)]((G,H)=>{const bK=bJ;$gameSwitches[bK(0x2f6)](G,this[bK(0xdc)](H));}),this[bJ(0x9e)+bJ(0x2e6)][bJ(0x11d)]((G,H)=>{const bL=bJ;$gameSwitches[bL(0x2f6)](G,this[bL(0x151)+'d'](H));}),this[bJ(0xc3)+bJ(0x152)][bJ(0x11d)]((G,H)=>{const bM=bJ;$gameSwitches[bM(0x2f6)](G,this[bM(0x19c)](H));});};const s=Input[a6(0xf3)];Input[a6(0xf3)]=function(){const bN=a6;r[bN(0xf3)](),s[bN(0x1eb)](this,arguments);};const t=Input[a6(0x151)+'d'];Input[a6(0x151)+'d']=function(G){const bO=a6,H=r[bO(0xf6)+bO(0xe2)](G);return H!==''?this[bO(0x1a7)+bO(0x22e)](G)&&this[bO(0x151)+'d'](bO(0x184))?!![]:r[bO(0x151)+'d'](H):t[bO(0x1eb)](this,arguments);};const u=Input[a6(0xdc)];Input[a6(0xdc)]=function(G){const bP=a6,H=r[bP(0xf6)+bP(0xe2)](G);return H!==''?this[bP(0x1a7)+bP(0x22e)](G)&&this[bP(0xdc)](bP(0x184))?!![]:r[bP(0xdc)](H):u[bP(0x1eb)](this,arguments);};const v=Input[a6(0x19c)];Input[a6(0x19c)]=function(G){const bQ=a6,H=r[bQ(0xf6)+bQ(0xe2)](G);return H!==''?this[bQ(0x1a7)+bQ(0x22e)](G)&&this[bQ(0x19c)](bQ(0x184))?!![]:r[bQ(0x19c)](H):v[bQ(0x1eb)](this,arguments);};const w=Input[a6(0x2bf)+a6(0x29c)];Input[a6(0x2bf)+a6(0x29c)]=function(G){const bR=a6,H=r[bR(0xf6)+bR(0xe2)](G);return H!==''?this[bR(0x1a7)+bR(0x22e)](G)&&this[bR(0x2bf)+bR(0x29c)](bR(0x184))?!![]:r[bR(0x2bf)+bR(0x29c)](H):w[bR(0x1eb)](this,arguments);};if(g){window[a6(0x21a)+a6(0x9a)](a6(0x25e),M=>{const bS=a6;console[bS(0x138)](bS(0x293)+M[bS(0x143)]+bS(0xbe)+M[bS(0x212)]);},!![]);const G=((()=>{const bT=a6,M=new Set(),N=JSON[bT(0x2d9)](f[bT(0x24a)+'ns']);for(let P in N){if(P===bT(0x2ee)){const Q=JSON[bT(0x2d9)](N[P])[bT(0xcc)](JSON[bT(0x2d9)]);Q[bT(0x11d)](R=>M[bT(0x161)](R[bT(0x177)+'ol']));}else M[bT(0x161)](P);}const O=Input[bT(0x20c)];for(let R in O){M[bT(0x161)](O[R]);}return M;})());r[a6(0x275)+a6(0x269)]=0x1fd+-0x71*0x51+-0x21c4*-0x1;const H=-0x779+0x26f*0x7+-0x974,I=0x33f*-0x2+0x26fa+-0x567*0x6,J=Scene_Map[a6(0x2fc)][a6(0x1aa)+a6(0xbb)];Scene_Map[a6(0x2fc)][a6(0x1aa)+a6(0xbb)]=function(){const bU=a6;J[bU(0x1eb)](this,arguments),this[bU(0x131)+bU(0x156)](),this[bU(0x2b3)+bU(0x157)]();},Scene_Map[a6(0x2fc)][a6(0x131)+a6(0x156)]=function(){const bV=a6,M=new Sprite();M[bV(0x2db)]=new Bitmap(Graphics[bV(0x12e)],Graphics[bV(0x104)]),M[bV(0x2db)][bV(0x2ba)]=0x1758*-0x1+0x1cc7+-0x547,this[bV(0x311)](M),this[bV(0x1c0)+bV(0x19a)]=M;};const K=Scene_Map[a6(0x2fc)][a6(0x2fa)];Scene_Map[a6(0x2fc)][a6(0x2fa)]=function(){const bW=a6;this[bW(0x2dd)+bW(0x156)](),K[bW(0x1eb)](this,arguments);},Scene_Map[a6(0x2fc)][a6(0x2dd)+a6(0x156)]=function(){const bX=a6,M=this[bX(0x1c0)+bX(0x19a)][bX(0x2db)];M[bX(0x1e8)](),M[bX(0x2ba)]=I;const N=r[bX(0x27d)+'d']()?r[bX(0x27d)+'d']()['id']:'';M[bX(0x285)](bX(0x2e3)+r[bX(0x275)+bX(0x269)]+']\x20'+N,-0x1*-0x1763+0x1*0x2429+-0x3b78,0x1fea+-0x575+0x1*-0x1a6b,0x1*0x166f+0xb4+-0x152f,-0xe0c+0xcac+0x188),M[bX(0x2ba)]=H;const O=Array[bX(0x126)](r[bX(0x22a)+'p'][bX(0x2c2)]())[bX(0x137)](Array[bX(0x126)](r[bX(0x17c)+'p'][bX(0x2c2)]())),P=new Set(O);let Q=0x15c9+0x2167+-0x371c,R=0x1f*-0xe3+0x1ecb+-0x326,S=0x1*-0xecb+0x53*0x49+0x818*-0x1,T=-0x210b+-0x87f+0x29b2;M[bX(0x2ba)]=I,M[bX(0x285)](bX(0x2fb)+']',Q,R,S,T),M[bX(0x2ba)]=H,R+=T,P[bX(0x11d)](W=>{const bY=bX;r[bY(0xdc)](W)&&(M[bY(0x285)](W,Q,R,S,T),R+=T);}),R=-0x2269+0xfd+-0x1c*-0x133;const U=0xf3*-0xf+-0x55+0xf5a,V=-0x1dfd+0x1085+0xe40;M[bX(0x2ba)]=I,M[bX(0x285)](bX(0x267),U,R,V,T),M[bX(0x2ba)]=H,R+=T,G[bX(0x11d)](W=>{const bZ=bX;Input[bZ(0xdc)](W)&&(M[bZ(0x285)](W,U,R,V,T),R+=T);}),this[bX(0x1b6)+bX(0x19a)]&&this[bX(0x1b6)+bX(0x19a)][bX(0x2c7)+'e'](Array[bX(0x126)](r[bX(0x99)+bX(0x297)])[0x35*-0x79+0x23f6+-0xae9]);},Scene_Map[a6(0x2fc)][a6(0x2b3)+a6(0x157)]=function(){const c0=a6,M=new o(),N=o[c0(0x25f)+'s']();M[c0(0xed)](N),M['x']=0xafe+0x11*0x22+-0xcb4*0x1,M['y']=0x2669+-0x310+-0x22f5,this[c0(0x311)](M),this[c0(0x1b6)+c0(0x19a)]=M;};const L=Scene_Map[a6(0x2fc)][a6(0x10c)];Scene_Map[a6(0x2fc)][a6(0x10c)]=function(){const c1=a6;this[c1(0x305)+c1(0xec)+'te'](),L[c1(0x1eb)](this,arguments);},Scene_Map[a6(0x2fc)][a6(0x305)+a6(0xec)+'te']=function(){const c2=a6,M=this[c2(0x1c0)+c2(0x19a)][c2(0x2db)];this[c2(0x1c0)+c2(0x19a)][c2(0x2db)]=null,M[c2(0x283)]();};}class x extends Scene_MenuBase{static[a6(0x25a)](){const c3=a6;SceneManager[c3(0x210)](x);}static [a6(0x23c)+'DE']={'BOTH':0x0,'ONLY_KEY':0x1,'ONLY_PAD':0x2};[a6(0x108)]=x[a6(0x23c)+'DE'][a6(0x18f)];[a6(0xa0)](){const c4=a6;if(!this[c4(0x1fe)+c4(0x29b)]){const M=q[c4(0x15d)][c4(0x180)];ImageManager[c4(0x20d)+'e'](M[c4(0x1d7)]),ImageManager[c4(0x20d)+'e'](M[c4(0x30b)]),this[c4(0x1fe)+c4(0x29b)]=!![];}return super[c4(0xa0)]();}[a6(0x1b4)+a6(0x9b)](){const c5=a6;super[c5(0x1b4)+c5(0x9b)]();const M=q[c5(0x15d)][c5(0x180)],N=new Sprite();N[c5(0x2db)]=ImageManager[c5(0x20d)+'e'](M[c5(0x1d7)]);const O=new Sprite();O[c5(0x2db)]=ImageManager[c5(0x20d)+'e'](M[c5(0x30b)]),this[c5(0x1bb)]={'key':N,'pad':O},N[c5(0x109)]=!![],O[c5(0x109)]=![],this[c5(0x311)](N),this[c5(0x311)](O);}[a6(0x116)](){const c6=a6;this[c6(0xf2)+'r'][c6(0x11b)]=()=>{const c7=c6;return c7(0x11a)+c7(0x1d5);},this[c6(0x299)]=q[c6(0x15d)];const M=q[c6(0x15d)];this[c6(0x18d)+'ta']=q[c6(0x15d)][c6(0xfb)],super[c6(0x116)](),this[c6(0xd5)+c6(0x24c)][c6(0x102)+c6(0x1d9)](()=>{const c8=c6;this[c8(0x2e1)]();});if(M[c6(0x162)+c6(0x1c7)]!==''&&M[c6(0x289)+'e']!=='')this[c6(0x120)+c6(0x1e6)](),this[c6(0x306)+c6(0x17b)+'ow'](),this[c6(0x306)+c6(0x2d2)+'ow'](),this[c6(0x108)]=x[c6(0x23c)+'DE'][c6(0x18f)];else{if(M[c6(0x162)+c6(0x1c7)]==='')this[c6(0x306)+c6(0x17b)+'ow'](),this[c6(0x108)]=x[c6(0x23c)+'DE'][c6(0x250)],this[c6(0x1bb)][c6(0x2ad)][c6(0x109)]=!![],this[c6(0x1bb)][c6(0x192)][c6(0x109)]=![];else M[c6(0x289)+'e']===''&&(this[c6(0x306)+c6(0x2d2)+'ow'](),this[c6(0x108)]=x[c6(0x23c)+'DE'][c6(0x290)],this[c6(0x1bb)][c6(0x2ad)][c6(0x109)]=![],this[c6(0x1bb)][c6(0x192)][c6(0x109)]=!![]);}this[c6(0x23b)+'ow']();switch(this[c6(0x108)]){case x[c6(0x23c)+'DE'][c6(0x18f)]:this[c6(0x218)+c6(0x190)][c6(0x2eb)](),this[c6(0x218)+c6(0x190)][c6(0x10a)](-0x8e*0x1b+0x479*-0x7+0x2e49);break;case x[c6(0x23c)+'DE'][c6(0x250)]:this[c6(0x114)+c6(0x208)][c6(0x2eb)](),this[c6(0x114)+c6(0x208)][c6(0x10a)](0x1d4a+-0x25f1+-0x8a7*-0x1);break;case x[c6(0x23c)+'DE'][c6(0x290)]:this[c6(0xeb)+c6(0x140)][c6(0x2eb)](),this[c6(0xeb)+c6(0x140)][c6(0x10a)](0xc29+-0x93d*-0x3+0xb*-0x3a0);break;}this[c6(0xcd)]='',this[c6(0xf1)+c6(0x9f)]();}[a6(0x1ba)+a6(0x2cd)+'t'](){const c9=a6,M=this[c9(0xb4)+'w'],N=this[c9(0x18d)+'ta'],O=((()=>{const ca=c9;if(this[ca(0x218)+ca(0x190)])return this[ca(0x218)+ca(0x190)][ca(0x29a)]['x'];else{if(this[ca(0xeb)+ca(0x140)])return this[ca(0xeb)+ca(0x140)][ca(0x29a)]['x'];else{if(this[ca(0x114)+ca(0x208)])return this[ca(0x114)+ca(0x208)][ca(0x29a)]['x'];}}})()),P=M[c9(0x1ea)];let Q=-0x4bd+0x846+-0x389;Q=Math[c9(0x19e)](Q,M[c9(0x1ea)](N[c9(0x313)+'ey'])[c9(0x104)]),Q=Math[c9(0x19e)](Q,M[c9(0x1ea)](N[c9(0x1a9)+'ad'])[c9(0x104)]),Q=Math[c9(0x19e)](Q,M[c9(0x1ea)](N[c9(0x171)+'ey'])[c9(0x104)]),Q=Math[c9(0x19e)](Q,M[c9(0x1ea)](N[c9(0x277)+'ad'])[c9(0x104)]),Q=Math[c9(0x19e)](Q,M[c9(0x1ea)](N[c9(0x277)+c9(0x1bd)])[c9(0x104)]),Q=Math[c9(0x19e)](Q,M[c9(0x1ea)](N[c9(0x277)+c9(0x13e)])[c9(0x104)]),Q=Math[c9(0x19e)](Q,M[c9(0x1ea)](N[c9(0x2c8)+'y'])[c9(0x104)]),Q=Math[c9(0x19e)](Q,M[c9(0x1ea)](N[c9(0xff)+'d'])[c9(0x104)]);const R=Graphics[c9(0x104)]-Q-(-0x2034+0x24b9+0x1*-0x47d),S=N[c9(0x12e)];M[c9(0x29a)]['x']=O+N[c9(0x29a)]['x'],M[c9(0x29a)]['y']=R+N[c9(0x29a)]['y'],M[c9(0x104)]=Q,M[c9(0x12e)]=S,M[c9(0x2ff)][c9(0x13d)](S,Q),N[c9(0x205)+c9(0xfd)]&&M[c9(0x2be)+c9(0x249)](0x1*0x115a+-0x1f1e+-0x2b*-0x52),!N[c9(0x1d0)]&&(M[c9(0x109)]=![]);}[a6(0xf1)+a6(0x9f)](){const cb=a6,M=this[cb(0x163)+cb(0x211)]();this[cb(0xb4)+'w']=new Window_Help(M),this[cb(0x1ba)+cb(0x2cd)+'t'](),this[cb(0x1af)](this[cb(0xb4)+'w']);}[a6(0x163)+a6(0x211)](){return new Rectangle(-0x3*-0x85f+0x16c3*0x1+-0xbf8*0x4,-0x4a9*-0x1+-0x2*-0x7bb+-0x141f,0x89a+0x1*0x2221+-0x2a93,0xeb+-0x1f83+0x2*0xf60);}[a6(0xf3)](){const cc=a6;super[cc(0xf3)](),this[cc(0x239)+cc(0x2c1)]();}[a6(0x1a8)](){const cd=a6;this[cd(0x299)]=q[cd(0x15d)];}[a6(0x120)+a6(0x1e6)](){const ce=a6,M=this[ce(0x292)+ce(0x222)+ce(0x294)](),N=new y(M);N[ce(0x30e)](ce(0x2e9),this[ce(0x2c0)+ce(0x101)][ce(0x264)](this)),N[ce(0x30e)](ce(0xc4),this[ce(0x17a)+ce(0xf0)][ce(0x264)](this)),N[ce(0x30e)](ce(0x168),this[ce(0x2e1)][ce(0x264)](this)),this[ce(0x218)+ce(0x190)]=N,this[ce(0x1af)](N);}[a6(0x292)+a6(0x222)+a6(0x294)](){const cf=a6,M=q[cf(0x15d)][cf(0x180)],N=M[cf(0x29a)],O=$gameSystem[cf(0x28a)+cf(0x150)]()/(0x815+0x2049+-0x285c),P=this[cf(0x1c5)+'p']()+N['y'],Q=M[cf(0x12e)]-O,R=Graphics[cf(0x12e)]/(0x2*0x133+-0x1827+0x15c3)-Q/(0x1664+-0x1d0e+0x6ac)-(0x1*0x127d+0x6*0x373+-0x272b)+N['x'],S=this[cf(0x2e8)+cf(0xee)](-0x102a+0x269*0xc+-0xcc1,!![]);return new Rectangle(R,P,Q,S);}[a6(0x306)+a6(0x2d2)+'ow'](){const cg=a6,M=this[cg(0xd6)+cg(0xa4)](0x10e0+0x192*-0x16+0x389*0x5),N=new z(M);N[cg(0x30e)](cg(0x168),this[cg(0x312)+cg(0x17d)][cg(0x264)](this)),this[cg(0xeb)+cg(0x140)]=N,N[cg(0x284)]();const O=this[cg(0x18d)+'ta'];N[cg(0x18d)+'ta']={'choice':O[cg(0x313)+'ey'],'input':O[cg(0x2c8)+'y'],'ignore':O[cg(0x171)+'ey'],'ignorePartner':O[cg(0x277)+cg(0x1bd)],'duration':O[cg(0x22b)]},this[cg(0x1af)](N);}[a6(0xd6)+a6(0xa4)](M=-0xaa4+-0xb1f+0x15c4){const ch=a6,N=q[ch(0x15d)][ch(0x180)],O=N[ch(0x29a)],P=q[ch(0x15d)],Q=$gameSystem[ch(0x28a)+ch(0x150)]()/(0x1*0xd2d+-0x8c9*-0x1+-0x15f4),R=this[ch(0x218)+ch(0x190)]?this[ch(0x218)+ch(0x190)]['y']+this[ch(0x218)+ch(0x190)][ch(0x104)]:this[ch(0x1c5)+'p']()+O['y'],S=N[ch(0x12e)]-Q,T=Graphics[ch(0x12e)]/(0x609+0x8e7*0x1+-0xeee)-S/(-0xc23+-0x1536+-0x1*-0x215b)-(-0x3bf+-0x17cb+0x1b8e)+O['x'],U=((()=>{const ci=ch;let Y=-0x876+-0x14e8+0x219*0xe;const Z=P[ci(0x1ed)];return Z[ci(0x11d)](a0=>{const cj=ci;a0[cj(0x18b)]!==''&&Y++;}),Y+M;})()),V=Math[ch(0x1c4)](U/P[ch(0x180)][ch(0xa3)]),W=Graphics[ch(0x104)]-R-Q,X=Math[ch(0x2da)](this[ch(0x2e8)+ch(0xee)](V,!![]),W);return new Rectangle(T,R,S,X);}[a6(0x306)+a6(0x17b)+'ow'](){const ck=a6,M=this[ck(0xd6)+ck(0xa4)](-0x43*-0x2f+-0x3*-0x69a+-0x2019),N=new A(M);N[ck(0x30e)](ck(0x168),this[ck(0x312)+ck(0xd9)][ck(0x264)](this)),N[ck(0x284)]();const O=this[ck(0x18d)+'ta'];N[ck(0x18d)+'ta']={'choice':O[ck(0x1a9)+'ad'],'input':O[ck(0xff)+'d'],'ignore':O[ck(0x277)+'ad'],'ignorePartner':O[ck(0x277)+ck(0x13e)],'duration':O[ck(0x22b)]},this[ck(0x114)+ck(0x208)]=N,this[ck(0x1af)](N);}[a6(0x312)+a6(0x17d)](){const cl=a6;this[cl(0x218)+cl(0x190)]?(this[cl(0xeb)+cl(0x140)][cl(0x10a)](-(-0x9*-0x2d2+0xb8d+-0x24ee)),this[cl(0x218)+cl(0x190)][cl(0x2eb)]()):this[cl(0x2e1)]();}[a6(0x312)+a6(0xd9)](){const cm=a6;this[cm(0x218)+cm(0x190)]?(this[cm(0x114)+cm(0x208)][cm(0x10a)](-(0x95e*0x3+-0x2095+0x1*0x47c)),this[cm(0x218)+cm(0x190)][cm(0x2eb)]()):this[cm(0x2e1)]();}[a6(0x2c0)+a6(0x101)](){const cn=a6;this[cn(0x218)+cn(0x190)][cn(0x284)](),this[cn(0x114)+cn(0x208)][cn(0x284)](),this[cn(0xeb)+cn(0x140)][cn(0x2eb)](),this[cn(0xeb)+cn(0x140)][cn(0x10a)](0x86*-0x17+-0x1617+0x2221);}[a6(0x17a)+a6(0xf0)](){const co=a6;this[co(0x218)+co(0x190)][co(0x284)](),this[co(0xeb)+co(0x140)][co(0x284)](),this[co(0x114)+co(0x208)][co(0x2eb)](),this[co(0x114)+co(0x208)][co(0x10a)](-0xfc4+-0x1f04+0x2ec8);}[a6(0x23b)+'ow'](){const cp=a6;if(!this[cp(0x218)+cp(0x190)]||!this[cp(0xeb)+cp(0x140)]||!this[cp(0x114)+cp(0x208)])return;this[cp(0x218)+cp(0x190)][cp(0xa5)]===-0x1da8+-0x1091*-0x1+0x1*0xd17?(this[cp(0xeb)+cp(0x140)][cp(0x109)]=!![],this[cp(0x114)+cp(0x208)][cp(0x109)]=![],this[cp(0x1bb)][cp(0x192)][cp(0x109)]=!![],this[cp(0x1bb)][cp(0x2ad)][cp(0x109)]=![]):(this[cp(0xeb)+cp(0x140)][cp(0x109)]=![],this[cp(0x114)+cp(0x208)][cp(0x109)]=!![],this[cp(0x1bb)][cp(0x2ad)][cp(0x109)]=!![],this[cp(0x1bb)][cp(0x192)][cp(0x109)]=![]);}[a6(0x2f4)+a6(0x1e1)](){return-0x798+-0xc*0x308+0x2bf8;}[a6(0x10c)](){const cq=a6;F[cq(0x19b)](),super[cq(0x10c)]();}[a6(0x239)+a6(0x2c1)](){const cr=a6;if(!this[cr(0xb4)+'w'][cr(0x2ff)])return;this[cr(0x218)+cr(0x190)]&&this[cr(0x218)+cr(0x190)][cr(0xdf)+cr(0xc1)]()&&(this[cr(0xcd)]=''),this[cr(0xb4)+'w'][cr(0x28f)](this[cr(0xcd)]);}}window[a6(0x11a)+a6(0x1d5)]=x;class y extends Window_HorzCommand{[a6(0x2c4)](M){const cs=a6;this[cs(0x299)]=q[cs(0x15d)],super[cs(0x2c4)](M),q[cs(0x15d)][cs(0x180)][cs(0x205)+cs(0xfd)]&&(this[cs(0x2be)+cs(0x249)](-0x598*0x4+0x3*-0x28e+0x2*0xf06),this[cs(0x148)+cs(0x18c)]=!![]),this[cs(0xf2)+'r'][cs(0x11b)]=()=>{const ct=cs;return ct(0x198)+ct(0x302)+ct(0x2ae);};}[a6(0x2af)](){return-0x60+-0x167*0xf+0x156b*0x1;}[a6(0x209)+a6(0x1bc)](){const cu=a6;this[cu(0x2e5)](this[cu(0x299)][cu(0x162)+cu(0x1c7)],cu(0x2e9),!![]),this[cu(0x2e5)](this[cu(0x299)][cu(0x289)+'e'],cu(0xc4),r[cu(0x27d)+'d']());}[a6(0xf3)](){const cv=a6;super[cv(0xf3)](),this[cv(0x234)+cv(0x225)]();}[a6(0x234)+a6(0x225)](){const cw=a6;if(!this[cw(0x263)])return;const M=this[cw(0x2b8)][0x53f*0x1+-0x1368+0xe2a][cw(0x1dd)],N=!!r[cw(0x27d)+'d']();this[cw(0x2b8)][-0x1e1+-0x1aa3+0x413*0x7][cw(0x1dd)]=N,M!==N&&this[cw(0x1f1)]();}[a6(0x10a)](M){const cx=a6;super[cx(0x10a)](M),this[cx(0xa5)]>=-0x10*0x1b1+-0x22e*0xe+0x3994&&SceneManager[cx(0x255)][cx(0x23b)+'ow']();}[a6(0x2d4)+a6(0x261)](M){const cy=a6;if(this[cy(0x148)+cy(0x18c)])return;super[cy(0x2d4)+cy(0x261)](M);}}window[a6(0x198)+a6(0x302)+a6(0x2ae)]=y;class z extends Window_Command{static [a6(0xfa)+a6(0x13f)]=a6(0x132)+a6(0x291)+a6(0x282);[a6(0x2c4)](M){const cz=a6;super[cz(0x2c4)](M),this[cz(0x255)]=SceneManager[cz(0x255)],this[cz(0x1d4)]=![],this[cz(0x299)]=q[cz(0x15d)],this[cz(0xe1)+cz(0x1b8)]=[],this[cz(0x2b2)+cz(0x26a)]=![],this[cz(0x108)]=cz(0x2ea),this[cz(0x12a)+cz(0x2c5)]=0x21fa+0x1208+0x3402*-0x1,this[cz(0x206)+cz(0x21c)],this[cz(0xb7)+cz(0x19f)]=-0x15bf+-0x1dd+0x179c*0x1,this[cz(0x155)](),q[cz(0x15d)][cz(0x180)][cz(0x205)+cz(0xfd)]&&(this[cz(0x2be)+cz(0x249)](-0x1d9b+-0x1bd2+-0x396f*-0x1),this[cz(0x148)+cz(0x18c)]=!![]),this[cz(0x10a)](-(-0x1bb0+0x1*-0x232b+0x3edc)),this[cz(0x284)](),this[cz(0x1f1)](),this[cz(0xf2)+'r'][cz(0x11b)]=()=>{const cA=cz;return cA(0x142)+cA(0x310)+'d';};}[a6(0x155)](){const cB=a6;this[cB(0x2cf)]=this[cB(0x299)][cB(0x1ed)],this[cB(0x26d)]=p[cB(0x176)](),this[cB(0x1ad)+'st']=r[cB(0xfc)+'ys'];}[a6(0xf9)](M){const cC=a6;M===cC(0x223)?this[cC(0x2f1)+cC(0x2ec)]():this[cC(0x2f1)+cC(0x214)](),this[cC(0x2b2)+cC(0x26a)]=!![],this[cC(0x108)]=M;}[a6(0xf3)](){const cD=a6;this[cD(0xac)+cD(0xc6)](),this[cD(0x235)+cD(0x260)](),this[cD(0x16d)+cD(0x1b7)]();if(this[cD(0x2b2)+cD(0x26a)])return;this[cD(0x108)]===cD(0x223)?this[cD(0x27e)+'t']():super[cD(0xf3)]();}[a6(0x235)+a6(0x260)](){const cE=a6;if(this[cE(0x12a)+cE(0x2c5)]===-0x1650+-0x188f+0x2edf)return;this[cE(0x12a)+cE(0x2c5)]--,this[cE(0x12a)+cE(0x2c5)]===0x560+-0x1583+0x1*0x1023&&(this[cE(0x1b0)]===cE(0x2ea)?this[cE(0x2f1)+cE(0x214)]():this[cE(0x2f1)+cE(0x2ec)]());}[a6(0x16d)+a6(0x1b7)](){const cF=a6;if(this[cF(0xb7)+cF(0x19f)]===-0xcf*-0x7+0x1c30+-0x1*0x21d9)return;this[cF(0xb7)+cF(0x19f)]--;}[a6(0x307)+'ed'](){const cG=a6;return this[cG(0x1ad)+'st'][cG(0xe3)]===-0xe6e+-0x1*-0x2547+0x16d9*-0x1;}[a6(0xac)+a6(0xc6)](){const cH=a6;this[cH(0x307)+'ed']()&&(this[cH(0x2b2)+cH(0x26a)]=![]);}[a6(0x201)+a6(0xc0)](){const cI=a6;return r[cI(0x265)+cI(0x27c)+cI(0x2d1)]();}[a6(0x27e)+'t'](){const cJ=a6,M=this[cJ(0x201)+cJ(0xc0)]();if(TouchInput[cJ(0x14c)+'d']()||M){SoundManager[cJ(0x1f8)](),this[cJ(0x1f0)+cJ(0xf7)]();return;}if(this[cJ(0xb7)+cJ(0x19f)]>-0x1*-0x9a1+-0x6*0x418+0xeef*0x1)return;if(this[cJ(0x307)+'ed']())return;const N=Array[cJ(0x126)](this[cJ(0x1ad)+'st'])[-0x1*-0x23f5+0x4bc+-0x28b1];this[cJ(0x278)+cJ(0x2aa)](this[cJ(0x206)+cJ(0x21c)],N)?(this[cJ(0x15c)+'g'](),this[cJ(0x1f0)+cJ(0xf7)]()):(this[cJ(0x11c)](),this[cJ(0xb7)+cJ(0x19f)]=-0x19cc+-0x1713+0x13*0x293);}[a6(0x1f0)+a6(0xf7)](){const cK=a6;this[cK(0xf9)](cK(0x2ea)),this[cK(0x1f1)](),this[cK(0x2eb)]();}[a6(0x2f1)+a6(0x214)](){const cL=a6;this[cL(0x12a)+cL(0x2c5)]=-0x1*0x1835+-0x1021*0x1+-0xd72*-0x3,this[cL(0x2f1)+'t'](this[cL(0x18d)+'ta'][cL(0x2ea)]);}[a6(0x2f1)+a6(0x2ec)](){const cM=a6;this[cM(0x12a)+cM(0x2c5)]=0x9b6*0x2+0x1*-0x23b1+0x1045,this[cM(0x2f1)+'t'](this[cM(0x18d)+'ta'][cM(0x223)]);}[a6(0x2f1)+a6(0x301)+'ou'](){const cN=a6;this[cN(0x2f1)+'t'](this[cN(0x18d)+'ta'][cN(0x28e)+cN(0x1a0)]),this[cN(0x12a)+cN(0x2c5)]=this[cN(0x18d)+'ta'][cN(0x22b)];}[a6(0x2f1)+a6(0x1c1)](){const cO=a6;this[cO(0x2f1)+'t'](this[cO(0x18d)+'ta'][cO(0x147)]),this[cO(0x12a)+cO(0x2c5)]=this[cO(0x18d)+'ta'][cO(0x22b)];}[a6(0x2f1)+'t'](M=''){const cP=a6;this[cP(0x255)][cP(0xcd)]=M;}[a6(0x1cc)+a6(0xf8)](M=''){const cQ=a6;this[cQ(0x255)][cQ(0xcd)][0x1*-0x353+-0x603+0x956]=M;}[a6(0x1cc)+a6(0x19d)](M=''){const cR=a6;this[cR(0x255)][cR(0xcd)][-0xb1d+-0x26a8+0x31c6]=M;}[a6(0x2a7)+'g'](){const cS=a6;p[cS(0x304)+cS(0x2a4)]();}[a6(0x2fe)+a6(0xb2)](){const cT=a6,M=this[cT(0x24b)+cT(0x2d3)]();M===z[cT(0xfa)+cT(0x13f)]?(this[cT(0x206)+cT(0x21c)]=null,this[cT(0x15c)+'g'](),this[cT(0x2a7)+'g'](),this[cT(0xf9)](cT(0x2ea)),this[cT(0x1f1)](),this[cT(0x2eb)]()):(this[cT(0x206)+cT(0x21c)]=M,this[cT(0xf9)](cT(0x223)));}[a6(0x13a)+a6(0x23d)](M,N){const cU=a6,O=this[cU(0x299)][cU(0x1ed)][cU(0x241)](M),P=O[cU(0x1b2)];return P[cU(0x187)](N);}[a6(0xd7)+a6(0xc0)](){const cV=a6;if(this[cV(0x108)]===cV(0x223))return;super[cV(0xd7)+cV(0xc0)]();}[a6(0x1d6)](){const cW=a6;return Math[cW(0x1c4)](this[cW(0x2b8)][cW(0x1b3)]/this[cW(0x2af)]());}[a6(0x2af)](){const cX=a6;return q[cX(0x15d)][cX(0x180)][cX(0xa3)];}[a6(0x197)+a6(0x1ee)](){const cY=a6;return cY(0x166);}[a6(0x244)](M){const cZ=a6,N=this[cZ(0xe1)+cZ(0x1b8)][M],O=this[cZ(0x2ac)+'ct'](M),P=this[cZ(0x197)+cZ(0x1ee)]();this[cZ(0x14b)+cZ(0x30a)](),this[cZ(0x1a1)+cZ(0x1f5)](this[cZ(0x248)+cZ(0x16c)](M));if(N[cZ(0x20a)]===this[cZ(0x299)][cZ(0xad)]){this[cZ(0x2ff)][cZ(0x2ba)]=0x239*-0xc+0x2*-0xae4+0x6f*0x70;const T=this[cZ(0x2ff)][cZ(0x135)];this[cZ(0x2ff)][cZ(0x135)]=ColorManager[cZ(0xb0)+'r'](),this[cZ(0x285)](N[cZ(0x20a)],O['x'],O['y'],O[cZ(0x12e)],cZ(0x24f)),this[cZ(0x2ff)][cZ(0x135)]=T;return;}const Q=O[cZ(0x12e)]*(0x106d+-0x9e3+-0x345*0x2+0.68);this[cZ(0x2ff)][cZ(0x2ba)]=-0x23f9+-0x17*0xfb+0x3aa2,this[cZ(0x285)](N[cZ(0x20a)],O['x'],O['y'],Q,P);const R=O[cZ(0x12e)]*(0x491*-0x7+-0x4*0x494+0x3247+0.3),S=O['x']+O[cZ(0x12e)]-R;this[cZ(0x285)](N[cZ(0x192)][cZ(0x200)](cZ(0x18e),''),S,O['y'],R,cZ(0x254));}[a6(0x209)+a6(0x1bc)](){const d0=a6;if(!this[d0(0x299)]||!this[d0(0xe1)+d0(0x1b8)])return;this[d0(0xe1)+d0(0x1b8)][d0(0x170)](-0xe8c+0x21ec+-0x28*0x7c);const M=[];this[d0(0x2cf)][d0(0x11d)]((N,O)=>{const d1=d0;if(N[d1(0x18b)]!==''){const P=this[d1(0x26d)][d1(0x241)](O),Q='['+P+']';M[d1(0x210)]({'caption':N[d1(0x18b)],'buttonId':O,'orderNo':N[d1(0x2c6)],'keyStr':Q});}}),M[d0(0x14a)]((N,O)=>N[d0(0x2c6)]-O[d0(0x2c6)]),M[d0(0x11d)](N=>{const d2=d0;this[d2(0x2e5)](N[d2(0x20a)],N[d2(0xb3)],!![]),this[d2(0xe1)+d2(0x1b8)][d2(0x210)]({'key':N[d2(0x1f7)],'caption':N[d2(0x20a)]});}),this[d0(0x2e5)](this[d0(0x299)][d0(0xad)],z[d0(0xfa)+d0(0x13f)],!![]),this[d0(0xe1)+d0(0x1b8)][d0(0x210)]({'key':'','count':'','caption':this[d0(0x299)][d0(0xad)]});}[a6(0x164)+'ey'](M){const d3=a6;return!M[d3(0xd3)+'nc'];}[a6(0x1ef)+a6(0x30c)](M){const d4=a6;return r[d4(0x1ef)+d4(0xe9)](M);}[a6(0x115)+a6(0x203)](M){const d5=a6;return M[d5(0x12d)];}[a6(0x278)+a6(0x2aa)](M,N){const d6=a6;if(this[d6(0x13a)+d6(0x23d)](M,N))return this[d6(0x2f1)+d6(0x1c1)](),![];const O=this[d6(0x2cf)],P=this[d6(0x1ef)+d6(0x30c)](N),Q=this[d6(0x26d)];if(M===P)return!O[d6(0x241)](M)[d6(0xd3)+'nc']?(this[d6(0x160)+d6(0x150)](M),!![]):!![];if(P==='')return this[d6(0x1fc)+d6(0x150)](M,N),!![];const R=this[d6(0x26d)][d6(0x241)](M);if(O[d6(0x241)](M)[d6(0xd3)+'nc']&&O[d6(0x241)](P)[d6(0xd3)+'nc'])return!this[d6(0x13a)+d6(0x23d)](P,R)?(this[d6(0x28d)+'g'](P,M,N),!![]):(this[d6(0x2f1)+d6(0x301)+'ou'](),![]);if(!O[d6(0x241)](M)[d6(0xd3)+'nc']&&!O[d6(0x241)](P)[d6(0xd3)+'nc']){const S=Q[d6(0x241)](M),T=Q[d6(0x241)](P);if(S!==''&&T!=='')return!this[d6(0x13a)+d6(0x23d)](P,R)?(this[d6(0x28d)+'g'](P,M,N),!![]):(this[d6(0x2f1)+d6(0x301)+'ou'](),![]);else{if(S==='')return this[d6(0x160)+d6(0x150)](P),this[d6(0x1fc)+d6(0x150)](M,N),!![];}return!![];}if(!O[d6(0x241)](P)[d6(0xd3)+'nc'])return Q[d6(0x241)](P)!==''&&(!this[d6(0x13a)+d6(0x23d)](P,R)?this[d6(0x28d)+'g'](P,M,N):this[d6(0x2f1)+d6(0x301)+'ou']()),!![];if(!O[d6(0x241)](M)[d6(0xd3)+'nc']){if(Q[d6(0x241)](M)==='')return this[d6(0x2f1)+d6(0x301)+'ou'](),![];else{if(Q[d6(0x241)](M)!==''){if(!this[d6(0x13a)+d6(0x23d)](P,R))return this[d6(0x28d)+'g'](P,M,N),!![];else this[d6(0x2f1)+d6(0x301)+'ou']();}return![];}}}[a6(0x1fc)+a6(0x150)](M,N){const d7=a6;r[d7(0x1f2)](M,N);}[a6(0x160)+a6(0x150)](M){const d8=a6;r[d8(0x160)+d8(0x17d)](M);}[a6(0x2df)+a6(0x2e4)](M,N,O){const d9=a6;r[d9(0x160)+d9(0x17d)](M),r[d9(0x1f2)](N,O);}[a6(0x28d)+'g'](M,N,O){const da=a6,P=this[da(0x26d)][da(0x241)](N);r[da(0x160)+da(0x17d)](P),r[da(0x160)+da(0x17d)](M),r[da(0x1f2)](M,P),r[da(0x1f2)](N,O);}[a6(0x15c)+'g'](){const db=a6;AudioManager[db(0x2fd)](q[db(0x15d)][db(0xa8)+'nd']);}[a6(0x11c)](){const dc=a6;AudioManager[dc(0x2fd)](q[dc(0x15d)][dc(0x2d6)+'d']);}[a6(0x2d4)+a6(0x261)](M){const dd=a6;if(this[dd(0x148)+dd(0x18c)])return;super[dd(0x2d4)+dd(0x261)](M);}[a6(0x2eb)](){const de=a6;this[de(0x18d)+'ta']&&this[de(0x2f1)+de(0x214)](),super[de(0x2eb)]();}}window[a6(0x142)+a6(0x310)+'d']=z;class A extends z{static [a6(0x107)+a6(0x194)]=a6(0x132)+a6(0x13b)+a6(0x2e7);static [a6(0x1da)+a6(0x181)]=j[a6(0x1ec)+a6(0x270)];[a6(0x2c4)](M){const df=a6;this[df(0xe1)+df(0x1b8)]=[],super[df(0x2c4)](M),this[df(0x1d4)]=![],this[df(0xf2)+'r'][df(0x11b)]=()=>{const dg=df;return dg(0x142)+dg(0x158)+'d';};}[a6(0x155)](){const dh=a6;this[dh(0x2cf)]=this[dh(0x299)][dh(0x1ed)],this[dh(0x26d)]=p[dh(0x1e9)](),this[dh(0x1ad)+'st']=r[dh(0x99)+dh(0x297)];}[a6(0x209)+a6(0x1bc)](){const di=a6;if(!this[di(0x299)]||!this[di(0xe1)+di(0x1b8)])return;super[di(0x209)+di(0x1bc)]();const M=this[di(0x2b8)][di(0xa7)](N=>N[di(0x119)]===z[di(0xfa)+di(0x13f)]);if(r[di(0x220)+di(0x188)][di(0x1b3)]>-0x1*-0x1a27+-0x1032+-0x9f4){const N=this[di(0x299)][di(0x125)+di(0x122)];this[di(0x2b8)][di(0x170)](M,0x19c3+-0x279+0xb*-0x21e,{'name':N,'symbol':A[di(0x107)+di(0x194)],'enabled':!![],'ext':''}),this[di(0xe1)+di(0x1b8)][di(0x170)](M,0x1*0x5ff+0x2558+-0x2b57,{'key':'','count':'','caption':N});}}[a6(0x201)+a6(0xc0)](){const dj=a6;return r[dj(0x265)+dj(0xae)]();}[a6(0x2fe)+a6(0xb2)](){const dk=a6,M=this[dk(0x24b)+dk(0x2d3)]();M===A[dk(0x107)+dk(0x194)]?(this[dk(0x206)+dk(0x21c)]=null,this[dk(0x15c)+'g'](),this[dk(0xef)+dk(0x10f)](),this[dk(0xf9)](dk(0x2ea)),this[dk(0x1f1)](),this[dk(0x2eb)]()):super[dk(0x2fe)+dk(0xb2)]();}[a6(0x13a)+a6(0x23d)](M,N){const dl=a6,O=this[dl(0x299)][dl(0x1ed)][dl(0x241)](M),P=O[dl(0x15b)+dl(0x2c9)];return P[dl(0x187)](N);}[a6(0xef)+a6(0x10f)](){const dm=a6;r[dm(0x9d)+dm(0xc5)](),this[dm(0x1f1)]();}[a6(0x2a7)+'g'](){const dn=a6;p[dn(0x304)+dn(0x286)]();}[a6(0x1ef)+a6(0x30c)](M){const dp=a6;return r[dp(0x1ef)+dp(0x279)](M);;}[a6(0x1fc)+a6(0x150)](M,N){const dq=a6;r[dq(0xd1)](M,N),this[dq(0x15c)+'g']();}[a6(0x160)+a6(0x150)](M){const dr=a6;r[dr(0x160)+dr(0xd9)](M),this[dr(0x15c)+'g']();}[a6(0x2df)+a6(0x2e4)](M,N,O){const ds=a6;r[ds(0x160)+ds(0xd9)](M),r[ds(0xd1)](N,O),this[ds(0x15c)+'g']();}[a6(0x28d)+'g'](M,N,O){const dt=a6,P=this[dt(0x26d)][dt(0x241)](N);r[dt(0x160)+dt(0xd9)](N),r[dt(0x160)+dt(0xd9)](M),r[dt(0xd1)](M,P),r[dt(0xd1)](N,O),this[dt(0x15c)+'g']();}[a6(0x244)](M){const du=a6,N=this[du(0xe1)+du(0x1b8)][M],O=this[du(0x2ac)+'ct'](M),P=this[du(0x197)+du(0x1ee)]();this[du(0x14b)+du(0x30a)](),this[du(0x1a1)+du(0x1f5)](this[du(0x248)+du(0x16c)](M));if(N[du(0x20a)]===this[du(0x299)][du(0xad)]){this[du(0x2ff)][du(0x2ba)]=0x912+-0x14f0+0x6*0x1ff;const a1=this[du(0x2ff)][du(0x135)];this[du(0x2ff)][du(0x135)]=ColorManager[du(0xb0)+'r'](),this[du(0x285)](N[du(0x20a)],O['x'],O['y'],O[du(0x12e)],du(0x24f)),this[du(0x2ff)][du(0x135)]=a1;return;}else{if(N[du(0x20a)]===this[du(0x299)][du(0x125)+du(0x122)]){this[du(0x2ff)][du(0x2ba)]=-0x47*-0x3+0x2554+0x33*-0xbf;const a2=this[du(0x2ff)][du(0x135)];this[du(0x2ff)][du(0x135)]=ColorManager[du(0xb0)+'r'](),this[du(0x285)](N[du(0x20a)],O['x'],O['y'],O[du(0x12e)],du(0x24f)),this[du(0x2ff)][du(0x135)]=a2;return;}}const Q=O[du(0x12e)]*(-0x24b5+-0x1d49+0x41fe+0.5);this[du(0x2ff)][du(0x2ba)]=-0x1*-0x351+-0x2f*0x22+0x309,this[du(0x285)](N[du(0x20a)],O['x'],O['y'],Q,P);const R=A[du(0x1da)+du(0x181)],S=O['x']+O[du(0x12e)]-R[du(0x12e)]-(-0x2*-0xc56+0x945+-0x21e9*0x1),T=N[du(0x192)][du(0x200)]('[','')[du(0x200)](']',''),U=r[du(0x245)+du(0x186)],V=U[du(0x2db)],W=U[du(0x221)][''+T];if(!W)return;const X=U[du(0x100)+'h'],Y=U[du(0x113)+'ht'],Z=W['x']*X,a0=W['y']*Y;this[du(0x2ff)][du(0x274)](V,Z,a0,X,Y,S+R['x'],O['y']-(-0x7e6+0x410+-0x3da*-0x1)+R['y'],R[du(0x12e)],R[du(0x104)]);}}window[a6(0x142)+a6(0x158)+'d']=A,Window_Base[a6(0x236)+a6(0x105)]=n[a6(0x14f)];const B=Window_Base[a6(0x2fc)][a6(0x2de)+a6(0x183)+'er'];Window_Base[a6(0x2fc)][a6(0x2de)+a6(0x183)+'er']=function(M,N){const dv=a6;B[dv(0x1eb)](this,arguments);switch(M){case Window_Base[dv(0x236)+dv(0x105)]:this[dv(0xba)+dv(0xbc)](this[dv(0x196)+dv(0x1df)+dv(0x21d)](N),N);break;}},Window_Base[a6(0x2fc)][a6(0x196)+a6(0x1df)+a6(0x21d)]=function(M){const dw=a6,N=/^\[.+?\]/,O=N[dw(0x179)](M[dw(0x2bb)][dw(0x1c3)](M[dw(0x10e)]));return O?(M[dw(0x10e)]+=O[-0x2055+0x410+0x1c45][dw(0x1b3)],O[-0x11b4+0xda2+0x412][dw(0xca)](-0x2*0x25f+0x45*-0x75+0x2448,O[0x293*-0x2+-0x85*-0x3+0x1*0x397][dw(0x1b3)]-(-0x2f*-0xa8+0x1391*0x1+-0x1934*0x2))):'';},Window_Base[a6(0x2fc)][a6(0xba)+a6(0xbc)]=function(M,N){const dx=a6;let O=0xba5+0x8fc+-0x14a1;if(N[dx(0x10d)]){if(!r[dx(0x149)]()){const P=N['x']+(-0x8dc+-0x121d*-0x2+0xdab*-0x2),Q=N['y'];O=this[dx(0x271)](M,P,Q)+(-0x1aab+-0x139b+-0x293*-0x12);}else{const R=N['x']+(-0xc9c+-0x3*0x93a+-0x1426*-0x2),S=N['y']+(0x11*0x198+-0xd0b+-0xe0b*0x1);this[dx(0x2d8)+dx(0x24c)](M,R,S),O=r[dx(0x106)+dx(0x1ab)][dx(0x12e)]+(-0x25ce+0x1*0x1ab7+0xb1b);}}N['x']+=O;},Window_Base[a6(0x2fc)][a6(0x2d8)+a6(0x24c)]=function(M,N,O){const dy=a6,P=r[dy(0x1db)+dy(0x2cb)](M);if(P===-(0x3*-0x67+0x17ee+-0x16b8))return;const Q=r[dy(0x245)+dy(0x186)],R=Q[dy(0x2db)],S=Q[dy(0x221)][''+P],T=Q[dy(0x100)+'h'],U=Q[dy(0x113)+'ht'],V=S['x']*T,W=S['y']*U,X=r[dy(0x106)+dy(0x1ab)],Y=X[dy(0x12e)],Z=X[dy(0x104)],a0=X['x'],a1=X['y'];this[dy(0x2ff)][dy(0x274)](R,V,W,T,U,N+a0,O-(-0x160*0x4+0x1336*0x2+-0x1d4*0x12)+a1,Y,Z);},Window_Base[a6(0x2fc)][a6(0x271)]=function(M,N,O){const dz=a6,P=this[dz(0x2ff)][dz(0x135)];this[dz(0x145)+dz(0x2d0)](ColorManager[dz(0x135)](n[dz(0xd2)+'or']));const Q=r[dz(0xbf)+'Id'](M),R=this[dz(0x2ff)][dz(0x2ba)],S='['+Q[dz(0x200)](dz(0x18e),'')+']',T=this[dz(0x159)](S);return this[dz(0x285)](S,N,O,T),this[dz(0x2ff)][dz(0x135)]=P,T;},PluginManager[a6(0xe4)+a6(0x247)](e,a6(0x228),M=>{const dA=a6;x[dA(0x25a)]();});const C=Window_MenuCommand[a6(0x2fc)][a6(0x209)+a6(0x1bc)];Window_MenuCommand[a6(0x2fc)][a6(0x209)+a6(0x1bc)]=function(){const dB=a6;C[dB(0x1eb)](this,arguments),this[dB(0x2f5)+dB(0x302)+dB(0x18a)]();},Window_MenuCommand[a6(0x2fc)][a6(0x2f5)+a6(0x302)+a6(0x18a)]=function(){const dC=a6;if(q[dC(0x15d)][dC(0x2b1)]===-(-0x95*0x35+0x1*0x222f+-0x355))return;const M=q[dC(0x15d)];this[dC(0x2b8)][dC(0x170)](M[dC(0x2b1)],0x1*-0x995+0x1b06+-0x1171,{'name':M[dC(0x26f)],'symbol':dC(0x1c8)+dC(0x229),'enabled':!![],'ext':''});};const D=Scene_Menu[a6(0x2fc)][a6(0x120)+a6(0x1e6)];Scene_Menu[a6(0x2fc)][a6(0x120)+a6(0x1e6)]=function(){const dD=a6;D[dD(0x1eb)](this,arguments),this[dD(0x218)+dD(0x190)][dD(0x30e)](dD(0x1c8)+dD(0x229),this[dD(0x2f0)+dD(0x219)][dD(0x264)](this));},Scene_Menu[a6(0x2fc)][a6(0x2f0)+a6(0x219)]=function(){const dE=a6;x[dE(0x25a)]();};const E=Scene_Boot[a6(0x2fc)][a6(0x173)+a6(0xe7)];Scene_Boot[a6(0x2fc)][a6(0x173)+a6(0xe7)]=function(){const dF=a6;E[dF(0x1eb)](this,arguments),F[dF(0x10b)]();};function F(){const dG=a6;throw new Error(dG(0x2bc)+dG(0x111)+'ss');}F[a6(0x10b)]=function(){const dH=a6;StorageManager[dH(0x191)](dH(0x16e)+dH(0x1d1))[dH(0x1be)](M=>this[dH(0x16a)](M||{}))[dH(0x2a6)](()=>0xb5*-0x12+0xa*0x2a5+-0x6dc*0x2)[dH(0x1be)](()=>{const dI=dH;return this[dI(0x253)]=!![],0x76*0x4+-0x2fa+0x122;})[dH(0x2a6)](()=>0x3*-0x631+-0x3*-0x3b0+0x1*0x783);},F[a6(0x19b)]=function(){const dJ=a6;StorageManager[dJ(0x1a4)](dJ(0x16e)+dJ(0x1d1),this[dJ(0x1c2)]());},F[a6(0x242)]=function(){const dK=a6;return this[dK(0x253)];},F[a6(0x1c2)]=function(){const dL=a6,M={};return M[dL(0x1e5)]=p[dL(0x27b)+'ta'](),M[dL(0x22f)+dL(0xbd)]=r[dL(0x189)+'e'],M;},F[a6(0x16a)]=function(M){const dM=a6;this[dM(0x2c3)+dM(0xab)](M),this[dM(0x2c3)+dM(0x1dc)+dM(0x28c)](M);},F[a6(0x2c3)+a6(0xab)]=function(M){const dN=a6;if(h)return;M[dN(0x1e5)]&&p[dN(0x136)+dN(0xd8)](M[dN(0x1e5)]);},F[a6(0x2c3)+a6(0x1dc)+a6(0x28c)]=function(M){const dO=a6;if(M[dO(0x22f)+dO(0xbd)]){const N=M[dO(0x22f)+dO(0xbd)];r[dO(0x189)+'e']=N,r[dO(0x29e)+dO(0x202)+'te']();}};k&&r[a6(0x112)+'el']();if(l){const M=Window_Selectable[a6(0x2fc)][a6(0x2a8)+a6(0xdb)];Window_Selectable[a6(0x2fc)][a6(0x2a8)+a6(0xdb)]=function(){const dP=a6,N=this[dP(0xa5)];M[dP(0x1eb)](this,arguments);if(N===this[dP(0xa5)]&&this[dP(0xdf)+dP(0xc1)]()){const O=this[dP(0x10e)]();v[dP(0x1a5)](Input,dP(0xfe))&&this[dP(0x1e2)](t[dP(0x1a5)](Input,dP(0xfe))),v[dP(0x1a5)](Input,'up')&&this[dP(0x12b)](t[dP(0x1a5)](Input,'up')),v[dP(0x1a5)](Input,dP(0x254))&&this[dP(0x9c)+'t'](t[dP(0x1a5)](Input,dP(0x254))),v[dP(0x1a5)](Input,dP(0x166))&&this[dP(0x141)](t[dP(0x1a5)](Input,dP(0x166))),this[dP(0x10e)]()!==O&&this[dP(0xf4)+dP(0x11e)]();}};}((()=>{const dQ=a6,N=JSON[dQ(0x2d9)](f[dQ(0x165)+'e']),O=Input[dQ(0x20c)],P=(Q,R)=>{const dR=dQ;if(N[Q]!==''){for(let S in O){O[S]===R&&delete O[S];}Input[dR(0x20c)][N[Q]]=R;}};P('ok','ok'),P(dQ(0x184),dQ(0x184)),P(dQ(0x16b),dQ(0x16b)),P(dQ(0xc7),dQ(0xc7)),P('up','up'),P(dQ(0xfe),dQ(0xfe)),P(dQ(0x166),dQ(0x166)),P(dQ(0x254),dQ(0x254)),P(dQ(0x288),dQ(0x288));if(N[dQ(0x130)]!==''&&N[dQ(0x168)]!==''){for(let Q in O){O[Q]===dQ(0x184)&&delete O[dQ(0x184)];}P(dQ(0x130),dQ(0x130)),P(dQ(0x168),dQ(0x168));}})());if(m){const N=Window_Selectable[a6(0x2fc)][a6(0x22c)+a6(0x1b5)];Window_Selectable[a6(0x2fc)][a6(0x22c)+a6(0x1b5)]=function(){const dS=a6;return Input[dS(0x19c)](dS(0x130))||N[dS(0x1eb)](this,arguments);};}}})()));