/*:
 * @target MZ
 * @plugindesc フェードイン・フェードアウト中はクリック（タッチ）を無効化します。
 * @author トリアコンタン MarkⅡ
 * @help
 * シーンのフェードイン中（fadeSign === 1）
 * フェードアウト中（fadeSign === -1）
 * の両方において、fadeDuration > 0 の間はクリックを受け付けません。
 *
 * インストール:
 *  1. このファイルを js/plugins/DisableClickDuringFadeOut.js として保存
 *  2. プラグイン管理で有効化
 *
 * 備考:
 *  - キーボード・ゲームパッド入力はそのまま（必要なら拡張可）。
 *  - シーン遷移中の誤クリック防止に適しています。
 */

(() => {
  "use strict";

  // フェードイン or フェードアウト中か判定
  function isSceneFading() {
    const s = SceneManager._scene;
    // fadeSign は 1（フェードイン） or -1（フェードアウト）
    return !!(s && s._fadeDuration > 0 && (s._fadeSign === 1 || s._fadeSign === -1));
  }

  // TouchInput のクリック系メソッドをフェード中は無効化
  const _TouchInput_isTriggered = TouchInput.isTriggered;
  TouchInput.isTriggered = function() {
    if (isSceneFading()) return false;
    return _TouchInput_isTriggered.call(this);
  };

  const _TouchInput_isPressed = TouchInput.isPressed;
  TouchInput.isPressed = function() {
    if (isSceneFading()) return false;
    return _TouchInput_isPressed.call(this);
  };

  const _TouchInput_isLongPressed = TouchInput.isLongPressed;
  TouchInput.isLongPressed = function() {
    if (isSceneFading()) return false;
    return _TouchInput_isLongPressed.call(this);
  };

  // 必要なら isClicked も無効化できます
  // const _TouchInput_isClicked = TouchInput.isClicked;
  // TouchInput.isClicked = function() {
  //   if (isSceneFading()) return false;
  //   return _TouchInput_isClicked.call(this);
  // };

})();
