//=============================================================================
// RPG Maker MZ - GRKT_MessageWindow
//=============================================================================

/*:
 * @target MZ
 * @plugindesc メッセージウィンドウ
 * @author MUMAMOMEMU
 * @url https://mumamomemu.booth.pm/
 * @base GRKT_Base
 * @orderAfter GRKT_Base
 *
 * @help GRKT_MessageWindow.js(ver1.0.0)
 *
 *
 * --------------------------
 * ■利用規約
 *
 * Copyright (c) 2023 MUMAMOMEMU
 * https://star-write-dream.com/
 *
 * 以下に定める条件に従い、本プラグインファイル（以下「ソフトウェア」）の
 * 購入者に対し、ソフトウェアを変更し、
 * 購入者の制作する作品（以下、制作物）に組み込むことを許可します。
 * 制作物の内容および公開形式に制約はありません。
 *
 * ソフトウェア単体で掲載、頒布、共有することはできません。
 * 上記の著作権表示および本許諾表示は変更できず、削除もできません。
 * 別途、制作物の重要な箇所にソフトウェアの著作権表示をする必要はありません。
 *
 * ソフトウェアは「現状のまま」で、明示であるか暗黙であるかを問わず、
 * 何らの保証もなく提供されます。ここでいう保証とは、商品性、
 * 特定の目的への適合性、および権利非侵害についての保証も含みますが、
 * それに限定されるものではありません。作者または著作権者は、契約行為、
 * 不法行為、またはそれ以外であろうと、ソフトウェアに起因または関連し、
 * あるいはソフトウェアの使用またはその他の扱いによって生じる一切の請求、
 * 損害、その他の義務について何らの責任も負わないものとします。
 * --------------------------
 *
 * @param testMode
 * @type boolean
 * @text テストモード
 * @desc 調整用にメッセージウィンドウを表示します。
 * @default false
 *
 * @param font
 * @type string
 * @text フォント
 * @desc
 * @default ----------------
 *
 * @param fonts
 * @parent font
 * @type string[]
 * @text フォントリスト
 * @desc fontsフォルダ内のフォントを指定します。拡張子を含めます。（標準：mplus-1m-regular.woff）
 * @default ["mplus-1m-regular.woff"]
 *
 * @param fontTag
 * @parent font
 * @type string
 * @text タグ
 * @desc フォント用のタグ文字を指定します。大文字小文字は無視されます。
 * @default ff
 *
 * @param ruby
 * @type string
 * @text ルビ
 * @desc
 * @default ----------------
 *
 * @param rubyList
 * @parent ruby
 * @type struct<RubyData>[]
 * @text ルビリスト
 * @desc ルビリストを登録します
 * @default ["{\"targetStr\":\"漢字\",\"rubyStr\":\"かんじ\"}"]
 *
 * @param rubyTag
 * @parent ruby
 * @type string
 * @text タグ
 * @desc ルビ用のタグ文字を指定します。大文字小文字は無視されます。
 * @default r
 *
 * @command setupMessage
 * @text 設定変更
 * @desc メッセージウィンドウ・名前欄の設定を変更します。
 *
 * @arg msgWindow
 * @type string
 * @text メッセージウィンドウ
 * @desc
 * @default ----------------
 *
 * @arg windowSize
 * @parent msgWindow
 * @type string
 * @text サイズ
 * @desc メッセージウィンドウの横幅,高さを指定します。
 * @default 808,224
 *
 * @arg windowPos
 * @parent msgWindow
 * @type string[]
 * @text ウィンドウの位置調整
 * @desc X,Yで調整値を指定します。上中下の順に3件登録します。
 * @default ["0,0","0,0","0,0"]
 *
 * @arg bgImage
 * @parent msgWindow
 * @type file
 * @dir img/system
 * @text 背景画像
 * @desc メッセージウィンドウに背景画像を設定します。
 * @default
 *
 * @arg bgPos
 * @parent msgWindow
 * @type string[]
 * @text 背景画像の位置調整
 * @desc X,Yで調整値を指定します。上中下の順に3件登録します。
 * @default ["0,0","0,0","0,0"]
 *
 * @arg nameBox
 * @type string
 * @text 名前欄
 * @desc
 * @default ----------------
 *
 * @arg nameBoxPos
 * @parent nameBox
 * @type string[]
 * @text 位置調整
 * @desc X,Yで調整値を指定します。上中下の順に3件登録します。
 * @default ["0,0","0,0","0,0"]
 *
 * @arg nameBoxWidth
 * @parent nameBox
 * @type string
 * @text 幅と寄せ方
 * @desc 0以下だとシステム標準と同様、文字数に応じて拡張します。寄せ方はleft,center,rightのいずれかです。
 * @default 0,left
 *
 * @arg font
 * @type string
 * @text フォント
 * @desc
 * @default ----------------
 *
 * @arg fontFamily
 * @parent font
 * @type number
 * @text 本文フォント
 * @desc 本文のフォントをフォントリストの番号（先頭1番）で指定します。
 * @default 1
 * @min 1
 *
 * @arg fontSize
 * @parent font
 * @type number
 * @text 本文フォントサイズ
 * @desc 本文のフォントサイズを指定します。
 * @default 26
 *
 * @arg nameFontFamily
 * @parent font
 * @type number
 * @text 名前欄フォント
 * @desc 名前欄のフォントをフォントリストの番号（先頭1番）で指定します。
 * @default 1
 * @min 1
 *
 * @arg nameFontSize
 * @parent font
 * @type number
 * @text 名前欄フォントサイズ
 * @desc 名前欄のフォントサイズを指定します。
 * @default 26
 *
 * @arg ruby
 * @type string
 * @text ルビ
 * @desc
 * @default ----------------
 *
 * @arg rubySize
 * @parent ruby
 * @type number
 * @text ルビサイズ
 * @desc 本文のフォントサイズに対する比率を指定します。
 * @default 0.4
 * @max 10
 * @min 0
 * @decimals 1
 *
 * @arg rubyLineSpacing
 * @parent ruby
 * @type number
 * @text 行間調整
 * @desc 行間を調整する値を指定します。
 * @default 0
 * @max 9999
 * @min -9999
 *
 * @arg rubySpacing
 * @parent ruby
 * @type number
 * @text 本文とルビの間隔
 * @desc 本文とルビの間隔を調整する値を指定します。
 * @default 2
 * @max 9999
 * @min -9999
 *
 * @arg faceImage
 * @type string
 * @text 顔画像
 * @desc
 * @default ----------------
 *
 * @arg facePos
 * @parent faceImage
 * @type string
 * @text 位置調整
 * @desc X,Yで調整値を指定します。
 * @default 0,0
 *
 * @command nextMessage
 * @text 次回メッセージの差し替え
 * @desc 次回の「文章の表示」の内容を差し替えます。
 *
 * @arg message
 * @type multiline_string
 * @text メッセージ
 * @desc メッセージを入力します。
 * @default
 *
 */
/*~struct~RubyData:
 *
 * @param targetStr
 * @type string
 * @text 対象文字
 * @desc ルビを振りたい文字
 * @default 漢字
 *
 * @param rubyStr
 * @type string
 * @text ルビ文字
 * @desc ルビ
 * @default かんじ
 *
 */

function b(c,d){const e=a();return b=function(f,g){f=f-(-0xd6+0x16*-0x77+0xce8);let h=e[f];return h;},b(c,d);}(function(c,d){const L=b,e=c();while(!![]){try{const f=-parseInt(L(0x231))/(-0x9fe+0x1*0xf9+-0x16*-0x69)+parseInt(L(0x276))/(0x17*-0x3a+-0x13a+-0x339*-0x2)*(-parseInt(L(0x278))/(-0x11*-0x246+0x1*-0x2239+0x46a*-0x1))+-parseInt(L(0x243))/(-0x7d3+-0x2059+-0x4*-0xa0c)+parseInt(L(0x1f4))/(-0x1c4b*0x1+0x2657+-0xa07)+parseInt(L(0x240))/(-0x1*0x1e17+0x9d8+0x1445*0x1)*(-parseInt(L(0x20f))/(0x1640+-0x1728+0xef))+-parseInt(L(0x208))/(0x1d10+-0xfce+-0xd3a)*(-parseInt(L(0x1d8))/(-0x3*0x59f+-0x2229+0x330f))+-parseInt(L(0x289))/(0x5bf*0x6+-0x25c2+0x1a9*0x2)*(-parseInt(L(0x1f1))/(0x1*0x31d+-0x1ce9+-0x87*-0x31));if(f===d)break;else e['push'](e['shift']());}catch(g){e['push'](e['shift']());}}}(a,-0x532e6+0x61*-0x3dcf+0x2bd0b3),((()=>{'use strict';const M=b;const c=document[M(0x22b)+M(0x242)],d=PluginManagerEx[M(0x288)+M(0x21c)](c);GRKT_Util[M(0x220)+'n'](M(0x26a)+M(0x24b)+M(0x27f)+M(0x25f)+M(0x225)+M(0x280),c);const e=M(0x1fe)+M(0x241);GRKT_Util[M(0x23f)][M(0x27b)]=d[M(0x27b)],d[M(0x27b)]=d[M(0x27b)][M(0x22f)+'e'](),d[M(0x1f9)]=d[M(0x1f9)][M(0x22f)+'e'](),d[M(0x284)]=d[M(0x284)][M(0x279)]((u,v)=>v[M(0x277)][M(0x1f8)]-u[M(0x277)][M(0x1f8)]),PluginManagerEx[M(0x216)+M(0x1e0)](c,M(0x25d)+'ge',u=>{const N=M,v=u[N(0x1f3)][N(0x20e)](',')[N(0x1f2)](Number),x=u[N(0x271)][N(0x1f2)](F=>F[N(0x20e)](',')[N(0x1f2)](Number)),y=u[N(0x26d)][N(0x1f2)](F=>F[N(0x20e)](',')[N(0x1f2)](Number)),z=u[N(0x218)][N(0x1f2)](F=>F[N(0x20e)](',')[N(0x1f2)](Number)),A=u[N(0x1de)][N(0x20e)](',')[N(0x1f2)](Number),B=u[N(0x1e4)+'th'][N(0x20e)](','),C=Number(B[-0xc7*-0x10+-0x54b*-0x3+-0x1c51]),D=GRKT_Util[N(0x256)+N(0x269)](B[-0x1e3d*0x1+0x25c3+-0xaf*0xb][N(0x228)]());$gameScreen[N(0x27e)+N(0x24d)][N(0x223)]=v,$gameScreen[N(0x27e)+N(0x24d)][N(0x24f)]=x,$gameScreen[N(0x27e)+N(0x24d)][N(0x22c)]=y,$gameScreen[N(0x27e)+N(0x24d)][N(0x218)]=z,$gameScreen[N(0x27e)+N(0x24d)][N(0x267)]=u[N(0x267)],ImageManager[N(0x1e2)]($gameScreen[N(0x27e)+N(0x24d)][N(0x267)]),$gameScreen[N(0x27e)+N(0x24d)][N(0x1de)]=A,$gameScreen[N(0x27e)+N(0x24d)][N(0x1e4)+'th']=C,$gameScreen[N(0x27e)+N(0x24d)][N(0x27a)+'gn']=D,$gameScreen[N(0x23e)][N(0x23a)]=u[N(0x23a)],$gameScreen[N(0x23e)][N(0x20b)+'g']=u[N(0x21b)+N(0x252)],$gameScreen[N(0x23e)][N(0x219)+'g']=u[N(0x219)+'g'],$gameScreen[N(0x229)][N(0x258)]=u[N(0x258)],$gameScreen[N(0x229)][N(0x237)]=u[N(0x237)],$gameScreen[N(0x229)][N(0x233)+N(0x22a)]=u[N(0x233)+N(0x22a)],$gameScreen[N(0x229)][N(0x230)+'ze']=u[N(0x230)+'ze'];const E=SceneManager[N(0x27c)][N(0x215)+N(0x1e1)];E&&(E['x']=(Graphics[N(0x21f)]-v[-0x3d*-0x5+-0x6db+0x5aa])/(-0x10af+-0xb*-0x33f+-0x1304*0x1));});const f=Game_Message[M(0x217)][M(0x1fd)];Game_Message[M(0x217)][M(0x1fd)]=function(){const O=M;f[O(0x202)](this,arguments),this[O(0x26b)+O(0x205)]='';},PluginManagerEx[M(0x216)+M(0x1e0)](c,M(0x25a)+'e',u=>{const P=M;$gameMessage[P(0x26b)+P(0x205)]=u[P(0x1eb)];});const g=Game_Screen[M(0x217)][M(0x264)];Game_Screen[M(0x217)][M(0x264)]=function(){const Q=M;g[Q(0x202)](this,arguments),this[Q(0x27e)+Q(0x24d)]={'wSize':[-0x6f7*-0x1+0x805*-0x3+0x1440,0x18d1*-0x1+-0x469+0x1e1a],'wPos':[[0x1a1f+0x22b9+-0x3cd8,-0x1fdc*-0x1+0x1f*0x9d+-0x10f5*0x3],[-0x1f9+0x2324+0x212b*-0x1,-0x8*-0x6+0x1*-0x16fc+0x16cc],[0x89*-0x27+-0x942+0x359*0x9,-0x10b4+0x11e6+-0x132]],'nPos':[[-0x33b+-0x21fb+0x2536*0x1,0x1*0xe9b+-0x9*-0x33d+0x38*-0xc8],[0x22c4+0xcd9+-0x11*0x2cd,0x1fd0+0xb*-0x2e0+-0x30],[0x12f0+0x1c00+0x1778*-0x2,0x2cf+-0x91a*-0x2+-0x1503]],'bgPos':[[-0x1dd1+-0x61*-0x1f+0x202*0x9,-0x1e24+-0x1*0x2f7+0x211b],[-0x2278+-0xfa2+0x321a,0xcda+0x21e6+-0x16*0x220],[-0x436+-0x2602+-0x182*-0x1c,-0x1*-0x598+0x487*-0x8+0x1ea0]],'bgImage':'','facePos':[0x12fa+0x1*-0x62d+-0xccd,0xfef+0x1511*0x1+-0x2500],'nameBoxWidth':0x0,'nameBoxAlign':Q(0x1ec)},this[Q(0x23e)]={'rubySize':0.4,'lineSpacing':0x0,'rubySpacing':0x2},this[Q(0x229)]={'fontFamily':0x1,'fontSize':$gameSystem[Q(0x239)+'ze'](),'nameFontFamily':0x1,'nameFontSize':$gameSystem[Q(0x239)+'ze']()};};const h=Scene_Boot[M(0x217)][M(0x283)+M(0x1e6)];Scene_Boot[M(0x217)][M(0x283)+M(0x1e6)]=function(){const R=M;h[R(0x202)](this,arguments),d[R(0x25b)][R(0x1ef)]((u,v)=>{const S=R;FontManager[S(0x245)](e+(v+(0x3eb*0x1+0x1f*0x5a+-0x18*0x9e)),u);});},Scene_Message[M(0x217)][M(0x21d)+M(0x221)]=function(){const T=M,u=$gameScreen[T(0x27e)+T(0x24d)][T(0x223)][-0x181e+0x1ca4+-0x486],v=$gameScreen[T(0x27e)+T(0x24d)][T(0x223)][-0x1561+0x1a53+0x17*-0x37],w=(Graphics[T(0x21f)]-u)/(-0xcc1+0x4*-0x676+0x269b*0x1),x=0xafb+-0x4af+0x3e*-0x1a;return new Rectangle(w,x,u,v);};const i=Scene_Message[M(0x217)][M(0x209)+M(0x268)];Scene_Message[M(0x217)][M(0x209)+M(0x268)]=function(){const U=M;this[U(0x207)+'KT']=new t(),this[U(0x1fb)](this[U(0x207)+'KT']),i[U(0x202)](this,arguments);};const j=Scene_Message[M(0x217)][M(0x1f0)+M(0x211)];Scene_Message[M(0x217)][M(0x1f0)+M(0x211)]=function(){const V=M;j[V(0x202)](this,arguments),this[V(0x207)+'KT']&&(this[V(0x207)+'KT'][V(0x232)]=this[V(0x215)+V(0x1e1)]);};const k=Window_Base[M(0x217)][M(0x24a)+M(0x251)];Window_Base[M(0x217)][M(0x24a)+M(0x251)]=function(u,v,w,z){const W=M,A=k[W(0x202)](this,arguments);return d[W(0x284)][W(0x1ef)](B=>{const X=W,C=new RegExp(X(0x281)+B[X(0x277)],'gi');A[X(0x20c)]=A[X(0x20c)][X(0x287)](C,X(0x247)+B[X(0x277)]+','+B[X(0x1d9)]+']');}),A;},Window_Base[M(0x217)][M(0x1dd)+'KT']=function(){const Y=M;return Math[Y(0x262)](this[Y(0x270)][Y(0x237)]*(0x7c9+-0x1bd4+0x146f)*$gameScreen[Y(0x23e)][Y(0x23a)])/(-0x151a+-0xb2*-0x10+0x52f*0x2);};const l=Window_Base[M(0x217)][M(0x1f5)+M(0x212)+'er'];Window_Base[M(0x217)][M(0x1f5)+M(0x212)+'er']=function(u,v){const Z=M;switch(u){case d[Z(0x27b)]:const w=v[Z(0x204)],z=this[Z(0x265)+Z(0x1da)+Z(0x26c)](v),A=v[Z(0x204)];if(z!==null){const C=this[Z(0x270)][Z(0x237)],D=this[Z(0x244)](z[-0x133b+-0x27*-0xe9+0x6*-0x2b6]),E=this[Z(0x1dd)+'KT'](),F=z[-0x2672+0x8e+0x25e6]?Number(z[-0x2664+0x1cd4+0x992]):0x78d*-0x3+-0x2258+0x38ff*0x1,G=z[0x1777+0x1ccd*0x1+-0x3441]?Number(z[0x1379+0x9bb*0x1+-0x1d31]):0x20c3+-0x1d93+-0x330;this[Z(0x270)][Z(0x237)]=E;const H=this[Z(0x244)](z[0xa46+-0x60b+-0x43a]);this[Z(0x270)][Z(0x237)]=C;const I=v['x']-(H-D)/(0x215f+-0x2011+0xa6*-0x2),J=v['y'],K=Math[Z(0x262)]((-E-(-0x21bc+-0x5a1*-0x3+0x10e1)-$gameScreen[Z(0x23e)][Z(0x219)+'g']+G)*(-0x24e3+0x3*0xa79+0x5dc))/(0x40d*0x9+-0x10d6*-0x2+0x45bd*-0x1);this[Z(0x224)+Z(0x1db)](z[0x16*-0x182+-0x784+-0xa2c*-0x4],v),this[Z(0x270)][Z(0x237)]=E,this[Z(0x22d)](z[-0x1374+-0x3*0x823+-0xa*-0x463],I+F,J+K,H,v[Z(0x20d)],Z(0x259)),this[Z(0x270)][Z(0x237)]=C;}break;case d[Z(0x1f9)]:const B=this[Z(0x265)+Z(0x260)](v);this[Z(0x270)][Z(0x255)]=Z(0x1fe)+Z(0x241)+B;break;}l[Z(0x202)](this,arguments);};const m=Window_Message[M(0x217)][M(0x210)];Window_Message[M(0x217)][M(0x210)]=function(){const a0=M;this[a0(0x275)+a0(0x286)](),m[a0(0x202)](this,arguments);},Window_Message[M(0x217)][M(0x275)+M(0x286)]=function(){const a1=M;$gameScreen[a1(0x27e)+a1(0x24d)][a1(0x267)]!==this[a1(0x1f6)+a1(0x272)]&&(SceneManager[a1(0x27c)][a1(0x207)+'KT'][a1(0x1f7)]=ImageManager[a1(0x1e2)]($gameScreen[a1(0x27e)+a1(0x24d)][a1(0x267)]),this[a1(0x1f6)+a1(0x272)]=$gameScreen[a1(0x27e)+a1(0x24d)][a1(0x267)]);};const n=Window_Message[M(0x217)][M(0x1ed)+M(0x261)];Window_Message[M(0x217)][M(0x1ed)+M(0x261)]=function(){const a2=M;n[a2(0x202)](this,arguments),this['x']=this[a2(0x1dc)+'T']()+$gameScreen[a2(0x27e)+a2(0x24d)][a2(0x24f)][this[a2(0x274)+a2(0x1ea)]][0x1*0x8e+0x167f*0x1+0x3*-0x7af],this['y']+=$gameScreen[a2(0x27e)+a2(0x24d)][a2(0x24f)][this[a2(0x274)+a2(0x1ea)]][-0x44d+-0x1acc+0x1f1a];},Window_Message[M(0x217)][M(0x1dc)+'T']=function(){const a3=M;return(Graphics[a3(0x21f)]-$gameScreen[a3(0x27e)+a3(0x24d)][a3(0x223)][0x10*-0x18e+0x1192*0x1+0x74e])/(0x21a+-0x1*-0x7db+-0x9f3);},Window_Message[M(0x217)][M(0x275)+M(0x203)]=function(){const a4=M;d[a4(0x282)]?(this[a4(0x24c)+'d']=-0xb*-0x2f7+-0xf9b+-0x1102,this[a4(0x26e)+a4(0x246)](-0x1*0xa88+-0x3a*0x1d+0xb*0x18e)):(this[a4(0x24c)+'d']=0x1033*0x1+-0x26c1+0x1690,this[a4(0x26e)+a4(0x246)](-0x57f*0x1+0x2*0xc42+-0x1303));},Window_Message[M(0x217)][M(0x1ee)+M(0x235)]=function(){const a5=M;this[a5(0x270)][a5(0x255)]=e+$gameScreen[a5(0x229)][a5(0x258)],this[a5(0x270)][a5(0x237)]=$gameScreen[a5(0x229)][a5(0x237)],this[a5(0x253)+a5(0x273)]();},Window_Message[M(0x217)][M(0x26f)+M(0x1e5)]=function(){const a6=M,u=$gameMessage[a6(0x200)](),v=$gameMessage[a6(0x201)](),w=$gameMessage[a6(0x266)](),y=ImageManager[a6(0x213)],z=this[a6(0x227)+'t'],A=w?this[a6(0x22e)]-y-(-0x171c+0x697*0x1+0x1089):0x107b+-0x4*0x2ce+0x1*-0x53f;this[a6(0x1e7)](u,v,A+$gameScreen[a6(0x27e)+a6(0x24d)][a6(0x1de)][-0x1*-0x14fe+-0x1880+-0x2*-0x1c1],$gameScreen[a6(0x27e)+a6(0x24d)][a6(0x1de)][0x4*-0x2e+0x2471+-0x23b8],y,z);};const o=Window_Message[M(0x217)][M(0x263)+'ge'];Window_Message[M(0x217)][M(0x263)+'ge']=function(){const a7=M,u=$gameScreen[a7(0x27e)+a7(0x24d)][a7(0x223)][0x1dc1*-0x1+0x1*-0x7cf+0x10*0x259],v=$gameScreen[a7(0x27e)+a7(0x24d)][a7(0x223)][0x229+0x1*-0xb1+-0x177];this[a7(0x1e9)](this['x'],this['y'],u,v),this[a7(0x270)][a7(0x23d)](u,v),$gameMessage[a7(0x26b)+a7(0x205)][a7(0x1f8)]!==-0xa*0x14e+0x193f*0x1+0xc33*-0x1&&($gameMessage[a7(0x249)]=$gameMessage[a7(0x26b)+a7(0x205)][a7(0x20e)]('\x0a'),$gameMessage[a7(0x26b)+a7(0x205)]=''),o[a7(0x202)](this,arguments);};const p=Window_Message[M(0x217)][M(0x1fc)];Window_Message[M(0x217)][M(0x1fc)]=function(u){const a8=M;p[a8(0x202)](this,arguments);const v=this[a8(0x1dd)+'KT']()+$gameScreen[a8(0x23e)][a8(0x219)+'g'];u['y']+=v;};const q=Window_Base[M(0x217)][M(0x248)+M(0x1fa)];Window_Base[M(0x217)][M(0x248)+M(0x1fa)]=function(u){const a9=M;q[a9(0x202)](this,arguments),u['y']+=this[a9(0x1dd)+'KT']()+$gameScreen[a9(0x23e)][a9(0x20b)+'g']+$gameScreen[a9(0x23e)][a9(0x219)+'g'];};const r=Window_NameBox[M(0x217)][M(0x264)];Window_NameBox[M(0x217)][M(0x264)]=function(){const aa=M;r[aa(0x202)](this,arguments),this[aa(0x24e)]=-0x1*-0x190f+-0x1fcc+0x6bd,this[aa(0x257)+aa(0x25c)]=-0x19*0x5b+0x18*0x1c+0x643;};const s=Window_NameBox[M(0x217)][M(0x1ed)+M(0x261)];Window_NameBox[M(0x217)][M(0x1ed)+M(0x261)]=function(){const ab=M;s[ab(0x202)](this,arguments),this['x']=this[ab(0x215)+ab(0x1e1)]['x']+$gameScreen[ab(0x27e)+ab(0x24d)][ab(0x22c)][this[ab(0x215)+ab(0x1e1)][ab(0x274)+ab(0x1ea)]][-0x1aef+-0x2*-0x88b+0x9d9],this['y']=this[ab(0x215)+ab(0x1e1)]['y']+$gameScreen[ab(0x27e)+ab(0x24d)][ab(0x22c)][this[ab(0x215)+ab(0x1e1)][ab(0x274)+ab(0x1ea)]][-0xb7*0x6+0x214f+0x741*-0x4];},Window_NameBox[M(0x217)][M(0x25e)]=function(u){return;},Window_NameBox[M(0x217)][M(0x275)+M(0x203)]=function(){const ac=M;this[ac(0x26e)+ac(0x246)](0x2*0x23b+0xd*-0x133+0xb23*0x1);},Window_NameBox[M(0x217)][M(0x1ee)+M(0x235)]=function(){const ad=M;this[ad(0x270)][ad(0x255)]=e+$gameScreen[ad(0x229)][ad(0x233)+ad(0x22a)],this[ad(0x270)][ad(0x237)]=$gameScreen[ad(0x229)][ad(0x230)+'ze'],this[ad(0x253)+ad(0x273)]();},Window_NameBox[M(0x217)][M(0x254)]=function(){const ae=M,u=this[ae(0x222)+'ct']();this[ae(0x270)][ae(0x1fd)]();const v=this[ae(0x1dd)+'KT']()+$gameScreen[ae(0x23e)][ae(0x219)+'g'];this[ae(0x1e3)](this[ae(0x226)],u['x'],u['y']+v,u[ae(0x238)]);const w=$gameScreen[ae(0x27e)+ae(0x24d)][ae(0x1e4)+'th'];if(w>0x1*-0x131e+-0x1ec3+0x31e1){const x=this[ae(0x257)+ae(0x25c)];if(w<x)this[ae(0x1e8)]['x']=Math[ae(0x262)](w/x*(-0x11a*0x14+-0x1378*-0x2+-0x1084))/(0x2022+0x83f+-0x27fd);else{this[ae(0x1e8)]['x']=-0x103a*-0x2+-0x4ad*-0x3+-0x2e7a;switch($gameScreen[ae(0x27e)+ae(0x24d)][ae(0x27a)+'gn']){case ae(0x1ec):this['x']=this['x'];break;case ae(0x259):this['x']=this['x']+(w/(-0x234c+0x1007*-0x1+-0x1*-0x3355)-x/(-0x5*-0x54d+-0x832*-0x3+0x9*-0x5ad));break;case ae(0x234):this['x']=this['x']+w-x;break;}}}},Window_NameBox[M(0x217)][M(0x1df)+'ht']=function(){return-0x1bfe+0xfba+0x38*0x41;},Window_NameBox[M(0x217)][M(0x20a)+'h']=function(){const af=M;if(this[af(0x226)]){const u=this[af(0x206)](this[af(0x226)])[af(0x238)],v=-0x11f3+0x192*0x6+0x887,w=Math[af(0x21a)](u)+v*(0x2547+0x2b*0x85+-0x3b9c),x=Math[af(0x250)](w,Graphics[af(0x21f)]);return this[af(0x257)+af(0x25c)]=x,x;}else return this[af(0x257)+af(0x25c)]=-0x2*0x1343+-0x2*-0x740+-0x401*-0x6,-0x5*-0x32a+0x12*-0x94+-0x56a;},Window_NameBox[M(0x217)][M(0x214)+'g']=function(){return-0x5*0x1df+0x1b54+-0x11f9;};class t extends Sprite{[M(0x264)](){const ag=M;super[ag(0x264)](),this[ag(0x232)]=null;}[M(0x210)](){const ah=M;super[ah(0x210)](),this[ah(0x232)]&&(this[ah(0x236)+ah(0x1ff)](),this[ah(0x23b)+ah(0x27d)]());}[M(0x236)+M(0x1ff)](){const ai=M,u=this[ai(0x232)];this['x']=u['x']+$gameScreen[ai(0x27e)+ai(0x24d)][ai(0x218)][u[ai(0x274)+ai(0x1ea)]][0x1a53+0x17*-0xd+-0x1928],this['y']=u['y']+$gameScreen[ai(0x27e)+ai(0x24d)][ai(0x218)][u[ai(0x274)+ai(0x1ea)]][0x18db+-0x1345*-0x1+-0x8d3*0x5];}[M(0x23b)+M(0x27d)](){const aj=M;this[aj(0x23c)]=this[aj(0x232)][aj(0x285)];}[M(0x21e)](){const ak=M;this[ak(0x232)]=null,super[ak(0x21e)]();}}})()));function a(){const al=['clear','rmmz-fontC','tion','faceName','faceIndex','apply','ground','index','geGRKT','textSizeEx','_bgImageGR','87408ozgMIL','createWind','windowWidt','lineSpacin','text','height','split','518WimkAQ','update','indows','apeCharact','faceWidth','itemPaddin','_messageWi','registerCo','prototype','bgPos','rubySpacin','ceil','rubyLineSp','meter','messageWin','destroy','boxWidth','proofPlugi','dowRect','baseTextRe','wSize','flushTextS','7718918616','_name','innerHeigh','trim','_fontGRKT','mily','currentScr','nPos','drawText','innerWidth','toUpperCas','nameFontSi','1878885IdTqVl','_window','nameFontFa','right','ettings','updatePosi','fontSize','width','mainFontSi','rubySize','updateOpac','opacity','resize','_rubyGRKT','needsParam','117246MKtSYi','ustomGRKT-','ipt','4690732lsoYCG','textWidth','load','undType','\x1br[','processNew','_texts','createText','0512414413','_backgroun','GRKT','_padding','wPos','min','State','acing','resetTextC','refresh','fontFace','getAlignSt','_windowWid','fontFamily','center','nextMessag','fonts','thValue','setupMessa','drawShape','1812062071','peParam','ement','trunc','startMessa','initialize','obtainEsca','isRTL','bgImage','owLayer','ring','1871711902','_nextMessa','ayGRKT','nameBoxPos','setBackgro','drawMessag','contents','windowPos','meGRKT','olor','_positionT','updateBack','4zHQxwX','targetStr','2436111DVNwrs','sort','nameBoxAli','rubyTag','_scene','ity','_msgWindow','3149169139','3195','(?<!\x5c[)','testMode','loadGameFo','rubyList','openness','groundGRKT','replaceAll','createPara','10hxkedW','981WKdTFR','rubyStr','peParamArr','tateGRKT','centerXGRK','rubySizeGR','facePos','windowHeig','mmand','ndow','loadSystem','drawTextEx','nameBoxWid','eFace','nts','drawFace','scale','move','ype','message','left','updatePlac','resetFontS','forEach','createAllW','55565906wCXFoh','map','windowSize','4376150IDDYZA','processEsc','_bgImageNa','bitmap','length','fontTag','Line','addChild','newPage'];a=function(){return al;};return a();}