//=============================================================================
// RPG Maker MZ - GRKT_PictureCursor
//=============================================================================

/*:
 * @target MZ
 * @plugindesc ピクチャ用カーソル
 * @author MUMAMOMEMU
 * @url https://mumamomemu.booth.pm/
 * @base GRKT_Base
 * @orderAfter GRKT_Base
 *
 * @help GRKT_PictureCursor.js(ver1.0.1)
 *
 *
 * --------------------------
 * ■利用規約
 *
 * Copyright (c) 2023 MUMAMOMEMU
 * https://star-write-dream.com/
 *
 * 以下に定める条件に従い、本プラグインファイル（以下「ソフトウェア」）の
 * 購入者に対し、ソフトウェアを変更し、
 * 購入者の制作する作品（以下、制作物）に組み込むことを許可します。
 * 制作物の内容および公開形式に制約はありません。
 *
 * ソフトウェア単体で掲載、頒布、共有することはできません。
 * 上記の著作権表示および本許諾表示は変更できず、削除もできません。
 * 別途、制作物の重要な箇所にソフトウェアの著作権表示をする必要はありません。
 *
 * ソフトウェアは「現状のまま」で、明示であるか暗黙であるかを問わず、
 * 何らの保証もなく提供されます。ここでいう保証とは、商品性、
 * 特定の目的への適合性、および権利非侵害についての保証も含みますが、
 * それに限定されるものではありません。作者または著作権者は、契約行為、
 * 不法行為、またはそれ以外であろうと、ソフトウェアに起因または関連し、
 * あるいはソフトウェアの使用またはその他の扱いによって生じる一切の請求、
 * 損害、その他の義務について何らの責任も負わないものとします。
 * --------------------------
 *
 * @param padding
 * @type string
 * @text 余白
 * @desc カーソルの余白を左右,上下で指定します。初期値：10,10
 * @default 10,10
 *
 * @param color
 * @type string
 * @text 色
 * @desc カーソルの色を指定します。初期値：rgb(255,255,255)
 * @default rgb(255,255,255)
 *
 * @param maxOpacity
 * @type number
 * @text 最大の不透明度
 * @desc カーソルが一番濃くなった時の不透明度を0-255で入力します。
 * @default 120
 * @max 255
 * @min 0
 *
 * @param minOpacity
 * @type number
 * @text 最小の不透明度
 * @desc カーソルが一番薄くなった時の不透明度を0-255で入力します。
 * @default 20
 * @max 255
 * @min 0
 *
 * @param changeDuration
 * @type number
 * @text 不透明度の変化フレーム
 * @desc カーソルの濃淡変化にかかる時間をフレームで指定します。
 * @default 60
 *
 * @param fixedOpacity
 * @type number
 * @text 確定中の不透明度
 * @desc カーソル確定中の不透明度を入力します。
 * @default 125
 *
 * @param useMouse
 * @type boolean
 * @text マウスクリックに対応
 * @desc ON:マウスクリックでも決定コモンイベントを実行します。
 * @default true
 *
 * @command setup
 * @text セットアップ
 * @desc セットアップします。
 *
 * @arg dataList
 * @type struct<cursorData>[]
 * @text ピクチャリスト
 * @desc ピクチャリストを登録します。
 * @default
 *
 * @arg cancelCeIdActive
 * @type common_event
 * @text 操作中キャンセルコモンイベント
 * @desc カーソル操作中にキャンセル操作した場合のコモンイベントを指定します。
 * @default 0
 *
 * @arg cancelCeIdFixed
 * @type common_event
 * @text 確定中キャンセルコモンイベント
 * @desc 確定中にキャンセル操作した場合のコモンイベントを指定します。
 * @default 0
 *
 * @arg row
 * @type number
 * @text 行数
 * @desc 行数を指定します。0でリスト件数分が設定されます。
 * @default 0
 *
 * @command start
 * @text カーソル開始
 * @desc カーソル動作を開始します。
 *
 * @arg startIndex
 * @type string
 * @text 開始インデックス
 * @desc 開始インデックスを指定します。先頭0。\v[X]可。
 * @default 0
 *
 * @command fix
 * @text カーソル確定
 * @desc カーソルを可視状態のまま停止します。
 *
 * @command end
 * @text カーソル終了
 * @desc カーソルを非可視にして停止します。
 *
 * @command getIndex
 * @text インデックスを保存
 * @desc 現在のインデックスを変数に保存します。
 *
 * @arg indexVar
 * @type variable
 * @text 保存変数
 * @desc インデックスを保存する変数を指定します。
 * @default 0
 *
 */
/*~struct~cursorData:
 *
 * @param picId
 * @type string
 * @text ピクチャ番号
 * @desc ピクチャ番号を指定します。\v[X]可。
 * @default 0
 *
 * @param ceId
 * @type common_event
 * @text コモンイベント
 * @desc コモンイベントを指定します。
 * @default 0
 *
 */

function b(c,d){const e=a();return b=function(f,g){f=f-(-0x255a+-0x1*-0x1cf6+-0xa27*-0x1);let h=e[f];return h;},b(c,d);}(function(c,d){const q=b,e=c();while(!![]){try{const f=parseInt(q(0x21d))/(-0x2651+-0x5*-0x3bf+0x1397*0x1)+-parseInt(q(0x225))/(-0x2*0x6a+0x1397+-0x12c1)+parseInt(q(0x202))/(0x1a8d+-0x2125+0x69b)+parseInt(q(0x1f4))/(0x119*0x1b+-0x4e3*-0x1+-0x2282)+-parseInt(q(0x1fe))/(-0x16dd*0x1+0x1ea5+-0x7c3)*(-parseInt(q(0x206))/(0x20d*-0x6+0x2*0xb68+-0x2c*0x3d))+-parseInt(q(0x1de))/(0xa09+-0x18ca+0xec8)+parseInt(q(0x212))/(0xf95+-0xca9*0x2+-0x9c5*-0x1)*(-parseInt(q(0x203))/(-0x3*-0x33b+-0x1e7c+0x14d4));if(f===d)break;else e['push'](e['shift']());}catch(g){e['push'](e['shift']());}}}(a,0xbe64d*-0x1+-0xa11ac+0x1ee2ca),((()=>{'use strict';const r=b;const c=document[r(0x1cd)+r(0x21b)],d=PluginManagerEx[r(0x1ea)+r(0x213)](c),e=d[r(0x21f)][r(0x1f5)](',')[r(0x1eb)](Number);GRKT_Util[r(0x1c6)+'n'](r(0x201)+r(0x209)+r(0x22f)+r(0x21a)+r(0x1f2)+r(0x1d0),document[r(0x1cd)+r(0x21b)]),PluginManagerEx[r(0x1d5)+r(0x1c5)](c,r(0x1e4),l=>{const s=r;if(l[s(0x1fd)][s(0x1f9)]===0xb86+0x2573*0x1+-0x6ff*0x7)return;const m=$gameScreen[s(0x215)+'T'];m[s(0x1e0)]=l[s(0x1fd)][s(0x1eb)](n=>n[s(0x234)]),m[s(0x228)]=l[s(0x228)]===-0xc33*0x1+0x1d*-0xfd+0x28dc?l[s(0x1fd)][s(0x1f9)]:l[s(0x228)],m[s(0x1df)]=0x2fa+-0x3ce+0x2*0x6a,m[s(0x1f3)]=-0x5ad+-0x1*-0xf56+-0x9a9*0x1,m[s(0x1d3)]=l[s(0x22c)+s(0x1e5)],m[s(0x1e8)]=l[s(0x22c)+s(0x1c4)],m[s(0x1e0)][s(0x219)](n=>{const t=s;if(isNaN(n[t(0x1da)])){const o=GRKT_Util[t(0x1d8)+t(0x1fb)](n[t(0x1da)]);n[t(0x1da)]=Number(o);}});}),PluginManagerEx[r(0x1d5)+r(0x1c5)](c,r(0x22e),l=>{const u=r,m=$gameScreen[u(0x215)+'T'];if(l[u(0x1ef)]>=-0x235*-0x1+-0x6fb+0x4c6){const n=l[u(0x1ef)];if(!m[u(0x1e0)][n]||m[u(0x1e0)][n][u(0x1da)]===-0xa7b*-0x1+-0x4d*0x13+-0x4c4){const o=m[u(0x1e0)][u(0x222)](p=>p&&p[u(0x1da)]!=0x14c1+0x2*0x219+-0x18f3);m[u(0x1d6)]=o;}else m[u(0x1d6)]=l[u(0x1ef)];$gameScreen[u(0x1e2)+u(0x20c)+'KT']();}m[u(0x211)]=-(-0x2300+0x3*-0x6b3+-0x2*-0x1b8d),SceneManager[u(0x1c9)][u(0x1fc)+u(0x1e9)]();}),PluginManagerEx[r(0x1d5)+r(0x1c5)](c,r(0x1dc),l=>{const v=r;SceneManager[v(0x1c9)][v(0x214)+v(0x229)][v(0x20a)]();const m=$gameScreen[v(0x215)+'T'];m[v(0x211)]=m[v(0x1d6)];}),PluginManagerEx[r(0x1d5)+r(0x1c5)](c,r(0x231),l=>{const w=r;SceneManager[w(0x1c9)][w(0x214)+w(0x229)][w(0x220)]();const m=$gameScreen[w(0x215)+'T'];m[w(0x211)]=-(-0x1546+-0x238b*-0x1+-0xe44);}),PluginManagerEx[r(0x1d5)+r(0x1c5)](c,r(0x1ec),l=>{const x=r,m=$gameScreen[x(0x215)+'T'];$gameVariables[x(0x22d)](l[x(0x210)],m[x(0x1d6)]);});const f=Scene_Battle[r(0x1ff)][r(0x1ee)+r(0x235)];Scene_Battle[r(0x1ff)][r(0x1ee)+r(0x235)]=function(){const y=r;f[y(0x1d4)](this,arguments),this[y(0x1dd)+y(0x1ce)]();},Scene_Battle[r(0x1ff)][r(0x1dd)+r(0x1ce)]=function(){const z=r;this[z(0x214)+z(0x229)]=new j(),this[z(0x214)+z(0x229)][z(0x220)](),this[z(0x237)](this[z(0x214)+z(0x229)]);};const g=Scene_Map[r(0x1ff)][r(0x1ee)+r(0x235)];Scene_Map[r(0x1ff)][r(0x1ee)+r(0x235)]=function(){const A=r;g[A(0x1d4)](this,arguments),this[A(0x1dd)+A(0x1ce)]();},Scene_Map[r(0x1ff)][r(0x1dd)+r(0x1ce)]=function(){const B=r;this[B(0x214)+B(0x229)]=new j(),this[B(0x214)+B(0x229)][B(0x220)](),this[B(0x237)](this[B(0x214)+B(0x229)]);};const h=Scene_Base[r(0x1ff)][r(0x1db)];Scene_Base[r(0x1ff)][r(0x1db)]=function(){const C=r;this[C(0x218)+C(0x216)+'T'](),h[C(0x1d4)](this,arguments);},Scene_Base[r(0x1ff)][r(0x218)+r(0x216)+'T']=function(){const D=r;if(!this[D(0x214)+D(0x229)])return;const l=$gameScreen[D(0x215)+'T'];if(!l)return;const m=l[D(0x1d6)];if(!this[D(0x214)+D(0x229)][D(0x1c8)]()&&l[D(0x211)]===-(0x1*-0xc07+0x2*0x904+-0x600))return;if(l[D(0x211)]!==-(0x1*0x5d+0x8f*-0x25+0x3*0x6c5)){(Input[D(0x1cc)+'d'](D(0x1e6))||TouchInput[D(0x205)+'d']())&&($gameParty[D(0x20e)+D(0x1ca)+'KT'](l[D(0x1e8)],0x25b+-0x7b9+0x55e),l[D(0x211)]===-(0x63e+0x4d*0xa+-0x1*0x93f));return;}if(Input[D(0x1cc)+'d']('ok')||this[D(0x1d2)+D(0x1cf)+D(0x1fa)]())$gameParty[D(0x20e)+D(0x1ca)+'KT'](l[D(0x1e0)][l[D(0x1d6)]][D(0x1f0)],-0x261a+-0x1*0x1f0f+-0x4529*-0x1);else(Input[D(0x1cc)+'d'](D(0x1e6))||TouchInput[D(0x205)+'d']())&&$gameParty[D(0x20e)+D(0x1ca)+'KT'](l[D(0x1d3)],-0x335*-0xc+0x5d3*-0x2+0x5*-0x55e);if(Input[D(0x1d7)]('up'))this[D(0x224)+D(0x22b)]();else Input[D(0x1d7)](D(0x239))&&this[D(0x1d1)+D(0x221)]();if(Input[D(0x1d7)](D(0x1f8)))this[D(0x1ed)+D(0x221)]();else Input[D(0x1d7)](D(0x1f7))&&this[D(0x22a)+D(0x22b)]();l[D(0x1d6)]!==m&&this[D(0x1fc)+D(0x1e9)]();},Scene_Base[r(0x1ff)][r(0x1d2)+r(0x1cf)+r(0x1fa)]=function(){const E=r;return TouchInput[E(0x1cc)+'d']()&&this[E(0x214)+E(0x229)]&&this[E(0x214)+E(0x229)][E(0x20d)+E(0x238)]();},Scene_Base[r(0x1ff)][r(0x1fc)+r(0x1e9)]=function(){const F=r,l=$gameScreen[F(0x215)+'T'],m=l[F(0x1e0)][l[F(0x1d6)]][F(0x1da)],n=this[F(0x21c)][F(0x20f)+F(0x217)],o=n[F(0x20b)][F(0x1e1)](p=>p[F(0x204)]===m);if(!o)return;this[F(0x214)+F(0x229)][F(0x1f1)](o);},Scene_Base[r(0x1ff)][r(0x1d1)+r(0x221)]=function(){const G=r;if($gameScreen[G(0x215)+'T'][G(0x228)]===-0x1559+0xee6+0x674)return;const l=$gameScreen[G(0x215)+'T'];l[G(0x1df)]<l[G(0x228)]-(0x23b3+0x49*0x25+0x2e3f*-0x1)?(l[G(0x1df)]++,l[G(0x1d6)]++):(l[G(0x1df)]=0xa*0xf1+-0x546*0x1+-0x424,l[G(0x1d6)]=l[G(0x1d6)]-(l[G(0x228)]-(-0x1ef+-0x71*0x44+0x664*0x5))),(!l[G(0x1e0)][l[G(0x1d6)]]||l[G(0x1e0)][l[G(0x1d6)]][G(0x1da)]===0x5ad*-0x2+0x38*-0x92+0x2b4a)&&this[G(0x1d1)+G(0x221)](),SoundManager[G(0x236)]();},Scene_Base[r(0x1ff)][r(0x224)+r(0x22b)]=function(){const H=r;if($gameScreen[H(0x215)+'T'][H(0x228)]===-0x1a9a+0x29*-0xad+-0xb*-0x4f0)return;const l=$gameScreen[H(0x215)+'T'];l[H(0x1df)]===-0x135f*0x1+0x15d3+-0x2*0x13a?(l[H(0x1df)]=l[H(0x228)]-(-0xcdf*-0x1+-0x1*0x1a11+0xd33),l[H(0x1d6)]=l[H(0x1d6)]+(l[H(0x228)]-(-0x155f+-0x1*0x1a71+0x2fd1))):(l[H(0x1df)]--,l[H(0x1d6)]--),(!l[H(0x1e0)][l[H(0x1d6)]]||l[H(0x1e0)][l[H(0x1d6)]][H(0x1da)]===0x114b+0x1d16+0x2e61*-0x1)&&this[H(0x224)+H(0x22b)](),SoundManager[H(0x236)]();},Scene_Base[r(0x1ff)][r(0x1ed)+r(0x221)]=function(){const I=r;if($gameScreen[I(0x215)+'T'][I(0x228)]>=$gameScreen[I(0x215)+'T'][I(0x1e0)][I(0x1f9)])return;const l=$gameScreen[I(0x215)+'T'];l[I(0x1e0)][I(0x1f9)]>l[I(0x228)]*(l[I(0x1f3)]+(-0xc61*0x1+-0x1051+-0xed*-0x1f))?(l[I(0x1f3)]++,l[I(0x1d6)]=l[I(0x1d6)]+l[I(0x228)]):(l[I(0x1f3)]=-0x1067+-0x1c47*-0x1+-0x1*0xbe0,l[I(0x1d6)]=l[I(0x1df)]),(!l[I(0x1e0)][l[I(0x1d6)]]||l[I(0x1e0)][l[I(0x1d6)]][I(0x1da)]===0x206a+0x5*-0x286+-0x2*0x9e6)&&this[I(0x1ed)+I(0x221)](),SoundManager[I(0x236)]();},Scene_Base[r(0x1ff)][r(0x22a)+r(0x22b)]=function(){const J=r;if($gameScreen[J(0x215)+'T'][J(0x228)]>=$gameScreen[J(0x215)+'T'][J(0x1e0)][J(0x1f9)])return;const l=$gameScreen[J(0x215)+'T'];l[J(0x1f3)]>0x105*0xd+0x76d*0x1+-0x14ae?(l[J(0x1f3)]--,l[J(0x1d6)]=l[J(0x1d6)]-l[J(0x228)]):(l[J(0x1f3)]=Math[J(0x21e)](l[J(0x1e0)][J(0x1f9)]/l[J(0x228)]),l[J(0x1d6)]=l[J(0x1df)]+l[J(0x228)]*l[J(0x1f3)]),(!l[J(0x1e0)][l[J(0x1d6)]]||l[J(0x1e0)][l[J(0x1d6)]][J(0x1da)]===-0x8a1*0x3+0x17f*-0x18+-0x1499*-0x3)&&this[J(0x22a)+J(0x22b)](),SoundManager[J(0x236)]();};const i=Game_Screen[r(0x1ff)][r(0x200)];Game_Screen[r(0x1ff)][r(0x200)]=function(){const K=r;i[K(0x1d4)](this,arguments),this[K(0x215)+'T']={'fixedIndex':-(0x40*0x20+0x7*-0x185+0x2a4),'row':0x1,'curRow':0x0,'curCol':0x0,'index':0x0,'list':[],'cancelCE1':0x0,'cancelCE2':0x0};},Game_Screen[r(0x1ff)][r(0x1e2)+r(0x20c)+'KT']=function(){const L=r,l=this[L(0x215)+'T'];l[L(0x1f3)]=Math[L(0x21e)](l[L(0x1d6)]/l[L(0x228)]),l[L(0x1df)]=l[L(0x1d6)]-l[L(0x228)]*l[L(0x1f3)];};class j extends Sprite_CursorCommonGRKT{[r(0x200)](){const M=r;super[M(0x200)](),this[M(0x208)+M(0x1d9)]={'min':d[M(0x207)],'max':d[M(0x1f6)],'fixed':d[M(0x233)+'ty'],'duration':d[M(0x1e3)+M(0x226)]},this[M(0x230)]=this[M(0x208)+M(0x1d9)][M(0x1c3)],this[M(0x223)+M(0x1c7)]=e,this[M(0x232)][M(0x1e7)](d[M(0x1cb)]);}}const k=Sprite_Picture[r(0x1ff)][r(0x227)+'er'];Sprite_Picture[r(0x1ff)][r(0x227)+'er']=function(){const N=r;k[N(0x1d4)](this,arguments);const l=SceneManager[N(0x1c9)][N(0x214)+N(0x229)];if(!l)return;if(!l[N(0x1c8)]())return;const m=$gameScreen[N(0x215)+'T'],n=m[N(0x1e0)][N(0x222)](o=>o[N(0x1da)]===this[N(0x204)]);n>=-0xa5c+-0x4*0x8a+0xc84&&(m[N(0x1d6)]!==n&&(SoundManager[N(0x236)](),m[N(0x1d6)]=n,l[N(0x1f1)](this),$gameScreen[N(0x1e2)+N(0x20c)+'KT']()));};})()));function a(){const O=['padding','deactivate','CursorGRKT','findIndex','_paramPadd','backRowCur','1125656lVIQCq','tion','onMouseEnt','row','iteGRKT','backColCur','sorGRKT','cancelCeId','setValue','start','3149169145','opacity','end','bitmap','fixedOpaci','_parameter','layObjects','playCursor','addChild','ched','down','min','Fixed','mmand','proofPlugi','ing','isActive','_scene','icCommonGR','color','isTriggere','currentScr','orGRKT','nPictureCu','9215','forwardRow','isTriggerO','cancelCE1','apply','registerCo','index','isRepeated','messageTag','ity','picId','update','fix','createCurs','3085565NAVOet','curRow','list','find','setRowColu','changeDura','setup','Active','cancel','fillAll','cancelCE2','ursorGRKT','createPara','map','getIndex','forwardCol','createDisp','startIndex','ceId','setTarget','1120718612','curCol','2419968psNgGV','split','maxOpacity','left','right','length','rsor','Work','setTargetC','dataList','498860MACXTz','prototype','initialize','1931961901','2215590NxcsEk','360198onpjhP','_pictureId','isCancelle','24xUpdcJ','minOpacity','_paramOpac','9612414413','fixed','children','mnCursorGR','isBeingTou','setupDynam','_pictureCo','indexVar','fixedIndex','88ucOgOR','meter','_cursorSpr','_cursorGRK','tCursorGRK','ntainer','updataInpu','forEach','1881792092','ipt','_spriteset','285656IRudzE','trunc'];a=function(){return O;};return a();}