/*:
 * @target MZ
 * @plugindesc 現在ONになっているプラグインの作者名を重複なしで一覧表示します
 * @author GPT-5
 *
 * @command ShowAuthors
 * @text 作者一覧を表示
 * @desc 現在ONになっているプラグインの作者を表示します
 */

(() => {

    const pluginName = "ListPluginAuthors";

    // プラグインコマンド登録
    PluginManager.registerCommand(pluginName, "ShowAuthors", () => {
        const plugins = (typeof $plugins !== "undefined") ? $plugins : PluginManager._plugins;
        const authors = new Set();

        for (const plugin of plugins) {
            if (plugin && plugin.status && plugin.description) {
                // メタ情報やコメントから作者名を抽出（@authorタグを優先）
                let author = "";

                // ヘッダーにメタがある場合
                if (plugin.parameters && plugin.parameters.author) {
                    author = plugin.parameters.author;
                }

                // メタデータから
                if (plugin.meta && plugin.meta.author) {
                    author = plugin.meta.author;
                }

                // ファイル先頭コメントをスキャン
                if (!author && plugin.description.match(/@author\s+([^\n\r]+)/)) {
                    author = RegExp.$1.trim();
                }

                if (author) authors.add(author);
            }
        }

        if (authors.size === 0) {
            $gameMessage.add("作者情報が見つかりませんでした。");
        } else {
            $gameMessage.add("ONになっているプラグインの作者一覧：");
            for (const a of authors) {
                $gameMessage.add("・" + a);
            }
        }

        console.log("プラグイン作者一覧:", Array.from(authors));
    });

})();
