
/*:
 * @plugindesc ゲーム全体のフォントおよびアイコンのサイズを変更します。
 * @author しぐれん(https://github.com/Sigureya/RPGmakerMV)
 * 
 * @target MZ
 * 
 * @param fontSize
 * @type number
 * @default 36
 * 
 * @param iconSize
 * @type number
 * @default 32
 * 
 * @help
 * フォントの大きさを変更します。
 * 全てのウィンドウに対して適用されます。
 * アイコンの表示サイズも変更可能です。
 * 
 * 本来のアイコンは32*32の大きさですが、パラメータ変更によって縮小します。
*/
(function(){
    'use strict';

    /**
     * @type {String}
     */
    const  PLUGIN_NAME= ('Mano_FontSizeChange');
    function getParam(){ return PluginManager.parameters(PLUGIN_NAME);  }
    
    
    const setting = (function(){
        const param =getParam();
        const result ={
            fontSize:Number(param.fontSize),
            iconSize:Number(param.iconSize),
        };
        return result;
    })();

Window_Base.prototype.lineHeight = function() {
    return setting.fontSize;//★ゲーム全体の基本行間
};

Window_Base.prototype.drawIcon= function(iconIndex,x,y){
    const bitmap = ImageManager.loadSystem("IconSet");
    const pw = ImageManager.iconWidth;
    const ph = ImageManager.iconHeight;
    const sx = (iconIndex % 16) * pw;
    const sy = Math.floor(iconIndex / 16) * ph;
    this.contents.blt(bitmap, sx, sy, pw, ph, x, y,setting.iconSize,setting.iconSize);
}
Window_Base.prototype.processDrawIcon = function(iconIndex, textState) {
    if (textState.drawing) {
        this.drawIcon(iconIndex, textState.x + 2, textState.y + 2);
    }
    textState.x += setting.iconSize + 4;
};

}())
