//=============================================================================
// ModifyPictureEvents.js
// ----------------------------------------------------------------------------
// <利用規約>
//  利用はRPGツクールMV/RPGMakerMVの正規ユーザーに限られます。
//  商用、非商用、ゲームの内容を問わず利用可能です。
//  ゲームへの利用の際、報告や出典元の記載等は必須ではありません。
//  二次配布や転載は禁止します。
//  ソースコードURL、ダウンロードURLへの直接リンクも禁止します。
//  不具合対応以外のサポートやリクエストは受け付けておりません。
//  スクリプト利用により生じたいかなる問題においても、一切責任を負いかねます。
// ----------------------------------------------------------------------------
//  Ver1.00  2016/02/06  初版
//=============================================================================

/*:
 * @plugindesc ピクチャ関連のイベント（マップイベント、コモンイベント）を一括修正します。
 * @author こま
 *
 * @param Backup Old Data 
 * @desc 修正前のファイルをバックアップする場合は「ON」にしてください。（ON/OFF）
 * @default ON
 *
 * @help
 * ------------------------------------------------------------------------------
 * 重要：このプラグインは、ゲームデータを大きく書き換える機能を備えています。
 *     ：実行前にはデータのバックアップを取る等、取り扱いには十分ご注意ください。
 * ------------------------------------------------------------------------------
 *
 * このプラグインはゲームの機能を拡張するものではなく、マップイベントやコモンイベ
 * ントの元データ（dataフォルダにある当該jsonファイル）を編集するものです。下記プ
 * ラグインコマンド実行後は、「プロジェクトを保存せずに開き直し」てください。
 *
 * *このプラグインは、テスト時のみ動作します。
 *
 * プラグインコマンド：
 *  MPE_SET_NUMBER <start> <end> <set num>
 *  : イベントで指定したピクチャ番号を、指定の番号に変更します。
 *  : <start>と<end>には、変更対象となるピクチャ番号の範囲を指定してください。
 *  : <set num>には、変更後の番号を指定してください。
 *  :
 *  : 使用例：MPE_ADD_NUMBER 1 3 5
 *  :         > ピクチャ番号1番、2番、3番をすべて5番に変更します。
 *
 *  MPE_ADD_NUMBER <start> <end> <add num>
 *  : イベントで指定したピクチャ番号を、指定数分だけ加算します。
 *  : <start>と<end>には、加算対象となるピクチャ番号の範囲を指定してください。
 *  : <add num>には、加算したい量を指定してください。
 *  :
 *  : 使用例：MPE_ADD_NUMBER 1 3 1
 *  :         > ピクチャ番号1番を2番に、2番を3番に、3番を4番に変更します。
 *
 *  MPE_RENAME <old name> <new name>
 *  : イベントで指定したピクチャ名を、別の名前に変更します。
 *  : <old name>には、変更前の名前を指定してください。
 *  : <new name>には、変更後の名前を指定してください。
 *  :
 *  : 使用例：MPE_RENAME pic_AAA pic_BBB
 *  :         > ピクチャ名がpic_AAAとなっている箇所を、すべてpic_BBBに変更します。
 *
 * ----------------------------
 *  プラグインコマンド実行方法
 * ----------------------------
 *  プラグインコマンドは、通常通りゲームを起動して対象のイベントを実行するやり方
 *  でも問題ありませんが、イベントエディタ上でも簡単に実行できます。
 *
 *  イベントエディタで以下の操作を実施：
 *   1) 設定したプラグインコマンドを選択状態にする
 *   2) 右クリック→「テスト」を実行
 *
 *  見た目には何も起こりませんが、データの編集は行われています。プロジェクトの
 *  保存は"行わず"に、プロジェクトを開き直して下さい。
 *
 * ----------------------
 *  バックアップについて
 * ----------------------
 *  プラグインパラメータの「Backup Old Data」をONにしている場合、「backup」フォル
 *  ダが作成され、変更前のデータが保存されます。データを元に戻したいときは、
 *  backupフォルダから当該データをコピーしてください。
 */

(function(){
    var pluginName = 'ModifyPictureEvents';
    
    var parameters = PluginManager.parameters(pluginName);
    var BackupOldData = (parameters['Backup Old Data'].toUpperCase() === 'ON');

    function filePath(directory, file) {
        var path = window.location.pathname.replace(/(\/www|)\/[^\/]*$/, '/' + directory + '/');
        if (path.match(/^\/([A-Z]\:)/)) {
            path = path.slice(1);
        }
        return decodeURIComponent(path) + file;
    };
    
    function modifyMapEvents(code, p1, p2, p3) {
        var fs = require('fs');
        var MapInfos = JSON.parse(fs.readFileSync(filePath('data', 'MapInfos.json'), 'utf-8'));
        MapInfos.forEach(function(map) {
            if (map) {
                var json = fs.readFileSync(filePath('data', 'Map%1.json').format(map.id.padZero(3)), 'utf-8')
                var Map = JSON.parse(json);
                var modify = false;
                Map.events.forEach(function(event) {
                    if (event) {
                        event.pages.forEach(function(page) {
                            if (page) {
                                page.list.forEach(function(list) {
                                    if ((list.code >= 231) && (list.code <= 235)) {
                                        if (code != 3) {
                                            if ((list.parameters[0] >= p1) && (list.parameters[0] <= p2)) {
                                                if (code == 1) {
                                                    list.parameters[0] = p3;
                                                } else {
                                                    list.parameters[0] += p3;
                                                }
                                                modify = true;
                                            }
                                        } else {
                                            if (list.parameters[1] === p1) {
                                                list.parameters[1] = p2;
                                                modify = true;
                                            }
                                        }
                                    }
                                });
                            }
                        });
                    }
                });
                if (modify) {
                    var date = new Date();
                    var date = '' + date.getFullYear() + (date.getMonth() + 1).padZero(2) + date.getDate().padZero(2)
                                  + date.getHours().padZero(2) + date.getMinutes().padZero(2) + date.getSeconds().padZero(2);
                    fs.writeFile(filePath('data', 'Map%1.json').format(map.id.padZero(3)), JSON.stringify(Map));
                    if (BackupOldData) {
                        if (!fs.existsSync(filePath('backup', ''))) {
                            fs.mkdirSync(filePath('backup', ''));
                        }
                        fs.writeFile(filePath('backup', 'Map%1_%2.json').format(map.id.padZero(3), date), json);
                    }
                }
            }
        });
    }

    function modifyCommonEvents(code, p1, p2, p3) {
        var fs = require('fs');
        var json = fs.readFileSync(filePath('data', 'CommonEvents.json'), 'utf-8');
        var CommonEvents = JSON.parse(json);
        var modify = false;
        CommonEvents.forEach(function(event) {
           if (event) {
               event.list.forEach(function(list) {
                   if ((list.code >= 231) && (list.code <= 235)) {
                        if (code != 3) {
                            if ((list.parameters[0] >= p1) && (list.parameters[0] <= p2)) {
                                if (code == 1) {
                                    list.parameters[0] = p3;
                                } else {
                                    list.parameters[0] += p3;
                                }
                                modify = true;
                            }
                        } else {
                            if (list.parameters[1] === p1) {
                                list.parameters[1] = p2;
                                modify = true;
                            }
                        }
                   }
               });
           }
        });
        if (modify) {
            var date = new Date();
            var date = '' + date.getFullYear() + (date.getMonth() + 1).padZero(2) + date.getDate().padZero(2)
                          + date.getHours().padZero(2) + date.getMinutes().padZero(2) + date.getSeconds().padZero(2);
            fs.writeFile(filePath('data', 'CommonEvents.json'), JSON.stringify(CommonEvents));
            if (BackupOldData) {
                if (!fs.existsSync(filePath('backup', ''))) {
                    fs.mkdirSync(filePath('backup', ''));
                }
                fs.writeFile(filePath('backup', 'CommonEvents_%1.json').format(date), json);
            }
        }
    }

    var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function (command, args) {
        _Game_Interpreter_pluginCommand.call (this, command, args);
        if ($gameTemp.isPlaytest()) {
            var code = 0;
            var params = [Number(args[0]) || 0, Number(args[1]) || 0, Number(args[2]) || 0];
            switch (command) {
                case 'MPE_SET_NUMBER':
                    code = 1;
                    break;
                case 'MPE_ADD_NUMBER':
                    code = 2;
                    break;
                case 'MPE_RENAME':
                    code = 3;
                    params[0] = args[0];
                    params[1] = args[1];
                    break;
            }
            if (code) {
                modifyMapEvents(code, params[0], params[1], params[2]);
                modifyCommonEvents(code, params[0], params[1], params[2]);
            }
        }
    }
}());
