/*:
 * @target MZ
 * @plugindesc イベント実行をクリックまたは決定キー入力まで一時停止します。
 * @author トリアコンタン MarkⅡ
 *
 * @command WaitForClick
 * @text クリック待ち
 * @desc プレイヤーがクリックまたは決定キーを押すまでイベントの実行を停止します。
 *
 * @help
 * 【使用方法】
 * イベントコマンドの「プラグインコマンド」から
 * このプラグインの「クリック待ち」を選択してください。
 *
 * または、スクリプトコマンドで次のように書くこともできます：
 *   this.pluginCommand('WaitForClick', []);
 *
 * プレイヤーがクリックまたは決定キー（Enter/Z/Spaceなど）を押すと
 * 次のイベントコマンドへ進みます。
 */

(() => {
    const pluginName = "WaitForClick";

    PluginManager.registerCommand(pluginName, "WaitForClick", function() {
        this._waitForClick = true;
    });

    const _GameInterpreter_updateWaitMode = Game_Interpreter.prototype.updateWaitMode;
    Game_Interpreter.prototype.updateWaitMode = function() {
        if (this._waitForClick) {
            if (TouchInput.isTriggered() || Input.isTriggered("ok")) {
                this._waitForClick = false;
                return false;
            }
            return true;
        }
        return _GameInterpreter_updateWaitMode.apply(this, arguments);
    };
})();
