/*:
 * @target MZ
 * @plugindesc ピクチャ表示・消去時にコンソールへ情報出力 v1.0
 * @author ChatGPT
 * @help
 * イベントコマンドで「ピクチャの表示」を実行すると
 *   Picture ID と 画像ファイル名 をコンソールに出力します。
 * 「ピクチャの消去」を実行すると
 *   Picture ID をコンソールに出力します。
 *
 * プラグインコマンドはありません。
 */

(() => {
    "use strict";

    // 元のshowPictureを退避
    const _Game_Screen_showPicture = Game_Screen.prototype.showPicture;
    Game_Screen.prototype.showPicture = function(pictureId, name, origin, x, y, scaleX, scaleY, opacity, blendMode) {
        console.log(`ピクチャ表示: ID=${pictureId}, ファイル="${name}"`);
        _Game_Screen_showPicture.apply(this, arguments);
    };

    // 元のerasePictureを退避
    const _Game_Screen_erasePicture = Game_Screen.prototype.erasePicture;
    Game_Screen.prototype.erasePicture = function(pictureId) {
        console.log(`ピクチャ削除: ID=${pictureId}`);
        _Game_Screen_erasePicture.apply(this, arguments);
    };
})();
