/*:
 * @target MZ
 * @plugindesc ピクチャの名前を自動変更
 * @author DB
 *
 * @param OriginPictures
 * @text 派生元画像ファイル
 * @desc 装備画面で自動表示する裸の立ち絵ファイルを指定してください（通常）
 * @default []
 * @type file[]
 * @option img/pictures/picture1.png
 * @option img/pictures/picture2.png
 * @option img/pictures/picture3.png
 * @parent ボ
 *
 * @param SwitchNames
 * @text スイッチと名前の対応
 * @desc スイッチの番号とそれに対応する名前のセットを指定してください。
 * @type struct<SwitchName>[]
 * @default []
 *
 */
 /*~struct~SwitchName:
 * @param SwitchNumber
 * @text スイッチ番号
 * @desc 名前を変更するためのスイッチの番号を指定してください。
 * @type switch
 *
 * @param Name
 * @text 名前
 * @desc スイッチがONの場合に追加される名前を指定してください。
 * @type string
 */


const parameters = PluginManager.parameters('picturenameMZ');
const originPictures = JSON.parse(parameters['OriginPictures']);
const switchNames = JSON.parse(parameters['SwitchNames'] || '[]');

	
Game_Screen.prototype.nameplus = function() {
    for (const switchName of switchNames) {
        const switchInfo = JSON.parse(switchName); // JSON形式の文字列をオブジェクトに変換
        const switchNumber = Number(switchInfo.SwitchNumber);
        const name = switchInfo.Name;
        if ($gameSwitches.value(switchNumber)) {
            return name;
        }
    }
    return '';
};


// prettier-ignore
Game_Screen.prototype.showPicture = function(
    pictureId, name, origin, x, y, scaleX, scaleY, opacity, blendMode
	) {
		for(i = 0 ; i < originPictures.length ; i++){
		var originWithoutPath = originPictures[i].replace('img/pictures/', '');


		    if(name == originWithoutPath){
		    	name += this.nameplus();
		    	break;
			}
		}
    const realPictureId = this.realPictureId(pictureId);
    const picture = new Game_Picture();
    picture.show(name, origin, x, y, scaleX, scaleY, opacity, blendMode);
    this._pictures[realPictureId] = picture;
};