//=============================================================================
// RPG Maker MZ - Battle Scene Custom
//=============================================================================

/*:
 * @target MZ
 * @plugindesc 戦闘シーンの配置をカスタマイズします。
 * @author sun_dundy
 * @url https://star-write-dream.com/
 *
 * @help BattleSceneCustom.js(ver1.0.2)
 *
 * 戦闘シーンの配置をカスタマイズします。
 *
 *
 * --------------------------
 * ■利用規約
 *
 * Copyright (c) 2023 sun_dandy
 * https://star-write-dream.com/
 *
 * 以下に定める条件に従い、本プラグインファイル（以下「ソフトウェア」）の
 * 制作依頼者（以下、購入者）に対し、ソフトウェアを変更し、
 * 購入者の制作する作品（以下、制作物）に組み込むことを許可します。
 * 制作物の内容および公開形式に制約はありません。
 *
 * ソフトウェア単体で掲載、頒布、共有することはできません。
 * 上記の著作権表示および本許諾表示は変更できず、削除もできません。
 * 別途、制作物の重要な箇所にソフトウェアの著作権表示をする必要はありません。
 *
 * ソフトウェアは「現状のまま」で、明示であるか暗黙であるかを問わず、
 * 何らの保証もなく提供されます。ここでいう保証とは、商品性、
 * 特定の目的への適合性、および権利非侵害についての保証も含みますが、
 * それに限定されるものではありません。作者または著作権者は、契約行為、
 * 不法行為、またはそれ以外であろうと、ソフトウェアに起因または関連し、
 * あるいはソフトウェアの使用またはその他の扱いによって生じる一切の請求、
 * 損害、その他の義務について何らの責任も負わないものとします。
 * --------------------------
 *
 * @param labelWidth
 * @text ゲージラベルの幅
 * @type number
 * @desc バトルステータスのゲージラベルの幅を設定します。
 * @default 40
 *
 */

(() => {
    "use strict";
    const pluginName = "BattleSceneCustom";

	const parameters = PluginManager.parameters(pluginName);
	const labelWidth = Number(parameters["labelWidth"]) || 40;

    // Scene_Battle

    Scene_Battle.prototype.statusWindowRect = function () {
        const extra = 10;
        const ww = Graphics.boxWidth / 2 - 192;
        const wh = this.windowAreaHeight() + extra;
        const wx = 192;
        const wy = Graphics.boxHeight - wh + extra - 4;
        return new Rectangle(wx, wy, ww, wh);
    };

    Scene_Battle.prototype.enemyWindowRect = function () {
        const wx = this._statusWindow.x;
        const ww = Graphics.boxWidth - 192;
        const wh = this.windowAreaHeight();
        const wy = Graphics.boxHeight - wh;
        return new Rectangle(wx, wy, ww, wh);
    };

    Scene_Battle.prototype.isRightInputMode = function () {
        return false;
    };

    // ----------------------
    // Window_BattleStatus

    Window_BattleStatus.prototype.maxCols = function () {
        return 2;
    };

    Window_StatusBase.prototype.placeGauge = function(actor, type, x, y) {
        const key = "actor%1-gauge-%2".format(actor.actorId(), type);
        const sprite = actor._actorId > 0 ? this.createInnerSprite(key, Sprite_Gauge_BattleActor) : this.createInnerSprite(key, Sprite_Gauge);
        sprite.setup(actor, type);
        sprite.move(x, y);
        sprite.show();
    };

    // ----------------------
    // ステータス用の少し長いゲージ

    class Sprite_Gauge_BattleActor extends Sprite_Gauge{
        bitmapWidth() {
            return this._bitmapWidth = 180;
        };

        labelWidth(){
            return labelWidth;
        }

        measureLabelWidth() {
            this.setupLabelFont();
            const labels = [TextManager.hpA, TextManager.mpA, TextManager.tpA];
            const widths = labels.map(str => this.bitmap.measureTextWidth(str));
            if (widths.some(el => el > 0)) {
                return this.labelWidth();
            } else {
                return 0;
            }
        };

        drawLabel() {
            const label = this.label();
            const x = this.labelOutlineWidth() / 2;
            const y = this.labelY();
            const width = this.labelWidth();
            const height = this.textHeight();
            this.setupLabelFont();
            this.bitmap.paintOpacity = this.labelOpacity();
            this.bitmap.drawText(label, x, y, width, height, "left");
            this.bitmap.paintOpacity = 255;
        };
    }

})();
