//=============================================================================
// MOG_SceneMenu_FileRename.js
// ----------------------------------------------------------------------------
// (C) 2018 astral
//
// ----------------------------------------------------------------------------
// Version
// 1.1.1 2021/01/03 MZ版動作検証・対応
// 1.1   2020/12/15 リファクター、falsyな設定値へ対応
// 1.0.1 2019/11/2 オリジナルの利用規約内で利用できるようMITLicenceを変更
// 1.0   2018/10/22 初版

/*:
 * @plugindesc  MOG SceneMenu / BattleCommandsでファイル名を変更します
 * @author astral
 * @target MZ
 *
 * @param changeFileList
 * @text 変更するファイル名一覧
 * @desc 変更するファイル名一覧
 * @type  struct<fileNameList>[]
 * @default ["{\"menuCommand\":\"アイテム\",\"loadFile\":\"Item\"}","{\"menuCommand\":\"装備\",\"loadFile\":\"Equip\"}","{\"menuCommand\":\"スキル\",\"loadFile\":\"Skill\"}","{\"menuCommand\":\"ステータス\",\"loadFile\":\"Status\"}","{\"menuCommand\":\"並び替え\",\"loadFile\":\"Formation\"}","{\"menuCommand\":\"オプション\",\"loadFile\":\"Options\"}","{\"menuCommand\":\"セーブ\",\"loadFile\":\"Save\"}","{\"menuCommand\":\"ゲーム終了\",\"loadFile\":\"Game End\"}","{\"menuCommand\":\"Com_攻撃\",\"loadFile\":\"Com_Attack\"}","{\"menuCommand\":\"Com_防御\",\"loadFile\":\"Com_Guard\"}","{\"menuCommand\":\"Com_アイテム\",\"loadFile\":\"Com_Item\"}","{\"menuCommand\":\"Com_魔法\",\"loadFile\":\"Com_Magic\"}","{\"menuCommand\":\"Com_必殺技\",\"loadFile\":\"Com_Special\"}"]
 *
 *
 * @help
 *
 + 配布元
 * http://forum.tkool.jp/index.php?threads/%E4%BD%BF%E3%81%84%E6%96%B9%E3%81%A8%E3%83%86%E3%83%B3%E3%83%97%E3%83%AC%E3%83%BC%E3%83%88.59/post-10968
 * https://forum.tkool.jp/index.php?threads/2806/
 *
 * 下記プラグインで日本語等のコマンド名を使用した場合に、
 * 読み込まれるファイルを別のファイル名へ置き換えます。
 *
 * MOG_SceneMenu.js
 * MOG_BattleCommands.js
 *
 * プラグイン登録
 *  MOG_BattleCommands.js
 *  MOG_SceneMenu.js
 *  の下になるよう配置してください。
 *
 * プラグインパラメータ
 *  変更前のファイル名と変更後のファイル名を指定してください。
 *  基本的に大文字小文字は区別されます。
 *
 *  .pngなどの拡張子は不要です。
 *
 * 新規プロジェクトで使用されるものは設定済みなので、コマンドを追加される場合に追加してください。
 *
 * 例：
 *  変更前のファイル名：アイテム
 *  変更後のファイル名：Item
 *
 *
 * [1]、という最初と最後が[]で構成されるファイル名の場合は、"[1]"と入力してください。
 *
 *
 * MOG - Scene Menu (v1.2)について
 * https://atelierrgss.wordpress.com/
 *
 * 利用規約の範囲内で利用可能です。
 * https://atelierrgss.wordpress.com/about/
 *
 * 配布終了後もCC0扱いで利用可能です。
 *
 * -_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-
 * 本プラグインは、ツクールMV用プラグインを
 * 第三者がMZ向けに移植したものです。
 * 移行元バージョン：1.1.1
 *
 * ☆サポート先はMV版作者様ではありません。
 * -_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-
 *
 */
/*~struct~fileNameList:
 * @param menuCommand
 * @text 変更前のファイル名
 * @type string
 * @desc このファイルが呼び出された時を対象とします。大文字小文字も区別されます。
 *
 * @param loadFile
 * @text 変更後のファイル名
 * @type string
 * @desc 実在するファイル名を指定します。Windows以外では大文字小文字が区別されます。
 */


(function () {
    'use strict';

    var parameters = PluginManager.parameters('MOG_SceneMenu_FileRename');

    var param = JSON.parse(JSON.stringify(parameters, function (key, value) {
        if (value[0] === '"' && value[value.length - 1] === '"') {
            return value;
        }
        try {
            return JSON.parse(value);
        } catch (e) {
            return value;
        }
    }));

    var changeList = (param.changeFileList || []).reduce(function (a, c) {
        function toString(str) {
            str = String(str);
            if (str[0] === '"' && str[str.length - 1] === '"') {
                str = str.slice(1).slice(0,-1);
            }
            return str;
        };
        if (c.menuCommand === '' || c.loadFile === '' || c.loadFile === '""') return a;
        a[c.menuCommand] = toString(c.loadFile);
        return a;
    }, {});

    var replaceLoadFile = function (filename) {
        return changeList[filename] !== undefined ? changeList[filename] : filename;
    };

    //=============================================================================
    // ** ImageManager
    //=============================================================================

    //==============================
    // * Main Commands
    //==============================
    if (ImageManager.loadMenusMainCommands) {
        var _ImageManager_loadMenusMainCommands = ImageManager.loadMenusMainCommands;
        ImageManager.loadMenusMainCommands = function (filename) {
            return _ImageManager_loadMenusMainCommands.call(this, replaceLoadFile(filename));
        };
    }
    //==============================
    // * BHud
    //==============================

    if (ImageManager.loadBcom) {
        var _ImageManager_loadBcom = ImageManager.loadBcom;
        ImageManager.loadBcom = function(filename) {
            return _ImageManager_loadBcom.call(this, replaceLoadFile(filename));
        };
    }

})();