﻿/*
 * --------------------------------------------------
 * MOG_SceneMenu_loop_patch
 * Copyright (c) 2020 Munokura
 * This software is released under the MIT license.
 * http://opensource.org/licenses/mit-license.php
 * --------------------------------------------------
 */

/*:
 * @plugindesc MOG_SceneMenu.js のメニューを左右ループするように変更します
 * @author munokura
 * @orderAfter MOG_SceneMenu
 * @target MZ
 *
 * @help
 * MOG Scene Menu のメニューを左右ループするように変更します。
 * プラグイン管理でMOG_SceneMenuの下側に配置してください。
 *
 *
 * -_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-
 * 本プラグインは、ツクールMV用プラグインを
 * 第三者がMZ向けに移植したものです。
 *
 * ☆サポート先はMV版作者様ではありません。
 * -_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-
 *
 */

(function () {
	'use strict';

	Window_MenuCommand.prototype.processCursorMove = function () {
		if (this.isCursorMovable()) {
			var lastIndex = this.index();
			if (Input.isRepeated('down') || Input.isRepeated('right')) {
				this.cursorDown(true);	//ecf5DTTzl6h6lJj02氏改変
			};
			if (Input.isRepeated('up') || Input.isRepeated('left')) {
				this.cursorUp(true);	//ecf5DTTzl6h6lJj02氏改変
			};
			if (this.index() !== lastIndex) {
				SoundManager.playCursor();
			};
		};
	};

})();
