
//=============================================================================
// SimpleVoiceAdd_Villaa.js
// Copyright (c) 2021- 村人Ａ
//=============================================================================

/*:ja
 * @plugindesc SimpleVoiceプラグインに機能を追加するプラグインです。
 * @author 村人Ａ
 *
 * @help
 * ＊このプラグインはサークル萌工房様専用に作られたプラグインです。
 * ＊その他の方の無断の使用を禁止します。
 * 
 * _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
 * 
 * バージョン情報
 * 
 * 23/08/31 バージョン1.0 MZ改修
 * 
 * _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
 * 
 * ========================================
 * 以下ヘルプ
 * ========================================
 * 
 * このプラグインはSimpleVoiceよりも下に配置してください。
 * 
 * プラグインコマンド
 * 
 * ボイス予約のキャンセル チャンネル
 * 
 * と指定することで予約されている音声をキャンセルすることができます。
 * 
 * ex)チャンネル３に予約されている音声をキャンセルする
 * 
 * ボイス予約のキャンセル 3
 * 
 * @command SV_CANCEL_RESERVED_VOICE
 * @text ボイス予約のキャンセル
 * @desc 演奏中のボイスを停止します。ファイルを直接指定するかチャンネル番号を指定して停止します。
 *
 * @arg channel
 * @text チャンネル番号
 * @desc 停止するボイスのチャンネル番号です。
 * @default 0
 * @type number
 *
*/

{	
	'use strict'
	
	AudioManager.reservedVoiceTimeoutArray = [];
	
    var pluginName    = 'SimpleVoiceAdd_Villaa';
	
    //=============================================================================
    // Game_Interpreter
    //  プラグインコマンドを追加定義します。
    //=============================================================================
	
	const _alias_Game_Interpreter_initialize = Game_Interpreter.prototype.initialize;
	Game_Interpreter.prototype.initialize = function(depth) {
		_alias_Game_Interpreter_initialize.call(this, depth)
		this.simpleVoiceCancelReserveChannels = [];
	}
	
    const _alias_Game_Interpreter_command357  = Game_Interpreter.prototype.command357;
	Game_Interpreter.prototype.command357 = function(params) {
		const args = Object.values(params[3])
		if(params[0] == "SimpleVoice"){
			if (params[2] == "ボイスの予約" || params[1] == "SV_RESERVE_VOICE" || params[2] == "ループボイスの予約" || params[1] == "SV_RESERVE_LOOP_VOICE"){
				const channel = args.length >= 5 ? Number(args[4]) : 2;
				if(this.simpleVoiceCancelReserveChannels.includes(channel)){
					this.simpleVoiceCancelReserveChannels.splice(this.simpleVoiceCancelReserveChannels.indexOf(channel), 1)
				}
			}
			
			if (params[2] == "ボイスの演奏" || params[1] == "SV_PLAY_VOICE"){
				const channel  = args.length >= 5 ? Number(args[4]) : 2;
				$gameSystem.nearVoiceChannel = channel;
			}
		}
		
		if(params[0] == pluginName){
			if (params[2] == "ボイス予約のキャンセル" || params[1] == "SV_CANCEL_RESERVED_VOICE"){
				this.simpleVoiceCancelReserveChannels.push(Number(args[0]))
			}
		}
		return _alias_Game_Interpreter_command357.call(this, params);
	}

	//23/04/30 追記
    var getArgNumber = function(arg, min, max) {
        if (arguments.length < 2) min = -Infinity;
        if (arguments.length < 3) max = Infinity;
        return (parseInt(arg) || 0).clamp(min, max);
    };

	//23/04/30 追記
	const _alias_Game_Interpreter_execReserveVoice = Game_Interpreter.prototype.execReserveVoice;
    Game_Interpreter.prototype.execReserveVoice = function(args, loop) {
        var channel = args.length >= 5 ? getArgNumber(args[4], 1) : undefined;
		if(this.simpleVoiceCancelReserveChannels.includes(channel)){
			this.simpleVoiceCancelReserveChannels.splice(this.simpleVoiceCancelReserveChannels.indexOf(channel), 1)
			return
		}
        if (AudioManager.isExistVoiceChannel(channel)) {
			const timeout = setTimeout(this.execReserveVoice.bind(this, args, loop), 16)
			const arr = AudioManager.reservedVoiceTimeoutArray[channel];
			if(arr){
				clearTimeout(arr[1]);
				arr[1] = null
			}
			AudioManager.reservedVoiceTimeoutArray[channel] = [this, timeout, args, loop];
            return;
        }
		AudioManager.reservedVoiceTimeoutArray[channel] = null
		_alias_Game_Interpreter_execReserveVoice.call(this, args, loop);
    };

	//オートメッセージ機能の不具合についての対策
    AudioManager.isExistVoice = function() {
        if (!AudioManager._voiceBuffers) {
            return false;
        }
        this.filterPlayingVoice();
        return this._voiceBuffers.some(function(buffer) {
			//0304修正　buffer._sourceNode判定を追加
            return buffer.isPlaying() && buffer._sourceNode && !buffer._sourceNode.loop;
        });
    }

	const _alias_Game_Interpreter_execStopVoice = Game_Interpreter.prototype.execStopVoice;
    Game_Interpreter.prototype.execStopVoice = function(args) {
        const channel = Number(args[0]);
		if(this.simpleVoiceCancelReserveChannels.includes(channel)){
			this.simpleVoiceCancelReserveChannels.splice(this.simpleVoiceCancelReserveChannels.indexOf(channel), 1)
			if(AudioManager.reservedVoiceTimeoutArray[channel])clearTimeout(AudioManager.reservedVoiceTimeoutArray[channel][1]);
			AudioManager.reservedVoiceTimeoutArray[channel] = null;
		}
		_alias_Game_Interpreter_execStopVoice.call(this, args);
    };

}


























