//=============================================================================
// VisuStella MZ - Battle Core
// VisuMZ_1_BattleCore.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_1_BattleCore = true;

var VisuMZ = VisuMZ || {};
VisuMZ.BattleCore = VisuMZ.BattleCore || {};
VisuMZ.BattleCore.version = 1.75;

//=============================================================================
 /*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 1] [Version 1.75] [BattleCore]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/Battle_Core_VisuStella_MZ
 * @orderAfter VisuMZ_0_CoreEngine
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 *
 * The Battle Core plugin revamps the battle engine provided by RPG Maker MZ to
 * become more flexible, streamlined, and support a variety of features. The
 * updated battle engine allows for custom Action Sequences, battle layout
 * styles, and a lot of control over the battle mechanics, too.
 *
 * Features include all (but not limited to) the following:
 * 
 * * Action Sequence Plugin Commands to give you full control over what happens
 *   during the course of a skill or item.
 * * Animated Sideview Battler support for enemies!
 * * Auto Battle options for party-wide and actor-only instances.
 * * Base Troop Events to quickly streamline events for all Troop events.
 * * Battle Command control to let you change which commands appear for actors.
 * * Battle Layout styles to change the way the battle scene looks.
 * * Casting animation support for skills.
 * * Critical Hit control over the success rate formula and damage multipliers.
 * * Custom target scopes added for skills and items.
 * * Damage formula control, including Damage Styles.
 * * Damage caps, both hard caps and soft caps.
 * * Damage traits such Armor Penetration/Reduction to bypass defenses.
 * * Elements & Status Menu Core support for traits.
 * * Multitude of JavaScript notetags and global Plugin Parameters to let you
 *   make a variety of effects across various instances during battle.
 * * Party Command window can be skipped/disabled entirely.
 * * Weather effects now show in battle.
 * * Streamlined Battle Log to remove redundant information and improve the
 *   flow of battle.
 * * Visual HP Gauges can be displayed above the heads of actors and/or enemies
 *   with a possible requirement for enemies to be defeated at least once first
 *   in order for them to show.
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Tier 1 ------
 *
 * This plugin is a Tier 1 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ library.
 *
 * ============================================================================
 * Major Changes
 * ============================================================================
 *
 * This plugin will overwrite some core parts of the RPG Maker MZ base code in
 * order to ensure the Battle Core plugin will work at full capacity. The
 * following are explanations of what has been changed.
 *
 * ---
 *
 * Action Sequences
 *
 * - Action sequences are now done either entirely by the Battle Log Window or
 * through common events if the <Custom Action Sequence> notetag is used.
 * In RPG Maker MZ by default, Action Sequences would be a mixture of using the
 * Battle Log Window, the Battle Manager, and the Battle Scene, making it hard
 * to fully grab control of the situation.
 *
 * ---
 *
 * Action Speed
 *
 * - Action speeds determine the turn order in the default battle system. The
 * AGI of a battle unit is also taken into consideration. However, the random
 * variance applied to the action speed system makes the turn order extremely
 * chaotic and hard for the player to determine. Thus, the random variance
 * aspect of it has been turned off. This can be reenabled by default through
 * Plugin Parameters => Mechanics Settings => Allow Random Speed?
 *
 * ---
 *
 * Animated Sideview Battler Support For Enemies
 *
 * - Enemies can now use Sideview Actor sprites for themselves! They will
 * behave like actors and can even carry their own set of weapons for physical
 * attacks. These must be set up using notetags. More information can be found
 * in the notetag section.
 *
 * - As the sprites are normally used for actors, some changes have been made
 * to Sprite_Actor to be able to support both actors and enemies. These changes
 * should have minimal impact on other plugins.
 *
 * ---
 *
 * Battle Sprite Updates
 *
 * - A lot of functions in Sprite_Battler, Sprite_Actor, and Sprite_Enemy have
 * been overwritten to make the new Action Sequence system added by this plugin
 * possible. These changes make it possible for the sprites to move anywhere on
 * the screen, jump, float, change visibility, and more.
 *
 * ---
 *
 * Change Battle Back in Battle
 * 
 * - By default, the Change Battle Back event command does not work in battle.
 * Any settings made to it will only reflect in the following battle. Now, if
 * the battle back event command is used during battle, it will reflect upon
 * any new changes immediately.
 *
 * ---
 *
 * Critical Hit - LUK Influence
 *
 * - The LUK Buffs now affect the critical hit rate based off how the formula
 * is now calculated. Each stack of a LUK Buff will double the critical hit
 * rate and compound upon that. That means a x1 LUK Buff stack will raise it by
 * x2, a x2 LUK Buff stack will raise the critical hit rate by x4, a x3 LUK
 * Buff Stack will raise the critical hit rate stack by x8, and so on.
 *
 * - LUK also plays a role in how much damage is dealt with critical hits. The
 * default critical hit multiplier has been reduced from x3 to x2. However, a
 * percentage of LUK will added on (based off the user's CRI rate) onto the
 * finalized critical damage. If the user's CRI rate is 4%, then 4% of the user
 * LUK value will also be added onto the damage.
 *
 * - This change can be altered through Plugin Parameters => Damage Settings =>
 * Critical Hits => JS: Rate Formula and JS: Damage Formula.
 *
 * ---
 * 
 * Damage Popups
 * 
 * - Damage popups are now formatted with + and - to determine healing and
 * damage. MP Damage will also include "MP" at the back. This is to make it
 * clearer what each colored variant of the damage popup means as well as help
 * color blind players read the on-screen data properly.
 * 
 * - Damage popups have also been rewritten to show all changed aspects instead
 * of just one. Previously with RPG Maker MZ, if an action would deal both HP
 * and MP damage, only one of them would show. Now, everything is separated and
 * both HP and MP changes will at a time.
 * 
 * ---
 * 
 * Dual Wielding
 * 
 * - Previously, RPG Maker MZ had "Dual Wielding" attack using both weapon
 * animations at once, with the combined ATK of each weapon. It's confusing to
 * look at and does not portray the nature of "Dual Wielding".
 * 
 * - Dual Wielding, or in the case of users adding in third and fourth weapons,
 * Multi Wielding is now changed. Each weapon is displayed individually, each
 * producing its own attack animation, showing each weapon type, and applying
 * only that weapon's ATK, Traits, and related effects. It is no longer a
 * combined effect to display everything at once like RPG Maker MZ default.
 * 
 * - If an actor has multiple weapon slots but some of them are unequipped,
 * then the action will treat the attack as a single attack. There will be no
 * barehanded attack to add on top of it. This is to match RPG Maker MZ's
 * decision to omit a second animation if the same scenario is applied.
 * 
 * ---
 *
 * Force Action
 *
 * - Previously, Forced Actions would interrupt the middle of an event to
 * perform an action. However, with the addition of more flexible Action
 * Sequences, the pre-existing Force Action system would not be able to exist
 * and would require being remade.
 *
 * - Forced Actions now are instead, added to a separate queue from the action
 * battler list. Whenever an action and/or common event is completed, then if
 * there's a Forced Action battler queued, then the Forced Action battler will
 * have its turn. This is the cleanest method available and avoids the most
 * conflicts possible.
 *
 * - This means if you planned to make cinematic sequences with Forced Actions,
 * you will need to account for the queued Force Actions. However, in the case
 * of battle cinematics, we would highly recommend that you use the newly added
 * Action Sequence Plugin Commands instead as those give you more control than
 * any Force Action ever could.
 *
 * ---
 *
 * Random Scope
 *
 * - The skill and item targeting scopes for Random Enemy, 2 Random Enemies,
 * 3 Random Enemies, 4 Random Enemies will now ignore TGR and utilize true
 * randomness.
 *
 * ---
 *
 * Spriteset_Battle Update
 *
 * - The spriteset now has extra containers to separate battlers (actors and
 * enemies), animations, and damage. This is to make actors and enemy battler
 * sprites more efficient to sort (if enabled), so that animations won't
 * interfere with and cover damage sprites, and to make sure damage sprites are
 * unaffected by screen tints in order to ensure the player will always have a
 * clear read on the information relaying sprites.
 *
 * ---
 * 
 * TPB/ATB Active Battle Actor Shifting
 * 
 * - Pressing cancel on the Actor Command Window no longer switches between
 * actors with a full TPB/ATB gauge before reaching the Party Command Window.
 * This is to accomplish a couple of things: 1) reduce the number of button
 * presses to reach the Party Command Window and 2) to prevent motion resets
 * and disrupting action sequences. If this feature is vital to your battle
 * system, we recommend that you do not use this plugin or any of the Battle
 * Core-required plugins.
 * 
 * ---
 *
 * Weather Displayed in Battle
 *
 * - Previously, weather has not been displayed in battle. This means that any
 * weather effects placed on the map do not transfer over to battle and causes
 * a huge disconnect for players. The Battle Core plugin will add weather
 * effects to match the map's weather conditions. Any changes made to weather
 * through event commands midway through battle will also be reflected.
 *
 * ---
 *
 * ============================================================================
 * Base Troops
 * ============================================================================
 *
 * Base Troops can be found, declared, and modified in the Plugin Parameters =>
 * Mechanics Settings => Base Troop ID's. All of the listed Troop ID's here
 * will have their page events replicated and placed under all other troops
 * found in the database.
 *
 * ---
 *
 * This means that if you have an event that runs on Turn 1 of a Base Troop,
 * then for every troop out there, that same event will also run on Turn 1,
 * as well. This is useful for those who wish to customize their battle system
 * further and to reduce the amount of work needed to copy/paste said event
 * pages into every database troop object manually.
 *
 * ---
 *
 * ============================================================================
 * Damage Styles
 * ============================================================================
 *
 * Damage Styles are a new feature added through the Battle Core plugin. When
 * using certain Battle Styles, you can completely ignore typing in the whole
 * damage formula inside the damage formula input box, and instead, insert
 * either a power amount or a multiplier depending on the Damage Style. The
 * plugin will then automatically calculate damage using that value factoring
 * in ATK, DEF, MAT, MDF values.
 *
 * ---
 *
 * Here is a list of the Damage Styles that come with this plugin by default.
 * You can add in your own and even edit them to your liking.
 * Or just remove them if you want.
 *
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Style          Use Formula As   PH/MA Disparity   Stat Scale   Damage Scale
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Standard       Formula          No                Varies       Varies
 * ArmorScaling   Formula          No                Varies       Varies
 * CT             Multiplier       Yes               Low          Normal
 * D4             Multiplier       No                High         Normal
 * DQ             Multiplier       No                Low          Low
 * FF7            Power            Yes               Low          High
 * FF8            Power            Yes               Medium       Normal
 * FF9            Power            Yes               Low          Normal
 * FF10           Power            Yes               Medium       High
 * MK             Multiplier       No                Medium       Low
 * MOBA           Multiplier       No                Medium       Normal
 * PKMN           Power            No                Low          Normal
 *
 * Use the above chart to figure out which Damage Style best fits your game,
 * if you plan on using them.
 *
 * The 'Standard' style is the same as the 'Manual' formula input, except that
 * it allows for the support of <Armor Penetration> and <Armor Reduction>
 * notetags.
 *
 * The 'Armor Scaling' style allows you to type in the base damage calculation
 * without the need to type in any defending modifiers.
 *
 * NOTE: While these are based off the damage formulas found in other games,
 * not all of them are exact replicas. Many of them are adapted for use in
 * RPG Maker MZ since not all RPG's use the same set of parameters and not all
 * external multipliers function the same way as RPG Maker MZ.
 * 
 * ---
 *
 * Style:
 * - This is what the Damage Style is.
 *
 * Use Formula As:
 * - This is what you insert into the formula box.
 * - Formula: Type in the formula for the action just as you would normally.
 * - Multiplier: Type in the multiplier for the action.
 *     Use float values. This means 250% is typed out as 2.50
 * - Power: Type in the power constant for the action.
 *     Use whole numbers. Type in something like 16 for a power constant.
 * 
 * PH/MA Disparity:
 * - Is there a disparity between how Physical Attacks and Magical Attacks
 *   are calculated?
 * - If yes, then physical attacks and magical attacks will have different
 *   formulas used.
 * - If no, then physical attacks and magical attacks will share similar
 *   formulas for how they're calculated.
 *
 * Stat Scale:
 * - How much should stats scale throughout the game?
 * - Low: Keep them under 100 for the best results.
 * - Medium: Numbers work from low to mid 400's for best results.
 * - High: The numbers really shine once they're higher.
 *
 * Damage Scale:
 * - How much does damage vary depending on small parameter changes?
 * - Low: Very little increase from parameter changes.
 * - Normal: Damage scales close to proportionally with parameter changes.
 * - High: Damage can boost itself drastically with parameter changes.
 *
 * ---
 *
 * To determine what kind of parameters are used for the Damage Styles, they
 * will depend on two things: the action's 'Hit Type' (ie Physical Attack,
 * Magical Attack, and Certain Hit) and the action's 'Damage Type' (ie. Damage,
 * Recovery, or Drain).
 *
 * Certain Hit tends to use whichever value is higher: ATK or MAT, and then
 * ignores the target's defense values. Use Certain Hits for 'True Damage'.
 *
 * Use the chart below to figure out everything else:
 * 
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Hit Type      Damage Type   Attacker Parameter   Defender Parameter
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Physical      Damage        ATK                  DEF
 * Magical       Damage        MAT                  MDF
 * Certain Hit   Damage        Larger (ATK, MAT)    -Ignores-
 * Physical      Recover       DEF                  -Ignores-
 * Magical       Recover       MDF                  -Ignores-
 * Certain Hit   Recover       Larger (ATK, MAT)    -Ignores-
 * Physical      Drain         ATK                  DEF
 * Magical       Drain         MAT                  MDF
 * Certain Hit   Drain         Larger (ATK, MAT)    -Ignores-
 *
 * These can be modified within the Plugin Parameters in the individual
 * Damage Styles themselves.
 *
 * ---
 *
 * Skills and Items can use different Damage Styles from the setting you've
 * selected in the Plugin Parameters. They can be altered to have different
 * Damage Styles through the usage of a notetag:
 *
 * <Damage Style: name>
 *
 * This will use whichever style is found in the Plugin Parameters.
 *
 * If "Manual" is used, then no style will be used and all calculations will be
 * made strictly based off the formula found inside the formula box.
 *
 * ---
 *
 * ============================================================================
 * VisuStella MZ Compatibility
 * ============================================================================
 *
 * While this plugin is compatible with the majority of the VisuStella MZ
 * plugin library, it is not compatible with specific plugins or specific
 * features. This section will highlight the main plugins/features that will
 * not be compatible with this plugin or put focus on how the make certain
 * features compatible.
 *
 * ---
 * 
 * VisuMZ_1_BattleCore
 * 
 * When using Action Sequences, Boost effects for damage, turn extensions,
 * analyze, etc. will not occur for anything other than the Action Sequence:
 * "MECH: Action Effect" in order to maintain controlled effects. However, if
 * you do want to apply bonuses for Boosts, utilize "MECH: Boost Store Data" to
 * store inside a variable how many times Boosts were used. This can be used
 * however which way you want it to as long as it is manageable through events
 * and Common Events.
 * 
 * ---
 *
 * ============================================================================
 * Notetags
 * ============================================================================
 *
 * The following are notetags that have been added through this plugin. These
 * notetags will not work with your game if this plugin is OFF or not present.
 * 
 * === HP Gauge-Related Notetags ===
 * 
 * The following notetags allow you to set whether or not HP Gauges can be
 * displayed by enemies regardless of Plugin Parameter settings.
 * 
 * ---
 *
 * <Show HP Gauge>
 *
 * - Used for: Enemy Notetags
 * - Will always show the HP Gauge for the enemy regardless of the defeat
 *   requirement setting.
 * - This does not bypass the player's Options preferences.
 * - This does not bypass disabling enemy HP Gauges as a whole.
 * 
 * ---
 *
 * <Hide HP Gauge>
 *
 * - Used for: Enemy Notetags
 * - Will always hide the HP Gauge for the enemy regardless of the defeat
 *   requirement setting.
 * - This does not bypass the player's Options preferences.
 * 
 * ---
 * 
 * <Battle UI Offset: +x, +y>
 * <Battle UI Offset: -x, -y>
 * 
 * <Battle UI Offset X: +x>
 * <Battle UI Offset X: -x>
 * 
 * <Battle UI Offset Y: +y>
 * <Battle UI Offset Y: -y>
 * 
 * - Used for: Actor and Enemy Notetags
 * - Adjusts the offset of HP Gauges and State Icons above the heads of actors
 *   and enemies.
 * - Replace 'x' with a number value that offsets the x coordinate.
 * - Negative x values offset left. Positive x values offset right.
 * - Replace 'y' with a number value that offsets the y coordinate.
 * - Negative y values offset up. Positive x values offset down.
 * 
 * ---
 *
 * === Animation-Related Notetags ===
 *
 * The following notetags allow you to set animations to play at certain
 * instances and/or conditions.
 *
 * ---
 *
 * <Slip Animation: x>
 *
 * - Requires VisuMZ_0_CoreEngine!
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - During the phase at which the user regenerates HP, MP, or TP, this
 *   animation will play as long as the user is alive and visible.
 * - Replace 'x' with a number value representing the Animation ID to play.
 *
 * ---
 *
 * <Cast Animation: x>
 *
 * - Used for: Skill Notetags
 * - Plays a battle animation at the start of the skill.
 * - Replace 'x' with a number value representing the Animation ID to play.
 *
 * ---
 *
 * <Attack Animation: x>
 *
 * - Used for: Enemy Notetags
 * - Gives an enemy an attack animation to play for its basic attack.
 * - Replace 'x' with a number value representing the Animation ID to play.
 *
 * ---
 *
 * === Battleback-Related Notetags ===
 *
 * You can apply these notetags to have some control over the battlebacks that
 * appear in different regions of the map for random or touch encounters.
 *
 * ---
 *
 * <Region x Battleback1: filename>
 * <Region x Battleback2: filename>
 * 
 * - Used for: Map Notetags
 * - If the player starts a battle while standing on 'x' region, then the
 *   'filename' battleback will be used.
 * - Replace 'x' with a number representing the region ID you wish to use.
 * - Replace 'filename' with the filename of the graphic to use. Do not insert
 *   any extensions. This means the file 'Castle1.png' will be only inserted
 *   as 'Castle1' without the '.png' at the end.
 * - *NOTE: This will override any specified battleback settings.
 *
 * ---
 *
 * === Battle Command-Related Notetags ===
 *
 * You can use notetags to change how the battle commands of playable
 * characters appear in battle as well as whether or not they can be used.
 *
 * ---
 *
 * <Seal Attack>
 * <Seal Guard>
 * <Seal Item>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Prevents specific battle commands from being able to be used.
 *
 * ---
 *
 * <Battle Commands>
 *  Attack
 *  Skills
 *  SType: x
 *  SType: name
 *  All Skills
 *  Skill: x
 *  Skill: name
 *  Guard
 *  Item
 *  Party
 *  Escape
 *  Auto Battle
 *  Combat Log
 *  Talk
 *  Weapon Swap
 * </Battle Commands>
 *
 * - Used for: Class Notetags
 * - Changes which commands appear in the Actor Command Window in battle.
 *   If this notetag is not used, then the default commands determined in
 *   Plugin Parameters => Actor Command Window => Command List will be used.
 * - Add/remove/modify entries as needed.
 *
 * - Attack 
 *   - Adds the basic attack command.
 * 
 * - Skills
 *   - Displays all the skill types available to the actor.
 * 
 * - SType: x
 * - Stype: name
 *   - Adds in a specific skill type.
 *   - Replace 'x' with the ID of the skill type.
 *   - Replace 'name' with the name of the skill type (without text codes).
 *
 * - All Skills
 *   - Adds all usable battle skills as individual actions.
 * 
 * - Skill: x
 * - Skill: name
 *   - Adds in a specific skill as a usable action.
 *   - Replace 'x' with the ID of the skill.
 *   - Replace 'name' with the name of the skill.
 * 
 * - Guard
 *   - Adds the basic guard command.
 * 
 * - Item
 *   - Adds the basic item command.
 *
 * - Party
 *   - Requires VisuMZ_2_PartySystem.
 *   - Allows this actor to switch out with a different party member.
 * 
 * - Escape
 *   - Adds the escape command.
 * 
 * - Auto Battle
 *   - Adds the auto battle command.
 * 
 * - Combat Log
 *   - Requires VisuMZ_4_CombatLog.
 *   - Opens up the combat log.
 * 
 * - Talk
 *   - Requires VisuMZ_3_BattleCmdTalk!
 *   - Shows talk command if applicable.
 * 
 * - Weapon Swap
 *   - Requires VisuMZ_2_WeaponSwapSystem.
 *   - Swaps the current weapon.
 *
 * Example:
 *
 * <Battle Commands>
 *  Attack
 *  Skill: Heal
 *  Skills
 *  Guard
 *  Item
 *  Escape
 * </Battle Commands>
 *
 * ---
 *
 * <Command Text: x>
 *
 * - Used for: Skill Notetags
 * - When a skill is used in a <Battle Commands> notetag set, you can change
 *   the skill name text that appears to something else.
 * - Replace 'x' with the skill's name you want to shown in the Actor Battle
 *   Command window.
 * - Recommended Usage: Shorten skill names that are otherwise too big to fit
 *   inside of the Actor Battle Command window.
 *
 * ---
 *
 * <Command Icon: x>
 *
 * - Used for: Skill Notetags
 * - When a skill is used in a <Battle Commands> notetag set, you can change
 *   the skill icon that appears to something else.
 * - Replace 'x' with the ID of icon you want shown in the Actor Battle Command
 *   window to represent the skill.
 * 
 * ---
 * 
 * <Command Require Learn>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not by whether the actor has
 *   learned the skill.
 * - Learning the skill is a requirement. Acquiring the skill through traits
 *   does not count as learning the skill.
 * 
 * ---
 * 
 * <Command Require Access>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not by whether the actor has
 *   access to the skill.
 * - Having access to the skill can come through either learning the skill or
 *   temporarily acquiring it through trait objects.
 * 
 * ---
 * 
 * <Command Show Switch: x>
 * 
 * <Command Show All Switches: x,x,x>
 * <Command Show Any Switches: x,x,x>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not through switches.
 * - Replace 'x' with the switch ID to determine the skill's visibility.
 * - If 'All' notetag variant is used, item will be hidden until all
 *   switches are ON. Then, it would be shown.
 * - If 'Any' notetag variant is used, item will be shown if any of the
 *   switches are ON. Otherwise, it would be hidden.
 * - This can be applied to Attack and Guard commands, too.
 * 
 * ---
 * 
 * <Command Hide Switch: x>
 * 
 * <Command Hide All Switches: x,x,x>
 * <Command Hide Any Switches: x,x,x>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not through switches.
 * - Replace 'x' with the switch ID to determine the skill's visibility.
 * - If 'All' notetag variant is used, item will be shown until all
 *   switches are ON. Then, it would be hidden.
 * - If 'Any' notetag variant is used, item will be hidden if any of the
 *   switches are ON. Otherwise, it would be shown.
 * - This can be applied to Attack and Guard commands, too.
 * 
 * ---
 * 
 * <Battle Portrait: filename>
 *
 * - Used for: Actor
 * - This is used with the "Portrait" Battle Layout.
 * - Sets the battle portrait image for the actor to 'filename'.
 * - Replace 'filename' with a picture found within your game project's
 *   img/pictures/ folder. Filenames are case sensitive. Leave out the filename
 *   extension from the notetag.
 * - This will override any menu images used for battle only.
 * 
 * ---
 * 
 * <Battle Portrait Offset: +x, +y>
 * <Battle Portrait Offset: -x, -y>
 * 
 * <Battle Portrait Offset X: +x>
 * <Battle Portrait Offset X: -x>
 * 
 * <Battle Portrait Offset Y: +y>
 * <Battle Portrait Offset Y: -y>
 *
 * - Used for: Actor
 * - This is used with the "Portrait" and "Border" Battle Layouts.
 * - Offsets the X and Y coordinates for the battle portrait.
 * - Replace 'x' with a number value that offsets the x coordinate.
 * - Negative x values offset left. Positive x values offset right.
 * - Replace 'y' with a number value that offsets the y coordinate.
 * - Negative y values offset up. Positive x values offset down.
 * 
 * ---
 * 
 * === JavaScript Notetag: Battle Command-Related ===
 *
 * The following are notetags made for users with JavaScript knowledge to
 * determine if skill-based battle commands are visible or hidden.
 * 
 * ---
 * 
 * <JS Command Visible>
 *  code
 *  code
 *  visible = code;
 * </JS Command Visible>
 * 
 * - Used for: Skill Notetags
 * - The 'visible' variable is the final returned variable to determine the
 *   skill's visibility in the Battle Command Window.
 * - Replace 'code' with JavaScript code to determine the skill's visibility in
 *   the Battle Command Window.
 * - The 'user' variable represents the user who will perform the skill.
 * - The 'skill' variable represents the skill to be used.
 * 
 * ---
 *
 * === Targeting-Related Notetags ===
 *
 * The following notetags are related to the targeting aspect of skills and
 * items and may adjust the scope of how certain skills/items work.
 *
 * ---
 *
 * <Always Hit>
 *
 * <Always Hit Rate: x%>
 *
 * - Used for: Skill, Item Notetags
 * - Causes the action to always hit or to always have a hit rate of exactly
 *   the marked x%.
 * - Replace 'x' with a number value representing the hit success percentage.
 *
 * ---
 *
 * <Repeat Hits: x>
 *
 * - Used for: Skill, Item Notetags
 * - Changes the number of hits the action will produce.
 * - Replace 'x' with a number value representing the number of hits to incur.
 *
 * ---
 *
 * <Target: x Random Any>
 *
 * - Used for: Skill, Item Notetags
 * - Makes the skill pick 'x' random targets when used.
 * - Targets can be both actors and enemies.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 * - Replace 'x' with a number value representing the number of random targets.
 *
 * ---
 *
 * <Target: x Random Enemies>
 *
 * - Used for: Skill, Item Notetags
 * - Makes the skill pick 'x' random targets when used.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 * - Targets are only enemies.
 * - Replace 'x' with a number value representing the number of random targets.
 *
 * ---
 *
 * <Target: x Random Allies>
 *
 * - Used for: Skill, Item Notetags
 * - Makes the skill pick 'x' random targets when used.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 * - Targets are only actors.
 * - Replace 'x' with a number value representing the number of random targets.
 *
 * ---
 *
 * <Target: All Allies But User>
 *
 * - Used for: Skill, Item Notetags
 * - Targets all allies with the exception of the user.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 *
 * ---
 * 
 * <Target: Ally or Enemy>
 * 
 * - Used for: Skill, Item Notetags
 * - Allows the player to target allies or enemies with the skill/item.
 *   - Keep in mind this does NOT allow you to select dead party members.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 * - Target selection emphasis will go to allies first.
 * - Ignored when used by enemies and will be treated as an ally scope.
 * - Auto-battle actors will also treat this action as an ally scope.
 * - For certain battle layouts in frontview, this will open the Actor Select
 *   window in order for Touch Input to be able to select actors.
 * 
 * ---
 * 
 * <Target: Enemy or Ally>
 * 
 * - Used for: Skill, Item Notetags
 * - Allows the player to target enemies or allies with the skill/item.
 *   - Keep in mind this does NOT allow you to select dead party members.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 * - Target selection emphasis will go to enemies first.
 * - Ignored when used by enemies and will be treated as an enemy scope.
 * - Auto-battle actors will also treat this action as an enemy scope.
 * - For certain battle layouts in frontview, this will open the Actor Select
 *   window in order for Touch Input to be able to select actors.
 * 
 * ---
 * 
 * <Single or Multiple Select>
 * 
 * - Used for: Skill, Item Notetags
 * - Requires an original scope that can select individual targets.
 * - This will allow the skill/item to be able to select either single targets
 *   or multiple targets at once.
 *   - In order to select "all enemies", the player must press the "Page Up"
 *     keyboard button or the visual on screen "All Enemies" button.
 *   - In order to select "all allies", the player must press the "Page Down"
 *     keyboard button or the visual on screen "All Allies" button.
 *   - Those wondering why this isn't regulated to a command left or right of
 *     the enemies and actors is because mouse controls and touch controls
 *     would not be able to select all enemies or all allies that way.
 *   - This can NOT be used with single dead ally scopes.
 * - If there is an enemy with Taunt or Provoke, the option to select
 *   "All Enemies" does not become possible.
 * - The enemy AI and Auto-Battle actor AI will NOT make use of the ability to
 *   toggle between single and multiple target scopes. They will only use the
 *   single target versions of these skills.
 * 
 * ---
 * 
 * <Disperse Damage>
 * 
 * - Used for: Skill, Item Notetags
 * - This will cause any damage dealt by this skill to be split equally amongst
 *   all targets of the skill including repeats.
 *   - For basic attacks, any damage reduction added attack trait totals will
 *     by reverted.
 * - This does NOT have to be used with <Single or Multiple Select> notetag and
 *   can be used by itself for an "All" scope, making the skill/item deal less
 *   damage if there's more enemies and more damage if there's less enemies.
 * 
 * ---
 * 
 * <Cannot Target User>
 * 
 * - Used for: Skill, Item Notetags
 * - This will cause the action to be unable to select the user as the target.
 * - This is not a targeting scope. Instead, it is used in addition to any
 *   other targeting scopes out there.
 * - When used with "All" scopes, the user is removed from the target pool.
 * - This is also applied outside of battle.
 * - If the user somehow enters the target pool, the user is then replaced by
 *   a random ally found in the party.
 * 
 * ---
 *
 * === JavaScript Notetag: Targeting-Related ===
 *
 * ---
 * 
 * <JS Targets>
 *  code
 *  code
 *  targets = [code];
 * </JS Targets>
 *
 * - Used for: Skill, Item Notetags
 * - The 'targets' variable is an array that is returned to be used as a
 *   container for all the valid action targets.
 * - The 'targets' variable will include the original set of targets determined
 *   by the skill/item's original scale.
 * - If you wish to clear it out, simply do 'targets = []' first.
 * - Replace 'code' with JavaScript code to determine valid targets.
 *
 * ---
 *
 * === Damage-Related Notetags ===
 *
 * ---
 *
 * <Damage Style: name>
 *
 * - Used for: Skill, Item Notetags
 * - Replace 'name' with a Damage Style name to change the way calculations are
 *   made using the damage formula input box.
 * - Names can be found in Plugin Parameters => Damage Settings => Style List
 *
 * ---
 *
 * <Armor Reduction: x>
 * <Armor Reduction: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   reduction properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor reduction properties
 *   when calculating one's own armor.
 * - This applies to physical attacks.
 * - Use the 'x' notetag variant to determine a flat reduction value.
 * - Use the 'x%' notetag variant to determine a percentile reduction value.
 *
 * ---
 *
 * <Armor Penetration: x>
 * <Armor Penetration: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   penetration properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor penetration
 *   properties when calculating a target's armor.
 * - This applies to physical attacks.
 * - Use the 'x' notetag variant to determine a flat penetration value.
 * - Use the 'x%' notetag variant to determine a percentile penetration value.
 *
 * ---
 *
 * <Magic Reduction: x>
 * <Magic Reduction: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   reduction properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor reduction properties
 *   when calculating one's own armor.
 * - This applies to magical attacks.
 * - Use the 'x' notetag variant to determine a flat reduction value.
 * - Use the 'x%' notetag variant to determine a percentile reduction value.
 *
 * ---
 *
 * <Magic Penetration: x>
 * <Magic Penetration: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   penetration properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor penetration
 *   properties when calculating a target's armor.
 * - This applies to magical attacks.
 * - Use the 'x' notetag variant to determine a flat penetration value.
 * - Use the 'x%' notetag variant to determine a percentile penetration value.
 *
 * ---
 *
 * <Bypass Damage Cap>
 * 
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will cause the action to never have
 *   its damage capped.
 * - If used on trait objects, this will cause the affected unit to never have
 *   its damage capped.
 *
 * ---
 *
 * <Damage Cap: x>
 *
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will declare the hard damage cap to
 *   be the 'x' value.
 * - If used on trait objects, this will raise the affect unit's hard damage
 *   cap to 'x' value. If another trait object has a higher value, use that
 *   value instead.
 *
 * ---
 *
 * <Bypass Soft Damage Cap>
 *
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will cause the action to never have
 *   its damage scaled downward to the soft cap.
 * - If used on trait objects, this will cause the affected unit to never have
 *   its damage scaled downward to the soft cap.
 *
 * ---
 *
 * <Soft Damage Cap: +x%>
 * <Soft Damage Cap: -x%>
 *
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will increase/decrease the action's
 *   soft cap by x% where 'x' is a percentage value representing the increment
 *   changed by the hard cap value.
 * - If used on trait objects, this will raise the affect unit's soft damage
 *   limit by x% where 'x' is a percentage value representing the increment
 *   changed by the hard cap value.
 *
 * ---
 *
 * <Unblockable>
 *
 * - Used for: Skill, Item Notetags
 * - Using "Guard" against this skill will not reduce any damage.
 *
 * ---
 *
 * === Critical-Related Notetags ===
 *
 * The following notetags affect skill and item critical hit rates and the
 * critical damage multiplier.
 *
 * ---
 *
 * <Always Critical>
 *
 * - Used for: Skill, Item Notetags
 * - This skill/item will always land a critical hit regardless of the
 *   user's CRI parameter value.
 *
 * ---
 *
 * <Set Critical Rate: x%>
 *
 * - Used for: Skill, Item Notetags
 * - This skill/item will always have a x% change to land a critical hit
 *   regardless of user's CRI parameter value.
 * - Replace 'x' with a percerntage value representing the success rate.
 *
 * ---
 *
 * <Modify Critical Rate: x%>
 * <Modify Critical Rate: +x%>
 * <Modify Critical Rate: -x%>
 *
 * - Used for: Skill, Item Notetags
 * - Modifies the user's CRI parameter calculation for this skill/item.
 * - The 'x%' notetag variant will multiply the user's CRI parameter value
 *   for this skill/item.
 * - The '+x%' and '-x%' notetag variants will incremenetally increase/decrease
 *   the user's CRI parameter value for this skill/item.
 *
 * ---
 *
 * <Modify Critical Multiplier: x%>
 * <Modify Critical Multiplier: +x%>
 * <Modify Critical Multiplier: -x%>
 *
 * - Used for: Skill, Item Notetags
 * - These notetags determine the damage multiplier when a critical hit lands.
 * - The 'x%' notetag variant multiply the multiplier to that exact percentage.
 * - The '+x%' and '-x%' notetag variants will change the multiplier with an
 *   incremenetal rate for this skill/item.
 *
 * ---
 *
 * <Modify Critical Bonus Damage: x%>
 * <Modify Critical Bonus Damage: +x%>
 * <Modify Critical Bonus Damage: -x%>
 *
 * - Used for: Skill, Item Notetags
 * - These notetags determine the bonus damage added when a critical hit lands.
 * - The 'x%' notetag variant multiply the damage to that exact percentage.
 * - The '+x%' and '-x%' notetag variants will change the bonus damage with an
 *   incremenetal rate for this skill/item.
 *
 * ---
 *
 * === JavaScript Notetags: Critical-Related ===
 *
 * The following are notetags made for users with JavaScript knowledge to
 * determine how critical hit-related aspects are calculated.
 *
 * ---
 *
 * <JS Critical Rate>
 *  code
 *  code
 *  rate = code;
 * </JS Critical Rate>
 *
 * - Used for: Skill, Item Notetags
 * - The 'rate' variable is the final returned amount to determine the
 *   critical hit success rate.
 * - Replace 'code' with JavaScript code to determine the final 'rate' to be
 *   returned as the critical hit success rate.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Critical Damage>
 *  code
 *  code
 *  multiplier = code;
 *  bonusDamage = code;
 * </JS Critical Damage>
 *
 * - Used for: Skill, Item Notetags
 * - The 'multiplier' variable is returned later and used as the damage
 *   multiplier used to amplify the critical damage amount.
 * - The 'bonusDamage' variable is returned later and used as extra added
 *   damage for the critical damage amount.
 * - Replace 'code' with JavaScript code to determine how the 'multiplier' and
 *   'bonusDamage' variables are calculated.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 * 
 * === Life Steal-Related Notetags ===
 * 
 * ---
 * 
 * <HP Life Steal: x%>
 * <MP Life Steal: x%>
 * 
 * - Used for: Skill, Item Notetags
 * - Causes this skill/item to have Life Steal properties, allowing the user to
 *   take x% of the HP/MP Damage as recovered HP/MP.
 *   - HP Life Steal can only take HP from dealt HP damage.
 *   - MP Life Steal can only take HP from dealt MP damage.
 * - Replace 'x' with a number representing the percentage of the dealt damage
 *   used as HP/MP recovery.
 * - This cannot be used with skills/items with HP Drain/MP Drain. Life Steal
 *   is a different mechanic from HP Drain/MP Drain.
 * 
 * ---
 * 
 * <HP Life Steal Certain Hit: +x%>
 * <HP Life Steal Physical Hit: +x%>
 * <HP Life Steal Magical Hit: +x%>
 * 
 * <HP Life Steal Certain Hit: -x%>
 * <HP Life Steal Physical Hit: -x%>
 * <HP Life Steal Magical Hit: -x%>
 * 
 * <MP Life Steal Certain Hit: +x%>
 * <MP Life Steal Physical Hit: +x%>
 * <MP Life Steal Magical Hit: +x%>
 * 
 * <MP Life Steal Certain Hit: -x%>
 * <MP Life Steal Physical Hit: -x%>
 * <MP Life Steal Magical Hit: -x%>
 * 
 * - Used for: Used for: Actor, Class, Armor, Enemy, State Notetags
 * - The related battler's various trait properties can have passive life steal
 *   properties that will trigger upon using skills/items with matching hit
 *   types regardless of whether or not the skill/item innately has Life Steal.
 *   - Notetag variants with "Certain Hit" will only trigger from "Certain Hit"
 *     skill and item types. Same with "Physical" and "Magical" variants.
 *   - HP Life Steal can only take HP from dealt HP damage.
 *   - MP Life Steal can only take HP from dealt MP damage.
 * - Replace 'x' with a number representing the additive stacking percentage
 *   boost of the dealt damage used as HP/MP recovery. The effects will stack
 *   additively with other trait objects.
 * - This cannot be used with skills/items with HP Drain/MP Drain. Life Steal
 *   is a different mechanic from HP Drain/MP Drain.
 * 
 * ---
 * 
 * <Cancel Life Steal>
 * 
 * <Cancel HP Life Steal>
 * <Cancel MP Life Steal>
 * 
 * - Used for: Skill, Item Notetags
 * - Prevents this skill from allowing Life Steal effects to occur including
 *   the passive life steal calculators from the skill/item user.
 * - This does not affect HP Drain/MP Drain. Life Steal is a different mechanic
 *   from HP Drain/MP Drain.
 * 
 * ---
 * 
 * <Guard Life Steal>
 * 
 * <Guard HP Life Steal>
 * <Guard MP Life Steal>
 * 
 * - Used for: Used for: Actor, Class, Armor, Enemy, State Notetags
 * - If the related battler becomes the target of Life Steal, this will prevent
 *   the Life Steal effects from taking effect.
 * - This does not affect HP Drain/MP Drain. Life Steal is a different mechanic
 *   from HP Drain/MP Drain.
 * 
 * ---
 * 
 * <Disarm Life Steal>
 * 
 * <Disarm HP Life Steal>
 * <Disarm MP Life Steal>
 * 
 * - Used for: Used for: Actor, Class, Armor, Enemy, State Notetags
 * - Makes the related battler unable to HP/MP Life Steal regardless of the
 *   skill/item and its related properties like equipment.
 * - This does not prevent skills/items with innate Life Steal from being used.
 *   Only the Life Steal part of the skill/item will have no effect.
 * - This does not affect HP Drain/MP Drain. Life Steal is a different mechanic
 *   from HP Drain/MP Drain.
 * 
 * ---
 * 
 * <Negative Life Steal>
 * 
 * <Negative HP Life Steal>
 * <Negative MP Life Steal>
 * 
 * - Used for: Used for: Actor, Class, Armor, Enemy, State Notetags
 * - If the related battler becomes the target of Life Steal, this will invert
 *   the healing properties of Life Steal, causing the Life Steal user to
 *   instead take HP/MP damage.
 *   - This does NOT heal the target related battler.
 * - This does not prevent skills/items with innate Life Steal from being used.
 *   Only the Life Steal part of the skill/item will have no effect.
 * - This does not affect HP Drain/MP Drain. Life Steal is a different mechanic
 *   from HP Drain/MP Drain.
 * 
 * ---
 *
 * === Action Sequence-Related Notetags ===
 *
 * Action Sequences allow you full control over how a skill and/or item plays
 * through its course. These notetags give you control over various aspects of
 * those Action Sequences. More information is found in the Action Sequences
 * help section.
 *
 * ---
 *
 * <Custom Action Sequence>
 *
 * - Used for: Skill, Item Notetags
 * - Removes all automated Action Sequence parts from the skill.
 * - Everything Action Sequence-related will be done by Common Events.
 * - Insert Common Event(s) into the skill/item's effects list to make use of
 *   the Custom Action Sequences.
 * - This will prevent common events from loading in the Item Scene and Skill
 *   Scene when used outside of battle.
 *
 * ---
 * 
 * <Auto Action Sequence>
 * 
 * - Used for: Skill, Item Notetags
 * - If the Action Sequence Plugin Parameter "Auto Notetag" is enabled, this
 *   plugin will prevent custom action sequences from happening for the skill
 *   or item, and instead, use an Automatic Action Sequence instead.
 * - Ignore this if you have "Auto Notetag" disabled or set to false. By
 *   default, this setting is set to false. Please be aware of the changes
 *   you've made to your game before using it.
 * 
 * ---
 * 
 * <Bypass Auto Action Sequence>
 * 
 * - Used for: Skill, Item Notetags
 * - This notetag is used for the game devs that have the Action Sequence
 *   Plugin Parameter "Auto Notetag" on for applying <Custom Action Sequence>
 *   to everything.
 * - This will allow items and skills to be able to launch their common
 *   events from the menu scene regardless of the inherent restriction to
 *   prevent action sequence based skills/items with common events from
 *   launching.
 * - Ignore this if you have "Auto Notetag" disabled or set to false. By
 *   default, this setting is set to false. Please be aware of the changes
 *   you've made to your game before using it.
 * 
 * ---
 * 
 * <Common Event: name>
 *
 * - Used for: Skill, Item Notetags
 * - Battle only: calls forth a Common Event of a matching name.
 * - Replace 'name' with the name of a Common Event to call from when this
 *   skill/item is used in battle.
 *   - Remove any \I[x] in the name.
 * - Insert multiple notetags to call multiple Common Events in succession.
 * - This will occur after any Common Event Trait Effects for the skill/item's
 *   database entry.
 * - This is primarily used for users who are reorganizing around their Common
 *   Events and would still like to have their skills/items perform the correct
 *   Action Sequences in case the ID's are different.
 * 
 * ---
 *
 * <Display Icon: x>
 * <Display Text: string>
 *
 * - Used for: Skill, Item Notetags
 * - When displaying the skill/item name in the Action Sequence, determine the
 *   icon and/or text displayed.
 * - Replace 'x' with a number value representing the icon ID to be displayed.
 * - Replace 'string' with a text value representing the displayed name.
 *
 * ---
 * 
 * <Common Event Key: name>
 * <Common Event Keys: name, name, name>
 * 
 * <Common Event Keys>
 *  key
 *  key
 *  key
 * </Common Event Keys>
 * 
 * - Used for: Skill, Item Notetags
 * - Will generate Common Events for the skill/item with a corresponding key.
 * - Replace 'name' with the name of the Common Event's key that you want to
 *   reference. That key will be converted into a Common Event effect for the
 *   skill/item and be treated as an action sequence.
 *   - The notetag variants that use multiple keys will have the keys added in
 *     the order they are listed.
 *   - If keys do not reference any Common Events, no Common Events will be
 *     added for that key.
 * - To mark a Common Event with a key, insert inside a Common Event's name the
 *   [ and ] brackets around the text that will be used as the Common Event's
 *   key text.
 *   - For example, if Common Event's name is "Penta Slash [PENTA]", then the
 *     key used is "PENTA" without the quotes.
 *   - This key could then be referenced by <Common Event Key: PENTA> notetag.
 *   - Do not use commas (,) inside the key text as it will be automatically
 *     removed for the sake of consistency.
 * - This feature is made for make the process of sharing Action Sequences to
 *   become easier without needing to line up Common Event ID's.
 * 
 * ---
 *
 * === Animated Sideview Battler-Related Notetags ===
 *
 * Enemies can use Animated Sideview Actor graphics thanks to this plugin.
 * These notetags give you control over that aspect. Some of these also affect
 * actors in addition to enemies.
 *
 * ---
 *
 * <Sideview Battler: filename>
 *
 * <Sideview Battlers>
 *  filename: weight
 *  filename: weight
 *  filename: weight
 * </Sideview Battlers>
 *
 * - Used for: Enemy Notetags
 * - Replaces the enemy's battler graphic with an animated Sideview Actor
 *   graphic found in the img/sv_actors/ folder.
 * - Replace 'filename' with the filename of the graphic to use. Do not insert
 *   any extensions. This means the file 'Actor1_1.png' will be only inserted
 *   as 'Actor1_1' without the '.png' at the end.
 * - If the multiple notetag vaiant is used, then a random filename is selected
 *   from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'filename'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'filename' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Sideview Battlers>
 *  Actor1_1: 25
 *  Actor1_3: 10
 *  Actor1_5
 *  Actor1_7
 * </Sideview Battlers>
 *
 * ---
 *
 * <Sideview Anchor: x, y>
 *
 * - Used for: Actor, Enemy Notetags
 * - Sets the sprite anchor positions for the sideview sprite.
 * - Replace 'x' and 'y' with numbers depicting where the anchors should be for
 *   the sideview sprite.
 * - By default, the x and y anchors are 0.5 and 1.0.
 *
 * ---
 * 
 * <Sideview Home Offset: +x, +y>
 * <Sideview Home Offset: -x, -y>
 * 
 * - Used for: Actor, Class, Weapon, Armor, State Notetags
 * - Offsets the sideview actor sprite's home position by +/-x, +/-y.
 * - Replace 'x' and 'y' with numbers depicting how much to offset each of the
 *   coordinates by. For '0' values, use +0 or -0.
 * - This notetag will not work if you remove it from the JavaScript code in
 *   Plugin Parameters > Actor > JS:  Home Position
 * 
 * ---
 * 
 * <Sideview Weapon Offset: +x, +y>
 * <Sideview Weapon Offset: -x, -y>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy State Notetags
 * - Offsets the sideview weapon sprite's position by +/-x, +/-y.
 * - Replace 'x' and 'y' with numbers depicting how much to offset each of the
 *   coordinates by. For '0' values, use +0 or -0.
 * 
 * ---
 *
 * <Sideview Show Shadow>
 * <Sideview Hide Shadow>
 *
 * - Used for: Actor, Enemy Notetags
 * - Sets it so the sideview battler's shadow will be visible or hidden.
 *
 * ---
 * 
 * <Sideview Shadow Scale: x%>
 * <Sideview Shadow Scale: x.y>
 * 
 * - Used for: Actor, Enemy Notetags
 * - Adjusts the scaling size of the sideview battler's shadow.
 * - This affects both the X and Y scale.
 * 
 * ---
 * 
 * <Sideview Shadow Scale X: x%>
 * <Sideview Shadow Scale X: x.y>
 * 
 * <Sideview Shadow Scale Y: x%>
 * <Sideview Shadow Scale Y: x.y>
 * 
 * - Used for: Actor, Enemy Notetags
 * - Adjusts the scaling size of the sideview battler's shadow.
 * - These affect their respective X and Y scales separately.
 * 
 * ---
 *
 * <Sideview Collapse>
 * <Sideview No Collapse>
 *
 * - Used for: Enemy Notetags
 * - Either shows the collapse graphic or does not show the collapse graphic.
 * - Collapse graphic means the enemy will 'fade away' once it's defeated.
 * - No collapse graphic means the enemy's corpse will remain on the screen.
 *
 * ---
 *
 * <Sideview Idle Motion: name>
 *
 * <Sideview Idle Motions>
 *  name: weight
 *  name: weight
 *  name: weight
 * </Sideview Idle Motions>
 *
 * - Used for: Enemy Notetags
 * - Changes the default idle motion for the enemy.
 * - Replace 'name' with any of the following motion names:
 *   - 'walk', 'wait', 'chant', 'guard', 'damage', 'evade', 'thrust', 'swing',
 *     'missile', 'skill', 'spell', 'item', 'escape', 'victory', 'dying',
 *     'abnormal', 'sleep', 'dead'
 * - If the multiple notetag vaiant is used, then a random motion name is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'name'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'name' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Sideview Idle Motions>
 *  walk: 25
 *  wait: 50
 *  guard
 *  victory
 *  abnormal
 * </Sideview Idle Motions>
 *
 * ---
 *
 * <Sideview Size: width, height>
 *
 * - Used for: Enemy Notetags
 * - When using a sideview battler, its width and height will default to the
 *   setting made in Plugin Parameters => Enemy Settings => Size: Width/Height.
 * - This notetag lets you change that value to something else.
 * - Replace 'width' and 'height' with numbers representing how many pixels
 *   wide/tall the sprite will be treated as.
 * - This does NOT change the image size. This only changes the HITBOX size.
 *
 * ---
 *
 * <Sideview Weapon: weapontype>
 *
 * <Sideview Weapons>
 *  weapontype: weight
 *  weapontype: weight
 *  weapontype: weight
 * </Sideview Weapons>
 *
 * - Used for: Enemy Notetags
 * - Give your sideview enemies weapons to use.
 * - Replace 'weapontype' with the name of the weapon type found under the
 *   Database => Types => Weapon Types list (without text codes).
 * - If the multiple notetag vaiant is used, then a random weapon type is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the weapontype
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'weapontype' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Sideview Weapons>
 *  Dagger: 25
 *  Sword: 25
 *  Axe
 * </Sideview Weapons>
 *
 * ---
 *
 * <traitname Sideview Battler: filename>
 *
 * <traitname Sideview Battlers>
 *  filename: weight
 *  filename: weight
 *  filename: weight
 * </traitname Sideview Battlers>
 *
 * - Used for: Enemy Notetags
 * - Requires VisuMZ_1_ElementStatusCore
 * - Allows certain Trait Sets to cause battlers to have a unique appearance.
 * - Replace 'filename' with the filename of the graphic to use. Do not insert
 *   any extensions. This means the file 'Actor1_1.png' will be only inserted
 *   as 'Actor1_1' without the '.png' at the end.
 * - If the multiple notetag vaiant is used, then a random filename is selected
 *   from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'filename'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'filename' instead.
 * - Add/remove lines as you see fit.
 *
 * Examples:
 *
 * <Male Sideview Battlers>
 *  Actor1_1: 25
 *  Actor1_3: 10
 *  Actor1_5
 *  Actor1_7
 * </Male Sideview Battlers>
 *
 * <Female Sideview Battlers>
 *  Actor1_2: 25
 *  Actor1_4: 10
 *  Actor1_6
 *  Actor1_8
 * </Female Sideview Battlers>
 *
 * ---
 *
 * <traitname Sideview Idle Motion: name>
 *
 * <traitname Sideview Idle Motions>
 *  name: weight
 *  name: weight
 *  name: weight
 * </traitname Sideview Idle Motions>
 *
 * - Used for: Enemy Notetags
 * - Requires VisuMZ_1_ElementStatusCore
 * - Allows certain Trait Sets to cause battlers to have unique idle motions.
 * - Replace 'name' with any of the following motion names:
 *   - 'walk', 'wait', 'chant', 'guard', 'damage', 'evade', 'thrust', 'swing',
 *     'missile', 'skill', 'spell', 'item', 'escape', 'victory', 'dying',
 *     'abnormal', 'sleep', 'dead'
 * - If the multiple notetag vaiant is used, then a random motion name is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'name'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'name' instead.
 * - Add/remove lines as you see fit.
 *
 * Examples:
 *
 * <Jolly Sideview Idle Motions>
 *  wait: 25
 *  victory: 10
 *  walk
 * </Jolly Sideview Idle Motions>
 *
 * <Serious Sideview Idle Motions>
 *  walk: 25
 *  guard: 10
 *  wait
 * </Jolly Sideview Idle Motions>
 *
 * ---
 *
 * <traitname Sideview Weapon: weapontype>
 *
 * <traitname Sideview Weapons>
 *  weapontype: weight
 *  weapontype: weight
 *  weapontype: weight
 * </traitname Sideview Weapons>
 *
 * - Used for: Enemy Notetags
 * - Requires VisuMZ_1_ElementStatusCore
 * - Allows certain Trait Sets to cause battlers to have unique weapons.
 * - Replace 'weapontype' with the name of the weapon type found under the
 *   Database => Types => Weapon Types list (without text codes).
 * - If the multiple notetag vaiant is used, then a random weapon type is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the weapontype
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'weapontype' instead.
 * - Add/remove lines as you see fit.
 *
 * Examples:
 *
 * <Male Sideview Weapons>
 *  Dagger: 25
 *  Sword: 25
 *  Axe
 * </Male Sideview Weapons>
 *
 * <Female Sideview Weapons>
 *  Dagger: 25
 *  Spear: 25
 *  Cane
 * </Female Sideview Weapons>
 *
 * ---
 *
 * === Enemy-Related Notetags ===
 *
 * ---
 *
 * <Battler Sprite Cannot Move>
 *
 * - Used for: Enemy Notetags
 * - Prevents the enemy from being able to move, jump, and/or float due to
 *   Action Sequences. Useful for rooted enemies.
 *
 * ---
 * 
 * <Battler Sprite Grounded>
 *
 * - Used for: Enemy Notetags
 * - Prevents the enemy from being able to jumping and/or floating due to
 *   Action Sequences but still able to move. Useful for rooted enemies.
 * 
 * ---
 *
 * <Swap Enemies>
 *  name: weight
 *  name: weight
 *  name: weight
 * </Swap Enemies>
 *
 * - Used for: Enemy Notetags
 * - Causes this enemy database object to function as a randomizer for any of
 *   the listed enemies inside the notetag. When the enemy is loaded into the
 *   battle scene, the enemy is immediately replaced with one of the enemies
 *   listed. The randomization is based off the 'weight' given to each of the
 *   enemy 'names'.
 * - Replace 'name' with the database enemy of the enemy you wish to replace
 *   the enemy with.
 * - Replace 'weight' with a number value representing how often the 'name'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'name' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Swap Enemies>
 *  Bat: 50
 *  Slime: 25
 *  Orc
 *  Minotaur
 * </Swap Enemies>
 *
 * ---
 *
 * === JavaScript Notetags: Mechanics-Related ===
 *
 * These JavaScript notetags allow you to run code at specific instances during
 * battle provided that the unit has that code associated with them in a trait
 * object (actor, class, weapon, armor, enemy, or state). How you use these is
 * entirely up to you and will depend on your ability to understand the code
 * used and driven for each case.
 *
 * ---
 *
 * <JS Pre-Start Battle>
 *  code
 *  code
 *  code
 * </JS Pre-Start Battle>
 *
 * <JS Post-Start Battle>
 *  code
 *  code
 *  code
 * </JS Post-Start Battle>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of battle aimed at the function:
 *   BattleManager.startBattle()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Start Turn>
 *  code
 *  code
 *  code
 * </JS Pre-Start Turn>
 *
 * <JS Post-Start Turn>
 *  code
 *  code
 *  code
 * </JS Post-Start Turn>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of a turn aimed at the function:
 *   BattleManager.startTurn()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Start Action>
 *  code
 *  code
 *  code
 * </JS Pre-Start Action>
 *
 * <JS Post-Start Action>
 *  code
 *  code
 *  code
 * </JS Post-Start Action>
 * 
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of an action aimed at the function:
 *   BattleManager.startAction()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Apply>
 *  code
 *  code
 *  code
 * </JS Pre-Apply>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code at the start of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Pre' runs before the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Pre-Apply as User>
 *  code
 *  code
 *  code
 * </JS Pre-Apply as User>
 *
 * <JS Pre-Apply as Target>
 *  code
 *  code
 *  code
 * </JS Pre-Apply as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Pre' runs before the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Pre-Damage>
 *  code
 *  code
 *  code
 * </JS Pre-Damage>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code before damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Pre' runs before the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 * - The 'value' variable represents the damage being calculated up to this
 *   point (if any) and any changes made to the 'value' variable will reflect
 *   on the damage dealt/healed, too.
 *
 * ---
 *
 * <JS Pre-Damage as User>
 *  code
 *  code
 *  code
 * </JS Pre-Damage as User>
 *
 * <JS Pre-Damage as Target>
 *  code
 *  code
 *  code
 * </JS Pre-Damage as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code before damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Pre' runs before the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 * - The 'value' variable represents the damage being calculated up to this
 *   point (if any) and any changes made to the 'value' variable will reflect
 *   on the damage dealt/healed, too.
 *
 * ---
 *
 * <JS Post-Damage>
 *  code
 *  code
 *  code
 * </JS Post-Damage>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code after damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Post' runs after the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 * - The 'value' variable represents the damage/healing that has been last
 *   dealt through this action.
 *
 * ---
 *
 * <JS Post-Damage as User>
 *  code
 *  code
 *  code
 * </JS Post-Damage as User>
 *
 * <JS Post-Damage as Target>
 *  code
 *  code
 *  code
 * </JS Post-Damage as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code after damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Post' runs after the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 * - The 'value' variable represents the damage/healing that has been last
 *   dealt through this action.
 *
 * ---
 *
 * <JS Post-Apply>
 *  code
 *  code
 *  code
 * </JS Post-Apply>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code at the end of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Post' runs after the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Post-Apply as User>
 *  code
 *  code
 *  code
 * </JS Post-Apply as User>
 *
 * <JS Post-Apply as Target>
 *  code
 *  code
 *  code
 * </JS Post-Apply as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the end of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Post' runs after the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 *
 * ---
 *
 * <JS Pre-End Action>
 *  code
 *  code
 *  code
 * </JS Pre-End Action>
 *
 * <JS Post-End Action>
 *  code
 *  code
 *  code
 * </JS Post-End Action>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the end of an action aimed at the function:
 *   BattleManager.endAction()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-End Turn>
 *  code
 *  code
 *  code
 * </JS Pre-End Turn>
 *
 * <JS Post-End Turn>
 *  code
 *  code
 *  code
 * </JS Post-End Turn>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the end of a turn aimed at the function:
 *   Game_Battler.prototype.onTurnEnd()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Regenerate>
 *  code
 *  code
 *  code
 * </JS Pre-Regenerate>
 *
 * <JS Post-Regenerate>
 *  code
 *  code
 *  code
 * </JS Post-Regenerate>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when a unit regenerates HP/MP aimed at the function:
 *   Game_Battler.prototype.regenerateAll()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Battle Victory>
 *  code
 *  code
 *  code
 * </JS Battle Victory>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when a battle is won aimed at the function:
 *   BattleManager.processVictory()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Escape Success>
 *  code
 *  code
 *  code
 * </JS Escape Success>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when escaping succeeds aimed at the function:
 *   BattleManager.onEscapeSuccess()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Escape Failure>
 *  code
 *  code
 *  code
 * </JS Escape Failure>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when escaping fails aimed at the function:
 *   BattleManager.onEscapeFailure()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Battle Defeat>
 *  code
 *  code
 *  code
 * </JS Battle Defeat>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when a battle is lost aimed at the function:
 *   BattleManager.processDefeat()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-End Battle>
 *  code
 *  code
 *  code
 * </JS Pre-End Battle>
 *
 * <JS Post-End Battle>
 *  code
 *  code
 *  code
 * </JS Post-End Battle>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when the battle is over aimed at the function:
 *   BattleManager.endBattle()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 * 
 * === Battle Layout-Related Notetags ===
 * 
 * These tags will change the battle layout for a troop regardless of how the
 * plugin parameters are set up normally. Insert these tags in either the
 * noteboxes of maps or the names of troops for them to take effect. If both
 * are present for a specific battle, then priority goes to the setting found
 * in the troop name.
 * 
 * ---
 * 
 * <Layout: type>
 * <Battle Layout: type>
 * 
 * - Used for: Map Notetags, Troop Name Tags, and Troop Comment Tags
 * - Changes the battle layout style used for this specific map or battle.
 * - Replace 'type' with 'default', 'list', 'xp', 'portrait', or 'border'.
 * - Those with VisuMZ_3_FrontviewBattleUI can use 'frontview'.
 * - Those with VisuMZ_3_SideviewBattleUI can use 'sideview'.
 * - If using Troop Comment Tags, then as long as the tag appears in a comment
 *   found on any of the Troop's pages (even if they don't run), the tag will
 *   be considered in effect.
 * 
 * ---
 * 
 * === Troop Size Tags ===
 * 
 * ---
 * 
 * <Extend: x>
 * <Extend: x, x, x>
 * 
 * - Used for: Troop Name Tags and Troop Comment Tags
 * - Adds enemies from another troop to the current troop.
 * - Enemies from another troop will retain their database positions.
 * - Replace 'x' with the ID of the database troop entry you wish to add enemy
 *   members from.
 *   - Insert multiple x's to add from more troops.
 * - Extended troop members will be added in the order they're listed.
 * - Be cautious of how many enemies you add as too many will lag the battle
 *   system. We are not responsible for frame drops due to this.
 * 
 * ---
 * 
 * === Troop Comment Tags ===
 * 
 * Place these tags inside of a comment found in a troop page's event list.
 * 
 * ---
 * 
 * <Once Parallel When Start Battle>
 * 
 * - Used for: Troop Page Comment Tags
 * - Causes the troop page to immediately load the moment the battle scene
 *   begins to fade in (not after it fades in). This is faster than a turn 0
 *   condition troop page. Troop page conditions are ignored.
 * - This can be used for things like the Action Sequence Camera plugin, the
 *   Visual Battle Environment plugin, and/or initial battle poses and such in
 *   order to provide a near seamless battle transition experience.
 * - This does NOT trigger when coming out of the options menu or party menu.
 * - This WILL trigger when going from battle to battle nonstop via plugins
 *   like VisuStella MZ's Chain Battles.
 * - When actors are moving towards their home positions, it will take around
 *   30 frames by default. Use this information however you like.
 * 
 * ---
 *
 * ============================================================================
 * Action Sequence - Plugin Commands
 * ============================================================================
 *
 * Skills and items, when used in battle, have a pre-determined series of
 * actions to display to the player as a means of representing what's going on
 * with the action. For some game devs, this may not be enough and they would
 * like to get more involved with the actions themselves.
 *
 * Action Sequences, added through this plugin, enable this. To give a skill or
 * item a Custom Action Sequence, a couple of steps must be followed:
 *
 * ---
 *
 * 1. Insert the <Custom Action Sequence> notetag into the skill or item's
 *    notebox (or else this would not work as intended).
 * 2. Give that skill/item a Common Event through the Effects box. The selected
 *    Common Event will contain all the Action Sequence data.
 * 3. Create the Common Event with Action Sequence Plugin Commands and/or event
 *    commands to make the skill/item do what you want it to do.
 *
 * ---
 *
 * The Plugin Commands added through the Battle Core plugin focus entirely on
 * Action Sequences. However, despite the fact that they're made for skills and
 * items, some of these Action Sequence Plugin Commands can still be used for
 * regular Troop events and Common Events.
 *
 * ---
 *
 * === Action Sequence - Action Sets ===
 *
 * Action Sequence Action Sets are groups of commonly used
 * Action Sequence Commands put together for more efficient usage.
 *
 * ---
 *
 * ACSET: Setup Action Set
 * - The generic start to most actions.
 *
 *   Display Action:
 *   Immortal: On:
 *   Battle Step:
 *   Wait For Movement:
 *   Cast Animation:
 *   Wait For Animation:
 *   - Use this part of the action sequence?
 *
 * ---
 *
 * ACSET: All Targets Action Set
 * - Affects all targets simultaneously performing the following.
 *
 *   Dual/Multi Wield?
 *   - Add times struck based on weapon quantity equipped?
 * 
 *   Perform Action:
 *   Wait Count:
 *   Action Animation:
 *   Wait For Animation:
 *   Action Effect:
 *   Immortal: Off:
 *   - Use this part of the action sequence?
 *   - Insert values for the Wait Count(s).
 *
 * ---
 *
 * ACSET: Each Target Action Set
 * - Goes through each target one by one to perform the following.
 *
 *   Dual/Multi Wield?
 *   - Add times struck based on weapon quantity equipped?
 *
 *   Perform Action:
 *   Wait Count:
 *   Action Animation:
 *   Wait Count:
 *   Action Effect:
 *   Immortal: Off:
 *   - Use this part of the action sequence?
 *   - Insert values for the Wait Count(s).
 *
 * ---
 *
 * ACSET: Finish Action
 * - The generic ending to most actions.
 *
 *   Wait For New Line:
 *   Wait For Effects:
 *   Clear Battle Log:
 *   Home Reset:
 *   Wait For Movement:
 *   - Use this part of the action sequence?
 *
 * ---
 * 
 * === Action Sequences - Angle ===
 * 
 * These action sequences allow you to have control over the camera angle.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * ---
 *
 * ANGLE: Change Angle
 * - Changes the camera angle.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Angle:
 *   - Change the camera angle to this many degrees.
 *
 *   Duration:
 *   - Duration in frames to change camera angle.
 *
 *   Angle Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Angle?:
 *   - Wait for angle changes to complete before performing next command?
 *
 * ---
 *
 * ANGLE: Reset Angle
 * - Reset any angle settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Duration:
 *   - Duration in frames to reset camera angle.
 *
 *   Angle Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Angle?:
 *   - Wait for angle changes to complete before performing next command?
 *
 * ---
 *
 * ANGLE: Wait For Angle
 * - Waits for angle changes to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * === Action Sequences - Animations ===
 *
 * These Action Sequences are related to the 'Animations' that can be found in
 * the Animations tab of the Database.
 *
 * ---
 *
 * ANIM: Action Animation
 * - Plays the animation associated with the action.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Attack Animation
 * - Plays the animation associated with the user's weapon.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Attack Animation 2+
 * - Plays the animation associated with the user's other weapons.
 * - Plays nothing if there is no other weapon equipped.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 * 
 *   Slot:
 *   - Which weapon slot to get this data from?
 *   - Main-hand weapon is weapon slot 1.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Cast Animation
 * - Plays the cast animation associated with the action.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Change Battle Portrait
 * - Changes the battle portrait of the actor (if it's an actor).
 * - Can be used outside of battle/action sequences.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *   - Valid units can only be actors.
 *
 *   Filename:
 *   - Select the file to change the actor's portrait to.
 * 
 * ---
 *
 * ANIM: Play at Coordinate
 * - Plays an animation on the screen at a specific x, y coordinate.
 * - Requires VisuMZ_0_CoreEngine!
 * 
 *   Animation ID:
 *   - Plays this animation.
 * 
 *   Coordinates:
 * 
 *     X:
 *     Y:
 *     - X/Y coordinate used for the animation.
 *       You may use JavaScript code.
 * 
 *   Mirror Animation?:
 *   - Mirror the animation?
 * 
 *   Mute Animation?:
 *   - Mute the animation?
 * 
 *   Wait for Completion?:
 *   - Wait the animation to finish before continuing?
 *
 * ---
 *
 * ANIM: Show Animation
 * - Plays the a specific animation on unit(s).
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Animation ID:
 *   - Select which animation to play on unit(s).
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Wait For Animation
 * - Causes the interpreter to wait for any animation(s) to finish.
 *
 * ---
 *
 * === Action Sequences - Battle Log ===
 *
 * These Action Sequences are related to the Battle Log Window, the window
 * found at the top of the battle screen.
 *
 * ---
 *
 * BTLOG: Add Text
 * - Adds a new line of text into the Battle Log.
 *
 *   Text:
 *   - Add this text into the Battle Log.
 *   - Text codes allowed.
 * 
 *   Copy to Combat Log?:
 *   - Copies text to the Combat Log.
 *   - Requires VisuMZ_4_CombatLog
 * 
 *     Combat Log Icon:
 *     - What icon would you like to bind to this entry?
 *     - Requires VisuMZ_4_CombatLog
 *
 * ---
 *
 * BTLOG: Clear Battle Log
 * - Clears all the text in the Battle Log.
 *
 * ---
 *
 * BTLOG: Display Action
 * - plays the current action in the Battle Log.
 *
 * ---
 *
 * BTLOG: Pop Base Line
 * - Removes the Battle Log's last added base line and  all text up to its
 *   former location.
 *
 * ---
 *
 * BTLOG: Push Base Line
 * - Adds a new base line to where the Battle Log currently is at.
 *
 * ---
 *
 * BTLOG: Refresh Battle Log
 * - Refreshes the Battle Log.
 *
 * ---
 *
 * BTLOG: UI Show/Hide
 * - Shows or hides the Battle UI (including the Battle Log).
 *
 *   Show/Hide?:
 *   - Shows/hides the Battle UI.
 *
 * ---
 *
 * BTLOG: Wait For Battle Log
 * - Causes the interpreter to wait for the Battle Log to finish.
 *
 * ---
 *
 * BTLOG: Wait For New Line
 * - Causes the interpreter to wait for a new line in the Battle Log.
 *
 * ---
 *
 * === Action Sequences - Camera ===
 *
 * These Action Sequences are battle camera-related.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * CAMERA: Clamp ON/OFF
 * - Turns battle camera clamping on/off.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Setting:
 *   - Turns camera clamping on/off.
 *
 * ---
 *
 * CAMERA: Focus Point
 * - Focus the battle camera on a certain point in the screen.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   X Coordinate:
 *   - Insert the point to focus the camera on.
 *   - You may use JavaScript code.
 *
 *   Y Coordinate:
 *   - Insert the point to focus the camera on.
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for camera focus change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Focus Target(s)
 * - Focus the battle camera on certain battler target(s).
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Targets:
 *   - Select unit(s) to focus the battle camera on.
 *
 *   Duration:
 *   - Duration in frames for camera focus change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Offset
 * - Offset the battle camera from the focus target.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Offset X:
 *   - How much to offset the camera X by.
 *   - Negative: left. Positive: right.
 *
 *   Offset Y:
 *   - How much to offset the camera Y by.
 *   - Negative: up. Positive: down.
 *
 *   Duration:
 *   - Duration in frames for offset change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Reset
 * - Reset the battle camera settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Reset Focus?:
 *   - Reset the focus point?
 *
 *   Reset Offset?:
 *   - Reset the camera offset?
 *
 *   Duration:
 *   - Duration in frames for reset change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Wait For Camera
 * - Waits for camera changes to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 * 
 * === Action Sequences - Cutins ===
 * 
 * Allows you to have control over Visual Cutin Effects.
 * Requires VisuMZ_3_VisualCutinEffect!
 * 
 * ---
 * 
 * CUTIN: Add Visual Cutin Effect
 * - Adds the Visual Cutin Effect using these desired settings.
 * - Only one of each cutin-style type can be present at a time.
 * - Requires VisuMZ_3_VisualCutinEffect!
 * 
 *   Basic Settings:
 * 
 *     Cutin Style Type:
 *     - What Visual Cutin Effect style type do you wish to use?
 *     - Only one of each cutin-style type can be present.
 *     - Refer to VisuMZ wiki for visuals on styles.
 * 
 *     Portrait Target:
 *     - Select unit(s) to grab the Visual Cutin Effect portrait data from.
 *     - First unit will be used to make portrait.
 * 
 *     Parallax Filename:
 *     - Pick a parallax to use for the Visual Cutin Effect.
 *     - Pick (None) to not use a parallax.
 * 
 *     Background Color:
 *     - Use #rrggbb for custom colors or regular numbers for text colors from
 *       the Window Skin.
 *
 *   Extra Settings:
 *   - Extra Plugin Command settings pertaining to this Visual Cutin Effect.
 *   - An explanation for these settings are found in the Visual Cutin Effect
 *     help file and documentation.
 *   - Extra parameters are added for Parallax Scroll Inversion when the target
 *     is an enemy.
 * 
 *   Wait for Entrance:
 *   - Wait until cutin entrance is finished before performing the next
 *     event command?
 * 
 * ---
 *
 * CUTIN: End Visual Cutin Effect (All)
 * - Ends all Visual Cutin Effects currently present.
 * - Requires VisuMZ_3_VisualCutinEffect!
 * 
 *   Wait for Exit:
 *   - Wait until cutin exit is finished before performing the next
 *     event command?
 *
 * ---
 *
 * CUTIN: End Visual Cutin Effect (Type)
 * - Ends the Visual Cutin Effect with the matching type.
 * - Requires VisuMZ_3_VisualCutinEffect!
 *
 *   Cutin Style Type:
 *   - What Visual Cutin Effect style type do you wish to end?
 * 
 *   Wait for Exit:
 *   - Wait until cutin exit is finished before performing the next
 *     event command?
 *
 * ---
 * 
 * CUTIN: Wait for Cutin Entrance
 * - Wait until all cutin entrances are finished before performing the next
 *   event command.
 * - Requires VisuMZ_3_VisualCutinEffect!
 * 
 * ---
 * 
 * CUTIN: Wait for Cutin Exit
 * - Wait until all cutin exits are finished before performing the next
 *   event command.
 * - Requires VisuMZ_3_VisualCutinEffect!
 * 
 * ---
 *
 * === Action Sequences - Dragonbones ===
 *
 * These Action Sequences are Dragonbones-related.
 * Requires VisuMZ_2_DragonbonesUnion!
 *
 * ---
 *
 * DB: Dragonbones Animation
 * - Causes the unit(s) to play a Dragonbones motion animation.
 * - Requires VisuMZ_2_DragonbonesUnion!
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion animation.
 *
 *   Motion Animation:
 *   - What is the name of the Dragonbones motion animation you wish to play?
 *
 * ---
 *
 * DB: Dragonbones Time Scale
 * - Causes the unit(s) to change their Dragonbones time scale.
 * - Requires VisuMZ_2_DragonbonesUnion!
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion animation.
 *
 *   Time Scale:
 *   - Change the value of the Dragonbones time scale to this.
 *
 * ---
 *
 * === Action Sequences - Elements ===
 *
 * These Action Sequences can change up the element(s) used for the action's
 * damage calculation midway through an action.
 *
 * They also require the VisuMZ_1_ElementStatusCore plugin to be present in
 * order for them to work.
 *
 * ---
 *
 * ELE: Add Elements
 * - Adds element(s) to be used when calculating damage.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 *   Elements:
 *   - Select which element ID to add onto the action.
 *   - Insert multiple element ID's to add multiple at once.
 *
 * ---
 *
 * ELE: Clear Element Changes
 * - Clears all element changes made through Action Sequences.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 * ---
 *
 * ELE: Force Elements
 * - Forces only specific element(s) when calculating damage.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 *   Elements:
 *   - Select which element ID to force in the action.
 *   - Insert multiple element ID's to force multiple at once.
 *
 * ---
 *
 * ELE: Null Element
 * - Forces no element to be used when calculating damage.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 * ---
 * 
 * === Action Sequences - Horror Effects ===
 * 
 * These Action Sequences are Horror Effects-related.
 * Requires VisuMZ_2_HorrorEffects!
 * 
 * ---
 *
 * HORROR: Clear All Filters
 * - Clear all Horror Effects filters on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove Horror Effects for.
 *
 * ---
 *
 * HORROR: Glitch Create
 * - Creates the glitch effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to create the Horror Effect for.
 *
 *   Glitch Slices:
 *   - Glitch slices to be used with the target.
 *
 *   Glitch Offset:
 *   - Default offset value.
 *
 *   Glitch Animated?:
 *   - Animate the glitch effect?
 *
 *   Glitch Frequency:
 *   - If animated, how frequent to make the glitch effect?
 *   - Lower = often     Higher = rarer
 *
 *   Glitch Strength:
 *   - If animated, how strong is the glitch effect?
 *   - Lower = weaker     Higher = stronger
 *
 * ---
 *
 * HORROR: Glitch Remove
 * - Removes the glitch effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove the Horror Effect for.
 *
 * ---
 *
 * HORROR: Noise Create
 * - Creates the noise effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to create the Horror Effect for.
 *
 *   Noise Rate:
 *   - Noise rate to be used with the target.
 *
 *   Noise Animated:
 *   - Animate the noise for the target?
 *
 * ---
 *
 * HORROR: Noise Remove
 * - Removes the noise effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove the Horror Effect for.
 *
 * ---
 *
 * HORROR: TV Create
 * - Creates the TV effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to create the Horror Effect for.
 *
 *   TV Line Thickness:
 *   - Default TV line thickness
 *   - Lower = thinner     Higher = thicker
 *
 *   TV Corner Size:
 *   - Default TV line corner size
 *   - Lower = smaller     Higher = bigger
 *
 *   TV Animated:
 *   - Animate the TV?
 *
 *   TV Speed:
 *   - Speed used to animate the TV if animated
 *   - Lower = slower     Higher = faster
 *
 * ---
 *
 * HORROR: TV Remove
 * - Removes the TV effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove the Horror Effect for.
 *
 * ---
 * 
 * === Action Sequences - Impact ===
 * 
 * These Action Sequences are related to creating impact.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * ---
 *
 * IMPACT: Bizarro Inversion
 * - Swaps blue/red colors on the battlefield.
 * - Requires VisuMZ_3_ActSeqImpact!
 * - Created by Manu Gaming!
 *
 *   Bizarro?:
 *   - Enable Bizarro Inversion effect?
 *
 * ---
 *
 * IMPACT: Color Break
 * - Breaks the colors on the screen before reassembling.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Intensity:
 *   - What is the intensity of the color break effect?
 *
 *   Duration:
 *   - What is the duration of the color break effect?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Desaturation
 * - Desaturates all colors on the battlefield.
 * - Requires VisuMZ_3_ActSeqImpact!
 * - Created by Manu Gaming!
 *
 *   Desaturate?:
 *   - Enable Desaturation effect?
 *
 * ---
 *
 * IMPACT: Motion Blur Screen
 * - Creates a motion blur on the whole screen.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Angle:
 *   - Determine what angle to make the motion blur at.
 *
 *   Intensity Rate:
 *   - This determines intensity rate of the motion blur.
 *   - Use a number between 0 and 1.
 *
 *   Duration:
 *   - How many frames should the motion blur last?
 *   - What do you want to be its duration?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Motion Blur Target(s)
 * - Creates a motion blur on selected target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to create motion blur effects for.
 *
 *   Angle:
 *   - Determine what angle to make the motion blur at.
 *
 *   Intensity Rate:
 *   - This determines intensity rate of the motion blur.
 *   - Use a number between 0 and 1.
 *
 *   Duration:
 *   - How many frames should the motion blur last?
 *   - What do you want to be its duration?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Motion Trail Create
 * - Creates a motion trail effect for the target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to create motion trail effects for.
 *
 *   Delay:
 *   - How many frames to delay by when creating a motion trail?
 *   - The higher the delay, the less motion trails there are.
 *
 *   Duration:
 *   - How many frames should the motion trail last?
 *   - What do you want to be its duration?
 *
 *   Hue:
 *   - What do you want to be the hue for the motion trail?
 *
 *   Starting Opacity:
 *   - What starting opacity value do you want for the motion trail?
 *   - Opacity values decrease over time.
 *
 *   Tone:
 *   - What tone do you want for the motion trail?
 *   - Format: [Red, Green, Blue, Gray]
 *
 * ---
 *
 * IMPACT: Motion Trail Remove
 * - Removes the motion trail effect from the target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to clear motion trail effects for.
 *
 * ---
 *
 * IMPACT: Negative Inversion
 * - Inverts all the colors on the battlefield.
 * - Requires VisuMZ_3_ActSeqImpact!
 * - Created by Manu Gaming!
 *
 *   Negative?:
 *   - Enable Negative Inversion effect?
 *
 * ---
 *
 * IMPACT: Oversaturation
 * - Oversaturates colors on the battlefield.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Oversaturate?:
 *   - Enable Oversaturation effect?
 *
 * ---
 *
 * IMPACT: Shockwave at Point
 * - Creates a shockwave at the designated coordinates.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Point: X:
 *   Point: Y:
 *   - What x/y coordinate do you want to create a shockwave at?
 *   - You can use JavaScript code.
 *
 *   Amplitude:
 *   - What is the aplitude of the shockwave effect?
 *
 *   Wavelength:
 *   - What is the wavelength of the shockwave effect?
 *
 *   Duration:
 *   - What is the duration of the shockwave?
 *
 * ---
 *
 * IMPACT: Shockwave from Each Target(s)
 * - Creates a shockwave at each of the target(s) location(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to start a shockwave from.
 *
 *   Target Location:
 *   - Select which part target group to start a shockwave from.
 * 
 *     Offset X:
 *     Offset Y:
 *     - How much to offset the shockwave X/Y point by.
 *
 *   Amplitude:
 *   - What is the aplitude of the shockwave effect?
 *
 *   Wavelength:
 *   - What is the wavelength of the shockwave effect?
 *
 *   Duration:
 *   - What is the duration of the shockwave?
 *
 * ---
 *
 * IMPACT: Shockwave from Target(s) Center
 * - Creates a shockwave from the center of the target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to start a shockwave from.
 *
 *   Target Location:
 *   - Select which part target group to start a shockwave from.
 * 
 *     Offset X:
 *     Offset Y:
 *     - How much to offset the shockwave X/Y point by.
 *
 *   Amplitude:
 *   - What is the aplitude of the shockwave effect?
 *
 *   Wavelength:
 *   - What is the wavelength of the shockwave effect?
 *
 *   Duration:
 *   - What is the duration of the shockwave?
 *
 * ---
 *
 * IMPACT: Time Scale
 * - Adjust time to go faster or slower!
 * - Requires VisuMZ_3_ActSeqImpact!
 * - Created by Manu Gaming!
 *
 *   Scale:
 *   - Adjusts how fast/slow time goes.
 *   - 1.00 is normal. Lower is slower. Higher is faster.
 *
 * ---
 *
 * IMPACT: Time Stop
 * - Stops time for a set amount of milliseconds.
 * - Requires VisuMZ_3_ActSeqImpact!
 * - Created by Manu Gaming!
 *
 *   Milliseconds:
 *   - How many milliseconds should time stop for?
 *   - 1000 milliseconds = 1 second.
 *
 * ---
 *
 * IMPACT: Zoom Blur at Point
 * - Creates a zoom blur at the designated coordinates.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Point: X:
 *   Point: Y:
 *   - What x/y coordinate do you want to focus the zoom at?
 *   - You can use JavaScript code.
 *
 *   Zoom Strength:
 *   - What is the strength of the zoom effect?
 *   - Use a number between 0 and 1.
 *
 *   Visible Radius:
 *   - How much of a radius should be visible from the center?
 *
 *   Duration:
 *   - What is the duration of the zoom blur?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Zoom Blur at Target(s) Center
 * - Creates a zoom blur at the center of targets.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to start a zoom blur from.
 *
 *   Target Location:
 *   - Select which part target group to start a zoom blur from.
 * 
 *     Offset X:
 *     Offset Y:
 *     - How much to offset the zoom blur X/Y point by.
 *
 *   Zoom Strength:
 *   - What is the strength of the zoom effect?
 *   - Use a number between 0 and 1.
 *
 *   Visible Radius:
 *   - How much of a radius should be visible from the center?
 *
 *   Duration:
 *   - What is the duration of the zoom blur?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * === Action Sequences - Inject ===
 *
 * These Action Sequences are related to injecting sprite animations.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * ---
 * 
 * INJECT: Animation Begin
 * - Injects and plays a whole spritesheet animation.
 * - The spritesheet animation will play over the battler until it is finished.
 * - The battler's original sprite will be invisible until finished.
 * - Requires VisuMZ_3_ActSeqImpact!
 * 
 *   Targets:
 *   - Select unit(s) to inject the animation on.
 * 
 *   Filename:
 *   - Select the animation spritesheet file.
 *   - Located in the /img/sv_actors/ folder.
 * 
 *     Horizontal Cells:
 *     - How many horizontal cells (or columns) are there?
 * 
 *     Vertical Cells:
 *     - How many vertical cells (or rows) are there?
 * 
 *     Frame Delay:
 *     - How many frames are played inbetween cells?
 * 
 *     Smooth Bitmap?:
 *     - Smooth the spritesheet graphic?
 * 
 *   Offset:
 * 
 *     Offset X:
 *     - Offsets the X position of the injected animation.
 *     - Negative: left. Positive: right.
 * 
 *     Offset Y:
 *     - Offsets the Y position of the injected animation.
 *     - Negative: up. Positive: down.
 * 
 * ---
 * 
 * INJECT: Animation End
 * - Stops and ends any injected animations on target(s).
 * - Any inject animation will be prematurely terminated.
 * - Requires VisuMZ_3_ActSeqImpact!
 * 
 *   Targets:
 *   - Select unit(s) to stop injected animation(s).
 * 
 * ---
 * 
 * INJECT: Animation Pause/Resume
 * - Pauses/resumes any injected animations on target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 * 
 *   Targets:
 *   - Select unit(s) to pause/resume injected animation(s).
 * 
 *   Pause?:
 *   - Pause the injected animation?
 * 
 * ---
 * 
 * INJECT: Wait For Injected Animation
 * - Waits for injected animations to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqImpact!
 * 
 * ---
 *
 * === Action Sequences - Mechanics ===
 *
 * These Action Sequences are related to various mechanics related to the
 * battle system.
 *
 * ---
 *
 * MECH: Action Effect
 * - Causes the unit(s) to take damage/healing from action and incurs any
 *   changes made such as buffs and states.
 *
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 *
 * ---
 * 
 * MECH: Active Chain Input Disable
 * - Disables input for Active Chain Skills at this time.
 * - Requires VisuMZ_3_ActiveChainSkills!
 * 
 * ---
 *
 * MECH: Add Buff/Debuff
 * - Adds buff(s)/debuff(s) to unit(s). 
 * - Determine which parameters are affected and their durations.
 *
 *   Targets:
 *   - Select unit(s) to receive the buff(s) and/or debuff(s).
 *
 *   Buff Parameters:
 *   - Select which parameter(s) to buff.
 *   - Insert a parameter multiple times to raise its stacks.
 *
 *   Debuff Parameters:
 *   - Select which parameter(s) to debuff.
 *   - Insert a parameter multiple times to raise its stacks.
 *
 *   Turns:
 *   - Number of turns to set the parameter(s) buffs to.
 *   - You may use JavaScript code.
 *
 * ---
 *
 * MECH: Add State
 * - Adds state(s) to unit(s).
 *
 *   Targets:
 *   - Select unit(s) to receive the buff(s).
 *
 *   States:
 *   - Select which state ID(s) to add to unit(s).
 *   - Insert multiple state ID's to add multiple at once.
 *
 * ---
 * 
 * MECH: Analyze Weakness
 * - Reveal elemental weakness(es) from target(s).
 * - Requires VisuMZ_3_WeaknessDisplay!
 * 
 *   Targets:
 *   - Select unit(s) to reveal elemental weaknesses for.
 * 
 *   Reveal:
 *   - How many elemental weaknesses do you wish to reveal?
 *   - You may use JavaScript code.
 * 
 * ---
 *
 * MECH: Armor Penetration
 * - Adds an extra layer of defensive penetration/reduction.
 * - You may use JavaScript code for any of these.
 *
 *   Armor/Magic Penetration:
 *
 *     Rate:
 *     - Penetrates an extra multiplier of armor by this value.
 *
 *     Flat:
 *     - Penetrates a flat amount of armor by this value.
 *
 *   Armor/Magic Reduction:
 *
 *     Rate:
 *     - Reduces an extra multiplier of armor by this value.
 *
 *     Flat:
 *     - Reduces a flat amount of armor by this value.
 *
 * ---
 * 
 * MECH: ATB Gauge
 * - Alters the ATB/TPB Gauges.
 * - Requires VisuMZ_2_BattleSystemATB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the ATB/TPB Gauges for.
 * 
 *   Charging:
 *   
 *     Charge Rate:
 *     - Changes made to the ATB Gauge if it is currently charging.
 * 
 *   Casting:
 *   
 *     Cast Rate:
 *     - Changes made to the ATB Gauge if it is currently casting.
 *   
 *     Interrupt?:
 *     - Interrupt the ATB Gauge if it is currently casting?
 * 
 * ---
 * 
 * MECH: Boost Points Change
 * - Changes Boost Points for target(s).
 * - Requires VisuMZ_3_BoostAction!
 * 
 *   Targets:
 *   - Select unit(s) to alter the Boost Points for.
 * 
 *   Alter Boost Points By:
 *   - Alters the unit(s) Boost Points.
 *   - Positive for gaining points. Negative for losing points.
 * 
 * ---
 * 
 * MECH: Boost Store Data
 * - Stores the number of Boosts used this action inside a variable.
 * - Requires VisuMZ_3_BoostAction!
 * 
 *   Variable ID:
 *   - Which variable do you want to store the data inside?
 * 
 * ---
 * 
 * MECH: Break Shield Change
 * - Changes Break Shields for target(s) if not Break Stunned.
 * - Requires VisuMZ_4_BreakShields!
 * 
 *   Targets:
 *   - Select unit(s) to alter the Break Shields for.
 * 
 *   Alter Break Shields By:
 *   - Alters the unit(s) Break Shields.
 *   - Positive for gaining shields. Negative for losing shields.
 * 
 * ---
 * 
 * MECH: Break Shield Reset
 * - Resets Break Shields for target(s) if not Break Stunned.
 * - Requires VisuMZ_4_BreakShields!
 * 
 *   Targets:
 *   - Select unit(s) to reset the Break Shields for.
 * 
 * ---
 * 
 * MECH: BTB Brave Points
 * - Alters the target(s) Brave Points to an exact value.
 * - Requires VisuMZ_2_BattleSystemBTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the ATB/TPB Gauges for.
 * 
 *   Alter Brave Points By:
 *   - Alters the target(s) Brave Points.
 *   - Positive for gaining BP.
 *   - Negative for losing BP.
 * 
 * ---
 *
 * MECH: Collapse
 * - Causes the unit(s) to perform its collapse animation if the unit(s)
 *   has died.
 *
 *   Targets:
 *   - Select unit(s) to process a death collapse.
 *
 *   Force Death:
 *   - Force death even if the unit has not reached 0 HP?
 *   - This will remove immortality.
 *
 *   Wait For Effect?:
 *   - Wait for the collapse effect to complete before performing next command?
 *
 * ---
 * 
 * MECH: CTB Order
 * - Alters the CTB Turn Order.
 * - Requires VisuMZ_2_BattleSystemCTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the CTB Turn Order for.
 * 
 *   Change Order By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 * ---
 * 
 * MECH: CTB Speed
 * - Alters the CTB Speed.
 * - Requires VisuMZ_2_BattleSystemCTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the CTB Speed for.
 * 
 *   Charge Rate:
 *   - Changes made to the CTB Speed if it is currently charging.
 * 
 *   Cast Rate:
 *   - Changes made to the CTB Speed if it is currently casting.
 * 
 * ---
 * 
 * MECH: Custom Damage Formula
 * - Changes the current action's damage formula to custom.
 * - This will assume the MANUAL damage style.
 * 
 *   Formula:
 *   - Changes the current action's damage formula to custom.
 *   - Use 'default' to revert the damage formula.
 * 
 * ---
 *
 * MECH: Damage Popup
 * - Causes the unit(s) to display the current state of damage received
 *   or healed.
 *
 *   Targets:
 *   - Select unit(s) to prompt a damage popup.
 *
 * ---
 *
 * MECH: Dead Label Jump
 * - If the active battler is dead, jump to a specific label in the
 *   common event.
 *
 *   Jump To Label:
 *   - If the active battler is dead, jump to this specific label in the
 *     common event.
 *
 * ---
 *
 * MECH: Enemy Escape
 * - Causes the enemy unit(s) to escape.
 *
 *   Targets:
 *   - Select unit(s) to escape.
 *
 * ---
 *
 * MECH: ETB Energy Count
 * - Alters the subject team's available Energy Count.
 * - Requires VisuMZ_2_BattleSystemETB!
 *
 *   Energy Count:
 *   - Alters the subject team's available Energy Count.
 *   - Positive for gaining energy. Negative for losing energy.
 *
 * ---
 *
 * MECH: FTB Action Count
 * - Alters the subject team's available Action Count.
 * - Requires VisuMZ_2_BattleSystemFTB!
 *
 *   Action Count:
 *   - Alters the subject team's available Action Count.
 *   - Positive for gaining actions. Negative for losing actions.
 *
 * ---
 *
 * MECH: HP, MP, TP
 * - Alters the HP, MP, and TP values for unit(s).
 * - Positive values for healing. Negative values for damage.
 *
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 *
 *   HP, MP, TP:
 *
 *     Rate:
 *     - Changes made to the parameter based on rate.
 *     - Positive values for healing. Negative values for damage.
 *
 *     Flat:
 *     - Flat changes made to the parameter.
 *     - Positive values for healing. Negative values for damage.
 *
 *   Damage Popup?:
 *   - Display a damage popup after?
 *
 * ---
 *
 * MECH: Immortal
 * - Changes the immortal flag of targets. If immortal flag is removed and a
 *   unit would die, collapse that unit.
 *
 *   Targets:
 *   - Alter the immortal flag of these groups. If immortal flag is removed and
 *     a unit would die, collapse that unit.
 *
 *   Immortal:
 *   - Turn immortal flag for unit(s) on/off?
 *
 * ---
 *
 * MECH: Multipliers
 * - Changes the multipliers for the current action.
 * - You may use JavaScript code for any of these.
 *
 *   Critical Hit%:
 *
 *     Rate:
 *     - Affects chance to land a critical hit by this multiplier.
 *
 *     Flat:
 *     - Affects chance to land a critical hit by this flat bonus.
 *
 *   Critical Damage
 *
 *     Rate:
 *     - Affects critical damage by this multiplier.
 *
 *     Flat:
 *     - Affects critical damage by this flat bonus.
 *
 *   Damage/Healing
 *
 *     Rate:
 *     - Sets the damage/healing multiplier for current action.
 *
 *     Flat:
 *     - Sets the damage/healing bonus for current action.
 *
 *   Hit Rate
 *
 *     Rate:
 *     - Affects chance to connect attack by this multiplier.
 *
 *     Flat:
 *     - Affects chance to connect attack by this flat bonus.
 *
 * ---
 * 
 * MECH: Once Parallel
 * - Plays a Common Event parallel to the battle event once without repeating
 *   itself when done.
 * 
 *   Common Event ID:
 *   - The ID of the parallel Common Event to play.
 *   - Does NOT repeat itself when finished.
 *   - When exiting battle scene, all Once Parallels are cleared.
 *   - Once Parallels are not retained upon reentering the scene.
 *   - Once Parallels are not stored in memory and cannot be saved.
 * 
 * ---
 * 
 * MECH: OTB Order
 * - Alters the OTB Turn Order. Best used with single targets.
 * - Requires VisuMZ_2_BattleSystemOTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the OTB Turn Order for.
 * 
 *   Current Turn By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 *   Next Turn By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 *   Follow Turn By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 * ---
 * 
 * MECH: PTB Alter Cost
 * - Alters the action's cost settings.
 * - Requires VisuMZ_2_BattleSystemPTB!
 * 
 *   Override?:
 *   - Overrides any 'permanent' settings for Changeability?
 * 
 *   Alter Changeability:
 *   - Allow the cost type and value to be changeable?
 * 
 *   Alter Cost Type:
 *   - Change the cost type to this scenario.
 *   - Use 'Unchanged' for no changes.
 * 
 *   Alter Cost Value:
 *   - What is the default action cost for this scenario?
 * 
 *   Priority:
 *   - What is this scenario's priority? Scenario outcomes with equal or lower
 *     priorities cannot override types and costs.
 * 
 * ---
 * 
 * MECH: PTB Conversion
 * - Converts full actions into half actions.
 * - Requires VisuMZ_2_BattleSystemPTB!
 * 
 *   Conversion Count:
 *   - Converts full actions into half actions.
 *   - If not enough, consume half actions.
 * 
 * ---
 * 
 * MECH: PTB Full/Half Action(s)
 * - Alters the subject team's available Full/Half Actions.
 * - Requires VisuMZ_2_BattleSystemPTB!
 * 
 *   Full Actions:
 *   - Alters the subject team's available Full Actions.
 *   - Positive for gaining. Negative for losing.
 * 
 *   Half Actions:
 *   - Alters the subject team's available Half Actions.
 *   - Positive for gaining. Negative for losing.
 * 
 * ---
 *
 * MECH: Remove Buff/Debuff
 * - Removes buff(s)/debuff(s) from unit(s). 
 * - Determine which parameters are removed.
 *
 *   Targets:
 *   - Select unit(s) to have the buff(s) and/or debuff(s) removed.
 *
 *   Buff Parameters:
 *   - Select which buffed parameter(s) to remove.
 *
 *   Debuff Parameters:
 *   - Select which debuffed parameter(s) to remove.
 *
 * ---
 *
 * MECH: Remove State
 * - Remove state(s) from unit(s).
 *
 *   Targets:
 *   - Select unit(s) to have states removed from.
 *
 *   States:
 *   - Select which state ID(s) to remove from unit(s).
 *   - Insert multiple state ID's to remove multiple at once.
 *
 * ---
 * 
 * MECH: STB Exploit Effect
 * - Utilize the STB Exploitation mechanics!
 * - Requires VisuMZ_2_BattleSystemSTB!
 * 
 *   Target(s) Exploited?:
 *   - Exploit the below targets?
 * 
 *     Targets:
 *     - Select unit(s) to become exploited.
 * 
 *     Force Exploitation:
 *     - Force the exploited status?
 * 
 *   User Exploiter?:
 *   - Allow the user to become the exploiter?
 * 
 *     Force Exploitation:
 *     - Force the exploiter status?
 * 
 * ---
 * 
 * MECH: STB Extra Action
 * - Adds an extra action for the currently active battler.
 * - Requires VisuMZ_2_BattleSystemSTB!
 * 
 *   Extra Actions:
 *   - How many extra actions should the active battler gain?
 *   - You may use JavaScript code.
 * 
 * ---
 * 
 * MECH: STB Remove Excess Actions
 * - Removes excess actions from the active battler.
 * - Requires VisuMZ_2_BattleSystemSTB!
 * 
 *   Remove Actions:
 *   - How many actions to remove from the active battler?
 *   - You may use JavaScript code.
 * 
 * ---
 * 
 * MECH: Swap Weapon
 * - Causes the unit(s) to swap their weapon for another.
 * - Requires VisuMZ_2_WeaponSwapSystem!
 * 
 *   Targets:
 *   - Select unit(s) to swap weapons for.
 * 
 *   Weapon Type ID:
 *   - Which weapon type to swap to?
 *   - This is NOT the weapon's ID.
 *   - It's the weapon TYPE.
 * 
 * ---
 * 
 * MECH: Text Popup
 * - Causes the unit(s) to display a text popup.
 * 
 *   Targets:
 *   - Select unit(s) to prompt a text popup.
 * 
 *   Text:
 *   - What text do you wish to display?
 * 
 *   Text Color:
 *   - Use #rrggbb for custom colors or regular numbers for text colors from
 *     the Window Skin.
 * 
 *   Flash Color:
 *   - Adjust the popup's flash color.
 *   - Format: [red, green, blue, alpha]
 * 
 *   Flash Duration:
 *   - What is the frame duration of the flash effect?
 * 
 * ---
 * 
 * MECH: Variable Popup
 * - Causes the unit(s) to display a popup using the data stored inside
 *   a variable.
 * 
 *   Targets:
 *   - Select unit(s) to prompt a text popup.
 * 
 *   Variable:
 *   - Get data from which variable to display as a popup?
 * 
 *   Digit Grouping:
 *   - Use digit grouping to separate numbers?
 *   - Requires VisuMZ_0_CoreEngine!
 * 
 *   Text Color:
 *   - Use #rrggbb for custom colors or regular numbers for text colors from
 *     the Window Skin.
 * 
 *   Flash Color:
 *   - Adjust the popup's flash color.
 *   - Format: [red, green, blue, alpha]
 * 
 *   Flash Duration:
 *   - What is the frame duration of the flash effect?
 * 
 * ---
 *
 * MECH: Wait For Effect
 * - Waits for the effects to complete before performing next command.
 *
 * ---
 *
 * === Action Sequences - Motion ===
 *
 * These Action Sequences allow you the ability to control the motions of
 * sideview sprites.
 *
 * ---
 * 
 * MOTION: Clear Freeze Frame
 * - Clears any freeze frames from the unit(s).
 * - Only applies to sprite sheets.
 * - Does NOT work with Dragonbones.
 * - Use "DB: Dragonbones Time Scale" instead.
 * 
 *   Targets:
 *   - Select which unit(s) to clear freeze frames for.
 * 
 * ---
 * 
 * MOTION: Freeze Motion Frame
 * - Forces a freeze frame instantly at the selected motion.
 * - Automatically clears with a new motion.
 * - Only applies to sprite sheets.
 * - Does NOT work with Dragonbones.
 * - Use "DB: Dragonbones Time Scale" instead.
 * 
 *   Targets:
 *   - Select which unit(s) to freeze motions for.
 * 
 *   Motion Type:
 *   - Freeze this motion for the unit(s).
 * 
 *   Frame Index:
 *   - Which frame do you want to freeze the motion on?
 *   - Frame index values start at 0.
 * 
 *   Show Weapon?:
 *   - If using 'attack', 'thrust', 'swing', or 'missile', display the
 *     weapon sprite?
 * 
 * ---
 *
 * MOTION: Motion Type
 * - Causes the unit(s) to play the selected motion.
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion.
 *
 *   Motion Type:
 *   - Play this motion for the unit(s).
 *
 *   Show Weapon?:
 *   - If using 'attack', 'thrust', 'swing', or 'missile', display the
 *     weapon sprite?
 *
 * ---
 *
 * MOTION: Perform Action
 * - Causes the unit(s) to play the proper motion based on the current action.
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion.
 *
 * ---
 *
 * MOTION: Refresh Motion
 * - Cancels any set motions unit(s) has to do and use their most natural
 *   motion at the moment.
 *
 *   Targets:
 *   - Select which unit(s) to refresh their motion state.
 *
 * ---
 *
 * MOTION: Wait By Motion Frame
 * - Creates a wait equal to the number of motion frames passing.
 * - Time is based on Plugin Parameters => Actors => Motion Speed.
 *
 *   Motion Frames to Wait?:
 *   - Each "frame" is equal to the value found in 
 *     Plugin Parameters => Actors => Motion Speed
 *
 * ---
 *
 * === Action Sequences - Movement ===
 *
 * These Action Sequences allow you the ability to control the sprites of
 * actors and enemies in battle.
 *
 * ---
 *
 * MOVE: Battle Step
 * - Causes the unit(s) to move forward past their home position to prepare
 *   for action.
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Change Home By Distance
 * - Change unit(s)'s home position by a distance from their current home
 *   position(s).
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change home position(s) for.
 *
 *   Distance Adjustment:
 *   - Makes adjustments to distance values to determine which direction to
 *     change by.
 *     - Normal - No adjustments made
 *     - Horizontal - Actors adjust left, Enemies adjust right
 *     - Vertical - Actors adjust Up, Enemies adjust down
 *     - Both - Applies both Horizontal and Vertical
 *
 *     Distance: X:
 *     - Horizontal distance to move.
 *     - You may use JavaScript code.
 *
 *     Distance: Y:
 *     - Vertical distance to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total change amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Change Home To Point
 * - Change home position(s) to a target point on the screen.
 * - Sideview-only! Points based off Graphics.boxWidth/Height.
 *
 *   Targets:
 *   - Select which unit(s) to change home position(s) for.
 *
 *   Destination Point:
 *   - Select which point to face.
 *     - Center
 *     - Point X, Y
 *       - Replace 'x' and 'y' with coordinates
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total change amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Change Home To Target(s)
 * - Moves unit(s) to another unit(s) on the battle field.
 * - Sideview-only!
 *
 *   Targets (Moving):
 *   - Select which unit(s) to change home position(s) for.
 *
 *   Targets (Destination):
 *   - Select which unit(s) to change home position to.
 *
 *     Target Location:
 *     - Select which part target group to change home position to.
 *       - front head
 *       - front center
 *       - front base
 *       - middle head
 *       - middle center
 *       - middle base
 *       - back head
 *       - back center
 *       - back base
 *
 *     Melee Distance:
 *     - The melee distance away from the target location in addition to the
 *       battler's width.
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total change amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Face Direction
 * - Causes the unit(s) to face forward or backward.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change direction.
 *
 *   Direction:
 *   - Select which direction to face.
 *
 * ---
 *
 * MOVE: Face Point
 * - Causes the unit(s) to face a point on the screen.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change direction.
 *
 *   Point:
 *   - Select which point to face.
 *     - Home
 *     - Center
 *     - Point X, Y
 *       - Replace 'x' and 'y' with coordinates
 *
 *   Face Away From?:
 *   - Face away from the point instead?
 *
 * ---
 *
 * MOVE: Face Target(s)
 * - Causes the unit(s) to face other targets on the screen.
 * - Sideview-only!
 *
 *   Targets (facing):
 *   - Select which unit(s) to change direction.
 *
 *   Targets (destination):
 *   - Select which unit(s) for the turning unit(s) to face.
 *
 *   Face Away From?:
 *   - Face away from the unit(s) instead?
 *
 * ---
 *
 * MOVE: Float
 * - Causes the unit(s) to float above the ground.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to make float.
 *
 *   Desired Height:
 *   - Vertical distance to float upward.
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total float amount.
 *
 *   Float Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Float?:
 *   - Wait for floating to complete before performing next command?
 *
 * ---
 *
 * MOVE: Home Reset
 * - Causes the unit(s) to move back to their home position(s) and face back to
 *   their original direction(s).
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Jump
 * - Causes the unit(s) to jump into the air.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to make jump.
 *
 *   Desired Height:
 *   - Max jump height to go above the ground
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total jump amount.
 *
 *   Wait For Jump?:
 *   - Wait for jumping to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move Distance
 * - Moves unit(s) by a distance from their current position(s).
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Distance Adjustment:
 *   - Makes adjustments to distance values to determine which direction to
 *     move unit(s).
 *     - Normal - No adjustments made
 *     - Horizontal - Actors adjust left, Enemies adjust right
 *     - Vertical - Actors adjust Up, Enemies adjust down
 *     - Both - Applies both Horizontal and Vertical
 *
 *     Distance: X:
 *     - Horizontal distance to move.
 *     - You may use JavaScript code.
 *
 *     Distance: Y:
 *     - Vertical distance to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move To Point
 * - Moves unit(s) to a designated point on the screen.
 * - Sideview-only! Points based off Graphics.boxWidth/Height.
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Destination Point:
 *   - Select which point to face.
 *     - Home
 *     - Center
 *     - Point X, Y
 *       - Replace 'x' and 'y' with coordinates
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move To Target(s)
 * - Moves unit(s) to another unit(s) on the battle field.
 * - Sideview-only!
 *
 *   Targets (Moving):
 *   - Select which unit(s) to move.
 *
 *   Targets (Destination):
 *   - Select which unit(s) to move to.
 *
 *     Target Location:
 *     - Select which part target group to move to.
 *       - front head
 *       - front center
 *       - front base
 *       - middle head
 *       - middle center
 *       - middle base
 *       - back head
 *       - back center
 *       - back base
 *
 *     Melee Distance:
 *     - The melee distance away from the target location in addition to the
 *       battler's width.
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Opacity
 * - Causes the unit(s) to change opacity.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change opacity.
 *
 *   Desired Opacity:
 *   - Change to this opacity value.
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for opacity change.
 *
 *   Opacity Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Opacity?:
 *   - Wait for opacity changes to complete before performing next command?
 *
 * ---
 *
 * MOVE: Scale/Grow/Shrink
 * - Causes the unit(s) to scale, grow, or shrink?.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change the scale of.
 *
 *   Scale X:
 *   Scale Y:
 *   - What target scale value do you want?
 *   - 1.0 is normal size.
 *
 *   Duration:
 *   - Duration in frames to scale for.
 *
 *   Scale Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Scale?:
 *   - Wait for scaling to complete before performing next command?
 *
 * ---
 *
 * MOVE: Skew/Distort
 * - Causes the unit(s) to skew.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to skew.
 *
 *   Skew X:
 *   Skew Y:
 *   - What variance to skew?
 *   - Use small values for the best results.
 *
 *   Duration:
 *   - Duration in frames to skew for.
 *
 *   Skew Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Skew?:
 *   - Wait for skew to complete before performing next command?
 *
 * ---
 *
 * MOVE: Spin/Rotate
 * - Causes the unit(s) to spin.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to spin.
 *
 *   Angle:
 *   - How many degrees to spin?
 *
 *   Duration:
 *   - Duration in frames to spin for.
 *
 *   Spin Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 * 
 *   Revert Angle on Finish:
 *   - Upon finishing the spin, revert the angle back to 0.
 *
 *   Wait For Spin?:
 *   - Wait for spin to complete before performing next command?
 *
 * ---
 *
 * MOVE: Wait For Float
 * - Waits for floating to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Jump
 * - Waits for jumping to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Movement
 * - Waits for movement to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Opacity
 * - Waits for opacity changes to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Scale
 * - Waits for scaling to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Skew
 * - Waits for skewing to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Spin
 * - Waits for spinning to complete before performing next command.
 *
 * ---
 * 
 * === Action Sequences - Projectiles ===
 * 
 * Create projectiles on the screen and fire them off at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * ---
 *
 * PROJECTILE: Animation
 * - Create an animation projectile and fire it at a target.
 * - Requires VisuMZ_3_ActSeqProjectiles!
 *
 *   Coordinates:
 *
 *     Start Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should start from.
 *         - Target - Start from battler target(s)
 *         - Point - Start from a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) to start the projectile from.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile from.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to start the projectile at.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *     Goal Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should go to.
 *         - Target - Goal is battler target(s)
 *         - Point - Goal is a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) for projectile to go to.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile to.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to send the projectile to.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *   Settings:
 *
 *     Animation ID:
 *     - Determine which animation to use as a projectile.
 *
 *     Duration:
 *     - Duration for the projectile(s) to travel.
 *
 *     Wait For Projectile?:
 *     - Wait for projectile(s) to reach their destination before going onto
 *       the next command?
 * 
 *     Wait For Animation?:
 *     - Wait for animation to finish before going to the next command?
 *
 *     Extra Settings:
 *     - Add extra settings to the projectile?
 *
 *       Auto Angle?:
 *       - Automatically angle the projectile to tilt the direction
 *         it's moving?
 *
 *       Angle Offset:
 *       - Alter the projectile's tilt by this many degrees.
 *
 *       Arc Peak:
 *       - This is the height of the project's trajectory arc in pixels.
 *
 *       Easing:
 *       - Select which easing type to apply to the projectile's trajectory.
 *
 *       Spin Speed:
 *       - Determine how much angle the projectile spins per frame.
 *       - Does not work well with "Auto Angle".
 *
 * ---
 *
 * PROJECTILE: Icon
 * - Create an icon projectile and fire it at a target.
 * - Requires VisuMZ_3_ActSeqProjectiles!
 *
 *   Coordinates:
 *
 *     Start Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should start from.
 *         - Target - Start from battler target(s)
 *         - Point - Start from a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) to start the projectile from.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile from.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to start the projectile at.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *     Goal Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should go to.
 *         - Target - Goal is battler target(s)
 *         - Point - Goal is a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) for projectile to go to.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile to.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to send the projectile to.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *   Settings:
 *
 *     Icon:
 *     - Determine which icon to use as a projectile.
 *       - You may use JavaScript code.
 *
 *     Duration:
 *     - Duration for the projectile(s) to travel.
 *
 *     Wait For Projectile?:
 *     - Wait for projectile(s) to reach their destination before going onto
 *       the next command?
 *
 *     Extra Settings:
 *     - Add extra settings to the projectile?
 *
 *       Auto Angle?:
 *       - Automatically angle the projectile to tilt the direction
 *         it's moving?
 *
 *       Angle Offset:
 *       - Alter the projectile's tilt by this many degrees.
 *
 *       Arc Peak:
 *       - This is the height of the project's trajectory arc in pixels.
 *
 *       Blend Mode:
 *       - What kind of blend mode do you wish to apply to the projectile?
 *         - Normal
 *         - Additive
 *         - Multiply
 *         - Screen
 *
 *       Easing:
 *       - Select which easing type to apply to the projectile's trajectory.
 *
 *       Hue:
 *       - Adjust the hue of the projectile.
 *       - Insert a number between 0 and 360.
 *
 *       Scale:
 *       - Adjust the size scaling of the projectile.
 *       - Use decimals for exact control.
 *
 *       Spin Speed:
 *       - Determine how much angle the projectile spins per frame.
 *       - Does not work well with "Auto Angle".
 *
 * ---
 *
 * PROJECTILE: Picture
 * - Create a picture projectile and fire it at a target.
 * - Requires VisuMZ_3_ActSeqProjectiles!
 *
 *   Coordinates:
 *
 *     Start Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should start from.
 *         - Target - Start from battler target(s)
 *         - Point - Start from a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) to start the projectile from.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile from.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to start the projectile at.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *     Goal Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should go to.
 *         - Target - Goal is battler target(s)
 *         - Point - Goal is a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) for projectile to go to.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile to.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to send the projectile to.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *   Settings:
 *
 *     Picture Filename:
 *     - Determine which picture to use as a projectile.
 *
 *     Duration:
 *     - Duration for the projectile(s) to travel.
 *
 *     Wait For Projectile?:
 *     - Wait for projectile(s) to reach their destination before going onto
 *       the next command?
 *
 *     Extra Settings:
 *     - Add extra settings to the projectile?
 *
 *       Auto Angle?:
 *       - Automatically angle the projectile to tilt the direction
 *         it's moving?
 *
 *       Angle Offset:
 *       - Alter the projectile's tilt by this many degrees.
 *
 *       Arc Peak:
 *       - This is the height of the project's trajectory arc in pixels.
 *
 *       Blend Mode:
 *       - What kind of blend mode do you wish to apply to the projectile?
 *         - Normal
 *         - Additive
 *         - Multiply
 *         - Screen
 *
 *       Easing:
 *       - Select which easing type to apply to the projectile's trajectory.
 *
 *       Hue:
 *       - Adjust the hue of the projectile.
 *       - Insert a number between 0 and 360.
 *
 *       Scale:
 *       - Adjust the size scaling of the projectile.
 *       - Use decimals for exact control.
 *
 *       Spin Speed:
 *       - Determine how much angle the projectile spins per frame.
 *       - Does not work well with "Auto Angle".
 *
 * ---
 * 
 * === Action Sequences - Skew ===
 * 
 * These action sequences allow you to have control over the camera skew.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * ---
 *
 * SKEW: Change Skew
 * - Changes the camera skew.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Skew X:
 *   - Change the camera skew X to this value.
 *
 *   Skew Y:
 *   - Change the camera skew Y to this value.
 *
 *   Duration:
 *   - Duration in frames to change camera skew.
 *
 *   Skew Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Skew?:
 *   - Wait for skew changes to complete before performing next command?
 *
 * ---
 *
 * SKEW: Reset Skew
 * - Reset any skew settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Duration:
 *   - Duration in frames to reset camera skew.
 *
 *   Skew Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Skew?:
 *   - Wait for skew changes to complete before performing next command?
 *
 * ---
 *
 * SKEW: Wait For Skew
 * - Waits for skew changes to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * === Action Sequences - Target ===
 *
 * If using a manual target by target Action Sequence, these commands will give
 * you full control over its usage.
 *
 * ---
 *
 * TARGET: Current Index
 * - Sets the current index to this value.
 * - Then decide to jump to a label (optional).
 *
 *   Set Index To:
 *   - Sets current targeting index to this value.
 *   - 0 is the starting index of a target group.
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * TARGET: Next Target
 * - Moves index forward by 1 to select a new current target.
 * - Then decide to jump to a label (optional).
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * TARGET: Previous Target
 * - Moves index backward by 1 to select a new current target.
 * - Then decide to jump to a label (optional).
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * TARGET: Random Target
 * - Sets index randomly to determine new currernt target.
 * - Then decide to jump to a label (optional).
 *
 *   Force Random?:
 *   - Index cannot be its previous index amount after random.
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * === Action Sequences - Weapon ===
 *
 * Allows for finer control over Dual/Multi Wielding actors.
 * Only works for Actors.
 *
 * ---
 *
 * WEAPON: Clear Weapon Slot
 * - Clears the active weapon slot (making others valid again).
 * - Only works for Actors.
 *
 *   Targets:
 *   - Select unit(s) to clear the active weapon slot for.
 *
 * ---
 *
 * WEAPON: Next Weapon Slot
 * - Goes to next active weapon slot (making others invalid).
 * - If next slot is weaponless, don't label jump.
 *
 *   Targets:
 *   - Select unit(s) to change the next active weapon slot for.
 *
 * ---
 *
 * WEAPON: Set Weapon Slot
 * - Sets the active weapon slot (making others invalid).
 * - Only works for Actors.
 *
 *   Targets:
 *   - Select unit(s) to change the active weapon slot for.
 *
 *   Weapon Slot ID:
 *   - Select weapon slot to make active (making others invalid).
 *   - Use 0 to clear and normalize. You may use JavaScript code.
 *
 * ---
 *
 * === Action Sequences - Zoom ===
 *
 * These Action Sequences are zoom-related.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * ZOOM: Change Scale
 * - Changes the zoom scale.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Scale:
 *   - The zoom scale to change to.
 *
 *   Duration:
 *   - Duration in frames to reset battle zoom.
 *
 *   Zoom Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Zoom?
 *   - Wait for zoom changes to complete before performing next command?
 *
 * ---
 *
 * ZOOM: Reset Zoom
 * - Reset any zoom settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Duration:
 *   - Duration in frames to reset battle zoom.
 *
 *   Zoom Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Zoom?
 *   - Wait for zoom changes to complete before performing next command?
 *
 * ---
 *
 * ZOOM: Wait For Zoom
 * - Waits for zoom changes to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Auto Battle Settings
 * ============================================================================
 *
 * These Plugin Parameter settings allow you to change the aspects added by
 * this plugin that support Auto Battle and the Auto Battle commands.
 *
 * Auto Battle commands can be added to the Party Command Window and/or Actor
 * Command Window. The one used by the Party Command Window will cause the
 * whole party to enter an Auto Battle state until stopped by a button input.
 * The command used by the Actor Command Window, however, will cause the actor
 * to select an action based off the Auto Battle A.I. once for the current turn
 * instead.
 *
 * ---
 *
 * Battle Display
 * 
 *   Message:
 *   - Message that's displayed when Auto Battle is on.
 *     Text codes allowed. %1 - OK button, %2 - Cancel button
 * 
 *   OK Button:
 *   - Text used to represent the OK button.
 *   - If VisuMZ_0_CoreEngine is present, ignore this.
 * 
 *   Cancel Button:
 *   - Text used to represent the Cancel button.
 *   - If VisuMZ_0_CoreEngine is present, ignore this.
 * 
 *   Background Type:
 *   - Select background type for Auto Battle window.
 *     - 0 - Window
 *     - 1 - Dim
 *     - 2 - Transparent
 * 
 *   JS: X, Y, W, H:
 *   - Code used to determine the dimensions for this window.
 *
 * ---
 *
 * Options
 * 
 *   Add Option?:
 *   - Add the Auto Battle options to the Options menu?
 * 
 *   Adjust Window Height:
 *   - Automatically adjust the options window height?
 * 
 *   Startup Name:
 *   - Command name of the option.
 * 
 *   Style Name:
 *   - Command name of the option.
 * 
 *   OFF:
 *   - Text displayed when Auto Battle Style is OFF.
 * 
 *   ON:
 *   - Text displayed when Auto Battle Style is ON.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Damage Settings
 * ============================================================================
 *
 * These Plugin Parameters add a variety of things to how damage is handled in
 * battle. These range from hard damage caps to soft damage caps to how damage
 * popups appear, how the formulas for various aspects are handled and more.
 *
 * Damage Styles are also a feature added through this plugin. More information
 * can be found in the help section above labeled 'Damage Styles'.
 *
 * ---
 *
 * Damage Styles
 * 
 *   Default Style:
 *   - Which Damage Style do you want to set as default?
 *   - Use 'Manual' to not use any styles at all.
 *     - The 'Manual' style will not support <Armor Penetration> notetags.
 *     - The 'Manual' style will not support <Armor Reduction> notetags.
 * 
 *   Style List:
 *   - A list of the damage styles available.
 *   - These are used to calculate base damage.
 * 
 *     Name:
 *     - Name of this Damage Style.
 *     -Used for notetags and such.
 * 
 *     JS: Formula:
 *     - The base formula for this Damage Style.
 * 
 *     Items & Equips Core:
 * 
 *       HP Damage:
 *       MP Damage:
 *       HP Recovery:
 *       MP Recovery:
 *       HP Drain:
 *       MP Drain:
 *       - Vocabulary used for this data entry.
 * 
 *       JS: Damage Display:
 *       - Code used the data displayed for this category.
 *
 * ---
 *
 * Damage Cap
 * 
 *   Enable Damage Cap?:
 *   - Put a maximum hard damage cap on how far damage can go?
 *   - This can be broken through the usage of notetags.
 * 
 *   Default Hard Cap:
 *   - The default hard damage cap used before applying damage.
 * 
 *   Enable Soft Cap?:
 *   - Soft caps ease in the damage values leading up to the  hard damage cap.
 *   - Requires hard Damage Cap enabled.
 * 
 *     Base Soft Cap Rate:
 *     - The default soft damage cap used before applying damage.
 * 
 *     Soft Scale Constant:
 *     - The default soft damage cap used before applying damage.
 *
 * ---
 *
 * Popups
 * 
 *   Popup Duration:
 *   - Adjusts how many frames a popup stays visible.
 * 
 *   Newest Popups Bottom:
 *   - Puts the newest popups at the bottom.
 * 
 *   End Battle Show?:
 *   - Show or hide popups upon victory or escape?
 *   - Used to hide battle-state removal popups.
 * 
 *   Offset X:
 *   Offset Y:
 *   - Sets how much to offset the sprites by horizontally/vertically.
 * 
 *   Shift X:
 *   Shift Y:
 *   - Sets how much to shift the sprites by horizontally/vertically.
 * 
 *   Shift Y:
 * 
 *   Critical Flash Color:
 *   - Adjust the popup's flash color.
 *   - Format: [red, green, blue, alpha]
 * 
 *   Critical Duration:
 *   - Adjusts how many frames a the flash lasts.
 *
 * ---
 *
 * Formulas
 * 
 *   JS: Overall Formula:
 *   - The overall formula used when calculating damage.
 * 
 *   JS: Variance Formula:
 *   - The formula used when damage variance.
 * 
 *   JS: Guard Formula:
 *   - The formula used when damage is guarded.
 *
 * ---
 *
 * Critical Hits
 * 
 *   JS: Rate Formula:
 *   - The formula used to calculate Critical Hit Rates.
 * 
 *   JS: Damage Formula:
 *   - The formula used to calculate Critical Hit Damage modification.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Mechanics Settings
 * ============================================================================
 *
 * Some of the base settings for the various mechanics found in the battle
 * system can be altered here in these Plugin Parameters. Most of these will
 * involve JavaScript code and require you to have to good understanding of
 * how the RPG Maker MZ code works before tampering with it.
 *
 * ---
 *
 * Action Speed
 * 
 *   Allow Random Speed?:
 *   - Allow speed to be randomized base off the user's AGI?
 * 
 *   JS: Calculate:
 *   - Code used to calculate action speed.
 *
 * ---
 *
 * Base Troop
 * 
 *   Base Troop ID's:
 *   - Select the Troop ID(s) to duplicate page events from for all
 *     other troops.
 *   - More information can be found in the dedicated Help section above.
 *
 * ---
 * 
 * Common Events (on Map)
 * 
 *   Pre-Battle Event:
 *   Post-Battle Event:
 *   Victory Event:
 *   Defeat Event:
 *   Escape Success Event:
 *   Escape Fail Event:
 *   - Queued Common Event to run upon meeting the condition.
 *   - Use to 0 to not run any Common Event at all.
 *   - "Post-Battle Event" will always run regardless.
 *   - If any events are running before the battle, they will continue running
 *     to the end first before the queued Common Events will run.
 *   - These common events only run on the map scene. They're not meant to run
 *     in the battle scene.
 *   - If the "Defeat Event" has a common event attached to it, then random
 *     encounters will be changed to allow defeat without being sent to the
 *     Game Over scene. Instead, the game will send the player to the map scene
 *     where the Defeat Event will run.
 *
 * ---
 *
 * Escape
 * 
 *   JS: Calc Escape Ratio:
 *   - Code used to calculate the escape success ratio.
 * 
 *   JS: Calc Escape Raise:
 *   - Code used to calculate how much the escape success ratio raises upon
 *     each failure.
 * 
 * ---
 * 
 * Switches
 * 
 *   Switch: Critical:
 *   - Turns switch ON if the action performs a critical hit.
 *   - Switch reverts to OFF whenever an action starts.
 *   - If multiple targets/hits are struck, as long as one hit lands a critical
 *     hit, then the switch will remain ON for the rest of the action.
 * 
 *   Switch: Miss/Evade:
 *   - Turns switch ON if the action misses/is evaded.
 *   - Switch reverts to OFF whenever an action starts.
 *   - If multiple targets/hits are struck, as long as one hit fails to land,
 *     then the switch will remain ON for the rest of the action.
 * 
 * ---
 * 
 * Variables
 * 
 *   Variable: Damage:
 *   - Variable records target damage during action.
 *   - Variable reverts to 0 whenever an action starts.
 *   - If multiple targets/hits are struck, the variable will record the total
 *     amount of damage done for the remainder of the action (unless manually
 *     reseting to 0 during an Action Sequence).
 * 
 *   Variable: Healing:
 *   - Variable records target healing during action.
 *   - Variable reverts to 0 whenever an action starts.
 *   - If multiple targets/hits are struck, the variable will record the total
 *     amount of healing done for the remainder of the action (unless manually
 *     reseting to 0 during an Action Sequence).
 * 
 * ---
 *
 * JS: Battle-Related
 * 
 *   JS: Pre-Start Battle:
 *   - Target function: BattleManager.startBattle()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Start Battle:
 *   - Target function: BattleManager.startBattle()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Battle Victory:
 *   - Target function: BattleManager.processVictory()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Escape Success:
 *   - Target function: BattleManager.onEscapeSuccess()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Escape Failure:
 *   - Target function: BattleManager.onEscapeFailure()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Battle Defeat:
 *   - Target function: BattleManager.processDefeat()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Pre-End Battle:
 *   - Target function: BattleManager.endBattle()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-End Battle:
 *   - Target function: BattleManager.endBattle()
 *   - JavaScript code occurs after function is run.
 *
 * ---
 *
 * JS: Turn-Related
 * 
 *   JS: Pre-Start Turn:
 *   - Target function: BattleManager.startTurn()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Start Turn:
 *   - Target function: BattleManager.startTurn()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-End Turn:
 *   - Target function: Game_Battler.prototype.onTurnEnd()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-End Turn:
 *   - Target function: Game_Battler.prototype.onTurnEnd()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-Regenerate:
 *   - Target function: Game_Battler.prototype.regenerateAll()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Regenerate:
 *   - Target function: Game_Battler.prototype.regenerateAll()
 *   - JavaScript code occurs after function is run.
 *
 * ---
 *
 * JS: Action-Related
 * 
 *   JS: Pre-Start Action:
 *   - Target function: BattleManager.startAction()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Start Action:
 *   - Target function: BattleManager.startAction()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-Apply:
 *   - Target function: Game_Action.prototype.apply()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Pre-Damage:
 *   - Target function: Game_Action.prototype.executeDamage()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Damage:
 *   - Target function: Game_Action.prototype.executeDamage()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Post-Apply:
 *   - Target function: Game_Action.prototype.apply()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-End Action:
 *   - Target function: BattleManager.endAction()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-End Action:
 *   - DescriTarget function: BattleManager.endAction()
 *   - JavaScript code occurs after function is run.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Battle Layout Settings
 * ============================================================================
 *
 * The Battle Layout Settings Plugin Parameter gives you control over the look,
 * style, and appearance of certain UI elements. These range from the way the
 * Battle Status Window presents its information to the way certain windows
 * like the Party Command Window and Actor Command Window appear.
 *
 * ---
 *
 * Battle Layout Style
 * - The style used for the battle layout.
 * 
 *   Default:
 *   - Shows actor faces in Battle Status.
 * 
 *   List:
 *   - Lists actors in Battle Status.
 * 
 *   XP:
 *   - Shows actor battlers in a stretched Battle Status.
 * 
 *   Portrait:
 *   - Shows portraits in a stretched Battle Status.
 * 
 *   Border:
 *   - Displays windows around the screen border.
 *
 * ---
 *
 * List Style
 * 
 *   Show Faces:
 *   - Shows faces in List Style?
 * 
 *   Command Window Width:
 *   - Determine the window width for the Party and Actor Command Windows.
 *   - Affects Default and List Battle Layout styles.
 *
 * ---
 *
 * XP Style
 * 
 *   Command Lines:
 *   - Number of action lines in the Actor Command Window for the XP Style.
 * 
 *   Sprite Height:
 *   - Default sprite height used when if the sprite's height has not been
 *     determined yet.
 * 
 *   Sprite Base Location:
 *   - Determine where the sprite is located on the Battle Status Window.
 *     - Above Name - Sprite is located above the name.
 *     - Bottom - Sprite is located at the bottom of the window.
 *     - Centered - Sprite is centered in the window.
 *     - Top - Sprite is located at the top of the window.
 *
 * ---
 *
 * Portrait Style
 * 
 *   Show Portraits?:
 *   - Requires VisuMZ_1_MainMenuCore.
 *   - Shows the actor's portrait instead of a face.
 * 
 *   Portrait Scaling:
 *   - If portraits are used, scale them by this much.
 *
 * ---
 *
 * Border Style
 * 
 *   Columns:
 *   - The total number of columns for Skill & Item Windows in the battle scene
 * 
 *   Show Portraits?:
 *   - Requires VisuMZ_1_MainMenuCore.
 *   - Shows the actor's portrait at the edge of the screen.
 * 
 *   Portrait Scaling:
 *   - If portraits are used, scale them by this much.
 *
 * ---
 *
 * Skill & Item Windows
 * 
 *   Middle Layout:
 *   - Shows the Skill & Item Windows in mid-screen?
 * 
 *   Columns:
 *   - The total number of columns for Skill & Item Windows in the battle scene
 *
 * ---
 * 
 * Status Window Elements
 * 
 *   Battler Name:
 *   Gauge 1 (HP):
 *   Gauge 2 (MP):
 *   Gauge 3 (TP):
 *   State Icon:
 *   TPB/ATB Gauge:
 * 
 *     Offset: X/Y:
 *     - Offset this Battle Status Window element's X/Y.
 *     - For X: Negative goes left. Positive goes right.
 *     - For Y: Negative goes up. Positive goes down.
 * 
 *   Window Skin:
 * 
 *     Filename:
 *     - Filename used for the Battle Status Window skin.
 *     - Leave this empty to use the default window skin.
 * 
 *     Hide Window Skin?:
 *     - Hide the window skin for the Battle Status Window?
 * 
 *   Selectable Background:
 * 
 *     Hide Selectable BG?:
 *     - Show/Hide the selectable background box for the Battle Status Window?
 * 
 *   Attachments:
 * 
 *     Back Attachment:
 * 
 *       Filename:
 *       - Filename used for an image to attach to the back of the Battle
 *         Status Window. Leave empty for none.
 * 
 *       Offset: X/Y:
 *       - Offset this Battle Status Window element's X/Y.
 *       - For X: Negative goes left. Positive goes right.
 *       - For Y: Negative goes up. Positive goes down.
 * 
 *     Front Attachment:
 * 
 *       Filename:
 *       - Filename used for an image to attach to the front of the Battle
 *         Status Window. Leave empty for none.
 * 
 * ---
 * 
 * UI Elements
 * 
 *   Anti-Tint UI?
 *   - Prevent UI Elements from being tinted?
 *   - This prevents UI Elements such as HP Gauges, Enemy Names, Battle Cursor,
 *     and Weakness Display from being affected by screen tint.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Battle Log Settings
 * ============================================================================
 *
 * These Plugin Parameters give you control over how the Battle Log Window, the
 * window shown at the top of the screen in the battle layout, appears, its
 * various properties, and which text will be displayed.
 *
 * The majority of the text has been disabled by default with this plugin to
 * make the flow of battle progress faster.
 *
 * ---
 *
 * General
 * 
 *   Back Color:
 *   - Use #rrggbb for a hex color.
 * 
 *   Max Lines:
 *   - Maximum number of lines to be displayed.
 * 
 *   Message Wait:
 *   - Number of frames for a usual message wait.
 * 
 *   Text Align:
 *   - Text alignment for the Window_BattleLog.
 * 
 *   JS: X, Y, W, H:
 *   - Code used to determine the dimensions for the battle log.
 *
 * ---
 *
 * Start Turn
 * 
 *   Show Start Turn?:
 *   - Display turn changes at the start of the turn?
 * 
 *   Start Turn Message:
 *   - Message displayed at turn start.
 *   - %1 - Turn Count
 * 
 *   Start Turn Wait:
 *   - Number of frames to wait after a turn started.
 *
 * ---
 *
 * Display Action
 * 
 *   Show Centered Action?:
 *   - Display a centered text of the action name?
 * 
 *   Show Skill Message 1?:
 *   - Display the 1st skill message?
 * 
 *   Show Skill Message 2?:
 *   - Display the 2nd skill message?
 * 
 *   Show Item Message?:
 *   - Display the item use message?
 *
 * ---
 *
 * Action Changes
 * 
 *   Show Counter?:
 *   - Display counter text?
 * 
 *   Show Reflect?:
 *   - Display magic reflection text?
 * 
 *   Show Substitute?:
 *   - Display substitute text?
 *
 * ---
 *
 * Action Results
 * 
 *   Show No Effect?:
 *   - Display no effect text?
 * 
 *   Show Critical?:
 *   - Display critical text?
 * 
 *   Show Miss/Evasion?:
 *   - Display miss/evasion text?
 * 
 *   Show HP Damage?:
 *   - Display HP Damage text?
 * 
 *   Show MP Damage?:
 *   - Display MP Damage text?
 * 
 *   Show TP Damage?:
 *   - Display TP Damage text?
 *
 * ---
 *
 * Display States
 * 
 *   Show Added States?:
 *   - Display added states text?
 * 
 *   Show Removed States?:
 *   - Display removed states text?
 * 
 *   Show Current States?:
 *   - Display the currently affected state text?
 * 
 *   Show Added Buffs?:
 *   - Display added buffs text?
 * 
 *   Show Added Debuffs?:
 *   - Display added debuffs text?
 * 
 *   Show Removed Buffs?:
 *   - Display removed de/buffs text?
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Battleback Scaling Settings
 * ============================================================================
 *
 * By default, the battlebacks in RPG Maker MZ scale as if the screen size is
 * a static 816x624 resolution, which isn't always the case. These settings
 * here allow you to dictate how you want the battlebacks to scale for the
 * whole game. These settings CANNOT be changed midgame or per battle.
 *
 * ---
 *
 * Settings
 * 
 *   Default Style:
 *   - The default scaling style used for battlebacks.
 *   - MZ (MZ's default style)
 *   - 1:1 (No Scaling)
 *   - Scale To Fit (Scale to screen size)
 *   - Scale Down (Scale Downward if Larger than Screen)
 *   - Scale Up (Scale Upward if Smaller than Screen)
 * 
 *   JS: 1:1:
 *   JS: Scale To Fit:
 *   JS: Scale Down:
 *   JS: Scale Up:
 *   - This code gives you control over the scaling for this style.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Party Command Window
 * ============================================================================
 *
 * These Plugin Parameters allow you control over how the Party Command Window
 * operates in the battle scene. You can turn disable it from appearing or make
 * it so that it doesn't 
 *
 * ---
 *
 * Command Window
 * 
 *   Style:
 *   - How do you wish to draw commands in the Party Command Window?
 *   - Text Only: Display only the text.
 *   - Icon Only: Display only the icon.
 *   - Icon + Text: Display the icon first, then the text.
 *   - Auto: Determine which is better to use based on the size of the cell.
 * 
 *   Text Align:
 *   - Text alignment for the Party Command Window.
 * 
 *   Fight Icon:
 *   - The icon used for the Fight command.
 * 
 *   Add Auto Battle?:
 *   - Add the "Auto Battle" command to the Command Window?
 * 
 *     Auto Battle Icon:
 *     - The icon used for the Auto Battle command.
 * 
 *     Auto Battle Text:
 *     - The text used for the Auto Battle command.
 * 
 *   Add Options?:
 *   - Add the "Options" command to the Command Window?
 * 
 *     Options Icon:
 *     - The icon used for the Options command.
 * 
 *     Active TPB Message:
 *     - Message that will be displayed when selecting options during the
 *       middle of an action.
 * 
 *   Escape Icon:
 *   - The icon used for the Escape command.
 *
 * ---
 *
 * Access
 * 
 *   Skip Party Command:
 *   - DTB: Skip Party Command selection on turn start.
 *   - TPB: Skip Party Command selection at battle start.
 * 
 *   Disable Party Command:
 *   - Disable the Party Command Window entirely?
 *
 * ---
 *
 * Help Window
 * 
 *   Fight:
 *   - Text displayed when selecting a skill type.
 *   - %1 - Skill Type Name
 * 
 *   Auto Battle:
 *   - Text displayed when selecting the Auto Battle command.
 * 
 *   Options:
 *   - Text displayed when selecting the Options command.
 * 
 *   Escape:
 *   - Text displayed when selecting the escape command.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Actor Command Window
 * ============================================================================
 *
 * These Plugin Parameters allow you to change various aspects regarding the
 * Actor Command Window and how it operates in the battle scene. This ranges
 * from how it appears to the default battle commands given to all players
 * without a custom <Battle Commands> notetag.
 *
 * ---
 *
 * Command Window
 * 
 *   Style:
 *   - How do you wish to draw commands in the Actor Command Window?
 *   - Text Only: Display only the text.
 *   - Icon Only: Display only the icon.
 *   - Icon + Text: Display the icon first, then the text.
 *   - Auto: Determine which is better to use based on the size of the cell.
 * 
 *   Text Align:
 *   - Text alignment for the Actor Command Window.
 * 
 *   Item Icon:
 *   - The icon used for the Item command.
 * 
 *   Normal SType Icon:
 *   - Icon used for normal skill types that aren't assigned any icons.
 *   - Ignore if VisuMZ_1_SkillsStatesCore is installed.
 * 
 *   Magic SType Icon:
 *   - Icon used for magic skill types that aren't assigned any icons.
 *   - Ignore if VisuMZ_1_SkillsStatesCore is installed.
 *
 * ---
 *
 * Battle Commands
 * 
 *   Command List:
 *   - List of battle commands that appear by default if the <Battle Commands>
 *     notetag isn't present.
 *
 *     - Attack 
 *       - Adds the basic attack command.
 * 
 *     - Skills
 *       - Displays all the skill types available to the actor.
 * 
 *     - SType: x
 *     - Stype: name
 *       - Adds in a specific skill type.
 *       - Replace 'x' with the ID of the skill type.
 *       - Replace 'name' with the name of the skill type (without text codes).
 *
 *     - All Skills
 *       - Adds all usable battle skills as individual actions.
 * 
 *     - Skill: x
 *     - Skill: name
 *       - Adds in a specific skill as a usable action.
 *       - Replace 'x' with the ID of the skill.
 *       - Replace 'name' with the name of the skill.
 * 
 *     - Guard
 *       - Adds the basic guard command.
 * 
 *     - Item
 *       - Adds the basic item command.
 * 
 *     - Escape
 *       - Adds the escape command.
 * 
 *     - Auto Battle
 *       - Adds the auto battle command.
 * 
 *     - Party
 *       - Requires VisuMZ_2_PartySystem!
 *       - Switches out the current actor for another.
 * 
 *     - Combat Log
 *       - Requires VisuMZ_4_CombatLog!
 *       - Shows combat log.
 * 
 *     - Talk
 *       - Requires VisuMZ_3_BattleCmdTalk!
 *       - Shows talk command if applicable.
 * 
 *     - Weapon Swap
 *       - Requires VisuMZ_2_WeaponSwapSystem!
 *       - Swaps current weapon for next one.
 * 
 *   Show Command Costs:
 *   - If a battle command has a resource cost, show it?
 *
 * ---
 *
 * Help Window
 * 
 *   Skill Types:
 *   - Text displayed when selecting a skill type.
 *   - %1 - Skill Type Name
 * 
 *   Items:
 *   - Text displayed when selecting the item command.
 * 
 *   Escape:
 *   - Text displayed when selecting the escape command.
 * 
 *   Auto Battle:
 *   - Text displayed when selecting the Auto Battle command.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Multi-Target Windows Settings
 * ============================================================================
 *
 * Action Sequence Plugin Parameters adjust how the Multi-Target Windows appear
 * in battle. These windows are visible when selecting an enemy or actor while
 * using a skill/item that has the <Single or Multiple Select> notetag.
 * 
 * Those wondering why this isn't regulated to a command left or right of the
 * enemies and actors is because mouse controls and touch controls would not be
 * able to select all enemies or all allies that way.
 *
 * ---
 * 
 * Properties
 * 
 *   Window Width:
 *   - What is the width used for the Multi-Target Window?
 * 
 *   Background Type:
 *   - Select background type for these windows.
 * 
 *   Show Button:
 *   - Shows the keyboard/controller button to press?
 *   - Requires VisuMZ_0_CoreEngine!
 * 
 * ---
 * 
 * Vocab
 * 
 *   All Actors:
 *   - What is the text used for the "All Actors" button?
 * 
 *   All Enemies:
 *   - What is the text used for the "All Enemies" button?
 * 
 * ---
 * 
 * Offsets > Actor Offsets
 * Offsets > Enemy Offsets
 * 
 *   Offset X:
 *   - Offsets the button's x position.
 *   - Negative: left. Positive: right.
 * 
 *   Offset Y:
 *   - Offsets the button's y position.
 *   - Negative: up. Positive: down.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Actor Battler Settings
 * ============================================================================
 *
 * These Plugin Parameter settings adjust how the sideview battlers behave for
 * the actor sprites. Some of these settings are shared with enemies if they
 * use sideview battler graphics.
 *
 * ---
 *
 * Flinch
 * 
 *   Flinch Distance X:
 *   - The normal X distance when flinching.
 * 
 *   Flinch Distance Y:
 *   - The normal Y distance when flinching.
 * 
 *   Flinch Duration:
 *   - The number of frames for a flinch to complete.
 * 
 *   Shake Flinch:
 *   - Perform a shake flinch when taking damage?
 * 
 *     Max Duration:
 *     - Maximum duration a shake flinch can have.
 *     - This is reduced relative to the amount of damage taken.
 * 
 *     Max Power:
 *     - The power rating of a shake flinch at full damage.
 *     - This is reduced relative to the amount of damage taken.
 *
 * ---
 *
 * Sideview Battlers
 * 
 *   Anchor: X:
 *   - Default X anchor for Sideview Battlers.
 * 
 *   Anchor: Y:
 *   - Default Y anchor for Sideview Battlers.
 * 
 *   Chant Style:
 *   - What determines the chant motion?
 *   - Hit type or skill type?
 * 
 *   Offset X:
 *   - Offsets X position where actor is positioned.
 *   - Negative values go left. Positive values go right.
 * 
 *   Offset Y:
 *   - Offsets Y position where actor is positioned.
 *   - Negative values go up. Positive values go down.
 * 
 *   Motion Speed:
 *   - The number of frames in between each motion.
 * 
 *   Priority: Active:
 *   - Place the active actor on top of actor and enemy sprites.
 * 
 *   Priority: Actors:
 *   - Prioritize actors over enemies when placing sprites on top of each other
 * 
 *   Shadow Visible:
 *   - Show or hide the shadow for Sideview Battlers.
 * 
 *   Smooth Image:
 *   - Smooth out the battler images or pixelate them?
 * 
 *   JS: Home Position:
 *   - Code used to calculate the home position of actors.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Enemy Battler Settings
 * ============================================================================
 *
 * These Plugin Parameter settings adjust how enemies appear visually in the
 * battle scene. Some of these settings will override the settings used for
 * actors if used as sideview battlers. Other settings include changing up the
 * default attack animation for enemies, how the enemy select window functions,
 * and more.
 *
 * ---
 *
 * Visual
 * 
 *   Attack Animation:
 *   - Default attack animation used for enemies.
 *   - Use <Attack Animation: x> for custom animations.
 * 
 *   Emerge Text:
 *   - Show or hide the 'Enemy emerges!' text at the start of battle.
 * 
 *   Offset X:
 *   - Offsets X position where enemy is positioned.
 *   - Negative values go left. Positive values go right.
 * 
 *   Offset Y:
 *   - Offsets Y position where enemy is positioned.
 *   - Negative values go up. Positive values go down.
 * 
 *   Smooth Image:
 *   - Smooth out the battler images or pixelate them?
 *
 * ---
 *
 * Select Window
 * 
 *   Any: Last Selected:
 *   - Prioritize last selected enemy over front view or sideview settings?
 * 
 *   FV: Right Priority:
 *   - If using frontview, auto select the enemy furthest right.
 * 
 *   SV: Right Priority:
 *   - If using sideview, auto select the enemy furthest right.
 * 
 * ---
 * 
 * Name:
 * 
 *   Legacy Option:
 *   - Use the legacy version (window) or new version (sprite).
 *   - WARNING: Legacy version is no longer supported for bugs.
 *   - Not all settings available here in the Plugin Parameters will be
 *     available to the legacy version (ie Always Visible and Attach States).
 * 
 *   Font Size:
 *   - Font size used for enemy names.
 * 
 *   Name Position:
 * 
 *     Offset X:
 *     Offset Y:
 *     - Offset the enemy name's position by this much.
 *     - For X: Negative goes left. Positive goes right.
 *     - For Y: Negative goes up. Positive goes down.
 * 
 *   Name: Attach States:
 *   - Attach the enemy's state icon to the enemy name?
 * 
 *     Attach: Offset X:
 *     Attach: Offset Y:
 *     - How much to offset the attached icon's X/Y position by?
 *     - For X: Negative goes left. Positive goes right.
 *     - For Y: Negative goes up. Positive goes down.
 * 
 *   Name Visibility:
 * 
 *     Always Hidden:
 *     - Determines if the enemy name will always be visible.
 *     - Highest priority.
 * 
 *     Always Visible:
 *     - Determines if the enemy name will always be visible.
 *     - Medium priority.
 * 
 *     By Selection?:
 *     - Determines the conditions for enemy name visibility.
 *     - Lowest priority.
 *
 * ---
 *
 * Sideview Battlers
 * 
 *   Allow Collapse:
 *   - Causes defeated enemies with SV Battler graphics to "fade away"
 *     when defeated?
 * 
 *   Anchor: X:
 *   - Default X anchor for Sideview Battlers.
 *   - Use values between 0 and 1 to be safe.
 * 
 *   Anchor: Y:
 *   - Default Y anchor for Sideview Battlers.
 *   - Use values between 0 and 1 to be safe.
 * 
 *   Motion: Idle:
 *   - Sets default idle animation used by Sideview Battlers.
 * 
 *   Shadow Visible:
 *   - Show or hide the shadow for Sideview Battlers.
 * 
 *   Size: Width:
 *   - Default width for enemies that use Sideview Battlers.
 * 
 *   Size: Height:
 *   - Default height for enemies that use Sideview Battlers.
 * 
 *   Weapon Type:
 *   - Sets default weapon type used by Sideview Battlers.
 *   - Use 0 for Bare Hands.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: HP Gauge Settings
 * ============================================================================
 *
 * Settings that adjust the visual HP Gauge displayed in battle.
 *
 * ---
 *
 * Show Gauges For
 * 
 *   Actors:
 *   - Show HP Gauges over the actor sprites' heads?
 *   - Requires SV Actors to be visible.
 * 
 *   Enemies:
 *   - Show HP Gauges over the enemy sprites' heads?
 *   - Can be bypassed with <Hide HP Gauge> notetag.
 * 
 *     Requires Defeat?:
 *     - Requires defeating the enemy once to show HP Gauge?
 *     - Can be bypassed with <Show HP Gauge> notetag.
 * 
 *       Battle Test Bypass?:
 *       - Bypass the defeat requirement in battle test?
 *
 * ---
 *
 * Settings
 * 
 *   Animation Duration:
 *   - How many frames should gauges animate themselves?
 *   - Default: 20 frames.
 * 
 *   Anchor X:
 *   Anchor Y:
 *   - Where do you want the HP Gauge sprite's anchor X/Y to be?
 *     Use values between 0 and 1 to be safe.
 * 
 *   Scale:
 *   - How large/small do you want the HP Gauge to be scaled?
 * 
 *   Offset X:
 *   Offset Y:
 *   - How many pixels to offset the HP Gauge's X/Y by?
 *
 * ---
 *
 * Options
 * 
 *   Add Option?:
 *   - Add the 'Show HP Gauge' option to the Options menu?
 * 
 *   Adjust Window Height:
 *   - Automatically adjust the options window height?
 * 
 *   Option Name:
 *   - Command name of the option.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Action Sequence Settings
 * ============================================================================
 *
 * Action Sequence Plugin Parameters allow you to decide if you want automatic
 * Action Sequences to be used for physical attacks, the default casting
 * animations used, how counters and reflects appear visually, and what the
 * default stepping distances are.
 *
 * ---
 *
 * Automatic Sequences
 * 
 *   Melee Single Target:
 *   - Allow this auto sequence for physical, single target actions?
 * 
 *   Melee Multi Target:
 *   - Allow this auto sequence for physical, multi-target actions?
 *
 * ---
 * 
 * Quality of Life
 * 
 *   Auto Notetag:
 *   - Automatically apply the <Custom Action Sequence> notetag effect to any
 *     item or skill that has a Common Event?
 *   - Any item or skill without a Common Event attached to it will use the
 *     Automatic Action Sequences instead.
 *   - The <Auto Action Sequence> notetag will disable this effect for that
 *     particular skill or item.
 * 
 * ---
 *
 * Cast Animations
 * 
 *   Certain Hit:
 *   - Cast animation for Certain Hit skills.
 * 
 *   Physical:
 *   - Cast animation for Physical skills.
 * 
 *   Magical:
 *   - Cast animation for Magical skills.
 *
 * ---
 *
 * Counter/Reflect
 * 
 *   Counter Back:
 *   - Play back the attack animation used?
 * 
 *   Reflect Animation:
 *   - Animation played when an action is reflected.
 * 
 *   Reflect Back:
 *   - Play back the attack animation used?
 *
 * ---
 *
 * Stepping
 * 
 *   Melee Distance:
 *   - Minimum distance in pixels for Movement Action Sequences.
 * 
 *   Step Distance X:
 *   - The normal X distance when stepping forward.
 * 
 *   Step Distance Y:
 *   - The normal Y distance when stepping forward.
 * 
 *   Step Duration:
 *   - The number of frames for a stepping action to complete.
 *
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 * 
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 * 
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 * 
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 * 
 * If you are using this plugin, credit the following people in your game:
 * 
 * Team VisuStella
 * * Yanfly
 * * Arisu
 * * Olivia
 * * Irina
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 * 
 * Version 1.75: March 16, 2023
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New notetags added by Olivia and sponsored by Anon:
 * *** <HP Life Steal: x%>
 * *** <MP Life Steal: x%>
 * *** <HP Life Steal hitType: +/-x%>
 * *** <MP Life Steal hitType: +/-x%>
 * *** <Cancel Life Steal>
 * *** <Guard Life Steal>
 * *** <Disarm Life Steal>
 * *** <Negative Life Steal>
 * **** Life Steal properties involving HP/MP are now added. They will restore
 *      a portion of the dealt HP/MP damage to the target.
 * **** This is a different mechanic from Drain HP/Drain MP and cannot be used
 *      together to prevent clashing.
 * **** Read the help file for more information.
 * 
 * Version 1.74: February 16, 2023
 * * Bug Fixes!
 * ** Fixed a bug that would cause a crash if your basic attack skill somehow
 *    manages to target neither an enemy nor an actor. Fix made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Auto-action sequence for jumping forward and attacking is now reinstated
 *    so that it's only disabled when the target and user are on the same side.
 *    If there is no target, a jump still occurs for visual player feedback.
 *    Update made by Olivia.
 * * New Features!
 * ** New notetag effect added by Olivia and sponsored by AndyL:
 * *** <Cannot Target User>
 * **** This will cause the action to be unable to select the user as target.
 * **** This is not a targeting scope. Instead, it is used in addition to any
 *      other targeting scopes out there.
 * 
 * Version 1.73: January 20, 2023
 * * Bug Fixes!
 * ** Active TPB custom action sequences will no longer play differently due to
 *    queued inputting actors causing motion refreshes. Fix made by Arisu.
 * ** Corrected and updated Anti-Tint UI animation offsets for MV animations.
 *    Fix made by Irina.
 * ** Fixed a problem with Sideview Battlers not working properly. Fix made
 *    by Irina.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Help file updated for to add the following text to the <Target: x>
 *    notetag entries in order to avoid confusion.
 * *** This will overwrite the existing database scope and ignore the
 *     database's existing scope in favor of this.
 * * Feature Update!
 * ** <Extend: x> Troop Name Tag is now also usable as a Troop Comment Tag.
 * ** Action Sequence targeting has been updated with two new types "special"
 *    and "special x", to be used for future plugins.
 * * New Features!
 * ** New Notetags added by Irina and sponsored by AndyL:
 * *** <Target: Ally or Enemy>
 * *** <Target: Enemy or Ally>
 * **** Allows the player to target allies or enemies with the skill/item.
 * **** See help file for more information.
 * *** <Single or Multiple Select>
 * **** This will allow the skill/item to be able to select either single
 *      targets or multiple targets at once.
 * **** See help file for more information.
 * *** <Disperse Damage>
 * **** This will cause any damage dealt by this skill to be split equally
 *      amongst all targets of the skill including repeats.
 * ** New Plugin Parameters added by Irina and sponsored by AndyL:
 * *** Plugin Parameters > Multi-Target Windows
 * **** Settings that alter the Multi-Target Windows in battle.
 * 
 * Version 1.72: December 15, 2022
 * * Bug Fixes!
 * ** Fixed a transformation of a sideview enemy to a static enemy and back not
 *    working properly. Fix made by Irina.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Feature!
 * ** New Plugin Parameter added by Irina!
 * *** Plugin Parameters > HP Gauges > Settings > Animation Duration
 * **** How many frames should gauges animate themselves? Default: 20 frames.
 * ** New Plugin Parameters added by Yanfly!
 * *** Plugin Parameters > Actor Battler Settings > Shake Flinch
 * *** Plugin Parameters > Actor Battler Settings > Shake Flinch > Max Power
 * *** Plugin Parameters > Actor Battler Settings > Shake Flinch > Max Duration
 * **** These new plugin parameters will cause targets that take HP damage to
 *      shake (in addition to a regular flinch) to provide better visual
 *      feedback to the player.
 * **** Shake Flinch will be kept disabled by default and only turned on when
 *      you want it to be.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.71: November 10, 2022
 * ** Fixed a problem with repeating animations from Visual State Effects
 *    causing softlocks. Fix made by Olivia.
 * 
 * Version 1.70: October 6, 2022
 * * Bug Fixes!
 * ** Fixed a problem with the "Border" style where if a battle portrait
 *    changed midway through the battle, the portrait shown didn't actually
 *    update properly. Fix made by Irina.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence added by Olivia:
 * *** MECH: Active Chain Input Disable
 * **** Disables input for Active Chain Skills at this time.
 * **** Requires VisuMZ_3_ActiveChainSkills!
 * ** New Plugin Parameter added by Olivia and sponsored by Anon:
 * *** Plugin Parameters > Damage Settings > Popups > End Battle Show?
 * **** Show or hide popups upon victory or escape?
 * **** Used to hide battle-state removal popups.
 * 
 * Version 1.69: September 7, 2022
 * * Compatibility Update!
 * ** Better compatibility with VisuMZ Active Chain Skills.
 * ** Compatibility will be seen with VisuMZ_3_ActiveChainSkills version 1.02.
 * * Documentation Update!
 * ** Added notes to the following Action Sequences:
 * *** MOTION: Clear Freeze Frame and MOTION: Freeze Motion Frame
 * **** Only applies to sprite sheets.
 * **** Does NOT work with Dragonbones.
 * **** Use "DB: Dragonbones Time Scale" instead.
 * * Feature Update!
 * ** Reduced MV Animation misalignment when Screen Resolution does not match
 *    the UI Area Resolution. Update by Arisu.
 * ** Command Remember will now remember the locations of single skills. Update
 *    made by Olivia.
 * 
 * Version 1.68: August 4, 2022
 * * Feature Update!
 * ** Damage popups are now automatically cleared upon starting battles. This
 *    is to ensure that, if for some reason, residual damage popup requests
 *    will not be retained. Update made by Olivia.
 * 
 * Version 1.67: July 28, 2022
 * * Feature Updates!
 * ** Rounding window coordinates have been added for for 'XP' and 'Portrait'
 *    styles when window sizes happen to land on non-divisible numbers. Update
 *    made by Irina.
 * ** Enemy name position rounding is now enforced. Update made by Irina.
 * 
 * Version 1.66: July 14, 2022
 * * Bug Fixes!
 * ** Fixed a bug that caused the various Battleback Scaling JS custom plugin
 *    parameters to not work properly. Fix made by Irina.
 * 
 * Version 1.65: July 7, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Updates!
 * ** Automatic action motions for HP and MP Recovery (Certain Hit type) will
 *    now use the "skill" cast SV animation instead of attack animation to
 *    better match the default RPG Maker MZ cast animation. Update by Olivia.
 * * New Features!
 * ** New troop name tag added by Olivia:
 * *** <Extend: x> and <Extend: x, x, x>
 * **** Adds enemies from another troop to the current troop.
 * **** Enemies from another troop will retain their database positions.
 * **** Extended troop members will be added in the order they're listed.
 * **** Be cautious of how many enemies you add as too many will lag the battle
 *      system. We are not responsible for frame drops due to this.
 * 
 * Version 1.64: June 16, 2022
 * * Bug Fixes!
 * ** "All Skills" battle command should now work with the updated version of
 *    VisuMZ Skills & States Core. Fix madde by Olivia.
 * * Compatibility Update
 * ** Plugins should be more compatible with one another.
 * 
 * Version 1.63: May 26, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** HP Gauge sprite now properly synchs with battler location.
 * * New Features!
 * ** New Action Sequence Effects added by Irina and sponsored by MirageV:
 * *** INJECT action sequence series
 * **** See the Action Sequence Impact changelog for details.
 * 
 * Version 1.62: April 22, 2022
 * * Bug Fixes!
 * ** RPG Maker MZ Bug Fix!
 * *** Battle Forced End Action Crash
 * **** Depending on various circumstances, currently active battlers can be
 *      cleared from the battle system at will due to a number of reasons.
 *      However, if it just so happens that the targets are cleared, too, with
 *      actions remaining, then a crash will follow up. This plugin will
 *      prevent that change. Fix made by Olivia.
 * 
 * Version 1.61: April 14, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Impact Effects added by Irina and collaborating with Manu Gaming!
 * *** Impact: Bizarro Inversion
 * *** Impact: Desaturation
 * *** Impact: Negative Inversion
 * *** Impact: Oversaturation
 * *** Impact: Time Scale
 * *** Impact: Time Stop
 * 
 * Version 1.60: April 7, 2022
 * * Bug Fixes!
 * ** <Bypass Soft Damage Cap> notetag should no longer cause crashes. Fix made
 *    by Olivia.
 * * Feature Update!
 * ** Removed one of the forced log window clear events that have made log
 *    window messages impossible to utilize for certain settings. Update made
 *    by Olivia.
 * 
 * Version 1.59: March 31, 2022
 * * Bug Fixes!
 * ** Escape failure will no longer trigger Post-Battle Common Events. Fix
 *    made by Arisu.
 * 
 * Version 1.58: March 24, 2022
 * * Documentation Update:
 * ** Added extra clarity to <Sideview Size: width, height> notetag:
 * *** This does NOT change the image size. This only changes the HITBOX size.
 * * Feature Update!
 * ** Added failsafes to prevent battlers from moving to non-finite coordinates
 *    if calculations are made for non-existent targets. Updated by Olivia.
 * ** Regeneration timing for TPB-based battle systems will now occur based on
 *    individual turn counts instead of global turn counts for initial turn 0
 *    checks. Updated by Olivia.
 * 
 * Version 1.57: February 17, 2022
 * * Feature Update!
 * ** Adjusted the offset properties for the anti-tint UI container to properly
 *    match the UI offsets if the anti-tint were to be off. Update by Irina.
 * 
 * Version 1.56: February 10, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Once Parallels for battle now operate outside of the battle process.
 *    Update made by Olivia.
 * * New Features!
 * ** New Troop Page comment tag added by Olivia and sponsored by Puddor:
 * *** <Once Parallel When Start Battle>
 * **** Causes the troop page to immediately run the moment the battle scene
 *      begins to fade in (not after it fades in). This is faster than a turn 0
 *      condition troop page. Troop page conditions are ignored.
 * **** This can be used for things like the Action Sequence Camera plugin, the
 *      Visual Battle Environment plugin, and/or initial battle poses and such
 *      in order to provide a near seamless battle transition experience.
 * **** This does NOT trigger when coming out of the options menu or party
 *      menu screens.
 * **** This WILL trigger when going from battle to battle nonstop via plugins
 *      like VisuStella MZ's Chain Battles.
 * **** When actors are moving towards their home positions, it will take
 *      around 30 frames by default. Use this information however you like.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.55: January 27 2022
 * * Compatibility Update!
 * ** RPG Maker MV animations with front view should now play in the correct
 *    area against actor faces. Update made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Animations now play on top of all actor faces/portraits regardless of the
 *    battle layout style. Update made by Olivia.
 * * New Features!
 * ** New notetag added by Arisu.
 * *** <Bypass Auto Action Sequence>
 * **** This notetag is used for the game devs that have the Action Sequence
 *      Plugin Parameter "Auto Notetag" on for applying the notetag
 *      <Custom Action Sequence> to every skill and item with common events.
 * **** This will allow items and skills to be able to launch their common
 *      events from the menu scene regardless of the inherent restriction to
 *      prevent action sequence based skills/items with common events from
 *      launching.
 * **** Ignore this if you have "Auto Notetag" disabled or set to false. By
 *      default, this setting is set to false. Please be aware of the changes
 *      you've made to your game before using it.
 * 
 * Version 1.54: January 13, 2022
 * * Bug Fixes!
 * ** RPG Maker MZ Bug Fix!
 * *** Overly-Protective Substitute
 * *** When an ally with critical health is being targeted by a friendly non-
 *     Certain Hit skill (such as a heal or buff) and another ally has the
 *     substitute state, the other ally would "protect" the originally targeted
 *     ally and take the heal or buff.
 * *** The new changed behavior is that now, substitute will not trigger for
 *     any actions whose scope targets allies.
 * *** Fix made by Olivia.
 * 
 * Version 1.53: December 30, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Help file updated for updated features.
 * * New Features!
 * ** New Plugin Parameter added by Olivia:
 * *** Plugin Parameters > Battle Layout > UI Elements > Anti-Tint UI?
 * **** Prevent UI Elements from being tinted?
 * **** This prevents UI Elements such as HP Gauges, Enemy Names, Battle
 *      Cursor, and Weakness Display from being affected by screen tint.
 * * Updated Feature!
 * ** Updated Plugin Command "PROJECTILE: Animation" by Arisu!
 * *** New Parameter: Wait For Animation?
 * **** Wait for animation to finish before going to the next command?
 * 
 * Version 1.52: December 16, 2021
 * * Compatibility Update!
 * ** RPG Maker MZ 1.4.0 compatibility update!
 * *** MV Animations played on screen level will now show up properly in the
 *     center of the screen.
 * 
 * Version 1.51: December 9, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence Plugin Commands added by Arisu:
 * *** MOVE: Change Home By Distance
 * *** MOVE: Change Home To Point
 * *** MOVE: Change Home To Target(s)
 * **** These Plugin Commands allow you to adjust the home position of
 *      battlers in sideview battle.
 * **** This is sideview only!
 * **** This does NOT work with front view!
 * **** For those wondering, going to the options screen, party screen, etc.
 *      won't reset the home positions like regular movement changes do.
 * **** Merry Christmas, Harold-gang!
 * 
 * Version 1.50: November 4, 2021
 * * Bug Fixes!
 * ** <Seal Attack> and <Seal Guard> should no longer be bypassed by
 *    auto-battle status. Fix made by Yanfly.
 * 
 * Version 1.49: October 28, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Action Sequence: MOTION: Freeze Motion Frame will now only show weapons
 *    when using a motion that is named either "attack", "thrust", "swing", or
 *    "missile". Update made by Irina.
 * ** Fail safe added to prevent Scene_Battle going into unsupported scenes
 *    like Scene_Equip and Scene_Skill. Update made by Olivia.
 * * New Feature!
 * ** New Action Sequence Plugin Command added by Arisu and sponsored by Anon:
 * *** MECH: Once Parallel
 * **** Plays a Common Event parallel to the battle event once without
 *      repeating itself when done.
 * **** When exiting battle scene, all Once Parallels are cleared.
 * **** Once Parallels are not retained upon reentering the scene.
 * **** Once Parallels are not stored in memory and cannot be saved.
 * 
 * Version 1.48: October 21, 2021
 * * Feature Update!
 * ** Animations are now played on top of battlers in the Front View XP Battle
 *    Layout appearance. Update made by Irina.
 * ** Battle Log, if decided to be shown, now updates faster. Update by Irina.
 * ** Default Critical Damage Bonus increase is now updated to account for
 *    HP Healing and MP Recovery. To update this, create a new project, with
 *    the newest version of Battle Core installed. Copy over the Plugin
 *    Parameters for the Damage Settings > Critical Hits > JS: Damage Formula
 *    to your own project's version. Update made by Irina.
 * 
 * Version 1.47: October 14, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Feature Update!
 * ** Back attachment sprites are now automatically updated with sprite
 *    battlers to be shifted towards the very back.
 * 
 * Version 1.46: September 23, 2021
 * * Bug Fixes!
 * ** Fixed problem with skills and items without action sequences preventing
 *    actions from occurring. Fix made by Yanfly.
 * 
 * Version 1.45: September 17, 2021
 * * Bug Fixes!
 * ** <JS Pre-End Action> and <JS Post-End Action> effects now have multiple
 *    checks to make sure that they don't launch multiple times when a battler
 *    without actions has a turn after one that does. Fix made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence notetags added by Yanfly and Arisu:
 * *** <Common Event Key: name>
 * *** <Common Event Keys: name, name, name>
 * *** <Common Event Keys>
 *      key
 *      key
 *      key
 *     </Common Event Keys>
 * **** Will generate Common Events for the skill/item with a corresponding
 *      key.
 * **** More information will be explained inside of the help file.
 * **** This feature is made for make the process of sharing Action Sequences
 *      to become easier without needing to line up Common Event ID's.
 * 
 * Version 1.44: August 20, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence added by Irina and sponsored by Anon.
 * *** "ANIM: Play at Coordinate"
 * **** Plays an animation on the screen at a specific x, y coordinate even if
 *      there is no sprite attached.
 * **** Requires VisuMZ_0_CoreEngine!
 * 
 * Version 1.43: July 23, 2021
 * * Feature Update!
 * ** Immortality now works different with instant death mechanics. Skill
 *    effects that apply instant death or attack states that apply instant
 *    death will now trigger a flag instead of cancelling immortality. The
 *    flag will remain until immortality is manually cancelled via Action
 *    Sequence and then proc the death effect. This way, animations can remain
 *    to the end with instant death mechanics in mind. This does not affect
 *    script calls.
 * 
 * Version 1.42: July 16, 2021
 * * Bug Fixes!
 * ** Added another fail safe for empty common events used for pre-battle
 *    common events. Fix made by Olivia.
 * 
 * Version 1.41: July 2, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Added entries to <Battle Command> notetags and Plugin Parameters for
 *    "Party", "Combat Log", and "Weapon Swap" which weren't updated before.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * * New Features!
 * ** New Action Sequence added by Arisu:
 * *** MECH: Enemy Escape
 * **** Causes the enemy unit(s) to escape.
 * 
 * Version 1.40: June 25, 2021
 * * Bug Fixes!
 * ** Transformations from static enemies to and from animated SV enemies
 *    should no longer show both sprites. Fix made by Irina.
 * * Compatibility Update
 * ** Compatibility update with RPG Maker MZ 1.3.0+.
 * 
 * Version 1.39: June 18, 2021
 * * Bug Fixes!
 * ** MOVE: Home Reset should no longer trigger an end action function and
 *    cause plugins such as "Boost Action" to malfunction. Fix made by Olivia.
 * * Compatibility Update
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for updated features.
 * * Feature Update!
 * ** <Battle Layout: x> Troop Name tags can now work with comment tags. Update
 *    made by Irina.
 * ** Random encounter lists are now better shuffled for more variety with how
 *    the RNG seed works. Update made by Arisu.
 * 
 * Version 1.38: June 11, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Updates!
 * ** Location calculations will now be based off the a battler's base position
 *    in order for animations, popups, and other aspects to line up properly
 *    when scaled. Update made by Irina.
 * ** Plugin Parameters for Enemy Battler Settings > Name have been rearranged
 *    for better organization. Update by Olivia.
 * * New Features!
 * ** New Notetags added by Olivia and sponsored by NSG:
 * *** <Sideview Shadow Scale X: x%>
 * *** <Sideview Shadow Scale X: x.y>
 * *** <Sideview Shadow Scale Y: x%>
 * *** <Sideview Shadow Scale Y: x.y>
 * **** These new notetags allow you to adjust the X and Y scale of the SV
 *      shadow sprite separately.
 * ** New Plugin Parameters added by Olivia and sponsored by NSG:
 * *** Enemy Battler Settings > Name > Name Visibility > Always Hidden
 * *** Enemy Battler Settings > Name > Name Visibility > By Selection?
 * **** Choose to have the names always hidden or by selection.
 * **** These are adjusted on a priority list.
 * 
 * Version 1.37: May 21, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New notetags added by Olivia.
 * *** <Command Require Learn>
 * *** <Command Require Access>
 * **** These two commands determine the visibility of a battle command by
 *      whether or not the skill has been learned or accessible.
 * * Feature Update!
 * ** For those using TPB, each battler's regeneration phase will no longer
 *    tick multiple times in a single frame to prevent irregularities. Update
 *    made by Olivia.
 * 
 * Version 1.36: May 14, 2021
 * * Bug Fixes!
 * ** Reversed an HP/MP regeneration bug that was incorrectly reported for TPB.
 *    Fix made by Olivia.
 * * Documentation Update
 * ** Added "TPB/ATB Active Battle Actor Shifting" to Major Changes section:
 * *** This change has been active since the start of this plugin. It was not
 *     documented until now.
 * *** Pressing cancel on the Actor Command Window no longer switches between
 *     actors with a full TPB/ATB gauge before reaching the Party Command
 *     Window. This is to accomplish a couple of things: 1) reduce the number
 *     of button presses to reach the Party Command Window and 2) to prevent
 *     motion resets and disrupting action sequences. If this feature is vital
 *     to your battle system, we recommend that you do not use this plugin or
 *     any of the Battle Core-required plugins.
 * ** Feature Updates
 * *** Distortion sprite Y calculations will now be rounded upward for better
 *     visuals and prevent odd pixelation effects. Update made by Irina.
 * 
 * Version 1.35: May 7, 2021
 * * Bug Fixes!
 * ** Pre-Battle Common Events without a wait command at the end should no
 *    longer lock up by coincidentally pressing the menu key at the same time.
 *    Fix made by Olivia.
 * * Feature Update!
 * ** Added an extra check for TPB-based battle systems to not run turn end
 *    functions when it's not actually the actual turn end timing. Update made
 *    by Olivia.
 * ** "Damage Styles" plugin parameters are now moved to the top of the
 *    Damage Settings category. This should make it easier to acknowledge the
 *    existence of and not have it be an unknown entity. Update made by Irina.
 * 
 * Version 1.34: April 23, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Uses a better algorithm for determining shadow positioning. Update made
 *    by Olivia.
 * * New Features!
 * ** New additions made for Projectile action sequences.
 * ** "Start Location" and "Goal Location" now have "Target Location" parameter
 *    to determine which part of the target's body to send the projectile from
 *    or towards. Added by Olivia.
 * ** Requires VisuMZ_1_BattleCore version 1.34 to have affect.
 * 
 * Version 1.33: April 9, 2021
 * * Bug Fixes!
 * ** Skill costs should now be displayed on battle commands again. Bug fix
 *    made by Olivia.
 * ** Pre-Battle Common Events should no longer cause stalling when used with
 *    specific event commands. Bug fix made by Olivia.
 * * Compatibility Update!
 * ** Added "Weapon Swap" to the list of battle commands that can be added.
 * * Documentation Update!
 * ** Added "Weapon Swap" and "Combat Log" to the list of <Battle Commands> in
 *    the notetags section.
 * ** Help file updated for new features.
 * * New Features!
 * ** New notetags added by Olivia:
 * *** <Sideview Shadow Scale: x%> and <Sideview Shadow Scale: x.y>
 * **** Used for: Actor, Enemy Notetags
 * **** Adjusts the scaling size of the sideview battler's shadow.
 * 
 * Version 1.32: April 2, 2021
 * * Feature Update!
 * ** Sideview battler sprites when using front view will now factor in the
 *    window padding and appear properly centered to their focus point. Update
 *    made by Olivia.
 * 
 * Version 1.31: March 26, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Added "VisuStella MZ Compatibility" section for detailed compatibility
 *    explanations with the VisuMZ_3_BoostAction plugin.
 * 
 * Version 1.30: March 19, 2021
 * * Documentation Update!
 * ** Help file updated for updated features.
 * * Feature Update!
 * ** <JS Targets> is now updated to include the default set of targets
 *    selected by the skill/item's original scope. Update made by Yanfly.
 * *** If you wish to clear it out, simply do 'targets = []' first.
 * 
 * Version 1.29: March 12, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameter added by Olivia:
 * *** Plugin Parameters > Enemy Battler Settings > Name > Legacy Option
 * **** Use the legacy version (window) or new version (sprite).
 * **** WARNING: Legacy version is no longer supported for bugs.
 * **** Not all settings available here in the Plugin Parameters will be
 *      available to the legacy version (ie Always Visible and Attach States).
 * 
 * Version 1.28: March 5, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Arisu:
 * *** Plugin Parameters > Actor Command > Show Command Costs
 * **** If you don't want to show skill costs for your commands in the Actor
 *      Command Window, you can now hide them.
 * ** New Plugin Parameters added by Irina:
 * *** Plugin Parameters > Battle Layout Settings > Status Window Elements
 * *** Battle Layout Settings > Status Window Elements > Battler Name
 * *** Battle Layout Settings > Status Window Elements > Gauge 1 (HP)
 * *** Battle Layout Settings > Status Window Elements > Gauge 2 (MP)
 * *** Battle Layout Settings > Status Window Elements > Gauge 3 (TP)
 * *** Battle Layout Settings > Status Window Elements > State Icon
 * *** Battle Layout Settings > Status Window Elements > TPB/ATB Gauge
 * **** These new Plugin Parameters allow you to offset the positions of the
 *      various Battle Status Window elements. Their base positions will be
 *      calculated by the Battle Layout used and then offset from there.
 * *** Battle Layout Settings > Status Window Elements > Window Skin
 * **** These settings allow you to set a specific window skin for the
 *      Battle Status Window or hide it from view completely.
 * *** Battle Layout Settings > Status Window Elements > Selectable Background
 * **** This option allows you to hide the black box that comes with the
 *      majority of selectable elements found in RPG Maker MZ in case it does
 *      not fit with how you want the Battle Status Window to look.
 * *** Battle Layout Settings > Status Window Elements > Back Attachment
 * *** Battle Layout Settings > Status Window Elements > Front Attachment
 * **** These settings allow you to attach images to the back/front of the
 *      Battle Status Window from the img/system/ folder.
 * **** You may offset X and Y positions for them as well.
 * ** New Plugin Parameters added by Olivia:
 * *** Plugin Parameters > Enemy Settings > Name: Always Visible
 * **** Determines if the enemy name will always be visible.
 * *** Plugin Parameters > Enemy Settings > Name: Attach States
 * **** Attach the enemy's state icon to the enemy name?
 * *** Plugin Parameters > Enemy Settings > Attach: Offset X/Y
 * **** Offset the attached state icon's position.
 * * Feature Update!
 * ** Switched drawing enemy names on the screen from window to sprite to
 *    reduce lag and for better screen positioning accuracy especially during
 *    screen zooming. Update by Olivia.
 * 
 * Version 1.27: February 26, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Irina and sponsored by AndyL:
 * *** Plugin Parameters > Mechanics Settings > Switches > Switch: Critical
 * *** Plugin Parameters > Mechanics Settings > Switches > Switch: Miss/Evade
 * **** Turns Switches ON if the action performs a critical hit, misses, or is
 *      evaded at any point.
 * **** Switch reverts to OFF whenever an action starts.
 * **** If multiple targets/hits are struck, as long as one hit respectively
 *      lands a critical hit, fails to land, then the switch will remain ON for
 *      the rest of the action.
 * *** Plugin Parameters > Mechanics Settings > Variables > Variable: Damage
 * *** Plugin Parameters > Mechanics Settings > Variables > Variable: Healing
 * **** Variable records target damage/healing during action.
 * **** Variable reverts to 0 whenever an action starts.
 * **** If multiple targets/hits are struck, the variable will record the total
 *      amount of damage/healing done for the remainder of the action (unless
 *      manually reseting to 0 during an Action Sequence).
 * 
 * Version 1.26: February 19, 2021
 * * Bug Fixes!
 * ** Battles with branching event paths found within a conditional branch or
 *    choice tree will no longer be skipped over. Fix made by Arisu.
 * * Compatibility Update
 * ** Returning to the battle scene from the options scene in a Tpb-base battle
 *    system now links the current actor. Update by Irina.
 * 
 * Version 1.25: February 5, 2021
 * * Compatibility Update
 * ** Added compatibility update with VisuStella MZ Skills and States Core's
 *    Plugin Parameter > State Settings > Action End Update
 * * Feature Update!
 * ** <Common Event: name> notetag no longer requires <Custom Action Sequence>
 *    notetag if the Plugin Parameter: Auto Notetag is enabled.
 * 
 * Version 1.24: January 29, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** MOVE: Move To Point and MOVE: Move To Target(s) Action Sequences'
 *    "Offset Adjustment" normal setting will now factor in Offset X and
 *    Offset Y positions unlike before where it cancels them. Update by Irina.
 * * New Features!
 * ** New notetag added by Arisu:
 * *** <Common Event: name>
 * **** Battle only: calls forth a Common Event of a matching name.
 * **** This is primarily used for users who are reorganizing around their
 *      Common Events and would still like to have their skills/items perform
 *      the correct Action Sequences in case the ID's are different.
 * 
 * Version 1.23: January 22, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** ACSET: All Targets Action Set and ACSET: Each Target Action Set updated
 * *** New parameter added: Dual/Multi Wield?
 * **** Add times struck based on weapon quantity equipped?
 * * New Features!
 * ** Dual Wielding now functions differently. Made by Olivia.
 * *** Previously, RPG Maker MZ had "Dual Wielding" attack using both weapon
 *     animations at once, with the combined ATK of each weapon. It's confusing
 *     to look at and does not portray the nature of "Dual Wielding".
 * *** Dual Wielding, or in the case of users adding in third and fourth
 *     weapons, Multi Wielding is now changed. Each weapon is displayed
 *     individually, each producing its own attack animation, showing each
 *     weapon type, and applying only that weapon's ATK, Traits, and related
 *     effects. It is no longer a combined effect to display everything at once
 *     like RPG Maker MZ default.
 * *** If an actor has multiple weapon slots but some of them are unequipped,
 *     then the action will treat the attack as a single attack. There will be
 *     no barehanded attack to add on top of it. This is to match RPG Maker
 *     MZ's decision to omit a second animation if the same scenario is
 *     applied.
 * ** New Action Sequence Plugin Commands added by Yanfly
 * *** ANIM: Attack Animation 2+
 * **** Plays the animation associated with the user's 2nd weapon.
 *      Plays nothing if there is no 2nd weapon equipped.
 * ** New Action Sequence Plugin Commands added by Olivia
 * *** WEAPON: Clear Weapon Slot
 * *** WEAPON: Next Weapon Slot
 * *** WEAPON: Set Weapon Slot
 * **** These are Action Sequence Plugin Commands for devs who want finer
 *      control over Dual/Multi Wielding weapons.
 * 
 * Version 1.22: January 15, 2021
 * * Compatibility Update
 * ** Compatibility with "All Skills" Actor Command should now work with the
 *    Skills & States Core hide skill notetags.
 * 
 * Version 1.21: January 8, 2021
 * * Bug Fixes!
 * ** "MOVE: Home Reset" Plugin Command Action Sequence should work properly.
 *    Fix made by Yanfly.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New Notetag snuck in by Arisu
 * *** <Auto Action Sequence>
 * **** Used for those who have the "Auto Notetag" Plugin Parameter enabled and
 *      just want to use an automatic Action Sequence instead.
 * ** New Plugin Parameter snuck in by Arisu!
 * *** Plugin Parameters > Action Sequences > Quality of Life > Auto Notetag
 * **** Automatically apply the <Custom Action Sequence> notetag effect to any
 *      item or skill that has a Common Event?
 * **** Any item or skill without a Common Event attached to it will use the
 *      Automatic Action Sequences instead.
 * **** The <Auto Action Sequence> notetag will disable this effect for that
 *      particular skill or item.
 * ** Arisu, you're going to be responsible for any bugs these may cause.
 * *** Bring it!!!!
 * **** And handling any bug report emails that are sent because this was
 *      turned on by accident.
 * ***** Please read the documentation, guys!
 * 
 * Version 1.20: January 1, 2021
 * * Bug Fixes!
 * ** For TPB Active or ATB Active, inputting actors that have received damage
 *    will return back to place after flinching. Fix made by Yanfly.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New notetags added by Yanfly:
 * *** <Battle Portrait Offset: +x, +y>
 * *** <Battle Portrait Offset X: +x>
 * *** <Battle Portrait Offset Y: +y>
 * **** This is used with the "Portrait" and "Border" Battle Layouts.
 * **** Offsets the X and Y coordinates for the battle portrait.
 * 
 * Version 1.19: December 25, 2020
 * * Bug Fixes!
 * ** Removing a state from a Sideview Enemy during the middle of their a non-
 *    looping motion will no longer reset their motion to neutral.
 *    Fix made by Yanfly.
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Added documentation for updated feature(s)!
 * * Feature Update!
 * ** Action Sequence "PROJECTILE: Icon" now supports code for the "Icon"
 *    parameter. Update made by Yanfly.
 * 
 * Version 1.18: December 18, 2020
 * * Bug Fixes!
 * ** For TPB Active or ATB Active, inputting actors will no longer step back
 *    after an enemy's action is finished. Fix made by Yanfly and Shiro.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** Action Sequence "BTLOG: Add Text" is updated for the convenience of a new
 *    option to quickly copy the displayed text to the VisuStella MZ Combat Log
 *    if that plugin is installed. Added by Yanfly.
 * 
 * Version 1.17: December 11, 2020
 * * Bug Fixes!
 * ** Common Events in TPB Active that cause forced actions will no longer
 *    cause currently inputting actors that match the forced action battler to
 *    crash the game. Fix made by Yanfly and Shiro.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * Feature Update!
 * ** Action Sequence Impact Action Sequences "Shockwave from Each Target(s)",
 *    "Shockwave from Target(s) Center", and "Zoom Blur at Target(s) Center"
 *    now have "Offset X" and "Offset Y" plugin parameters. Added by Yanfly.
 * ** Action Sequence "MOVE: Move To Target(s)" is now changed so that if the
 *    "Melee Distance" value is set to 0, battlers will no longer stand a half
 *    body distance away. Added by Yanfly.
 * 
 * Version 1.16: December 4, 2020
 * * Bug Fixes!
 * ** Bug fixes made for the RPG Maker MZ base code. If a battler has no
 *    actions, then their action speed will not be Infinity. Fix by Olivia.
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.15: November 29, 2020
 * * Bug Fixes!
 * ** Completely replacing the whole party at once will no longer cause the
 *    battle system to crash. Fix made by Olivia.
 * ** Pre-Battle Common Events will no longer cancel out any win/lose branches.
 *    Fix made by Arisu.
 * * Feature Update!
 * ** Custom Action Sequences will no longer close the Actor Command Input
 *    window unless absolutely necessary (like for Show Message events) during
 *    Active TPB/ATB. Change made by Arisu.
 * 
 * Version 1.14: November 22, 2020
 * * Feature Update!
 * ** Natural Miss and Evasion motions now have flinch distance.
 *    Added by Yanfly.
 * 
 * Version 1.13: November 15, 2020
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.12: November 8, 2020
 * * Bug Fixes!
 * ** Failsafes added to prevent common events from running if they're empty.
 *    Fix made by Irina.
 * ** Skip Party Command will now work properly with TPB-based battle systems.
 *    Fix made by Yanfly.
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** In preparation for upcoming VisuStella MZ plugins.
 * 
 * Version 1.11: November 1, 2020
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Added clarity for the Plugin Parameters for the Common Events settings
 *    found in the mechanics section. The common events are only meant to run
 *    in the map scene and not for the battle scene. Update made by Irina.
 * * Feature Update!
 * ** The Plugin Parameter for Mechanics, Common Events (on Map), Defeat Event
 *    now has updated functionality. If this has a common event attached to it,
 *    then losing to random encounters will no longer send the player to the
 *    Game Over scene, but instead, send the player back to the map scene,
 *    where the Defeat Common Event will run. Update made by Irina.
 * 
 * Version 1.10: October 25, 2020
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New Action Sequence Plugin Command added by Olivia:
 * *** MECH: Custom Damage Formula
 * **** Changes the current action's damage formula to custom.
 *      This will assume the MANUAL damage style.
 * ** New Notetag added by Irina:
 * ** New Plugin Parameters added by Irina:
 * *** Plugin Parameters > Battleback Scaling Settings
 * **** These settings allow you to adjust how battlebacks scale to the screen
 *      in the game.
 * *** <Battler Sprite Grounded>
 * **** Prevents the enemy from being able to jumping and/or floating due to
 *      Action Sequences but still able to move. Useful for rooted enemies.
 * 
 * Version 1.09: October 18, 2020
 * * Bug Fixes!
 * ** Exiting out of the Options menu scene or Party menu scene will no longer
 *    cause party members to reset their starting position. Fix made by Arisu
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * ** There was a documentation error with <JS Pre-Regenerate> and
 *    <JS Post-Regenerate>. Fix made by Yanfly.
 * *** Before, these were written as <JS Pre-Regenerate Turn> and
 *     <JS Post-Regenerate Turn>. The "Turn" part of the notetag has been
 *     removed in the documentation.
 * * Feature Update!
 * ** Damage sprites on actors are now centered relative to the actor's anchor.
 *    Change made by Yanfly.
 * * New Features!
 * ** New Action Sequence Plugin Command added by Yanfly:
 * *** MECH: Variable Popup
 * **** Causes the unit(s) to display a popup using the data stored inside
 *      a variable.
 * 
 * Version 1.08: October 11, 2020
 * * Bug Fixes!
 * ** Dead party members at the start of battle no longer start offscreen.
 *    Fix made by Arisu.
 * ** Removed party members from battle no longer count as moving battlers.
 *    Fix made by Yanfly.
 * ** Using specific motions should now have the weapons showing and not
 *    showing properly. Fix made by Yanfly.
 * 
 * Version 1.07: October 4, 2020
 * * Bug Fixes!
 * ** Adding and removing actors will now refresh the battle status display.
 *    Fix made by Irina.
 * ** Adding new states that would change the affected battler's state motion
 *    will automatically refresh the battler's motion. Fix made by Irina.
 * ** Boss Collapse animation fixed and will sink into the ground.
 *    Fix made by Irina.
 * ** Failsafes added for certain animation types. Fix made by Yanfly.
 * ** Freeze Motion for thrust, swing, and missile animations will now show the
 *    weapons properly. Fix made by Yanfly.
 * ** The Guard command will no longer display the costs of the Attack command.
 *    Fix made by Irina.
 * * Documentation Update!
 * ** Updated help file for newly added plugin parameters.
 * * Feature Updates!
 * ** When using the Change Battleback event command in battle, the game client
 *    will wait until both battlebacks are loaded before changing the both of
 *    them so that the appearance is synched together. Change made by Yanfly.
 * * New Features!
 * ** New plugin parameters added by Irina!
 * *** Plugin Parameters > Actor Battler Settings > Chant Style
 * **** What determines the chant motion? Hit type or skill type?
 * 
 * Version 1.06: September 27, 2020
 * * Bug Fixes!
 * ** Enemy Battler Plugin Parameter "Shadow Visible" should now work again.
 *    Fix made by Irina.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins. Added by Yanfly.
 * * Documentation Update!
 * ** Updated the help file for all the new plugin parameters.
 * * Feature Update!
 * ** Action Sequence "MECH: HP, MP, TP" will now automatically collapse an
 *    enemy if it has been killed by the effect.
 * ** All battle systems for front view will now have damage popups appear
 *    in front of the status window instead of just the Portrait battle layout.
 *    Update made by Yanfly.
 * * New Features!
 * ** New Action Sequence Plugin Commands from Irina!
 * *** MOTION: Clear Freeze Frame
 * *** MOTION: Freeze Motion Frame
 * **** You can freeze a battler's sprite's motion with a specific frame.
 * ** New notetags for Maps and name tags for Troops added by Yanfly!
 * *** <Battle Layout: type> to change the battle layout style used for
 *     specific maps and/or troops.
 * ** New plugin parameters added by Yanfly!
 * *** Plugin Parameters > Battle Layout Settings > Command Window Width
 * **** This plugin parameter lets you adjust the window width for Party and
 *      Actor Command windows in the Default and List Battle Layout styles.
 * *** Plugin Parameters > Enemy Battler Settings > Name: Offset X
 * *** Plugin Parameters > Enemy Battler Settings > Name: Offset Y
 * **** These plugin parameters allow you to offset the position of the enemy
 *      name positions on the screen by a specific amount.
 * 
 * Version 1.05: September 20, 2020
 * * Bug Fixes!
 * ** Actors now use their casting or charging animations again during TPB/ATB.
 *    Fix made by Yanfly.
 * ** Defeat requirement for enemies will no longer crash the game if turned on
 *    after creating
 * ** Escaping animation no longer has actors stay in place. Fixed by Yanfly.
 * ** Failsafes added for newly added weapon types that have not been adjusted
 *    in the Database > System 2 tab. Fixed by Irina.
 * ** Shadows now appear under the actor sprites. Fix made by Yanfly.
 * ** Victory during TPB will no longer cancel the victory animations of
 *    actors that will have their turn after. Fixed by Yanfly.
 * * Documentation Update!
 * ** All Anchor Plugin Parameter descriptions now state to use values between
 *    0 and 1 to be safe. Update made by Yanfly.
 * * Feature Update!
 * ** During Active TPB / ATB, canceling out of the actor command window will
 *    go directly into the party window without having to sort through all of
 *    the available active actors.
 * ** Going from the Party Command Window's Fight command will immediately
 *    return back to the actor command window that was canceled from.
 * * New Features!
 * ** Action Sequence Plugin Command "MOVE: Spin/Rotate" has been updated.
 * *** A new parameter has been added: "Revert Angle on Finish"
 * *** Added by Yanfly.
 * ** New plugin parameters have been added to Damage Settings.
 * *** Appear Position: Selects where you want popups to appear relative to the
 *     battler. Head, Center, Base. Added by Yanfly.
 * *** Offset X: Sets how much to offset the sprites by vertically.
 *     Added by Yanfly.
 * *** Offset Y: Sets how much to offset the sprites by horizontally.
 *     Added by Yanfly.
 * ** New plugin parameters have been added to Actor Battler Settings.
 * *** Priority: Active - Place the active actor on top of actor and
 *     enemy sprites. Added by Yanfly.
 * *** Priority: Actors - Prioritize actors over enemies when placing 
 *     sprites on top of each other. Added by Yanfly.
 * 
 * Version 1.04: September 13, 2020
 * * Bug Fixes!
 * ** Active Battler Sprites now remain on top and won't be hidden behind
 *    other sprites for better visual clarity. Fix made by Arisu.
 * ** Collapsing battlers will now show the dead motion properly. Fix made by
 *    Olivia.
 * ** Dead battlers can no longer be given immortality. Fix made by Olivia.
 * ** Going into the Options menu with no battleback set will no longer set a
 *    battle snapshot.
 * ** HP Gauges for Sideview Enemies are no longer flipped! Fix made by Yanfly.
 * ** Moving a dead battler would no longer reset their animation. Fix made by
 *    Olivia.
 * ** Pre-Battle Common Events now work with events instead of just random
 *    encounters. Fix made by Yanfly.
 * ** Sideview Enemy shadows no longer twitch. Fix made by Irina.
 * * Documentation Updates!
 * ** Added further explanations for Anchor X and Anchor Y plugin parameters.
 *    This is because there's a lot of confusion for users who aren't familiar
 *    with how sprites work. Added by Irina.
 * ** <Magic Reduction: x> notetag updated to say magical damage instead of
 *    physical damage. Fix made by Yanfly.
 * * New Features!
 * ** Additional Action Sequence Plugin Commands have been added in preparation
 *    of upcoming plugins! Additions made by Irina.
 * *** Action Sequences - Angle (for VisuMZ_3_ActSeqCamera)
 * *** Action Sequences - Camera (for VisuMZ_3_ActSeqCamera)
 * *** Action Sequences - Skew (for VisuMZ_3_ActSeqCamera)
 * *** Action Sequences - Zoom (for VisuMZ_3_ActSeqCamera)
 * ** Additional Action Sequence Plugin Commands have been made available now
 *    and added to Battle Core! Additions made by Irina.
 * *** MOVE: Scale/Grow/Shrink
 * *** MOVE: Skew/Distort
 * *** MOVE: Spin/Rotate
 * *** MOVE: Wait For Scale
 * *** MOVE: Wait For Skew
 * *** MOVE: Wait For Spin
 * ** Plugin Parameters Additions. Additions made by Irina.
 * *** Plugin Params > Actor Battler Settings > Offset X
 * *** Plugin Params > Actor Battler Settings > Offset Y
 * *** Plugin Params > Actor Battler Settings > Smooth Image
 * *** Plugin Params > Enemy Battler Settings > Offset X
 * *** Plugin Params > Enemy Battler Settings > Offset Y
 * *** Plugin Params > Enemy Battler Settings > Smooth Image
 * 
 * Version 1.03: September 6, 2020
 * * Bug Fixes!
 * ** Animated Battlers will refresh their motions from the death motion once
 *    they're revived instead of waiting for their next input phase. Fix made
 *    by Yanfly.
 * ** Battle Log speed sometimes went by too fast for certain enabled messages.
 *    Wait timers are now added to them, like state results, buff results, and
 *    debuff results. Fix made by Yanfly.
 * ** Boss Collapse animation now works properly. Fix made by Yanfly.
 * ** Freeze fix for TPB (Wait) if multiple actors get a turn at the same time.
 *    Fix made by Olivia.
 * ** Pressing cancel on a target window after selecting a single skill no
 *    longer causes the status window to twitch.
 * ** Sideview Enemies had a split frame of being visible if they were to start
 *    off hidden in battle. Fix made by Shaz.
 * * Compatibility Update:
 * ** Battle Core's Sprite_Damage.setup() function is now separated fro the
 *    default to allow for better compatibility. Made by Yanfly.
 * * Documentation Update:
 * ** Inserted more information for "Damage Popups" under "Major Changes"
 * * New Features!
 * ** <Magic Penetration: x>, <Magic Penetration: x%> notetags added.
 * ** <Magic Reduction: x>, <Magic Reduction: x%> notetags added.
 * ** <Battle UI Offset: +x, +y>, <Battle UI Offset X: +x>, and
 *    <Battle UI Offset Y: +y> notetags added for adjusting the positions of
 *    HP Gauges and State Icons.
 * *** Notetags added by Yanfly.
 * 
 * Version 1.02: August 30, 2020
 * * Bug Fixes!
 * ** Failsafes added for parsing battle targets. Fix made by Yanfly.
 * ** Immortality is no longer ignored by skills/items with the Normal Attack
 *    state effect. Fix made by Yanfly.
 * ** Miss and Evasion sound effects work again! Fix made by Yanfly.
 * ** Selecting "Escape" from the Actor Command Window will now have the
 *    Inputting Battler show its escape motion. Fix made by Yanfly.
 * ** Wait for Movement now applies to SV Enemies. Fix made by Yanfly.
 * * New Features!
 * ** Plugin Command "ACSET: Finish Action" now has an option to turn off the
 *    Immortality of targets. Feature added by Yanfly.
 * * Optimization Update
 * ** Uses less resources when making checks for Pre-Battle Battle Start events
 * 
 * Version 1.01: August 23, 2020
 * * Bug Fixes!
 * ** Plugin Parameters > Damage Settings > Damage Formats are now fixed.
 *    Fix made by Olivia.
 * ** TPB Battle System with Disable Party Command fixed. Fix made by Olivia.
 * ** States now show in list format if faces are disabled. Fix made by Yanfly.
 * ** The default damage styles were missing the 'v' variable to allow for
 *    variable data input. These are back now. Fix made by Yanfly.
 * *** Users updating from version 1.00 will need to fix this problem by either
 *     removing the plugin from the Plugin Manager list and reinstalling it, or
 *     going to Plugin Parameters > Damage Settings > Style List > the style
 *     you want, and adding "const v = $gameVariables._data;" to JS: Formula
 * * New Notetags Added:
 * ** <Command Show Switch: x> added by Olivia
 * ** <Command Show All Switches: x,x,x> added by Olivia
 * ** <Command Show Any Switches: x,x,x> added by Olivia
 * ** <Command Hide Switch: x> added by Olivia
 * ** <Command Hide All Switches: x,x,x> added by Olivia
 * ** <Command Hide Any Switches: x,x,x> added by Olivia
 * ** <JS Command Visible> added by Olivia
 *
 * Version 1.00: August 20, 2020
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceStart
 * @text -
 * @desc The following are Action Sequences commands/sets.
 * These Plugin Commands only work in battle.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakSet
 * @text Action Sequence - Action Sets
 * @desc Action Sequence Action Sets are groups of commonly used
 * Action Sequence Commands put together for more efficient usage.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_SetupAction
 * @text ACSET: Setup Action Set
 * @desc The generic start to most actions.
 * 
 * @arg DisplayAction:eval
 * @text Display Action
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: On
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ActionStart:eval
 * @text Battle Step
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg CastAnimation:eval
 * @text Cast Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_WholeActionSet
 * @text ACSET: All Targets Action Set
 * @desc Affects all targets simultaneously performing the following.
 * 
 * @arg DualWield:eval
 * @text Dual/Multi Wield?
 * @type boolean
 * @on Apply
 * @off Don't
 * @desc Add times struck based on weapon quantity equipped?
 * @default false
 * 
 * @arg PerformAction:eval
 * @text Perform Action
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitCount:eval
 * @text Wait Count
 * @desc How many frames should the action sequence wait?
 * You may use JavaScript code.
 * @default Sprite_Battler._motionSpeed
 * 
 * @arg ActionAnimation:eval
 * @text Action Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ActionEffect:eval
 * @text Action Effect
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: Off
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_TargetActionSet
 * @text ACSET: Each Target Action Set
 * @desc Goes through each target one by one to perform the following.
 * 
 * @arg DualWield:eval
 * @text Dual/Multi Wield?
 * @type boolean
 * @on Apply
 * @off Don't
 * @desc Add times struck based on weapon quantity equipped?
 * @default false
 * 
 * @arg PerformAction:eval
 * @text Perform Action
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitCount1:eval
 * @text Wait Count
 * @desc How many frames should the action sequence wait?
 * You may use JavaScript code.
 * @default Sprite_Battler._motionSpeed
 * 
 * @arg ActionAnimation:eval
 * @text Action Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitCount2:eval
 * @text Wait Count
 * @desc How many frames should the action sequence wait?
 * You may use JavaScript code.
 * @default Sprite_Battler._motionSpeed * 2
 * 
 * @arg ActionEffect:eval
 * @text Action Effect
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: Off
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_FinishAction
 * @text ACSET: Finish Action
 * @desc The generic ending to most actions.
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: Off
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForNewLine:eval
 * @text Wait For New Line
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForEffect:eval
 * @text Wait For Effects
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ClearBattleLog:eval
 * @text Clear Battle Log
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ActionEnd:eval
 * @text Home Reset
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceAngle
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakAngle
 * @text Action Sequences - Angle
 * @desc Allows you to have control over the camera angle.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_ChangeAngle
 * @text ANGLE: Change Angle
 * @desc Changes the camera angle.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Angle:eval
 * @text Angle
 * @desc Change the camera angle to this many degrees.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to change camera angle.
 * @default 60
 *
 * @arg EasingType:str
 * @text Angle Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForAngle:eval
 * @text Wait For Angle?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for angle changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Angle_Reset
 * @text ANGLE: Reset Angle
 * @desc Reset any angle settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to reset camera angle.
 * @default 60
 *
 * @arg EasingType:str
 * @text Angle Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForAngle:eval
 * @text Wait For Angle?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for angle changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Angle_WaitForAngle
 * @text ANGLE: Wait For Angle
 * @desc Waits for angle changes to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceAnimation
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakAnimation
 * @text Action Sequences - Animations
 * @desc These Action Sequences are related to the 'Animations' that
 * can be found in the Animations tab of the Database.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ActionAnimation
 * @text ANIM: Action Animation
 * @desc Plays the animation associated with the action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_AttackAnimation
 * @text ANIM: Attack Animation
 * @desc Plays the animation associated with the user's 1st weapon.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_AttackAnimation2
 * @text ANIM: Attack Animation 2+
 * @desc Plays the animation associated with the user's other weapons.
 * Plays nothing if there is no other weapon equipped.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Slot:eval
 * @text Slot
 * @desc Which weapon slot to get this data from?
 * Main-hand weapon is weapon slot 1.
 * @default 2
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default true
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_CastAnimation
 * @text ANIM: Cast Animation
 * @desc Plays the cast animation associated with the action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["user"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ChangeBattlePortrait
 * @text ANIM: Change Battle Portrait
 * @desc Changes the battle portrait of the actor (if it's an actor).
 * Can be used outside of battle/action sequences.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to change the portraits for.
 * Valid units can only be actors.
 * @default ["user"]
 * 
 * @arg Filename:str
 * @text Filename
 * @type file
 * @dir img/pictures/
 * @desc Select the file to change the actor's portrait to.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_PlayAtCoordinate
 * @text ANIM: Play at Coordinate
 * @desc Plays an animation on the screen at a specific x, y coordinate.
 * Requires VisuMZ_0_CoreEngine!
 *
 * @arg AnimationID:num
 * @text Animation ID
 * @parent Animation
 * @type animation
 * @desc Plays this animation.
 * @default 1
 * 
 * @arg Coordinates
 *
 * @arg pointX:eval
 * @text X
 * @parent Coordinates
 * @desc X coordinate used for the animation.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 *
 * @arg pointY:eval
 * @text Y
 * @parent Coordinates
 * @desc Y coordinate used for the animation.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 *
 * @arg Mirror:eval
 * @text Mirror Animation?
 * @parent Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 *
 * @arg Mute:eval
 * @text Mute Animation?
 * @parent Animation
 * @type boolean
 * @on Mute
 * @off Normal
 * @desc Mute the animation?
 * @default false
 *
 * @arg WaitComplete:eval
 * @text Wait for Completion?
 * @parent Animation
 * @type boolean
 * @on Wait
 * @off Normal
 * @desc Wait the animation to finish before continuing?
 * @default false
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ShowAnimation
 * @text ANIM: Show Animation
 * @desc Plays the a specific animation on unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg AnimationID:num
 * @text Animation ID
 * @type animation
 * @desc Select which animation to play on unit(s).
 * @default 1
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_WaitForAnimation
 * @text ANIM: Wait For Animation
 * @desc Causes the interpreter to wait for any animation(s) to finish.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceBattleLog
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakBattleLog
 * @text Action Sequences - Battle Log
 * @desc These Action Sequences are related to the Battle Log Window,
 * the window found at the top of the battle screen.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_AddText
 * @text BTLOG: Add Text
 * @desc Adds a new line of text into the Battle Log.
 * 
 * @arg Text:str
 * @text Text
 * @desc Add this text into the Battle Log.
 * Text codes allowed.
 * @default Insert text here.
 * 
 * @arg CopyCombatLog:eval
 * @text Copy to Combat Log?
 * @type boolean
 * @on Copy Text
 * @off Don't Copy
 * @desc Copies text to the Combat Log.
 * Requires VisuMZ_4_CombatLog
 * @default true
 *
 * @arg CombatLogIcon:num
 * @text Combat Log Icon
 * @parent CopyCombatLog:eval
 * @desc What icon would you like to bind to this entry?
 * Requires VisuMZ_4_CombatLog
 * @default 87
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_Clear
 * @text BTLOG: Clear Battle Log
 * @desc Clears all the text in the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_DisplayAction
 * @text BTLOG: Display Action
 * @desc Displays the current action in the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_PopBaseLine
 * @text BTLOG: Pop Base Line
 * @desc Removes the Battle Log's last added base line and 
 * all text up to its former location.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_PushBaseLine
 * @text BTLOG: Push Base Line
 * @desc Adds a new base line to where the Battle Log currently is at.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_Refresh
 * @text BTLOG: Refresh Battle Log
 * @desc Refreshes the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_UI
 * @text BTLOG: UI Show/Hide
 * @desc Shows or hides the Battle UI (including the Battle Log).
 * 
 * @arg ShowHide:eval
 * @text Show/Hide?
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows/hides the Battle UI.
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_WaitForBattleLog
 * @text BTLOG: Wait For Battle Log
 * @desc Causes the interpreter to wait for the Battle Log to finish.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_WaitForNewLine
 * @text BTLOG: Wait For New Line
 * @desc Causes the interpreter to wait for a new line in the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceCamera
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakCamera
 * @text Action Sequences - Camera
 * @desc Allows you to have control over the camera.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_Clamp
 * @text CAMERA: Clamp ON/OFF
 * @desc Turns battle camera clamping on/off.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Setting:eval
 * @text ON/OFF
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Turns camera clamping on/off.
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_FocusPoint
 * @text CAMERA: Focus Point
 * @desc Focus the battle camera on a certain point in the screen.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg FocusX:eval
 * @text X Coordinate
 * @desc Insert the point to focus the camera on.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @arg FocusY:eval
 * @text Y Coordinate
 * @desc Insert the point to focus the camera on.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for camera focus change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_FocusTarget
 * @text CAMERA: Focus Target(s)
 * @desc Focus the battle camera on certain battler target(s).
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to focus the battle camera on.
 * @default ["user"]
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for camera focus change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_Offset
 * @text CAMERA: Offset
 * @desc Offset the battle camera from the focus target.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @desc How much to offset the camera X by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @desc How much to offset the camera Y by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for offset change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_Reset
 * @text CAMERA: Reset
 * @desc Reset the battle camera settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg ResetFocus:eval
 * @text Reset Focus?
 * @type boolean
 * @on On
 * @off Off
 * @desc Reset the focus point?
 * @default true
 * 
 * @arg ResetOffset:eval
 * @text Reset Offset?
 * @type boolean
 * @on On
 * @off Off
 * @desc Reset the camera offset?
 * @default true
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for reset change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_WaitForCamera
 * @text CAMERA: Wait For Camera
 * @desc Waits for camera to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceCutin
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakCutin
 * @text Action Sequences - Cutins
 * @desc Allows you to have control over Visual Cutin Effects.
 * Requires VisuMZ_3_VisualCutinEffect!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Cutin_AddVisualCutinEffect
 * @text CUTIN: Add Visual Cutin Effect
 * @desc Adds the Visual Cutin Effect using these desired settings.
 * Requires VisuMZ_3_VisualCutinEffect!
 * 
 * @arg Basic
 * @text Basic Settings
 * 
 * @arg type:str
 * @text Cutin Style Type
 * @parent Basic
 * @type select
 * @option -
 * @option Whole
 * @option -
 * @option Showcase
 * @option -
 * @option LeftHorzSpan
 * @option CenterHorzSpan
 * @option RightHorzSpan
 * @option -
 * @option LeftHorzSlash
 * @option RightHorzSlash
 * @option -
 * @option LeftVertSlash
 * @option RightVertSlash
 * @option -
 * @option LeftMajor
 * @option RightMajor
 * @option -
 * @option LeftMinor
 * @option CenterMinor
 * @option RightMinor
 * @option -
 * @option LeftDiamond
 * @option CenterDiamond
 * @option RightDiamond
 * @option -
 * @option LeftGemstone
 * @option CenterGemstone
 * @option RightGemstone
 * @option -
 * @option TopLeftQuad
 * @option TopRightQuad
 * @option BottomLeftQuad
 * @option BottomRightQuad
 * @option -
 * @option TopLeftCorner
 * @option TopRightCorner
 * @option BottomLeftCorner
 * @option BottomRightCorner
 * @option -
 * @option Row1stThird
 * @option Row2ndThird
 * @option Row3rdThird
 * @option -
 * @option Row1stFourth
 * @option Row2ndFourth
 * @option Row3rdFourth
 * @option Row4thFourth
 * @option -
 * @option Row1stFifth
 * @option Row2ndFifth
 * @option Row3rdFifth
 * @option Row4thFifth
 * @option Row5thFifth
 * @option -
 * @option Col1stThird
 * @option Col2ndThird
 * @option Col3rdThird
 * @option -
 * @option Col1stFourth
 * @option Col2ndFourth
 * @option Col3rdFourth
 * @option Col4thFourth
 * @option -
 * @option Col1stFifth
 * @option Col2ndFifth
 * @option Col3rdFifth
 * @option Col4thFifth
 * @option Col5thFifth
 * @option -
 * @option SixPack1
 * @option SixPack2
 * @option SixPack3
 * @option SixPack4
 * @option SixPack5
 * @option SixPack6
 * @option -
 * @option EightPack1
 * @option EightPack2
 * @option EightPack3
 * @option EightPack4
 * @option EightPack5
 * @option EightPack6
 * @option EightPack7
 * @option EightPack8
 * @option -
 * @option TwelvePack1
 * @option TwelvePack2
 * @option TwelvePack3
 * @option TwelvePack4
 * @option TwelvePack5
 * @option TwelvePack6
 * @option TwelvePack7
 * @option TwelvePack8
 * @option TwelvePack9
 * @option TwelvePack10
 * @option TwelvePack11
 * @option TwelvePack12
 * @option -
 * @desc What Visual Cutin Effect style type do you wish to use?
 * Only one of each cutin-style type can be present.
 * @default CenterHorzSpan
 * 
 * @arg Targets:arraystr
 * @text Portrait Target
 * @parent Basic
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to grab the Visual Cutin Effect portrait
 * data from. First unit will be used to make portrait.
 * @default ["user"]
 *
 * @arg parallaxFilename:str
 * @text Parallax Filename
 * @parent Basic
 * @type file
 * @dir img/parallaxes/
 * @require 1
 * @desc Pick a parallax to use for the Visual Cutin Effect.
 * Pick (None) to not use a parallax.
 * @default >>>ATTENTION<<<
 *
 * @arg bgColor:str
 * @text Background Color
 * @parent Basic
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default #888888
 *
 * @arg ExtraSettings:struct
 * @text Extra Settings
 * @type struct<VisualCutinEffect>
 * @desc Extra Plugin Command settings pertaining to this Visual Cutin Effect.
 * @default {}
 * 
 * @arg WaitForEntrance:eval
 * @text Wait For Entrance
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait until cutin entrance is finished before performing
 * the next event command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Cutin_EndVisualCutinEffectAll
 * @text CUTIN: End Visual Cutin Effect (All)
 * @desc Ends all Visual Cutin Effects currently present.
 * Requires VisuMZ_3_VisualCutinEffect!
 * 
 * @arg WaitForExit:eval
 * @text Wait For Exit
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait until cutin exit is finished before performing
 * the next event command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Cutin_EndVisualCutinEffectType
 * @text CUTIN: End Visual Cutin Effect (Type)
 * @desc Ends the Visual Cutin Effect with the matching type.
 * Requires VisuMZ_3_VisualCutinEffect!
 * 
 * @arg type:str
 * @text Cutin Style Type
 * @type select
 * @option -
 * @option Whole
 * @option -
 * @option Showcase
 * @option -
 * @option LeftHorzSpan
 * @option CenterHorzSpan
 * @option RightHorzSpan
 * @option -
 * @option LeftHorzSlash
 * @option RightHorzSlash
 * @option -
 * @option LeftVertSlash
 * @option RightVertSlash
 * @option -
 * @option LeftMajor
 * @option RightMajor
 * @option -
 * @option LeftMinor
 * @option CenterMinor
 * @option RightMinor
 * @option -
 * @option LeftDiamond
 * @option CenterDiamond
 * @option RightDiamond
 * @option -
 * @option LeftGemstone
 * @option CenterGemstone
 * @option RightGemstone
 * @option -
 * @option TopLeftQuad
 * @option TopRightQuad
 * @option BottomLeftQuad
 * @option BottomRightQuad
 * @option -
 * @option TopLeftCorner
 * @option TopRightCorner
 * @option BottomLeftCorner
 * @option BottomRightCorner
 * @option -
 * @option Row1stThird
 * @option Row2ndThird
 * @option Row3rdThird
 * @option -
 * @option Row1stFourth
 * @option Row2ndFourth
 * @option Row3rdFourth
 * @option Row4thFourth
 * @option -
 * @option Row1stFifth
 * @option Row2ndFifth
 * @option Row3rdFifth
 * @option Row4thFifth
 * @option Row5thFifth
 * @option -
 * @option Col1stThird
 * @option Col2ndThird
 * @option Col3rdThird
 * @option -
 * @option Col1stFourth
 * @option Col2ndFourth
 * @option Col3rdFourth
 * @option Col4thFourth
 * @option -
 * @option Col1stFifth
 * @option Col2ndFifth
 * @option Col3rdFifth
 * @option Col4thFifth
 * @option Col5thFifth
 * @option -
 * @option SixPack1
 * @option SixPack2
 * @option SixPack3
 * @option SixPack4
 * @option SixPack5
 * @option SixPack6
 * @option -
 * @option EightPack1
 * @option EightPack2
 * @option EightPack3
 * @option EightPack4
 * @option EightPack5
 * @option EightPack6
 * @option EightPack7
 * @option EightPack8
 * @option -
 * @option TwelvePack1
 * @option TwelvePack2
 * @option TwelvePack3
 * @option TwelvePack4
 * @option TwelvePack5
 * @option TwelvePack6
 * @option TwelvePack7
 * @option TwelvePack8
 * @option TwelvePack9
 * @option TwelvePack10
 * @option TwelvePack11
 * @option TwelvePack12
 * @option -
 * @desc What Visual Cutin Effect style type do you wish to end?
 * @default CenterHorzSpan
 * 
 * @arg WaitForExit:eval
 * @text Wait For Exit
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait until cutin exit is finished before performing
 * the next event command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Cutin_WaitForEntrance
 * @text CUTIN: Wait for Cutin Entrance
 * @desc Wait until all cutin entrances are finished before performing the next event command. Requires VisuMZ_3_VisualCutinEffect!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Cutin_WaitForExit
 * @text CUTIN: Wait for Cutin Exit
 * @desc Wait until all cutin exits are finished before performing the next event command. Requires VisuMZ_3_VisualCutinEffect!
 *
 * @ --------------------------------------------------------------------------
 *
 *
 * @command ActionSequenceSpaceDragonbones
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreaDragonbones
 * @text Action Sequences - Dragonbones
 * @desc These Action Sequences are Dragonbones-related.
 * Requires VisuMZ_2_DragonbonesUnion!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_DB_DragonbonesMotionAni
 * @text DB: Dragonbones Animation
 * @desc Causes the unit(s) to play a Dragonbones motion animation.
 * Requires VisuMZ_2_DragonbonesUnion!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion animation.
 * @default ["user"]
 *
 * @arg MotionAni:str
 * @text Motion Animation
 * @desc What is the name of the Dragonbones motion animation you wish to play?
 * @default attack
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_DB_DragonbonesTimeScale
 * @text DB: Dragonbones Time Scale
 * @desc Causes the unit(s) to change their Dragonbones time scale.
 * Requires VisuMZ_2_DragonbonesUnion!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion animation.
 * @default ["user"]
 *
 * @arg TimeScale:num
 * @text Time Scale
 * @desc Change the value of the Dragonbones time scale to this.
 * @default 1.0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceElements
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakElements
 * @text Action Sequences - Elements
 * @desc These Action Sequences are related to elements.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_AddElements
 * @text ELE: Add Elements
 * @desc Adds element(s) to be used when calculating damage.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @arg Elements:arraynum
 * @text Elements
 * @type number[]
 * @min 1
 * @max 99
 * @desc Select which element ID to add onto the action.
 * Insert multiple element ID's to add multiple at once.
 * @default ["1"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_Clear
 * @text ELE: Clear Element Changes
 * @desc Clears all element changes made through Action Sequences.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_ForceElements
 * @text ELE: Force Elements
 * @desc Forces only specific element(s) when calculating damage.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @arg Elements:arraynum
 * @text Elements
 * @type number[]
 * @min 1
 * @max 99
 * @desc Select which element ID to force in the action.
 * Insert multiple element ID's to force multiple at once.
 * @default ["1"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_NullElements
 * @text ELE: Null Element
 * @desc Forces no element to be used when calculating damage.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceHorror
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakHorror
 * @text Action Sequences - Horror Effects
 * @desc These Action Sequences are Horror Effects-related.
 * Requires VisuMZ_2_HorrorEffects!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_Clear
 * @text HORROR: Clear All Filters
 * @desc Clear all Horror Effects filters on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove Horror Effects for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_GlitchCreate
 * @text HORROR: Glitch Create
 * @desc Creates the glitch effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create the Horror Effect for.
 * @default ["user"]
 *
 * @arg slices:num
 * @text Glitch Slices
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc Glitch slices to be used with the target.
 * @default 10
 *
 * @arg offset:num
 * @text Glitch Offset
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc Default offset value.
 * @default 100
 *
 * @arg animated:eval
 * @text Glitch Animated?
 * @parent FilterGlitch
 * @type boolean
 * @on Animate
 * @off Static
 * @desc Animate the glitch effect?
 * @default true
 *
 * @arg aniFrequency:num
 * @text Glitch Frequency
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc If animated, how frequent to make the glitch effect?
 * Lower = often     Higher = rarer
 * @default 300
 *
 * @arg aniStrength:num
 * @text Glitch Strength
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc If animated, how strong is the glitch effect?
 * Lower = weaker     Higher = stronger
 * @default 30
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_GlitchRemove
 * @text HORROR: Glitch Remove
 * @desc Removes the glitch effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove the Horror Effect for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_NoiseCreate
 * @text HORROR: Noise Create
 * @desc Creates the noise effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create the Horror Effect for.
 * @default ["user"]
 *
 * @arg noise:num
 * @text Noise Rate
 * @parent FilterNoise
 * @desc Noise rate to be used with the target.
 * @default 0.3
 *
 * @arg animated:eval
 * @text Noise Animated
 * @parent FilterNoise
 * @type boolean
 * @on Animate
 * @off Static
 * @desc Animate the noise for the target?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_NoiseRemove
 * @text HORROR: Noise Remove
 * @desc Removes the noise effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove the Horror Effect for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_TVCreate
 * @text HORROR: TV Create
 * @desc Creates the TV effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create the Horror Effect for.
 * @default ["user"]
 *
 * @arg lineWidth:num
 * @text TV Line Thickness
 * @parent FilterTV
 * @type number
 * @min 1
 * @desc Default TV line thickness
 * Lower = thinner     Higher = thicker
 * @default 5
 *
 * @arg vignetting:num
 * @text TV Corner Size
 * @parent FilterTV
 * @desc Default TV line corner size
 * Lower = smaller     Higher = bigger
 * @default 0.3
 *
 * @arg animated:eval
 * @text TV Animated
 * @parent FilterTV
 * @type boolean
 * @on Animate
 * @off Static
 * @desc Animate the TV?
 * @default true
 *
 * @arg aniSpeed:num
 * @text TV Speed
 * @parent FilterTV
 * @desc Speed used to animate the TV if animated
 * Lower = slower     Higher = faster
 * @default 0.25
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_TVRemove
 * @text HORROR: TV Remove
 * @desc Removes the TV effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove the Horror Effect for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceImpact
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakImpact
 * @text Action Sequences - Impact
 * @desc These Action Sequences are related to creating impact.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_BlueRedInvert
 * @text IMPACT: Bizarro Inversion
 * @desc Swaps blue/red colors on the battlefield.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Enable:eval
 * @text Bizarro?
 * @type boolean
 * @on Enable / Bizarro
 * @off Disable / Normal
 * @desc Enable Bizarro Inversion effect?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ColorBreak
 * @text IMPACT: Color Break
 * @desc Breaks the colors on the screen before reassembling.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Intensity:eval
 * @text Intensity
 * @desc What is the intensity of the color break effect?
 * @default 60
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the color break effect?
 * @default 60
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default OutBack
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_Desaturate
 * @text IMPACT: Desaturation
 * @desc Desaturates all colors on the battlefield.
 * Requires VisuMZ_3_ActSeqImpact! Created by Manu Gaming!
 *
 * @arg Enable:eval
 * @text Desaturate?
 * @type boolean
 * @on Enable / Desaturate
 * @off Disable / Normal
 * @desc Enable Desaturation effect?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionBlurScreen
 * @text IMPACT: Motion Blur Screen
 * @desc Creates a motion blur on the whole screen.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Angle:eval
 * @text Angle
 * @desc Determine what angle to make the motion blur at.
 * @default Math.randomInt(360)
 *
 * @arg Rate:eval
 * @text Intensity Rate
 * @desc This determines intensity rate of the motion blur.
 * Use a number between 0 and 1.
 * @default 0.1
 *
 * @arg Duration:num
 * @text Duration
 * @type number
 * @min 1
 * @desc How many frames should the motion blur last?
 * What do you want to be its duration?
 * @default 30
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionBlurTarget
 * @text IMPACT: Motion Blur Target(s)
 * @desc Creates a motion blur on selected target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create motion blur effects for.
 * @default ["user"]
 *
 * @arg Angle:eval
 * @text Angle
 * @desc Determine what angle to make the motion blur at.
 * @default Math.randomInt(360)
 *
 * @arg Rate:eval
 * @text Intensity Rate
 * @desc This determines intensity rate of the motion blur.
 * Use a number between 0 and 1.
 * @default 0.5
 *
 * @arg Duration:num
 * @text Duration
 * @type number
 * @min 1
 * @desc How many frames should the motion blur last?
 * What do you want to be its duration?
 * @default 30
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionTrailCreate
 * @text IMPACT: Motion Trail Create
 * @desc Creates a motion trail effect for the target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create motion trail effects for.
 * @default ["user"]
 *
 * @arg delay:num
 * @text Delay
 * @type number
 * @min 1
 * @desc How many frames to delay by when creating a motion trail?
 * The higher the delay, the less after images there are.
 * @default 1
 *
 * @arg duration:num
 * @text Duration
 * @type number
 * @min 1
 * @desc How many frames should the motion trail last?
 * What do you want to be its duration?
 * @default 30
 *
 * @arg hue:num
 * @text Hue
 * @type number
 * @min 0
 * @max 360
 * @desc What do you want to be the hue for the motion trail?
 * @default 0
 *
 * @arg opacityStart:num
 * @text Starting Opacity
 * @type number
 * @min 0
 * @max 255
 * @desc What starting opacity value do you want for the motion
 * trail? Opacity values decrease over time.
 * @default 200
 *
 * @arg tone:eval
 * @text Tone
 * @desc What tone do you want for the motion trail?
 * Format: [Red, Green, Blue, Gray]
 * @default [0, 0, 0, 0]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionTrailRemove
 * @text IMPACT: Motion Trail Remove
 * @desc Removes the motion trail effect from the target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to clear motion trail effects for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_Negative
 * @text IMPACT: Negative Inversion
 * @desc Inverts all the colors on the battlefield.
 * Requires VisuMZ_3_ActSeqImpact! Created by Manu Gaming!
 *
 * @arg Enable:eval
 * @text Negative?
 * @type boolean
 * @on Enable / Negative
 * @off Disable / Normal
 * @desc Enable negative inversion effect?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_Oversaturate
 * @text IMPACT: Oversaturation
 * @desc Oversaturates colors on the battlefield.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Enable:eval
 * @text Oversaturate?
 * @type boolean
 * @on Enable / Oversaturate
 * @off Disable / Normal
 * @desc Enable Oversaturation effect?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ShockwavePoint
 * @text IMPACT: Shockwave at Point
 * @desc Creates a shockwave at the designated coordinates.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Coordinates
 * 
 * @arg X:eval
 * @text Point: X
 * @parent Coordinates
 * @desc What x coordinate do you want to create a shockwave at?
 * You can use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @arg Y:eval
 * @text Point: Y
 * @parent Coordinates
 * @desc What y coordinate do you want to create a shockwave at?
 * You can use JavaScript code.
 * @default (Graphics.height - 200) / 2
 * 
 * @arg Amp:eval
 * @text Amplitude
 * @desc What is the aplitude of the shockwave effect?
 * @default 30
 * 
 * @arg Wave:eval
 * @text Wavelength
 * @desc What is the wavelength of the shockwave effect?
 * @default 160
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the shockwave?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ShockwaveEachTargets
 * @text IMPACT: Shockwave from Each Target(s)
 * @desc Creates a shockwave at each of the target(s) location(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to start a shockwave from.
 * @default ["all targets"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to start a shockwave from.
 * @default middle center
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave X point by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave Y point by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Amp:eval
 * @text Amplitude
 * @desc What is the aplitude of the shockwave effect?
 * @default 30
 * 
 * @arg Wave:eval
 * @text Wavelength
 * @desc What is the wavelength of the shockwave effect?
 * @default 160
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the shockwave?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ShockwaveCenterTargets
 * @text IMPACT: Shockwave from Target(s) Center
 * @desc Creates a shockwave from the center of the target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to start a shockwave from.
 * @default ["all targets"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to start a shockwave from.
 * @default middle center
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave X point by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave Y point by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Amp:eval
 * @text Amplitude
 * @desc What is the aplitude of the shockwave effect?
 * @default 30
 * 
 * @arg Wave:eval
 * @text Wavelength
 * @desc What is the wavelength of the shockwave effect?
 * @default 160
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the shockwave?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_TimeScale
 * @text IMPACT: Time Scale
 * @desc Adjust time to go faster or slower!
 * Requires VisuMZ_3_ActSeqImpact! Created by Manu Gaming!
 * 
 * @arg Scale:eval
 * @text Scale
 * @desc Adjusts how fast/slow time goes.
 * 1.00 is normal. Lower is slower. Higher is faster.
 * @default 1.00
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_TimeStop
 * @text IMPACT: Time Stop
 * @desc Stops time for a set amount of milliseconds.
 * Requires VisuMZ_3_ActSeqImpact! Created by Manu Gaming!
 * 
 * @arg ms:eval
 * @text Milliseconds
 * @desc How many milliseconds should time stop for?
 * 1000 milliseconds = 1 second.
 * @default 1000
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ZoomBlurPoint
 * @text IMPACT: Zoom Blur at Point
 * @desc Creates a zoom blur at the designated coordinates.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Coordinates
 * 
 * @arg X:eval
 * @text Point: X
 * @parent Coordinates
 * @desc What x coordinate do you want to focus the zoom at?
 * You can use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @arg Y:eval
 * @text Point: Y
 * @parent Coordinates
 * @desc What y coordinate do you want to focus the zoom at?
 * You can use JavaScript code.
 * @default (Graphics.height - 200) / 2
 * 
 * @arg Strength:eval
 * @text Zoom Strength
 * @desc What is the strength of the zoom effect?
 * Use a number between 0 and 1.
 * @default 0.5
 * 
 * @arg Radius:eval
 * @text Visible Radius
 * @desc How much of a radius should be visible from the center?
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the zoom blur?
 * @default 60
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default OutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ZoomBlurTargetCenter
 * @text IMPACT: Zoom Blur at Target(s) Center
 * @desc Creates a zoom blur at the center of targets.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to start a zoom blur from.
 * @default ["user"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to start a zoom blur from.
 * @default middle center
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @parent TargetLocation:str
 * @desc How much to offset the zoom blur X point by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @parent TargetLocation:str
 * @desc How much to offset the zoom blur Y point by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Strength:eval
 * @text Zoom Strength
 * @desc What is the strength of the zoom effect?
 * Use a number between 0 and 1.
 * @default 0.5
 * 
 * @arg Radius:eval
 * @text Visible Radius
 * @desc How much of a radius should be visible from the center?
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the zoom blur?
 * @default 60
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default OutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceInject
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakInject
 * @text Action Sequences - Inject
 * @desc These Action Sequences are related to injected animations.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Inject_AnimationStart
 * @text INJECT: Animation Begin
 * @desc Injects and plays a whole spritesheet animation.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to inject the animation on.
 * @default ["user"]
 * 
 * @arg Filename:str
 * @text Filename
 * @type file
 * @dir img/sv_actors/
 * @desc Select the animation spritesheet file.
 * Located in the /img/sv_actors/ folder.
 * @default Untitled
 *
 * @arg horzCells:num
 * @text Horizontal Cells
 * @parent Filename:str
 * @type number
 * @min 1
 * @desc How many horizontal cells (or columns) are there?
 * @default 1
 *
 * @arg vertCells:num
 * @text Vertical Cells
 * @parent Filename:str
 * @type number
 * @min 1
 * @desc How many vertical cells (or rows) are there?
 * @default 1
 *
 * @arg frameDelay:num
 * @text Frame Delay
 * @parent Filename:str
 * @type number
 * @min 1
 * @desc How many frames are played inbetween cells?
 * @default 1
 *
 * @arg smooth:eval
 * @text Smooth Bitmap?
 * @parent Filename:str
 * @type boolean
 * @on Smooth
 * @off Pixelated
 * @desc Smooth the spritesheet graphic?
 * @default false
 * 
 * @arg Offset
 *
 * @arg offsetX:eval
 * @text Offset X
 * @parent Offset
 * @desc Offsets the X position of the injected animation.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @arg offsetY:eval
 * @text Offset Y
 * @parent Offset
 * @desc Offsets the Y position of the injected animation.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Inject_AnimationEnd
 * @text INJECT: Animation End
 * @desc Stops and ends any injected animations on target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to stop injected animation(s).
 * @default ["user"]
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Inject_AnimationPauseResume
 * @text INJECT: Animation Pause/Resume
 * @desc Pauses/resumes any injected animations on target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to pause injected animation(s).
 * @default ["user"]
 *
 * @arg pause:eval
 * @text Pause?
 * @parent Filename:str
 * @type boolean
 * @on Pause
 * @off Resume
 * @desc Pause the injected animation?
 * @default true
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Inject_WaitForInjectAni
 * @text INJECT: Wait For Injected Animation
 * @desc Waits for injected animations to complete before performing
 * next command. Requires VisuMZ_3_ActSeqImpact!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceMechanics
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakMechanics
 * @text Action Sequences - Mechanics
 * @desc These Action Sequences are related to various mechanics
 * related to the battle system.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_ActionEffect
 * @text MECH: Action Effect
 * @desc Causes the unit(s) to take damage/healing from action and
 * incurs any changes made such as buffs and states.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_ActiveChainInputDisable
 * @text MECH: Active Chain Input Disable
 * @desc Disables input for Active Chain Skills at this time.
 * Requires VisuMZ_3_ActiveChainSkills!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AddBuffDebuff
 * @text MECH: Add Buff/Debuff
 * @desc Adds buff(s)/debuff(s) to unit(s). 
 * Determine which parameters are affected and their durations.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the buff(s) and/or debuff(s).
 * @default ["user"]
 * 
 * @arg Buffs:arraystr
 * @text Buff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which parameter(s) to buff.
 * Insert a parameter multiple times to raise its stacks.
 * @default ["ATK"]
 *
 * @arg Debuffs:arraystr
 * @text Debuff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which parameter(s) to debuff.
 * Insert a parameter multiple times to raise its stacks.
 * @default ["DEF"]
 * 
 * @arg Turns:eval
 * @text Turns
 * @desc Number of turns to set the parameter(s) buffs to.
 * You may use JavaScript code.
 * @default 5
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AddState
 * @text MECH: Add State
 * @desc Adds state(s) to unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the buff(s).
 * @default ["user"]
 * 
 * @arg States:arraynum
 * @text States
 * @type state[]
 * @desc Select which state ID(s) to add to unit(s).
 * Insert multiple state ID's to add multiple at once.
 * @default ["4"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AnalyzeWeakness
 * @text MECH: Analyze Weakness
 * @desc Reveal elemental weakness(es) from target(s).
 * Requires VisuMZ_3_WeaknessDisplay!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to reveal elemental weaknesses for.
 * @default ["all targets"]
 * 
 * @arg Reveal:eval
 * @text Reveal
 * @desc How many elemental weaknesses do you wish to reveal?
 * You may use JavaScript code.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_ArmorPenetration
 * @text MECH: Armor Penetration
 * @desc Adds an extra layer of defensive penetration/reduction.
 * You may use JavaScript code for any of these.
 *
 * @arg ArmorPenetration
 * @text Armor/Magic Penetration
 * 
 * @arg ArPenRate:eval
 * @text Rate
 * @parent ArmorPenetration
 * @desc Penetrates an extra multiplier of armor by this value.
 * @default 0.00
 * 
 * @arg ArPenFlat:eval
 * @text Flat
 * @parent ArmorPenetration
 * @desc Penetrates a flat amount of armor by this value.
 * @default 0
 *
 * @arg ArmorReduction
 * @text Armor/Magic Reduction
 * 
 * @arg ArRedRate:eval
 * @text Rate
 * @parent ArmorReduction
 * @desc Reduces an extra multiplier of armor by this value.
 * @default 0.00
 * 
 * @arg ArRedFlat:eval
 * @text Flat
 * @parent ArmorReduction
 * @desc Reduces a flat amount of armor by this value.
 * @default 0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AtbGauge
 * @text MECH: ATB Gauge
 * @desc Alters the ATB/TPB Gauges.
 * Requires VisuMZ_2_BattleSystemATB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the ATB/TPB Gauges for.
 * @default ["all targets"]
 *
 * @arg Charging
 * 
 * @arg ChargeRate:eval
 * @text Charge Rate
 * @parent Charging
 * @desc Changes made to the ATB Gauge if it is currently charging.
 * @default -0.00
 * 
 * @arg Casting
 * 
 * @arg CastRate:eval
 * @text Cast Rate
 * @parent Casting
 * @desc Changes made to the ATB Gauge if it is currently casting.
 * @default -0.00
 * 
 * @arg Interrupt:eval
 * @text Interrupt?
 * @parent Casting
 * @type boolean
 * @on Interrupt
 * @off Don't Interrupt
 * @desc Interrupt the ATB Gauge if it is currently casting?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BoostPointsChange
 * @text MECH: Boost Points Change
 * @desc Changes Boost Points for target(s).
 * Requires VisuMZ_3_BoostAction!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the Boost Points for.
 * @default ["user"]
 * 
 * @arg BoostPoints:eval
 * @text Alter Boost Points By
 * @desc Alters the unit(s) Boost Points.
 * Positive for gaining points. Negative for losing points.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BoostPointsStoreData
 * @text MECH: Boost Store Data
 * @desc Stores the number of Boosts used this action inside a variable.
 * Requires VisuMZ_3_BoostAction!
 * 
 * @arg VariableID:num
 * @text Variable ID
 * @type variable
 * @desc Which variable do you want to store the data inside?
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BreakShieldChange
 * @text MECH: Break Shield Change
 * @desc Changes Break Shields for target(s) if not Break Stunned.
 * Requires VisuMZ_4_BreakShields!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the Break Shields for.
 * @default ["all targets"]
 * 
 * @arg BreakShields:eval
 * @text Alter Break Shields By
 * @desc Alters the unit(s) Break Shields.
 * Positive for gaining shields. Negative for losing shields.
 * @default -1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BreakShieldReset
 * @text MECH: Break Shield Reset
 * @desc Resets Break Shields for target(s) if not Break Stunned.
 * Requires VisuMZ_4_BreakShields!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to reset the Break Shields for.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BtbGain
 * @text MECH: BTB Brave Points
 * @desc Alters the target(s) Brave Points to an exact value.
 * Requires VisuMZ_2_BattleSystemBTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the ATB/TPB Gauges for.
 * @default ["all targets"]
 * 
 * @arg BravePoints:eval
 * @text Alter Brave Points By
 * @desc Alters the target(s) Brave Points.
 * Positive for gaining BP. Negative for losing BP.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_Collapse
 * @text MECH: Collapse
 * @desc Causes the unit(s) to perform its collapse animation
 * if the unit(s) has died.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to process a death collapse.
 * @default ["all targets"]
 * 
 * @arg ForceDeath:eval
 * @text Force Death
 * @type boolean
 * @on On
 * @off Off
 * @desc Force death even if the unit has not reached 0 HP?
 * This will remove immortality.
 * @default false
 * 
 * @arg WaitForEffect:eval
 * @text Wait For Effect?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for the collapse effect to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_CtbOrder
 * @text MECH: CTB Order
 * @desc Alters the CTB Turn Order.
 * Requires VisuMZ_2_BattleSystemCTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the CTB Turn Order for.
 * @default ["all targets"]
 *
 * @arg ChangeOrderBy:eval
 * @text Change Order By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_CtbSpeed
 * @text MECH: CTB Speed
 * @desc Alters the CTB Speed.
 * Requires VisuMZ_2_BattleSystemCTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the CTB Speed for.
 * @default ["all targets"]
 *
 * @arg ChargeRate:eval
 * @text Charge Rate
 * @parent Charging
 * @desc Changes made to the CTB Speed if it is currently charging.
 * @default -0.00
 * 
 * @arg CastRate:eval
 * @text Cast Rate
 * @parent Casting
 * @desc Changes made to the CTB Speed if it is currently casting.
 * @default -0.00
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_CustomDmgFormula
 * @text MECH: Custom Damage Formula
 * @desc Changes the current action's damage formula to custom.
 * This will assume the MANUAL damage style.
 * 
 * @arg Formula:str
 * @text Formula
 * @desc Changes the current action's damage formula to custom.
 * Use 'default' to revert the damage formula.
 * @default default
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_DamagePopup
 * @text MECH: Damage Popup
 * @desc Causes the unit(s) to display the current state of
 * damage received or healed.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to prompt a damage popup.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_DeathBreak
 * @text MECH: Dead Label Jump
 * @desc If the active battler is dead, jump to a specific label in the common event.
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If the active battler is dead, jump to this specific label in the common event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EnemyEscape
 * @text MECH: Enemy Escape
 * @desc Causes the enemy unit(s) to escape.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to escape.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EtbAction
 * @text MECH: ETB Energy Count
 * @desc Alters the subject team's available Energy Count.
 * Requires VisuMZ_2_BattleSystemETB!
 * 
 * @arg ActionCount:eval
 * @text Energy Count
 * @desc Alters the subject team's available Energy Count.
 * Positive for gaining energy. Negative for losing energy.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_FtbAction
 * @text MECH: FTB Action Count
 * @desc Alters the subject team's available Action Count.
 * Requires VisuMZ_2_BattleSystemFTB!
 * 
 * @arg ActionCount:eval
 * @text Action Count
 * @desc Alters the subject team's available Action Count.
 * Positive for gaining actions. Negative for losing actions.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_HpMpTp
 * @text MECH: HP, MP, TP
 * @desc Alters the HP, MP, and TP values for unit(s).
 * Positive values for healing. Negative values for damage.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["user"]
 *
 * @arg HP
 * 
 * @arg HP_Rate:eval
 * @text HP Rate
 * @parent HP
 * @desc Changes made to HP based on rate.
 * Positive values for healing. Negative values for damage.
 * @default +0.00
 * 
 * @arg HP_Flat:eval
 * @text HP Flat
 * @parent HP
 * @desc Flat changes made to HP.
 * Positive values for healing. Negative values for damage.
 * @default +0
 * 
 * @arg MP
 * 
 * @arg MP_Rate:eval
 * @text MP Rate
 * @parent MP
 * @desc Changes made to MP based on rate.
 * Positive values for healing. Negative values for damage.
 * @default +0.00
 * 
 * @arg MP_Flat:eval
 * @text MP Flat
 * @parent MP
 * @desc Flat changes made to MP.
 * Positive values for healing. Negative values for damage.
 * @default +0
 *
 * @arg TP
 * 
 * @arg TP_Rate:eval
 * @text TP Rate
 * @parent TP
 * @desc Changes made to TP based on rate.
 * Positive values for healing. Negative values for damage.
 * @default +0.00
 * 
 * @arg TP_Flat:eval
 * @text TP Flat
 * @parent TP
 * @desc Flat changes made to TP.
 * Positive values for healing. Negative values for damage.
 * @default +0
 * 
 * @arg ShowPopup:eval
 * @text Damage Popup?
 * @type boolean
 * @on On
 * @off Off
 * @desc Display a damage popup after?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_Immortal
 * @text MECH: Immortal
 * @desc Changes the immortal flag of targets. If immortal flag is
 * removed and a unit would die, collapse that unit.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Alter the immortal flag of these groups. If immortal flag
 * is removed and a unit would die, collapse that unit.
 * @default ["user","all targets"]
 * 
 * @arg Immortal:eval
 * @text Immortal
 * @type boolean
 * @on On
 * @off Off
 * @desc Turn immortal flag for unit(s) on/off?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_Multipliers
 * @text MECH: Multipliers
 * @desc Changes the multipliers for the current action.
 * You may use JavaScript code for any of these.
 *
 * @arg CriticalHit
 * @text Critical Hit%
 * 
 * @arg CriticalHitRate:eval
 * @text Rate
 * @parent CriticalHit
 * @desc Affects chance to land a critical hit by this multiplier.
 * @default 1.00
 * 
 * @arg CriticalHitFlat:eval
 * @text Flat
 * @parent CriticalHit
 * @desc Affects chance to land a critical hit by this flat bonus.
 * @default +0.00
 *
 * @arg CriticalDmg
 * @text Critical Damage
 * 
 * @arg CriticalDmgRate:eval
 * @text Rate
 * @parent CriticalDmg
 * @desc Affects critical damage by this multiplier.
 * @default 1.00
 * 
 * @arg CriticalDmgFlat:eval
 * @text Flat
 * @parent CriticalDmg
 * @desc Affects critical damage by this flat bonus.
 * @default +0.00
 *
 * @arg Damage
 * @text Damage/Healing
 * 
 * @arg DamageRate:eval
 * @text Rate
 * @parent Damage
 * @desc Sets the damage/healing multiplier for current action.
 * @default 1.00
 * 
 * @arg DamageFlat:eval
 * @text Flat
 * @parent Damage
 * @desc Sets the damage/healing bonus for current action.
 * @default +0.00
 *
 * @arg HitRate
 * @text Hit Rate
 * 
 * @arg HitRate:eval
 * @text Rate
 * @parent HitRate
 * @desc Affects chance to connect attack by this multiplier.
 * @default 1.00
 * 
 * @arg HitFlat:eval
 * @text Flat
 * @parent HitRate
 * @desc Affects chance to connect attack by this flat bonus.
 * @default +0.00
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_OnceParallel
 * @text MECH: Once Parallel
 * @desc Plays a Common Event parallel to the battle event once
 * without repeating itself when done.
 *
 * @arg CommonEventID:num
 * @text Common Event ID
 * @type common_event
 * @desc The ID of the parallel Common Event to play.
 * Does NOT repeat itself when finished.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_OtbOrder
 * @text MECH: OTB Order
 * @desc Alters the OTB Turn Order. Best used with single targets.
 * Requires VisuMZ_2_BattleSystemOTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the OTB Turn Order for.
 * @default ["all targets"]
 *
 * @arg CurrentTurn:eval
 * @text Current Turn By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +0
 *
 * @arg NextTurn:eval
 * @text Next Turn By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +1
 *
 * @arg FollowTurn:eval
 * @text Follow Turn By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_PtbAlterCost
 * @text MECH: PTB Alter Cost
 * @desc Alters the action's cost settings.
 * Requires VisuMZ_2_BattleSystemPTB!
 *
 * @arg Override:eval
 * @text Override?
 * @type boolean
 * @on Override Permanent
 * @off Require Temporary
 * @desc Overrides any 'permanent' settings for Changeability?
 * @default false
 *
 * @arg alterChange:str
 * @text Alter Changeability
 * @type select
 * @option Unchanged - Cost type is unchanged after this effect
 * @value unchanged
 * @option Permanent - Cost type can no longer be changed after
 * @value permanent
 * @option Temporary - Cost type can still be changed after
 * @value temporary
 * @desc Allow the cost type and value to be changeable?
 * @default unchanged
 *
 * @arg alterType:str
 * @text Alter Cost Type
 * @type select
 * @option Unchanged - No changes are made
 * @value unchanged
 * @option Consume - Removes half, otherwise consumes full
 * @value consume
 * @option Convert - Converts full => half, otherwise consumes half
 * @value convert
 * @option Compress - Consumes half, otherwise converts full => half
 * @value compress
 * @desc Change the cost type to this scenario.
 * Use 'Unchanged' for no changes.
 * @default convert
 *
 * @arg alterCost:eval
 * @text Alter Cost Value
 * @desc What is the default action cost for this scenario?
 * @default +0
 *
 * @arg alterPriority:eval
 * @text Priority
 * @desc What is this scenario's priority? Scenario outcomes with
 * equal or lower priorities cannot override types and costs.
 * @default 50
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_PtbConvert
 * @text MECH: PTB Conversion
 * @desc Converts full actions into half actions.
 * Requires VisuMZ_2_BattleSystemPTB!
 * 
 * @arg ConvertCount:eval
 * @text Conversion Count
 * @desc Converts full actions into half actions.
 * If not enough, consume half actions.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_PtbFullHalfAction
 * @text MECH: PTB Full/Half Action(s)
 * @desc Alters the subject team's available Full/Half Actions.
 * Requires VisuMZ_2_BattleSystemPTB!
 * 
 * @arg FullActions:eval
 * @text Full Actions
 * @desc Alters the subject team's available Full Actions.
 * Positive for gaining. Negative for losing.
 * @default +0
 * 
 * @arg HalfActions:eval
 * @text Half Actions
 * @desc Alters the subject team's available Half Actions.
 * Positive for gaining. Negative for losing.
 * @default +0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_RemoveBuffDebuff
 * @text MECH: Remove Buff/Debuff
 * @desc Removes buff(s)/debuff(s) from unit(s). 
 * Determine which parameters are removed.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to have the buff(s) and/or debuff(s) removed.
 * @default ["user"]
 * 
 * @arg Buffs:arraystr
 * @text Buff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which buffed parameter(s) to remove.
 * @default ["MaxHP","MaxMP","ATK","DEF","MAT","MDF","AGI","LUK"]
 *
 * @arg Debuffs:arraystr
 * @text Debuff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which debuffed parameter(s) to remove.
 * @default ["MaxHP","MaxMP","ATK","DEF","MAT","MDF","AGI","LUK"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_RemoveState
 * @text MECH: Remove State
 * @desc Remove state(s) from unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to have states removed from.
 * @default ["user"]
 * 
 * @arg States:arraynum
 * @text States
 * @type state[]
 * @desc Select which state ID(s) to remove from unit(s).
 * Insert multiple state ID's to remove multiple at once.
 * @default ["4"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StbExploit
 * @text MECH: STB Exploit Effect
 * @desc Utilize the STB Exploitation mechanics!
 * Requires VisuMZ_2_BattleSystemSTB!
 * 
 * @arg Exploited:eval
 * @text Target(s) Exploited?
 * @type boolean
 * @on Exploit
 * @off Don't
 * @desc Exploit the below targets?
 * @default true
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to become exploited.
 * @default ["all targets"]
 * 
 * @arg ForceExploited:eval
 * @text Force Exploitation
 * @type boolean
 * @on Force
 * @off Don't
 * @desc Force the exploited status?
 * @default false
 * 
 * @arg Exploiter:eval
 * @text User Exploiter?
 * @type boolean
 * @on Exploit
 * @off Don't
 * @desc Allow the user to become the exploiter?
 * @default true
 * 
 * @arg ForceExploited:eval
 * @text Force Exploitation
 * @type boolean
 * @on Force
 * @off Don't
 * @desc Force the exploiter status?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StbExtraAction
 * @text MECH: STB Extra Action
 * @desc Adds an extra action for the currently active battler.
 * Requires VisuMZ_2_BattleSystemSTB!
 * 
 * @arg Actions:eval
 * @text Extra Actions
 * @parent Charging
 * @desc How many extra actions should the active battler gain?
 * You may use JavaScript code.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StbRemoveExcessActions
 * @text MECH: STB Remove Excess Actions
 * @desc Removes excess actions from the active battler.
 * Requires VisuMZ_2_BattleSystemSTB!
 * 
 * @arg Actions:eval
 * @text Remove Actions
 * @parent Charging
 * @desc How many actions to remove from the active battler?
 * You may use JavaScript code.
 * @default 99
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_SwapWeapon
 * @text MECH: Swap Weapon
 * @desc Causes the unit(s) to swap their weapon for another.
 * Requires VisuMZ_2_WeaponSwapSystem!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to swap weapons for.
 * @default ["user"]
 * 
 * @arg WeaponTypeID:eval
 * @text Weapon Type ID
 * @desc Which weapon type to swap to?
 * This is NOT the weapon's ID. It's the weapon TYPE.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_TextPopup
 * @text MECH: Text Popup
 * @desc Causes the unit(s) to display a text popup.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to prompt a text popup.
 * @default ["target"]
 * 
 * @arg Text:str
 * @text Text
 * @desc What text do you wish to display?
 * @default Text
 * 
 * @arg TextColor:str
 * @text Text Color
 * @parent Text:str
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default #ffffff
 *
 * @arg FlashColor:eval
 * @text Flash Color
 * @parent Popups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [255, 0, 0, 160]
 * 
 * @arg FlashDuration:num
 * @text Flash Duration
 * @parent FlashColor:eval
 * @type number
 * @desc What is the frame duration of the flash effect?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_VariablePopup
 * @text MECH: Variable Popup
 * @desc Causes the unit(s) to display a popup using the data
 * stored inside a variable.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to prompt a text popup.
 * @default ["target"]
 * 
 * @arg Variable:num
 * @text Variable ID
 * @type variable
 * @desc Get data from which variable to display as a popup?
 * @default 1
 * 
 * @arg DigitGrouping:eval
 * @text Digit Grouping
 * @parent Variable:num
 * @type boolean
 * @on Group Digits
 * @off Don't Group
 * @desc Use digit grouping to separate numbers?
 * Requires VisuMZ_0_CoreEngine!
 * @default true
 * 
 * @arg TextColor:str
 * @text Text Color
 * @parent Variable:num
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default #ffffff
 *
 * @arg FlashColor:eval
 * @text Flash Color
 * @parent Popups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [0, 0, 0, 0]
 * 
 * @arg FlashDuration:num
 * @text Flash Duration
 * @parent FlashColor:eval
 * @type number
 * @desc What is the frame duration of the flash effect?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_WaitForEffect
 * @text MECH: Wait For Effect
 * @desc Waits for the effects to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceMotion
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakMotion
 * @text Action Sequences - Motion
 * @desc These Action Sequences allow you the ability to control
 * the motions of sideview sprites.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_ClearFreezeFrame
 * @text MOTION: Clear Freeze Frame
 * @desc Clears any freeze frames from the unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to clear freeze frames for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_FreezeMotionFrame
 * @text MOTION: Freeze Motion Frame
 * @desc Forces a freeze frame instantly at the selected motion.
 * Automatically clears with a new motion.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to freeze motions for.
 * @default ["user"]
 *
 * @arg MotionType:str
 * @text Motion Type
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option attack
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Freeze this motion for the unit(s).
 * @default attack
 * 
 * @arg Frame:num
 * @text Frame Index
 * @desc Which frame do you want to freeze the motion on?
 * Frame index values start at 0.
 * @default 2
 *
 * @arg ShowWeapon:eval
 * @text Show Weapon?
 * @type combo
 * @type boolean
 * @on Show
 * @off Hide
 * @desc If using 'attack', 'thrust', 'swing', or 'missile',
 * display the weapon sprite?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_MotionType
 * @text MOTION: Motion Type
 * @desc Causes the unit(s) to play the selected motion.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion.
 * @default ["user"]
 *
 * @arg MotionType:str
 * @text Motion Type
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option attack
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default attack
 *
 * @arg ShowWeapon:eval
 * @text Show Weapon?
 * @type combo
 * @type boolean
 * @on Show
 * @off Hide
 * @desc If using 'attack', 'thrust', 'swing', or 'missile',
 * display the weapon sprite?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_PerformAction
 * @text MOTION: Perform Action
 * @desc Causes the unit(s) to play the proper motion based
 * on the current action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_RefreshMotion
 * @text MOTION: Refresh Motion
 * @desc Cancels any set motions unit(s) has to do and use
 * their most natural motion at the moment.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to refresh their motion state.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_WaitMotionFrame
 * @text MOTION: Wait By Motion Frame
 * @desc Creates a wait equal to the number of motion frames passing.
 * Time is based on Plugin Parameters => Actors => Motion Speed.
 *
 * @arg MotionFrameWait:num
 * @text Motion Frames to Wait?
 * @type number
 * @min 1
 * @desc Each "frame" is equal to the value found in
 * Plugin Parameters => Actors => Motion Speed
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceMovement
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakMovement
 * @text Action Sequences - Movement
 * @desc These Action Sequences allow you the ability to control
 * the sprites of actors and enemies in battle.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_BattleStep
 * @text MOVE: Battle Step
 * @desc Causes the unit(s) to move forward past their home position
 * to prepare for action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeMoveBy
 * @text MOVE: Change Home By Distance
 * @desc Change unit(s)'s home position by a distance from their
 * current home position(s). Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change home position(s) for.
 * @default ["user"]
 *
 * @arg DistanceAdjust:str
 * @text Distance Adjustment
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to distance values to determine
 * which direction to change by.
 * @default horz
 * 
 * @arg DistanceX:eval
 * @text Distance: X
 * @parent DistanceAdjust:str
 * @desc Horizontal distance to change home by.
 * You may use JavaScript code.
 * @default 48
 * 
 * @arg DistanceY:eval
 * @text Distance: Y
 * @parent DistanceAdjust:str
 * @desc Vertical distance to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total change amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeMoveToPoint
 * @text MOVE: Change Home To Point
 * @desc Change home position(s) to a target point on the screen.
 * Sideview-only! Points based off Graphics.boxWidth/Height.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change home position(s) for.
 * @default ["user"]
 * 
 * @arg Destination:str
 * @text Destination Point
 * @type combo
 * @option center
 * @option point x, y
 * @desc Select which point to face.
 * Replace 'x' and 'y' with coordinates
 * @default center
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Destination:str
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total change amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeMoveToTarget
 * @text MOVE: Change Home To Target(s)
 * @desc Moves unit(s) to another unit(s) on the battle field.
 * Sideview-only!
 * 
 * @arg Targets1:arraystr
 * @text Targets (Moving)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change home position(s) for.
 * @default ["user"]
 * 
 * @arg Targets2:arraystr
 * @text Targets (Destination)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change home position to.
 * @default ["all targets"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to change home position to.
 * @default front base
 * 
 * @arg MeleeDistance:eval
 * @text Melee Distance
 * @parent TargetLocation:str
 * @desc The melee distance away from the target location
 * in addition to the battler's width.
 * @default 24
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Targets2:arraystr
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total change amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FaceDirection
 * @text MOVE: Face Direction
 * @desc Causes the unit(s) to face forward or backward.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 * 
 * @arg Direction:str
 * @text Direction
 * @type combo
 * @option forward
 * @option backward
 * @option random
 * @desc Select which direction to face.
 * @default forward
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FacePoint
 * @text MOVE: Face Point
 * @desc Causes the unit(s) to face a point on the screen.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 * 
 * @arg Point:str
 * @text Point
 * @type combo
 * @option home
 * @option center
 * @option point x, y
 * @desc Select which point to face.
 * Replace 'x' and 'y' with coordinates
 * @default home
 * 
 * @arg FaceAway:eval
 * @text Face Away From?
 * @type boolean
 * @on Turn Away
 * @off Face Directly
 * @desc Face away from the point instead?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FaceTarget
 * @text MOVE: Face Target(s)
 * @desc Causes the unit(s) to face other targets on the screen.
 * Sideview-only!
 * 
 * @arg Targets1:arraystr
 * @text Targets (facing)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 * 
 * @arg Targets2:arraystr
 * @text Targets (destination)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) for the turning unit(s) to face.
 * @default ["current target"]
 * 
 * @arg FaceAway:eval
 * @text Face Away From?
 * @type boolean
 * @on Turn Away
 * @off Face Directly
 * @desc Face away from the unit(s) instead?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Float
 * @text MOVE: Float
 * @desc Causes the unit(s) to float above the ground.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to make float.
 * @default ["user"]
 * 
 * @arg Height:eval
 * @text Desired Height
 * @desc Vertical distance to float upward.
 * You may use JavaScript code.
 * @default 100
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total float amount.
 * @default 12
 *
 * @arg EasingType:str
 * @text Float Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForFloat:eval
 * @text Wait For Float?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for floating to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeReset
 * @text MOVE: Home Reset
 * @desc Causes the unit(s) to move back to their home position(s)
 * and face back to their original direction(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["alive battlers"]
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Jump
 * @text MOVE: Jump
 * @desc Causes the unit(s) to jump into the air.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to make jump.
 * @default ["user"]
 * 
 * @arg Height:eval
 * @text Desired Height
 * @desc Max jump height to go above the ground
 * You may use JavaScript code.
 * @default 100
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total jump amount.
 * @default 12
 * 
 * @arg WaitForJump:eval
 * @text Wait For Jump?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for jumping to complete before performing next command?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveBy
 * @text MOVE: Move Distance
 * @desc Moves unit(s) by a distance from their current position(s).
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 *
 * @arg DistanceAdjust:str
 * @text Distance Adjustment
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to distance values to determine
 * which direction to move unit(s).
 * @default horz
 * 
 * @arg DistanceX:eval
 * @text Distance: X
 * @parent DistanceAdjust:str
 * @desc Horizontal distance to move.
 * You may use JavaScript code.
 * @default 48
 * 
 * @arg DistanceY:eval
 * @text Distance: Y
 * @parent DistanceAdjust:str
 * @desc Vertical distance to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveToPoint
 * @text MOVE: Move To Point
 * @desc Moves unit(s) to a designated point on the screen.
 * Sideview-only! Points based off Graphics.boxWidth/Height.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 * 
 * @arg Destination:str
 * @text Destination Point
 * @type combo
 * @option home
 * @option center
 * @option point x, y
 * @desc Select which point to face.
 * Replace 'x' and 'y' with coordinates
 * @default home
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Destination:str
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveToTarget
 * @text MOVE: Move To Target(s)
 * @desc Moves unit(s) to another unit(s) on the battle field.
 * Sideview-only!
 * 
 * @arg Targets1:arraystr
 * @text Targets (Moving)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 * 
 * @arg Targets2:arraystr
 * @text Targets (Destination)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move to.
 * @default ["all targets"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to move to.
 * @default front base
 * 
 * @arg MeleeDistance:eval
 * @text Melee Distance
 * @parent TargetLocation:str
 * @desc The melee distance away from the target location
 * in addition to the battler's width.
 * @default 24
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Targets2:arraystr
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Opacity
 * @text MOVE: Opacity
 * @desc Causes the unit(s) to change opacity.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change opacity.
 * @default ["user"]
 * 
 * @arg Opacity:eval
 * @text Desired Opacity
 * @desc Change to this opacity value.
 * You may use JavaScript code.
 * @default 255
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for opacity change.
 * @default 12
 *
 * @arg EasingType:str
 * @text Opacity Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForOpacity:eval
 * @text Wait For Opacity?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for opacity changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Scale
 * @text MOVE: Scale/Grow/Shrink
 * @desc Causes the unit(s) to scale, grow, or shrink?.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change the scale of.
 * @default ["user"]
 * 
 * @arg ScaleX:eval
 * @text Scale X
 * @desc What target scale value do you want?
 * 1.0 is normal size.
 * @default 1.00
 * 
 * @arg ScaleY:eval
 * @text Scale Y
 * @desc What target scale value do you want?
 * 1.0 is normal size.
 * @default 1.00
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to scale for.
 * @default 12
 *
 * @arg EasingType:str
 * @text Scale Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForScale:eval
 * @text Wait For Scale?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for scaling to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Skew
 * @text MOVE: Skew/Distort
 * @desc Causes the unit(s) to skew.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to skew.
 * @default ["user"]
 * 
 * @arg SkewX:eval
 * @text Skew X
 * @desc X variance to skew?
 * Use small values for the best results.
 * @default 0.00
 * 
 * @arg SkewY:eval
 * @text Skew Y
 * @desc Y variance to skew?
 * Use small values for the best results.
 * @default 0.00
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to skew for.
 * @default 12
 *
 * @arg EasingType:str
 * @text Skew Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForSkew:eval
 * @text Wait For Skew?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for skew to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Spin
 * @text MOVE: Spin/Rotate
 * @desc Causes the unit(s) to spin.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to spin.
 * @default ["user"]
 * 
 * @arg Angle:eval
 * @text Angle
 * @desc How many degrees to spin?
 * @default 360
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to spin for.
 * @default 12
 *
 * @arg EasingType:str
 * @text Spin Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg RevertAngle:eval
 * @text Revert Angle on Finish
 * @type boolean
 * @on Revert
 * @off Don't
 * @desc Revert angle after spinning?
 * @default true
 * 
 * @arg WaitForSpin:eval
 * @text Wait For Spin?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for spin to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForFloat
 * @text MOVE: Wait For Float
 * @desc Waits for floating to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForJump
 * @text MOVE: Wait For Jump
 * @desc Waits for jumping to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForMovement
 * @text MOVE: Wait For Movement
 * @desc Waits for movement to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForOpacity
 * @text MOVE: Wait For Opacity
 * @desc Waits for opacity changes to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForScale
 * @text MOVE: Wait For Scale
 * @desc Waits for scaling to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForSkew
 * @text MOVE: Wait For Skew
 * @desc Waits for skewing to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForSpin
 * @text MOVE: Wait For Spin
 * @desc Waits for spinning to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceProjectile
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakProjectile
 * @text Action Sequences - Projectiles
 * @desc Create projectiles on the screen and fire them off at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Projectile_Animation
 * @text PROJECTILE: Animation
 * @desc Create an animation projectile and fire it at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * @arg Coordinates
 *
 * @arg Start:struct
 * @text Start Location
 * @parent Coordinates
 * @type struct<ProjectileStart>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"user\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 *
 * @arg Goal:struct
 * @text Goal Location
 * @parent Coordinates
 * @type struct<ProjectileGoal>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"all targets\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 * 
 * @arg Settings
 *
 * @arg AnimationID:num
 * @text Animation ID
 * @parent Settings
 * @type animation
 * @desc Determine which animation to use as a projectile.
 * @default 77
 * 
 * @arg Duration:eval
 * @text Duration
 * @parent Settings
 * @desc Duration for the projectile(s) to travel.
 * @default 20
 * 
 * @arg WaitForProjectile:eval
 * @text Wait For Projectile?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for projectile(s) to reach their destination before
 * going onto the next command?
 * @default true
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to finish before going to the next command?
 * @default false
 * 
 * @arg Extra:struct
 * @text Extra Settings
 * @type struct<ProjectileExAni>
 * @desc Add extra settings to the projectile?
 * @default {"AutoAngle:eval":"true","AngleOffset:eval":"+0","Arc:eval":"0","EasingType:str":"Linear","Spin:eval":"+0.0"}
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Projectile_Icon
 * @text PROJECTILE: Icon
 * @desc Create an icon projectile and fire it at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * @arg Coordinates
 *
 * @arg Start:struct
 * @text Start Location
 * @parent Coordinates
 * @type struct<ProjectileStart>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"user\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 *
 * @arg Goal:struct
 * @text Goal Location
 * @parent Coordinates
 * @type struct<ProjectileGoal>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"all targets\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 * 
 * @arg Settings
 *
 * @arg Icon:eval
 * @text Icon Index
 * @parent Settings
 * @desc Determine which icon to use as a projectile.
 * You may use JavaScript code.
 * @default 118
 * 
 * @arg Duration:eval
 * @text Duration
 * @parent Settings
 * @desc Duration for the projectile(s) to travel.
 * @default 20
 * 
 * @arg WaitForProjectile:eval
 * @text Wait For Projectile?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for projectile(s) to reach their destination before
 * going onto the next command?
 * @default true
 * 
 * @arg Extra:struct
 * @text Extra Settings
 * @type struct<ProjectileExtra>
 * @desc Add extra settings to the projectile?
 * @default {"AutoAngle:eval":"true","AngleOffset:eval":"+0","Arc:eval":"0","BlendMode:num":"0","EasingType:str":"Linear","Hue:eval":"0","Scale:eval":"1.0","Spin:eval":"+0.0"}
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Projectile_Picture
 * @text PROJECTILE: Picture
 * @desc Create a picture projectile and fire it at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * @arg Coordinates
 *
 * @arg Start:struct
 * @text Start Location
 * @parent Coordinates
 * @type struct<ProjectileStart>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"user\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 *
 * @arg Goal:struct
 * @text Goal Location
 * @parent Coordinates
 * @type struct<ProjectileGoal>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"all targets\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 * 
 * @arg Settings
 *
 * @arg Picture:str
 * @text Picture Filename
 * @parent Settings
 * @type file
 * @dir img/pictures/
 * @desc Determine which picture to use as a projectile.
 * @default Untitled
 * 
 * @arg Duration:eval
 * @text Duration
 * @parent Settings
 * @desc Duration for the projectile(s) to travel.
 * @default 20
 * 
 * @arg WaitForProjectile:eval
 * @text Wait For Projectile?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for projectile(s) to reach their destination before
 * going onto the next command?
 * @default true
 * 
 * @arg Extra:struct
 * @text Extra Settings
 * @type struct<ProjectileExtra>
 * @desc Add extra settings to the projectile?
 * @default {"AutoAngle:eval":"true","AngleOffset:eval":"+0","Arc:eval":"0","BlendMode:num":"0","EasingType:str":"Linear","Hue:eval":"0","Scale:eval":"1.0","Spin:eval":"+0.0"}
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceSkew
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakSkew
 * @text Action Sequences - Skew
 * @desc Allows you to have control over the camera skew.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_ChangeSkew
 * @text SKEW: Change Skew
 * @desc Changes the camera skew.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg SkewX:eval
 * @text Skew X
 * @desc Change the camera skew X to this value.
 * @default 0
 * 
 * @arg SkewY:eval
 * @text Skew Y
 * @desc Change the camera skew Y to this value.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to change camera skew.
 * @default 60
 *
 * @arg EasingType:str
 * @text Skew Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForSkew:eval
 * @text Wait For Skew?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for skew changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Skew_Reset
 * @text SKEW: Reset Skew
 * @desc Reset any skew settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to reset camera skew.
 * @default 60
 *
 * @arg EasingType:str
 * @text Skew Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForSkew:eval
 * @text Wait For Skew?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for skew changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Skew_WaitForSkew
 * @text SKEW: Wait For Skew
 * @desc Waits for skew changes to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceTarget
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakTarget
 * @text Action Sequences - Target
 * @desc If using a manual target by target Action Sequence,
 * these commands will give you full control over its usage.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_CurrentIndex
 * @text TARGET: Current Index
 * @desc Sets the current index to this value.
 * Then decide to jump to a label (optional).
 * 
 * @arg Index:eval
 * @text Set Index To
 * @desc Sets current targeting index to this value.
 * 0 is the starting index of a target group.
 * @default 0
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_NextTarget
 * @text TARGET: Next Target
 * @desc Moves index forward by 1 to select a new current target.
 * Then decide to jump to a label (optional).
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_PrevTarget
 * @text TARGET: Previous Target
 * @desc Moves index backward by 1 to select a new current target.
 * Then decide to jump to a label (optional).
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_RandTarget
 * @text TARGET: Random Target
 * @desc Sets index randomly to determine new currernt target.
 * Then decide to jump to a label (optional).
 * 
 * @arg ForceRandom:eval
 * @text Force Random?
 * @type boolean
 * @on On
 * @off Off
 * @desc Index cannot be its previous index amount after random.
 * @default false
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceWeapon
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakWeapon
 * @text Action Sequences - Weapon
 * @desc Allows for finer control over Dual/Multi Wielding actors.
 * Only works for Actors.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Weapon_ClearActiveWeapon
 * @text WEAPON: Clear Weapon Slot
 * @desc Clears the active weapon slot (making others valid again).
 * Only works for Actors.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @desc Select unit(s) to clear the active weapon slot for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Weapon_NextActiveWeapon
 * @text WEAPON: Next Weapon Slot
 * @desc Goes to next active weapon slot (making others invalid).
 * If next slot is weaponless, don't label jump.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @desc Select unit(s) to change the next active weapon slot for.
 * @default ["user"]
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a weapon is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Weapon_SetActiveWeapon
 * @text WEAPON: Set Weapon Slot
 * @desc Sets the active weapon slot (making others invalid).
 * Only works for Actors.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @desc Select unit(s) to change the active weapon slot for.
 * @default ["user"]
 * 
 * @arg SlotID:eval
 * @text Weapon Slot ID
 * @desc Select weapon slot to make active (making others invalid).
 * Use 0 to clear and normalize. You may use JavaScript code.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceZoom
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakZoom
 * @text Action Sequences - Zoom
 * @desc Allows you to have control over the screen zoom.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Zoom_Scale
 * @text ZOOM: Change Scale
 * @desc Changes the zoom scale.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Scale:eval
 * @text Scale
 * @desc The zoom scale to change to.
 * @default 1.0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to change battle zoom.
 * @default 60
 *
 * @arg EasingType:str
 * @text Zoom Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForZoom:eval
 * @text Wait For Zoom?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for zoom changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Zoom_Reset
 * @text ZOOM: Reset Zoom
 * @desc Reset any zoom settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to reset battle zoom.
 * @default 60
 *
 * @arg EasingType:str
 * @text Zoom Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForZoom:eval
 * @text Wait For Zoom?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for zoom changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Zoom_WaitForZoom
 * @text ZOOM: Wait For Zoom
 * @desc Waits for zoom to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceEnd
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param BattleCore
 * @default Plugin Parameters
 *
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param AutoBattle:struct
 * @text Auto Battle Settings
 * @type struct<AutoBattle>
 * @desc Settings pertaining to Auto Battle.
 * @default {"BattleDisplay":"","AutoBattleMsg:str":"Press %1 or %2 to stop Auto Battle","AutoBattleOK:str":"OK","AutoBattleCancel:str":"Cancel","AutoBattleBgType:num":"1","AutoBattleRect:func":"\"const width = Graphics.width;\\nconst height = this.calcWindowHeight(1, false);\\nconst x = 0;\\nconst y = (Graphics.height - height) / 2;\\nreturn new Rectangle(x, y, width, height);\"","Options":"","AddOption:eval":"true","AdjustRect:eval":"true","StartName:str":"Auto Battle Start","StyleName:str":"Auto Battle Style","StyleOFF:str":"Attack","StyleON:str":"Skills"}
 *
 * @param Damage:struct
 * @text Damage Settings
 * @type struct<Damage>
 * @desc Settings pertaining to damage calculations.
 * @default {"DamageStyles":"","DefaultDamageStyle:str":"Standard","DamageStyleList:arraystruct":"[\"{\\\"Name:str\\\":\\\"Standard\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Declare Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Replace Formula\\\\\\\\nlet formula = item.damage.formula;\\\\\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 0)';\\\\\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nlet value = Math.max(eval(formula), 0);\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"return this.getItemDamageAmountTextOriginal();\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"Armor Scaling\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Declare Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Replace Formula\\\\\\\\nlet formula = item.damage.formula;\\\\\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 1)';\\\\\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nlet value = Math.max(eval(formula), 0);\\\\\\\\n\\\\\\\\n// Apply Defender's Defense Parameter\\\\\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\\\\\n\\\\\\\\n    // Calculate Base Armor\\\\\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\\\\\n\\\\\\\\n    // Apply Armor to Damage\\\\\\\\n    if (armor >= 0) {\\\\\\\\n        value *= 100 / (100 + armor);\\\\\\\\n    } else {\\\\\\\\n        value *= 2 - (100 / (100 - armor));\\\\\\\\n    }\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"return this.getItemDamageAmountTextOriginal();\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"CT\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet value = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\\\\\nlet attackStat = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat =  a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nattackStat = (attackStat * 1.75) + (level ** 2 / 45.5);\\\\\\\\nvalue = attackStat * 4;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= Math.max(256 - armor, 0) / 256;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= Math.max(102.4 - armor, 0) / 128;\\\\\\\\n}\\\\\\\\nvalue *= multiplier;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"D4\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nlet stat = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    stat = a.def;\\\\\\\\n    armor = 0;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    stat = a.mdf;\\\\\\\\n    armor = 0;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage \\\\\\\\nlet value = 1.5 * Math.max(2 * stat * multiplier - armor, 1) * multiplier / 5;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"DQ\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nlet multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\nif (this.isCertainHit()) {\\\\\\\\n    let value = multiplier * Math.max(a.atk, a.mat);\\\\\\\\n    return (isNaN(value) ? 0 : value) * sign;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Get Primary Stats\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(b, armor);\\\\\\\\nlet stat = 1;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    stat = a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    stat = a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Check for Recovery\\\\\\\\nif (this.isRecover()) {\\\\\\\\n    let value = stat * multiplier * sign;\\\\\\\\n    return isNaN(value) ? 0 : value;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nlet value = 0;\\\\\\\\nif (stat < ((2 + armor) / 2)) {\\\\\\\\n    // Plink Damage\\\\\\\\n    let baseline = Math.max(stat - ((12 * (armor - stat + 1)) / stat), 5);\\\\\\\\n    value = baseline / 3;\\\\\\\\n} else {\\\\\\\\n    // Normal Damage\\\\\\\\n    let baseline = Math.max(stat - (armor / 2), 1);\\\\\\\\n    value = baseline / 2;\\\\\\\\n}\\\\\\\\nvalue *= multiplier;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF7\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Power\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare base Damage\\\\\\\\nlet baseDamage = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    baseDamage = a.atk + ((a.atk + level) / 32) * ((a.atk * level) / 32);\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    baseDamage = 6 * (a.mat + level);\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    baseDamage = 6 * (a.def + level);\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    baseDamage = 6 * (a.mdf + level);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Final Damage\\\\\\\\nlet value = baseDamage;\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nif (this.isRecover()) {\\\\\\\\n    value += 22 * power;\\\\\\\\n} else {\\\\\\\\n    value = (power * Math.max(512 - armor, 1) * baseDamage) / (16 * 512);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF8\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Power\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Damage\\\\\\\\nlet Value = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = a.atk ** 2 / 16 + a.atk;\\\\\\\\n    value *= Math.max(265 - armor, 1) / 256;\\\\\\\\n    value *= power / 16;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = a.mat + power;\\\\\\\\n    value *= Math.max(265 - armor, 1) / 4;\\\\\\\\n    value *= power / 256;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value = (power + a.def) * power / 2;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value = (power + a.mdf) * power / 2;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF9\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Damage Constant\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\nif (this.isCertainHit()) {\\\\\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Declare Main Stats\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(b, armor);\\\\\\\\nlet stat = 1;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    stat = a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    stat = a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Declare Base Damage\\\\\\\\nlet baseDamage = power;\\\\\\\\nif (this.isPhysical()) {\\\\\\\\n    baseDamage += stat;\\\\\\\\n}\\\\\\\\nif (this.isDamage() || this.isDrain()) {\\\\\\\\n    baseDamage -= armor;\\\\\\\\n    baseDamage = Math.max(1, baseDamage);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Declare Bonus Damage\\\\\\\\nlet bonusDamage = stat + (((a.level || a.luk) + stat) / 8);\\\\\\\\n\\\\\\\\n// Declare Final Damage\\\\\\\\nlet value = baseDamage * bonusDamage * sign;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF10\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Damage Constant\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\nif (this.isCertainHit()) {\\\\\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Create Damage Offense Value\\\\\\\\nlet value = power;\\\\\\\\n\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = (((a.atk ** 3) / 32) + 32) * power / 16;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = power * ((a.mat ** 2 / 6) + power) / 4;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value = power * ((a.def + power) / 2);\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value = power * ((a.mdf + power) / 2);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Apply Damage Defense Value\\\\\\\\nif (this.isDamage() || this.isDrain()) {\\\\\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\n    armor = this.applyArmorModifiers(b, armor);\\\\\\\\n    armor = Math.max(armor, 1);\\\\\\\\n    value *= ((((armor - 280.4) ** 2) / 110) / 16) / 730;\\\\\\\\n    value *= (730 - (armor * 51 - (armor ** 2) / 11) / 10) / 730;\\\\\\\\n} else if (this.isRecover()) {\\\\\\\\n    value *= -1;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"MK\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nconst denominator = Math.max(200 + armor, 1);\\\\\\\\n\\\\\\\\n// Calculate Damage \\\\\\\\nlet value = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = 200 * a.atk / denominator;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = 200 * a.mat / denominator;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value = 200 * a.def / 200;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value = 200 * a.mdf / 200;\\\\\\\\n}\\\\\\\\nvalue *= multiplier;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"MOBA\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Damage Value\\\\\\\\nlet value = Math.max(eval(item.damage.formula), 0) * sign;\\\\\\\\n\\\\\\\\n// Apply Attacker's Offense Parameter\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value *= a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value *= a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Apply Defender's Defense Parameter\\\\\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\\\\\n\\\\\\\\n    // Calculate Base Armor\\\\\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\\\\\n\\\\\\\\n    // Apply Armor to Damage\\\\\\\\n    if (armor >= 0) {\\\\\\\\n        value *= 100 / (100 + armor);\\\\\\\\n    } else {\\\\\\\\n        value *= 2 - (100 / (100 - armor));\\\\\\\\n    }\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"PKMN\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Power\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet value = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\\\\\nlet attackStat = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat =  a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nvalue = (((((2 * level) / 5) + 2) * power * (attackStat / armor)) / 50) + 2;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\"]","Cap":"","EnableDamageCap:eval":"false","DefaultHardCap:num":"9999","EnableSoftCap:eval":"false","DefaultSoftCap:num":"0.80","DefaultSoftScaler:num":"0.1275","Popups":"","PopupDuration:num":"128","NewPopupBottom:eval":"true","PopupPosition:str":"base","PopupOffsetX:num":"0","PopupOffsetY:num":"0","PopupShiftX:num":"8","PopupShiftY:num":"-28","hpDamageFmt:str":"-%1","hpHealingFmt:str":"+%1","mpDamageFmt:str":"-%1 %2","mpHealingFmt:str":"+%1 %2","CriticalColor:eval":"[255, 0, 0, 160]","CriticalDuration:num":"128","Formulas":"","OverallFormulaJS:func":"\"// Declare Constants\\nconst target = arguments[0];\\nconst critical = arguments[1];\\nconst item = this.item();\\n\\n// Get Base Damage\\nconst baseValue = this.evalDamageFormula(target);\\n\\n// Calculate Element Modifiers\\nlet value = baseValue * this.calcElementRate(target);\\n\\n// Calculate Physical and Magical Modifiers\\nif (this.isPhysical()) {\\n    value *= target.pdr;\\n}\\nif (this.isMagical()) {\\n    value *= target.mdr;\\n}\\n\\n// Apply Healing Modifiers\\nif (baseValue < 0) {\\n    value *= target.rec;\\n}\\n\\n// Apply Critical Modifiers\\nif (critical) {\\n    value = this.applyCritical(value);\\n}\\n\\n// Apply Variance and Guard Modifiers\\nvalue = this.applyVariance(value, item.damage.variance);\\nvalue = this.applyGuard(value, target);\\n\\n// Finalize Damage\\nvalue = Math.round(value);\\nreturn value;\"","VarianceFormulaJS:func":"\"// Declare Constants\\nconst damage = arguments[0];\\nconst variance = arguments[1];\\n\\n// Calculate Variance\\nconst amp = Math.floor(Math.max((Math.abs(damage) * variance) / 100, 0));\\nconst v = Math.randomInt(amp + 1) + Math.randomInt(amp + 1) - amp;\\n\\n// Return Damage\\nreturn damage >= 0 ? damage + v : damage - v;\"","GuardFormulaJS:func":"\"// Declare Constants\\nconst damage = arguments[0];\\nconst target = arguments[1];\\n\\n// Return Damage Early\\nconst note = this.item().note;\\nif (note.match(/<UNBLOCKABLE>/i)) return damage;\\nif (!target.isGuard()) return damage;\\nif (damage < 0) return damage;\\n\\n// Declare Guard Rate\\nlet guardRate = 0.5;\\nguardRate /= target.grd;\\n\\n// Return Damage\\nreturn damage * guardRate;\"","Critical":"","CriticalHitRateJS:func":"\"// Declare Constants\\nconst user = this.subject();\\nconst target = arguments[0];\\n\\n// Create Base Critical Rate\\nlet rate = this.subject().cri * (1 - target.cev);\\n\\n// Apply Notetags\\nconst note = this.item().note;\\nif (note.match(/<ALWAYS CRITICAL>/i)) {\\n    return 1;\\n}\\nif (note.match(/<SET CRITICAL RATE:[ ](\\\\d+)([%％])>/i)) {\\n    return Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL RATE:[ ](\\\\d+)([%％])>/i)) {\\n    rate *= Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL RATE:[ ]([\\\\+\\\\-]\\\\d+)([%％])>/i)) {\\n    rate += Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<JS CRITICAL RATE>\\\\s*([\\\\s\\\\S]*)\\\\s*<\\\\/JS CRITICAL RATE>/i)) {\\n    const code = String(RegExp.$1);\\n    try {\\n        eval(code);\\n    } catch (e) {\\n        if ($gameTemp.isPlaytest()) console.log(e);\\n    }\\n}\\n\\n// Apply LUK Buffs/Debuffs\\nconst lukStack = this.subject().buff(7);\\nrate *= 2 ** lukStack;\\n\\n// Return Rate\\nreturn rate;\"","CriticalHitMultiplier:func":"\"// Declare Constants\\nconst user = this.subject();\\nlet damage = arguments[0];\\nlet multiplier = 2.0;\\nlet bonusDamage = this.subject().luk * this.subject().cri;\\nif (this.isHpRecover() || this.isMpRecover()) {\\n    bonusDamage *= -1;\\n}\\n\\n// Apply Notetags\\nconst note = this.item().note;\\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ](\\\\d+)([%％])>/i)) {\\n    multiplier = Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ]([\\\\+\\\\-]\\\\d+)([%％])>/i)) {\\n    multiplier += Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ](\\\\d+)([%％])>/i)) {\\n    bonusDamage *= Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ]([\\\\+\\\\-]\\\\d+)([%％])>/i)) {\\n    bonusDamage += bonusDamage * (RegExp.$1) / 100;\\n}\\nif (note.match(/<JS CRITICAL DAMAGE>\\\\s*([\\\\s\\\\S]*)\\\\s*<\\\\/JS CRITICAL DAMAGE>/i)) {\\n    const code = String(RegExp.$1);\\n    try {\\n        eval(code);\\n    } catch (e) {\\n        if ($gameTemp.isPlaytest()) console.log(e);\\n    }\\n}\\n\\n// Return Damage\\nreturn damage * multiplier + bonusDamage;\""}
 *
 * @param Mechanics:struct
 * @text Mechanics Settings
 * @type struct<Mechanics>
 * @desc Settings pertaining to various game mechanics.
 * @default {"ActionSpeed":"","AllowRandomSpeed:eval":"false","CalcActionSpeedJS:func":"\"// Declare Constants\\nconst agi = this.subject().agi;\\n\\n// Create Speed\\nlet speed = agi;\\nif (this.allowRandomSpeed()) {\\n    speed += Math.randomInt(Math.floor(5 + agi / 4));\\n}\\nif (this.item()) {\\n    speed += this.item().speed;\\n}\\nif (this.isAttack()) {\\n    speed += this.subject().attackSpeed();\\n}\\n\\n// Return Speed\\nreturn speed;\"","BaseTroop":"","BaseTroopIDs:arraynum":"[\"1\"]","CommonEvents":"","BattleStartEvent:num":"0","BattleEndEvent:num":"0","VictoryEvent:num":"0","DefeatEvent:num":"0","EscapeSuccessEvent:num":"0","EscapeFailEvent:num":"0","Escape":"","CalcEscapeRatioJS:func":"\"// Calculate Escape Ratio\\nlet ratio = 0.5;\\nratio *= $gameParty.agility();\\nratio /= $gameTroop.agility();\\n\\n// Return Ratio\\nreturn ratio;\"","CalcEscapeRaiseJS:func":"\"// Calculate Escape Ratio\\nlet value = 0.1;\\nvalue += $gameParty.aliveMembers().length;\\n\\n// Return Value\\nreturn value;\"","BattleJS":"","PreStartBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostStartBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","BattleVictoryJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","EscapeSuccessJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","EscapeFailureJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","BattleDefeatJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PreEndBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostEndBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","TurnJS":"","PreStartTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostStartTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PreEndTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostEndTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PreRegenerateJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostRegenerateJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","ActionJS":"","PreStartActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\"","PostStartActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\"","PreApplyJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PreDamageJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PostDamageJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PostApplyJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PreEndActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\"","PostEndActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\""}
 *
 * @param CmdWindows
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param BattleLayout:struct
 * @text Battle Layout Settings
 * @type struct<BattleLayout>
 * @desc Settings that adjust how the battle layout appears.
 * @default {"Style:str":"default","ListStyle":"","ShowFacesListStyle:eval":"true","CommandWidth:num":"192","XPStyle":"","XPActorCommandLines:num":"4","XPActorDefaultHeight:num":"64","XPSpriteYLocation:str":"name","PotraitStyle":"","ShowPortraits:eval":"true","PortraitScale:num":"0.5","BorderStyle":"","SkillItemBorderCols:num":"1","ShowPortraitsBorderStyle:eval":"true","PortraitScaleBorderStyle:num":"1.25","SkillItemWindows":"","SkillItemMiddleLayout:eval":"false","SkillItemStandardCols:num":"2"}
 *
 * @param BattleLog:struct
 * @text Battle Log Settings
 * @type struct<BattleLog>
 * @desc Settings that adjust how Window_BattleLog behaves.
 * @default {"General":"","BackColor:str":"#000000","MaxLines:num":"10","MessageWait:num":"16","TextAlign:str":"center","BattleLogRectJS:func":"\"const wx = 0;\\nconst wy = 0;\\nconst ww = Graphics.boxWidth;\\nconst wh = this.calcWindowHeight(10, false);\\nreturn new Rectangle(wx, wy, ww, wh);\"","StartTurn":"","StartTurnShow:eval":"true","StartTurnMsg:str":"Turn %1","StartTurnWait:num":"40","DisplayAction":"","ActionCenteredName:eval":"true","ActionSkillMsg1:eval":"false","ActionSkillMsg2:eval":"true","ActionItemMsg:eval":"false","ActionChanges":"","ShowCounter:eval":"true","ShowReflect:eval":"true","ShowSubstitute:eval":"true","ActionResults":"","ShowFailure:eval":"false","ShowCritical:eval":"false","ShowMissEvasion:eval":"false","ShowHpDmg:eval":"false","ShowMpDmg:eval":"false","ShowTpDmg:eval":"false","DisplayStates":"","ShowAddedState:eval":"false","ShowRemovedState:eval":"false","ShowCurrentState:eval":"false","ShowAddedBuff:eval":"false","ShowAddedDebuff:eval":"false","ShowRemovedBuff:eval":"false"}
 *
 * @param BattlebackScale:struct
 * @text Battleback Scaling
 * @type struct<Battleback>
 * @desc Settings that adjust how battlebacks scale.
 * @default {"DefaultStyle:str":"MZ","jsOneForOne:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst scale = 1.0;\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = 0;\\nthis.y = 0;\"","jsScaleToFit:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst ratioX = this.width / this.bitmap.width;\\nconst ratioY = this.height / this.bitmap.height;\\nconst scale = Math.max(ratioX, ratioY);\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = (Graphics.width - this.width) / 2;\\nthis.y = Graphics.height - this.height;\"","jsScaleDown:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst ratioX = Math.min(1, this.width / this.bitmap.width);\\nconst ratioY = Math.min(1, this.height / this.bitmap.height);\\nconst scale = Math.max(ratioX, ratioY);\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = (Graphics.width - this.width) / 2;\\nthis.y = Graphics.height - this.height;\"","jsScale Up:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst ratioX = Math.max(1, this.width / this.bitmap.width);\\nconst ratioY = Math.max(1, this.height / this.bitmap.height);\\nconst scale = Math.max(ratioX, ratioY);\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = (Graphics.width - this.width) / 2;\\nthis.y = Graphics.height - this.height;\""}
 *
 * @param PartyCmd:struct
 * @text Party Command Window
 * @type struct<PartyCmd>
 * @desc Settings that alter the Party Command Window in battle.
 * @default {"Cmd":"","CmdStyle:str":"auto","CmdTextAlign:str":"left","CmdIconFight:num":"76","CommandAddAutoBattle:eval":"true","CmdIconAutoBattle:num":"78","CmdTextAutoBattle:str":"Auto","CommandAddOptions:eval":"true","CmdIconOptions:num":"83","ActiveTpbOptionsMessage:str":"Options Menu queued after action is complete.","CmdIconEscape:num":"82","Access":"","SkipPartyCmd:eval":"true","DisablePartyCmd:eval":"false","HelpWindow":"","HelpFight:str":"Select actions to fight.","HelpAutoBattle:str":"Sets party to Auto Battle mode.","HelpOptions:str":"Opens up the Options Menu.","HelpEscape:str":"Attempt to escape the battle."}
 *
 * @param ActorCmd:struct
 * @text Actor Command Window
 * @type struct<ActorCmd>
 * @desc Settings that alter the Actor Command Window in battle.
 * @default {"Cmd":"","CmdStyle:str":"auto","CmdTextAlign:str":"left","CmdIconItem:num":"176","IconStypeNorm:num":"78","IconStypeMagic:num":"79","BattleCmd":"","BattleCmdList:arraystr":"[\"attack\",\"skills\",\"guard\",\"item\",\"escape\"]","HelpWindow":"","HelpSkillType:str":"Opens up a list of skills under the \\C[16]%1\\C[0] category.","HelpItem:str":"Opens up a list of items that you can use.","HelpEscape:str":"Attempt to escape the battle.","HelpAutoBattle:str":"Automatically choose an action suitable for combat."}
 * 
 * @param MultiTarget:struct
 * @text Multi-Target Windows
 * @type struct<MultiTarget>
 * @desc Settings that alter the Multi-Target Windows in battle.
 * @default {"Properties":"","WindowWidth:num":"280","BgType:num":"2","ShowButton:eval":"true","Vocab":"","AllActorsText:str":"All Allies","AllEnemiesText:str":"All Enemies","Offsets":"","ActorOffsets":"","ActorOffsetX:num":"+0","ActorOffsetY:num":"+0","EnemyOffsets":"","EnemyOffsetX:num":"+0","EnemyOffsetY:num":"+0"}
 *
 * @param VisualBreak
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param Actor:struct
 * @text Actor Battler Settings
 * @type struct<Actor>
 * @desc Settings that alter various properties for actors.
 * @default {"Flinch":"","FlinchDistanceX:num":"12","FlinchDistanceY:num":"0","FlinchDuration:num":"6","SvBattlers":"","AnchorX:num":"0.5","AnchorY:num":"1.0","ChantStyle:eval":"true","OffsetX:num":"0","OffsetY:num":"0","MotionSpeed:num":"12","PrioritySortActive:eval":"true","PrioritySortActors:eval":"false","Shadow:eval":"true","SmoothImage:eval":"true","HomePosJS:func":"\"// Declare Constants\\nconst sprite = this;\\nconst actor = this._actor;\\nconst index = arguments[0];\\n\\n// Make Calculations\\nlet x = Math.round((Graphics.width / 2) + 192)\\nx -= Math.floor((Graphics.width - Graphics.boxWidth) / 2);\\nx += index * 32;\\nlet y = (Graphics.height - 200) - ($gameParty.maxBattleMembers() * 48);\\ny -= Math.floor((Graphics.height - Graphics.boxHeight) / 2);\\ny += index * 48;\\n\\n// Home Position Offsets\\nconst offsetNote = /<SIDEVIEW HOME OFFSET:[ ]([\\\\+\\\\-]\\\\d+),[ ]([\\\\+\\\\-]\\\\d+)>/i;\\nconst xOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$1) : 0));\\nconst yOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$2) : 0));\\nx = xOffsets.reduce((r, offset) => r + offset, x);\\ny = yOffsets.reduce((r, offset) => r + offset, y);\\n\\n// Set Home Position\\nthis.setHome(x, y);\""}
 *
 * @param Enemy:struct
 * @text Enemy Battler Settings
 * @type struct<Enemy>
 * @desc Settings that alter various properties for enemies.
 * @default {"Visual":"","AttackAnimation:num":"1","EmergeText:eval":"false","OffsetX:num":"0","OffsetY:num":"0","SmoothImage:eval":"true","SelectWindow":"","FrontViewSelect:eval":"false","SideviewSelect:eval":"true","NameFontSize:num":"22","SvBattlers":"","AllowCollapse:eval":"false","AnchorX:num":"0.5","AnchorY:num":"1.0","MotionIdle:str":"walk","Shadow:eval":"true","Width:num":"64","Height:num":"64","WtypeId:num":"0"}
 *
 * @param HpGauge:struct
 * @text HP Gauge Settings
 * @type struct<HpGauge>
 * @desc Settings that adjust the visual HP Gauge displayed in battle.
 * @default {"Display":"","ShowActorGauge:eval":"false","ShowEnemyGauge:eval":"true","RequiresDefeat:eval":"false","BTestBypass:eval":"true","Settings":"","AnchorX:num":"0.5","AnchorY:num":"1.0","Scale:num":"0.5","OffsetX:num":"0","OffsetY:num":"-3","Options":"","AddHpGaugeOption:eval":"true","AdjustRect:eval":"true","Name:str":"Show HP Gauge"}
 *
 * @param ActionSequence:struct
 * @text Action Sequence Settings
 * @type struct<ActionSequence>
 * @desc Settings that adjust how certain Action Sequences work.
 * @default {"AutoSequences":"","AutoMeleeSolo:eval":"true","AutoMeleeAoE:eval":"true","CastAnimations":"","CastCertain:num":"120","CastPhysical:num":"52","CastMagical:num":"51","CounterReflection":"","CounterPlayback:eval":"true","ReflectAnimation:num":"53","ReflectPlayback:eval":"true","Stepping":"","MeleeDistance:num":"24","StepDistanceX:num":"48","StepDistanceY:num":"0","StepDuration:num":"12"}
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
/* ----------------------------------------------------------------------------
 * Auto Battle Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~AutoBattle:
 *
 * @param BattleDisplay
 * @text Battle Display
 *
 * @param AutoBattleMsg:str
 * @text Message
 * @parent BattleDisplay
 * @desc Message that's displayed when Auto Battle is on.
 * Text codes allowed. %1 - OK button, %2 - Cancel button
 * @default Press %1 or %2 to stop Auto Battle
 *
 * @param AutoBattleOK:str
 * @text OK Button
 * @parent BattleDisplay
 * @desc Text used to represent the OK button.
 * If VisuMZ_0_CoreEngine is present, ignore this.
 * @default OK
 *
 * @param AutoBattleCancel:str
 * @text Cancel Button
 * @parent BattleDisplay
 * @desc Text used to represent the Cancel button.
 * If VisuMZ_0_CoreEngine is present, ignore this.
 * @default Cancel
 *
 * @param AutoBattleBgType:num
 * @text Background Type
 * @parent BattleDisplay
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for Auto Battle window.
 * @default 1
 *
 * @param AutoBattleRect:func
 * @text JS: X, Y, W, H
 * @parent BattleDisplay
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const width = Graphics.width;\nconst height = this.calcWindowHeight(1, false);\nconst x = 0;\nconst y = (Graphics.height - height) / 2;\nreturn new Rectangle(x, y, width, height);"
 *
 * @param Options
 *
 * @param AddOption:eval
 * @text Add Option?
 * @parent Options
 * @type boolean
 * @on Add
 * @off Don't Add
 * @desc Add the Auto Battle options to the Options menu?
 * @default true
 *
 * @param AdjustRect:eval
 * @text Adjust Window Height
 * @parent Options
 * @type boolean
 * @on Adjust
 * @off Don't
 * @desc Automatically adjust the options window height?
 * @default true
 *
 * @param StartName:str
 * @text Startup Name
 * @parent Options
 * @desc Command name of the option.
 * @default Auto Battle Start
 *
 * @param StyleName:str
 * @text Style Name
 * @parent Options
 * @desc Command name of the option.
 * @default Auto Battle Style
 *
 * @param StyleOFF:str
 * @text OFF
 * @parent StyleName:str
 * @desc Text displayed when Auto Battle Style is OFF.
 * @default Attack
 *
 * @param StyleON:str
 * @text ON
 * @parent StyleName:str
 * @desc Text displayed when Auto Battle Style is ON.
 * @default Skills
 *
 */
/* ----------------------------------------------------------------------------
 * Damage Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Damage:
 *
 * @param DamageStyles
 * @text Damage Styles
 *
 * @param DefaultDamageStyle:str
 * @text Default Style
 * @parent DamageStyles
 * @desc Which Damage Style do you want to set as default?
 * Use 'Manual' to not use any styles at all.
 * @default Standard
 *
 * @param DamageStyleList:arraystruct
 * @text Style List
 * @parent DamageStyles
 * @type struct<DamageStyle>[]
 * @desc A list of the damage styles available.
 * These are used to calculate base damage.
 * @default ["{\"Name:str\":\"Standard\",\"Formula:func\":\"\\\"// Declare Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Replace Formula\\\\nlet formula = item.damage.formula;\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 0)';\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\n}\\\\n\\\\n// Calculate Damage\\\\nlet value = Math.max(eval(formula), 0);\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"return this.getItemDamageAmountTextOriginal();\\\"\"}","{\"Name:str\":\"Armor Scaling\",\"Formula:func\":\"\\\"// Declare Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Replace Formula\\\\nlet formula = item.damage.formula;\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 1)';\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\n}\\\\n\\\\n// Calculate Damage\\\\nlet value = Math.max(eval(formula), 0);\\\\n\\\\n// Apply Defender's Defense Parameter\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\n\\\\n    // Calculate Base Armor\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\n\\\\n    // Apply Armor to Damage\\\\n    if (armor >= 0) {\\\\n        value *= 100 / (100 + armor);\\\\n    } else {\\\\n        value *= 2 - (100 / (100 - armor));\\\\n    }\\\\n}\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"return this.getItemDamageAmountTextOriginal();\\\"\"}","{\"Name:str\":\"CT\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet value = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\nlet attackStat = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat =  a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    attackStat =  a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    attackStat =  a.mdf;\\\\n}\\\\n\\\\n// Calculate Damage\\\\nattackStat = (attackStat * 1.75) + (level ** 2 / 45.5);\\\\nvalue = attackStat * 4;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= Math.max(256 - armor, 0) / 256;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= Math.max(102.4 - armor, 0) / 128;\\\\n}\\\\nvalue *= multiplier;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"D4\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nlet stat = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    stat = a.def;\\\\n    armor = 0;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    stat = a.mdf;\\\\n    armor = 0;\\\\n}\\\\n\\\\n// Calculate Damage \\\\nlet value = 1.5 * Math.max(2 * stat * multiplier - armor, 1) * multiplier / 5;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"DQ\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nlet multiplier = Math.max(eval(item.damage.formula), 0);\\\\nif (this.isCertainHit()) {\\\\n    let value = multiplier * Math.max(a.atk, a.mat);\\\\n    return (isNaN(value) ? 0 : value) * sign;\\\\n}\\\\n\\\\n// Get Primary Stats\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(b, armor);\\\\nlet stat = 1;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    stat = a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    stat = a.mdf;\\\\n}\\\\n\\\\n// Check for Recovery\\\\nif (this.isRecover()) {\\\\n    let value = stat * multiplier * sign;\\\\n    return isNaN(value) ? 0 : value;\\\\n}\\\\n\\\\n// Calculate Damage\\\\nlet value = 0;\\\\nif (stat < ((2 + armor) / 2)) {\\\\n    // Plink Damage\\\\n    let baseline = Math.max(stat - ((12 * (armor - stat + 1)) / stat), 5);\\\\n    value = baseline / 3;\\\\n} else {\\\\n    // Normal Damage\\\\n    let baseline = Math.max(stat - (armor / 2), 1);\\\\n    value = baseline / 2;\\\\n}\\\\nvalue *= multiplier;\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF7\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Power\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare base Damage\\\\nlet baseDamage = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    baseDamage = a.atk + ((a.atk + level) / 32) * ((a.atk * level) / 32);\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    baseDamage = 6 * (a.mat + level);\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    baseDamage = 6 * (a.def + level);\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    baseDamage = 6 * (a.mdf + level);\\\\n}\\\\n\\\\n// Calculate Final Damage\\\\nlet value = baseDamage;\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nif (this.isRecover()) {\\\\n    value += 22 * power;\\\\n} else {\\\\n    value = (power * Math.max(512 - armor, 1) * baseDamage) / (16 * 512);\\\\n}\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF8\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Power\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Damage\\\\nlet Value = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value = a.atk ** 2 / 16 + a.atk;\\\\n    value *= Math.max(265 - armor, 1) / 256;\\\\n    value *= power / 16;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value = a.mat + power;\\\\n    value *= Math.max(265 - armor, 1) / 4;\\\\n    value *= power / 256;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value = (power + a.def) * power / 2;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value = (power + a.mdf) * power / 2;\\\\n}\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF9\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Damage Constant\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\nif (this.isCertainHit()) {\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\n}\\\\n\\\\n// Declare Main Stats\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(b, armor);\\\\nlet stat = 1;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    stat = a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    stat = a.mdf;\\\\n}\\\\n\\\\n// Declare Base Damage\\\\nlet baseDamage = power;\\\\nif (this.isPhysical()) {\\\\n    baseDamage += stat;\\\\n}\\\\nif (this.isDamage() || this.isDrain()) {\\\\n    baseDamage -= armor;\\\\n    baseDamage = Math.max(1, baseDamage);\\\\n}\\\\n\\\\n// Declare Bonus Damage\\\\nlet bonusDamage = stat + (((a.level || a.luk) + stat) / 8);\\\\n\\\\n// Declare Final Damage\\\\nlet value = baseDamage * bonusDamage * sign;\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF10\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Damage Constant\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\nif (this.isCertainHit()) {\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\n}\\\\n\\\\n// Create Damage Offense Value\\\\nlet value = power;\\\\n\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value = (((a.atk ** 3) / 32) + 32) * power / 16;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value = power * ((a.mat ** 2 / 6) + power) / 4;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value = power * ((a.def + power) / 2);\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value = power * ((a.mdf + power) / 2);\\\\n}\\\\n\\\\n// Apply Damage Defense Value\\\\nif (this.isDamage() || this.isDrain()) {\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\n    armor = this.applyArmorModifiers(b, armor);\\\\n    armor = Math.max(armor, 1);\\\\n    value *= ((((armor - 280.4) ** 2) / 110) / 16) / 730;\\\\n    value *= (730 - (armor * 51 - (armor ** 2) / 11) / 10) / 730;\\\\n} else if (this.isRecover()) {\\\\n    value *= -1;\\\\n}\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"MK\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nconst denominator = Math.max(200 + armor, 1);\\\\n\\\\n// Calculate Damage \\\\nlet value = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value = 200 * a.atk / denominator;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value = 200 * a.mat / denominator;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value = 200 * a.def / 200;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value = 200 * a.mdf / 200;\\\\n}\\\\nvalue *= multiplier;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"MOBA\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Damage Value\\\\nlet value = Math.max(eval(item.damage.formula), 0) * sign;\\\\n\\\\n// Apply Attacker's Offense Parameter\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value *= a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value *= a.mdf;\\\\n}\\\\n\\\\n// Apply Defender's Defense Parameter\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\n\\\\n    // Calculate Base Armor\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\n\\\\n    // Apply Armor to Damage\\\\n    if (armor >= 0) {\\\\n        value *= 100 / (100 + armor);\\\\n    } else {\\\\n        value *= 2 - (100 / (100 - armor));\\\\n    }\\\\n}\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"PKMN\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Power\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet value = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\nlet attackStat = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat =  a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    attackStat =  a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    attackStat =  a.mdf;\\\\n}\\\\n\\\\n// Calculate Damage\\\\nvalue = (((((2 * level) / 5) + 2) * power * (attackStat / armor)) / 50) + 2;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}"]
 *
 * @param Cap
 * @text Damage Cap
 *
 * @param EnableDamageCap:eval
 * @text Enable Damage Cap?
 * @parent Cap
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Put a maximum hard damage cap on how far damage can go?
 * This can be broken through the usage of notetags.
 * @default false
 *
 * @param DefaultHardCap:num
 * @text Default Hard Cap
 * @parent EnableDamageCap:eval
 * @type number
 * @min 1
 * @desc The default hard damage cap used before applying damage.
 * @default 9999
 *
 * @param EnableSoftCap:eval
 * @text Enable Soft Cap?
 * @parent Cap
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Soft caps ease in the damage values leading up to the 
 * hard damage cap. Requires hard Damage Cap enabled.
 * @default false
 *
 * @param DefaultSoftCap:num
 * @text Base Soft Cap Rate
 * @parent EnableSoftCap:eval
 * @desc The default soft damage cap used before applying damage.
 * @default 0.80
 *
 * @param DefaultSoftScaler:num
 * @text Soft Scale Constant
 * @parent EnableSoftCap:eval
 * @desc The default soft damage cap used before applying damage.
 * @default 0.1275
 *
 * @param Popups
 *
 * @param PopupDuration:num
 * @text Popup Duration
 * @parent Popups
 * @type number
 * @min 1
 * @desc Adjusts how many frames a popup stays visible.
 * @default 128
 *
 * @param NewPopupBottom:eval
 * @text Newest Popups Bottom
 * @parent Popups
 * @type boolean
 * @on Bottom
 * @off Top
 * @desc Puts the newest popups at the bottom.
 * @default true
 *
 * @param PopupPosition:str
 * @text Appear Position
 * @parent Popups
 * @type select
 * @option Head - At the top of the battler.
 * @value head
 * @option Center - At the center of the battler.
 * @value center
 * @option Base - At the foot of the battler.
 * @value base
 * @desc Selects where you want popups to appear relative to the battler.
 * @default base
 *
 * @param EndBattlePopups:eval
 * @text End Battle Show?
 * @parent Popups
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show or hide popups upon victory or escape?
 * Used to hide battle-state removal popups.
 * @default true
 *
 * @param PopupOffsetX:num
 * @text Offset X
 * @parent Popups
 * @desc Sets how much to offset the sprites by horizontally.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param PopupOffsetY:num
 * @text Offset Y
 * @parent Popups
 * @desc Sets how much to offset the sprites by vertically.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param PopupShiftX:num
 * @text Shift X
 * @parent Popups
 * @desc Sets how much to shift the sprites by horizontally.
 * Negative values go left. Positive values go right.
 * @default 8
 *
 * @param PopupShiftY:num
 * @text Shift Y
 * @parent Popups
 * @desc Sets how much to shift the sprites by vertically.
 * Negative values go up. Positive values go down.
 * @default -28
 *
 * @param hpDamageFmt:str
 * @text HP Damage Format
 * @parent Popups
 * @desc Determines HP damage format for popup.
 * %1 - Value, %2 - HP Text
 * @default -%1
 *
 * @param hpHealingFmt:str
 * @text HP Healing Format
 * @parent Popups
 * @desc Determines HP healing format for popup.
 * %1 - Value, %2 - HP Text
 * @default +%1
 *
 * @param mpDamageFmt:str
 * @text MP Damage Format
 * @parent Popups
 * @desc Determines MP damage format for popup.
 * %1 - Value, %2 - MP Text
 * @default -%1 %2
 *
 * @param mpHealingFmt:str
 * @text MP Healing Format
 * @parent Popups
 * @desc Determines MP healing format for popup.
 * %1 - Value, %2 - MP Text
 * @default +%1 %2
 *
 * @param CriticalColor:eval
 * @text Critical Flash Color
 * @parent Popups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [255, 0, 0, 160]
 *
 * @param CriticalDuration:num
 * @text Critical Duration
 * @parent Popups
 * @type number
 * @min 1
 * @desc Adjusts how many frames a the flash lasts.
 * @default 128
 *
 * @param Formulas
 *
 * @param OverallFormulaJS:func
 * @text JS: Overall Formula
 * @parent Formulas
 * @type note
 * @desc The overall formula used when calculating damage.
 * @default "// Declare Constants\nconst target = arguments[0];\nconst critical = arguments[1];\nconst item = this.item();\n\n// Get Base Damage\nconst baseValue = this.evalDamageFormula(target);\n\n// Calculate Element Modifiers\nlet value = baseValue * this.calcElementRate(target);\n\n// Calculate Physical and Magical Modifiers\nif (this.isPhysical()) {\n    value *= target.pdr;\n}\nif (this.isMagical()) {\n    value *= target.mdr;\n}\n\n// Apply Healing Modifiers\nif (baseValue < 0) {\n    value *= target.rec;\n}\n\n// Apply Critical Modifiers\nif (critical) {\n    value = this.applyCritical(value);\n}\n\n// Apply Variance and Guard Modifiers\nvalue = this.applyVariance(value, item.damage.variance);\nvalue = this.applyGuard(value, target);\n\n// Finalize Damage\nvalue = Math.round(value);\nreturn value;"
 *
 * @param VarianceFormulaJS:func
 * @text JS: Variance Formula
 * @parent Formulas
 * @type note
 * @desc The formula used when damage variance.
 * @default "// Declare Constants\nconst damage = arguments[0];\nconst variance = arguments[1];\n\n// Calculate Variance\nconst amp = Math.floor(Math.max((Math.abs(damage) * variance) / 100, 0));\nconst v = Math.randomInt(amp + 1) + Math.randomInt(amp + 1) - amp;\n\n// Return Damage\nreturn damage >= 0 ? damage + v : damage - v;"
 *
 * @param GuardFormulaJS:func
 * @text JS: Guard Formula
 * @parent Formulas
 * @type note
 * @desc The formula used when damage is guarded.
 * @default "// Declare Constants\nconst damage = arguments[0];\nconst target = arguments[1];\n\n// Return Damage Early\nconst note = this.item().note;\nif (note.match(/<UNBLOCKABLE>/i)) return damage;\nif (!target.isGuard()) return damage;\nif (damage < 0) return damage;\n\n// Declare Guard Rate\nlet guardRate = 0.5;\nguardRate /= target.grd;\n\n// Return Damage\nreturn damage * guardRate;"
 *
 * @param Critical
 * @text Critical Hits
 *
 * @param CriticalHitRateJS:func
 * @text JS: Rate Formula
 * @parent Critical
 * @type note
 * @desc The formula used to calculate Critical Hit Rates.
 * @default "// Declare Constants\nconst user = this.subject();\nconst target = arguments[0];\n\n// Create Base Critical Rate\nlet rate = this.subject().cri * (1 - target.cev);\n\n// Apply Notetags\nconst note = this.item().note;\nif (note.match(/<ALWAYS CRITICAL>/i)) {\n    return 1;\n}\nif (note.match(/<SET CRITICAL RATE:[ ](\\d+)([%％])>/i)) {\n    return Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL RATE:[ ](\\d+)([%％])>/i)) {\n    rate *= Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL RATE:[ ]([\\+\\-]\\d+)([%％])>/i)) {\n    rate += Number(RegExp.$1) / 100;\n}\nif (note.match(/<JS CRITICAL RATE>\\s*([\\s\\S]*)\\s*<\\/JS CRITICAL RATE>/i)) {\n    const code = String(RegExp.$1);\n    try {\n        eval(code);\n    } catch (e) {\n        if ($gameTemp.isPlaytest()) console.log(e);\n    }\n}\n\n// Apply LUK Buffs/Debuffs\nconst lukStack = this.subject().buff(7);\nrate *= 2 ** lukStack;\n\n// Return Rate\nreturn rate;"
 *
 * @param CriticalHitMultiplier:func
 * @text JS: Damage Formula
 * @parent Critical
 * @type note
 * @desc The formula used to calculate Critical Hit Damage modification.
 * @default "// Declare Constants\nconst user = this.subject();\nlet damage = arguments[0];\nlet multiplier = 2.0;\nlet bonusDamage = this.subject().luk * this.subject().cri;\n\n// Apply Notetags\nconst note = this.item().note;\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ](\\d+)([%％])>/i)) {\n    multiplier = Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ]([\\+\\-]\\d+)([%％])>/i)) {\n    multiplier += Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ](\\d+)([%％])>/i)) {\n    bonusDamage *= Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ]([\\+\\-]\\d+)([%％])>/i)) {\n    bonusDamage += bonusDamage * (RegExp.$1) / 100;\n}\nif (note.match(/<JS CRITICAL DAMAGE>\\s*([\\s\\S]*)\\s*<\\/JS CRITICAL DAMAGE>/i)) {\n    const code = String(RegExp.$1);\n    try {\n        eval(code);\n    } catch (e) {\n        if ($gameTemp.isPlaytest()) console.log(e);\n    }\n}\n\n// Return Damage\nreturn damage * multiplier + bonusDamage;"
 *
 */
/* ----------------------------------------------------------------------------
 * Damage Formula Style
 * ----------------------------------------------------------------------------
 */
/*~struct~DamageStyle:
 *
 * @param Name:str
 * @text Name
 * @desc Name of this Damage Style.
 * Used for notetags and such.
 * @default Untitled
 *
 * @param Formula:func
 * @text JS: Formula
 * @parent Name:str
 * @type note
 * @desc The base formula for this Damage Style.
 * @default "// Define Constants\nconst item = this.item();\nconst a = this.subject();\nconst b = target;\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\n\n// Create Damage Value\nlet value = Math.max(eval(item.damage.formula), 0) * sign;\n\n// Return Value\nreturn isNaN(value) ? 0 : value;"
 *
 * @param ItemsEquipsCore
 * @text Items & Equips Core
 *
 * @param DamageType
 * @text Damage Label
 * @parent ItemsEquipsCore
 *
 * @param DamageType1:str
 * @text HP Damage
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Damage Multiplier
 *
 * @param DamageType2:str
 * @text MP Damage
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Damage Multiplier
 *
 * @param DamageType3:str
 * @text HP Recovery
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Recovery Multiplier
 *
 * @param DamageType4:str
 * @text MP Recovery
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Recovery Multiplier
 *
 * @param DamageType5:str
 * @text HP Drain
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Drain Multiplier
 *
 * @param DamageType6:str
 * @text MP Drain
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Drain Multiplier
 *
 * @param DamageDisplay:func
 * @text JS: Damage Display
 * @parent ItemsEquipsCore
 * @type note
 * @desc Code used the data displayed for this category.
 * @default "// Define Constants\nconst item = this._item;\nconst formula = item.damage.formula;\nconst a = this._tempActorA;\nconst b = this._tempActorB;\nconst user = a;\nconst target = b;\n\n// Return Value\ntry {\n    const value = Math.max(eval(formula), 0);\n    return '%1%'.format(Math.round(value * 100));\n} catch (e) {\n    if ($gameTemp.isPlaytest()) {\n        console.log('Damage Formula Error for %1'.format(this._item.name));\n    }\n    return '?????';\n}"
 *
 */
/* ----------------------------------------------------------------------------
 * Mechanics Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Mechanics:
 *
 * @param ActionSpeed
 * @text Action Speed
 *
 * @param AllowRandomSpeed:eval
 * @text Allow Random Speed?
 * @parent ActionSpeed
 * @type boolean
 * @on Allow
 * @off Disable
 * @desc Allow speed to be randomized base off the user's AGI?
 * @default false
 *
 * @param CalcActionSpeedJS:func
 * @text JS: Calculate
 * @parent ActionSpeed
 * @type note
 * @desc Code used to calculate action speed.
 * @default "// Declare Constants\nconst agi = this.subject().agi;\n\n// Create Speed\nlet speed = agi;\nif (this.allowRandomSpeed()) {\n    speed += Math.randomInt(Math.floor(5 + agi / 4));\n}\nif (this.item()) {\n    speed += this.item().speed;\n}\nif (this.isAttack()) {\n    speed += this.subject().attackSpeed();\n}\n\n// Return Speed\nreturn speed;"
 *
 * @param BaseTroop
 * @text Base Troop
 *
 * @param BaseTroopIDs:arraynum
 * @text Base Troop ID's
 * @parent BaseTroop
 * @type troop[]
 * @desc Select the Troop ID(s) to duplicate page events from for all other troops.
 * @default ["1"]
 *
 * @param CommonEvents
 * @text Common Events (on Map)
 *
 * @param BattleStartEvent:num
 * @text Pre-Battle Event
 * @parent CommonEvents
 * @type common_event
 * @desc Common Event to run before each battle on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param BattleEndEvent:num
 * @text Post-Battle Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run after each battle on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param VictoryEvent:num
 * @text Victory Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon victory on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param DefeatEvent:num
 * @text Defeat Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon defeat on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param EscapeSuccessEvent:num
 * @text Escape Success Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon escape success on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param EscapeFailEvent:num
 * @text Escape Fail Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon escape failure on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param Escape
 *
 * @param CalcEscapeRatioJS:func
 * @text JS: Calc Escape Ratio
 * @parent Escape
 * @type note
 * @desc Code used to calculate the escape success ratio.
 * @default "// Calculate Escape Ratio\nlet ratio = 0.5;\nratio *= $gameParty.agility();\nratio /= $gameTroop.agility();\n\n// Return Ratio\nreturn ratio;"
 *
 * @param CalcEscapeRaiseJS:func
 * @text JS: Calc Escape Raise
 * @parent Escape
 * @type note
 * @desc Code used to calculate how much the escape success ratio raises upon each failure.
 * @default "// Calculate Escape Ratio\nlet value = 0.1;\nvalue += $gameParty.aliveMembers().length;\n\n// Return Value\nreturn value;"
 *
 * @param Switches
 *
 * @param SwitchCritical:num
 * @text Switch: Critical
 * @parent Switches
 * @type switch
 * @desc Turns switch ON if the action performs a critical hit.
 * Switch reverts to OFF whenever an action starts.
 * @default 0
 *
 * @param SwitchMissEvade:num
 * @text Switch: Miss/Evade
 * @parent Switches
 * @type switch
 * @desc Turns switch ON if the action misses/is evaded.
 * Switch reverts to OFF whenever an action starts.
 * @default 0
 *
 * @param Variables
 *
 * @param VariableDmg:num
 * @text Variable: Damage
 * @parent Variables
 * @type variable
 * @desc Variable records target damage during action.
 * Variable reverts to 0 whenever an action starts.
 * @default 0
 *
 * @param VariableHeal:num
 * @text Variable: Healing
 * @parent Variables
 * @type variable
 * @desc Variable records target healing during action.
 * Variable reverts to 0 whenever an action starts.
 * @default 0
 *
 * @param BattleJS
 * @text JS: Battle-Related
 * 
 * @param PreStartBattleJS:func
 * @text JS: Pre-Start Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.startBattle()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostStartBattleJS:func
 * @text JS: Post-Start Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.startBattle()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 * 
 * @param BattleVictoryJS:func
 * @text JS: Battle Victory
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.processVictory()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param EscapeSuccessJS:func
 * @text JS: Escape Success
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.onEscapeSuccess()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param EscapeFailureJS:func
 * @text JS: Escape Failure
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.onEscapeFailure()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 * 
 * @param BattleDefeatJS:func
 * @text JS: Battle Defeat
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.processDefeat()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 * 
 * @param PreEndBattleJS:func
 * @text JS: Pre-End Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.endBattle()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostEndBattleJS:func
 * @text JS: Post-End Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.endBattle()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param TurnJS
 * @text JS: Turn-Related
 *
 * @param PreStartTurnJS:func
 * @text JS: Pre-Start Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: BattleManager.startTurn()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostStartTurnJS:func
 * @text JS: Post-Start Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: BattleManager.startTurn()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PreEndTurnJS:func
 * @text JS: Pre-End Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.onTurnEnd()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostEndTurnJS:func
 * @text JS: Post-End Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.onTurnEnd()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PreRegenerateJS:func
 * @text JS: Pre-Regenerate
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.regenerateAll()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostRegenerateJS:func
 * @text JS: Post-Regenerate
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.regenerateAll()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param ActionJS
 * @text JS: Action-Related
 *
 * @param PreStartActionJS:func
 * @text JS: Pre-Start Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.startAction()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 * @param PostStartActionJS:func
 * @text JS: Post-Start Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.startAction()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 * @param PreApplyJS:func
 * @text JS: Pre-Apply
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.apply()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PreDamageJS:func
 * @text JS: Pre-Damage
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.executeDamage()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PostDamageJS:func
 * @text JS: Post-Damage
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.executeDamage()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PostApplyJS:func
 * @text JS: Post-Apply
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.apply()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PreEndActionJS:func
 * @text JS: Pre-End Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.endAction()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 * @param PostEndActionJS:func
 * @text JS: Post-End Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.endAction()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 */
/* ----------------------------------------------------------------------------
 * Battle Layout Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~BattleLayout:
 *
 * @param Style:str
 * @text Battle Layout Style
 * @type select
 * @option Default - Shows actor faces in Battle Status.
 * @value default
 * @option List - Lists actors in Battle Status.
 * @value list
 * @option XP - Shows actor battlers in a stretched Battle Status.
 * @value xp
 * @option Portrait - Shows portraits in a stretched Battle Status.
 * @value portrait
 * @option Border - Displays windows around the screen border.
 * @value border
 * @option Frontview Battle UI - Requires VisuMZ_3_FrontviewBattleUI
 * @value frontview_ui
 * @option Sideview Battle UI - Requires VisuMZ_3_SideviewBattleUI
 * @value sideview_ui
 * @desc The style used for the battle layout.
 * @default default
 *
 * @param ListStyle
 * @text List Style
 * @parent Style:str
 *
 * @param ShowFacesListStyle:eval
 * @text Show Faces
 * @parent ListStyle
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows faces in List Style?
 * @default true
 *
 * @param CommandWidth:num
 * @text Command Window Width
 * @parent ListStyle
 * @type number
 * @min 1
 * @desc Determine the window width for the Party and Actor Command
 * Windows. Affects Default and List Battle Layout styles.
 * @default 192
 *
 * @param XPStyle
 * @text XP Style
 * @parent Style:str
 *
 * @param XPActorCommandLines:num
 * @text Command Lines
 * @parent XPStyle
 * @type number
 * @min 1
 * @desc Number of action lines in the Actor Command Window for the XP Style.
 * @default 4
 *
 * @param XPActorDefaultHeight:num
 * @text Sprite Height
 * @parent XPStyle
 * @type number
 * @min 1
 * @desc Default sprite height used when if the sprite's height has not been determined yet.
 * @default 64
 *
 * @param XPSpriteYLocation:str
 * @text Sprite Base Location
 * @parent XPStyle
 * @type select
 * @option Above Name - Sprite is located above the name.
 * @value name
 * @option Bottom - Sprite is located at the bottom of the window.
 * @value bottom
 * @option Centered - Sprite is centered in the window.
 * @value center
 * @option Top - Sprite is located at the top of the window.
 * @value top
 * @desc Determine where the sprite is located on the Battle Status Window.
 * @default name
 *
 * @param PotraitStyle
 * @text Portrait Style
 * @parent Style:str
 *
 * @param ShowPortraits:eval
 * @text Show Portraits?
 * @parent PotraitStyle
 * @type boolean
 * @on Portraits
 * @off Faces
 * @desc Requires VisuMZ_1_MainMenuCore.
 * Shows the actor's portrait instead of a face.
 * @default true
 *
 * @param PortraitScale:num
 * @text Portrait Scaling
 * @parent PotraitStyle
 * @desc If portraits are used, scale them by this much.
 * @default 0.5
 *
 * @param BorderStyle
 * @text Border Style
 * @parent Style:str
 *
 * @param SkillItemBorderCols:num
 * @text Columns
 * @parent BorderStyle
 * @type number
 * @min 1
 * @desc The total number of columns for Skill & Item Windows
 * in the battle scene.
 * @default 1
 *
 * @param ShowPortraitsBorderStyle:eval
 * @text Show Portraits?
 * @parent BorderStyle
 * @type boolean
 * @on Portraits
 * @off Faces
 * @desc Requires VisuMZ_1_MainMenuCore.
 * Shows the actor's portrait at the edge of the screen.
 * @default true
 *
 * @param PortraitScaleBorderStyle:num
 * @text Portrait Scaling
 * @parent BorderStyle
 * @desc If portraits are used, scale them by this much.
 * @default 1.0
 *
 * @param SkillItemWindows
 * @text Skill & Item Windows
 *
 * @param SkillItemMiddleLayout:eval
 * @text Middle Layout
 * @parent SkillItemWindows
 * @type boolean
 * @on Middle
 * @off Bottom
 * @desc Shows the Skill & Item Windows in mid-screen?
 * @default false
 *
 * @param SkillItemStandardCols:num
 * @text Columns
 * @parent SkillItemWindows
 * @type number
 * @min 1
 * @desc The total number of columns for Skill & Item Windows
 * in the battle scene.
 * @default 2
 *
 * @param StatusWindow
 * @text Status Window Elements
 *
 * @param StatusWindowName
 * @text Battler Name
 * @parent StatusWindow
 *
 * @param NameOffsetX:num
 * @text Offset: X
 * @parent StatusWindowName
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param NameOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowName
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowHpGauge
 * @text Gauge 1 (HP)
 * @parent StatusWindow
 *
 * @param HpGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowHpGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param HpGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowHpGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowMpGauge
 * @text Gauge 2 (MP)
 * @parent StatusWindow
 *
 * @param MpGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowMpGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param MpGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowMpGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowTpGauge
 * @text Gauge 3 (TP)
 * @parent StatusWindow
 *
 * @param TpGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowTpGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param TpGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowTpGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowStateIcon
 * @text State Icon
 * @parent StatusWindow
 *
 * @param StateIconOffsetX:num
 * @text Offset: X
 * @parent StatusWindowStateIcon
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param StateIconOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowStateIcon
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowTpbGauge
 * @text TPB/ATB Gauge
 * @parent StatusWindow
 *
 * @param TpbGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowTpbGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param TpbGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowTpbGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowSkin
 * @text Window Skin
 * @parent StatusWindow
 *
 * @param StatusWindowSkinFilename:str
 * @text Filename
 * @parent StatusWindowSkin
 * @type file
 * @dir img/system/
 * @desc Filename used for the Battle Status Window skin.
 * Leave this empty to use the default window skin.
 * @default 
 *
 * @param StatusWindowSkinHide:eval
 * @text Hide Window Skin?
 * @parent StatusWindowSkin
 * @type boolean
 * @on No Window Skin
 * @off Default Skin
 * @desc Show/Hide the window skin for the Battle Status Window?
 * @default false
 *
 * @param StatusWindowSelectBack
 * @text Selectable Background
 * @parent StatusWindow
 *
 * @param StatusWindowSelectableBackHide:eval
 * @text Hide Selectable BG?
 * @parent StatusWindowSelectBack
 * @type boolean
 * @on No Selectable BG
 * @off Default Selectable BG
 * @desc Show/Hide the selectable background box for the Battle Status Window?
 * @default false
 *
 * @param StatusWindowAttachments
 * @text Attachments
 * @parent StatusWindow
 *
 * @param StatusWindowBackAttachment
 * @text Back Attachment
 * @parent StatusWindowAttachments
 *
 * @param StatusWindowAttachmentBack:str
 * @text Filename
 * @parent StatusWindowBackAttachment
 * @type file
 * @dir img/system/
 * @desc Filename used for an image to attach to the back of the
 * Battle Status Window. Leave empty for none.
 * @default 
 *
 * @param StatusWindowAttachmentBackOffsetX:num
 * @text Offset: X
 * @parent StatusWindowBackAttachment
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param StatusWindowAttachmentBackOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowBackAttachment
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowFrontAttachment
 * @text Front Attachment
 * @parent StatusWindowAttachments
 *
 * @param StatusWindowAttachmentFront:str
 * @text Filename
 * @parent StatusWindowFrontAttachment
 * @type file
 * @dir img/system/
 * @desc Filename used for an image to attach to the front of the
 * Battle Status Window. Leave empty for none.
 * @default 
 *
 * @param StatusWindowAttachmentFrontOffsetX:num
 * @text Offset: X
 * @parent StatusWindowFrontAttachment
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param StatusWindowAttachmentFrontOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowFrontAttachment
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param UiElements
 * @text UI Elements
 *
 * @param AntiTintUiElements:eval
 * @text Anti-Tint UI?
 * @parent UiElements
 * @type boolean
 * @on Prevent Tint
 * @off Allow Tint
 * @desc Prevent UI Elements from being tinted?
 * @default true
 *
 */
/* ----------------------------------------------------------------------------
 * Battle Log Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~BattleLog:
 *
 * @param General
 *
 * @param BackColor:str
 * @text Back Color
 * @parent General
 * @desc Use #rrggbb for a hex color.
 * @default #000000
 *
 * @param MaxLines:num
 * @text Max Lines
 * @parent General
 * @type number
 * @min 1
 * @desc Maximum number of lines to be displayed.
 * @default 10
 *
 * @param MessageWait:num
 * @text Message Wait
 * @parent General
 * @type number
 * @min 1
 * @desc Number of frames for a usual message wait.
 * @default 16
 *
 * @param TextAlign:str
 * @text Text Align
 * @parent General
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Window_BattleLog.
 * @default center
 *
 * @param BattleLogRectJS:func
 * @text JS: X, Y, W, H
 * @parent General
 * @type note
 * @desc Code used to determine the dimensions for the battle log.
 * @default "const wx = 0;\nconst wy = 0;\nconst ww = Graphics.boxWidth;\nconst wh = this.calcWindowHeight(10, false);\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param StartTurn
 * @text Start Turn
 *
 * @param StartTurnShow:eval
 * @text Show Start Turn?
 * @parent StartTurn
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display turn changes at the start of the turn?
 * @default false
 *
 * @param StartTurnMsg:str
 * @text Start Turn Message
 * @parent StartTurn
 * @desc Message displayed at turn start.
 * %1 - Turn Count
 * @default Turn %1
 *
 * @param StartTurnWait:num
 * @text Start Turn Wait
 * @parent StartTurn
 * @type number
 * @min 1
 * @desc Number of frames to wait after a turn started.
 * @default 40
 *
 * @param DisplayAction
 * @text Display Action
 *
 * @param ActionCenteredName:eval
 * @text Show Centered Action?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display a centered text of the action name?
 * @default true
 *
 * @param ActionSkillMsg1:eval
 * @text Show Skill Message 1?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the 1st skill message?
 * @default false
 *
 * @param ActionSkillMsg2:eval
 * @text Show Skill Message 2?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the 2nd skill message?
 * @default true
 *
 * @param ActionItemMsg:eval
 * @text Show Item Message?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the item use message?
 * @default false
 *
 * @param ActionChanges
 * @text Action Changes
 *
 * @param ShowCounter:eval
 * @text Show Counter?
 * @parent ActionChanges
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display counter text?
 * @default true
 *
 * @param ShowReflect:eval
 * @text Show Reflect?
 * @parent ActionChanges
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display magic reflection text?
 * @default true
 *
 * @param ShowSubstitute:eval
 * @text Show Substitute?
 * @parent ActionChanges
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display substitute text?
 * @default true
 *
 * @param ActionResults
 * @text Action Results
 *
 * @param ShowFailure:eval
 * @text Show No Effect?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display no effect text?
 * @default false
 *
 * @param ShowCritical:eval
 * @text Show Critical?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display critical text?
 * @default false
 *
 * @param ShowMissEvasion:eval
 * @text Show Miss/Evasion?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display miss/evasion text?
 * @default false
 *
 * @param ShowHpDmg:eval
 * @text Show HP Damage?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display HP Damage text?
 * @default false
 *
 * @param ShowMpDmg:eval
 * @text Show MP Damage?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display MP Damage text?
 * @default false
 *
 * @param ShowTpDmg:eval
 * @text Show TP Damage?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display TP Damage text?
 * @default false
 *
 * @param DisplayStates
 * @text Display States
 *
 * @param ShowAddedState:eval
 * @text Show Added States?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display added states text?
 * @default false
 *
 * @param ShowRemovedState:eval
 * @text Show Removed States?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display removed states text?
 * @default false
 *
 * @param ShowCurrentState:eval
 * @text Show Current States?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the currently affected state text?
 * @default false
 *
 * @param ShowAddedBuff:eval
 * @text Show Added Buffs?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display added buffs text?
 * @default false
 *
 * @param ShowAddedDebuff:eval
 * @text Show Added Debuffs?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display added debuffs text?
 * @default false
 *
 * @param ShowRemovedBuff:eval
 * @text Show Removed Buffs?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display removed de/buffs text?
 * @default false
 *
 */
/* ----------------------------------------------------------------------------
 * Battleback Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Battleback:
 *
 * @param DefaultStyle:str
 * @text Default Style
 * @type select
 * @option MZ (MZ's default style)
 * @value MZ
 * @option 1:1 (No Scaling)
 * @value 1:1
 * @option Scale To Fit (Scale to screen size)
 * @value ScaleToFit
 * @option Scale Down (Scale Downward if Larger than Screen)
 * @value ScaleDown
 * @option Scale Up (Scale Upward if Smaller than Screen)
 * @value ScaleUp
 * @desc The default scaling style used for battlebacks.
 * @default MZ
 *
 * @param jsOneForOne:func
 * @text JS: 1:1
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst scale = 1.0;\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = 0;\nthis.y = 0;"
 *
 * @param jsScaleToFit:func
 * @text JS: Scale To Fit
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst ratioX = this.width / this.bitmap.width;\nconst ratioY = this.height / this.bitmap.height;\nconst scale = Math.max(ratioX, ratioY);\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = (Graphics.width - this.width) / 2;\nthis.y = Graphics.height - this.height;"
 *
 * @param jsScaleDown:func
 * @text JS: Scale Down
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst ratioX = Math.min(1, this.width / this.bitmap.width);\nconst ratioY = Math.min(1, this.height / this.bitmap.height);\nconst scale = Math.max(ratioX, ratioY);\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = (Graphics.width - this.width) / 2;\nthis.y = Graphics.height - this.height;"
 *
 * @param jsScaleUp:func
 * @text JS: Scale Up
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst ratioX = Math.max(1, this.width / this.bitmap.width);\nconst ratioY = Math.max(1, this.height / this.bitmap.height);\nconst scale = Math.max(ratioX, ratioY);\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = (Graphics.width - this.width) / 2;\nthis.y = Graphics.height - this.height;"
 *
 */
/* ----------------------------------------------------------------------------
 * Party Command Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~PartyCmd:
 *
 * @param Cmd
 * @text Command Window
 *
 * @param CmdStyle:str
 * @text Style
 * @parent Cmd
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands in the Party Command Window?
 * @default auto
 *
 * @param CmdTextAlign:str
 * @text Text Align
 * @parent Cmd
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Party Command Window.
 * @default left
 *
 * @param CmdIconFight:num
 * @text Fight Icon
 * @parent Cmd
 * @desc The icon used for the Fight command.
 * @default 76
 *
 * @param CommandAddAutoBattle:eval
 * @text Add Auto Battle?
 * @parent Cmd
 * @type boolean
 * @on Add
 * @off Don't
 * @desc Add the "Auto Battle" command to the Command Window?
 * @default true
 *
 * @param CmdIconAutoBattle:num
 * @text Auto Battle Icon
 * @parent CommandAddAutoBattle:eval
 * @desc The icon used for the Auto Battle command.
 * @default 78
 *
 * @param CmdTextAutoBattle:str
 * @text Auto Battle Text
 * @parent CommandAddAutoBattle:eval
 * @desc The text used for the Auto Battle command.
 * @default Auto
 *
 * @param CommandAddOptions:eval
 * @text Add Options?
 * @parent Cmd
 * @type boolean
 * @on Add
 * @off Don't
 * @desc Add the "Options" command to the Command Window?
 * @default true
 *
 * @param CmdIconOptions:num
 * @text Options Icon
 * @parent CommandAddOptions:eval
 * @desc The icon used for the Options command.
 * @default 83
 *
 * @param ActiveTpbOptionsMessage:str
 * @text Active TPB Message
 * @parent CommandAddOptions:eval
 * @desc Message that will be displayed when selecting options during the middle of an action.
 * @default Options Menu queued after action is complete.
 *
 * @param CmdIconEscape:num
 * @text Escape Icon
 * @parent Cmd
 * @desc The icon used for the Escape command.
 * @default 82
 *
 * @param Access
 *
 * @param SkipPartyCmd:eval
 * @text Skip Party Command
 * @parent Access
 * @type boolean
 * @on Skip
 * @off Don't
 * @desc DTB: Skip Party Command selection on turn start.
 * TPB: Skip Party Command selection at battle start.
 * @default true
 *
 * @param DisablePartyCmd:eval
 * @text Disable Party Command
 * @parent Access
 * @type boolean
 * @on Disable
 * @off Don't
 * @desc Disable the Party Command Window entirely?
 * @default false
 *
 * @param HelpWindow
 * @text Help Window
 *
 * @param HelpFight:str
 * @text Fight
 * @parent HelpWindow
 * @desc Text displayed when selecting a skill type.
 * %1 - Skill Type Name
 * @default Select actions to fight.
 *
 * @param HelpAutoBattle:str
 * @text Auto Battle
 * @parent HelpWindow
 * @desc Text displayed when selecting the Auto Battle command.
 * @default Sets party to Auto Battle mode.
 *
 * @param HelpOptions:str
 * @text Options
 * @parent HelpWindow
 * @desc Text displayed when selecting the Options command.
 * @default Opens up the Options Menu.
 *
 * @param HelpEscape:str
 * @text Escape
 * @parent HelpWindow
 * @desc Text displayed when selecting the escape command.
 * @default Attempt to escape the battle.
 *
 */
/* ----------------------------------------------------------------------------
 * Actor Command Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ActorCmd:
 *
 * @param Cmd
 * @text Command Window
 *
 * @param CmdStyle:str
 * @text Style
 * @parent Cmd
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands in the Actor Command Window?
 * @default auto
 *
 * @param CmdTextAlign:str
 * @text Text Align
 * @parent Cmd
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Actor Command Window.
 * @default left
 *
 * @param CmdIconItem:num
 * @text Item Icon
 * @parent Cmd
 * @desc The icon used for the Item command.
 * @default 176
 *
 * @param IconStypeNorm:num
 * @text Normal SType Icon
 * @parent Cmd
 * @desc Icon used for normal skill types that aren't assigned any
 * icons. Ignore if VisuMZ_1_SkillsStatesCore is installed.
 * @default 78
 *
 * @param IconStypeMagic:num
 * @text Magic SType Icon
 * @parent Cmd
 * @desc Icon used for magic skill types that aren't assigned any
 * icons. Ignore if VisuMZ_1_SkillsStatesCore is installed.
 * @default 79
 *
 * @param BattleCmd
 * @text Battle Commands
 *
 * @param BattleCmdList:arraystr
 * @text Command List
 * @parent BattleCmd
 * @type combo[]
 * @option attack
 * @option skills
 * @option guard
 * @option item
 * @option party
 * @option escape
 * @option auto battle
 * @option stypes
 * @option stype: x
 * @option stype: name
 * @option all skills
 * @option skill: x
 * @option skill: name
 * @option combat log
 * @option talk
 * @option weapon swap
 * @desc List of battle commands that appear by default
 * if the <Battle Commands> notetag isn't present.
 * @default ["attack","skills","guard","party","item"]
 *
 * @param ShowCosts:eval
 * @text Show Command Costs
 * @parent BattleCmd
 * @type boolean
 * @on Show Costs
 * @off Hide Costs
 * @desc If a battle command has a resource cost, show it?
 * @default true
 *
 * @param HelpWindow
 * @text Help Window
 *
 * @param HelpSkillType:str
 * @text Skill Types
 * @parent HelpWindow
 * @desc Text displayed when selecting a skill type.
 * %1 - Skill Type Name
 * @default Opens up a list of skills under the \C[16]%1\C[0] category.
 *
 * @param HelpItem:str
 * @text Items
 * @parent HelpWindow
 * @desc Text displayed when selecting the item command.
 * @default Opens up a list of items that you can use.
 *
 * @param HelpEscape:str
 * @text Escape
 * @parent HelpWindow
 * @desc Text displayed when selecting the escape command.
 * @default Attempt to escape the battle.
 *
 * @param HelpAutoBattle:str
 * @text Auto Battle
 * @parent HelpWindow
 * @desc Text displayed when selecting the Auto Battle command.
 * @default Automatically choose an action suitable for combat.
 *
 * @param HelpParty:str
 * @text Party
 * @parent HelpWindow
 * @desc Text displayed when selecting the Party command.
 * Requires 
 * @default Automatically choose an action suitable for combat.
 *
 */
/* ----------------------------------------------------------------------------
 * Multi-Target Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~MultiTarget:
 *
 * @param Properties
 * 
 * @param WindowWidth:num
 * @text Window Width
 * @parent Properties
 * @type number
 * @min 1
 * @desc What is the width used for the Multi-Target Window?
 * @default 280
 *
 * @param BgType:num
 * @text Background Type
 * @parent Properties
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for these windows.
 * @default 2
 *
 * @param ShowButton:eval
 * @text Show Button
 * @parent Properties
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows the keyboard/controller button to press?
 * Requires VisuMZ_0_CoreEngine!
 * @default true
 * 
 * @param Vocab
 *
 * @param AllActorsText:str
 * @text All Actors
 * @parent Vocab
 * @desc What is the text used for the "All Actors" button?
 * @default All Allies
 *
 * @param AllEnemiesText:str
 * @text All Enemies
 * @parent Vocab
 * @desc What is the text used for the "All Enemies" button?
 * @default All Enemies
 * 
 * @param Offsets
 * 
 * @param ActorOffsets
 * @text Actor Offsets
 * @parent Offsets
 *
 * @param ActorOffsetX:num
 * @text Offset X
 * @parent ActorOffsets
 * @desc Offsets the button's x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param ActorOffsetY:num
 * @text Offset Y
 * @parent ActorOffsets
 * @desc Offsets the button's y position.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @param EnemyOffsets
 * @text Enemy Offsets
 * @parent Offsets
 *
 * @param EnemyOffsetX:num
 * @text Offset X
 * @parent EnemyOffsets
 * @desc Offsets the button's x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param EnemyOffsetY:num
 * @text Offset Y
 * @parent EnemyOffsets
 * @desc Offsets the button's y position.
 * Negative: up. Positive: down.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Actor Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Actor:
 *
 * @param Flinch
 *
 * @param FlinchDistanceX:num
 * @text Flinch Distance X
 * @parent Flinch
 * @desc The normal X distance when flinching.
 * @default 12
 *
 * @param FlinchDistanceY:num
 * @text Flinch Distance Y
 * @parent Flinch
 * @desc The normal Y distance when flinching.
 * @default 0
 *
 * @param FlinchDuration:num
 * @text Flinch Duration
 * @parent Flinch
 * @desc The number of frames for a flinch to complete.
 * @default 6
 *
 * @param ShakeFlinch:eval
 * @text Shake Flinch
 * @parent Flinch
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Perform a shake flinch when taking damage?
 * @default false
 *
 * @param ShakeFlinchDuration:num
 * @text Max Duration
 * @parent ShakeFlinch:eval
 * @type number
 * @min 1
 * @desc Maximum duration a shake flinch can have.
 * This is reduced relative to the amount of damage taken.
 * @default 24
 *
 * @param ShakeFlinchPower:num
 * @text Max Power
 * @parent ShakeFlinch:eval
 * @type number
 * @min 1
 * @desc The power rating of a shake flinch at full damage.
 * This is reduced relative to the amount of damage taken.
 * @default 48
 *
 * @param SvBattlers
 * @text Sideview Battlers
 *
 * @param AnchorX:num
 * @text Anchor: X
 * @parent SvBattlers
 * @desc Default X anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor: Y
 * @parent SvBattlers
 * @desc Default Y anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 1.0
 *
 * @param ChantStyle:eval
 * @text Chant Style
 * @parent SvBattlers
 * @type boolean
 * @on Magical Hit Type
 * @off Magical Skill Type
 * @desc What determines the chant motion?
 * Hit type or skill type?
 * @default true
 *
 * @param OffsetX:num
 * @text Offset: X
 * @parent SvBattlers
 * @desc Offsets X position where actor is positioned.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset: Y
 * @parent SvBattlers
 * @desc Offsets Y position where actor is positioned.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param MotionSpeed:num
 * @text Motion Speed
 * @parent SvBattlers
 * @type number
 * @min 1
 * @desc The number of frames in between each motion.
 * @default 12
 *
 * @param PrioritySortActive:eval
 * @text Priority: Active
 * @parent SvBattlers
 * @type boolean
 * @on Active Actor over All Else
 * @off Active Actor is Sorted Normally
 * @desc Place the active actor on top of actor and enemy sprites.
 * @default false
 *
 * @param PrioritySortActors:eval
 * @text Priority: Actors
 * @parent SvBattlers
 * @type boolean
 * @on Actors over Enemies
 * @off Sort by Y Position
 * @desc Prioritize actors over enemies when placing sprites on top
 * of each other.
 * @default true
 *
 * @param Shadow:eval
 * @text Shadow Visible
 * @parent SvBattlers
 * @type boolean
 * @on Visible
 * @off Hidden
 * @desc Show or hide the shadow for Sideview Battlers.
 * @default true
 *
 * @param SmoothImage:eval
 * @text Smooth Image
 * @parent SvBattlers
 * @type boolean
 * @on Smooth
 * @off Pixelated
 * @desc Smooth out the battler images or pixelate them?
 * @default false
 *
 * @param HomePosJS:func
 * @text JS: Home Position
 * @parent SvBattlers
 * @type note
 * @desc Code used to calculate the home position of actors.
 * @default "// Declare Constants\nconst sprite = this;\nconst actor = this._actor;\nconst index = arguments[0];\n\n// Make Calculations\nlet x = Math.round((Graphics.width / 2) + 192)\nx -= Math.floor((Graphics.width - Graphics.boxWidth) / 2);\nx += index * 32;\nlet y = (Graphics.height - 200) - ($gameParty.maxBattleMembers() * 48);\ny -= Math.floor((Graphics.height - Graphics.boxHeight) / 2);\ny += index * 48;\n\n// Home Position Offsets\nconst offsetNote = /<SIDEVIEW HOME OFFSET:[ ]([\\+\\-]\\d+),[ ]([\\+\\-]\\d+)>/i;\nconst xOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$1) : 0));\nconst yOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$2) : 0));\nx = xOffsets.reduce((r, offset) => r + offset, x);\ny = yOffsets.reduce((r, offset) => r + offset, y);\n\n// Set Home Position\nthis.setHome(x, y);"
 *
 */
/* ----------------------------------------------------------------------------
 * Enemy Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Enemy:
 *
 * @param Visual
 *
 * @param AttackAnimation:num
 * @text Attack Animation
 * @parent Visual
 * @type animation
 * @desc Default attack animation used for enemies.
 * Use <Attack Animation: x> for custom animations.
 * @default 1
 *
 * @param EmergeText:eval
 * @text Emerge Text
 * @parent Visual
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show or hide the 'Enemy emerges!' text at the start of battle.
 * @default false
 *
 * @param OffsetX:num
 * @text Offset: X
 * @parent Visual
 * @desc Offsets X position where enemy is positioned.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset: Y
 * @parent Visual
 * @desc Offsets Y position where enemy is positioned.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param SmoothImage:eval
 * @text Smooth Image
 * @parent Visual
 * @type boolean
 * @on Smooth
 * @off Pixelated
 * @desc Smooth out the battler images or pixelate them?
 * @default true
 *
 * @param SelectWindow
 * @text Select Window
 *
 * @param LastSelected:eval
 * @text Any: Last Selected
 * @parent SelectWindow
 * @type boolean
 * @on Last Selected
 * @off FV/SV Priority
 * @desc Prioritize last selected enemy over front view or sideview settings?
 * @default true
 *
 * @param FrontViewSelect:eval
 * @text FV: Right Priority
 * @parent SelectWindow
 * @type boolean
 * @on Right
 * @off Normal
 * @desc If using frontview, auto select the enemy furthest right.
 * @default false
 *
 * @param SideviewSelect:eval
 * @text SV: Right Priority
 * @parent SelectWindow
 * @type boolean
 * @on Right
 * @off Normal
 * @desc If using sideview, auto select the enemy furthest right.
 * @default true
 * 
 * @param Name
 *
 * @param NameLegacy:eval
 * @text Legacy Option
 * @parent Name
 * @type boolean
 * @on Legacy Version
 * @off New Version (Sprite)
 * @desc Use the legacy version (window) or new version (sprite).
 * WARNING: Legacy version is no longer supported for bugs.
 * @default false
 *
 * @param NameFontSize:num
 * @text Font Size
 * @parent Name
 * @desc Font size used for enemy names.
 * @default 22
 * 
 * @param NamePosition
 * @text Name Position
 * @parent Name
 *
 * @param NameOffsetX:num
 * @text Offset X
 * @parent NamePosition
 * @desc Offset the enemy name's X position by this much.
 * Negative goes left. Positive goes right.
 * @default 0
 *
 * @param NameOffsetY:num
 * @text Offset Y
 * @parent NamePosition
 * @desc Offset the enemy name's Y position by this much.
 * Negative goes up. Positive goes down.
 * @default 0
 *
 * @param NameAttachStateIcon:eval
 * @text Attach States
 * @parent Name
 * @type boolean
 * @on Attach
 * @off Normal Position
 * @desc Attach the enemy's state icon to the enemy name?
 * @default false
 *
 * @param AttachStateOffsetX:num
 * @text Attach: Offset X
 * @parent NameAttachStateIcon:eval
 * @desc How much to offset the attached icon's X position by?
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param AttachStateOffsetY:num
 * @text Attach: Offset Y
 * @parent NameAttachStateIcon:eval
 * @desc How much to offset the attached icon's Y position by?
 * Negative goes up. Positive goes down.
 * @default +0
 * 
 * @param NameVisibility
 * @text Name Visibility
 * @parent Name
 *
 * @param NameAlwaysHidden:eval
 * @text Always Hidden
 * @parent NameVisibility
 * @type boolean
 * @on Always Hidden
 * @off No Priority
 * @desc Determines if the enemy name will always be visible.
 * Highest priority.
 * @default false
 *
 * @param NameAlwaysVisible:eval
 * @text Always Visible
 * @parent NameVisibility
 * @type boolean
 * @on Always Visible
 * @off Hide when Unselected
 * @desc Determines if the enemy name will always be visible.
 * Medium priority.
 * @default false
 *
 * @param NameAlwaysSelectOnly:eval
 * @text By Selection?
 * @parent NameVisibility
 * @type boolean
 * @on Visible when Selected
 * @off Visible when Targeting
 * @desc Determines the conditions for enemy name visibility.
 * Lowest priority.
 * @default false
 *
 * @param SvBattlers
 * @text Sideview Battlers
 *
 * @param AllowCollapse:eval
 * @text Allow Collapse
 * @parent SvBattlers
 * @type boolean
 * @on Allow
 * @off Don't
 * @desc Causes defeated enemies with SV Battler graphics
 * to "fade away" when defeated?
 * @default false
 *
 * @param AnchorX:num
 * @text Anchor: X
 * @parent SvBattlers
 * @desc Default X anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor: Y
 * @parent SvBattlers
 * @desc Default Y anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 1.0
 *
 * @param MotionIdle:str
 * @text Motion: Idle
 * @parent SvBattlers
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Sets default idle animation used by Sideview Battlers.
 * @default walk
 *
 * @param Shadow:eval
 * @text Shadow Visible
 * @parent SvBattlers
 * @type boolean
 * @on Visible
 * @off Hidden
 * @desc Show or hide the shadow for Sideview Battlers.
 * @default true
 *
 * @param Width:num
 * @text Size: Width
 * @parent SvBattlers
 * @type number
 * @min 1
 * @desc Default width for enemies that use Sideview Battlers.
 * @default 64
 *
 * @param Height:num
 * @text Size: Height
 * @parent SvBattlers
 * @type number
 * @min 1
 * @desc Default height for enemies that use Sideview Battlers.
 * @default 64
 *
 * @param WtypeId:num
 * @text Weapon Type
 * @parent SvBattlers
 * @type number
 * @min 0
 * @desc Sets default weapon type used by Sideview Battlers.
 * Use 0 for Bare Hands.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * HP Gauge Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~HpGauge:
 *
 * @param Display
 * @text Show Gauges For
 *
 * @param ShowActorGauge:eval
 * @text Actors
 * @parent Display
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show HP Gauges over the actor sprites' heads?
 * Requires SV Actors to be visible.
 * @default true
 *
 * @param ShowEnemyGauge:eval
 * @text Enemies
 * @parent Display
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show HP Gauges over the enemy sprites' heads?
 * Can be bypassed with <Hide HP Gauge> notetag.
 * @default true
 *
 * @param RequiresDefeat:eval
 * @text Requires Defeat?
 * @parent ShowEnemyGauge:eval
 * @type boolean
 * @on Require Defeat First
 * @off No Requirement
 * @desc Requires defeating the enemy once to show HP Gauge?
 * Can be bypassed with <Show HP Gauge> notetag.
 * @default true
 *
 * @param BTestBypass:eval
 * @text Battle Test Bypass?
 * @parent RequiresDefeat:eval
 * @type boolean
 * @on Bypass
 * @off Don't Bypass
 * @desc Bypass the defeat requirement in battle test?
 * @default true
 *
 * @param Settings
 *
 * @param AniDuration:num
 * @text Animation Duration
 * @parent Settings
 * @type number
 * @min 1
 * @desc How many frames should gauges animate themselves?
 * Default: 20 frames.
 * @default 20
 *
 * @param AnchorX:num
 * @text Anchor X
 * @parent Settings
 * @desc Where do you want the HP Gauge sprite's anchor X to be?
 * Use values between 0 and 1 to be safe.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor Y
 * @parent Settings
 * @desc Where do you want the HP Gauge sprite's anchor Y to be?
 * Use values between 0 and 1 to be safe.
 * @default 1.0
 *
 * @param Scale:num
 * @text Scale
 * @parent Settings
 * @desc How large/small do you want the HP Gauge to be scaled?
 * @default 0.5
 *
 * @param OffsetX:num
 * @text Offset X
 * @parent Settings
 * @desc How many pixels to offset the HP Gauge's X by?
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset Y
 * @parent Settings
 * @desc How many pixels to offset the HP Gauge's Y by?
 * @default -3
 *
 * @param Options
 * @text Options
 *
 * @param AddHpGaugeOption:eval
 * @text Add Option?
 * @parent Options
 * @type boolean
 * @on Add
 * @off Don't Add
 * @desc Add the 'Show HP Gauge' option to the Options menu?
 * @default true
 *
 * @param AdjustRect:eval
 * @text Adjust Window Height
 * @parent Options
 * @type boolean
 * @on Adjust
 * @off Don't
 * @desc Automatically adjust the options window height?
 * @default true
 *
 * @param Name:str
 * @text Option Name
 * @parent Options
 * @desc Command name of the option.
 * @default Show HP Gauge
 *
 */
/* ----------------------------------------------------------------------------
 * Action Sequence Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ActionSequence:
 *
 * @param AutoSequences
 * @text Automatic Sequences
 *
 * @param AutoMeleeSolo:eval
 * @text Melee Single Target
 * @parent AutoSequences
 * @type boolean
 * @on Allow
 * @off Ignore
 * @desc Allow this auto sequence for physical, single target actions?
 * @default true
 *
 * @param AutoMeleeAoE:eval
 * @text Melee Multi Target
 * @parent AutoSequences
 * @type boolean
 * @on Allow
 * @off Ignore
 * @desc Allow this auto sequence for physical, multi-target actions?
 * @default true
 *
 * @param QoL
 * @text Quality of Life
 *
 * @param AutoNotetag:eval
 * @text Auto Notetag
 * @parent QoL
 * @type boolean
 * @on Automatic
 * @off Manual
 * @desc Automatically apply the <Custom Action Sequence> notetag
 * effect to any item or skill that has a Common Event?
 * @default false
 *
 * @param CastAnimations
 * @text Cast Animations
 *
 * @param CastCertain:num
 * @text Certain Hit
 * @parent CastAnimations
 * @type animation
 * @desc Cast animation for Certain Hit skills.
 * @default 120
 *
 * @param CastPhysical:num
 * @text Physical
 * @parent CastAnimations
 * @type animation
 * @desc Cast animation for Physical skills.
 * @default 52
 *
 * @param CastMagical:num
 * @text Magical
 * @parent CastAnimations
 * @type animation
 * @desc Cast animation for Magical skills.
 * @default 51
 *
 * @param CounterReflection
 * @text Counter/Reflect
 *
 * @param CounterPlayback:eval
 * @text Counter Back
 * @parent CounterReflection
 * @type boolean
 * @on Play Back
 * @off Ignore
 * @desc Play back the attack animation used?
 * @default true
 *
 * @param ReflectAnimation:num
 * @text Reflect Animation
 * @parent CounterReflection
 * @type animation
 * @desc Animation played when an action is reflected.
 * @default 53
 *
 * @param ReflectPlayback:eval
 * @text Reflect Back
 * @parent CounterReflection
 * @type boolean
 * @on Play Back
 * @off Ignore
 * @desc Play back the attack animation used?
 * @default true
 *
 * @param Stepping
 *
 * @param MeleeDistance:num
 * @text Melee Distance
 * @parent Stepping
 * @desc Minimum distance in pixels for Movement Action Sequences.
 * @default 24
 *
 * @param StepDistanceX:num
 * @text Step Distance X
 * @parent Stepping
 * @desc The normal X distance when stepping forward.
 * @default 48
 *
 * @param StepDistanceY:num
 * @text Step Distance Y
 * @parent Stepping
 * @desc The normal Y distance when stepping forward.
 * @default 0
 *
 * @param StepDuration:num
 * @text Step Duration
 * @parent Stepping
 * @desc The number of frames for a stepping action to complete.
 * @default 12
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Start Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileStart:
 * 
 * @param Type:str
 * @text Type
 * @type select
 * @option Target - Start from battler target(s)
 * @value target
 * @option Point - Start from a point on the screen
 * @value point
 * @desc Select where the projectile should start from.
 * @default target
 * 
 * @param Targets:arraystr
 * @text Target(s)
 * @parent Type:str
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to start the projectile from.
 * @default ["user"]
 * 
 * @param TargetCenter:eval
 * @text Centralize
 * @parent Targets:arraystr
 * @type boolean
 * @on Center Projectile
 * @off Create Each
 * @desc Create one projectile at the center of the targets?
 * Or create a projectile for each target?
 * @default false
 * 
 * @param TargetLocation:str
 * @text Target Location
 * @parent Targets:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part of the target to send the projectile from.
 * @default middle center
 * 
 * @param PointX:eval
 * @text Point X
 * @parent Type:str
 * @desc Insert the X coordinate to start the projectile at.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @param PointY:eval
 * @text Point Y
 * @parent Type:str
 * @desc Insert the Y coordinate to start the projectile at.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 * 
 * @param OffsetX:eval
 * @text Offset X
 * @desc Insert how many pixels to offset the X coordinate by.
 * You may use JavaScript code.
 * @default +0
 * 
 * @param OffsetY:eval
 * @text Offset Y
 * @desc Insert how many pixels to offset the Y coordinate by.
 * You may use JavaScript code.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Goal Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileGoal:
 * 
 * @param Type:str
 * @text Type
 * @type select
 * @option Target - Goal is battler target(s)
 * @value target
 * @option Point - Goal is a point on the screen
 * @value point
 * @desc Select where the projectile should go to.
 * @default target
 * 
 * @param Targets:arraystr
 * @text Target(s)
 * @parent Type:str
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) for projectile to go to.
 * @default ["all targets"]
 * 
 * @param TargetCenter:eval
 * @text Centralize
 * @parent Targets:arraystr
 * @type boolean
 * @on Center Projectile
 * @off Create Each
 * @desc Set goal in the center of targets?
 * Or create a projectile to go to each target?
 * @default false
 * 
 * @param TargetLocation:str
 * @text Target Location
 * @parent Targets:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part of the target to send the projectile at.
 * @default middle center
 * 
 * @param PointX:eval
 * @text Point X
 * @parent Type:str
 * @desc Insert the X coordinate to send the projectile to.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @param PointY:eval
 * @text Point Y
 * @parent Type:str
 * @desc Insert the Y coordinate to send the projectile to.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 * 
 * @param OffsetX:eval
 * @text Offset X
 * @desc Insert how many pixels to offset the X coordinate by.
 * You may use JavaScript code.
 * @default +0
 * 
 * @param OffsetY:eval
 * @text Offset Y
 * @desc Insert how many pixels to offset the Y coordinate by.
 * You may use JavaScript code.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Extra Animation Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileExAni:
 * 
 * @param AutoAngle:eval
 * @text Auto Angle?
 * @parent Settings
 * @type boolean
 * @on Automatically Angle
 * @off Normal
 * @desc Automatically angle the projectile to tilt the direction it's moving?
 * @default true
 * 
 * @param AngleOffset:eval
 * @text Angle Offset
 * @desc Alter the projectile's tilt by this many degrees.
 * @default +0
 * 
 * @param Arc:eval
 * @text Arc Peak
 * @parent Settings
 * @desc This is the height of the project's trajectory arc
 * in pixels.
 * @default 0
 *
 * @param EasingType:str
 * @text Easing
 * @parent Settings
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type to apply to the projectile's trajectory.
 * @default Linear
 * 
 * @param Spin:eval
 * @text Spin Speed
 * @parent Settings
 * @desc Determine how much angle the projectile spins per frame.
 * Does not work well with "Auto Angle".
 * @default +0.0
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Extra Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileExtra:
 * 
 * @param AutoAngle:eval
 * @text Auto Angle?
 * @parent Settings
 * @type boolean
 * @on Automatically Angle
 * @off Normal
 * @desc Automatically angle the projectile to tilt the direction it's moving?
 * @default true
 * 
 * @param AngleOffset:eval
 * @text Angle Offset
 * @desc Alter the projectile's tilt by this many degrees.
 * @default +0
 * 
 * @param Arc:eval
 * @text Arc Peak
 * @parent Settings
 * @desc This is the height of the project's trajectory arc
 * in pixels.
 * @default 0
 *
 * @param BlendMode:num
 * @text Blend Mode
 * @type select
 * @option 0 - Normal
 * @value 0
 * @option 1 - Additive
 * @value 1
 * @option 2 - Multiply
 * @value 2
 * @option 3 - Screen
 * @value 3
 * @desc What kind of blend mode do you wish to apply to the projectile?
 * @default 0
 *
 * @param EasingType:str
 * @text Easing
 * @parent Settings
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type to apply to the projectile's trajectory.
 * @default Linear
 * 
 * @param Hue:eval
 * @text Hue
 * @parent Settings
 * @desc Adjust the hue of the projectile.
 * Insert a number between 0 and 360.
 * @default 0
 * 
 * @param Scale:eval
 * @text Scale
 * @parent Settings
 * @desc Adjust the size scaling of the projectile.
 * Use decimals for exact control.
 * @default 1.0
 * 
 * @param Spin:eval
 * @text Spin Speed
 * @parent Settings
 * @desc Determine how much angle the projectile spins per frame.
 * Does not work well with "Auto Angle".
 * @default +0.0
 *
 */
/* ----------------------------------------------------------------------------
 * Visual Cutin Effect Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~VisualCutinEffect:
 *
 * @param Transition
 * 
 * @param enterDuration:num
 * @text Entrance Duration
 * @parent Transition
 * @type number
 * @desc How many frames does it take to fully enter?
 * Used when a Visual Cutin Effect starts.
 * @default 12
 * 
 * @param exitDuration:num
 * @text Exit Duration
 * @parent Transition
 * @type number
 * @desc How many frames does it take to fully exit?
 * Used when a Visual Cutin Effect ends.
 * @default 12
 *
 * @param Cutin
 * @text Cutin Settings
 *
 * @param bgShow:eval
 * @text Show BG Color?
 * @parent Cutin
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Add a background color for this cutin?
 * Background colors appear behind the parallax.
 * @default true
 *
 * @param outlineShow:eval
 * @text Show Outline?
 * @parent Cutin
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show the cutin outline?
 * @default true
 *
 * @param Portrait
 * @text Portrait Settings
 *
 * @param PortraitBase
 * @text Base Properties
 * @parent Portrait
 * 
 * @param portraitAnchorX:num
 * @text Anchor X
 * @parent PortraitBase
 * @desc Determines the sprite anchor X alignment.
 * 0.0: Left, 0.5: Center, 1.0: Right.
 * @default 0.5
 * 
 * @param portraitAnchorY:num
 * @text Anchor Y
 * @parent PortraitBase
 * @desc Determines the sprite anchor Y alignment.
 * 0.0: Top, 0.5: Middle, 1.0: Bottom.
 * @default 0.5
 *
 * @param portraitHue:num
 * @text Hue
 * @parent PortraitBase
 * @type number
 * @min 0
 * @max 360
 * @desc Do you wish to adjust this cutin's portrait hue?
 * @default 0
 * 
 * @param portraitOpacity:num
 * @text Opacity
 * @parent PortraitBase
 * @type number
 * @max 255
 * @desc What is the opacity level of this cutin's portrait?
 * @default 255
 * 
 * @param portraitOffsetX:num
 * @text Offset X
 * @parent PortraitBase
 * @desc Offsets the cutin portrait's X location.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @param portraitOffsetY:num
 * @text Offset Y
 * @parent PortraitBase
 * @desc Offsets the cutin portrait's Y location.
 * Negative: up. Positive: down.
 * @default +0
 *
 * @param PortraitEnter
 * @text Entrance Properties
 * @parent Portrait
 * 
 * @param portraitEnterX:num
 * @text Entrance X
 * @parent PortraitEnter
 * @desc Sets the cutin portrait's X entrance.
 * Negative: from left. Positive: from right.
 * @default +0
 * 
 * @param portraitEnterY:num
 * @text Entrance Y
 * @parent PortraitEnter
 * @desc Sets the cutin portrait's Y entrance.
 * Negative: from up. Positive: from down.
 * @default +0
 *
 * @param portraitEnterEasingType:str
 * @text Entrance Easing
 * @parent PortraitEnter
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @param PortraitExit
 * @text Exit Properties
 * @parent Portrait
 * 
 * @param portraitExitX:num
 * @text Exit X
 * @parent PortraitExit
 * @desc Sets the cutin portrait's X exit.
 * Negative: to left. Positive: to right.
 * @default +0
 * 
 * @param portraitExitY:num
 * @text Exit Y
 * @parent PortraitExit
 * @desc Sets the cutin portrait's Y exit.
 * Negative: to up. Positive: to down.
 * @default +0
 *
 * @param portraitExitEasingType:str
 * @text Exit Easing
 * @parent PortraitExit
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @param PortraitFlip
 * @text Flip Properties
 * @parent Portrait
 *
 * @param portraitFlipHorz:eval
 * @text Flip Horizontally?
 * @parent PortraitFlip
 * @type boolean
 * @on Flip
 * @off Don't Flip
 * @desc Flip the cutin portrait horizontally?
 * @default false
 *
 * @param portraitFlipVert:eval
 * @text Flip Vertically?
 * @parent PortraitFlip
 * @type boolean
 * @on Flip
 * @off Don't Flip
 * @desc Flip the cutin portrait vertically?
 * @default false
 *
 * @param PortraitScale
 * @text Scaling Properties
 * @parent Portrait
 * 
 * @param portraitForcedScale:num
 * @text Forced Scaling
 * @parent PortraitScale
 * @desc Do you want to force a scaling ratio?
 * Leave as 0 for none. Disables "Fit to Scale?".
 * @default 0.0
 *
 * @param portraitScaleToFit:eval
 * @text Fit to Scale?
 * @parent PortraitScale
 * @type boolean
 * @on Fit to Scale
 * @off Don't Scale
 * @desc Scale the cutin portrait to fit the cutin style?
 * Cannot be used with "Forced Scaling".
 * @default true
 *
 * @param portraitScaleMax:eval
 * @text Scale Max?
 * @parent portraitScaleToFit:eval
 * @type boolean
 * @on Scale Maximum
 * @off Scale Minimum
 * @desc Scale the cutin portrait to the maximum fit or
 * scale the cutin portrait to the minimum fit.
 * @default false
 *
 * @param PortraitAni
 * @text Animated Portraits
 * @parent Portrait
 *
 * @param animatedPortraitLooping:eval
 * @text Loop?
 * @parent PortraitAni
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Will loop back to beginning once ended.
 * Requires VisuMZ_4_AnimatedPictures!
 * @default true
 *
 * @param animatedPortraitWaitFrames:num
 * @text Wait Frames
 * @parent PortraitAni
 * @type number
 * @min 1
 * @desc Frames to wait before moving to next cell.
 * Requires VisuMZ_4_AnimatedPictures!
 * @default 4
 *
 * @param Parallax
 * @text Parallax Settings
 *
 * @param ParallaxBase
 * @text Base Settings
 * @parent Parallax
 *
 * @param parallaxBlendMode:num
 * @text Blend Mode
 * @parent ParallaxBase
 * @type select
 * @option 0 - Normal
 * @value 0
 * @option 1 - Additive
 * @value 1
 * @option 2 - Multiply
 * @value 2
 * @option 3 - Screen
 * @value 3
 * @desc What kind of blend mode do you wish to apply to the cutin?
 * @default 0
 *
 * @param parallaxHue:num
 * @text Hue
 * @parent ParallaxBase
 * @type number
 * @min 0
 * @max 360
 * @desc Do you wish to adjust this cutin's parallax hue?
 * @default 0
 *
 * @param parallaxHueEnemyModifier:num
 * @text Enemy Modifier
 * @parent parallaxHue:num
 * @desc Adjust the hue value by this if the cutin target is an enemy.
 * @default +0
 * 
 * @param parallaxOpacity:num
 * @text Opacity
 * @parent ParallaxBase
 * @type number
 * @max 255
 * @desc What is the opacity level of this cutin's parallax?
 * @default 255
 *
 * @param ParallaxScroll
 * @text Scrolling Settings
 * @parent Parallax
 * 
 * @param parallaxOffsetX:num
 * @text Offset X
 * @parent ParallaxScroll
 * @desc Offsets the cutin parallax's X location.
 * Negative: left. Positive: right.
 * @default +0.0
 * 
 * @param parallaxOffsetY:num
 * @text Offset Y
 * @parent ParallaxScroll
 * @desc Offsets the cutin parallax's Y location.
 * Negative: up. Positive: down.
 * @default +0.0
 * 
 * @param parallaxScrollX:num
 * @text Scroll X
 * @parent ParallaxScroll
 * @desc How many pixels does the parallax scroll horizontally?
 * Negative: Scroll to right. Positive: Scroll to left.
 * @default +0.0
 *
 * @param parallaxScrollXinvertEnemy:eval
 * @text Invert for Enemy?
 * @parent parallaxScrollX:num
 * @type boolean
 * @on Invert
 * @off Don't Invert
 * @desc Invert the X scroll direction if the cutin target is an enemy?
 * @default false
 * 
 * @param parallaxScrollY:num
 * @text Scroll Y
 * @parent ParallaxScroll
 * @desc How many pixels does the parallax scroll vertically?
 * Negative: Scroll to down. Positive: Scroll to up.
 * @default +0.0
 *
 * @param parallaxScrollYinvertEnemy:eval
 * @text Invert for Enemy?
 * @parent parallaxScrollY:num
 * @type boolean
 * @on Invert
 * @off Don't Invert
 * @desc Invert the Y scroll direction if the cutin target is an enemy?
 * @default false
 *
 */
//=============================================================================

const _0x1a8785=_0x416b;(function(_0x278959,_0x41a95a){const _0x10fcac=_0x416b,_0x5ea839=_0x278959();while(!![]){try{const _0x1d137e=-parseInt(_0x10fcac(0x2af))/0x1+-parseInt(_0x10fcac(0x84f))/0x2+-parseInt(_0x10fcac(0x662))/0x3*(parseInt(_0x10fcac(0x7d2))/0x4)+parseInt(_0x10fcac(0x511))/0x5+-parseInt(_0x10fcac(0x6d8))/0x6*(parseInt(_0x10fcac(0x3e7))/0x7)+parseInt(_0x10fcac(0x871))/0x8+parseInt(_0x10fcac(0xa9f))/0x9;if(_0x1d137e===_0x41a95a)break;else _0x5ea839['push'](_0x5ea839['shift']());}catch(_0x14800d){_0x5ea839['push'](_0x5ea839['shift']());}}}(_0x2d08,0x1df75));var label='BattleCore',tier=tier||0x0,dependencies=[],pluginData=$plugins[_0x1a8785(0x70f)](function(_0x263247){const _0x338b82=_0x1a8785;return _0x263247[_0x338b82(0x43f)]&&_0x263247['description']['includes']('['+label+']');})[0x0];VisuMZ[label][_0x1a8785(0x9a7)]=VisuMZ[label]['Settings']||{},VisuMZ[_0x1a8785(0x235)]=function(_0x1c5d2b,_0x3de8ec){const _0xa06064=_0x1a8785;for(const _0x268935 in _0x3de8ec){if(_0x268935['match'](/(.*):(.*)/i)){const _0x560a93=String(RegExp['$1']),_0x2ac328=String(RegExp['$2'])['toUpperCase']()['trim']();let _0x1d61e6,_0x58bdb0,_0x42cdbe;switch(_0x2ac328){case'NUM':_0x1d61e6=_0x3de8ec[_0x268935]!==''?Number(_0x3de8ec[_0x268935]):0x0;break;case _0xa06064(0x312):_0x58bdb0=_0x3de8ec[_0x268935]!==''?JSON['parse'](_0x3de8ec[_0x268935]):[],_0x1d61e6=_0x58bdb0[_0xa06064(0x628)](_0x38145a=>Number(_0x38145a));break;case _0xa06064(0x72e):_0x1d61e6=_0x3de8ec[_0x268935]!==''?eval(_0x3de8ec[_0x268935]):null;break;case _0xa06064(0x31f):_0x58bdb0=_0x3de8ec[_0x268935]!==''?JSON[_0xa06064(0x74f)](_0x3de8ec[_0x268935]):[],_0x1d61e6=_0x58bdb0[_0xa06064(0x628)](_0x397655=>eval(_0x397655));break;case _0xa06064(0x83a):_0x1d61e6=_0x3de8ec[_0x268935]!==''?JSON[_0xa06064(0x74f)](_0x3de8ec[_0x268935]):'';break;case'ARRAYJSON':_0x58bdb0=_0x3de8ec[_0x268935]!==''?JSON[_0xa06064(0x74f)](_0x3de8ec[_0x268935]):[],_0x1d61e6=_0x58bdb0[_0xa06064(0x628)](_0x135761=>JSON[_0xa06064(0x74f)](_0x135761));break;case _0xa06064(0x187):_0x1d61e6=_0x3de8ec[_0x268935]!==''?new Function(JSON[_0xa06064(0x74f)](_0x3de8ec[_0x268935])):new Function(_0xa06064(0x503));break;case _0xa06064(0x8b8):_0x58bdb0=_0x3de8ec[_0x268935]!==''?JSON[_0xa06064(0x74f)](_0x3de8ec[_0x268935]):[],_0x1d61e6=_0x58bdb0[_0xa06064(0x628)](_0x40a50f=>new Function(JSON['parse'](_0x40a50f)));break;case'STR':_0x1d61e6=_0x3de8ec[_0x268935]!==''?String(_0x3de8ec[_0x268935]):'';break;case _0xa06064(0x6b0):_0x58bdb0=_0x3de8ec[_0x268935]!==''?JSON[_0xa06064(0x74f)](_0x3de8ec[_0x268935]):[],_0x1d61e6=_0x58bdb0['map'](_0x2404a2=>String(_0x2404a2));break;case _0xa06064(0x960):_0x42cdbe=_0x3de8ec[_0x268935]!==''?JSON[_0xa06064(0x74f)](_0x3de8ec[_0x268935]):{},_0x1c5d2b[_0x560a93]={},VisuMZ[_0xa06064(0x235)](_0x1c5d2b[_0x560a93],_0x42cdbe);continue;case _0xa06064(0x280):_0x58bdb0=_0x3de8ec[_0x268935]!==''?JSON['parse'](_0x3de8ec[_0x268935]):[],_0x1d61e6=_0x58bdb0[_0xa06064(0x628)](_0x50662d=>VisuMZ[_0xa06064(0x235)]({},JSON['parse'](_0x50662d)));break;default:continue;}_0x1c5d2b[_0x560a93]=_0x1d61e6;}}return _0x1c5d2b;},(_0x1682ce=>{const _0x38b989=_0x1a8785,_0x6d340e=_0x1682ce['name'];for(const _0x30f9a9 of dependencies){if(!Imported[_0x30f9a9]){alert('%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.'[_0x38b989(0x22f)](_0x6d340e,_0x30f9a9)),SceneManager['exit']();break;}}const _0x4ac70b=_0x1682ce[_0x38b989(0x3d1)];if(_0x4ac70b[_0x38b989(0x9e0)](/\[Version[ ](.*?)\]/i)){const _0x48933d=Number(RegExp['$1']);_0x48933d!==VisuMZ[label][_0x38b989(0xa23)]&&(alert(_0x38b989(0x5b4)['format'](_0x6d340e,_0x48933d)),SceneManager[_0x38b989(0x821)]());}if(_0x4ac70b['match'](/\[Tier[ ](\d+)\]/i)){const _0x3cffc6=Number(RegExp['$1']);_0x3cffc6<tier?(alert(_0x38b989(0xab9)[_0x38b989(0x22f)](_0x6d340e,_0x3cffc6,tier)),SceneManager[_0x38b989(0x821)]()):tier=Math[_0x38b989(0x5a7)](_0x3cffc6,tier);}VisuMZ[_0x38b989(0x235)](VisuMZ[label]['Settings'],_0x1682ce[_0x38b989(0x536)]);})(pluginData),VisuMZ[_0x1a8785(0x65c)]=function(_0x2dee95){const _0x2003e3=_0x1a8785;let _0x4e086b=[];for(const _0x517606 of _0x2dee95){_0x4e086b=_0x4e086b[_0x2003e3(0x755)](VisuMZ[_0x2003e3(0x38b)](_0x517606));}return _0x4e086b[_0x2003e3(0x70f)](_0x1bade7=>_0x1bade7);},VisuMZ[_0x1a8785(0x38b)]=function(_0x2bef9a){const _0x21ee30=_0x1a8785,_0x40b326=BattleManager[_0x21ee30(0x54d)]()['filter'](_0x5ddee1=>_0x5ddee1&&_0x5ddee1[_0x21ee30(0x46d)]()),_0x11e8e5=BattleManager[_0x21ee30(0x938)],_0x49bcf3=BattleManager[_0x21ee30(0x733)],_0x3ddb8a=BattleManager[_0x21ee30(0x829)]?BattleManager[_0x21ee30(0x829)][_0x21ee30(0xa53)](0x0):_0x40b326;_0x2bef9a=_0x2bef9a[_0x21ee30(0x5dd)]()[_0x21ee30(0x6b6)]();if(_0x2bef9a===_0x21ee30(0x3dc))return[_0x11e8e5];else{if(_0x2bef9a===_0x21ee30(0xaa2))return[_0x49bcf3];else{if(_0x2bef9a===_0x21ee30(0x178)){if(_0x49bcf3){const _0x2be6b4=_0x3ddb8a[_0x21ee30(0x64f)](_0x49bcf3);return _0x2be6b4>=0x0?[_0x3ddb8a[_0x2be6b4-0x1]||_0x49bcf3]:[_0x49bcf3];}}else{if(_0x2bef9a==='text\x20target'){if(_0x49bcf3){const _0x3fbeed=_0x3ddb8a[_0x21ee30(0x64f)](_0x49bcf3);return _0x3fbeed>=0x0?[_0x3ddb8a[_0x3fbeed+0x1]||_0x49bcf3]:[_0x49bcf3];}}else{if(_0x2bef9a===_0x21ee30(0x313))return _0x3ddb8a;else{if(_0x2bef9a===_0x21ee30(0x85a))return[_0x11e8e5][_0x21ee30(0x755)](_0x3ddb8a);else{if(_0x2bef9a==='not\x20focus')return _0x40b326[_0x21ee30(0x70f)](_0x125363=>_0x125363!==_0x11e8e5&&!_0x3ddb8a[_0x21ee30(0xa3e)](_0x125363)&&_0x125363[_0x21ee30(0x49b)]());else{if(_0x2bef9a===_0x21ee30(0x453))return[VisuMZ[_0x21ee30(0x3d4)]()];else{if(_0x2bef9a[_0x21ee30(0x9e0)](/SPECIAL (.*)>/i)){const _0x402e34=String(RegExp['$1'])['split'](',')[_0x21ee30(0x628)](_0x111fcd=>_0x111fcd['trim']());return[VisuMZ[_0x21ee30(0x8fd)](_0x402e34)];}}}}}}}}}if(_0x11e8e5){if(_0x2bef9a==='alive\x20friends')return _0x11e8e5[_0x21ee30(0xb04)]()[_0x21ee30(0x7b2)]();else{if(_0x2bef9a===_0x21ee30(0x58e))return _0x11e8e5[_0x21ee30(0xb04)]()['aliveMembers']()[_0x21ee30(0x70f)](_0x249ddf=>_0x249ddf!==_0x11e8e5);else{if(_0x2bef9a==='alive\x20friends\x20not\x20target')return _0x11e8e5['friendsUnit']()['aliveMembers']()[_0x21ee30(0x70f)](_0x2a62ed=>_0x2a62ed!==_0x49bcf3);else{if(_0x2bef9a===_0x21ee30(0xa92))return _0x11e8e5['friendsUnit']()['deadMembers']();else{if(_0x2bef9a[_0x21ee30(0x9e0)](/FRIEND INDEX (\d+)/i)){const _0x1207e1=Number(RegExp['$1']);return[_0x11e8e5[_0x21ee30(0xb04)]()[_0x21ee30(0x894)]()[_0x1207e1]];}}}}}if(_0x2bef9a===_0x21ee30(0x6dd))return _0x11e8e5[_0x21ee30(0xab4)]()[_0x21ee30(0x7b2)]();else{if(_0x2bef9a===_0x21ee30(0x60c))return _0x11e8e5[_0x21ee30(0xab4)]()[_0x21ee30(0x7b2)]()[_0x21ee30(0x70f)](_0x4c3ab1=>_0x4c3ab1!==_0x49bcf3);else{if(_0x2bef9a==='dead\x20opponents')return _0x11e8e5[_0x21ee30(0xab4)]()['deadMembers']();else{if(_0x2bef9a[_0x21ee30(0x9e0)](/OPPONENT INDEX (\d+)/i)){const _0x3da859=Number(RegExp['$1']);return[_0x11e8e5[_0x21ee30(0xab4)]()[_0x21ee30(0x894)]()[_0x3da859]];}}}}}if(_0x2bef9a===_0x21ee30(0x33b))return $gameParty[_0x21ee30(0x7b2)]();else{if(_0x2bef9a===_0x21ee30(0x669))return $gameParty[_0x21ee30(0x7b2)]()[_0x21ee30(0x70f)](_0x506b1f=>_0x506b1f!==_0x11e8e5);else{if(_0x2bef9a===_0x21ee30(0x373))return $gameParty[_0x21ee30(0x7b2)]()['filter'](_0x297318=>_0x297318!==_0x49bcf3);else{if(_0x2bef9a===_0x21ee30(0x91a))return $gameParty[_0x21ee30(0x4b2)]();else{if(_0x2bef9a['match'](/ACTOR INDEX (\d+)/i)){const _0x2899c3=Number(RegExp['$1']);return[$gameParty[_0x21ee30(0x894)]()[_0x2899c3]];}else{if(_0x2bef9a[_0x21ee30(0x9e0)](/ACTOR ID (\d+)/i)){const _0xd29f09=Number(RegExp['$1']);return[$gameActors[_0x21ee30(0x7fd)](_0xd29f09)];}}}}}}if(_0x2bef9a===_0x21ee30(0x1c7))return $gameTroop[_0x21ee30(0x7b2)]();else{if(_0x2bef9a===_0x21ee30(0xa7d))return $gameTroop[_0x21ee30(0x7b2)]()[_0x21ee30(0x70f)](_0x54a8e3=>_0x54a8e3!==_0x11e8e5);else{if(_0x2bef9a===_0x21ee30(0x5b9))return $gameTroop[_0x21ee30(0x7b2)]()[_0x21ee30(0x70f)](_0x5f1258=>_0x5f1258!==_0x49bcf3);else{if(_0x2bef9a===_0x21ee30(0x195))return $gameTroop[_0x21ee30(0x4b2)]();else{if(_0x2bef9a[_0x21ee30(0x9e0)](/ENEMY INDEX (\d+)/i)){const _0x5e2305=Number(RegExp['$1']);return[$gameTroop[_0x21ee30(0x894)]()[_0x5e2305]];}else{if(_0x2bef9a[_0x21ee30(0x9e0)](/ENEMY ID (\d+)/i)){const _0x11e69c=Number(RegExp['$1']);return $gameTroop[_0x21ee30(0x7b2)]()[_0x21ee30(0x70f)](_0x428cee=>_0x428cee[_0x21ee30(0x667)]()===_0x11e69c);}}}}}}if(_0x2bef9a===_0x21ee30(0x70b))return _0x40b326[_0x21ee30(0x70f)](_0xd2a2c=>_0xd2a2c[_0x21ee30(0x919)]());else{if(_0x2bef9a===_0x21ee30(0x462))return _0x40b326[_0x21ee30(0x70f)](_0x42b6f8=>_0x42b6f8[_0x21ee30(0x919)]()&&_0x42b6f8!==_0x11e8e5);else{if(_0x2bef9a===_0x21ee30(0x4ea))return _0x40b326[_0x21ee30(0x70f)](_0x4b6148=>_0x4b6148[_0x21ee30(0x919)]()&&_0x4b6148!==_0x49bcf3);else{if(_0x2bef9a===_0x21ee30(0x8ff))return _0x40b326[_0x21ee30(0x70f)](_0x1dd53b=>_0x1dd53b[_0x21ee30(0x37f)]());}}}return[];},VisuMZ[_0x1a8785(0x3d4)]=function(){const _0xbfd5b6=_0x1a8785;return BattleManager[_0xbfd5b6(0x733)];},VisuMZ[_0x1a8785(0x8fd)]=function(_0x12c917){const _0x1b2491=_0x1a8785;return BattleManager[_0x1b2491(0x733)];},PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x9c9),_0x1f0e46=>{const _0x3c59b9=_0x1a8785;if(!SceneManager[_0x3c59b9(0x3a8)]())return;VisuMZ['ConvertParams'](_0x1f0e46,_0x1f0e46);const _0x4a8ad0=$gameTemp['getLastPluginCommandInterpreter'](),_0x3c9f31=BattleManager[_0x3c59b9(0x440)],_0x3648d1=BattleManager[_0x3c59b9(0x938)],_0x438d03=BattleManager[_0x3c59b9(0x829)]?BattleManager[_0x3c59b9(0x829)]['slice'](0x0):[],_0x53f6b5=BattleManager[_0x3c59b9(0x2f3)];if(!_0x4a8ad0||!_0x3c9f31||!_0x3648d1)return;if(!_0x3c9f31[_0x3c59b9(0x7e0)]())return;if(_0x1f0e46[_0x3c59b9(0x622)])_0x53f6b5[_0x3c59b9(0x32b)](_0x3648d1,_0x3c9f31[_0x3c59b9(0x7e0)]());_0x1f0e46['ApplyImmortal']&&_0x53f6b5[_0x3c59b9(0x963)]('applyImmortal',_0x3648d1,_0x438d03,!![]);if(_0x1f0e46['ActionStart'])_0x53f6b5[_0x3c59b9(0x963)](_0x3c59b9(0x80d),_0x3648d1,_0x3c9f31);if(_0x1f0e46[_0x3c59b9(0x615)])_0x53f6b5[_0x3c59b9(0x963)]('waitForMovement');if(_0x1f0e46['CastAnimation'])_0x53f6b5['push']('performCastAnimation',_0x3648d1,_0x3c9f31);if(_0x1f0e46[_0x3c59b9(0x598)])_0x53f6b5[_0x3c59b9(0x963)](_0x3c59b9(0x407));_0x4a8ad0[_0x3c59b9(0xab1)](_0x3c59b9(0x468));}),PluginManager['registerCommand'](pluginData['name'],_0x1a8785(0x7dd),_0x177622=>{const _0x79241b=_0x1a8785;if(!SceneManager[_0x79241b(0x3a8)]())return;VisuMZ[_0x79241b(0x235)](_0x177622,_0x177622);const _0xb5adfb=$gameTemp[_0x79241b(0x55b)](),_0x5545c2=BattleManager[_0x79241b(0x440)],_0x300b11=BattleManager[_0x79241b(0x938)],_0x170492=BattleManager[_0x79241b(0x829)]?BattleManager[_0x79241b(0x829)][_0x79241b(0xa53)](0x0):[],_0x5e301e=BattleManager[_0x79241b(0x2f3)],_0x104a8b=_0x177622[_0x79241b(0x6fd)]??![];if(!_0xb5adfb||!_0x5545c2||!_0x300b11)return;if(!_0x5545c2[_0x79241b(0x7e0)]())return;let _0x100c5c=_0x104a8b?_0x5e301e[_0x79241b(0x9e1)](_0x300b11):0x1;for(let _0x51e756=0x0;_0x51e756<_0x100c5c;_0x51e756++){_0x104a8b&&_0x300b11[_0x79241b(0x68d)]()&&_0x5e301e['push']('setActiveWeaponSet',_0x300b11,_0x51e756);if(_0x177622['PerformAction'])_0x5e301e[_0x79241b(0x963)](_0x79241b(0x720),_0x300b11,_0x5545c2);if(_0x177622[_0x79241b(0x9dc)]>0x0)_0x5e301e[_0x79241b(0x963)](_0x79241b(0x491),_0x177622['WaitCount']);if(_0x177622[_0x79241b(0x406)])_0x5e301e[_0x79241b(0x963)](_0x79241b(0x404),_0x300b11,_0x170492,_0x5545c2[_0x79241b(0x7e0)]()[_0x79241b(0xab8)]);if(_0x177622[_0x79241b(0x598)])_0x5e301e[_0x79241b(0x963)](_0x79241b(0x407));for(const _0x4cff15 of _0x170492){if(!_0x4cff15)continue;if(_0x177622[_0x79241b(0x5b8)])_0x5e301e['push'](_0x79241b(0x62b),_0x300b11,_0x4cff15);}}_0x104a8b&&_0x300b11[_0x79241b(0x68d)]()&&_0x5e301e[_0x79241b(0x963)](_0x79241b(0x997),_0x300b11);if(_0x177622[_0x79241b(0x3a2)])_0x5e301e['push']('applyImmortal',_0x300b11,_0x170492,![]);_0xb5adfb[_0x79241b(0xab1)]('battlelog');}),PluginManager['registerCommand'](pluginData['name'],_0x1a8785(0xae3),_0x4e4e33=>{const _0x2c1df9=_0x1a8785;if(!SceneManager[_0x2c1df9(0x3a8)]())return;VisuMZ['ConvertParams'](_0x4e4e33,_0x4e4e33);const _0x1c54e3=$gameTemp[_0x2c1df9(0x55b)](),_0x1d4f76=BattleManager[_0x2c1df9(0x440)],_0x1cd6fc=BattleManager[_0x2c1df9(0x938)],_0x2ee8bf=BattleManager[_0x2c1df9(0x829)]?BattleManager[_0x2c1df9(0x829)]['slice'](0x0):[],_0x452ea8=BattleManager[_0x2c1df9(0x2f3)],_0x474d4b=_0x4e4e33['DualWield']??![];if(!_0x1c54e3||!_0x1d4f76||!_0x1cd6fc)return;if(!_0x1d4f76[_0x2c1df9(0x7e0)]())return;let _0xca811b=_0x474d4b?_0x452ea8[_0x2c1df9(0x9e1)](_0x1cd6fc):0x1;for(let _0xa81d9a=0x0;_0xa81d9a<_0xca811b;_0xa81d9a++){for(const _0x485199 of _0x2ee8bf){if(!_0x485199)continue;_0x474d4b&&_0x1cd6fc[_0x2c1df9(0x68d)]()&&_0x452ea8[_0x2c1df9(0x963)](_0x2c1df9(0x28b),_0x1cd6fc,_0xa81d9a);if(_0x4e4e33['PerformAction'])_0x452ea8[_0x2c1df9(0x963)]('performAction',_0x1cd6fc,_0x1d4f76);if(_0x4e4e33[_0x2c1df9(0x5c4)]>0x0)_0x452ea8[_0x2c1df9(0x963)]('waitCount',_0x4e4e33['WaitCount1']);if(_0x4e4e33[_0x2c1df9(0x406)])_0x452ea8[_0x2c1df9(0x963)](_0x2c1df9(0x404),_0x1cd6fc,[_0x485199],_0x1d4f76[_0x2c1df9(0x7e0)]()[_0x2c1df9(0xab8)]);if(_0x4e4e33[_0x2c1df9(0x9ff)]>0x0)_0x452ea8[_0x2c1df9(0x963)](_0x2c1df9(0x491),_0x4e4e33[_0x2c1df9(0x9ff)]);if(_0x4e4e33[_0x2c1df9(0x5b8)])_0x452ea8['push'](_0x2c1df9(0x62b),_0x1cd6fc,_0x485199);}}_0x474d4b&&_0x1cd6fc[_0x2c1df9(0x68d)]()&&_0x452ea8[_0x2c1df9(0x963)]('clearActiveWeaponSet',_0x1cd6fc);if(_0x4e4e33[_0x2c1df9(0x3a2)])_0x452ea8[_0x2c1df9(0x963)](_0x2c1df9(0x380),_0x1cd6fc,_0x2ee8bf,![]);_0x1c54e3[_0x2c1df9(0xab1)]('battlelog');}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],_0x1a8785(0x226),_0x591a71=>{const _0x1dbbee=_0x1a8785;if(!SceneManager[_0x1dbbee(0x3a8)]())return;VisuMZ[_0x1dbbee(0x235)](_0x591a71,_0x591a71);const _0xcead82=$gameTemp[_0x1dbbee(0x55b)](),_0x2a5e7f=BattleManager[_0x1dbbee(0x440)],_0x2e006d=BattleManager['_subject'],_0x59503b=BattleManager[_0x1dbbee(0x829)]?BattleManager[_0x1dbbee(0x829)][_0x1dbbee(0xa53)](0x0):[],_0x5a77f9=BattleManager['_logWindow'];if(!_0xcead82||!_0x2a5e7f||!_0x2e006d)return;if(!_0x2a5e7f[_0x1dbbee(0x7e0)]())return;if(_0x591a71[_0x1dbbee(0x3a2)])_0x5a77f9[_0x1dbbee(0x963)](_0x1dbbee(0x380),_0x2e006d,_0x59503b,![]);if(_0x591a71[_0x1dbbee(0x5fd)])_0x5a77f9[_0x1dbbee(0x963)](_0x1dbbee(0x389));if(_0x591a71[_0x1dbbee(0xa66)])_0x5a77f9[_0x1dbbee(0x963)]('waitForEffect');if(_0x591a71[_0x1dbbee(0x499)])_0x5a77f9['push'](_0x1dbbee(0x1fb));if(_0x591a71[_0x1dbbee(0x200)])_0x5a77f9[_0x1dbbee(0x963)](_0x1dbbee(0x64a),_0x2e006d);if(_0x591a71['WaitForMovement'])_0x5a77f9[_0x1dbbee(0x963)]('waitForMovement');_0xcead82['setWaitMode'](_0x1dbbee(0x468));}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x30c),_0x54eee2=>{const _0x592879=_0x1a8785;if(!SceneManager[_0x592879(0x3a8)]())return;if(!Imported[_0x592879(0x9de)])return;VisuMZ['ConvertParams'](_0x54eee2,_0x54eee2);const _0xe2c698=$gameTemp[_0x592879(0x55b)](),_0x4a400c=_0x54eee2[_0x592879(0x479)];if(!_0xe2c698)return;$gameScreen[_0x592879(0x90b)](_0x54eee2[_0x592879(0x205)],_0x54eee2[_0x592879(0x918)],_0x54eee2[_0x592879(0x6c4)]);if(_0x4a400c)_0xe2c698[_0x592879(0xab1)](_0x592879(0x6a3));}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],'ActSeq_Angle_Reset',_0x2bf071=>{const _0x388f71=_0x1a8785;if(!SceneManager[_0x388f71(0x3a8)]())return;if(!Imported[_0x388f71(0x9de)])return;VisuMZ[_0x388f71(0x235)](_0x2bf071,_0x2bf071);const _0x2f52a5=$gameTemp[_0x388f71(0x55b)](),_0x412e91=_0x2bf071['WaitForAngle'];if(!_0x2f52a5)return;$gameScreen[_0x388f71(0x90b)](0x0,_0x2bf071['Duration'],_0x2bf071[_0x388f71(0x6c4)]);if(_0x412e91)_0x2f52a5[_0x388f71(0xab1)](_0x388f71(0x6a3));}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],'ActSeq_Angle_WaitForAngle',_0x3921ad=>{const _0x3434e7=_0x1a8785;if(!SceneManager[_0x3434e7(0x3a8)]())return;if(!Imported[_0x3434e7(0x9de)])return;const _0x2c78a5=$gameTemp[_0x3434e7(0x55b)]();if(!_0x2c78a5)return;_0x2c78a5['setWaitMode']('battleAngle');}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],_0x1a8785(0x9e8),_0x27a635=>{const _0x67e54b=_0x1a8785;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x67e54b(0x235)](_0x27a635,_0x27a635);const _0x303c76=$gameTemp[_0x67e54b(0x55b)](),_0x3a9e17=BattleManager[_0x67e54b(0x440)],_0xa69061=BattleManager[_0x67e54b(0x938)],_0x10a1ba=VisuMZ[_0x67e54b(0x65c)](_0x27a635[_0x67e54b(0x7f7)]),_0x5a156d=_0x27a635[_0x67e54b(0x6ca)],_0xf14dae=BattleManager[_0x67e54b(0x2f3)];if(!_0x303c76||!_0x3a9e17||!_0xa69061)return;if(!_0x3a9e17['item']())return;let _0x1a0b58=_0x3a9e17[_0x67e54b(0x7e0)]()[_0x67e54b(0xab8)];if(_0x1a0b58<0x0)_0x1a0b58=_0xa69061[_0x67e54b(0x523)]();$gameTemp[_0x67e54b(0x522)](_0x10a1ba,_0x1a0b58,_0x5a156d),_0x27a635[_0x67e54b(0x598)]&&_0x303c76['setWaitMode'](_0x67e54b(0x2c0));}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x77f),_0x5bb878=>{const _0x26a378=_0x1a8785;if(!SceneManager[_0x26a378(0x3a8)]())return;VisuMZ[_0x26a378(0x235)](_0x5bb878,_0x5bb878);const _0x473c93=$gameTemp[_0x26a378(0x55b)](),_0x29e8a9=BattleManager[_0x26a378(0x938)],_0x79ea78=VisuMZ['CreateActionSequenceTargets'](_0x5bb878[_0x26a378(0x7f7)]),_0x385414=_0x5bb878[_0x26a378(0x6ca)],_0x2ff2d4=BattleManager[_0x26a378(0x2f3)];if(!_0x473c93||!_0x29e8a9)return;const _0x3e4672=_0x29e8a9[_0x26a378(0x523)]();$gameTemp['requestAnimation'](_0x79ea78,_0x3e4672,_0x385414),_0x5bb878[_0x26a378(0x598)]&&_0x473c93[_0x26a378(0xab1)](_0x26a378(0x2c0));}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],_0x1a8785(0x97b),_0x41e5ad=>{const _0x557d88=_0x1a8785;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x557d88(0x235)](_0x41e5ad,_0x41e5ad);const _0x1f85be=_0x5478e8[_0x557d88(0x54c)](_0x41e5ad[_0x557d88(0x202)]);if(_0x1f85be<=0x0)return;const _0x48cd04=$gameTemp[_0x557d88(0x55b)](),_0x5478e8=BattleManager[_0x557d88(0x938)],_0x579f59=VisuMZ['CreateActionSequenceTargets'](_0x41e5ad[_0x557d88(0x7f7)]),_0x5568b8=_0x41e5ad[_0x557d88(0x6ca)],_0x5218fc=BattleManager[_0x557d88(0x2f3)];if(!_0x48cd04||!_0x5478e8)return;$gameTemp['requestAnimation'](_0x579f59,_0x1f85be,_0x5568b8),_0x41e5ad[_0x557d88(0x598)]&&_0x48cd04[_0x557d88(0xab1)]('battleAnimation');}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0xaaf),_0x411685=>{const _0x1bde4c=_0x1a8785;if(!SceneManager[_0x1bde4c(0x3a8)]())return;VisuMZ[_0x1bde4c(0x235)](_0x411685,_0x411685);const _0x3e91a2=$gameTemp[_0x1bde4c(0x55b)](),_0x16007c=BattleManager[_0x1bde4c(0x440)],_0x5bb851=_0x411685[_0x1bde4c(0x6ca)],_0xcc4077=VisuMZ[_0x1bde4c(0x65c)](_0x411685[_0x1bde4c(0x7f7)]);if(!_0x3e91a2||!_0x16007c)return;if(!_0x16007c[_0x1bde4c(0x7e0)]())return;for(const _0x25815f of _0xcc4077){if(!_0x25815f)continue;_0x25815f[_0x1bde4c(0x1df)](_0x16007c,_0x5bb851);}if(_0x411685[_0x1bde4c(0x598)])_0x3e91a2[_0x1bde4c(0xab1)](_0x1bde4c(0x2c0));}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0xa07),_0x51ef4b=>{const _0xa7aa5c=_0x1a8785;VisuMZ['ConvertParams'](_0x51ef4b,_0x51ef4b);const _0xd78bd7=$gameTemp[_0xa7aa5c(0x55b)](),_0x44b819=VisuMZ[_0xa7aa5c(0x65c)](_0x51ef4b[_0xa7aa5c(0x7f7)]),_0x5dd8c1=_0x51ef4b[_0xa7aa5c(0x7aa)];if(!_0x5dd8c1)return;for(const _0x57b1cd of _0x44b819){if(!_0x57b1cd)continue;if(!_0x57b1cd[_0xa7aa5c(0x68d)]())continue;_0x57b1cd['setBattlePortrait'](_0x5dd8c1);}}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x252),_0x8aa6aa=>{const _0x2d94ab=_0x1a8785;if(!SceneManager['_scene'])return;if(!SceneManager[_0x2d94ab(0xa42)][_0x2d94ab(0x589)])return;if(!Imported[_0x2d94ab(0x211)])return;VisuMZ[_0x2d94ab(0x235)](_0x8aa6aa,_0x8aa6aa);const _0x457221=$gameTemp[_0x2d94ab(0x55b)](),_0x3b9938=Math[_0x2d94ab(0x86d)](_0x8aa6aa[_0x2d94ab(0x21a)]),_0x37d528=Math[_0x2d94ab(0x86d)](_0x8aa6aa[_0x2d94ab(0x7bb)]);$gameTemp['requestPointAnimation'](_0x3b9938,_0x37d528,_0x8aa6aa[_0x2d94ab(0x551)],_0x8aa6aa[_0x2d94ab(0x6ca)],_0x8aa6aa[_0x2d94ab(0xa32)]),_0x8aa6aa[_0x2d94ab(0x557)]&&_0x457221&&(SceneManager[_0x2d94ab(0xa42)][_0x2d94ab(0x589)]['updatePointAnimations'](),_0x457221[_0x2d94ab(0xab1)]('battleAnimation'));}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],'ActSeq_Animation_ShowAnimation',_0x5a9e2c=>{const _0x17bba2=_0x1a8785;if(!SceneManager[_0x17bba2(0x3a8)]())return;VisuMZ[_0x17bba2(0x235)](_0x5a9e2c,_0x5a9e2c);const _0x48f8d2=$gameTemp['getLastPluginCommandInterpreter'](),_0x53134f=VisuMZ[_0x17bba2(0x65c)](_0x5a9e2c[_0x17bba2(0x7f7)]),_0x33c57e=_0x5a9e2c['AnimationID'],_0x52ee1c=_0x5a9e2c[_0x17bba2(0x6ca)];if(!_0x48f8d2)return;$gameTemp['requestAnimation'](_0x53134f,_0x33c57e,_0x52ee1c);if(_0x5a9e2c[_0x17bba2(0x598)])_0x48f8d2[_0x17bba2(0xab1)]('battleAnimation');}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x18e),_0x1844e2=>{const _0x56b085=_0x1a8785;if(!SceneManager[_0x56b085(0x3a8)]())return;const _0x66941c=$gameTemp[_0x56b085(0x55b)]();if(!_0x66941c)return;_0x66941c[_0x56b085(0xab1)](_0x56b085(0x2c0));}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],'ActSeq_BattleLog_AddText',_0x3f0598=>{const _0x356846=_0x1a8785;if(!SceneManager[_0x356846(0x3a8)]())return;VisuMZ['ConvertParams'](_0x3f0598,_0x3f0598);const _0x3f9ab5=BattleManager['_logWindow'],_0x42296e=_0x3f0598[_0x356846(0x341)]&&Imported[_0x356846(0xa9e)];_0x3f9ab5[_0x356846(0x9a4)](_0x3f0598[_0x356846(0xa81)]),_0x42296e&&Imported[_0x356846(0xa9e)]&&$gameSystem[_0x356846(0x889)](_0x3f0598['Text']||'',_0x3f0598['CombatLogIcon']||0x0);}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],'ActSeq_BattleLog_Clear',_0x24f799=>{const _0x2d2dd6=_0x1a8785;if(!SceneManager['isSceneBattle']())return;const _0x456a08=BattleManager[_0x2d2dd6(0x2f3)];_0x456a08['clear']();}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x5e8),_0x3b4df3=>{const _0xb60785=_0x1a8785;if(!SceneManager[_0xb60785(0x3a8)]())return;const _0x281c46=$gameTemp['getLastPluginCommandInterpreter'](),_0x52f3ca=BattleManager[_0xb60785(0x440)],_0x3b2376=BattleManager[_0xb60785(0x938)],_0x1567f7=BattleManager[_0xb60785(0x2f3)];if(!_0x281c46||!_0x52f3ca||!_0x3b2376)return;if(!_0x52f3ca[_0xb60785(0x7e0)]())return;_0x1567f7['displayAction'](_0x3b2376,_0x52f3ca['item']()),_0x281c46[_0xb60785(0xab1)](_0xb60785(0x468));}),PluginManager['registerCommand'](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x9d7),_0x27565e=>{const _0x3c425c=_0x1a8785;if(!SceneManager[_0x3c425c(0x3a8)]())return;const _0x566072=BattleManager[_0x3c425c(0x2f3)];_0x566072['popBaseLine']();}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],'ActSeq_BattleLog_PushBaseLine',_0x1c5f8d=>{const _0x32ae47=_0x1a8785;if(!SceneManager[_0x32ae47(0x3a8)]())return;const _0xac35ee=BattleManager[_0x32ae47(0x2f3)];_0xac35ee['pushBaseLine']();}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],_0x1a8785(0x7bd),_0x39b997=>{const _0x5d1bf0=_0x1a8785;if(!SceneManager['isSceneBattle']())return;const _0x7db137=BattleManager['_logWindow'];_0x7db137[_0x5d1bf0(0x4cd)]();}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x8fa),_0x364e48=>{const _0x3165de=_0x1a8785;if(!SceneManager[_0x3165de(0x3a8)]())return;VisuMZ[_0x3165de(0x235)](_0x364e48,_0x364e48),SceneManager[_0x3165de(0xa42)][_0x3165de(0x839)](_0x364e48[_0x3165de(0x459)]);}),PluginManager['registerCommand'](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x250),_0x1691d2=>{const _0xc9a569=_0x1a8785;if(!SceneManager[_0xc9a569(0x3a8)]())return;const _0x1d235b=$gameTemp[_0xc9a569(0x55b)]();_0x1d235b[_0xc9a569(0xab1)](_0xc9a569(0x468));}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],_0x1a8785(0x423),_0x111c24=>{const _0x14932c=_0x1a8785;if(!SceneManager[_0x14932c(0x3a8)]())return;const _0x4575c7=$gameTemp['getLastPluginCommandInterpreter'](),_0x2692b9=BattleManager[_0x14932c(0x2f3)];_0x2692b9[_0x14932c(0x389)](),_0x4575c7[_0x14932c(0xab1)](_0x14932c(0x468));}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0xa1c),_0x34c41b=>{const _0x509f69=_0x1a8785;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x509f69(0x9de)])return;VisuMZ[_0x509f69(0x235)](_0x34c41b,_0x34c41b);const _0x16d184=$gameScreen[_0x509f69(0x911)]();_0x16d184[_0x509f69(0x1b6)]=_0x34c41b['Setting'];}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],'ActSeq_Camera_FocusPoint',_0x5a9773=>{const _0x3b7461=_0x1a8785;if(!SceneManager[_0x3b7461(0x3a8)]())return;if(!Imported[_0x3b7461(0x9de)])return;VisuMZ['ConvertParams'](_0x5a9773,_0x5a9773);const _0x3cd24b=$gameTemp[_0x3b7461(0x55b)](),_0x19f243=_0x5a9773[_0x3b7461(0x900)];$gameScreen[_0x3b7461(0x3ba)](_0x5a9773[_0x3b7461(0x34d)],_0x5a9773[_0x3b7461(0x500)],_0x5a9773[_0x3b7461(0x918)],_0x5a9773[_0x3b7461(0x6c4)]);if(_0x19f243)_0x3cd24b[_0x3b7461(0xab1)](_0x3b7461(0x638));}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x641),_0x167ad3=>{const _0x13c741=_0x1a8785;if(!SceneManager[_0x13c741(0x3a8)]())return;if(!Imported['VisuMZ_3_ActSeqCamera'])return;VisuMZ[_0x13c741(0x235)](_0x167ad3,_0x167ad3);const _0x507e1c=$gameTemp[_0x13c741(0x55b)](),_0x5bd837=VisuMZ[_0x13c741(0x65c)](_0x167ad3['Targets']),_0x546394=_0x167ad3[_0x13c741(0x900)];$gameScreen['setBattleCameraTargets'](_0x5bd837,_0x167ad3[_0x13c741(0x918)],_0x167ad3[_0x13c741(0x6c4)]);if(_0x546394)_0x507e1c[_0x13c741(0xab1)](_0x13c741(0x638));}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],_0x1a8785(0x8ad),_0x14bf59=>{const _0x20e8bf=_0x1a8785;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x20e8bf(0x9de)])return;VisuMZ[_0x20e8bf(0x235)](_0x14bf59,_0x14bf59);const _0x545b7a=$gameTemp[_0x20e8bf(0x55b)](),_0x57b9e9=_0x14bf59[_0x20e8bf(0x900)];$gameScreen[_0x20e8bf(0x70a)](_0x14bf59['OffsetX'],_0x14bf59[_0x20e8bf(0x4bf)],_0x14bf59[_0x20e8bf(0x918)],_0x14bf59[_0x20e8bf(0x6c4)]);if(_0x57b9e9)_0x545b7a['setWaitMode']('battleCamera');}),PluginManager['registerCommand'](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x87a),_0x152266=>{const _0x3a913a=_0x1a8785;if(!SceneManager[_0x3a913a(0x3a8)]())return;if(!Imported[_0x3a913a(0x9de)])return;VisuMZ[_0x3a913a(0x235)](_0x152266,_0x152266);const _0x1403f0=$gameTemp[_0x3a913a(0x55b)](),_0x18686a=_0x152266[_0x3a913a(0xa85)],_0xde4486=_0x152266['ResetOffset'],_0x40a4de=_0x152266[_0x3a913a(0x900)];if(_0x18686a){const _0x51b4f0=Math[_0x3a913a(0x86d)](Graphics[_0x3a913a(0x92d)]/0x2),_0x3572aa=Math[_0x3a913a(0x86d)](Graphics[_0x3a913a(0x98e)]/0x2);$gameScreen[_0x3a913a(0x3ba)](_0x51b4f0,_0x3572aa,_0x152266['Duration'],_0x152266[_0x3a913a(0x6c4)]);}_0xde4486&&$gameScreen[_0x3a913a(0x70a)](0x0,0x0,_0x152266[_0x3a913a(0x918)],_0x152266['EasingType']);if(_0x40a4de)_0x1403f0['setWaitMode'](_0x3a913a(0x638));}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x2f7),_0x2a19fc=>{const _0xd7278f=_0x1a8785;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0xd7278f(0x9de)])return;const _0x2b843d=$gameTemp[_0xd7278f(0x55b)]();if(!_0x2b843d)return;_0x2b843d[_0xd7278f(0xab1)]('battleCamera');}),VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x4cc)]=function(_0x52bc04){const _0x28ed30=_0x1a8785;_0x52bc04['portraitFilename']='';const _0x443537=VisuMZ[_0x28ed30(0x3af)]['CreateCutinSettings'](_0x52bc04),_0x5017c5=VisuMZ[_0x28ed30(0x65c)](_0x52bc04[_0x28ed30(0x7f7)])[0x0]||null;return _0x5017c5&&(_0x443537[_0x28ed30(0x2e8)]=_0x5017c5[_0x28ed30(0xa29)](),_0x443537['portraitIndex']=_0x5017c5[_0x28ed30(0x612)](),_0x443537[_0x28ed30(0xa2e)]=_0x5017c5[_0x28ed30(0x1cb)](),_0x443537[_0x28ed30(0x4fe)]=_0x5017c5[_0x28ed30(0x565)](),_0x5017c5[_0x28ed30(0x3a6)]()&&(_0x5017c5[_0x28ed30(0x962)]()&&(_0x443537['portraitFlipHorz']=!_0x443537[_0x28ed30(0x40f)]),_0x5017c5[_0x28ed30(0x914)]()&&(_0x443537[_0x28ed30(0x4aa)]=!_0x443537['portraitFlipVert']),_0x443537[_0x28ed30(0x4fe)]===_0x28ed30(0x585)&&(_0x443537[_0x28ed30(0x40f)]=!_0x443537['portraitFlipHorz']),_0x52bc04[_0x28ed30(0xa26)]['parallaxScrollXinvertEnemy']&&(_0x443537[_0x28ed30(0x573)]*=-0x1),_0x52bc04[_0x28ed30(0xa26)][_0x28ed30(0x53a)]&&(_0x443537[_0x28ed30(0x23a)]*=-0x1),_0x443537[_0x28ed30(0x1fc)]+=_0x52bc04[_0x28ed30(0xa26)][_0x28ed30(0x961)]??0x0)),_0x443537;},PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0xac4),_0x1bb883=>{const _0x462a94=_0x1a8785;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x462a94(0x99a)])return;VisuMZ['ConvertParams'](_0x1bb883,_0x1bb883);const _0x18d687=VisuMZ[_0x462a94(0x83c)][_0x462a94(0x4cc)](_0x1bb883);SceneManager['_scene'][_0x462a94(0x1eb)](_0x18d687);const _0x297908=$gameTemp[_0x462a94(0x55b)]();_0x297908&&_0x1bb883[_0x462a94(0x2c9)]&&_0x297908[_0x462a94(0xab1)]('cutinEnter');}),PluginManager['registerCommand'](pluginData['name'],_0x1a8785(0x9ea),_0x24d5cc=>{const _0x3e97fa=_0x1a8785;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x3e97fa(0x99a)])return;VisuMZ[_0x3e97fa(0x235)](_0x24d5cc,_0x24d5cc),SceneManager[_0x3e97fa(0xa42)][_0x3e97fa(0x5d3)]();const _0x3798a6=$gameTemp['getLastPluginCommandInterpreter']();_0x3798a6&&_0x24d5cc['WaitForExit']&&_0x3798a6[_0x3e97fa(0xab1)](_0x3e97fa(0x576));}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],_0x1a8785(0x771),_0x334c6e=>{const _0x4069ee=_0x1a8785;if(!SceneManager[_0x4069ee(0x3a8)]())return;if(!Imported[_0x4069ee(0x99a)])return;VisuMZ['ConvertParams'](_0x334c6e,_0x334c6e);const _0x3149d7=_0x334c6e[_0x4069ee(0x888)][_0x4069ee(0x5dd)]()['trim']();SceneManager['_scene'][_0x4069ee(0x296)](_0x3149d7);const _0x526309=$gameTemp['getLastPluginCommandInterpreter']();_0x526309&&_0x334c6e['WaitForExit']&&_0x526309[_0x4069ee(0xab1)]('cutinExit');}),PluginManager['registerCommand'](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x872),_0x5cb3c9=>{const _0x27e343=_0x1a8785;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x27e343(0x99a)])return;const _0x50ffde=$gameTemp[_0x27e343(0x55b)]();_0x50ffde[_0x27e343(0xab1)](_0x27e343(0x42f));}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0xa8a),_0x1d716d=>{const _0x4f4252=_0x1a8785;if(!SceneManager[_0x4f4252(0x3a8)]())return;if(!Imported[_0x4f4252(0x99a)])return;const _0x53b407=$gameTemp[_0x4f4252(0x55b)]();_0x53b407['setWaitMode'](_0x4f4252(0x576));}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x8ab),_0x1c861e=>{const _0x423e51=_0x1a8785;if(!SceneManager[_0x423e51(0x3a8)]())return;if(!Imported[_0x423e51(0x28d)])return;VisuMZ[_0x423e51(0x235)](_0x1c861e,_0x1c861e);const _0x562932=VisuMZ['CreateActionSequenceTargets'](_0x1c861e[_0x423e51(0x7f7)]),_0x15d090=_0x1c861e[_0x423e51(0x60e)]['toLowerCase']()[_0x423e51(0x6b6)]();for(const _0x561378 of _0x562932){if(!_0x561378)continue;_0x561378[_0x423e51(0x1ff)](_0x15d090);}}),PluginManager['registerCommand'](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x860),_0x3bee11=>{const _0x3e93d2=_0x1a8785;if(!SceneManager[_0x3e93d2(0x3a8)]())return;if(!Imported[_0x3e93d2(0x28d)])return;VisuMZ[_0x3e93d2(0x235)](_0x3bee11,_0x3bee11);const _0x50edcf=VisuMZ[_0x3e93d2(0x65c)](_0x3bee11['Targets']),_0x486df7=_0x3bee11[_0x3e93d2(0x37e)];for(const _0x534728 of _0x50edcf){if(!_0x534728)continue;_0x534728[_0x3e93d2(0x903)]()[_0x3e93d2(0x572)]=_0x486df7;}}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],_0x1a8785(0x449),_0xc991d6=>{const _0x2b7254=_0x1a8785;if(!SceneManager[_0x2b7254(0x3a8)]())return;if(!Imported['VisuMZ_1_ElementStatusCore'])return;VisuMZ[_0x2b7254(0x235)](_0xc991d6,_0xc991d6);const _0x366508=BattleManager[_0x2b7254(0x440)],_0xed037a=_0xc991d6[_0x2b7254(0x249)];if(!_0x366508)return;_0x366508[_0x2b7254(0x1da)]=_0xed037a;}),PluginManager['registerCommand'](pluginData[_0x1a8785(0x1f2)],'ActSeq_Element_Clear',_0x287760=>{const _0x37dbbc=_0x1a8785;if(!SceneManager[_0x37dbbc(0x3a8)]())return;if(!Imported[_0x37dbbc(0x6be)])return;const _0x29845c=BattleManager[_0x37dbbc(0x440)];if(!_0x29845c)return;_0x29845c[_0x37dbbc(0x192)]();}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x858),_0x3f1cf6=>{const _0x38d69d=_0x1a8785;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x38d69d(0x6be)])return;VisuMZ[_0x38d69d(0x235)](_0x3f1cf6,_0x3f1cf6);const _0x3e1454=BattleManager[_0x38d69d(0x440)],_0xe0c285=_0x3f1cf6[_0x38d69d(0x249)];if(!_0x3e1454)return;_0x3e1454[_0x38d69d(0x46a)]=_0xe0c285;}),PluginManager['registerCommand'](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x81f),_0x1bda3e=>{const _0x532df1=_0x1a8785;if(!SceneManager[_0x532df1(0x3a8)]())return;if(!Imported[_0x532df1(0x6be)])return;const _0x1a5107=BattleManager[_0x532df1(0x440)];if(!_0x1a5107)return;_0x1a5107[_0x532df1(0xa54)]=!![];}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],'ActSeq_Horror_Clear',_0x4dcd80=>{const _0x398e4e=_0x1a8785;if(!Imported[_0x398e4e(0x2ff)])return;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x398e4e(0x235)](_0x4dcd80,_0x4dcd80);const _0x89c8c2=VisuMZ[_0x398e4e(0x65c)](_0x4dcd80[_0x398e4e(0x7f7)]);for(const _0x47ef99 of _0x89c8c2){if(!_0x47ef99)continue;_0x47ef99[_0x398e4e(0xae5)]('noise'),_0x47ef99[_0x398e4e(0xae5)](_0x398e4e(0xa45)),_0x47ef99[_0x398e4e(0xae5)]('tv'),_0x47ef99[_0x398e4e(0x7a5)]();}$gamePlayer['refresh']();}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x2da),_0x5dc11d=>{const _0x164e5d=_0x1a8785;if(!Imported['VisuMZ_2_HorrorEffects'])return;if(!SceneManager[_0x164e5d(0x3a8)]())return;VisuMZ[_0x164e5d(0x235)](_0x5dc11d,_0x5dc11d);const _0x269ff6=VisuMZ['CreateActionSequenceTargets'](_0x5dc11d['Targets']),_0x292971=_0x164e5d(0xa45);_0x5dc11d[_0x164e5d(0x7fc)]=Math[_0x164e5d(0x348)](_0x5dc11d[_0x164e5d(0x89f)]/0x2),_0x5dc11d[_0x164e5d(0x965)]=_0x5dc11d[_0x164e5d(0x89f)],_0x5dc11d['refreshRequest']=!![];for(const _0x28be09 of _0x269ff6){if(!_0x28be09)continue;_0x28be09[_0x164e5d(0x21b)](_0x292971,_0x5dc11d);}$gamePlayer[_0x164e5d(0x4cd)]();}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],'ActSeq_Horror_GlitchRemove',_0x3e157d=>{const _0x699e83=_0x1a8785;if(!Imported[_0x699e83(0x2ff)])return;if(!SceneManager[_0x699e83(0x3a8)]())return;VisuMZ[_0x699e83(0x235)](_0x3e157d,_0x3e157d);const _0x117b4f=VisuMZ['CreateActionSequenceTargets'](_0x3e157d[_0x699e83(0x7f7)]);for(const _0x50811c of _0x117b4f){if(!_0x50811c)continue;_0x50811c[_0x699e83(0xae5)](_0x699e83(0xa45));}$gamePlayer['refresh']();}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x652),_0xb9808f=>{const _0x443d4d=_0x1a8785;if(!Imported[_0x443d4d(0x2ff)])return;if(!SceneManager[_0x443d4d(0x3a8)]())return;VisuMZ[_0x443d4d(0x235)](_0xb9808f,_0xb9808f);const _0x34dbab=VisuMZ[_0x443d4d(0x65c)](_0xb9808f[_0x443d4d(0x7f7)]),_0x448141=_0x443d4d(0x800);for(const _0x74454a of _0x34dbab){if(!_0x74454a)continue;_0x74454a[_0x443d4d(0x21b)](_0x448141,_0xb9808f);}$gamePlayer[_0x443d4d(0x4cd)]();}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],_0x1a8785(0x980),_0x27d219=>{const _0x2a4299=_0x1a8785;if(!Imported[_0x2a4299(0x2ff)])return;if(!SceneManager[_0x2a4299(0x3a8)]())return;VisuMZ[_0x2a4299(0x235)](_0x27d219,_0x27d219);const _0x3e44de=VisuMZ[_0x2a4299(0x65c)](_0x27d219[_0x2a4299(0x7f7)]);for(const _0x2b5afb of _0x3e44de){if(!_0x2b5afb)continue;_0x2b5afb[_0x2a4299(0xae5)](_0x2a4299(0x800));}$gamePlayer[_0x2a4299(0x4cd)]();}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],'ActSeq_Horror_TVCreate',_0x13e2a1=>{const _0xf9a7b0=_0x1a8785;if(!Imported[_0xf9a7b0(0x2ff)])return;if(!SceneManager[_0xf9a7b0(0x3a8)]())return;VisuMZ['ConvertParams'](_0x13e2a1,_0x13e2a1);const _0x241437=VisuMZ[_0xf9a7b0(0x65c)](_0x13e2a1['Targets']),_0x376348='tv';for(const _0x2a420b of _0x241437){if(!_0x2a420b)continue;_0x2a420b['setHorrorEffectSettings'](_0x376348,_0x13e2a1);}$gamePlayer[_0xf9a7b0(0x4cd)]();}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x794),_0xf54e51=>{const _0x49ae27=_0x1a8785;if(!Imported[_0x49ae27(0x2ff)])return;if(!SceneManager[_0x49ae27(0x3a8)]())return;VisuMZ[_0x49ae27(0x235)](_0xf54e51,_0xf54e51);const _0x434a19=VisuMZ['CreateActionSequenceTargets'](_0xf54e51[_0x49ae27(0x7f7)]);for(const _0x3c6c86 of _0x434a19){if(!_0x3c6c86)continue;_0x3c6c86[_0x49ae27(0xae5)]('tv');}$gamePlayer[_0x49ae27(0x4cd)]();}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],_0x1a8785(0x77e),_0x382eff=>{const _0x504068=_0x1a8785;if(!Imported[_0x504068(0x9d4)])return;const _0x6cd4cc=SceneManager[_0x504068(0xa42)][_0x504068(0x589)];if(!_0x6cd4cc)return;if(VisuMZ[_0x504068(0x94d)]['version']<=1.04){alert('Action\x20Sequence\x20Impact\x20needs\x20an\x20update!'),SceneManager[_0x504068(0x821)]();return;}VisuMZ['ConvertParams'](_0x382eff,_0x382eff);const _0x44a529=_0x382eff[_0x504068(0x6db)];_0x6cd4cc['setupBlueRedInvertImpactFilter'](_0x44a529);}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x697),_0x2ac1bb=>{const _0xc4cb02=_0x1a8785;if(!SceneManager[_0xc4cb02(0x3a8)]())return;if(!Imported[_0xc4cb02(0x9d4)])return;const _0x38bff9=SceneManager[_0xc4cb02(0xa42)][_0xc4cb02(0x589)];if(!_0x38bff9)return;VisuMZ[_0xc4cb02(0x235)](_0x2ac1bb,_0x2ac1bb);const _0x594876=_0x2ac1bb[_0xc4cb02(0xb06)]||0x1,_0x5955cb=_0x2ac1bb[_0xc4cb02(0x918)]||0x1,_0xe67cf4=_0x2ac1bb[_0xc4cb02(0x6c4)]||_0xc4cb02(0x434);_0x38bff9[_0xc4cb02(0xa18)](_0x594876,_0x5955cb,_0xe67cf4);}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],_0x1a8785(0x834),_0x2eeab5=>{const _0x2c1167=_0x1a8785;if(!Imported['VisuMZ_3_ActSeqImpact'])return;const _0x581db6=SceneManager[_0x2c1167(0xa42)][_0x2c1167(0x589)];if(!_0x581db6)return;if(VisuMZ[_0x2c1167(0x94d)][_0x2c1167(0xa23)]<=1.04){alert(_0x2c1167(0x8e1)),SceneManager['exit']();return;}VisuMZ[_0x2c1167(0x235)](_0x2eeab5,_0x2eeab5);const _0x54224e=_0x2eeab5['Enable'];_0x581db6['setupDesaturateImpactFilter'](_0x54224e);}),PluginManager['registerCommand'](pluginData['name'],_0x1a8785(0x6f8),_0x4b2a85=>{const _0x39c23c=_0x1a8785;if(!SceneManager[_0x39c23c(0x3a8)]())return;if(!Imported[_0x39c23c(0x9d4)])return;const _0x3bc0f7=SceneManager[_0x39c23c(0xa42)][_0x39c23c(0x589)];if(!_0x3bc0f7)return;VisuMZ[_0x39c23c(0x235)](_0x4b2a85,_0x4b2a85);const _0x210f7a=Number(_0x4b2a85[_0x39c23c(0x205)])||0x0,_0x592a83=Number(_0x4b2a85['Rate']),_0x25ac40=_0x4b2a85[_0x39c23c(0x918)]||0x1,_0x269fe3=_0x4b2a85['EasingType']||_0x39c23c(0x434);_0x3bc0f7[_0x39c23c(0x706)](_0x210f7a,_0x592a83,_0x25ac40,_0x269fe3);}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x563),_0x2c37bb=>{const _0x304b70=_0x1a8785;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x304b70(0x9d4)])return;const _0x2fbfa3=SceneManager['_scene'][_0x304b70(0x589)];if(!_0x2fbfa3)return;VisuMZ[_0x304b70(0x235)](_0x2c37bb,_0x2c37bb);const _0x1504ca=Number(_0x2c37bb['Angle'])||0x0,_0x337ee4=Number(_0x2c37bb[_0x304b70(0x272)]),_0x164ab7=_0x2c37bb[_0x304b70(0x918)]||0x1,_0x3ef75a=_0x2c37bb['EasingType']||'Linear',_0x460cdb=VisuMZ[_0x304b70(0x65c)](_0x2c37bb[_0x304b70(0x7f7)]);for(const _0x47fb9c of _0x460cdb){if(!_0x47fb9c)continue;if(!_0x47fb9c[_0x304b70(0x89e)]())continue;_0x47fb9c[_0x304b70(0x89e)]()[_0x304b70(0x706)](_0x1504ca,_0x337ee4,_0x164ab7,_0x3ef75a);}}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],_0x1a8785(0x93c),_0xc7db8e=>{const _0x1d9caa=_0x1a8785;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x1d9caa(0x9d4)])return;VisuMZ[_0x1d9caa(0x235)](_0xc7db8e,_0xc7db8e);const _0x417a79={'delay':_0xc7db8e[_0x1d9caa(0x36f)],'duration':_0xc7db8e[_0x1d9caa(0x3a0)],'hue':_0xc7db8e[_0x1d9caa(0x892)],'opacityStart':_0xc7db8e[_0x1d9caa(0x41d)],'tone':_0xc7db8e[_0x1d9caa(0x472)],'visible':!![]},_0x284bed=VisuMZ['CreateActionSequenceTargets'](_0xc7db8e['Targets']);for(const _0x50ba7d of _0x284bed){if(!_0x50ba7d)continue;_0x50ba7d['setBattlerMotionTrailData'](_0x417a79);}}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x7e6),_0xccbe72=>{const _0xc8df89=_0x1a8785;if(!SceneManager[_0xc8df89(0x3a8)]())return;if(!Imported[_0xc8df89(0x9d4)])return;VisuMZ[_0xc8df89(0x235)](_0xccbe72,_0xccbe72);const _0x4ccb14=VisuMZ['CreateActionSequenceTargets'](_0xccbe72[_0xc8df89(0x7f7)]);for(const _0x1017c1 of _0x4ccb14){if(!_0x1017c1)continue;_0x1017c1[_0xc8df89(0x93e)]();}}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],_0x1a8785(0x740),_0x20dcf7=>{const _0x1f3bb1=_0x1a8785;if(!Imported['VisuMZ_3_ActSeqImpact'])return;const _0x2ade73=SceneManager[_0x1f3bb1(0xa42)][_0x1f3bb1(0x589)];if(!_0x2ade73)return;if(VisuMZ[_0x1f3bb1(0x94d)][_0x1f3bb1(0xa23)]<=1.04){alert(_0x1f3bb1(0x8e1)),SceneManager[_0x1f3bb1(0x821)]();return;}VisuMZ[_0x1f3bb1(0x235)](_0x20dcf7,_0x20dcf7);const _0x488635=_0x20dcf7[_0x1f3bb1(0x6db)];_0x2ade73[_0x1f3bb1(0xa10)](_0x488635);}),PluginManager['registerCommand'](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x1f5),_0x5875e9=>{const _0xb806b2=_0x1a8785;if(!Imported[_0xb806b2(0x9d4)])return;const _0x5a91b3=SceneManager[_0xb806b2(0xa42)][_0xb806b2(0x589)];if(!_0x5a91b3)return;if(VisuMZ['ActSeqImpact'][_0xb806b2(0xa23)]<=1.04){alert('Action\x20Sequence\x20Impact\x20needs\x20an\x20update!'),SceneManager['exit']();return;}VisuMZ[_0xb806b2(0x235)](_0x5875e9,_0x5875e9);const _0x1fe6f8=_0x5875e9[_0xb806b2(0x6db)];_0x5a91b3[_0xb806b2(0x70d)](_0x1fe6f8);}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],'ActSeq_Impact_ShockwavePoint',_0x46a0d5=>{const _0x110ab9=_0x1a8785;if(!Imported[_0x110ab9(0x9d4)])return;const _0x3a77b3=SceneManager[_0x110ab9(0xa42)][_0x110ab9(0x589)];if(!_0x3a77b3)return;VisuMZ['ConvertParams'](_0x46a0d5,_0x46a0d5);const _0xc8298c=_0x46a0d5['X']||0x0,_0x4658f1=_0x46a0d5['Y']||0x0,_0x54567f=_0x46a0d5[_0x110ab9(0x267)]||0x0,_0x5415df=_0x46a0d5[_0x110ab9(0x864)]||0x0,_0xb49e74=_0x46a0d5[_0x110ab9(0x918)]||0x1;_0x3a77b3['setupShockwaveImpactFilter'](_0xc8298c,_0x4658f1,_0x54567f,_0x5415df,_0xb49e74);}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],_0x1a8785(0xa6a),_0x2f463d=>{const _0x365dc2=_0x1a8785;if(!SceneManager[_0x365dc2(0x3a8)]())return;if(!Imported[_0x365dc2(0x9d4)])return;const _0x1a2eba=SceneManager[_0x365dc2(0xa42)][_0x365dc2(0x589)];if(!_0x1a2eba)return;VisuMZ[_0x365dc2(0x235)](_0x2f463d,_0x2f463d);const _0x5389a9=VisuMZ[_0x365dc2(0x65c)](_0x2f463d[_0x365dc2(0x7f7)]),_0x5527d8=_0x2f463d[_0x365dc2(0x5f4)],_0x2d091f=_0x2f463d[_0x365dc2(0xa93)]||0x0,_0x11e28e=_0x2f463d[_0x365dc2(0x4bf)]||0x0,_0x525a54=_0x2f463d[_0x365dc2(0x267)]||0x0,_0x1aa81d=_0x2f463d['Wave']||0x0,_0x36d6e1=_0x2f463d['Duration']||0x1;for(const _0x46e86f of _0x5389a9){if(!_0x46e86f)continue;if(!_0x46e86f[_0x365dc2(0x89e)]())continue;const _0x46853a=_0x46e86f[_0x365dc2(0x89e)]();let _0x5b1d97=_0x46853a[_0x365dc2(0x6c5)],_0xb9c442=_0x46853a[_0x365dc2(0x236)];_0x5b1d97+=(Graphics[_0x365dc2(0x92d)]-Graphics[_0x365dc2(0x9ab)])/0x2,_0xb9c442+=(Graphics[_0x365dc2(0x98e)]-Graphics['boxHeight'])/0x2;if(_0x5527d8[_0x365dc2(0x9e0)](/front/i))_0x5b1d97+=(_0x46e86f[_0x365dc2(0x3a6)]()?0x1:-0x1)*_0x46853a[_0x365dc2(0x4a2)]()/0x2;else _0x5527d8[_0x365dc2(0x9e0)](/back/i)&&(_0x5b1d97+=(_0x46e86f[_0x365dc2(0x3a6)]()?-0x1:0x1)*_0x46853a['mainSpriteWidth']()/0x2);if(_0x5527d8[_0x365dc2(0x9e0)](/head/i))_0xb9c442-=_0x46853a[_0x365dc2(0x27b)]();else _0x5527d8[_0x365dc2(0x9e0)](/center/i)&&(_0xb9c442-=_0x46853a[_0x365dc2(0x27b)]()/0x2);_0x5b1d97+=_0x2d091f,_0xb9c442+=_0x11e28e,_0x1a2eba[_0x365dc2(0x993)](_0x5b1d97,_0xb9c442,_0x525a54,_0x1aa81d,_0x36d6e1);}}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],_0x1a8785(0x629),_0x105cae=>{const _0xe2dbe0=_0x1a8785;if(!SceneManager[_0xe2dbe0(0x3a8)]())return;if(!Imported[_0xe2dbe0(0x9d4)])return;const _0x272a99=SceneManager[_0xe2dbe0(0xa42)]['_spriteset'];if(!_0x272a99)return;VisuMZ['ConvertParams'](_0x105cae,_0x105cae);const _0x2e00e9=VisuMZ[_0xe2dbe0(0x65c)](_0x105cae['Targets']),_0x3dcc24=_0x105cae[_0xe2dbe0(0x5f4)],_0x11e778=_0x105cae[_0xe2dbe0(0xa93)]||0x0,_0x434ecf=_0x105cae[_0xe2dbe0(0x4bf)]||0x0,_0x1c1b17=_0x105cae['Amp']||0x0,_0x5954ed=_0x105cae[_0xe2dbe0(0x864)]||0x0,_0x45b7df=_0x105cae[_0xe2dbe0(0x918)]||0x1,_0x3d2efe=Math[_0xe2dbe0(0xae7)](..._0x2e00e9[_0xe2dbe0(0x628)](_0x523296=>_0x523296[_0xe2dbe0(0x89e)]()['_baseX']-_0x523296[_0xe2dbe0(0x89e)]()[_0xe2dbe0(0x4a2)]()/0x2)),_0x1864ad=Math[_0xe2dbe0(0x5a7)](..._0x2e00e9[_0xe2dbe0(0x628)](_0x5ed52b=>_0x5ed52b[_0xe2dbe0(0x89e)]()[_0xe2dbe0(0x6c5)]+_0x5ed52b[_0xe2dbe0(0x89e)]()[_0xe2dbe0(0x4a2)]()/0x2)),_0x461116=Math[_0xe2dbe0(0xae7)](..._0x2e00e9[_0xe2dbe0(0x628)](_0x4a6973=>_0x4a6973[_0xe2dbe0(0x89e)]()[_0xe2dbe0(0x236)]-_0x4a6973[_0xe2dbe0(0x89e)]()[_0xe2dbe0(0x27b)]())),_0x6cbe3d=Math['max'](..._0x2e00e9[_0xe2dbe0(0x628)](_0x882f32=>_0x882f32[_0xe2dbe0(0x89e)]()[_0xe2dbe0(0x236)])),_0x546bac=_0x2e00e9[_0xe2dbe0(0x70f)](_0x130310=>_0x130310[_0xe2dbe0(0x68d)]())['length'],_0x57e0be=_0x2e00e9[_0xe2dbe0(0x70f)](_0x96c935=>_0x96c935[_0xe2dbe0(0x3a6)]())[_0xe2dbe0(0x2dc)];let _0x52b399=0x0,_0x4a3397=0x0;if(_0x3dcc24['match'](/front/i))_0x52b399=_0x546bac>=_0x57e0be?_0x3d2efe:_0x1864ad;else{if(_0x3dcc24[_0xe2dbe0(0x9e0)](/middle/i))_0x52b399=(_0x3d2efe+_0x1864ad)/0x2,melee=-0x1;else _0x3dcc24[_0xe2dbe0(0x9e0)](/back/i)&&(_0x52b399=_0x546bac>=_0x57e0be?_0x1864ad:_0x3d2efe);}if(_0x3dcc24[_0xe2dbe0(0x9e0)](/head/i))_0x4a3397=_0x461116;else{if(_0x3dcc24[_0xe2dbe0(0x9e0)](/center/i))_0x4a3397=(_0x461116+_0x6cbe3d)/0x2;else _0x3dcc24[_0xe2dbe0(0x9e0)](/base/i)&&(_0x4a3397=_0x6cbe3d);}_0x52b399+=(Graphics[_0xe2dbe0(0x92d)]-Graphics[_0xe2dbe0(0x9ab)])/0x2,_0x4a3397+=(Graphics['height']-Graphics[_0xe2dbe0(0x69d)])/0x2,_0x52b399+=_0x11e778,_0x4a3397+=_0x434ecf,_0x272a99[_0xe2dbe0(0x993)](_0x52b399,_0x4a3397,_0x1c1b17,_0x5954ed,_0x45b7df);}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x2ed),_0x3e1ae6=>{const _0x67d142=_0x1a8785;if(!Imported['VisuMZ_3_ActSeqImpact'])return;const _0x3b7468=SceneManager[_0x67d142(0xa42)]['_spriteset'];if(!_0x3b7468)return;if(VisuMZ['ActSeqImpact'][_0x67d142(0xa23)]<=1.04){alert('Action\x20Sequence\x20Impact\x20needs\x20an\x20update!'),SceneManager['exit']();return;}VisuMZ[_0x67d142(0x235)](_0x3e1ae6,_0x3e1ae6);const _0x41933f=$gameTemp['getLastPluginCommandInterpreter'](),_0x274556=Math[_0x67d142(0x5a7)](0.01,_0x3e1ae6[_0x67d142(0x9bd)]);$gameTemp[_0x67d142(0x395)](_0x274556,_0x41933f);}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0xa9c),_0x156855=>{const _0x203f56=_0x1a8785;if(!Imported[_0x203f56(0x9d4)])return;const _0x488899=SceneManager['_scene'][_0x203f56(0x589)];if(!_0x488899)return;if(VisuMZ[_0x203f56(0x94d)][_0x203f56(0xa23)]<=1.04){alert(_0x203f56(0x8e1)),SceneManager[_0x203f56(0x821)]();return;}VisuMZ[_0x203f56(0x235)](_0x156855,_0x156855);const _0x592c6a=$gameTemp[_0x203f56(0x55b)](),_0x17afe7=_0x156855['ms']||0x1;VisuMZ[_0x203f56(0x94d)][_0x203f56(0x65e)](_0x17afe7,_0x592c6a);}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x4f1),_0x9a6808=>{const _0x34b943=_0x1a8785;if(!Imported[_0x34b943(0x9d4)])return;const _0x10e185=SceneManager[_0x34b943(0xa42)][_0x34b943(0x589)];if(!_0x10e185)return;VisuMZ[_0x34b943(0x235)](_0x9a6808,_0x9a6808);const _0x3eafa0=_0x9a6808['X']||0x0,_0x5cacb1=_0x9a6808['Y']||0x0,_0x16cb6a=_0x9a6808['Strength']||0x0,_0xa2e57=_0x9a6808[_0x34b943(0x306)]||0x0,_0x38d82c=_0x9a6808[_0x34b943(0x918)]||0x1,_0x4f7b83=_0x9a6808[_0x34b943(0x6c4)]||_0x34b943(0x434);_0x10e185[_0x34b943(0x946)](_0x16cb6a,_0x3eafa0,_0x5cacb1,_0xa2e57,_0x38d82c,_0x4f7b83);}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x180),_0x6077ea=>{const _0x6ca099=_0x1a8785;if(!Imported[_0x6ca099(0x9d4)])return;const _0xe5bfd5=SceneManager['_scene'][_0x6ca099(0x589)];if(!_0xe5bfd5)return;VisuMZ['ConvertParams'](_0x6077ea,_0x6077ea);const _0x1a9fb2=VisuMZ[_0x6ca099(0x65c)](_0x6077ea[_0x6ca099(0x7f7)]),_0x38a8c4=_0x6077ea[_0x6ca099(0x5f4)],_0x1b65b1=_0x6077ea[_0x6ca099(0xa93)]||0x0,_0x2c9e1e=_0x6077ea[_0x6ca099(0x4bf)]||0x0,_0x392e15=_0x6077ea[_0x6ca099(0x7b7)]||0x0,_0x4bbe44=_0x6077ea[_0x6ca099(0x306)]||0x0,_0x4f7e2d=_0x6077ea[_0x6ca099(0x918)]||0x1,_0x33d4fb=_0x6077ea[_0x6ca099(0x6c4)]||_0x6ca099(0x434),_0x442136=Math[_0x6ca099(0xae7)](..._0x1a9fb2['map'](_0x23c6f7=>_0x23c6f7[_0x6ca099(0x89e)]()[_0x6ca099(0x6c5)]-_0x23c6f7['battler']()[_0x6ca099(0x4a2)]()/0x2)),_0x3c3daf=Math[_0x6ca099(0x5a7)](..._0x1a9fb2[_0x6ca099(0x628)](_0x1c3c8d=>_0x1c3c8d[_0x6ca099(0x89e)]()[_0x6ca099(0x6c5)]+_0x1c3c8d[_0x6ca099(0x89e)]()[_0x6ca099(0x4a2)]()/0x2)),_0x2fae34=Math[_0x6ca099(0xae7)](..._0x1a9fb2[_0x6ca099(0x628)](_0x52f91e=>_0x52f91e[_0x6ca099(0x89e)]()[_0x6ca099(0x236)]-_0x52f91e[_0x6ca099(0x89e)]()[_0x6ca099(0x27b)]())),_0x20f7cf=Math[_0x6ca099(0x5a7)](..._0x1a9fb2[_0x6ca099(0x628)](_0x41780b=>_0x41780b[_0x6ca099(0x89e)]()[_0x6ca099(0x236)])),_0x162bdd=_0x1a9fb2['filter'](_0x1b74a8=>_0x1b74a8['isActor']())[_0x6ca099(0x2dc)],_0x36e4e0=_0x1a9fb2['filter'](_0x3648c1=>_0x3648c1[_0x6ca099(0x3a6)]())[_0x6ca099(0x2dc)];let _0x5cf61a=0x0,_0x17ddd4=0x0;if(_0x38a8c4[_0x6ca099(0x9e0)](/front/i))_0x5cf61a=_0x162bdd>=_0x36e4e0?_0x442136:_0x3c3daf;else{if(_0x38a8c4[_0x6ca099(0x9e0)](/middle/i))_0x5cf61a=(_0x442136+_0x3c3daf)/0x2,melee=-0x1;else _0x38a8c4[_0x6ca099(0x9e0)](/back/i)&&(_0x5cf61a=_0x162bdd>=_0x36e4e0?_0x3c3daf:_0x442136);}if(_0x38a8c4[_0x6ca099(0x9e0)](/head/i))_0x17ddd4=_0x2fae34;else{if(_0x38a8c4[_0x6ca099(0x9e0)](/center/i))_0x17ddd4=(_0x2fae34+_0x20f7cf)/0x2;else _0x38a8c4['match'](/base/i)&&(_0x17ddd4=_0x20f7cf);}_0x5cf61a+=(Graphics[_0x6ca099(0x92d)]-Graphics[_0x6ca099(0x9ab)])/0x2,_0x17ddd4+=(Graphics['height']-Graphics['boxHeight'])/0x2,_0x5cf61a+=_0x1b65b1,_0x17ddd4+=_0x2c9e1e,_0xe5bfd5['setupZoomBlurImpactFilter'](_0x392e15,_0x5cf61a,_0x17ddd4,_0x4bbe44,_0x4f7e2d,_0x33d4fb);}),PluginManager['registerCommand'](pluginData[_0x1a8785(0x1f2)],'ActSeq_Inject_AnimationStart',_0x5ad915=>{const _0x4a6110=_0x1a8785;if(!Imported[_0x4a6110(0x9d4)])return;const _0x2ae24c=SceneManager['_scene'][_0x4a6110(0x589)];if(!_0x2ae24c)return;if(VisuMZ[_0x4a6110(0x94d)][_0x4a6110(0xa23)]<=1.05){alert(_0x4a6110(0x8e1)),SceneManager[_0x4a6110(0x821)]();return;}VisuMZ['ConvertParams'](_0x5ad915,_0x5ad915);const _0x524838=VisuMZ[_0x4a6110(0x65c)](_0x5ad915['Targets']),_0x557eb4={'filename':_0x5ad915[_0x4a6110(0x7aa)],'horzCells':_0x5ad915[_0x4a6110(0x217)]||0x1,'vertCells':_0x5ad915[_0x4a6110(0x8e8)]||0x1,'frameDelay':_0x5ad915[_0x4a6110(0x4fd)]||0x1,'smooth':_0x5ad915[_0x4a6110(0x66c)]||![],'anchorX':_0x5ad915['anchorX']||0x0,'anchorY':_0x5ad915[_0x4a6110(0x17a)]||0x0,'offsetX':_0x5ad915[_0x4a6110(0x775)]||0x0,'offsetY':_0x5ad915[_0x4a6110(0x274)]||0x0};for(const _0x3ecb6e of _0x524838){if(!_0x3ecb6e)continue;if(!_0x3ecb6e[_0x4a6110(0x89e)]())continue;_0x3ecb6e[_0x4a6110(0x89e)]()[_0x4a6110(0x2cb)](_0x557eb4);}const _0x3d22e3=$gameTemp[_0x4a6110(0x55b)]();_0x3d22e3&&_0x3d22e3['setWaitMode']('battleInjectPrep');}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x467),_0x1b49a4=>{const _0x25bc74=_0x1a8785;if(!Imported[_0x25bc74(0x9d4)])return;const _0x4fdbc9=SceneManager['_scene']['_spriteset'];if(!_0x4fdbc9)return;if(VisuMZ[_0x25bc74(0x94d)][_0x25bc74(0xa23)]<=1.05){alert(_0x25bc74(0x8e1)),SceneManager[_0x25bc74(0x821)]();return;}VisuMZ[_0x25bc74(0x235)](_0x1b49a4,_0x1b49a4);const _0x238a30=VisuMZ[_0x25bc74(0x65c)](_0x1b49a4[_0x25bc74(0x7f7)]);for(const _0x5e407b of _0x238a30){if(!_0x5e407b)continue;if(!_0x5e407b[_0x25bc74(0x89e)]())continue;_0x5e407b['battler']()['stopInjectAnimation']();}}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x715),_0x50feca=>{const _0x3eab1c=_0x1a8785;if(!Imported[_0x3eab1c(0x9d4)])return;const _0x33e9fe=SceneManager[_0x3eab1c(0xa42)]['_spriteset'];if(!_0x33e9fe)return;if(VisuMZ[_0x3eab1c(0x94d)][_0x3eab1c(0xa23)]<=1.05){alert('Action\x20Sequence\x20Impact\x20needs\x20an\x20update!'),SceneManager['exit']();return;}VisuMZ[_0x3eab1c(0x235)](_0x50feca,_0x50feca);const _0x3111d0=VisuMZ[_0x3eab1c(0x65c)](_0x50feca['Targets']),_0x480cf7=_0x50feca[_0x3eab1c(0x5ed)];for(const _0x431449 of _0x3111d0){if(!_0x431449)continue;if(!_0x431449[_0x3eab1c(0x89e)]())continue;_0x431449[_0x3eab1c(0x89e)]()[_0x3eab1c(0x411)](_0x480cf7);}}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0xaee),_0x46490c=>{const _0x360291=_0x1a8785;if(!SceneManager[_0x360291(0x3a8)]())return;const _0x449c9f=$gameTemp[_0x360291(0x55b)]();if(!_0x449c9f)return;_0x449c9f['setWaitMode'](_0x360291(0x40a));}),PluginManager['registerCommand'](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x3de),_0x94eece=>{const _0x419b55=_0x1a8785;if(!SceneManager[_0x419b55(0x3a8)]())return;VisuMZ[_0x419b55(0x235)](_0x94eece,_0x94eece);const _0x4adfc7=$gameTemp[_0x419b55(0x55b)](),_0x29d1e7=BattleManager[_0x419b55(0x440)],_0x334721=BattleManager['_subject'],_0x3b6614=BattleManager[_0x419b55(0x2f3)];if(!_0x4adfc7||!_0x29d1e7||!_0x334721)return;if(!_0x29d1e7[_0x419b55(0x7e0)]())return;const _0x4af6da=VisuMZ[_0x419b55(0x65c)](_0x94eece[_0x419b55(0x7f7)]);for(const _0x367e29 of _0x4af6da){if(!_0x367e29)continue;_0x3b6614[_0x419b55(0x963)](_0x419b55(0x62b),_0x334721,_0x367e29);}_0x4adfc7[_0x419b55(0xab1)](_0x419b55(0x468));}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],'ActSeq_Mechanics_ActiveChainInputDisable',_0x322c50=>{const _0x2d54ee=_0x1a8785;if(!SceneManager[_0x2d54ee(0x3a8)]())return;if(!Imported[_0x2d54ee(0x379)])return;$gameTemp[_0x2d54ee(0xa05)]=!![];}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],'ActSeq_Mechanics_AddBuffDebuff',_0x1ab9ce=>{const _0x286921=_0x1a8785;if(!SceneManager[_0x286921(0x3a8)]())return;VisuMZ[_0x286921(0x235)](_0x1ab9ce,_0x1ab9ce);const _0x3f46c8=[_0x286921(0x241),_0x286921(0xaed),_0x286921(0x53b),_0x286921(0xa09),_0x286921(0x86b),_0x286921(0x51d),_0x286921(0xaf6),_0x286921(0x232)],_0x210abd=_0x1ab9ce[_0x286921(0xab3)],_0x3cbf7d=_0x1ab9ce[_0x286921(0x30f)],_0x5e4f12=_0x1ab9ce[_0x286921(0x429)],_0x265783=VisuMZ[_0x286921(0x65c)](_0x1ab9ce[_0x286921(0x7f7)]);for(const _0x1f9300 of _0x265783){if(!_0x1f9300)continue;for(const _0x4e74dc of _0x210abd){const _0xc5e8ef=_0x3f46c8[_0x286921(0x64f)](_0x4e74dc[_0x286921(0x830)]()[_0x286921(0x6b6)]());_0xc5e8ef>=0x0&&_0xc5e8ef<=0x7&&_0x1f9300[_0x286921(0x2b2)](_0xc5e8ef,_0x5e4f12);}for(const _0x52c41c of _0x3cbf7d){const _0x981b83=_0x3f46c8[_0x286921(0x64f)](_0x52c41c[_0x286921(0x830)]()[_0x286921(0x6b6)]());_0x981b83>=0x0&&_0x981b83<=0x7&&_0x1f9300[_0x286921(0xabc)](_0x981b83,_0x5e4f12);}}}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],'ActSeq_Mechanics_AddState',_0x1aeede=>{const _0x3d3f95=_0x1a8785;if(!SceneManager[_0x3d3f95(0x3a8)]())return;VisuMZ[_0x3d3f95(0x235)](_0x1aeede,_0x1aeede);const _0x3210de=_0x1aeede[_0x3d3f95(0x6d6)],_0x54563c=VisuMZ[_0x3d3f95(0x65c)](_0x1aeede[_0x3d3f95(0x7f7)]);for(const _0x5805c9 of _0x54563c){if(!_0x5805c9)continue;for(const _0xfd638d of _0x3210de){_0x5805c9[_0x3d3f95(0x5af)](_0xfd638d);}}}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x89a),_0x3090f1=>{const _0x4b3b8c=_0x1a8785;if(!SceneManager[_0x4b3b8c(0x3a8)]())return;VisuMZ[_0x4b3b8c(0x235)](_0x3090f1,_0x3090f1);const _0x31da1d=BattleManager['_action'],_0x554306={'arPenRate':_0x3090f1[_0x4b3b8c(0x94f)],'arPenFlat':_0x3090f1[_0x4b3b8c(0x6aa)],'arRedRate':_0x3090f1[_0x4b3b8c(0x17e)],'arRedFlat':_0x3090f1['ArRedFlat']};_0x31da1d[_0x4b3b8c(0x666)]=_0x554306;}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],'ActSeq_Mechanics_AnalyzeWeakness',_0x1a2a16=>{const _0x29a86f=_0x1a8785;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x29a86f(0x9d5)])return;VisuMZ['ConvertParams'](_0x1a2a16,_0x1a2a16);const _0x5079a5=VisuMZ[_0x29a86f(0x65c)](_0x1a2a16[_0x29a86f(0x7f7)]),_0x11c680=_0x1a2a16[_0x29a86f(0x290)]||0x1;for(const _0x6b85ac of _0x5079a5){if(!_0x6b85ac)continue;if(!_0x6b85ac[_0x29a86f(0x3a6)]())continue;_0x6b85ac[_0x29a86f(0x6e8)](_0x11c680);}}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x72d),_0x474355=>{const _0x38fe00=_0x1a8785;if(!SceneManager[_0x38fe00(0x3a8)]())return;if(!Imported[_0x38fe00(0x730)])return;if(!BattleManager[_0x38fe00(0x509)]())return;VisuMZ[_0x38fe00(0x235)](_0x474355,_0x474355);const _0x15d8d0=VisuMZ['CreateActionSequenceTargets'](_0x474355[_0x38fe00(0x7f7)]),_0x2ea4a5=_0x474355[_0x38fe00(0x732)],_0x3f0f8b=_0x474355[_0x38fe00(0x732)],_0x2bb05d=_0x474355[_0x38fe00(0x345)];for(const _0x382937 of _0x15d8d0){if(!_0x382937)continue;if(_0x382937[_0x38fe00(0x42a)]())_0x382937[_0x38fe00(0x625)](_0x2ea4a5);else{if(_0x382937['isAtbCastingState']()){_0x382937[_0x38fe00(0x649)](_0x3f0f8b);if(_0x2bb05d)_0x382937['atbInterrupt']();}}}}),PluginManager['registerCommand'](pluginData['name'],_0x1a8785(0x8ec),_0x40b8a4=>{const _0x3db5d2=_0x1a8785;if(!SceneManager[_0x3db5d2(0x3a8)]())return;if(!Imported[_0x3db5d2(0x377)])return;VisuMZ['ConvertParams'](_0x40b8a4,_0x40b8a4);const _0xfcf6b1=VisuMZ[_0x3db5d2(0x65c)](_0x40b8a4[_0x3db5d2(0x7f7)]),_0x3ae448=_0x40b8a4['BoostPoints'];for(const _0x29be4f of _0xfcf6b1){if(!_0x29be4f)continue;_0x29be4f[_0x3db5d2(0x30d)](_0x3ae448);}}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],'ActSeq_Mechanics_BoostPointsStoreData',_0x46d18c=>{const _0x21cd76=_0x1a8785;if(!SceneManager[_0x21cd76(0x3a8)]())return;if(!Imported['VisuMZ_3_BoostAction'])return;if(!BattleManager[_0x21cd76(0x938)])return;VisuMZ[_0x21cd76(0x235)](_0x46d18c,_0x46d18c);const _0x22f6a0=_0x46d18c[_0x21cd76(0x5d5)];$gameVariables[_0x21cd76(0x3eb)](_0x22f6a0,BattleManager[_0x21cd76(0x938)][_0x21cd76(0x77c)]());}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],_0x1a8785(0x75e),_0x2d04a1=>{const _0x3ab0fd=_0x1a8785;if(!SceneManager[_0x3ab0fd(0x3a8)]())return;if(!Imported[_0x3ab0fd(0xa50)])return;VisuMZ[_0x3ab0fd(0x235)](_0x2d04a1,_0x2d04a1);const _0x34872a=VisuMZ[_0x3ab0fd(0x65c)](_0x2d04a1[_0x3ab0fd(0x7f7)]),_0x5d69fc=_0x2d04a1[_0x3ab0fd(0x5ee)];for(const _0x46a69e of _0x34872a){if(!_0x46a69e)continue;if(_0x46a69e[_0x3ab0fd(0x18d)]())continue;if(!_0x46a69e[_0x3ab0fd(0x944)]())continue;_0x46a69e[_0x3ab0fd(0x77a)](_0x5d69fc);}}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x40c),_0x4afc87=>{const _0xe32fa9=_0x1a8785;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0xe32fa9(0xa50)])return;VisuMZ[_0xe32fa9(0x235)](_0x4afc87,_0x4afc87);const _0x2bca41=VisuMZ[_0xe32fa9(0x65c)](_0x4afc87[_0xe32fa9(0x7f7)]);for(const _0x1d63cf of _0x2bca41){if(!_0x1d63cf)continue;if(_0x1d63cf[_0xe32fa9(0x18d)]())continue;if(!_0x1d63cf[_0xe32fa9(0x944)]())continue;_0x1d63cf[_0xe32fa9(0x65a)]();}}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],_0x1a8785(0x364),_0x4528ed=>{const _0x4e29e5=_0x1a8785;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x4e29e5(0x2f5)])return;if(!BattleManager[_0x4e29e5(0x642)]())return;VisuMZ[_0x4e29e5(0x235)](_0x4528ed,_0x4528ed);const _0x24dc0a=VisuMZ[_0x4e29e5(0x65c)](_0x4528ed[_0x4e29e5(0x7f7)]),_0x2ad6c0=_0x4528ed[_0x4e29e5(0x71d)];for(const _0x156398 of _0x24dc0a){if(!_0x156398)continue;_0x156398[_0x4e29e5(0x381)](_0x2ad6c0);}}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x399),_0x5c1885=>{const _0x3448a7=_0x1a8785;if(!SceneManager[_0x3448a7(0x3a8)]())return;VisuMZ[_0x3448a7(0x235)](_0x5c1885,_0x5c1885);const _0x294c7c=$gameTemp[_0x3448a7(0x55b)](),_0x2e791e=BattleManager[_0x3448a7(0x440)],_0xb2d436=BattleManager[_0x3448a7(0x938)];if(!_0x294c7c||!_0x2e791e||!_0xb2d436)return;if(!_0x2e791e[_0x3448a7(0x7e0)]())return;const _0x535dd0=VisuMZ['CreateActionSequenceTargets'](_0x5c1885[_0x3448a7(0x7f7)]);for(const _0x53b7b8 of _0x535dd0){if(!_0x53b7b8)continue;_0x5c1885[_0x3448a7(0x492)]&&(_0x53b7b8[_0x3448a7(0x6e5)](),_0x53b7b8[_0x3448a7(0x5af)](_0x53b7b8[_0x3448a7(0x7f9)]())),_0x53b7b8[_0x3448a7(0x7e5)]()&&_0x53b7b8[_0x3448a7(0x37d)]();}_0x294c7c[_0x3448a7(0xab1)](_0x3448a7(0x8ba));}),PluginManager['registerCommand'](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x6d2),_0x31026c=>{const _0x330cbd=_0x1a8785;if(!SceneManager[_0x330cbd(0x3a8)]())return;if(!Imported[_0x330cbd(0x4f5)])return;if(!BattleManager[_0x330cbd(0x789)]())return;VisuMZ[_0x330cbd(0x235)](_0x31026c,_0x31026c);const _0x5cc8e7=VisuMZ[_0x330cbd(0x65c)](_0x31026c['Targets']),_0x2219b8=_0x31026c[_0x330cbd(0xafe)];for(const _0x3fd793 of _0x5cc8e7){if(!_0x3fd793)continue;_0x3fd793[_0x330cbd(0x9ad)](_0x2219b8);}}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],_0x1a8785(0x3e1),_0x11d275=>{const _0x8d8e7e=_0x1a8785;if(!SceneManager[_0x8d8e7e(0x3a8)]())return;if(!Imported[_0x8d8e7e(0x4f5)])return;if(!BattleManager[_0x8d8e7e(0x789)]())return;VisuMZ[_0x8d8e7e(0x235)](_0x11d275,_0x11d275);const _0x307e1f=VisuMZ[_0x8d8e7e(0x65c)](_0x11d275[_0x8d8e7e(0x7f7)]),_0x411780=_0x11d275['ChargeRate'],_0x342628=_0x11d275[_0x8d8e7e(0x732)];for(const _0x2dbdff of _0x307e1f){if(!_0x2dbdff)continue;if(_0x2dbdff[_0x8d8e7e(0x20c)]===_0x8d8e7e(0x9b2))_0x2dbdff[_0x8d8e7e(0x6d5)](_0x411780);else _0x2dbdff[_0x8d8e7e(0x20c)]==='casting'&&_0x2dbdff['changeCtbCastTime'](_0x342628);}}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x49f),_0x2e123d=>{const _0x28c26f=_0x1a8785;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x28c26f(0x235)](_0x2e123d,_0x2e123d);const _0x62e6dd=BattleManager[_0x28c26f(0x440)];if(!_0x62e6dd)return;let _0x12b73f=_0x2e123d[_0x28c26f(0x5a6)];_0x62e6dd[_0x28c26f(0x3e0)](_0x12b73f);}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x862),_0x265273=>{const _0x335911=_0x1a8785;if(!SceneManager[_0x335911(0x3a8)]())return;VisuMZ[_0x335911(0x235)](_0x265273,_0x265273);const _0x5c3663=VisuMZ[_0x335911(0x65c)](_0x265273[_0x335911(0x7f7)]);for(const _0x1a2aa1 of _0x5c3663){if(!_0x1a2aa1)continue;if(_0x1a2aa1[_0x335911(0x723)]())_0x1a2aa1[_0x335911(0x419)]();}}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0xab7),_0x1b754c=>{const _0x226e1c=_0x1a8785;if(!SceneManager[_0x226e1c(0x3a8)]())return;VisuMZ[_0x226e1c(0x235)](_0x1b754c,_0x1b754c);const _0x5ea2c3=$gameTemp[_0x226e1c(0x55b)](),_0x3c759d=BattleManager['_subject'],_0x537af0=_0x1b754c[_0x226e1c(0x742)];if(!_0x5ea2c3)return;if(!_0x3c759d)return;_0x3c759d&&_0x3c759d[_0x226e1c(0x37f)]()&&_0x537af0[_0x226e1c(0x830)]()[_0x226e1c(0x6b6)]()!=='UNTITLED'&&_0x5ea2c3['command119']([_0x537af0]);}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],_0x1a8785(0x369),_0x34b497=>{const _0x13b765=_0x1a8785;if(!SceneManager[_0x13b765(0x3a8)]())return;VisuMZ['ConvertParams'](_0x34b497,_0x34b497);const _0xdd43d3=VisuMZ[_0x13b765(0x65c)](_0x34b497[_0x13b765(0x7f7)]);for(const _0x4da234 of _0xdd43d3){if(!_0x4da234)continue;if(!_0x4da234[_0x13b765(0x3a6)]())continue;_0x4da234['escape']();}}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x79c),_0x1cb938=>{const _0x1d7f66=_0x1a8785;if(!SceneManager[_0x1d7f66(0x3a8)]())return;if(!Imported['VisuMZ_2_BattleSystemETB'])return;if(!BattleManager[_0x1d7f66(0x38a)]())return;VisuMZ['ConvertParams'](_0x1cb938,_0x1cb938);const _0x170dd6=_0x1cb938['ActionCount'];BattleManager[_0x1d7f66(0x938)]&&BattleManager['_subject']['friendsUnit']()[_0x1d7f66(0x353)](_0x170dd6);}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],'ActSeq_Mechanics_FtbAction',_0x18c850=>{const _0x1aed08=_0x1a8785;if(!SceneManager[_0x1aed08(0x3a8)]())return;if(!Imported[_0x1aed08(0x5d6)])return;if(!BattleManager[_0x1aed08(0x643)]())return;VisuMZ[_0x1aed08(0x235)](_0x18c850,_0x18c850);const _0x2f7f20=_0x18c850[_0x1aed08(0x2fb)];BattleManager['_subject']&&BattleManager[_0x1aed08(0x938)][_0x1aed08(0xb04)]()[_0x1aed08(0x5c6)](_0x2f7f20);}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x8e0),_0x2e5034=>{const _0x1dc9b1=_0x1a8785;if(!SceneManager[_0x1dc9b1(0x3a8)]())return;VisuMZ[_0x1dc9b1(0x235)](_0x2e5034,_0x2e5034);const _0x232ed4=VisuMZ[_0x1dc9b1(0x65c)](_0x2e5034[_0x1dc9b1(0x7f7)]),_0x554dce=_0x2e5034[_0x1dc9b1(0xa59)],_0x173c2a=_0x2e5034[_0x1dc9b1(0x47e)],_0x3a119b=_0x2e5034['MP_Rate'],_0x54a9b6=_0x2e5034[_0x1dc9b1(0x866)],_0xf539d9=_0x2e5034[_0x1dc9b1(0x81c)],_0x49e44f=_0x2e5034[_0x1dc9b1(0x766)],_0x1a25e1=_0x2e5034[_0x1dc9b1(0x6e2)];for(const _0x159afc of _0x232ed4){if(!_0x159afc)continue;const _0x3270ee=_0x159afc[_0x1dc9b1(0x919)](),_0x3a005a=Math['round'](_0x554dce*_0x159afc['mhp']+_0x173c2a),_0x3bc36e=Math[_0x1dc9b1(0x86d)](_0x3a119b*_0x159afc[_0x1dc9b1(0x403)]+_0x54a9b6),_0x2ed9c9=Math[_0x1dc9b1(0x86d)](_0xf539d9*_0x159afc[_0x1dc9b1(0x2bc)]()+_0x49e44f);if(_0x3a005a!==0x0)_0x159afc['gainHp'](_0x3a005a);if(_0x3bc36e!==0x0)_0x159afc[_0x1dc9b1(0x48d)](_0x3bc36e);if(_0x2ed9c9!==0x0)_0x159afc[_0x1dc9b1(0x263)](_0x2ed9c9);if(_0x1a25e1)_0x159afc[_0x1dc9b1(0x419)]();_0x3270ee&&_0x159afc['isDead']()&&_0x159afc[_0x1dc9b1(0x37d)]();}}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x6ad),_0x48044c=>{const _0x233188=_0x1a8785;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x233188(0x235)](_0x48044c,_0x48044c);const _0x3f5697=VisuMZ[_0x233188(0x65c)](_0x48044c['Targets']);for(const _0x384ac1 of _0x3f5697){if(!_0x384ac1)continue;_0x384ac1['setImmortal'](_0x48044c[_0x233188(0x7d6)]);}}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x9f6),_0x366067=>{const _0x48f380=_0x1a8785;if(!SceneManager[_0x48f380(0x3a8)]())return;VisuMZ[_0x48f380(0x235)](_0x366067,_0x366067);const _0x177450=BattleManager[_0x48f380(0x440)],_0xf38924={'criticalHitRate':_0x366067[_0x48f380(0x693)],'criticalHitFlat':_0x366067[_0x48f380(0x9f2)],'criticalDmgRate':_0x366067[_0x48f380(0x702)],'criticalDmgFlat':_0x366067[_0x48f380(0x61d)],'damageRate':_0x366067[_0x48f380(0x430)],'damageFlat':_0x366067['DamageFlat'],'hitRate':_0x366067[_0x48f380(0x35d)],'hitFlat':_0x366067[_0x48f380(0x9fd)]};_0x177450[_0x48f380(0x44e)]=_0xf38924;}),PluginManager['registerCommand'](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x910),_0x2a317f=>{const _0x20b6b1=_0x1a8785;if(!SceneManager['isSceneBattle']())return;VisuMZ['ConvertParams'](_0x2a317f,_0x2a317f);const _0x4c2441=_0x2a317f[_0x20b6b1(0x90f)];SceneManager[_0x20b6b1(0xa42)][_0x20b6b1(0x8a3)](_0x4c2441);}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],'ActSeq_Mechanics_OtbOrder',_0x53600e=>{const _0x487c85=_0x1a8785;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x487c85(0x25b)])return;if(!BattleManager[_0x487c85(0x879)]())return;VisuMZ['ConvertParams'](_0x53600e,_0x53600e);const _0x1404a4=VisuMZ[_0x487c85(0x65c)](_0x53600e['Targets']);for(const _0x260db2 of _0x1404a4){if(!_0x260db2)continue;let _0x199d15=_0x53600e[_0x487c85(0x2ae)],_0x7108ae=_0x53600e[_0x487c85(0xadb)],_0x3a9061=_0x53600e[_0x487c85(0x729)];BattleManager['_actionBattlers'][_0x487c85(0xa3e)](_0x260db2)?_0x199d15+=_0x3a9061:_0x7108ae+=_0x3a9061,BattleManager[_0x487c85(0xa56)](_0x260db2,-_0x199d15,![]),BattleManager[_0x487c85(0xa56)](_0x260db2,-_0x7108ae,!![]);}}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],_0x1a8785(0x6dc),_0x1bd7e0=>{const _0x237080=_0x1a8785;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x237080(0x7f2)])return;if(!BattleManager[_0x237080(0x943)]())return;VisuMZ[_0x237080(0x235)](_0x1bd7e0,_0x1bd7e0);const _0x49935e=BattleManager[_0x237080(0x938)][_0x237080(0xb04)](),_0x10f76d=_0x1bd7e0[_0x237080(0x4ec)],_0x5cd445=_0x1bd7e0[_0x237080(0x9c2)]||_0x237080(0x8bc),_0x5d1d1f=_0x1bd7e0['alterType']||_0x237080(0x8bc),_0x385453=_0x1bd7e0[_0x237080(0x838)]||0x0,_0x31f8bf=_0x1bd7e0[_0x237080(0x96b)]||0x0;(_0x49935e['canAlterActionCostPTB']()||_0x10f76d)&&(_0x10f76d&&(_0x49935e[_0x237080(0x767)]=_0x49935e['_ptbActionCost']||{},_0x49935e[_0x237080(0x767)]['priority']=0x0),_0x49935e['alterActionCostPTB'](_0x5cd445,_0x5d1d1f,_0x385453,_0x31f8bf));}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x3ec),_0x3d18df=>{const _0x2393ce=_0x1a8785;if(!SceneManager[_0x2393ce(0x3a8)]())return;if(!Imported[_0x2393ce(0x7f2)])return;if(!BattleManager[_0x2393ce(0x943)]())return;VisuMZ[_0x2393ce(0x235)](_0x3d18df,_0x3d18df);const _0x1453fd=BattleManager[_0x2393ce(0x938)]['friendsUnit']();let _0x5dedbe=Math[_0x2393ce(0x5a7)](_0x3d18df[_0x2393ce(0x7cd)],0x0),_0x54f943=_0x1453fd[_0x2393ce(0x58f)](),_0x1beb53=_0x1453fd[_0x2393ce(0x486)]();while(_0x5dedbe--){if(_0x54f943<=0x0&&_0x1beb53<=0x0)break;else _0x54f943>0x0?(_0x54f943--,_0x1beb53++):_0x1beb53--;}_0x1453fd[_0x2393ce(0x204)](_0x54f943),_0x1453fd[_0x2393ce(0x1d2)](_0x1beb53);}),PluginManager['registerCommand'](pluginData['name'],'ActSeq_Mechanics_PtbFullHalfAction',_0x4908ce=>{const _0x42e9e6=_0x1a8785;if(!SceneManager[_0x42e9e6(0x3a8)]())return;if(!Imported[_0x42e9e6(0x7f2)])return;if(!BattleManager['isPTB']())return;VisuMZ['ConvertParams'](_0x4908ce,_0x4908ce);const _0xe153e5=BattleManager[_0x42e9e6(0x938)]['friendsUnit']();let _0x4cec14=_0x4908ce[_0x42e9e6(0x8da)],_0x6044ea=_0x4908ce[_0x42e9e6(0x6fb)];_0xe153e5[_0x42e9e6(0x90d)](_0x4cec14),_0xe153e5[_0x42e9e6(0x26b)](_0x6044ea);}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],'ActSeq_Mechanics_RemoveBuffDebuff',_0x310042=>{const _0x43b063=_0x1a8785;if(!SceneManager[_0x43b063(0x3a8)]())return;VisuMZ['ConvertParams'](_0x310042,_0x310042);const _0x4af4be=[_0x43b063(0x241),_0x43b063(0xaed),'ATK',_0x43b063(0xa09),'MAT',_0x43b063(0x51d),_0x43b063(0xaf6),_0x43b063(0x232)],_0xb36f40=_0x310042[_0x43b063(0xab3)],_0x18e320=_0x310042[_0x43b063(0x30f)],_0x317b09=VisuMZ[_0x43b063(0x65c)](_0x310042[_0x43b063(0x7f7)]);for(const _0x3bc2f0 of _0x317b09){if(!_0x3bc2f0)continue;for(const _0x28aad8 of _0xb36f40){const _0xe927e7=_0x4af4be['indexOf'](_0x28aad8[_0x43b063(0x830)]()[_0x43b063(0x6b6)]());_0xe927e7>=0x0&&_0xe927e7<=0x7&&_0x3bc2f0[_0x43b063(0x7a7)](_0xe927e7)&&_0x3bc2f0['removeBuff'](_0xe927e7);}for(const _0x572fca of _0x18e320){const _0x2d75d5=_0x4af4be[_0x43b063(0x64f)](_0x572fca[_0x43b063(0x830)]()[_0x43b063(0x6b6)]());_0x2d75d5>=0x0&&_0x2d75d5<=0x7&&_0x3bc2f0[_0x43b063(0xaad)](_0x2d75d5)&&_0x3bc2f0[_0x43b063(0x881)](_0x2d75d5);}}}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x233),_0x157b7c=>{const _0x5c8206=_0x1a8785;if(!SceneManager[_0x5c8206(0x3a8)]())return;VisuMZ[_0x5c8206(0x235)](_0x157b7c,_0x157b7c);const _0x3ce1cf=_0x157b7c['States'],_0x3125f6=VisuMZ[_0x5c8206(0x65c)](_0x157b7c[_0x5c8206(0x7f7)]);for(const _0x59bc9f of _0x3125f6){if(!_0x59bc9f)continue;for(const _0x822840 of _0x3ce1cf){_0x59bc9f[_0x5c8206(0x81d)](_0x822840);}}}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x5ab),_0x35b7e3=>{const _0x3c42fe=_0x1a8785;if(!SceneManager[_0x3c42fe(0x3a8)]())return;if(!Imported[_0x3c42fe(0xa46)])return;if(!BattleManager['isSTB']())return;VisuMZ[_0x3c42fe(0x235)](_0x35b7e3,_0x35b7e3);const _0x3e6294=_0x35b7e3['Exploited'],_0x58e088=VisuMZ['CreateActionSequenceTargets'](_0x35b7e3[_0x3c42fe(0x7f7)]),_0x3f6099=_0x35b7e3[_0x3c42fe(0x7ac)],_0x99722=_0x35b7e3[_0x3c42fe(0x6df)],_0x1db750=_0x35b7e3[_0x3c42fe(0x9b8)],_0x5ac02e=BattleManager[_0x3c42fe(0x440)];if(_0x3e6294)for(const _0x1d54cd of _0x58e088){if(!_0x1d54cd)continue;if(_0x1d54cd===user)continue;if(_0x3f6099)_0x1d54cd[_0x3c42fe(0x89b)](![]);_0x1d54cd[_0x3c42fe(0x7d8)](BattleManager[_0x3c42fe(0x938)],_0x5ac02e);}if(_0x99722&&BattleManager['_subject']){if(_0x1db750)BattleManager[_0x3c42fe(0x938)][_0x3c42fe(0x89b)](![]);const _0x40e455=_0x58e088[0x0];BattleManager[_0x3c42fe(0xa58)](_0x40e455,_0x5ac02e);}}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x2bd),_0x10538c=>{const _0x2bfed5=_0x1a8785;if(!SceneManager[_0x2bfed5(0x3a8)]())return;if(!Imported[_0x2bfed5(0xa46)])return;if(!BattleManager[_0x2bfed5(0x55f)]())return;VisuMZ[_0x2bfed5(0x235)](_0x10538c,_0x10538c);const _0x3b7d88=_0x10538c[_0x2bfed5(0x600)];BattleManager[_0x2bfed5(0x938)]&&BattleManager[_0x2bfed5(0x938)][_0x2bfed5(0x851)](_0x3b7d88);}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x295),_0xeb9777=>{const _0x28324f=_0x1a8785;if(!SceneManager[_0x28324f(0x3a8)]())return;if(!Imported['VisuMZ_2_BattleSystemSTB'])return;if(!BattleManager[_0x28324f(0x55f)]())return;VisuMZ[_0x28324f(0x235)](_0xeb9777,_0xeb9777);let _0x3915e3=_0xeb9777[_0x28324f(0x600)];if(BattleManager[_0x28324f(0x938)]){BattleManager[_0x28324f(0x938)][_0x28324f(0xa89)]=BattleManager[_0x28324f(0x938)][_0x28324f(0xa89)]||[];while(_0x3915e3--){if(BattleManager[_0x28324f(0x938)]['_actions'][_0x28324f(0x2dc)]<=0x0)break;BattleManager[_0x28324f(0x938)][_0x28324f(0xa89)][_0x28324f(0x3e5)]();}}}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x4f8),_0x5c62df=>{const _0x26c87d=_0x1a8785;if(!SceneManager[_0x26c87d(0x3a8)]())return;if(!Imported[_0x26c87d(0x47b)])return;VisuMZ[_0x26c87d(0x235)](_0x5c62df,_0x5c62df);const _0x281edb=VisuMZ[_0x26c87d(0x65c)](_0x5c62df['Targets']),_0x285a34=_0x5c62df[_0x26c87d(0x474)];for(const _0x3d8a30 of _0x281edb){if(!_0x3d8a30)continue;if(!_0x3d8a30['isActor']())continue;_0x3d8a30[_0x26c87d(0x282)](_0x285a34);}}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],_0x1a8785(0x239),_0x2f098a=>{const _0x3768e3=_0x1a8785;if(!SceneManager[_0x3768e3(0x3a8)]())return;VisuMZ[_0x3768e3(0x235)](_0x2f098a,_0x2f098a);const _0x13ab64=VisuMZ['CreateActionSequenceTargets'](_0x2f098a['Targets']),_0x580e6c=_0x2f098a['Text'],_0x3f05a9={'textColor':ColorManager['getColor'](_0x2f098a[_0x3768e3(0xb07)]),'flashColor':_0x2f098a[_0x3768e3(0xa6c)],'flashDuration':_0x2f098a[_0x3768e3(0x97d)]};for(const _0xf105f7 of _0x13ab64){if(!_0xf105f7)continue;_0xf105f7[_0x3768e3(0x7ec)](_0x580e6c,_0x3f05a9);}}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x480),_0x20c422=>{const _0xd3fb39=_0x1a8785;if(!SceneManager[_0xd3fb39(0x3a8)]())return;VisuMZ[_0xd3fb39(0x235)](_0x20c422,_0x20c422);const _0x31c3a1=VisuMZ['CreateActionSequenceTargets'](_0x20c422[_0xd3fb39(0x7f7)]);let _0x3a2814=$gameVariables['value'](_0x20c422['Variable']);Imported[_0xd3fb39(0x211)]&&_0x20c422[_0xd3fb39(0x445)]&&(_0x3a2814=VisuMZ[_0xd3fb39(0x291)](_0x3a2814));const _0x1b321d=String(_0x3a2814),_0x9416ee={'textColor':ColorManager[_0xd3fb39(0x31e)](_0x20c422[_0xd3fb39(0xb07)]),'flashColor':_0x20c422[_0xd3fb39(0xa6c)],'flashDuration':_0x20c422['FlashDuration']};for(const _0x5d82e8 of _0x31c3a1){if(!_0x5d82e8)continue;_0x5d82e8[_0xd3fb39(0x7ec)](_0x1b321d,_0x9416ee);}}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],_0x1a8785(0x635),_0x14fa26=>{const _0x1de070=_0x1a8785;if(!SceneManager[_0x1de070(0x3a8)]())return;const _0x5c7e7d=$gameTemp[_0x1de070(0x55b)]();if(!_0x5c7e7d)return;_0x5c7e7d[_0x1de070(0xab1)]('battleEffect');}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],_0x1a8785(0x3c2),_0x5f29b9=>{const _0x19a96c=_0x1a8785;if(!SceneManager[_0x19a96c(0x3a8)]())return;VisuMZ[_0x19a96c(0x235)](_0x5f29b9,_0x5f29b9);const _0x57a515=VisuMZ['CreateActionSequenceTargets'](_0x5f29b9[_0x19a96c(0x7f7)]);for(const _0x2f84c3 of _0x57a515){if(!_0x2f84c3)continue;_0x2f84c3[_0x19a96c(0x302)]();}}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],'ActSeq_Motion_FreezeMotionFrame',_0x1328e5=>{const _0x27c557=_0x1a8785;if(!SceneManager[_0x27c557(0x3a8)]())return;VisuMZ[_0x27c557(0x235)](_0x1328e5,_0x1328e5);const _0x3251a9=VisuMZ['CreateActionSequenceTargets'](_0x1328e5[_0x27c557(0x7f7)]),_0x611d53=_0x1328e5['MotionType']['toLowerCase']()['trim']();let _0x33e570=_0x1328e5['ShowWeapon'];const _0x20664f=_0x1328e5[_0x27c557(0x99c)];![_0x27c557(0x432),_0x27c557(0xa03),_0x27c557(0x9b1),_0x27c557(0x18c)]['includes'](_0x611d53)&&(_0x33e570=![]);for(const _0x1e7ec8 of _0x3251a9){if(!_0x1e7ec8)continue;_0x1e7ec8[_0x27c557(0x751)](_0x611d53,_0x33e570,_0x20664f);}}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x606),_0x154dc4=>{const _0x162ce1=_0x1a8785;if(!SceneManager[_0x162ce1(0x3a8)]())return;VisuMZ['ConvertParams'](_0x154dc4,_0x154dc4);const _0x1fbc7c=VisuMZ['CreateActionSequenceTargets'](_0x154dc4[_0x162ce1(0x7f7)]),_0x479eb4=_0x154dc4[_0x162ce1(0x994)][_0x162ce1(0x5dd)]()['trim'](),_0x3a6d3d=_0x154dc4[_0x162ce1(0x9b4)];for(const _0x43a66f of _0x1fbc7c){if(!_0x43a66f)continue;if(_0x479eb4[_0x162ce1(0x9e0)](/ATTACK[ ](\d+)/i))_0x43a66f[_0x162ce1(0x2b9)](Number(RegExp['$1']));else _0x479eb4===_0x162ce1(0x432)?_0x43a66f[_0x162ce1(0x608)]():_0x43a66f[_0x162ce1(0x3a4)](_0x479eb4);if(!_0x3a6d3d)_0x43a66f[_0x162ce1(0x229)](0x0);else{if(_0x3a6d3d&&[_0x162ce1(0xa03),_0x162ce1(0x9b1),_0x162ce1(0x6f6)][_0x162ce1(0xa3e)](_0x479eb4)){}}}}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x564),_0x47c006=>{const _0x50e787=_0x1a8785;if(!SceneManager[_0x50e787(0x3a8)]())return;VisuMZ[_0x50e787(0x235)](_0x47c006,_0x47c006);const _0xc7c80d=BattleManager[_0x50e787(0x440)];if(!_0xc7c80d)return;if(!_0xc7c80d[_0x50e787(0x7e0)]())return;const _0x428ab4=VisuMZ[_0x50e787(0x65c)](_0x47c006[_0x50e787(0x7f7)]);for(const _0x18d68c of _0x428ab4){if(!_0x18d68c)continue;_0x18d68c['performAction'](_0xc7c80d);}}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0xa4d),_0xb3dd67=>{const _0x479e8d=_0x1a8785;if(!SceneManager[_0x479e8d(0x3a8)]())return;VisuMZ['ConvertParams'](_0xb3dd67,_0xb3dd67);const _0x55c100=VisuMZ[_0x479e8d(0x65c)](_0xb3dd67[_0x479e8d(0x7f7)]);for(const _0x1eca2f of _0x55c100){if(!_0x1eca2f)continue;if(!_0x1eca2f[_0x479e8d(0x89e)]())continue;_0x1eca2f[_0x479e8d(0x89e)]()[_0x479e8d(0x5ca)]();}}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],'ActSeq_Motion_WaitMotionFrame',_0x3d7ef7=>{const _0x123cbf=_0x1a8785;if(!SceneManager[_0x123cbf(0x3a8)]())return;VisuMZ['ConvertParams'](_0x3d7ef7,_0x3d7ef7);const _0x798ef5=$gameTemp['getLastPluginCommandInterpreter'](),_0xea1367=_0x3d7ef7['MotionFrameWait']*Sprite_Battler[_0x123cbf(0x1a4)];_0x798ef5[_0x123cbf(0x7c9)](_0xea1367);}),PluginManager['registerCommand'](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x4be),_0x265f10=>{const _0x19bb1b=_0x1a8785;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x19bb1b(0x235)](_0x265f10,_0x265f10);const _0x3e5608=$gameTemp[_0x19bb1b(0x55b)](),_0x26887c=BattleManager[_0x19bb1b(0x440)];if(!_0x3e5608||!_0x26887c)return;if(!_0x26887c[_0x19bb1b(0x7e0)]())return;const _0x52ad5f=VisuMZ[_0x19bb1b(0x65c)](_0x265f10[_0x19bb1b(0x7f7)]);for(const _0x22b747 of _0x52ad5f){if(!_0x22b747)continue;_0x22b747[_0x19bb1b(0x80d)](_0x26887c);}if(_0x265f10['WaitForMovement'])_0x3e5608[_0x19bb1b(0xab1)](_0x19bb1b(0x248));}),PluginManager['registerCommand'](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x19c),_0x1b30e2=>{const _0x2e6928=_0x1a8785;if(!SceneManager['isSceneBattle']())return;if(!$gameSystem['isSideView']())return;VisuMZ[_0x2e6928(0x235)](_0x1b30e2,_0x1b30e2);const _0x3984fa=$gameTemp['getLastPluginCommandInterpreter'](),_0xdb0d93=VisuMZ['CreateActionSequenceTargets'](_0x1b30e2[_0x2e6928(0x7f7)]),_0x45039e=_0x1b30e2[_0x2e6928(0x8be)],_0x31e85f=_0x1b30e2['DistanceX'],_0x371cb2=_0x1b30e2[_0x2e6928(0x5a2)],_0x2a5ce5=_0x1b30e2[_0x2e6928(0x918)],_0x534d46=_0x1b30e2[_0x2e6928(0x339)],_0x4ff23a=_0x1b30e2[_0x2e6928(0x6c4)],_0x2ec88e=_0x1b30e2[_0x2e6928(0x994)],_0x400391=_0x1b30e2[_0x2e6928(0x615)];if(!_0x3984fa)return;for(const _0xda0f1c of _0xdb0d93){if(!_0xda0f1c)continue;let _0x444820=_0x31e85f,_0x4482fc=_0x371cb2;if(_0x45039e['match'](/horz/i))_0x444820*=_0xda0f1c['isActor']()?-0x1:0x1;if(_0x45039e['match'](/vert/i))_0x4482fc*=_0xda0f1c[_0x2e6928(0x68d)]()?-0x1:0x1;_0xda0f1c[_0x2e6928(0x55d)](_0x444820,_0x4482fc,_0x2a5ce5,_0x534d46,_0x4ff23a),_0xda0f1c[_0x2e6928(0x3a4)](_0x2ec88e);}if(_0x400391)_0x3984fa[_0x2e6928(0xab1)](_0x2e6928(0x248));}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],_0x1a8785(0x933),_0x262663=>{const _0x5e816b=_0x1a8785;if(!SceneManager['isSceneBattle']())return;if(!$gameSystem[_0x5e816b(0x973)]())return;VisuMZ[_0x5e816b(0x235)](_0x262663,_0x262663);const _0x38c17b=$gameTemp[_0x5e816b(0x55b)](),_0x13e627=VisuMZ['CreateActionSequenceTargets'](_0x262663[_0x5e816b(0x7f7)]),_0x13f4c5=_0x262663['Destination'],_0x2e45b2=_0x262663['OffsetAdjust'],_0x3aef32=_0x262663[_0x5e816b(0xa93)],_0x1fca15=_0x262663[_0x5e816b(0x4bf)],_0x368586=_0x262663[_0x5e816b(0x918)],_0x1e5942=_0x262663['FaceDirection'],_0x4958db=_0x262663[_0x5e816b(0x6c4)],_0x225980=_0x262663[_0x5e816b(0x994)],_0x473c58=_0x262663[_0x5e816b(0x615)];if(!_0x38c17b)return;for(const _0x48a3c0 of _0x13e627){if(!_0x48a3c0)continue;let _0x4a17e0=_0x48a3c0[_0x5e816b(0x89e)]()['_baseX'],_0x5d08e9=_0x48a3c0['battler']()[_0x5e816b(0x236)];if(_0x13f4c5[_0x5e816b(0x9e0)](/home/i))_0x4a17e0=_0x48a3c0[_0x5e816b(0x89e)]()[_0x5e816b(0x9b9)],_0x5d08e9=_0x48a3c0['battler']()[_0x5e816b(0x774)];else{if(_0x13f4c5[_0x5e816b(0x9e0)](/center/i))_0x4a17e0=Graphics[_0x5e816b(0x9ab)]/0x2,_0x5d08e9=Graphics[_0x5e816b(0x69d)]/0x2;else _0x13f4c5[_0x5e816b(0x9e0)](/point (\d+), (\d+)/i)&&(_0x4a17e0=Number(RegExp['$1']),_0x5d08e9=Number(RegExp['$2']));}if(_0x2e45b2[_0x5e816b(0x9e0)](/none/i))_0x4a17e0+=_0x3aef32,_0x5d08e9+=_0x1fca15;else{if(_0x2e45b2['match'](/horz/i)&&_0x2e45b2[_0x5e816b(0x9e0)](/vert/i))_0x4a17e0+=_0x48a3c0['isActor']()?-_0x3aef32:_0x3aef32,_0x5d08e9+=_0x48a3c0[_0x5e816b(0x68d)]()?-_0x1fca15:_0x1fca15;else{if(_0x2e45b2[_0x5e816b(0x9e0)](/horz/i))_0x4a17e0+=_0x48a3c0[_0x5e816b(0x68d)]()?-_0x3aef32:_0x3aef32,_0x5d08e9+=_0x1fca15;else _0x2e45b2[_0x5e816b(0x9e0)](/vert/i)&&(_0x4a17e0+=_0x3aef32,_0x5d08e9+=_0x48a3c0[_0x5e816b(0x68d)]()?-_0x1fca15:_0x1fca15);}}_0x48a3c0['moveBattlerHomeToPoint'](_0x4a17e0,_0x5d08e9,_0x368586,_0x1e5942,_0x4958db,-0x1),_0x48a3c0[_0x5e816b(0x3a4)](_0x225980);}if(_0x473c58)_0x38c17b[_0x5e816b(0xab1)](_0x5e816b(0x248));}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x26d),_0x10ba90=>{const _0x233bee=_0x1a8785;if(!SceneManager[_0x233bee(0x3a8)]())return;if(!$gameSystem[_0x233bee(0x973)]())return;VisuMZ['ConvertParams'](_0x10ba90,_0x10ba90);const _0x48c2da=$gameTemp['getLastPluginCommandInterpreter'](),_0x43e34c=VisuMZ['CreateActionSequenceTargets'](_0x10ba90[_0x233bee(0x2aa)]),_0x38e493=VisuMZ[_0x233bee(0x65c)](_0x10ba90[_0x233bee(0x4c6)]),_0x597b0d=_0x10ba90['TargetLocation'];let _0x31965d=_0x10ba90['MeleeDistance'];const _0x37b93b=_0x10ba90['OffsetAdjust'],_0x5bbde8=_0x10ba90[_0x233bee(0xa93)],_0x1a14e8=_0x10ba90[_0x233bee(0x4bf)],_0x121737=_0x10ba90[_0x233bee(0x918)],_0x4a86ff=_0x10ba90['FaceDirection'],_0x29d4c4=_0x10ba90['EasingType'],_0x12c3ef=_0x10ba90[_0x233bee(0x994)],_0x35ccb4=_0x10ba90[_0x233bee(0x615)],_0x3c4267=Math['min'](..._0x38e493[_0x233bee(0x628)](_0x2020d0=>_0x2020d0[_0x233bee(0x89e)]()[_0x233bee(0x6c5)]-_0x2020d0['battler']()[_0x233bee(0x4a2)]()/0x2)),_0x4e6823=Math['max'](..._0x38e493[_0x233bee(0x628)](_0x47ea0e=>_0x47ea0e[_0x233bee(0x89e)]()[_0x233bee(0x6c5)]+_0x47ea0e[_0x233bee(0x89e)]()['mainSpriteWidth']()/0x2)),_0x3a5680=Math[_0x233bee(0xae7)](..._0x38e493['map'](_0x40ca8d=>_0x40ca8d[_0x233bee(0x89e)]()['_baseY']-_0x40ca8d[_0x233bee(0x89e)]()[_0x233bee(0x27b)]())),_0x4b9532=Math[_0x233bee(0x5a7)](..._0x38e493[_0x233bee(0x628)](_0xe352a4=>_0xe352a4[_0x233bee(0x89e)]()[_0x233bee(0x236)])),_0x499956=_0x38e493['filter'](_0x29175c=>_0x29175c['isActor']())[_0x233bee(0x2dc)],_0x5b9847=_0x38e493[_0x233bee(0x70f)](_0xa6c4c3=>_0xa6c4c3[_0x233bee(0x3a6)]())[_0x233bee(0x2dc)];let _0x6a2dae=0x0,_0x218248=0x0;if(_0x597b0d['match'](/front/i))_0x6a2dae=_0x499956>=_0x5b9847?_0x3c4267:_0x4e6823;else{if(_0x597b0d[_0x233bee(0x9e0)](/middle/i))_0x6a2dae=(_0x3c4267+_0x4e6823)/0x2,_0x31965d=-0x1;else _0x597b0d[_0x233bee(0x9e0)](/back/i)&&(_0x6a2dae=_0x499956>=_0x5b9847?_0x4e6823:_0x3c4267);}if(_0x597b0d[_0x233bee(0x9e0)](/head/i))_0x218248=_0x3a5680;else{if(_0x597b0d[_0x233bee(0x9e0)](/center/i))_0x218248=(_0x3a5680+_0x4b9532)/0x2;else _0x597b0d[_0x233bee(0x9e0)](/base/i)&&(_0x218248=_0x4b9532);}if(!_0x48c2da)return;for(const _0x219dbe of _0x43e34c){if(!_0x219dbe)continue;let _0x2c2ffe=_0x6a2dae,_0xe2e151=_0x218248;if(_0x37b93b[_0x233bee(0x9e0)](/none/i))_0x2c2ffe+=_0x5bbde8,_0xe2e151+=_0x1a14e8;else{if(_0x37b93b[_0x233bee(0x9e0)](/horz/i)&&_0x37b93b[_0x233bee(0x9e0)](/vert/i))_0x2c2ffe+=_0x219dbe[_0x233bee(0x68d)]()?-_0x5bbde8:_0x5bbde8,_0xe2e151+=_0x219dbe['isActor']()?-_0x1a14e8:_0x1a14e8;else{if(_0x37b93b[_0x233bee(0x9e0)](/horz/i))_0x2c2ffe+=_0x219dbe['isActor']()?-_0x5bbde8:_0x5bbde8,_0xe2e151+=_0x1a14e8;else _0x37b93b[_0x233bee(0x9e0)](/vert/i)&&(_0x2c2ffe+=_0x5bbde8,_0xe2e151+=_0x219dbe[_0x233bee(0x68d)]()?-_0x1a14e8:_0x1a14e8);}}_0x219dbe[_0x233bee(0x9f5)](_0x2c2ffe,_0xe2e151,_0x121737,_0x4a86ff,_0x29d4c4,_0x31965d),_0x219dbe[_0x233bee(0x3a4)](_0x12c3ef);}if(_0x35ccb4)_0x48c2da[_0x233bee(0xab1)](_0x233bee(0x248));}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],_0x1a8785(0x23e),_0x59c4ea=>{const _0xee7481=_0x1a8785;if(!SceneManager['isSceneBattle']())return;if(!$gameSystem[_0xee7481(0x973)]())return;VisuMZ['ConvertParams'](_0x59c4ea,_0x59c4ea);const _0x3746e4=VisuMZ['CreateActionSequenceTargets'](_0x59c4ea[_0xee7481(0x7f7)]);let _0x1842e6=_0x59c4ea['Direction'][_0xee7481(0x9e0)](/back/i);for(const _0x41601c of _0x3746e4){if(!_0x41601c)continue;if(_0x59c4ea[_0xee7481(0x7ef)][_0xee7481(0x9e0)](/rand/i))_0x1842e6=Math[_0xee7481(0x526)](0x2);_0x41601c[_0xee7481(0x321)](!!_0x1842e6);}}),PluginManager['registerCommand'](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x61f),_0x4e2512=>{const _0x2137c2=_0x1a8785;if(!SceneManager[_0x2137c2(0x3a8)]())return;if(!$gameSystem['isSideView']())return;VisuMZ[_0x2137c2(0x235)](_0x4e2512,_0x4e2512);const _0x3fd08c=VisuMZ[_0x2137c2(0x65c)](_0x4e2512[_0x2137c2(0x7f7)]);let _0x48d93f=_0x4e2512['Point'];const _0x3003d5=_0x4e2512['FaceAway'];for(const _0x126fda of _0x3fd08c){if(!_0x126fda)continue;let _0x430622=_0x126fda[_0x2137c2(0x89e)]()[_0x2137c2(0x6c5)],_0x3b53cd=_0x126fda[_0x2137c2(0x89e)]()[_0x2137c2(0x236)];if(_0x48d93f['match'](/home/i))_0x430622=_0x126fda[_0x2137c2(0x89e)]()[_0x2137c2(0x9b9)],_0x3b53cd=_0x126fda[_0x2137c2(0x89e)]()[_0x2137c2(0x774)];else{if(_0x48d93f[_0x2137c2(0x9e0)](/center/i))_0x430622=Graphics['boxWidth']/0x2,_0x3b53cd=Graphics['boxHeight']/0x2;else _0x48d93f[_0x2137c2(0x9e0)](/point (\d+), (\d+)/i)&&(_0x430622=Number(RegExp['$1']),_0x3b53cd=Number(RegExp['$2']));}_0x126fda[_0x2137c2(0x1cf)](Math[_0x2137c2(0x86d)](_0x430622),Math['round'](_0x3b53cd),!!_0x3003d5);}}),PluginManager['registerCommand'](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x93a),_0x5e94a0=>{const _0x31c2ad=_0x1a8785;if(!SceneManager[_0x31c2ad(0x3a8)]())return;if(!$gameSystem[_0x31c2ad(0x973)]())return;VisuMZ[_0x31c2ad(0x235)](_0x5e94a0,_0x5e94a0);const _0x225a87=VisuMZ['CreateActionSequenceTargets'](_0x5e94a0[_0x31c2ad(0x2aa)]),_0x3534a3=VisuMZ[_0x31c2ad(0x65c)](_0x5e94a0[_0x31c2ad(0x4c6)]),_0x3b8ace=_0x3534a3[_0x31c2ad(0x628)](_0x43b5d3=>_0x43b5d3&&_0x43b5d3['battler']()?_0x43b5d3[_0x31c2ad(0x89e)]()[_0x31c2ad(0x6c5)]:0x0)/(_0x3534a3[_0x31c2ad(0x2dc)]||0x1),_0x43633d=_0x3534a3[_0x31c2ad(0x628)](_0x22ffe1=>_0x22ffe1&&_0x22ffe1[_0x31c2ad(0x89e)]()?_0x22ffe1[_0x31c2ad(0x89e)]()[_0x31c2ad(0x236)]:0x0)/(_0x3534a3[_0x31c2ad(0x2dc)]||0x1),_0x33eea6=_0x5e94a0['FaceAway'];for(const _0x27b18f of _0x225a87){if(!_0x27b18f)continue;_0x27b18f[_0x31c2ad(0x1cf)](Math['round'](_0x3b8ace),Math[_0x31c2ad(0x86d)](_0x43633d),!!_0x33eea6);}}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0xa64),_0x1226c0=>{const _0x4a8975=_0x1a8785;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x4a8975(0x235)](_0x1226c0,_0x1226c0);const _0x2d12e3=$gameTemp[_0x4a8975(0x55b)](),_0x40707b=VisuMZ['CreateActionSequenceTargets'](_0x1226c0[_0x4a8975(0x7f7)]),_0x31bdab=_0x1226c0[_0x4a8975(0x3c3)],_0x10f9d3=_0x1226c0['Duration'],_0x250de9=_0x1226c0['EasingType'],_0x1907dd=_0x1226c0[_0x4a8975(0x87f)];if(!_0x2d12e3)return;for(const _0x222840 of _0x40707b){if(!_0x222840)continue;_0x222840[_0x4a8975(0x336)](_0x31bdab,_0x10f9d3,_0x250de9);}if(_0x1907dd)_0x2d12e3[_0x4a8975(0xab1)](_0x4a8975(0x5df));}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x7fa),_0xb0b3e2=>{const _0x599a49=_0x1a8785;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x599a49(0x235)](_0xb0b3e2,_0xb0b3e2);const _0x57a6b2=$gameTemp[_0x599a49(0x55b)]();if(!_0x57a6b2)return;const _0x5a8b5a=VisuMZ[_0x599a49(0x65c)](_0xb0b3e2[_0x599a49(0x7f7)]);for(const _0x100fbb of _0x5a8b5a){if(!_0x100fbb)continue;_0x100fbb[_0x599a49(0x2ce)]();}BattleManager[_0x599a49(0x938)]&&BattleManager[_0x599a49(0x938)]['performActionEnd']();if(_0xb0b3e2[_0x599a49(0x615)])_0x57a6b2[_0x599a49(0xab1)](_0x599a49(0x248));}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],'ActSeq_Movement_Jump',_0x2ebc2e=>{const _0x5a6f14=_0x1a8785;if(!SceneManager[_0x5a6f14(0x3a8)]())return;VisuMZ['ConvertParams'](_0x2ebc2e,_0x2ebc2e);const _0x40f18f=$gameTemp['getLastPluginCommandInterpreter'](),_0x34ece1=VisuMZ['CreateActionSequenceTargets'](_0x2ebc2e[_0x5a6f14(0x7f7)]),_0x5543c7=_0x2ebc2e[_0x5a6f14(0x3c3)],_0x3d9e35=_0x2ebc2e[_0x5a6f14(0x918)],_0x2bcd4d=_0x2ebc2e[_0x5a6f14(0x680)];if(!_0x40f18f)return;for(const _0x1fd462 of _0x34ece1){if(!_0x1fd462)continue;_0x1fd462['jumpBattler'](_0x5543c7,_0x3d9e35);}if(_0x2bcd4d)_0x40f18f[_0x5a6f14(0xab1)](_0x5a6f14(0x66b));}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x275),_0x3c1a05=>{const _0x33c002=_0x1a8785;if(!SceneManager[_0x33c002(0x3a8)]())return;if(!$gameSystem[_0x33c002(0x973)]())return;VisuMZ[_0x33c002(0x235)](_0x3c1a05,_0x3c1a05);const _0x10ebf5=$gameTemp['getLastPluginCommandInterpreter'](),_0x519021=VisuMZ['CreateActionSequenceTargets'](_0x3c1a05[_0x33c002(0x7f7)]),_0x95c61d=_0x3c1a05[_0x33c002(0x8be)],_0x3cfb55=_0x3c1a05['DistanceX'],_0x2168a5=_0x3c1a05[_0x33c002(0x5a2)],_0x179027=_0x3c1a05[_0x33c002(0x918)],_0x165944=_0x3c1a05[_0x33c002(0x339)],_0x123e23=_0x3c1a05['EasingType'],_0x3b48db=_0x3c1a05['MotionType'],_0x10fa1a=_0x3c1a05['WaitForMovement'];if(!_0x10ebf5)return;for(const _0x6d86dc of _0x519021){if(!_0x6d86dc)continue;let _0x51a950=_0x3cfb55,_0x106be1=_0x2168a5;if(_0x95c61d[_0x33c002(0x9e0)](/horz/i))_0x51a950*=_0x6d86dc[_0x33c002(0x68d)]()?-0x1:0x1;if(_0x95c61d[_0x33c002(0x9e0)](/vert/i))_0x106be1*=_0x6d86dc[_0x33c002(0x68d)]()?-0x1:0x1;_0x6d86dc[_0x33c002(0x2ba)](_0x51a950,_0x106be1,_0x179027,_0x165944,_0x123e23),_0x6d86dc[_0x33c002(0x3a4)](_0x3b48db);}if(_0x10fa1a)_0x10ebf5['setWaitMode']('battleMove');}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0xa20),_0xb609c0=>{const _0x39b6c0=_0x1a8785;if(!SceneManager[_0x39b6c0(0x3a8)]())return;if(!$gameSystem['isSideView']())return;VisuMZ['ConvertParams'](_0xb609c0,_0xb609c0);const _0x355d79=$gameTemp['getLastPluginCommandInterpreter'](),_0x2e2cbc=VisuMZ[_0x39b6c0(0x65c)](_0xb609c0[_0x39b6c0(0x7f7)]),_0x46adc9=_0xb609c0['Destination'],_0x328a9a=_0xb609c0[_0x39b6c0(0x822)],_0x1b11df=_0xb609c0[_0x39b6c0(0xa93)],_0x3d7046=_0xb609c0[_0x39b6c0(0x4bf)],_0x1ebcb2=_0xb609c0[_0x39b6c0(0x918)],_0x472164=_0xb609c0[_0x39b6c0(0x339)],_0x422a9=_0xb609c0['EasingType'],_0x19a7c5=_0xb609c0[_0x39b6c0(0x994)],_0x242641=_0xb609c0[_0x39b6c0(0x615)];if(!_0x355d79)return;for(const _0x3f659e of _0x2e2cbc){if(!_0x3f659e)continue;let _0x1bf49e=_0x3f659e[_0x39b6c0(0x89e)]()[_0x39b6c0(0x6c5)],_0x1642a2=_0x3f659e[_0x39b6c0(0x89e)]()['_baseY'];if(_0x46adc9['match'](/home/i))_0x1bf49e=_0x3f659e[_0x39b6c0(0x89e)]()[_0x39b6c0(0x9b9)],_0x1642a2=_0x3f659e[_0x39b6c0(0x89e)]()['_homeY'];else{if(_0x46adc9[_0x39b6c0(0x9e0)](/center/i))_0x1bf49e=Graphics[_0x39b6c0(0x9ab)]/0x2,_0x1642a2=Graphics[_0x39b6c0(0x69d)]/0x2;else _0x46adc9[_0x39b6c0(0x9e0)](/point (\d+), (\d+)/i)&&(_0x1bf49e=Number(RegExp['$1']),_0x1642a2=Number(RegExp['$2']));}if(_0x328a9a[_0x39b6c0(0x9e0)](/none/i))_0x1bf49e+=_0x1b11df,_0x1642a2+=_0x3d7046;else{if(_0x328a9a[_0x39b6c0(0x9e0)](/horz/i)&&_0x328a9a[_0x39b6c0(0x9e0)](/vert/i))_0x1bf49e+=_0x3f659e[_0x39b6c0(0x68d)]()?-_0x1b11df:_0x1b11df,_0x1642a2+=_0x3f659e['isActor']()?-_0x3d7046:_0x3d7046;else{if(_0x328a9a[_0x39b6c0(0x9e0)](/horz/i))_0x1bf49e+=_0x3f659e[_0x39b6c0(0x68d)]()?-_0x1b11df:_0x1b11df,_0x1642a2+=_0x3d7046;else _0x328a9a[_0x39b6c0(0x9e0)](/vert/i)&&(_0x1bf49e+=_0x1b11df,_0x1642a2+=_0x3f659e[_0x39b6c0(0x68d)]()?-_0x3d7046:_0x3d7046);}}_0x3f659e[_0x39b6c0(0x2cc)](_0x1bf49e,_0x1642a2,_0x1ebcb2,_0x472164,_0x422a9,-0x1),_0x3f659e[_0x39b6c0(0x3a4)](_0x19a7c5);}if(_0x242641)_0x355d79[_0x39b6c0(0xab1)](_0x39b6c0(0x248));}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x929),_0x1214aa=>{const _0x3a0856=_0x1a8785;if(!SceneManager['isSceneBattle']())return;if(!$gameSystem[_0x3a0856(0x973)]())return;VisuMZ['ConvertParams'](_0x1214aa,_0x1214aa);const _0x10d0ae=$gameTemp[_0x3a0856(0x55b)](),_0x580af0=VisuMZ['CreateActionSequenceTargets'](_0x1214aa[_0x3a0856(0x2aa)]),_0x1393d3=VisuMZ['CreateActionSequenceTargets'](_0x1214aa[_0x3a0856(0x4c6)]),_0x23dd26=_0x1214aa[_0x3a0856(0x5f4)];let _0x1a8271=_0x1214aa['MeleeDistance'];const _0x3595b9=_0x1214aa['OffsetAdjust'],_0x143510=_0x1214aa[_0x3a0856(0xa93)],_0x36798c=_0x1214aa['OffsetY'],_0x2d939c=_0x1214aa[_0x3a0856(0x918)],_0x155f9d=_0x1214aa[_0x3a0856(0x339)],_0x2793f1=_0x1214aa['EasingType'],_0x56cc3f=_0x1214aa[_0x3a0856(0x994)],_0x180fe3=_0x1214aa['WaitForMovement'],_0xd6c5a=Math['min'](..._0x1393d3['map'](_0x51f77b=>_0x51f77b[_0x3a0856(0x89e)]()[_0x3a0856(0x6c5)]-_0x51f77b[_0x3a0856(0x89e)]()[_0x3a0856(0x4a2)]()/0x2)),_0x44b186=Math[_0x3a0856(0x5a7)](..._0x1393d3[_0x3a0856(0x628)](_0x88ed7d=>_0x88ed7d[_0x3a0856(0x89e)]()[_0x3a0856(0x6c5)]+_0x88ed7d[_0x3a0856(0x89e)]()['mainSpriteWidth']()/0x2)),_0x2f5287=Math[_0x3a0856(0xae7)](..._0x1393d3[_0x3a0856(0x628)](_0x43224=>_0x43224[_0x3a0856(0x89e)]()[_0x3a0856(0x236)]-_0x43224[_0x3a0856(0x89e)]()[_0x3a0856(0x27b)]())),_0xcc89a2=Math[_0x3a0856(0x5a7)](..._0x1393d3['map'](_0x12d9c7=>_0x12d9c7[_0x3a0856(0x89e)]()['_baseY'])),_0x3f2bb2=_0x1393d3[_0x3a0856(0x70f)](_0x30fbb5=>_0x30fbb5[_0x3a0856(0x68d)]())['length'],_0x325198=_0x1393d3[_0x3a0856(0x70f)](_0x508855=>_0x508855[_0x3a0856(0x3a6)]())['length'];let _0x1b4539=0x0,_0x21e430=0x0;if(_0x23dd26[_0x3a0856(0x9e0)](/front/i))_0x1b4539=_0x3f2bb2>=_0x325198?_0xd6c5a:_0x44b186;else{if(_0x23dd26['match'](/middle/i))_0x1b4539=(_0xd6c5a+_0x44b186)/0x2,_0x1a8271=-0x1;else _0x23dd26[_0x3a0856(0x9e0)](/back/i)&&(_0x1b4539=_0x3f2bb2>=_0x325198?_0x44b186:_0xd6c5a);}if(_0x23dd26[_0x3a0856(0x9e0)](/head/i))_0x21e430=_0x2f5287;else{if(_0x23dd26['match'](/center/i))_0x21e430=(_0x2f5287+_0xcc89a2)/0x2;else _0x23dd26['match'](/base/i)&&(_0x21e430=_0xcc89a2);}if(!_0x10d0ae)return;for(const _0x3e05c1 of _0x580af0){if(!_0x3e05c1)continue;let _0x7a9052=_0x1b4539,_0x4baf27=_0x21e430;if(_0x3595b9[_0x3a0856(0x9e0)](/none/i))_0x7a9052+=_0x143510,_0x4baf27+=_0x36798c;else{if(_0x3595b9[_0x3a0856(0x9e0)](/horz/i)&&_0x3595b9[_0x3a0856(0x9e0)](/vert/i))_0x7a9052+=_0x3e05c1[_0x3a0856(0x68d)]()?-_0x143510:_0x143510,_0x4baf27+=_0x3e05c1[_0x3a0856(0x68d)]()?-_0x36798c:_0x36798c;else{if(_0x3595b9[_0x3a0856(0x9e0)](/horz/i))_0x7a9052+=_0x3e05c1['isActor']()?-_0x143510:_0x143510,_0x4baf27+=_0x36798c;else _0x3595b9['match'](/vert/i)&&(_0x7a9052+=_0x143510,_0x4baf27+=_0x3e05c1[_0x3a0856(0x68d)]()?-_0x36798c:_0x36798c);}}_0x3e05c1['moveBattlerToPoint'](_0x7a9052,_0x4baf27,_0x2d939c,_0x155f9d,_0x2793f1,_0x1a8271),_0x3e05c1[_0x3a0856(0x3a4)](_0x56cc3f);}if(_0x180fe3)_0x10d0ae[_0x3a0856(0xab1)](_0x3a0856(0x248));}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x189),_0x18c782=>{const _0x135f4a=_0x1a8785;if(!SceneManager[_0x135f4a(0x3a8)]())return;VisuMZ[_0x135f4a(0x235)](_0x18c782,_0x18c782);const _0x3395f3=$gameTemp['getLastPluginCommandInterpreter'](),_0xb3cca8=VisuMZ[_0x135f4a(0x65c)](_0x18c782[_0x135f4a(0x7f7)]),_0x4ed54e=_0x18c782[_0x135f4a(0x7e3)],_0x2fd7e4=_0x18c782[_0x135f4a(0x918)],_0x14edde=_0x18c782[_0x135f4a(0x6c4)],_0x14be70=_0x18c782[_0x135f4a(0x6ce)];if(!_0x3395f3)return;for(const _0x27752e of _0xb3cca8){if(!_0x27752e)continue;_0x27752e['changeBattlerOpacity'](_0x4ed54e,_0x2fd7e4,_0x14edde);}if(_0x14be70)_0x3395f3[_0x135f4a(0xab1)](_0x135f4a(0x647));}),PluginManager['registerCommand'](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x4ba),_0x50c7cc=>{const _0x16bdb4=_0x1a8785;if(!SceneManager[_0x16bdb4(0x3a8)]())return;VisuMZ['ConvertParams'](_0x50c7cc,_0x50c7cc);const _0x3de8b8=$gameTemp[_0x16bdb4(0x55b)](),_0x1073b7=VisuMZ[_0x16bdb4(0x65c)](_0x50c7cc[_0x16bdb4(0x7f7)]),_0x1a08e3=_0x50c7cc[_0x16bdb4(0x52e)],_0x1cce63=_0x50c7cc[_0x16bdb4(0x74e)],_0x1650bf=_0x50c7cc['Duration'],_0x4a095d=_0x50c7cc[_0x16bdb4(0x6c4)],_0x202e64=_0x50c7cc[_0x16bdb4(0x861)];if(!_0x3de8b8)return;for(const _0x1a7f93 of _0x1073b7){if(!_0x1a7f93)continue;_0x1a7f93['growBattler'](_0x1a08e3,_0x1cce63,_0x1650bf,_0x4a095d);}if(_0x202e64)_0x3de8b8[_0x16bdb4(0xab1)](_0x16bdb4(0x294));}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x2ca),_0x35d11b=>{const _0x1aef7d=_0x1a8785;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x1aef7d(0x235)](_0x35d11b,_0x35d11b);const _0x4808ac=$gameTemp['getLastPluginCommandInterpreter'](),_0x35508b=VisuMZ[_0x1aef7d(0x65c)](_0x35d11b[_0x1aef7d(0x7f7)]),_0x26af2c=_0x35d11b[_0x1aef7d(0x19a)],_0xb9a0ed=_0x35d11b[_0x1aef7d(0x756)],_0x56d890=_0x35d11b[_0x1aef7d(0x918)],_0xda3bf5=_0x35d11b[_0x1aef7d(0x6c4)],_0xeb1e06=_0x35d11b['WaitForSkew'];if(!_0x4808ac)return;for(const _0x2a573b of _0x35508b){if(!_0x2a573b)continue;_0x2a573b['skewBattler'](_0x26af2c,_0xb9a0ed,_0x56d890,_0xda3bf5);}if(_0xeb1e06)_0x4808ac[_0x1aef7d(0xab1)](_0x1aef7d(0x3a7));}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x4eb),_0x4ba441=>{const _0x17fc8d=_0x1a8785;if(!SceneManager[_0x17fc8d(0x3a8)]())return;VisuMZ[_0x17fc8d(0x235)](_0x4ba441,_0x4ba441);const _0x115685=$gameTemp[_0x17fc8d(0x55b)](),_0x2d6b4a=VisuMZ[_0x17fc8d(0x65c)](_0x4ba441[_0x17fc8d(0x7f7)]),_0x3399cc=_0x4ba441[_0x17fc8d(0x205)],_0x525136=_0x4ba441['Duration'],_0x4de58a=_0x4ba441[_0x17fc8d(0x6c4)],_0x357dd2=_0x4ba441[_0x17fc8d(0x582)],_0x37248b=_0x4ba441[_0x17fc8d(0x2d8)];if(!_0x115685)return;for(const _0x39c504 of _0x2d6b4a){if(!_0x39c504)continue;_0x39c504['spinBattler'](_0x3399cc,_0x525136,_0x4de58a,_0x357dd2);}if(_0x37248b)_0x115685[_0x17fc8d(0xab1)](_0x17fc8d(0x23d));}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],'ActSeq_Movement_WaitForFloat',_0x24dce3=>{const _0x5422cf=_0x1a8785;if(!SceneManager[_0x5422cf(0x3a8)]())return;const _0x1ca76e=$gameTemp['getLastPluginCommandInterpreter']();if(!_0x1ca76e)return;_0x1ca76e[_0x5422cf(0xab1)](_0x5422cf(0x5df));}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0xa70),_0x58d9d2=>{const _0x3d1b2e=_0x1a8785;if(!SceneManager[_0x3d1b2e(0x3a8)]())return;const _0x52338e=$gameTemp['getLastPluginCommandInterpreter']();if(!_0x52338e)return;_0x52338e[_0x3d1b2e(0xab1)]('battleJump');}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x68b),_0x13f826=>{const _0x529df7=_0x1a8785;if(!SceneManager[_0x529df7(0x3a8)]())return;const _0x1aa280=$gameTemp[_0x529df7(0x55b)]();if(!_0x1aa280)return;_0x1aa280['setWaitMode'](_0x529df7(0x248));}),PluginManager['registerCommand'](pluginData['name'],_0x1a8785(0x88a),_0x35944f=>{const _0x16acc9=_0x1a8785;if(!SceneManager[_0x16acc9(0x3a8)]())return;const _0x515ee6=$gameTemp[_0x16acc9(0x55b)]();if(!_0x515ee6)return;_0x515ee6[_0x16acc9(0xab1)](_0x16acc9(0x647));}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x956),_0x19bc7a=>{const _0x58625c=_0x1a8785;if(!SceneManager[_0x58625c(0x3a8)]())return;const _0x32fa31=$gameTemp[_0x58625c(0x55b)]();if(!_0x32fa31)return;_0x32fa31[_0x58625c(0xab1)]('battleGrow');}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x5ad),_0x35dbe1=>{const _0x3cdfca=_0x1a8785;if(!SceneManager[_0x3cdfca(0x3a8)]())return;const _0x238bd4=$gameTemp[_0x3cdfca(0x55b)]();if(!_0x238bd4)return;_0x238bd4[_0x3cdfca(0xab1)]('battleSpriteSkew');}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x25c),_0x509f04=>{const _0x2c16b6=_0x1a8785;if(!SceneManager[_0x2c16b6(0x3a8)]())return;const _0x55b788=$gameTemp[_0x2c16b6(0x55b)]();if(!_0x55b788)return;_0x55b788[_0x2c16b6(0xab1)](_0x2c16b6(0x23d));}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],_0x1a8785(0x433),_0x4281e3=>{const _0x1627da=_0x1a8785;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x1627da(0x937)])return;VisuMZ[_0x1627da(0x235)](_0x4281e3,_0x4281e3);const _0x3eacc7=$gameTemp[_0x1627da(0x55b)](),_0x365bfc=_0x4281e3[_0x1627da(0x673)];if(!_0x3eacc7)return;const _0x359b3f=BattleManager['_spriteset'];if(!_0x359b3f)return;_0x359b3f[_0x1627da(0x1e5)](_0x4281e3);if(_0x365bfc)_0x3eacc7[_0x1627da(0xab1)]('battleProjectiles');}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0xa1a),_0x45d9ff=>{const _0x1f6b13=_0x1a8785;if(!SceneManager[_0x1f6b13(0x3a8)]())return;if(!Imported[_0x1f6b13(0x937)])return;VisuMZ['ConvertParams'](_0x45d9ff,_0x45d9ff);const _0x477701=$gameTemp[_0x1f6b13(0x55b)](),_0xc753a4=_0x45d9ff[_0x1f6b13(0x673)];if(!_0x477701)return;const _0xd82fc6=BattleManager[_0x1f6b13(0x589)];if(!_0xd82fc6)return;_0xd82fc6[_0x1f6b13(0x1e5)](_0x45d9ff);if(_0xc753a4)_0x477701[_0x1f6b13(0xab1)](_0x1f6b13(0x21f));}),PluginManager['registerCommand'](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x636),_0x52cd08=>{const _0x44a136=_0x1a8785;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x44a136(0x937)])return;VisuMZ[_0x44a136(0x235)](_0x52cd08,_0x52cd08);const _0x53b4ce=$gameTemp[_0x44a136(0x55b)](),_0x74df57=_0x52cd08[_0x44a136(0x673)];if(!_0x53b4ce)return;const _0x16cac8=BattleManager['_spriteset'];if(!_0x16cac8)return;_0x16cac8[_0x44a136(0x1e5)](_0x52cd08);if(_0x74df57)_0x53b4ce[_0x44a136(0xab1)](_0x44a136(0x21f));}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],_0x1a8785(0x76d),_0x2390be=>{const _0x350375=_0x1a8785;if(!SceneManager[_0x350375(0x3a8)]())return;if(!Imported[_0x350375(0x9de)])return;VisuMZ[_0x350375(0x235)](_0x2390be,_0x2390be);const _0x3f28c2=$gameTemp['getLastPluginCommandInterpreter'](),_0x38e752=_0x2390be[_0x350375(0xa51)];if(!_0x3f28c2)return;$gameScreen[_0x350375(0x7d4)](_0x2390be[_0x350375(0x19a)],_0x2390be[_0x350375(0x756)],_0x2390be[_0x350375(0x918)],_0x2390be['EasingType']);if(_0x38e752)_0x3f28c2['setWaitMode']('battleSkew');}),PluginManager[_0x1a8785(0x37a)](pluginData['name'],_0x1a8785(0x335),_0x3ce59c=>{const _0x1e05d7=_0x1a8785;if(!SceneManager[_0x1e05d7(0x3a8)]())return;if(!Imported[_0x1e05d7(0x9de)])return;VisuMZ['ConvertParams'](_0x3ce59c,_0x3ce59c);const _0x397b85=$gameTemp[_0x1e05d7(0x55b)](),_0x49b90a=_0x3ce59c['WaitForSkew'];if(!_0x397b85)return;$gameScreen[_0x1e05d7(0x7d4)](0x0,0x0,_0x3ce59c[_0x1e05d7(0x918)],_0x3ce59c[_0x1e05d7(0x6c4)]);if(_0x49b90a)_0x397b85[_0x1e05d7(0xab1)](_0x1e05d7(0xaa0));}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],'ActSeq_Skew_WaitForSkew',_0x40322b=>{const _0x50068a=_0x1a8785;if(!SceneManager[_0x50068a(0x3a8)]())return;if(!Imported[_0x50068a(0x9de)])return;const _0x2f1ddf=$gameTemp['getLastPluginCommandInterpreter']();if(!_0x2f1ddf)return;_0x2f1ddf[_0x50068a(0xab1)](_0x50068a(0xaa0));}),PluginManager['registerCommand'](pluginData[_0x1a8785(0x1f2)],'ActSeq_Target_CurrentIndex',_0xe25089=>{const _0x61fbc=_0x1a8785;if(!SceneManager[_0x61fbc(0x3a8)]())return;VisuMZ[_0x61fbc(0x235)](_0xe25089,_0xe25089);const _0x3d3270=$gameTemp['getLastPluginCommandInterpreter'](),_0x3b776b=_0xe25089[_0x61fbc(0x9dd)],_0x4ae869=_0xe25089['JumpToLabel'];if(!_0x3d3270)return;BattleManager[_0x61fbc(0x721)]=_0x3b776b,BattleManager[_0x61fbc(0x733)]=BattleManager['_allTargets']?BattleManager['_allTargets'][BattleManager[_0x61fbc(0x721)]]||null:null,BattleManager[_0x61fbc(0x733)]&&_0x4ae869['toUpperCase']()[_0x61fbc(0x6b6)]()!==_0x61fbc(0x512)&&_0x3d3270[_0x61fbc(0x3f1)]([_0x4ae869]);}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x7eb),_0x4ec4d3=>{const _0xd352e6=_0x1a8785;if(!SceneManager[_0xd352e6(0x3a8)]())return;VisuMZ['ConvertParams'](_0x4ec4d3,_0x4ec4d3);const _0x2084c0=$gameTemp[_0xd352e6(0x55b)](),_0x29386b=_0x4ec4d3[_0xd352e6(0x742)];if(!_0x2084c0)return;BattleManager[_0xd352e6(0x721)]++,BattleManager['_target']=BattleManager[_0xd352e6(0x829)][BattleManager['_targetIndex']]||null,BattleManager[_0xd352e6(0x733)]&&_0x29386b[_0xd352e6(0x830)]()[_0xd352e6(0x6b6)]()!==_0xd352e6(0x512)&&_0x2084c0[_0xd352e6(0x3f1)]([_0x29386b]);}),PluginManager['registerCommand'](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x623),_0x4c1e24=>{const _0x7b9848=_0x1a8785;if(!SceneManager[_0x7b9848(0x3a8)]())return;VisuMZ[_0x7b9848(0x235)](_0x4c1e24,_0x4c1e24);const _0x1ef6e0=$gameTemp['getLastPluginCommandInterpreter'](),_0x3e2400=_0x4c1e24[_0x7b9848(0x742)];if(!_0x1ef6e0)return;BattleManager[_0x7b9848(0x721)]--,BattleManager[_0x7b9848(0x733)]=BattleManager[_0x7b9848(0x829)][BattleManager[_0x7b9848(0x721)]]||null,BattleManager[_0x7b9848(0x733)]&&_0x3e2400[_0x7b9848(0x830)]()[_0x7b9848(0x6b6)]()!==_0x7b9848(0x512)&&_0x1ef6e0[_0x7b9848(0x3f1)]([_0x3e2400]);}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],'ActSeq_Target_RandTarget',_0x29bef4=>{const _0x37690a=_0x1a8785;if(!SceneManager[_0x37690a(0x3a8)]())return;VisuMZ[_0x37690a(0x235)](_0x29bef4,_0x29bef4);const _0x5c850a=$gameTemp[_0x37690a(0x55b)](),_0x2affc1=_0x29bef4[_0x37690a(0x1cc)],_0x2eb728=_0x29bef4[_0x37690a(0x742)];if(!_0x5c850a)return;const _0x77cfd1=BattleManager[_0x37690a(0x721)];for(;;){BattleManager[_0x37690a(0x721)]=Math[_0x37690a(0x526)](BattleManager[_0x37690a(0x829)][_0x37690a(0x2dc)]);if(!_0x2affc1)break;if(BattleManager[_0x37690a(0x721)]!==_0x77cfd1)break;if(BattleManager[_0x37690a(0x829)][_0x37690a(0x2dc)]<=0x1){BattleManager[_0x37690a(0x721)]=0x0;break;}}BattleManager[_0x37690a(0x733)]=BattleManager[_0x37690a(0x829)][BattleManager[_0x37690a(0x721)]]||null,BattleManager[_0x37690a(0x733)]&&_0x2eb728[_0x37690a(0x830)]()['trim']()!=='UNTITLED'&&_0x5c850a[_0x37690a(0x3f1)]([_0x2eb728]);}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x814),_0x190ec1=>{const _0x1abedd=_0x1a8785;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x1abedd(0x235)](_0x190ec1,_0x190ec1);const _0x9c6a90=VisuMZ[_0x1abedd(0x65c)](_0x190ec1[_0x1abedd(0x7f7)]);for(const _0x508b6a of _0x9c6a90){if(!_0x508b6a)continue;if(!_0x508b6a[_0x1abedd(0x68d)]())continue;_0x508b6a[_0x1abedd(0x627)]();}}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x80b),_0x5a91c4=>{const _0x4f6821=_0x1a8785;if(!SceneManager[_0x4f6821(0x3a8)]())return;VisuMZ[_0x4f6821(0x235)](_0x5a91c4,_0x5a91c4);const _0x4f3b3c=$gameTemp[_0x4f6821(0x55b)]();let _0x38bf89=![];const _0x3d2a17=_0x5a91c4[_0x4f6821(0x742)],_0x26dec9=VisuMZ[_0x4f6821(0x65c)](_0x5a91c4[_0x4f6821(0x7f7)]);for(const _0x46d68a of _0x26dec9){if(!_0x46d68a)continue;if(!_0x46d68a[_0x4f6821(0x68d)]())continue;_0x46d68a[_0x4f6821(0xacd)](),_0x46d68a[_0x4f6821(0x577)]()[_0x4f6821(0x2dc)]>0x0?_0x38bf89=!![]:_0x46d68a[_0x4f6821(0x627)]();}_0x38bf89&&_0x3d2a17[_0x4f6821(0x830)]()[_0x4f6821(0x6b6)]()!==_0x4f6821(0x512)&&_0x4f3b3c[_0x4f6821(0x3f1)]([_0x3d2a17]);}),PluginManager['registerCommand'](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0x36c),_0x118498=>{const _0x488f81=_0x1a8785;if(!SceneManager[_0x488f81(0x3a8)]())return;VisuMZ[_0x488f81(0x235)](_0x118498,_0x118498);let _0x377dc4=_0x118498[_0x488f81(0x300)];_0x377dc4--,_0x377dc4=Math[_0x488f81(0x5a7)](_0x377dc4,0x0);const _0x3662c7=VisuMZ[_0x488f81(0x65c)](_0x118498['Targets']);for(const _0x446eba of _0x3662c7){if(!_0x446eba)continue;if(!_0x446eba[_0x488f81(0x68d)]())continue;_0x446eba[_0x488f81(0x331)](_0x377dc4);}}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],_0x1a8785(0xa4e),_0x1d23e6=>{const _0x29910d=_0x1a8785;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x29910d(0x9de)])return;VisuMZ[_0x29910d(0x235)](_0x1d23e6,_0x1d23e6);const _0x37896f=$gameTemp[_0x29910d(0x55b)](),_0x13cfe8=_0x1d23e6[_0x29910d(0x33d)];if(!_0x37896f)return;$gameScreen[_0x29910d(0x38d)](_0x1d23e6['Scale'],_0x1d23e6[_0x29910d(0x918)],_0x1d23e6[_0x29910d(0x6c4)]);if(_0x13cfe8)_0x37896f[_0x29910d(0xab1)](_0x29910d(0x921));}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],'ActSeq_Zoom_Reset',_0x1e23b8=>{const _0x4b4e45=_0x1a8785;if(!SceneManager[_0x4b4e45(0x3a8)]())return;if(!Imported['VisuMZ_3_ActSeqCamera'])return;VisuMZ[_0x4b4e45(0x235)](_0x1e23b8,_0x1e23b8);const _0x53d2ae=$gameTemp[_0x4b4e45(0x55b)](),_0x4efff0=_0x1e23b8['WaitForZoom'];if(!_0x53d2ae)return;$gameScreen[_0x4b4e45(0x38d)](0x1,_0x1e23b8['Duration'],_0x1e23b8[_0x4b4e45(0x6c4)]);if(_0x4efff0)_0x53d2ae[_0x4b4e45(0xab1)](_0x4b4e45(0x921));}),PluginManager[_0x1a8785(0x37a)](pluginData[_0x1a8785(0x1f2)],'ActSeq_Zoom_WaitForZoom',_0x42552b=>{const _0x4b75f7=_0x1a8785;if(!SceneManager[_0x4b75f7(0x3a8)]())return;if(!Imported[_0x4b75f7(0x9de)])return;const _0x21fd5e=$gameTemp['getLastPluginCommandInterpreter']();if(!_0x21fd5e)return;_0x21fd5e['setWaitMode'](_0x4b75f7(0x921));}),VisuMZ['BattleCore'][_0x1a8785(0x48b)]=Scene_Boot[_0x1a8785(0x978)][_0x1a8785(0x58a)],Scene_Boot[_0x1a8785(0x978)][_0x1a8785(0x58a)]=function(){const _0x470052=_0x1a8785;this[_0x470052(0x984)](),this['process_VisuMZ_BattleCore_PluginParams'](),this[_0x470052(0x562)](),this[_0x470052(0x1f8)](),VisuMZ[_0x470052(0x83c)][_0x470052(0x48b)][_0x470052(0x716)](this),this['process_VisuMZ_BattleCore_Notetags'](),this['process_VisuMZ_BattleCore_BaseTroops'](),this[_0x470052(0x9e6)](),this[_0x470052(0x968)]();},Scene_Boot[_0x1a8785(0x978)][_0x1a8785(0xa74)]=function(){const _0x11d7b9=_0x1a8785;if(VisuMZ[_0x11d7b9(0x4f3)])return;this[_0x11d7b9(0x4fc)](),this[_0x11d7b9(0xa77)](),this['process_VisuMZ_BattleCore_jsFunctions']();},Scene_Boot[_0x1a8785(0x978)]['process_VisuMZ_BattleCore_Failsafes']=function(){const _0x3272a7=_0x1a8785,_0x433c56=$dataSystem['weaponTypes']['length'];for(let _0x15aa09=0x0;_0x15aa09<_0x433c56;_0x15aa09++){const _0x2374f5=$dataSystem[_0x3272a7(0x45d)][_0x15aa09];if(_0x2374f5)continue;$dataSystem[_0x3272a7(0x45d)][_0x15aa09]={'type':0x1,'weaponImageId':0x1};}},Scene_Boot[_0x1a8785(0x978)][_0x1a8785(0xa67)]=function(){const _0x4898ca=_0x1a8785,_0x5c05c1=VisuMZ['BattleCore'][_0x4898ca(0x9a7)];_0x5c05c1['Damage'][_0x4898ca(0x8d2)]===undefined&&(_0x5c05c1[_0x4898ca(0xa19)][_0x4898ca(0x8d2)]=_0x4898ca(0xa14)),_0x5c05c1[_0x4898ca(0x1d0)][_0x4898ca(0x1e2)]===undefined&&(_0x5c05c1[_0x4898ca(0x1d0)][_0x4898ca(0x1e2)]=![]),_0x5c05c1['Enemy'][_0x4898ca(0x1e2)]===undefined&&(_0x5c05c1[_0x4898ca(0x199)][_0x4898ca(0x1e2)]=!![]),_0x5c05c1[_0x4898ca(0x1d0)][_0x4898ca(0x490)]===undefined&&(_0x5c05c1[_0x4898ca(0x1d0)][_0x4898ca(0x490)]=![]),_0x5c05c1[_0x4898ca(0x1d0)]['PrioritySortActors']===undefined&&(_0x5c05c1['Actor']['PrioritySortActors']=!![]);},VisuMZ[_0x1a8785(0x86e)]={},Scene_Boot[_0x1a8785(0x978)][_0x1a8785(0x562)]=function(){const _0xcd0bc2=_0x1a8785;for(const _0x4c3daf of VisuMZ[_0xcd0bc2(0x83c)][_0xcd0bc2(0x9a7)][_0xcd0bc2(0xa19)]['DamageStyleList']){if(!_0x4c3daf)continue;const _0x33118a=_0x4c3daf[_0xcd0bc2(0x39b)][_0xcd0bc2(0x830)]()[_0xcd0bc2(0x6b6)]();VisuMZ[_0xcd0bc2(0x86e)][_0x33118a]=_0x4c3daf;}},VisuMZ['BattleCore']['RegExp']={},Scene_Boot[_0x1a8785(0x978)]['process_VisuMZ_BattleCore_CreateRegExp']=function(){const _0x487648=_0x1a8785,_0x25c95d=VisuMZ[_0x487648(0x83c)][_0x487648(0x31d)],_0x396745='<%1>\x5cs*([\x5cs\x5cS]*)\x5cs*<\x5c/%1>',_0x2bf8db=[[_0x487648(0x920),_0x487648(0x26f)],[_0x487648(0x8eb),_0x487648(0x537)]],_0x576eec=[[_0x487648(0x986),_0x487648(0x51a)],[_0x487648(0x2e3),_0x487648(0x33c)]],_0x28b8e1=[['',''],[_0x487648(0x64c),'AS\x20USER'],['AsTarget','AS\x20TARGET']];for(const _0x9565f7 of _0x576eec){for(const _0x2d2b4c of _0x28b8e1){for(const _0x340cb2 of _0x2bf8db){const _0x3c01ba=_0x9565f7[0x0]['format'](_0x340cb2[0x0],_0x2d2b4c[0x0]),_0x2e4115=_0x9565f7[0x1][_0x487648(0x22f)](_0x340cb2[0x1],_0x2d2b4c[0x1])[_0x487648(0x6b6)](),_0x5ce884=new RegExp(_0x396745[_0x487648(0x22f)](_0x2e4115),'i');_0x25c95d[_0x3c01ba]=_0x5ce884;}}}const _0x2c541e=[[_0x487648(0xa5a),_0x487648(0x2e2)],[_0x487648(0x1d9),_0x487648(0x246)]];for(const _0x2d3288 of _0x2c541e){for(const _0x141782 of _0x2bf8db){const _0x141cb2=_0x2d3288[0x0][_0x487648(0x22f)](_0x141782[0x0]),_0x30432d=_0x2d3288[0x1][_0x487648(0x22f)](_0x141782[0x1]),_0x204d06=new RegExp(_0x396745[_0x487648(0x22f)](_0x30432d),'i');_0x25c95d[_0x141cb2]=_0x204d06;}}const _0x849cae=[[_0x487648(0x6b2),_0x487648(0x473)],[_0x487648(0x60a),_0x487648(0x362)],['BattleVictoryJS',_0x487648(0x5e7)],[_0x487648(0x671),_0x487648(0x6ab)],['EscapeSuccessJS','JS\x20ESCAPE\x20SUCCESS'],['EscapeFailureJS',_0x487648(0x595)],['%1StartTurnJS',_0x487648(0x682)],[_0x487648(0x397),_0x487648(0x7d7)],['%1RegenerateJS',_0x487648(0x6cc)]];for(const _0x1813bf of _0x849cae){for(const _0x442910 of _0x2bf8db){const _0x2d7255=_0x1813bf[0x0][_0x487648(0x22f)](_0x442910[0x0]),_0xe6c180=_0x1813bf[0x1][_0x487648(0x22f)](_0x442910[0x1]),_0x5c9e46=new RegExp(_0x396745[_0x487648(0x22f)](_0xe6c180),'i');_0x25c95d[_0x2d7255]=_0x5c9e46;}}},Scene_Boot[_0x1a8785(0x978)][_0x1a8785(0x4fc)]=function(){const _0x2360cc=_0x1a8785,_0x516b37=$dataSkills[_0x2360cc(0x755)]($dataItems);for(const _0x2211dd of _0x516b37){if(!_0x2211dd)continue;VisuMZ['BattleCore'][_0x2360cc(0x245)](_0x2211dd);}},Scene_Boot[_0x1a8785(0x978)][_0x1a8785(0xa77)]=function(){const _0x4d98b5=_0x1a8785,_0x429259=$dataActors[_0x4d98b5(0x755)]($dataClasses,$dataWeapons,$dataArmors,$dataEnemies,$dataStates);for(const _0x3dd75b of _0x429259){if(!_0x3dd75b)continue;VisuMZ[_0x4d98b5(0x83c)][_0x4d98b5(0x66a)](_0x3dd75b);}},Scene_Boot[_0x1a8785(0x978)][_0x1a8785(0x19f)]=function(){const _0x576d82=_0x1a8785,_0x53041e=VisuMZ[_0x576d82(0x83c)][_0x576d82(0x9a7)][_0x576d82(0x1af)][_0x576d82(0x31c)],_0x53f4b3=[];for(const _0x4328c8 of _0x53041e){const _0x158213=$dataTroops[_0x4328c8];if(_0x158213)_0x53f4b3[_0x576d82(0x963)](JsonEx[_0x576d82(0x950)](_0x158213));}for(const _0x305f41 of $dataTroops){if(!_0x305f41)continue;for(const _0x509a18 of _0x53f4b3){if(_0x509a18['id']===_0x305f41['id'])continue;_0x305f41[_0x576d82(0x1dc)]=_0x305f41[_0x576d82(0x1dc)][_0x576d82(0x755)](_0x509a18['pages']);}}},Scene_Boot['prototype'][_0x1a8785(0x9e6)]=function(){const _0x5342f8=_0x1a8785,_0x412b46=VisuMZ[_0x5342f8(0x83c)][_0x5342f8(0x9a7)][_0x5342f8(0x1af)];if(_0x412b46[_0x5342f8(0x1dd)]>0x0&&$dataCommonEvents[_0x412b46['BattleStartEvent']]){const _0x4cd64b=$dataCommonEvents[_0x412b46['BattleStartEvent']],_0x11ba83=_0x4cd64b['list'][_0x5342f8(0x2dc)]-0x2,_0x1b888d=_0x4cd64b[_0x5342f8(0x43b)][_0x11ba83];if(_0x1b888d&&_0x1b888d['code']!==0xe6){const _0x1fed92={'code':0xe6,'indent':0x0,'parameters':[0x1]},_0x16751a=_0x4cd64b[_0x5342f8(0x43b)]['pop']();_0x4cd64b['list'][_0x5342f8(0x5a1)](_0x1fed92),_0x4cd64b[_0x5342f8(0x43b)][_0x5342f8(0x5a1)](_0x16751a);}}},Scene_Boot[_0x1a8785(0x978)]['process_VisuMZ_BattleCore_CommonEventKeys']=function(){const _0x4fc7f7=_0x1a8785;VisuMZ[_0x4fc7f7(0x83c)]['CreateCommonEventKeys'](),VisuMZ[_0x4fc7f7(0x83c)][_0x4fc7f7(0x244)]($dataSkills),VisuMZ[_0x4fc7f7(0x83c)][_0x4fc7f7(0x244)]($dataItems);},VisuMZ['BattleCore'][_0x1a8785(0x75f)]=function(){const _0x4de7ab=_0x1a8785;VisuMZ['BattleCore']['_commonEventKey']={};for(const _0x5bfde8 of $dataCommonEvents){if(!_0x5bfde8)continue;if(_0x5bfde8[_0x4de7ab(0x1f2)]['match'](/\[(.*)\]/i)){let _0x4a003b=String(RegExp['$1'])[_0x4de7ab(0x555)](/,/g,'')[_0x4de7ab(0x830)]()[_0x4de7ab(0x6b6)]();VisuMZ['BattleCore'][_0x4de7ab(0x932)][_0x4a003b]=_0x5bfde8['id'];}}},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x244)]=function(_0x1fceba){const _0x489ab7=_0x1a8785;for(const _0x1cf31d of _0x1fceba){if(!_0x1cf31d)continue;VisuMZ['BattleCore'][_0x489ab7(0x2fd)](_0x1cf31d);}},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x2fd)]=function(_0x214d91){const _0x35e581=_0x1a8785;if(!_0x214d91)return;if(!_0x214d91['effects'])return;VisuMZ[_0x35e581(0x83c)][_0x35e581(0x932)]=VisuMZ[_0x35e581(0x83c)][_0x35e581(0x932)]||{};const _0x153cf1=/<COMMON EVENT (?:KEY|KEYS):[ ](.*)>/gi,_0x46c94c=/<COMMON EVENT (?:KEY|KEYS)>\s*([\s\S]*)\s*<\/COMMON EVENT (?:KEY|KEYS)>/i;let _0x13352a=[];const _0x383955=_0x214d91[_0x35e581(0x9c6)][_0x35e581(0x9e0)](_0x153cf1);if(_0x383955){for(const _0xc7ef15 of _0x383955){_0xc7ef15[_0x35e581(0x9e0)](_0x153cf1);const _0x320013=String(RegExp['$1'])[_0x35e581(0x2d7)](',')[_0x35e581(0x628)](_0x4f32f5=>String(_0x4f32f5)[_0x35e581(0x830)]()[_0x35e581(0x6b6)]());_0x13352a=_0x13352a['concat'](_0x320013);}!_0x214d91[_0x35e581(0x9c6)]['match'](/<CUSTOM ACTION SEQUENCE>/i)&&(_0x214d91[_0x35e581(0x9c6)]+=_0x35e581(0x2fc));;}if(_0x214d91['note']['match'](_0x46c94c)){const _0x3a8794=String(RegExp['$1'])[_0x35e581(0x2d7)](/[\r\n]+/)[_0x35e581(0x628)](_0x433896=>String(_0x433896)[_0x35e581(0x830)]()['trim']());_0x13352a=_0x13352a['concat'](_0x3a8794);!_0x214d91['note'][_0x35e581(0x9e0)](/<CUSTOM ACTION SEQUENCE>/i)&&(_0x214d91[_0x35e581(0x9c6)]+=_0x35e581(0x2fc));;}for(const _0x54481c of _0x13352a){if(VisuMZ[_0x35e581(0x83c)]['_commonEventKey'][_0x54481c]){const _0x2706a6=VisuMZ[_0x35e581(0x83c)][_0x35e581(0x932)][_0x54481c],_0x4fa146={'code':0x2c,'dataId':_0x2706a6,'value1':0x1,'value2':0x0};_0x214d91[_0x35e581(0x7ed)][_0x35e581(0x963)](_0x4fa146);}}},Scene_Boot[_0x1a8785(0x978)][_0x1a8785(0x4f9)]=function(){const _0x165601=_0x1a8785,_0x35945c=$dataSkills[_0x165601(0x755)]($dataItems);for(const _0x587ba9 of _0x35945c){if(!_0x587ba9)continue;VisuMZ[_0x165601(0x83c)][_0x165601(0x5ff)](_0x587ba9);}},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0xb02)]=VisuMZ[_0x1a8785(0xb02)],VisuMZ[_0x1a8785(0xb02)]=function(_0x3461a3){const _0x5c082d=_0x1a8785;VisuMZ[_0x5c082d(0x83c)]['ParseActorNotetags']&&VisuMZ['BattleCore']['ParseActorNotetags'][_0x5c082d(0x716)](this,_0x3461a3),VisuMZ['BattleCore'][_0x5c082d(0x66a)](_0x3461a3);},VisuMZ['BattleCore'][_0x1a8785(0x9db)]=VisuMZ[_0x1a8785(0x9db)],VisuMZ['ParseClassNotetags']=function(_0x53d920){const _0x28e39c=_0x1a8785;VisuMZ[_0x28e39c(0x83c)][_0x28e39c(0x9db)]&&VisuMZ[_0x28e39c(0x83c)]['ParseClassNotetags'][_0x28e39c(0x716)](this,_0x53d920),VisuMZ[_0x28e39c(0x83c)][_0x28e39c(0x66a)](_0x53d920);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x40e)]=VisuMZ['ParseSkillNotetags'],VisuMZ[_0x1a8785(0x40e)]=function(_0x271009){const _0x42e684=_0x1a8785;VisuMZ[_0x42e684(0x83c)][_0x42e684(0x40e)]&&VisuMZ[_0x42e684(0x83c)]['ParseSkillNotetags']['call'](this,_0x271009),VisuMZ[_0x42e684(0x83c)][_0x42e684(0x245)](_0x271009),VisuMZ[_0x42e684(0x83c)][_0x42e684(0x5ff)](_0x271009);},VisuMZ[_0x1a8785(0x83c)]['ParseItemNotetags']=VisuMZ[_0x1a8785(0x82f)],VisuMZ[_0x1a8785(0x82f)]=function(_0x77ce65){const _0x387476=_0x1a8785;VisuMZ[_0x387476(0x83c)]['ParseItemNotetags']&&VisuMZ[_0x387476(0x83c)]['ParseItemNotetags'][_0x387476(0x716)](this,_0x77ce65),VisuMZ['BattleCore'][_0x387476(0x245)](_0x77ce65),VisuMZ['BattleCore'][_0x387476(0x5ff)](_0x77ce65);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x45b)]=VisuMZ[_0x1a8785(0x45b)],VisuMZ[_0x1a8785(0x45b)]=function(_0x3dff5b){const _0x4916db=_0x1a8785;VisuMZ['BattleCore'][_0x4916db(0x45b)]&&VisuMZ['BattleCore'][_0x4916db(0x45b)][_0x4916db(0x716)](this,_0x3dff5b),VisuMZ[_0x4916db(0x83c)][_0x4916db(0x66a)](_0x3dff5b);},VisuMZ['BattleCore']['ParseArmorNotetags']=VisuMZ[_0x1a8785(0x96e)],VisuMZ['ParseArmorNotetags']=function(_0x20cc32){const _0x177105=_0x1a8785;VisuMZ[_0x177105(0x83c)][_0x177105(0x96e)]&&VisuMZ[_0x177105(0x83c)][_0x177105(0x96e)][_0x177105(0x716)](this,_0x20cc32),VisuMZ[_0x177105(0x83c)]['Parse_Notetags_TraitObjects'](_0x20cc32);},VisuMZ[_0x1a8785(0x83c)]['ParseEnemyNotetags']=VisuMZ[_0x1a8785(0xa6b)],VisuMZ[_0x1a8785(0xa6b)]=function(_0x1bd611){const _0x4191ae=_0x1a8785;VisuMZ[_0x4191ae(0x83c)][_0x4191ae(0xa6b)]&&VisuMZ['BattleCore']['ParseEnemyNotetags'][_0x4191ae(0x716)](this,_0x1bd611),VisuMZ['BattleCore'][_0x4191ae(0x66a)](_0x1bd611);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x607)]=VisuMZ[_0x1a8785(0x607)],VisuMZ['ParseStateNotetags']=function(_0x1f615c){const _0x5a3834=_0x1a8785;VisuMZ['BattleCore'][_0x5a3834(0x607)]&&VisuMZ['BattleCore'][_0x5a3834(0x607)]['call'](this,_0x1f615c),VisuMZ[_0x5a3834(0x83c)][_0x5a3834(0x66a)](_0x1f615c);},VisuMZ[_0x1a8785(0x83c)]['Parse_Notetags_Action']=function(_0x5e9fdb){const _0x2b6438=_0x1a8785,_0x247870=[_0x2b6438(0x63d),_0x2b6438(0x196),_0x2b6438(0x1f6),_0x2b6438(0x7cf),_0x2b6438(0x1b8),'PostStartActionJS',_0x2b6438(0x342),'PostEndActionJS'];for(const _0x78a7d0 of _0x247870){VisuMZ['BattleCore'][_0x2b6438(0x4fa)](_0x5e9fdb,_0x78a7d0);}const _0x3270de=_0x5e9fdb[_0x2b6438(0x9c6)];_0x3270de[_0x2b6438(0x9e0)](/<ALWAYS CRITICAL/i)&&(_0x5e9fdb[_0x2b6438(0x5c1)][_0x2b6438(0x9fe)]=!![]),_0x3270de[_0x2b6438(0x9e0)](/<(?:REPEAT|REPEATS|REPEAT HITS):[ ](\d+)/i)&&(_0x5e9fdb['repeats']=Math[_0x2b6438(0x5a7)](0x1,Number(RegExp['$1']))),_0x3270de[_0x2b6438(0x9e0)](/<TARGET:[ ](.*)>/i)&&(_0x5e9fdb[_0x2b6438(0x502)]=String(RegExp['$1'])['toUpperCase']()[_0x2b6438(0x6b6)]());},VisuMZ['BattleCore'][_0x1a8785(0x66a)]=function(_0x5f1d70){const _0x5a2312=_0x1a8785,_0x107eea=[_0x5a2312(0x64b),_0x5a2312(0x34b),_0x5a2312(0x9f0),_0x5a2312(0x36b),_0x5a2312(0x1d3),_0x5a2312(0x5d4),'PreDamageAsTargetJS',_0x5a2312(0xa82),_0x5a2312(0x1b8),_0x5a2312(0x683),_0x5a2312(0x342),_0x5a2312(0x2fe),'PreStartBattleJS',_0x5a2312(0x2d1),_0x5a2312(0x594),_0x5a2312(0x56a),'BattleVictoryJS',_0x5a2312(0x671),'EscapeSuccessJS',_0x5a2312(0x777),'PreStartTurnJS',_0x5a2312(0x826),_0x5a2312(0x207),_0x5a2312(0x776),_0x5a2312(0x73d),'PostRegenerateJS'];for(const _0x1c7052 of _0x107eea){VisuMZ['BattleCore'][_0x5a2312(0x4fa)](_0x5f1d70,_0x1c7052);}},VisuMZ['BattleCore'][_0x1a8785(0x5ff)]=function(_0x365309){const _0x4874f7=_0x1a8785,_0x13744e=_0x365309[_0x4874f7(0x9c6)];if(_0x13744e[_0x4874f7(0x9e0)](/<JS TARGETS>\s*([\s\S]*)\s*<\/JS TARGETS>/i)){const _0x3bf625=String(RegExp['$1']),_0xab74bc=VisuMZ['BattleCore'][_0x4874f7(0x30b)](_0x365309,_0x4874f7(0x7f7));VisuMZ[_0x4874f7(0x83c)][_0x4874f7(0x28c)](_0x3bf625,_0xab74bc);}if(_0x13744e['match'](/<JS COMMAND (?:VISIBLE|SHOW|HIDE)>\s*([\s\S]*)\s*<\/JS COMMAND (?:VISIBLE|SHOW|HIDE)>/i)){const _0x36a094=String(RegExp['$1']),_0x55582c=VisuMZ['BattleCore']['createKeyJS'](_0x365309,_0x4874f7(0x7a4));VisuMZ[_0x4874f7(0x83c)][_0x4874f7(0x36e)](_0x36a094,_0x55582c);}},VisuMZ[_0x1a8785(0x83c)]['JS']={},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x4fa)]=function(_0x24ca4d,_0x205021){const _0x3982a5=_0x1a8785,_0x5de141=_0x24ca4d[_0x3982a5(0x9c6)];if(_0x5de141[_0x3982a5(0x9e0)](VisuMZ['BattleCore'][_0x3982a5(0x31d)][_0x205021])){const _0x443870=RegExp['$1'],_0x1e47b3=_0x3982a5(0x967)[_0x3982a5(0x22f)](_0x443870),_0x3e2b42=VisuMZ[_0x3982a5(0x83c)][_0x3982a5(0x30b)](_0x24ca4d,_0x205021);VisuMZ[_0x3982a5(0x83c)]['JS'][_0x3e2b42]=new Function(_0x1e47b3);}},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x30b)]=function(_0x4d374b,_0x4bf453){const _0x2b58f4=_0x1a8785;if(VisuMZ[_0x2b58f4(0x30b)])return VisuMZ['createKeyJS'](_0x4d374b,_0x4bf453);let _0x376d02='';if($dataActors[_0x2b58f4(0xa3e)](_0x4d374b))_0x376d02=_0x2b58f4(0x2f9)[_0x2b58f4(0x22f)](_0x4d374b['id'],_0x4bf453);if($dataClasses[_0x2b58f4(0xa3e)](_0x4d374b))_0x376d02=_0x2b58f4(0x620)[_0x2b58f4(0x22f)](_0x4d374b['id'],_0x4bf453);if($dataSkills[_0x2b58f4(0xa3e)](_0x4d374b))_0x376d02=_0x2b58f4(0xa5c)[_0x2b58f4(0x22f)](_0x4d374b['id'],_0x4bf453);if($dataItems[_0x2b58f4(0xa3e)](_0x4d374b))_0x376d02='Item-%1-%2'[_0x2b58f4(0x22f)](_0x4d374b['id'],_0x4bf453);if($dataWeapons['includes'](_0x4d374b))_0x376d02=_0x2b58f4(0x801)[_0x2b58f4(0x22f)](_0x4d374b['id'],_0x4bf453);if($dataArmors['includes'](_0x4d374b))_0x376d02=_0x2b58f4(0x505)[_0x2b58f4(0x22f)](_0x4d374b['id'],_0x4bf453);if($dataEnemies[_0x2b58f4(0xa3e)](_0x4d374b))_0x376d02=_0x2b58f4(0x5d8)[_0x2b58f4(0x22f)](_0x4d374b['id'],_0x4bf453);if($dataStates[_0x2b58f4(0xa3e)](_0x4d374b))_0x376d02=_0x2b58f4(0x21d)[_0x2b58f4(0x22f)](_0x4d374b['id'],_0x4bf453);return _0x376d02;},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x28c)]=function(_0x5167c1,_0x56f532){const _0x179bda=_0x1a8785,_0x1ac078=_0x179bda(0x3df)[_0x179bda(0x22f)](_0x5167c1);VisuMZ[_0x179bda(0x83c)]['JS'][_0x56f532]=new Function(_0x1ac078);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x36e)]=function(_0xdc2265,_0x40aa58){const _0x2c8988=_0x1a8785,_0xc7745d=_0x2c8988(0x802)[_0x2c8988(0x22f)](_0xdc2265);VisuMZ['BattleCore']['JS'][_0x40aa58]=new Function(_0xc7745d);},TextManager[_0x1a8785(0x476)]=VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x9a7)]['PartyCmd'][_0x1a8785(0xa6e)],TextManager[_0x1a8785(0x650)]=VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x9a7)][_0x1a8785(0x224)][_0x1a8785(0x3da)],TextManager['autoBattleStyle']=VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x9a7)][_0x1a8785(0x224)][_0x1a8785(0x8d8)],TextManager[_0x1a8785(0xa96)]=VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x9a7)][_0x1a8785(0x9d0)]['Name'],ColorManager[_0x1a8785(0x31e)]=function(_0x475b02){const _0x4e7324=_0x1a8785;return _0x475b02=String(_0x475b02),_0x475b02['match'](/#(.*)/i)?_0x4e7324(0x396)[_0x4e7324(0x22f)](String(RegExp['$1'])):this[_0x4e7324(0xaff)](Number(_0x475b02));},DataManager[_0x1a8785(0x89d)]=function(_0x235054){const _0x37eac0=_0x1a8785;if(_0x235054['note'][_0x37eac0(0x9e0)](/<DAMAGE STYLE:[ ](.*)>/i)){const _0x350877=String(RegExp['$1'])[_0x37eac0(0x830)]()[_0x37eac0(0x6b6)]();if(_0x350877===_0x37eac0(0x2e7))return _0x37eac0(0x2e7);if(VisuMZ[_0x37eac0(0x86e)][_0x350877])return _0x350877;}const _0x431bd9=VisuMZ[_0x37eac0(0x83c)][_0x37eac0(0x9a7)][_0x37eac0(0xa19)][_0x37eac0(0x665)][_0x37eac0(0x830)]()[_0x37eac0(0x6b6)]();if(VisuMZ[_0x37eac0(0x86e)][_0x431bd9])return _0x431bd9;return _0x37eac0(0x2e7);},DataManager[_0x1a8785(0x927)]=function(_0x36b49f){const _0x344db2=_0x1a8785;_0x36b49f=_0x36b49f[_0x344db2(0x830)]()[_0x344db2(0x6b6)](),this[_0x344db2(0x4c4)]=this['_stypeIDs']||{};if(this[_0x344db2(0x4c4)][_0x36b49f])return this[_0x344db2(0x4c4)][_0x36b49f];for(let _0x1dcbd6=0x1;_0x1dcbd6<0x64;_0x1dcbd6++){if(!$dataSystem[_0x344db2(0xa98)][_0x1dcbd6])continue;let _0x30e4fe=$dataSystem[_0x344db2(0xa98)][_0x1dcbd6][_0x344db2(0x830)]()['trim']();_0x30e4fe=_0x30e4fe['replace'](/\x1I\[(\d+)\]/gi,''),_0x30e4fe=_0x30e4fe[_0x344db2(0x555)](/\\I\[(\d+)\]/gi,''),this['_stypeIDs'][_0x30e4fe]=_0x1dcbd6;}return this['_stypeIDs'][_0x36b49f]||0x0;},DataManager[_0x1a8785(0x53d)]=function(_0x1a1bad){const _0x1806bd=_0x1a8785;_0x1a1bad=_0x1a1bad['toUpperCase']()['trim'](),this['_skillIDs']=this['_skillIDs']||{};if(this['_skillIDs'][_0x1a1bad])return this['_skillIDs'][_0x1a1bad];for(const _0x35e83d of $dataSkills){if(!_0x35e83d)continue;this[_0x1806bd(0x92c)][_0x35e83d[_0x1806bd(0x1f2)][_0x1806bd(0x830)]()[_0x1806bd(0x6b6)]()]=_0x35e83d['id'];}return this['_skillIDs'][_0x1a1bad]||0x0;},DataManager[_0x1a8785(0x65f)]=function(_0x25130f){const _0x283fc4=_0x1a8785;_0x25130f=_0x25130f[_0x283fc4(0x830)]()[_0x283fc4(0x6b6)](),this[_0x283fc4(0x28f)]=this['_enemyIDs']||{};if(this['_enemyIDs'][_0x25130f])return this[_0x283fc4(0x28f)][_0x25130f];for(const _0x1add2e of $dataEnemies){if(!_0x1add2e)continue;this[_0x283fc4(0x28f)][_0x1add2e[_0x283fc4(0x1f2)]['toUpperCase']()[_0x283fc4(0x6b6)]()]=_0x1add2e['id'];}return this[_0x283fc4(0x28f)][_0x25130f]||0x0;},DataManager[_0x1a8785(0x952)]=function(_0x12995e){const _0x5da637=_0x1a8785;_0x12995e=_0x12995e['toUpperCase']()[_0x5da637(0x6b6)](),this[_0x5da637(0x343)]=this[_0x5da637(0x343)]||{};if(this[_0x5da637(0x343)][_0x12995e])return this[_0x5da637(0x343)][_0x12995e];for(let _0x1d2974=0x1;_0x1d2974<0x64;_0x1d2974++){if(!$dataSystem[_0x5da637(0x35f)][_0x1d2974])continue;let _0x4ef8b0=$dataSystem[_0x5da637(0x35f)][_0x1d2974][_0x5da637(0x830)]()[_0x5da637(0x6b6)]();_0x4ef8b0=_0x4ef8b0[_0x5da637(0x555)](/\x1I\[(\d+)\]/gi,''),_0x4ef8b0=_0x4ef8b0[_0x5da637(0x555)](/\\I\[(\d+)\]/gi,''),this[_0x5da637(0x343)][_0x4ef8b0]=_0x1d2974;}return this['_wtypeIDs'][_0x5da637(0xaa8)]=0x0,this[_0x5da637(0x343)][_0x12995e]||0x0;},DataManager[_0x1a8785(0x4bb)]=function(_0x2692e3){const _0x13c6b1=_0x1a8785,_0x11693c=_0x13c6b1(0xa01);let _0x386cad=_0x2692e3[_0x13c6b1(0x442)],_0x4ece4b=_0x2692e3[_0x13c6b1(0x1f2)];const _0x56b99e=_0x2692e3['note'];return _0x56b99e['match'](/<DISPLAY ICON: (\d+)>/i)&&(_0x386cad=Number(RegExp['$1'])),_0x56b99e[_0x13c6b1(0x9e0)](/<DISPLAY TEXT: (.*)>/i)&&(_0x4ece4b=String(RegExp['$1'])),_0x11693c[_0x13c6b1(0x22f)](_0x386cad,_0x4ece4b);},DataManager[_0x1a8785(0x2a5)]=function(_0xbc7da1){const _0x30ec57=_0x1a8785;return _0xbc7da1[_0x30ec57(0x9c6)][_0x30ec57(0x9e0)](/<COMMAND TEXT: (.*)>/i)?String(RegExp['$1']):_0xbc7da1[_0x30ec57(0x1f2)];},DataManager['battleCommandIcon']=function(_0x52ed68){const _0x431708=_0x1a8785;return _0x52ed68[_0x431708(0x9c6)][_0x431708(0x9e0)](/<COMMAND ICON: (\d+)>/i)?Number(RegExp['$1']):_0x52ed68[_0x431708(0x442)];},DataManager[_0x1a8785(0x452)]=function(_0x47914b){const _0x1739e6=_0x1a8785,_0x527c2f=$dataEnemies[_0x47914b];if(_0x527c2f){if(_0x527c2f[_0x1739e6(0x9c6)][_0x1739e6(0x9e0)](/<SWAP ENEMIES>\s*([\s\S]*)\s*<\/SWAP ENEMIES>/i)){const _0x27da5c=String(RegExp['$1'])[_0x1739e6(0x2d7)](/[\r\n]+/)[_0x1739e6(0xa3b)](''),_0x5b34c3=this['processRandomizedData'](_0x27da5c);_0x47914b=this[_0x1739e6(0x65f)](_0x5b34c3)||_0x47914b,_0x47914b=DataManager['swapEnemyIDs'](_0x47914b);}}return _0x47914b;},DataManager[_0x1a8785(0x6e1)]=function(_0x4294e5){const _0x15c2ef=_0x1a8785;let _0x2cbd3d=0x0;const _0x51c490={};for(const _0x52718e of _0x4294e5){if(_0x52718e[_0x15c2ef(0x9e0)](/(.*):[ ](\d+)/i)){const _0x5d4e5f=String(RegExp['$1'])[_0x15c2ef(0x6b6)](),_0x49d736=Number(RegExp['$2']);_0x51c490[_0x5d4e5f]=_0x49d736,_0x2cbd3d+=_0x49d736;}else{if(_0x52718e['match'](/(.*):[ ](\d+\.?\d+)/i)){const _0x2e59db=String(RegExp['$1'])['trim'](),_0x124c01=Number(RegExp['$2']);_0x51c490[_0x2e59db]=_0x124c01,_0x2cbd3d+=_0x124c01;}else _0x52718e!==''&&(_0x51c490[_0x52718e]=0x1,_0x2cbd3d++);}}if(_0x2cbd3d<=0x0)return'';let _0x27e818=Math[_0x15c2ef(0x876)]()*_0x2cbd3d;for(const _0x5b0a55 in _0x51c490){_0x27e818-=_0x51c490[_0x5b0a55];if(_0x27e818<=0x0)return _0x5b0a55;}return'';},DataManager[_0x1a8785(0x35a)]=function(_0x5a15e0){const _0x4126ce=_0x1a8785;if(!_0x5a15e0)return![];if(!VisuMZ[_0x4126ce(0x83c)][_0x4126ce(0x9a7)][_0x4126ce(0x6fa)][_0x4126ce(0x67f)])return![];if(_0x5a15e0[_0x4126ce(0x9c6)][_0x4126ce(0x9e0)](/<AUTO ACTION SEQUENCE>/i))return![];if(_0x5a15e0[_0x4126ce(0x9c6)][_0x4126ce(0x9e0)](/<COMMON (?:EVENT|EVENTS):[ ](.*)>/gi))return!![];for(const _0x4b2f47 of _0x5a15e0[_0x4126ce(0x7ed)]){if(!_0x4b2f47)continue;if(_0x4b2f47[_0x4126ce(0xa2f)]===Game_Action[_0x4126ce(0x8c8)])return!![];}return![];},DataManager[_0x1a8785(0x6e9)]=function(_0x14454e){const _0x26beac=_0x1a8785,_0x376fe0=$dataTroops[_0x14454e];if(!_0x376fe0)return'';let _0x40667a='';_0x40667a+=_0x376fe0[_0x26beac(0x1f2)];for(const _0x425162 of _0x376fe0[_0x26beac(0x1dc)]){for(const _0x315b89 of _0x425162[_0x26beac(0x43b)]){[0x6c,0x198][_0x26beac(0xa3e)](_0x315b89[_0x26beac(0xa2f)])&&(_0x40667a+='\x0a',_0x40667a+=_0x315b89[_0x26beac(0x536)][0x0]);}}return _0x40667a;},ConfigManager['autoBattleAtStart']=ConfigManager['autoBattleAtStart']??![],ConfigManager[_0x1a8785(0x832)]=ConfigManager[_0x1a8785(0x832)]??![],ConfigManager[_0x1a8785(0xa96)]=ConfigManager['visualHpGauge']??!![],VisuMZ[_0x1a8785(0x83c)]['ConfigManager_makeData']=ConfigManager[_0x1a8785(0x939)],ConfigManager[_0x1a8785(0x939)]=function(){const _0x150175=_0x1a8785,_0x39b981=VisuMZ[_0x150175(0x83c)][_0x150175(0x97c)]['call'](this);return _0x39b981[_0x150175(0x7c2)]=this[_0x150175(0x7c2)],_0x39b981[_0x150175(0x832)]=this['autoBattleUseSkills'],_0x39b981[_0x150175(0xa96)]=this[_0x150175(0xa96)],_0x39b981;},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x428)]=ConfigManager['applyData'],ConfigManager['applyData']=function(_0x977a47){const _0x440897=_0x1a8785;VisuMZ['BattleCore'][_0x440897(0x428)][_0x440897(0x716)](this,_0x977a47),_0x440897(0x7c2)in _0x977a47?this['autoBattleAtStart']=_0x977a47['autoBattleAtStart']:this[_0x440897(0x7c2)]=![],_0x440897(0x832)in _0x977a47?this[_0x440897(0x832)]=_0x977a47[_0x440897(0x832)]:this[_0x440897(0x832)]=![],_0x440897(0xa96)in _0x977a47?this['visualHpGauge']=_0x977a47[_0x440897(0xa96)]:this[_0x440897(0xa96)]=!![];},ImageManager[_0x1a8785(0x346)]=ImageManager[_0x1a8785(0x346)]||0x9,ImageManager['svActorVertCells']=ImageManager[_0x1a8785(0x392)]||0x6,VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x2c7)]=BattleManager['setup'],BattleManager[_0x1a8785(0x352)]=function(_0x2e2eb0,_0x4a7796,_0x3aedb9){const _0x103f69=_0x1a8785;VisuMZ[_0x103f69(0x83c)][_0x103f69(0x2c7)]['call'](this,_0x2e2eb0,_0x4a7796,_0x3aedb9),this[_0x103f69(0x1fe)]={};},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x902)]=BattleManager[_0x1a8785(0x9a3)],BattleManager['initMembers']=function(){const _0x48b321=_0x1a8785;VisuMZ[_0x48b321(0x83c)][_0x48b321(0x902)]['call'](this),this[_0x48b321(0x73a)]=[];},BattleManager['refreshStatusWindow']=function(){const _0x10646a=_0x1a8785;if(!SceneManager['isSceneBattle']())return;const _0x497f88=SceneManager[_0x10646a(0xa42)][_0x10646a(0x2ac)];if(_0x497f88)_0x497f88[_0x10646a(0x7c4)]();},BattleManager[_0x1a8785(0x513)]=function(){const _0x3ad0e3=_0x1a8785;if(BattleManager['isTpb']())return'TPB';return _0x3ad0e3(0x88e);},BattleManager[_0x1a8785(0x390)]=function(_0x62bae4){const _0xac31e=_0x1a8785;return _0x62bae4=_0x62bae4[_0xac31e(0x830)]()[_0xac31e(0x6b6)](),this[_0xac31e(0x513)]()===_0x62bae4;},BattleManager[_0x1a8785(0x8ef)]=function(){return this['isBattleSys']('DTB');},BattleManager['isTurnBased']=function(){const _0x6904be=_0x1a8785;return this[_0x6904be(0x8ef)]();},BattleManager[_0x1a8785(0x748)]=function(){const _0x5a8784=_0x1a8785;return!this[_0x5a8784(0xac7)]();},BattleManager[_0x1a8785(0xaf1)]=function(){const _0x276cc6=_0x1a8785;return!this[_0x276cc6(0xac7)]()&&!this[_0x276cc6(0x748)]();},BattleManager[_0x1a8785(0x86f)]=function(_0x46dc42){const _0x2dc7ae=_0x1a8785;this[_0x2dc7ae(0x1fe)]=this[_0x2dc7ae(0x1fe)]||{};if(this[_0x2dc7ae(0x1fe)][_0x46dc42]!==undefined)return this[_0x2dc7ae(0x1fe)][_0x46dc42];this[_0x2dc7ae(0x1fe)][_0x46dc42]=null;const _0x1dc6e9=this['allBattleMembers'](),_0x171530=_0x1dc6e9[_0x2dc7ae(0x75b)](_0x5d1462=>_0x5d1462[_0x2dc7ae(0x707)]()===_0x46dc42);if(_0x171530)this[_0x2dc7ae(0x1fe)][_0x46dc42]=_0x171530;return this[_0x2dc7ae(0x1fe)][_0x46dc42];},Game_BattlerBase[_0x1a8785(0x978)][_0x1a8785(0x707)]=function(){const _0x436088=_0x1a8785;return _0x436088(0x769)[_0x436088(0x22f)](this[_0x436088(0x68d)]()?_0x436088(0x7fd):'enemy',this[_0x436088(0x1f2)]());},Game_Action['prototype'][_0x1a8785(0x5db)]=function(_0x3d00e7){const _0x239faa=_0x1a8785;if(this[_0x239faa(0x9ef)]!=='')return;typeof _0x3d00e7===_0x239faa(0x546)?this[_0x239faa(0x9ef)]=_0x3d00e7[_0x239faa(0x5dd)]()[_0x239faa(0x6b6)]():this[_0x239faa(0x9ef)]=_0x3d00e7[_0x239faa(0x707)]();},Game_Action[_0x1a8785(0x978)][_0x1a8785(0x8af)]=function(){const _0x328e77=_0x1a8785;return[this[_0x328e77(0x534)]()];},Game_Action[_0x1a8785(0x978)]['getSpecificBattlerKeyTarget']=function(){const _0x38a7ae=_0x1a8785,_0x494406=this[_0x38a7ae(0x9ef)]||'',_0x5f53b4=BattleManager['getBattlerFromKey'](_0x494406);if(!_0x5f53b4)return this[_0x38a7ae(0x753)]();if(!_0x5f53b4[_0x38a7ae(0x919)]())this[_0x38a7ae(0x753)]();return _0x5f53b4;},Game_Action['prototype'][_0x1a8785(0x753)]=function(){const _0x38f9ec=_0x1a8785,_0x2731ab=this[_0x38f9ec(0x9ef)];return _0x2731ab['match'](/ACTOR/i)?this[_0x38f9ec(0xb04)]()['trueRandomTarget']():this[_0x38f9ec(0xab4)]()[_0x38f9ec(0x96a)]();},BattleManager[_0x1a8785(0x656)]=function(){const _0x3e536c=_0x1a8785;return this[_0x3e536c(0x54d)]()[_0x3e536c(0x70f)](_0x2cc9d5=>_0x2cc9d5[_0x3e536c(0x5f2)]());},BattleManager[_0x1a8785(0x3bc)]=function(_0x1689b1){const _0x5a1a36=_0x1a8785;_0x1689b1===_0x5a1a36(0x743)&&(this[_0x5a1a36(0xaf9)]=!![]),$gameParty[_0x5a1a36(0x3bc)](_0x1689b1),$gameTroop[_0x5a1a36(0x3bc)](_0x1689b1);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x5a8)]=BattleManager[_0x1a8785(0x926)],BattleManager[_0x1a8785(0x926)]=function(){const _0x4a8591=_0x1a8785;this[_0x4a8591(0x1c6)]=![],this[_0x4a8591(0x6c9)]=ConfigManager[_0x4a8591(0x7c2)],this[_0x4a8591(0xaf9)]=![],this['processBattleCoreJS']('PreStartBattleJS'),VisuMZ[_0x4a8591(0x83c)]['BattleManager_startBattle'][_0x4a8591(0x716)](this),this[_0x4a8591(0x3bc)](_0x4a8591(0x2d1));},BattleManager[_0x1a8785(0x24e)]=function(_0x23e7ed){const _0xfe67b3=_0x1a8785,_0x5afe2a=VisuMZ[_0xfe67b3(0x83c)]['Settings'][_0xfe67b3(0x1af)];_0x23e7ed!==_0xfe67b3(0x77d)&&_0x5afe2a['BattleEndEvent']&&VisuMZ[_0xfe67b3(0x83c)][_0xfe67b3(0xa8c)](_0x5afe2a['BattleEndEvent'])&&$gameTemp[_0xfe67b3(0x93f)](_0x5afe2a[_0xfe67b3(0x701)]);const _0x1154c7='%1Event'['format'](_0x23e7ed);_0x5afe2a[_0x1154c7]&&VisuMZ['BattleCore'][_0xfe67b3(0xa8c)](_0x5afe2a[_0x1154c7])&&$gameTemp[_0xfe67b3(0x93f)](_0x5afe2a[_0x1154c7]);},VisuMZ['BattleCore'][_0x1a8785(0x746)]=BattleManager[_0x1a8785(0xa6d)],BattleManager[_0x1a8785(0xa6d)]=function(){const _0x4785b5=_0x1a8785;if(this[_0x4785b5(0x426)]===_0x4785b5(0x684)){if($gameTemp[_0x4785b5(0x8df)]())return![];}return VisuMZ[_0x4785b5(0x83c)]['BattleManager_checkBattleEnd'][_0x4785b5(0x716)](this);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x5c8)]=BattleManager['processVictory'],BattleManager[_0x1a8785(0x651)]=function(){const _0x46bd13=_0x1a8785;this[_0x46bd13(0xaf9)]=!![],this['processBattleCoreJS'](_0x46bd13(0x743)),VisuMZ['BattleCore']['BattleManager_processVictory']['call'](this),this['processPostBattleCommonEvents'](_0x46bd13(0x3e8));},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0xa4f)]=BattleManager[_0x1a8785(0x9bb)],BattleManager[_0x1a8785(0x9bb)]=function(){const _0x5d6702=_0x1a8785;this[_0x5d6702(0xaf9)]=!![],VisuMZ[_0x5d6702(0x83c)][_0x5d6702(0xa4f)]['call'](this);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x8a5)]=BattleManager[_0x1a8785(0x413)],BattleManager['processDefeat']=function(){const _0xb01cb2=_0x1a8785;this[_0xb01cb2(0xaf9)]=!![],this[_0xb01cb2(0x3bc)](_0xb01cb2(0x671)),VisuMZ[_0xb01cb2(0x83c)]['BattleManager_processDefeat'][_0xb01cb2(0x716)](this),this['processPostBattleCommonEvents'](_0xb01cb2(0x79e));},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x37c)]=BattleManager[_0x1a8785(0x6bb)],BattleManager[_0x1a8785(0x6bb)]=function(_0x51ed87){const _0x4f8aea=_0x1a8785;this[_0x4f8aea(0x1c6)]=!![],this[_0x4f8aea(0x6c9)]=![],this[_0x4f8aea(0x3bc)](_0x4f8aea(0x594)),VisuMZ[_0x4f8aea(0x83c)][_0x4f8aea(0x37c)][_0x4f8aea(0x716)](this,_0x51ed87),this[_0x4f8aea(0x3bc)](_0x4f8aea(0x56a));},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x640)]=BattleManager[_0x1a8785(0x868)],BattleManager[_0x1a8785(0x868)]=function(){const _0x505b6f=_0x1a8785;if(this[_0x505b6f(0xac7)]())this[_0x505b6f(0x3bc)]('PreStartTurnJS');VisuMZ[_0x505b6f(0x83c)][_0x505b6f(0x640)][_0x505b6f(0x716)](this);if(this[_0x505b6f(0xac7)]())this[_0x505b6f(0x3bc)](_0x505b6f(0x826));},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x897)]=BattleManager[_0x1a8785(0x59e)],BattleManager[_0x1a8785(0x59e)]=function(){const _0xab5d41=_0x1a8785,_0x5a3b3f=this[_0xab5d41(0x938)]['currentAction'](),_0x2b68ea=this['_subject'];_0x5a3b3f&&_0x5a3b3f[_0xab5d41(0x9ba)]()===_0x2b68ea&&_0x5a3b3f[_0xab5d41(0x279)](_0xab5d41(0x1b8)),VisuMZ[_0xab5d41(0x83c)][_0xab5d41(0x897)][_0xab5d41(0x716)](this),_0x5a3b3f&&_0x5a3b3f['subject']()===_0x2b68ea&&_0x5a3b3f['actionBattleCoreJS'](_0xab5d41(0x683));},VisuMZ[_0x1a8785(0x83c)]['BattleManager_endAction']=BattleManager[_0x1a8785(0x9a1)],BattleManager[_0x1a8785(0x9a1)]=function(){const _0x150ab9=_0x1a8785,_0x461662=this['_action'],_0x3f2832=this[_0x150ab9(0x938)];_0x461662&&_0x461662!==this[_0x150ab9(0xac5)]&&_0x461662['subject']()===_0x3f2832&&_0x461662['actionBattleCoreJS'](_0x150ab9(0x342)),this[_0x150ab9(0x938)]?VisuMZ[_0x150ab9(0x83c)]['BattleManager_endAction']['call'](this):this['_phase']=_0x150ab9(0x684),_0x461662&&_0x461662!==this[_0x150ab9(0xac5)]&&_0x461662['subject']()===_0x3f2832&&_0x461662[_0x150ab9(0x279)](_0x150ab9(0x2fe)),this[_0x150ab9(0x3b7)](this[_0x150ab9(0x54d)]()),this[_0x150ab9(0xac5)]=this[_0x150ab9(0x440)];},BattleManager[_0x1a8785(0x3b7)]=function(_0x42b8a5){const _0x54e8a9=_0x1a8785;for(const _0x3d91d3 of _0x42b8a5){if(!_0x3d91d3)continue;if(!_0x3d91d3['battler']())continue;_0x3d91d3[_0x54e8a9(0x89e)]()[_0x54e8a9(0x5ca)]();}},BattleManager[_0x1a8785(0x6a5)]=function(){const _0x308292=_0x1a8785;!this['_logWindow'][_0x308292(0x5ce)]()&&this[_0x308292(0x9a1)]();},Game_Battler['prototype'][_0x1a8785(0x6cf)]=function(){const _0x3030b8=_0x1a8785;this['clearResult']();if(Imported['VisuMZ_1_SkillsStatesCore']){const _0x2e2be1=VisuMZ['SkillsStatesCore'][_0x3030b8(0x9a7)][_0x3030b8(0x6d6)];_0x2e2be1&&_0x2e2be1[_0x3030b8(0x91e)]===![]&&this[_0x3030b8(0xa3d)](0x1);}else this[_0x3030b8(0xa3d)](0x1);this[_0x3030b8(0x518)]();},BattleManager[_0x1a8785(0x9a8)]=function(){const _0x1d2762=_0x1a8785;this[_0x1d2762(0x44f)]=VisuMZ['BattleCore'][_0x1d2762(0x9a7)]['Mechanics'][_0x1d2762(0x9f4)][_0x1d2762(0x716)](this);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x1b3)]=BattleManager[_0x1a8785(0x48e)],BattleManager['onEscapeSuccess']=function(){const _0x55c6a2=_0x1a8785;this[_0x55c6a2(0x3bc)]('EscapeSuccessJS'),BattleManager[_0x55c6a2(0x589)][_0x55c6a2(0x8dc)](),VisuMZ['BattleCore'][_0x55c6a2(0x1b3)][_0x55c6a2(0x716)](this),this['processPostBattleCommonEvents'](_0x55c6a2(0x350));},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x95f)]=BattleManager[_0x1a8785(0x7e8)],BattleManager[_0x1a8785(0x7e8)]=function(){const _0x31a2dd=_0x1a8785;this['processBattleCoreJS']('EscapeFailureJS');const _0x4b6800=this[_0x31a2dd(0x44f)];VisuMZ[_0x31a2dd(0x83c)]['BattleManager_onEscapeFailure'][_0x31a2dd(0x716)](this),this[_0x31a2dd(0x44f)]=_0x4b6800+VisuMZ[_0x31a2dd(0x83c)][_0x31a2dd(0x9a7)][_0x31a2dd(0x1af)][_0x31a2dd(0xaa6)][_0x31a2dd(0x716)](this),this[_0x31a2dd(0x24e)]('EscapeFail');},BattleManager[_0x1a8785(0x57a)]=function(){const _0x56b31d=_0x1a8785;let _0x5a2ff1=![];if(this[_0x56b31d(0x1e4)]())for(const _0x587853 of $gameTroop[_0x56b31d(0x969)]()){this['_logWindow'][_0x56b31d(0x963)](_0x56b31d(0x9a4),TextManager[_0x56b31d(0x54b)]['format'](_0x587853)),this['_logWindow'][_0x56b31d(0x963)](_0x56b31d(0x7c9)),_0x5a2ff1=!![];}if(this[_0x56b31d(0x2f1)])this[_0x56b31d(0x2f3)][_0x56b31d(0x963)](_0x56b31d(0x9a4),TextManager[_0x56b31d(0x3f8)][_0x56b31d(0x22f)]($gameParty[_0x56b31d(0x1f2)]())),this['_logWindow'][_0x56b31d(0x963)](_0x56b31d(0x7c9));else this['_surprise']&&(this[_0x56b31d(0x2f3)][_0x56b31d(0x963)](_0x56b31d(0x9a4),TextManager[_0x56b31d(0x992)][_0x56b31d(0x22f)]($gameParty[_0x56b31d(0x1f2)]())),this[_0x56b31d(0x2f3)]['push'](_0x56b31d(0x7c9)));_0x5a2ff1&&(this[_0x56b31d(0x2f3)][_0x56b31d(0x963)](_0x56b31d(0x7c9)),this['_logWindow'][_0x56b31d(0x963)]('clear')),this[_0x56b31d(0x875)]()&&this['isSkipPartyCommandWindow']()&&(this[_0x56b31d(0xa4a)]=![]);},BattleManager[_0x1a8785(0x1e4)]=function(){const _0x2f5cf4=_0x1a8785;if(BattleManager[_0x2f5cf4(0x6c9)])return![];return VisuMZ[_0x2f5cf4(0x83c)]['Settings']['Enemy'][_0x2f5cf4(0x626)];},VisuMZ[_0x1a8785(0x83c)]['BattleManager_startInput']=BattleManager[_0x1a8785(0xa24)],BattleManager[_0x1a8785(0xa24)]=function(){const _0x1d9814=_0x1a8785;VisuMZ[_0x1d9814(0x83c)]['BattleManager_startInput']['call'](this),this[_0x1d9814(0x8ef)]()&&this['isSkipPartyCommandWindow']()&&!this['_surprise']&&$gameParty[_0x1d9814(0x86c)]()&&this['selectNextCommand']();},BattleManager[_0x1a8785(0x66f)]=function(){const _0xbab1c1=_0x1a8785;return VisuMZ[_0xbab1c1(0x83c)][_0xbab1c1(0x9a7)][_0xbab1c1(0x504)][_0xbab1c1(0x618)];},BattleManager[_0x1a8785(0xa6f)]=function(){const _0x37cfc1=_0x1a8785;this[_0x37cfc1(0x3c1)]()&&this[_0x37cfc1(0x592)]();},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x225)]=Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x7da)],Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x7da)]=function(){const _0x2427b3=_0x1a8785;VisuMZ[_0x2427b3(0x83c)][_0x2427b3(0x225)][_0x2427b3(0x716)](this),BattleManager[_0x2427b3(0x875)]()&&BattleManager[_0x2427b3(0xa4a)]&&(BattleManager['_tpbNeedsPartyCommand']=![],this[_0x2427b3(0x525)]());},BattleManager[_0x1a8785(0x540)]=function(_0x11329d,_0x27fbdf){const _0x4e7898=_0x1a8785;this[_0x4e7898(0x440)][_0x4e7898(0x56e)]=_0x27fbdf,this[_0x4e7898(0x2f3)][_0x4e7898(0x3ab)](_0x27fbdf),this[_0x4e7898(0x2f3)][_0x4e7898(0x5a3)](_0x11329d,this['_action']),this['_action']['apply'](_0x11329d),this[_0x4e7898(0x2f3)]['displayActionResults'](_0x11329d,_0x11329d);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0xa7c)]=BattleManager[_0x1a8785(0x5ba)],BattleManager[_0x1a8785(0x5ba)]=function(){const _0x247fc2=_0x1a8785;VisuMZ['BattleCore'][_0x247fc2(0xa7c)][_0x247fc2(0x716)](this),this[_0x247fc2(0x8b6)]=this['_actionBattlers']['filter'](_0x5c8814=>_0x5c8814&&_0x5c8814[_0x247fc2(0x46d)]());},VisuMZ['BattleCore']['BattleManager_updatePhase']=BattleManager[_0x1a8785(0x3b0)],BattleManager['updatePhase']=function(_0x31f73d){const _0x4fdfa9=_0x1a8785;if(this['_phase']===_0x4fdfa9(0x558))this[_0x4fdfa9(0xa5d)]();else this['_phase']==='forceAction'?this['updateForceAction']():VisuMZ[_0x4fdfa9(0x83c)]['BattleManager_updatePhase'][_0x4fdfa9(0x716)](this,_0x31f73d);},BattleManager[_0x1a8785(0x447)]=function(){const _0x395604=_0x1a8785;this['_allTargets']=this[_0x395604(0x58c)][_0x395604(0xa53)](0x0),this['_targetIndex']=0x0,this[_0x395604(0x733)]=this[_0x395604(0x829)][0x0]||null,this[_0x395604(0x426)]=_0x395604(0x558);},BattleManager['updateCustomActionSequence']=function(){const _0x4cd8c2=_0x1a8785;!this['updateEventMain']()&&!this[_0x4cd8c2(0x2f3)][_0x4cd8c2(0x5ce)]()&&(this['_phase']=_0x4cd8c2(0x915));},BattleManager[_0x1a8785(0x790)]=function(_0x2ec014){const _0x4a72f8=_0x1a8785;this[_0x4a72f8(0x8b6)][_0x4a72f8(0xa3b)](_0x2ec014);if(_0x2ec014===this[_0x4a72f8(0x938)])return;const _0x20c2be=JsonEx[_0x4a72f8(0x950)](_0x2ec014['currentAction']());this[_0x4a72f8(0x73a)][_0x4a72f8(0x963)]([_0x2ec014,_0x20c2be]);},BattleManager[_0x1a8785(0x1ba)]=function(){},BattleManager[_0x1a8785(0x87d)]=function(){const _0x9fe2a3=_0x1a8785;if(this['isTpb']())this[_0x9fe2a3(0x426)]=_0x9fe2a3(0x684);else this[_0x9fe2a3(0x73a)][_0x9fe2a3(0x2dc)]>0x0?this['_phase']=_0x9fe2a3(0x684):this[_0x9fe2a3(0xa24)]();},BattleManager[_0x1a8785(0x737)]=function(){const _0x45c66b=_0x1a8785,_0x5d38ba=this[_0x45c66b(0x938)];_0x5d38ba&&this['isTpb']()&&_0x5d38ba[_0x45c66b(0x98a)](_0x45c66b(0x2df));for(;;){const _0x540fbc=this['getNextSubjectFromPool']();if(!_0x540fbc)return null;if(_0x540fbc['isBattleMember']()&&_0x540fbc[_0x45c66b(0x919)]())return _0x540fbc;}},BattleManager[_0x1a8785(0x2a1)]=function(){const _0x40badf=_0x1a8785;if(this[_0x40badf(0x73a)][_0x40badf(0x2dc)]>0x0){const _0x11418a=this[_0x40badf(0x73a)]['shift'](),_0x4e0751=_0x11418a[0x0];return _0x4e0751[_0x40badf(0xa89)]=_0x4e0751[_0x40badf(0xa89)]||[],_0x4e0751['_actions'][0x0]=_0x11418a[0x1],_0x4e0751;}else return this[_0x40badf(0x8b6)][_0x40badf(0x3e5)]();},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x86a)]=Game_Battler[_0x1a8785(0x978)]['forceAction'],Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x790)]=function(_0x5b55cd,_0x4b7975){const _0x2b76dd=_0x1a8785;VisuMZ[_0x2b76dd(0x83c)][_0x2b76dd(0x86a)]['call'](this,_0x5b55cd,_0x4b7975),this[_0x2b76dd(0xa89)][this[_0x2b76dd(0xa89)][_0x2b76dd(0x2dc)]-0x1]['_forceAction']=!![];},Game_Interpreter[_0x1a8785(0x978)][_0x1a8785(0xaf7)]=function(_0x2e59d6){const _0x3db6d2=_0x1a8785;return this[_0x3db6d2(0x5f8)](_0x2e59d6[0x0],_0x2e59d6[0x1],_0x30a62d=>{const _0x529ab3=_0x3db6d2;!_0x30a62d[_0x529ab3(0x7e5)]()&&(_0x30a62d[_0x529ab3(0x790)](_0x2e59d6[0x2],_0x2e59d6[0x3]),BattleManager[_0x529ab3(0x790)](_0x30a62d));}),!![];},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x81a)]=Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x4a6)],Game_Battler['prototype'][_0x1a8785(0x4a6)]=function(){const _0x5c25fe=_0x1a8785;VisuMZ[_0x5c25fe(0x83c)][_0x5c25fe(0x81a)][_0x5c25fe(0x716)](this),this[_0x5c25fe(0xa89)][_0x5c25fe(0x2dc)]<=0x0&&(this[_0x5c25fe(0x24b)]=Number[_0x5c25fe(0x88b)]);},BattleManager[_0x1a8785(0x495)]=function(){const _0x552992=_0x1a8785;if(VisuMZ[_0x552992(0x83c)][_0x552992(0x9a7)]['Damage'][_0x552992(0x316)]??!![])return![];return SceneManager[_0x552992(0x3a8)]()&&this['_endingBattle'];},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x276)]=BattleManager['selectNextCommand'],BattleManager[_0x1a8785(0x592)]=function(){const _0xf7236e=_0x1a8785;this['isTpb']()?this[_0xf7236e(0x283)]():VisuMZ[_0xf7236e(0x83c)][_0xf7236e(0x276)][_0xf7236e(0x716)](this);},BattleManager[_0x1a8785(0x283)]=function(){const _0x31c983=_0x1a8785;if(this[_0x31c983(0x9d6)]){if(this[_0x31c983(0x9d6)][_0x31c983(0x592)]())return;this['finishActorInput'](),this[_0x31c983(0x966)](),!this['_subject']&&!this[_0x31c983(0x9d6)]&&SceneManager[_0x31c983(0xa42)]['updateBattleProcess']();}else!this[_0x31c983(0x938)]&&this['selectNextActor']();},BattleManager[_0x1a8785(0x966)]=function(){const _0x274857=_0x1a8785;(!this[_0x274857(0x3c1)]()||this['needsActorInputCancel']())&&(this['_tpbSceneChangeCacheActor']&&(!$gameParty['battleMembers']()[_0x274857(0xa3e)](this[_0x274857(0x23f)])&&(this[_0x274857(0x23f)]=null)),!this[_0x274857(0x23f)]?(this[_0x274857(0x604)](),this[_0x274857(0x9d6)]=null,this['_inputting']=![]):this[_0x274857(0x3e9)]());},BattleManager[_0x1a8785(0x3e9)]=function(){const _0x40228d=_0x1a8785;!$gameParty[_0x40228d(0x87e)]()[_0x40228d(0xa3e)](this[_0x40228d(0x23f)])&&(this[_0x40228d(0x23f)]=null),this[_0x40228d(0x23f)]?(this['_currentActor']=this[_0x40228d(0x23f)],this[_0x40228d(0x9d6)]['_tpbState']='charged',this[_0x40228d(0x67d)]=!![],this['_tpbSceneChangeCacheActor']=null):(this[_0x40228d(0x604)](),this[_0x40228d(0x9d6)]=null,this[_0x40228d(0x67d)]=![]);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0xaa9)]=BattleManager[_0x1a8785(0x700)],BattleManager[_0x1a8785(0x700)]=function(){const _0x5ef522=_0x1a8785;return this[_0x5ef522(0x426)]===_0x5ef522(0x558)?this['battleCoreTpbMainPhase']():VisuMZ['BattleCore']['BattleManager_isTpbMainPhase'][_0x5ef522(0x716)](this);},BattleManager['battleCoreTpbMainPhase']=function(){return this['isActiveTpb']();},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x243)]=BattleManager[_0x1a8785(0x604)],BattleManager[_0x1a8785(0x604)]=function(){const _0x36323d=_0x1a8785;this[_0x36323d(0x875)]()&&this[_0x36323d(0x426)]===_0x36323d(0x2b6)&&(this['_currentActor']=null),VisuMZ[_0x36323d(0x83c)][_0x36323d(0x243)]['call'](this);},VisuMZ['BattleCore'][_0x1a8785(0x4a5)]=BattleManager['inputtingAction'],BattleManager['inputtingAction']=function(){const _0x4f68b7=_0x1a8785,_0x42a158=this[_0x4f68b7(0x9d6)];if(_0x42a158&&!_0x42a158[_0x4f68b7(0x288)]()){const _0x2f6b9c=_0x42a158['_actionInputIndex'];_0x42a158[_0x4f68b7(0xa89)][_0x2f6b9c]=new Game_Action(_0x42a158);}return VisuMZ[_0x4f68b7(0x83c)][_0x4f68b7(0x4a5)][_0x4f68b7(0x716)](this);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x570)]=BattleManager[_0x1a8785(0x1b2)],BattleManager[_0x1a8785(0x1b2)]=function(_0x3005da){const _0x128e13=_0x1a8785;if(this[_0x128e13(0x440)][_0x128e13(0x734)]())return![];return VisuMZ[_0x128e13(0x83c)][_0x128e13(0x570)][_0x128e13(0x716)](this,_0x3005da);},SceneManager[_0x1a8785(0x3a8)]=function(){const _0x20e5a1=_0x1a8785;return this[_0x20e5a1(0xa42)]&&this['_scene'][_0x20e5a1(0x79d)]===Scene_Battle;},SceneManager[_0x1a8785(0x55e)]=function(){const _0x1455b1=_0x1a8785;return Spriteset_Battle['prototype'][_0x1455b1(0x401)]();},SceneManager['isPreviousSceneBattleTransitionable']=function(){if(SceneManager['isPreviousScene'](Scene_Options))return!![];return![];},SceneManager['isNextSceneBattleTransitionable']=function(){const _0x7bd02=_0x1a8785;if(SceneManager[_0x7bd02(0x890)](Scene_Options))return!![];return![];},SceneManager[_0x1a8785(0x843)]=function(_0x4e9be6){const _0x36b84f=_0x1a8785;if(!SceneManager[_0x36b84f(0x3a8)]())return!![];const _0x2acfd0=[_0x36b84f(0x970),_0x36b84f(0x977)];return _0x2acfd0['includes'](_0x4e9be6[_0x36b84f(0x1f2)]);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0xa69)]=SceneManager['push'],SceneManager['push']=function(_0x36bc47){const _0x5a9899=_0x1a8785;if(!SceneManager[_0x5a9899(0x843)](_0x36bc47))return this['displayBattleCoreTransitionErrorMsg'](_0x36bc47);VisuMZ[_0x5a9899(0x83c)][_0x5a9899(0xa69)][_0x5a9899(0x716)](this,_0x36bc47);},SceneManager['displayBattleCoreTransitionErrorMsg']=function(_0x39f7c3){const _0x293e76=_0x1a8785;if(!$gameTemp['isPlaytest']())return;if(this[_0x293e76(0x831)])return;this[_0x293e76(0x831)]=!![];let _0x2101d5='';_0x2101d5+=_0x293e76(0x223),_0x2101d5+=_0x293e76(0x528)['format'](_0x39f7c3[_0x293e76(0x1f2)]),alert(_0x2101d5);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x45e)]=Game_Temp[_0x1a8785(0x978)][_0x1a8785(0x522)],Game_Temp['prototype'][_0x1a8785(0x522)]=function(_0x4d9491,_0x27c9df,_0x335851){const _0x5b7653=_0x1a8785;_0x4d9491=_0x4d9491['filter']((_0x1276fa,_0xbc8bbe,_0x200c81)=>_0x200c81[_0x5b7653(0x64f)](_0x1276fa)===_0xbc8bbe),SceneManager[_0x5b7653(0x3a8)]()&&SceneManager['isBattleFlipped']()&&(_0x335851=!_0x335851),VisuMZ[_0x5b7653(0x83c)]['Game_Temp_requestAnimation']['call'](this,_0x4d9491,_0x27c9df,_0x335851),SceneManager[_0x5b7653(0x3a8)]()&&BattleManager[_0x5b7653(0x589)][_0x5b7653(0x69e)]();},Game_Temp[_0x1a8785(0x978)][_0x1a8785(0x39e)]=function(_0x5dc73e){const _0x2f40b1=_0x1a8785;this[_0x2f40b1(0x415)]=_0x5dc73e;},Game_Temp[_0x1a8785(0x978)][_0x1a8785(0x55b)]=function(){return this['_lastPluginCommandInterpreter'];},Game_Temp[_0x1a8785(0x978)][_0x1a8785(0x485)]=function(){const _0xf4fe78=_0x1a8785;this[_0xf4fe78(0x68c)]=undefined;},Game_Temp[_0x1a8785(0x978)][_0x1a8785(0x8bb)]=function(_0xb22c35){const _0x3396ea=_0x1a8785;$gameMap&&$dataMap&&$dataMap[_0x3396ea(0x9c6)]&&this[_0x3396ea(0xad3)]($dataMap[_0x3396ea(0x9c6)]);const _0x511e00=$dataTroops[_0xb22c35];if(_0x511e00){let _0x4d404f=DataManager[_0x3396ea(0x6e9)](_0x511e00['id']);this['parseForcedGameTroopSettingsBattleCore'](_0x4d404f);}},Game_Temp[_0x1a8785(0x978)]['parseForcedGameTroopSettingsBattleCore']=function(_0x2daad1){const _0x4042af=_0x1a8785;if(!_0x2daad1)return;if(_0x2daad1[_0x4042af(0x9e0)](/<(?:BATTLELAYOUT|BATTLE LAYOUT|LAYOUT):[ ](.*?)>/i)){const _0x7ed9e6=String(RegExp['$1']);if(_0x7ed9e6[_0x4042af(0x9e0)](/DEFAULT/i))this[_0x4042af(0x68c)]='default';else{if(_0x7ed9e6[_0x4042af(0x9e0)](/LIST/i))this[_0x4042af(0x68c)]=_0x4042af(0x43b);else{if(_0x7ed9e6[_0x4042af(0x9e0)](/XP/i))this[_0x4042af(0x68c)]='xp';else{if(_0x7ed9e6[_0x4042af(0x9e0)](/PORTRAIT/i))this[_0x4042af(0x68c)]=_0x4042af(0x5b2);else{if(_0x7ed9e6[_0x4042af(0x9e0)](/BORDER/i))this['_forcedBattleLayout']=_0x4042af(0x617);else{if(_0x7ed9e6['match'](/(?:SIDEVIEW UI|SIDEVIEW)/i))Imported[_0x4042af(0xa2b)]?this[_0x4042af(0x68c)]=_0x4042af(0x80e):this[_0x4042af(0x68c)]=_0x4042af(0x3ee);else _0x7ed9e6['match'](/(?:FRONTVIEW UI|FRONTVIEW)/i)&&(Imported[_0x4042af(0xa71)]?this[_0x4042af(0x68c)]=_0x4042af(0x955):this[_0x4042af(0x68c)]=_0x4042af(0x3ee));}}}}}}},VisuMZ['BattleCore'][_0x1a8785(0x4a4)]=Game_System[_0x1a8785(0x978)]['initialize'],Game_System[_0x1a8785(0x978)][_0x1a8785(0x3cf)]=function(){const _0x3dd3a2=_0x1a8785;VisuMZ['BattleCore']['Game_System_initialize'][_0x3dd3a2(0x716)](this),this[_0x3dd3a2(0x62a)]();},Game_System[_0x1a8785(0x978)]['initBattleCore']=function(){const _0x44a3ed=_0x1a8785;this[_0x44a3ed(0x791)]=this[_0x44a3ed(0x791)]||[];},Game_System[_0x1a8785(0x978)]['getDefeatedEnemies']=function(){const _0x414143=_0x1a8785;if(this[_0x414143(0x791)]===undefined)this[_0x414143(0x62a)]();return this[_0x414143(0x791)];},Game_System[_0x1a8785(0x978)][_0x1a8785(0x5bb)]=function(_0x2ab096){const _0x21390c=_0x1a8785;if(this[_0x21390c(0x791)]===undefined)this[_0x21390c(0x62a)]();if(!_0x2ab096)return;if(this[_0x21390c(0x791)]['includes'](_0x2ab096))return;this[_0x21390c(0x791)][_0x21390c(0x963)](_0x2ab096),this[_0x21390c(0x791)][_0x21390c(0x836)]((_0x2b5359,_0x115aa7)=>_0x2b5359-_0x115aa7);},VisuMZ['BattleCore'][_0x1a8785(0x9ca)]=Game_BattlerBase[_0x1a8785(0x978)]['addNewState'],Game_BattlerBase[_0x1a8785(0x978)]['addNewState']=function(_0xe3a47d){const _0xe32af0=_0x1a8785,_0x22c1a6=this[_0xe32af0(0x919)](),_0x155a10=this[_0xe32af0(0x8c6)]();VisuMZ[_0xe32af0(0x83c)][_0xe32af0(0x9ca)][_0xe32af0(0x716)](this,_0xe3a47d),this[_0xe32af0(0x3a6)]()&&_0x22c1a6&&this[_0xe32af0(0x37f)]()&&(this[_0xe32af0(0x334)]=!this['hasBeenDefeatedBefore'](),$gameSystem[_0xe32af0(0x5bb)](this['enemyId']())),SceneManager['isSceneBattle']()&&_0x155a10!==this[_0xe32af0(0x8c6)]()&&(this[_0xe32af0(0x89e)]()&&this[_0xe32af0(0x89e)]()[_0xe32af0(0x5ca)]());},Game_Enemy['prototype'][_0x1a8785(0x705)]=function(){const _0x2a0c1f=_0x1a8785;return $gameSystem[_0x2a0c1f(0x20f)]()[_0x2a0c1f(0xa3e)](this[_0x2a0c1f(0x4d1)]);},VisuMZ['BattleCore'][_0x1a8785(0x65d)]=Game_BattlerBase['prototype'][_0x1a8785(0x3a1)],Game_BattlerBase[_0x1a8785(0x978)][_0x1a8785(0x3a1)]=function(_0x351ea4){const _0x45593f=_0x1a8785;VisuMZ[_0x45593f(0x83c)][_0x45593f(0x65d)][_0x45593f(0x716)](this,_0x351ea4),this[_0x45593f(0x3a6)]()&&_0x351ea4===this['deathStateId']()&&this[_0x45593f(0x919)]()&&(this['_visualHpGauge_JustDied']=![]),!this[_0x45593f(0x5a5)]&&!this[_0x45593f(0x1c0)]&&SceneManager[_0x45593f(0x3a8)]()&&this[_0x45593f(0x7cb)]();},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x8cb)]=Game_Action['prototype']['clear'],Game_Action[_0x1a8785(0x978)][_0x1a8785(0x1fb)]=function(){const _0x2ce3d2=_0x1a8785;VisuMZ[_0x2ce3d2(0x83c)][_0x2ce3d2(0x8cb)]['call'](this),this[_0x2ce3d2(0x666)]={'arPenRate':0x0,'arPenFlat':0x0,'arRedRate':0x0,'arRedFlat':0x0},this['_multipliers']={'criticalHitRate':0x1,'criticalHitFlat':0x0,'criticalDmgRate':0x1,'criticalDmgFlat':0x0,'damageRate':0x1,'damageFlat':0x0,'hitRate':0x1,'hitFlat':0x0},this['_customDamageFormula']=_0x2ce3d2(0x3ee),this[_0x2ce3d2(0x714)]();},Game_Action[_0x1a8785(0x978)][_0x1a8785(0x714)]=function(){const _0x5a9484=_0x1a8785;this[_0x5a9484(0x9ef)]='';},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x770)]=Game_Action[_0x1a8785(0x978)][_0x1a8785(0x8b4)],Game_Action[_0x1a8785(0x978)]['setSubject']=function(_0x1415cc){const _0x25af20=_0x1a8785;VisuMZ[_0x25af20(0x83c)][_0x25af20(0x770)][_0x25af20(0x716)](this,_0x1415cc),this['clearTargetBattlerKey']();},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x2e1)]=Game_Action[_0x1a8785(0x978)][_0x1a8785(0x533)],Game_Action[_0x1a8785(0x978)]['setSkill']=function(_0x5806e3){const _0x545ea2=_0x1a8785;VisuMZ['BattleCore'][_0x545ea2(0x2e1)][_0x545ea2(0x716)](this,_0x5806e3),this['clearTargetBattlerKey']();},VisuMZ['BattleCore'][_0x1a8785(0xa36)]=Game_Action['prototype'][_0x1a8785(0xa11)],Game_Action[_0x1a8785(0x978)][_0x1a8785(0xa11)]=function(_0x57b664){const _0x3006be=_0x1a8785;VisuMZ[_0x3006be(0x83c)][_0x3006be(0xa36)][_0x3006be(0x716)](this,_0x57b664),this[_0x3006be(0x714)]();},Game_Action[_0x1a8785(0x978)]['makeDamageValue']=function(_0x50f0db,_0x1b8b9d){const _0x48ff0a=_0x1a8785;return VisuMZ[_0x48ff0a(0x83c)]['Settings'][_0x48ff0a(0xa19)][_0x48ff0a(0x62e)][_0x48ff0a(0x716)](this,_0x50f0db,_0x1b8b9d);},Game_Action[_0x1a8785(0x978)][_0x1a8785(0x847)]=function(_0x5b8758,_0x106354){const _0x1a9b5e=_0x1a8785;return VisuMZ['BattleCore'][_0x1a9b5e(0x9a7)][_0x1a9b5e(0xa19)][_0x1a9b5e(0x754)][_0x1a9b5e(0x716)](this,_0x5b8758,_0x106354);},Game_Action[_0x1a8785(0x978)][_0x1a8785(0x71c)]=function(_0x3b51d0,_0x317550){const _0x412547=_0x1a8785;return VisuMZ[_0x412547(0x83c)][_0x412547(0x9a7)][_0x412547(0xa19)]['GuardFormulaJS']['call'](this,_0x3b51d0,_0x317550);},VisuMZ[_0x1a8785(0x83c)]['Game_Action_itemHit']=Game_Action['prototype'][_0x1a8785(0x726)],Game_Action['prototype'][_0x1a8785(0x726)]=function(_0x1d9ebf){const _0x252103=_0x1a8785,_0x300c4b=this['item']()[_0x252103(0x9c6)];if(_0x300c4b[_0x252103(0x9e0)](/<ALWAYS HIT>/i))return 0x1;else{if(_0x300c4b['match'](/<ALWAYS HIT RATE: (\d+)([%％])>/i))return Number(RegExp['$1'])/0x64;else{let _0x13b065=VisuMZ[_0x252103(0x83c)][_0x252103(0x78d)]['call'](this,_0x1d9ebf);return _0x13b065=this[_0x252103(0x44e)][_0x252103(0x4e1)]*_0x13b065+this[_0x252103(0x44e)][_0x252103(0x181)],_0x13b065;}}},Game_Action[_0x1a8785(0x978)][_0x1a8785(0x4ef)]=function(_0x216d04){const _0x3ee058=_0x1a8785;if(!this[_0x3ee058(0x7e0)]()[_0x3ee058(0x5c1)]['critical'])return 0x0;let _0x1d73ce=VisuMZ['BattleCore'][_0x3ee058(0x9a7)]['Damage'][_0x3ee058(0x545)][_0x3ee058(0x716)](this,_0x216d04);return _0x1d73ce=this['_multipliers']['criticalHitRate']*_0x1d73ce+this[_0x3ee058(0x44e)][_0x3ee058(0x3be)],_0x1d73ce;},Game_Action[_0x1a8785(0x978)][_0x1a8785(0x759)]=function(_0x12b8a0){const _0x1e242e=_0x1a8785;return _0x12b8a0=VisuMZ['BattleCore']['Settings'][_0x1e242e(0xa19)][_0x1e242e(0x579)][_0x1e242e(0x716)](this,_0x12b8a0),_0x12b8a0=this[_0x1e242e(0x44e)][_0x1e242e(0x750)]*_0x12b8a0+this[_0x1e242e(0x44e)]['criticalDmgFlat'],_0x12b8a0;},VisuMZ['BattleCore'][_0x1a8785(0x7db)]=Game_Action[_0x1a8785(0x978)][_0x1a8785(0x677)],Game_Action[_0x1a8785(0x978)][_0x1a8785(0x677)]=function(_0x2ffac5){const _0x4ec2ee=_0x1a8785;if(this['_customDamageFormula']!=='default')return this[_0x4ec2ee(0x6cd)](_0x2ffac5);else return DataManager[_0x4ec2ee(0x89d)](this[_0x4ec2ee(0x7e0)]())===_0x4ec2ee(0x2e7)?VisuMZ[_0x4ec2ee(0x83c)]['Game_Action_evalDamageFormula']['call'](this,_0x2ffac5):this['evalDamageFormulaBattleCore'](_0x2ffac5);},Game_Action['prototype'][_0x1a8785(0x3e0)]=function(_0x5f3a6e){const _0x2390f0=_0x1a8785;this[_0x2390f0(0x7f5)]=_0x5f3a6e;},Game_Action['prototype'][_0x1a8785(0x6cd)]=function(_0x4acff3){const _0x3d2a91=_0x1a8785,_0x2ae30d=this[_0x3d2a91(0x7e0)](),_0x2ecb13=_0x2ae30d[_0x3d2a91(0x5c1)]['formula'];_0x2ae30d['damage'][_0x3d2a91(0x9e4)]=this['_customDamageFormula'];let _0x492ca0=VisuMZ[_0x3d2a91(0x83c)][_0x3d2a91(0x7db)][_0x3d2a91(0x716)](this,_0x4acff3);return _0x2ae30d[_0x3d2a91(0x5c1)][_0x3d2a91(0x9e4)]=_0x2ecb13,_0x492ca0;},Game_Action['prototype'][_0x1a8785(0x2ab)]=function(){const _0x45dae5=_0x1a8785;if(this[_0x45dae5(0x7e0)]()[_0x45dae5(0x9c6)][_0x45dae5(0x9e0)](/<DAMAGE STYLE:[ ](.*)>/i)){const _0x3e7e5c=String(RegExp['$1'])[_0x45dae5(0x830)]()['trim']();return _0x3e7e5c;}return _0x45dae5(0x2e7);},Game_Action[_0x1a8785(0x978)]['evalDamageFormulaBattleCore']=function(_0xf2c570){const _0x568a24=_0x1a8785,_0x11f04f=DataManager[_0x568a24(0x89d)](this['item']()),_0x4a44b6=VisuMZ['DamageStyles'][_0x11f04f];try{return _0x4a44b6['Formula'][_0x568a24(0x716)](this,_0xf2c570);}catch(_0x5dbd88){if($gameTemp[_0x568a24(0x444)]())console[_0x568a24(0x809)](_0x5dbd88);return VisuMZ[_0x568a24(0x83c)][_0x568a24(0x7db)][_0x568a24(0x716)](this);}},Game_Action[_0x1a8785(0x978)][_0x1a8785(0x928)]=function(_0x22a807,_0x2a667b){const _0x71af5e=_0x1a8785;if(this[_0x71af5e(0x3f7)]())return _0x2a667b;const _0x58cee8=this[_0x71af5e(0x9ba)](),_0x1b21bd=_0x22a807;let _0x7c8625=[],_0x49aa65=[];_0x7c8625['push'](this[_0x71af5e(0x666)][_0x71af5e(0x3fd)],this[_0x71af5e(0x666)]['arRedFlat']),_0x49aa65[_0x71af5e(0x963)](this[_0x71af5e(0x666)][_0x71af5e(0x56d)],this[_0x71af5e(0x666)][_0x71af5e(0x4ac)]);const _0x5544d8=this[_0x71af5e(0x1a6)]()?/<ARMOR REDUCTION:[ ](\d+\.?\d*)>/i:/<MAGIC REDUCTION:[ ](\d+\.?\d*)>/i,_0x461f03=this[_0x71af5e(0x1a6)]()?/<ARMOR REDUCTION:[ ](\d+\.?\d*)([%％])>/i:/<MAGIC REDUCTION:[ ](\d+\.?\d*)([%％])>/i,_0x20f477=this[_0x71af5e(0x1a6)]()?/<ARMOR PENETRATION:[ ](\d+\.?\d*)>/i:/<MAGIC PENETRATION:[ ](\d+\.?\d*)>/i,_0x4bbe3e=this[_0x71af5e(0x1a6)]()?/<ARMOR PENETRATION:[ ](\d+\.?\d*)([%％])>/i:/<MAGIC PENETRATION:[ ](\d+\.?\d*)([%％])>/i;return _0x7c8625=_0x7c8625[_0x71af5e(0x755)](_0x1b21bd[_0x71af5e(0x990)]()[_0x71af5e(0x628)](_0x5e19f8=>_0x5e19f8&&_0x5e19f8['note']['match'](_0x5544d8)?Number(RegExp['$1']):0x0)),_0x49aa65=_0x49aa65[_0x71af5e(0x755)](_0x1b21bd[_0x71af5e(0x990)]()[_0x71af5e(0x628)](_0xdc2b98=>_0xdc2b98&&_0xdc2b98[_0x71af5e(0x9c6)]['match'](_0x461f03)?Number(RegExp['$1'])/0x64:0x0)),_0x7c8625=_0x7c8625[_0x71af5e(0x755)](_0x58cee8[_0x71af5e(0x990)]()['map'](_0x361b22=>_0x361b22&&_0x361b22[_0x71af5e(0x9c6)][_0x71af5e(0x9e0)](_0x20f477)?Number(RegExp['$1']):0x0)),_0x49aa65=_0x49aa65[_0x71af5e(0x755)](_0x58cee8[_0x71af5e(0x990)]()[_0x71af5e(0x628)](_0x24789a=>_0x24789a&&_0x24789a[_0x71af5e(0x9c6)][_0x71af5e(0x9e0)](_0x4bbe3e)?Number(RegExp['$1'])/0x64:0x0)),this['item']()[_0x71af5e(0x9c6)][_0x71af5e(0x9e0)](_0x20f477)&&_0x7c8625[_0x71af5e(0x963)](Number(RegExp['$1'])),this['item']()['note'][_0x71af5e(0x9e0)](_0x4bbe3e)&&_0x49aa65[_0x71af5e(0x963)](Number(RegExp['$1'])),_0x2a667b=_0x7c8625['reduce']((_0x5961df,_0x26c991)=>_0x5961df-_0x26c991,_0x2a667b),_0x2a667b>0x0&&(_0x2a667b=_0x49aa65['reduce']((_0x21cdeb,_0x51155d)=>_0x21cdeb*(0x1-_0x51155d),_0x2a667b)),_0x2a667b;},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x9b3)]=Game_Action[_0x1a8785(0x978)][_0x1a8785(0x3b4)],Game_Action[_0x1a8785(0x978)][_0x1a8785(0x3b4)]=function(_0x56bbbf,_0xda2ed1){const _0x339939=_0x1a8785;_0xda2ed1=_0xda2ed1*this[_0x339939(0x44e)][_0x339939(0x67a)],_0xda2ed1+=this[_0x339939(0x44e)][_0x339939(0x9ee)]*(_0xda2ed1>=0x0?0x1:-0x1),_0xda2ed1=this[_0x339939(0x2c1)](_0x339939(0x4d8),_0x56bbbf,_0xda2ed1,![]),_0xda2ed1=this[_0x339939(0x995)](_0xda2ed1),_0xda2ed1=Math['round'](_0xda2ed1),this[_0x339939(0x360)]=_0xda2ed1,this[_0x339939(0x488)]=this['_totalValue']||0x0,this[_0x339939(0x488)]+=_0xda2ed1,VisuMZ[_0x339939(0x83c)][_0x339939(0x9b3)][_0x339939(0x716)](this,_0x56bbbf,_0xda2ed1),this[_0x339939(0x2c1)](_0x339939(0xa55),_0x56bbbf,_0xda2ed1,!![]);},Game_Action['prototype']['applyDamageCaps']=function(_0x211e08){const _0x10aa1e=_0x1a8785;if(this[_0x10aa1e(0x3c5)]())return _0x211e08;return _0x211e08=this[_0x10aa1e(0xa99)](_0x211e08),_0x211e08=this['applyHardDamageCap'](_0x211e08),_0x211e08;},Game_Action[_0x1a8785(0x978)][_0x1a8785(0x3c5)]=function(){const _0x145eed=_0x1a8785,_0x5cf7f3=/<BYPASS DAMAGE CAP>/i;if(this['item']()[_0x145eed(0x9c6)]['match'](_0x5cf7f3))return!![];if(this[_0x145eed(0x9ba)]()['traitObjects']()[_0x145eed(0xa8e)](_0x152750=>_0x152750&&_0x152750[_0x145eed(0x9c6)][_0x145eed(0x9e0)](_0x5cf7f3)))return!![];return!VisuMZ[_0x145eed(0x83c)][_0x145eed(0x9a7)]['Damage'][_0x145eed(0x209)];},Game_Action['prototype'][_0x1a8785(0xa99)]=function(_0x5f3bf2){const _0x3e0166=_0x1a8785;if(!VisuMZ[_0x3e0166(0x83c)][_0x3e0166(0x9a7)][_0x3e0166(0xa19)][_0x3e0166(0x57f)])return _0x5f3bf2;const _0x5f2494=/<BYPASS SOFT DAMAGE CAP>/i;if(this[_0x3e0166(0x7e0)]()[_0x3e0166(0x9c6)][_0x3e0166(0x9e0)](_0x5f2494))return _0x5f3bf2;if(this[_0x3e0166(0x9ba)]()[_0x3e0166(0x990)]()['some'](_0x5e4ee5=>_0x5e4ee5&&_0x5e4ee5[_0x3e0166(0x9c6)][_0x3e0166(0x9e0)](_0x5f2494)))return _0x5f3bf2;const _0x5c3474=_0x5f3bf2<0x0?-0x1:0x1;_0x5f3bf2=Math['abs'](_0x5f3bf2);let _0xf1a930=this['subject']()['softDamageCapRate']();this[_0x3e0166(0x7e0)]()[_0x3e0166(0x9c6)]['match'](/<SOFT DAMAGE CAP:[ ]([\+\-]\d+)([%％])>/i)&&(_0xf1a930+=Number(RegExp['$1'])/0x64);_0xf1a930=_0xf1a930[_0x3e0166(0x39c)](0.01,0x1);const _0x22fcd9=this['getHardDamageCap'](),_0x199d7c=_0xf1a930*_0x22fcd9;if(_0x5f3bf2>_0x199d7c&&_0x22fcd9>_0x199d7c){_0x5f3bf2-=_0x199d7c;const _0x1d76dd=VisuMZ[_0x3e0166(0x83c)][_0x3e0166(0x9a7)][_0x3e0166(0xa19)][_0x3e0166(0x39d)],_0xa1ce07=Math[_0x3e0166(0x5a7)](0x1-_0x5f3bf2/((_0x22fcd9-_0x199d7c)*_0x1d76dd+_0x5f3bf2),0.01);_0x5f3bf2*=_0xa1ce07,_0x5f3bf2+=_0x199d7c;}return _0x5f3bf2*_0x5c3474;},Game_Action[_0x1a8785(0x978)]['getHardDamageCap']=function(){const _0x33fe19=_0x1a8785;return this[_0x33fe19(0x7e0)]()[_0x33fe19(0x9c6)][_0x33fe19(0x9e0)](/<DAMAGE CAP:[ ](\d+)>/i)?Number(RegExp['$1']):this[_0x33fe19(0x9ba)]()[_0x33fe19(0xa02)]();},Game_Action['prototype'][_0x1a8785(0x65b)]=function(_0x163dfd){const _0x10e908=_0x1a8785;console['log'](_0x163dfd);let _0x39dd2d=this['getHardDamageCap']();return _0x163dfd[_0x10e908(0x39c)](-_0x39dd2d,_0x39dd2d);},Game_Action[_0x1a8785(0x978)][_0x1a8785(0xa44)]=function(){const _0x2b11e3=_0x1a8785;if(!this['item']())return![];return(this[_0x2b11e3(0x7e0)]()['note']||'')[_0x2b11e3(0x9e0)](/<DISPERSE DAMAGE>/i);},Game_Action[_0x1a8785(0x978)][_0x1a8785(0x417)]=function(_0x148e41){const _0x55c4ef=_0x1a8785;if(this['shouldDisperseDamage']()){let _0x55ef07=BattleManager['_targets'];_0x148e41/=_0x55ef07['length'],this[_0x55c4ef(0x9fc)]()&&(_0x148e41*=this[_0x55c4ef(0x9ba)]()['attackTimesAdd']()+0x1),_0x148e41=_0x148e41>0x0?Math['ceil'](_0x148e41):Math[_0x55c4ef(0x4a7)](_0x148e41);}return _0x148e41;},VisuMZ[_0x1a8785(0x83c)]['Game_Action_makeDamageValueDisperse']=Game_Action[_0x1a8785(0x978)]['makeDamageValue'],Game_Action[_0x1a8785(0x978)][_0x1a8785(0x7ea)]=function(_0x5ad8d1,_0x2479b4){const _0x474759=_0x1a8785;let _0x3b312a=VisuMZ[_0x474759(0x83c)]['Game_Action_makeDamageValueDisperse'][_0x474759(0x716)](this,_0x5ad8d1,_0x2479b4);return this[_0x474759(0x417)](_0x3b312a);},Game_Action['prototype']['itemEffectRecoverHp']=function(_0x54020e,_0x43c053){const _0x125a65=_0x1a8785;let _0x21920f=(_0x54020e[_0x125a65(0x2c5)]*_0x43c053['value1']+_0x43c053[_0x125a65(0x3b6)])*_0x54020e['rec'];_0x21920f=this[_0x125a65(0x417)](_0x21920f),this[_0x125a65(0x786)]()&&(_0x21920f*=this[_0x125a65(0x9ba)]()['pha']),_0x21920f=Math[_0x125a65(0x4a7)](_0x21920f),_0x21920f!==0x0&&(_0x54020e['gainHp'](_0x21920f),this[_0x125a65(0x837)](_0x54020e));},Game_Action['prototype']['itemEffectRecoverMp']=function(_0x4df4f0,_0x22b2fd){const _0x5196d2=_0x1a8785;let _0x419fd8=(_0x4df4f0[_0x5196d2(0x403)]*_0x22b2fd['value1']+_0x22b2fd[_0x5196d2(0x3b6)])*_0x4df4f0[_0x5196d2(0x5c5)];_0x419fd8=this['disperseDamage'](_0x419fd8),this['isItem']()&&(_0x419fd8*=this[_0x5196d2(0x9ba)]()['pha']),_0x419fd8=Math[_0x5196d2(0x4a7)](_0x419fd8),_0x419fd8!==0x0&&(_0x4df4f0[_0x5196d2(0x48d)](_0x419fd8),this[_0x5196d2(0x837)](_0x4df4f0));},Game_Action[_0x1a8785(0x978)]['itemEffectGainTp']=function(_0x2d38e3,_0x24ccf5){const _0x5722cc=_0x1a8785;let _0x5b9535=Math[_0x5722cc(0x4a7)](_0x24ccf5[_0x5722cc(0x221)]);_0x5b9535=this[_0x5722cc(0x417)](_0x5b9535),_0x5b9535!==0x0&&(_0x2d38e3[_0x5722cc(0x263)](_0x5b9535),this['makeSuccess'](_0x2d38e3));},VisuMZ['BattleCore'][_0x1a8785(0x6c7)]=Game_Action['prototype'][_0x1a8785(0x520)],Game_Action[_0x1a8785(0x978)]['apply']=function(_0x9ac6f2){const _0x3af58c=_0x1a8785;this['applyBattleCoreJS']('PreApply%1JS',_0x9ac6f2,0x0,!![]),VisuMZ[_0x3af58c(0x83c)][_0x3af58c(0x6c7)]['call'](this,_0x9ac6f2),this[_0x3af58c(0x2c1)]('PostApply%1JS',_0x9ac6f2,this['_executedValue']||0x0,!![]),this['applyResultSwitches'](_0x9ac6f2);},Game_Action[_0x1a8785(0x978)][_0x1a8785(0x2c1)]=function(_0xb8e842,_0x143add,_0x2c9c6f,_0x49399e){const _0x5ac218=_0x1a8785;if(this[_0x5ac218(0x1c0)]||this[_0x5ac218(0x5a5)])return;_0x2c9c6f=_0x2c9c6f||0x0;const _0x41af86=_0x2c9c6f,_0x4af315=VisuMZ[_0x5ac218(0x83c)][_0x5ac218(0x9a7)][_0x5ac218(0x1af)],_0x4964ce=_0xb8e842[_0x5ac218(0x22f)]('');if(_0x4af315[_0x4964ce]){_0x2c9c6f=_0x4af315[_0x4964ce][_0x5ac218(0x716)](this,_0x2c9c6f,_0x143add);if(_0x49399e)_0x2c9c6f=_0x41af86;}let _0x208e2b=VisuMZ[_0x5ac218(0x83c)][_0x5ac218(0x30b)](this[_0x5ac218(0x7e0)](),_0xb8e842[_0x5ac218(0x22f)](''));if(VisuMZ[_0x5ac218(0x83c)]['JS'][_0x208e2b]){_0x2c9c6f=VisuMZ['BattleCore']['JS'][_0x208e2b][_0x5ac218(0x716)](this,this[_0x5ac218(0x9ba)](),_0x143add,this[_0x5ac218(0x7e0)](),_0x2c9c6f);if(_0x49399e)_0x2c9c6f=_0x41af86;}for(const _0x3175ce of this[_0x5ac218(0x9ba)]()[_0x5ac218(0x990)]()){if(!_0x3175ce)continue;_0x208e2b=VisuMZ[_0x5ac218(0x83c)][_0x5ac218(0x30b)](_0x3175ce,_0xb8e842[_0x5ac218(0x22f)](_0x5ac218(0x64c)));if(VisuMZ[_0x5ac218(0x83c)]['JS'][_0x208e2b]){_0x2c9c6f=VisuMZ[_0x5ac218(0x83c)]['JS'][_0x208e2b][_0x5ac218(0x716)](this,this[_0x5ac218(0x9ba)](),_0x143add,_0x3175ce,_0x2c9c6f);if(_0x49399e)_0x2c9c6f=_0x41af86;}}for(const _0xe1040 of _0x143add['traitObjects']()){if(!_0xe1040)continue;_0x208e2b=VisuMZ[_0x5ac218(0x83c)][_0x5ac218(0x30b)](_0xe1040,_0xb8e842[_0x5ac218(0x22f)](_0x5ac218(0x79b)));if(VisuMZ[_0x5ac218(0x83c)]['JS'][_0x208e2b]){_0x2c9c6f=VisuMZ['BattleCore']['JS'][_0x208e2b][_0x5ac218(0x716)](this,this['subject'](),_0x143add,_0xe1040,_0x2c9c6f);if(_0x49399e)_0x2c9c6f=_0x41af86;}}return _0x2c9c6f;},Game_Action['prototype']['actionBattleCoreJS']=function(_0x5327ec){const _0x21e579=_0x1a8785,_0x2bac88=this[_0x21e579(0x488)]||0x0,_0x21554e=VisuMZ['BattleCore'][_0x21e579(0x9a7)][_0x21e579(0x1af)],_0x2ade30=_0x5327ec[_0x21e579(0x22f)]('');_0x21554e[_0x2ade30]&&_0x21554e[_0x2ade30][_0x21e579(0x716)](this,_0x2bac88);let _0x267a00=VisuMZ[_0x21e579(0x83c)][_0x21e579(0x30b)](this[_0x21e579(0x7e0)](),_0x5327ec);VisuMZ[_0x21e579(0x83c)]['JS'][_0x267a00]&&VisuMZ[_0x21e579(0x83c)]['JS'][_0x267a00]['call'](this,this[_0x21e579(0x9ba)](),this[_0x21e579(0x9ba)](),this[_0x21e579(0x7e0)](),_0x2bac88);for(const _0x2d89e4 of this['subject']()[_0x21e579(0x990)]()){if(!_0x2d89e4)continue;_0x267a00=VisuMZ[_0x21e579(0x83c)][_0x21e579(0x30b)](_0x2d89e4,_0x5327ec),VisuMZ[_0x21e579(0x83c)]['JS'][_0x267a00]&&VisuMZ[_0x21e579(0x83c)]['JS'][_0x267a00][_0x21e579(0x716)](this,this['subject'](),this[_0x21e579(0x9ba)](),_0x2d89e4,_0x2bac88);}},Game_Action[_0x1a8785(0x978)][_0x1a8785(0x6b7)]=function(){const _0x371edb=_0x1a8785;return VisuMZ[_0x371edb(0x83c)]['Settings']['Mechanics']['CalcActionSpeedJS'][_0x371edb(0x716)](this);},Game_Action[_0x1a8785(0x978)]['allowRandomSpeed']=function(){const _0x17f4aa=_0x1a8785;return VisuMZ['BattleCore']['Settings'][_0x17f4aa(0x1af)][_0x17f4aa(0x778)];},Game_Action[_0x1a8785(0x978)][_0x1a8785(0x85d)]=function(){const _0x554879=_0x1a8785;if(this[_0x554879(0x9ef)]===_0x554879(0x9d1))return![];if(this['_targetBattlerKey']===_0x554879(0x398))return![];if(!this[_0x554879(0x7e0)]())return![];return this['item']()[_0x554879(0x9c6)][_0x554879(0x9e0)](/<JS TARGETS>/i);},Game_Action['prototype'][_0x1a8785(0x507)]=function(){const _0x382d6b=_0x1a8785;if(this[_0x382d6b(0x9ef)]==='all\x20actors')return![];if(this['_targetBattlerKey']==='all\x20enemies')return![];if(!this[_0x382d6b(0xae2)]&&this[_0x382d6b(0x9ba)]()[_0x382d6b(0x7c7)]())return![];if(this['isCustomBattleScope']())return!![];if(!this[_0x382d6b(0x7e0)]())return![];return typeof this[_0x382d6b(0x7e0)]()[_0x382d6b(0x502)]==='string';},VisuMZ['BattleCore'][_0x1a8785(0xac0)]=Game_Action[_0x1a8785(0x978)][_0x1a8785(0x7b9)],Game_Action[_0x1a8785(0x978)][_0x1a8785(0x7b9)]=function(){const _0x18e548=_0x1a8785;if(this[_0x18e548(0x9ef)]==='all\x20actors')return![];if(this['_targetBattlerKey']===_0x18e548(0x398))return!![];return this[_0x18e548(0x507)]()&&!this[_0x18e548(0x85d)]()?this[_0x18e548(0x3fe)]():VisuMZ[_0x18e548(0x83c)][_0x18e548(0xac0)]['call'](this);},Game_Action[_0x1a8785(0x978)][_0x1a8785(0x3fe)]=function(){const _0x13a76b=_0x1a8785,_0x137d0d=this[_0x13a76b(0x7e0)]()[_0x13a76b(0x502)];return _0x137d0d[_0x13a76b(0x9e0)](/(?:ENEMY|ENEMIES|FOE|FOES)/i);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x674)]=Game_Action['prototype'][_0x1a8785(0x734)],Game_Action['prototype']['isForFriend']=function(){const _0xaa67ff=_0x1a8785;if(this[_0xaa67ff(0x9ef)]===_0xaa67ff(0x9d1))return!![];if(this[_0xaa67ff(0x9ef)]===_0xaa67ff(0x398))return![];return this[_0xaa67ff(0x507)]()&&!this[_0xaa67ff(0x85d)]()?this[_0xaa67ff(0x52a)]():VisuMZ['BattleCore'][_0xaa67ff(0x674)][_0xaa67ff(0x716)](this);},Game_Action[_0x1a8785(0x978)][_0x1a8785(0x52a)]=function(){const _0x5140f2=_0x1a8785,_0x340074=this['item']()[_0x5140f2(0x502)];return _0x340074[_0x5140f2(0x9e0)](/(?:ALLY|ALLIES|FRIEND|FRIENDS)/i);},Game_Action[_0x1a8785(0x978)][_0x1a8785(0x50d)]=function(){const _0xa16716=_0x1a8785;if(this[_0xa16716(0x507)]()&&!this[_0xa16716(0x85d)]()){const _0x4aa01f=this[_0xa16716(0x7e0)]()[_0xa16716(0x502)];return _0x4aa01f[_0xa16716(0x9e0)](/(?:ENEMY|FOE)/i)&&_0x4aa01f[_0xa16716(0x9e0)](/OR/i)&&_0x4aa01f['match'](/(?:ALLY|FRIEND)/i);}else return![];},Game_Action['prototype'][_0x1a8785(0x42c)]=function(){const _0x49dc2b=_0x1a8785;if(this['isForAnyone']()){const _0x593fa7=this['item']()[_0x49dc2b(0x502)];if(_0x593fa7[_0x49dc2b(0x9e0)](/(?:ALLY|FRIEND) OR (?:ENEMY|FOE)/i))return!![];}return![];},Game_Action['prototype'][_0x1a8785(0x597)]=function(){const _0x259bde=_0x1a8785;if(this[_0x259bde(0x50d)]()){const _0x34d461=this['item']()[_0x259bde(0x502)];if(_0x34d461['match'](/(?:ENEMY|FOE) OR (?:ALLY|FRIEND)/i))return!![];}return![];},VisuMZ[_0x1a8785(0x83c)]['Game_Action_isForAliveFriend']=Game_Action[_0x1a8785(0x978)]['isForAliveFriend'],Game_Action[_0x1a8785(0x978)][_0x1a8785(0x58b)]=function(){const _0x44d984=_0x1a8785;return this[_0x44d984(0x507)]()&&!this[_0x44d984(0x85d)]()?this['isForAliveFriendBattleCore']():VisuMZ[_0x44d984(0x83c)][_0x44d984(0x82d)][_0x44d984(0x716)](this);},Game_Action[_0x1a8785(0x978)][_0x1a8785(0x663)]=function(){const _0x4558bb=_0x1a8785;if(this[_0x4558bb(0x50d)]())return!![];return![];},Game_Action[_0x1a8785(0x978)][_0x1a8785(0x9fb)]=function(){const _0x599491=_0x1a8785;return this[_0x599491(0x7e0)]()&&this[_0x599491(0x7e0)]()[_0x599491(0x9c6)]['match'](/<CANNOT TARGET (?:USER|SELF)>/i);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x7c8)]=Game_Action[_0x1a8785(0x978)]['isForOne'],Game_Action['prototype'][_0x1a8785(0xacc)]=function(){const _0xe1104e=_0x1a8785;if(this[_0xe1104e(0x9ef)]===_0xe1104e(0x9d1))return![];if(this['_targetBattlerKey']===_0xe1104e(0x398))return![];return this[_0xe1104e(0x507)]()&&!this['isCustomBattleScope']()?this[_0xe1104e(0x83f)]():VisuMZ['BattleCore']['Game_Action_isForOne']['call'](this);},Game_Action['prototype']['isForOneBattleCore']=function(){const _0x23df23=_0x1a8785;if(this[_0x23df23(0x50d)]())return!![];return![];},VisuMZ[_0x1a8785(0x83c)]['Game_Action_isForRandom']=Game_Action[_0x1a8785(0x978)][_0x1a8785(0x96f)],Game_Action['prototype'][_0x1a8785(0x96f)]=function(){const _0x195c2f=_0x1a8785;if(this[_0x195c2f(0x9ef)]===_0x195c2f(0x9d1))return![];if(this[_0x195c2f(0x9ef)]===_0x195c2f(0x398))return![];return this[_0x195c2f(0x507)]()&&!this['isCustomBattleScope']()?this['isForRandomBattleCore']():VisuMZ[_0x195c2f(0x83c)]['Game_Action_isForRandom'][_0x195c2f(0x716)](this);},Game_Action[_0x1a8785(0x978)][_0x1a8785(0x98f)]=function(){const _0x2d2c36=_0x1a8785,_0x4f9d4a=this[_0x2d2c36(0x7e0)]()[_0x2d2c36(0x502)];return _0x4f9d4a[_0x2d2c36(0x9e0)](/(?:RAND|RANDOM)/i);},VisuMZ['BattleCore']['Game_Action_isForAll']=Game_Action['prototype']['isForAll'],Game_Action['prototype']['isForAll']=function(){const _0x18a16f=_0x1a8785;if(this[_0x18a16f(0x9ef)]==='all\x20actors')return!![];if(this['_targetBattlerKey']===_0x18a16f(0x398))return!![];return VisuMZ[_0x18a16f(0x83c)][_0x18a16f(0x3ea)][_0x18a16f(0x716)](this);},Game_Action[_0x1a8785(0x978)][_0x1a8785(0x97e)]=function(){const _0x178560=_0x1a8785;if(!this[_0x178560(0x7e0)]())return![];if(this[_0x178560(0x3bb)]())return![];return(this[_0x178560(0x7e0)]()[_0x178560(0x9c6)]||'')[_0x178560(0x9e0)](/<SINGLE OR MULTIPLE SELECT>/i);},VisuMZ['BattleCore'][_0x1a8785(0x1ce)]=Game_Action[_0x1a8785(0x978)][_0x1a8785(0x8b9)],Game_Action[_0x1a8785(0x978)]['testApply']=function(_0x5051dd){const _0x54efe3=_0x1a8785;if(this['isForNotUser']()&&_0x5051dd===this[_0x54efe3(0x9ba)]())return![];return VisuMZ[_0x54efe3(0x83c)]['Game_Action_testApply'][_0x54efe3(0x716)](this,_0x5051dd);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x3cb)]=Game_Action['prototype'][_0x1a8785(0xabb)],Game_Action[_0x1a8785(0x978)][_0x1a8785(0xabb)]=function(){const _0x4dcfc8=_0x1a8785,_0x4cbb49=VisuMZ[_0x4dcfc8(0x83c)]['Game_Action_itemTargetCandidates'][_0x4dcfc8(0x716)](this);if(this[_0x4dcfc8(0x9fb)]())_0x4cbb49['remove'](this[_0x4dcfc8(0x9ba)]());return _0x4cbb49;},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x60d)]=Game_Action['prototype'][_0x1a8785(0xad2)],Game_Action['prototype'][_0x1a8785(0xad2)]=function(){const _0x4120a7=_0x1a8785;return this[_0x4120a7(0x507)]()&&!this[_0x4120a7(0x85d)]()?this[_0x4120a7(0x6a1)]():VisuMZ[_0x4120a7(0x83c)][_0x4120a7(0x60d)]['call'](this);},Game_Action[_0x1a8785(0x978)][_0x1a8785(0x6a1)]=function(){const _0x1eb054=_0x1a8785,_0x52a4ea=this[_0x1eb054(0x7e0)]()[_0x1eb054(0x502)];if(_0x52a4ea[_0x1eb054(0x9e0)](/RANDOM/i))return![];if(_0x52a4ea[_0x1eb054(0x9e0)](/ALL (?:ALLY|ALLIES|FRIEND|FRIENDS)/i))return![];if(_0x52a4ea['match'](/ALL (?:ENEMY|ENEMIES|FOE|FOES)/i))return![];if(_0x52a4ea[_0x1eb054(0x9e0)](/(?:ENEMY|FOE) OR (?:ALLY|FRIEND)/i))return!![];if(_0x52a4ea[_0x1eb054(0x9e0)](/(?:ALLY|FRIEND) OR (?:ENEMY|FOE)/i))return!![];return VisuMZ[_0x1eb054(0x83c)][_0x1eb054(0x60d)]['call'](this);},VisuMZ[_0x1a8785(0x83c)]['Game_Action_makeTargets']=Game_Action[_0x1a8785(0x978)][_0x1a8785(0x84a)],Game_Action[_0x1a8785(0x978)][_0x1a8785(0x84a)]=function(){const _0x12e31a=_0x1a8785;let _0x1752f6=[];return this[_0x12e31a(0x507)]()?this[_0x12e31a(0x85d)]()?_0x1752f6=this[_0x12e31a(0xa80)]():_0x1752f6=this[_0x12e31a(0x4f4)]():_0x1752f6=VisuMZ[_0x12e31a(0x83c)][_0x12e31a(0x553)][_0x12e31a(0x716)](this),_0x1752f6=this['applyTargetFilters'](_0x1752f6),_0x1752f6;},Game_Action['prototype']['isSubjectValidForAnyoneSelect']=function(){const _0x5a3c5b=_0x1a8785;return this[_0x5a3c5b(0x9ba)]()[_0x5a3c5b(0x68d)]()&&!this['subject']()[_0x5a3c5b(0xad5)]();},Game_Action[_0x1a8785(0x978)]['makeTargetsBattleCoreJS']=function(){const _0xe41d5a=_0x1a8785,_0x15f90e=VisuMZ['BattleCore'][_0xe41d5a(0x30b)](this[_0xe41d5a(0x7e0)](),_0xe41d5a(0x7f7));if(VisuMZ['BattleCore']['JS'][_0x15f90e]){targets=VisuMZ[_0xe41d5a(0x83c)]['Game_Action_makeTargets'][_0xe41d5a(0x716)](this);const _0x1db94c=VisuMZ[_0xe41d5a(0x83c)]['createKeyJS'](this[_0xe41d5a(0x7e0)](),_0xe41d5a(0x7f7));return targets=VisuMZ[_0xe41d5a(0x83c)]['JS'][_0x1db94c][_0xe41d5a(0x716)](this,this[_0xe41d5a(0x9ba)](),targets),this[_0xe41d5a(0x95d)](targets);}return this[_0xe41d5a(0x4f4)]();},Game_Action[_0x1a8785(0x978)][_0x1a8785(0x4f4)]=function(){const _0x599339=_0x1a8785;let _0x2fbd76=[];const _0x3afa84=String(this['item']()[_0x599339(0x502)]);if(this[_0x599339(0x597)]())return this[_0x599339(0x586)]()?(_0x2fbd76=this['getBattlerKeyTargets'](),this['repeatTargets'](_0x2fbd76)):(this[_0x599339(0x721)]=-0x1,_0x2fbd76[_0x599339(0x963)](...this[_0x599339(0x92a)]()),this[_0x599339(0x95d)](_0x2fbd76));if(this[_0x599339(0x42c)]()){if(this[_0x599339(0x586)]())return _0x2fbd76=this[_0x599339(0x8af)](),this[_0x599339(0x95d)](_0x2fbd76);else{if(Imported['VisuMZ_3_BattleAI']){if(VisuMZ['BattleAI'][_0x599339(0xa23)]<1.19){let _0x43864e='';_0x43864e+=_0x599339(0xacf),_0x43864e+=_0x599339(0x953),_0x43864e+=_0x599339(0x857),alert(_0x43864e),SceneManager['exit']();}}return this[_0x599339(0x721)]=-0x1,_0x2fbd76[_0x599339(0x963)](...this['targetsForFriends']()),this[_0x599339(0x95d)](_0x2fbd76);}}if(_0x3afa84[_0x599339(0x9e0)](/(\d+) RANDOM ANY/i)){let _0x3c935b=Number(RegExp['$1']);while(_0x3c935b--){const _0xaefa37=Math[_0x599339(0x526)](0x2)===0x0?this[_0x599339(0xab4)]():this[_0x599339(0xb04)]();_0x2fbd76['push'](_0xaefa37[_0x599339(0x96a)]());}return this[_0x599339(0x95d)](_0x2fbd76);}if(_0x3afa84['match'](/(\d+) RANDOM (?:ENEMY|ENEMIES|FOE|FOES)/i)){let _0x1ea5fd=Number(RegExp['$1']);while(_0x1ea5fd--){_0x2fbd76[_0x599339(0x963)](this[_0x599339(0xab4)]()[_0x599339(0x96a)]());}return this[_0x599339(0x95d)](_0x2fbd76);}if(_0x3afa84['match'](/(\d+) RANDOM (?:ALLY|ALLIES|FRIEND|FRIENDS)/i)){let _0x1258ce=Number(RegExp['$1']);while(_0x1258ce--){_0x2fbd76[_0x599339(0x963)](this[_0x599339(0xb04)]()[_0x599339(0x96a)]());}return this[_0x599339(0x95d)](_0x2fbd76);}if(_0x3afa84['match'](/ALL (?:ALLY|ALLIES|FRIEND|FRIENDS) (?:BUT|EXCEPT) (?:USER|SELF)/i))return _0x2fbd76['push'](...this[_0x599339(0xb04)]()[_0x599339(0x7b2)]()[_0x599339(0x70f)](_0x59bba9=>_0x59bba9!==this['subject']())),this[_0x599339(0x95d)](_0x2fbd76);return VisuMZ[_0x599339(0x83c)][_0x599339(0x553)][_0x599339(0x716)](this);},Game_Action[_0x1a8785(0x978)][_0x1a8785(0x870)]=function(_0x5c08dd){const _0x509fd9=_0x1a8785,_0x31184b=[];for(let _0x9ca0ff=0x0;_0x9ca0ff<this[_0x509fd9(0x188)]();_0x9ca0ff++){_0x31184b[_0x509fd9(0x963)](_0x5c08dd['trueRandomTarget']());}return _0x31184b;},Game_Action[_0x1a8785(0x978)][_0x1a8785(0x783)]=function(_0x5f5c12){const _0x23d1b2=_0x1a8785;if(!this[_0x23d1b2(0x7e0)]())return _0x5f5c12;const _0x2d88f9=this[_0x23d1b2(0x7e0)]()[_0x23d1b2(0x9c6)];if(this[_0x23d1b2(0x9fb)]()){this[_0x23d1b2(0xa5f)]()&&_0x5f5c12[_0x23d1b2(0xa3b)](this['subject']());if(_0x5f5c12[_0x23d1b2(0xa3e)](this[_0x23d1b2(0x9ba)]())){const _0x226ec4=this['friendsUnit']()[_0x23d1b2(0x7b2)]()[_0x23d1b2(0xa3b)](this[_0x23d1b2(0x9ba)]());if(_0x226ec4[_0x23d1b2(0x2dc)]>0x0){_0x226ec4[_0x23d1b2(0x836)]((_0x25cf5f,_0x3e3f7f)=>_0x25cf5f[_0x23d1b2(0x197)]()-_0x3e3f7f[_0x23d1b2(0x197)]());while(_0x5f5c12[_0x23d1b2(0xa3e)](this[_0x23d1b2(0x9ba)]())){const _0x11130e=_0x5f5c12[_0x23d1b2(0x64f)](this[_0x23d1b2(0x9ba)]());_0x5f5c12[_0x11130e]=_0x226ec4[Math[_0x23d1b2(0x526)](_0x226ec4[_0x23d1b2(0x2dc)])];}}else _0x5f5c12[_0x23d1b2(0xa3b)](this[_0x23d1b2(0x9ba)]());}}return _0x5f5c12;},VisuMZ['BattleCore'][_0x1a8785(0x8dd)]=Game_Action[_0x1a8785(0x978)]['itemEffectAddAttackState'],Game_Action['prototype'][_0x1a8785(0x9be)]=function(_0x2dea2f,_0x15486a){const _0x488c42=_0x1a8785;VisuMZ[_0x488c42(0x83c)]['Game_Action_itemEffectAddAttackState'][_0x488c42(0x716)](this,_0x2dea2f,_0x15486a);if(!_0x2dea2f['isImmortal']())return;for(const _0x15fdc4 of this[_0x488c42(0x9ba)]()[_0x488c42(0x366)]()){if(_0x15fdc4===_0x2dea2f[_0x488c42(0x7f9)]()){let _0xb6d48d=_0x15486a[_0x488c42(0x221)];_0xb6d48d*=_0x2dea2f[_0x488c42(0xa8d)](_0x15fdc4),_0xb6d48d*=this[_0x488c42(0x9ba)]()['attackStatesRate'](_0x15fdc4),_0xb6d48d*=this[_0x488c42(0xad4)](_0x2dea2f),Math[_0x488c42(0x876)]()<_0xb6d48d&&(_0x2dea2f['_deathStateApplied']=!![],this[_0x488c42(0x837)](_0x2dea2f));}}},VisuMZ[_0x1a8785(0x83c)]['Game_Action_itemEffectAddNormalState']=Game_Action['prototype']['itemEffectAddNormalState'],Game_Action[_0x1a8785(0x978)][_0x1a8785(0x91c)]=function(_0x5b1b8c,_0x364cbd){const _0x42492f=_0x1a8785;VisuMZ[_0x42492f(0x83c)][_0x42492f(0x231)]['call'](this,_0x5b1b8c,_0x364cbd);if(!_0x5b1b8c[_0x42492f(0x5e4)]())return;if(_0x364cbd[_0x42492f(0x478)]!==_0x5b1b8c[_0x42492f(0x7f9)]())return;let _0x2227c5=_0x364cbd[_0x42492f(0x221)];!this[_0x42492f(0x3f7)]()&&(_0x2227c5*=_0x5b1b8c[_0x42492f(0xa8d)](_0x364cbd[_0x42492f(0x478)]),_0x2227c5*=this[_0x42492f(0xad4)](_0x5b1b8c)),Math[_0x42492f(0x876)]()<_0x2227c5&&(_0x5b1b8c[_0x42492f(0xae6)]=!![],this[_0x42492f(0x837)](_0x5b1b8c));},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x324)]=Game_Action[_0x1a8785(0x978)][_0x1a8785(0x55c)],Game_Action['prototype'][_0x1a8785(0x55c)]=function(){const _0x5a691d=_0x1a8785;VisuMZ['BattleCore'][_0x5a691d(0x324)][_0x5a691d(0x716)](this),this[_0x5a691d(0x4bd)](),this['resetResultSwitches']();},Game_Action['prototype'][_0x1a8785(0x4bd)]=function(){const _0xcf65b4=_0x1a8785;if(!SceneManager[_0xcf65b4(0x3a8)]())return;const _0x4ac7fc=/<COMMON (?:EVENT|EVENTS):[ ](.*)>/gi,_0x218dcc=this[_0xcf65b4(0x7e0)]()['note'][_0xcf65b4(0x9e0)](_0x4ac7fc);if(_0x218dcc)for(const _0x177ab8 of _0x218dcc){if(!_0x177ab8)continue;_0x177ab8[_0xcf65b4(0x9e0)](_0x4ac7fc);const _0x464fa3=String(RegExp['$1'])[_0xcf65b4(0x2d7)](',')[_0xcf65b4(0x628)](_0x39ff74=>String(_0x39ff74)[_0xcf65b4(0x6b6)]()),_0x2a6cfc=_0x464fa3[_0xcf65b4(0x628)](_0x54df5c=>DataManager[_0xcf65b4(0x9cd)](_0x54df5c));for(const _0x59fd4c of _0x2a6cfc){const _0xc6beb0=$dataCommonEvents[_0x59fd4c];_0xc6beb0&&$gameTemp[_0xcf65b4(0x93f)](_0x59fd4c);}}},DataManager[_0x1a8785(0x9cd)]=function(_0x42844e){const _0x4e8316=_0x1a8785;_0x42844e=_0x42844e[_0x4e8316(0x830)]()['trim'](),this[_0x4e8316(0x4da)]=this[_0x4e8316(0x4da)]||{};if(this[_0x4e8316(0x4da)][_0x42844e])return this['_commonEventIDs'][_0x42844e];for(const _0x21e176 of $dataCommonEvents){if(!_0x21e176)continue;let _0x4594e3=_0x21e176['name'];_0x4594e3=_0x4594e3[_0x4e8316(0x555)](/\x1I\[(\d+)\]/gi,''),_0x4594e3=_0x4594e3[_0x4e8316(0x555)](/\\I\[(\d+)\]/gi,''),this[_0x4e8316(0x4da)][_0x4594e3['toUpperCase']()[_0x4e8316(0x6b6)]()]=_0x21e176['id'];}return this[_0x4e8316(0x4da)][_0x42844e]||0x0;},Game_Action['prototype'][_0x1a8785(0x547)]=function(){const _0x4fd8d2=_0x1a8785;if(!SceneManager[_0x4fd8d2(0x3a8)]())return;const _0x4d40c2=VisuMZ[_0x4fd8d2(0x83c)][_0x4fd8d2(0x9a7)][_0x4fd8d2(0x1af)];_0x4d40c2[_0x4fd8d2(0x945)]&&$gameSwitches['setValue'](_0x4d40c2[_0x4fd8d2(0x945)],![]),_0x4d40c2[_0x4fd8d2(0x685)]&&$gameSwitches[_0x4fd8d2(0x3eb)](_0x4d40c2[_0x4fd8d2(0x685)],![]),_0x4d40c2[_0x4fd8d2(0x9d8)]&&$gameVariables[_0x4fd8d2(0x3eb)](_0x4d40c2[_0x4fd8d2(0x9d8)],0x0),_0x4d40c2['VariableHeal']&&$gameVariables['setValue'](_0x4d40c2[_0x4fd8d2(0x52d)],0x0);},Game_Action[_0x1a8785(0x978)][_0x1a8785(0x297)]=function(_0x5cd834){const _0x3a99a8=_0x1a8785;if(!SceneManager[_0x3a99a8(0x3a8)]())return;if(!_0x5cd834)return;const _0x99a661=_0x5cd834[_0x3a99a8(0x97a)](),_0x46d866=VisuMZ['BattleCore']['Settings'][_0x3a99a8(0x1af)];_0x46d866[_0x3a99a8(0x945)]&&_0x99a661[_0x3a99a8(0x9fe)]&&$gameSwitches[_0x3a99a8(0x3eb)](_0x46d866[_0x3a99a8(0x945)],!![]);_0x46d866[_0x3a99a8(0x685)]&&(_0x99a661[_0x3a99a8(0x6ee)]||_0x99a661[_0x3a99a8(0xb03)])&&$gameSwitches[_0x3a99a8(0x3eb)](_0x46d866[_0x3a99a8(0x685)],!![]);if(_0x46d866[_0x3a99a8(0x9d8)]){let _0x1b6c86=$gameVariables[_0x3a99a8(0x9e5)](_0x46d866['VariableDmg']);_0x99a661['hpDamage']>0x0&&(_0x1b6c86+=Math[_0x3a99a8(0x73f)](_0x99a661['hpDamage'])),$gameVariables[_0x3a99a8(0x3eb)](_0x46d866[_0x3a99a8(0x9d8)],_0x1b6c86);}if(_0x46d866[_0x3a99a8(0x52d)]){let _0x3bc749=$gameVariables[_0x3a99a8(0x9e5)](_0x46d866[_0x3a99a8(0x52d)]);_0x99a661[_0x3a99a8(0x981)]<0x0&&(_0x3bc749+=Math[_0x3a99a8(0x73f)](_0x99a661[_0x3a99a8(0x981)])),$gameVariables[_0x3a99a8(0x3eb)](_0x46d866[_0x3a99a8(0x52d)],_0x3bc749);}},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0xa76)]={'lifeSteaItem':/<(.*?) (?:LIFE|MANA) STEAL:[ ](\d+)([%％])>/gi,'lifeStealTrait':/<(.*?) (?:LIFE|MANA) STEAL (.*?):[ ]([\+\-]\d+)([%％])>/gi,'cancelLifeSteal':/<CANCEL LIFE STEAL>/i,'cancelHpLifeSteal':/<CANCEL HP LIFE STEAL>/i,'cancelMpLifeSteal':/<CANCEL MP LIFE STEAL>/i,'guardLifeSteal':/<GUARD LIFE STEAL>/i,'guardHpLifeSteal':/<GUARD HP LIFE STEAL>/i,'guardMpLifeSteal':/<GUARD MP LIFE STEAL>/i,'disarmLifeSteal':/<DISARM LIFE STEAL>/i,'disarmHpLifeSteal':/<DISARM HP LIFE STEAL>/i,'disarmMpLifeSteal':/<DISARM MP LIFE STEAL>/i,'negativeLifeSteal':/<REVERSE LIFE STEAL>/i,'negativeHpLifeSteal':/<REVERSE HP LIFE STEAL>/i,'negativeMpLifeSteal':/<REVERSE MP LIFE STEAL>/i},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x384)]=Game_Action[_0x1a8785(0x978)][_0x1a8785(0x60f)],Game_Action[_0x1a8785(0x978)][_0x1a8785(0x60f)]=function(_0x1e75fb,_0x4c004b){const _0x3e3605=_0x1a8785;VisuMZ[_0x3e3605(0x83c)]['Game_Action_executeHpDamage'][_0x3e3605(0x716)](this,_0x1e75fb,_0x4c004b),!this[_0x3e3605(0x5fb)]()&&_0x1e75fb&&_0x1e75fb[_0x3e3605(0x97a)]()[_0x3e3605(0x981)]>0x0&&this[_0x3e3605(0x4e5)]('HP',_0x1e75fb,_0x1e75fb[_0x3e3605(0x97a)]()['hpDamage']);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x9c8)]=Game_Action[_0x1a8785(0x978)]['executeMpDamage'],Game_Action['prototype'][_0x1a8785(0x552)]=function(_0x4878e9,_0x4ee046){const _0x2674ec=_0x1a8785;VisuMZ[_0x2674ec(0x83c)]['Game_Action_executeMpDamage'][_0x2674ec(0x716)](this,_0x4878e9,_0x4ee046),!this[_0x2674ec(0x5fb)]()&&_0x4878e9&&_0x4878e9[_0x2674ec(0x97a)]()['mpDamage']>0x0&&this[_0x2674ec(0x4e5)]('MP',_0x4878e9,_0x4878e9[_0x2674ec(0x97a)]()['mpDamage']);},Game_Action[_0x1a8785(0x978)][_0x1a8785(0x4e5)]=function(_0x563054,_0x341429,_0x1ac7e4){const _0x130b0c=_0x1a8785;_0x563054=_0x563054[_0x130b0c(0x830)]()[_0x130b0c(0x6b6)]();const _0x5be4e0=this[_0x130b0c(0x840)](_0x563054,_0x341429);if(_0x5be4e0<=0x0)return;const _0x3f9931=Math[_0x130b0c(0x86d)](_0x1ac7e4*_0x5be4e0);if(_0x3f9931<=0x0)return;let _0x22fba2=this[_0x130b0c(0x9ba)]();if(this['_reflectionTarget'])_0x22fba2=this[_0x130b0c(0x56e)];const _0x18391a=_0x341429[_0x130b0c(0x884)](_0x563054)?-0x1:0x1;if(_0x563054==='HP')_0x22fba2[_0x130b0c(0x9a2)](_0x18391a*_0x3f9931);if(_0x563054==='MP')_0x22fba2[_0x130b0c(0x48d)](_0x18391a*_0x3f9931);},Game_Action[_0x1a8785(0x978)]['lifeStealRate']=function(_0x2a4e38,_0x11be04){const _0x218c0a=_0x1a8785;if(this['isCancelLifeSteal'](_0x2a4e38))return 0x0;if(this[_0x218c0a(0x9ba)]()['isDisarmLifeSteal'](_0x2a4e38))return 0x0;if(_0x11be04['isGuardLifeSteal'](_0x2a4e38))return 0x0;let _0x56a44d=0x0;return _0x56a44d+=this[_0x218c0a(0x23c)](_0x2a4e38),_0x56a44d+=this[_0x218c0a(0x9ba)]()[_0x218c0a(0x840)](_0x2a4e38,this[_0x218c0a(0x7e0)]()[_0x218c0a(0x24c)]),_0x56a44d['clamp'](0x0,0x1);},Game_Action[_0x1a8785(0x978)][_0x1a8785(0x4a8)]=function(_0x1e6850){const _0x4fff88=_0x1a8785;_0x1e6850=_0x1e6850[_0x4fff88(0x830)]()['trim']();const _0x2560d9=VisuMZ[_0x4fff88(0x83c)]['LifeStealRegExp'],_0x5a4034=this['item']()[_0x4fff88(0x9c6)]||'';if(_0x5a4034['match'](_0x2560d9['cancelLifeSteal']))return!![];if(_0x1e6850==='HP'&&_0x5a4034[_0x4fff88(0x9e0)](_0x2560d9[_0x4fff88(0x29a)]))return!![];if(_0x1e6850==='MP'&&_0x5a4034['match'](_0x2560d9[_0x4fff88(0x2e5)]))return!![];return![];},Game_Action[_0x1a8785(0x978)][_0x1a8785(0x23c)]=function(_0x50b4e1){const _0x206f06=_0x1a8785,_0x265046=VisuMZ[_0x206f06(0x83c)][_0x206f06(0xa76)],_0x598a16=this['item']()[_0x206f06(0x9c6)]||'';_0x50b4e1=_0x50b4e1[_0x206f06(0x830)]()[_0x206f06(0x6b6)]();const _0x4cee1b=_0x598a16[_0x206f06(0x9e0)](_0x265046[_0x206f06(0x450)]);if(_0x4cee1b)for(const _0x1845a7 of _0x4cee1b){_0x1845a7[_0x206f06(0x9e0)](_0x265046['lifeSteaItem']);const _0x314b66=String(RegExp['$1'])['toUpperCase']()[_0x206f06(0x6b6)](),_0x475669=Number(RegExp['$2'])*0.01;if(_0x314b66!==_0x50b4e1)continue;return _0x475669;}return 0x0;},Game_BattlerBase[_0x1a8785(0x978)][_0x1a8785(0x840)]=function(_0x5512b5,_0x48cc58){const _0x3f32f9=_0x1a8785,_0xf2937e=VisuMZ['BattleCore'][_0x3f32f9(0xa76)];let _0x2871d3=0x0;_0x5512b5=_0x5512b5[_0x3f32f9(0x830)]()[_0x3f32f9(0x6b6)]();for(const _0x166781 of this[_0x3f32f9(0x990)]()){if(!_0x166781)continue;const _0x338b97=_0x166781['note']||'',_0x1c35b1=_0x338b97[_0x3f32f9(0x9e0)](_0xf2937e[_0x3f32f9(0x5fa)]);if(_0x1c35b1)for(const _0x15fbde of _0x1c35b1){_0x15fbde[_0x3f32f9(0x9e0)](_0xf2937e['lifeStealTrait']);const _0x2487ad=String(RegExp['$1'])[_0x3f32f9(0x830)]()[_0x3f32f9(0x6b6)](),_0x131463=String(RegExp['$2']),_0x4a8c75=Number(RegExp['$3'])*0.01;if(_0x2487ad!==_0x5512b5)continue;if(_0x48cc58===Game_Action[_0x3f32f9(0x457)]&&_0x131463[_0x3f32f9(0x9e0)](/CERTAIN/i))_0x2871d3+=_0x4a8c75;else{if(_0x48cc58===Game_Action[_0x3f32f9(0x96c)]&&_0x131463[_0x3f32f9(0x9e0)](/PHYS/i))_0x2871d3+=_0x4a8c75;else _0x48cc58===Game_Action[_0x3f32f9(0x43e)]&&_0x131463[_0x3f32f9(0x9e0)](/MAGIC/i)&&(_0x2871d3+=_0x4a8c75);}}}return _0x2871d3;},Game_BattlerBase[_0x1a8785(0x978)]['isDisarmLifeSteal']=function(_0x18011c){const _0x3c34d5=_0x1a8785;_0x18011c=_0x18011c[_0x3c34d5(0x830)]()[_0x3c34d5(0x6b6)]();const _0x1dcefa=VisuMZ[_0x3c34d5(0x83c)][_0x3c34d5(0xa76)];for(const _0x5b752e of this['traitObjects']()){if(!_0x5b752e)continue;const _0x1bb151=_0x5b752e[_0x3c34d5(0x9c6)]||'';if(_0x1bb151['match'](_0x1dcefa[_0x3c34d5(0x575)]))return!![];if(_0x18011c==='HP'&&_0x1bb151[_0x3c34d5(0x9e0)](_0x1dcefa[_0x3c34d5(0x711)]))return!![];if(_0x18011c==='MP'&&_0x1bb151[_0x3c34d5(0x9e0)](_0x1dcefa['disarmMpLifeSteal']))return!![];}return![];},Game_BattlerBase['prototype'][_0x1a8785(0x884)]=function(_0x2a3bba){const _0x356c14=_0x1a8785;_0x2a3bba=_0x2a3bba[_0x356c14(0x830)]()[_0x356c14(0x6b6)]();const _0xf9e7d3=VisuMZ[_0x356c14(0x83c)]['LifeStealRegExp'];for(const _0x3723c9 of this[_0x356c14(0x990)]()){if(!_0x3723c9)continue;const _0x5efd4b=_0x3723c9[_0x356c14(0x9c6)]||'';if(_0x5efd4b['match'](_0xf9e7d3['negativeLifeSteal']))return!![];if(_0x2a3bba==='HP'&&_0x5efd4b['match'](_0xf9e7d3[_0x356c14(0x71e)]))return!![];if(_0x2a3bba==='MP'&&_0x5efd4b[_0x356c14(0x9e0)](_0xf9e7d3[_0x356c14(0x66d)]))return!![];}return![];},Game_BattlerBase['prototype'][_0x1a8785(0x6f3)]=function(_0x43f6e3){const _0x4e3e1b=_0x1a8785;_0x43f6e3=_0x43f6e3[_0x4e3e1b(0x830)]()[_0x4e3e1b(0x6b6)]();const _0x19791e=VisuMZ[_0x4e3e1b(0x83c)][_0x4e3e1b(0xa76)];for(const _0x2308f2 of this[_0x4e3e1b(0x990)]()){if(!_0x2308f2)continue;const _0x294963=_0x2308f2[_0x4e3e1b(0x9c6)]||'';if(_0x294963['match'](_0x19791e[_0x4e3e1b(0x3bd)]))return!![];if(_0x43f6e3==='HP'&&_0x294963['match'](_0x19791e[_0x4e3e1b(0x81e)]))return!![];if(_0x43f6e3==='MP'&&_0x294963[_0x4e3e1b(0x9e0)](_0x19791e[_0x4e3e1b(0x32c)]))return!![];}return![];},VisuMZ['BattleCore'][_0x1a8785(0x8f5)]=Game_BattlerBase[_0x1a8785(0x978)][_0x1a8785(0x9a3)],Game_BattlerBase[_0x1a8785(0x978)][_0x1a8785(0x9a3)]=function(){const _0x6dde63=_0x1a8785;VisuMZ[_0x6dde63(0x83c)]['Game_BattlerBase_initMembers'][_0x6dde63(0x716)](this),this[_0x6dde63(0x5c7)]();},Game_BattlerBase[_0x1a8785(0x978)]['initMembersBattleCore']=function(){const _0x3c6ee7=_0x1a8785;this[_0x3c6ee7(0x186)]=![];},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x25f)]=Game_BattlerBase[_0x1a8785(0x978)][_0x1a8785(0x4cd)],Game_BattlerBase['prototype'][_0x1a8785(0x4cd)]=function(){const _0x1a37cd=_0x1a8785;this['_cache']={},VisuMZ['BattleCore'][_0x1a37cd(0x25f)][_0x1a37cd(0x716)](this);},Game_BattlerBase['prototype'][_0x1a8785(0x4ce)]=function(_0x1abcbf){const _0xe561f4=_0x1a8785;return this[_0xe561f4(0x574)]=this[_0xe561f4(0x574)]||{},this[_0xe561f4(0x574)][_0x1abcbf]!==undefined;},Game_BattlerBase['prototype']['hardDamageCap']=function(){const _0x432889=_0x1a8785;if(this[_0x432889(0x574)][_0x432889(0xa02)]!==undefined)return this[_0x432889(0x574)][_0x432889(0xa02)];const _0x2a98c4=/<DAMAGE CAP:[ ](\d+)>/i,_0x2077df=this[_0x432889(0x990)]()[_0x432889(0x628)](_0x423b35=>_0x423b35&&_0x423b35[_0x432889(0x9c6)]['match'](_0x2a98c4)?Number(RegExp['$1']):0x0);let _0x5aba4e=_0x2077df[_0x432889(0x2dc)]>0x0?Math['max'](..._0x2077df):0x0;if(_0x5aba4e<=0x0)_0x5aba4e=VisuMZ['BattleCore'][_0x432889(0x9a7)][_0x432889(0xa19)][_0x432889(0x923)];return this['_cache'][_0x432889(0xa02)]=_0x5aba4e,this['_cache'][_0x432889(0xa02)];},Game_BattlerBase[_0x1a8785(0x978)][_0x1a8785(0x2bb)]=function(){const _0x1e75b=_0x1a8785;if(this['_cache']['softDamageCap']!==undefined)return this[_0x1e75b(0x574)][_0x1e75b(0x72b)];let _0x47c0b1=VisuMZ[_0x1e75b(0x83c)][_0x1e75b(0x9a7)][_0x1e75b(0xa19)][_0x1e75b(0x7f0)];const _0x20503b=/<SOFT DAMAGE CAP:[ ]([\+\-]\d+)([%％])>/i,_0x36d322=this['traitObjects']()[_0x1e75b(0x628)](_0x5b084a=>_0x5b084a&&_0x5b084a[_0x1e75b(0x9c6)][_0x1e75b(0x9e0)](_0x20503b)?Number(RegExp['$1'])/0x64:0x0);return _0x47c0b1=_0x36d322[_0x1e75b(0x220)]((_0xbdcaa2,_0x1867be)=>_0xbdcaa2+_0x1867be,_0x47c0b1),this[_0x1e75b(0x574)][_0x1e75b(0x72b)]=_0x47c0b1,this[_0x1e75b(0x574)][_0x1e75b(0x72b)][_0x1e75b(0x39c)](0.01,0x1);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x361)]=Game_BattlerBase[_0x1a8785(0x978)][_0x1a8785(0x602)],Game_BattlerBase['prototype'][_0x1a8785(0x602)]=function(){const _0x3afbc7=_0x1a8785;VisuMZ[_0x3afbc7(0x83c)]['Game_BattlerBase_die'][_0x3afbc7(0x716)](this),SceneManager[_0x3afbc7(0x3a8)]()&&this[_0x3afbc7(0x3a4)]('dead');},Game_BattlerBase[_0x1a8785(0x978)][_0x1a8785(0x89e)]=function(){const _0xe9ee40=_0x1a8785;if(!SceneManager[_0xe9ee40(0x3a8)]())return null;if(!SceneManager[_0xe9ee40(0xa42)]['_spriteset'])return null;return SceneManager[_0xe9ee40(0xa42)][_0xe9ee40(0x589)][_0xe9ee40(0x2d4)](this);},Game_BattlerBase[_0x1a8785(0x978)][_0x1a8785(0x191)]=function(){const _0x102538=_0x1a8785;return VisuMZ['BattleCore'][_0x102538(0x9a7)][_0x102538(0x1d0)][_0x102538(0xafc)];},Game_BattlerBase['prototype'][_0x1a8785(0x713)]=function(){const _0x32b2f7=_0x1a8785;return VisuMZ[_0x32b2f7(0x83c)][_0x32b2f7(0x9a7)][_0x32b2f7(0x1d0)][_0x32b2f7(0x53e)];},Game_BattlerBase['prototype'][_0x1a8785(0x2ad)]=function(){const _0x3e656b=_0x1a8785;return this[_0x3e656b(0x68d)]&&this['isActor']()?VisuMZ[_0x3e656b(0x83c)][_0x3e656b(0x9a7)][_0x3e656b(0x1d0)][_0x3e656b(0x73e)]:VisuMZ[_0x3e656b(0x83c)][_0x3e656b(0x9a7)]['Enemy'][_0x3e656b(0x73e)];},Game_BattlerBase[_0x1a8785(0x978)]['battlerSmoothImage']=function(){return!![];},Game_BattlerBase[_0x1a8785(0x978)]['battleUIOffsetX']=function(){return 0x0;},Game_BattlerBase[_0x1a8785(0x978)][_0x1a8785(0x260)]=function(){return 0x0;},Game_BattlerBase[_0x1a8785(0x978)][_0x1a8785(0xa91)]=function(_0x1a8cb1){const _0x18c966=_0x1a8785;if(!_0x1a8cb1)return 0x0;let _0x563c5e=0x0;const _0x472202=_0x1a8cb1[_0x18c966(0x9c6)];return _0x472202[_0x18c966(0x9e0)](/<BATTLE UI OFFSET X:[ ]([\+\-]\d+)>/i)&&(_0x563c5e+=Number(RegExp['$1'])),_0x472202[_0x18c966(0x9e0)](/<BATTLE UI OFFSET:[ ]([\+\-]\d+),[ ]([\+\-]\d+)>/i)&&(_0x563c5e+=Number(RegExp['$1'])),_0x563c5e;},Game_BattlerBase[_0x1a8785(0x978)][_0x1a8785(0x2a7)]=function(_0xbc8d9f){const _0x39b50f=_0x1a8785;if(!_0xbc8d9f)return 0x0;let _0x1def9e=0x0;const _0x18b016=_0xbc8d9f[_0x39b50f(0x9c6)];return _0x18b016[_0x39b50f(0x9e0)](/<BATTLE UI OFFSET Y:[ ]([\+\-]\d+)>/i)&&(_0x1def9e+=Number(RegExp['$1'])),_0x18b016['match'](/<BATTLE UI OFFSET:[ ]([\+\-]\d+),[ ]([\+\-]\d+)>/i)&&(_0x1def9e+=Number(RegExp['$2'])),_0x1def9e;},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x391)]=Game_BattlerBase[_0x1a8785(0x978)]['isStateResist'],Game_BattlerBase[_0x1a8785(0x978)]['isStateResist']=function(_0x1b5335){const _0x3f4fe8=_0x1a8785;if(_0x1b5335===this[_0x3f4fe8(0x7f9)]()&&this[_0x3f4fe8(0x5e4)]())return!![];return VisuMZ[_0x3f4fe8(0x83c)][_0x3f4fe8(0x391)][_0x3f4fe8(0x716)](this,_0x1b5335);},Game_BattlerBase[_0x1a8785(0x978)][_0x1a8785(0x5e4)]=function(){const _0x2d593a=_0x1a8785;return this[_0x2d593a(0x186)];},Game_BattlerBase[_0x1a8785(0x978)][_0x1a8785(0x1e1)]=function(_0x7abd11){_0x7abd11?this['addImmortal']():this['removeImmortal']();},Game_BattlerBase['prototype'][_0x1a8785(0x38c)]=function(){const _0x46a6d0=_0x1a8785;if(this[_0x46a6d0(0x37f)]())return;this['_immortal']=!![],this['_deathStateApplied']=![];},Game_BattlerBase['prototype'][_0x1a8785(0x6e5)]=function(){const _0x1cdec7=_0x1a8785,_0x257486=this['isAlive']();this[_0x1cdec7(0x186)]=![],_0x257486&&this[_0x1cdec7(0xae6)]&&this[_0x1cdec7(0x602)](),this['_deathStateApplied']=![],this['refresh'](),this[_0x1cdec7(0x37f)]()&&_0x257486&&(this['performCollapse'](),this[_0x1cdec7(0x7cb)]());},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x385)]=Game_Action[_0x1a8785(0x978)][_0x1a8785(0x8f4)],Game_Action[_0x1a8785(0x978)][_0x1a8785(0x8f4)]=function(){const _0x3e6092=_0x1a8785;return this['item']()?VisuMZ[_0x3e6092(0x83c)][_0x3e6092(0x385)]['call'](this):0x0;},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x41b)]=Game_Action[_0x1a8785(0x978)]['setAttack'],Game_Action[_0x1a8785(0x978)][_0x1a8785(0x2eb)]=function(){const _0x1e4668=_0x1a8785;this[_0x1e4668(0x9ba)]()&&this[_0x1e4668(0x9ba)]()[_0x1e4668(0x4ad)]()?VisuMZ[_0x1e4668(0x83c)][_0x1e4668(0x41b)][_0x1e4668(0x716)](this):this[_0x1e4668(0x1fb)]();},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x885)]=Game_BattlerBase[_0x1a8785(0x978)][_0x1a8785(0x4ad)],Game_BattlerBase['prototype'][_0x1a8785(0x4ad)]=function(){const _0x247a86=_0x1a8785;if(!this[_0x247a86(0x6e4)]())return![];return VisuMZ[_0x247a86(0x83c)][_0x247a86(0x885)][_0x247a86(0x716)](this);},Game_BattlerBase['prototype']['canAttackBattleCore']=function(){const _0x4562b4=_0x1a8785;for(const _0x3bc209 of this[_0x4562b4(0x990)]()){if(!_0x3bc209)continue;if(_0x3bc209[_0x4562b4(0x9c6)][_0x4562b4(0x9e0)](/<(?:ATTACK SEAL|SEAL ATTACK)>/i))return![];}return!![];},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x210)]=Game_Action['prototype'][_0x1a8785(0x4b1)],Game_Action[_0x1a8785(0x978)][_0x1a8785(0x4b1)]=function(){const _0x4fc2b1=_0x1a8785;this[_0x4fc2b1(0x9ba)]()[_0x4fc2b1(0x1b1)]()&&VisuMZ[_0x4fc2b1(0x83c)][_0x4fc2b1(0x210)]['call'](this);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x516)]=Game_BattlerBase['prototype'][_0x1a8785(0x1b1)],Game_BattlerBase[_0x1a8785(0x978)][_0x1a8785(0x1b1)]=function(){const _0x17e780=_0x1a8785;if(!this[_0x17e780(0x494)]())return![];return VisuMZ[_0x17e780(0x83c)][_0x17e780(0x516)][_0x17e780(0x716)](this);},Game_BattlerBase['prototype']['canGuardBattleCore']=function(){const _0x4cf921=_0x1a8785;for(const _0x1a0f78 of this[_0x4cf921(0x990)]()){if(!_0x1a0f78)continue;if(_0x1a0f78[_0x4cf921(0x9c6)][_0x4cf921(0x9e0)](/<(?:GUARD SEAL|SEAL GUARD)>/i))return![];}return!![];},Game_BattlerBase[_0x1a8785(0x978)][_0x1a8785(0x6d1)]=function(){const _0x22a946=_0x1a8785;for(const _0x491199 of this[_0x22a946(0x990)]()){if(!_0x491199)continue;if(_0x491199[_0x22a946(0x9c6)][_0x22a946(0x9e0)](/<(?:ITEM SEAL|SEAL ITEM|SEAL ITEMS)>/i))return![];}return!![];},VisuMZ['BattleCore'][_0x1a8785(0x325)]=Game_BattlerBase[_0x1a8785(0x978)][_0x1a8785(0x257)],Game_BattlerBase[_0x1a8785(0x978)][_0x1a8785(0x257)]=function(_0x54941f){const _0x42744a=_0x1a8785;if(_0x54941f&&_0x54941f['note'][_0x42744a(0x9e0)](/<CANNOT TARGET (?:USER|SELF)>/i)){const _0x536218=this['friendsUnit']()[_0x42744a(0x7b2)]();if(_0x536218[_0x42744a(0x2dc)]===0x1&&_0x536218[0x0]===this)return![];}return VisuMZ['BattleCore'][_0x42744a(0x325)]['call'](this,_0x54941f);},Game_Battler['prototype']['allowRandomSpeed']=function(){const _0x363019=_0x1a8785;return VisuMZ[_0x363019(0x83c)][_0x363019(0x9a7)][_0x363019(0x1af)][_0x363019(0x778)];},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x3c8)]=Game_Battler['prototype'][_0x1a8785(0x1a9)],Game_Battler['prototype']['regenerateAll']=function(){const _0x356836=_0x1a8785;if(SceneManager[_0x356836(0x3a8)]()){if(BattleManager[_0x356836(0x875)]()){if(this[_0x356836(0x4e4)]()<=0x0)return;}else{if($gameTroop[_0x356836(0x4e4)]()<=0x0)return;}}if(SceneManager[_0x356836(0x3a8)]()&&BattleManager['isTpb']()&&this[_0x356836(0x7b0)]===Graphics[_0x356836(0x699)])return;this[_0x356836(0x7b0)]=Graphics[_0x356836(0x699)],SceneManager['isSceneBattle']()&&this[_0x356836(0x3bc)]('PreRegenerateJS'),VisuMZ[_0x356836(0x83c)][_0x356836(0x3c8)][_0x356836(0x716)](this),SceneManager['isSceneBattle']()&&(this[_0x356836(0x5b6)](),this['processBattleCoreJS'](_0x356836(0x614)));},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x5b6)]=function(){const _0x39dfd1=_0x1a8785;if(SceneManager[_0x39dfd1(0x3a8)]())for(const _0x574f5e of this[_0x39dfd1(0x990)]()){if(!_0x574f5e)continue;this[_0x39dfd1(0x7ff)](_0x574f5e);}},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x7ff)]=function(_0x5e7a5a){const _0x388657=_0x1a8785;if(!Imported[_0x388657(0x211)])return;if(!SceneManager[_0x388657(0x3a8)]())return;if(this[_0x388657(0x37f)]())return;if(this[_0x388657(0xaef)]())return;if(_0x5e7a5a[_0x388657(0x9c6)]['match'](/<(?:REGENERATE|REGEN|DEGEN|DOT|SLIP)[ ]ANIMATION:[ ](\d+)>/i)){const _0x498605=Number(RegExp['$1']);$gameTemp[_0x388657(0x3ac)]([this],_0x498605,![],![]);}},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x219)]=Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x8f3)],Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x8f3)]=function(){const _0x1e8e29=_0x1a8785;this['processBattleCoreJS'](_0x1e8e29(0xa16)),VisuMZ[_0x1e8e29(0x83c)]['Game_Battler_startTpbTurn'][_0x1e8e29(0x716)](this),this['processBattleCoreJS']('PostStartTurnJS');},VisuMZ['BattleCore']['Game_Battler_onTurnEnd']=Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x676)],Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x676)]=function(){const _0x4a305b=_0x1a8785;this[_0x4a305b(0x3bc)]('PreEndTurnJS'),VisuMZ[_0x4a305b(0x83c)][_0x4a305b(0x1f4)][_0x4a305b(0x716)](this),this[_0x4a305b(0x3bc)]('PostEndTurnJS');},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x3bc)]=function(_0x2ed269){const _0x53af5c=_0x1a8785;if(this[_0x53af5c(0x1c0)]||this['_tempActor'])return;const _0x527129=VisuMZ[_0x53af5c(0x83c)][_0x53af5c(0x9a7)]['Mechanics'];if(_0x527129[_0x2ed269])_0x527129[_0x2ed269][_0x53af5c(0x716)](this);for(const _0x20aa81 of this['traitObjects']()){if(!_0x20aa81)continue;key=VisuMZ['BattleCore'][_0x53af5c(0x30b)](_0x20aa81,_0x2ed269),VisuMZ[_0x53af5c(0x83c)]['JS'][key]&&VisuMZ[_0x53af5c(0x83c)]['JS'][key]['call'](this,this,this,_0x20aa81,0x0);}},Game_Battler['prototype']['chantStyle']=function(){const _0x1e2625=_0x1a8785;return VisuMZ['BattleCore'][_0x1e2625(0x9a7)][_0x1e2625(0x1d0)]['ChantStyle']||![];},Game_Battler['prototype'][_0x1a8785(0x259)]=function(){const _0x5a372e=_0x1a8785;if(this[_0x5a372e(0x7fb)]()){if(this['chantStyle']()){if(this[_0x5a372e(0xa89)]['some'](_0x5720fb=>_0x5720fb['item']()&&_0x5720fb['isMagical']()))return!![];}else{if(this[_0x5a372e(0xa89)]['some'](_0x4a756c=>_0x4a756c[_0x5a372e(0x7e0)]()&&_0x4a756c[_0x5a372e(0x8d7)]()))return!![];}}if(BattleManager['isTpb']()&&this[_0x5a372e(0x20c)]===_0x5a372e(0x5f9))return this[_0x5a372e(0x5ac)]()?this['currentAction']()&&this[_0x5a372e(0x916)]()['item']()&&this[_0x5a372e(0x916)]()[_0x5a372e(0x5e5)]():this['currentAction']()&&this[_0x5a372e(0x916)]()[_0x5a372e(0x7e0)]()&&this[_0x5a372e(0x916)]()[_0x5a372e(0x8d7)]();return![];},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x887)]=function(){const _0x16d23c=_0x1a8785;if(BattleManager['isTpb']()&&this[_0x16d23c(0x20c)]===_0x16d23c(0x5f9))return this[_0x16d23c(0x5ac)]()?this[_0x16d23c(0x916)]()&&this['currentAction']()[_0x16d23c(0x7e0)]()&&!this[_0x16d23c(0x916)]()[_0x16d23c(0x5e5)]():this[_0x16d23c(0x916)]()&&this[_0x16d23c(0x916)]()[_0x16d23c(0x7e0)]()&&!this[_0x16d23c(0x916)]()[_0x16d23c(0x8d7)]();return![];},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x3ae)]=Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x57c)],Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x57c)]=function(){const _0x13f1d8=_0x1a8785;VisuMZ[_0x13f1d8(0x83c)][_0x13f1d8(0x3ae)][_0x13f1d8(0x716)](this),this[_0x13f1d8(0x3b9)]=[];},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0xae8)]=function(){const _0x3d813f=_0x1a8785;if(!this[_0x3d813f(0x3b9)])this[_0x3d813f(0x57c)]();return this[_0x3d813f(0x3b9)][_0x3d813f(0x2dc)]>0x0;},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x419)]=function(){const _0x2b8241=_0x1a8785;if(!SceneManager[_0x2b8241(0x3a8)]())return;if(BattleManager[_0x2b8241(0x495)]())return;if(!this[_0x2b8241(0x3b9)])this[_0x2b8241(0x57c)]();this[_0x2b8241(0x4e7)]();const _0x3d0105=this[_0x2b8241(0x89e)]();if(_0x3d0105)_0x3d0105[_0x2b8241(0x317)]();},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x4e7)]=function(){const _0x169093=_0x1a8785,_0x431189=this[_0x169093(0x97a)]();if(_0x431189[_0x169093(0x6ee)]||_0x431189['evaded']){const _0x50c39c=JsonEx['makeDeepCopy'](_0x431189);_0x50c39c[_0x169093(0x8b7)]=![],_0x50c39c[_0x169093(0x3ed)]=0x0,this[_0x169093(0x3b9)]['push'](_0x50c39c);}if(_0x431189[_0x169093(0x8b7)]){const _0x3104eb=JsonEx[_0x169093(0x950)](_0x431189);_0x3104eb[_0x169093(0x6ee)]=![],_0x3104eb[_0x169093(0xb03)]=![],_0x3104eb[_0x169093(0x3ed)]=0x0,this[_0x169093(0x3b9)][_0x169093(0x963)](_0x3104eb);}if(_0x431189[_0x169093(0x3ed)]!==0x0){const _0x198cbf=JsonEx[_0x169093(0x950)](_0x431189);_0x198cbf[_0x169093(0x6ee)]=![],_0x198cbf['evaded']=![],_0x198cbf['hpAffected']=![],this[_0x169093(0x3b9)][_0x169093(0x963)](_0x198cbf);}},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x32f)]=function(){const _0x3c08c3=_0x1a8785;if(!this[_0x3c08c3(0x3b9)])this[_0x3c08c3(0x57c)]();return VisuMZ[_0x3c08c3(0x83c)][_0x3c08c3(0x9a7)][_0x3c08c3(0xa19)][_0x3c08c3(0x8fb)]?this['_damagePopupArray'][_0x3c08c3(0x3e5)]():this[_0x3c08c3(0x3b9)][_0x3c08c3(0x925)]();},Game_Battler['prototype'][_0x1a8785(0x7ec)]=function(_0x4a0ba3,_0x80938b){const _0x42891f=_0x1a8785;if(!SceneManager[_0x42891f(0x3a8)]())return;if(BattleManager[_0x42891f(0x495)]())return;if(!this['battler']())return;if(_0x4a0ba3[_0x42891f(0x2dc)]<=0x0)return;_0x80938b=_0x80938b||{},_0x80938b[_0x42891f(0xaff)]=_0x80938b[_0x42891f(0xaff)]||_0x42891f(0x85e),_0x80938b[_0x42891f(0x940)]=_0x80938b[_0x42891f(0x940)]||[0x0,0x0,0x0,0x0],_0x80938b['flashDuration']=_0x80938b['flashDuration']||0x0,this[_0x42891f(0x89e)]()[_0x42891f(0x7ec)](_0x4a0ba3,_0x80938b);},Game_Battler['prototype'][_0x1a8785(0x1c3)]=function(_0x1cdc21,_0x56e397,_0x2efdf5){const _0xd23e0d=_0x1a8785;if(!SceneManager['isSceneBattle']())return;if(BattleManager[_0xd23e0d(0x495)]())return;if(!this[_0xd23e0d(0x89e)]())return;if(_0x56e397['length']<=0x0)return;_0x2efdf5=_0x2efdf5||{},_0x2efdf5['textColor']=_0x2efdf5[_0xd23e0d(0xaff)]||'#ffffff',_0x2efdf5[_0xd23e0d(0x940)]=_0x2efdf5['flashColor']||[0x0,0x0,0x0,0x0],_0x2efdf5['flashDuration']=_0x2efdf5[_0xd23e0d(0x29e)]||0x0,this[_0xd23e0d(0x89e)]()['setupIconTextPopup'](_0x1cdc21,_0x56e397,_0x2efdf5);},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x49b)]=function(){const _0x5e7578=_0x1a8785;if(this[_0x5e7578(0xaef)]())return![];if(this['isAlive']()&&this[_0x5e7578(0x46d)]())return!![];if(this[_0x5e7578(0x3a6)]()&&this[_0x5e7578(0x907)]()){if(this[_0x5e7578(0x37f)]()&&this['allowCollapse']())return![];}else{if(this[_0x5e7578(0x37f)]())return![];}return!![];},VisuMZ['BattleCore']['Game_Battler_clearMotion']=Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x752)],Game_Battler['prototype']['clearMotion']=function(){const _0xf493=_0x1a8785;VisuMZ[_0xf493(0x83c)][_0xf493(0x40d)][_0xf493(0x716)](this),this[_0xf493(0x302)]();},Game_Battler[_0x1a8785(0x978)]['canBattlerMove']=function(){return!![];},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x68a)]=function(){return![];},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x648)]=Game_Battler['prototype'][_0x1a8785(0x72f)],Game_Battler['prototype']['onBattleStart']=function(_0x3f6dcc){const _0x4dc815=_0x1a8785;VisuMZ[_0x4dc815(0x83c)][_0x4dc815(0x648)][_0x4dc815(0x716)](this,_0x3f6dcc),this['onBattleStartBattleCore'](_0x3f6dcc),this['clearDamagePopup']();},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x1ae)]=function(_0x2be2d6){const _0x43e730=_0x1a8785;this[_0x43e730(0x321)](![]),this[_0x43e730(0x424)]=undefined,this[_0x43e730(0x976)]=undefined;},VisuMZ[_0x1a8785(0x83c)]['Game_Battler_onBattleEnd']=Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x931)],Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x931)]=function(){const _0x271aaa=_0x1a8785;VisuMZ[_0x271aaa(0x83c)]['Game_Battler_onBattleEnd'][_0x271aaa(0x716)](this),this[_0x271aaa(0x4a0)]();},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x4a0)]=function(){const _0x2e4e24=_0x1a8785;this[_0x2e4e24(0x424)]=undefined,this['_forcedHomeY']=undefined;},VisuMZ[_0x1a8785(0x83c)]['Game_Battler_performActionStart']=Game_Battler['prototype'][_0x1a8785(0x80d)],Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x80d)]=function(_0x56d470){const _0x218034=_0x1a8785;VisuMZ[_0x218034(0x83c)][_0x218034(0x37b)][_0x218034(0x716)](this,_0x56d470);if(!_0x56d470['isGuard']()){const _0x84b0d3=this['battler']();_0x84b0d3&&_0x84b0d3[_0x218034(0x4b9)]();}this[_0x218034(0x321)](![]);},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x2ce)]=function(){const _0x8266e3=_0x1a8785,_0x568f0b=this['_flinched'];this['_flinched']=![];if(BattleManager[_0x8266e3(0x28e)]()&&this[_0x8266e3(0x99f)]()){const _0x11ca71=this[_0x8266e3(0x89e)]();if(_0x11ca71&&_0x568f0b)_0x11ca71['stepForward']();return;}const _0x55fdc8=this['battler']();if(_0x55fdc8)_0x55fdc8['stepBack']();this[_0x8266e3(0x321)](![]),this[_0x8266e3(0x7cb)]();},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x70e)]=function(_0x55da1e){const _0x192242=_0x1a8785;if(_0x55da1e['isAttack']())this[_0x192242(0x608)]();else{if(_0x55da1e[_0x192242(0xae0)]())this[_0x192242(0x3a4)](_0x192242(0x237));else{if(_0x55da1e[_0x192242(0x5e5)]())this[_0x192242(0x3a4)](_0x192242(0x1ed));else{if(_0x55da1e[_0x192242(0x98c)]())[0x1,0x2,0x5,0x6][_0x192242(0xa3e)](_0x55da1e[_0x192242(0x7e0)]()[_0x192242(0x5c1)][_0x192242(0x888)])?this[_0x192242(0x608)]():this[_0x192242(0x3a4)](_0x192242(0x8d9));else _0x55da1e['isItem']()&&this[_0x192242(0x3a4)](_0x192242(0x7e0));}}}},Game_Battler['prototype'][_0x1a8785(0x1fd)]=function(){return $dataSystem['attackMotions'][0x0];},Game_Battler['prototype'][_0x1a8785(0x185)]=function(){const _0xd96a4a=_0x1a8785,_0x1391d0=this[_0xd96a4a(0x1fd)]();return _0x1391d0?_0x1391d0[_0xd96a4a(0x2b5)]:0x0;},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x6f0)]=function(_0x414891){const _0x52699e=_0x1a8785;if(!$gameSystem['isSideView']())return;const _0x18b1b1=this[_0x52699e(0x89e)](),_0x245b10=_0x414891['battler']();if(!_0x18b1b1||!_0x245b10)return;const _0x2711ef=_0x245b10['_baseX'],_0x603642=_0x245b10[_0x52699e(0x236)];this[_0x52699e(0x2cc)](_0x2711ef,_0x603642,0x0,![],_0x52699e(0x434),-0x1),_0x18b1b1[_0x52699e(0x412)]();const _0x490613=VisuMZ['BattleCore']['Settings'][_0x52699e(0x6fa)];let _0x15fdc8=(_0x245b10[_0x52699e(0x92d)]+_0x18b1b1['width'])/0x2;_0x15fdc8*=this[_0x52699e(0x68d)]()?0x1:-0x1;let _0x25e6ad=_0x490613[_0x52699e(0x43c)]*(this[_0x52699e(0x68d)]()?0x1:-0x1);_0x414891[_0x52699e(0x2ba)](_0x15fdc8,_0x25e6ad,0x0,![],_0x52699e(0x434)),_0x245b10[_0x52699e(0x412)]();},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x3a4)]=function(_0x5e99bf){const _0x547add=_0x1a8785;if(SceneManager[_0x547add(0x3a8)]()){const _0x4d6dce=this[_0x547add(0x89e)]();_0x4d6dce&&(_0x4d6dce[_0x547add(0x3fc)](_0x5e99bf),['swing',_0x547add(0xa03),_0x547add(0x18c)][_0x547add(0xa3e)](_0x5e99bf)&&this['performWeaponAnimation']());}this[_0x547add(0x302)]();},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x6e0)]=function(){},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x229)]=function(_0x4a659e){const _0x5ebdbe=_0x1a8785;if(SceneManager[_0x5ebdbe(0x3a8)]()){const _0x416ed1=this[_0x5ebdbe(0x89e)]();if(_0x416ed1)_0x416ed1[_0x5ebdbe(0x2f4)](_0x4a659e);}},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0xafa)]=function(){const _0x37314c=_0x1a8785;if(SceneManager['isSceneBattle']()){const _0x8d5f8d=this['getAttackWeaponAnimationId']();this[_0x37314c(0x229)](_0x8d5f8d);}},Game_Battler[_0x1a8785(0x978)]['performCastAnimation']=function(_0x4fd945,_0x1aa3c3){const _0x134034=_0x1a8785;if(!_0x4fd945)return;if(!_0x4fd945['item']())return;if(_0x4fd945[_0x134034(0x9fc)]())return;if(_0x4fd945[_0x134034(0xae0)]())return;if(_0x4fd945[_0x134034(0x786)]())return;let _0x2594c=0x0;const _0x51cd7a=VisuMZ[_0x134034(0x83c)][_0x134034(0x9a7)][_0x134034(0x6fa)],_0x32d676=_0x4fd945[_0x134034(0x7e0)]()[_0x134034(0x9c6)];if(_0x32d676[_0x134034(0x9e0)](/<CAST ANIMATION: (\d+)>/i))_0x2594c=Number(RegExp['$1']);else{if(_0x32d676[_0x134034(0x9e0)](/<NO CAST ANIMATION>/i))return;else{if(_0x4fd945['isCertainHit']())_0x2594c=_0x51cd7a[_0x134034(0xa73)];else{if(_0x4fd945[_0x134034(0x1a6)]())_0x2594c=_0x51cd7a['CastPhysical'];else _0x4fd945[_0x134034(0x5e5)]()&&(_0x2594c=_0x51cd7a['CastMagical']);}}}_0x2594c>0x0&&$gameTemp[_0x134034(0x522)]([this],_0x2594c,!!_0x1aa3c3);},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x1b0)]=function(){const _0x559a0b=_0x1a8785;SoundManager[_0x559a0b(0x82c)]();let _0x221849=VisuMZ[_0x559a0b(0x83c)][_0x559a0b(0x9a7)][_0x559a0b(0x6fa)]['ReflectAnimation'];_0x221849>0x0&&(Imported['VisuMZ_0_CoreEngine']?$gameTemp[_0x559a0b(0x3ac)]([this],_0x221849):$gameTemp[_0x559a0b(0x522)]([this],_0x221849));},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x3bf)]=Game_Battler['prototype'][_0x1a8785(0x5a0)],Game_Battler[_0x1a8785(0x978)]['performDamage']=function(){const _0x102d6d=_0x1a8785;VisuMZ['BattleCore'][_0x102d6d(0x3bf)][_0x102d6d(0x716)](this),this[_0x102d6d(0x1c1)](),this[_0x102d6d(0x270)]();},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x4d4)]=Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x8aa)],Game_Battler[_0x1a8785(0x978)]['performMiss']=function(){const _0x539110=_0x1a8785;VisuMZ['BattleCore']['Game_Battler_performMiss'][_0x539110(0x716)](this),this[_0x539110(0x1c1)]();},VisuMZ['BattleCore'][_0x1a8785(0x23b)]=Game_Battler['prototype'][_0x1a8785(0x84d)],Game_Battler['prototype'][_0x1a8785(0x84d)]=function(){const _0x258f33=_0x1a8785;VisuMZ[_0x258f33(0x83c)][_0x258f33(0x23b)]['call'](this),this[_0x258f33(0x1c1)]();},Game_Battler[_0x1a8785(0x978)]['performFlinch']=function(){const _0x453620=_0x1a8785;if(!$gameSystem[_0x453620(0x973)]())return;if(this[_0x453620(0x5e2)])return;this[_0x453620(0x5e2)]=!![];const _0x22b21b=this['battler']();if(_0x22b21b)_0x22b21b['stepFlinch']();},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x270)]=function(){const _0x3c2caf=_0x1a8785;if(!this['canBattlerMove']())return;const _0x22fd26=VisuMZ[_0x3c2caf(0x83c)]['Settings'][_0x3c2caf(0x1d0)];if(!(_0x22fd26[_0x3c2caf(0x393)]??![]))return;if(this[_0x3c2caf(0x62d)]<=0x0)return;const _0x2d89d6=this['battler']();if(_0x2d89d6){const _0x50a4aa=this[_0x3c2caf(0x62d)],_0x73541a=(_0x50a4aa/this[_0x3c2caf(0x2c5)])['clamp'](0.8,0x1),_0x245331=_0x22fd26[_0x3c2caf(0x30a)]??0x30,_0x44608f=_0x73541a*_0x245331;_0x2d89d6[_0x3c2caf(0x605)](_0x44608f,_0x73541a);}},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x7cb)]=function(){const _0x1f327c=_0x1a8785;if(this['isDead']()&&this[_0x1f327c(0x7c6)]!==_0x1f327c(0x51c)){this[_0x1f327c(0x3a4)]('dead');return;}if(this[_0x1f327c(0x37f)]()&&this[_0x1f327c(0x7c6)]===_0x1f327c(0x51c))return;if(!!this['_freezeMotionData'])return;if(this['isEnemy']()){if(!this[_0x1f327c(0x9c0)]()&&this!==BattleManager[_0x1f327c(0x938)]){if(this['battler']())this[_0x1f327c(0x89e)]()[_0x1f327c(0x5ca)]();}this[_0x1f327c(0x302)]();return;}if(this[_0x1f327c(0x7c6)]==='victory')return;if(this[_0x1f327c(0x7c6)]===_0x1f327c(0x425)&&!BattleManager['isInputting']())return;if(this['_motionType']===_0x1f327c(0x237)&&!BattleManager[_0x1f327c(0x99f)]())return;this['clearMotion']();if(BattleManager[_0x1f327c(0x28e)]()&&this===BattleManager['_subject'])return;if(this[_0x1f327c(0x89e)]()&&BattleManager[_0x1f327c(0x99f)]()){this[_0x1f327c(0x89e)]()['refreshMotion'](),this[_0x1f327c(0x302)]();return;}},Game_Enemy[_0x1a8785(0x978)][_0x1a8785(0x9c0)]=function(){const _0x148137=_0x1a8785;if(!this[_0x148137(0x907)]())return![];const _0x3d512d=this[_0x148137(0x89e)]();if(!_0x3d512d)return![];const _0x128b04=_0x3d512d[_0x148137(0xadf)];if(!_0x128b04)return![];const _0x5dfe90=_0x128b04[_0x148137(0x328)];return _0x5dfe90&&!_0x5dfe90[_0x148137(0xa86)];},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x1e8)]=function(){const _0x35df92=_0x1a8785;return this[_0x35df92(0x62c)];},Game_Battler['prototype'][_0x1a8785(0x321)]=function(_0x5ead4f){const _0x206ef9=_0x1a8785;if(!$gameSystem[_0x206ef9(0x973)]())return;this[_0x206ef9(0x62c)]=_0x5ead4f;const _0xd6dd39=this[_0x206ef9(0x89e)]();if(_0xd6dd39)_0xd6dd39[_0x206ef9(0x971)]();},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x1cf)]=function(_0x412aba,_0x4f5364,_0x57eb10){const _0x47fa9f=_0x1a8785;if(!$gameSystem['isSideView']())return;const _0x12d085=this['battler']();if(!_0x12d085)return;if(_0x412aba===_0x12d085[_0x47fa9f(0x6c5)])return;let _0xf99c80=![];if(this[_0x47fa9f(0x68d)]()){if(_0x412aba>_0x12d085[_0x47fa9f(0x6c5)])_0xf99c80=!![];if(_0x412aba<_0x12d085[_0x47fa9f(0x6c5)])_0xf99c80=![];}else{if(this[_0x47fa9f(0x3a6)]()){if(_0x412aba>_0x12d085[_0x47fa9f(0x6c5)])_0xf99c80=![];if(_0x412aba<_0x12d085[_0x47fa9f(0x6c5)])_0xf99c80=!![];}};this[_0x47fa9f(0x321)](_0x57eb10?!_0xf99c80:_0xf99c80),_0x12d085[_0x47fa9f(0x971)]();},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x2ba)]=function(_0x1a9726,_0x1c5d98,_0x28d903,_0x2e053f,_0x455b90){const _0x433ce5=_0x1a8785;if(!$gameSystem['isSideView']())return;const _0x544559=this[_0x433ce5(0x89e)]();if(!_0x544559)return;if(_0x2e053f)this[_0x433ce5(0x1cf)](_0x1a9726+_0x544559[_0x433ce5(0x6c5)],_0x1c5d98+_0x544559[_0x433ce5(0x236)],![]);_0x1a9726+=_0x544559[_0x433ce5(0x6c5)]-_0x544559[_0x433ce5(0x9b9)],_0x1c5d98+=_0x544559[_0x433ce5(0x236)]-_0x544559['_homeY'],_0x544559[_0x433ce5(0x21c)](_0x1a9726,_0x1c5d98,_0x28d903);if(Imported[_0x433ce5(0x211)])_0x544559[_0x433ce5(0x7a2)](_0x455b90||_0x433ce5(0x434));},Game_Battler['prototype'][_0x1a8785(0x2cc)]=function(_0x147a49,_0x2d1d07,_0x221850,_0x3c8453,_0x2efea8,_0x28dec6){const _0x5092f1=_0x1a8785;if(!$gameSystem[_0x5092f1(0x973)]())return;const _0x3c57c5=this['battler']();if(!_0x3c57c5)return;if(_0x147a49===Infinity||_0x2d1d07===Infinity)return;if(isNaN(_0x147a49)||isNaN(_0x2d1d07))return;_0x28dec6=_0x28dec6||0x0;if(_0x28dec6>0x0){if(_0x3c57c5[_0x5092f1(0x6c5)]>_0x147a49)_0x147a49+=_0x3c57c5[_0x5092f1(0x92d)]/0x2+_0x28dec6;if(_0x3c57c5[_0x5092f1(0x6c5)]<_0x147a49)_0x147a49-=_0x3c57c5[_0x5092f1(0x92d)]/0x2+_0x28dec6;}if(_0x3c8453)this[_0x5092f1(0x1cf)](_0x147a49,_0x2d1d07,![]);_0x147a49-=_0x3c57c5['_homeX'],_0x2d1d07-=_0x3c57c5['_homeY'],_0x3c57c5[_0x5092f1(0x21c)](_0x147a49,_0x2d1d07,_0x221850);if(Imported[_0x5092f1(0x211)])_0x3c57c5[_0x5092f1(0x7a2)](_0x2efea8||_0x5092f1(0x434));},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x55d)]=function(_0x135f10,_0x14a761,_0x54d7a2,_0x9d1525,_0x3b3286){const _0x302d83=_0x1a8785;if(!$gameSystem[_0x302d83(0x973)]())return;const _0x4dd802=this[_0x302d83(0x89e)]();if(!_0x4dd802)return;if(_0x9d1525)this[_0x302d83(0x1cf)](_0x135f10+_0x4dd802['_baseX'],_0x14a761+_0x4dd802['_baseY'],![]);_0x135f10+=_0x4dd802[_0x302d83(0x9b9)],_0x14a761+=_0x4dd802[_0x302d83(0x774)],_0x4dd802[_0x302d83(0x807)](_0x135f10,_0x14a761,_0x54d7a2,_0x3b3286),this[_0x302d83(0x424)]=_0x135f10,this[_0x302d83(0x976)]=_0x14a761;},Game_Battler['prototype'][_0x1a8785(0x9f5)]=function(_0xc6d451,_0x2cf4a6,_0x25b86d,_0x2f993f,_0x259544,_0x59e746){const _0x1fe8fe=_0x1a8785;if(!$gameSystem[_0x1fe8fe(0x973)]())return;const _0x45ca10=this[_0x1fe8fe(0x89e)]();if(!_0x45ca10)return;_0x59e746=_0x59e746||0x0;if(_0x59e746>0x0){if(_0x45ca10[_0x1fe8fe(0x6c5)]>_0xc6d451)_0xc6d451+=_0x45ca10['width']/0x2+_0x59e746;if(_0x45ca10[_0x1fe8fe(0x6c5)]<_0xc6d451)_0xc6d451-=_0x45ca10[_0x1fe8fe(0x92d)]/0x2+_0x59e746;}if(_0x2f993f)this[_0x1fe8fe(0x1cf)](_0xc6d451,_0x2cf4a6,![]);_0x45ca10[_0x1fe8fe(0x807)](_0xc6d451,_0x2cf4a6,_0x25b86d,_0x259544),this['_forcedHomeX']=_0xc6d451,this[_0x1fe8fe(0x976)]=_0x2cf4a6;},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x336)]=function(_0x32482b,_0x19c7a5,_0x2f249a){const _0x5b88a4=_0x1a8785;if(!$gameSystem['isSideView']())return;const _0x15838a=this[_0x5b88a4(0x89e)]();if(!_0x15838a)return;_0x15838a[_0x5b88a4(0x61e)](_0x32482b,_0x19c7a5,_0x2f249a);},Game_Battler[_0x1a8785(0x978)]['jumpBattler']=function(_0x2ffc26,_0x336972){const _0x228dc6=_0x1a8785;if(!$gameSystem[_0x228dc6(0x973)]())return;const _0x128479=this['battler']();if(!_0x128479)return;_0x128479[_0x228dc6(0xa3a)](_0x2ffc26,_0x336972);},Game_Battler[_0x1a8785(0x978)]['spinBattler']=function(_0x768cdf,_0x1bf60f,_0x2ee6ad,_0x51a729){const _0x170022=_0x1a8785;if(!$gameSystem[_0x170022(0x973)]())return;const _0x1d9566=this[_0x170022(0x89e)]();if(!_0x1d9566)return;_0x1d9566['startSpin'](_0x768cdf,_0x1bf60f,_0x2ee6ad,_0x51a729);},Game_Battler[_0x1a8785(0x978)]['skewBattler']=function(_0x424b43,_0xeada73,_0x2c39f5,_0x282beb){const _0x4a6e1d=_0x1a8785;if(!$gameSystem[_0x4a6e1d(0x973)]())return;const _0xcbcff9=this['battler']();if(!_0xcbcff9)return;this[_0x4a6e1d(0x68d)]()&&(_0x424b43*=-0x1,_0xeada73*=-0x1),_0xcbcff9[_0x4a6e1d(0x867)](_0x424b43,_0xeada73,_0x2c39f5,_0x282beb);},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x3a3)]=function(_0xb2c2ba,_0x2777e7,_0x12f2f9,_0x188d01){const _0x2e69db=_0x1a8785;if(!$gameSystem['isSideView']())return;const _0x2c3ddd=this[_0x2e69db(0x89e)]();if(!_0x2c3ddd)return;_0x2c3ddd[_0x2e69db(0x6e3)](_0xb2c2ba,_0x2777e7,_0x12f2f9,_0x188d01);},Game_Battler[_0x1a8785(0x978)]['changeBattlerOpacity']=function(_0xe254d0,_0x1b5023,_0x3f267f){const _0x31f227=_0x1a8785;if(!$gameSystem['isSideView']())return;const _0x5c1717=this[_0x31f227(0x89e)]();if(!_0x5c1717)return;_0x5c1717[_0x31f227(0x3f3)](_0xe254d0,_0x1b5023,_0x3f267f);},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x302)]=function(){const _0x54abaf=_0x1a8785,_0x13ad07=!!this[_0x54abaf(0x446)];this[_0x54abaf(0x446)]=undefined,_0x13ad07&&(this[_0x54abaf(0x7cb)](),this['clearFreezeMotionForWeapons']());},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0xa1f)]=function(){const _0x3f2ecf=_0x1a8785;if(!SceneManager[_0x3f2ecf(0x3a8)]())return;const _0x18e1be=this['battler']();if(!_0x18e1be)return;let _0x1e5b97=this['isActor']()?_0x18e1be[_0x3f2ecf(0x709)]:_0x18e1be[_0x3f2ecf(0xadf)]['_weaponSprite'];_0x1e5b97&&_0x1e5b97[_0x3f2ecf(0x352)](0x0);},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x751)]=function(_0x3667e1,_0xbaad11,_0x3531bb){const _0x263bf6=_0x1a8785;if(this['isEnemy']()&&!this[_0x263bf6(0x907)]())return;let _0x10fcd0=0x0,_0x19402=0x0;_0x3667e1[_0x263bf6(0x9e0)](/ATTACK[ ](\d+)/i)&&(_0x19402=Number(RegExp['$1']),_0x19402--);if(this[_0x263bf6(0x68d)]()){const _0x3e894d=this['weapons']();_0x10fcd0=_0x3e894d[_0x19402]?_0x3e894d[_0x19402][_0x263bf6(0x7d5)]:0x0;}else this[_0x263bf6(0x3a6)]()&&(_0x10fcd0=this[_0x263bf6(0x49a)]()[_0x263bf6(0x7d5)]||0x0);const _0x78cc2=$dataSystem['attackMotions'][_0x10fcd0];_0x3667e1[_0x263bf6(0x9e0)](/attack/i)&&(_0x3667e1=[_0x263bf6(0xa03),_0x263bf6(0x9b1),_0x263bf6(0x18c)][_0x78cc2[_0x263bf6(0x888)]]||_0x263bf6(0x9b1)),this[_0x263bf6(0x446)]={'motionType':_0x3667e1,'weaponImageId':_0xbaad11?_0x78cc2['weaponImageId']:0x0,'pattern':_0x3531bb};},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0xa94)]=function(_0x27fbaa){const _0x384641=_0x1a8785;if(!_0x27fbaa)return![];return _0x27fbaa[_0x384641(0xb04)]()===this[_0x384641(0xb04)]();},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0xaca)]=function(_0x1ee73d){const _0x388ce5=_0x1a8785;if(!_0x1ee73d)return![];return _0x1ee73d[_0x388ce5(0xab4)]()===this[_0x388ce5(0xb04)]();},Game_Battler['prototype'][_0x1a8785(0x51b)]=function(){return![];},Game_Actor[_0x1a8785(0x978)][_0x1a8785(0x51b)]=function(){const _0x2e862a=_0x1a8785;return this[_0x2e862a(0x45f)]()['match'](/\$/i);},Game_Enemy[_0x1a8785(0x978)]['hasStaticSvBattler']=function(){const _0x163c32=_0x1a8785;return this[_0x163c32(0x907)]()&&this[_0x163c32(0x43d)]()[_0x163c32(0x9e0)](/\$/i);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x27f)]=Game_Actor[_0x1a8785(0x978)][_0x1a8785(0x352)],Game_Actor[_0x1a8785(0x978)][_0x1a8785(0x352)]=function(_0x2f1723){const _0x1c89ae=_0x1a8785;VisuMZ[_0x1c89ae(0x83c)][_0x1c89ae(0x27f)][_0x1c89ae(0x716)](this,_0x2f1723),this[_0x1c89ae(0x99d)]();},Game_Actor[_0x1a8785(0x978)][_0x1a8785(0x99d)]=function(){const _0x35aaa7=_0x1a8785;this['_battlePortrait']='',this[_0x35aaa7(0x7fd)]()&&this[_0x35aaa7(0x7fd)]()[_0x35aaa7(0x9c6)][_0x35aaa7(0x9e0)](/<BATTLE (?:IMAGE|PORTRAIT):[ ](.*)>/i)&&(this[_0x35aaa7(0x9e2)]=String(RegExp['$1']));},Game_Actor[_0x1a8785(0x978)]['getBattlePortraitFilename']=function(){const _0x57e240=_0x1a8785;if(this[_0x57e240(0x8a9)]()!=='')return this[_0x57e240(0x8a9)]();else{if(Imported['VisuMZ_1_MainMenuCore']&&this[_0x57e240(0x2d3)]()!=='')return this[_0x57e240(0x2d3)]();}return'';},Game_Actor[_0x1a8785(0x978)][_0x1a8785(0x8a9)]=function(){const _0x167f6c=_0x1a8785;if(this['_battlePortrait']===undefined)this[_0x167f6c(0x99d)]();return this[_0x167f6c(0x9e2)];},Game_Actor[_0x1a8785(0x978)][_0x1a8785(0x7c5)]=function(_0x341f67){const _0x3c652e=_0x1a8785;if(this[_0x3c652e(0x9e2)]===undefined)this['initBattlePortrait']();this[_0x3c652e(0x9e2)]=_0x341f67;if(SceneManager[_0x3c652e(0x3a8)]()&&$gameParty['battleMembers']()[_0x3c652e(0xa3e)](this)){const _0x880cfc=SceneManager[_0x3c652e(0xa42)][_0x3c652e(0x2ac)];_0x880cfc&&_0x880cfc[_0x3c652e(0x19b)](this);}},Game_Actor[_0x1a8785(0x978)]['isSpriteVisible']=function(){return!![];},Game_Actor[_0x1a8785(0x978)]['isAutoBattle']=function(){const _0x4098d7=_0x1a8785;if(!this[_0x4098d7(0x7c7)]()&&BattleManager[_0x4098d7(0x6c9)])return!![];return Game_Battler[_0x4098d7(0x978)][_0x4098d7(0xad5)][_0x4098d7(0x716)](this);},VisuMZ['BattleCore'][_0x1a8785(0x991)]=Game_Actor[_0x1a8785(0x978)][_0x1a8785(0x795)],Game_Actor[_0x1a8785(0x978)]['makeActionList']=function(){const _0x70473c=_0x1a8785;if(BattleManager[_0x70473c(0x6c9)]&&!ConfigManager['autoBattleUseSkills'])return this[_0x70473c(0x5b0)]();else{return VisuMZ['BattleCore'][_0x70473c(0x991)][_0x70473c(0x716)](this);;}},Game_Actor[_0x1a8785(0x978)]['makeActionListAutoAttack']=function(){const _0x28e38c=_0x1a8785,_0x45a81e=[],_0x2f6113=new Game_Action(this);return _0x2f6113[_0x28e38c(0x2eb)](),_0x45a81e['push'](_0x2f6113),_0x45a81e;},Game_Actor['prototype'][_0x1a8785(0x2a8)]=function(){const _0x41b7e2=_0x1a8785;return this[_0x41b7e2(0xa1b)]()['note'][_0x41b7e2(0x9e0)](/<BATTLE COMMANDS>\s*([\s\S]*)\s*<\/BATTLE COMMANDS>/i)?String(RegExp['$1'])[_0x41b7e2(0x2d7)](/[\r\n]+/):VisuMZ[_0x41b7e2(0x83c)][_0x41b7e2(0x9a7)][_0x41b7e2(0x708)]['BattleCmdList'];},Game_Actor['prototype'][_0x1a8785(0x191)]=function(){const _0x33ee97=_0x1a8785;if(this['_cache'][_0x33ee97(0x9a0)]!==undefined)return this[_0x33ee97(0x574)][_0x33ee97(0x9a0)];return this[_0x33ee97(0x7fd)]()[_0x33ee97(0x9c6)][_0x33ee97(0x9e0)](/<SIDEVIEW ANCHOR: (.*), (.*)>/i)?(this[_0x33ee97(0x574)]['svAnchorX']=eval(RegExp['$1']),this[_0x33ee97(0x574)]['svAnchorY']=eval(RegExp['$2'])):this['_cache'][_0x33ee97(0x9a0)]=Game_Battler[_0x33ee97(0x978)]['svBattlerAnchorX'][_0x33ee97(0x716)](this),this[_0x33ee97(0x574)][_0x33ee97(0x9a0)];},Game_Actor['prototype'][_0x1a8785(0x713)]=function(){const _0x53eae3=_0x1a8785;if(this[_0x53eae3(0x574)]['svAnchorY']!==undefined)return this[_0x53eae3(0x574)]['svAnchorY'];return this[_0x53eae3(0x7fd)]()[_0x53eae3(0x9c6)][_0x53eae3(0x9e0)](/<SIDEVIEW ANCHOR: (.*), (.*)>/i)?(this['_cache'][_0x53eae3(0x9a0)]=eval(RegExp['$1']),this[_0x53eae3(0x574)][_0x53eae3(0x951)]=eval(RegExp['$2'])):this[_0x53eae3(0x574)][_0x53eae3(0x951)]=Game_Battler['prototype']['svBattlerAnchorY']['call'](this),this[_0x53eae3(0x574)][_0x53eae3(0x951)];},Game_Actor['prototype'][_0x1a8785(0x2ad)]=function(){const _0x89d8c9=_0x1a8785;if(this[_0x89d8c9(0x574)][_0x89d8c9(0x5c0)]!==undefined)return this[_0x89d8c9(0x574)][_0x89d8c9(0x5c0)];if(this[_0x89d8c9(0x7fd)]()[_0x89d8c9(0x9c6)][_0x89d8c9(0x9e0)](/<SIDEVIEW SHOW SHADOW>/i))this[_0x89d8c9(0x574)][_0x89d8c9(0x5c0)]=!![];else this[_0x89d8c9(0x7fd)]()[_0x89d8c9(0x9c6)][_0x89d8c9(0x9e0)](/<SIDEVIEW HIDE SHADOW>/i)?this[_0x89d8c9(0x574)][_0x89d8c9(0x5c0)]=![]:this[_0x89d8c9(0x574)][_0x89d8c9(0x5c0)]=Game_Battler[_0x89d8c9(0x978)][_0x89d8c9(0x2ad)][_0x89d8c9(0x716)](this);return this[_0x89d8c9(0x574)][_0x89d8c9(0x5c0)];},Game_Actor['prototype'][_0x1a8785(0x484)]=function(){const _0x5737a6=_0x1a8785;return VisuMZ['BattleCore']['Settings'][_0x5737a6(0x1d0)][_0x5737a6(0x1e2)];},Game_Actor['prototype'][_0x1a8785(0x6e0)]=function(){const _0x3bb91c=_0x1a8785,_0x5e5141=this['weapons'](),_0xec4b50=_0x5e5141[0x0]?_0x5e5141[0x0][_0x3bb91c(0x7d5)]:0x0,_0x4e433b=$dataSystem[_0x3bb91c(0x45d)][_0xec4b50];_0x4e433b&&this[_0x3bb91c(0x229)](_0x4e433b['weaponImageId']);},Game_Actor[_0x1a8785(0x978)]['performAction']=function(_0x3cb9ba){const _0x1e11ac=_0x1a8785;Game_Battler[_0x1e11ac(0x978)][_0x1e11ac(0x720)][_0x1e11ac(0x716)](this,_0x3cb9ba),this[_0x1e11ac(0x70e)](_0x3cb9ba);},Game_Actor[_0x1a8785(0x978)]['getAttackMotion']=function(){const _0x288f56=_0x1a8785,_0xc1fb38=this[_0x288f56(0x577)](),_0xefc387=_0xc1fb38[0x0]?_0xc1fb38[0x0][_0x288f56(0x7d5)]:0x0;return $dataSystem['attackMotions'][_0xefc387];},Game_Actor[_0x1a8785(0x978)][_0x1a8785(0x54c)]=function(_0xd1bb62){const _0x3d72ac=_0x1a8785;_0xd1bb62=_0xd1bb62||0x1,_0xd1bb62--;const _0xc1ea4f=this[_0x3d72ac(0x577)]();return _0xc1ea4f[_0xd1bb62]?_0xc1ea4f[_0xd1bb62][_0x3d72ac(0xab8)]:0x0;},Game_Actor[_0x1a8785(0x978)][_0x1a8785(0x657)]=function(_0x3e9a92){const _0x45327e=_0x1a8785;_0x3e9a92=_0x3e9a92||0x1,_0x3e9a92--;const _0x21a73b=this[_0x45327e(0x577)](),_0x5dd913=_0x21a73b[_0x3e9a92]?_0x21a73b[_0x3e9a92][_0x45327e(0x7d5)]:0x0;return $dataSystem[_0x45327e(0x45d)][_0x5dd913];},Game_Actor['prototype']['performAttackSlot']=function(_0x5a5e5c){const _0x12c901=_0x1a8785;_0x5a5e5c=_0x5a5e5c||0x1,_0x5a5e5c--;const _0x152ec9=this['weapons'](),_0x453e81=_0x152ec9[_0x5a5e5c]?_0x152ec9[_0x5a5e5c][_0x12c901(0x7d5)]:0x0,_0x32e727=$dataSystem['attackMotions'][_0x453e81];if(_0x32e727){if(_0x32e727[_0x12c901(0x888)]===0x0)this[_0x12c901(0x3a4)](_0x12c901(0xa03));else{if(_0x32e727[_0x12c901(0x888)]===0x1)this['requestMotion'](_0x12c901(0x9b1));else _0x32e727['type']===0x2&&this[_0x12c901(0x3a4)](_0x12c901(0x18c));}this['startWeaponAnimation'](_0x32e727['weaponImageId']);}},Game_Battler['prototype'][_0x1a8785(0x331)]=function(_0x41fd11){const _0x5eb415=_0x1a8785;this[_0x5eb415(0x50a)]=_0x41fd11||0x0,this[_0x5eb415(0x574)]={};},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0xacd)]=function(){const _0x535844=_0x1a8785;this['_activeWeaponSlot']=this[_0x535844(0x50a)]||0x0,this[_0x535844(0x50a)]++,this[_0x535844(0x574)]={};},Game_Battler[_0x1a8785(0x978)][_0x1a8785(0x627)]=function(){const _0x242ccc=_0x1a8785;this[_0x242ccc(0x50a)]=undefined,this['_cache']={};},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x2f2)]=Game_Actor[_0x1a8785(0x978)][_0x1a8785(0x32d)],Game_Actor[_0x1a8785(0x978)]['equips']=function(){const _0x5bd025=_0x1a8785;let _0x560aa2=VisuMZ[_0x5bd025(0x83c)][_0x5bd025(0x2f2)][_0x5bd025(0x716)](this);if(this[_0x5bd025(0x5e0)])return _0x560aa2;if(this[_0x5bd025(0x50a)]!==undefined){this[_0x5bd025(0x5e0)]=!![];const _0x230fcb=this['equipSlots']();for(let _0x2b04c6=0x0;_0x2b04c6<_0x230fcb['length'];_0x2b04c6++){_0x230fcb[_0x2b04c6]===0x1&&this[_0x5bd025(0x50a)]!==_0x2b04c6&&(_0x560aa2[_0x2b04c6]=null);}this[_0x5bd025(0x5e0)]=undefined;}return _0x560aa2;},Window_BattleLog[_0x1a8785(0x978)][_0x1a8785(0x9e1)]=function(_0x3a3712){const _0x27eef5=_0x1a8785;return _0x3a3712[_0x27eef5(0x68d)]()?_0x3a3712['weapons']()[_0x27eef5(0x2dc)]||0x1:0x1;},Window_BattleLog[_0x1a8785(0x978)][_0x1a8785(0x28b)]=function(_0x1eeb4a,_0x3fc37d){const _0x53b64e=_0x1a8785;_0x1eeb4a&&_0x1eeb4a[_0x53b64e(0x68d)]()&&_0x1eeb4a['setActiveWeaponSlot'](_0x3fc37d),this[_0x53b64e(0x2d9)]();},Window_BattleLog['prototype'][_0x1a8785(0x997)]=function(_0x30d97b){const _0x172757=_0x1a8785;_0x30d97b&&_0x30d97b[_0x172757(0x68d)]()&&_0x30d97b[_0x172757(0x627)](),this['callNextMethod']();},Game_Actor[_0x1a8785(0x978)][_0x1a8785(0x1ad)]=function(){const _0x20e99e=_0x1a8785;let _0x56536b='battleUIOffsetX';if(this[_0x20e99e(0x4ce)](_0x56536b))return this[_0x20e99e(0x574)][_0x56536b];return this[_0x20e99e(0x574)][_0x56536b]=this['createBattleUIOffsetX'](this[_0x20e99e(0x7fd)]()),this[_0x20e99e(0x574)][_0x56536b];},Game_Actor[_0x1a8785(0x978)][_0x1a8785(0x260)]=function(){const _0x309122=_0x1a8785;let _0x26c37b=_0x309122(0x260);if(this['checkCacheKey'](_0x26c37b))return this['_cache'][_0x26c37b];return this[_0x309122(0x574)][_0x26c37b]=this[_0x309122(0x2a7)](this[_0x309122(0x7fd)]()),this['_cache'][_0x26c37b];},VisuMZ['BattleCore'][_0x1a8785(0x29f)]=Game_Enemy[_0x1a8785(0x978)][_0x1a8785(0x352)],Game_Enemy['prototype'][_0x1a8785(0x352)]=function(_0x4d65f8,_0xfa30cc,_0x35ef5c){const _0x3fda6a=_0x1a8785;_0x4d65f8=DataManager['swapEnemyIDs'](_0x4d65f8),VisuMZ[_0x3fda6a(0x83c)][_0x3fda6a(0x29f)][_0x3fda6a(0x716)](this,_0x4d65f8,_0xfa30cc,_0x35ef5c),Imported[_0x3fda6a(0x6be)]&&this['initElementStatusCore'](),this[_0x3fda6a(0x3d9)](),this['setupBattleCoreData'](),Imported['VisuMZ_1_ElementStatusCore']&&this[_0x3fda6a(0x6b1)]();},Game_Enemy[_0x1a8785(0x978)][_0x1a8785(0x3d9)]=function(){const _0x30158e=_0x1a8785,_0x2d710d=VisuMZ['BattleCore'][_0x30158e(0x9a7)][_0x30158e(0x199)];this['_attackAnimationId']=_0x2d710d['AttackAnimation'],this[_0x30158e(0x5ae)]={};},Game_Enemy['prototype']['setupBattleCoreData']=function(){const _0x4353bd=_0x1a8785,_0x355063=VisuMZ[_0x4353bd(0x83c)][_0x4353bd(0x9a7)][_0x4353bd(0x199)],_0x81e62d=this['enemy']()[_0x4353bd(0x9c6)];this[_0x4353bd(0x5ae)]={'name':'','wtypeId':_0x355063[_0x4353bd(0x61c)],'collapse':_0x355063['AllowCollapse'],'motionIdle':_0x355063[_0x4353bd(0x6ef)],'width':_0x355063[_0x4353bd(0x877)]||0x40,'height':_0x355063['Height']||0x40,'anchorX':_0x355063[_0x4353bd(0xafc)]||0x0,'anchorY':_0x355063[_0x4353bd(0x53e)]||0x0,'shadow':_0x355063[_0x4353bd(0x73e)]};_0x81e62d['match'](/<ATTACK ANIMATION:[ ](\d+)>/i)&&(this['_attackAnimationId']=Number(RegExp['$1']));const _0x31ad8d=this[_0x4353bd(0x5ae)];if(_0x81e62d[_0x4353bd(0x9e0)](/<SIDEVIEW BATTLER: (.*)>/i))_0x31ad8d[_0x4353bd(0x1f2)]=String(RegExp['$1']);else{if(_0x81e62d[_0x4353bd(0x9e0)](/<SIDEVIEW BATTLERS>\s*([\s\S]*)\s*<\/SIDEVIEW BATTLERS>/i)){const _0x562437=String(RegExp['$1'])['split'](/[\r\n]+/)[_0x4353bd(0xa3b)]('');_0x31ad8d['name']=DataManager[_0x4353bd(0x6e1)](_0x562437);}}_0x81e62d['match'](/<SIDEVIEW ANCHOR: (.*), (.*)>/i)&&(_0x31ad8d[_0x4353bd(0x853)]=eval(RegExp['$1']),_0x31ad8d['anchorY']=eval(RegExp['$2']));if(_0x81e62d[_0x4353bd(0x9e0)](/<SIDEVIEW COLLAPSE>/i))_0x31ad8d[_0x4353bd(0x633)]=!![];else _0x81e62d[_0x4353bd(0x9e0)](/<SIDEVIEW NO COLLAPSE>/i)&&(_0x31ad8d[_0x4353bd(0x633)]=![]);if(_0x81e62d[_0x4353bd(0x9e0)](/<SIDEVIEW SHOW SHADOW>/i))_0x31ad8d['shadow']=!![];else _0x81e62d['match'](/<SIDEVIEW HIDE SHADOW>/i)&&(_0x31ad8d['shadow']=![]);if(_0x81e62d[_0x4353bd(0x9e0)](/<SIDEVIEW IDLE MOTION: (.*)>/i))_0x31ad8d['motionIdle']=String(RegExp['$1'])[_0x4353bd(0x5dd)]()['trim']();else{if(_0x81e62d[_0x4353bd(0x9e0)](/<SIDEVIEW IDLE MOTIONS>\s*([\s\S]*)\s*<\/SIDEVIEW IDLE MOTIONS>/i)){const _0x40f104=String(RegExp['$1'])[_0x4353bd(0x2d7)](/[\r\n]+/)[_0x4353bd(0xa3b)]('');_0x31ad8d['motionIdle']=DataManager[_0x4353bd(0x6e1)](_0x40f104);}}_0x81e62d[_0x4353bd(0x9e0)](/<SIDEVIEW SIZE: (\d+), (\d+)>/i)&&(_0x31ad8d[_0x4353bd(0x92d)]=Number(RegExp['$1']),_0x31ad8d['height']=Number(RegExp['$2']));if(_0x81e62d[_0x4353bd(0x9e0)](/<SIDEVIEW WEAPON: (.*)>/i))_0x31ad8d[_0x4353bd(0x7d5)]=DataManager['getWtypeIdWithName'](RegExp['$1']);else{if(_0x81e62d[_0x4353bd(0x9e0)](/<SIDEVIEW WEAPONS>\s*([\s\S]*)\s*<\/SIDEVIEW WEAPONS>/i)){const _0x4d5f1c=String(RegExp['$1'])[_0x4353bd(0x2d7)](/[\r\n]+/)[_0x4353bd(0xa3b)](''),_0x298a1c=DataManager[_0x4353bd(0x6e1)](_0x4d5f1c);_0x31ad8d['wtypeId']=DataManager[_0x4353bd(0x952)](_0x298a1c);}}if(Imported[_0x4353bd(0x6be)]){const _0x5fb43c=this[_0x4353bd(0x2c6)]();for(const _0x5e0fad of _0x5fb43c){const _0x57fbc9=this[_0x4353bd(0x590)](_0x5e0fad)[_0x4353bd(0x39b)][_0x4353bd(0x830)]()['trim'](),_0x3c58a5=_0x5e0fad['toUpperCase']()[_0x4353bd(0x6b6)]();if(_0x81e62d[_0x4353bd(0x9e0)](VisuMZ[_0x4353bd(0x9d3)][_0x4353bd(0x31d)][_0x4353bd(0x53c)[_0x4353bd(0x22f)](_0x3c58a5,_0x57fbc9)]))_0x31ad8d[_0x4353bd(0x1f2)]=String(RegExp['$1']);else{if(_0x81e62d[_0x4353bd(0x9e0)](VisuMZ[_0x4353bd(0x9d3)]['RegExp'][_0x4353bd(0x63e)[_0x4353bd(0x22f)](_0x3c58a5,_0x57fbc9)])){const _0xf95c5a=String(RegExp['$1'])[_0x4353bd(0x2d7)](/[\r\n]+/)[_0x4353bd(0xa3b)]('');_0x31ad8d[_0x4353bd(0x1f2)]=DataManager['processRandomizedData'](_0xf95c5a);}}if(_0x81e62d[_0x4353bd(0x9e0)](VisuMZ[_0x4353bd(0x9d3)][_0x4353bd(0x31d)]['SvWeaponSolo-%1-%2'[_0x4353bd(0x22f)](_0x3c58a5,_0x57fbc9)]))_0x31ad8d['wtypeId']=DataManager[_0x4353bd(0x952)](RegExp['$1']);else{if(_0x81e62d[_0x4353bd(0x9e0)](VisuMZ[_0x4353bd(0x9d3)]['RegExp']['SvWeaponMass-%1-%2'['format'](_0x3c58a5,_0x57fbc9)])){const _0x3f3f98=String(RegExp['$1'])['split'](/[\r\n]+/)[_0x4353bd(0xa3b)](''),_0x4e7cca=DataManager[_0x4353bd(0x6e1)](_0x3f3f98);_0x31ad8d['wtypeId']=DataManager['getWtypeIdWithName'](_0x4e7cca);}}if(_0x81e62d[_0x4353bd(0x9e0)](VisuMZ[_0x4353bd(0x9d3)][_0x4353bd(0x31d)][_0x4353bd(0x98d)[_0x4353bd(0x22f)](_0x3c58a5,_0x57fbc9)]))_0x31ad8d['motionIdle']=String(RegExp['$1'])[_0x4353bd(0x5dd)]()[_0x4353bd(0x6b6)]();else{if(_0x81e62d[_0x4353bd(0x9e0)](VisuMZ[_0x4353bd(0x9d3)][_0x4353bd(0x31d)]['SvMotionIdleMass-%1-%2'[_0x4353bd(0x22f)](_0x3c58a5,_0x57fbc9)])){const _0x3dca15=String(RegExp['$1'])[_0x4353bd(0x2d7)](/[\r\n]+/)[_0x4353bd(0xa3b)]('');_0x31ad8d[_0x4353bd(0x74a)]=DataManager[_0x4353bd(0x6e1)](_0x3dca15);}}}}},Game_Enemy[_0x1a8785(0x978)][_0x1a8785(0x523)]=function(){const _0x461963=_0x1a8785;return this[_0x461963(0x806)]||0x0;},Game_Enemy['prototype']['attackAnimationId2']=function(){return this['attackAnimationId1']();},Game_Enemy[_0x1a8785(0x978)][_0x1a8785(0x54c)]=function(_0x31cf63){const _0x295715=_0x1a8785;return this[_0x295715(0x523)]();},Game_Enemy[_0x1a8785(0x978)]['canBattlerMove']=function(){const _0x43d914=_0x1a8785;if(this['enemy']()[_0x43d914(0x9c6)][_0x43d914(0x9e0)](/<BATTLER SPRITE CANNOT MOVE>/i))return![];return Game_Battler[_0x43d914(0x978)][_0x43d914(0x76b)][_0x43d914(0x716)](this);},Game_Enemy[_0x1a8785(0x978)][_0x1a8785(0x68a)]=function(){const _0x35fe59=_0x1a8785;if(this[_0x35fe59(0x739)]()['note']['match'](/<BATTLER SPRITE GROUNDED>/i))return!![];return![];},Game_Enemy[_0x1a8785(0x978)][_0x1a8785(0x4e3)]=function(){const _0x20f6bd=_0x1a8785,_0x358271=[];for(const _0x1fad5f of this[_0x20f6bd(0x739)]()[_0x20f6bd(0xac6)]){const _0x639cf6=$dataSkills[_0x1fad5f[_0x20f6bd(0x4d0)]];if(_0x639cf6&&!_0x358271[_0x20f6bd(0xa3e)](_0x639cf6))_0x358271[_0x20f6bd(0x963)](_0x639cf6);}return _0x358271;},Game_Enemy[_0x1a8785(0x978)][_0x1a8785(0x1ad)]=function(){const _0x10704a=_0x1a8785;let _0x26d044=_0x10704a(0x1ad);if(this[_0x10704a(0x4ce)](_0x26d044))return this[_0x10704a(0x574)][_0x26d044];return this[_0x10704a(0x574)][_0x26d044]=this[_0x10704a(0xa91)](this['enemy']()),this[_0x10704a(0x574)][_0x26d044];},Game_Enemy['prototype'][_0x1a8785(0x260)]=function(){const _0x57461f=_0x1a8785;let _0x338510='battleUIOffsetY';if(this['checkCacheKey'](_0x338510))return this['_cache'][_0x338510];return this[_0x57461f(0x574)][_0x338510]=this[_0x57461f(0x2a7)](this[_0x57461f(0x739)]()),this['_cache'][_0x338510];},Game_Enemy[_0x1a8785(0x978)][_0x1a8785(0x49a)]=function(){const _0x36d5a3=_0x1a8785;if(this[_0x36d5a3(0x5ae)]!==undefined)return this[_0x36d5a3(0x5ae)];return this[_0x36d5a3(0x3cc)](),this[_0x36d5a3(0x5ae)];},Game_Enemy[_0x1a8785(0x978)][_0x1a8785(0x907)]=function(){const _0x3a9449=_0x1a8785;return this[_0x3a9449(0x49a)]()[_0x3a9449(0x1f2)]!=='';},Game_Enemy[_0x1a8785(0x978)][_0x1a8785(0x43d)]=function(){const _0x2c825e=_0x1a8785;return this[_0x2c825e(0x49a)]()[_0x2c825e(0x1f2)];},Game_Enemy[_0x1a8785(0x978)][_0x1a8785(0x484)]=function(){const _0x5bc600=_0x1a8785;return this['hasSvBattler']()?VisuMZ[_0x5bc600(0x83c)][_0x5bc600(0x9a7)]['Actor'][_0x5bc600(0x1e2)]:VisuMZ['BattleCore']['Settings'][_0x5bc600(0x199)][_0x5bc600(0x1e2)];},Game_Enemy[_0x1a8785(0x978)][_0x1a8785(0x720)]=function(_0x19a2a9){const _0x3f91a3=_0x1a8785;Game_Battler[_0x3f91a3(0x978)][_0x3f91a3(0x720)]['call'](this,_0x19a2a9);if(this[_0x3f91a3(0x907)]())this[_0x3f91a3(0x70e)](_0x19a2a9);},Game_Enemy[_0x1a8785(0x978)][_0x1a8785(0x608)]=function(){const _0xdbf5a7=_0x1a8785,_0x3543a7=this['svBattlerData']()[_0xdbf5a7(0x7d5)]||0x0,_0x2a24ec=$dataSystem[_0xdbf5a7(0x45d)][_0x3543a7];if(_0x2a24ec){if(_0x2a24ec[_0xdbf5a7(0x888)]===0x0)this[_0xdbf5a7(0x3a4)](_0xdbf5a7(0xa03));else{if(_0x2a24ec[_0xdbf5a7(0x888)]===0x1)this[_0xdbf5a7(0x3a4)]('swing');else _0x2a24ec[_0xdbf5a7(0x888)]===0x2&&this[_0xdbf5a7(0x3a4)](_0xdbf5a7(0x18c));}}},Game_Enemy[_0x1a8785(0x978)]['performWeaponAnimation']=function(){const _0x45154d=_0x1a8785,_0x587188=this[_0x45154d(0x49a)]()[_0x45154d(0x7d5)]||0x0,_0x4db198=$dataSystem['attackMotions'][_0x587188];_0x4db198&&this[_0x45154d(0x229)](_0x4db198[_0x45154d(0x2b5)]);},Game_Enemy[_0x1a8785(0x978)]['getAttackMotion']=function(){const _0x220be6=_0x1a8785,_0x153a1c=this[_0x220be6(0x49a)]()['wtypeId']||0x0;return $dataSystem['attackMotions'][_0x153a1c];},Game_Enemy[_0x1a8785(0x978)][_0x1a8785(0x657)]=function(_0x2a4a81){const _0x2e8104=_0x1a8785;return this[_0x2e8104(0x1fd)]();},Game_Enemy[_0x1a8785(0x978)][_0x1a8785(0x5a0)]=function(){const _0x547ad6=_0x1a8785;Game_Battler[_0x547ad6(0x978)][_0x547ad6(0x5a0)][_0x547ad6(0x716)](this),this[_0x547ad6(0x33e)]()&&this[_0x547ad6(0x907)]()&&this[_0x547ad6(0x3a4)](_0x547ad6(0x5c1)),SoundManager[_0x547ad6(0x672)]();},Game_Enemy[_0x1a8785(0x978)][_0x1a8785(0x84d)]=function(){const _0x235369=_0x1a8785;Game_Battler[_0x235369(0x978)][_0x235369(0x84d)]['call'](this),this['requestMotion'](_0x235369(0x6a4));},Game_Enemy[_0x1a8785(0x978)]['performMagicEvasion']=function(){const _0x2d6c27=_0x1a8785;Game_Battler['prototype'][_0x2d6c27(0x9cb)][_0x2d6c27(0x716)](this),this[_0x2d6c27(0x3a4)](_0x2d6c27(0x6a4));},Game_Enemy['prototype'][_0x1a8785(0x1aa)]=function(){const _0x527c6b=_0x1a8785;Game_Battler[_0x527c6b(0x978)][_0x527c6b(0x1aa)][_0x527c6b(0x716)](this),this[_0x527c6b(0x608)]();},Game_Enemy[_0x1a8785(0x978)]['allowCollapse']=function(){const _0x3835f3=_0x1a8785;if(this[_0x3835f3(0x907)]()){if(this[_0x3835f3(0x2a9)]()>=0x1)return!![];return this['svBattlerData']()[_0x3835f3(0x633)];}else return!![];},Game_Enemy[_0x1a8785(0x978)][_0x1a8785(0x191)]=function(){return this['svBattlerData']()['anchorX'];},Game_Enemy[_0x1a8785(0x978)][_0x1a8785(0x713)]=function(){const _0x3341ff=_0x1a8785;return this[_0x3341ff(0x49a)]()['anchorY'];},Game_Enemy[_0x1a8785(0x978)][_0x1a8785(0x2ad)]=function(){const _0xedb024=_0x1a8785;return this[_0xedb024(0x49a)]()['shadow'];},VisuMZ['BattleCore'][_0x1a8785(0x9aa)]=Game_Enemy[_0x1a8785(0x978)][_0x1a8785(0x696)],Game_Enemy[_0x1a8785(0x978)]['transform']=function(_0x5a447d){const _0x1de283=_0x1a8785;VisuMZ[_0x1de283(0x83c)]['Game_Enemy_transform'][_0x1de283(0x716)](this,_0x5a447d),this[_0x1de283(0x3d9)](),this['setupBattleCoreData']();const _0x10b503=this[_0x1de283(0x89e)]();_0x10b503&&(_0x10b503[_0x1de283(0x7b5)]=undefined,_0x10b503[_0x1de283(0x464)](this));},Game_Unit[_0x1a8785(0x978)][_0x1a8785(0x3bc)]=function(_0x40ea98){const _0x40a332=_0x1a8785;for(const _0x46b8b0 of this[_0x40a332(0x894)]()){if(_0x46b8b0)_0x46b8b0[_0x40a332(0x3bc)](_0x40ea98);}},Game_Unit['prototype'][_0x1a8785(0x96a)]=function(){const _0x4aa8c4=_0x1a8785,_0xc7426f=this[_0x4aa8c4(0x7b2)]();return _0xc7426f[Math[_0x4aa8c4(0x526)](_0xc7426f[_0x4aa8c4(0x2dc)])];},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0xb08)]=Game_Party[_0x1a8785(0x978)][_0x1a8785(0x4c3)],Game_Party['prototype'][_0x1a8785(0x4c3)]=function(_0x5e4a67){const _0x2707c7=_0x1a8785;VisuMZ[_0x2707c7(0x83c)][_0x2707c7(0xb08)][_0x2707c7(0x716)](this,_0x5e4a67),BattleManager[_0x2707c7(0x4dc)]();},VisuMZ['BattleCore']['Game_Party_removeActor']=Game_Party['prototype'][_0x1a8785(0x4d9)],Game_Party[_0x1a8785(0x978)][_0x1a8785(0x4d9)]=function(_0x5365dd){const _0x349324=_0x1a8785;VisuMZ[_0x349324(0x83c)]['Game_Party_removeActor'][_0x349324(0x716)](this,_0x5365dd),BattleManager[_0x349324(0x4dc)]();},VisuMZ['BattleCore']['Game_Troop_setup']=Game_Troop[_0x1a8785(0x978)][_0x1a8785(0x352)],Game_Troop['prototype'][_0x1a8785(0x352)]=function(_0x55f1a7){const _0x4cd062=_0x1a8785;$gameTemp[_0x4cd062(0x485)](),$gameTemp[_0x4cd062(0x8bb)](_0x55f1a7),VisuMZ[_0x4cd062(0x83c)][_0x4cd062(0x7e2)][_0x4cd062(0x716)](this,_0x55f1a7),this[_0x4cd062(0x4d5)]();},VisuMZ[_0x1a8785(0x83c)]['Game_Troop_expTotal']=Game_Troop['prototype'][_0x1a8785(0x3c6)],Game_Troop[_0x1a8785(0x978)][_0x1a8785(0x3c6)]=function(){const _0x5a9438=_0x1a8785;let _0x19e374=VisuMZ[_0x5a9438(0x83c)][_0x5a9438(0x451)]['call'](this);return this[_0x5a9438(0x527)]&&(_0x19e374*=this[_0x5a9438(0x527)]()),Math[_0x5a9438(0x348)](_0x19e374);},Game_Troop[_0x1a8785(0x978)][_0x1a8785(0x527)]=function(){return 0x1;},Game_Troop['prototype'][_0x1a8785(0x4d5)]=function(){const _0x36d488=_0x1a8785,_0x12c485=DataManager['createTroopNote'](this[_0x36d488(0x7ee)]()['id']);if(_0x12c485['match'](/<(?:EXTEND|ADD):[ ](.*?)>/i)){const _0x32fbec=RegExp['$1'][_0x36d488(0x2d7)](',')[_0x36d488(0x628)](_0x486595=>Number(_0x486595));this[_0x36d488(0x3f4)](),this[_0x36d488(0x356)](_0x32fbec);}},Game_Troop[_0x1a8785(0x978)][_0x1a8785(0x3f4)]=function(){const _0x27a820=_0x1a8785;let _0x993c1f='Update\x20your\x20Battle\x20System\x20-\x20%1\x20to\x20the\x20latest'+'\x0a';_0x993c1f+=_0x27a820(0x3ef),Imported[_0x27a820(0x2f5)]&&(VisuMZ[_0x27a820(0x703)]['version']<1.11&&(alert(_0x993c1f[_0x27a820(0x22f)](_0x27a820(0x798))),SceneManager[_0x27a820(0x821)]())),Imported['VisuMZ_2_BattleSystemCTB']&&(VisuMZ[_0x27a820(0x56f)][_0x27a820(0xa23)]<1.19&&(alert(_0x993c1f[_0x27a820(0x22f)]('CTB')),SceneManager[_0x27a820(0x821)]())),Imported['VisuMZ_2_BattleSystemSTB']&&(VisuMZ[_0x27a820(0x90e)]['version']<1.15&&(alert(_0x993c1f[_0x27a820(0x22f)](_0x27a820(0x8fc))),SceneManager[_0x27a820(0x821)]()));},Game_Troop[_0x1a8785(0x978)][_0x1a8785(0x356)]=function(_0x143219){const _0x58ad76=_0x1a8785;this[_0x58ad76(0xace)]={};for(const _0x4c5f67 of this[_0x58ad76(0x894)]()){if(!_0x4c5f67)continue;_0x4c5f67['setLetter']('');}for(const _0x345ac0 of _0x143219){const _0x16f80d=$dataTroops[_0x345ac0];if(_0x16f80d)this['addExtendedTroopMembers'](_0x16f80d);}this[_0x58ad76(0x308)]();},Game_Troop[_0x1a8785(0x978)][_0x1a8785(0x29d)]=function(_0x4d830b){const _0x56f641=_0x1a8785;for(const _0x2a9d39 of _0x4d830b[_0x56f641(0x894)]){if($dataEnemies[_0x2a9d39[_0x56f641(0x667)]]){const _0x4c1432=_0x2a9d39['enemyId'],_0x561e98=_0x2a9d39['x'],_0x5212da=_0x2a9d39['y'],_0x13fdfd=new Game_Enemy(_0x4c1432,_0x561e98,_0x5212da);_0x2a9d39['hidden']&&_0x13fdfd[_0x56f641(0x6f7)](),this[_0x56f641(0x51e)]['push'](_0x13fdfd);}}},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x661)]=Game_Map[_0x1a8785(0x978)][_0x1a8785(0x3c4)],Game_Map[_0x1a8785(0x978)]['setupBattleback']=function(){const _0xe46138=_0x1a8785;VisuMZ[_0xe46138(0x83c)]['Game_Map_setupBattleback'][_0xe46138(0x716)](this),this[_0xe46138(0x3b5)]();},Game_Map[_0x1a8785(0x978)][_0x1a8785(0x3b5)]=function(){const _0x25a64e=_0x1a8785;this[_0x25a64e(0x4df)]={},this[_0x25a64e(0x901)]={};if(!$dataMap)return;const _0x2b3f27=$dataMap[_0x25a64e(0x9c6)];if(!_0x2b3f27)return;const _0xd9c249=_0x2b3f27['match'](/<REGION (\d+) BATTLEBACK(\d+): (.*)>/gi);if(_0xd9c249)for(const _0x3dce6c of _0xd9c249){_0x3dce6c[_0x25a64e(0x9e0)](/<REGION (\d+) BATTLEBACK(\d+): (.*)>/i);const _0x374d66=Number(RegExp['$1']),_0x301a38=Number(RegExp['$2']),_0x25349d=_0x301a38===0x1?this[_0x25a64e(0x4df)]:this[_0x25a64e(0x901)],_0x1c0654=String(RegExp['$3']);_0x25349d[_0x374d66]=_0x1c0654;}},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0xa17)]=Game_Map[_0x1a8785(0x978)][_0x1a8785(0x515)],Game_Map['prototype']['battleback1Name']=function(){const _0x41aaf7=_0x1a8785;if(!BattleManager['isBattleTest']()){const _0x139155=$gamePlayer[_0x41aaf7(0x632)]($gamePlayer['x'],$gamePlayer['y']);if(this[_0x41aaf7(0x4df)]&&this[_0x41aaf7(0x4df)][_0x139155])return this[_0x41aaf7(0x4df)][_0x139155];}return VisuMZ['BattleCore'][_0x41aaf7(0xa17)][_0x41aaf7(0x716)](this);},VisuMZ['BattleCore'][_0x1a8785(0x874)]=Game_Map['prototype']['battleback2Name'],Game_Map['prototype'][_0x1a8785(0x72c)]=function(){const _0x589aba=_0x1a8785;if(!BattleManager[_0x589aba(0x27c)]()){const _0x46cfdb=$gamePlayer['regionId']($gamePlayer['x'],$gamePlayer['y']);if(this['_regionBattleback1']&&this[_0x589aba(0x901)][_0x46cfdb])return this[_0x589aba(0x901)][_0x46cfdb];}return VisuMZ['BattleCore'][_0x589aba(0x874)][_0x589aba(0x716)](this);},VisuMZ[_0x1a8785(0x83c)]['Game_Map_encounterList']=Game_Map[_0x1a8785(0x978)][_0x1a8785(0x1c8)],Game_Map['prototype'][_0x1a8785(0x1c8)]=function(){const _0x5e9ad7=_0x1a8785;let _0x484c61=JsonEx['makeDeepCopy'](VisuMZ[_0x5e9ad7(0x83c)][_0x5e9ad7(0x6fe)][_0x5e9ad7(0x716)](this));return VisuMZ[_0x5e9ad7(0x83c)][_0x5e9ad7(0x84e)](_0x484c61);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x84e)]=function(_0x43cec9){const _0x5db077=_0x1a8785;var _0x3f89ed,_0x222739,_0x17c28a;for(_0x17c28a=_0x43cec9[_0x5db077(0x2dc)]-0x1;_0x17c28a>0x0;_0x17c28a--){_0x3f89ed=Math[_0x5db077(0x4a7)](Math[_0x5db077(0x876)]()*(_0x17c28a+0x1)),_0x222739=_0x43cec9[_0x17c28a],_0x43cec9[_0x17c28a]=_0x43cec9[_0x3f89ed],_0x43cec9[_0x3f89ed]=_0x222739;}return _0x43cec9;},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x33a)]=Game_Interpreter[_0x1a8785(0x978)][_0x1a8785(0x4c7)],Game_Interpreter[_0x1a8785(0x978)][_0x1a8785(0x4c7)]=function(_0x4b8066){const _0x44f0da=_0x1a8785;return $gameTemp[_0x44f0da(0x39e)](this),VisuMZ['BattleCore'][_0x44f0da(0x33a)][_0x44f0da(0x716)](this,_0x4b8066);},VisuMZ['BattleCore']['Game_Interpreter_updateWaitMode']=Game_Interpreter['prototype']['updateWaitMode'],Game_Interpreter[_0x1a8785(0x978)][_0x1a8785(0x363)]=function(){const _0x535e8e=_0x1a8785;if(SceneManager[_0x535e8e(0x3a8)]())switch(this[_0x535e8e(0x934)]){case _0x535e8e(0x6a3):if(Imported[_0x535e8e(0x9de)]){if($gameScreen[_0x535e8e(0x911)]()[_0x535e8e(0x7b4)]>0x0)return!![];this[_0x535e8e(0x934)]='';}break;case _0x535e8e(0x2c0):if(BattleManager[_0x535e8e(0x589)]['isAnimationPlaying']())return!![];this[_0x535e8e(0x934)]='';break;case _0x535e8e(0x638):if(Imported[_0x535e8e(0x9de)]){if($gameScreen['battleCameraData']()[_0x535e8e(0x580)]>0x0)return!![];if($gameScreen[_0x535e8e(0x911)]()[_0x535e8e(0x6c3)]>0x0)return!![];this[_0x535e8e(0x934)]='';}break;case _0x535e8e(0x8ba):if(BattleManager[_0x535e8e(0x589)][_0x535e8e(0x57b)]())return!![];this[_0x535e8e(0x934)]='';break;case _0x535e8e(0x5df):if(BattleManager[_0x535e8e(0x589)][_0x535e8e(0x409)]())return!![];this[_0x535e8e(0x934)]='';break;case _0x535e8e(0x66b):if(BattleManager['_spriteset'][_0x535e8e(0x1be)]())return!![];this['_waitMode']='';break;case _0x535e8e(0x468):if(BattleManager[_0x535e8e(0x2f3)][_0x535e8e(0x5ce)]())return!![];this[_0x535e8e(0x934)]='';break;case _0x535e8e(0x248):if(BattleManager[_0x535e8e(0x589)]['isAnyoneMoving']())return!![];this[_0x535e8e(0x934)]='';break;case _0x535e8e(0x647):if(BattleManager[_0x535e8e(0x589)][_0x535e8e(0x3d0)]())return!![];this[_0x535e8e(0x934)]='';break;case'battleGrow':if(BattleManager[_0x535e8e(0x589)][_0x535e8e(0xa06)]())return!![];this[_0x535e8e(0x934)]='';break;case'battleSpriteSkew':if(BattleManager[_0x535e8e(0x589)]['isAnyoneSkewing']())return!![];this[_0x535e8e(0x934)]='';break;case _0x535e8e(0x21f):if(Imported[_0x535e8e(0x937)]){if(BattleManager[_0x535e8e(0x589)]['isAnyProjectilePresent']())return!![];this[_0x535e8e(0x934)]='';}break;case _0x535e8e(0xaa0):if(Imported[_0x535e8e(0x9de)]){if($gameScreen['battleCameraData']()['skewDuration']>0x0)return!![];this[_0x535e8e(0x934)]='';}break;case'battleSpin':if(BattleManager['_spriteset'][_0x535e8e(0x61b)]())return!![];this[_0x535e8e(0x934)]='';break;case _0x535e8e(0x921):if(Imported[_0x535e8e(0x9de)]){if($gameScreen[_0x535e8e(0x911)]()['zoomDuration']>0x0)return!![];this['_waitMode']='';}break;case _0x535e8e(0x611):if(Imported[_0x535e8e(0x9d4)]){if(BattleManager[_0x535e8e(0x589)][_0x535e8e(0x22c)]){if(BattleManager['_spriteset'][_0x535e8e(0x22c)]())return!![];this[_0x535e8e(0x934)]=_0x535e8e(0x40a);}else this[_0x535e8e(0x934)]='';break;}break;case _0x535e8e(0x40a):if(Imported[_0x535e8e(0x9d4)]){if(BattleManager[_0x535e8e(0x589)][_0x535e8e(0x466)]())return!![];this[_0x535e8e(0x934)]='';}break;}return VisuMZ[_0x535e8e(0x83c)][_0x535e8e(0x849)]['call'](this);},VisuMZ[_0x1a8785(0x83c)]['Game_Interpreter_command301']=Game_Interpreter[_0x1a8785(0x978)][_0x1a8785(0x261)],Game_Interpreter[_0x1a8785(0x978)][_0x1a8785(0x261)]=function(_0x4093a7){const _0x1a366c=_0x1a8785;return!$gameParty[_0x1a366c(0x255)]()?this[_0x1a366c(0xa95)](_0x4093a7):VisuMZ[_0x1a366c(0x83c)][_0x1a366c(0x5b1)][_0x1a366c(0x716)](this,_0x4093a7);},Game_Interpreter[_0x1a8785(0x978)]['command3011']=function(_0x9f18a8){const _0x18c71f=_0x1a8785;return VisuMZ[_0x18c71f(0x83c)][_0x18c71f(0x5b1)][_0x18c71f(0x716)](this,_0x9f18a8),BattleManager[_0x18c71f(0x724)](_0x40a9b8=>{const _0x142e9c=_0x18c71f;this['_branch'][this[_0x142e9c(0x3f6)]]=_0x40a9b8;}),!![];},VisuMZ['BattleCore'][_0x1a8785(0xa8c)]=function(_0x4d47eb){const _0x5b5f23=_0x1a8785,_0x2e5025=$dataCommonEvents[_0x4d47eb];if(!_0x2e5025)return![];if(_0x2e5025[_0x5b5f23(0x43b)][_0x5b5f23(0x2dc)]<=0x1)return![];return!![];},Game_Interpreter[_0x1a8785(0x978)][_0x1a8785(0xa95)]=function(_0x15deb1){const _0x246414=_0x1a8785,_0x3516b3=VisuMZ[_0x246414(0x83c)][_0x246414(0x9a7)][_0x246414(0x1af)],_0x5cb20a=_0x3516b3[_0x246414(0x1dd)],_0x1b3d5f=$dataCommonEvents[_0x5cb20a];if(_0x1b3d5f&&VisuMZ[_0x246414(0x83c)][_0x246414(0xa8c)](_0x5cb20a)){const _0x810170=this[_0x246414(0x987)]()?this['_eventId']:0x0,_0x327833=_0x1b3d5f[_0x246414(0x43b)];this['setupChild'](_0x327833,_0x810170),this[_0x246414(0x5be)]=JsonEx['makeDeepCopy'](this[_0x246414(0x5be)]);const _0x1361fb={'code':0xbc3,'indent':this[_0x246414(0x3f6)],'parameters':JsonEx[_0x246414(0x950)](_0x15deb1)};return this[_0x246414(0x5be)]['splice'](this['_index']+0x1,0x0,_0x1361fb),!![];}else return VisuMZ[_0x246414(0x83c)][_0x246414(0x5b1)][_0x246414(0x716)](this,_0x15deb1);},VisuMZ[_0x1a8785(0x83c)]['BattleManager_onEncounter']=BattleManager[_0x1a8785(0x8de)],BattleManager['onEncounter']=function(){const _0x48a734=_0x1a8785;VisuMZ[_0x48a734(0x83c)][_0x48a734(0x559)][_0x48a734(0x716)](this),this['onEncounterBattleCore']();},BattleManager[_0x1a8785(0x833)]=function(){const _0x5995a2=_0x1a8785,_0x25de5e=VisuMZ[_0x5995a2(0x83c)][_0x5995a2(0x9a7)][_0x5995a2(0x1af)],_0x5de8b1=_0x25de5e[_0x5995a2(0x1dd)];_0x5de8b1&&VisuMZ[_0x5995a2(0x83c)]['CheckMapBattleEventValid'](_0x5de8b1)&&(this[_0x5995a2(0xa68)]=!![],$gameTemp[_0x5995a2(0x93f)](_0x25de5e[_0x5995a2(0x1dd)]),$gameMap[_0x5995a2(0x556)](),$gameMap[_0x5995a2(0x285)][_0x5995a2(0x32a)]=!![]),_0x25de5e['DefeatEvent']>0x0&&(this['_canLose']=!![]);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x646)]=Scene_Map['prototype'][_0x1a8785(0x510)],Scene_Map['prototype'][_0x1a8785(0x510)]=function(){const _0x487dbe=_0x1a8785;if(BattleManager[_0x487dbe(0xa68)])return;VisuMZ[_0x487dbe(0x83c)]['Scene_Map_updateCallMenu']['call'](this);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x2ec)]=Scene_Map['prototype'][_0x1a8785(0x17d)],Scene_Map['prototype'][_0x1a8785(0x17d)]=function(){const _0x2e4486=_0x1a8785;BattleManager['_battleCoreBattleStartEvent']?this[_0x2e4486(0x438)]():VisuMZ[_0x2e4486(0x83c)][_0x2e4486(0x2ec)][_0x2e4486(0x716)](this);},Scene_Map[_0x1a8785(0x978)][_0x1a8785(0x438)]=function(){const _0x310044=_0x1a8785;this[_0x310044(0x82e)]=!![];},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x5d9)]=SceneManager[_0x1a8785(0x314)],SceneManager['isSceneChanging']=function(){const _0x99e6fa=_0x1a8785;if(BattleManager[_0x99e6fa(0xa68)])return![];return VisuMZ[_0x99e6fa(0x83c)]['SceneManager_isSceneChanging'][_0x99e6fa(0x716)](this);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x1d5)]=Game_Interpreter[_0x1a8785(0x978)][_0x1a8785(0x2e6)],Game_Interpreter[_0x1a8785(0x978)][_0x1a8785(0x2e6)]=function(){const _0x10fc08=_0x1a8785;VisuMZ[_0x10fc08(0x83c)][_0x10fc08(0x1d5)][_0x10fc08(0x716)](this),this[_0x10fc08(0x32a)]&&(this[_0x10fc08(0x32a)]=undefined,SceneManager[_0x10fc08(0xa42)]['battleCoreResumeLaunchBattle']());},Scene_Map[_0x1a8785(0x978)]['battleCoreResumeLaunchBattle']=function(){const _0xc94e5=_0x1a8785;BattleManager[_0xc94e5(0xa68)]=undefined,BattleManager[_0xc94e5(0x307)]=!![],this[_0xc94e5(0x5cd)]();},VisuMZ[_0x1a8785(0x83c)]['Scene_Map_initializeAfter']=Scene_Map[_0x1a8785(0x978)][_0x1a8785(0x3cf)],Scene_Map[_0x1a8785(0x978)]['initialize']=function(){const _0x44d3d1=_0x1a8785;VisuMZ[_0x44d3d1(0x83c)][_0x44d3d1(0x8f9)][_0x44d3d1(0x716)](this),BattleManager[_0x44d3d1(0x307)]&&(this[_0x44d3d1(0x82e)]=!![],BattleManager[_0x44d3d1(0x307)]=undefined);},VisuMZ[_0x1a8785(0x83c)]['Scene_Map_initialize']=Scene_Map['prototype']['initialize'],Scene_Map[_0x1a8785(0x978)][_0x1a8785(0x3cf)]=function(){const _0x750de4=_0x1a8785;VisuMZ['BattleCore'][_0x750de4(0x63f)][_0x750de4(0x716)](this),$gameTemp[_0x750de4(0x485)]();},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x9ac)]=Scene_ItemBase[_0x1a8785(0x978)][_0x1a8785(0x4d7)],Scene_ItemBase[_0x1a8785(0x978)]['applyItem']=function(){const _0x2447ac=_0x1a8785;VisuMZ[_0x2447ac(0x83c)][_0x2447ac(0x9ac)][_0x2447ac(0x716)](this);if(this[_0x2447ac(0x7e0)]()[_0x2447ac(0x9c6)][_0x2447ac(0x9e0)](/<BYPASS AUTO ACTION SEQUENCE>/i))return;this[_0x2447ac(0x7e0)]()[_0x2447ac(0x9c6)][_0x2447ac(0x9e0)](/<CUSTOM ACTION SEQUENCE>/i)&&($gameTemp[_0x2447ac(0x4b5)]=[]),DataManager[_0x2447ac(0x35a)](this['item']())&&($gameTemp[_0x2447ac(0x4b5)]=[]);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x19e)]=Scene_Options[_0x1a8785(0x978)][_0x1a8785(0x56c)],Scene_Options['prototype'][_0x1a8785(0x56c)]=function(){const _0x4d1706=_0x1a8785;let _0x2a6a1d=VisuMZ[_0x4d1706(0x83c)][_0x4d1706(0x19e)][_0x4d1706(0x716)](this);const _0x1dd4ab=VisuMZ[_0x4d1706(0x83c)][_0x4d1706(0x9a7)];if(_0x1dd4ab[_0x4d1706(0x224)][_0x4d1706(0x542)]&&_0x1dd4ab[_0x4d1706(0x224)]['AdjustRect'])_0x2a6a1d+=0x2;if(_0x1dd4ab[_0x4d1706(0x9d0)]['AddOption']&&_0x1dd4ab['HpGauge'][_0x4d1706(0xabe)])_0x2a6a1d+=0x1;return _0x2a6a1d;},VisuMZ[_0x1a8785(0x83c)]['Scene_Battle_initialize']=Scene_Battle['prototype']['initialize'],Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x3cf)]=function(){const _0x1b79ba=_0x1a8785;VisuMZ[_0x1b79ba(0x83c)]['Scene_Battle_initialize']['call'](this),this[_0x1b79ba(0x59b)]();},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x50b)]=Scene_Battle['prototype'][_0x1a8785(0x6f1)],Scene_Battle[_0x1a8785(0x978)]['start']=function(){const _0x48bbaf=_0x1a8785;SceneManager[_0x48bbaf(0x569)]()?(Scene_Message['prototype'][_0x48bbaf(0x6f1)][_0x48bbaf(0x716)](this),this[_0x48bbaf(0x589)]&&this[_0x48bbaf(0x589)][_0x48bbaf(0x31a)](),BattleManager['_tpbSceneChangeCacheActor']&&BattleManager[_0x48bbaf(0x3e9)]()):(VisuMZ['BattleCore']['Scene_Battle_start']['call'](this),$gameTroop[_0x48bbaf(0x498)]());},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x4b0)]=Scene_Battle[_0x1a8785(0x978)]['stop'],Scene_Battle[_0x1a8785(0x978)]['stop']=function(){const _0x5577b1=_0x1a8785;SceneManager['isNextSceneBattleTransitionable']()?Scene_Message[_0x5577b1(0x978)][_0x5577b1(0x5cd)][_0x5577b1(0x716)](this):VisuMZ['BattleCore']['Scene_Battle_stop'][_0x5577b1(0x716)](this);},VisuMZ['BattleCore'][_0x1a8785(0x3c7)]=Scene_Battle['prototype']['terminate'],Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x2e6)]=function(){const _0x5ab79f=_0x1a8785;SceneManager[_0x5ab79f(0x8d4)]()?Scene_Message[_0x5ab79f(0x978)][_0x5ab79f(0x2e6)]['call'](this):VisuMZ[_0x5ab79f(0x83c)][_0x5ab79f(0x3c7)][_0x5ab79f(0x716)](this),this[_0x5ab79f(0x59b)]();},Scene_Battle['prototype']['isRightInputMode']=function(){const _0x77a901=_0x1a8785;if(ConfigManager[_0x77a901(0x2a0)]&&ConfigManager['uiInputPosition']!==undefined)return ConfigManager[_0x77a901(0x66e)];else{if(this[_0x77a901(0x367)]()===_0x77a901(0x617))return![];else{return Scene_Message[_0x77a901(0x978)]['isRightInputMode'][_0x77a901(0x716)](this);;}}},VisuMZ[_0x1a8785(0x83c)]['Scene_Battle_createAllWindows']=Scene_Battle['prototype'][_0x1a8785(0x7b8)],Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x7b8)]=function(){const _0x31b66f=_0x1a8785;this[_0x31b66f(0xa84)](),VisuMZ[_0x31b66f(0x83c)][_0x31b66f(0xae9)]['call'](this),this[_0x31b66f(0x1a7)]();},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x7ae)]=Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x5fc)],Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x5fc)]=function(){const _0x2821df=_0x1a8785;VisuMZ[_0x2821df(0x83c)]['Scene_Battle_createEnemyWindow']['call'](this),this[_0x2821df(0x27d)]();},Scene_Battle['prototype'][_0x1a8785(0x27d)]=function(){const _0xe88464=_0x1a8785;this[_0xe88464(0x3d5)](!![]),this[_0xe88464(0x3d5)](![]);},Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x5d1)]=function(_0x24e5c0){const _0x442a49=_0x1a8785,_0x4a2ffc=Window_BattleMultiTarget[_0x442a49(0xaea)],_0x32c472=this[_0x442a49(0x747)](0x1,!![]);let _0x3fcb4f=_0x24e5c0?Graphics[_0x442a49(0x9ab)]-_0x4a2ffc:0x0;_0x3fcb4f+=_0x24e5c0?Window_BattleMultiTarget[_0x442a49(0x2b8)]:Window_BattleMultiTarget[_0x442a49(0x1ee)];const _0xb69978=[_0x442a49(0x955)][_0x442a49(0xa3e)](this['battleLayoutStyle']())?0x0:this[_0x442a49(0x2ac)][_0x442a49(0x98e)];let _0x244373=Graphics[_0x442a49(0x69d)]-_0xb69978-_0x32c472;return _0x244373+=_0x24e5c0?Window_BattleMultiTarget[_0x442a49(0x7a3)]:Window_BattleMultiTarget['ENEMY_OFFSET_Y'],new Rectangle(_0x3fcb4f,_0x244373,_0x4a2ffc,_0x32c472);},Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x3d5)]=function(_0x53e7bc){const _0x4fe69a=_0x1a8785,_0xdaaab3=this[_0x4fe69a(0x5d1)](_0x53e7bc),_0x10173d=new Window_BattleMultiTarget(_0xdaaab3,_0x53e7bc);this[_0x4fe69a(0x8e5)](_0x10173d),_0x53e7bc?this[_0x4fe69a(0x22d)]=_0x10173d:this['_enemyMultiTargetWindow']=_0x10173d;},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0xa8f)]=Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x44c)],Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x44c)]=function(){const _0x471284=_0x1a8785;VisuMZ[_0x471284(0x83c)][_0x471284(0xa8f)][_0x471284(0x716)](this),this['battleLayoutStyle']()==='border'&&this[_0x471284(0x2b4)]();},Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x839)]=function(_0x387904){const _0x3e846e=_0x1a8785;_0x387904?(this[_0x3e846e(0x531)]['x']=(Graphics[_0x3e846e(0x92d)]-Graphics[_0x3e846e(0x9ab)])/0x2,this[_0x3e846e(0x531)]['y']=(Graphics[_0x3e846e(0x98e)]-Graphics[_0x3e846e(0x69d)])/0x2):(this[_0x3e846e(0x531)]['x']=Graphics[_0x3e846e(0x92d)]*0xa,this[_0x3e846e(0x531)]['y']=Graphics['height']*0xa);},VisuMZ[_0x1a8785(0x83c)]['Scene_Battle_selectNextCommand']=Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x592)],Scene_Battle['prototype'][_0x1a8785(0x592)]=function(){const _0xe21884=_0x1a8785,_0x1ce1ec=BattleManager[_0xe21884(0x7fd)]();VisuMZ[_0xe21884(0x83c)][_0xe21884(0x74d)][_0xe21884(0x716)](this);if(_0x1ce1ec){if(_0x1ce1ec===BattleManager[_0xe21884(0x7fd)]())return;if(_0x1ce1ec===BattleManager[_0xe21884(0x938)])return;if(_0x1ce1ec[_0xe21884(0x89e)]())_0x1ce1ec[_0xe21884(0x89e)]()[_0xe21884(0x56b)]();}},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0xa5b)]=Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x3e2)],Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x3e2)]=function(){const _0x2cdd7b=_0x1a8785,_0x12b432=BattleManager[_0x2cdd7b(0x7fd)]();if(_0x12b432&&_0x12b432[_0x2cdd7b(0x89e)])_0x12b432['battler']()[_0x2cdd7b(0x56b)]();VisuMZ['BattleCore'][_0x2cdd7b(0xa5b)]['call'](this);},VisuMZ[_0x1a8785(0x83c)]['Scene_Battle_logWindowRect']=Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x9bc)],Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x9bc)]=function(){const _0x510304=_0x1a8785;if(VisuMZ[_0x510304(0x83c)][_0x510304(0x9a7)]['BattleLog'][_0x510304(0xad0)])return VisuMZ[_0x510304(0x83c)][_0x510304(0x9a7)]['BattleLog'][_0x510304(0xad0)][_0x510304(0x716)](this);return VisuMZ[_0x510304(0x83c)]['Scene_Battle_logWindowRect'][_0x510304(0x716)](this);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x68e)]=Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x856)],Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x856)]=function(){const _0xd13482=_0x1a8785;VisuMZ['BattleCore'][_0xd13482(0x68e)][_0xd13482(0x716)](this),this[_0xd13482(0xad1)]();},Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0xad1)]=function(){const _0x313ece=_0x1a8785,_0x509427=this[_0x313ece(0x319)];_0x509427[_0x313ece(0x936)](_0x313ece(0x476),this['commandAutoBattle'][_0x313ece(0x6e7)](this)),_0x509427[_0x313ece(0x936)](_0x313ece(0x215),this[_0x313ece(0x337)][_0x313ece(0x6e7)](this));const _0x21126b=this[_0x313ece(0x367)]();switch(_0x21126b){case'xp':case _0x313ece(0x5b2):return this['_partyCommandWindow'][_0x313ece(0x7de)](0x1);break;}},Scene_Battle[_0x1a8785(0x978)]['commandAutoBattle']=function(){const _0x402531=_0x1a8785;BattleManager['_autoBattle']=!![],$gameParty[_0x402531(0x581)](),this['selectNextCommand'](),BattleManager[_0x402531(0x875)]()&&(BattleManager[_0x402531(0x67d)]=![]);},Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x337)]=function(){const _0x15bbae=_0x1a8785;this['isQueueOptionsMenu']()?(this[_0x15bbae(0x4b8)]=!![],this['_logWindow']['push'](_0x15bbae(0x9a4),VisuMZ[_0x15bbae(0x83c)][_0x15bbae(0x9a7)]['PartyCmd']['ActiveTpbOptionsMessage'])):this['callOptions']();},Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x3c9)]=function(){const _0x432a69=_0x1a8785;return BattleManager[_0x432a69(0x28e)]();},Scene_Battle[_0x1a8785(0x978)]['callOptions']=function(){const _0xa0c94b=_0x1a8785;this[_0xa0c94b(0x4b8)]=![],this[_0xa0c94b(0x589)][_0xa0c94b(0x31a)](),this[_0xa0c94b(0x531)]['visible']=![];if(BattleManager[_0xa0c94b(0x27c)]())($dataSystem['battleback1Name']||$dataSystem[_0xa0c94b(0x72c)])&&SceneManager[_0xa0c94b(0x68f)]();else($gameMap['battleback1Name']()||$gameMap[_0xa0c94b(0x72c)]())&&SceneManager[_0xa0c94b(0x68f)]();SceneManager['push'](Scene_Options),BattleManager['isTpb']()&&(BattleManager['_tpbSceneChangeCacheActor']=BattleManager[_0xa0c94b(0x7fd)]());},VisuMZ['BattleCore']['Scene_Battle_updateBattleProcess']=Scene_Battle[_0x1a8785(0x978)]['updateBattleProcess'],Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0xa1d)]=function(){const _0x57ea55=_0x1a8785;VisuMZ[_0x57ea55(0x83c)][_0x57ea55(0xaaa)]['call'](this);if(this[_0x57ea55(0x4b8)]&&!BattleManager[_0x57ea55(0x938)])this['callOptions']();},VisuMZ[_0x1a8785(0x83c)]['Scene_Battle_update']=Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x31a)],Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x31a)]=function(){const _0x378eb9=_0x1a8785;VisuMZ[_0x378eb9(0x83c)]['Scene_Battle_update'][_0x378eb9(0x716)](this),this['updateOnceParallelInterpreters']();},Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x1a7)]=function(){const _0x20d97c=_0x1a8785,_0x588b1c=this['autoBattleWindowRect']();this[_0x20d97c(0x9ae)]=new Window_AutoBattleCancel(_0x588b1c),this['_autoBattleWindow']['hide'](),this['addChild'](this[_0x20d97c(0x9ae)]);},Scene_Battle['prototype'][_0x1a8785(0x9c4)]=function(){const _0x10f4d3=_0x1a8785;return VisuMZ[_0x10f4d3(0x83c)][_0x10f4d3(0x9a7)]['AutoBattle'][_0x10f4d3(0x7d3)]['call'](this);},Scene_Battle[_0x1a8785(0x978)]['clearOnceParallelInterpreters']=function(){const _0x22e25f=_0x1a8785;this[_0x22e25f(0x521)]=[];},Scene_Battle['prototype']['updateOnceParallelInterpreters']=function(){const _0x522102=_0x1a8785;if(!this['_onceParallelInterpreters'])return;for(const _0x2c948c of this['_onceParallelInterpreters']){_0x2c948c&&_0x2c948c[_0x522102(0x31a)]();}},Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x8a3)]=function(_0x30b38a){const _0x382596=_0x1a8785,_0x783ccf=$dataCommonEvents[_0x30b38a];if(!_0x783ccf)return;const _0x4fc333=new Game_BattleOnceParallelInterpreter();this[_0x382596(0x8c9)](_0x4fc333),_0x4fc333['setCommonEvent'](_0x30b38a);},Scene_Battle[_0x1a8785(0x978)]['addOnceParallelInterpreter']=function(_0x35afd5){const _0x40503d=_0x1a8785;this['_onceParallelInterpreters']=this[_0x40503d(0x521)]||[],this[_0x40503d(0x521)][_0x40503d(0x963)](_0x35afd5);},Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x6b9)]=function(_0x387f30){const _0x537d01=_0x1a8785;this['_onceParallelInterpreters']=this[_0x537d01(0x521)]||[],this[_0x537d01(0x521)][_0x537d01(0xa3b)](_0x387f30);},Game_Troop[_0x1a8785(0x978)]['onBattleStartOnceParallels']=function(){const _0x44a415=_0x1a8785;for(const _0x4054fc of this[_0x44a415(0x7ee)]()['pages']){if(!this[_0x44a415(0x727)](_0x4054fc))continue;SceneManager[_0x44a415(0xa42)][_0x44a415(0x456)](_0x4054fc);}},Game_Troop[_0x1a8785(0x978)]['doesPageHaveOnceParallelStart']=function(_0xca3c72){const _0x2cb8d7=_0x1a8785;if(!_0xca3c72)return;for(const _0x3a6c31 of _0xca3c72[_0x2cb8d7(0x43b)]){if([0x6c,0x198]['includes'](_0x3a6c31[_0x2cb8d7(0xa2f)])){const _0x149ce4=_0x3a6c31[_0x2cb8d7(0x536)][0x0];if(_0x149ce4[_0x2cb8d7(0x9e0)](/<ONCE PARALLEL WHEN START BATTLE>/i))return!![];}}return![];},Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x456)]=function(_0x28ed4e){if(!_0x28ed4e)return;const _0x3e24ba=new Game_BattleOnceParallelInterpreter();this['addOnceParallelInterpreter'](_0x3e24ba),_0x3e24ba['setTroopPage'](_0x28ed4e);};function _0x416b(_0x3c294f,_0x4ef3db){const _0x2d08c3=_0x2d08();return _0x416b=function(_0x416bec,_0x2650de){_0x416bec=_0x416bec-0x178;let _0x5503c8=_0x2d08c3[_0x416bec];return _0x5503c8;},_0x416b(_0x3c294f,_0x4ef3db);}function Game_BattleOnceParallelInterpreter(){const _0x47ea11=_0x1a8785;this[_0x47ea11(0x3cf)](...arguments);}Game_BattleOnceParallelInterpreter[_0x1a8785(0x978)]=Object['create'](Game_Interpreter['prototype']),Game_BattleOnceParallelInterpreter['prototype']['constructor']=Game_BattleOnceParallelInterpreter,Game_BattleOnceParallelInterpreter[_0x1a8785(0x978)]['setCommonEvent']=function(_0x3955a1){const _0x480ede=_0x1a8785,_0x391c42=$dataCommonEvents[_0x3955a1];_0x391c42?this[_0x480ede(0x352)](_0x391c42[_0x480ede(0x43b)],0x0):this[_0x480ede(0x2e6)]();},Game_BattleOnceParallelInterpreter[_0x1a8785(0x978)][_0x1a8785(0x2e6)]=function(){const _0x2a49ca=_0x1a8785;if(!SceneManager[_0x2a49ca(0x3a8)]())return;SceneManager['_scene']['removeOnceParallelInterpreter'](this),Game_Interpreter[_0x2a49ca(0x978)][_0x2a49ca(0x2e6)][_0x2a49ca(0x716)](this);},Game_BattleOnceParallelInterpreter[_0x1a8785(0x978)]['setTroopPage']=function(_0x19df48){const _0x2150af=_0x1a8785;_0x19df48?this[_0x2150af(0x352)](_0x19df48[_0x2150af(0x43b)],0x0):this['terminate']();},Scene_Battle[_0x1a8785(0x978)]['isPartyCommandWindowDisabled']=function(){const _0x113133=_0x1a8785;return VisuMZ['BattleCore'][_0x113133(0x9a7)][_0x113133(0x504)][_0x113133(0x347)];},VisuMZ['BattleCore'][_0x1a8785(0x6ae)]=Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x5d0)],Scene_Battle[_0x1a8785(0x978)]['startPartyCommandSelection']=function(){const _0x2d5d59=_0x1a8785;this[_0x2d5d59(0xa8b)]()?this[_0x2d5d59(0xacb)]():VisuMZ[_0x2d5d59(0x83c)][_0x2d5d59(0x6ae)][_0x2d5d59(0x716)](this);},Scene_Battle[_0x1a8785(0x978)]['onDisabledPartyCommandSelection']=function(){const _0x1d6926=_0x1a8785;if(BattleManager[_0x1d6926(0x8ef)]())this[_0x1d6926(0x592)]();else BattleManager[_0x1d6926(0x875)]()&&VisuMZ['BattleCore'][_0x1d6926(0x6ae)]['call'](this);},VisuMZ[_0x1a8785(0x83c)]['Scene_Battle_commandFight']=Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x6c6)],Scene_Battle['prototype'][_0x1a8785(0x6c6)]=function(){const _0x408e9d=_0x1a8785;BattleManager['isTpb']()?(this[_0x408e9d(0x998)](),this[_0x408e9d(0x7da)]()):VisuMZ[_0x408e9d(0x83c)][_0x408e9d(0x41f)][_0x408e9d(0x716)](this);},Scene_Battle['prototype'][_0x1a8785(0x998)]=function(){const _0x268a4f=_0x1a8785;if(!VisuMZ[_0x268a4f(0x83c)][_0x268a4f(0x9d2)])return;if(Imported['VisuMZ_2_BattleSystemCTB']&&BattleManager['isCTB']())return;const _0x24b0aa=$gameParty['aliveMembers']()[_0x268a4f(0x70f)](_0x589ecc=>_0x589ecc[_0x268a4f(0x1a5)]()&&_0x589ecc[_0x268a4f(0x86c)]());BattleManager['_currentActor']=_0x24b0aa[0x0]||null,BattleManager[_0x268a4f(0x9d6)]&&BattleManager[_0x268a4f(0x9d6)][_0x268a4f(0x98a)](_0x268a4f(0x4b4));},VisuMZ[_0x1a8785(0x83c)]['Scene_Battle_createActorCommandWindow']=Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x216)],Scene_Battle['prototype'][_0x1a8785(0x216)]=function(){const _0x5bc1f5=_0x1a8785;VisuMZ[_0x5bc1f5(0x83c)][_0x5bc1f5(0x869)][_0x5bc1f5(0x716)](this),this[_0x5bc1f5(0x637)]();},Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x637)]=function(){const _0x2a2ffe=_0x1a8785,_0x219bcf=this[_0x2a2ffe(0x47d)];_0x219bcf[_0x2a2ffe(0x936)]('escape',this['actorCommandEscape'][_0x2a2ffe(0x6e7)](this)),_0x219bcf[_0x2a2ffe(0x936)](_0x2a2ffe(0x476),this[_0x2a2ffe(0x358)][_0x2a2ffe(0x6e7)](this)),_0x219bcf[_0x2a2ffe(0x936)](_0x2a2ffe(0x85c),this['actorCommandSingleSkill'][_0x2a2ffe(0x6e7)](this)),BattleManager[_0x2a2ffe(0x875)]()&&(this['isPartyCommandWindowDisabled']()?delete _0x219bcf[_0x2a2ffe(0x596)]['cancel']:_0x219bcf[_0x2a2ffe(0x936)](_0x2a2ffe(0xaec),this['actorCommandCancelTPB']['bind'](this)));},Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0xa7f)]=function(){const _0x435b6e=_0x1a8785;this[_0x435b6e(0x4d2)]();},Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x358)]=function(){const _0x25e80f=_0x1a8785;BattleManager[_0x25e80f(0x7fd)]()['makeAutoBattleActions'](),BattleManager[_0x25e80f(0x823)](),BattleManager[_0x25e80f(0x45a)](),this[_0x25e80f(0x73b)]();},Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0xa04)]=function(){const _0x5bfa51=_0x1a8785,_0x19fae0=BattleManager[_0x5bfa51(0x288)](),_0xac3f11=this['_actorCommandWindow'][_0x5bfa51(0x83e)]();_0x19fae0['setSkill'](_0xac3f11),BattleManager['actor']()[_0x5bfa51(0x805)]($dataSkills[_0xac3f11]),this[_0x5bfa51(0x5b3)]();},Scene_Battle['prototype'][_0x1a8785(0x525)]=function(){const _0x3ff60b=_0x1a8785;this[_0x3ff60b(0x842)]()?this[_0x3ff60b(0x8d0)]():this[_0x3ff60b(0x2ea)]();},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x9d2)]=![],Scene_Battle[_0x1a8785(0x978)]['tpbActorSwitchConditionsMet']=function(){const _0x47d1da=_0x1a8785;if(Imported[_0x47d1da(0x4f5)]&&BattleManager['isCTB']())return![];else{if(!VisuMZ[_0x47d1da(0x83c)][_0x47d1da(0x9d2)])return![];const _0xbcec90=$gameParty[_0x47d1da(0x7b2)]()[_0x47d1da(0x70f)](_0x5470ae=>_0x5470ae[_0x47d1da(0x1a5)]()&&_0x5470ae[_0x47d1da(0x86c)]());return _0xbcec90[_0x47d1da(0x2dc)]>0x0&&BattleManager[_0x47d1da(0x7fd)]()!==_0xbcec90[_0xbcec90[_0x47d1da(0x2dc)]-0x1];}},Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x8d0)]=function(){const _0x5036ca=_0x1a8785,_0x4a4244=BattleManager[_0x5036ca(0x7fd)](),_0x45f52a=_0x4a4244[_0x5036ca(0x89e)]();if(_0x45f52a)_0x45f52a[_0x5036ca(0x56b)]();const _0x4859c5=$gameParty[_0x5036ca(0x7b2)]()[_0x5036ca(0x70f)](_0x5358dc=>_0x5358dc[_0x5036ca(0x1a5)]()&&_0x5358dc[_0x5036ca(0x86c)]()),_0x4b1642=_0x4859c5[_0x5036ca(0x64f)](_0x4a4244),_0x39e524=_0x4859c5[_0x4b1642+0x1];BattleManager[_0x5036ca(0x9d6)]=_0x39e524||null;if(_0x39e524)_0x39e524[_0x5036ca(0x98a)](_0x5036ca(0x4b4));_0x4a4244[_0x5036ca(0x98a)](_0x5036ca(0x2df)),this[_0x5036ca(0x73b)]();},Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x2ea)]=function(){const _0x1a4e6a=_0x1a8785;this['_partyCommandWindow']['setup'](),this[_0x1a4e6a(0x47d)]['close']();if(!VisuMZ[_0x1a4e6a(0x83c)][_0x1a4e6a(0x9d2)])return;if(Imported[_0x1a4e6a(0x4f5)]&&BattleManager[_0x1a4e6a(0x789)]())return;if(BattleManager[_0x1a4e6a(0x9d6)]){BattleManager[_0x1a4e6a(0x9d6)]['setActionState']('undecided');const _0x486647=BattleManager[_0x1a4e6a(0x9d6)][_0x1a4e6a(0x89e)]();if(_0x486647)_0x486647[_0x1a4e6a(0x56b)]();}BattleManager[_0x1a4e6a(0x9d6)]=null;},VisuMZ['BattleCore'][_0x1a8785(0x4ae)]=Scene_Battle['prototype'][_0x1a8785(0x50e)],Scene_Battle['prototype'][_0x1a8785(0x50e)]=function(){const _0x492e73=_0x1a8785;VisuMZ['BattleCore'][_0x492e73(0x4ae)][_0x492e73(0x716)](this),this[_0x492e73(0x265)]();},Scene_Battle[_0x1a8785(0x978)]['createHelpWindowBattleCore']=function(){const _0x1fa2e2=_0x1a8785;this[_0x1fa2e2(0x47d)][_0x1fa2e2(0x206)](this[_0x1fa2e2(0x765)]),this[_0x1fa2e2(0x319)][_0x1fa2e2(0x206)](this['_helpWindow']);},Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x367)]=function(){const _0x13c3f0=_0x1a8785;if($gameTemp['_forcedBattleLayout']!==undefined)return $gameTemp[_0x13c3f0(0x68c)];if(this[_0x13c3f0(0xaf5)])return this[_0x13c3f0(0xaf5)];return this['_battleLayoutStyle']=VisuMZ[_0x13c3f0(0x83c)]['Settings']['BattleLayout']['Style'][_0x13c3f0(0x5dd)]()[_0x13c3f0(0x6b6)](),this[_0x13c3f0(0xaf5)]===_0x13c3f0(0x80e)&&!Imported[_0x13c3f0(0xa2b)]&&(this[_0x13c3f0(0xaf5)]=_0x13c3f0(0x3ee)),this[_0x13c3f0(0xaf5)]===_0x13c3f0(0x955)&&!Imported[_0x13c3f0(0xa71)]&&(this[_0x13c3f0(0xaf5)]=_0x13c3f0(0x3ee)),this[_0x13c3f0(0xaf5)];},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x757)]=Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x251)],Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x251)]=function(){const _0x445b8b=_0x1a8785,_0x69b6cd=this[_0x445b8b(0x367)]();switch(_0x69b6cd){case _0x445b8b(0x43b):return this['calcWindowHeight'](Math[_0x445b8b(0x5a7)](0x1,$gameParty[_0x445b8b(0x8a4)]()),!![]);break;default:return VisuMZ[_0x445b8b(0x83c)][_0x445b8b(0x757)]['call'](this);break;}},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x69b)]=Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x1d7)],Scene_Battle['prototype'][_0x1a8785(0x1d7)]=function(){const _0x41e98c=_0x1a8785,_0x2d83c6=this[_0x41e98c(0x367)]();switch(_0x2d83c6){case _0x41e98c(0x617):return this[_0x41e98c(0x882)]();break;case _0x41e98c(0x3ee):case _0x41e98c(0x43b):case'xp':case'portrait':default:return VisuMZ[_0x41e98c(0x83c)][_0x41e98c(0x69b)][_0x41e98c(0x716)](this);break;}},Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0xa3c)]=function(){const _0x52704b=_0x1a8785,_0x588ae6=this['battleLayoutStyle']();switch(_0x588ae6){case'xp':case'portrait':return this['statusWindowRectXPStyle']();break;case'border':return this[_0x52704b(0x824)]();break;case _0x52704b(0x3ee):case _0x52704b(0x43b):default:return this['statusWindowRectDefaultStyle']();break;}},VisuMZ['BattleCore'][_0x1a8785(0x2fa)]=Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x818)],Scene_Battle[_0x1a8785(0x978)]['partyCommandWindowRect']=function(){const _0x558116=_0x1a8785,_0x5187c3=this[_0x558116(0x367)]();switch(_0x5187c3){case'xp':case _0x558116(0x5b2):return this[_0x558116(0x481)]();break;case _0x558116(0x617):return this[_0x558116(0x8ee)]();case _0x558116(0x3ee):case _0x558116(0x43b):default:return this[_0x558116(0x289)]();break;}},Scene_Battle[_0x1a8785(0x978)]['partyCommandWindowRectDefaultStyle']=function(){const _0x469ce3=_0x1a8785,_0x3200d5=VisuMZ[_0x469ce3(0x83c)][_0x469ce3(0x9a7)][_0x469ce3(0x9bf)],_0xacea51=_0x3200d5[_0x469ce3(0xafb)]||0xc0,_0x2ce73d=this['windowAreaHeight'](),_0x584fbd=this[_0x469ce3(0x691)]()?Graphics[_0x469ce3(0x9ab)]-_0xacea51:0x0,_0x333b15=Graphics[_0x469ce3(0x69d)]-_0x2ce73d;return new Rectangle(_0x584fbd,_0x333b15,_0xacea51,_0x2ce73d);},Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x8f8)]=function(){const _0x36cfc0=_0x1a8785;return this[_0x36cfc0(0x818)]();},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0xa40)]=Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x5cb)],Scene_Battle['prototype']['updateStatusWindowPosition']=function(){const _0x4e31ee=_0x1a8785,_0x581d8b=this[_0x4e31ee(0x367)]();switch(_0x581d8b){case'xp':case _0x4e31ee(0x5b2):case _0x4e31ee(0x617):break;case'default':case _0x4e31ee(0x43b):default:VisuMZ[_0x4e31ee(0x83c)][_0x4e31ee(0xa40)][_0x4e31ee(0x716)](this);break;}},VisuMZ['BattleCore'][_0x1a8785(0xaa7)]=Scene_Battle['prototype']['startActorSelection'],Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x941)]=function(){const _0xba8ea9=_0x1a8785;VisuMZ['BattleCore']['Scene_Battle_startActorSelection'][_0xba8ea9(0x716)](this),this[_0xba8ea9(0x78f)]();},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x825)]=Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0xac8)],Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0xac8)]=function(){const _0x486f89=_0x1a8785;VisuMZ[_0x486f89(0x83c)]['Scene_Battle_startEnemySelection'][_0x486f89(0x716)](this),this['_enemyWindow'][_0x486f89(0x863)](),this[_0x486f89(0x78f)]();},Scene_Battle[_0x1a8785(0x978)]['makeTargetSelectionMoreVisible']=function(){const _0x20394b=_0x1a8785,_0x361c08=this[_0x20394b(0x367)]();['xp','portrait',_0x20394b(0x617)][_0x20394b(0xa3e)](_0x361c08)&&this[_0x20394b(0x47d)][_0x20394b(0x76e)](),(_0x361c08==='border'||this[_0x20394b(0x475)]())&&(this[_0x20394b(0x49e)][_0x20394b(0x76e)](),this[_0x20394b(0xa75)][_0x20394b(0x76e)]());},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0xa39)]=Scene_Battle['prototype']['onActorOk'],Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x2cf)]=function(){const _0xff3509=_0x1a8785;VisuMZ[_0xff3509(0x83c)][_0xff3509(0xa39)][_0xff3509(0x716)](this),this[_0xff3509(0x98b)]();},Scene_Battle['prototype'][_0x1a8785(0x441)]=function(){const _0x37474d=_0x1a8785;return[_0x37474d(0x432),_0x37474d(0x237),'singleSkill'][_0x37474d(0xa3e)](this['_actorCommandWindow'][_0x37474d(0x387)]());},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x36a)]=Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x974)],Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x974)]=function(){const _0xfc312c=_0x1a8785;this[_0xfc312c(0x441)]()?(this[_0xfc312c(0x2ac)][_0xfc312c(0x655)](),this[_0xfc312c(0x218)][_0xfc312c(0x6f7)](),this[_0xfc312c(0x47d)][_0xfc312c(0x5d7)]()):VisuMZ[_0xfc312c(0x83c)][_0xfc312c(0x36a)]['call'](this),this[_0xfc312c(0x610)]();},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x644)]=Scene_Battle['prototype'][_0x1a8785(0x455)],Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x455)]=function(){const _0x1b52f3=_0x1a8785,_0x3f2de0=BattleManager[_0x1b52f3(0x288)]();_0x3f2de0[_0x1b52f3(0x5db)](this['_enemyWindow'][_0x1b52f3(0x739)]()),this['_enemyWindow']['closeBattleActorWindow'](),VisuMZ['BattleCore'][_0x1b52f3(0x644)][_0x1b52f3(0x716)](this),this[_0x1b52f3(0x98b)]();},VisuMZ['BattleCore'][_0x1a8785(0x5c2)]=Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x5fe)],Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x5fe)]=function(){const _0x4b5247=_0x1a8785;this[_0x4b5247(0x441)]()?(this[_0x4b5247(0x2ac)][_0x4b5247(0x655)](),this[_0x4b5247(0xadc)][_0x4b5247(0x6f7)](),this[_0x4b5247(0x47d)]['activate']()):VisuMZ['BattleCore']['Scene_Battle_onEnemyCancel']['call'](this),this[_0x4b5247(0x610)](),this[_0x4b5247(0xadc)][_0x4b5247(0x371)]();},Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x98b)]=function(){const _0x584eaa=_0x1a8785,_0x4e6d60=this['battleLayoutStyle']();(_0x4e6d60===_0x584eaa(0x617)||this[_0x584eaa(0x475)]())&&(this[_0x584eaa(0x49e)][_0x584eaa(0x329)](),this[_0x584eaa(0x49e)][_0x584eaa(0x741)]&&this['_skillWindow'][_0x584eaa(0x655)](),this[_0x584eaa(0xa75)]['open'](),this['_itemWindow'][_0x584eaa(0x741)]&&this['_itemWindow'][_0x584eaa(0x655)]());},Scene_Battle['prototype'][_0x1a8785(0x610)]=function(){const _0x4f74e6=_0x1a8785,_0x335df4=this[_0x4f74e6(0x367)]();['xp',_0x4f74e6(0x5b2),_0x4f74e6(0x617)][_0x4f74e6(0xa3e)](_0x335df4)&&this[_0x4f74e6(0x47d)][_0x4f74e6(0x329)](),this['okTargetSelectionVisibility']();},Scene_Battle[_0x1a8785(0x978)]['statusWindowRectDefaultStyle']=function(){const _0x1d66de=_0x1a8785,_0x2766a6=VisuMZ[_0x1d66de(0x83c)][_0x1d66de(0x9a7)][_0x1d66de(0x9bf)],_0x4d9479=Window_BattleStatus[_0x1d66de(0x978)][_0x1d66de(0xa78)](),_0x3a4e56=Graphics[_0x1d66de(0x9ab)]-(_0x2766a6[_0x1d66de(0xafb)]||0xc0),_0x5759f2=this['windowAreaHeight']()+_0x4d9479,_0xf176c6=this[_0x1d66de(0x691)]()?0x0:Graphics['boxWidth']-_0x3a4e56,_0x237245=Graphics[_0x1d66de(0x69d)]-_0x5759f2+_0x4d9479;return new Rectangle(_0xf176c6,_0x237245,_0x3a4e56,_0x5759f2);},Scene_Battle[_0x1a8785(0x978)]['statusWindowRectXPStyle']=function(){const _0x5d3fae=_0x1a8785,_0x207cd5=Window_BattleStatus[_0x5d3fae(0x978)][_0x5d3fae(0xa78)](),_0x3f3de6=Graphics[_0x5d3fae(0x9ab)],_0x23ed06=this[_0x5d3fae(0x251)]()+_0x207cd5,_0x4c6dd8=0x0,_0x53b881=Graphics[_0x5d3fae(0x69d)]-_0x23ed06+_0x207cd5;return new Rectangle(_0x4c6dd8,_0x53b881,_0x3f3de6,_0x23ed06);},Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x481)]=function(){const _0xbd5a09=_0x1a8785,_0x2cccf4=Graphics['boxWidth']/0x2,_0x1143e3=this['calcWindowHeight'](VisuMZ[_0xbd5a09(0x83c)]['Settings']['BattleLayout']['XPActorCommandLines'],!![]),_0x1c25a2=Math[_0xbd5a09(0x86d)]((Graphics[_0xbd5a09(0x9ab)]-_0x2cccf4)/0x2),_0x497513=Graphics[_0xbd5a09(0x69d)]-_0x1143e3-this[_0xbd5a09(0x7c1)]()[_0xbd5a09(0x98e)];return new Rectangle(_0x1c25a2,_0x497513,_0x2cccf4,_0x1143e3);},Scene_Battle['prototype'][_0x1a8785(0x882)]=function(){const _0xba546c=_0x1a8785,_0x450ccb=Graphics['width'],_0x42a90a=Math['round']((Graphics[_0xba546c(0x9ab)]-_0x450ccb)/0x2),_0x26182a=this[_0xba546c(0x4fb)](),_0x7851a=(Graphics[_0xba546c(0x98e)]-Graphics[_0xba546c(0x69d)])/-0x2;return new Rectangle(_0x42a90a,_0x7851a,_0x450ccb,_0x26182a);},Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x824)]=function(){const _0x44ade1=_0x1a8785,_0x5b579a=Graphics[_0x44ade1(0x92d)],_0x4ef856=Math[_0x44ade1(0x86d)]((Graphics['boxWidth']-_0x5b579a)/0x2),_0x6f0f5e=this[_0x44ade1(0x747)](0x4,!![]),_0x14ab8=Graphics[_0x44ade1(0x69d)]-_0x6f0f5e+(Graphics[_0x44ade1(0x98e)]-Graphics['boxHeight'])/0x2;return new Rectangle(_0x4ef856,_0x14ab8,_0x5b579a,_0x6f0f5e);},Scene_Battle['prototype']['partyCommandWindowRectBorderStyle']=function(){const _0x1af43c=_0x1a8785,_0x383c2c=Math[_0x1af43c(0x4a7)](Graphics[_0x1af43c(0x92d)]/0x3),_0x43134e=this[_0x1af43c(0x691)]()?(Graphics['width']+Graphics[_0x1af43c(0x9ab)])/0x2-_0x383c2c:(Graphics[_0x1af43c(0x92d)]-Graphics['boxWidth'])/-0x2,_0x2c421a=this[_0x1af43c(0x882)](),_0x878b3e=_0x2c421a['y']+_0x2c421a[_0x1af43c(0x98e)],_0x5a7051=this['statusWindowRectBorderStyle'](),_0x2b2411=_0x5a7051['y']-_0x878b3e;return new Rectangle(_0x43134e,_0x878b3e,_0x383c2c,_0x2b2411);},Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x4e6)]=function(){const _0x3b267f=_0x1a8785,_0x37b02b=Math[_0x3b267f(0x348)](Graphics[_0x3b267f(0x92d)]/0x3),_0x8e1b58=Math[_0x3b267f(0x86d)]((Graphics['boxWidth']-_0x37b02b)/0x2),_0x15c266=this[_0x3b267f(0x8ee)](),_0x370cab=_0x15c266['y'],_0x128022=_0x15c266[_0x3b267f(0x98e)];return new Rectangle(_0x8e1b58,_0x370cab,_0x37b02b,_0x128022);},Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x2b4)]=function(){const _0xff4ff2=_0x1a8785;this['_cancelButton']['y']=this['_helpWindow']['y']+this[_0xff4ff2(0x765)][_0xff4ff2(0x98e)],this[_0xff4ff2(0x691)]()?this[_0xff4ff2(0x367)]()===_0xff4ff2(0x617)?this['_cancelButton']['x']=0x8:this[_0xff4ff2(0xa22)]['x']=-this['_cancelButton']['width']-0x4:this[_0xff4ff2(0xa22)]['x']=Graphics[_0xff4ff2(0x92d)]-(Graphics[_0xff4ff2(0x92d)]-Graphics['boxWidth'])/0x2-this['_cancelButton'][_0xff4ff2(0x92d)]-0x4;},VisuMZ[_0x1a8785(0x83c)]['Scene_Battle_skillWindowRect']=Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x788)],Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x788)]=function(){const _0x5d3671=_0x1a8785;if(this['battleLayoutStyle']()==='border')return this[_0x5d3671(0x4e6)]();else return this['isSkillItemWindowsMiddle']()?this['skillItemWindowRectMiddle']():VisuMZ['BattleCore'][_0x5d3671(0x718)][_0x5d3671(0x716)](this);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x6b4)]=Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0xa30)],Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0xa30)]=function(){const _0x159cb9=_0x1a8785;if(this['battleLayoutStyle']()===_0x159cb9(0x617))return this[_0x159cb9(0x4e6)]();else return this['isSkillItemWindowsMiddle']()?this[_0x159cb9(0xa48)]():VisuMZ[_0x159cb9(0x83c)]['Scene_Battle_itemWindowRect'][_0x159cb9(0x716)](this);},Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0x475)]=function(){const _0x5bb82a=_0x1a8785;return VisuMZ[_0x5bb82a(0x83c)]['Settings'][_0x5bb82a(0x9bf)][_0x5bb82a(0xa62)];},Scene_Battle[_0x1a8785(0x978)]['skillItemWindowRectMiddle']=function(){const _0x5298ff=_0x1a8785,_0x30997b=Sprite_Button[_0x5298ff(0x978)][_0x5298ff(0x1a8)]()*0x2+0x4;let _0x5d7533=Graphics[_0x5298ff(0x9ab)]-_0x30997b;Imported[_0x5298ff(0x211)]&&SceneManager[_0x5298ff(0x1de)]()&&(_0x5d7533+=_0x30997b);const _0x184a63=this[_0x5298ff(0x8f1)](),_0x66849a=Graphics[_0x5298ff(0x69d)]-_0x184a63-this['statusWindowRect']()['height']+Window_BattleStatus[_0x5298ff(0x978)][_0x5298ff(0xa78)](),_0x3cf6f3=0x0;return new Rectangle(_0x3cf6f3,_0x184a63,_0x5d7533,_0x66849a);},Scene_Battle[_0x1a8785(0x978)][_0x1a8785(0xa84)]=function(){const _0x5c13b8=_0x1a8785;if(!VisuMZ[_0x5c13b8(0x83c)]['Settings'][_0x5c13b8(0x199)][_0x5c13b8(0x80c)])return;this['_enemyNameContainer']=new Sprite(),this['_enemyNameContainer']['x']=this[_0x5c13b8(0x531)]['x'],this['_enemyNameContainer']['y']=this['_windowLayer']['y'];const _0x4b17f7=this[_0x5c13b8(0x908)][_0x5c13b8(0x64f)](this[_0x5c13b8(0x531)]);this[_0x5c13b8(0xa21)](this[_0x5c13b8(0xada)],_0x4b17f7);for(let _0x36cdd7=0x0;_0x36cdd7<0x8;_0x36cdd7++){const _0x328cf0=new Window_EnemyName(_0x36cdd7);this['_enemyNameContainer'][_0x5c13b8(0xaba)](_0x328cf0);}},Sprite_Battler[_0x1a8785(0x1a4)]=VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x9a7)]['Actor']['MotionSpeed'],VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0xa9a)]=Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x9a3)],Sprite_Battler[_0x1a8785(0x978)]['initMembers']=function(){const _0x1fbcd5=_0x1a8785;VisuMZ[_0x1fbcd5(0x83c)][_0x1fbcd5(0xa9a)]['call'](this),this[_0x1fbcd5(0x5c7)]();if(this['constructor']===Sprite_Enemy)this[_0x1fbcd5(0x57d)]();this[_0x1fbcd5(0x376)]();},Sprite_Battler['prototype']['initMembersBattleCore']=function(){const _0x1b2ef1=_0x1a8785;this[_0x1b2ef1(0x6c5)]=0x0,this[_0x1b2ef1(0x236)]=0x0,this[_0x1b2ef1(0xa35)]=0x0,this[_0x1b2ef1(0x44b)]=0x0,this['_floatDuration']=0x0,this[_0x1b2ef1(0x5f1)]=0x0,this[_0x1b2ef1(0x762)]=_0x1b2ef1(0x434),this[_0x1b2ef1(0xa34)]=0x0,this['_jumpMaxHeight']=0x0,this['_jumpDuration']=0x0,this['_jumpWholeDuration']=0x0,this['_targetOpacity']=0xff,this[_0x1b2ef1(0x517)]=0x0,this[_0x1b2ef1(0x7ca)]=0x0,this[_0x1b2ef1(0xaf0)]='Linear',this[_0x1b2ef1(0x355)]=0x0,this['_targetAngle']=0x0,this[_0x1b2ef1(0xb05)]=0x0,this[_0x1b2ef1(0x422)]=0x0,this[_0x1b2ef1(0x4bc)]='Linear',this[_0x1b2ef1(0x309)]=!![],this['_skewX']=0x0,this[_0x1b2ef1(0x83b)]=0x0,this['_targetSkewX']=0x0,this[_0x1b2ef1(0x303)]=0x0,this[_0x1b2ef1(0x3e4)]=0x0,this[_0x1b2ef1(0x41a)]=0x0,this['_skewEasing']='Linear',this[_0x1b2ef1(0x8a0)]=0x1,this[_0x1b2ef1(0x603)]=0x1,this[_0x1b2ef1(0x6da)]=0x1,this[_0x1b2ef1(0x996)]=0x1,this['_growDuration']=0x0,this[_0x1b2ef1(0x95c)]=0x0,this[_0x1b2ef1(0x8b3)]=_0x1b2ef1(0x434),this[_0x1b2ef1(0xa37)]=0x1,this[_0x1b2ef1(0x76a)]=0x0,this[_0x1b2ef1(0x78e)]=0x0,this[_0x1b2ef1(0x46c)]=0x0,this[_0x1b2ef1(0x9b0)]=0x0,this[_0x1b2ef1(0x820)]=_0x1b2ef1(0x434),this[_0x1b2ef1(0x418)]=0x0,this[_0x1b2ef1(0x4db)]=0x0;},Sprite_Battler[_0x1a8785(0x978)]['createShadowSprite']=function(){const _0x1dfaa1=_0x1a8785;this[_0x1dfaa1(0x5e6)]=new Sprite(),this[_0x1dfaa1(0x5e6)][_0x1dfaa1(0x92b)]=ImageManager[_0x1dfaa1(0x6d3)](_0x1dfaa1(0x812)),this[_0x1dfaa1(0x5e6)]['bitmap']['smooth']=VisuMZ['BattleCore'][_0x1dfaa1(0x9a7)]['Actor']['SmoothImage'],this['_shadowSprite'][_0x1dfaa1(0x7b1)]['x']=0.5,this['_shadowSprite']['anchor']['y']=0.5,this['_shadowSprite']['y']=-0x2,this[_0x1dfaa1(0x5e6)][_0x1dfaa1(0xac3)]=![],this[_0x1dfaa1(0xaba)](this[_0x1dfaa1(0x5e6)]);},Sprite_Battler[_0x1a8785(0x978)]['createDistortionSprite']=function(){const _0x23bf34=_0x1a8785;this[_0x23bf34(0x194)]=new Sprite(),this['_distortionSprite'][_0x23bf34(0x7b1)]['x']=0.5,this['_distortionSprite'][_0x23bf34(0x7b1)]['y']=0.5,this['addChild'](this[_0x23bf34(0x194)]);},Sprite_Battler[_0x1a8785(0x978)]['attachSpritesToDistortionSprite']=function(){const _0x318dd9=_0x1a8785;if(!this[_0x318dd9(0x194)])return;if(this[_0x318dd9(0x5e6)]){const _0xb40db1=this['getChildIndex'](this['_distortionSprite']);this[_0x318dd9(0xa21)](this[_0x318dd9(0x5e6)],_0xb40db1),this[_0x318dd9(0x568)]();}this[_0x318dd9(0xadf)]&&this[_0x318dd9(0x194)]['addChild'](this[_0x318dd9(0xadf)]),this[_0x318dd9(0x709)]&&this[_0x318dd9(0x194)][_0x318dd9(0xaba)](this[_0x318dd9(0x709)]),this[_0x318dd9(0x91b)]&&this[_0x318dd9(0x194)][_0x318dd9(0xaba)](this[_0x318dd9(0x91b)]),this[_0x318dd9(0x687)]&&this['_distortionSprite'][_0x318dd9(0xaba)](this[_0x318dd9(0x687)]),this[_0x318dd9(0xa47)]&&this[_0x318dd9(0x194)][_0x318dd9(0xaba)](this[_0x318dd9(0xa47)]);},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x568)]=function(){const _0x100570=_0x1a8785;if(!this[_0x100570(0x5e6)])return;if(this[_0x100570(0x8b2)]&&this[_0x100570(0x8b2)][_0x100570(0x2ad)]()){const _0x5d4786=this[_0x100570(0x5e6)]['bitmap'];this['_shadowSprite'][_0x100570(0x645)](0x0,0x0,_0x5d4786[_0x100570(0x92d)],_0x5d4786[_0x100570(0x98e)]);}else this[_0x100570(0x5e6)][_0x100570(0x645)](0x0,0x0,0x0,0x0);},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x201)]=function(){const _0x234098=_0x1a8785;return SceneManager[_0x234098(0x3a8)]()?SceneManager[_0x234098(0xa42)][_0x234098(0x589)][_0x234098(0x22a)]:this[_0x234098(0x45c)];},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x7ec)]=function(_0x1591f3,_0x1b266c){const _0x4f1865=_0x1a8785;if(!this['_battler']['isSpriteVisible']())return;if(BattleManager[_0x4f1865(0x495)]())return;const _0x19eed4=VisuMZ[_0x4f1865(0x83c)][_0x4f1865(0x9a7)][_0x4f1865(0xa19)],_0x3e9e95=new Sprite_Damage();_0x3e9e95[_0x4f1865(0x2c2)]=_0x19eed4[_0x4f1865(0x97f)],this[_0x4f1865(0x2b0)](_0x3e9e95),_0x3e9e95[_0x4f1865(0x7ec)](_0x1591f3,_0x1b266c),this[_0x4f1865(0x7f1)](_0x3e9e95);},Sprite_Battler[_0x1a8785(0x978)]['setupIconTextPopup']=function(_0x4cccf0,_0x4378aa,_0x51c3c9){const _0x1c41c4=_0x1a8785;if(!this[_0x1c41c4(0x8b2)][_0x1c41c4(0x33e)]())return;if(BattleManager[_0x1c41c4(0x495)]())return;const _0x5183f4=VisuMZ[_0x1c41c4(0x83c)][_0x1c41c4(0x9a7)][_0x1c41c4(0xa19)],_0x3abef8=new Sprite_Damage();_0x3abef8[_0x1c41c4(0x2c2)]=_0x5183f4[_0x1c41c4(0x97f)],this[_0x1c41c4(0x2b0)](_0x3abef8),_0x3abef8[_0x1c41c4(0x1c3)](_0x4cccf0,_0x4378aa,_0x51c3c9),this[_0x1c41c4(0x7f1)](_0x3abef8);},Sprite_Battler['prototype']['setupDamagePopup']=function(){const _0x302615=_0x1a8785;if(!this[_0x302615(0x8b2)]['isDamagePopupRequested']())return;while(this[_0x302615(0x8b2)][_0x302615(0xae8)]()){this[_0x302615(0x8b2)][_0x302615(0x33e)]()&&this['createDamageSprite']();}this[_0x302615(0x8b2)][_0x302615(0x57c)](),this[_0x302615(0x8b2)][_0x302615(0x8d6)]();},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x63c)]=function(){const _0x85c34a=_0x1a8785;if(BattleManager[_0x85c34a(0x495)]())return;const _0x5c47e6=VisuMZ[_0x85c34a(0x83c)]['Settings'][_0x85c34a(0xa19)],_0x4e8d60=new Sprite_Damage();_0x4e8d60[_0x85c34a(0x2c2)]=_0x5c47e6[_0x85c34a(0x97f)],this['sortDamageSprites'](_0x4e8d60),_0x4e8d60[_0x85c34a(0x352)](this[_0x85c34a(0x8b2)]),_0x4e8d60[_0x85c34a(0x75d)](this[_0x85c34a(0x8b2)]),this[_0x85c34a(0x7f1)](_0x4e8d60);},Sprite_Battler[_0x1a8785(0x978)]['addDamageSprite']=function(_0x1b5842){const _0x41e6c5=_0x1a8785;this[_0x41e6c5(0x5dc)][_0x41e6c5(0x963)](_0x1b5842);if(this[_0x41e6c5(0x6f5)]()){const _0x4ac531=SceneManager[_0x41e6c5(0xa42)][_0x41e6c5(0x2ac)];if(_0x4ac531)_0x4ac531['addDamageSprite'](_0x1b5842,this[_0x41e6c5(0x8b2)]);}else{this[_0x41e6c5(0x201)]()[_0x41e6c5(0xaba)](_0x1b5842);if(SceneManager[_0x41e6c5(0x55e)]())_0x1b5842[_0x41e6c5(0x768)]['x']=-0x1;}},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x6f5)]=function(){const _0x5baca5=_0x1a8785;return!$gameSystem['isSideView']()&&this['_battler']&&this['_battler'][_0x5baca5(0x68d)]();return!$gameSystem['isSideView']()&&this[_0x5baca5(0x8b2)]&&this[_0x5baca5(0x8b2)]['isActor']()&&Window_BattleStatus[_0x5baca5(0x978)]['battleLayoutStyle']()===_0x5baca5(0x5b2);},Sprite_Battler[_0x1a8785(0x978)]['sortDamageSprites']=function(_0x39653d){const _0x23053d=_0x1a8785;this[_0x23053d(0x560)](_0x39653d,!![]);const _0x31d9df=VisuMZ[_0x23053d(0x83c)][_0x23053d(0x9a7)]['Damage'],_0x2d9618=SceneManager[_0x23053d(0x55e)]()?-0x1:0x1;if(_0x31d9df[_0x23053d(0x8fb)])for(const _0x469eb1 of this[_0x23053d(0x5dc)]){_0x469eb1['x']+=_0x31d9df['PopupShiftX']*_0x2d9618,_0x469eb1['y']+=_0x31d9df['PopupShiftY'];}else{const _0x54a501=this[_0x23053d(0x5dc)][this[_0x23053d(0x5dc)][_0x23053d(0x2dc)]-0x1];_0x54a501&&(_0x39653d['x']=_0x54a501['x']+_0x31d9df['PopupShiftX']*_0x2d9618,_0x39653d['y']=_0x54a501['y']+_0x31d9df[_0x23053d(0xaac)]);}},Sprite_Battler[_0x1a8785(0x978)]['alignBattleCoreDamageSprite']=function(_0x50629f,_0x50bef6){const _0x2b8441=_0x1a8785,_0x39ad07=SceneManager[_0x2b8441(0x55e)]()?-0x1:0x1;let _0x9a9394=this[_0x2b8441(0x6c5)];_0x9a9394+=this[_0x2b8441(0x619)]();let _0x21bff1=this[_0x2b8441(0x236)];const _0x4ed81c=this['_distortionSprite'][_0x2b8441(0x768)]['y'];_0x21bff1+=this[_0x2b8441(0x587)]();const _0x127867=SceneManager['_scene']['_statusWindow'];if(_0x127867&&this[_0x2b8441(0x45c)]===_0x127867){_0x9a9394+=_0x127867['x']-this[_0x2b8441(0x48c)]();const _0x284753=_0x127867['lineHeight']()*0x3/0x4;_0x21bff1=_0x127867['y']+_0x284753,_0x21bff1=Math[_0x2b8441(0xae7)](_0x21bff1,_0x127867['y']+this['y']-this['height']+_0x284753);}_0x50629f['x']=Math['round'](_0x9a9394+this['damageOffsetX']()*_0x39ad07),_0x50629f['y']=Math[_0x2b8441(0x86d)](_0x21bff1+this['damageOffsetY']());},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x4f2)]=Sprite_Battler['prototype']['damageOffsetX'],Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x48c)]=function(){const _0x2c7b35=_0x1a8785;let _0x1869e4=VisuMZ[_0x2c7b35(0x83c)]['Sprite_Battler_damageOffsetX'][_0x2c7b35(0x716)](this),_0x1c90ad=VisuMZ[_0x2c7b35(0x83c)]['Settings'][_0x2c7b35(0xa19)]['PopupOffsetX']||0x0;return Math[_0x2c7b35(0x86d)](_0x1869e4+_0x1c90ad);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0xa60)]=Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x61a)],Sprite_Battler['prototype'][_0x1a8785(0x61a)]=function(){const _0x3bf65a=_0x1a8785;let _0x1984e2=VisuMZ[_0x3bf65a(0x83c)]['Sprite_Battler_damageOffsetY']['call'](this);switch(VisuMZ[_0x3bf65a(0x83c)]['Settings']['Damage'][_0x3bf65a(0x8d2)]){case _0x3bf65a(0x959):_0x1984e2-=this['height']*this[_0x3bf65a(0x768)]['y'];break;case _0x3bf65a(0x745):_0x1984e2-=this['height']*this[_0x3bf65a(0x768)]['y']*0.5;break;}let _0x5cda81=VisuMZ[_0x3bf65a(0x83c)][_0x3bf65a(0x9a7)][_0x3bf65a(0xa19)][_0x3bf65a(0x8a6)]||0x0;return Math[_0x3bf65a(0x86d)](_0x1984e2+_0x5cda81);},Sprite_Actor[_0x1a8785(0x978)][_0x1a8785(0x48c)]=function(){const _0xfed159=_0x1a8785;return Sprite_Battler['prototype']['damageOffsetX'][_0xfed159(0x716)](this);},Sprite_Actor[_0x1a8785(0x978)][_0x1a8785(0x61a)]=function(){const _0x3d0b7b=_0x1a8785;return Sprite_Battler[_0x3d0b7b(0x978)][_0x3d0b7b(0x61a)][_0x3d0b7b(0x716)](this);},Sprite_Battler['prototype']['destroyDamageSprite']=function(_0x4c5775){const _0x5ebad7=_0x1a8785;this[_0x5ebad7(0x6f5)]()?SceneManager['_scene']['_statusWindow'][_0x5ebad7(0x400)](_0x4c5775):(this[_0x5ebad7(0x201)]()['removeChild'](_0x4c5775),this[_0x5ebad7(0x5dc)][_0x5ebad7(0xa3b)](_0x4c5775),_0x4c5775[_0x5ebad7(0x738)]());},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x7ad)]=Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x8e7)],Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x8e7)]=function(_0x41a4e3,_0x417042){const _0x200e21=_0x1a8785,_0xf95c57=VisuMZ['BattleCore'][_0x200e21(0x9a7)];if(this[_0x200e21(0x79d)]===Sprite_Actor)_0x41a4e3+=_0xf95c57[_0x200e21(0x1d0)][_0x200e21(0xa93)]||0x0,_0x417042+=_0xf95c57[_0x200e21(0x1d0)]['OffsetY']||0x0;else this['constructor']===Sprite_Enemy&&(_0x41a4e3+=_0xf95c57['Enemy'][_0x200e21(0xa93)]||0x0,_0x417042+=_0xf95c57[_0x200e21(0x199)][_0x200e21(0x4bf)]||0x0);this[_0x200e21(0x8b2)]&&(_0x41a4e3=this[_0x200e21(0x8b2)][_0x200e21(0x424)]??_0x41a4e3,_0x417042=this['_battler'][_0x200e21(0x976)]??_0x417042),VisuMZ[_0x200e21(0x83c)][_0x200e21(0x7ad)][_0x200e21(0x716)](this,_0x41a4e3,_0x417042),this[_0x200e21(0x76a)]=this[_0x200e21(0x9b9)],this[_0x200e21(0x78e)]=this[_0x200e21(0x774)],this['_homeDuration']=0x0,this[_0x200e21(0x9b0)]=0x0,this[_0x200e21(0x820)]=_0x200e21(0x434);},VisuMZ['BattleCore']['Sprite_Battler_update']=Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x31a)],Sprite_Battler['prototype'][_0x1a8785(0x31a)]=function(){const _0x2de069=_0x1a8785;VisuMZ[_0x2de069(0x83c)]['Sprite_Battler_update'][_0x2de069(0x716)](this),!this[_0x2de069(0x8b2)]&&this[_0x2de069(0x5f5)]&&(this[_0x2de069(0x5f5)][_0x2de069(0xac3)]=![]);},VisuMZ['BattleCore'][_0x1a8785(0x2bf)]=Sprite_Battler['prototype'][_0x1a8785(0x59a)],Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x59a)]=function(){const _0x328b80=_0x1a8785;this[_0x328b80(0x719)](),this[_0x328b80(0x74b)](),this[_0x328b80(0x3f9)](),this['updateFlip'](),VisuMZ[_0x328b80(0x83c)][_0x328b80(0x2bf)][_0x328b80(0x716)](this),this[_0x328b80(0x988)](),this['updateShakeFlinch']();if(this[_0x328b80(0x79d)]===Sprite_Enemy)this['updateShadow']();},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x989)]=Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x412)],Sprite_Battler['prototype'][_0x1a8785(0x412)]=function(){const _0x530908=_0x1a8785;this[_0x530908(0x695)](),VisuMZ['BattleCore'][_0x530908(0x989)][_0x530908(0x716)](this),this[_0x530908(0x758)](),this['updateOpacity']();},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x287)]=function(){const _0x522c50=_0x1a8785,_0x2319fb=this['mainSprite']();if(this['_battler'][_0x522c50(0x5f2)]())this[_0x522c50(0x828)]++,Graphics[_0x522c50(0x699)]%0x1e<0xf?_0x2319fb[_0x522c50(0x9f1)]([0xff,0xff,0xff,0x40]):_0x2319fb['setBlendColor']([0x0,0x0,0x0,0x0]);else this['_selectionEffectCount']>0x0&&(this[_0x522c50(0x828)]=0x0,_0x2319fb[_0x522c50(0x9f1)]([0x0,0x0,0x0,0x0]));},Sprite_Battler[_0x1a8785(0x978)]['silentHomeMove']=function(_0x17ee37,_0x4d3b5e){const _0x3a6eb8=_0x1a8785,_0x536856=_0x17ee37-this['_homeX'],_0x5bba85=_0x4d3b5e-this[_0x3a6eb8(0x774)];this['_homeX']=_0x17ee37,this[_0x3a6eb8(0x774)]=_0x4d3b5e,this[_0x3a6eb8(0x28a)]-=_0x536856,this[_0x3a6eb8(0x44d)]-=_0x5bba85,this[_0x3a6eb8(0xaa1)]-=_0x536856,this[_0x3a6eb8(0x7a9)]-=_0x5bba85,this['updatePosition']();},Sprite_Battler[_0x1a8785(0x978)]['startHomeMove']=function(_0x285947,_0x2c8aec,_0x16520b,_0x2b18a3){const _0x4187ce=_0x1a8785;(this[_0x4187ce(0x76a)]!==_0x285947||this[_0x4187ce(0x78e)]!==_0x2c8aec)&&(this[_0x4187ce(0x76a)]=_0x285947,this[_0x4187ce(0x78e)]=_0x2c8aec,this['_homeDuration']=_0x16520b,this[_0x4187ce(0x9b0)]=_0x16520b,this[_0x4187ce(0x820)]=_0x2b18a3,_0x16520b<=0x0&&this[_0x4187ce(0x3c0)]());},Sprite_Battler[_0x1a8785(0x978)]['updateHomeMove']=function(){const _0x5444eb=_0x1a8785;if(this[_0x5444eb(0x46c)]<=0x0)return;const _0x4dd117=this[_0x5444eb(0x46c)],_0x2d34cc=this[_0x5444eb(0x9b0)],_0x13b083=this['_homeEasing'];Imported['VisuMZ_0_CoreEngine']?(this['_homeX']=this[_0x5444eb(0x77b)](this[_0x5444eb(0x9b9)],this[_0x5444eb(0x76a)],_0x4dd117,_0x2d34cc,_0x13b083),this[_0x5444eb(0x774)]=this[_0x5444eb(0x77b)](this[_0x5444eb(0x774)],this[_0x5444eb(0x78e)],_0x4dd117,_0x2d34cc,_0x13b083)):(this[_0x5444eb(0x9b9)]=(this['_homeX']*(_0x4dd117-0x1)+this[_0x5444eb(0x76a)])/_0x4dd117,this[_0x5444eb(0x774)]=(this[_0x5444eb(0x774)]*(_0x4dd117-0x1)+this[_0x5444eb(0x78e)])/_0x4dd117);this['_homeDuration']--;if(this[_0x5444eb(0x46c)]<=0x0)this[_0x5444eb(0x3c0)]();},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x3c0)]=function(){const _0x477592=_0x1a8785;this['_homeX']=this[_0x477592(0x76a)],this[_0x477592(0x774)]=this[_0x477592(0x78e)];},Sprite_Battler['prototype'][_0x1a8785(0x758)]=function(){const _0x11503f=_0x1a8785;this[_0x11503f(0x6c5)]=this['x'],this[_0x11503f(0x236)]=this['y'],this[_0x11503f(0x670)](),this[_0x11503f(0x8cc)](),this['x']+=this[_0x11503f(0x619)](),this['y']+=this[_0x11503f(0x587)](),this['y']+=this['extraPositionScaledY'](),this['x']=Math['floor'](this['x']),this['y']=Math[_0x11503f(0x4a7)](this['y']);},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x619)]=function(){let _0x493340=0x0;return _0x493340;},Sprite_Battler['prototype'][_0x1a8785(0x587)]=function(){const _0x4ab93d=_0x1a8785;let _0x3b2539=0x0;return this[_0x4ab93d(0x8b2)]&&!this[_0x4ab93d(0x8b2)][_0x4ab93d(0x68a)]()&&(_0x3b2539-=this[_0x4ab93d(0xa35)],_0x3b2539-=this['_jumpHeight']),_0x3b2539;},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0xa33)]=function(){const _0xbeba7a=_0x1a8785;let _0x3d8214=0x0;if(this['_distortionSprite']&&this['constructor']!==Sprite_SvEnemy){const _0xbde1cc=this['_distortionSprite'][_0xbeba7a(0x768)]['y'];_0x3d8214-=(_0xbde1cc-0x1)*this[_0xbeba7a(0x98e)];}return _0x3d8214;},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x971)]=function(){const _0x5d170c=_0x1a8785,_0x5864cf=this[_0x5d170c(0x8b2)]&&this['_battler'][_0x5d170c(0x1e8)]();this[_0x5d170c(0xa37)]=(_0x5864cf?-0x1:0x1)*Math['abs'](this['scale']['x']);},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x61e)]=function(_0x31cf40,_0x850d0c,_0x2f187a){const _0x1c6991=_0x1a8785;if(!this[_0x1c6991(0x42d)]())return;if(this[_0x1c6991(0x44b)]===_0x31cf40)return;this[_0x1c6991(0x44b)]=_0x31cf40,this[_0x1c6991(0x3d2)]=_0x850d0c,this['_floatWholeDuration']=_0x850d0c,this[_0x1c6991(0x762)]=_0x2f187a||'Linear';if(_0x850d0c<=0x0)this[_0x1c6991(0xa35)]=_0x31cf40;},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x670)]=function(){const _0x4ff3c6=_0x1a8785;if(this[_0x4ff3c6(0x3d2)]<=0x0)return;const _0x2fc19b=this[_0x4ff3c6(0x3d2)],_0x533678=this['_floatWholeDuration'],_0x4abcf2=this[_0x4ff3c6(0x762)];Imported[_0x4ff3c6(0x211)]?this[_0x4ff3c6(0xa35)]=this[_0x4ff3c6(0x77b)](this['_floatHeight'],this[_0x4ff3c6(0x44b)],_0x2fc19b,_0x533678,_0x4abcf2):this['_floatHeight']=(this[_0x4ff3c6(0xa35)]*(_0x2fc19b-0x1)+this[_0x4ff3c6(0x44b)])/_0x2fc19b;this[_0x4ff3c6(0x3d2)]--;if(this[_0x4ff3c6(0x3d2)]<=0x0)this[_0x4ff3c6(0x658)]();},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x658)]=function(){const _0x511f28=_0x1a8785;this[_0x511f28(0xa35)]=this[_0x511f28(0x44b)];},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x2ee)]=function(){return this['_floatDuration']>0x0;},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0xa3a)]=function(_0x7fd102,_0x23d06c){const _0x5497b8=_0x1a8785;if(!this['canMove']())return;if(_0x23d06c<=0x0)return;this[_0x5497b8(0xa72)]=_0x7fd102,this[_0x5497b8(0x21e)]=_0x23d06c,this['_jumpWholeDuration']=_0x23d06c;},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x8cc)]=function(){const _0x51bf9b=_0x1a8785;if(this[_0x51bf9b(0x21e)]<=0x0)return;const _0x23a9ba=this[_0x51bf9b(0x9da)]-this[_0x51bf9b(0x21e)],_0x4c1d62=this[_0x51bf9b(0x9da)]/0x2,_0x15d321=this[_0x51bf9b(0xa72)],_0x11547f=-_0x15d321/Math['pow'](_0x4c1d62,0x2);this[_0x51bf9b(0xa34)]=_0x11547f*Math[_0x51bf9b(0xab6)](_0x23a9ba-_0x4c1d62,0x2)+_0x15d321,this[_0x51bf9b(0x21e)]--;if(this[_0x51bf9b(0x21e)]<=0x0)return this[_0x51bf9b(0x1d8)]();},Sprite_Battler['prototype'][_0x1a8785(0x1d8)]=function(){const _0xf0d1c7=_0x1a8785;this[_0xf0d1c7(0xa34)]=0x0;},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x735)]=function(){const _0x1de110=_0x1a8785;return this[_0x1de110(0x21e)]>0x0;},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x3f3)]=function(_0x35206f,_0x8aa255,_0x3061ad){const _0x208ab5=_0x1a8785;if(this['_targetOpacity']===_0x35206f)return;this[_0x208ab5(0x949)]=_0x35206f,this[_0x208ab5(0x517)]=_0x8aa255,this['_opacityWholeDuration']=_0x8aa255,this[_0x208ab5(0xaf0)]=_0x3061ad||_0x208ab5(0x434);if(_0x8aa255<=0x0)this['opacity']=_0x35206f;},Sprite_Battler['prototype'][_0x1a8785(0xb01)]=function(){const _0x54e22e=_0x1a8785;if(this['constructor'][_0x54e22e(0x1f2)]===_0x54e22e(0x1c4))return;if(this[_0x54e22e(0x517)]<=0x0)return;const _0x45a0b6=this[_0x54e22e(0x517)],_0x255dbf=this[_0x54e22e(0x7ca)],_0x6252f3=this[_0x54e22e(0xaf0)];Imported['VisuMZ_0_CoreEngine']?this['opacity']=this[_0x54e22e(0x77b)](this[_0x54e22e(0xaeb)],this['_targetOpacity'],_0x45a0b6,_0x255dbf,_0x6252f3):this['opacity']=(this['opacity']*(_0x45a0b6-0x1)+this['_targetOpacity'])/_0x45a0b6;this[_0x54e22e(0x517)]--;if(this[_0x54e22e(0x517)]<=0x0)this['onOpacityEnd']();},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x1b9)]=function(){const _0x56fc87=_0x1a8785;this[_0x56fc87(0xaeb)]=this[_0x56fc87(0x949)];},Sprite_Battler['prototype']['isChangingOpacity']=function(){const _0x25a996=_0x1a8785;return this[_0x25a996(0x517)]>0x0;},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x793)]=function(){const _0x6694e4=_0x1a8785;this[_0x6694e4(0x5e6)][_0x6694e4(0xac3)]=this[_0x6694e4(0x8b2)][_0x6694e4(0x907)](),this[_0x6694e4(0x659)]();},Sprite_Battler[_0x1a8785(0x978)]['updateShadowPosition']=function(){const _0x326508=_0x1a8785;if(!this[_0x326508(0x5e6)])return;this[_0x326508(0x5e6)]['y']=this[_0x326508(0x236)]-this['y']-0x2;},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x844)]=function(){const _0x25e4a1=_0x1a8785;if(!this[_0x25e4a1(0x8b2)])return;this['_shadowScaleX']=this[_0x25e4a1(0x8b2)][_0x25e4a1(0x46f)](),this[_0x25e4a1(0x9ed)]=this[_0x25e4a1(0x8b2)][_0x25e4a1(0x1a0)]();},Game_BattlerBase[_0x1a8785(0x978)]['battlerShadowScaleX']=function(){const _0x23ffad=_0x1a8785,_0x445f91=this[_0x23ffad(0x68d)]()?this[_0x23ffad(0x7fd)]():this[_0x23ffad(0x739)]();if(_0x445f91){const _0x2d97a8=_0x445f91['note'];if(_0x2d97a8[_0x23ffad(0x9e0)](/<SIDEVIEW SHADOW (?:SCALE|SCALE X):[ ](\d+)([%％])>/i))return Number(RegExp['$1'])*0.01;else{if(_0x2d97a8[_0x23ffad(0x9e0)](/<SIDEVIEW SHADOW (?:SCALE|SCALE X):[ ](.*)>/i))return Number(RegExp['$1'])||0x0;}}return 0x1;},Game_BattlerBase[_0x1a8785(0x978)]['battlerShadowScaleY']=function(){const _0x365656=_0x1a8785,_0x30f122=this[_0x365656(0x68d)]()?this[_0x365656(0x7fd)]():this[_0x365656(0x739)]();if(_0x30f122){const _0x5d4f36=_0x30f122[_0x365656(0x9c6)];if(_0x5d4f36['match'](/<SIDEVIEW SHADOW (?:SCALE|SCALE Y):[ ](\d+)([%％])>/i))return Number(RegExp['$1'])*0.01;else{if(_0x5d4f36['match'](/<SIDEVIEW SHADOW (?:SCALE|SCALE Y):[ ](.*)>/i))return Number(RegExp['$1'])||0x0;}}return 0x1;},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x719)]=function(){const _0x29ca58=_0x1a8785;if(this[_0x29ca58(0x79d)]===Sprite_SvEnemy)return;this['updateGrow'](),this[_0x29ca58(0x278)]();},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x278)]=function(){const _0x339076=_0x1a8785,_0x129ffc=this[_0x339076(0x194)];_0x129ffc&&(_0x129ffc[_0x339076(0x768)]['x']=this['mainSpriteScaleX'](),_0x129ffc['scale']['y']=this[_0x339076(0x9ec)]());},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x48f)]=function(){const _0x1b2502=_0x1a8785;let _0x19fd96=0x1;return _0x19fd96*=this[_0x1b2502(0xa37)],_0x19fd96*=this[_0x1b2502(0x8a0)],_0x19fd96;},Sprite_Battler[_0x1a8785(0x978)]['mainSpriteScaleY']=function(){const _0x57b229=_0x1a8785;return 0x1*this[_0x57b229(0x603)];},Sprite_Battler['prototype']['mainSpriteWidth']=function(){const _0x3aa3d3=_0x1a8785;return this[_0x3aa3d3(0x92d)]*this[_0x3aa3d3(0x48f)]();},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x27b)]=function(){const _0x356215=_0x1a8785;return this[_0x356215(0x98e)]*this[_0x356215(0x9ec)]();},Sprite_Battler[_0x1a8785(0x978)]['startGrow']=function(_0x1c19f2,_0x14c1fc,_0x360086,_0x2c7c01){const _0xb0a906=_0x1a8785;if(!this['canMove']())return;if(!this['_distortionSprite'])return;if(this[_0xb0a906(0x6da)]===_0x1c19f2&&this[_0xb0a906(0x996)]===_0x14c1fc)return;this[_0xb0a906(0x6da)]=_0x1c19f2,this[_0xb0a906(0x996)]=_0x14c1fc,this[_0xb0a906(0x26a)]=_0x360086,this['_growWholeDuration']=_0x360086,this[_0xb0a906(0x8b3)]=_0x2c7c01||_0xb0a906(0x434),_0x360086<=0x0&&(this[_0xb0a906(0x8a0)]=this['_targetGrowX'],this[_0xb0a906(0x603)]=this[_0xb0a906(0x996)]);},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x9cc)]=function(){const _0x2ce661=_0x1a8785;if(this[_0x2ce661(0x26a)]<=0x0)return;if(!this[_0x2ce661(0x194)])return;const _0x4661e7=this[_0x2ce661(0x26a)],_0x41e47e=this['_growWholeDuration'],_0x13bac4=this[_0x2ce661(0x8b3)];Imported['VisuMZ_0_CoreEngine']?(this[_0x2ce661(0x8a0)]=this[_0x2ce661(0x77b)](this[_0x2ce661(0x8a0)],this[_0x2ce661(0x6da)],_0x4661e7,_0x41e47e,_0x13bac4),this[_0x2ce661(0x603)]=this[_0x2ce661(0x77b)](this['_growY'],this[_0x2ce661(0x996)],_0x4661e7,_0x41e47e,_0x13bac4)):(this[_0x2ce661(0x8a0)]=(this['_growX']*(_0x4661e7-0x1)+this[_0x2ce661(0x6da)])/_0x4661e7,this[_0x2ce661(0x603)]=(this[_0x2ce661(0x603)]*(_0x4661e7-0x1)+this['_targetGrowY'])/_0x4661e7);this[_0x2ce661(0x26a)]--;if(this[_0x2ce661(0x26a)]<=0x0)this[_0x2ce661(0x5ef)]();},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x5ef)]=function(){const _0x440cc0=_0x1a8785;this[_0x440cc0(0x8a0)]=this[_0x440cc0(0x6da)],this[_0x440cc0(0x603)]=this['_targetGrowY'];},Sprite_Battler['prototype'][_0x1a8785(0x7f8)]=function(){const _0x4b4426=_0x1a8785;return this[_0x4b4426(0x26a)]>0x0;},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x867)]=function(_0x177541,_0x43c6bd,_0x1db39a,_0x33c46c){const _0xca6f3a=_0x1a8785;if(!this[_0xca6f3a(0x42d)]())return;if(!this[_0xca6f3a(0x194)])return;if(this['_targetSkewX']===_0x177541&&this[_0xca6f3a(0x303)]===_0x43c6bd)return;this[_0xca6f3a(0x2b3)]=_0x177541,this[_0xca6f3a(0x303)]=_0x43c6bd,this[_0xca6f3a(0x3e4)]=_0x1db39a,this['_skewWholeDuration']=_0x1db39a,this[_0xca6f3a(0x8f0)]=_0x33c46c||_0xca6f3a(0x434),_0x1db39a<=0x0&&(this[_0xca6f3a(0x194)]['skew']['x']=this[_0xca6f3a(0x2b3)],this[_0xca6f3a(0x194)][_0xca6f3a(0x292)]['y']=this['_targetSkewY']);},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x74b)]=function(){const _0x35d228=_0x1a8785;if(this[_0x35d228(0x3e4)]<=0x0)return;if(!this[_0x35d228(0x194)])return;const _0x2f9363=this[_0x35d228(0x3e4)],_0x1c3179=this[_0x35d228(0x41a)],_0x1e4442=this[_0x35d228(0x8f0)],_0x3c84d9=this['_distortionSprite'];Imported['VisuMZ_0_CoreEngine']?(_0x3c84d9[_0x35d228(0x292)]['x']=this[_0x35d228(0x77b)](_0x3c84d9['skew']['x'],this[_0x35d228(0x2b3)],_0x2f9363,_0x1c3179,_0x1e4442),_0x3c84d9[_0x35d228(0x292)]['y']=this[_0x35d228(0x77b)](_0x3c84d9[_0x35d228(0x292)]['y'],this[_0x35d228(0x303)],_0x2f9363,_0x1c3179,_0x1e4442)):(_0x3c84d9[_0x35d228(0x292)]['x']=(_0x3c84d9[_0x35d228(0x292)]['x']*(_0x2f9363-0x1)+this[_0x35d228(0x2b3)])/_0x2f9363,_0x3c84d9[_0x35d228(0x292)]['y']=(_0x3c84d9[_0x35d228(0x292)]['y']*(_0x2f9363-0x1)+this[_0x35d228(0x303)])/_0x2f9363);this[_0x35d228(0x3e4)]--;if(this[_0x35d228(0x3e4)]<=0x0)this[_0x35d228(0x482)]();},Sprite_Battler['prototype'][_0x1a8785(0x482)]=function(){const _0x33dec0=_0x1a8785;this[_0x33dec0(0x194)][_0x33dec0(0x292)]['x']=this['_targetSkewX'],this['_distortionSprite'][_0x33dec0(0x292)]['y']=this['_targetSkewY'];},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x6c0)]=function(){const _0x2b6233=_0x1a8785;return this[_0x2b6233(0x3e4)]>0x0;},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x593)]=function(_0x23ee04,_0x215dab,_0x3b0b1c,_0x4b43ee){const _0xe17791=_0x1a8785;if(!this[_0xe17791(0x42d)]())return;if(!this[_0xe17791(0x194)])return;if(this[_0xe17791(0x36d)]===_0x23ee04)return;this['_targetAngle']=_0x23ee04,this[_0xe17791(0xb05)]=_0x215dab,this[_0xe17791(0x422)]=_0x215dab,this[_0xe17791(0x4bc)]=_0x3b0b1c||'Linear',this[_0xe17791(0x309)]=_0x4b43ee,this[_0xe17791(0x309)]===undefined&&(this[_0xe17791(0x309)]=!![]),_0x215dab<=0x0&&(this[_0xe17791(0x355)]=_0x23ee04,this[_0xe17791(0x309)]&&(this[_0xe17791(0x36d)]=0x0,this['_currentAngle']=0x0));},Sprite_Battler['prototype'][_0x1a8785(0x3f9)]=function(){const _0x17b472=_0x1a8785;this['updateAngleCalculations'](),this[_0x17b472(0x668)]();},Sprite_Battler['prototype'][_0x1a8785(0x59f)]=function(){const _0x45de5f=_0x1a8785;if(this[_0x45de5f(0xb05)]<=0x0)return;const _0x219ca8=this[_0x45de5f(0xb05)],_0x2e6cec=this[_0x45de5f(0x422)],_0x3b933e=this[_0x45de5f(0x4bc)];Imported[_0x45de5f(0x211)]?this[_0x45de5f(0x355)]=this['applyEasing'](this[_0x45de5f(0x355)],this[_0x45de5f(0x36d)],_0x219ca8,_0x2e6cec,_0x3b933e):this['_currentAngle']=(this[_0x45de5f(0x355)]*(_0x219ca8-0x1)+this[_0x45de5f(0x36d)])/_0x219ca8;this[_0x45de5f(0xb05)]--;if(this[_0x45de5f(0xb05)]<=0x0)this[_0x45de5f(0x17b)]();},Sprite_Battler['prototype'][_0x1a8785(0x17b)]=function(){const _0x5a2f76=_0x1a8785;this['_currentAngle']=this[_0x5a2f76(0x36d)],this[_0x5a2f76(0x309)]&&(this['_targetAngle']=0x0,this[_0x5a2f76(0x355)]=0x0);},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x749)]=function(){const _0x5ee46a=_0x1a8785;return this[_0x5ee46a(0xb05)]>0x0;},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x668)]=function(){const _0x3222e2=_0x1a8785;if(!this[_0x3222e2(0x194)])return;const _0x5dd8c5=this['_currentAngle'],_0x7763ec=this[_0x3222e2(0x768)]['x'],_0x515a95=this[_0x3222e2(0x8b2)][_0x3222e2(0x68d)]()?-0x1:0x1;this[_0x3222e2(0x194)][_0x3222e2(0x4c5)]=_0x5dd8c5*_0x7763ec*_0x515a95;const _0x561649=this[_0x3222e2(0x194)]['scale']['y'];this[_0x3222e2(0x194)]['y']=this[_0x3222e2(0x98e)]*-0.5*(0x2-_0x561649),this[_0x3222e2(0x194)]['y']=Math[_0x3222e2(0x348)](this[_0x3222e2(0x194)]['y']);const _0x562fa6=[this[_0x3222e2(0x91b)],this[_0x3222e2(0xadf)],this[_0x3222e2(0xa47)]];for(const _0x5caf82 of _0x562fa6){if(!_0x5caf82)continue;_0x5caf82['y']=this['height']*0.5;}this['_shadowSprite']&&(this['_shadowScaleX']=this[_0x3222e2(0x8e4)]??0x1,this[_0x3222e2(0x9ed)]=this[_0x3222e2(0x9ed)]??0x1,this[_0x3222e2(0x5e6)][_0x3222e2(0x768)]['x']=this[_0x3222e2(0x194)][_0x3222e2(0x768)]['x']*this[_0x3222e2(0x8e4)],this[_0x3222e2(0x5e6)][_0x3222e2(0x768)]['y']=this[_0x3222e2(0x194)][_0x3222e2(0x768)]['y']*this['_shadowScaleY']);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0xafd)]=Sprite_Actor[_0x1a8785(0x978)]['createStateSprite'],Sprite_Actor[_0x1a8785(0x978)][_0x1a8785(0x349)]=function(){const _0x54707c=_0x1a8785;VisuMZ[_0x54707c(0x83c)][_0x54707c(0xafd)][_0x54707c(0x716)](this),VisuMZ['BattleCore'][_0x54707c(0x9a7)][_0x54707c(0x9d0)][_0x54707c(0x909)]&&this['createHpGaugeSprite']();},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x712)]=Sprite_Enemy[_0x1a8785(0x978)][_0x1a8785(0x374)],Sprite_Enemy['prototype'][_0x1a8785(0x374)]=function(){const _0x19a73e=_0x1a8785;VisuMZ[_0x19a73e(0x83c)][_0x19a73e(0x9a7)][_0x19a73e(0x9d0)]['ShowEnemyGauge']&&this[_0x19a73e(0x69c)](),VisuMZ[_0x19a73e(0x83c)][_0x19a73e(0x712)][_0x19a73e(0x716)](this);},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x69c)]=function(){const _0x16b66f=_0x1a8785;if(!ConfigManager[_0x16b66f(0xa96)])return;if(this[_0x16b66f(0x79d)]===Sprite_SvEnemy)return;const _0x59de3c=VisuMZ[_0x16b66f(0x83c)][_0x16b66f(0x9a7)][_0x16b66f(0x9d0)],_0x3d49a7=new Sprite_HpGauge();_0x3d49a7[_0x16b66f(0x7b1)]['x']=_0x59de3c[_0x16b66f(0xafc)],_0x3d49a7['anchor']['y']=_0x59de3c[_0x16b66f(0x53e)],_0x3d49a7[_0x16b66f(0x768)]['x']=_0x3d49a7[_0x16b66f(0x768)]['y']=_0x59de3c['Scale'],this[_0x16b66f(0x5f5)]=_0x3d49a7,this[_0x16b66f(0xaba)](this[_0x16b66f(0x5f5)]),Spriteset_Battle[_0x16b66f(0x83d)]&&BattleManager[_0x16b66f(0x193)](this[_0x16b66f(0x5f5)]);},VisuMZ[_0x1a8785(0x83c)]['Sprite_Battler_setBattler']=Sprite_Battler['prototype'][_0x1a8785(0x464)],Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x464)]=function(_0x412a57){const _0x19475a=_0x1a8785,_0x5d5f84=this[_0x19475a(0x8b2)];VisuMZ[_0x19475a(0x83c)][_0x19475a(0x242)][_0x19475a(0x716)](this,_0x412a57),this[_0x19475a(0x338)](_0x412a57);if(_0x5d5f84!==_0x412a57)this['updateShadowScale']();},Sprite_Battler[_0x1a8785(0x978)]['setupHpGaugeSprite']=function(_0x3e1a4c){const _0x5a07d7=_0x1a8785;if(!_0x3e1a4c)return;if(!this[_0x5a07d7(0x5f5)])return;if(_0x3e1a4c['isActor']()){}else{if(_0x3e1a4c[_0x5a07d7(0x3a6)]()){if(this[_0x5a07d7(0x79d)]===Sprite_SvEnemy&&!_0x3e1a4c[_0x5a07d7(0x907)]())return;}}this[_0x5a07d7(0x5f5)][_0x5a07d7(0x352)](_0x3e1a4c,'hp');},Sprite_Battler[_0x1a8785(0x978)]['hasStaticSvBattler']=function(){const _0x33bf73=_0x1a8785;return this[_0x33bf73(0x8b2)]&&this[_0x33bf73(0x8b2)]['hasStaticSvBattler']();},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x253)]=function(){const _0x10fdda=_0x1a8785,_0xadbd=this[_0x10fdda(0x91b)][_0x10fdda(0x92b)];if(!_0xadbd)return;const _0x292b7a=_0xadbd[_0x10fdda(0x92d)];let _0x5b78e5=_0xadbd[_0x10fdda(0x98e)];if(this[_0x10fdda(0x8b2)]['isDead']()){if(this[_0x10fdda(0x6a9)])_0x5b78e5=Math[_0x10fdda(0x5a7)](0x0,this[_0x10fdda(0x6a9)][_0x10fdda(0x98e)]-0x4);}this[_0x10fdda(0x91b)][_0x10fdda(0x645)](0x0,0x0,_0x292b7a,_0x5b78e5),this['setFrame'](0x0,0x0,_0x292b7a,_0x5b78e5);},Sprite_Battler[_0x1a8785(0x978)]['updateHpGaugePosition']=function(){const _0x52c6b4=_0x1a8785;if(!this['_battler'])return;if(!this[_0x52c6b4(0x5f5)])return;const _0xf2c775=VisuMZ[_0x52c6b4(0x83c)][_0x52c6b4(0x9a7)][_0x52c6b4(0x9d0)],_0x4a90e7=this[_0x52c6b4(0x5f5)];_0x4a90e7[_0x52c6b4(0xac3)]=this[_0x52c6b4(0x22e)]();const _0x3ffd3e=_0xf2c775[_0x52c6b4(0xa93)],_0x3176d3=_0xf2c775[_0x52c6b4(0x4bf)];_0x4a90e7['x']=_0x3ffd3e,_0x4a90e7['x']+=this[_0x52c6b4(0x8b2)][_0x52c6b4(0x1ad)](),_0x4a90e7['y']=-this[_0x52c6b4(0x98e)]+_0x3176d3,_0x4a90e7['y']+=this[_0x52c6b4(0x8b2)]['battleUIOffsetY'](),Spriteset_Battle['ANTI_TINT_UI']&&SceneManager[_0x52c6b4(0xa42)]['_spriteset']&&(_0x4a90e7['x']+=this['x'],_0x4a90e7['y']+=this['y']);},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x22e)]=function(){const _0x596cc4=_0x1a8785;if(!this['_battler'])return![];if(this[_0x596cc4(0x8b2)][_0x596cc4(0x68d)]())return!![];if(this['_battler']['isHidden']())return![];if(this[_0x596cc4(0xaeb)]<=0x0)return![];const _0x13c80c=this['_battler'][_0x596cc4(0x739)]()[_0x596cc4(0x9c6)];if(_0x13c80c[_0x596cc4(0x9e0)](/<SHOW HP GAUGE>/i))return!![];if(_0x13c80c['match'](/<HIDE HP GAUGE>/i))return![];const _0x20ba50=VisuMZ[_0x596cc4(0x83c)][_0x596cc4(0x9a7)]['HpGauge'];if(_0x20ba50[_0x596cc4(0x1e3)]){if(_0x20ba50['BTestBypass']&&BattleManager[_0x596cc4(0x27c)]())return!![];if(this[_0x596cc4(0x8b2)]['_visualHpGauge_JustDied'])return![];return this['_battler'][_0x596cc4(0x705)]();}return!![];},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x2d5)]=Sprite_Battler['prototype'][_0x1a8785(0x454)],Sprite_Battler['prototype'][_0x1a8785(0x454)]=function(){const _0x4610f6=_0x1a8785;if(!this[_0x4610f6(0x8b2)])return![];if(this[_0x4610f6(0x46c)]>0x0)return!![];return VisuMZ[_0x4610f6(0x83c)][_0x4610f6(0x2d5)]['call'](this);},VisuMZ['BattleCore']['Sprite_Battler_startMove']=Sprite_Battler['prototype'][_0x1a8785(0x21c)],Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x21c)]=function(_0x26a6da,_0xf0fc64,_0x35c15d){const _0xe3568d=_0x1a8785;this[_0xe3568d(0x42d)]()&&VisuMZ[_0xe3568d(0x83c)]['Sprite_Battler_startMove']['call'](this,_0x26a6da,_0xf0fc64,_0x35c15d);},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x42d)]=function(){const _0x189a85=_0x1a8785;if(this[_0x189a85(0x8b2)]&&this['_battler'][_0x189a85(0x37f)]())return![];if(this[_0x189a85(0x8b2)]&&!this[_0x189a85(0x8b2)][_0x189a85(0x76b)]())return![];return $gameSystem[_0x189a85(0x973)]();},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x4b9)]=function(){},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x56b)]=function(){const _0x3b9a52=_0x1a8785;this[_0x3b9a52(0x21c)](0x0,0x0,0xc);},Sprite_Battler[_0x1a8785(0x978)]['retreat']=function(){},Sprite_Battler[_0x1a8785(0x978)]['stepFlinch']=function(){const _0x5d5a67=_0x1a8785,_0x3a0823=VisuMZ[_0x5d5a67(0x83c)][_0x5d5a67(0x9a7)][_0x5d5a67(0x1d0)],_0x9511d4=this[_0x5d5a67(0x8b2)]&&this[_0x5d5a67(0x8b2)][_0x5d5a67(0x68d)]()?0x1:-0x1,_0x37e62f=this['_baseX']-this[_0x5d5a67(0x9b9)]+_0x9511d4*_0x3a0823['FlinchDistanceX'],_0x2eb7fc=this['_baseY']-this[_0x5d5a67(0x774)]+_0x9511d4*_0x3a0823['FlinchDistanceY'],_0x5924b9=_0x3a0823[_0x5d5a67(0x330)];this['startMove'](_0x37e62f,_0x2eb7fc,_0x5924b9);},Sprite_Battler[_0x1a8785(0x978)][_0x1a8785(0x605)]=function(_0x17639c,_0x202578){const _0x7cfc26=_0x1a8785,_0x1d5ba9=VisuMZ[_0x7cfc26(0x83c)]['Settings'][_0x7cfc26(0x1d0)];this[_0x7cfc26(0x418)]=Math[_0x7cfc26(0x348)]((_0x1d5ba9[_0x7cfc26(0x2e0)]??0x18)*_0x202578),this[_0x7cfc26(0x4db)]=Math[_0x7cfc26(0x5a7)](this[_0x7cfc26(0x4db)],_0x17639c);},Sprite_Battler['prototype'][_0x1a8785(0x6de)]=function(){const _0x4b1036=_0x1a8785,_0x4a2052=VisuMZ[_0x4b1036(0x83c)][_0x4b1036(0x9a7)][_0x4b1036(0x1d0)];if(!(_0x4a2052[_0x4b1036(0x393)]??![]))return;if(this[_0x4b1036(0x418)]>0x0){const _0xf0f9b6=this[_0x4b1036(0x418)];this[_0x4b1036(0x4db)]=this[_0x4b1036(0x4db)]*(_0xf0f9b6-0x1)/_0xf0f9b6,this[_0x4b1036(0x418)]--,this[_0x4b1036(0x418)]<=0x0&&(this[_0x4b1036(0x4db)]=0x0);}this['_shakeFlinchPower']>0x0?(this[_0x4b1036(0x91b)]['x']=Math[_0x4b1036(0x526)](this[_0x4b1036(0x4db)])*(Math['random']()<0.5?-0x1:0x1),this[_0x4b1036(0x236)]!==this['y']&&(this['_mainSprite']['y']=this[_0x4b1036(0x98e)]*0.5,this[_0x4b1036(0x91b)]['y']+=Math['randomInt'](this['_shakeFlinchPower'])*(Math[_0x4b1036(0x876)]()<0.5?-0x1:0x1))):(this[_0x4b1036(0x91b)]['x']=0x0,this[_0x4b1036(0x91b)]['y']=this[_0x4b1036(0x98e)]*0.5);},VisuMZ[_0x1a8785(0x83c)]['Sprite_Actor_initMembers']=Sprite_Actor['prototype'][_0x1a8785(0x9a3)],Sprite_Actor[_0x1a8785(0x978)]['initMembers']=function(){const _0x4fe3b9=_0x1a8785;VisuMZ[_0x4fe3b9(0x83c)]['Sprite_Actor_initMembers']['call'](this),this['attachSpritesToDistortionSprite']();},Sprite_Actor[_0x1a8785(0x978)][_0x1a8785(0x7b3)]=function(){const _0x2b58e9=_0x1a8785;return this[_0x2b58e9(0x194)]||this[_0x2b58e9(0x91b)]||this;},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x1ef)]=Sprite_Actor[_0x1a8785(0x978)][_0x1a8785(0x203)],Sprite_Actor[_0x1a8785(0x978)][_0x1a8785(0x203)]=function(){},Sprite_Actor[_0x1a8785(0x978)][_0x1a8785(0x5a4)]=function(_0x5edf1b){const _0x5e0cc3=_0x1a8785;if(SceneManager[_0x5e0cc3(0x569)]())return;if(!_0x5edf1b)return;if(!_0x5edf1b[_0x5e0cc3(0x42d)]())return;VisuMZ['BattleCore'][_0x5e0cc3(0x1ef)][_0x5e0cc3(0x716)](this);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x9a6)]=Sprite_Actor[_0x1a8785(0x978)][_0x1a8785(0x9b7)],Sprite_Actor[_0x1a8785(0x978)][_0x1a8785(0x9b7)]=function(_0x4cbaee){const _0x8344de=_0x1a8785;VisuMZ[_0x8344de(0x83c)][_0x8344de(0x9a7)]['Actor'][_0x8344de(0x87c)]?VisuMZ['BattleCore'][_0x8344de(0x9a7)][_0x8344de(0x1d0)][_0x8344de(0x87c)]['call'](this,_0x4cbaee):VisuMZ['BattleCore'][_0x8344de(0x9a6)][_0x8344de(0x716)](this,_0x4cbaee);},VisuMZ[_0x1a8785(0x83c)]['Sprite_Actor_setBattler']=Sprite_Actor['prototype']['setBattler'],Sprite_Actor[_0x1a8785(0x978)]['setBattler']=function(_0x12cddc){const _0x2801cf=_0x1a8785;VisuMZ[_0x2801cf(0x83c)]['Sprite_Actor_setBattler']['call'](this,_0x12cddc),this[_0x2801cf(0xa25)](_0x12cddc);},Sprite_Actor[_0x1a8785(0x978)][_0x1a8785(0xa25)]=function(_0x5f298f){const _0x15afb2=_0x1a8785;if(!_0x5f298f)return;if(!this[_0x15afb2(0x91b)])return;this[_0x15afb2(0x91b)]['anchor']['x']=this[_0x15afb2(0x8f2)][_0x15afb2(0x191)](),this[_0x15afb2(0x91b)][_0x15afb2(0x7b1)]['y']=this['_actor'][_0x15afb2(0x713)](),this[_0x15afb2(0x568)]();},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x99b)]=Sprite_Actor[_0x1a8785(0x978)][_0x1a8785(0x31a)],Sprite_Actor[_0x1a8785(0x978)][_0x1a8785(0x31a)]=function(){const _0x1027a4=_0x1a8785;VisuMZ['BattleCore']['Sprite_Actor_update'][_0x1027a4(0x716)](this),this[_0x1027a4(0x8f2)]&&(this[_0x1027a4(0xa9b)](),this[_0x1027a4(0x906)]());},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x465)]=Sprite_Actor[_0x1a8785(0x978)][_0x1a8785(0x781)],Sprite_Actor[_0x1a8785(0x978)]['updateBitmap']=function(){const _0x4d0635=_0x1a8785;VisuMZ[_0x4d0635(0x83c)][_0x4d0635(0x465)][_0x4d0635(0x716)](this),this[_0x4d0635(0x91b)]&&this[_0x4d0635(0x91b)][_0x4d0635(0x92b)]&&this['_battler']&&(this[_0x4d0635(0x91b)]['bitmap'][_0x4d0635(0x66c)]!==this['_battler']['battlerSmoothImage']()&&(this['_mainSprite'][_0x4d0635(0x92b)][_0x4d0635(0x66c)]=this[_0x4d0635(0x8b2)][_0x4d0635(0x484)]()));},VisuMZ[_0x1a8785(0x83c)]['Sprite_Actor_updateShadow']=Sprite_Actor['prototype'][_0x1a8785(0x793)],Sprite_Actor[_0x1a8785(0x978)]['updateShadow']=function(){const _0x4c327e=_0x1a8785;VisuMZ['BattleCore']['Sprite_Actor_updateShadow']['call'](this),this[_0x4c327e(0x782)]();},Sprite_Actor[_0x1a8785(0x978)]['updateShadowBattleCore']=function(){const _0x1d70ff=_0x1a8785;if(!this[_0x1d70ff(0x91b)])return;if(!this[_0x1d70ff(0x5e6)])return;this[_0x1d70ff(0x568)](),this[_0x1d70ff(0x659)]();},Sprite_Actor[_0x1a8785(0x978)][_0x1a8785(0xa9b)]=function(){const _0x4ee6ed=_0x1a8785;this[_0x4ee6ed(0xa15)]['scale']['x']=0x1/(this['scale']['x']||0.001),this[_0x4ee6ed(0xa15)][_0x4ee6ed(0x768)]['y']=0x1/(this['scale']['y']||0.001);},Sprite_Actor[_0x1a8785(0x978)]['updateStyleOpacity']=function(){const _0x1be7b0=_0x1a8785;if(!$gameSystem[_0x1be7b0(0x973)]()&&this[_0x1be7b0(0x79d)]===Sprite_Actor){const _0x14dc67=Scene_Battle[_0x1be7b0(0x978)]['battleLayoutStyle']();[_0x1be7b0(0x3ee),_0x1be7b0(0x43b),_0x1be7b0(0x5b2),'border']['includes'](_0x14dc67)&&(this['opacity']=0x0);}},Sprite_Actor['prototype'][_0x1a8785(0x5ca)]=function(){const _0x885816=_0x1a8785,_0x33f32c=this[_0x885816(0x8f2)];if(_0x33f32c){const _0x5dc11e=_0x33f32c[_0x885816(0x8c6)]();if(_0x33f32c[_0x885816(0x99f)]()||_0x33f32c[_0x885816(0x1c5)]())this[_0x885816(0x1f7)](_0x885816(0x543));else{if(_0x5dc11e===0x3)this[_0x885816(0x1f7)](_0x885816(0x51c));else{if(_0x5dc11e===0x2)this[_0x885816(0x1f7)](_0x885816(0x7f6));else{if(this[_0x885816(0x183)])this[_0x885816(0x1f7)](_0x885816(0x425));else{if(_0x33f32c[_0x885816(0x887)]())this[_0x885816(0x1f7)](_0x885816(0x7c9));else{if(_0x33f32c[_0x885816(0x259)]())this[_0x885816(0x1f7)](_0x885816(0x4e8));else{if(_0x33f32c[_0x885816(0xae0)]()||_0x33f32c[_0x885816(0xa57)]())this['startMotion'](_0x885816(0x237));else{if(_0x5dc11e===0x1)this[_0x885816(0x1f7)](_0x885816(0x957));else{if(_0x33f32c['isDying']())this['startMotion']('dying');else{if(_0x33f32c['isUndecided']())this[_0x885816(0x1f7)]('walk');else _0x33f32c[_0x885816(0x916)]()?this[_0x885816(0x1f7)](_0x885816(0x7c9)):this['startMotion'](_0x885816(0x543));}}}}}}}}}}},Sprite_Actor[_0x1a8785(0x978)][_0x1a8785(0x1bb)]=function(){const _0x471de4=_0x1a8785,_0x492ebb=0xa,_0x5b8ec6=0x12c*_0x492ebb,_0x4b39ee=0x1e*_0x492ebb;this[_0x471de4(0x21c)](_0x5b8ec6,0x0,_0x4b39ee);},Sprite_Actor[_0x1a8785(0x978)][_0x1a8785(0x43a)]=function(){const _0x4afea4=_0x1a8785;Sprite_Battler['prototype'][_0x4afea4(0x43a)]['call'](this);},Sprite_Actor['prototype']['motionSpeed']=function(){const _0x59a5f9=_0x1a8785;return Sprite_Battler[_0x59a5f9(0x1a4)];},Sprite_Weapon[_0x1a8785(0x978)]['animationWait']=function(){return Sprite_Battler['_motionSpeed'];},Sprite_Actor[_0x1a8785(0x978)][_0x1a8785(0x7f4)]=function(){},Sprite_Actor[_0x1a8785(0x978)][_0x1a8785(0xa43)]=function(){},Sprite_Actor[_0x1a8785(0x978)][_0x1a8785(0x3d7)]=function(){const _0x487d67=_0x1a8785;if(this[_0x487d67(0x328)]&&++this[_0x487d67(0xabd)]>=this[_0x487d67(0x8f7)]()){if(this[_0x487d67(0x328)][_0x487d67(0xa86)])this[_0x487d67(0xa88)]=(this[_0x487d67(0xa88)]+0x1)%0x4;else this[_0x487d67(0xa88)]<0x2?this[_0x487d67(0xa88)]++:this[_0x487d67(0x5ca)]();this[_0x487d67(0xabd)]=0x0;}},Sprite_Actor[_0x1a8785(0x978)][_0x1a8785(0x3fc)]=function(_0x2ac62b){const _0x487feb=_0x1a8785;if(_0x2ac62b===_0x487feb(0x228))this[_0x487feb(0xa41)]=!![];if(this['_battler']&&this[_0x487feb(0x8b2)]['isDead']()){this[_0x487feb(0x328)]=Sprite_Actor['MOTIONS']['dead'];return;}const _0x3a004b=Sprite_Actor[_0x487feb(0x508)][_0x2ac62b];this['_motion']=_0x3a004b,this[_0x487feb(0xabd)]=0x0,this[_0x487feb(0xa88)]=0x0;},Sprite_Actor[_0x1a8785(0x978)]['forceWeaponAnimation']=function(_0x1db8a6){const _0x1586d7=_0x1a8785;if(this[_0x1586d7(0x51b)]())return;this[_0x1586d7(0x94b)](),this[_0x1586d7(0x709)]['setup'](_0x1db8a6),this[_0x1586d7(0x8f2)][_0x1586d7(0x322)]();},Sprite_Actor[_0x1a8785(0x978)]['adjustWeaponSpriteOffset']=function(){const _0x517f44=_0x1a8785;let _0x26cb75=-0x10,_0x2393dc=this[_0x517f44(0x98e)]*0.5;const _0x1295bb=/<SIDEVIEW WEAPON OFFSET:[ ]([\+\-]\d+),[ ]([\+\-]\d+)>/i,_0x4a501c=this['_battler']['traitObjects']()['map'](_0x50255c=>_0x50255c&&_0x50255c[_0x517f44(0x9c6)][_0x517f44(0x9e0)](_0x1295bb)?Number(RegExp['$1']):0x0),_0x328f69=this[_0x517f44(0x8b2)][_0x517f44(0x990)]()['map'](_0x3a572d=>_0x3a572d&&_0x3a572d[_0x517f44(0x9c6)][_0x517f44(0x9e0)](_0x1295bb)?Number(RegExp['$2']):0x0);_0x26cb75=_0x4a501c[_0x517f44(0x220)]((_0x557b68,_0x1b94cb)=>_0x557b68+_0x1b94cb,_0x26cb75),_0x2393dc=_0x328f69[_0x517f44(0x220)]((_0x298878,_0x12f693)=>_0x298878+_0x12f693,_0x2393dc),this[_0x517f44(0x709)]['x']=_0x26cb75,this[_0x517f44(0x709)]['y']=_0x2393dc,this[_0x517f44(0x709)][_0x517f44(0x31a)]();},Sprite_Weapon[_0x1a8785(0x978)]['setup']=function(_0x46e5e4){const _0x50f006=_0x1a8785;this[_0x50f006(0x427)]=_0x46e5e4,this[_0x50f006(0x810)]=-0x1,this[_0x50f006(0xa88)]=0x0,this[_0x50f006(0xa0d)](),this[_0x50f006(0x6f9)]();},Sprite_Actor['prototype'][_0x1a8785(0x8bd)]=function(){},Sprite_Actor[_0x1a8785(0x978)][_0x1a8785(0x4b9)]=function(){const _0x127777=_0x1a8785,_0x1e436c=VisuMZ[_0x127777(0x83c)][_0x127777(0x9a7)][_0x127777(0x6fa)],_0x15091b=_0x1e436c[_0x127777(0x4f0)],_0x413ce0=_0x1e436c[_0x127777(0x43c)],_0x61977d=_0x1e436c[_0x127777(0xb00)];this[_0x127777(0x21c)](-_0x15091b,-_0x413ce0,_0x61977d);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x264)]=Sprite_Actor[_0x1a8785(0x978)][_0x1a8785(0x6f9)],Sprite_Actor[_0x1a8785(0x978)][_0x1a8785(0x6f9)]=function(){const _0x4beb22=_0x1a8785;this[_0x4beb22(0x51b)]()?this['updateStaticSvBattlerFrames']():(this[_0x4beb22(0x208)](),VisuMZ[_0x4beb22(0x83c)]['Sprite_Actor_updateFrame'][_0x4beb22(0x716)](this));},Sprite_Actor[_0x1a8785(0x978)][_0x1a8785(0x208)]=function(){const _0x3168cc=_0x1a8785;if(this[_0x3168cc(0x8b2)]&&this[_0x3168cc(0x8b2)][_0x3168cc(0x446)]){const _0x32623f=this[_0x3168cc(0x8b2)][_0x3168cc(0x446)];this[_0x3168cc(0x328)]=Sprite_Actor[_0x3168cc(0x508)][_0x32623f['motionType']],this[_0x3168cc(0xa88)]=_0x32623f[_0x3168cc(0x922)];const _0x4b107e=this[_0x3168cc(0x709)];_0x4b107e[_0x3168cc(0x8d1)](_0x32623f[_0x3168cc(0x2b5)],_0x32623f['pattern']),this[_0x3168cc(0x94b)]();}},Sprite_Weapon['prototype'][_0x1a8785(0x8d1)]=function(_0x223245,_0x44d369){const _0x479009=_0x1a8785;this['_weaponImageId']=_0x223245,this['_animationCount']=-Infinity,this['_pattern']=_0x44d369,this[_0x479009(0xa0d)](),this[_0x479009(0x6f9)]();},Sprite_Enemy['prototype']['initMembers']=function(){const _0x3e93e0=_0x1a8785;Sprite_Battler[_0x3e93e0(0x978)]['initMembers']['call'](this),this['_enemy']=null,this[_0x3e93e0(0xa65)]=![],this[_0x3e93e0(0x7b5)]='',this[_0x3e93e0(0x437)]=0x0,this[_0x3e93e0(0x6ac)]=null,this[_0x3e93e0(0x7df)]=0x0,this['_shake']=0x0,this[_0x3e93e0(0x3ca)](),this['createStateIconSprite']();},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x22b)]=Sprite_Enemy['prototype'][_0x1a8785(0x31a)],Sprite_Enemy[_0x1a8785(0x978)][_0x1a8785(0x31a)]=function(){const _0x5c1c83=_0x1a8785;VisuMZ[_0x5c1c83(0x83c)][_0x5c1c83(0x22b)][_0x5c1c83(0x716)](this),this[_0x5c1c83(0x568)]();},Sprite_Enemy[_0x1a8785(0x978)][_0x1a8785(0x3ca)]=function(){const _0x389597=_0x1a8785;this[_0x389597(0x91b)]=new Sprite(),this[_0x389597(0x91b)][_0x389597(0x7b1)]['x']=0.5,this['_mainSprite'][_0x389597(0x7b1)]['y']=0x1,this[_0x389597(0xaba)](this[_0x389597(0x91b)]),this[_0x389597(0x1f1)]();},Sprite_Enemy['prototype']['mainSprite']=function(){const _0x2dab6c=_0x1a8785;return this[_0x2dab6c(0x194)]||this['_mainSprite']||this;},Sprite_Enemy[_0x1a8785(0x978)][_0x1a8785(0xa0d)]=function(_0x1bd2da){const _0x2b5836=_0x1a8785;this[_0x2b5836(0x92b)]=new Bitmap(0x1,0x1);if(this['hasSvBattler']()){const _0x15b815=this['_enemy'][_0x2b5836(0x49a)]();this['bitmap']=new Bitmap(_0x15b815[_0x2b5836(0x92d)],_0x15b815['height']),this[_0x2b5836(0x91b)][_0x2b5836(0x92b)]=new Bitmap(0x1,0x1);}else{if($gameSystem[_0x2b5836(0x973)]()){const _0x4e1ca1=ImageManager[_0x2b5836(0x323)](_0x1bd2da);_0x4e1ca1['addLoadListener'](this[_0x2b5836(0x340)][_0x2b5836(0x6e7)](this,_0x4e1ca1));}else{const _0x2b7f00=ImageManager['loadEnemy'](_0x1bd2da);_0x2b7f00['addLoadListener'](this['onStaticEnemyBitmapLoad'][_0x2b5836(0x6e7)](this,_0x2b7f00));}}},Sprite_Enemy['prototype'][_0x1a8785(0x340)]=function(_0x2b8213){const _0x6577f0=_0x1a8785;this[_0x6577f0(0x91b)]['bitmap']=_0x2b8213,this[_0x6577f0(0x92b)]=new Bitmap(_0x2b8213['width'],_0x2b8213[_0x6577f0(0x98e)]);},VisuMZ['BattleCore']['Sprite_Enemy_setHue']=Sprite_Enemy[_0x1a8785(0x978)][_0x1a8785(0x20a)],Sprite_Enemy[_0x1a8785(0x978)][_0x1a8785(0x20a)]=function(_0x17879b){const _0x214389=_0x1a8785;this[_0x214389(0x91b)]&&this[_0x214389(0x91b)][_0x214389(0x20a)](_0x17879b);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x1e9)]=Sprite_Enemy[_0x1a8785(0x978)][_0x1a8785(0x561)],Sprite_Enemy[_0x1a8785(0x978)]['initVisibility']=function(){const _0x12dd25=_0x1a8785;this[_0x12dd25(0x5da)]()?VisuMZ['BattleCore']['Sprite_Enemy_initVisibility'][_0x12dd25(0x716)](this):(this['_appeared']=!this[_0x12dd25(0x416)]['isHidden'](),!this[_0x12dd25(0xa65)]&&(this[_0x12dd25(0xaeb)]=0x0));},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x190)]=Sprite_Enemy[_0x1a8785(0x978)]['updateCollapse'],Sprite_Enemy[_0x1a8785(0x978)]['updateCollapse']=function(){const _0x1dfe5b=_0x1a8785;if(this['allowCollapse']())VisuMZ[_0x1dfe5b(0x83c)]['Sprite_Enemy_updateCollapse'][_0x1dfe5b(0x716)](this);},Sprite_Enemy[_0x1a8785(0x978)][_0x1a8785(0x6f9)]=function(){const _0x55a447=_0x1a8785;Sprite_Battler[_0x55a447(0x978)][_0x55a447(0x6f9)][_0x55a447(0x716)](this);const _0x32512f=this[_0x55a447(0x7b3)]()||this;if(!_0x32512f)return;!_0x32512f['bitmap']&&(_0x32512f[_0x55a447(0x92b)]=new Bitmap(this[_0x55a447(0x92d)],this['height'])),this[_0x55a447(0x6ac)]===_0x55a447(0x6d9)?this[_0x55a447(0x91b)][_0x55a447(0x645)](0x0,0x0,this[_0x55a447(0x91b)]['width'],this[_0x55a447(0x7df)]):_0x32512f['setFrame'](0x0,0x0,_0x32512f['bitmap'][_0x55a447(0x92d)],this[_0x55a447(0x92b)][_0x55a447(0x98e)]);},VisuMZ[_0x1a8785(0x83c)]['Sprite_Enemy_updateBossCollapse']=Sprite_Enemy[_0x1a8785(0x978)][_0x1a8785(0x47f)],Sprite_Enemy[_0x1a8785(0x978)][_0x1a8785(0x47f)]=function(){const _0x2741de=_0x1a8785;if(this[_0x2741de(0x5da)]())VisuMZ['BattleCore'][_0x2741de(0x679)][_0x2741de(0x716)](this);},Sprite_Enemy[_0x1a8785(0x978)]['isMoving']=function(){const _0x4bddd0=_0x1a8785;return Sprite_Battler[_0x4bddd0(0x978)][_0x4bddd0(0x454)][_0x4bddd0(0x716)](this);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0xa2c)]=Sprite_Enemy[_0x1a8785(0x978)][_0x1a8785(0xa9b)],Sprite_Enemy['prototype'][_0x1a8785(0xa9b)]=function(){const _0x117ad2=_0x1a8785;VisuMZ[_0x117ad2(0x83c)][_0x117ad2(0xa2c)][_0x117ad2(0x716)](this),this['updateStateSpriteBattleCore']();},Sprite_Enemy['prototype'][_0x1a8785(0x6ea)]=function(){const _0x4b2b40=_0x1a8785,_0x362fdb=VisuMZ[_0x4b2b40(0x83c)]['Settings']['Enemy'];if(_0x362fdb['NameAttachStateIcon']&&!_0x362fdb[_0x4b2b40(0x80c)]){this[_0x4b2b40(0x4dd)][_0x4b2b40(0xaeb)]=0x0;return;}this['_stateIconSprite']['x']=0x0,this[_0x4b2b40(0x4dd)]['x']+=this['_battler'][_0x4b2b40(0x1ad)](),this[_0x4b2b40(0x4dd)]['y']=-this[_0x4b2b40(0x92b)][_0x4b2b40(0x98e)]-this[_0x4b2b40(0x4dd)][_0x4b2b40(0x98e)]-0x4,this[_0x4b2b40(0x4dd)]['y']+=this[_0x4b2b40(0x8b2)]['battleUIOffsetY'](),this['_stateIconSprite'][_0x4b2b40(0x768)]['x']=0x1/(this[_0x4b2b40(0x768)]['x']||0.001),this[_0x4b2b40(0x4dd)][_0x4b2b40(0x768)]['y']=0x1/(this[_0x4b2b40(0x768)]['y']||0.001),this[_0x4b2b40(0x907)]()&&(this[_0x4b2b40(0xadf)][_0x4b2b40(0xa15)][_0x4b2b40(0x768)]['x']=-0x1/(this['scale']['x']||0.001),this[_0x4b2b40(0xadf)][_0x4b2b40(0xa15)][_0x4b2b40(0x768)]['y']=0x1/(this[_0x4b2b40(0x768)]['y']||0.001));},VisuMZ[_0x1a8785(0x83c)]['Sprite_Enemy_setBattler']=Sprite_Enemy[_0x1a8785(0x978)][_0x1a8785(0x464)],Sprite_Enemy[_0x1a8785(0x978)][_0x1a8785(0x464)]=function(_0x5aff1d){const _0x306cde=_0x1a8785;VisuMZ[_0x306cde(0x83c)]['Sprite_Enemy_setBattler'][_0x306cde(0x716)](this,_0x5aff1d),this[_0x306cde(0x493)](_0x5aff1d);},Sprite_Enemy[_0x1a8785(0x978)]['setSvBattlerSprite']=function(_0x2eaecc){const _0x8e71ae=_0x1a8785;!this[_0x8e71ae(0xadf)]&&(this[_0x8e71ae(0xadf)]=new Sprite_SvEnemy(_0x2eaecc),this['attachSpritesToDistortionSprite']()),this['_svBattlerSprite']['setBattler'](_0x2eaecc);},Sprite_Enemy[_0x1a8785(0x978)][_0x1a8785(0x907)]=function(){const _0x33e36d=_0x1a8785;return this['_enemy']&&this['_enemy'][_0x33e36d(0x907)]();},Sprite_Enemy[_0x1a8785(0x978)][_0x1a8785(0x5da)]=function(){const _0x3d2b13=_0x1a8785;return this['hasSvBattler']()?this[_0x3d2b13(0x416)][_0x3d2b13(0x5da)]():!![];},Sprite_Enemy['prototype']['refreshMotion']=function(){const _0x1771ff=_0x1a8785;this['hasSvBattler']()&&this[_0x1771ff(0xadf)][_0x1771ff(0x5ca)]();},Sprite_Enemy[_0x1a8785(0x978)][_0x1a8785(0x3fc)]=function(_0x2374ee){const _0x1ab09f=_0x1a8785;if(this[_0x1ab09f(0x907)]())this[_0x1ab09f(0xadf)]['forceMotion'](_0x2374ee);},Sprite_Enemy[_0x1a8785(0x978)][_0x1a8785(0x2f4)]=function(_0x1120d0){const _0x104d60=_0x1a8785;if(this['hasSvBattler']())this[_0x104d60(0xadf)][_0x104d60(0x2f4)](_0x1120d0);},Sprite_Enemy[_0x1a8785(0x978)][_0x1a8785(0x4b9)]=function(){const _0x529755=_0x1a8785,_0x4694cc=VisuMZ[_0x529755(0x83c)][_0x529755(0x9a7)]['ActionSequence'],_0x1fe83d=_0x4694cc['StepDistanceX'],_0x9aff75=_0x4694cc[_0x529755(0x43c)],_0x44ff80=_0x4694cc['StepDuration'];this[_0x529755(0x21c)](_0x1fe83d,_0x9aff75,_0x44ff80);};function Sprite_SvEnemy(){const _0x4ee1a3=_0x1a8785;this[_0x4ee1a3(0x3cf)](...arguments);}Sprite_SvEnemy[_0x1a8785(0x978)]=Object[_0x1a8785(0xade)](Sprite_Actor[_0x1a8785(0x978)]),Sprite_SvEnemy[_0x1a8785(0x978)][_0x1a8785(0x79d)]=Sprite_SvEnemy,Sprite_SvEnemy['prototype']['initialize']=function(_0x118615){const _0x3f1cc0=_0x1a8785;Sprite_Actor[_0x3f1cc0(0x978)]['initialize'][_0x3f1cc0(0x716)](this,_0x118615),this[_0x3f1cc0(0x768)]['x']=-0x1,this[_0x3f1cc0(0xa15)]['scale']['x']=-0x1;},Sprite_SvEnemy[_0x1a8785(0x978)]['createShadowSprite']=function(){},Sprite_SvEnemy['prototype'][_0x1a8785(0x203)]=function(){},Sprite_SvEnemy['prototype'][_0x1a8785(0x9b7)]=function(_0x11d2c2){},Sprite_SvEnemy[_0x1a8785(0x978)][_0x1a8785(0x793)]=function(){},Sprite_SvEnemy[_0x1a8785(0x978)]['updateShadowPosition']=function(){},Sprite_SvEnemy[_0x1a8785(0x978)][_0x1a8785(0xa9b)]=function(){const _0x32c066=_0x1a8785;this[_0x32c066(0xa15)][_0x32c066(0xac3)]=![];},Sprite_SvEnemy[_0x1a8785(0x978)][_0x1a8785(0x781)]=function(){const _0x1acdd4=_0x1a8785;Sprite_Battler[_0x1acdd4(0x978)]['updateBitmap'][_0x1acdd4(0x716)](this);const _0x45114c=this['_actor'][_0x1acdd4(0x43d)]();this[_0x1acdd4(0x7b5)]!==_0x45114c&&(this[_0x1acdd4(0x7b5)]=_0x45114c,this[_0x1acdd4(0x91b)][_0x1acdd4(0x92b)]=ImageManager[_0x1acdd4(0x315)](_0x45114c)),this[_0x1acdd4(0x91b)]&&this['_mainSprite']['bitmap']&&this[_0x1acdd4(0x8b2)]&&(this['_mainSprite'][_0x1acdd4(0x92b)][_0x1acdd4(0x66c)]!==this[_0x1acdd4(0x8b2)][_0x1acdd4(0x484)]()&&(this[_0x1acdd4(0x91b)][_0x1acdd4(0x92b)][_0x1acdd4(0x66c)]=this[_0x1acdd4(0x8b2)][_0x1acdd4(0x484)]()));},Sprite_SvEnemy[_0x1a8785(0x978)]['retreat']=function(){},Sprite_SvEnemy[_0x1a8785(0x978)][_0x1a8785(0x21c)]=function(_0x417b0d,_0x3df50a,_0x2b0721){const _0x18cbea=_0x1a8785;if(this[_0x18cbea(0x45c)])this[_0x18cbea(0x45c)][_0x18cbea(0x21c)](_0x417b0d,_0x3df50a,_0x2b0721);},Sprite_SvEnemy[_0x1a8785(0x978)]['refreshMotion']=function(){const _0x3b1ba9=_0x1a8785,_0x4b58e9=this['_actor'];if(_0x4b58e9){const _0x562214=_0x4b58e9[_0x3b1ba9(0x8c6)]();if(_0x4b58e9[_0x3b1ba9(0x99f)]()||_0x4b58e9['isActing']())this[_0x3b1ba9(0x1f7)](_0x3b1ba9(0x543));else{if(_0x562214===0x3)this['startMotion'](_0x3b1ba9(0x51c));else{if(_0x562214===0x2)this[_0x3b1ba9(0x1f7)](_0x3b1ba9(0x7f6));else{if(_0x4b58e9[_0x3b1ba9(0x259)]())this['startMotion'](_0x3b1ba9(0x4e8));else{if(_0x4b58e9[_0x3b1ba9(0xae0)]()||_0x4b58e9[_0x3b1ba9(0xa57)]())this[_0x3b1ba9(0x1f7)](_0x3b1ba9(0x237));else{if(_0x562214===0x1)this[_0x3b1ba9(0x1f7)]('abnormal');else{if(_0x4b58e9[_0x3b1ba9(0x414)]())this[_0x3b1ba9(0x1f7)](_0x3b1ba9(0x18f));else _0x4b58e9[_0x3b1ba9(0x3a9)]()?this['startMotion'](_0x3b1ba9(0x543)):this[_0x3b1ba9(0x1f7)](_0x4b58e9['svBattlerData']()[_0x3b1ba9(0x74a)]||_0x3b1ba9(0x543));}}}}}}}},Sprite_SvEnemy[_0x1a8785(0x978)][_0x1a8785(0x982)]=function(){const _0x62bac8=_0x1a8785;return this[_0x62bac8(0x45c)]?this[_0x62bac8(0x45c)][_0x62bac8(0x28a)]===0x0&&this['parent'][_0x62bac8(0x44d)]===0x0:!![];},Sprite_SvEnemy['prototype'][_0x1a8785(0x971)]=function(){},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x35c)]=Sprite_Animation[_0x1a8785(0x978)][_0x1a8785(0x744)],Sprite_Animation[_0x1a8785(0x978)]['targetSpritePosition']=function(_0x1e504f){const _0x52f68a=_0x1a8785;return _0x1e504f[_0x52f68a(0x194)]?this[_0x52f68a(0x3d8)](_0x1e504f):VisuMZ['BattleCore']['Sprite_Animation_targetSpritePosition']['call'](this,_0x1e504f);},Sprite_Animation[_0x1a8785(0x978)][_0x1a8785(0x3d8)]=function(_0x4f4ed8){const _0x457943=_0x1a8785;let _0x1d8be2=_0x4f4ed8['x'],_0x1280a0=_0x4f4ed8['y'],_0x4c5372=_0x4f4ed8[_0x457943(0x98e)],_0x45e84f=_0x4f4ed8[_0x457943(0x194)][_0x457943(0x768)]['y'];_0x4f4ed8['x']=_0x4f4ed8[_0x457943(0x6c5)]+_0x4f4ed8[_0x457943(0x619)](),_0x4f4ed8['y']=_0x4f4ed8[_0x457943(0x236)]+_0x4f4ed8[_0x457943(0x587)](),_0x4f4ed8[_0x457943(0x98e)]*=_0x45e84f;let _0x34cdec=VisuMZ['BattleCore'][_0x457943(0x35c)][_0x457943(0x716)](this,_0x4f4ed8);return _0x4f4ed8['x']=_0x1d8be2,_0x4f4ed8['y']=_0x1280a0,_0x4f4ed8[_0x457943(0x98e)]=_0x4c5372,_0x34cdec;},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x29b)]=Sprite_AnimationMV[_0x1a8785(0x978)]['updatePosition'],Sprite_AnimationMV[_0x1a8785(0x978)][_0x1a8785(0x412)]=function(){const _0x482894=_0x1a8785;VisuMZ[_0x482894(0x83c)][_0x482894(0x29b)][_0x482894(0x716)](this);if(!SceneManager[_0x482894(0x3a8)]())return;if(this[_0x482894(0x9af)][_0x482894(0x184)]===0x3)this['x']=Math[_0x482894(0x86d)](Graphics[_0x482894(0x9ab)]/0x2),this['y']=Math[_0x482894(0x86d)](Graphics[_0x482894(0x69d)]/0x2);else{if(this['battleStatusSprite'])return;}},Sprite_Damage[_0x1a8785(0x978)]['setupBattleCore']=function(_0x1b67d2){const _0x5b6373=_0x1a8785,_0x56ba99=_0x1b67d2[_0x5b6373(0x32f)]()||_0x1b67d2[_0x5b6373(0x97a)]();if(_0x56ba99[_0x5b6373(0x6ee)]||_0x56ba99[_0x5b6373(0xb03)])this['_colorType']=0x0,this[_0x5b6373(0x532)]();else{if(_0x56ba99['hpAffected'])this[_0x5b6373(0x6fc)]=_0x56ba99[_0x5b6373(0x981)]>=0x0?0x0:0x1,this[_0x5b6373(0x301)](_0x56ba99[_0x5b6373(0x981)]);else _0x1b67d2[_0x5b6373(0x919)]()&&_0x56ba99[_0x5b6373(0x3ed)]!==0x0&&(this[_0x5b6373(0x6fc)]=_0x56ba99[_0x5b6373(0x3ed)]>=0x0?0x2:0x3,this['createDigits'](_0x56ba99[_0x5b6373(0x3ed)]));}_0x56ba99[_0x5b6373(0x9fe)]&&this[_0x5b6373(0x975)]();},Sprite_Damage[_0x1a8785(0x978)][_0x1a8785(0x352)]=function(_0xa9337f){},Sprite_Damage[_0x1a8785(0x978)][_0x1a8785(0x301)]=function(_0x27c114){const _0x5e00cb=_0x1a8785;let _0x23a75d=this[_0x5e00cb(0x854)](_0x27c114);const _0x508b11=this[_0x5e00cb(0x34e)](),_0x228218=Math[_0x5e00cb(0x4a7)](_0x508b11*0.75);for(let _0x1f74cf=0x0;_0x1f74cf<_0x23a75d[_0x5e00cb(0x2dc)];_0x1f74cf++){const _0x1317e1=this[_0x5e00cb(0x372)](_0x228218,_0x508b11);_0x1317e1['bitmap'][_0x5e00cb(0x6bc)](_0x23a75d[_0x1f74cf],0x0,0x0,_0x228218,_0x508b11,_0x5e00cb(0x745)),_0x1317e1['x']=(_0x1f74cf-(_0x23a75d['length']-0x1)/0x2)*_0x228218,_0x1317e1['dy']=-_0x1f74cf;}},Sprite_Damage[_0x1a8785(0x978)][_0x1a8785(0x854)]=function(_0x29c64e){const _0x4dcfc2=_0x1a8785;let _0xfe2bc5=Math[_0x4dcfc2(0x73f)](_0x29c64e)['toString']();this[_0x4dcfc2(0x6ff)]()&&(_0xfe2bc5=VisuMZ[_0x4dcfc2(0x291)](_0xfe2bc5));const _0x27fa05=VisuMZ[_0x4dcfc2(0x83c)][_0x4dcfc2(0x9a7)][_0x4dcfc2(0xa19)];let _0x578e7a='',_0x4dfc12='';switch(this[_0x4dcfc2(0x6fc)]){case 0x0:_0x578e7a=_0x27fa05['hpDamageFmt']||_0x4dcfc2(0x4b6),_0x4dfc12=TextManager['hp'];if(_0x29c64e===0x0)_0x578e7a='%1';break;case 0x1:_0x578e7a=_0x27fa05['hpHealingFmt']||_0x4dcfc2(0x230),_0x4dfc12=TextManager['hp'];break;case 0x2:_0x578e7a=_0x27fa05[_0x4dcfc2(0x431)]||_0x4dcfc2(0x1a2),_0x4dfc12=TextManager['mp'];break;case 0x3:_0x578e7a=_0x27fa05[_0x4dcfc2(0x8a2)]||_0x4dcfc2(0x277),_0x4dfc12=TextManager['mp'];break;}return _0x578e7a[_0x4dcfc2(0x22f)](_0xfe2bc5,_0x4dfc12)[_0x4dcfc2(0x6b6)]();},Sprite_Damage[_0x1a8785(0x978)][_0x1a8785(0x6ff)]=function(){const _0x3fe7be=_0x1a8785;return Imported[_0x3fe7be(0x211)]?VisuMZ[_0x3fe7be(0x266)]['Settings'][_0x3fe7be(0x75c)][_0x3fe7be(0x578)]:![];},Sprite_Damage['prototype']['setupCriticalEffect']=function(){const _0x1e869c=_0x1a8785,_0x23370d=VisuMZ[_0x1e869c(0x83c)][_0x1e869c(0x9a7)][_0x1e869c(0xa19)];this[_0x1e869c(0x841)]=_0x23370d[_0x1e869c(0x6d7)][_0x1e869c(0xa53)](0x0),this[_0x1e869c(0x3dd)]=_0x23370d[_0x1e869c(0x6f2)];},Sprite_Damage[_0x1a8785(0x978)][_0x1a8785(0x7ec)]=function(_0x5aa024,_0x32dcd5){const _0x11f807=_0x1a8785;this[_0x11f807(0x841)]=_0x32dcd5['flashColor']||[0x0,0x0,0x0,0x0],this['_flashColor']=JsonEx[_0x11f807(0x950)](this['_flashColor']),this[_0x11f807(0x3dd)]=_0x32dcd5[_0x11f807(0x29e)]||0x0;const _0x4ee7a2=this['fontSize'](),_0x434431=Math[_0x11f807(0x4a7)](_0x4ee7a2*0x1e),_0x55e59a=this[_0x11f807(0x372)](_0x434431,_0x4ee7a2);_0x55e59a[_0x11f807(0x92b)][_0x11f807(0xaff)]=ColorManager[_0x11f807(0x31e)](_0x32dcd5[_0x11f807(0xaff)]),_0x55e59a[_0x11f807(0x92b)][_0x11f807(0x6bc)](_0x5aa024,0x0,0x0,_0x434431,_0x4ee7a2,_0x11f807(0x745)),_0x55e59a['dy']=0x0;},Sprite_Damage[_0x1a8785(0x978)][_0x1a8785(0x1c3)]=function(_0x11d5ca,_0x38dc40,_0x437acb){const _0xee2dcb=_0x1a8785,_0x433358=Math['max'](this[_0xee2dcb(0x34e)](),ImageManager['iconHeight']),_0x4e97b7=Math[_0xee2dcb(0x4a7)](_0x433358*0x1e),_0x18cfc8=this['createChildSprite'](_0x4e97b7,_0x433358),_0x28d627=ImageManager[_0xee2dcb(0x84c)]/0x2,_0x592399=_0x18cfc8[_0xee2dcb(0x92b)][_0xee2dcb(0x7e7)](_0x38dc40+'\x20');_0x18cfc8[_0xee2dcb(0x92b)][_0xee2dcb(0xaff)]=ColorManager[_0xee2dcb(0x31e)](_0x437acb['textColor']),_0x18cfc8['bitmap'][_0xee2dcb(0x6bc)](_0x38dc40,_0x28d627,0x0,_0x4e97b7-_0x28d627,_0x433358,_0xee2dcb(0x745));const _0x74cd63=Math[_0xee2dcb(0x86d)]((_0x433358-ImageManager[_0xee2dcb(0xa4c)])/0x2),_0x5e81df=_0x4e97b7/0x2-ImageManager[_0xee2dcb(0x84c)]-_0x592399/0x2+_0x28d627/0x2,_0x405c22=ImageManager['loadSystem'](_0xee2dcb(0x5e9)),_0xad67c3=ImageManager['iconWidth'],_0xf32a7d=ImageManager[_0xee2dcb(0xa4c)],_0x4853ac=_0x11d5ca%0x10*_0xad67c3,_0x265de4=Math[_0xee2dcb(0x4a7)](_0x11d5ca/0x10)*_0xf32a7d;_0x18cfc8['bitmap']['blt'](_0x405c22,_0x4853ac,_0x265de4,_0xad67c3,_0xf32a7d,_0x5e81df,_0x74cd63),this[_0xee2dcb(0x841)]=_0x437acb[_0xee2dcb(0x940)]||[0x0,0x0,0x0,0x0],this[_0xee2dcb(0x841)]=JsonEx[_0xee2dcb(0x950)](this[_0xee2dcb(0x841)]),this[_0xee2dcb(0x3dd)]=_0x437acb[_0xee2dcb(0x29e)]||0x0,_0x18cfc8['dy']=0x0;},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x913)]=Sprite_Damage[_0x1a8785(0x978)]['createChildSprite'],Sprite_Damage[_0x1a8785(0x978)][_0x1a8785(0x372)]=function(_0x9eef66,_0x395c70){const _0x39c95c=_0x1a8785;return _0x395c70=Math[_0x39c95c(0x86d)](_0x395c70*1.2),VisuMZ['BattleCore'][_0x39c95c(0x913)][_0x39c95c(0x716)](this,_0x9eef66,_0x395c70);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x2a3)]=Sprite_StateIcon[_0x1a8785(0x978)]['updateFrame'],Sprite_StateIcon[_0x1a8785(0x978)][_0x1a8785(0x6f9)]=function(){const _0x497a5d=_0x1a8785;VisuMZ[_0x497a5d(0x83c)]['Sprite_StateIcon_updateFrame'][_0x497a5d(0x716)](this),this['opacity']=this['_iconIndex']>0x0?0xff:0x0;},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x9ce)]=Sprite_Weapon[_0x1a8785(0x978)]['loadBitmap'],Sprite_Weapon[_0x1a8785(0x978)][_0x1a8785(0xa0d)]=function(){const _0x11a8dd=_0x1a8785;VisuMZ[_0x11a8dd(0x83c)][_0x11a8dd(0x9ce)]['call'](this),this[_0x11a8dd(0x92b)]&&(this['bitmap'][_0x11a8dd(0x66c)]=VisuMZ[_0x11a8dd(0x83c)][_0x11a8dd(0x9a7)]['Actor'][_0x11a8dd(0x1e2)]);},VisuMZ['BattleCore'][_0x1a8785(0x506)]=Sprite_Gauge['prototype'][_0x1a8785(0xaf2)],Sprite_Gauge[_0x1a8785(0x978)]['smoothness']=function(){const _0x4c0f4f=_0x1a8785;return this['_statusType']!=='time'?VisuMZ[_0x4c0f4f(0x83c)]['Settings'][_0x4c0f4f(0x9d0)][_0x4c0f4f(0x1ec)]??0x14:VisuMZ['BattleCore']['Sprite_Gauge_smoothness'][_0x4c0f4f(0x716)](this);};function Sprite_HpGauge(){const _0x1cff02=_0x1a8785;this[_0x1cff02(0x3cf)](...arguments);}Sprite_HpGauge['prototype']=Object[_0x1a8785(0xade)](Sprite_Gauge['prototype']),Sprite_HpGauge[_0x1a8785(0x978)][_0x1a8785(0x79d)]=Sprite_HpGauge,Sprite_HpGauge['prototype'][_0x1a8785(0x3cf)]=function(){const _0xb43254=_0x1a8785;Sprite_Gauge[_0xb43254(0x978)][_0xb43254(0x3cf)][_0xb43254(0x716)](this);},Sprite_HpGauge[_0x1a8785(0x978)][_0x1a8785(0x354)]=function(){return 0x0;},Sprite_HpGauge[_0x1a8785(0x978)][_0x1a8785(0x764)]=function(){const _0x4f2f4f=_0x1a8785;this[_0x4f2f4f(0x92b)]['clear']();const _0x30ab6c=this[_0x4f2f4f(0x34a)]();!isNaN(_0x30ab6c)&&this['drawGauge']();};function Sprite_EnemyName(){const _0x54142b=_0x1a8785;this[_0x54142b(0x3cf)](...arguments);}Sprite_EnemyName[_0x1a8785(0x978)]=Object['create'](Sprite_Name[_0x1a8785(0x978)]),Sprite_EnemyName[_0x1a8785(0x978)][_0x1a8785(0x79d)]=Sprite_EnemyName,Sprite_EnemyName[_0x1a8785(0x978)][_0x1a8785(0x3cf)]=function(){const _0x5540ab=_0x1a8785;Sprite_Name[_0x5540ab(0x978)][_0x5540ab(0x3cf)]['call'](this),this['createAttachedSprites']();},Sprite_EnemyName[_0x1a8785(0x978)][_0x1a8785(0x9a3)]=function(){const _0xbbd1ec=_0x1a8785;Sprite_Name[_0xbbd1ec(0x978)][_0xbbd1ec(0x9a3)][_0xbbd1ec(0x716)](this),this['opacity']=0x0,this['_linkedSprite']=null,this[_0xbbd1ec(0x7b1)]['x']=0.5,this['anchor']['y']=0x0;},Sprite_EnemyName[_0x1a8785(0x978)][_0x1a8785(0x182)]=function(){const _0x7654e5=_0x1a8785;VisuMZ['BattleCore'][_0x7654e5(0x9a7)]['Enemy']['NameAttachStateIcon']&&(this['_stateIconSprite']=new Sprite_StateIcon(),this[_0x7654e5(0xaba)](this[_0x7654e5(0x4dd)]));},Sprite_EnemyName[_0x1a8785(0x978)]['bitmapWidth']=function(){const _0x4b81bc=_0x1a8785;return Graphics[_0x4b81bc(0x9ab)];},Sprite_EnemyName[_0x1a8785(0x978)][_0x1a8785(0x9e3)]=function(){const _0x5699bc=_0x1a8785;return this['_lineHeight']=this[_0x5699bc(0x7a8)]||Window_Base['prototype'][_0x5699bc(0x736)]()||0x24,this[_0x5699bc(0x7a8)]*0x4;},Sprite_EnemyName['prototype']['fontSize']=function(){const _0x30407a=_0x1a8785;return VisuMZ[_0x30407a(0x83c)]['Settings'][_0x30407a(0x199)]['NameFontSize']||$gameSystem[_0x30407a(0x6b5)]();},Sprite_EnemyName[_0x1a8785(0x978)]['linkSprite']=function(_0x977417){const _0x48f4ab=_0x1a8785;this[_0x48f4ab(0x3ce)]=_0x977417;},Sprite_EnemyName[_0x1a8785(0x978)]['update']=function(){const _0x406933=_0x1a8785;Sprite_Name[_0x406933(0x978)]['update'][_0x406933(0x716)](this),this['updateLink'](),this[_0x406933(0x412)](),this['updateAttachedSprites'](),this[_0x406933(0xb01)]();},Sprite_EnemyName[_0x1a8785(0x978)][_0x1a8785(0x764)]=function(){const _0x4ba92d=_0x1a8785;this['_cacheTextWidth']=undefined;const _0x26fe41=this[_0x4ba92d(0x1f2)](),_0x301985=this[_0x4ba92d(0x710)](),_0x2e2f0b=Window_Base[_0x4ba92d(0x978)][_0x4ba92d(0x736)]();this[_0x4ba92d(0x873)](),this['bitmap'][_0x4ba92d(0x1fb)](),this[_0x4ba92d(0x92b)][_0x4ba92d(0x6bc)](_0x26fe41,0x0,0x0,_0x301985,_0x2e2f0b,'center');},Sprite_EnemyName[_0x1a8785(0x978)][_0x1a8785(0x2dd)]=function(){const _0x41757e=_0x1a8785;if(!this[_0x41757e(0x3ce)])return;this['_battler']!==this['_linkedSprite']['_battler']&&this[_0x41757e(0x352)](this[_0x41757e(0x3ce)][_0x41757e(0x8b2)]);},Sprite_EnemyName['prototype'][_0x1a8785(0x412)]=function(){const _0x3d17e4=_0x1a8785;if(!this[_0x3d17e4(0x3ce)])return;this[_0x3d17e4(0x7a8)]=this[_0x3d17e4(0x7a8)]||Window_Base[_0x3d17e4(0x978)][_0x3d17e4(0x736)](),this['x']=Math[_0x3d17e4(0x86d)](this[_0x3d17e4(0x3ce)][_0x3d17e4(0x6c5)]),this['y']=Math[_0x3d17e4(0x86d)](this['_linkedSprite'][_0x3d17e4(0x236)]-this['_lineHeight']*0.5);const _0x2e5903=VisuMZ[_0x3d17e4(0x83c)]['Settings'][_0x3d17e4(0x199)];this['x']+=Math['round'](_0x2e5903[_0x3d17e4(0x9df)]||0x0),this['y']+=Math['round'](_0x2e5903[_0x3d17e4(0x787)]||0x0);},Sprite_EnemyName[_0x1a8785(0x978)][_0x1a8785(0x89c)]=function(){const _0x315ecb=_0x1a8785;this[_0x315ecb(0x2ef)]();},Sprite_EnemyName[_0x1a8785(0x978)][_0x1a8785(0x2ef)]=function(){const _0x402819=_0x1a8785;if(!this['_stateIconSprite'])return;this[_0x402819(0x8b2)]!==this[_0x402819(0x4dd)][_0x402819(0x8b2)]&&this[_0x402819(0x4dd)][_0x402819(0x352)](this['_battler']);const _0x3c531d=this[_0x402819(0x804)]();this['_lineHeight']=this['_lineHeight']||Window_Base[_0x402819(0x978)][_0x402819(0x736)](),this['_stateIconSprite']['x']=Math[_0x402819(0x86d)]((_0x3c531d+ImageManager[_0x402819(0x84c)])/0x2)+0x8,this[_0x402819(0x4dd)]['y']=this['_lineHeight']/0x2;const _0x598240=VisuMZ['BattleCore']['Settings'][_0x402819(0x199)];this['_stateIconSprite']['x']+=_0x598240[_0x402819(0x1ea)]||0x0,this[_0x402819(0x4dd)]['y']+=_0x598240['AttachStateOffsetY']||0x0;},Sprite_EnemyName[_0x1a8785(0x978)][_0x1a8785(0xb01)]=function(){const _0x194c75=_0x1a8785,_0x3dc31=this[_0x194c75(0xb0a)]();if(_0x3dc31&&this[_0x194c75(0xaeb)]<0xff)this[_0x194c75(0xaeb)]+=0x10;else!_0x3dc31&&this[_0x194c75(0xaeb)]>0x0&&(this[_0x194c75(0xaeb)]-=0x10);},Sprite_EnemyName[_0x1a8785(0x978)][_0x1a8785(0xb0a)]=function(){const _0x3bc037=_0x1a8785;if(this[_0x3bc037(0x2cd)]())return![];else{if(!this[_0x3bc037(0x8b2)])return![];else{if(this['_battler']['isDead']())return![];else{if(!this[_0x3bc037(0x8b2)][_0x3bc037(0x46d)]())return![];else{if(this['compatibilityVisible']())return!![];else{if(this['isAlwaysVisible']())return!![];else{if(this[_0x3bc037(0x311)]())return!![];else{if(this[_0x3bc037(0xaeb)]>0x0)return![];}}}}}}}},Sprite_EnemyName[_0x1a8785(0x978)][_0x1a8785(0x2cd)]=function(){const _0x31a60d=_0x1a8785;return VisuMZ[_0x31a60d(0x83c)][_0x31a60d(0x9a7)][_0x31a60d(0x199)][_0x31a60d(0x79f)];},Sprite_EnemyName[_0x1a8785(0x978)][_0x1a8785(0x784)]=function(){return![];},Sprite_EnemyName[_0x1a8785(0x978)][_0x1a8785(0x27e)]=function(){const _0x5e8871=_0x1a8785;return VisuMZ[_0x5e8871(0x83c)]['Settings'][_0x5e8871(0x199)][_0x5e8871(0x5ec)];},Sprite_EnemyName[_0x1a8785(0x978)]['isIncludedInEnemyWindow']=function(){const _0x56b319=_0x1a8785;return VisuMZ[_0x56b319(0x83c)]['Settings']['Enemy'][_0x56b319(0x6d0)]?this['_battler']['isSelected']():SceneManager[_0x56b319(0xa42)][_0x56b319(0xadc)]&&SceneManager[_0x56b319(0xa42)][_0x56b319(0xadc)][_0x56b319(0x741)]&&SceneManager[_0x56b319(0xa42)][_0x56b319(0xadc)][_0x56b319(0x51e)]['includes'](this[_0x56b319(0x8b2)]);},Sprite_EnemyName[_0x1a8785(0x978)][_0x1a8785(0x804)]=function(){const _0x561e9f=_0x1a8785;if(!this['_battler'])return 0x0;if(this[_0x561e9f(0x827)])return this[_0x561e9f(0x827)];const _0x34abac=this['name']();return this[_0x561e9f(0x873)](),this['_cacheTextWidth']=this[_0x561e9f(0x92b)][_0x561e9f(0x7e7)](_0x34abac)||0x1,this[_0x561e9f(0x827)];},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x4c0)]=Sprite_Battleback[_0x1a8785(0x978)][_0x1a8785(0x497)],Sprite_Battleback[_0x1a8785(0x978)][_0x1a8785(0x497)]=function(){const _0x14b0a1=_0x1a8785,_0x2aa726=VisuMZ[_0x14b0a1(0x83c)][_0x14b0a1(0x9a7)][_0x14b0a1(0x9b6)];if(!_0x2aa726)return VisuMZ[_0x14b0a1(0x83c)]['Sprite_Battleback_adjustPosition'][_0x14b0a1(0x716)](this);const _0x1a3341=String(_0x2aa726['DefaultStyle'])||'MZ';switch(_0x1a3341){case'MZ':VisuMZ[_0x14b0a1(0x83c)]['Sprite_Battleback_adjustPosition']['call'](this);break;case _0x14b0a1(0x883):this[_0x14b0a1(0x544)]();break;case _0x14b0a1(0x529):this[_0x14b0a1(0x435)]();break;case _0x14b0a1(0x3f2):this[_0x14b0a1(0x899)]();break;case _0x14b0a1(0x808):this[_0x14b0a1(0x4e9)]();break;}},Sprite_Battleback[_0x1a8785(0x978)][_0x1a8785(0x544)]=function(){const _0x585b3e=_0x1a8785,_0x20baf9=VisuMZ[_0x585b3e(0x83c)][_0x585b3e(0x9a7)][_0x585b3e(0x9b6)];if(_0x20baf9&&_0x20baf9[_0x585b3e(0x653)])return _0x20baf9[_0x585b3e(0x653)]['call'](this);this[_0x585b3e(0x92d)]=Graphics['width'],this[_0x585b3e(0x98e)]=Graphics[_0x585b3e(0x98e)];const _0x17cb61=0x1;this[_0x585b3e(0x768)]['x']=_0x17cb61,this[_0x585b3e(0x768)]['y']=_0x17cb61,this['x']=0x0,this['y']=0x0;},Sprite_Battleback[_0x1a8785(0x978)]['adjustPosition_ScaleToFit']=function(){const _0x1f6711=_0x1a8785,_0x43070e=VisuMZ['BattleCore'][_0x1f6711(0x9a7)]['BattlebackScale'];if(_0x43070e&&_0x43070e['jsScaleToFit'])return _0x43070e[_0x1f6711(0x38e)][_0x1f6711(0x716)](this);this[_0x1f6711(0x92d)]=Graphics['width'],this[_0x1f6711(0x98e)]=Graphics[_0x1f6711(0x98e)];const _0x695f0=this['width']/this[_0x1f6711(0x92b)][_0x1f6711(0x92d)],_0x477376=this[_0x1f6711(0x98e)]/this[_0x1f6711(0x92b)][_0x1f6711(0x98e)],_0x11c5d3=Math[_0x1f6711(0x5a7)](_0x695f0,_0x477376);this[_0x1f6711(0x768)]['x']=_0x11c5d3,this['scale']['y']=_0x11c5d3,this['x']=(Graphics[_0x1f6711(0x92d)]-this[_0x1f6711(0x92d)])/0x2,this['y']=Graphics[_0x1f6711(0x98e)]-this[_0x1f6711(0x98e)];},Sprite_Battleback[_0x1a8785(0x978)]['adjustPosition_ScaleDown']=function(){const _0x40cfe1=_0x1a8785,_0x58b13f=VisuMZ['BattleCore'][_0x40cfe1(0x9a7)][_0x40cfe1(0x9b6)];if(_0x58b13f&&_0x58b13f[_0x40cfe1(0x7e1)])return _0x58b13f[_0x40cfe1(0x7e1)][_0x40cfe1(0x716)](this);this['width']=Graphics['width'],this[_0x40cfe1(0x98e)]=Graphics[_0x40cfe1(0x98e)];const _0x29359e=Math[_0x40cfe1(0xae7)](0x1,this[_0x40cfe1(0x92d)]/this[_0x40cfe1(0x92b)][_0x40cfe1(0x92d)]),_0x1a0f95=Math[_0x40cfe1(0xae7)](0x1,this[_0x40cfe1(0x98e)]/this[_0x40cfe1(0x92b)][_0x40cfe1(0x98e)]),_0x57c819=Math['max'](_0x29359e,_0x1a0f95);this[_0x40cfe1(0x768)]['x']=_0x57c819,this[_0x40cfe1(0x768)]['y']=_0x57c819,this['x']=(Graphics[_0x40cfe1(0x92d)]-this[_0x40cfe1(0x92d)])/0x2,this['y']=Graphics[_0x40cfe1(0x98e)]-this['height'];},Sprite_Battleback[_0x1a8785(0x978)][_0x1a8785(0x4e9)]=function(){const _0xf633be=_0x1a8785,_0x4762b4=VisuMZ[_0xf633be(0x83c)][_0xf633be(0x9a7)][_0xf633be(0x9b6)];if(_0x4762b4&&_0x4762b4['jsScaleUp'])return _0x4762b4[_0xf633be(0x24d)][_0xf633be(0x716)](this);this['width']=Graphics['width'],this[_0xf633be(0x98e)]=Graphics[_0xf633be(0x98e)];const _0x45d0b7=Math[_0xf633be(0x5a7)](0x1,this[_0xf633be(0x92d)]/this['bitmap'][_0xf633be(0x92d)]),_0x2d8423=Math['max'](0x1,this[_0xf633be(0x98e)]/this['bitmap'][_0xf633be(0x98e)]),_0x12c00a=Math['max'](_0x45d0b7,_0x2d8423);this[_0xf633be(0x768)]['x']=_0x12c00a,this[_0xf633be(0x768)]['y']=_0x12c00a,this['x']=(Graphics[_0xf633be(0x92d)]-this['width'])/0x2,this['y']=Graphics[_0xf633be(0x98e)]-this[_0xf633be(0x98e)];},Spriteset_Battle[_0x1a8785(0x83d)]=![],Spriteset_Battle[_0x1a8785(0x978)][_0x1a8785(0x401)]=function(){const _0x45b924=_0x1a8785;if(!$gameSystem[_0x45b924(0x973)]())return![];return![];},Spriteset_Battle[_0x1a8785(0x978)][_0x1a8785(0xa13)]=function(){return 0x0;},Spriteset_Battle[_0x1a8785(0x978)]['animationNextDelay']=function(){return 0x0;},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x51f)]=Spriteset_Battle['prototype'][_0x1a8785(0x85f)],Spriteset_Battle[_0x1a8785(0x978)][_0x1a8785(0x85f)]=function(){const _0x3ca12d=_0x1a8785;VisuMZ['BattleCore'][_0x3ca12d(0x51f)][_0x3ca12d(0x716)](this),this[_0x3ca12d(0x448)](),this[_0x3ca12d(0x4d3)]();},VisuMZ['BattleCore'][_0x1a8785(0x42e)]=Spriteset_Battle[_0x1a8785(0x978)][_0x1a8785(0x31a)],Spriteset_Battle[_0x1a8785(0x978)][_0x1a8785(0x31a)]=function(){const _0x44fb67=_0x1a8785;VisuMZ[_0x44fb67(0x83c)][_0x44fb67(0x42e)][_0x44fb67(0x716)](this),this[_0x44fb67(0x1a1)](),this[_0x44fb67(0x42b)](),this[_0x44fb67(0xadd)]();},Spriteset_Battle[_0x1a8785(0x978)][_0x1a8785(0x448)]=function(){const _0x2102bf=_0x1a8785;this[_0x2102bf(0x935)]=new Weather(),this[_0x2102bf(0x7ab)][_0x2102bf(0xaba)](this[_0x2102bf(0x935)]);},Spriteset_Battle[_0x1a8785(0x978)][_0x1a8785(0xadd)]=function(){const _0x279842=_0x1a8785;this[_0x279842(0x935)][_0x279842(0x888)]=$gameScreen['weatherType'](),this[_0x279842(0x935)][_0x279842(0x4ab)]=$gameScreen[_0x279842(0x1cd)]();},Game_Interpreter[_0x1a8785(0x978)][_0x1a8785(0x896)]=function(_0x470573){const _0x11fd31=_0x1a8785;$gameScreen[_0x11fd31(0x256)](_0x470573[0x0],_0x470573[0x1],_0x470573[0x2]);if(_0x470573[0x3])this[_0x11fd31(0x7c9)](_0x470573[0x2]);return!![];},VisuMZ[_0x1a8785(0x83c)]['Game_Interpreter_command283']=Game_Interpreter[_0x1a8785(0x978)][_0x1a8785(0x71f)],Game_Interpreter[_0x1a8785(0x978)][_0x1a8785(0x71f)]=function(_0x4474f6){const _0x2f99e3=_0x1a8785;return SceneManager[_0x2f99e3(0x3a8)]()?(SceneManager['_scene'][_0x2f99e3(0x589)][_0x2f99e3(0x357)](_0x4474f6[0x0],_0x4474f6[0x1]),!![]):VisuMZ['BattleCore'][_0x2f99e3(0x53f)][_0x2f99e3(0x716)](this,_0x4474f6);},Spriteset_Battle[_0x1a8785(0x978)][_0x1a8785(0x60b)]=function(_0x2749f7,_0x1f4424){_0x2749f7['bitmap']=_0x1f4424;},Spriteset_Battle[_0x1a8785(0x978)][_0x1a8785(0x357)]=function(_0x208548,_0x5a82f5){const _0x23c3a7=_0x1a8785;_0x208548=_0x208548||'',_0x5a82f5=_0x5a82f5||'';_0x208548===''&&_0x5a82f5===''&&(_0x208548=this[_0x23c3a7(0x2de)][_0x23c3a7(0x515)](),_0x5a82f5=this[_0x23c3a7(0x8cd)][_0x23c3a7(0x72c)]());const _0x7d0782=ImageManager['loadBattleback1'](_0x208548),_0x320d90=ImageManager['loadBattleback2'](_0x5a82f5);_0x7d0782[_0x23c3a7(0x9f9)](this[_0x23c3a7(0x333)][_0x23c3a7(0x6e7)](this,this[_0x23c3a7(0x2de)],this[_0x23c3a7(0x8cd)],_0x7d0782,_0x320d90));},Spriteset_Battle[_0x1a8785(0x978)][_0x1a8785(0x333)]=function(_0x21637c,_0xf60264,_0x5ef271,_0xed5b89){const _0x3e57f8=_0x1a8785;_0xed5b89[_0x3e57f8(0x9f9)](this[_0x3e57f8(0x1b7)][_0x3e57f8(0x6e7)](this,_0x21637c,_0xf60264,_0x5ef271,_0xed5b89));},Spriteset_Battle[_0x1a8785(0x978)][_0x1a8785(0x1b7)]=function(_0x539129,_0x3df2c5,_0x2292a4,_0x34c4c8){const _0x2db199=_0x1a8785;_0x539129[_0x2db199(0x92b)]=_0x2292a4,_0x3df2c5[_0x2db199(0x92b)]=_0x34c4c8,_0x539129[_0x2db199(0x497)](),_0x3df2c5['adjustPosition']();},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x46e)]=Spriteset_Battle['prototype'][_0x1a8785(0xabf)],Spriteset_Battle[_0x1a8785(0x978)][_0x1a8785(0xabf)]=function(){const _0x57b3d4=_0x1a8785;VisuMZ[_0x57b3d4(0x83c)]['Spriteset_Battle_createBattleField'][_0x57b3d4(0x716)](this),this[_0x57b3d4(0x4a9)]();},Spriteset_Battle[_0x1a8785(0x978)][_0x1a8785(0x4a9)]=function(){const _0x4cd775=_0x1a8785;this[_0x4cd775(0x59d)](),this['createUIContainer'](),this[_0x4cd775(0x7a6)](),this[_0x4cd775(0x2be)](),this[_0x4cd775(0x234)]();},Spriteset_Battle[_0x1a8785(0x978)][_0x1a8785(0x59d)]=function(){const _0x513008=_0x1a8785;this[_0x513008(0x58d)]=new Sprite(),this[_0x513008(0x7ab)][_0x513008(0xaba)](this[_0x513008(0x58d)]);},Spriteset_Battle[_0x1a8785(0x978)][_0x1a8785(0x7a6)]=function(){const _0x25efb1=_0x1a8785;this['_animationContainer']=new Sprite(),Spriteset_Battle[_0x25efb1(0x83d)]?this[_0x25efb1(0xaba)](this[_0x25efb1(0x1d6)]):this[_0x25efb1(0x7ab)]['addChild'](this[_0x25efb1(0x1d6)]);},Spriteset_Battle[_0x1a8785(0x978)][_0x1a8785(0x2be)]=function(){const _0x245226=_0x1a8785;this[_0x245226(0x22a)]=new Sprite(),this[_0x245226(0x22a)]['x']=this[_0x245226(0x7ab)]['x'],this[_0x245226(0x22a)]['y']=this[_0x245226(0x7ab)]['y'],this[_0x245226(0xaba)](this['_damageContainer']);},Spriteset_Battle[_0x1a8785(0x978)][_0x1a8785(0x234)]=function(){const _0x44b84d=_0x1a8785;if(!this['isFlipped']())return;this[_0x44b84d(0x58d)][_0x44b84d(0x768)]['x']=-0x1,this[_0x44b84d(0x58d)]['x']=this[_0x44b84d(0x7ab)][_0x44b84d(0x92d)],this[_0x44b84d(0x320)][_0x44b84d(0x768)]['x']=-0x1,this['_uiContainer']['x']=this[_0x44b84d(0x7ab)][_0x44b84d(0x92d)],this[_0x44b84d(0x1d6)][_0x44b84d(0x768)]['x']=-0x1,this[_0x44b84d(0x1d6)]['x']=this[_0x44b84d(0x7ab)]['width'],this['_damageContainer'][_0x44b84d(0x768)]['x']=-0x1,this[_0x44b84d(0x22a)]['x']=this['_battleField']['x']+this[_0x44b84d(0x7ab)][_0x44b84d(0x92d)];},Spriteset_Battle['prototype']['createEnemies']=function(){const _0x257eea=_0x1a8785;Imported[_0x257eea(0x211)]&&this[_0x257eea(0x359)]()&&this[_0x257eea(0x3ff)]();const _0x3053b5=$gameTroop['members'](),_0x12930e=[];for(const _0x57bdb9 of _0x3053b5){_0x12930e[_0x257eea(0x963)](new Sprite_Enemy(_0x57bdb9));}_0x12930e[_0x257eea(0x836)](this[_0x257eea(0x57e)][_0x257eea(0x6e7)](this));for(const _0x4c1dbf of _0x12930e){this[_0x257eea(0x58d)][_0x257eea(0xaba)](_0x4c1dbf);}this[_0x257eea(0x72a)]=_0x12930e;},Spriteset_Battle[_0x1a8785(0x978)][_0x1a8785(0x779)]=function(){const _0x388e46=_0x1a8785;this[_0x388e46(0x6cb)]=[];for(let _0x5e21ff=0x0;_0x5e21ff<$gameParty[_0x388e46(0x8a4)]();_0x5e21ff++){const _0x251557=$gameParty[_0x388e46(0x87e)]()[_0x5e21ff],_0x5888d4=new Sprite_Actor();_0x5888d4[_0x388e46(0x5a4)](_0x251557),_0x5888d4[_0x388e46(0x464)](_0x251557),_0x5888d4[_0x388e46(0x31a)](),this[_0x388e46(0x6cb)][_0x388e46(0x963)](_0x5888d4),this[_0x388e46(0x58d)][_0x388e46(0xaba)](_0x5888d4);}},Spriteset_Battle[_0x1a8785(0x978)][_0x1a8785(0x7dc)]=function(_0x5bc506,_0x1211d4,_0x11c83e,_0x3e7c68){const _0x4c8c5f=_0x1a8785,_0x1abc15=this[_0x4c8c5f(0x212)](_0x1211d4),_0x36394f=new(_0x1abc15?Sprite_AnimationMV:Sprite_Animation)(),_0x43cd9c=this[_0x4c8c5f(0x571)](_0x5bc506);this[_0x4c8c5f(0x74c)](_0x5bc506[0x0])&&(_0x11c83e=!_0x11c83e),_0x36394f[_0x4c8c5f(0x2c4)]=_0x5bc506,_0x36394f['setup'](_0x43cd9c,_0x1211d4,_0x11c83e,_0x3e7c68),this[_0x4c8c5f(0x67e)](_0x36394f);},Spriteset_Battle[_0x1a8785(0x978)]['addAnimationSpriteToContainer']=function(_0xccac8a){const _0x318acd=_0x1a8785;this[_0x318acd(0x17f)](_0xccac8a)?(this['battleStatusWindowAnimationContainer']()[_0x318acd(0xaba)](_0xccac8a),_0xccac8a[_0x318acd(0x8a7)]=!![]):(this['_animationContainer'][_0x318acd(0xaba)](_0xccac8a),Spriteset_Battle['ANTI_TINT_UI']&&(this[_0x318acd(0x1d6)]['x']=this['_effectsContainer']['x'],this[_0x318acd(0x1d6)]['y']=this[_0x318acd(0x52b)]['y'])),this[_0x318acd(0x3fa)][_0x318acd(0x963)](_0xccac8a);},Spriteset_Battle[_0x1a8785(0x978)][_0x1a8785(0x17f)]=function(_0x2e839b){const _0x37da66=_0x1a8785;if(!_0x2e839b)return![];if(!_0x2e839b[_0x37da66(0x9af)])return![];if(!_0x2e839b[_0x37da66(0x2c4)][0x0])return![];if(_0x2e839b['targetObjects'][0x0][_0x37da66(0x68d)]&&!_0x2e839b[_0x37da66(0x2c4)][0x0][_0x37da66(0x68d)]())return![];if($gameSystem[_0x37da66(0x973)]())return![];if(!this[_0x37da66(0x1fa)]())return![];if(_0x2e839b[_0x37da66(0x79d)]===Sprite_Animation){if(_0x2e839b[_0x37da66(0x9af)][_0x37da66(0x94e)]!==0x0)return![];}else{if(_0x2e839b['constructor']===Sprite_AnimationMV){if(_0x2e839b[_0x37da66(0x9af)][_0x37da66(0x184)]===0x3)return![];}}return!![];const _0x187a6b=Window_BattleStatus[_0x37da66(0x978)][_0x37da66(0x367)]();return['xp',_0x37da66(0x5b2)][_0x37da66(0x9c5)](_0x187a6b);},Spriteset_Battle[_0x1a8785(0x978)][_0x1a8785(0x1fa)]=function(){const _0x18e03b=_0x1a8785;if(!SceneManager['_scene'])return null;if(!SceneManager['_scene'][_0x18e03b(0x2ac)])return null;if(!SceneManager[_0x18e03b(0xa42)]['_statusWindow']['_effectsContainer'])return null;return SceneManager[_0x18e03b(0xa42)][_0x18e03b(0x2ac)]['_effectsContainer'];},Spriteset_Battle['prototype']['removeAnimation']=function(_0x18b0b8){const _0x2d65a9=_0x1a8785;this[_0x2d65a9(0x3b3)](_0x18b0b8);for(const _0xaebf54 of _0x18b0b8[_0x2d65a9(0x2c4)]){_0xaebf54[_0x2d65a9(0x893)]&&_0xaebf54[_0x2d65a9(0x893)]();}_0x18b0b8[_0x2d65a9(0x738)]();},Spriteset_Battle[_0x1a8785(0x978)]['removeAnimationFromContainer']=function(_0x230f8d){const _0x2f0707=_0x1a8785;this['isAnimationShownOnBattlePortrait'](_0x230f8d)?this[_0x2f0707(0x1fa)]()[_0x2f0707(0x25a)](_0x230f8d):this[_0x2f0707(0x1d6)][_0x2f0707(0x25a)](_0x230f8d);this[_0x2f0707(0x52b)][_0x2f0707(0x25a)](_0x230f8d),this[_0x2f0707(0x1d6)][_0x2f0707(0x25a)](_0x230f8d),this[_0x2f0707(0x3fa)]['remove'](_0x230f8d);if(this[_0x2f0707(0xa61)])this[_0x2f0707(0xa61)][_0x2f0707(0xa3b)](_0x230f8d);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x698)]=Spriteset_Battle[_0x1a8785(0x978)][_0x1a8785(0xaf8)],Spriteset_Battle[_0x1a8785(0x978)][_0x1a8785(0xaf8)]=function(){const _0x422048=_0x1a8785;VisuMZ['BattleCore'][_0x422048(0x698)][_0x422048(0x716)](this),this[_0x422048(0x1a1)]();},Spriteset_Battle[_0x1a8785(0x978)]['updateBattlerContainer']=function(){const _0x2603e2=_0x1a8785;this['_battlerContainer'][_0x2603e2(0x908)][_0x2603e2(0x836)](this[_0x2603e2(0x240)][_0x2603e2(0x6e7)](this)),this[_0x2603e2(0x1d1)]();if(!this['_battlerContainer'])return;this[_0x2603e2(0x58d)][_0x2603e2(0xaeb)]=this[_0x2603e2(0x41c)]();},Spriteset_Battle[_0x1a8785(0x978)][_0x1a8785(0x240)]=function(_0x4aa9f9,_0x35d476){const _0x1d7681=_0x1a8785;if(VisuMZ[_0x1d7681(0x83c)][_0x1d7681(0x9a7)][_0x1d7681(0x1d0)][_0x1d7681(0x9e9)]){if(_0x4aa9f9['_battler']&&_0x35d476[_0x1d7681(0x8b2)]){if(_0x4aa9f9['_battler'][_0x1d7681(0x68d)]()&&_0x35d476[_0x1d7681(0x8b2)][_0x1d7681(0x3a6)]())return 0x1;else{if(_0x35d476[_0x1d7681(0x8b2)][_0x1d7681(0x68d)]()&&_0x4aa9f9[_0x1d7681(0x8b2)][_0x1d7681(0x3a6)]())return-0x1;}}}return _0x4aa9f9['_baseY']!==_0x35d476[_0x1d7681(0x236)]?_0x4aa9f9[_0x1d7681(0x236)]-_0x35d476[_0x1d7681(0x236)]:_0x35d476[_0x1d7681(0x87b)]-_0x4aa9f9['spriteId'];},Spriteset_Battle[_0x1a8785(0x978)][_0x1a8785(0x1d1)]=function(){const _0x5e787f=_0x1a8785;if(!VisuMZ[_0x5e787f(0x83c)][_0x5e787f(0x9a7)][_0x5e787f(0x1d0)][_0x5e787f(0x490)])return;const _0x5d73d2=BattleManager[_0x5e787f(0x938)];if(_0x5d73d2){if(_0x5d73d2['isActor']()&&!$gameSystem[_0x5e787f(0x973)]())return;const _0x5d9ca8=_0x5d73d2['battler']();if(_0x5d9ca8&&_0x5d73d2[_0x5e787f(0x68d)]())this[_0x5e787f(0x58d)][_0x5e787f(0xaba)](_0x5d9ca8);}},Spriteset_Battle[_0x1a8785(0x978)][_0x1a8785(0x8dc)]=function(){const _0x25dc25=_0x1a8785;for(const _0x1d0769 of $gameParty['aliveMembers']()){if(!_0x1d0769)continue;if(!_0x1d0769['battler']())continue;_0x1d0769[_0x25dc25(0x89e)]()[_0x25dc25(0x183)]=!![],_0x1d0769['battler']()['retreat']();}},Spriteset_Battle['prototype'][_0x1a8785(0x5f3)]=function(){const _0x172c36=_0x1a8785;this[_0x172c36(0x320)]=new Sprite(),Spriteset_Battle[_0x172c36(0x83d)]?this[_0x172c36(0xaba)](this[_0x172c36(0x320)]):this[_0x172c36(0x7ab)][_0x172c36(0xaba)](this['_uiContainer']),SceneManager[_0x172c36(0xa42)][_0x172c36(0x320)]=this[_0x172c36(0x320)];},Spriteset_Battle['prototype'][_0x1a8785(0x4d3)]=function(){const _0x5efc7c=_0x1a8785;if(VisuMZ[_0x5efc7c(0x83c)][_0x5efc7c(0x9a7)][_0x5efc7c(0x199)][_0x5efc7c(0x80c)])return;this[_0x5efc7c(0xada)]=new Sprite(),BattleManager[_0x5efc7c(0x193)](this[_0x5efc7c(0xada)]);for(const _0x474179 of this[_0x5efc7c(0x72a)]){const _0xbdc72=new Sprite_EnemyName();this[_0x5efc7c(0xada)][_0x5efc7c(0xaba)](_0xbdc72),_0xbdc72['linkSprite'](_0x474179);}},Spriteset_Battle['prototype'][_0x1a8785(0x42b)]=function(){const _0x3b48e9=_0x1a8785;if(!this[_0x3b48e9(0x22a)])return;if(!this[_0x3b48e9(0x320)])return;const _0x59cead=Spriteset_Battle[_0x3b48e9(0x83d)]?this['_damageContainer']['x']:0x0,_0x563aee=Spriteset_Battle[_0x3b48e9(0x83d)]?this['_damageContainer']['y']:0x0,_0x10e338=Imported['VisuMZ_3_ActSeqCamera']?this[_0x3b48e9(0x7ab)]['x']:0x0,_0x9a8f52=Imported[_0x3b48e9(0x9de)]?this[_0x3b48e9(0x7ab)]['y']:0x0;this[_0x3b48e9(0x320)]['x']=_0x59cead+_0x10e338,this[_0x3b48e9(0x320)]['y']=_0x563aee+_0x9a8f52;},BattleManager[_0x1a8785(0x193)]=function(_0x319b58){const _0x1af165=_0x1a8785;if(!SceneManager[_0x1af165(0xa42)][_0x1af165(0x320)])return;SceneManager['_scene'][_0x1af165(0x320)][_0x1af165(0xaba)](_0x319b58);},Spriteset_Battle[_0x1a8785(0x978)]['targetBattlerContainerOpacity']=function(){return 0xff;},Spriteset_Battle[_0x1a8785(0x978)][_0x1a8785(0x5ce)]=function(){return![];},Spriteset_Battle[_0x1a8785(0x978)][_0x1a8785(0x409)]=function(){const _0x58ed2f=_0x1a8785;return this['battlerSprites']()['some'](_0x3dc390=>_0x3dc390[_0x58ed2f(0x2ee)]());},Spriteset_Battle['prototype'][_0x1a8785(0x1be)]=function(){const _0x3f9994=_0x1a8785;return this['battlerSprites']()[_0x3f9994(0xa8e)](_0x3d26f0=>_0x3d26f0['isJumping']());},Spriteset_Battle['prototype'][_0x1a8785(0xa06)]=function(){const _0xa1f47=_0x1a8785;return this[_0xa1f47(0x524)]()[_0xa1f47(0xa8e)](_0x427caf=>_0x427caf['isGrowing']());},Spriteset_Battle[_0x1a8785(0x978)]['isAnyoneSkewing']=function(){const _0x54e3b0=_0x1a8785;return this[_0x54e3b0(0x524)]()[_0x54e3b0(0xa8e)](_0x1508bc=>_0x1508bc[_0x54e3b0(0x6c0)]());},Spriteset_Battle[_0x1a8785(0x978)][_0x1a8785(0x61b)]=function(){const _0x50c13a=_0x1a8785;return this['battlerSprites']()[_0x50c13a(0xa8e)](_0x29b722=>_0x29b722[_0x50c13a(0x749)]());},Spriteset_Battle[_0x1a8785(0x978)]['isAnyoneChangingOpacity']=function(){const _0x141116=_0x1a8785;return this[_0x141116(0x524)]()[_0x141116(0xa8e)](_0x1707e6=>_0x1707e6[_0x141116(0x332)]());},VisuMZ['BattleCore']['Window_ItemList_maxCols']=Window_ItemList[_0x1a8785(0x978)][_0x1a8785(0x664)],Window_ItemList[_0x1a8785(0x978)][_0x1a8785(0x664)]=function(){const _0x49eb56=_0x1a8785;return SceneManager[_0x49eb56(0x3a8)]()?SceneManager[_0x49eb56(0xa42)][_0x49eb56(0x367)]()==='border'?VisuMZ['BattleCore']['Settings'][_0x49eb56(0x9bf)][_0x49eb56(0x722)]:VisuMZ[_0x49eb56(0x83c)][_0x49eb56(0x9a7)]['BattleLayout'][_0x49eb56(0x4ff)]:VisuMZ['BattleCore']['Window_ItemList_maxCols']['call'](this);},VisuMZ['BattleCore'][_0x1a8785(0x954)]=Window_SkillList[_0x1a8785(0x978)][_0x1a8785(0x664)],Window_SkillList['prototype'][_0x1a8785(0x664)]=function(){const _0x3d3355=_0x1a8785;return SceneManager[_0x3d3355(0x3a8)]()?SceneManager[_0x3d3355(0xa42)][_0x3d3355(0x367)]()===_0x3d3355(0x617)?VisuMZ['BattleCore'][_0x3d3355(0x9a7)][_0x3d3355(0x9bf)][_0x3d3355(0x722)]:VisuMZ['BattleCore']['Settings'][_0x3d3355(0x9bf)][_0x3d3355(0x4ff)]:VisuMZ[_0x3d3355(0x83c)][_0x3d3355(0x954)][_0x3d3355(0x716)](this);},VisuMZ[_0x1a8785(0x83c)][_0x1a8785(0x48a)]=Window_Options[_0x1a8785(0x978)][_0x1a8785(0x8ca)],Window_Options[_0x1a8785(0x978)][_0x1a8785(0x8ca)]=function(){const _0x19dc3d=_0x1a8785;VisuMZ[_0x19dc3d(0x83c)][_0x19dc3d(0x48a)][_0x19dc3d(0x716)](this),this[_0x19dc3d(0x8bf)](),this[_0x19dc3d(0x6a6)]();},Window_Options[_0x1a8785(0x978)][_0x1a8785(0x8bf)]=function(){const _0x40ed36=_0x1a8785;VisuMZ['BattleCore']['Settings'][_0x40ed36(0x224)]['AddOption']&&(this['addBattleCoreAutoBattleStartupCommand'](),this[_0x40ed36(0x4f7)]());},Window_Options['prototype'][_0x1a8785(0x6a6)]=function(){const _0x5e4ff4=_0x1a8785;if(!VisuMZ[_0x5e4ff4(0x83c)][_0x5e4ff4(0x9a7)][_0x5e4ff4(0x9d0)]['AddHpGaugeOption'])return;const _0x38cc06=TextManager[_0x5e4ff4(0xa96)],_0x357fc9=_0x5e4ff4(0xa96);this[_0x5e4ff4(0x79a)](_0x38cc06,_0x357fc9);},Window_Options[_0x1a8785(0x978)][_0x1a8785(0x584)]=function(){const _0x4a71b6=_0x1a8785,_0x18e313=TextManager[_0x4a71b6(0x650)