//=============================================================================
// VisuStella MZ - Options Core
// VisuMZ_1_OptionsCore.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_1_OptionsCore = true;

var VisuMZ = VisuMZ || {};
VisuMZ.OptionsCore = VisuMZ.OptionsCore || {};
VisuMZ.OptionsCore.version = 1.22;

//=============================================================================
 /*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 1] [Version 1.22] [OptionsCore]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/Options_Core_VisuStella_MZ
 * @orderAfter VisuMZ_0_CoreEngine
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 *
 * The Options Core plugin revamps the Options Menu Scene in RPG Maker MZ to be
 * more extensive and sustain a larger variety of options. This plugin will add
 * new options to the list in addition to options from other VisuStella MZ
 * plugins provided that they're installed as well. Game devs that are adept
 * with JavaScript are also able to add in their own options to the menu as
 * well.
 *
 * Features include all (but not limited to) the following:
 * 
 * * Revamped Options Menu Scene and layout.
 * * The ability to add in your own Categories and options inside each of the
 *   individual categories.
 * * Newly added options like Master Volume, Window Tone support, and more.
 * * Integrated options added from other VisuStella MZ plugins.
 * * An added Playtest options category that is only available during test play
 *   to help speed up the game debug process.
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Tier 1 ------
 *
 * This plugin is a Tier 1 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ library.
 *
 * ============================================================================
 * Major Changes
 * ============================================================================
 *
 * This plugin adds some new hard-coded features to RPG Maker MZ's functions.
 * The following is a list of them.
 *
 * ---
 *
 * Options Menu Scene
 *
 * - The whole scene is revamped due to all the new additions provided by the
 * Options Core plugin. While basic functions will still work, do not expect
 * everything to integrate into it seamlessly.
 *
 * ---
 *
 * ============================================================================
 * Extra Features
 * ============================================================================
 *
 * There are some extra features found if other VisuStella MZ plugins are found
 * present in the Plugin Manager list. Most of these enable new options for the
 * Options Core to utilize as the code for them to work is found in the newer
 * plugins.
 *
 * ---
 *
 * VisuMZ_0_CoreEngine
 * VisuMZ_1_BattleCore
 * VisuMZ_1_MessageCore
 * VisuMZ_1_SaveCore
 * VisuMZ_2_AggroControlSystem
 * VisuMZ_2_BattleSystemATB
 * VisuMZ_2_BrightEffects
 * VisuMZ_2_HorrorEffects
 * VisuMZ_2_QuestSystem
 * VisuMZ_3_ActSeqCamera
 * - Each of these plugins have options that become available when installed
 *   together with the Options Core plugin that wouldn't be available normally.
 *
 * ---
 *
 * ============================================================================
 * Understanding Options
 * ============================================================================
 * 
 * This section is to clarify a few things about the Options Core.
 * 
 * ---
 * 
 * === Global Settings ===
 * 
 * The majority of settings adjusted by the player in the Options menu are
 * global settings. This is the way it is for base RPG Maker MZ without using
 * any plugins and this is the way it will be when using the Options Core.
 * 
 * What does this mean?
 * 
 * This means that if your player changed the Options settings, then loaded up
 * a different save, the Options settings do not revert to the settings from
 * the last time that save was made.
 * 
 * Why is this?
 * 
 * Because that is the industry standard. If the player wants to adjust the
 * BGM volume down to 50% from 100%, that means that when the player loads a
 * save file, the BGM volume does not shoot back up to 100%. Doing that would
 * require the player to adjust the settings multiple times for each save and
 * that just is not user friendly.
 * 
 * Therefore, the majority of the Options Core settings are global for this
 * very reason and are not going to change because of it.
 * 
 * ---
 * 
 * === Exceptions ===
 * 
 * There are a few exceptions to the rule. These exceptions are the three
 * settings that govern the "Window Tone" in the UI section.
 * 
 * This means the values inserted for "Red", "Green", and "Blue" are saved
 * relative to the save file's settings.
 * 
 * Why is this?
 * 
 * That's because RPG Maker MZ's "Change Window Color" event command does the
 * same thing and we have no intentions of altering how it behaves to keep the
 * otherwise-global aspect.
 * 
 * ---
 *
 * ============================================================================
 * Options Category: General
 * ============================================================================
 *
 * The following are the options that have been added to the Options Menu. This
 * is the default "General" category that appears with the plugin parameters.
 * These can be added and/or removed. If a new option has been added through an
 * update, then there's a likelihood of it not appearing due to the plugin
 * parameters not being updated with them.
 *
 * === Exploration ===
 *
 * These options adjust the general exploration aspects of the game.
 *
 * ---
 *
 * Always Dash
 * - A default option that came with RPG Maker MZ.
 * - If ON, then this puts the player character in a constant state of dashing
 *   unless the Dash button is held down.
 *   - OFF: Walks normally. Holding down Dash button will make player dash.
 *   - ON: Dashes normally. Holding down Dash button will make player walk.
 *
 * ---
 *
 * Autosave
 * - Requires VisuMZ_1_SaveCore
 * - Lets the player choose whether or not they want autosaving in their game.
 *   - OFF: Autosaves are disabled.
 *   - ON: Autosaves are enabled and occur at the set conditions.
 *
 * ---
 *
 * Show Compass
 * - Requires VisuMZ_4_ProximityCompass
 * - Displays the Proximity Compass in the corner of the screen.
 *   - OFF: Compass is hidden.
 *   - ON: Compass is shown.
 * 
 * ---
 *
 * Compass Size
 * - Requires VisuMZ_4_ProximityCompass
 * - Changes the size of the compass.
 *   - 50% for Smallest
 *   - 100% for Largest
 * 
 * ---
 *
 * Show Quest Tracker
 * - Requires VisuMZ_2_QuestSystem
 * - Player can choose if they want the Quest Tracker Window to appear on the
 *   map scene as they explore.
 *   - OFF: Quest Tracker Window does not appear.
 *   - ON: Quest Tracker Window is visible.
 *
 * ---
 *
 * Quest Tracker Position
 * - Requires VisuMZ_2_QuestSystem
 * - Lets the player decide which half of the screen the Quest Tracker Window
 *   should appear.
 *   - ←: Quest Tracker Window appears on the left.
 *   - →: Quest Tracker Window appears on the right.
 *
 * ---
 *
 * Random Encounters
 * - Sometimes, random encounters can really take away the enjoyment a player
 *   has for the game if it's too frequent. This option lets the player turn
 *   them off or reduce their frequency by half.
 *   - None: No random encounters while this is selected.
 *   - Half: Random encounters occur at half frequency.
 *   - Normal: Random encounters occur at normal frequency.
 *
 * ---
 *
 * === Battle ===
 *
 * These options adjust the general battle aspects of the game.
 *
 * ---
 * 
 * Show Battle Animations:
 * - Players might want to turn off or some battle animations for various
 *   reasons. As examples, battle animations may take a toll on some players'
 *   computers while others might find them too distracting.
 *   - OFF: All battle animations are turned off.
 *   - SOME: Animations that aren't part of a skill/item's action sequence will
 *     not be displayed.
 *   - ON: All battle animations are visible.
 * 
 * ---
 *
 * Battle Animation Speed:
 * - Battles can become a slog for some types of players. This option comes
 *   with four speed types to blaze through the battle while animations are
 *   playing. Fret not, if it's time for an actor to input actions, then the
 *   battle speed will temporarily revert to normal speed.
 *   - Normal: The usual battle speed.
 *   - Fast: x2 the usual battle speed.
 *   - Faster: x3 the usual battle speed.
 *   - Fastest: x4 the usual battle speed.
 *
 * ---
 *
 * Battle Camera
 * - Requires VisuMZ_3_ActSeqCamera
 * - Allows the player to turn on/off the camera in case the player is one
 *   who gets motion sick easily.
 *   - OFF: Battle camera is static and doesn't move/zoom.
 *   - ON: Battle camera has full range of movement and zoom.
 *
 * ---
 *
 * Command Remember
 * - A default Options menu command that remembers the last position of the
 *   battle input window.
 *   - OFF: Cursor position resets each time the battle input window is active.
 *   - ON: Cursor position remembers last position for battle input window.
 *
 * ---
 *
 * Active Battle Style
 * - Requires VisuMZ_2_BattleSystemATB
 * - Lets the player switch betweent "Wait" and "Active".
 *   - Wait: ATB gauges stop filling up the moment an actor can input.
 *   - Active: ATB gauges keep filling even if actors can input.
 *
 * ---
 *
 * Active Battle Speed
 * - Requires VisuMZ_2_BattleSystemATB
 * - Lets the player control how fast ATB gauges fill up.
 * - 1 for slowest.
 * - 5 for fastest.
 *
 * ---
 *
 * Auto Battle Start
 * - Requires VisuMZ_1_BattleCore
 * - Start battles with Auto Battle on/off?
 *   - OFF: Battles do not start with Auto Battle on.
 *   - ON: Battles start with Auto Battle on.
 *
 * ---
 *
 * Auto Battle Style
 * - Requires VisuMZ_1_BattleCore
 * - Determine if Auto Battle for the player party will attack only or be
 *   allowed to use skills as well.
 *   - Attack: Auto Battle actors will attack only.
 *   - Skills: Auto Battle actors can also use skills.
 * 
 * ---
 *
 * === Screen ===
 *
 * These options adjust the general screen-related aspects of the game.
 *
 * ---
 *
 * Display FPS
 * - Turns on/off the FPS counter in the upper left section of the screen.
 *
 * ---
 *
 * Full Screen
 * - Switches the game client between windowed mode and full screen.
 *
 * ---
 *
 * Stretch Screen
 * - If the game client is larger than the screen, then the game's canvas will
 *   stretch to fit the client. Turn this on or off.
 *
 * ---
 * 
 * Special Effects
 * - Requires: VisuMZ_2_BrightEffects and/or VisuMZ_2_HorrorEffects
 * - When using VisuStella MZ's Horror Effects or Bright Effects, users can opt
 *   to disable those effects by turning this option on/off.
 * 
 * ---
 *
 * ============================================================================
 * Options Category: Audio
 * ============================================================================
 *
 * The following are the options that have been added to the Options Menu. This
 * is the default "Audio" category that appears with the plugin parameters.
 * These can be added and/or removed. If a new option has been added through an
 * update, then there's a likelihood of it not appearing due to the plugin
 * parameters not being updated with them.
 *
 * === Volume ===
 *
 * These options adjust the volume-related aspects of the game.
 *
 * ---
 *
 * Master Volume
 * - The master volume sets the volume of all the other volume types by a
 *   proportional amount from 0% to 100%.
 * - The Options Core allows players to adjust the volume in increments of 10%
 *   instead of the 20% by default.
 *
 * ---
 *
 * BGM Volume
 * - Controls the background music volume by a value between 0% and 100%.
 * - The Options Core allows players to adjust the volume in increments of 10%
 *   instead of the 20% by default.
 *
 * ---
 *
 * BGS Volume
 * - Controls the background ambience volume by a value between 0% and 100%.
 * - The Options Core allows players to adjust the volume in increments of 10%
 *   instead of the 20% by default.
 *
 * ---
 *
 * ME Volume
 * - Controls the fanfare volume by a value between 0% and 100%.
 * - The Options Core allows players to adjust the volume in increments of 10%
 *   instead of the 20% by default.
 *
 * ---
 *
 * SE Volume
 * - Controls the sound effect volume by a value between 0% and 100%.
 * - The Options Core allows players to adjust the volume in increments of 10%
 *   instead of the 20% by default.
 * 
 * ---
 *
 * === Sound Effects ===
 *
 * These options adjust the sound effects-related aspects of the game.
 *
 * ---
 *
 * Sound Effects:
 * Cursor SFX:
 * Confirm SFX:
 * Cancel SFX:
 * Buzzer SFX:
 * - Not all sound effects register well with players and/or their computers.
 * - This lets players pick different sound effects if they have trouble
 *   hearing certain ones.
 *
 * ---
 *
 * ============================================================================
 * Options Category: UI
 * ============================================================================
 *
 * The following are the options that have been added to the Options Menu. This
 * is the default "UI" category that appears with the plugin parameters.
 * These can be added and/or removed. If a new option has been added through an
 * update, then there's a likelihood of it not appearing due to the plugin
 * parameters not being updated with them.
 *
 * === Windows ===
 *
 * These options adjust the Windows UI-related aspects of the game.
 *
 * ---
 *
 * Window Tone: Red:
 * Window Tone: Green:
 * Window Tone: Blue:
 * - Allows the player to adjust the Window Tone to their liking. This helps
 *   give players a more personal touch on their save file.
 *
 * ---
 *
 * === Text ===
 *
 * These options adjust the Text-related aspects of the game.
 *
 * ---
 *
 * Text Font:
 * - Certain fonts are harder to read for different players. Let the players
 *   pick the font the game uses to allow themselves maximum comfort.
 *
 * ---
 *
 * Text Speed
 * - Requires VisuMZ_1_MessageCore
 * - Allows the player to set the speed at which text displays during messages.
 * - There are speeds 1 through 10, with 1 being the slowest and 10 being the
 *   fastest.
 * - Speed 11 is "Instant" which causes text to display instantly.
 *
 * ---
 *
 * === Touch Input ===
 *
 * These options adjust the Touch UI-related aspects of the game.
 *
 * ---
 *
 * Touch UI
 * - Requires VisuMZ_0_CoreEngine
 * - This sets the visibility of the UI elements that are touch-only in the
 *   game such as the cancel button and the left/right actor switch buttons.
 *   - OFF: The touch-only UI elements do not appear.
 *   - ON: The touch-only UI elements do appear.
 *
 * ---
 *
 * Button Position:
 * - Requires VisuMZ_0_CoreEngine
 * - Moves the clickable Cancel button, Page Up button, and Page down button
 *   to either the top of the screen or bottom of the screen.
 *
 * ---
 *
 * Hover Select:
 * - Turn on/off Hover Select when using the mouse. If Hover Select is on, then
 *   the window cursor will automatically follow the mouse when applicable.
 *   Otherwise, the player will have to manually move the cursor.
 *
 * ---
 *
 * === Menu Arrangement ===
 *
 * These options adjust the Menu Arrangement-related aspects of the game.
 *
 * ---
 *
 * Menu Style
 * - Switch between 'Recommended' and 'Custom'. Recommended will have the menus
 *   arranged in the way the game/plugins decide for them to be. Otherwise,
 *   the player will be able to customize the positions of these next windows:
 *
 * ---
 *
 * Help Window Position:
 * Input Window Position:
 * - Adjust the positions of these windows in the various positions listed to
 *   allow the player to select what they're most comfortable with.
 *
 * ---
 *
 * === Battle UI ===
 *
 * These options adjust the Battle UI-related aspects of the game.
 *
 * ---
 *
 * Show Provoke Origin
 * - Requires VisuMZ_2_AggroControlSystem
 * - If a battler is under the effects of "Provoke", then a line tracing back
 *   to the origin of the "Provoke" effect can be found.
 *   - OFF: Hide the Provoke Origin lines.
 *   - ON: Show the Provoke Origin lines.
 *
 * ---
 *
 * Show Aggro Gauge
 * - Requires VisuMZ_2_AggroControlSystem
 * - Displays the amount of aggro a party member has with a gauge.
 *   - OFF: The Aggro Gauge is hidden.
 *   - ON: The Aggro Gauge is visible.
 *
 * ---
 *
 * Show HP Gauges
 * - Requires VisuMZ_3_VisualHpGauge
 * - Displays the amount of HP each battler has with a gauge under their feet.
 *   - OFF: The battlefield's HP Gauges are hidden.
 *   - ON: The battlefield's HP Gauges are visible.
 *
 * ---
 *
 * Show ATB Gauges
 * - Requires VisuMZ_2_BattleSystemATB
 * - Displays ATB gauges on each battler showing how much time they have left
 *   before they can act.
 *   - OFF: The battlefield's ATB Gauges are hidden.
 *   - ON: The battlefield's ATB Gauges are hidden.
 *
 * ---
 *
 * ============================================================================
 * Options Category: Playtest
 * ============================================================================
 *
 * The following are the options that have been added to the Options Menu. This
 * is the default "Text" category that appears with the plugin parameters.
 * These can be added and/or removed. If a new option has been added through an
 * update, then there's a likelihood of it not appearing due to the plugin
 * parameters not being updated with them.
 * 
 * *NOTE* Unless changed, this category only appears during playtesting and
 * does not appear outside of playtesting, which means deployed games should
 * not display this unless you've given them access to playtest mode.
 *
 * === Effects ===
 * 
 * ---
 *
 * Playtest Effects:
 * - If this is 'OFF', then all the Playtesting options are turned off. If 'ON'
 *   then you can adjust them however you like.
 *
 * ---
 * 
 * === Exploration ===
 * 
 * These options adjust the Playtest Exploration-related aspects of the game.
 * 
 * ---
 *
 * Map Update Speed:
 * - Allows you to speed up the events and movement on the map with four speed
 *   levels ranging from normal to x3 speed.
 *   - Normal: The usual update speed.
 *   - Fast: x2 the usual update speed.
 *   - Faster: x3 the usual update speed.
 *   - Fastest: x4 the usual update speed.
 *
 * ---
 *
 * Random Encounters:
 * - Sometimes, random encounters can really take away the enjoyment a player
 *   has for the game if it's too frequent. This option lets the player turn
 *   them off or reduce their frequency by half.
 *   - None: No random encounters while this is selected.
 *   - Half: Random encounters occur at half frequency.
 *   - Normal: Random encounters occur at normal frequency.
 *
 * ---
 * 
 * === Battle ===
 * 
 * These options adjust the Playtest Battle-related aspects of the game.
 * 
 * ---
 *
 * God Mode:
 * - If this is ON, then actors will be unable to die even if their HP reaches
 *   0. They will continue to act as if they still have HP left.
 *
 * ---
 *
 * Resist Negative Effects:
 * - Requires VisuMZ_1_SkillsStatesCore.
 * - If ON, this will resist states with a <Negative State> notetag.
 * - If ON, this will also resist debuffs.
 *
 * ---
 *
 * Instant K.O.
 * - If ON, then actors attacking enemies will deal fatal damage to enemies.
 *
 * ---
 *
 * Skill Costs:
 * Consume Items:
 * - If OFF, then skills won't cost anything and items won't be consumed.
 *
 * ---
 * 
 * === Rewards ===
 * 
 * These options adjust the Playtest Rewards-related aspects of the game.
 * 
 * ---
 *
 * EXP Multiplier:
 * Gold Multiplier:
 * Drop Multiplier:
 * - Allows you to adjust the multipliers for EXP gained, Gold gained, and
 *   Drop rates from x2 to x1024.
 *
 * ---
 * 
 * === Spawners ===
 * 
 * These options adjust the Playtest Spawner-related aspects of the game.
 * 
 * ---
 *
 * Spawn Items:
 * Spawn Weapons:
 * Spawn Armors:
 * - Sends you to a "shop" where you can purchase any of the game's named items
 *   for 0 gold each.
 *
 * ---
 * 
 * === Debug ===
 * 
 * These options adjust the Playtest Debug-related aspects of the game.
 * 
 * ---
 *
 * Debug Menu:
 * - Sends you to the Debug Menu Scene.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Options Settings
 * ============================================================================
 *
 * Allows you to adjust some default settings that may affect the way the
 * Options Menu Scene looks and/or some of the options available inside it.
 *
 * ---
 *
 * Categories
 * 
 *   Category Window Style:
 *   - How do you wish to draw commands in the Category Window?
 *   - Text Only: Display only the text.
 *   - Icon Only: Display only the icon.
 *   - Icon + Text: Display the icon first, then the text.
 *   - Auto: Determine which is better to use based on the size of the cell.
 * 
 *   Category Text Align:
 *   - Text alignment for the Command Window.
 * 
 *   Background Type:
 *   - Select background type for this window.
 *
 * ---
 * 
 * Options Window
 * 
 *   Background Type:
 *   - Select background type for this window.
 * 
 * ---
 *
 * Button Assist Window
 *
 *   Switch Category:
 *   - Button assist text used for switching categories.
 *   - For VisuStella MZ's Core Engine's Button Assist Window.
 * 
 *   Background Type:
 *   - Select background type for this window.
 *   - Requires VisuMZ_0_CoreEngine!
 *
 * ---
 *
 * Sound
 * 
 *   Cursor Sounds:
 *   OK Sounds:
 *   Cancel Sounds:
 *   Buzzer Sounds:
 *   - SE files player can select from for OK SE.
 *   - The first in the list will always be the default SE.
 *
 * ---
 *
 * Text
 * 
 *   Font Options:
 *   - Available fonts for the player to select from.
 *   - The first font in the list is always be the default font.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Options Categories
 * ============================================================================
 *
 * Here, you can add/edit/remove the categories found in the Options Menu Scene
 * and their related Options.
 *
 * ---
 *
 * Options Categories
 * 
 *   Name:
 *   - The name of this category as seen in the Category Window.
 *   - Text codes are supported.
 * 
 *   Icon:
 *   - Icon used for this category.
 *   - Use 0 for no icon.
 * 
 *   JS: Show/Hide:
 *   - Code used to determine if this category is visible.
 * 
 *   Options List:
 *   - Add options to this category here.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Listed Options
 * ============================================================================
 *
 * These are the Options found within an Options Category's List. Add, edit,
 * and/or remove them as you see fit. Adding or altering an option will require
 * adequate knowledge of JavaScript to do so.
 *
 * ---
 *
 * Basic
 * 
 *   Symbol:
 *   - Symbol used for this option when selected.
 *   - Make sure this is unique from other symbols.
 * 
 *   Icon:
 *   - Icon used for this option.
 *   - Use 0 for no icon.
 * 
 *   STR: Text:
 *   - Displayed text used for this option.
 *   - If this has a value, ignore the JS: Text version.
 * 
 *   JS: Text:
 *   - JavaScript code used to determine string used for the displayed name.
 *
 * ---
 *
 * Accessibility
 * 
 *   JS: Show/Hide:
 *   - Code used to determine if this option is visible.
 * 
 *   JS: Enable:
 *   - Code used to determine if this option is enabled.
 *   - This does NOT determine the ON/OFF value of the option. It instead
 *     determines if the option can be changed (enabled) or not (disabled).
 * 
 *   JS: Ext:
 *   - Code used to determine if this option's ext value.
 *
 * ---
 *
 * Functions
 * 
 *   JS: Draw Option:
 *   - Code used to draw this item into the List Window.
 * 
 *   JS: Process OK:
 *   - Code used when OK button is pressed while selected.
 * 
 *   JS: Cursor Right:
 *   - Code used when Right button is pressed while selected.
 * 
 *   JS: Cursor Left:
 *   - Code used when Left button is pressed while selected.
 *
 * ---
 *
 * Data
 * 
 *   JS: Default Value:
 *   - Code used to determine the default value of this option.
 *   - This is what determines the default ON/OFF values of an option.
 * 
 *   JS: Save Option:
 *   - Code used when saving this options setting.
 * 
 *   JS: Load Option:
 *   - Code used when loading this options setting.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Master Volume Shortcut Settings
 * ============================================================================
 *
 * Settings regarding the Master Volume Shortcut keys. Requires the
 * Options Core to allow players to adjust the master volume.
 * 
 * Shortcut: Ctrl + PageUp / Ctrl + PageDn
 *
 * ---
 *
 * Shortcut
 * 
 *   Enabled?:
 *   - Enable the shortcut?
 *   - Shortcut: Ctrl + PageUp / Ctrl + PageDn
 * 
 *   Shortcut Change Value:
 *   - What is the change amount for the shortcut key?
 *   - Master volume caps at 0 and 100.
 *
 * ---
 *
 * Sound Effects > Volume Up
 * 
 *   Filename:
 *   - Filename of the sound effect played.
 * 
 *   Volume:
 *   - Volume of the sound effect played.
 * 
 *   Pitch:
 *   - Pitch of the sound effect played.
 * 
 *   Pan:
 *   - Pan of the sound effect played.
 *
 * ---
 *
 * Sound Effects > Volume Down
 * 
 *   Filename:
 *   - Filename of the sound effect played.
 * 
 *   Volume:
 *   - Volume of the sound effect played.
 * 
 *   Pitch:
 *   - Pitch of the sound effect played.
 * 
 *   Pan:
 *   - Pan of the sound effect played.
 *
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 * 
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 * 
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 * 
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 * 
 * If you are using this plugin, credit the following people in your game:
 * 
 * Team VisuStella
 * * Yanfly
 * * Arisu
 * * Olivia
 * * Irina
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 * 
 * Version 1.22: January 20, 2023
 * * Added compatibility functionality for future plugin:
 * ** Animated Message Text Effects
 * *** If you want to acquire these settings for an already-existing project,
 *     do either of the following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the UI plugin parameters found in the Options Category plugin
 *      parameter settings to your current project.
 * 
 * Version 1.21: October 27, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Added compatibility functionality for future plugin:
 * ** Tutorial Panel System
 * *** If you want to acquire these settings for an already-existing project,
 *     do either of the following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the General and Audio settings found in the Options Category
 *      plugin parameter to your current project.
 * * New Features!
 * ** Added "Master Volume Shortcut" Plugin Parameters.
 * *** Change the master volume anywhere in the game as long as the Options
 *     Core allows players to adjust the Master Volume.
 * *** Shortcut: Ctrl + PageUp / Ctrl + PageDn
 * 
 * Version 1.20: September 15, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Button Assist Window no longer follows the Core Engine's Option Scene
 *    settings, but instead follows the Button Assist Window's settings.
 *    Update made by Arisu.
 * * New Features!
 * ** New Plugin Parameters added by Arisu:
 * *** Parameters > Options Settings > Categories > Background Type
 * *** Parameters > Options Settings > Options Window > Background Type
 * *** Parameters > Options Settings > Button Assist Window > Background Type
 * **** Select background type for this window.
 * 
 * Version 1.19: August 11, 2022
 * * Feature Update!
 * ** VisuMZ Core Engine menu layout window settings now apply to all windows
 *    found in the Options Scene. Update made by Arisu.
 * 
 * Version 1.18: March 3, 2022
 * * Compatibility Update
 * ** Added compatibility functionality for future plugins: "Movement Effects",
 *    "Weather Effects", and "Lighting Effects". Hold on tight!
 * *** If you want to acquire these settings for an already-existing project,
 *     do either of the following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the General and Audio settings found in the Options Category
 *      plugin parameter to your current project.
 * 
 * Version 1.17: December 30, 2021
 * * Bug Fixes!
 * ** Residual old code is now disabled from appearing on deployed projects if
 *    any carry over config data is brought over from the playtesting phase.
 * ** Yep, again again.
 * ** We had to call in the big boss to fix this.
 * 
 * Version 1.16: December 23, 2021
 * * Bug Fixes!
 * ** Residual old code is now disabled from appearing on deployed projects if
 *    any carry over config data is brought over from the playtesting phase.
 *    Fix made by Arisu.
 * ** Yep, again.
 * 
 * Version 1.15: December 16, 2021
 * * Bug Fixes!
 * ** Residual old code is now disabled from appearing on deployed projects if
 *    any carry over config data is brought over from the playtesting phase.
 *    Fix made by Arisu.
 * 
 * Version 1.14: December 9, 2021
 * * Compatibility Update!
 * ** Full Screen options have been updated to match the newest version of RPG
 *    Maker MZ's NodeJS client. Update made by Olivia.
 * *** The "Full Screen" settings have been updated in General settings. If
 *     you want to acquire these updated settings for an already-existing
 *     project, do either of the following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the General settings found in the Options Category plugin
 *      parameter to your current project.
 * 
 * Version 1.13: April 23, 2021
 * * Documentation Update!
 * ** Added clarity for some of the JS plugin parameters:
 * *** JS: Enable:
 * **** This does NOT determine the ON/OFF value of the option. It instead
 *      determines if the option can be changed (enabled) or not (disabled).
 * *** JS: Default Value:
 * **** This is what determines the default ON/OFF values of an option.
 * 
 * Version 1.12: April 9, 2021
 * * Bug Fixes!
 * ** Turning Touch UI off should no longer disable the Button Assist Text for
 *    the Page Up/Down buttons from the Core Engine. Fix made by Olivia.
 * 
 * Version 1.11: April 2, 2021
 * * Bug Fixes!
 * ** Default "Special Effects" option added in v1.10 should now have a fixed
 *    load data sequence that does not force open the FPS counter. To acquire
 *    the fixed settings, do either of the following:
 * *** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * *** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the General settings found in the Options Category plugin
 *      parameter to your current project.
 * * Documentation Update!
 * ** Added "Understanding Options" section.
 * ** Options Category: General section updated with "Special Effects" which
 *    was left out of the v1.10 update.
 * * Feature Update!
 * ** Default settings will now run regardless of undefined setting provided
 *    that their other conditions for usage have showed up first. This is to
 *    reduce confusion for users. Update made by Yanfly.
 * 
 * Version 1.10: March 12, 2021
 * * Compatibility Update!
 * ** Added compatibility for VisuStella MZ Bright Effects and Horror Effects.
 * *** "Special Effects" option allows users to turn on/off filters applied by
 *     the Bright Effects and Horror Effects plugins.
 * *** The "Special Effects" settings have been added to General settings. If
 *     you want to acquire these settings for an already-existing project, do
 *     either of the following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the General settings found in the Options Category plugin
 *      parameter to your current project.
 * * Documentation Update!
 * ** Added Bright Effects and Horror Effects to the list of plugins with Extra
 *    Features. Update made by Olivia.
 * 
 * Version 1.09: January 29, 2021
 * * Compatibility Update
 * ** Added compatibility for Tome571/TF's "Advanced Sound Options plugin".
 * *** Default settings have been added to the Audio settings. If you want to
 *     acquire these settings for an already-existing project, do either of the
 *     following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the Audio settings found in the Options Category plugin
 *      parameter to your current project.
 * 
 * Version 1.08: January 8, 2021
 * * Bug Fixes!
 * ** JS: Enabled accessibility option should now be working properly.
 * * Feature Update!
 * ** Disabled options should now be faded out completely.
 * 
 * Version 1.07: November 15, 2020
 * * Optimization update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.06: November 8, 2020
 * * Feature Update!
 * ** Modern Controls compatibility with Core Engine no longer enables the
 *    Item Categories window and child classes to utilize the Home/End keys.
 *
 * Version 1.05: October 18, 2020
 * * Optimization update!
 * 
 * Version 1.04: September 27, 2020
 * * Compatibility Update!
 * ** This plugin should offer better compatibility for future plugins!
 *    Update made by Yanfly.
 * 
 * Version 1.03: September 20, 2020
 * * Compatibility Update!
 * ** This plugin should offer better compatibility for future plugins!
 *    Update made by Yanfly.
 * 
 * Version 1.02: September 13, 2020
 * * Optimization Update!
 * ** Scrolling through menus should consume less resources.
 * 
 * Version 1.01: August 30, 2020
 * * Bug Fixes!
 * ** Before, already existing Options available in the RPG Maker MZ base code
 *    such as BGM Volume, Command Remember, Always Dash, and so on, would not
 *    have their default values declared through the Options Core. The Options
 *    Core now changes this functionality and gives priority to the Plugin
 *    Parameter settings declared by the game dev. Fix made by Yanfly.
 *
 * Version 1.00: August 20, 2020
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param OptionsCore
 * @default Plugin Parameters
 *
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param OptionsSettings:struct
 * @text Options Settings
 * @type struct<OptionsSettings>
 * @desc General settings pertaining to options found here.
 * @default {"Categories":"","CategoryStyle:str":"auto","CategoryTextAlign:str":"center","Sound":"","SFXCursorList:arraystr":"[\"Default\",\"Book2\",\"Coin\",\"Cursor1\",\"Cursor2\",\"Hammer\",\"Key\",\"Knock\",\"Open1\",\"Open2\",\"Open3\",\"Paralyze1\"]","SFXOKList:arraystr":"[\"Default\",\"Bell3\",\"Computer\",\"Decision2\",\"Flash1\",\"Bell3\",\"Cat\",\"Item1\",\"Item2\",\"Item3\",\"Ice4\",\"Decision1\"]","SFXCancelList:arraystr":"[\"Default\",\"Absorb1\",\"Book1\",\"Cancel1\",\"Cancel2\",\"Raise2\",\"Skill1\",\"Dog\",\"Shot2\",\"Ice3\",\"Magic1\",\"Magic2\"]","SFXBuzzerList:arraystr":"[\"Default\",\"Buzzer2\",\"Fall\",\"Skill2\",\"Shot3\",\"Bell1\",\"Crow\",\"Horn\",\"Ice2\",\"Magic3\",\"Open4\",\"Buzzer1\"]","Text":"","FontFaces:arraystr":"[\"Default\",\"Arial\",\"Candara\",\"Calibri\",\"Garamond\",\"Georgia\",\"Gill Sans MT\",\"Helvetica\",\"Impact\",\"Lato\",\"Rockwell\",\"Segoe UI\",\"Tahoma\",\"Times\",\"Trebuchet MS\",\"Verdana\"]","ButtonAssist":"","buttonAssistCategory:str":"Switch Category"}
 *
 * @param Categories:arraystruct
 * @text Options Categories
 * @type struct<Categories>[]
 * @desc Add categories and their options here.
 * @default ["{\"Name:str\":\"General\",\"Icon:num\":\"245\",\"ShowJS:func\":\"\\\"// Return Boolean\\\\nreturn true;\\\"\",\"List:arraystruct\":\"[\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Exploration\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"alwaysDash\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"82\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.alwaysDash;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"autosave\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"225\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.autosaveOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_1_SaveCore &&\\\\\\\\\\\\\\\\n    VisuMZ.SaveCore.Settings.AutosaveOption.AddOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"showCompass\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"222\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.showCompass;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_4_ProximityCompass &&\\\\\\\\\\\\\\\\n    VisuMZ.ProximityCompass.Settings.Options.AddShowOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"compassSize\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"222\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.compassSize;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_4_ProximityCompass &&\\\\\\\\\\\\\\\\n    VisuMZ.ProximityCompass.Settings.Options.AddSizeOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(20);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(21);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconsole.log((Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked()))\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 50;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(50, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(50, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(50, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 100;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"questTrackerShow\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"186\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.questTrackerShow;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_QuestSystem &&\\\\\\\\\\\\\\\\n    VisuMZ.QuestSystem.Settings.Tracker.AddShowOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"questTrackerPosition\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"186\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.questTrackerPosition;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_QuestSystem &&\\\\\\\\\\\\\\\\n    VisuMZ.QuestSystem.Settings.Tracker.AddShowOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = TextManager.questTrackerPosOff;\\\\\\\\\\\\\\\\nconst on  = TextManager.questTrackerPosOn;\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"randomEncounters\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"76\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Random Encounters\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Segments\\\\\\\\\\\\\\\\nconst speedText = ['None', 'Half', 'Normal'];\\\\\\\\\\\\\\\\nfor (let i = 0; i < 3; i++) {\\\\\\\\\\\\\\\\n    this.changePaintOpacity(i === value);\\\\\\\\\\\\\\\\n    const text = speedText[i];\\\\\\\\\\\\\\\\n    const sx = rect.x + halfWidth + (segment * i);\\\\\\\\\\\\\\\\n    this.drawText(text, sx, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 2 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 2);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 2);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 2);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 2;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 2);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 2);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"showTutorials\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"189\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.tutorial.optionsCmd;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_TutorialPanelSys &&\\\\\\\\\\\\\\\\n    VisuMZ.TutorialPanelSys.Settings.Options.AddTutorialsOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Battle\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"battleAniShow\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Show Battle Animations';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_1_OptionsCore;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Segments\\\\\\\\\\\\\\\\nconst showText = ['OFF', 'SOME', 'ON'];\\\\\\\\\\\\\\\\nfor (let i = 0; i < 3; i++) {\\\\\\\\\\\\\\\\n    this.changePaintOpacity(i === value);\\\\\\\\\\\\\\\\n    const text = showText[i];\\\\\\\\\\\\\\\\n    const sx = rect.x + halfWidth + (segment * i);\\\\\\\\\\\\\\\\n    this.drawText(text, sx, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 2 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 2);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 2);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 2);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 2;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 2);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 2);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"battleAniSpeed\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Battle Animation Speed\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 4;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Segments\\\\\\\\\\\\\\\\nconst speedText = ['Normal', 'Fast', 'Faster', 'Fastest'];\\\\\\\\\\\\\\\\nfor (let i = 0; i < 4; i++) {\\\\\\\\\\\\\\\\n    this.changePaintOpacity(i === value);\\\\\\\\\\\\\\\\n    const text = speedText[i];\\\\\\\\\\\\\\\\n    const sx = rect.x + halfWidth + (segment * i);\\\\\\\\\\\\\\\\n    this.drawText(text, sx, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 3 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 3);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 3);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 3);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 3);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 3);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"battleCamera\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.battleCameraOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_3_ActSeqCamera && VisuMZ.ActSeqCamera.Settings.Options.AddOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"commandRemember\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.commandRemember;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"atbActive\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Active Battle Style\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_2_BattleSystemATB && BattleManager.isATB();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'Wait';\\\\\\\\\\\\\\\\nconst on  = 'Active';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = $dataSystem.battleSystem === 1;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"atbSpeed\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Active Battle Speed\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_2_BattleSystemATB && BattleManager.isATB();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 5;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.ctGaugeColor1();\\\\\\\\\\\\\\\\nconst color2 = ColorManager.ctGaugeColor2();\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Segments\\\\\\\\\\\\\\\\nfor (let i = 1; i <= 5; i++) {\\\\\\\\\\\\\\\\n    this.changePaintOpacity(true);\\\\\\\\\\\\\\\\n    const sx = rect.x + halfWidth + (segment * (i - 1));\\\\\\\\\\\\\\\\n    this.contents.fillRect(sx, gy, segment, 12, color0);\\\\\\\\\\\\\\\\n    if (value >= i) this.contents.gradientFillRect(sx + 1, gy + 1, segment - 2, 10, color1, color2);\\\\\\\\\\\\\\\\n    this.changePaintOpacity(i === value);\\\\\\\\\\\\\\\\n    this.drawText(i, sx, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 5 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 1;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(1, 5);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(1, 5);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(1, 5);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 3;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(1, 5);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(1, 5);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"autoBattleAtStart\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"78\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.autoBattleStart;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_1_BattleCore && VisuMZ.BattleCore.Settings.AutoBattle.AddOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"autoBattleUseSkills\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"78\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.autoBattleStyle;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_1_BattleCore && VisuMZ.BattleCore.Settings.AutoBattle.AddOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = VisuMZ.BattleCore.Settings.AutoBattle.StyleOFF;\\\\\\\\\\\\\\\\nconst on  = VisuMZ.BattleCore.Settings.AutoBattle.StyleON;\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Screen\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"displayFPS\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"245\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Display FPS\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nif (!value) {\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._boxDiv.style.display = \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"block\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._showFps = true;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._boxDiv.style.display = \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"none\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._boxDiv.style.display = \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"block\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._showFps = true;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._boxDiv.style.display = \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"none\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\\nGraphics._fpsCounter._boxDiv.style.display = \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"none\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\\nif (config[symbol]) {\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._boxDiv.style.display = \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"block\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._showFps = true;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"fullScreen\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"245\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Full Screen\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Utils.isNwjs();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = !!Graphics._isFullScreen();\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'Window Mode';\\\\\\\\\\\\\\\\nconst on  = 'Full Screen';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = !!Graphics._isFullScreen();\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nGraphics._switchFullScreen();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = !!Graphics._isFullScreen();\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    Graphics._requestFullScreen();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = !!Graphics._isFullScreen();\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    Graphics._cancelFullScreen();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = !!Graphics._isFullScreen();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"stretchScreen\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"245\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Stretch Screen\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = !!Graphics._stretchEnabled;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = !!Graphics._isFullScreen();\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nGraphics._switchStretchMode();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = !!Graphics._stretchEnabled;\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    Graphics._stretchEnabled = true;\\\\\\\\\\\\\\\\n    Graphics._updateAllElements();\\\\\\\\\\\\\\\\n    Graphics._stretchScreenOptionsCore();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = !!Graphics._stretchEnabled;\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    Graphics._stretchEnabled = false;\\\\\\\\\\\\\\\\n    Graphics._updateAllElements();\\\\\\\\\\\\\\\\n    Graphics._stretchScreenOptionsCore();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = !!Graphics._stretchEnabled;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\\nif (ConfigManager[symbol]) {\\\\\\\\\\\\\\\\n    Graphics._stretchEnabled = true;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    Graphics._stretchEnabled = false;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nGraphics._updateAllElements();\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"specialEffects\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"87\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Special Effects\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_2_BrightEffects ||\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_HorrorEffects;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"dustCloud\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"160\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.MovementEffectsOptions.DustCloud;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_MovementEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.MovementEffects.Settings.Options.AddDustCloud\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"footprints\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"141\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.MovementEffectsOptions.Footprints;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_MovementEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.MovementEffects.Settings.Options.AddFootprints\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"smoothCamera\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"244\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.MovementEffectsOptions.SmoothCamera;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_MovementEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.MovementEffects.Settings.Options.AddSmoothCamera\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"blinkingLights\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"214\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.LightingEffectsOptions.BlinkingLights;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_LightingEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.LightingEffects.Settings.Options.AddBlinkingLights\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"pulsingLights\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"214\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.LightingEffectsOptions.PulsingLights;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_LightingEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.LightingEffects.Settings.Options.AddPulsingLights\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"weatherDensity\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"65\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.weatherDensity;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_WeatherEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.WeatherEffects.Settings.Options.AddWeatherDensityOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(4);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(0);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 100;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\"]\"}","{\"Name:str\":\"Audio\",\"Icon:num\":\"80\",\"ShowJS:func\":\"\\\"// Return Boolean\\\\nreturn true;\\\"\",\"List:arraystruct\":\"[\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Volume\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"masterVolume\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Master Volume\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(22);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(23);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    WebAudio.setMasterVolume(value / 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    WebAudio.setMasterVolume(value / 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    WebAudio.setMasterVolume(value / 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 100;\\\\\\\\\\\\\\\\nWebAudio.setMasterVolume(100 / 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\\nWebAudio.setMasterVolume(ConfigManager[symbol] / 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"bgmVolume\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.bgmVolume;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(26);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(27);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconsole.log((Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked()))\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 40;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"bgsVolume\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.bgsVolume;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(26);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(27);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 40;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"meVolume\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.meVolume;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(26);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(27);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 40;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"seVolume\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.seVolume;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(26);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(27);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 40;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"TF_AdvSoundOptions\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Advanced Sound Options\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.TFAdvancedSoundOptions;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nSoundManager.playOk();\\\\\\\\\\\\\\\\nSceneManager.push(Scene_TFAudioOptions);\\\\\\\\\\\\\\\\nthis.prepareOptionsCoreSceneChange();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nif (Imported.TFAdvancedSoundOptions) {\\\\\\\\\\\\\\\\n    config.freq1Gain = TF._audio_1Gain || 0;\\\\\\\\\\\\\\\\n    config.freq2Gain = TF._audio_2Gain || 0;\\\\\\\\\\\\\\\\n    config.freq3Gain = TF._audio_3Gain || 0;\\\\\\\\\\\\\\\\n    config.freq4Gain = TF._audio_4Gain || 0;\\\\\\\\\\\\\\\\n    config.freq5Gain = TF._audio_5Gain || 0;\\\\\\\\\\\\\\\\n    config.freq6Gain = TF._audio_6Gain || 0;\\\\\\\\\\\\\\\\n    config.freq7Gain = TF._audio_7Gain || 0;\\\\\\\\\\\\\\\\n    config.freq8Gain = TF._audio_8Gain || 0;\\\\\\\\\\\\\\\\n    config.freq9Gain = TF._audio_9Gain || 0;\\\\\\\\\\\\\\\\n    config.preset = TF._audio_preset || \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"Preset\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Sound Effects\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"footsteps\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"141\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.MovementEffectsOptions.Footsteps;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_MovementEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.MovementEffects.Settings.Options.AddSmoothCamera\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"msgLetterSound\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"189\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Letter Sounds\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_3_MessageSounds\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"seCursor\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"78\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Cursor SFX\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 1\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name1 = (value - 1) >= 0 ? 'Cursor %1'.format(value) : '-----';\\\\\\\\\\\\\\\\nconst fx1 = rect.x + halfWidth + (segment * 0);\\\\\\\\\\\\\\\\nthis.drawText(name1, fx1, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 2\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nconst name2 = 'Cursor %1'.format(value + 1);\\\\\\\\\\\\\\\\nconst fx2 = rect.x + halfWidth + (segment * 1);\\\\\\\\\\\\\\\\nthis.drawText(name2, fx2, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 3\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name3 = (value + 1) < SoundManager.cursorSFXs.length ? 'Cursor %1'.format(value + 2) : '-----';\\\\\\\\\\\\\\\\nconst fx3 = rect.x + halfWidth + (segment * 2);\\\\\\\\\\\\\\\\nthis.drawText(name3, fx3, rect.y, segment, 'center');\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.cursorSFXs.length - 1;\\\\\\\\\\\\\\\\nif (value >= length && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, length);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playCursor();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.cursorSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playCursor();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.cursorSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playCursor();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"seOK\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"78\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Confirm SFX\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 1\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name1 = (value - 1) >= 0 ? 'Confirm %1'.format(value) : '-----';\\\\\\\\\\\\\\\\nconst fx1 = rect.x + halfWidth + (segment * 0);\\\\\\\\\\\\\\\\nthis.drawText(name1, fx1, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 2\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nconst name2 = 'Confirm %1'.format(value + 1);\\\\\\\\\\\\\\\\nconst fx2 = rect.x + halfWidth + (segment * 1);\\\\\\\\\\\\\\\\nthis.drawText(name2, fx2, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 3\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name3 = (value + 1) < SoundManager.okSFXs.length ? 'Confirm %1'.format(value + 2) : '-----';\\\\\\\\\\\\\\\\nconst fx3 = rect.x + halfWidth + (segment * 2);\\\\\\\\\\\\\\\\nthis.drawText(name3, fx3, rect.y, segment, 'center');\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.okSFXs.length - 1;\\\\\\\\\\\\\\\\nif (value >= length && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, length);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playOk();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.okSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playOk();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.okSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playOk();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"seCancel\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"78\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Cancel SFX\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 1\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name1 = (value - 1) >= 0 ? 'Cancel %1'.format(value) : '-----';\\\\\\\\\\\\\\\\nconst fx1 = rect.x + halfWidth + (segment * 0);\\\\\\\\\\\\\\\\nthis.drawText(name1, fx1, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 2\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nconst name2 = 'Cancel %1'.format(value + 1);\\\\\\\\\\\\\\\\nconst fx2 = rect.x + halfWidth + (segment * 1);\\\\\\\\\\\\\\\\nthis.drawText(name2, fx2, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 3\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name3 = (value + 1) < SoundManager.cancelSFXs.length ? 'Cancel %1'.format(value + 2) : '-----';\\\\\\\\\\\\\\\\nconst fx3 = rect.x + halfWidth + (segment * 2);\\\\\\\\\\\\\\\\nthis.drawText(name3, fx3, rect.y, segment, 'center');\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.cancelSFXs.length - 1;\\\\\\\\\\\\\\\\nif (value >= length && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, length);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playCancel();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.cancelSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playCancel();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.cancelSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playCancel();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"seBuzzer\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"78\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Buzzer SFX\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 1\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name1 = (value - 1) >= 0 ? 'Buzzer %1'.format(value) : '-----';\\\\\\\\\\\\\\\\nconst fx1 = rect.x + halfWidth + (segment * 0);\\\\\\\\\\\\\\\\nthis.drawText(name1, fx1, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 2\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nconst name2 = 'Buzzer %1'.format(value + 1);\\\\\\\\\\\\\\\\nconst fx2 = rect.x + halfWidth + (segment * 1);\\\\\\\\\\\\\\\\nthis.drawText(name2, fx2, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 3\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name3 = (value + 1) < SoundManager.buzzerSFXs.length ? 'Buzzer %1'.format(value + 2) : '-----';\\\\\\\\\\\\\\\\nconst fx3 = rect.x + halfWidth + (segment * 2);\\\\\\\\\\\\\\\\nthis.drawText(name3, fx3, rect.y, segment, 'center');\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.buzzerSFXs.length - 1;\\\\\\\\\\\\\\\\nif (value >= length && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, length);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playBuzzer();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.buzzerSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playBuzzer();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.buzzerSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playBuzzer();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\"]\"}","{\"Name:str\":\"UI\",\"Icon:num\":\"79\",\"ShowJS:func\":\"\\\"// Return Boolean\\\\nreturn true;\\\"\",\"List:arraystruct\":\"[\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Windows\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"windowToneRed\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"162\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Window Tone: Red\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = $gameSystem.windowTone()[0];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = ((value + 255) / (255 * 2)).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(10);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(2);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = value;\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[0];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 255 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = -255;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\n    value = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[0] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[0];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\nvalue = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[0] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[0];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\nvalue = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[0] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"windowToneGreen\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"164\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Window Tone: Green\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = $gameSystem.windowTone()[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = ((value + 255) / (255 * 2)).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(11);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(3);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = value;\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[1];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 255 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = -255;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\n    value = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[1] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[1];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\nvalue = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[1] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[1];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\nvalue = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[1] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"windowToneBlue\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"165\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Window Tone: Blue\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = $gameSystem.windowTone()[2];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = ((value + 255) / (255 * 2)).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(12);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(4);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = value;\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[2];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 255 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = -255;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\n    value = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[2] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[2];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\nvalue = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[2] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[2];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\nvalue = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[2] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Text\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"textFont\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"225\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Text Font\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 1\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name1 = TextManager.optionsCoreFonts[value - 1] || '-----';\\\\\\\\\\\\\\\\nconst fx1 = rect.x + halfWidth + (segment * 0);\\\\\\\\\\\\\\\\nthis.drawText(name1, fx1, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 2\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nconst name2 = TextManager.optionsCoreFonts[value] || '-----';\\\\\\\\\\\\\\\\nconst fx2 = rect.x + halfWidth + (segment * 1);\\\\\\\\\\\\\\\\nthis.drawText(name2, fx2, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 3\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name3 = TextManager.optionsCoreFonts[value + 1] || '-----';\\\\\\\\\\\\\\\\nconst fx3 = rect.x + halfWidth + (segment * 2);\\\\\\\\\\\\\\\\nthis.drawText(name3, fx3, rect.y, segment, 'center');\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = TextManager.optionsCoreFonts.length - 1;\\\\\\\\\\\\\\\\nif (value >= length && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, length);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refreshWindows();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = TextManager.optionsCoreFonts.length - 1;\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refreshWindows();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = TextManager.optionsCoreFonts.length - 1;\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refreshWindows();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"textSpeed\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"225\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.messageCoreTextSpeed;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_1_MessageCore &&\\\\\\\\\\\\\\\\n    VisuMZ.MessageCore.Settings.TextSpeed.AddOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 10).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(value > 10 ? 20 : 28);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(value > 10 ? 21 : 29);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = this.textSpeedStatusText();\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 11 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 1;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(1, 11);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(1, 11);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(1, 11);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = VisuMZ.MessageCore ? VisuMZ.MessageCore.Settings.TextSpeed.Default : 10;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(1, 11);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(1, 11);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"textEffects\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"79\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.textEffects;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_AniMsgTextEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.AniMsgTextEffects.Settings.Options.AddOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Touch Input\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"touchUI\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"77\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.touchUI;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nif (Imported.VisuMZ_0_CoreEngine) {\\\\\\\\\\\\\\\\n    return !SceneManager.areButtonsHidden();\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    return true;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.updateButtonVisibility();\\\\\\\\\\\\\\\\nthis.updateWindowPositions();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.updateButtonVisibility();\\\\\\\\\\\\\\\\n    this.updateWindowPositions();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.updateButtonVisibility();\\\\\\\\\\\\\\\\n    this.updateWindowPositions();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"uiButtonPosition\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"77\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Button Position\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nif (Imported.VisuMZ_0_CoreEngine) {\\\\\\\\\\\\\\\\n    return !SceneManager.areButtonsHidden();\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    return true;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = '↑';\\\\\\\\\\\\\\\\nconst on  = '↓';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.updateButtonPositions();\\\\\\\\\\\\\\\\nthis.updateWindowPositions();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.updateButtonPositions();\\\\\\\\\\\\\\\\n    this.updateWindowPositions();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.updateButtonPositions();\\\\\\\\\\\\\\\\n    this.updateWindowPositions();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = uiDefault.ButtonPosition.call(this);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"uiHoverSelect\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"77\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Hover Select\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = uiDefault.hoverEnabled.call(this);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Menu Arrangement\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"uiMenuStyle\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"244\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Menu Style\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'Recommended';\\\\\\\\\\\\\\\\nconst on  = 'Custom';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.refresh();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"uiHelpPosition\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"244\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Help Window Position\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.uiMenuStyle;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(ConfigManager.uiMenuStyle);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = '↑';\\\\\\\\\\\\\\\\nconst on  = '↓';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(ConfigManager.uiMenuStyle && !value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(ConfigManager.uiMenuStyle && value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = uiDefault.HelpPosition.call(this);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"uiInputPosition\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"244\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Input Window Position\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.uiMenuStyle;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(ConfigManager.uiMenuStyle);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = '←';\\\\\\\\\\\\\\\\nconst on  = '→';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(ConfigManager.uiMenuStyle && !value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(ConfigManager.uiMenuStyle && value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = uiDefault.InputPosition.call(this);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Battle UI\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    (Imported.VisuMZ_2_AggroControlSystem && VisuMZ.AggroControlSystem.Settings.Provoke.AddOption) ||\\\\\\\\\\\\\\\\n    (Imported.VisuMZ_2_AggroControlSystem && VisuMZ.AggroControlSystem.Settings.Aggro.AddOption) ||\\\\\\\\\\\\\\\\n    (BattleManager.isTpb() && Imported.VisuMZ_3_VisualAtbGauge && VisuMZ.VisualAtbGauge.Settings.Options.AddOption) ||\\\\\\\\\\\\\\\\n    (Imported.VisuMZ_1_BattleCore && VisuMZ.BattleCore.Settings.HpGauge.AddHpGaugeOption) ||\\\\\\\\\\\\\\\\n  false);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"provokeOrigin\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.provokeOrigin;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_2_AggroControlSystem && VisuMZ.AggroControlSystem.Settings.Provoke.AddOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.refresh();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"aggroGauge\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.aggroGauge;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_2_AggroControlSystem && VisuMZ.AggroControlSystem.Settings.Aggro.AddOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.refresh();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"visualHpGauge\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"84\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.visualHpGauge;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_1_BattleCore && VisuMZ.BattleCore.Settings.HpGauge.AddHpGaugeOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.refresh();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"visualAtbGauge\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.visualAtbGauge;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn BattleManager.isTpb() && Imported.VisuMZ_2_BattleSystemATB && VisuMZ.BattleSystemATB.Settings.Options.AddOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.refresh();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    (Imported.VisuMZ_2_AggroControlSystem && VisuMZ.AggroControlSystem.Settings.Provoke.AddOption) ||\\\\\\\\\\\\\\\\n    (Imported.VisuMZ_2_AggroControlSystem && VisuMZ.AggroControlSystem.Settings.Aggro.AddOption) ||\\\\\\\\\\\\\\\\n    (BattleManager.isTpb() && Imported.VisuMZ_3_VisualAtbGauge && VisuMZ.VisualAtbGauge.Settings.Options.AddOption) ||\\\\\\\\\\\\\\\\n    (Imported.VisuMZ_1_BattleCore && VisuMZ.BattleCore.Settings.HpGauge.AddHpGaugeOption) ||\\\\\\\\\\\\\\\\n  false);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\"]\"}","{\"Name:str\":\"Playtest\",\"Icon:num\":\"84\",\"ShowJS:func\":\"\\\"// Return Boolean\\\\nreturn $gameTemp.isPlaytest();\\\"\",\"List:arraystruct\":\"[\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Effects\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistMode\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"87\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Playtest Effects\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.refresh();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Exploration\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistMapSpeed\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"82\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Map Update Speed\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 4;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Segments\\\\\\\\\\\\\\\\nconst speedText = ['Normal', 'Fast', 'Faster', 'Fastest'];\\\\\\\\\\\\\\\\nfor (let i = 0; i < 4; i++) {\\\\\\\\\\\\\\\\n    this.changePaintOpacity(i === value);\\\\\\\\\\\\\\\\n    const text = speedText[i];\\\\\\\\\\\\\\\\n    const sx = rect.x + halfWidth + (segment * i);\\\\\\\\\\\\\\\\n    this.drawText(text, sx, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 3 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 3);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 3);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 3);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 3);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 3);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistRandomEncounters\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"76\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Random Encounters\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Segments\\\\\\\\\\\\\\\\nconst speedText = ['None', 'Half', 'Normal'];\\\\\\\\\\\\\\\\nfor (let i = 0; i < 3; i++) {\\\\\\\\\\\\\\\\n    this.changePaintOpacity(i === value);\\\\\\\\\\\\\\\\n    const text = speedText[i];\\\\\\\\\\\\\\\\n    const sx = rect.x + halfWidth + (segment * i);\\\\\\\\\\\\\\\\n    this.drawText(text, sx, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 2 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 2);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 2);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 2);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 2;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 2);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 2);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Battle\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistGodmode\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"God Mode\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistResistNegatives\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Resist Negative Effects\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode && Imported.VisuMZ_1_SkillsStatesCore;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistInstantKO\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Instant K.O.\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistSkillCosts\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Skill Costs\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistConsumeItems\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Consume Items\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Rewards\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistExpMultiplier\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"88\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"EXP Multiplier\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 10).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(30);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(31);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = 'x%1'.format(2 ** value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 10 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 10);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 10);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 10);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 10);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 10);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistGoldMultiplier\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"314\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Gold Multiplier\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 10).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(14);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(6);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = 'x%1'.format(2 ** value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 10 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 10);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 10);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 10);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 10);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 10);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistDropMultiplier\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"176\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Drop Multiplier\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 10).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(11);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(3);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = 'x%1'.format(2 ** value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 10 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 10);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 10);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 10);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 10);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 10);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Spawners\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistSpawnItems\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"176\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Spawn Items\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Spawn Items\\\\\\\\\\\\\\\\nconst goods = [];\\\\\\\\\\\\\\\\nfor (const item of $dataItems) {\\\\\\\\\\\\\\\\n    if (item && item.name.trim() !== '') {\\\\\\\\\\\\\\\\n        goods.push([0, item.id, 1, 0]);\\\\\\\\\\\\\\\\n    }\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nSceneManager.push(Scene_Shop);\\\\\\\\\\\\\\\\nSceneManager.prepareNextScene(goods, true);\\\\\\\\\\\\\\\\nthis.prepareOptionsCoreSceneChange();\\\\\\\\\\\\\\\\nSoundManager.playOk();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistSpawnWeapons\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Spawn Weapons\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Spawn Items\\\\\\\\\\\\\\\\nconst goods = [];\\\\\\\\\\\\\\\\nfor (const item of $dataWeapons) {\\\\\\\\\\\\\\\\n    if (item && item.name.trim() !== '') {\\\\\\\\\\\\\\\\n        goods.push([1, item.id, 1, 0]);\\\\\\\\\\\\\\\\n    }\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nSceneManager.push(Scene_Shop);\\\\\\\\\\\\\\\\nSceneManager.prepareNextScene(goods, true);\\\\\\\\\\\\\\\\nthis.prepareOptionsCoreSceneChange();\\\\\\\\\\\\\\\\nSoundManager.playOk();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistSpawnArmors\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"137\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Spawn Armors\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Spawn Items\\\\\\\\\\\\\\\\nconst goods = [];\\\\\\\\\\\\\\\\nfor (const item of $dataArmors) {\\\\\\\\\\\\\\\\n    if (item && item.name.trim() !== '') {\\\\\\\\\\\\\\\\n        goods.push([2, item.id, 1, 0]);\\\\\\\\\\\\\\\\n    }\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nSceneManager.push(Scene_Shop);\\\\\\\\\\\\\\\\nSceneManager.prepareNextScene(goods, true);\\\\\\\\\\\\\\\\nthis.prepareOptionsCoreSceneChange();\\\\\\\\\\\\\\\\nSoundManager.playOk();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Debug\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistCallDebug\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"89\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Debug Menu\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Call Debug Menu\\\\\\\\\\\\\\\\nSceneManager.push(Scene_Debug);\\\\\\\\\\\\\\\\nthis.prepareOptionsCoreSceneChange();\\\\\\\\\\\\\\\\nSoundManager.playOk();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\"]\"}"]
 *
 * @param MasterVolShortcut:struct
 * @text Master Volume Shortcut
 * @type struct<MasterVolShortcut>
 * @desc Settings regarding the Master Volume Shortcut keys.
 * Shortcut: Ctrl + PageUp / Ctrl + PageDn
 * @default {"Shortcut":"","Enable:eval":"true","change:num":"10","Sfx":"","VolUpSfx":"","upName:str":"Up1","upVolume:num":"90","upPitch:num":"100","upPan:num":"0","VolDnSfx":"","downName:str":"Down1","downVolume:num":"90","downPitch:num":"100","downPan:num":"0"}
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
/* ----------------------------------------------------------------------------
 * Categories List
 * ----------------------------------------------------------------------------
 */
/*~struct~Categories:
 *
 * @param Name:str
 * @text Name
 * @desc The name of this category as seen in the Category Window.
 * Text codes are supported.
 * @default Untitled
 *
 * @param Icon:num
 * @text Icon
 * @parent Name:str
 * @desc Icon used for this category.
 * Use 0 for no icon.
 * @default 0
 *
 * @param ShowJS:func
 * @text JS: Show/Hide
 * @parent Name:str
 * @type note
 * @desc Code used to determine if this category is visible.
 * @default "// Return Boolean\nreturn true;"
 *
 * @param List:arraystruct
 * @text Options List
 * @type struct<Options>[]
 * @desc Add options to this category here.
 * @default []
 *
 */
/* ----------------------------------------------------------------------------
 * Options List
 * ----------------------------------------------------------------------------
 */
/*~struct~Options:
 *
 * @param Symbol:str
 * @text Symbol
 * @desc Symbol used for this option when selected.
 * Make sure this is unique from other symbols.
 * @default Symbol
 *
 * @param Icon:num
 * @text Icon
 * @parent Symbol:str
 * @desc Icon used for this option.
 * Use 0 for no icon.
 * @default 0
 *
 * @param TextStr:str
 * @text STR: Text
 * @parent Symbol:str
 * @desc Displayed text used for this option.
 * If this has a value, ignore the JS: Text version.
 * @default Untitled
 *
 * @param TextJS:func
 * @text JS: Text
 * @parent Symbol:str
 * @type note
 * @desc JavaScript code used to determine string used for the displayed name.
 * @default "return 'Text';"
 *
 * @param Accessibility
 *
 * @param ShowJS:func
 * @text JS: Show/Hide
 * @parent Accessibility
 * @type note
 * @desc Code used to determine if this option is visible.
 * @default "// Return Boolean\nreturn true;"
 *
 * @param EnableJS:func
 * @text JS: Enable
 * @parent Accessibility
 * @type note
 * @desc Code used to determine if this option is enabled.
 * @default "// Return Boolean\nreturn true;"
 *
 * @param ExtJS:func
 * @text JS: Ext
 * @parent Accessibility
 * @type note
 * @desc Code used to determine if this option's ext value.
 * @default "// Return Value\nreturn 0;"
 *
 * @param Functions
 *
 * @param DrawJS:func
 * @text JS: Draw Option
 * @parent Functions
 * @type note
 * @desc Code used to draw this item into the List Window.
 * @default "// Declare Constants\nconst symbol = arguments[0];\nconst index = arguments[1];\nconst title = this.commandName(index);\nconst rect = this.itemLineRect(index);\nconst quarterWidth = rect.width / 4;\nconst halfWidth = rect.width / 2;\nconst value = this.getConfigValue(symbol);\n\n// Draw Command Name\nthis.resetFontSettings();\nthis.changePaintOpacity(true);\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \"left\");\n\n// Draw Status Text\nconst off = 'OFF';\nconst on  = 'ON';\nthis.changePaintOpacity(!value);\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \"center\");\nthis.changePaintOpacity(value);\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \"center\");"
 *
 * @param ProcessOkJS:func
 * @text JS: Process OK
 * @parent Functions
 * @type note
 * @desc Code used when OK button is pressed while selected.
 * @default "// Declare Constants\nconst symbol = arguments[0];\nconst value = this.getConfigValue(symbol);\n\n// Perform Actions\nthis.setConfigValue(symbol, !value);\nthis.redrawItem(this.findSymbol(symbol));\nthis.playCursorSound();"
 *
 * @param CursorRightJS:func
 * @text JS: Cursor Right
 * @parent Functions
 * @type note
 * @desc Code used when Right button is pressed while selected.
 * @default "// Declare Constants\nconst symbol = arguments[0];\nconst value = this.getConfigValue(symbol);\nconst lastValue = value;\n\n// Perform Actions\nthis.setConfigValue(symbol, true);\nthis.redrawItem(this.findSymbol(symbol));\nif (this.getConfigValue(symbol) !== lastValue) {\n    this.playCursorSound();\n}"
 *
 * @param CursorLeftJS:func
 * @text JS: Cursor Left
 * @parent Functions
 * @type note
 * @desc Code used when Left button is pressed while selected.
 * @default "// Declare Constants\nconst symbol = arguments[0];\nconst value = this.getConfigValue(symbol);\nconst lastValue = value;\n\n// Perform Actions\nthis.setConfigValue(symbol, false);\nthis.redrawItem(this.findSymbol(symbol));\nif (this.getConfigValue(symbol) !== lastValue) {\n    this.playCursorSound();\n}"
 *
 * @param Data
 *
 * @param DefaultJS:func
 * @text JS: Default Value
 * @parent Data
 * @type note
 * @desc Code used to determine the default value of this option.
 * @default "// Declare Constants\nconst config = arguments[0];\nconst symbol = arguments[1];\n\n// Perform Actions\nConfigManager[symbol] = false;"
 *
 * @param SaveJS:func
 * @text JS: Save Option
 * @parent Data
 * @type note
 * @desc Code used when saving this options setting.
 * @default "// Declare Constants\nconst config = arguments[0];\nconst symbol = arguments[1];\n\n// Return Value\nconfig[symbol] = ConfigManager[symbol];"
 *
 * @param LoadJS:func
 * @text JS: Load Option
 * @parent Data
 * @type note
 * @desc Code used when loading this options setting.
 * @default "// Declare Constants\nconst config = arguments[0];\nconst symbol = arguments[1];\n\n// Return Value\nConfigManager[symbol] = config[symbol];"
 *
 */
/* ----------------------------------------------------------------------------
 * Options Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~OptionsSettings:
 *
 * @param Categories
 *
 * @param CategoryStyle:str
 * @text Category Window Style
 * @parent Categories
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands in the Category Window?
 * @default auto
 *
 * @param CategoryTextAlign:str
 * @text Category Text Align
 * @parent Categories
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Command Window.
 * @default center
 *
 * @param categoryWindowBgType:num
 * @text Background Type
 * @parent Categories
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param OptionsWindow
 * @text Options Window
 *
 * @param optionsWindowBgType:num
 * @text Background Type
 * @parent OptionsWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param ButtonAssist
 * @text Button Assist Window
 *
 * @param buttonAssistCategory:str
 * @text Switch Category
 * @parent ButtonAssist
 * @desc Button assist text used for switching categories.
 * For VisuStella MZ's Core Engine's Button Assist Window.
 * @default Switch Category
 *
 * @param buttonAssistBgType:num
 * @text Background Type
 * @parent ButtonAssist
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * Requires VisuMZ_0_CoreEngine!
 * @default 0
 *
 * @param Sound
 *
 * @param SFXCursorList:arraystr
 * @text Cursor Sounds
 * @parent Sound
 * @type file[]
 * @dir audio/se/
 * @desc SE files player can select from for cursor SE.
 * The first in the list will always be the default SE.
 * @default ["Default"]
 *
 * @param SFXOKList:arraystr
 * @text OK Sounds
 * @parent Sound
 * @type file[]
 * @dir audio/se/
 * @desc SE files player can select from for OK SE.
 * The first in the list will always be the default SE.
 * @default ["Default"]
 *
 * @param SFXCancelList:arraystr
 * @text Cancel Sounds
 * @parent Sound
 * @type file[]
 * @dir audio/se/
 * @desc SE files player can select from for cancel SE.
 * The first in the list will always be the default SE.
 * @default ["Default"]
 *
 * @param SFXBuzzerList:arraystr
 * @text Buzzer Sounds
 * @parent Sound
 * @type file[]
 * @dir audio/se/
 * @desc SE files player can select from for buzzer SE.
 * The first in the list will always be the default SE.
 * @default ["Default"]
 *
 * @param Text
 *
 * @param FontFaces:arraystr
 * @text Font Options
 * @parent Text
 * @type string[]
 * @desc Available fonts for the player to select from.
 * The first font in the list is always be the default font.
 * @default ["Default","Arial","Verdana","Times New Roman"]
 *
 */
/* ----------------------------------------------------------------------------
 * Master Volume Shortcut Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~MasterVolShortcut:
 * 
 * @param Shortcut
 *
 * @param Enable:eval
 * @text Enabled?
 * @parent Shortcut
 * @type boolean
 * @on Enable Shortcut
 * @off Disable Shortcut
 * @desc Enable the shortcut?
 * Shortcut: Ctrl + PageUp / Ctrl + PageDn
 * @default true
 *
 * @param change:num
 * @text Shortcut Change Value
 * @parent Shortcut
 * @type number
 * @min 1
 * @max 100
 * @desc What is the change amount for the shortcut key?
 * Master volume caps at 0 and 100.
 * @default 10
 * 
 * @param Sfx
 * @text Sound Effects
 * 
 * @param VolUpSfx
 * @text Volume Up
 * @parent Sfx
 *
 * @param upName:str
 * @text Filename
 * @parent VolUpSfx
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Up1
 *
 * @param upVolume:num
 * @text Volume
 * @parent VolUpSfx
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 90
 *
 * @param upPitch:num
 * @text Pitch
 * @parent VolUpSfx
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 100
 *
 * @param upPan:num
 * @text Pan
 * @parent VolUpSfx
 * @desc Pan of the sound effect played.
 * @default 0
 * 
 * @param VolDnSfx
 * @text Volume Down
 * @parent Sfx
 *
 * @param downName:str
 * @text Filename
 * @parent VolDnSfx
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Down1
 *
 * @param downVolume:num
 * @text Volume
 * @parent VolDnSfx
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 90
 *
 * @param downPitch:num
 * @text Pitch
 * @parent VolDnSfx
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 100
 *
 * @param downPan:num
 * @text Pan
 * @parent VolDnSfx
 * @desc Pan of the sound effect played.
 * @default 0
 *
 */
//=============================================================================

const _0xd7df0a=_0x11a5;(function(_0x3346ed,_0x2cbb2e){const _0x56db44=_0x11a5,_0x4ef798=_0x3346ed();while(!![]){try{const _0x55f87c=parseInt(_0x56db44(0x278))/0x1*(parseInt(_0x56db44(0x2de))/0x2)+-parseInt(_0x56db44(0x166))/0x3+-parseInt(_0x56db44(0x13a))/0x4*(-parseInt(_0x56db44(0x131))/0x5)+-parseInt(_0x56db44(0x251))/0x6+parseInt(_0x56db44(0x1be))/0x7+parseInt(_0x56db44(0x240))/0x8+-parseInt(_0x56db44(0x158))/0x9*(-parseInt(_0x56db44(0x254))/0xa);if(_0x55f87c===_0x2cbb2e)break;else _0x4ef798['push'](_0x4ef798['shift']());}catch(_0x5da9c0){_0x4ef798['push'](_0x4ef798['shift']());}}}(_0x357c,0x431a3));function _0x11a5(_0xecd7a7,_0x56468c){const _0x357c52=_0x357c();return _0x11a5=function(_0x11a5b0,_0x3dc4aa){_0x11a5b0=_0x11a5b0-0x102;let _0x2ac240=_0x357c52[_0x11a5b0];return _0x2ac240;},_0x11a5(_0xecd7a7,_0x56468c);}var label='OptionsCore',tier=tier||0x0,dependencies=[],pluginData=$plugins['filter'](function(_0x41ffb4){const _0x257f7b=_0x11a5;return _0x41ffb4['status']&&_0x41ffb4[_0x257f7b(0x264)][_0x257f7b(0x25d)]('['+label+']');})[0x0];VisuMZ[label][_0xd7df0a(0x1f0)]=VisuMZ[label][_0xd7df0a(0x1f0)]||{},VisuMZ[_0xd7df0a(0x260)]=function(_0x5aed33,_0x3c5ac0){const _0x2710c0=_0xd7df0a;for(const _0x219162 in _0x3c5ac0){if(_0x219162['match'](/(.*):(.*)/i)){const _0x1c4027=String(RegExp['$1']),_0x3ec22b=String(RegExp['$2'])[_0x2710c0(0x12d)]()[_0x2710c0(0x152)]();let _0x26bf97,_0x2cacbe,_0x1e23b;switch(_0x3ec22b){case _0x2710c0(0x134):_0x26bf97=_0x3c5ac0[_0x219162]!==''?Number(_0x3c5ac0[_0x219162]):0x0;break;case'ARRAYNUM':_0x2cacbe=_0x3c5ac0[_0x219162]!==''?JSON[_0x2710c0(0x1d2)](_0x3c5ac0[_0x219162]):[],_0x26bf97=_0x2cacbe[_0x2710c0(0x2d9)](_0x382fd2=>Number(_0x382fd2));break;case _0x2710c0(0x2b8):_0x26bf97=_0x3c5ac0[_0x219162]!==''?eval(_0x3c5ac0[_0x219162]):null;break;case _0x2710c0(0x1ba):_0x2cacbe=_0x3c5ac0[_0x219162]!==''?JSON[_0x2710c0(0x1d2)](_0x3c5ac0[_0x219162]):[],_0x26bf97=_0x2cacbe[_0x2710c0(0x2d9)](_0x52c6b8=>eval(_0x52c6b8));break;case _0x2710c0(0x23a):_0x26bf97=_0x3c5ac0[_0x219162]!==''?JSON[_0x2710c0(0x1d2)](_0x3c5ac0[_0x219162]):'';break;case _0x2710c0(0x1b2):_0x2cacbe=_0x3c5ac0[_0x219162]!==''?JSON[_0x2710c0(0x1d2)](_0x3c5ac0[_0x219162]):[],_0x26bf97=_0x2cacbe[_0x2710c0(0x2d9)](_0x183374=>JSON[_0x2710c0(0x1d2)](_0x183374));break;case _0x2710c0(0x1da):_0x26bf97=_0x3c5ac0[_0x219162]!==''?new Function(JSON['parse'](_0x3c5ac0[_0x219162])):new Function('return\x200');break;case _0x2710c0(0x22e):_0x2cacbe=_0x3c5ac0[_0x219162]!==''?JSON[_0x2710c0(0x1d2)](_0x3c5ac0[_0x219162]):[],_0x26bf97=_0x2cacbe[_0x2710c0(0x2d9)](_0xcb4d49=>new Function(JSON[_0x2710c0(0x1d2)](_0xcb4d49)));break;case'STR':_0x26bf97=_0x3c5ac0[_0x219162]!==''?String(_0x3c5ac0[_0x219162]):'';break;case _0x2710c0(0x2d1):_0x2cacbe=_0x3c5ac0[_0x219162]!==''?JSON[_0x2710c0(0x1d2)](_0x3c5ac0[_0x219162]):[],_0x26bf97=_0x2cacbe[_0x2710c0(0x2d9)](_0x1c694e=>String(_0x1c694e));break;case'STRUCT':_0x1e23b=_0x3c5ac0[_0x219162]!==''?JSON[_0x2710c0(0x1d2)](_0x3c5ac0[_0x219162]):{},_0x5aed33[_0x1c4027]={},VisuMZ[_0x2710c0(0x260)](_0x5aed33[_0x1c4027],_0x1e23b);continue;case'ARRAYSTRUCT':_0x2cacbe=_0x3c5ac0[_0x219162]!==''?JSON[_0x2710c0(0x1d2)](_0x3c5ac0[_0x219162]):[],_0x26bf97=_0x2cacbe[_0x2710c0(0x2d9)](_0x22fc72=>VisuMZ['ConvertParams']({},JSON[_0x2710c0(0x1d2)](_0x22fc72)));break;default:continue;}_0x5aed33[_0x1c4027]=_0x26bf97;}}return _0x5aed33;},(_0x2a6d57=>{const _0x123386=_0xd7df0a,_0x236e7f=_0x2a6d57[_0x123386(0x10a)];for(const _0x5005e4 of dependencies){if(!Imported[_0x5005e4]){alert('%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.'[_0x123386(0x235)](_0x236e7f,_0x5005e4)),SceneManager['exit']();break;}}const _0x96783b=_0x2a6d57['description'];if(_0x96783b[_0x123386(0x20f)](/\[Version[ ](.*?)\]/i)){if(_0x123386(0x190)!==_0x123386(0x190)){if(_0x138cdf['inBattle']()&&_0x4734de&&_0x21c792[_0x123386(0x2b5)]!==_0x3a02a8)return _0x1dde8d[_0x123386(0x2b5)]>=0x1;return!![];}else{const _0x2b4760=Number(RegExp['$1']);_0x2b4760!==VisuMZ[label][_0x123386(0x196)]&&(_0x123386(0x1b9)!=='gOHWh'?this[_0x123386(0x10c)][_0x2e63da][_0x123386(0x1fb)][_0x123386(0x209)](this,_0x8b4436,_0x223001):(alert(_0x123386(0x1c3)['format'](_0x236e7f,_0x2b4760)),SceneManager[_0x123386(0x1d0)]()));}}if(_0x96783b[_0x123386(0x20f)](/\[Tier[ ](\d+)\]/i)){const _0x14519a=Number(RegExp['$1']);if(_0x14519a<tier){if('wxgHb'!==_0x123386(0x26e))return _0x417074[_0x123386(0x256)];else alert(_0x123386(0x197)[_0x123386(0x235)](_0x236e7f,_0x14519a,tier)),SceneManager[_0x123386(0x1d0)]();}else'jRTbK'!=='jRTbK'?(_0xc27efb[_0x123386(0x267)]['Graphics_requestFullScreen'][_0x123386(0x209)](this),this['_fullScreenOptionsCore']()):tier=Math[_0x123386(0x217)](_0x14519a,tier);}VisuMZ[_0x123386(0x260)](VisuMZ[label]['Settings'],_0x2a6d57[_0x123386(0x226)]);})(pluginData),VisuMZ[_0xd7df0a(0x267)]['Scene_Boot_onDatabaseLoaded']=Scene_Boot['prototype'][_0xd7df0a(0x1ec)],Scene_Boot[_0xd7df0a(0x1bc)][_0xd7df0a(0x1ec)]=function(){const _0x4c62a3=_0xd7df0a;this[_0x4c62a3(0x239)](),VisuMZ['OptionsCore']['Scene_Boot_onDatabaseLoaded'][_0x4c62a3(0x209)](this),SoundManager[_0x4c62a3(0x20b)](),this['process_VisuMZ_OptionsCore_Failsafe'](),!Utils[_0x4c62a3(0x27a)](_0x4c62a3(0x188))&&(_0x4c62a3(0x23b)!==_0x4c62a3(0x23b)?_0x1429bd[_0x4c62a3(0x124)][_0x4c62a3(0x186)]():ConfigManager[_0x4c62a3(0x19b)]=![]);},Scene_Boot[_0xd7df0a(0x1bc)][_0xd7df0a(0x239)]=function(){const _0x414ca8=_0xd7df0a,_0x4d0679=['alwaysDash',_0x414ca8(0x1f2),'touchUI',_0x414ca8(0x18e),_0x414ca8(0x1b5),_0x414ca8(0x2c5),_0x414ca8(0x1b0)];for(const _0x12ded9 of VisuMZ[_0x414ca8(0x267)][_0x414ca8(0x1f0)][_0x414ca8(0x2a2)]){for(const _0x35e4f1 of _0x12ded9[_0x414ca8(0x23d)]){if(!_0x35e4f1)continue;const _0x28711c=_0x35e4f1[_0x414ca8(0x17a)];if(!_0x28711c)continue;if(_0x4d0679[_0x414ca8(0x25d)](_0x28711c))ConfigManager[_0x28711c]=undefined;_0x35e4f1['DefaultJS'][_0x414ca8(0x209)](this,ConfigManager,_0x28711c);}}},Scene_Boot[_0xd7df0a(0x1bc)]['process_VisuMZ_OptionsCore_Failsafe']=function(){const _0x1f52e9=_0xd7df0a;if(VisuMZ[_0x1f52e9(0x267)][_0x1f52e9(0x14d)]())return;const _0x24a696=_0x1f52e9(0x178),_0x29c3ce=[0x3,0x8,0x5,0x1,0x14,0x13],_0x2fea31=_0x29c3ce[_0x1f52e9(0x1b6)]((_0x516142,_0xc81907)=>_0x516142+_0x24a696[_0xc81907],''),_0xe401e2={'Name:str':_0x2fea31,'Icon:num':'7','ShowJS:func':'\x22//\x20Return\x20Boolean\x5cnreturn\x20!$gameTemp.isPlaytest()\x20&&\x20ConfigManager.assistMode;\x22','List:arraystruct':'[\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22\x5c\x5c\x5c\x5cC[16]Effects\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistMode\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2287\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Playtest\x20Effects\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Status\x20Text\x5c\x5c\x5c\x5cnconst\x20off\x20=\x20\x27OFF\x27;\x5c\x5c\x5c\x5cnconst\x20on\x20\x20=\x20\x27ON\x27;\x5c\x5c\x5c\x5cnthis.changePaintOpacity(!value);\x5c\x5c\x5c\x5cnthis.drawText(off,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cnthis.changePaintOpacity(value);\x5c\x5c\x5c\x5cnthis.drawText(on,\x20rect.x\x20+\x20halfWidth\x20+\x20quarterWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20!value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnthis.playCursorSound();\x5c\x5c\x5c\x5cnthis.refresh();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20true);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.refresh();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20false);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.refresh();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20false;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol];\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol];\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22-----------------------------\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Untitled\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22\x5c\x5c\x5c\x5cC[16]Exploration\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistMapSpeed\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2282\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Map\x20Update\x20Speed\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20segment\x20=\x20halfWidth\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Segments\x5c\x5c\x5c\x5cnconst\x20speedText\x20=\x20[\x27Normal\x27,\x20\x27Fast\x27,\x20\x27Faster\x27,\x20\x27Fastest\x27];\x5c\x5c\x5c\x5cnfor\x20(let\x20i\x20=\x200;\x20i\x20<\x204;\x20i++)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.changePaintOpacity(i\x20===\x20value);\x5c\x5c\x5c\x5cn\x20\x20\x20\x20const\x20text\x20=\x20speedText[i];\x5c\x5c\x5c\x5cn\x20\x20\x20\x20const\x20sx\x20=\x20rect.x\x20+\x20halfWidth\x20+\x20(segment\x20*\x20i);\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.drawText(text,\x20sx,\x20rect.y,\x20segment,\x20\x27center\x27);\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnif\x20(value\x20>=\x203\x20&&\x20(Input.isTriggered(\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22ok\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22)\x20||\x20TouchInput.isClicked()))\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x200;\x5c\x5c\x5c\x5cn}\x20else\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20+=\x201;\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x20value.clamp(0,\x203);\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20+=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x203);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20-=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x203);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol].clamp(0,\x203);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol].clamp(0,\x203);\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistRandomEncounters\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2276\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Random\x20Encounters\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20segment\x20=\x20halfWidth\x20/\x203;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Segments\x5c\x5c\x5c\x5cnconst\x20speedText\x20=\x20[\x27None\x27,\x20\x27Half\x27,\x20\x27Normal\x27];\x5c\x5c\x5c\x5cnfor\x20(let\x20i\x20=\x200;\x20i\x20<\x203;\x20i++)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.changePaintOpacity(i\x20===\x20value);\x5c\x5c\x5c\x5cn\x20\x20\x20\x20const\x20text\x20=\x20speedText[i];\x5c\x5c\x5c\x5cn\x20\x20\x20\x20const\x20sx\x20=\x20rect.x\x20+\x20halfWidth\x20+\x20(segment\x20*\x20i);\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.drawText(text,\x20sx,\x20rect.y,\x20segment,\x20\x27center\x27);\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnif\x20(value\x20>=\x202\x20&&\x20(Input.isTriggered(\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22ok\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22)\x20||\x20TouchInput.isClicked()))\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x200;\x5c\x5c\x5c\x5cn}\x20else\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20+=\x201;\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x20value.clamp(0,\x202);\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20+=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x202);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20-=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x202);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x202;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol].clamp(0,\x202);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol].clamp(0,\x202);\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22-----------------------------\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Untitled\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22\x5c\x5c\x5c\x5cC[16]Battle\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistGodmode\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2297\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22God\x20Mode\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Status\x20Text\x5c\x5c\x5c\x5cnconst\x20off\x20=\x20\x27OFF\x27;\x5c\x5c\x5c\x5cnconst\x20on\x20\x20=\x20\x27ON\x27;\x5c\x5c\x5c\x5cnthis.changePaintOpacity(!value);\x5c\x5c\x5c\x5cnthis.drawText(off,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cnthis.changePaintOpacity(value);\x5c\x5c\x5c\x5cnthis.drawText(on,\x20rect.x\x20+\x20halfWidth\x20+\x20quarterWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20!value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnthis.playCursorSound();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20true);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20false);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20false;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol];\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol];\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistResistNegatives\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2297\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Resist\x20Negative\x20Effects\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode\x20&&\x20Imported.VisuMZ_1_SkillsStatesCore;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Status\x20Text\x5c\x5c\x5c\x5cnconst\x20off\x20=\x20\x27OFF\x27;\x5c\x5c\x5c\x5cnconst\x20on\x20\x20=\x20\x27ON\x27;\x5c\x5c\x5c\x5cnthis.changePaintOpacity(!value);\x5c\x5c\x5c\x5cnthis.drawText(off,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cnthis.changePaintOpacity(value);\x5c\x5c\x5c\x5cnthis.drawText(on,\x20rect.x\x20+\x20halfWidth\x20+\x20quarterWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20!value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnthis.playCursorSound();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20true);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20false);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20false;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol];\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol];\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistInstantKO\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2297\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Instant\x20K.O.\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Status\x20Text\x5c\x5c\x5c\x5cnconst\x20off\x20=\x20\x27OFF\x27;\x5c\x5c\x5c\x5cnconst\x20on\x20\x20=\x20\x27ON\x27;\x5c\x5c\x5c\x5cnthis.changePaintOpacity(!value);\x5c\x5c\x5c\x5cnthis.drawText(off,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cnthis.changePaintOpacity(value);\x5c\x5c\x5c\x5cnthis.drawText(on,\x20rect.x\x20+\x20halfWidth\x20+\x20quarterWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20!value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnthis.playCursorSound();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20true);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20false);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20false;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol];\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol];\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistSkillCosts\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2297\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Skill\x20Costs\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Status\x20Text\x5c\x5c\x5c\x5cnconst\x20off\x20=\x20\x27OFF\x27;\x5c\x5c\x5c\x5cnconst\x20on\x20\x20=\x20\x27ON\x27;\x5c\x5c\x5c\x5cnthis.changePaintOpacity(!value);\x5c\x5c\x5c\x5cnthis.drawText(off,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cnthis.changePaintOpacity(value);\x5c\x5c\x5c\x5cnthis.drawText(on,\x20rect.x\x20+\x20halfWidth\x20+\x20quarterWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20!value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnthis.playCursorSound();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20true);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20false);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol];\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol];\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistConsumeItems\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2297\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Consume\x20Items\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Status\x20Text\x5c\x5c\x5c\x5cnconst\x20off\x20=\x20\x27OFF\x27;\x5c\x5c\x5c\x5cnconst\x20on\x20\x20=\x20\x27ON\x27;\x5c\x5c\x5c\x5cnthis.changePaintOpacity(!value);\x5c\x5c\x5c\x5cnthis.drawText(off,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cnthis.changePaintOpacity(value);\x5c\x5c\x5c\x5cnthis.drawText(on,\x20rect.x\x20+\x20halfWidth\x20+\x20quarterWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20!value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnthis.playCursorSound();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20true);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20false);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol];\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol];\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22-----------------------------\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Untitled\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22\x5c\x5c\x5c\x5cC[16]Rewards\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistExpMultiplier\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2288\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22EXP\x20Multiplier\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Gauge\x5c\x5c\x5c\x5cnconst\x20rate\x20=\x20(value\x20/\x2010).clamp(0,\x201);\x5c\x5c\x5c\x5cnconst\x20gx\x20=\x20rect.x\x20+\x20halfWidth;\x5c\x5c\x5c\x5cnconst\x20gy\x20=\x20rect.y\x20+\x20rect.height\x20-\x2014;\x5c\x5c\x5c\x5cnconst\x20fillW\x20=\x20Math.floor((halfWidth\x20-\x202)\x20*\x20rate);\x5c\x5c\x5c\x5cnconst\x20color0\x20=\x20ColorManager.gaugeBackColor();\x5c\x5c\x5c\x5cnconst\x20color1\x20=\x20ColorManager.textColor(30);\x5c\x5c\x5c\x5cnconst\x20color2\x20=\x20ColorManager.textColor(31);\x5c\x5c\x5c\x5cnthis.contents.fillRect(gx,\x20gy,\x20halfWidth,\x2012,\x20color0);\x5c\x5c\x5c\x5cnthis.contents.gradientFillRect(gx\x20+\x201,\x20gy\x20+\x201,\x20fillW,\x2010,\x20color1,\x20color2);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Value\x5c\x5c\x5c\x5cnconst\x20text\x20=\x20\x27x%1\x27.format(2\x20**\x20value);\x5c\x5c\x5c\x5cnthis.drawText(text,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnif\x20(value\x20>=\x2010\x20&&\x20(Input.isTriggered(\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22ok\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22)\x20||\x20TouchInput.isClicked()))\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x200;\x5c\x5c\x5c\x5cn}\x20else\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20+=\x201;\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20+=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20-=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol].clamp(0,\x2010);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol].clamp(0,\x2010);\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistGoldMultiplier\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x22314\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Gold\x20Multiplier\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Gauge\x5c\x5c\x5c\x5cnconst\x20rate\x20=\x20(value\x20/\x2010).clamp(0,\x201);\x5c\x5c\x5c\x5cnconst\x20gx\x20=\x20rect.x\x20+\x20halfWidth;\x5c\x5c\x5c\x5cnconst\x20gy\x20=\x20rect.y\x20+\x20rect.height\x20-\x2014;\x5c\x5c\x5c\x5cnconst\x20fillW\x20=\x20Math.floor((halfWidth\x20-\x202)\x20*\x20rate);\x5c\x5c\x5c\x5cnconst\x20color0\x20=\x20ColorManager.gaugeBackColor();\x5c\x5c\x5c\x5cnconst\x20color1\x20=\x20ColorManager.textColor(14);\x5c\x5c\x5c\x5cnconst\x20color2\x20=\x20ColorManager.textColor(6);\x5c\x5c\x5c\x5cnthis.contents.fillRect(gx,\x20gy,\x20halfWidth,\x2012,\x20color0);\x5c\x5c\x5c\x5cnthis.contents.gradientFillRect(gx\x20+\x201,\x20gy\x20+\x201,\x20fillW,\x2010,\x20color1,\x20color2);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Value\x5c\x5c\x5c\x5cnconst\x20text\x20=\x20\x27x%1\x27.format(2\x20**\x20value);\x5c\x5c\x5c\x5cnthis.drawText(text,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnif\x20(value\x20>=\x2010\x20&&\x20(Input.isTriggered(\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22ok\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22)\x20||\x20TouchInput.isClicked()))\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x200;\x5c\x5c\x5c\x5cn}\x20else\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20+=\x201;\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20+=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20-=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol].clamp(0,\x2010);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol].clamp(0,\x2010);\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistDropMultiplier\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x22176\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Drop\x20Multiplier\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Gauge\x5c\x5c\x5c\x5cnconst\x20rate\x20=\x20(value\x20/\x2010).clamp(0,\x201);\x5c\x5c\x5c\x5cnconst\x20gx\x20=\x20rect.x\x20+\x20halfWidth;\x5c\x5c\x5c\x5cnconst\x20gy\x20=\x20rect.y\x20+\x20rect.height\x20-\x2014;\x5c\x5c\x5c\x5cnconst\x20fillW\x20=\x20Math.floor((halfWidth\x20-\x202)\x20*\x20rate);\x5c\x5c\x5c\x5cnconst\x20color0\x20=\x20ColorManager.gaugeBackColor();\x5c\x5c\x5c\x5cnconst\x20color1\x20=\x20ColorManager.textColor(11);\x5c\x5c\x5c\x5cnconst\x20color2\x20=\x20ColorManager.textColor(3);\x5c\x5c\x5c\x5cnthis.contents.fillRect(gx,\x20gy,\x20halfWidth,\x2012,\x20color0);\x5c\x5c\x5c\x5cnthis.contents.gradientFillRect(gx\x20+\x201,\x20gy\x20+\x201,\x20fillW,\x2010,\x20color1,\x20color2);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Value\x5c\x5c\x5c\x5cnconst\x20text\x20=\x20\x27x%1\x27.format(2\x20**\x20value);\x5c\x5c\x5c\x5cnthis.drawText(text,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnif\x20(value\x20>=\x2010\x20&&\x20(Input.isTriggered(\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22ok\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22)\x20||\x20TouchInput.isClicked()))\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x200;\x5c\x5c\x5c\x5cn}\x20else\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20+=\x201;\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20+=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20-=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol].clamp(0,\x2010);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol].clamp(0,\x2010);\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22-----------------------------\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Untitled\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22\x5c\x5c\x5c\x5cC[16]Spawners\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistSpawnItems\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x22176\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Spawn\x20Items\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Spawn\x20Items\x5c\x5c\x5c\x5cnconst\x20goods\x20=\x20[];\x5c\x5c\x5c\x5cnfor\x20(const\x20item\x20of\x20$dataItems)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20if\x20(item\x20&&\x20item.name.trim()\x20!==\x20\x27\x27)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20\x20\x20\x20\x20goods.push([0,\x20item.id,\x201,\x200]);\x5c\x5c\x5c\x5cn\x20\x20\x20\x20}\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnSceneManager.push(Scene_Shop);\x5c\x5c\x5c\x5cnSceneManager.prepareNextScene(goods,\x20true);\x5c\x5c\x5c\x5cnthis.prepareOptionsCoreSceneChange();\x5c\x5c\x5c\x5cnSoundManager.playOk();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistSpawnWeapons\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2297\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Spawn\x20Weapons\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Spawn\x20Items\x5c\x5c\x5c\x5cnconst\x20goods\x20=\x20[];\x5c\x5c\x5c\x5cnfor\x20(const\x20item\x20of\x20$dataWeapons)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20if\x20(item\x20&&\x20item.name.trim()\x20!==\x20\x27\x27)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20\x20\x20\x20\x20goods.push([1,\x20item.id,\x201,\x200]);\x5c\x5c\x5c\x5cn\x20\x20\x20\x20}\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnSceneManager.push(Scene_Shop);\x5c\x5c\x5c\x5cnSceneManager.prepareNextScene(goods,\x20true);\x5c\x5c\x5c\x5cnthis.prepareOptionsCoreSceneChange();\x5c\x5c\x5c\x5cnSoundManager.playOk();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistSpawnArmors\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x22137\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Spawn\x20Armors\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Spawn\x20Items\x5c\x5c\x5c\x5cnconst\x20goods\x20=\x20[];\x5c\x5c\x5c\x5cnfor\x20(const\x20item\x20of\x20$dataArmors)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20if\x20(item\x20&&\x20item.name.trim()\x20!==\x20\x27\x27)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20\x20\x20\x20\x20goods.push([2,\x20item.id,\x201,\x200]);\x5c\x5c\x5c\x5cn\x20\x20\x20\x20}\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnSceneManager.push(Scene_Shop);\x5c\x5c\x5c\x5cnSceneManager.prepareNextScene(goods,\x20true);\x5c\x5c\x5c\x5cnthis.prepareOptionsCoreSceneChange();\x5c\x5c\x5c\x5cnSoundManager.playOk();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22-----------------------------\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Untitled\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22\x5c\x5c\x5c\x5cC[16]Debug\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistCallDebug\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2289\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Debug\x20Menu\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Call\x20Debug\x20Menu\x5c\x5c\x5c\x5cnSceneManager.push(Scene_Debug);\x5c\x5c\x5c\x5cnthis.prepareOptionsCoreSceneChange();\x5c\x5c\x5c\x5cnSoundManager.playOk();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22-----------------------------\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Untitled\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22]'};Window_OptionsCategory[_0x1f52e9(0x21b)][_0x1f52e9(0x1ab)](VisuMZ[_0x1f52e9(0x260)](_0xe401e2,_0xe401e2));},VisuMZ[_0xd7df0a(0x267)]['CheckAmPresent']=function(){const _0x3f8863=_0xd7df0a,_0x3a72d5='0abCdefghijklmnopqrstuvwxyz',_0x1f5a84=[0x1,0x13,0x13,0x9,0x13,0x14,0xd,0xf,0x4,0x5],_0x120848=_0x1f5a84[_0x3f8863(0x1b6)]((_0x128665,_0x2be196)=>_0x128665+_0x3a72d5[_0x2be196],'');for(const _0x48f09a of Window_OptionsCategory[_0x3f8863(0x21b)]){if(_0x3f8863(0x1ac)===_0x3f8863(0x2c4)){if(_0xf50d89&&_0x2c7451[_0x3f8863(0x261)]!==_0x3987cb){if(_0x1060ae[_0x3f8863(0x261)]>0x0){const _0x3cb26d=_0x380893[_0x3f8863(0x1b1)][_0x55c965['seBuzzer']];if(_0x3cb26d)return _0x228abb[_0x3f8863(0x18f)](_0x3cb26d);}}_0x4e8ff1[_0x3f8863(0x267)][_0x3f8863(0x287)][_0x3f8863(0x209)](this);}else{if(!_0x48f09a)continue;for(const _0x56179a of _0x48f09a[_0x3f8863(0x23d)]){if('LHzfy'===_0x3f8863(0x2c6)){if(_0x1eee00&&_0x190088[_0x3f8863(0x22d)]!==_0x232660){if(_0x2471a1[_0x3f8863(0x22d)]>0x0){const _0x3686a3=_0x3f94bc[_0x3f8863(0x262)][_0x274943['seOK']];if(_0x3686a3)return _0xcfd96b['playStaticSe'](_0x3686a3);}}_0x40bab2[_0x3f8863(0x267)]['SoundManager_playOk']['call'](this);}else{if(!_0x56179a)continue;if(_0x56179a['Symbol'][_0x3f8863(0x13f)]()['trim']()===_0x120848)return!![];}}}}return![];},VisuMZ['OptionsCore']['ConfigManager_save']=ConfigManager['save'],ConfigManager['save']=function(){const _0x52dfde=_0xd7df0a;if(this[_0x52dfde(0x2d0)]||this[_0x52dfde(0x1d6)])return;VisuMZ[_0x52dfde(0x267)]['ConfigManager_save'][_0x52dfde(0x209)](this);},VisuMZ['OptionsCore'][_0xd7df0a(0x1dc)]=ConfigManager[_0xd7df0a(0x230)],ConfigManager[_0xd7df0a(0x230)]=function(){const _0x3800b4=_0xd7df0a;let _0x4cae39=VisuMZ[_0x3800b4(0x267)]['ConfigManager_makeData'][_0x3800b4(0x209)](this);;return _0x4cae39=this[_0x3800b4(0x2df)](_0x4cae39),!Utils[_0x3800b4(0x27a)](_0x3800b4(0x188))&&('OlUvy'===_0x3800b4(0x2a4)?_0x4cae39[_0x3800b4(0x19b)]=![]:_0x378f65[_0x3800b4(0x237)]=!![]),_0x4cae39;},ConfigManager[_0xd7df0a(0x2df)]=function(_0x24bc81){const _0x3ec295=_0xd7df0a;this[_0x3ec295(0x2d0)]=!![];for(const _0x2ffc05 of Window_OptionsCategory[_0x3ec295(0x21b)]){if(_0x3ec295(0x16b)!==_0x3ec295(0x258))for(const _0x29bd1c of _0x2ffc05[_0x3ec295(0x23d)]){if(!_0x29bd1c)continue;const _0x38fc08=_0x29bd1c[_0x3ec295(0x17a)];if(!_0x38fc08)continue;if(ConfigManager[_0x38fc08]===undefined){if(_0x3ec295(0x213)===_0x3ec295(0x210))return _0x5d5ee4[_0x3ec295(0x248)];else _0x29bd1c[_0x3ec295(0x1d1)][_0x3ec295(0x209)](this,_0x24bc81,_0x38fc08);}_0x29bd1c['SaveJS'][_0x3ec295(0x209)](this,_0x24bc81,_0x38fc08);}else{const _0x1d9e3b=_0x5040e5['cursorSFXs'][_0x11e90d[_0x3ec295(0x23c)]];if(_0x1d9e3b)return _0x5e189f['playStaticSe'](_0x1d9e3b);}}return this[_0x3ec295(0x2d0)]=![],_0x24bc81;},VisuMZ[_0xd7df0a(0x267)]['ConfigManager_applyData']=ConfigManager['applyData'],ConfigManager['applyData']=function(_0x3d7da1){const _0x310e7c=_0xd7df0a;VisuMZ[_0x310e7c(0x267)]['ConfigManager_applyData'][_0x310e7c(0x209)](this,_0x3d7da1),this[_0x310e7c(0x207)](_0x3d7da1);},ConfigManager['applyDataOptionsCore']=function(_0x14d4bb){const _0x53badd=_0xd7df0a;this[_0x53badd(0x1d6)]=!![];for(const _0x3e4878 of Window_OptionsCategory[_0x53badd(0x21b)]){if(_0x53badd(0x249)!=='KNhug'){if(_0x3bf3f6)_0x3f9201['setBackgroundType'](_0x186e8e);}else for(const _0x20db73 of _0x3e4878['List']){if(!_0x20db73)continue;const _0x5a1d40=_0x20db73[_0x53badd(0x17a)];if(!_0x5a1d40)continue;if(_0x14d4bb[_0x5a1d40]===undefined){if(_0x53badd(0x159)===_0x53badd(0x14c))return _0x300921;else _0x20db73[_0x53badd(0x1d1)]['call'](this,_0x14d4bb,_0x5a1d40);}else _0x20db73[_0x53badd(0x246)]['call'](this,_0x14d4bb,_0x5a1d40);}}this[_0x53badd(0x1d6)]=![];},Graphics['_isFPSCounterOn']=function(){const _0xb6016c=_0xd7df0a;return this[_0xb6016c(0x1f5)]&&this[_0xb6016c(0x1f5)][_0xb6016c(0x29e)][_0xb6016c(0x12f)][_0xb6016c(0x140)]!=='none';},VisuMZ['OptionsCore'][_0xd7df0a(0x23f)]=Graphics['FPSCounter'][_0xd7df0a(0x1bc)]['switchMode'],Graphics['FPSCounter']['prototype']['switchMode']=function(){const _0xdbeb51=_0xd7df0a;VisuMZ[_0xdbeb51(0x267)]['Graphics_FPSCounter_switchMode'][_0xdbeb51(0x209)](this),this[_0xdbeb51(0x150)]();},Graphics['FPSCounter']['prototype'][_0xd7df0a(0x150)]=function(){const _0x486214=_0xd7df0a;if(ConfigManager&&ConfigManager[_0x486214(0x1e2)]!==undefined){if(_0x486214(0x171)!==_0x486214(0x171)){const _0x593d52=this[_0x486214(0x1e1)](),_0x578b26=this[_0x486214(0x1bd)](_0x593d52);if(!this['isCommandEnabled'](_0x593d52)){this['playBuzzerSound']();return;}try{this['_dataFunc'][_0x593d52]['CursorLeftJS']['call'](this,_0x578b26,_0x593d52);}catch(_0x403ba5){_0xc8e69c['OptionsCore']['Window_Options_cursorLeft'][_0x486214(0x209)](this);}}else ConfigManager[_0x486214(0x1e2)]=Graphics[_0x486214(0x1a6)](),ConfigManager[_0x486214(0x2c1)]();}if(SceneManager&&SceneManager[_0x486214(0x124)]){if(_0x486214(0x11b)===_0x486214(0x200))this[_0x486214(0x1eb)][_0x486214(0x24d)](),this[_0x486214(0x1eb)]['refreshCursor']();else{const _0xaf34d2=SceneManager[_0x486214(0x124)];_0xaf34d2[_0x486214(0x156)](),_0xaf34d2['constructor']===Scene_Options&&(_0x486214(0x2a7)==='Omieg'?_0xaf34d2[_0x486214(0x1c5)]():this[_0x486214(0x10c)][_0x1cd28c][_0x486214(0x180)]['call'](this,_0x38ed71,_0x5dd6b9));}}},VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x12c)]=Scene_Boot[_0xd7df0a(0x1bc)]['start'],Scene_Boot[_0xd7df0a(0x1bc)]['start']=function(){const _0x4838b6=_0xd7df0a;VisuMZ[_0x4838b6(0x267)][_0x4838b6(0x12c)][_0x4838b6(0x209)](this);if(ConfigManager&&ConfigManager[_0x4838b6(0x237)]){if(_0x4838b6(0x123)===_0x4838b6(0x174)){this[_0x4838b6(0x266)]();return;}else Graphics[_0x4838b6(0x1f9)]();}},VisuMZ[_0xd7df0a(0x267)]['Graphics_switchFullScreen']=Graphics[_0xd7df0a(0x2e4)],Graphics[_0xd7df0a(0x2e4)]=function(){const _0x25f821=_0xd7df0a;this[_0x25f821(0x1f7)]()?ConfigManager['fullScreen']=![]:ConfigManager[_0x25f821(0x237)]=!![],ConfigManager[_0x25f821(0x2c1)](),VisuMZ[_0x25f821(0x267)][_0x25f821(0x108)][_0x25f821(0x209)](this),Graphics[_0x25f821(0x141)]();},VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x1fa)]=Graphics[_0xd7df0a(0x1f9)],Graphics['_requestFullScreen']=function(){const _0x15dfac=_0xd7df0a;VisuMZ[_0x15dfac(0x267)][_0x15dfac(0x1fa)][_0x15dfac(0x209)](this),this[_0x15dfac(0x141)]();},VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x27f)]=Graphics[_0xd7df0a(0x26b)],Graphics[_0xd7df0a(0x26b)]=function(){const _0x49b16d=_0xd7df0a;VisuMZ['OptionsCore'][_0x49b16d(0x27f)]['call'](this),this['_fullScreenOptionsCore']();},Graphics[_0xd7df0a(0x141)]=function(){const _0x4623f6=_0xd7df0a;if(SceneManager&&SceneManager[_0x4623f6(0x124)]){if(_0x4623f6(0x1d9)!==_0x4623f6(0x1d9)){const _0x1a5d93=_0x34c54c[_0x4623f6(0x175)]??0x0;this['_categoryWindow'][_0x4623f6(0x21a)](_0x1a5d93);}else{const _0x5ac39d=SceneManager[_0x4623f6(0x124)];_0x5ac39d[_0x4623f6(0x2e0)]===Scene_Options&&setTimeout(_0x5ac39d['refreshWindows'][_0x4623f6(0x275)](_0x5ac39d),0x64);}}},VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x234)]=Graphics[_0xd7df0a(0x11f)],Graphics[_0xd7df0a(0x11f)]=function(){const _0x2afd2e=_0xd7df0a;VisuMZ[_0x2afd2e(0x267)][_0x2afd2e(0x234)][_0x2afd2e(0x209)](this),this['_stretchScreenOptionsCore']();},Graphics['_stretchScreenOptionsCore']=function(){const _0x20f94b=_0xd7df0a;ConfigManager&&ConfigManager[_0x20f94b(0x177)]!==undefined&&(ConfigManager[_0x20f94b(0x177)]=!!this[_0x20f94b(0x255)],setTimeout(ConfigManager[_0x20f94b(0x2c1)][_0x20f94b(0x275)](ConfigManager),0x64));if(SceneManager&&SceneManager[_0x20f94b(0x124)]){const _0x4c740f=SceneManager[_0x20f94b(0x124)];if(_0x4c740f[_0x20f94b(0x2e0)]===Scene_Options){if('fxVAd'===_0x20f94b(0x2d8))setTimeout(_0x4c740f[_0x20f94b(0x1c5)][_0x20f94b(0x275)](_0x4c740f),0x64);else{this['_doubleTouch']=![];if(this[_0x20f94b(0x109)]()){const _0x311d20=this[_0x20f94b(0x1e1)](),_0x4bcff7=this[_0x20f94b(0x2b9)]();_0x4bcff7>=0x0&&_0x4bcff7!==this[_0x20f94b(0x1e1)]()&&this[_0x20f94b(0x19e)](_0x4bcff7),_0x34faeb&&this[_0x20f94b(0x1e1)]()!==_0x311d20&&this[_0x20f94b(0x20a)]();}}}}},VisuMZ[_0xd7df0a(0x267)]['VolumeShortcut']={'enabled':VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x1f0)][_0xd7df0a(0x165)][_0xd7df0a(0x173)]??!![],'change':VisuMZ[_0xd7df0a(0x267)]['Settings'][_0xd7df0a(0x165)][_0xd7df0a(0x1af)]??!![]},VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x1db)]=Input[_0xd7df0a(0x1c2)],Input['isTriggered']=function(_0x4fe515){const _0x3512d2=_0xd7df0a;if(VisuMZ[_0x3512d2(0x267)][_0x3512d2(0x21d)](_0x4fe515,![]))return VisuMZ[_0x3512d2(0x267)][_0x3512d2(0x1e5)](_0x4fe515),![];return VisuMZ['OptionsCore'][_0x3512d2(0x1db)]['call'](this,_0x4fe515);},VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x203)]=Input[_0xd7df0a(0x139)],Input[_0xd7df0a(0x139)]=function(_0x5a9e09){const _0x50b672=_0xd7df0a;if(VisuMZ[_0x50b672(0x267)][_0x50b672(0x21d)](_0x5a9e09,!![]))return VisuMZ['OptionsCore'][_0x50b672(0x1e5)](_0x5a9e09),![];return VisuMZ[_0x50b672(0x267)][_0x50b672(0x203)][_0x50b672(0x209)](this,_0x5a9e09);},VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x21d)]=function(_0x1da65b,_0x474283){const _0xb1973d=_0xd7df0a;if(!VisuMZ['OptionsCore'][_0xb1973d(0x126)][_0xb1973d(0x107)])return![];if(ConfigManager[_0xb1973d(0x16a)]===undefined)return![];if(!Input[_0xb1973d(0x198)]('control'))return![];if(_0x1da65b!==_0xb1973d(0x2c3)&&_0x1da65b!=='pagedown')return![];if(_0x474283){if(_0xb1973d(0x17c)===_0xb1973d(0x194))this[_0xb1973d(0x10c)][_0x45c61f]['CursorLeftJS'][_0xb1973d(0x209)](this,_0x1ae749,_0x2bd5c1);else return VisuMZ[_0xb1973d(0x267)][_0xb1973d(0x203)][_0xb1973d(0x209)](Input,_0x1da65b);}else return VisuMZ[_0xb1973d(0x267)][_0xb1973d(0x1db)][_0xb1973d(0x209)](Input,_0x1da65b);},VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x1e5)]=function(_0x2d4973){const _0x1dbb6c=_0xd7df0a,_0x31740d=this[_0x1dbb6c(0x130)](_0x2d4973);this[_0x1dbb6c(0x1f8)](_0x31740d);},VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x130)]=function(_0x3455e1){const _0x592fbf=_0xd7df0a,_0x11f51c=VisuMZ['OptionsCore'][_0x592fbf(0x126)]['change'];let _0x5bdcdb=Math[_0x592fbf(0x2b4)](WebAudio[_0x592fbf(0x19f)]*0x64);const _0xdddb50=ConfigManager[_0x592fbf(0x16a)];if(_0x3455e1===_0x592fbf(0x2c3)){if('ouBcU'!==_0x592fbf(0x163))_0x5bdcdb+=_0x11f51c;else{for(let _0x267487=0x1;_0x267487<_0x4fdf67[_0x592fbf(0x28b)];_0x267487++){const _0x3869ba=_0x23d5ab[_0x267487],_0x1de92c=_0x505d1b[_0x592fbf(0x169)](_0x5bff25[_0x592fbf(0x2d3)][_0x38e34a]);_0x1de92c['name']=_0x3869ba,_0x6fe158[_0x267487]=_0x1de92c;}_0x3d00da++;}}else _0x3455e1===_0x592fbf(0x29c)&&('eFEOf'!==_0x592fbf(0x269)?_0x5bdcdb-=_0x11f51c:this[_0x592fbf(0x28f)]());_0x5bdcdb=_0x5bdcdb[_0x592fbf(0x17d)](0x0,0x64),ConfigManager[_0x592fbf(0x16a)]=_0x5bdcdb,ConfigManager[_0x592fbf(0x2c1)](),_0x5bdcdb/=0x64,WebAudio[_0x592fbf(0x24a)](_0x5bdcdb);if(_0xdddb50!==ConfigManager['masterVolume']){if(_0x3455e1==='pageup'){if(_0x592fbf(0x2bb)!==_0x592fbf(0x2db))SoundManager[_0x592fbf(0x270)]();else return this[_0x592fbf(0x1f5)]&&this[_0x592fbf(0x1f5)][_0x592fbf(0x29e)][_0x592fbf(0x12f)]['display']!=='none';}else{if(_0x3455e1==='pagedown'){if(_0x592fbf(0x105)==='klMHV')SoundManager[_0x592fbf(0x147)]();else{_0x2845e9['prototype'][_0x592fbf(0x18a)][_0x592fbf(0x209)](this),this['createCategoryWindow'](),this['createOptionsWindow'](),this['postCreateWindows']();if(_0x12b117[_0x592fbf(0x272)]){}this[_0x592fbf(0x225)]();}}}}return ConfigManager[_0x592fbf(0x16a)]!==_0xdddb50;},VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x1f8)]=function(_0x5e7e9c){const _0x1027b9=_0xd7df0a;if(!_0x5e7e9c)return;const _0x526736=SceneManager['_scene'];if(_0x526736[_0x1027b9(0x2e0)]!==Scene_Options)return;_0x526736[_0x1027b9(0x1eb)][_0x1027b9(0x24d)]();},VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x172)]=DataManager['setupNewGame'],DataManager[_0xd7df0a(0x1b7)]=function(){const _0x378995=_0xd7df0a,_0x3eb42b=($gameSystem?$gameSystem[_0x378995(0x245)]():$dataSystem['windowTone'])[_0x378995(0x1e6)](0x0);VisuMZ[_0x378995(0x267)][_0x378995(0x172)][_0x378995(0x209)](this),$gameSystem[_0x378995(0x279)](_0x3eb42b);},SoundManager[_0xd7df0a(0x13b)]=JsonEx[_0xd7df0a(0x169)](VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x1f0)][_0xd7df0a(0x211)][_0xd7df0a(0x111)]),SoundManager[_0xd7df0a(0x262)]=JsonEx[_0xd7df0a(0x169)](VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x1f0)]['OptionsSettings']['SFXOKList']),SoundManager['cancelSFXs']=JsonEx['makeDeepCopy'](VisuMZ[_0xd7df0a(0x267)]['Settings'][_0xd7df0a(0x211)]['SFXCancelList']),SoundManager[_0xd7df0a(0x1b1)]=JsonEx[_0xd7df0a(0x169)](VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x1f0)][_0xd7df0a(0x211)][_0xd7df0a(0x135)]),SoundManager[_0xd7df0a(0x20b)]=function(){const _0x177f67=_0xd7df0a,_0x5a6fea=[];_0x5a6fea[_0x177f67(0x1ab)](SoundManager['cursorSFXs']),_0x5a6fea['push'](SoundManager[_0x177f67(0x262)]),_0x5a6fea[_0x177f67(0x1ab)](SoundManager[_0x177f67(0x13d)]),_0x5a6fea['push'](SoundManager['buzzerSFXs']);let _0x58f634=0x0;for(const _0x1cfca5 of _0x5a6fea){for(let _0x569c2a=0x1;_0x569c2a<_0x1cfca5['length'];_0x569c2a++){if(_0x177f67(0x229)!=='WVxod'){const _0x539ac9=_0x1cfca5[_0x569c2a],_0x4d62db=JsonEx['makeDeepCopy']($dataSystem[_0x177f67(0x2d3)][_0x58f634]);_0x4d62db[_0x177f67(0x10a)]=_0x539ac9,_0x1cfca5[_0x569c2a]=_0x4d62db;}else _0x160d48[_0x177f67(0x267)]['Graphics_FPSCounter_switchMode']['call'](this),this[_0x177f67(0x150)]();}_0x58f634++;}},VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x176)]=SoundManager[_0xd7df0a(0x299)],SoundManager[_0xd7df0a(0x299)]=function(){const _0x31e289=_0xd7df0a;if(ConfigManager&&ConfigManager['seCursor']!==undefined){if(ConfigManager[_0x31e289(0x23c)]>0x0){if(_0x31e289(0x202)===_0x31e289(0x1f6)){if(_0xec5452['assistInstantKO'])_0x5af54e=_0x2cba2a[_0x31e289(0x217)](_0x5871de,_0x26af43[_0x31e289(0x1cc)]);}else{const _0x2375a9=SoundManager[_0x31e289(0x13b)][ConfigManager[_0x31e289(0x23c)]];if(_0x2375a9)return AudioManager[_0x31e289(0x18f)](_0x2375a9);}}}VisuMZ['OptionsCore'][_0x31e289(0x176)][_0x31e289(0x209)](this);},VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x250)]=SoundManager['playOk'],SoundManager[_0xd7df0a(0x133)]=function(){const _0x5823e6=_0xd7df0a;if(ConfigManager&&ConfigManager[_0x5823e6(0x22d)]!==undefined){if(ConfigManager[_0x5823e6(0x22d)]>0x0){if(_0x5823e6(0x2e1)!==_0x5823e6(0x2e1))this['isUseModernControls']()?this[_0x5823e6(0x231)]():(this[_0x5823e6(0x1df)][_0x5823e6(0x1f1)](),this[_0x5823e6(0x1eb)][_0x5823e6(0x129)]());else{const _0x7cf64a=SoundManager[_0x5823e6(0x262)][ConfigManager[_0x5823e6(0x22d)]];if(_0x7cf64a)return AudioManager[_0x5823e6(0x18f)](_0x7cf64a);}}}VisuMZ['OptionsCore'][_0x5823e6(0x250)]['call'](this);},VisuMZ['OptionsCore']['SoundManager_playCancel']=SoundManager[_0xd7df0a(0x1e3)],SoundManager['playCancel']=function(){const _0x377540=_0xd7df0a;if(ConfigManager&&ConfigManager[_0x377540(0x21e)]!==undefined){if(ConfigManager[_0x377540(0x21e)]>0x0){const _0x2c7578=SoundManager[_0x377540(0x13d)][ConfigManager[_0x377540(0x21e)]];if(_0x2c7578)return AudioManager[_0x377540(0x18f)](_0x2c7578);}}VisuMZ[_0x377540(0x267)][_0x377540(0x2d2)][_0x377540(0x209)](this);},VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x287)]=SoundManager[_0xd7df0a(0x296)],SoundManager[_0xd7df0a(0x296)]=function(){const _0x4dbc24=_0xd7df0a;if(ConfigManager&&ConfigManager['seBuzzer']!==undefined){if(_0x4dbc24(0x238)!==_0x4dbc24(0x238))return this['isUseModernControls']()?![]:_0x4e7e3b['prototype'][_0x4dbc24(0x104)]['call'](this);else{if(ConfigManager['seBuzzer']>0x0){const _0x14497f=SoundManager[_0x4dbc24(0x1b1)][ConfigManager[_0x4dbc24(0x261)]];if(_0x14497f)return AudioManager[_0x4dbc24(0x18f)](_0x14497f);}}}VisuMZ[_0x4dbc24(0x267)][_0x4dbc24(0x287)]['call'](this);},SoundManager[_0xd7df0a(0x270)]=function(){const _0x4df9ae=_0xd7df0a,_0x18fb7d=VisuMZ[_0x4df9ae(0x267)]['Settings'][_0x4df9ae(0x165)],_0x243948={'name':_0x18fb7d[_0x4df9ae(0x115)],'volume':_0x18fb7d['upVolume'],'pitch':_0x18fb7d[_0x4df9ae(0x1a7)],'pan':_0x18fb7d['upPan']};AudioManager['playSe'](_0x243948);},SoundManager[_0xd7df0a(0x147)]=function(){const _0xde8122=_0xd7df0a,_0x42804e=VisuMZ[_0xde8122(0x267)]['Settings'][_0xde8122(0x165)],_0x342504={'name':_0x42804e[_0xde8122(0x11c)],'volume':_0x42804e[_0xde8122(0x1bb)],'pitch':_0x42804e[_0xde8122(0x11d)],'pan':_0x42804e['downPan']};AudioManager[_0xde8122(0x128)](_0x342504);},TextManager[_0xd7df0a(0x106)]=VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x1f0)][_0xd7df0a(0x211)][_0xd7df0a(0x2e8)];if(Imported['VisuMZ_0_CoreEngine']){VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x2ad)]=Game_Temp[_0xd7df0a(0x1bc)][_0xd7df0a(0x1ce)],Game_Temp[_0xd7df0a(0x1bc)][_0xd7df0a(0x1ce)]=function(_0x267c24,_0xd69d2f,_0x592858){const _0x1a8845=_0xd7df0a;if(!this['showRegularAnimations']())return;VisuMZ[_0x1a8845(0x267)][_0x1a8845(0x2ad)][_0x1a8845(0x209)](this,_0x267c24,_0xd69d2f,_0x592858);},Game_Temp['prototype'][_0xd7df0a(0x24f)]=function(){const _0x5365fc=_0xd7df0a;if($gameParty[_0x5365fc(0x1ef)]()&&ConfigManager&&ConfigManager[_0x5365fc(0x2b5)]!==undefined)return _0x5365fc(0x16f)===_0x5365fc(0x16f)?ConfigManager['battleAniShow']>=0x1:_0x4265ca[_0x5365fc(0x256)]!==_0xb7863b?_0xc754e3[_0x5365fc(0x256)]:_0x518f82[_0x5365fc(0x282)][_0x5365fc(0x209)](this);return!![];};Game_Temp['prototype'][_0xd7df0a(0x247)]&&(VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x2da)]=Game_Temp[_0xd7df0a(0x1bc)][_0xd7df0a(0x247)],Game_Temp['prototype'][_0xd7df0a(0x247)]=function(){const _0x524d55=_0xd7df0a;if($gameParty[_0x524d55(0x1ef)]()&&ConfigManager&&ConfigManager['battleAniShow']!==undefined)return ConfigManager[_0x524d55(0x2b5)]>=0x2;return VisuMZ['OptionsCore'][_0x524d55(0x2da)][_0x524d55(0x209)](this);});;};VisuMZ['OptionsCore'][_0xd7df0a(0x2ac)]=Game_System[_0xd7df0a(0x1bc)][_0xd7df0a(0x117)],Game_System[_0xd7df0a(0x1bc)][_0xd7df0a(0x117)]=function(){const _0x2d007a=_0xd7df0a;VisuMZ[_0x2d007a(0x267)][_0x2d007a(0x2ac)][_0x2d007a(0x209)](this),this[_0x2d007a(0x1a0)]();},Game_System[_0xd7df0a(0x1bc)][_0xd7df0a(0x1a0)]=function(){const _0x552eac=_0xd7df0a;this[_0x552eac(0x243)]=JsonEx[_0x552eac(0x169)]($dataSystem[_0x552eac(0x245)]);},Game_System[_0xd7df0a(0x1bc)][_0xd7df0a(0x245)]=function(){const _0x2ef113=_0xd7df0a;if(this[_0x2ef113(0x243)])return this[_0x2ef113(0x243)];return this[_0x2ef113(0x1a0)](),this[_0x2ef113(0x243)];},VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x26a)]=Game_System['prototype'][_0xd7df0a(0x244)],Game_System[_0xd7df0a(0x1bc)]['mainFontFace']=function(){const _0x140f37=_0xd7df0a,_0x1ca2b0=VisuMZ[_0x140f37(0x267)][_0x140f37(0x26a)][_0x140f37(0x209)](this);if(ConfigManager&&ConfigManager[_0x140f37(0x295)]!==undefined){if(ConfigManager[_0x140f37(0x295)]>0x0){if(_0x140f37(0x2a6)!==_0x140f37(0x27d))return TextManager[_0x140f37(0x106)][ConfigManager[_0x140f37(0x295)]]||_0x1ca2b0;else{if(_0xbdb3a1[_0x140f37(0x263)](_0x289a5d)&&_0x1134ee[_0x140f37(0x1aa)]===![])return;if(_0x303742['isItem'](_0x428681)&&_0x55b46f[_0x140f37(0x1a9)]===![])return;}}}return _0x1ca2b0;},VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x257)]=Game_Action[_0xd7df0a(0x1bc)][_0xd7df0a(0x2cf)],Game_Action[_0xd7df0a(0x1bc)][_0xd7df0a(0x2cf)]=function(_0x18ecdc,_0x1b91a7){const _0x242683=_0xd7df0a;if(ConfigManager[_0x242683(0x19b)]){if(_0x242683(0x157)===_0x242683(0x2b1)){if(_0x41d186[_0x242683(0x1ef)]()&&_0x133298&&_0x33b70f[_0x242683(0x2b5)]!==_0x3922e4)return _0xf9b97b[_0x242683(0x2b5)]>=0x2;return _0x971e0c[_0x242683(0x267)][_0x242683(0x2da)]['call'](this);}else{if(this[_0x242683(0x218)]()[_0x242683(0x21f)]()&&_0x18ecdc[_0x242683(0x16e)]()){if(ConfigManager[_0x242683(0x29f)])_0x1b91a7=Math[_0x242683(0x217)](_0x1b91a7,_0x18ecdc['mhp']);}}}VisuMZ['OptionsCore'][_0x242683(0x257)][_0x242683(0x209)](this,_0x18ecdc,_0x1b91a7);},VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x113)]=Game_BattlerBase[_0xd7df0a(0x1bc)]['isStateResist'],Game_BattlerBase['prototype'][_0xd7df0a(0x205)]=function(_0x324822){const _0x12bf6c=_0xd7df0a;if(ConfigManager[_0x12bf6c(0x19b)]&&this['isActor']()){if(ConfigManager['assistGodmode']&&_0x324822===this[_0x12bf6c(0x2c9)]())return!![];if(Imported[_0x12bf6c(0x277)]&&ConfigManager['assistResistNegatives']){if(_0x12bf6c(0x19c)===_0x12bf6c(0x1d8))_0x27847b[_0x12bf6c(0x1c5)]();else{const _0x7470f6=$dataStates[_0x324822];if(_0x7470f6&&_0x7470f6[_0x12bf6c(0x24c)]&&_0x7470f6['categories']['includes']('NEGATIVE'))return!![];}}}return VisuMZ[_0x12bf6c(0x267)]['Game_BattlerBase_isStateResist']['call'](this,_0x324822);},VisuMZ[_0xd7df0a(0x267)]['Game_Battler_useItem']=Game_Battler[_0xd7df0a(0x1bc)]['useItem'],Game_Battler[_0xd7df0a(0x1bc)][_0xd7df0a(0x2e7)]=function(_0x367684){const _0x293ba0=_0xd7df0a;if(ConfigManager&&ConfigManager['assistMode']&&this[_0x293ba0(0x21f)]()){if(DataManager[_0x293ba0(0x263)](_0x367684)&&ConfigManager[_0x293ba0(0x1aa)]===![])return;if(DataManager[_0x293ba0(0x195)](_0x367684)&&ConfigManager[_0x293ba0(0x1a9)]===![])return;}VisuMZ['OptionsCore']['Game_Battler_useItem'][_0x293ba0(0x209)](this,_0x367684);},VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x291)]=Game_Battler[_0xd7df0a(0x1bc)][_0xd7df0a(0x193)],Game_Battler['prototype'][_0xd7df0a(0x193)]=function(_0x12d29b,_0xaa9dc4){const _0x4345d4=_0xd7df0a;if(ConfigManager[_0x4345d4(0x19b)]&&this[_0x4345d4(0x21f)]()){if(_0x4345d4(0x146)!=='oiKfe')this['onTouchSelect'](!![]);else{if(Imported['VisuMZ_1_SkillsStatesCore']&&ConfigManager[_0x4345d4(0x2b0)])return!![];}}VisuMZ['OptionsCore']['Game_Battler_addDebuff']['call'](this,_0x12d29b,_0xaa9dc4);},VisuMZ[_0xd7df0a(0x267)]['Game_Enemy_dropItemRate']=Game_Enemy['prototype'][_0xd7df0a(0x2d5)],Game_Enemy[_0xd7df0a(0x1bc)]['dropItemRate']=function(){const _0x3355ae=_0xd7df0a;let _0x57d680=VisuMZ['OptionsCore'][_0x3355ae(0x27b)]['call'](this);if(ConfigManager[_0x3355ae(0x19b)]){if('cAqGL'!==_0x3355ae(0x155))_0x57d680*=0x2**(ConfigManager[_0x3355ae(0x1e9)]||0x0);else{const _0x1349a2=this['contents'][_0x3355ae(0x17b)];this[_0x3355ae(0x1b4)]>=0x0&&(!this['isCommandEnabled'](this[_0x3355ae(0x1b4)])&&this[_0x3355ae(0x2b2)](![])),_0x5b10f4[_0x3355ae(0x1bc)]['drawText'][_0x3355ae(0x209)](this,_0x3a117a,_0x3e2a6e,_0x28af0a,_0x366ca5,_0xc9f4ff),this[_0x3355ae(0x208)][_0x3355ae(0x17b)]=_0x1349a2;}}return _0x57d680;},VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x2bd)]=Game_Party[_0xd7df0a(0x1bc)]['hasEncounterHalf'],Game_Party[_0xd7df0a(0x1bc)][_0xd7df0a(0x18c)]=function(){const _0x3a45c1=_0xd7df0a;if(ConfigManager['assistMode']&&ConfigManager[_0x3a45c1(0x164)]===0x1)return!![];if(ConfigManager[_0x3a45c1(0x15f)]===0x1)return!![];return VisuMZ[_0x3a45c1(0x267)]['Game_Party_hasEncounterHalf'][_0x3a45c1(0x209)](this);},VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x161)]=Game_Party[_0xd7df0a(0x1bc)]['hasEncounterNone'],Game_Party[_0xd7df0a(0x1bc)][_0xd7df0a(0x132)]=function(){const _0x27cc70=_0xd7df0a;if(ConfigManager['assistMode']&&ConfigManager['assistRandomEncounters']===0x0)return!![];if(ConfigManager[_0x27cc70(0x15f)]===0x0)return!![];return VisuMZ[_0x27cc70(0x267)][_0x27cc70(0x161)][_0x27cc70(0x209)](this);},VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x2aa)]=Game_Troop[_0xd7df0a(0x1bc)][_0xd7df0a(0x2c7)],Game_Troop[_0xd7df0a(0x1bc)]['expTotal']=function(){const _0x1f365c=_0xd7df0a;let _0x5f4ba=VisuMZ[_0x1f365c(0x267)]['Game_Troop_expTotal']['call'](this);if(ConfigManager['assistMode']){if(_0x1f365c(0x28a)!==_0x1f365c(0x28a)){if(this['isUseModernControls']())return;_0x4c82c6[_0x1f365c(0x1bc)][_0x1f365c(0x110)][_0x1f365c(0x209)](this);}else _0x5f4ba*=0x2**(ConfigManager[_0x1f365c(0x2cb)]||0x0);}return _0x5f4ba;},VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x1d4)]=Game_Troop[_0xd7df0a(0x1bc)]['goldRate'],Game_Troop[_0xd7df0a(0x1bc)][_0xd7df0a(0x276)]=function(){const _0x56b6a3=_0xd7df0a;let _0x8b65a8=VisuMZ[_0x56b6a3(0x267)][_0x56b6a3(0x1d4)][_0x56b6a3(0x209)](this);return ConfigManager['assistMode']&&(_0x8b65a8*=0x2**(ConfigManager['assistGoldMultiplier']||0x0)),_0x8b65a8;};var uiDefault=uiDefault||{};uiDefault['HelpPosition']=Scene_Base[_0xd7df0a(0x1bc)][_0xd7df0a(0x288)],Scene_Base['prototype']['isBottomHelpMode']=function(){const _0x17ee4b=_0xd7df0a;return ConfigManager['uiMenuStyle']&&ConfigManager[_0x17ee4b(0x248)]!==undefined?ConfigManager['uiHelpPosition']:uiDefault[_0x17ee4b(0x29b)][_0x17ee4b(0x209)](this);},uiDefault[_0xd7df0a(0x282)]=Scene_Base['prototype']['isBottomButtonMode'],Scene_Base[_0xd7df0a(0x1bc)]['isBottomButtonMode']=function(){const _0x25ed6d=_0xd7df0a;return ConfigManager[_0x25ed6d(0x256)]!==undefined?ConfigManager[_0x25ed6d(0x256)]:uiDefault['ButtonPosition'][_0x25ed6d(0x209)](this);},uiDefault[_0xd7df0a(0x15b)]=Scene_Base[_0xd7df0a(0x1bc)][_0xd7df0a(0x17f)],Scene_Base['prototype'][_0xd7df0a(0x17f)]=function(){const _0x5a9bcf=_0xd7df0a;if(ConfigManager['uiMenuStyle']&&ConfigManager[_0x5a9bcf(0x1ad)]!==undefined)return ConfigManager['uiInputPosition'];else{if(_0x5a9bcf(0x118)!=='mPlVw')return uiDefault[_0x5a9bcf(0x15b)][_0x5a9bcf(0x209)](this);else this[_0x5a9bcf(0x1df)][_0x5a9bcf(0x1fd)]();}},Scene_Base[_0xd7df0a(0x1bc)][_0xd7df0a(0x16c)]=function(){const _0x2bfa19=_0xd7df0a;this[_0x2bfa19(0x14a)]&&(this[_0x2bfa19(0x14a)][_0x2bfa19(0x199)]=ConfigManager[_0x2bfa19(0x136)]),this[_0x2bfa19(0x2dc)]&&(this['_pageupButton'][_0x2bfa19(0x199)]=ConfigManager[_0x2bfa19(0x136)]),this['_pagedownButton']&&(this[_0x2bfa19(0x222)][_0x2bfa19(0x199)]=ConfigManager[_0x2bfa19(0x136)]);},Scene_Base[_0xd7df0a(0x1bc)][_0xd7df0a(0x156)]=function(){const _0x3050e1=_0xd7df0a;this[_0x3050e1(0x14a)]&&('EDhPt'===_0x3050e1(0x2e2)?this[_0x3050e1(0x1fe)](_0x93f8dc):this['_cancelButton']['y']=this[_0x3050e1(0x2a3)]());if(this[_0x3050e1(0x2dc)]){this[_0x3050e1(0x2dc)]['y']=this['buttonY']();if(Graphics[_0x3050e1(0x1a6)]()&&!this['isBottomButtonMode']()){if('uiBBi'===_0x3050e1(0x1ea)){let _0x57fb0c=_0x460c12[_0x3050e1(0x18d)]||0x0;while(_0x57fb0c--){this[_0x3050e1(0x11a)]();}}else this['_pageupButton']['y']+=0x32;}}if(this['_pagedownButton']){this[_0x3050e1(0x222)]['y']=this[_0x3050e1(0x2a3)]();if(Graphics[_0x3050e1(0x1a6)]()&&!this[_0x3050e1(0x1a3)]()){if(_0x3050e1(0x27c)!==_0x3050e1(0x27c)){if(_0x124f07[_0x3050e1(0x28e)]!==_0x48938d){const _0x4bb7cb=_0x286735[_0x3050e1(0x28e)];this[_0x3050e1(0x1df)]['smoothSelect'](_0x4bb7cb[_0x3050e1(0x153)]),this[_0x3050e1(0x1df)]['update'](),this['isUseModernControls']()?this['_categoryWindow']['activate']():this[_0x3050e1(0x1df)][_0x3050e1(0x1fd)](),this[_0x3050e1(0x1eb)][_0x3050e1(0x1f1)](),this[_0x3050e1(0x1eb)][_0x3050e1(0x154)]=_0x4bb7cb['index'],this['_optionsWindow'][_0x3050e1(0x289)]=_0x4bb7cb[_0x3050e1(0x25f)],this[_0x3050e1(0x1eb)]['_scrollY']=_0x4bb7cb[_0x3050e1(0x2bf)],this[_0x3050e1(0x1eb)]['_scrollDuration']=0x0,this['_optionsWindow'][_0x3050e1(0x2ca)](),_0x33c3a1[_0x3050e1(0x28e)]=_0x929c06;}}else this['_pagedownButton']['y']+=0x32;}}},VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x10d)]=Scene_Base[_0xd7df0a(0x1bc)][_0xd7df0a(0x191)],Scene_Base[_0xd7df0a(0x1bc)][_0xd7df0a(0x191)]=function(){const _0x3e0465=_0xd7df0a;if(ConfigManager[_0x3e0465(0x136)]){if('eTqLu'!==_0x3e0465(0x1f4))_0x4898ab[_0x3e0465(0x267)]['Graphics_cancelFullScreen']['call'](this),this[_0x3e0465(0x141)]();else return VisuMZ[_0x3e0465(0x267)][_0x3e0465(0x10d)]['call'](this);}else return this[_0x3e0465(0x12b)]();},Scene_Base[_0xd7df0a(0x1bc)]['checkActiveWindowPageUpDownHandlers']=function(){const _0x3166d6=_0xd7df0a;if(this[_0x3166d6(0x116)]&&this[_0x3166d6(0x116)][_0x3166d6(0x1ee)])for(const _0xf0cbd9 of this['_windowLayer'][_0x3166d6(0x1ee)]){if(_0x3166d6(0x1c8)===_0x3166d6(0x1c8)){if(!_0xf0cbd9)continue;if(!_0xf0cbd9[_0x3166d6(0x25e)])continue;if(!_0xf0cbd9[_0x3166d6(0x25c)])continue;if(_0xf0cbd9[_0x3166d6(0x25c)][_0x3166d6(0x2c3)])return TextManager[_0x3166d6(0x25a)];}else{if(_0x1dfbbd&&_0xc557b9[_0x3166d6(0x124)]){const _0x41b5e5=_0x315db9['_scene'];_0x41b5e5[_0x3166d6(0x2e0)]===_0x4f7f97&&_0x547e82(_0x41b5e5[_0x3166d6(0x1c5)][_0x3166d6(0x275)](_0x41b5e5),0x64);}}}return'';},VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x12a)]=Scene_MenuBase[_0xd7df0a(0x1bc)][_0xd7df0a(0x236)],Scene_MenuBase['prototype'][_0xd7df0a(0x236)]=function(){const _0x5c39e5=_0xd7df0a;VisuMZ[_0x5c39e5(0x267)][_0x5c39e5(0x12a)][_0x5c39e5(0x209)](this),Graphics['_isFPSCounterOn']()&&!this[_0x5c39e5(0x1a3)]()&&(this[_0x5c39e5(0x2dc)]['y']+=0x32,this[_0x5c39e5(0x222)]['y']+=0x32);},Scene_MenuBase[_0xd7df0a(0x1bc)][_0xd7df0a(0x16c)]=function(){const _0x103ff5=_0xd7df0a;if(!this[_0x103ff5(0x14a)])this['createButtons']();Scene_Base[_0x103ff5(0x1bc)][_0x103ff5(0x16c)][_0x103ff5(0x209)](this);},VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x19d)]=Scene_Title[_0xd7df0a(0x1bc)][_0xd7df0a(0x15d)],Scene_Title['prototype'][_0xd7df0a(0x15d)]=function(){const _0x13a863=_0xd7df0a;this[_0x13a863(0x1a2)](),VisuMZ[_0x13a863(0x267)][_0x13a863(0x19d)]['call'](this);},Scene_Title[_0xd7df0a(0x1bc)]['updateOptionsCoreFailsafe']=function(){const _0x4fe6db=_0xd7df0a;if(ConfigManager['assistMode'])return;if($gameTemp[_0x4fe6db(0x16d)]())return;if(Input[_0x4fe6db(0x1c2)]('down'))this[_0x4fe6db(0x221)](0x2);if(Input[_0x4fe6db(0x1c2)](_0x4fe6db(0x10b)))this[_0x4fe6db(0x221)](0x4);if(Input[_0x4fe6db(0x1c2)](_0x4fe6db(0x13c)))this['processOptionsCoreFailsafe'](0x6);if(Input[_0x4fe6db(0x1c2)]('up'))this[_0x4fe6db(0x221)](0x8);},Scene_Title[_0xd7df0a(0x1bc)][_0xd7df0a(0x221)]=function(_0x350822){const _0x3890a1=_0xd7df0a,_0x1a7089=[0x8,0x8,0x2,0x2,0x4,0x6,0x4,0x6];this[_0x3890a1(0x2c8)]=this[_0x3890a1(0x2c8)]||0x0,_0x350822===_0x1a7089[this[_0x3890a1(0x2c8)]]?'hDJog'==='hDJog'?this[_0x3890a1(0x2c8)]++:this[_0x3890a1(0x222)]['y']+=0x32:this[_0x3890a1(0x2c8)]=0x0,this[_0x3890a1(0x2c8)]===_0x1a7089[_0x3890a1(0x28b)]&&('fhLzk'===_0x3890a1(0x26f)?(ConfigManager[_0x3890a1(0x19b)]=!![],ConfigManager['save'](),SoundManager['playLoad']()):_0x3ca283[_0x3890a1(0x246)]['call'](this,_0x2f74a5,_0xf1577d));},VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x281)]=Scene_Map[_0xd7df0a(0x1bc)][_0xd7df0a(0x25b)],Scene_Map[_0xd7df0a(0x1bc)]['updateMainMultiply']=function(){const _0x3afb59=_0xd7df0a;VisuMZ['OptionsCore'][_0x3afb59(0x281)][_0x3afb59(0x209)](this);if(ConfigManager[_0x3afb59(0x19b)]&&ConfigManager[_0x3afb59(0x18d)]&&!$gameMessage[_0x3afb59(0x290)]()){if('wFMMy'!==_0x3afb59(0x220))return _0x3afb59(0x114);else this[_0x3afb59(0x1ae)]();}},Scene_Map[_0xd7df0a(0x1bc)][_0xd7df0a(0x1ae)]=function(){const _0x20eb47=_0xd7df0a;let _0x38f733=ConfigManager[_0x20eb47(0x18d)]||0x0;while(_0x38f733--){if('YyVgT'===_0x20eb47(0x224))this[_0x20eb47(0x11a)]();else{if(!_0x285009[_0x20eb47(0x267)][_0x20eb47(0x126)]['enabled'])return![];if(_0x52bb13[_0x20eb47(0x16a)]===_0x3da79d)return![];if(!_0x47486a['isPressed'](_0x20eb47(0x29d)))return![];if(_0x5ca6cd!==_0x20eb47(0x2c3)&&_0x1282e0!==_0x20eb47(0x29c))return![];return _0x3dde0c?_0x1d985a['OptionsCore']['Input_isRepeated'][_0x20eb47(0x209)](_0x3e1f24,_0x5ea7bb):_0x9ae7cc[_0x20eb47(0x267)][_0x20eb47(0x1db)][_0x20eb47(0x209)](_0x156045,_0x4bd2dc);}}},VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x21c)]=Scene_Battle['prototype'][_0xd7df0a(0x15d)],Scene_Battle[_0xd7df0a(0x1bc)][_0xd7df0a(0x15d)]=function(){const _0x2bca78=_0xd7df0a;VisuMZ['OptionsCore'][_0x2bca78(0x21c)]['call'](this);if(ConfigManager[_0x2bca78(0x1d7)])this['updateBattleAniSpeed']();},Scene_Battle['prototype']['updateBattleAniSpeed']=function(){const _0x206fdd=_0xd7df0a;if(this[_0x206fdd(0x22a)]()){if(_0x206fdd(0x162)===_0x206fdd(0x162)){this[_0x206fdd(0x14e)]=!![];let _0x695179=ConfigManager['battleAniSpeed'];while(_0x695179--){this[_0x206fdd(0x15d)](),SceneManager[_0x206fdd(0x11e)]();}this[_0x206fdd(0x14e)]=![];}else this[_0x206fdd(0x215)](_0x3d60a6[_0x206fdd(0x1c2)](_0x206fdd(0x2c3)));}},Scene_Battle['prototype'][_0xd7df0a(0x22a)]=function(){const _0x55978d=_0xd7df0a;return!BattleManager[_0x55978d(0x15a)]()&&!this[_0x55978d(0x14e)]&&!$gameMessage[_0x55978d(0x290)]();},Scene_Options[_0xd7df0a(0x1bc)][_0xd7df0a(0x168)]=function(){return 0x0;},Scene_Options['prototype'][_0xd7df0a(0x28c)]=function(){const _0x2ad018=_0xd7df0a;return this['_categoryWindow']&&this[_0x2ad018(0x1df)][_0x2ad018(0x28c)]();},Scene_Options[_0xd7df0a(0x1bc)][_0xd7df0a(0x18a)]=function(){const _0x2e9602=_0xd7df0a;Scene_MenuBase[_0x2e9602(0x1bc)]['create'][_0x2e9602(0x209)](this),this[_0x2e9602(0x2d7)](),this['createOptionsWindow'](),this[_0x2e9602(0x214)]();if(Imported[_0x2e9602(0x272)]){}this['updateOptionsSceneBgTypes']();},Scene_Options[_0xd7df0a(0x1bc)][_0xd7df0a(0x2d7)]=function(){const _0x44e607=_0xd7df0a,_0x45ef09=this[_0x44e607(0x1ed)]();this['_categoryWindow']=new Window_OptionsCategory(_0x45ef09),this[_0x44e607(0x149)](this[_0x44e607(0x1df)]),!this[_0x44e607(0x28c)]()&&(_0x44e607(0x2a9)!=='LQQzR'?_0x12fb7a[_0x44e607(0x237)]=![]:(this[_0x44e607(0x1df)]['setHandler'](_0x44e607(0x153),this[_0x44e607(0x284)]['bind'](this)),this[_0x44e607(0x1df)][_0x44e607(0x201)](_0x44e607(0x2af),this[_0x44e607(0x231)][_0x44e607(0x275)](this))));},Scene_Options[_0xd7df0a(0x1bc)][_0xd7df0a(0x1ed)]=function(){const _0x1c31e5=_0xd7df0a,_0x2ed27c=Graphics[_0x1c31e5(0x2a1)],_0x2358d7=this['calcWindowHeight'](0x1,!![]),_0x2f0d7c=0x0,_0x24cca9=this[_0x1c31e5(0x2e5)]();return new Rectangle(_0x2f0d7c,_0x24cca9,_0x2ed27c,_0x2358d7);},Scene_Options[_0xd7df0a(0x1bc)][_0xd7df0a(0x233)]=function(){const _0x167b54=_0xd7df0a,_0x18bfd3=this['optionsWindowRect']();this['_optionsWindow']=new Window_Options(_0x18bfd3),this[_0x167b54(0x149)](this[_0x167b54(0x1eb)]),this['_optionsWindow'][_0x167b54(0x201)](_0x167b54(0x2af),this[_0x167b54(0x23e)][_0x167b54(0x275)](this)),this[_0x167b54(0x1df)]['setListWindow'](this['_optionsWindow']),this[_0x167b54(0x28c)]()?(this[_0x167b54(0x1eb)]['activate'](),this[_0x167b54(0x1eb)]['smoothSelect'](0x0)):(this[_0x167b54(0x1eb)][_0x167b54(0x1fd)](),this[_0x167b54(0x1eb)][_0x167b54(0x129)]());},Scene_Options[_0xd7df0a(0x1bc)]['optionsWindowRect']=function(){const _0x5e0815=_0xd7df0a,_0x3ef120=Graphics[_0x5e0815(0x2a1)],_0x336d97=this[_0x5e0815(0x26c)]()-this[_0x5e0815(0x1df)]['height'],_0x2b7177=0x0,_0x1ab1b5=this['_categoryWindow']['y']+this[_0x5e0815(0x1df)][_0x5e0815(0x167)];return new Rectangle(_0x2b7177,_0x1ab1b5,_0x3ef120,_0x336d97);},Scene_Options[_0xd7df0a(0x1bc)]['postCreateWindows']=function(){const _0x2643a0=_0xd7df0a;if($gameTemp[_0x2643a0(0x28e)]!==undefined){const _0x23ac96=$gameTemp['_returnOptionsCore'];this[_0x2643a0(0x1df)][_0x2643a0(0x148)](_0x23ac96['category']),this[_0x2643a0(0x1df)][_0x2643a0(0x15d)](),this[_0x2643a0(0x28c)]()?this[_0x2643a0(0x1df)]['activate']():this[_0x2643a0(0x1df)][_0x2643a0(0x1fd)](),this[_0x2643a0(0x1eb)][_0x2643a0(0x1f1)](),this[_0x2643a0(0x1eb)][_0x2643a0(0x154)]=_0x23ac96[_0x2643a0(0x1e1)],this[_0x2643a0(0x1eb)][_0x2643a0(0x289)]=_0x23ac96['scrollX'],this[_0x2643a0(0x1eb)][_0x2643a0(0x119)]=_0x23ac96['scrollY'],this['_optionsWindow']['_scrollDuration']=0x0,this[_0x2643a0(0x1eb)][_0x2643a0(0x2ca)](),$gameTemp[_0x2643a0(0x28e)]=undefined;}},Scene_Options[_0xd7df0a(0x1bc)][_0xd7df0a(0x284)]=function(){const _0x67161e=_0xd7df0a;this['_optionsWindow'][_0x67161e(0x1f1)](),this[_0x67161e(0x1eb)][_0x67161e(0x148)](0x0);},Scene_Options[_0xd7df0a(0x1bc)][_0xd7df0a(0x23e)]=function(){const _0x16fdcf=_0xd7df0a;this['isUseModernControls']()?this[_0x16fdcf(0x231)]():(this[_0x16fdcf(0x1df)][_0x16fdcf(0x1f1)](),this['_optionsWindow'][_0x16fdcf(0x129)]());},Scene_Options['prototype']['optionsCoreUpdateButtonPositions']=function(){const _0x116af2=_0xd7df0a;Scene_MenuBase[_0x116af2(0x1bc)][_0x116af2(0x156)][_0x116af2(0x209)](this),this[_0x116af2(0x186)]();},Scene_Options[_0xd7df0a(0x1bc)][_0xd7df0a(0x186)]=function(){const _0x4a63ea=_0xd7df0a;if(this['_categoryWindow']){const _0x1f1e3c=this[_0x4a63ea(0x1ed)]();this[_0x4a63ea(0x1df)]['move'](_0x1f1e3c['x'],_0x1f1e3c['y'],_0x1f1e3c[_0x4a63ea(0x293)],_0x1f1e3c['height']);}if(this[_0x4a63ea(0x1eb)]){if(_0x4a63ea(0x142)===_0x4a63ea(0x142)){const _0x3cf53b=this[_0x4a63ea(0x2ba)]();this[_0x4a63ea(0x1eb)][_0x4a63ea(0x1fc)](_0x3cf53b['x'],_0x3cf53b['y'],_0x3cf53b['width'],_0x3cf53b[_0x4a63ea(0x167)]);}else{_0x5d5e68[_0x4a63ea(0x267)][_0x4a63ea(0x21c)][_0x4a63ea(0x209)](this);if(_0x19d7ea[_0x4a63ea(0x1d7)])this[_0x4a63ea(0x227)]();}}if(this[_0x4a63ea(0x1e4)]){const _0x4d5dda=this[_0x4a63ea(0x1e7)]();this[_0x4a63ea(0x1e4)][_0x4a63ea(0x1fc)](_0x4d5dda['x'],_0x4d5dda['y'],_0x4d5dda['width'],_0x4d5dda['height']),this[_0x4a63ea(0x1e4)][_0x4a63ea(0x24d)]();}this[_0x4a63ea(0x1c5)]();},Scene_Options['prototype']['refreshWindows']=function(){const _0x5b3728=_0xd7df0a;this[_0x5b3728(0x1df)]&&(this[_0x5b3728(0x1df)][_0x5b3728(0x24d)](),this[_0x5b3728(0x1df)][_0x5b3728(0x2ca)]());if(this[_0x5b3728(0x1eb)]){if(_0x5b3728(0x2ae)!==_0x5b3728(0x232))this[_0x5b3728(0x1eb)][_0x5b3728(0x24d)](),this[_0x5b3728(0x1eb)][_0x5b3728(0x2ca)]();else{if(this['allowUpdateBattleAniSpeed']()){this['_battleAniSpeedLooping']=!![];let _0x19498b=_0x50dede[_0x5b3728(0x1d7)];while(_0x19498b--){this[_0x5b3728(0x15d)](),_0x479817[_0x5b3728(0x11e)]();}this[_0x5b3728(0x14e)]=![];}}}this['_buttonAssistWindow']&&this[_0x5b3728(0x1e4)][_0x5b3728(0x24d)]();},Scene_Options[_0xd7df0a(0x1bc)][_0xd7df0a(0x191)]=function(){const _0x75a835=_0xd7df0a;return VisuMZ[_0x75a835(0x267)][_0x75a835(0x1f0)][_0x75a835(0x211)]['buttonAssistCategory'];},Scene_Options[_0xd7df0a(0x1bc)][_0xd7df0a(0x14b)]=function(){const _0x51bf06=_0xd7df0a,_0x3e3bf8=Scene_Options['layoutSettings'][_0x51bf06(0x292)]||0x0,_0x1b76e1=[this[_0x51bf06(0x1df)],this[_0x51bf06(0x1eb)],this[_0x51bf06(0x1e4)]];for(const _0x2f28d0 of _0x1b76e1){if(_0x2f28d0)_0x2f28d0[_0x51bf06(0x21a)](_0x3e3bf8);}},Scene_Options['prototype']['updateOptionsSceneBgTypes']=function(){const _0x584ef3=_0xd7df0a,_0x2cb77a=VisuMZ['OptionsCore'][_0x584ef3(0x1f0)][_0x584ef3(0x211)];if(this[_0x584ef3(0x1df)]){const _0x322d6e=_0x2cb77a['categoryWindowBgType']??0x0;this[_0x584ef3(0x1df)][_0x584ef3(0x21a)](_0x322d6e);}if(this['_optionsWindow']){const _0x29f773=_0x2cb77a['optionsWindowBgType']??0x0;this[_0x584ef3(0x1eb)][_0x584ef3(0x21a)](_0x29f773);}if(this[_0x584ef3(0x1e4)]){if(_0x584ef3(0x2d6)===_0x584ef3(0x2d6)){const _0x593f7c=_0x2cb77a['buttonAssistBgType']??0x0;this['_buttonAssistWindow'][_0x584ef3(0x21a)](_0x593f7c);}else this[_0x584ef3(0x1df)]['refresh'](),this[_0x584ef3(0x1df)][_0x584ef3(0x2ca)]();}},uiDefault[_0xd7df0a(0x27e)]=Window_Selectable['prototype']['isHoverEnabled'],Window_Selectable[_0xd7df0a(0x1bc)][_0xd7df0a(0x104)]=function(){const _0xa9d5d0=_0xd7df0a;if(ConfigManager[_0xa9d5d0(0x28d)]!==undefined)return ConfigManager['uiHoverSelect'];else{return uiDefault[_0xa9d5d0(0x27e)][_0xa9d5d0(0x209)](this);;}};function _0x357c(){const _0x54739c=['zcSQu','replace','buttonAssistSwitch','updateMainMultiply','_handlers','includes','active','scrollX','ConvertParams','seBuzzer','okSFXs','isSkill','description','DydbE','playBuzzerSound','OptionsCore','center','gxNUW','Game_System_mainFontFace','_cancelFullScreen','mainAreaHeight','isOpenAndActive','wxgHb','fhLzk','playMasterVolumeUp','updateButtonPositions','VisuMZ_0_CoreEngine','ExtJS','hYzrI','bind','goldRate','VisuMZ_1_SkillsStatesCore','213iVbhrN','setWindowTone','isOptionValid','Game_Enemy_dropItemRate','rllYa','LRzRp','hoverEnabled','Graphics_cancelFullScreen','drawItem','Scene_Map_updateMainMultiply','ButtonPosition','_commandNameWindow','commandCategory','cursorRight','itemLineRect','SoundManager_playBuzzer','isBottomHelpMode','_scrollX','biuzf','length','isUseModernControls','uiHoverSelect','_returnOptionsCore','onTouchCancel','isBusy','Game_Battler_addDebuff','OptionsBgType','width','Icon','textFont','playBuzzer','obsPc','CursorLeftJS','playCursor','processCursorMoveModernControls','HelpPosition','pagedown','control','_boxDiv','assistInstantKO','ZgfWO','boxWidth','Categories','buttonY','OlUvy','outputWidth','OGunr','Omieg','_data','LQQzR','Game_Troop_expTotal','commandStyle','Game_System_initialize','Game_Temp_requestAnimation','czuYE','cancel','assistResistNegatives','vcmtR','changePaintOpacity','MVkqo','round','battleAniShow','_doubleTouch','AgmIa','EVAL','hitIndex','optionsWindowRect','qfpwz','ESYoi','Game_Party_hasEncounterHalf','SByqN','scrollY','iZxsC','save','cursorUp','pageup','kmkzD','meVolume','DkZTt','expTotal','_optionsCoreFailsafeCheck','deathStateId','refreshCursor','assistExpMultiplier','text','ext','maxCols','executeHpDamage','_saving','ARRAYSTR','SoundManager_playCancel','sounds','addCommand','dropItemRate','TPwSm','createCategoryWindow','fxVAd','map','Game_Temp_showFauxAnimations','whvzB','_pageupButton','makeCommandList','1076jDkuyh','makeDataOptionsCore','constructor','wNzBH','VtGFT','nOcnT','_switchFullScreen','mainAreaTop','commandNameWindowDrawText','useItem','FontFaces','smoothScrollTo','isCommandEnabled','isHoverEnabled','klMHV','optionsCoreFonts','enabled','Graphics_switchFullScreen','isCursorMovable','name','left','_dataFunc','Scene_Base_buttonAssistText1','FwfqC','GLFYN','processHandling','SFXCursorList','Window_Options_drawItem','Game_BattlerBase_isStateResist','icon','upName','_windowLayer','initialize','umSwg','_scrollY','updateMain','FafgH','downName','downPitch','updateEffekseer','_switchStretchMode','ZioJT','RGEEW','drawItemStyleIconText','iAIyN','_scene','iconText','VolumeShortcut','auto','playSe','deselect','Scene_MenuBase_createPageButtons','checkActiveWindowPageUpDownHandlers','Scene_Boot_start','toUpperCase','iconWidth','style','changeMasterVolumeViaShortcut','15nuXGwO','hasEncounterNone','playOk','NUM','SFXBuzzerList','touchUI','Window_Options_cursorRight','rMqSO','isRepeated','64180XZhujB','cursorSFXs','right','cancelSFXs','cursorPageup','toLowerCase','display','_fullScreenOptionsCore','lZbtT','currentData','PPhBu','windowPadding','oiKfe','playMasterVolumeDown','smoothSelect','addWindow','_cancelButton','updateCoreEngineOptionsCoreWindowBgStyle','eghBf','CheckAmPresent','_battleAniSpeedLooping','textSizeEx','switchModeOptionsCore','wFovO','trim','category','_index','uvpEV','optionsCoreUpdateButtonPositions','YwxLO','198XHiKcx','JrLPb','isInputting','InputPosition','commandName','update','updateWindowPositions','randomEncounters','ZgSAS','Game_Party_hasEncounterNone','MyYle','KKwGD','assistRandomEncounters','MasterVolShortcut','1335639zCGuzN','height','helpAreaHeight','makeDeepCopy','masterVolume','qrwty','updateButtonVisibility','isPlaytest','isEnemy','UUZtX','floor','oYzrY','DataManager_setupNewGame','Enable','JKNqh','categoryWindowBgType','SoundManager_playCursor','stretchScreen','0abCdefghijklmnopqrstuvwxyz','processOk','Symbol','paintOpacity','hcbtg','clamp','kBmlT','isRightInputMode','CursorRightJS','prepareOptionsCoreSceneChange','createCommandNameWindow','onTouchSelectModern','drawTextEx','FEVOt','optionsCoreUpdateWindowPositions','_list','test','layoutSettings','create','callUpdateHelp','hasEncounterHalf','assistMapSpeed','bgmVolume','playStaticSe','euRIN','buttonAssistText1','iconHeight','addDebuff','zZaWM','isItem','version','%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.','isPressed','visible','TextJS','assistMode','eGWLl','Scene_Title_update','select','_masterVolume','initOptionsCore','QWDHj','updateOptionsCoreFailsafe','isBottomButtonMode','maxItems','CategoryStyle','_isFPSCounterOn','upPitch','CategoryTextAlign','assistConsumeItems','assistSkillCosts','push','SDsID','uiInputPosition','updateMainMultiplyOptionsCore','change','seVolume','buzzerSFXs','ARRAYJSON','\x5cI[%1]%2','_currentDrawingIndex','bgsVolume','reduce','setupNewGame','SDJDT','gOHWh','ARRAYEVAL','downVolume','prototype','commandSymbol','27951JzCCps','drJOp','cursorDown','itemTextAlign','isTriggered','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','Window_Options_processOk','refreshWindows','NoqbR','ProcessOkJS','Mnibq','YxtwZ','VDqDi','xZjaL','mhp','commandStyleCheck','requestAnimation','HvcEe','exit','DefaultJS','parse','_name','Game_Troop_goldRate','uJozG','_loading','battleAniSpeed','dvrlN','PLaBa','FUNC','Input_isTriggered','ConfigManager_makeData','Name','onTouchOk','_categoryWindow','Untitled','index','displayFPS','playCancel','_buttonAssistWindow','processVolumeShortcut','slice','buttonAssistWindowRect','drawText','assistDropMultiplier','ODmqx','_optionsWindow','onDatabaseLoaded','categoryWindowRect','children','inBattle','Settings','activate','commandRemember','shift','eTqLu','_fpsCounter','iiMYf','_isFullScreen','updateOptionsCoreScene','_requestFullScreen','Graphics_requestFullScreen','DrawJS','move','deactivate','drawItemStyleIcon','AGOtx','Mnyvu','setHandler','nCAOV','Input_isRepeated','cursorPagedown','isStateResist','optionsWindowBgType','applyDataOptionsCore','contents','call','playCursorSound','processOptionsCoreSoundEffects','commandNameWindowCenter','updateCommandNameWindow','down','match','cEVOU','OptionsSettings','getConfigValue','ZKWmE','postCreateWindows','cursorLeft','cesIQ','max','subject','setListWindow','setBackgroundType','categoryList','Scene_Battle_update','meetVolumeShortcutConditions','seCancel','isActor','wFMMy','processOptionsCoreFailsafe','_pagedownButton','opacity','YyVgT','updateOptionsSceneBgTypes','parameters','updateBattleAniSpeed','dUNrk','nHTiH','allowUpdateBattleAniSpeed','symbol','Window_Options_initialize','seOK','ARRAYFUNC','Window_Options_cursorLeft','makeData','popScene','lgRca','createOptionsWindow','Graphics_switchStretchMode','format','createPageButtons','fullScreen','WhYFX','process_VisuMZ_OptionsCore_DefaultLoad','JSON','WETzO','seCursor','List','onListCancel','Graphics_FPSCounter_switchMode','1698928HzetSj','setCategory','MqMcw','_windowTone','mainFontFace','windowTone','LoadJS','showFauxAnimations','uiHelpPosition','KNhug','setMasterVolume','onTouchSelect','categories','refresh','resetFontSettings','showRegularAnimations','SoundManager_playOk','1989912XMtzzV','createTextState','buttonAssistBgType','305740DTHuSa','_stretchEnabled','uiButtonPosition','Game_Action_executeHpDamage'];_0x357c=function(){return _0x54739c;};return _0x357c();}function Window_OptionsCategory(){const _0x349577=_0xd7df0a;this[_0x349577(0x117)](...arguments);}Window_OptionsCategory[_0xd7df0a(0x21b)]=VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x1f0)][_0xd7df0a(0x2a2)],Window_OptionsCategory[_0xd7df0a(0x1bc)]=Object[_0xd7df0a(0x18a)](Window_HorzCommand[_0xd7df0a(0x1bc)]),Window_OptionsCategory[_0xd7df0a(0x1bc)][_0xd7df0a(0x2e0)]=Window_OptionsCategory,Window_OptionsCategory[_0xd7df0a(0x1bc)][_0xd7df0a(0x117)]=function(_0x1cf38e){const _0x1b3bd9=_0xd7df0a;Window_HorzCommand['prototype'][_0x1b3bd9(0x117)]['call'](this,_0x1cf38e),this[_0x1b3bd9(0x182)](_0x1cf38e);},Window_OptionsCategory[_0xd7df0a(0x1bc)]['isUseModernControls']=function(){const _0x872d54=_0xd7df0a;return Imported['VisuMZ_0_CoreEngine']&&Window_HorzCommand['prototype'][_0x872d54(0x28c)][_0x872d54(0x209)](this);},Window_OptionsCategory['prototype']['createCommandNameWindow']=function(_0x58b58a){const _0x44e9e9=_0xd7df0a,_0x4dca05=new Rectangle(0x0,0x0,_0x58b58a[_0x44e9e9(0x293)],_0x58b58a[_0x44e9e9(0x167)]);this['_commandNameWindow']=new Window_Base(_0x4dca05),this['_commandNameWindow'][_0x44e9e9(0x223)]=0x0,this['addChild'](this[_0x44e9e9(0x283)]),this[_0x44e9e9(0x20d)]();},Window_OptionsCategory['prototype'][_0xd7df0a(0x18b)]=function(){const _0x29b9c3=_0xd7df0a;Window_HorzCommand['prototype']['callUpdateHelp'][_0x29b9c3(0x209)](this);if(this['_commandNameWindow'])this['updateCommandNameWindow']();},Window_OptionsCategory[_0xd7df0a(0x1bc)][_0xd7df0a(0x20d)]=function(){const _0x13c7f3=_0xd7df0a,_0x3ff45a=this[_0x13c7f3(0x283)];_0x3ff45a['contents']['clear']();const _0x13bc18=this[_0x13c7f3(0x1cd)](this[_0x13c7f3(0x1e1)]());if(_0x13bc18===_0x13c7f3(0x114)){const _0x495b79=this['itemLineRect'](this[_0x13c7f3(0x1e1)]());let _0x4083df=this[_0x13c7f3(0x15c)](this[_0x13c7f3(0x1e1)]());_0x4083df=_0x4083df[_0x13c7f3(0x259)](/\\I\[(\d+)\]/gi,''),_0x3ff45a[_0x13c7f3(0x24e)](),this['commandNameWindowDrawBackground'](_0x4083df,_0x495b79),this[_0x13c7f3(0x2e6)](_0x4083df,_0x495b79),this[_0x13c7f3(0x20c)](_0x4083df,_0x495b79);}},Window_OptionsCategory[_0xd7df0a(0x1bc)]['commandNameWindowDrawBackground']=function(_0x1d65c0,_0x4c1455){},Window_OptionsCategory['prototype']['processCursorHomeEndTrigger']=function(){},Window_OptionsCategory[_0xd7df0a(0x1bc)]['commandNameWindowDrawText']=function(_0x18ede7,_0x29ca31){const _0x419c0f=_0xd7df0a,_0xd90502=this['_commandNameWindow'];_0xd90502[_0x419c0f(0x1e8)](_0x18ede7,0x0,_0x29ca31['y'],_0xd90502['innerWidth'],_0x419c0f(0x268));},Window_OptionsCategory[_0xd7df0a(0x1bc)][_0xd7df0a(0x20c)]=function(_0x152024,_0x5f3e77){const _0x1d22c1=_0xd7df0a,_0x716e1b=this[_0x1d22c1(0x283)],_0xd4fdc9=$gameSystem[_0x1d22c1(0x145)](),_0x189d81=_0x5f3e77['x']+Math[_0x1d22c1(0x170)](_0x5f3e77[_0x1d22c1(0x293)]/0x2)+_0xd4fdc9;_0x716e1b['x']=_0x716e1b['width']/-0x2+_0x189d81,_0x716e1b['y']=Math['floor'](_0x5f3e77['height']/0x2);},Window_OptionsCategory[_0xd7df0a(0x1bc)][_0xd7df0a(0x2ce)]=function(){const _0x111aa3=_0xd7df0a;return this[_0x111aa3(0x187)]?this[_0x111aa3(0x187)][_0x111aa3(0x28b)]:0x1;},Window_OptionsCategory[_0xd7df0a(0x1bc)][_0xd7df0a(0x219)]=function(_0x110a05){const _0x52a326=_0xd7df0a;this[_0x52a326(0x1eb)]=_0x110a05,this['refresh']();},Window_OptionsCategory['prototype'][_0xd7df0a(0x15d)]=function(){const _0x419de6=_0xd7df0a;Window_HorzCommand[_0x419de6(0x1bc)][_0x419de6(0x15d)][_0x419de6(0x209)](this);if(this[_0x419de6(0x1eb)]){if(_0x419de6(0x228)!==_0x419de6(0x2b7))this[_0x419de6(0x1eb)][_0x419de6(0x241)](this[_0x419de6(0x143)]());else{const _0xea72be=this[_0x419de6(0x1e1)](),_0x4293af=this['hitIndex']();_0x4293af>=0x0&&_0x4293af!==this[_0x419de6(0x1e1)]()&&this['select'](_0x4293af),_0x167a25&&this[_0x419de6(0x1e1)]()!==_0xea72be&&this['playCursorSound']();}}},Window_OptionsCategory[_0xd7df0a(0x1bc)][_0xd7df0a(0x29a)]=function(){const _0x14e809=_0xd7df0a;if(this[_0x14e809(0x109)]()){const _0x5a173d=this[_0x14e809(0x1e1)]();Input['isRepeated'](_0x14e809(0x29c))&&this[_0x14e809(0x285)](Input[_0x14e809(0x1c2)](_0x14e809(0x29c)));if(Input['isRepeated']('pageup')){if('RGEEW'===_0x14e809(0x121))this[_0x14e809(0x215)](Input[_0x14e809(0x1c2)](_0x14e809(0x2c3)));else return _0x3984db['OptionsCore'][_0x14e809(0x1f0)][_0x14e809(0x211)][_0x14e809(0x1a5)];}this[_0x14e809(0x1e1)]()!==_0x5a173d&&this[_0x14e809(0x20a)]();}},Window_OptionsCategory[_0xd7df0a(0x1bc)]['processHandling']=function(){const _0x1ea06c=_0xd7df0a;if(this['isUseModernControls']())return;Window_HorzCommand['prototype'][_0x1ea06c(0x110)][_0x1ea06c(0x209)](this);},Window_OptionsCategory[_0xd7df0a(0x1bc)][_0xd7df0a(0x104)]=function(){const _0x27d82b=_0xd7df0a;if(this[_0x27d82b(0x28c)]()){if(_0x27d82b(0x265)!==_0x27d82b(0x144))return![];else{const _0x18fa1f=_0x23e976[_0x27d82b(0x189)][_0x27d82b(0x292)]||0x0,_0x5bb8c6=[this[_0x27d82b(0x1df)],this[_0x27d82b(0x1eb)],this[_0x27d82b(0x1e4)]];for(const _0xcd51a4 of _0x5bb8c6){if(_0xcd51a4)_0xcd51a4[_0x27d82b(0x21a)](_0x18fa1f);}}}else return Window_HorzCommand[_0x27d82b(0x1bc)][_0x27d82b(0x104)][_0x27d82b(0x209)](this);},Window_OptionsCategory['prototype']['processTouchModernControls']=function(){const _0xc0b7d8=_0xd7df0a;if(this[_0xc0b7d8(0x26d)]()){if(TouchInput['isTriggered']()){if('MqQqA'!==_0xc0b7d8(0x1cb))this[_0xc0b7d8(0x24b)](!![]);else{return _0x13fd47[_0xc0b7d8(0x27e)]['call'](this);;}}if(TouchInput['isClicked']())this[_0xc0b7d8(0x1de)]();else TouchInput['isCancelled']()&&(_0xc0b7d8(0x2b3)!==_0xc0b7d8(0x1c9)?this[_0xc0b7d8(0x28f)]():_0x4a87ad*=0x2**(_0x388d6c['assistGoldMultiplier']||0x0));}},Window_OptionsCategory['prototype']['onTouchSelect']=function(_0x5cdce2){const _0x1fd619=_0xd7df0a;if(this['isUseModernControls']()){if(_0x1fd619(0x1a1)===_0x1fd619(0x1cf))return _0x59dff4[_0x1fd619(0x272)]&&_0x1699b8['prototype'][_0x1fd619(0x28c)]['call'](this);else this['onTouchSelectModern'](!![]);}else Window_HorzCommand[_0x1fd619(0x1bc)][_0x1fd619(0x24b)][_0x1fd619(0x209)](this,_0x5cdce2);},Window_OptionsCategory[_0xd7df0a(0x1bc)][_0xd7df0a(0x183)]=function(_0x1b8610){const _0x321106=_0xd7df0a;this[_0x321106(0x2b6)]=![];if(this[_0x321106(0x109)]()){const _0x203415=this[_0x321106(0x1e1)](),_0x183206=this[_0x321106(0x2b9)]();_0x183206>=0x0&&_0x183206!==this[_0x321106(0x1e1)]()&&this[_0x321106(0x19e)](_0x183206),_0x1b8610&&this[_0x321106(0x1e1)]()!==_0x203415&&this[_0x321106(0x20a)]();}},Window_OptionsCategory['prototype'][_0xd7df0a(0x2dd)]=function(){const _0xca7f3e=_0xd7df0a;for(const _0x253e50 of Window_OptionsCategory['categoryList']){if(!_0x253e50['ShowJS'][_0xca7f3e(0x209)](this))continue;const _0x1fc406=this['commandStyle'](),_0x16d055=_0x253e50[_0xca7f3e(0x1dd)],_0x182a8f=_0x253e50[_0xca7f3e(0x294)],_0x19ea09=_0x1fc406===_0xca7f3e(0x2cc)?_0x16d055:_0xca7f3e(0x1b3)[_0xca7f3e(0x235)](_0x182a8f,_0x16d055),_0x4e465c=_0x253e50[_0xca7f3e(0x23d)];this[_0xca7f3e(0x2d4)](_0x19ea09,_0xca7f3e(0x153),!![],_0x4e465c);}},Window_OptionsCategory[_0xd7df0a(0x1bc)][_0xd7df0a(0x1c1)]=function(){const _0x414ccc=_0xd7df0a;return VisuMZ[_0x414ccc(0x267)][_0x414ccc(0x1f0)][_0x414ccc(0x211)][_0x414ccc(0x1a8)];},Window_OptionsCategory['prototype'][_0xd7df0a(0x280)]=function(_0x27e00c){const _0x2d2b45=_0xd7df0a,_0x207dbd=this['commandStyleCheck'](_0x27e00c);if(_0x207dbd===_0x2d2b45(0x125))this[_0x2d2b45(0x122)](_0x27e00c);else{if(_0x207dbd===_0x2d2b45(0x114))this[_0x2d2b45(0x1fe)](_0x27e00c);else{if(_0x2d2b45(0x151)==='wFovO')Window_HorzCommand[_0x2d2b45(0x1bc)][_0x2d2b45(0x280)]['call'](this,_0x27e00c);else{_0x7a6f3b&&_0x14b47f['displayFPS']!==_0x34af77&&(_0x308b01[_0x2d2b45(0x1e2)]=_0x4cd58a[_0x2d2b45(0x1a6)](),_0x9a2984['save']());if(_0x426e61&&_0x12c2f7[_0x2d2b45(0x124)]){const _0x1b62c8=_0x184ec4['_scene'];_0x1b62c8[_0x2d2b45(0x156)](),_0x1b62c8[_0x2d2b45(0x2e0)]===_0x443ce9&&_0x1b62c8[_0x2d2b45(0x1c5)]();}}}}},Window_OptionsCategory[_0xd7df0a(0x1bc)][_0xd7df0a(0x2ab)]=function(){const _0xe1a9b0=_0xd7df0a;return VisuMZ[_0xe1a9b0(0x267)][_0xe1a9b0(0x1f0)]['OptionsSettings']['CategoryStyle'];},Window_OptionsCategory[_0xd7df0a(0x1bc)][_0xd7df0a(0x1cd)]=function(_0xda3a29){const _0x7f2e62=_0xd7df0a;if(_0xda3a29<0x0)return'text';const _0x4d0b1e=this[_0x7f2e62(0x2ab)]();if(_0x4d0b1e!==_0x7f2e62(0x127))return _0x4d0b1e;else{if(this[_0x7f2e62(0x1a4)]()>0x0){if(_0x7f2e62(0x160)===_0x7f2e62(0x1c6)){if(_0x201bef&&_0x2712cd[_0x7f2e62(0x23c)]!==_0x542547){if(_0x4c797c[_0x7f2e62(0x23c)]>0x0){const _0x3c2d88=_0x1255ea[_0x7f2e62(0x13b)][_0x5dd231[_0x7f2e62(0x23c)]];if(_0x3c2d88)return _0x5140ec[_0x7f2e62(0x18f)](_0x3c2d88);}}_0x57a938[_0x7f2e62(0x267)][_0x7f2e62(0x176)][_0x7f2e62(0x209)](this);}else{const _0x3962e8=this[_0x7f2e62(0x15c)](_0xda3a29);if(_0x3962e8[_0x7f2e62(0x20f)](/\\I\[(\d+)\]/i)){const _0x50cf5c=this[_0x7f2e62(0x286)](_0xda3a29),_0x3fe080=this[_0x7f2e62(0x14f)](_0x3962e8)['width'];if(_0x3fe080<=_0x50cf5c['width'])return _0x7f2e62(0x1ff)!==_0x7f2e62(0x1d5)?_0x7f2e62(0x125):_0x21ba20['status']&&_0x4ed8f2[_0x7f2e62(0x264)]['includes']('['+_0x530c35+']');else{if(_0x7f2e62(0x2bc)!==_0x7f2e62(0x242))return _0x7f2e62(0x114);else _0x3f4c0e(_0x7f2e62(0x1c3)[_0x7f2e62(0x235)](_0x4fb536,_0x52dec2)),_0x37d9b6[_0x7f2e62(0x1d0)]();}}}}}return'text';},Window_OptionsCategory[_0xd7df0a(0x1bc)][_0xd7df0a(0x122)]=function(_0xe24762){const _0x161455=_0xd7df0a,_0x235755=this['itemLineRect'](_0xe24762),_0x221c70=this['commandName'](_0xe24762),_0xe589b1=this[_0x161455(0x14f)](_0x221c70)[_0x161455(0x293)];this[_0x161455(0x2b2)](this[_0x161455(0x103)](_0xe24762));const _0x45f6e2=this[_0x161455(0x1c1)]();if(_0x45f6e2===_0x161455(0x13c))this[_0x161455(0x184)](_0x221c70,_0x235755['x']+_0x235755['width']-_0xe589b1,_0x235755['y'],_0xe589b1);else{if(_0x45f6e2===_0x161455(0x268)){const _0x5aad84=_0x235755['x']+Math[_0x161455(0x170)]((_0x235755['width']-_0xe589b1)/0x2);this[_0x161455(0x184)](_0x221c70,_0x5aad84,_0x235755['y'],_0xe589b1);}else{if(_0x161455(0x2e3)===_0x161455(0x297)){let _0x33c00b=_0x3bb7da[_0x161455(0x267)]['Game_Troop_expTotal'][_0x161455(0x209)](this);return _0x3f3e6c[_0x161455(0x19b)]&&(_0x33c00b*=0x2**(_0x5da618[_0x161455(0x2cb)]||0x0)),_0x33c00b;}else this[_0x161455(0x184)](_0x221c70,_0x235755['x'],_0x235755['y'],_0xe589b1);}}},Window_OptionsCategory['prototype'][_0xd7df0a(0x1fe)]=function(_0x4a9810){const _0xc749c5=_0xd7df0a;this[_0xc749c5(0x15c)](_0x4a9810)[_0xc749c5(0x20f)](/\\I\[(\d+)\]/i);const _0x296538=Number(RegExp['$1'])||0x0,_0x12902b=this[_0xc749c5(0x286)](_0x4a9810),_0x194993=_0x12902b['x']+Math[_0xc749c5(0x170)]((_0x12902b[_0xc749c5(0x293)]-ImageManager[_0xc749c5(0x12e)])/0x2),_0x791b3a=_0x12902b['y']+(_0x12902b[_0xc749c5(0x167)]-ImageManager[_0xc749c5(0x192)])/0x2;this['drawIcon'](_0x296538,_0x194993,_0x791b3a);},VisuMZ[_0xd7df0a(0x267)]['Window_Options_initialize']=Window_Options[_0xd7df0a(0x1bc)]['initialize'],Window_Options[_0xd7df0a(0x1bc)][_0xd7df0a(0x117)]=function(_0x143929){const _0x16c3ed=_0xd7df0a;this[_0x16c3ed(0x1d3)]=null,this[_0x16c3ed(0x2a8)]=null,VisuMZ[_0x16c3ed(0x267)][_0x16c3ed(0x22c)][_0x16c3ed(0x209)](this,_0x143929);},Window_Options[_0xd7df0a(0x1bc)][_0xd7df0a(0x28c)]=function(){const _0x55c8fb=_0xd7df0a;return Imported[_0x55c8fb(0x272)]&&Window_HorzCommand[_0x55c8fb(0x1bc)]['isUseModernControls'][_0x55c8fb(0x209)](this);},Window_Options[_0xd7df0a(0x1bc)]['processCursorMoveModernControls']=function(){const _0x5173f7=_0xd7df0a;if(this['isCursorMovable']()){const _0x4b5a42=this[_0x5173f7(0x1e1)]();Input[_0x5173f7(0x139)](_0x5173f7(0x20e))&&(Input['isPressed'](_0x5173f7(0x1f3))?this[_0x5173f7(0x204)]():this[_0x5173f7(0x1c0)](Input[_0x5173f7(0x1c2)](_0x5173f7(0x20e))));if(Input[_0x5173f7(0x139)]('up')){if(_0x5173f7(0x2be)!=='SByqN')return _0x24defe[_0x5173f7(0x267)][_0x5173f7(0x1e5)](_0x4a7376),![];else{if(Input[_0x5173f7(0x198)]('shift')){if(_0x5173f7(0x10e)!==_0x5173f7(0x17e))this[_0x5173f7(0x13e)]();else{const _0x1ad0fc=_0x1c3578[_0x5173f7(0x267)]['Settings']['OptionsSettings'];if(this[_0x5173f7(0x1df)]){const _0xbc17da=_0x1ad0fc[_0x5173f7(0x175)]??0x0;this[_0x5173f7(0x1df)][_0x5173f7(0x21a)](_0xbc17da);}if(this['_optionsWindow']){const _0x35841f=_0x1ad0fc[_0x5173f7(0x206)]??0x0;this[_0x5173f7(0x1eb)][_0x5173f7(0x21a)](_0x35841f);}if(this[_0x5173f7(0x1e4)]){const _0x13269f=_0x1ad0fc[_0x5173f7(0x253)]??0x0;this[_0x5173f7(0x1e4)][_0x5173f7(0x21a)](_0x13269f);}}}else this[_0x5173f7(0x2c2)](Input[_0x5173f7(0x1c2)]('up'));}}Input['isRepeated'](_0x5173f7(0x13c))&&this[_0x5173f7(0x285)](Input[_0x5173f7(0x1c2)](_0x5173f7(0x13c))),Input[_0x5173f7(0x139)](_0x5173f7(0x10b))&&this['cursorLeft'](Input[_0x5173f7(0x1c2)](_0x5173f7(0x10b))),this[_0x5173f7(0x1e1)]()!==_0x4b5a42&&this[_0x5173f7(0x20a)]();}},Window_Options[_0xd7df0a(0x1bc)][_0xd7df0a(0x241)]=function(_0x1489a1){const _0x46ebe6=_0xd7df0a;if(!_0x1489a1)return;if(_0x1489a1['name']===this[_0x46ebe6(0x1d3)])return;this[_0x46ebe6(0x1d3)]=_0x1489a1['name'],this['_data']=_0x1489a1[_0x46ebe6(0x2cd)],this[_0x46ebe6(0x102)](0x0,0x0),this[_0x46ebe6(0x24d)]();if(this['isUseModernControls']())this['smoothSelect'](0x0);},Window_Options[_0xd7df0a(0x1bc)][_0xd7df0a(0x2dd)]=function(){const _0x497313=_0xd7df0a;if(!this[_0x497313(0x2a8)])return;this[_0x497313(0x10c)]=[];for(const _0x2cd8bd of this['_data']){if('iZxsC'===_0x497313(0x2c0)){if(!_0x2cd8bd['ShowJS']['call'](this))continue;let _0x48ad22=_0x2cd8bd['TextStr'];if(['',_0x497313(0x1e0)]['includes'](_0x48ad22))_0x48ad22=_0x2cd8bd[_0x497313(0x19a)][_0x497313(0x209)](this);const _0x270512=_0x2cd8bd['Icon'];_0x270512>0x0&&('NXEVu'!==_0x497313(0x1bf)?_0x48ad22=_0x497313(0x1b3)[_0x497313(0x235)](_0x270512,_0x48ad22):(this[_0x497313(0x1eb)][_0x497313(0x1fd)](),this['_optionsWindow']['deselect']()));const _0x2fce51=_0x2cd8bd[_0x497313(0x17a)],_0xa30b6=_0x2cd8bd['EnableJS'][_0x497313(0x209)](this),_0x5d2a49=_0x2cd8bd[_0x497313(0x273)]['call'](this);this[_0x497313(0x2d4)](_0x48ad22,_0x2fce51,_0xa30b6,_0x5d2a49),this[_0x497313(0x10c)][_0x497313(0x1ab)](_0x2cd8bd);}else{const _0xd4257e=_0x5bf561['okSFXs'][_0x403f4e['seOK']];if(_0xd4257e)return _0x12f8f6['playStaticSe'](_0xd4257e);}}},VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x112)]=Window_Options[_0xd7df0a(0x1bc)][_0xd7df0a(0x280)],Window_Options[_0xd7df0a(0x1bc)][_0xd7df0a(0x280)]=function(_0x582cce){const _0x43c59f=_0xd7df0a;this[_0x43c59f(0x24e)](),this['changePaintOpacity'](this[_0x43c59f(0x103)](_0x582cce));const _0x201457=this['_list'][_0x582cce][_0x43c59f(0x22b)];this[_0x43c59f(0x1b4)]=_0x582cce;try{if(_0x43c59f(0x185)!==_0x43c59f(0x10f))this[_0x43c59f(0x10c)][_0x582cce][_0x43c59f(0x1fb)][_0x43c59f(0x209)](this,_0x201457,_0x582cce);else{const _0x19faf6=_0x5e611f[_0x43c59f(0x124)];_0x19faf6[_0x43c59f(0x156)](),_0x19faf6[_0x43c59f(0x2e0)]===_0x408255&&_0x19faf6['refreshWindows']();}}catch(_0x315b3e){VisuMZ[_0x43c59f(0x267)][_0x43c59f(0x112)][_0x43c59f(0x209)](this,_0x582cce);}this[_0x43c59f(0x1b4)]=undefined;},VisuMZ['OptionsCore'][_0xd7df0a(0x1c4)]=Window_Options[_0xd7df0a(0x1bc)][_0xd7df0a(0x179)],Window_Options[_0xd7df0a(0x1bc)][_0xd7df0a(0x179)]=function(){const _0x4ec22d=_0xd7df0a,_0x4d4a11=this[_0x4ec22d(0x1e1)](),_0x2a2fbf=this[_0x4ec22d(0x1bd)](_0x4d4a11);if(!this['isCommandEnabled'](_0x4d4a11)){this[_0x4ec22d(0x266)]();return;}try{if(_0x4ec22d(0x1b8)!=='LQGpT')this['_dataFunc'][_0x4d4a11][_0x4ec22d(0x1c7)]['call'](this,_0x2a2fbf,_0x4d4a11);else return _0x4ec22d(0x125);}catch(_0x4d95d8){_0x4ec22d(0x274)!==_0x4ec22d(0x216)?VisuMZ[_0x4ec22d(0x267)][_0x4ec22d(0x1c4)][_0x4ec22d(0x209)](this):_0x1c7a79['_scene'][_0x4ec22d(0x16c)]();}},VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x137)]=Window_Options['prototype'][_0xd7df0a(0x285)],Window_Options['prototype'][_0xd7df0a(0x285)]=function(){const _0x563cd4=_0xd7df0a,_0x597d8f=this[_0x563cd4(0x1e1)](),_0x611bf0=this[_0x563cd4(0x1bd)](_0x597d8f);if(!this[_0x563cd4(0x103)](_0x597d8f)){this[_0x563cd4(0x266)]();return;}try{this[_0x563cd4(0x10c)][_0x597d8f][_0x563cd4(0x180)][_0x563cd4(0x209)](this,_0x611bf0,_0x597d8f);}catch(_0x205a15){VisuMZ[_0x563cd4(0x267)][_0x563cd4(0x137)][_0x563cd4(0x209)](this);}},VisuMZ[_0xd7df0a(0x267)][_0xd7df0a(0x22f)]=Window_Options[_0xd7df0a(0x1bc)][_0xd7df0a(0x215)],Window_Options['prototype'][_0xd7df0a(0x215)]=function(){const _0x3fba17=_0xd7df0a,_0x2c983e=this[_0x3fba17(0x1e1)](),_0x400cb9=this[_0x3fba17(0x1bd)](_0x2c983e);if(!this[_0x3fba17(0x103)](_0x2c983e)){this[_0x3fba17(0x266)]();return;}try{this[_0x3fba17(0x10c)][_0x2c983e][_0x3fba17(0x298)]['call'](this,_0x400cb9,_0x2c983e);}catch(_0x55c288){if(_0x3fba17(0x1ca)!==_0x3fba17(0x1ca)){if(_0x11dcb1[_0x3fba17(0x22d)]>0x0){const _0x51708f=_0x50872c[_0x3fba17(0x262)][_0x5117fe[_0x3fba17(0x22d)]];if(_0x51708f)return _0x3fb5ff[_0x3fba17(0x18f)](_0x51708f);}}else VisuMZ['OptionsCore'][_0x3fba17(0x22f)][_0x3fba17(0x209)](this);}},Window_Options[_0xd7df0a(0x1bc)][_0xd7df0a(0x212)]=function(_0x3578c1){return ConfigManager[_0x3578c1];},Window_Options[_0xd7df0a(0x1bc)]['setConfigValue']=function(_0x1e28bc,_0x4e7e43){ConfigManager[_0x1e28bc]=_0x4e7e43;},Window_Options['prototype'][_0xd7df0a(0x181)]=function(){const _0x3f6560=_0xd7df0a;$gameTemp['_returnOptionsCore']={'category':SceneManager[_0x3f6560(0x124)]['_categoryWindow']['index'](),'index':this[_0x3f6560(0x1e1)](),'scrollX':this[_0x3f6560(0x289)],'scrollY':this['_scrollY']};},Window_Options[_0xd7df0a(0x1bc)]['updateButtonVisibility']=function(){const _0x7ae8c1=_0xd7df0a;SceneManager[_0x7ae8c1(0x124)][_0x7ae8c1(0x16c)]();},Window_Options[_0xd7df0a(0x1bc)][_0xd7df0a(0x271)]=function(){const _0x2ff4ac=_0xd7df0a;SceneManager['_scene'][_0x2ff4ac(0x156)]();},Window_Options[_0xd7df0a(0x1bc)][_0xd7df0a(0x15e)]=function(){const _0x380ac7=_0xd7df0a;SceneManager[_0x380ac7(0x124)]['optionsCoreUpdateWindowPositions']();},Window_Options[_0xd7df0a(0x1bc)][_0xd7df0a(0x1c5)]=function(){const _0x3b957e=_0xd7df0a;if(SceneManager[_0x3b957e(0x124)][_0x3b957e(0x2e0)]!==Scene_Options)return;SceneManager[_0x3b957e(0x124)][_0x3b957e(0x1c5)]();},Window_Options['prototype'][_0xd7df0a(0x1e8)]=function(_0x39a926,_0x3679fa,_0x4db213,_0x2e0e37,_0x1ea91c){const _0x2c3250=_0xd7df0a,_0x176f73=this[_0x2c3250(0x208)]['paintOpacity'];this['_currentDrawingIndex']>=0x0&&(_0x2c3250(0x2a0)!=='ZgfWO'?this[_0x2c3250(0x2c2)](_0x40ff37[_0x2c3250(0x1c2)]('up')):!this[_0x2c3250(0x103)](this[_0x2c3250(0x1b4)])&&this[_0x2c3250(0x2b2)](![])),Window_Command[_0x2c3250(0x1bc)]['drawText'][_0x2c3250(0x209)](this,_0x39a926,_0x3679fa,_0x4db213,_0x2e0e37,_0x1ea91c),this[_0x2c3250(0x208)][_0x2c3250(0x17b)]=_0x176f73;},Window_Options['prototype'][_0xd7df0a(0x184)]=function(_0x38d11a,_0xf44cc7,_0x23d2e7,_0x4e7cf9){const _0x4ab121=_0xd7df0a;this['resetFontSettings']();const _0x2d4f27=this['contents'][_0x4ab121(0x17b)];if(this[_0x4ab121(0x1b4)]>=0x0){if(!this[_0x4ab121(0x103)](this[_0x4ab121(0x1b4)])){if(_0x4ab121(0x138)===_0x4ab121(0x120))return this[_0x4ab121(0x12b)]();else this['changePaintOpacity'](![]);}}const _0x1a5005=this[_0x4ab121(0x252)](_0x38d11a,_0xf44cc7,_0x23d2e7,_0x4e7cf9);this['processAllText'](_0x1a5005);const _0x44278c=_0x1a5005[_0x4ab121(0x2a5)];return this[_0x4ab121(0x208)][_0x4ab121(0x17b)]=_0x2d4f27,_0x44278c;};