/*:
 * @target MZ
 * @plugindesc 自分用プラグイン。
 * @author 萌工房
 *
 * @help
 * 自分用プラグイン。
 */

(() => {
    // 文字列変数を管理するためのオブジェクトを初期化
    const _Game_Variables_initialize = Game_Variables.prototype.initialize;
    Game_Variables.prototype.initialize = function() {
        _Game_Variables_initialize.call(this);
        this._stringVariables = {}; // 文字列変数用の領域を追加
    };

    // 文字列変数の設定
    Game_Variables.prototype.setString = function(variableId, value) {
        this._stringVariables[variableId] = value;
    };

    // 文字列変数の取得
    Game_Variables.prototype.getString = function(variableId) {
        return this._stringVariables[variableId] || "";
    };

    // セーブデータ作成時に文字列変数を含める
    const _DataManager_makeSaveContents = DataManager.makeSaveContents;
    DataManager.makeSaveContents = function() {
        const contents = _DataManager_makeSaveContents.call(this);
        contents.stringVariables = $gameVariables._stringVariables;
        return contents;
    };

    // ロードデータ復元時に文字列変数を復元
    const _DataManager_extractSaveContents = DataManager.extractSaveContents;
    DataManager.extractSaveContents = function(contents) {
        _DataManager_extractSaveContents.call(this, contents);
        $gameVariables._stringVariables = contents.stringVariables || {};
    };
})();