/*=============================================================================
MaxFpsLimit.js
----------------------------------------------------------------------------

----------------------------------------------------------------------------
Version
1.0.0 2025/07/23 初版
----------------------------------------------------------------------------
参考
https://steamcommunity.com/app/363890/discussions/3/483368526578128878/?l=japanese
https://forums.rpgmakerweb.com/index.php?threads/how-to-limit-max-fps-to-50-60-in-rmmz.133226/
=============================================================================*/

/*:
 * @plugindesc MaxFpsLimit
 * @target MZ
 
 * @param maxfps
 * @text FPSの最大値
 * @desc FPSの最大値を設定してください。ゲームは設定した値を超えないように調整されます。
 * @default 60
 * @type number
 */

Graphics._createPixiApp = function() {
    try {
        this._setupPixi();
        this._app = new PIXI.Application({
            view: this._canvas,
            autoStart: false
        });
        this._app.ticker.remove(this._app.render, this._app);
        this._app.ticker.add(this._onTick, this);


        // << Begining of our changes
        const myMaxFPS = Number(PluginManager.parameters('MaxFpsLimit')['maxfps']);
        this._app.ticker.maxFPS = myMaxFPS;
        // >> End of our changes


    } catch (e) {
        this._app = null;
    }
};