/*:ja
 * @plugindesc 自作セーブ
 * @author kido
 * @help
 *   イベントフラグのセーブ・ロード
 *   使用方法: 
 *    
 *    セーブするとき: MySave save;
 *    ロードするとき: MySave load;
 *    ロードデータのチェック: MySave check;
 */

(function(){
	'use strict';
	
	const path = require('path');
	const fs = require('fs');

	var pluginName = "MySave";

	//プラグインコマンド定義
	var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;

	Game_Interpreter.prototype.pluginCommand = function(command, args) {
	_Game_Interpreter_pluginCommand.call(this, command, args);

		if( command === pluginName ) 
		{
			switch(args[0])
			{
				case 'save':
					save();
					break;
			
				case 'load':
					load();
					break;
				
				case 'check':
					check();
					break;
			}
		}
	}
	
	const save = function()
	{
		var projectFilePath = decodeURIComponent(path.dirname(window.location.pathname.slice(1)));
		let directoryPath = projectFilePath + '\\save\\';
		let val = $gameVariables.value(41);

		if(!exists(directoryPath))
		{
			console.log("ディレクトリがありません");
			return;
		}
	
		fs.writeFileSync(directoryPath + 'common.rpgsave', val);
	}
	
	const load = function()
	{
		var projectFilePath = decodeURIComponent(path.dirname(window.location.pathname.slice(1)));
		
		console.log("projectFilePath = " + projectFilePath);
		let directoryPath = projectFilePath + '\\save\\';
		//let val = $gameVariables.value(41);
		
		if(!exists(directoryPath))
		{
			console.log("ディレクトリがありません");
			$gameVariables.setValue(42, -1);
			return;
		}
		
		let text = fs.readFileSync(directoryPath + 'common.rpgsave', 'utf-8');
		$gameVariables.setValue(42, text);
	}
	
	const exists = function(path)
	{
		return fs.existsSync(path);
	}
	
	const check = function()
	{
		var projectFilePath = decodeURIComponent(path.dirname(window.location.pathname.slice(1)));
		let _path = projectFilePath + '\\save\\common.rpgsave';
		let isExists = exists(_path);
		$gameSwitches.setValue(77, isExists);
	}	

	})();
