/*:
@plugindesc
3D rendering for RPG Maker MV, 
version 0.6.8.2 (Demo)
@author Cutievirus

@help
Requires RPG Maker MV
	
This is a demo version of MV3D. The full version is available at
itch.io or patreon.

https://cutievirus.itch.io/mv3d
https://www.patreon.com/cutievirus


For assistance with the plugin, please join the discord:

Discord: http://cutievirus.com/discord  


For full documentation, please see the wiki:

https://mv3d.cutievirus.com/documentation



## Patron Heroes:

- Rikyu
- AMemoryofEternity 
- Fyoha
- 冬空 橙
- Anthony Xue
- Ricky Smith
- Lynn Grant
- kim marberry
- Samuel LESPES CARDILLO
- Ham
- Brendan Belton
- Mark Toman
- Decayingdev
- Donald Purvis
- Brandi K
- WeakWasabi 
- Logan Swartz

## Patron Knights:

- CattleDog
- hsumi1 .
- AmalgamAsh
- L
- Nemo Ma
- Clumsydemonwithfire 
- Matteo Calbi
- RetroChaos
- noone
- Rareica
- Jimmy McCarney
- JosephSeraph 
- Joseph Reyes
- Brendan Lundy
- stevens tavares
- SuperNick
- Harmless 
- Miolhr 
- Marcel Ka
- + 1 hidden




@command command
@text Legacy Command
@desc Use the old command syntax

@arg command
@text Command
@desc Enter the command without the mv3d/mz3d prefix.


@command animation
@text Play Animation
@desc 

@arg id
@text Animation
@type animation
@default 1

@arg target
@text Target
@desc Enter the event id or "player". Blank for current event.

@arg scale
@text Scale
@type number
@decimals 4
@min 0.0001
@default 1

@arg rot
@text Rotation
@desc The rotation angle of the animation. If "auto", matches camera rotation.
@type number
@decimals 0
@min 0 @max 360
@default auto

@arg depth
@text Depth
@desc If enabled, postprocessing will be disabled while the animation is playing.
@type boolean
@default false

@arg height
@text Height Offset
@desc Offsets the z position of the animation.
@type number
@decimals 4
@min -9999 @max 9999
@default 0


@command camera
@text Camera
@desc Change the camera settings.

@arg pitch
@text Pitch
@desc Aims the camera up and down
@type number
@decimals 0
@min 0
@max 180

@arg yaw
@text Yaw
@desc Rotates the camera around the target
@type number
@decimals 0
@min 0
@max 360

@arg roll
@text Roll
@desc Tilts the camera side to side
@type number
@decimals 0
@min -360
@max 360

@arg dist
@text Distance
@desc The distance of the camera to the target (0=first person)
@type number
@decimals 3
@min 0

@arg zoom
@text Zoom
@desc Modifies the FOV to zoom the camera.
@type number
@decimals 4
@min -9999
@max 9999

@arg height
@text Height
@desc The height of the camera.
@type number
@decimals 3

@arg mode
@text Mode
@desc Switch between perspective mode and orthographic mode.
@type select
@option perspective
@option orthographic

@arg follow
@text Follow Target
@desc Which character should the camera follow?
(enter the event id, or the word "player")

@arg pan
@text Pan
@desc Pan the camera away from the target
@type struct<XY>

@arg time
@text Time
@desc Time in seconds to complete transition
@type number
@decimals 3
@min 0
@default 1


@command cameraTrack
@text Camera Tracking
@desc Automatically rotate the camera to face the tracking target.

@arg target
@text Target
@desc Enter the event id or "player". Leave blank to disable.

@arg trackYaw
@text Track Yaw
@type boolean
@default true

@arg trackPitch
@text Track Pitch
@type boolean
@default true

@arg time
@text Smoothness
@desc How smoothly the target will be tracked. Higher number = slower.
@type number
@decimals 3
@default 0


@command fog
@text Fog
@desc Change fog settings.

@arg color
@text Fog Color

@arg near
@text Start Distance
@type number
@decimals 3

@arg far
@text End Distance
@type number
@decimals 3

@arg time
@text Time
@type number
@decimals 3
@default 1


@command light
@text Lighting
@desc Change light settings.

@arg color
@text Ambient Color
@desc The ambient light lights everything in the scene.

@arg time
@text Time
@type number
@decimals 0
@default 1


@command lamp
@text Lamp
@desc Add a lamp lightsource to a character.

@arg target
@text Target
@desc Enter the event id or "player". Blank for current event.

@arg color
@text Color

@arg intensity
@text Intensity
@type number
@decimals 3
@min 0

@arg dist
@text Distance
@desc How far the light will travel.
@type number
@decimals 3
@min 0

@arg time
@text Time
@type number
@decimals 3
@default 1


@command flashlight
@text Flashlight
@desc Add a flashlight lightsource to a character.

@arg target
@text Target
@desc Enter the event id or "player". Blank for current event.

@arg color
@text Color

@arg intensity
@text Intensity
@type number
@decimals 3
@min 0

@arg dist
@text Distance
@desc How far the light will travel.
@type number
@decimals 3
@min 0

@arg angle
@text Beam Width
@desc An angle that describes the width of the beam.
@type number
@min 0 @max 360

@arg yaw
@text Yaw
@desc The horizontal angle of the flashlight beam.
@type number
@decimals 0
@min 0
@max 360

@arg pitch
@text Pitch
@desc The vertical angle of the flashlight beam.
@type number
@decimals 0
@min 0
@max 180

@arg time
@text Time
@type number
@decimals 3
@default 1


@command resolution
@text Resolution Scale
@desc Scale the resolution for a pixellated effect.

@arg scale
@text Scale
@desc Should be between 0 and 1.
@type number
@decimals 4
@min 0 @max 1
@default 1.0000

@arg time
@text Time
@type number
@decimals 3
@default 1


@command configure
@text Configure
@desc Change the target event's configuration

@arg target
@text Target
@desc Enter the event id or "player". Blank for current event.

@arg config
@text Configuration
@type note


@command set
@text Set Property
@desc Change the value of one of these properties

@arg property
@text Property
@type select
@option lockCamera
@option allowRotation
@option allowPitch
@option diagonalMovement
@option turnIncrement
@option turnSpeed
@option instantMovement
@option inputCameraMouse
@option inputCameraGamepad
@option cameraCollision
@option airshipHeight

@arg value
@text Value



@param options
@text Option Settings

@param 3dMenu
@text 3D Options Menu
@desc Whether 3D options will be in a submenu, regular options menu, or disabled.
@parent options
@type select
@option SUBMENU
@option ENABLE
@option DISABLE
@default ENABLE


@param renderDistOptionName
@text Render Distance Option Name
@desc symbol name: mv3d-renderDist
@parent options
@type text
@default Render Distance

@param renderDist
@text Render Distance Default
@desc The maximum distance that can be rendered by the camera.
@parent renderDistOptionName
@type number
@default 25
@min 0

@param renderDistOption
@text Render Distance Option
@desc Should Render Distance appear on options menu?
@parent renderDistOptionName
@type boolean
@default true

@param renderDistMin
@text Render Distance Min
@parent renderDistOptionName
@type number
@default 10
@min 0

@param renderDistMax
@text Render Distance Max
@parent renderDistOptionName
@type number
@default 100
@min 0


#param mipmapOptionName
#text Mipmapping Option Name
#desc symbol name: mv3d-mipmap
#parent options
#type text
#default Mipmapping

#param mipmap
#text Mipmapping Default
#parent mipmapOptionName
#type boolean
#default false

#param mipmapOption
#text Mipmapping Option
#desc Should Mipmapping appear on options menu?
#parent mipmapOptionName
#type boolean
#default true


@param fovOptionName
@text FOV Option Name
@desc symbol name: mv3d-fov
@parent options
@type text
@default FOV

@param fov
@text FOV Default
@parent fovOptionName
@type number
@default 70
@min 0 @max 180

@param fovOption
@text FOV Option
@desc Should FOV appear on options menu?
@parent fovOptionName
@type boolean
@default false

@param fovMin
@text FOV Min
@parent fovOptionName
@type number
@default 50
@min 0 @max 180

@param fovMax
@text FOV Max
@parent fovOptionName
@type number
@default 100
@min 0 @max 180

@param invertYOptionName
@text Invert Y Axis Option Name
@desc symbol name: mv3d-inverty
@parent options
@type text
@default Invert Y Axis

@param invertYOption
@text Invert Y Axis Option
@desc Should invert Y axis appear on options menu?
@parent invertYOptionName
@type boolean
@default true

@param lookSensitivityOptionName
@text Look Sensitivity Option Name
@desc symbol name: mv3d-looksensitivity
@parent options
@type text
@default Look Sensitivity

@param lookSensitivityOption
@text Look Sensitivity Option
@desc Should look sensitivity appear in options menu
@parent lookSensitivityOptionName
@type boolean
@default true

@param spacer|graphics @text‏‏‎ ‎@desc ===============================================

@param graphics
@text Graphics

@param antialiasing
@text Antialiasing
@parent graphics
@type boolean
@default true

@param edgefix
@text Edge Fix
@desc Fixes rendering issues at the edges of tiles.
@parent graphics
@type number
@decimals 1
@default 0.5

@param alphatest
@text Alpha Cutoff
@desc Pixels with alpha below this value will not be rendered.
@parent graphics
@type number
@decimals 2
@min 0.01 @max 1
@default 0.51

@param lightLimit
@text Lights Per Mesh
@parent graphics
@type number
@min 4
@default 8

@param backfaceCulling
@text Backface Culling
@parent graphics
@type boolean
@default true

@param cameraCollision
@text Camera Collision
@parent graphics
@type combo
@option Off
@option Type1
@option Type2
@option Type1 Smoothed
@option Type2 Smoothed
@default Type2 Smoothed

@param resScale
@text Resolution Scale
@desc Scale the resolution
@parent graphics
@type number
@decimals 2
@min 0 @max 1
@default 1

@param spacer|map @text‏‏‎ ‎@desc ===============================================

@param map
@text Map Settings

@param cellSize
@text Cell Size
@desc The size of the chunks the map is divided into.
@parent map
@type number
@default 10

@param unloadCells
@text Unload Far Cells
@desc Unload cells outside the render distance.
@parent map
@type boolean
@default false

@param eventsUpdateNear
@text Update All Events in Render Distance
@parent map
@type boolean
@default true

@param mapDefaults
@text Map Defaults
@parent map
@type note
@default
"enable(true)\nsun(white)\nambient(default)\nfog(black|20,100)\nceiling(backface:true)"


@param spacer|input @text‏‏‎ ‎@desc ===============================================

@param input
@text Input & Gameplay

@param inputCameraMouse
@text Mouse Camera Control
@parent input
@type boolean
@default false

@param inputCameraGamepad
@text Gamepad Camera Control
@parent input
@type boolean
@default true

@param inputGamepadTurnButton
@text Gamepad Turn Button
@parent input
@type select
@option Bumpers
@option Triggers
@option Unchanged
@default Bumpers

@param WASD
@text WASD
@parent input
@type boolean
@default true

@param dir8Movement
@text Diagonal Movement
@desc In smart mode, when diagonal movement fails, try moving straight.
@parent input
@type combo
@option Off
@option Diagonal Basic
@option Diagonal Basic 3D Only
@option Diagonal Smart
@option Diagonal Smart 3D Only
@default Diagonal Smart

@param keyboardPitch
@text Control Pitch
@parent input
@desc Allow player to change pitch with pageup & pagedown.
@type boolean
@default true

@param keyboardTurn
@text Allow Turning
@parent input
@desc Allows rotating camera with keyboard in 3rd person. Rotating is always allowed in 1st person.
@type select
@option Turn with Q+E (requires WASD) @value QE
@option Turn with A+D and left+right @value AD
@option disabled
@default QE

@param keyboardStrafe
@text Allow Strafing
@parent input
@desc Allows strafing in 1st person mode.
@type select
@option Strafe with Q+E (requires WASD) @value QE
@option Strafe with A+D and left+right @value AD
@option disabled
@default QE

@param turnIncrement
@text Turn Increment
@parent input
@desc How many degrees the camera will turn when you press the turn button. Other numbers may also be entered.
@type combo
@option 90
@option 45
@option SMOOTH
@default 90

@param yawSpeed
@text Turn Speed
@parent input
@desc Speed when turning with keyboard (in degrees per second).
@type number
@default 180

@param pitchSpeed
@text Pitch Speed
@parent input
@desc Speed when changing pitch with keyboard (in degrees per second).
@type number
@default 90


@param stairThresh
@text Stair Threshold
@desc If the distance in height between two tiles is less than this, they will be passable.
@parent input
@type number
@decimals 2
@default 0.1

@param walkOffEdge
@text Walk off Edge
@parent input
@type boolean
@default false

@param walkOnEvents
@text Walk on Events
@parent input
@type boolean
@default true

@param gravity
@text Gravity
@desc The speed characters will fall, in tiles per second.
@parent input
@type number
@decimals 2
@default 8

@param spacer|tileconfig @text‏‏‎ ‎@desc ===============================================

@param tileconfig
@text Tile Config

@param wallTileSettings
@text Wall Tile Settings
@desc The default tile settings for wall tiles.
@parent tileconfig
@type note
@default "height(2)"

@param tableTileSettings
@text Table Tile Settings
@desc The default tile settings for table tiles.
@parent tileconfig
@type note
@default "height(0.33)"

@param starTileSettings
@text Star Tile Settings
@desc The default tile settings for star tiles.
@parent tileconfig
@type note
@default "fringe(2)\npass(*)"

@param ceilingHeight
@text Ceiling Height
@desc Default height of ceiling for maps with ceiling enabled.
@parent tileconfig
@type number
@min -9999 @max 9999
@decimals 3
@default 2.0

@param baseHeight
@text Base Height
@desc Extra height added to every tile on the map.
@parent tileconfig
@type number
@min 0 @max 1
@decimals 3
@default 0.25

@param layerDist
@text Layering Distance
@desc The distance between tile layers. If this is too small
there may be z-fighting issues. (default: 0.0100)
@parent tileconfig
@type number
@decimals 4
@default 0.0100

@param animDelay
@text Animation Speed
@desc The number of milliseconds between each frame in tile animations.
@parent tileconfig
@type number
@default 333

@param regions
@text Regions
@desc use regions to determine tile height.
@parent tileconfig
@type struct<RegionHeight>[]
@default ["{\"regionId\":\"1\",\"conf\":\"height(1)\"}","{\"regionId\":\"2\",\"conf\":\"height(2)\"}","{\"regionId\":\"3\",\"conf\":\"height(3)\"}","{\"regionId\":\"4\",\"conf\":\"height(4)\"}","{\"regionId\":\"5\",\"conf\":\"height(5)\"}","{\"regionId\":\"6\",\"conf\":\"height(6)\"}","{\"regionId\":\"7\",\"conf\":\"height(7)\"}"]

@param ttags
@text Terrain Tags
@desc use terrain tags to determine tile height.
@parent tileconfig
@type struct<TTagHeight>[]
@default ["{\"terrainTag\":\"1\",\"conf\":\"shape(xcross),height(1),fringe(0)\"}","{\"terrainTag\":\"2\",\"conf\":\"shape(fence),height(1)\"}"]

@param spacer|characters @text‏‏‎ ‎@desc ===============================================

@param characters
@text Characters

@param heightTrigger
@text Event Trigger Height
@desc If true, events will need to be at the same elevation as the player to be triggered.
@parent characters
@type boolean
@default true

@param eventCharDefaults
@text Character Event Settings
@parent characters
@type note
@default "shadow(0.8,4)\nshape(sprite)\nscale(1)"

@param eventObjDefaults
@text Object Event Settings
@parent characters
@type note
@default "shadow(0)\nshape(sprite)\nscale(1)"

@param eventTileDefaults
@text Tile Event Settings
@parent characters
@type note
@default "shadow(0)\nshape(flat)\nscale(1)"

@param eventHeight
@text Event "Above Characters" Default Height
@parent characters
@type number
@decimals 1
@default 2.0

@param boatSettings
@text Boat Settings
@parent characters
@type struct<BoatStruct>
@default {"conf":"shadow(0.8,4),shape(sprite),scale(1),bush(false)"}

@param shipSettings
@text Ship Settings
@parent characters
@type struct<BoatStruct>
@default {"conf":"shadow(0.8,4),shape(sprite),scale(1),bush(false)"}

@param airshipSettings
@text Airship Settings
@parent characters
@type struct<AirshipStruct>
@default {"conf":"shadow(1,6),shape(sprite),scale(1),bush(false)","height":"2.0","bushLanding":"false"}

@param allowGlide
@text Allow Glide
@desc If true, collision detection for flying characters will use only current elevation and not target elevation.
@parent characters
@type boolean
@default true

@param spriteOffset
@text Sprite Offset
@parent characters
@type number
@min 0 @max 1
@decimals 2
@default 0.9

@param spacer|assets @text‏‏‎ ‎@desc ===============================================

@param assets
@text Assets

@param diagSymbol
@text Diagonal Sprite Symbol
@desc Character sheets with this symbol contain diagonal sprites. Leave blank to use diagonal sprites with all images.
@parent assets
@type text
@default {d}

@param shadowTexture
@text Shadow Texture
@parent assets
@type file
@dir img/MV3D
@require 1
@default shadow

@param alphaMask
@text Bush Alpha Texture
@parent assets
@type file
@dir img/MV3D
@require 1
@default bushAlpha

@param errorTexture
@text Error Texture
@parent assets
@type file
@dir img/MV3D
@require 1
@default errorTexture

@param requiredImages
@text Other Required Images
@desc Specify additional images here to prevent them from being excluded during deployment.
@parent assets
@type file[]
@dir img/MV3D
@require 1


*/
/*~struct~RegionHeight:
@param regionId
@text Region Id
@type number
@min 1 @max 255
@default 1

@param conf
@text Configuration Functions
@desc See tileset configuration for list of functions
@type text
@default height(2)
*/

/*~struct~TTagHeight:
@param terrainTag
@text Terrain Tag
@type number
@min 1 @max 7
@default 1

@param conf
@text Configuration Functions
@desc See tileset configuration for list of functions
@type text
@default shape(flat),height(0)
*/

/*~struct~BoatStruct:
@param conf
@text Settings
@type text
@default shadow(0.8,4),shape(sprite),scale(1),bush(false)

*/

/*~struct~AirshipStruct:
@param conf
@text Settings
@type text
@default shadow(1,6),shape(sprite),scale(1),bush(false)

@param height
@text Elevation
@type number
@decimals 1
@default 2.0

@param bushLanding
@text Land on Bush Tiles
@desc Whether the airship can land on bush tiles.
@type boolean
@default false

*/

/*~struct~XY:
@param x
@text X
@type number
@decimals 3
@default 0

@param y
@text Y
@type number
@decimals 3
@default 0

*/


/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 4);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "makeColor", function() { return makeColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "hexNumber", function() { return hexNumber; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "relativeNumber", function() { return relativeNumber; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "relativeBlend", function() { return relativeBlend; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "booleanNumber", function() { return booleanNumber; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "booleanString", function() { return booleanString; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "falseString", function() { return falseString; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "sleep", function() { return sleep; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "degtorad", function() { return degtorad; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "radtodeg", function() { return radtodeg; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "pointtorad", function() { return pointtorad; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "pointtodeg", function() { return pointtodeg; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "sin", function() { return sin; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "cos", function() { return cos; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "unround", function() { return unround; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "minmax", function() { return minmax; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "tileSize", function() { return tileSize; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "tileWidth", function() { return tileWidth; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "tileHeight", function() { return tileHeight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "optimalFrustrumWidth", function() { return optimalFrustrumWidth; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "optimalFrustrumHeight", function() { return optimalFrustrumHeight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "file", function() { return file; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "filename", function() { return filename; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "foldername", function() { return foldername; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "deprecated", function() { return deprecated; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "throttle", function() { return throttle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "dirtoh", function() { return dirtoh; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "dirtov", function() { return dirtov; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "hvtodir", function() { return hvtodir; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "overload", function() { return overload; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "override", function() { return override; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "assign", function() { return assign; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "XAxis", function() { return XAxis; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "YAxis", function() { return YAxis; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ZAxis", function() { return ZAxis; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "v2origin", function() { return v2origin; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "v3origin", function() { return v3origin; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PI", function() { return PI; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PI2", function() { return PI2; });
/* harmony import */ var _main_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);


const {Vector2,Vector3,Color3,Color4} = window.BABYLON;

const makeColor = color=>{
	if (typeof color === 'number'){
		return {
			r: (color>>16)/255,
			g: (color>>8&255)/255,
			b: (color&255)/255,
			a: 1,
		};
	}else if(color instanceof Color3){
		return color.toColor4();
	}else if(color instanceof Color4){
		return color;
	}else{
		const canvas = document.createElement('canvas');
		canvas.width=1; canvas.height=1;
		const context = canvas.getContext('2d');
		context.fillStyle = color; context.fillRect(0,0,1,1);
		const bytes = context.getImageData(0,0,1,1).data;
		return new Color4(bytes[0]/255,bytes[1]/255,bytes[2]/255,bytes[3]/255);
	}
}


const hexNumber=n=>{
	n=String(n);
	if(n.startsWith('#')){
		n=n.substr(1);
	}
	return Number.parseInt(n,16);
};

const relativeNumber=(current,n)=>{
	if(n===''){ return +current; }
	const relative = /^[+]/.test(n);
	if(relative){n=n.substr(1);}
	n=Number(n);
	if(Number.isNaN(n)){ return +current; }
	if(relative){
		return +current+n;
	}else{
		return +n;
	}
};

const relativeBlend=(blender,n,time)=>{
	const relative = String(n).startsWith('+');
	blender.setValue(relativeNumber(blender.targetValue(),n),Number(time),!relative);
};

const booleanNumber=s=>{
	if(!isNaN(s)){return Number(s);}
	return booleanString(s);
};
const booleanString=s=>{
	return Boolean(falseString(s));
};
const falseString=s=>{
	if(!s){ return false; }
	if(typeof s !=='string'){ s=String(s); }
	const S=s.toUpperCase();
	if(falseString.values.includes(S)){
		return false;
	}
	return s;
};
falseString.values=['OFF','FALSE','UNDEFINED','NULL','DISABLE','DISABLED','CLEAR','CLEARED','0'];

const sleep=(ms=0)=>new Promise(resolve=>setTimeout(resolve,ms));
const degtorad=deg=>deg*Math.PI/180;
const radtodeg=rad=>rad*180/Math.PI;

const pointtorad=(x,y)=>Math.atan2(-y,x)-Math.PI/2;
const pointtodeg=(x,y)=>radtodeg(pointtorad(x,y));

const sin=r=>unround(Math.sin(r),1e15);
const cos=r=>unround(Math.cos(r),1e15);

const unround=(n,m=1e15)=>Math.round(n*m)/m;

const minmax=(min,max,v)=>Math.min(max,Math.max(min,v));

const tileSize=()=>tileWidth();
const tileWidth=()=>Game_Map.prototype.tileWidth();
const tileHeight=()=>Game_Map.prototype.tileHeight();
const optimalFrustrumWidth=()=>Graphics.width/48;
const optimalFrustrumHeight=()=>Graphics.height/48;

const file=(folder=_main_js__WEBPACK_IMPORTED_MODULE_0__[/* default */ "a"].MV3D_FOLDER,name,ext)=>{
	if(ext && !filename(name).contains('.')){ name=name+(ext.startsWith('.')?'':'.')+ext; }
	if(name.startsWith('/')){ return '.'+name; }
	else if(name.startsWith('./')){ return name; }
	if(folder.startsWith('/')){ folder='.'+folder; }
	else if(!folder.startsWith('./')&&folder!=='.'){ folder='./'+folder; }
	return `${folder}${folder.endsWith('/')?'':'/'}${name}`;
};

const filename=path=>{path=path.split('/');return path[path.length-1];}
const foldername=path=>{path=path.split('/');path.pop();return path.join('/')+'/';}

const issuedWarnings={};
const deprecated=message=>{
	if(message in issuedWarnings){ return; }
	issuedWarnings[message]=true;
	console.warn(message);
};

const throttle=(func,interval=100)=>{
	let last_call = 0;
	return function(){
		if(Date.now()-last_call>interval){
			func.apply(this,arguments);
			last_call = Date.now();
		}
	};
}

// directions

const dirtoh=d=>5 + ((d-1)%3-1);
const dirtov=d=>5 + (Math.floor((d-1)/3)-1)*3;
const hvtodir=(h,v)=>5 + (Math.floor((v-1)/3)-1)*3 + ((h-1)%3-1);

// overloading

const overload=funcs=>{
	const overloaded = function(){
		const l=arguments.length;
		if(typeof funcs[l] === 'function'){
			return funcs[l].apply(this,arguments);
		}else if(typeof funcs.default === 'function'){
			return funcs.default.apply(this,arguments);
		}else{ console.warn("Unsupported number of arguments."); }
	}
	for(const key in funcs){
		overloaded[key]=funcs[key].bind
	}
	return overloaded;
};

// override
const _override_default_condition=()=>!_main_js__WEBPACK_IMPORTED_MODULE_0__[/* default */ "a"].isDisabled();
const override=(obj,methodName,getNewMethod,condition=_override_default_condition)=>{
	const oldMethod = obj[methodName];
	const newMethod = getNewMethod(oldMethod);
	const overrider = function(){
		if(!(typeof condition==='function'?condition():condition)){ return oldMethod.apply(this,arguments); }
		return newMethod.apply(this,arguments);
	};
	Object.defineProperty(overrider,'name',{value:`${methodName}<mv3d_override>`});
	Object.defineProperty(newMethod,'name',{value:`${methodName}<mv3d>`});
	overrider.oldMethod=oldMethod; overrider.newMethod=newMethod;
	return obj[methodName] = overrider;
};

// assign
const assign=(obj,methods)=>{
	for (const key in methods){
		const descriptor = Object.getOwnPropertyDescriptor(methods,key);
		if (descriptor.get||descriptor.set){
			Object.defineProperty(obj,key,descriptor);
		}else if(methods[key] instanceof _main_js__WEBPACK_IMPORTED_MODULE_0__[/* default */ "a"].Attribute){
			const attribute = methods[key];
			Object.defineProperty(obj,key,attribute.descriptor);
		}else{
			obj[key]=methods[key];
		}
	}
};

// useful consts
const XAxis = new Vector3(1,0,0);
const YAxis = new Vector3(0,1,0);
const ZAxis = new Vector3(0,0,1);
const v2origin = new Vector2(0,0);
const v3origin = new Vector3(0,0,0);

const PI = Math.PI;
const PI2 = Math.PI*2;


/***/ }),
/* 1 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var babylonjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2);
/* harmony import */ var babylonjs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(babylonjs__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mod_babylon_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3);
/* harmony import */ var _util_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(0);






const mz3d = {
	util:_util_js__WEBPACK_IMPORTED_MODULE_2__,

	setup(){
		this.setupParameters();
		Object(_mod_babylon_js__WEBPACK_IMPORTED_MODULE_1__[/* setupBabylonMods */ "i"])();

		this.canvas = document.createElement('canvas');
		this.texture = PIXI.Texture.from(this.canvas);
		this.texture.destroy = function(){};
		this.texture.baseTexture.scaleMode=PIXI.SCALE_MODES.NEAREST;
		this.engine = new babylonjs__WEBPACK_IMPORTED_MODULE_0__["Engine"](this.canvas,this.ANTIALIASING,{
			//premultipliedAlpha:false, 
		});
		this.context = this.engine._gl;
		this.scene = new babylonjs__WEBPACK_IMPORTED_MODULE_0__["Scene"](this.engine);
		//this.scene.clearColor.a=0;
		this.scene.clearColor.set(0,0,0,0);

		//this.engine.forcePOTTextures=true;

		this.cameraStick = new babylonjs__WEBPACK_IMPORTED_MODULE_0__["TransformNode"]("cameraStick",this.scene);
		this.cameraNode = new babylonjs__WEBPACK_IMPORTED_MODULE_0__["TransformNode"]("cameraNode",this.scene);
		this.cameraNode.parent=this.cameraStick;
		this.camera = new babylonjs__WEBPACK_IMPORTED_MODULE_0__["FreeCamera"]("camera",new babylonjs__WEBPACK_IMPORTED_MODULE_0__["Vector3"](0,0,0),this.scene);
		this.camera.parent=this.cameraNode;
		this.camera.fov=Object(_util_js__WEBPACK_IMPORTED_MODULE_2__["degtorad"])(mz3d.FOV);
		/*
		this.camera.orthoLeft=-Graphics.width/2/tileSize();
		this.camera.orthoRight=Graphics.width/2/tileSize();
		this.camera.orthoTop=Graphics.height/2/tileSize();
		this.camera.orthoBottom=-Graphics.height/2/tileSize();
		*/
		this.camera.minZ=0.1;
		this.camera.maxZ=this.RENDER_DIST;

		//this.scene.activeCameras.push(this.camera);

		this.scene.ambientColor = new babylonjs__WEBPACK_IMPORTED_MODULE_0__["Color3"](1,1,1);
		this.scene.fogMode=_mod_babylon_js__WEBPACK_IMPORTED_MODULE_1__[/* FOGMODE_LINEAR */ "c"];

		this.map = new babylonjs__WEBPACK_IMPORTED_MODULE_0__["Node"]("map",this.scene);
		this.cells={};
		this.characters=[];

		this.setupBlenders();
		//this.updateBlenders(true);
		this.setupInput();

		this.setupSpriteMeshes();

		this.callFeatures('setup');

	},

	updateCanvas(){
		this.canvas.width = Graphics._width*mz3d.RES_SCALE;
		this.canvas.height = Graphics._height*mz3d.RES_SCALE;
	},

	render(){
		if(!this.texture.baseTexture){ return; }
		this.scene.render();
		this.callFeatures('render');
		this.texture.update();
	},

	lastMapUpdate:0,
	update(){
		if( performance.now()-this.lastMapUpdate > 1000 && !this.mapUpdating ){
			this.updateMap();
			this.lastMapUpdate=performance.now();
		}

		this.updateAnimations();

		this.updateCharacters();

		this.intensiveUpdate();

		this.updateBlenders();

		// input
		this.updateInput();

		for (const key in this.cells){
			this.cells[key].update();
		}

		this.callFeatures('update');

		//this.updateData();
	},

	loadData(key,dfault){
		if(!$gameVariables || !$gameVariables.mv3d || !(key in $gameVariables.mv3d)){ return dfault; }
		return $gameVariables.mv3d[key];
	},
	saveData(key,value){
		if(!$gameVariables){ return console.warn(`MV3D: Couldn't save data ${key}:${value}`); }
		if(!$gameVariables.mv3d){ $gameVariables.mv3d={}; }
		$gameVariables.mv3d[key]=value;
	},
	clearData(key){
		if(!$gameVariables){ return console.warn(`MV3D: Couldn't clear data ${key}`); }
		if(!$gameVariables.mv3d){ return; }
		delete $gameVariables.mv3d[key];
	},

	updateCameraMode(){
		const mode = this.cameraMode;
		let updated=false;
		if(mode.startsWith('O')){
			if(this.camera.mode!==_mod_babylon_js__WEBPACK_IMPORTED_MODULE_1__[/* ORTHOGRAPHIC_CAMERA */ "f"]){ this.camera.mode=_mod_babylon_js__WEBPACK_IMPORTED_MODULE_1__[/* ORTHOGRAPHIC_CAMERA */ "f"]; updated=true; }
		}else{
			if(this.camera.mode!==_mod_babylon_js__WEBPACK_IMPORTED_MODULE_1__[/* PERSPECTIVE_CAMERA */ "g"]){ this.camera.mode=_mod_babylon_js__WEBPACK_IMPORTED_MODULE_1__[/* PERSPECTIVE_CAMERA */ "g"]; updated=true; }
		}
		if(updated){
			this.updateBlenders(true);
			this.callFeatures('updateCameraMode');
			this.updateParameters();
		}
	},
	get cameraMode(){
		return this.loadData('cameraMode',this.CAMERA_MODE).toUpperCase();
	},
	set cameraMode(v){
		v = String(v).toUpperCase().startsWith('O') ? 'ORTHOGRAPHIC' : 'PERSPECTIVE' ;
		this.saveData('cameraMode',v);
		this.updateBlenders(true);
	},

	get hasBackground(){
		return window.$gameMap&&$gameMap.parallaxName()||mv3d.hasSkybox;
	},

	get hasAlphaPostProcess(){
		return (this.hasAlphaFog || mz3d.alphaFixPostProcess) && mz3d.scene.postProcessesEnabled;
	},

	is1stPerson(useCurrent){
		const k = useCurrent?'currentValue':'targetValue';
		return $gamePlayer && (mz3d.getCameraTarget()===$gamePlayer||mz3d.getCameraTarget()===$gamePlayer.vehicle()) && mz3d.blendCameraTransition[k]()<=0
		&& mz3d.blendCameraDist[k]()<=0 && mz3d.blendPanX[k]()===0 && mz3d.blendPanY[k]()===0;
	},

	isVR(){
		return false;
	},

	is3D(){
		return !mz3d.isDisabled() && SceneManager._scene instanceof Scene_Map;
	},

	isDisabled(){
		return mz3d.loadData('disabled', mz3d.getMapConfig('disabled', false ));
	},
	disable(fadeType=2){
		mz3d.saveData('disabled',true);
		//SceneManager.goto(Scene_Map);
		$gamePlayer.reserveTransfer($gameMap.mapId(),$gamePlayer.x,$gamePlayer.y,$gamePlayer.direction(),fadeType);
	},
	enable(fadeType=2){
		mz3d.saveData('disabled',false);
		//SceneManager.goto(Scene_Map);
		$gamePlayer.reserveTransfer($gameMap.mapId(),$gamePlayer.x,$gamePlayer.y,$gamePlayer.direction(),fadeType);
		mz3d.createCharacters();
	},

	loopCoords(x,y){
		if(this.loopHorizontal()){
			const mapWidth=mz3d.mapWidth();
			const ox = this.cameraStick.x - mapWidth/2;
			x=(x-ox).mod(mapWidth)+ox;
		}
		if(this.loopVertical()){
			const mapHeight=mz3d.mapHeight();
			const oy = this.cameraStick.y - mapHeight/2;
			y=(y-oy).mod(mapHeight)+oy;
		}
		return new babylonjs__WEBPACK_IMPORTED_MODULE_0__["Vector2"](x,y);
	},

	getFieldSize(dist=mz3d.blendCameraDist.currentValue()){
		const size = Math.tan(mz3d.camera.fov/2)*dist*2;
		return {
			width:size*mz3d.engine.getAspectRatio(mz3d.camera),
			height:size,
		};
	},
	getScaleForDist(dist=mz3d.blendCameraDist.currentValue()){
		return Graphics.height/this.getFieldSize(dist).height/48;
	},
	getFovForDist(dist=mz3d.blendCameraDist.currentValue(),height=Object(_util_js__WEBPACK_IMPORTED_MODULE_2__["optimalFrustrumHeight"])()){
		return 2*Math.atan(height/2/dist);
	},
	getDistForFov(fov=mz3d.camera.fov,height=Object(_util_js__WEBPACK_IMPORTED_MODULE_2__["optimalFrustrumHeight"])()){
		return height/2/Math.tan(fov/2);
	},
	getFrustrumHeight(dist=mz3d.blendCameraDist.currentValue(),fov=mz3d.camera.fov){
		return 2*dist*Math.tan(fov/2);
	},


	getScreenPosition(node,offset=babylonjs__WEBPACK_IMPORTED_MODULE_0__["Vector3"].Zero()){
		const matrix = node.parent ? node.parent.getWorldMatrix() : babylonjs__WEBPACK_IMPORTED_MODULE_0__["Matrix"].Identity();
		const pos = node instanceof babylonjs__WEBPACK_IMPORTED_MODULE_0__["Vector3"] ? node.add(offset) : node.position.add(offset);
		const projected = babylonjs__WEBPACK_IMPORTED_MODULE_0__["Vector3"].Project(pos,matrix,mz3d.scene.getTransformMatrix(),mz3d.camera.viewport);
		return {x:projected.x*Graphics.width, y:projected.y*Graphics.height, behindCamera:projected.z>1};
	},
	
	getUnscaledMatrix(mesh){
		const matrix = mesh.getWorldMatrix();
		const qrot=new babylonjs__WEBPACK_IMPORTED_MODULE_0__["Quaternion"](), vtrans=new babylonjs__WEBPACK_IMPORTED_MODULE_0__["Vector3"]();
		matrix.decompose(null,qrot,vtrans);
		return babylonjs__WEBPACK_IMPORTED_MODULE_0__["Matrix"].Compose(babylonjs__WEBPACK_IMPORTED_MODULE_0__["Vector3"].One(),qrot,vtrans);
	},
	getTranslationMatrix(mesh){
		const matrix = mesh.getWorldMatrix();
		const vrot=babylonjs__WEBPACK_IMPORTED_MODULE_0__["Vector3"].Zero(), vtrans=new babylonjs__WEBPACK_IMPORTED_MODULE_0__["Vector3"]();
		vrot.y=-Object(_util_js__WEBPACK_IMPORTED_MODULE_2__["degtorad"])(mz3d.blendCameraYaw.currentValue());
		vrot.x=-Object(_util_js__WEBPACK_IMPORTED_MODULE_2__["degtorad"])(mz3d.blendCameraPitch.currentValue()-90);
		matrix.decompose(null,null,vtrans);
		return babylonjs__WEBPACK_IMPORTED_MODULE_0__["Matrix"].Compose(babylonjs__WEBPACK_IMPORTED_MODULE_0__["Vector3"].One(),vrot.toQuaternion(),vtrans);
	},
	getRotationMatrix(mesh){
		const matrix = mesh.getWorldMatrix();
		const qrot=new babylonjs__WEBPACK_IMPORTED_MODULE_0__["Quaternion"]();
		matrix.decompose(null,qrot,null);
		return babylonjs__WEBPACK_IMPORTED_MODULE_0__["Matrix"].Compose(babylonjs__WEBPACK_IMPORTED_MODULE_0__["Vector3"].One(),qrot,babylonjs__WEBPACK_IMPORTED_MODULE_0__["Vector3"].Zero());
	},

	globalPosition(node){
		const matrix = node.parent ? node.parent.getWorldMatrix() : babylonjs__WEBPACK_IMPORTED_MODULE_0__["Matrix"].Identity();
		return babylonjs__WEBPACK_IMPORTED_MODULE_0__["Vector3"].TransformCoordinates(node.position,matrix);
	},

}
window.mv3d=window.mz3d=mz3d;
/* harmony default export */ __webpack_exports__["a"] = (mz3d);

/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

!function(e,t){ true?module.exports=t():undefined}("undefined"!=typeof self?self:"undefined"!=typeof global?global:this,function(){return function(e){var t={};function i(n){if(t[n])return t[n].exports;var r=t[n]={i:n,l:!1,exports:{}};return e[n].call(r.exports,r,r.exports,i),r.l=!0,r.exports}return i.m=e,i.c=t,i.d=function(e,t,n){i.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:n})},i.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},i.t=function(e,t){if(1&t&&(e=i(e)),8&t)return e;if(4&t&&"object"==typeof e&&e&&e.__esModule)return e;var n=Object.create(null);if(i.r(n),Object.defineProperty(n,"default",{enumerable:!0,value:e}),2&t&&"string"!=typeof e)for(var r in e)i.d(n,r,function(t){return e[t]}.bind(null,r));return n},i.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return i.d(t,"a",t),t},i.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},i.p="",i(i.s=151)}([function(e,t,i){"use strict";i.d(t,"d",function(){return s}),i.d(t,"e",function(){return c}),i.d(t,"f",function(){return l}),i.d(t,"b",function(){return u}),i.d(t,"a",function(){return h}),i.d(t,"c",function(){return f});var n=i(14),r=i(28),o=i(42),a=i(12),s=function(){function e(e,t){void 0===e&&(e=0),void 0===t&&(t=0),this.x=e,this.y=t}return e.prototype.toString=function(){return"{X: "+this.x+" Y:"+this.y+"}"},e.prototype.getClassName=function(){return"Vector2"},e.prototype.getHashCode=function(){var e=0|this.x;return e=397*e^(0|this.y)},e.prototype.toArray=function(e,t){return void 0===t&&(t=0),e[t]=this.x,e[t+1]=this.y,this},e.prototype.asArray=function(){var e=new Array;return this.toArray(e,0),e},e.prototype.copyFrom=function(e){return this.x=e.x,this.y=e.y,this},e.prototype.copyFromFloats=function(e,t){return this.x=e,this.y=t,this},e.prototype.set=function(e,t){return this.copyFromFloats(e,t)},e.prototype.add=function(t){return new e(this.x+t.x,this.y+t.y)},e.prototype.addToRef=function(e,t){return t.x=this.x+e.x,t.y=this.y+e.y,this},e.prototype.addInPlace=function(e){return this.x+=e.x,this.y+=e.y,this},e.prototype.addVector3=function(t){return new e(this.x+t.x,this.y+t.y)},e.prototype.subtract=function(t){return new e(this.x-t.x,this.y-t.y)},e.prototype.subtractToRef=function(e,t){return t.x=this.x-e.x,t.y=this.y-e.y,this},e.prototype.subtractInPlace=function(e){return this.x-=e.x,this.y-=e.y,this},e.prototype.multiplyInPlace=function(e){return this.x*=e.x,this.y*=e.y,this},e.prototype.multiply=function(t){return new e(this.x*t.x,this.y*t.y)},e.prototype.multiplyToRef=function(e,t){return t.x=this.x*e.x,t.y=this.y*e.y,this},e.prototype.multiplyByFloats=function(t,i){return new e(this.x*t,this.y*i)},e.prototype.divide=function(t){return new e(this.x/t.x,this.y/t.y)},e.prototype.divideToRef=function(e,t){return t.x=this.x/e.x,t.y=this.y/e.y,this},e.prototype.divideInPlace=function(e){return this.divideToRef(e,this)},e.prototype.negate=function(){return new e(-this.x,-this.y)},e.prototype.negateInPlace=function(){return this.x*=-1,this.y*=-1,this},e.prototype.negateToRef=function(e){return e.copyFromFloats(-1*this.x,-1*this.y)},e.prototype.scaleInPlace=function(e){return this.x*=e,this.y*=e,this},e.prototype.scale=function(t){var i=new e(0,0);return this.scaleToRef(t,i),i},e.prototype.scaleToRef=function(e,t){return t.x=this.x*e,t.y=this.y*e,this},e.prototype.scaleAndAddToRef=function(e,t){return t.x+=this.x*e,t.y+=this.y*e,this},e.prototype.equals=function(e){return e&&this.x===e.x&&this.y===e.y},e.prototype.equalsWithEpsilon=function(e,t){return void 0===t&&(t=r.a),e&&n.a.WithinEpsilon(this.x,e.x,t)&&n.a.WithinEpsilon(this.y,e.y,t)},e.prototype.floor=function(){return new e(Math.floor(this.x),Math.floor(this.y))},e.prototype.fract=function(){return new e(this.x-Math.floor(this.x),this.y-Math.floor(this.y))},e.prototype.length=function(){return Math.sqrt(this.x*this.x+this.y*this.y)},e.prototype.lengthSquared=function(){return this.x*this.x+this.y*this.y},e.prototype.normalize=function(){var e=this.length();return 0===e?this:(this.x/=e,this.y/=e,this)},e.prototype.clone=function(){return new e(this.x,this.y)},e.Zero=function(){return new e(0,0)},e.One=function(){return new e(1,1)},e.FromArray=function(t,i){return void 0===i&&(i=0),new e(t[i],t[i+1])},e.FromArrayToRef=function(e,t,i){i.x=e[t],i.y=e[t+1]},e.CatmullRom=function(t,i,n,r,o){var a=o*o,s=o*a;return new e(.5*(2*i.x+(-t.x+n.x)*o+(2*t.x-5*i.x+4*n.x-r.x)*a+(-t.x+3*i.x-3*n.x+r.x)*s),.5*(2*i.y+(-t.y+n.y)*o+(2*t.y-5*i.y+4*n.y-r.y)*a+(-t.y+3*i.y-3*n.y+r.y)*s))},e.Clamp=function(t,i,n){var r=t.x;r=(r=r>n.x?n.x:r)<i.x?i.x:r;var o=t.y;return new e(r,o=(o=o>n.y?n.y:o)<i.y?i.y:o)},e.Hermite=function(t,i,n,r,o){var a=o*o,s=o*a,c=2*s-3*a+1,l=-2*s+3*a,u=s-2*a+o,h=s-a;return new e(t.x*c+n.x*l+i.x*u+r.x*h,t.y*c+n.y*l+i.y*u+r.y*h)},e.Lerp=function(t,i,n){return new e(t.x+(i.x-t.x)*n,t.y+(i.y-t.y)*n)},e.Dot=function(e,t){return e.x*t.x+e.y*t.y},e.Normalize=function(e){var t=e.clone();return t.normalize(),t},e.Minimize=function(t,i){return new e(t.x<i.x?t.x:i.x,t.y<i.y?t.y:i.y)},e.Maximize=function(t,i){return new e(t.x>i.x?t.x:i.x,t.y>i.y?t.y:i.y)},e.Transform=function(t,i){var n=e.Zero();return e.TransformToRef(t,i,n),n},e.TransformToRef=function(e,t,i){var n=t.m,r=e.x*n[0]+e.y*n[4]+n[12],o=e.x*n[1]+e.y*n[5]+n[13];i.x=r,i.y=o},e.PointInTriangle=function(e,t,i,n){var r=.5*(-i.y*n.x+t.y*(-i.x+n.x)+t.x*(i.y-n.y)+i.x*n.y),o=r<0?-1:1,a=(t.y*n.x-t.x*n.y+(n.y-t.y)*e.x+(t.x-n.x)*e.y)*o,s=(t.x*i.y-t.y*i.x+(t.y-i.y)*e.x+(i.x-t.x)*e.y)*o;return a>0&&s>0&&a+s<2*r*o},e.Distance=function(t,i){return Math.sqrt(e.DistanceSquared(t,i))},e.DistanceSquared=function(e,t){var i=e.x-t.x,n=e.y-t.y;return i*i+n*n},e.Center=function(e,t){var i=e.add(t);return i.scaleInPlace(.5),i},e.DistanceOfPointFromSegment=function(t,i,n){var r=e.DistanceSquared(i,n);if(0===r)return e.Distance(t,i);var o=n.subtract(i),a=Math.max(0,Math.min(1,e.Dot(t.subtract(i),o)/r)),s=i.add(o.multiplyByFloats(a,a));return e.Distance(t,s)},e}(),c=function(){function e(e,t,i){void 0===e&&(e=0),void 0===t&&(t=0),void 0===i&&(i=0),this.x=e,this.y=t,this.z=i}return e.prototype.toString=function(){return"{X: "+this.x+" Y:"+this.y+" Z:"+this.z+"}"},e.prototype.getClassName=function(){return"Vector3"},e.prototype.getHashCode=function(){var e=0|this.x;return e=397*(e=397*e^(0|this.y))^(0|this.z)},e.prototype.asArray=function(){var e=[];return this.toArray(e,0),e},e.prototype.toArray=function(e,t){return void 0===t&&(t=0),e[t]=this.x,e[t+1]=this.y,e[t+2]=this.z,this},e.prototype.toQuaternion=function(){return u.RotationYawPitchRoll(this.y,this.x,this.z)},e.prototype.addInPlace=function(e){return this.addInPlaceFromFloats(e.x,e.y,e.z)},e.prototype.addInPlaceFromFloats=function(e,t,i){return this.x+=e,this.y+=t,this.z+=i,this},e.prototype.add=function(t){return new e(this.x+t.x,this.y+t.y,this.z+t.z)},e.prototype.addToRef=function(e,t){return t.copyFromFloats(this.x+e.x,this.y+e.y,this.z+e.z)},e.prototype.subtractInPlace=function(e){return this.x-=e.x,this.y-=e.y,this.z-=e.z,this},e.prototype.subtract=function(t){return new e(this.x-t.x,this.y-t.y,this.z-t.z)},e.prototype.subtractToRef=function(e,t){return this.subtractFromFloatsToRef(e.x,e.y,e.z,t)},e.prototype.subtractFromFloats=function(t,i,n){return new e(this.x-t,this.y-i,this.z-n)},e.prototype.subtractFromFloatsToRef=function(e,t,i,n){return n.copyFromFloats(this.x-e,this.y-t,this.z-i)},e.prototype.negate=function(){return new e(-this.x,-this.y,-this.z)},e.prototype.negateInPlace=function(){return this.x*=-1,this.y*=-1,this.z*=-1,this},e.prototype.negateToRef=function(e){return e.copyFromFloats(-1*this.x,-1*this.y,-1*this.z)},e.prototype.scaleInPlace=function(e){return this.x*=e,this.y*=e,this.z*=e,this},e.prototype.scale=function(t){return new e(this.x*t,this.y*t,this.z*t)},e.prototype.scaleToRef=function(e,t){return t.copyFromFloats(this.x*e,this.y*e,this.z*e)},e.prototype.scaleAndAddToRef=function(e,t){return t.addInPlaceFromFloats(this.x*e,this.y*e,this.z*e)},e.prototype.equals=function(e){return e&&this.x===e.x&&this.y===e.y&&this.z===e.z},e.prototype.equalsWithEpsilon=function(e,t){return void 0===t&&(t=r.a),e&&n.a.WithinEpsilon(this.x,e.x,t)&&n.a.WithinEpsilon(this.y,e.y,t)&&n.a.WithinEpsilon(this.z,e.z,t)},e.prototype.equalsToFloats=function(e,t,i){return this.x===e&&this.y===t&&this.z===i},e.prototype.multiplyInPlace=function(e){return this.x*=e.x,this.y*=e.y,this.z*=e.z,this},e.prototype.multiply=function(e){return this.multiplyByFloats(e.x,e.y,e.z)},e.prototype.multiplyToRef=function(e,t){return t.copyFromFloats(this.x*e.x,this.y*e.y,this.z*e.z)},e.prototype.multiplyByFloats=function(t,i,n){return new e(this.x*t,this.y*i,this.z*n)},e.prototype.divide=function(t){return new e(this.x/t.x,this.y/t.y,this.z/t.z)},e.prototype.divideToRef=function(e,t){return t.copyFromFloats(this.x/e.x,this.y/e.y,this.z/e.z)},e.prototype.divideInPlace=function(e){return this.divideToRef(e,this)},e.prototype.minimizeInPlace=function(e){return this.minimizeInPlaceFromFloats(e.x,e.y,e.z)},e.prototype.maximizeInPlace=function(e){return this.maximizeInPlaceFromFloats(e.x,e.y,e.z)},e.prototype.minimizeInPlaceFromFloats=function(e,t,i){return e<this.x&&(this.x=e),t<this.y&&(this.y=t),i<this.z&&(this.z=i),this},e.prototype.maximizeInPlaceFromFloats=function(e,t,i){return e>this.x&&(this.x=e),t>this.y&&(this.y=t),i>this.z&&(this.z=i),this},e.prototype.isNonUniformWithinEpsilon=function(e){var t=Math.abs(this.x),i=Math.abs(this.y);if(!n.a.WithinEpsilon(t,i,e))return!0;var r=Math.abs(this.z);return!n.a.WithinEpsilon(t,r,e)||!n.a.WithinEpsilon(i,r,e)},Object.defineProperty(e.prototype,"isNonUniform",{get:function(){var e=Math.abs(this.x),t=Math.abs(this.y);if(e!==t)return!0;var i=Math.abs(this.z);return e!==i||t!==i},enumerable:!0,configurable:!0}),e.prototype.floor=function(){return new e(Math.floor(this.x),Math.floor(this.y),Math.floor(this.z))},e.prototype.fract=function(){return new e(this.x-Math.floor(this.x),this.y-Math.floor(this.y),this.z-Math.floor(this.z))},e.prototype.length=function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z)},e.prototype.lengthSquared=function(){return this.x*this.x+this.y*this.y+this.z*this.z},e.prototype.normalize=function(){return this.normalizeFromLength(this.length())},e.prototype.reorderInPlace=function(e){var t=this;return"xyz"===(e=e.toLowerCase())?this:(d.Vector3[0].copyFrom(this),["x","y","z"].forEach(function(i,n){t[i]=d.Vector3[0][e[n]]}),this)},e.prototype.rotateByQuaternionToRef=function(t,i){return t.toRotationMatrix(d.Matrix[0]),e.TransformCoordinatesToRef(this,d.Matrix[0],i),i},e.prototype.rotateByQuaternionAroundPointToRef=function(e,t,i){return this.subtractToRef(t,d.Vector3[0]),d.Vector3[0].rotateByQuaternionToRef(e,d.Vector3[0]),t.addToRef(d.Vector3[0],i),i},e.prototype.cross=function(t){return e.Cross(this,t)},e.prototype.normalizeFromLength=function(e){return 0===e||1===e?this:this.scaleInPlace(1/e)},e.prototype.normalizeToNew=function(){var t=new e(0,0,0);return this.normalizeToRef(t),t},e.prototype.normalizeToRef=function(e){var t=this.length();return 0===t||1===t?e.copyFromFloats(this.x,this.y,this.z):this.scaleToRef(1/t,e)},e.prototype.clone=function(){return new e(this.x,this.y,this.z)},e.prototype.copyFrom=function(e){return this.copyFromFloats(e.x,e.y,e.z)},e.prototype.copyFromFloats=function(e,t,i){return this.x=e,this.y=t,this.z=i,this},e.prototype.set=function(e,t,i){return this.copyFromFloats(e,t,i)},e.prototype.setAll=function(e){return this.x=this.y=this.z=e,this},e.GetClipFactor=function(t,i,n,r){var o=e.Dot(t,n)-r;return o/(o-(e.Dot(i,n)-r))},e.GetAngleBetweenVectors=function(t,i,n){var r=t.normalizeToRef(d.Vector3[1]),o=i.normalizeToRef(d.Vector3[2]),a=e.Dot(r,o),s=d.Vector3[3];return e.CrossToRef(r,o,s),e.Dot(s,n)>0?Math.acos(a):-Math.acos(a)},e.FromArray=function(t,i){return void 0===i&&(i=0),new e(t[i],t[i+1],t[i+2])},e.FromFloatArray=function(t,i){return e.FromArray(t,i)},e.FromArrayToRef=function(e,t,i){i.x=e[t],i.y=e[t+1],i.z=e[t+2]},e.FromFloatArrayToRef=function(t,i,n){return e.FromArrayToRef(t,i,n)},e.FromFloatsToRef=function(e,t,i,n){n.copyFromFloats(e,t,i)},e.Zero=function(){return new e(0,0,0)},e.One=function(){return new e(1,1,1)},e.Up=function(){return new e(0,1,0)},Object.defineProperty(e,"UpReadOnly",{get:function(){return e._UpReadOnly},enumerable:!0,configurable:!0}),Object.defineProperty(e,"ZeroReadOnly",{get:function(){return e._ZeroReadOnly},enumerable:!0,configurable:!0}),e.Down=function(){return new e(0,-1,0)},e.Forward=function(){return new e(0,0,1)},e.Backward=function(){return new e(0,0,-1)},e.Right=function(){return new e(1,0,0)},e.Left=function(){return new e(-1,0,0)},e.TransformCoordinates=function(t,i){var n=e.Zero();return e.TransformCoordinatesToRef(t,i,n),n},e.TransformCoordinatesToRef=function(t,i,n){e.TransformCoordinatesFromFloatsToRef(t.x,t.y,t.z,i,n)},e.TransformCoordinatesFromFloatsToRef=function(e,t,i,n,r){var o=n.m,a=e*o[0]+t*o[4]+i*o[8]+o[12],s=e*o[1]+t*o[5]+i*o[9]+o[13],c=e*o[2]+t*o[6]+i*o[10]+o[14],l=1/(e*o[3]+t*o[7]+i*o[11]+o[15]);r.x=a*l,r.y=s*l,r.z=c*l},e.TransformNormal=function(t,i){var n=e.Zero();return e.TransformNormalToRef(t,i,n),n},e.TransformNormalToRef=function(e,t,i){this.TransformNormalFromFloatsToRef(e.x,e.y,e.z,t,i)},e.TransformNormalFromFloatsToRef=function(e,t,i,n,r){var o=n.m;r.x=e*o[0]+t*o[4]+i*o[8],r.y=e*o[1]+t*o[5]+i*o[9],r.z=e*o[2]+t*o[6]+i*o[10]},e.CatmullRom=function(t,i,n,r,o){var a=o*o,s=o*a;return new e(.5*(2*i.x+(-t.x+n.x)*o+(2*t.x-5*i.x+4*n.x-r.x)*a+(-t.x+3*i.x-3*n.x+r.x)*s),.5*(2*i.y+(-t.y+n.y)*o+(2*t.y-5*i.y+4*n.y-r.y)*a+(-t.y+3*i.y-3*n.y+r.y)*s),.5*(2*i.z+(-t.z+n.z)*o+(2*t.z-5*i.z+4*n.z-r.z)*a+(-t.z+3*i.z-3*n.z+r.z)*s))},e.Clamp=function(t,i,n){var r=new e;return e.ClampToRef(t,i,n,r),r},e.ClampToRef=function(e,t,i,n){var r=e.x;r=(r=r>i.x?i.x:r)<t.x?t.x:r;var o=e.y;o=(o=o>i.y?i.y:o)<t.y?t.y:o;var a=e.z;a=(a=a>i.z?i.z:a)<t.z?t.z:a,n.copyFromFloats(r,o,a)},e.CheckExtends=function(e,t,i){t.minimizeInPlace(e),i.maximizeInPlace(e)},e.Hermite=function(t,i,n,r,o){var a=o*o,s=o*a,c=2*s-3*a+1,l=-2*s+3*a,u=s-2*a+o,h=s-a;return new e(t.x*c+n.x*l+i.x*u+r.x*h,t.y*c+n.y*l+i.y*u+r.y*h,t.z*c+n.z*l+i.z*u+r.z*h)},e.Lerp=function(t,i,n){var r=new e(0,0,0);return e.LerpToRef(t,i,n,r),r},e.LerpToRef=function(e,t,i,n){n.x=e.x+(t.x-e.x)*i,n.y=e.y+(t.y-e.y)*i,n.z=e.z+(t.z-e.z)*i},e.Dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},e.Cross=function(t,i){var n=e.Zero();return e.CrossToRef(t,i,n),n},e.CrossToRef=function(e,t,i){var n=e.y*t.z-e.z*t.y,r=e.z*t.x-e.x*t.z,o=e.x*t.y-e.y*t.x;i.copyFromFloats(n,r,o)},e.Normalize=function(t){var i=e.Zero();return e.NormalizeToRef(t,i),i},e.NormalizeToRef=function(e,t){e.normalizeToRef(t)},e.Project=function(t,i,n,r){var o=r.width,a=r.height,s=r.x,c=r.y,l=d.Matrix[1];h.FromValuesToRef(o/2,0,0,0,0,-a/2,0,0,0,0,.5,0,s+o/2,a/2+c,.5,1,l);var u=d.Matrix[0];return i.multiplyToRef(n,u),u.multiplyToRef(l,u),e.TransformCoordinates(t,u)},e._UnprojectFromInvertedMatrixToRef=function(t,i,r){e.TransformCoordinatesToRef(t,i,r);var o=i.m,a=t.x*o[3]+t.y*o[7]+t.z*o[11]+o[15];n.a.WithinEpsilon(a,1)&&r.scaleInPlace(1/a)},e.UnprojectFromTransform=function(t,i,n,r,o){var a=d.Matrix[0];r.multiplyToRef(o,a),a.invert(),t.x=t.x/i*2-1,t.y=-(t.y/n*2-1);var s=new e;return e._UnprojectFromInvertedMatrixToRef(t,a,s),s},e.Unproject=function(t,i,n,r,o,a){var s=e.Zero();return e.UnprojectToRef(t,i,n,r,o,a,s),s},e.UnprojectToRef=function(t,i,n,r,o,a,s){e.UnprojectFloatsToRef(t.x,t.y,t.z,i,n,r,o,a,s)},e.UnprojectFloatsToRef=function(t,i,n,r,o,a,s,c,l){var u=d.Matrix[0];a.multiplyToRef(s,u),u.multiplyToRef(c,u),u.invert();var h=d.Vector3[0];h.x=t/r*2-1,h.y=-(i/o*2-1),h.z=2*n-1,e._UnprojectFromInvertedMatrixToRef(h,u,l)},e.Minimize=function(e,t){var i=e.clone();return i.minimizeInPlace(t),i},e.Maximize=function(e,t){var i=e.clone();return i.maximizeInPlace(t),i},e.Distance=function(t,i){return Math.sqrt(e.DistanceSquared(t,i))},e.DistanceSquared=function(e,t){var i=e.x-t.x,n=e.y-t.y,r=e.z-t.z;return i*i+n*n+r*r},e.Center=function(e,t){var i=e.add(t);return i.scaleInPlace(.5),i},e.RotationFromAxis=function(t,i,n){var r=e.Zero();return e.RotationFromAxisToRef(t,i,n,r),r},e.RotationFromAxisToRef=function(e,t,i,n){var r=d.Quaternion[0];u.RotationQuaternionFromAxisToRef(e,t,i,r),r.toEulerAnglesToRef(n)},e._UpReadOnly=e.Up(),e._ZeroReadOnly=e.Zero(),e}(),l=function(){function e(e,t,i,n){this.x=e,this.y=t,this.z=i,this.w=n}return e.prototype.toString=function(){return"{X: "+this.x+" Y:"+this.y+" Z:"+this.z+" W:"+this.w+"}"},e.prototype.getClassName=function(){return"Vector4"},e.prototype.getHashCode=function(){var e=0|this.x;return e=397*(e=397*(e=397*e^(0|this.y))^(0|this.z))^(0|this.w)},e.prototype.asArray=function(){var e=new Array;return this.toArray(e,0),e},e.prototype.toArray=function(e,t){return void 0===t&&(t=0),e[t]=this.x,e[t+1]=this.y,e[t+2]=this.z,e[t+3]=this.w,this},e.prototype.addInPlace=function(e){return this.x+=e.x,this.y+=e.y,this.z+=e.z,this.w+=e.w,this},e.prototype.add=function(t){return new e(this.x+t.x,this.y+t.y,this.z+t.z,this.w+t.w)},e.prototype.addToRef=function(e,t){return t.x=this.x+e.x,t.y=this.y+e.y,t.z=this.z+e.z,t.w=this.w+e.w,this},e.prototype.subtractInPlace=function(e){return this.x-=e.x,this.y-=e.y,this.z-=e.z,this.w-=e.w,this},e.prototype.subtract=function(t){return new e(this.x-t.x,this.y-t.y,this.z-t.z,this.w-t.w)},e.prototype.subtractToRef=function(e,t){return t.x=this.x-e.x,t.y=this.y-e.y,t.z=this.z-e.z,t.w=this.w-e.w,this},e.prototype.subtractFromFloats=function(t,i,n,r){return new e(this.x-t,this.y-i,this.z-n,this.w-r)},e.prototype.subtractFromFloatsToRef=function(e,t,i,n,r){return r.x=this.x-e,r.y=this.y-t,r.z=this.z-i,r.w=this.w-n,this},e.prototype.negate=function(){return new e(-this.x,-this.y,-this.z,-this.w)},e.prototype.negateInPlace=function(){return this.x*=-1,this.y*=-1,this.z*=-1,this.w*=-1,this},e.prototype.negateToRef=function(e){return e.copyFromFloats(-1*this.x,-1*this.y,-1*this.z,-1*this.w)},e.prototype.scaleInPlace=function(e){return this.x*=e,this.y*=e,this.z*=e,this.w*=e,this},e.prototype.scale=function(t){return new e(this.x*t,this.y*t,this.z*t,this.w*t)},e.prototype.scaleToRef=function(e,t){return t.x=this.x*e,t.y=this.y*e,t.z=this.z*e,t.w=this.w*e,this},e.prototype.scaleAndAddToRef=function(e,t){return t.x+=this.x*e,t.y+=this.y*e,t.z+=this.z*e,t.w+=this.w*e,this},e.prototype.equals=function(e){return e&&this.x===e.x&&this.y===e.y&&this.z===e.z&&this.w===e.w},e.prototype.equalsWithEpsilon=function(e,t){return void 0===t&&(t=r.a),e&&n.a.WithinEpsilon(this.x,e.x,t)&&n.a.WithinEpsilon(this.y,e.y,t)&&n.a.WithinEpsilon(this.z,e.z,t)&&n.a.WithinEpsilon(this.w,e.w,t)},e.prototype.equalsToFloats=function(e,t,i,n){return this.x===e&&this.y===t&&this.z===i&&this.w===n},e.prototype.multiplyInPlace=function(e){return this.x*=e.x,this.y*=e.y,this.z*=e.z,this.w*=e.w,this},e.prototype.multiply=function(t){return new e(this.x*t.x,this.y*t.y,this.z*t.z,this.w*t.w)},e.prototype.multiplyToRef=function(e,t){return t.x=this.x*e.x,t.y=this.y*e.y,t.z=this.z*e.z,t.w=this.w*e.w,this},e.prototype.multiplyByFloats=function(t,i,n,r){return new e(this.x*t,this.y*i,this.z*n,this.w*r)},e.prototype.divide=function(t){return new e(this.x/t.x,this.y/t.y,this.z/t.z,this.w/t.w)},e.prototype.divideToRef=function(e,t){return t.x=this.x/e.x,t.y=this.y/e.y,t.z=this.z/e.z,t.w=this.w/e.w,this},e.prototype.divideInPlace=function(e){return this.divideToRef(e,this)},e.prototype.minimizeInPlace=function(e){return e.x<this.x&&(this.x=e.x),e.y<this.y&&(this.y=e.y),e.z<this.z&&(this.z=e.z),e.w<this.w&&(this.w=e.w),this},e.prototype.maximizeInPlace=function(e){return e.x>this.x&&(this.x=e.x),e.y>this.y&&(this.y=e.y),e.z>this.z&&(this.z=e.z),e.w>this.w&&(this.w=e.w),this},e.prototype.floor=function(){return new e(Math.floor(this.x),Math.floor(this.y),Math.floor(this.z),Math.floor(this.w))},e.prototype.fract=function(){return new e(this.x-Math.floor(this.x),this.y-Math.floor(this.y),this.z-Math.floor(this.z),this.w-Math.floor(this.w))},e.prototype.length=function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},e.prototype.lengthSquared=function(){return this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w},e.prototype.normalize=function(){var e=this.length();return 0===e?this:this.scaleInPlace(1/e)},e.prototype.toVector3=function(){return new c(this.x,this.y,this.z)},e.prototype.clone=function(){return new e(this.x,this.y,this.z,this.w)},e.prototype.copyFrom=function(e){return this.x=e.x,this.y=e.y,this.z=e.z,this.w=e.w,this},e.prototype.copyFromFloats=function(e,t,i,n){return this.x=e,this.y=t,this.z=i,this.w=n,this},e.prototype.set=function(e,t,i,n){return this.copyFromFloats(e,t,i,n)},e.prototype.setAll=function(e){return this.x=this.y=this.z=this.w=e,this},e.FromArray=function(t,i){return i||(i=0),new e(t[i],t[i+1],t[i+2],t[i+3])},e.FromArrayToRef=function(e,t,i){i.x=e[t],i.y=e[t+1],i.z=e[t+2],i.w=e[t+3]},e.FromFloatArrayToRef=function(t,i,n){e.FromArrayToRef(t,i,n)},e.FromFloatsToRef=function(e,t,i,n,r){r.x=e,r.y=t,r.z=i,r.w=n},e.Zero=function(){return new e(0,0,0,0)},e.One=function(){return new e(1,1,1,1)},e.Normalize=function(t){var i=e.Zero();return e.NormalizeToRef(t,i),i},e.NormalizeToRef=function(e,t){t.copyFrom(e),t.normalize()},e.Minimize=function(e,t){var i=e.clone();return i.minimizeInPlace(t),i},e.Maximize=function(e,t){var i=e.clone();return i.maximizeInPlace(t),i},e.Distance=function(t,i){return Math.sqrt(e.DistanceSquared(t,i))},e.DistanceSquared=function(e,t){var i=e.x-t.x,n=e.y-t.y,r=e.z-t.z,o=e.w-t.w;return i*i+n*n+r*r+o*o},e.Center=function(e,t){var i=e.add(t);return i.scaleInPlace(.5),i},e.TransformNormal=function(t,i){var n=e.Zero();return e.TransformNormalToRef(t,i,n),n},e.TransformNormalToRef=function(e,t,i){var n=t.m,r=e.x*n[0]+e.y*n[4]+e.z*n[8],o=e.x*n[1]+e.y*n[5]+e.z*n[9],a=e.x*n[2]+e.y*n[6]+e.z*n[10];i.x=r,i.y=o,i.z=a,i.w=e.w},e.TransformNormalFromFloatsToRef=function(e,t,i,n,r,o){var a=r.m;o.x=e*a[0]+t*a[4]+i*a[8],o.y=e*a[1]+t*a[5]+i*a[9],o.z=e*a[2]+t*a[6]+i*a[10],o.w=n},e.FromVector3=function(t,i){return void 0===i&&(i=0),new e(t.x,t.y,t.z,i)},e}(),u=function(){function e(e,t,i,n){void 0===e&&(e=0),void 0===t&&(t=0),void 0===i&&(i=0),void 0===n&&(n=1),this.x=e,this.y=t,this.z=i,this.w=n}return e.prototype.toString=function(){return"{X: "+this.x+" Y:"+this.y+" Z:"+this.z+" W:"+this.w+"}"},e.prototype.getClassName=function(){return"Quaternion"},e.prototype.getHashCode=function(){var e=0|this.x;return e=397*(e=397*(e=397*e^(0|this.y))^(0|this.z))^(0|this.w)},e.prototype.asArray=function(){return[this.x,this.y,this.z,this.w]},e.prototype.equals=function(e){return e&&this.x===e.x&&this.y===e.y&&this.z===e.z&&this.w===e.w},e.prototype.equalsWithEpsilon=function(e,t){return void 0===t&&(t=r.a),e&&n.a.WithinEpsilon(this.x,e.x,t)&&n.a.WithinEpsilon(this.y,e.y,t)&&n.a.WithinEpsilon(this.z,e.z,t)&&n.a.WithinEpsilon(this.w,e.w,t)},e.prototype.clone=function(){return new e(this.x,this.y,this.z,this.w)},e.prototype.copyFrom=function(e){return this.x=e.x,this.y=e.y,this.z=e.z,this.w=e.w,this},e.prototype.copyFromFloats=function(e,t,i,n){return this.x=e,this.y=t,this.z=i,this.w=n,this},e.prototype.set=function(e,t,i,n){return this.copyFromFloats(e,t,i,n)},e.prototype.add=function(t){return new e(this.x+t.x,this.y+t.y,this.z+t.z,this.w+t.w)},e.prototype.addInPlace=function(e){return this.x+=e.x,this.y+=e.y,this.z+=e.z,this.w+=e.w,this},e.prototype.subtract=function(t){return new e(this.x-t.x,this.y-t.y,this.z-t.z,this.w-t.w)},e.prototype.scale=function(t){return new e(this.x*t,this.y*t,this.z*t,this.w*t)},e.prototype.scaleToRef=function(e,t){return t.x=this.x*e,t.y=this.y*e,t.z=this.z*e,t.w=this.w*e,this},e.prototype.scaleInPlace=function(e){return this.x*=e,this.y*=e,this.z*=e,this.w*=e,this},e.prototype.scaleAndAddToRef=function(e,t){return t.x+=this.x*e,t.y+=this.y*e,t.z+=this.z*e,t.w+=this.w*e,this},e.prototype.multiply=function(t){var i=new e(0,0,0,1);return this.multiplyToRef(t,i),i},e.prototype.multiplyToRef=function(e,t){var i=this.x*e.w+this.y*e.z-this.z*e.y+this.w*e.x,n=-this.x*e.z+this.y*e.w+this.z*e.x+this.w*e.y,r=this.x*e.y-this.y*e.x+this.z*e.w+this.w*e.z,o=-this.x*e.x-this.y*e.y-this.z*e.z+this.w*e.w;return t.copyFromFloats(i,n,r,o),this},e.prototype.multiplyInPlace=function(e){return this.multiplyToRef(e,this),this},e.prototype.conjugateToRef=function(e){return e.copyFromFloats(-this.x,-this.y,-this.z,this.w),this},e.prototype.conjugateInPlace=function(){return this.x*=-1,this.y*=-1,this.z*=-1,this},e.prototype.conjugate=function(){return new e(-this.x,-this.y,-this.z,this.w)},e.prototype.length=function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},e.prototype.normalize=function(){var e=this.length();if(0===e)return this;var t=1/e;return this.x*=t,this.y*=t,this.z*=t,this.w*=t,this},e.prototype.toEulerAngles=function(e){void 0===e&&(e="YZX");var t=c.Zero();return this.toEulerAnglesToRef(t),t},e.prototype.toEulerAnglesToRef=function(e){var t=this.z,i=this.x,n=this.y,r=this.w,o=r*r,a=t*t,s=i*i,c=n*n,l=n*t-i*r;return l<-.4999999?(e.y=2*Math.atan2(n,r),e.x=Math.PI/2,e.z=0):l>.4999999?(e.y=2*Math.atan2(n,r),e.x=-Math.PI/2,e.z=0):(e.z=Math.atan2(2*(i*n+t*r),-a-s+c+o),e.x=Math.asin(-2*(t*n-i*r)),e.y=Math.atan2(2*(t*i+n*r),a-s-c+o)),this},e.prototype.toRotationMatrix=function(e){return h.FromQuaternionToRef(this,e),this},e.prototype.fromRotationMatrix=function(t){return e.FromRotationMatrixToRef(t,this),this},e.FromRotationMatrix=function(t){var i=new e;return e.FromRotationMatrixToRef(t,i),i},e.FromRotationMatrixToRef=function(e,t){var i,n=e.m,r=n[0],o=n[4],a=n[8],s=n[1],c=n[5],l=n[9],u=n[2],h=n[6],d=n[10],f=r+c+d;f>0?(i=.5/Math.sqrt(f+1),t.w=.25/i,t.x=(h-l)*i,t.y=(a-u)*i,t.z=(s-o)*i):r>c&&r>d?(i=2*Math.sqrt(1+r-c-d),t.w=(h-l)/i,t.x=.25*i,t.y=(o+s)/i,t.z=(a+u)/i):c>d?(i=2*Math.sqrt(1+c-r-d),t.w=(a-u)/i,t.x=(o+s)/i,t.y=.25*i,t.z=(l+h)/i):(i=2*Math.sqrt(1+d-r-c),t.w=(s-o)/i,t.x=(a+u)/i,t.y=(l+h)/i,t.z=.25*i)},e.Dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},e.AreClose=function(t,i){return e.Dot(t,i)>=0},e.Zero=function(){return new e(0,0,0,0)},e.Inverse=function(t){return new e(-t.x,-t.y,-t.z,t.w)},e.InverseToRef=function(e,t){return t.set(-e.x,-e.y,-e.z,e.w),t},e.Identity=function(){return new e(0,0,0,1)},e.IsIdentity=function(e){return e&&0===e.x&&0===e.y&&0===e.z&&1===e.w},e.RotationAxis=function(t,i){return e.RotationAxisToRef(t,i,new e)},e.RotationAxisToRef=function(e,t,i){var n=Math.sin(t/2);return e.normalize(),i.w=Math.cos(t/2),i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i},e.FromArray=function(t,i){return i||(i=0),new e(t[i],t[i+1],t[i+2],t[i+3])},e.FromEulerAngles=function(t,i,n){var r=new e;return e.RotationYawPitchRollToRef(i,t,n,r),r},e.FromEulerAnglesToRef=function(t,i,n,r){return e.RotationYawPitchRollToRef(i,t,n,r),r},e.FromEulerVector=function(t){var i=new e;return e.RotationYawPitchRollToRef(t.y,t.x,t.z,i),i},e.FromEulerVectorToRef=function(t,i){return e.RotationYawPitchRollToRef(t.y,t.x,t.z,i),i},e.RotationYawPitchRoll=function(t,i,n){var r=new e;return e.RotationYawPitchRollToRef(t,i,n,r),r},e.RotationYawPitchRollToRef=function(e,t,i,n){var r=.5*i,o=.5*t,a=.5*e,s=Math.sin(r),c=Math.cos(r),l=Math.sin(o),u=Math.cos(o),h=Math.sin(a),d=Math.cos(a);n.x=d*l*c+h*u*s,n.y=h*u*c-d*l*s,n.z=d*u*s-h*l*c,n.w=d*u*c+h*l*s},e.RotationAlphaBetaGamma=function(t,i,n){var r=new e;return e.RotationAlphaBetaGammaToRef(t,i,n,r),r},e.RotationAlphaBetaGammaToRef=function(e,t,i,n){var r=.5*(i+e),o=.5*(i-e),a=.5*t;n.x=Math.cos(o)*Math.sin(a),n.y=Math.sin(o)*Math.sin(a),n.z=Math.sin(r)*Math.cos(a),n.w=Math.cos(r)*Math.cos(a)},e.RotationQuaternionFromAxis=function(t,i,n){var r=new e(0,0,0,0);return e.RotationQuaternionFromAxisToRef(t,i,n,r),r},e.RotationQuaternionFromAxisToRef=function(t,i,n,r){var o=d.Matrix[0];h.FromXYZAxesToRef(t.normalize(),i.normalize(),n.normalize(),o),e.FromRotationMatrixToRef(o,r)},e.Slerp=function(t,i,n){var r=e.Identity();return e.SlerpToRef(t,i,n,r),r},e.SlerpToRef=function(e,t,i,n){var r,o,a=e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w,s=!1;if(a<0&&(s=!0,a=-a),a>.999999)o=1-i,r=s?-i:i;else{var c=Math.acos(a),l=1/Math.sin(c);o=Math.sin((1-i)*c)*l,r=s?-Math.sin(i*c)*l:Math.sin(i*c)*l}n.x=o*e.x+r*t.x,n.y=o*e.y+r*t.y,n.z=o*e.z+r*t.z,n.w=o*e.w+r*t.w},e.Hermite=function(t,i,n,r,o){var a=o*o,s=o*a,c=2*s-3*a+1,l=-2*s+3*a,u=s-2*a+o,h=s-a;return new e(t.x*c+n.x*l+i.x*u+r.x*h,t.y*c+n.y*l+i.y*u+r.y*h,t.z*c+n.z*l+i.z*u+r.z*h,t.w*c+n.w*l+i.w*u+r.w*h)},e}(),h=function(){function e(){this._isIdentity=!1,this._isIdentityDirty=!0,this._isIdentity3x2=!0,this._isIdentity3x2Dirty=!0,this.updateFlag=-1,this._m=new Float32Array(16),this._updateIdentityStatus(!1)}return Object.defineProperty(e.prototype,"m",{get:function(){return this._m},enumerable:!0,configurable:!0}),e.prototype._markAsUpdated=function(){this.updateFlag=e._updateFlagSeed++,this._isIdentity=!1,this._isIdentity3x2=!1,this._isIdentityDirty=!0,this._isIdentity3x2Dirty=!0},e.prototype._updateIdentityStatus=function(t,i,n,r){void 0===i&&(i=!1),void 0===n&&(n=!1),void 0===r&&(r=!0),this.updateFlag=e._updateFlagSeed++,this._isIdentity=t,this._isIdentity3x2=t||n,this._isIdentityDirty=!this._isIdentity&&i,this._isIdentity3x2Dirty=!this._isIdentity3x2&&r},e.prototype.isIdentity=function(){if(this._isIdentityDirty){this._isIdentityDirty=!1;var e=this._m;this._isIdentity=1===e[0]&&0===e[1]&&0===e[2]&&0===e[3]&&0===e[4]&&1===e[5]&&0===e[6]&&0===e[7]&&0===e[8]&&0===e[9]&&1===e[10]&&0===e[11]&&0===e[12]&&0===e[13]&&0===e[14]&&1===e[15]}return this._isIdentity},e.prototype.isIdentityAs3x2=function(){return this._isIdentity3x2Dirty&&(this._isIdentity3x2Dirty=!1,1!==this._m[0]||1!==this._m[5]||1!==this._m[15]?this._isIdentity3x2=!1:0!==this._m[1]||0!==this._m[2]||0!==this._m[3]||0!==this._m[4]||0!==this._m[6]||0!==this._m[7]||0!==this._m[8]||0!==this._m[9]||0!==this._m[10]||0!==this._m[11]||0!==this._m[12]||0!==this._m[13]||0!==this._m[14]?this._isIdentity3x2=!1:this._isIdentity3x2=!0),this._isIdentity3x2},e.prototype.determinant=function(){if(!0===this._isIdentity)return 1;var e=this._m,t=e[0],i=e[1],n=e[2],r=e[3],o=e[4],a=e[5],s=e[6],c=e[7],l=e[8],u=e[9],h=e[10],d=e[11],f=e[12],p=e[13],_=e[14],m=e[15],g=h*m-_*d,v=u*m-p*d,y=u*_-p*h,b=l*m-f*d,T=l*_-h*f,E=l*p-f*u;return t*+(a*g-s*v+c*y)+i*-(o*g-s*b+c*T)+n*+(o*v-a*b+c*E)+r*-(o*y-a*T+s*E)},e.prototype.toArray=function(){return this._m},e.prototype.asArray=function(){return this._m},e.prototype.invert=function(){return this.invertToRef(this),this},e.prototype.reset=function(){return e.FromValuesToRef(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,this),this._updateIdentityStatus(!1),this},e.prototype.add=function(t){var i=new e;return this.addToRef(t,i),i},e.prototype.addToRef=function(e,t){for(var i=this._m,n=t._m,r=e.m,o=0;o<16;o++)n[o]=i[o]+r[o];return t._markAsUpdated(),this},e.prototype.addToSelf=function(e){for(var t=this._m,i=e.m,n=0;n<16;n++)t[n]+=i[n];return this._markAsUpdated(),this},e.prototype.invertToRef=function(t){if(!0===this._isIdentity)return e.IdentityToRef(t),this;var i=this._m,n=i[0],r=i[1],o=i[2],a=i[3],s=i[4],c=i[5],l=i[6],u=i[7],h=i[8],d=i[9],f=i[10],p=i[11],_=i[12],m=i[13],g=i[14],v=i[15],y=f*v-g*p,b=d*v-m*p,T=d*g-m*f,E=h*v-_*p,x=h*g-f*_,P=h*m-_*d,A=+(c*y-l*b+u*T),S=-(s*y-l*E+u*x),C=+(s*b-c*E+u*P),R=-(s*T-c*x+l*P),O=n*A+r*S+o*C+a*R;if(0===O)return t.copyFrom(this),this;var M=1/O,I=l*v-g*u,D=c*v-m*u,w=c*g-m*l,L=s*v-_*u,N=s*g-_*l,F=s*m-_*c,B=l*p-f*u,U=c*p-d*u,V=c*f-d*l,k=s*p-h*u,z=s*f-h*l,G=s*d-h*c,j=-(r*y-o*b+a*T),W=+(n*y-o*E+a*x),X=-(n*b-r*E+a*P),H=+(n*T-r*x+o*P),Y=+(r*I-o*D+a*w),K=-(n*I-o*L+a*N),Q=+(n*D-r*L+a*F),q=-(n*w-r*N+o*F),Z=-(r*B-o*U+a*V),J=+(n*B-o*k+a*z),$=-(n*U-r*k+a*G),ee=+(n*V-r*z+o*G);return e.FromValuesToRef(A*M,j*M,Y*M,Z*M,S*M,W*M,K*M,J*M,C*M,X*M,Q*M,$*M,R*M,H*M,q*M,ee*M,t),this},e.prototype.addAtIndex=function(e,t){return this._m[e]+=t,this._markAsUpdated(),this},e.prototype.multiplyAtIndex=function(e,t){return this._m[e]*=t,this._markAsUpdated(),this},e.prototype.setTranslationFromFloats=function(e,t,i){return this._m[12]=e,this._m[13]=t,this._m[14]=i,this._markAsUpdated(),this},e.prototype.addTranslationFromFloats=function(e,t,i){return this._m[12]+=e,this._m[13]+=t,this._m[14]+=i,this._markAsUpdated(),this},e.prototype.setTranslation=function(e){return this.setTranslationFromFloats(e.x,e.y,e.z)},e.prototype.getTranslation=function(){return new c(this._m[12],this._m[13],this._m[14])},e.prototype.getTranslationToRef=function(e){return e.x=this._m[12],e.y=this._m[13],e.z=this._m[14],this},e.prototype.removeRotationAndScaling=function(){var t=this.m;return e.FromValuesToRef(1,0,0,0,0,1,0,0,0,0,1,0,t[12],t[13],t[14],t[15],this),this._updateIdentityStatus(0===t[12]&&0===t[13]&&0===t[14]&&1===t[15]),this},e.prototype.multiply=function(t){var i=new e;return this.multiplyToRef(t,i),i},e.prototype.copyFrom=function(e){e.copyToArray(this._m);var t=e;return this._updateIdentityStatus(t._isIdentity,t._isIdentityDirty,t._isIdentity3x2,t._isIdentity3x2Dirty),this},e.prototype.copyToArray=function(e,t){void 0===t&&(t=0);var i=this._m;return e[t]=i[0],e[t+1]=i[1],e[t+2]=i[2],e[t+3]=i[3],e[t+4]=i[4],e[t+5]=i[5],e[t+6]=i[6],e[t+7]=i[7],e[t+8]=i[8],e[t+9]=i[9],e[t+10]=i[10],e[t+11]=i[11],e[t+12]=i[12],e[t+13]=i[13],e[t+14]=i[14],e[t+15]=i[15],this},e.prototype.multiplyToRef=function(e,t){return this._isIdentity?(t.copyFrom(e),this):e._isIdentity?(t.copyFrom(this),this):(this.multiplyToArray(e,t._m,0),t._markAsUpdated(),this)},e.prototype.multiplyToArray=function(e,t,i){var n=this._m,r=e.m,o=n[0],a=n[1],s=n[2],c=n[3],l=n[4],u=n[5],h=n[6],d=n[7],f=n[8],p=n[9],_=n[10],m=n[11],g=n[12],v=n[13],y=n[14],b=n[15],T=r[0],E=r[1],x=r[2],P=r[3],A=r[4],S=r[5],C=r[6],R=r[7],O=r[8],M=r[9],I=r[10],D=r[11],w=r[12],L=r[13],N=r[14],F=r[15];return t[i]=o*T+a*A+s*O+c*w,t[i+1]=o*E+a*S+s*M+c*L,t[i+2]=o*x+a*C+s*I+c*N,t[i+3]=o*P+a*R+s*D+c*F,t[i+4]=l*T+u*A+h*O+d*w,t[i+5]=l*E+u*S+h*M+d*L,t[i+6]=l*x+u*C+h*I+d*N,t[i+7]=l*P+u*R+h*D+d*F,t[i+8]=f*T+p*A+_*O+m*w,t[i+9]=f*E+p*S+_*M+m*L,t[i+10]=f*x+p*C+_*I+m*N,t[i+11]=f*P+p*R+_*D+m*F,t[i+12]=g*T+v*A+y*O+b*w,t[i+13]=g*E+v*S+y*M+b*L,t[i+14]=g*x+v*C+y*I+b*N,t[i+15]=g*P+v*R+y*D+b*F,this},e.prototype.equals=function(e){var t=e;if(!t)return!1;if((this._isIdentity||t._isIdentity)&&!this._isIdentityDirty&&!t._isIdentityDirty)return this._isIdentity&&t._isIdentity;var i=this.m,n=t.m;return i[0]===n[0]&&i[1]===n[1]&&i[2]===n[2]&&i[3]===n[3]&&i[4]===n[4]&&i[5]===n[5]&&i[6]===n[6]&&i[7]===n[7]&&i[8]===n[8]&&i[9]===n[9]&&i[10]===n[10]&&i[11]===n[11]&&i[12]===n[12]&&i[13]===n[13]&&i[14]===n[14]&&i[15]===n[15]},e.prototype.clone=function(){var t=new e;return t.copyFrom(this),t},e.prototype.getClassName=function(){return"Matrix"},e.prototype.getHashCode=function(){for(var e=0|this._m[0],t=1;t<16;t++)e=397*e^(0|this._m[t]);return e},e.prototype.decompose=function(t,i,n){if(this._isIdentity)return n&&n.setAll(0),t&&t.setAll(1),i&&i.copyFromFloats(0,0,0,1),!0;var r=this._m;if(n&&n.copyFromFloats(r[12],r[13],r[14]),(t=t||d.Vector3[0]).x=Math.sqrt(r[0]*r[0]+r[1]*r[1]+r[2]*r[2]),t.y=Math.sqrt(r[4]*r[4]+r[5]*r[5]+r[6]*r[6]),t.z=Math.sqrt(r[8]*r[8]+r[9]*r[9]+r[10]*r[10]),this.determinant()<=0&&(t.y*=-1),0===t.x||0===t.y||0===t.z)return i&&i.copyFromFloats(0,0,0,1),!1;if(i){var o=1/t.x,a=1/t.y,s=1/t.z;e.FromValuesToRef(r[0]*o,r[1]*o,r[2]*o,0,r[4]*a,r[5]*a,r[6]*a,0,r[8]*s,r[9]*s,r[10]*s,0,0,0,0,1,d.Matrix[0]),u.FromRotationMatrixToRef(d.Matrix[0],i)}return!0},e.prototype.getRow=function(e){if(e<0||e>3)return null;var t=4*e;return new l(this._m[t+0],this._m[t+1],this._m[t+2],this._m[t+3])},e.prototype.setRow=function(e,t){return this.setRowFromFloats(e,t.x,t.y,t.z,t.w)},e.prototype.transpose=function(){return e.Transpose(this)},e.prototype.transposeToRef=function(t){return e.TransposeToRef(this,t),this},e.prototype.setRowFromFloats=function(e,t,i,n,r){if(e<0||e>3)return this;var o=4*e;return this._m[o+0]=t,this._m[o+1]=i,this._m[o+2]=n,this._m[o+3]=r,this._markAsUpdated(),this},e.prototype.scale=function(t){var i=new e;return this.scaleToRef(t,i),i},e.prototype.scaleToRef=function(e,t){for(var i=0;i<16;i++)t._m[i]=this._m[i]*e;return t._markAsUpdated(),this},e.prototype.scaleAndAddToRef=function(e,t){for(var i=0;i<16;i++)t._m[i]+=this._m[i]*e;return t._markAsUpdated(),this},e.prototype.toNormalMatrix=function(t){var i=d.Matrix[0];this.invertToRef(i),i.transposeToRef(t);var n=t._m;e.FromValuesToRef(n[0],n[1],n[2],0,n[4],n[5],n[6],0,n[8],n[9],n[10],0,0,0,0,1,t)},e.prototype.getRotationMatrix=function(){var t=new e;return this.getRotationMatrixToRef(t),t},e.prototype.getRotationMatrixToRef=function(t){var i=d.Vector3[0];if(!this.decompose(i))return e.IdentityToRef(t),this;var n=this._m,r=1/i.x,o=1/i.y,a=1/i.z;return e.FromValuesToRef(n[0]*r,n[1]*r,n[2]*r,0,n[4]*o,n[5]*o,n[6]*o,0,n[8]*a,n[9]*a,n[10]*a,0,0,0,0,1,t),this},e.prototype.toggleModelMatrixHandInPlace=function(){var e=this._m;e[2]*=-1,e[6]*=-1,e[8]*=-1,e[9]*=-1,e[14]*=-1,this._markAsUpdated()},e.prototype.toggleProjectionMatrixHandInPlace=function(){var e=this._m;e[8]*=-1,e[9]*=-1,e[10]*=-1,e[11]*=-1,this._markAsUpdated()},e.FromArray=function(t,i){void 0===i&&(i=0);var n=new e;return e.FromArrayToRef(t,i,n),n},e.FromArrayToRef=function(e,t,i){for(var n=0;n<16;n++)i._m[n]=e[n+t];i._markAsUpdated()},e.FromFloat32ArrayToRefScaled=function(e,t,i,n){for(var r=0;r<16;r++)n._m[r]=e[r+t]*i;n._markAsUpdated()},Object.defineProperty(e,"IdentityReadOnly",{get:function(){return e._identityReadOnly},enumerable:!0,configurable:!0}),e.FromValuesToRef=function(e,t,i,n,r,o,a,s,c,l,u,h,d,f,p,_,m){var g=m._m;g[0]=e,g[1]=t,g[2]=i,g[3]=n,g[4]=r,g[5]=o,g[6]=a,g[7]=s,g[8]=c,g[9]=l,g[10]=u,g[11]=h,g[12]=d,g[13]=f,g[14]=p,g[15]=_,m._markAsUpdated()},e.FromValues=function(t,i,n,r,o,a,s,c,l,u,h,d,f,p,_,m){var g=new e,v=g._m;return v[0]=t,v[1]=i,v[2]=n,v[3]=r,v[4]=o,v[5]=a,v[6]=s,v[7]=c,v[8]=l,v[9]=u,v[10]=h,v[11]=d,v[12]=f,v[13]=p,v[14]=_,v[15]=m,g._markAsUpdated(),g},e.Compose=function(t,i,n){var r=new e;return e.ComposeToRef(t,i,n,r),r},e.ComposeToRef=function(e,t,i,n){var r=n._m,o=t.x,a=t.y,s=t.z,c=t.w,l=o+o,u=a+a,h=s+s,d=o*l,f=o*u,p=o*h,_=a*u,m=a*h,g=s*h,v=c*l,y=c*u,b=c*h,T=e.x,E=e.y,x=e.z;r[0]=(1-(_+g))*T,r[1]=(f+b)*T,r[2]=(p-y)*T,r[3]=0,r[4]=(f-b)*E,r[5]=(1-(d+g))*E,r[6]=(m+v)*E,r[7]=0,r[8]=(p+y)*x,r[9]=(m-v)*x,r[10]=(1-(d+_))*x,r[11]=0,r[12]=i.x,r[13]=i.y,r[14]=i.z,r[15]=1,n._markAsUpdated()},e.Identity=function(){var t=e.FromValues(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return t._updateIdentityStatus(!0),t},e.IdentityToRef=function(t){e.FromValuesToRef(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1,t),t._updateIdentityStatus(!0)},e.Zero=function(){var t=e.FromValues(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);return t._updateIdentityStatus(!1),t},e.RotationX=function(t){var i=new e;return e.RotationXToRef(t,i),i},e.Invert=function(t){var i=new e;return t.invertToRef(i),i},e.RotationXToRef=function(t,i){var n=Math.sin(t),r=Math.cos(t);e.FromValuesToRef(1,0,0,0,0,r,n,0,0,-n,r,0,0,0,0,1,i),i._updateIdentityStatus(1===r&&0===n)},e.RotationY=function(t){var i=new e;return e.RotationYToRef(t,i),i},e.RotationYToRef=function(t,i){var n=Math.sin(t),r=Math.cos(t);e.FromValuesToRef(r,0,-n,0,0,1,0,0,n,0,r,0,0,0,0,1,i),i._updateIdentityStatus(1===r&&0===n)},e.RotationZ=function(t){var i=new e;return e.RotationZToRef(t,i),i},e.RotationZToRef=function(t,i){var n=Math.sin(t),r=Math.cos(t);e.FromValuesToRef(r,n,0,0,-n,r,0,0,0,0,1,0,0,0,0,1,i),i._updateIdentityStatus(1===r&&0===n)},e.RotationAxis=function(t,i){var n=new e;return e.RotationAxisToRef(t,i,n),n},e.RotationAxisToRef=function(e,t,i){var n=Math.sin(-t),r=Math.cos(-t),o=1-r;e.normalize();var a=i._m;a[0]=e.x*e.x*o+r,a[1]=e.x*e.y*o-e.z*n,a[2]=e.x*e.z*o+e.y*n,a[3]=0,a[4]=e.y*e.x*o+e.z*n,a[5]=e.y*e.y*o+r,a[6]=e.y*e.z*o-e.x*n,a[7]=0,a[8]=e.z*e.x*o-e.y*n,a[9]=e.z*e.y*o+e.x*n,a[10]=e.z*e.z*o+r,a[11]=0,a[12]=0,a[13]=0,a[14]=0,a[15]=1,i._markAsUpdated()},e.RotationAlignToRef=function(e,t,i){var n=c.Cross(t,e),r=c.Dot(t,e),o=1/(1+r),a=i._m;a[0]=n.x*n.x*o+r,a[1]=n.y*n.x*o-n.z,a[2]=n.z*n.x*o+n.y,a[3]=0,a[4]=n.x*n.y*o+n.z,a[5]=n.y*n.y*o+r,a[6]=n.z*n.y*o-n.x,a[7]=0,a[8]=n.x*n.z*o-n.y,a[9]=n.y*n.z*o+n.x,a[10]=n.z*n.z*o+r,a[11]=0,a[12]=0,a[13]=0,a[14]=0,a[15]=1,i._markAsUpdated()},e.RotationYawPitchRoll=function(t,i,n){var r=new e;return e.RotationYawPitchRollToRef(t,i,n,r),r},e.RotationYawPitchRollToRef=function(e,t,i,n){u.RotationYawPitchRollToRef(e,t,i,d.Quaternion[0]),d.Quaternion[0].toRotationMatrix(n)},e.Scaling=function(t,i,n){var r=new e;return e.ScalingToRef(t,i,n,r),r},e.ScalingToRef=function(t,i,n,r){e.FromValuesToRef(t,0,0,0,0,i,0,0,0,0,n,0,0,0,0,1,r),r._updateIdentityStatus(1===t&&1===i&&1===n)},e.Translation=function(t,i,n){var r=new e;return e.TranslationToRef(t,i,n,r),r},e.TranslationToRef=function(t,i,n,r){e.FromValuesToRef(1,0,0,0,0,1,0,0,0,0,1,0,t,i,n,1,r),r._updateIdentityStatus(0===t&&0===i&&0===n)},e.Lerp=function(t,i,n){var r=new e;return e.LerpToRef(t,i,n,r),r},e.LerpToRef=function(e,t,i,n){for(var r=n._m,o=e.m,a=t.m,s=0;s<16;s++)r[s]=o[s]*(1-i)+a[s]*i;n._markAsUpdated()},e.DecomposeLerp=function(t,i,n){var r=new e;return e.DecomposeLerpToRef(t,i,n,r),r},e.DecomposeLerpToRef=function(t,i,n,r){var o=d.Vector3[0],a=d.Quaternion[0],s=d.Vector3[1];t.decompose(o,a,s);var l=d.Vector3[2],h=d.Quaternion[1],f=d.Vector3[3];i.decompose(l,h,f);var p=d.Vector3[4];c.LerpToRef(o,l,n,p);var _=d.Quaternion[2];u.SlerpToRef(a,h,n,_);var m=d.Vector3[5];c.LerpToRef(s,f,n,m),e.ComposeToRef(p,_,m,r)},e.LookAtLH=function(t,i,n){var r=new e;return e.LookAtLHToRef(t,i,n,r),r},e.LookAtLHToRef=function(t,i,n,r){var o=d.Vector3[0],a=d.Vector3[1],s=d.Vector3[2];i.subtractToRef(t,s),s.normalize(),c.CrossToRef(n,s,o);var l=o.lengthSquared();0===l?o.x=1:o.normalizeFromLength(Math.sqrt(l)),c.CrossToRef(s,o,a),a.normalize();var u=-c.Dot(o,t),h=-c.Dot(a,t),f=-c.Dot(s,t);e.FromValuesToRef(o.x,a.x,s.x,0,o.y,a.y,s.y,0,o.z,a.z,s.z,0,u,h,f,1,r)},e.LookAtRH=function(t,i,n){var r=new e;return e.LookAtRHToRef(t,i,n,r),r},e.LookAtRHToRef=function(t,i,n,r){var o=d.Vector3[0],a=d.Vector3[1],s=d.Vector3[2];t.subtractToRef(i,s),s.normalize(),c.CrossToRef(n,s,o);var l=o.lengthSquared();0===l?o.x=1:o.normalizeFromLength(Math.sqrt(l)),c.CrossToRef(s,o,a),a.normalize();var u=-c.Dot(o,t),h=-c.Dot(a,t),f=-c.Dot(s,t);e.FromValuesToRef(o.x,a.x,s.x,0,o.y,a.y,s.y,0,o.z,a.z,s.z,0,u,h,f,1,r)},e.OrthoLH=function(t,i,n,r){var o=new e;return e.OrthoLHToRef(t,i,n,r,o),o},e.OrthoLHToRef=function(t,i,n,r,o){var a=2/t,s=2/i,c=2/(r-n),l=-(r+n)/(r-n);e.FromValuesToRef(a,0,0,0,0,s,0,0,0,0,c,0,0,0,l,1,o),o._updateIdentityStatus(1===a&&1===s&&1===c&&0===l)},e.OrthoOffCenterLH=function(t,i,n,r,o,a){var s=new e;return e.OrthoOffCenterLHToRef(t,i,n,r,o,a,s),s},e.OrthoOffCenterLHToRef=function(t,i,n,r,o,a,s){var c=2/(i-t),l=2/(r-n),u=2/(a-o),h=-(a+o)/(a-o),d=(t+i)/(t-i),f=(r+n)/(n-r);e.FromValuesToRef(c,0,0,0,0,l,0,0,0,0,u,0,d,f,h,1,s),s._markAsUpdated()},e.OrthoOffCenterRH=function(t,i,n,r,o,a){var s=new e;return e.OrthoOffCenterRHToRef(t,i,n,r,o,a,s),s},e.OrthoOffCenterRHToRef=function(t,i,n,r,o,a,s){e.OrthoOffCenterLHToRef(t,i,n,r,o,a,s),s._m[10]*=-1},e.PerspectiveLH=function(t,i,n,r){var o=new e,a=2*n/t,s=2*n/i,c=(r+n)/(r-n),l=-2*r*n/(r-n);return e.FromValuesToRef(a,0,0,0,0,s,0,0,0,0,c,1,0,0,l,0,o),o._updateIdentityStatus(!1),o},e.PerspectiveFovLH=function(t,i,n,r){var o=new e;return e.PerspectiveFovLHToRef(t,i,n,r,o),o},e.PerspectiveFovLHToRef=function(t,i,n,r,o,a){void 0===a&&(a=!0);var s=n,c=r,l=1/Math.tan(.5*t),u=a?l/i:l,h=a?l:l*i,d=(c+s)/(c-s),f=-2*c*s/(c-s);e.FromValuesToRef(u,0,0,0,0,h,0,0,0,0,d,1,0,0,f,0,o),o._updateIdentityStatus(!1)},e.PerspectiveFovReverseLHToRef=function(t,i,n,r,o,a){void 0===a&&(a=!0);var s=1/Math.tan(.5*t),c=a?s/i:s,l=a?s:s*i;e.FromValuesToRef(c,0,0,0,0,l,0,0,0,0,-n,1,0,0,1,0,o),o._updateIdentityStatus(!1)},e.PerspectiveFovRH=function(t,i,n,r){var o=new e;return e.PerspectiveFovRHToRef(t,i,n,r,o),o},e.PerspectiveFovRHToRef=function(t,i,n,r,o,a){void 0===a&&(a=!0);var s=n,c=r,l=1/Math.tan(.5*t),u=a?l/i:l,h=a?l:l*i,d=-(c+s)/(c-s),f=-2*c*s/(c-s);e.FromValuesToRef(u,0,0,0,0,h,0,0,0,0,d,-1,0,0,f,0,o),o._updateIdentityStatus(!1)},e.PerspectiveFovReverseRHToRef=function(t,i,n,r,o,a){void 0===a&&(a=!0);var s=1/Math.tan(.5*t),c=a?s/i:s,l=a?s:s*i;e.FromValuesToRef(c,0,0,0,0,l,0,0,0,0,-n,-1,0,0,-1,0,o),o._updateIdentityStatus(!1)},e.PerspectiveFovWebVRToRef=function(e,t,i,n,r){void 0===r&&(r=!1);var o=r?-1:1,a=Math.tan(e.upDegrees*Math.PI/180),s=Math.tan(e.downDegrees*Math.PI/180),c=Math.tan(e.leftDegrees*Math.PI/180),l=Math.tan(e.rightDegrees*Math.PI/180),u=2/(c+l),h=2/(a+s),d=n._m;d[0]=u,d[1]=d[2]=d[3]=d[4]=0,d[5]=h,d[6]=d[7]=0,d[8]=(c-l)*u*.5,d[9]=-(a-s)*h*.5,d[10]=-i/(t-i),d[11]=1*o,d[12]=d[13]=d[15]=0,d[14]=-2*i*t/(i-t),n._markAsUpdated()},e.GetFinalMatrix=function(t,i,n,r,o,a){var s=t.width,c=t.height,l=t.x,u=t.y,h=e.FromValues(s/2,0,0,0,0,-c/2,0,0,0,0,a-o,0,l+s/2,c/2+u,o,1),f=d.Matrix[0];return i.multiplyToRef(n,f),f.multiplyToRef(r,f),f.multiply(h)},e.GetAsMatrix2x2=function(e){var t=e.m;return new Float32Array([t[0],t[1],t[4],t[5]])},e.GetAsMatrix3x3=function(e){var t=e.m;return new Float32Array([t[0],t[1],t[2],t[4],t[5],t[6],t[8],t[9],t[10]])},e.Transpose=function(t){var i=new e;return e.TransposeToRef(t,i),i},e.TransposeToRef=function(e,t){var i=t._m,n=e.m;i[0]=n[0],i[1]=n[4],i[2]=n[8],i[3]=n[12],i[4]=n[1],i[5]=n[5],i[6]=n[9],i[7]=n[13],i[8]=n[2],i[9]=n[6],i[10]=n[10],i[11]=n[14],i[12]=n[3],i[13]=n[7],i[14]=n[11],i[15]=n[15],t._updateIdentityStatus(e._isIdentity,e._isIdentityDirty)},e.Reflection=function(t){var i=new e;return e.ReflectionToRef(t,i),i},e.ReflectionToRef=function(t,i){t.normalize();var n=t.normal.x,r=t.normal.y,o=t.normal.z,a=-2*n,s=-2*r,c=-2*o;e.FromValuesToRef(a*n+1,s*n,c*n,0,a*r,s*r+1,c*r,0,a*o,s*o,c*o+1,0,a*t.d,s*t.d,c*t.d,1,i)},e.FromXYZAxesToRef=function(t,i,n,r){e.FromValuesToRef(t.x,t.y,t.z,0,i.x,i.y,i.z,0,n.x,n.y,n.z,0,0,0,0,1,r)},e.FromQuaternionToRef=function(e,t){var i=e.x*e.x,n=e.y*e.y,r=e.z*e.z,o=e.x*e.y,a=e.z*e.w,s=e.z*e.x,c=e.y*e.w,l=e.y*e.z,u=e.x*e.w;t._m[0]=1-2*(n+r),t._m[1]=2*(o+a),t._m[2]=2*(s-c),t._m[3]=0,t._m[4]=2*(o-a),t._m[5]=1-2*(r+i),t._m[6]=2*(l+u),t._m[7]=0,t._m[8]=2*(s+c),t._m[9]=2*(l-u),t._m[10]=1-2*(n+i),t._m[11]=0,t._m[12]=0,t._m[13]=0,t._m[14]=0,t._m[15]=1,t._markAsUpdated()},e._updateFlagSeed=0,e._identityReadOnly=e.Identity(),e}(),d=function(){function e(){}return e.Vector3=o.a.BuildArray(6,c.Zero),e.Matrix=o.a.BuildArray(2,h.Identity),e.Quaternion=o.a.BuildArray(3,u.Zero),e}(),f=function(){function e(){}return e.Vector2=o.a.BuildArray(3,s.Zero),e.Vector3=o.a.BuildArray(13,c.Zero),e.Vector4=o.a.BuildArray(3,l.Zero),e.Quaternion=o.a.BuildArray(2,u.Zero),e.Matrix=o.a.BuildArray(8,h.Identity),e}();a.a.RegisteredTypes["BABYLON.Vector2"]=s,a.a.RegisteredTypes["BABYLON.Vector3"]=c,a.a.RegisteredTypes["BABYLON.Vector4"]=l,a.a.RegisteredTypes["BABYLON.Matrix"]=h},function(e,t,i){"use strict";i.d(t,"d",function(){return r}),i.d(t,"a",function(){return o}),i.d(t,"c",function(){return a}),i.d(t,"b",function(){return s}),i.d(t,"e",function(){return c});
/*! *****************************************************************************
Copyright (c) Microsoft Corporation. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the
License at http://www.apache.org/licenses/LICENSE-2.0

THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
MERCHANTABLITY OR NON-INFRINGEMENT.

See the Apache Version 2.0 License for specific language governing permissions
and limitations under the License.
***************************************************************************** */
var n=function(e,t){return(n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var i in t)t.hasOwnProperty(i)&&(e[i]=t[i])})(e,t)};function r(e,t){function i(){this.constructor=e}n(e,t),e.prototype=null===t?Object.create(t):(i.prototype=t.prototype,new i)}var o=function(){return(o=Object.assign||function(e){for(var t,i=1,n=arguments.length;i<n;i++)for(var r in t=arguments[i])Object.prototype.hasOwnProperty.call(t,r)&&(e[r]=t[r]);return e}).apply(this,arguments)};function a(e,t,i,n){var r,o=arguments.length,a=o<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,i):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)a=Reflect.decorate(e,t,i,n);else for(var s=e.length-1;s>=0;s--)(r=e[s])&&(a=(o<3?r(a):o>3?r(t,i,a):r(t,i))||a);return o>3&&a&&Object.defineProperty(t,i,a),a}function s(e,t,i,n){return new(i||(i=Promise))(function(r,o){function a(e){try{c(n.next(e))}catch(e){o(e)}}function s(e){try{c(n.throw(e))}catch(e){o(e)}}function c(e){e.done?r(e.value):new i(function(t){t(e.value)}).then(a,s)}c((n=n.apply(e,t||[])).next())})}function c(e,t){var i,n,r,o,a={label:0,sent:function(){if(1&r[0])throw r[1];return r[1]},trys:[],ops:[]};return o={next:s(0),throw:s(1),return:s(2)},"function"==typeof Symbol&&(o[Symbol.iterator]=function(){return this}),o;function s(o){return function(s){return function(o){if(i)throw new TypeError("Generator is already executing.");for(;a;)try{if(i=1,n&&(r=2&o[0]?n.return:o[0]?n.throw||((r=n.return)&&r.call(n),0):n.next)&&!(r=r.call(n,o[1])).done)return r;switch(n=0,r&&(o=[2&o[0],r.value]),o[0]){case 0:case 1:r=o;break;case 4:return a.label++,{value:o[1],done:!1};case 5:a.label++,n=o[1],o=[0];continue;case 7:o=a.ops.pop(),a.trys.pop();continue;default:if(!(r=(r=a.trys).length>0&&r[r.length-1])&&(6===o[0]||2===o[0])){a=0;continue}if(3===o[0]&&(!r||o[1]>r[0]&&o[1]<r[3])){a.label=o[1];break}if(6===o[0]&&a.label<r[1]){a.label=r[1],r=o;break}if(r&&a.label<r[2]){a.label=r[2],a.ops.push(o);break}r[2]&&a.ops.pop(),a.trys.pop();continue}o=t.call(e,a)}catch(e){o=[6,e],n=0}finally{i=r=0}if(5&o[0])throw o[1];return{value:o[0]?o[1]:void 0,done:!0}}([o,s])}}}},function(e,t,i){"use strict";i.d(t,"a",function(){return n});var n=function(){function e(){}return e.ALPHA_DISABLE=0,e.ALPHA_ADD=1,e.ALPHA_COMBINE=2,e.ALPHA_SUBTRACT=3,e.ALPHA_MULTIPLY=4,e.ALPHA_MAXIMIZED=5,e.ALPHA_ONEONE=6,e.ALPHA_PREMULTIPLIED=7,e.ALPHA_PREMULTIPLIED_PORTERDUFF=8,e.ALPHA_INTERPOLATE=9,e.ALPHA_SCREENMODE=10,e.ALPHA_ONEONE_ONEONE=11,e.ALPHA_ALPHATOCOLOR=12,e.ALPHA_REVERSEONEMINUS=13,e.ALPHA_SRC_DSTONEMINUSSRCALPHA=14,e.ALPHA_ONEONE_ONEZERO=15,e.ALPHA_EXCLUSION=16,e.ALPHA_EQUATION_ADD=0,e.ALPHA_EQUATION_SUBSTRACT=1,e.ALPHA_EQUATION_REVERSE_SUBTRACT=2,e.ALPHA_EQUATION_MAX=3,e.ALPHA_EQUATION_MIN=4,e.ALPHA_EQUATION_DARKEN=5,e.DELAYLOADSTATE_NONE=0,e.DELAYLOADSTATE_LOADED=1,e.DELAYLOADSTATE_LOADING=2,e.DELAYLOADSTATE_NOTLOADED=4,e.NEVER=512,e.ALWAYS=519,e.LESS=513,e.EQUAL=514,e.LEQUAL=515,e.GREATER=516,e.GEQUAL=518,e.NOTEQUAL=517,e.KEEP=7680,e.REPLACE=7681,e.INCR=7682,e.DECR=7683,e.INVERT=5386,e.INCR_WRAP=34055,e.DECR_WRAP=34056,e.TEXTURE_CLAMP_ADDRESSMODE=0,e.TEXTURE_WRAP_ADDRESSMODE=1,e.TEXTURE_MIRROR_ADDRESSMODE=2,e.TEXTUREFORMAT_ALPHA=0,e.TEXTUREFORMAT_LUMINANCE=1,e.TEXTUREFORMAT_LUMINANCE_ALPHA=2,e.TEXTUREFORMAT_RGB=4,e.TEXTUREFORMAT_RGBA=5,e.TEXTUREFORMAT_RED=6,e.TEXTUREFORMAT_R=6,e.TEXTUREFORMAT_RG=7,e.TEXTUREFORMAT_RED_INTEGER=8,e.TEXTUREFORMAT_R_INTEGER=8,e.TEXTUREFORMAT_RG_INTEGER=9,e.TEXTUREFORMAT_RGB_INTEGER=10,e.TEXTUREFORMAT_RGBA_INTEGER=11,e.TEXTURETYPE_UNSIGNED_BYTE=0,e.TEXTURETYPE_UNSIGNED_INT=0,e.TEXTURETYPE_FLOAT=1,e.TEXTURETYPE_HALF_FLOAT=2,e.TEXTURETYPE_BYTE=3,e.TEXTURETYPE_SHORT=4,e.TEXTURETYPE_UNSIGNED_SHORT=5,e.TEXTURETYPE_INT=6,e.TEXTURETYPE_UNSIGNED_INTEGER=7,e.TEXTURETYPE_UNSIGNED_SHORT_4_4_4_4=8,e.TEXTURETYPE_UNSIGNED_SHORT_5_5_5_1=9,e.TEXTURETYPE_UNSIGNED_SHORT_5_6_5=10,e.TEXTURETYPE_UNSIGNED_INT_2_10_10_10_REV=11,e.TEXTURETYPE_UNSIGNED_INT_24_8=12,e.TEXTURETYPE_UNSIGNED_INT_10F_11F_11F_REV=13,e.TEXTURETYPE_UNSIGNED_INT_5_9_9_9_REV=14,e.TEXTURETYPE_FLOAT_32_UNSIGNED_INT_24_8_REV=15,e.TEXTURE_NEAREST_SAMPLINGMODE=1,e.TEXTURE_NEAREST_NEAREST=1,e.TEXTURE_BILINEAR_SAMPLINGMODE=2,e.TEXTURE_LINEAR_LINEAR=2,e.TEXTURE_TRILINEAR_SAMPLINGMODE=3,e.TEXTURE_LINEAR_LINEAR_MIPLINEAR=3,e.TEXTURE_NEAREST_NEAREST_MIPNEAREST=4,e.TEXTURE_NEAREST_LINEAR_MIPNEAREST=5,e.TEXTURE_NEAREST_LINEAR_MIPLINEAR=6,e.TEXTURE_NEAREST_LINEAR=7,e.TEXTURE_NEAREST_NEAREST_MIPLINEAR=8,e.TEXTURE_LINEAR_NEAREST_MIPNEAREST=9,e.TEXTURE_LINEAR_NEAREST_MIPLINEAR=10,e.TEXTURE_LINEAR_LINEAR_MIPNEAREST=11,e.TEXTURE_LINEAR_NEAREST=12,e.TEXTURE_EXPLICIT_MODE=0,e.TEXTURE_SPHERICAL_MODE=1,e.TEXTURE_PLANAR_MODE=2,e.TEXTURE_CUBIC_MODE=3,e.TEXTURE_PROJECTION_MODE=4,e.TEXTURE_SKYBOX_MODE=5,e.TEXTURE_INVCUBIC_MODE=6,e.TEXTURE_EQUIRECTANGULAR_MODE=7,e.TEXTURE_FIXED_EQUIRECTANGULAR_MODE=8,e.TEXTURE_FIXED_EQUIRECTANGULAR_MIRRORED_MODE=9,e.SCALEMODE_FLOOR=1,e.SCALEMODE_NEAREST=2,e.SCALEMODE_CEILING=3,e.MATERIAL_TextureDirtyFlag=1,e.MATERIAL_LightDirtyFlag=2,e.MATERIAL_FresnelDirtyFlag=4,e.MATERIAL_AttributesDirtyFlag=8,e.MATERIAL_MiscDirtyFlag=16,e.MATERIAL_AllDirtyFlag=31,e.MATERIAL_TriangleFillMode=0,e.MATERIAL_WireFrameFillMode=1,e.MATERIAL_PointFillMode=2,e.MATERIAL_PointListDrawMode=3,e.MATERIAL_LineListDrawMode=4,e.MATERIAL_LineLoopDrawMode=5,e.MATERIAL_LineStripDrawMode=6,e.MATERIAL_TriangleStripDrawMode=7,e.MATERIAL_TriangleFanDrawMode=8,e.MATERIAL_ClockWiseSideOrientation=0,e.MATERIAL_CounterClockWiseSideOrientation=1,e.ACTION_NothingTrigger=0,e.ACTION_OnPickTrigger=1,e.ACTION_OnLeftPickTrigger=2,e.ACTION_OnRightPickTrigger=3,e.ACTION_OnCenterPickTrigger=4,e.ACTION_OnPickDownTrigger=5,e.ACTION_OnDoublePickTrigger=6,e.ACTION_OnPickUpTrigger=7,e.ACTION_OnPickOutTrigger=16,e.ACTION_OnLongPressTrigger=8,e.ACTION_OnPointerOverTrigger=9,e.ACTION_OnPointerOutTrigger=10,e.ACTION_OnEveryFrameTrigger=11,e.ACTION_OnIntersectionEnterTrigger=12,e.ACTION_OnIntersectionExitTrigger=13,e.ACTION_OnKeyDownTrigger=14,e.ACTION_OnKeyUpTrigger=15,e.PARTICLES_BILLBOARDMODE_Y=2,e.PARTICLES_BILLBOARDMODE_ALL=7,e.PARTICLES_BILLBOARDMODE_STRETCHED=8,e.MESHES_CULLINGSTRATEGY_STANDARD=0,e.MESHES_CULLINGSTRATEGY_BOUNDINGSPHERE_ONLY=1,e.MESHES_CULLINGSTRATEGY_OPTIMISTIC_INCLUSION=2,e.MESHES_CULLINGSTRATEGY_OPTIMISTIC_INCLUSION_THEN_BSPHERE_ONLY=3,e.SCENELOADER_NO_LOGGING=0,e.SCENELOADER_MINIMAL_LOGGING=1,e.SCENELOADER_SUMMARY_LOGGING=2,e.SCENELOADER_DETAILED_LOGGING=3,e}()},function(e,t,i){"use strict";i.d(t,"b",function(){return d}),i.d(t,"c",function(){return f}),i.d(t,"m",function(){return p}),i.d(t,"e",function(){return _}),i.d(t,"h",function(){return m}),i.d(t,"n",function(){return g}),i.d(t,"o",function(){return v}),i.d(t,"k",function(){return y}),i.d(t,"g",function(){return b}),i.d(t,"f",function(){return T}),i.d(t,"i",function(){return E}),i.d(t,"l",function(){return x}),i.d(t,"j",function(){return P}),i.d(t,"d",function(){return A}),i.d(t,"a",function(){return S});var n=i(35),r=i(0),o=i(19),a=i(10),s={},c={},l=function(e,t,i){var r=e();n.a&&n.a.AddTagsTo(r,t.tags);var o=u(r);for(var a in o){var s=o[a],c=t[a],l=s.type;if(null!=c&&"uniqueId"!==a)switch(l){case 0:case 6:case 11:r[a]=c;break;case 1:r[a]=i||c.isRenderTarget?c:c.clone();break;case 2:case 3:case 4:case 5:case 7:case 10:case 12:r[a]=i?c:c.clone()}}return r};function u(e){var t=e.getClassName();if(c[t])return c[t];c[t]={};for(var i=c[t],n=e,r=t;r;){var o=s[r];for(var a in o)i[a]=o[a];var l=void 0,u=!1;do{if(!(l=Object.getPrototypeOf(n)).getClassName){u=!0;break}if(l.getClassName()!==r)break;n=l}while(l);if(u)break;r=l.getClassName(),n=l}return i}function h(e,t){return function(i,n){var r=function(e){var t=e.getClassName();return s[t]||(s[t]={}),s[t]}(i);r[n]||(r[n]={type:e,sourceName:t})}}function d(e,t){return void 0===t&&(t=null),function(e,t){return void 0===t&&(t=null),function(i,n){var r=t||"_"+n;Object.defineProperty(i,n,{get:function(){return this[r]},set:function(t){this[r]!==t&&(this[r]=t,i[e].apply(this))},enumerable:!0,configurable:!0})}}(e,t)}function f(e){return h(0,e)}function p(e){return h(1,e)}function _(e){return h(2,e)}function m(e){return h(3,e)}function g(e){return h(4,e)}function v(e){return h(5,e)}function y(e){return h(6,e)}function b(e){return h(7,e)}function T(e){return h(8,e)}function E(e){return h(9,e)}function x(e){return h(10,e)}function P(e){return h(12,e)}function A(e){return h(11,e)}var S=function(){function e(){}return e.AppendSerializedAnimations=function(e,t){if(e.animations){t.animations=[];for(var i=0;i<e.animations.length;i++){var n=e.animations[i];t.animations.push(n.serialize())}}},e.Serialize=function(e,t){t||(t={}),n.a&&(t.tags=n.a.GetTags(e));var i=u(e);for(var r in i){var o=i[r],a=o.sourceName||r,s=o.type,c=e[r];if(null!=c)switch(s){case 0:t[a]=c;break;case 1:t[a]=c.serialize();break;case 2:t[a]=c.asArray();break;case 3:t[a]=c.serialize();break;case 4:case 5:t[a]=c.asArray();break;case 6:t[a]=c.id;break;case 7:t[a]=c.serialize();break;case 8:t[a]=c.asArray();break;case 9:t[a]=c.serialize();break;case 10:t[a]=c.asArray();break;case 11:t[a]=c.id;case 12:t[a]=c.asArray()}}return t},e.Parse=function(t,i,o,s){void 0===s&&(s=null);var c=t();s||(s=""),n.a&&n.a.AddTagsTo(c,i.tags);var l=u(c);for(var h in l){var d=l[h],f=i[d.sourceName||h],p=d.type;if(null!=f){var _=c;switch(p){case 0:_[h]=f;break;case 1:o&&(_[h]=e._TextureParser(f,o,s));break;case 2:_[h]=a.a.FromArray(f);break;case 3:_[h]=e._FresnelParametersParser(f);break;case 4:_[h]=r.d.FromArray(f);break;case 5:_[h]=r.e.FromArray(f);break;case 6:o&&(_[h]=o.getLastMeshByID(f));break;case 7:_[h]=e._ColorCurvesParser(f);break;case 8:_[h]=a.b.FromArray(f);break;case 9:_[h]=e._ImageProcessingConfigurationParser(f);break;case 10:_[h]=r.b.FromArray(f);break;case 11:o&&(_[h]=o.getCameraByID(f));case 12:_[h]=r.a.FromArray(f)}}}return c},e.Clone=function(e,t){return l(e,t,!1)},e.Instanciate=function(e,t){return l(e,t,!0)},e._ImageProcessingConfigurationParser=function(e){throw o.a.WarnImport("ImageProcessingConfiguration")},e._FresnelParametersParser=function(e){throw o.a.WarnImport("FresnelParameters")},e._ColorCurvesParser=function(e){throw o.a.WarnImport("ColorCurves")},e._TextureParser=function(e,t,i){throw o.a.WarnImport("Texture")},e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return n}),i.d(t,"b",function(){return r});var n=function(){function e(e,t,i,n,r,o,a,s){void 0===n&&(n=0),void 0===r&&(r=!1),void 0===o&&(o=!1),void 0===a&&(a=!1),e.getScene?this._engine=e.getScene().getEngine():this._engine=e,this._updatable=i,this._instanced=o,this._divisor=s||1,this._data=t,this.byteStride=a?n:n*Float32Array.BYTES_PER_ELEMENT,r||this.create()}return e.prototype.createVertexBuffer=function(e,t,i,n,o,a,s){void 0===a&&(a=!1);var c=a?t:t*Float32Array.BYTES_PER_ELEMENT,l=n?a?n:n*Float32Array.BYTES_PER_ELEMENT:this.byteStride;return new r(this._engine,this,e,this._updatable,!0,l,void 0===o?this._instanced:o,c,i,void 0,void 0,!0,this._divisor||s)},e.prototype.isUpdatable=function(){return this._updatable},e.prototype.getData=function(){return this._data},e.prototype.getBuffer=function(){return this._buffer},e.prototype.getStrideSize=function(){return this.byteStride/Float32Array.BYTES_PER_ELEMENT},e.prototype.create=function(e){void 0===e&&(e=null),!e&&this._buffer||(e=e||this._data)&&(this._buffer?this._updatable&&(this._engine.updateDynamicVertexBuffer(this._buffer,e),this._data=e):this._updatable?(this._buffer=this._engine.createDynamicVertexBuffer(e),this._data=e):this._buffer=this._engine.createVertexBuffer(e))},e.prototype._rebuild=function(){this._buffer=null,this.create(this._data)},e.prototype.update=function(e){this.create(e)},e.prototype.updateDirectly=function(e,t,i,n){void 0===n&&(n=!1),this._buffer&&this._updatable&&(this._engine.updateDynamicVertexBuffer(this._buffer,e,n?t:t*Float32Array.BYTES_PER_ELEMENT,i?i*this.byteStride:void 0),this._data=null)},e.prototype.dispose=function(){this._buffer&&this._engine._releaseBuffer(this._buffer)&&(this._buffer=null)},e}(),r=function(){function e(t,i,r,o,a,s,c,l,u,h,d,f,p){if(void 0===d&&(d=!1),void 0===f&&(f=!1),void 0===p&&(p=1),i instanceof n?(this._buffer=i,this._ownsBuffer=!1):(this._buffer=new n(t,i,o,s,a,c,f),this._ownsBuffer=!0),this._kind=r,null==h){var _=this.getData();this.type=e.FLOAT,_ instanceof Int8Array?this.type=e.BYTE:_ instanceof Uint8Array?this.type=e.UNSIGNED_BYTE:_ instanceof Int16Array?this.type=e.SHORT:_ instanceof Uint16Array?this.type=e.UNSIGNED_SHORT:_ instanceof Int32Array?this.type=e.INT:_ instanceof Uint32Array&&(this.type=e.UNSIGNED_INT)}else this.type=h;var m=e.GetTypeByteLength(this.type);f?(this._size=u||(s?s/m:e.DeduceStride(r)),this.byteStride=s||this._buffer.byteStride||this._size*m,this.byteOffset=l||0):(this._size=u||s||e.DeduceStride(r),this.byteStride=s?s*m:this._buffer.byteStride||this._size*m,this.byteOffset=(l||0)*m),this.normalized=d,this._instanced=void 0!==c&&c,this._instanceDivisor=c?p:0}return Object.defineProperty(e.prototype,"instanceDivisor",{get:function(){return this._instanceDivisor},set:function(e){this._instanceDivisor=e,this._instanced=0!=e},enumerable:!0,configurable:!0}),e.prototype._rebuild=function(){this._buffer&&this._buffer._rebuild()},e.prototype.getKind=function(){return this._kind},e.prototype.isUpdatable=function(){return this._buffer.isUpdatable()},e.prototype.getData=function(){return this._buffer.getData()},e.prototype.getBuffer=function(){return this._buffer.getBuffer()},e.prototype.getStrideSize=function(){return this.byteStride/e.GetTypeByteLength(this.type)},e.prototype.getOffset=function(){return this.byteOffset/e.GetTypeByteLength(this.type)},e.prototype.getSize=function(){return this._size},e.prototype.getIsInstanced=function(){return this._instanced},e.prototype.getInstanceDivisor=function(){return this._instanceDivisor},e.prototype.create=function(e){this._buffer.create(e)},e.prototype.update=function(e){this._buffer.update(e)},e.prototype.updateDirectly=function(e,t,i){void 0===i&&(i=!1),this._buffer.updateDirectly(e,t,void 0,i)},e.prototype.dispose=function(){this._ownsBuffer&&this._buffer.dispose()},e.prototype.forEach=function(t,i){e.ForEach(this._buffer.getData(),this.byteOffset,this.byteStride,this._size,this.type,t,this.normalized,i)},e.DeduceStride=function(t){switch(t){case e.UVKind:case e.UV2Kind:case e.UV3Kind:case e.UV4Kind:case e.UV5Kind:case e.UV6Kind:return 2;case e.NormalKind:case e.PositionKind:return 3;case e.ColorKind:case e.MatricesIndicesKind:case e.MatricesIndicesExtraKind:case e.MatricesWeightsKind:case e.MatricesWeightsExtraKind:case e.TangentKind:return 4;default:throw new Error("Invalid kind '"+t+"'")}},e.GetTypeByteLength=function(t){switch(t){case e.BYTE:case e.UNSIGNED_BYTE:return 1;case e.SHORT:case e.UNSIGNED_SHORT:return 2;case e.INT:case e.UNSIGNED_INT:case e.FLOAT:return 4;default:throw new Error("Invalid type '"+t+"'")}},e.ForEach=function(t,i,n,r,o,a,s,c){if(t instanceof Array)for(var l=i/4,u=n/4,h=0;h<a;h+=r){for(var d=0;d<r;d++)c(t[l+d],h+d);l+=u}else{var f=t instanceof ArrayBuffer?new DataView(t):new DataView(t.buffer,t.byteOffset,t.byteLength),p=e.GetTypeByteLength(o);for(h=0;h<a;h+=r){var _=i;for(d=0;d<r;d++){c(e._GetFloatValue(f,o,_,s),h+d),_+=p}i+=n}}},e._GetFloatValue=function(t,i,n,r){switch(i){case e.BYTE:var o=t.getInt8(n);return r&&(o=Math.max(o/127,-1)),o;case e.UNSIGNED_BYTE:o=t.getUint8(n);return r&&(o/=255),o;case e.SHORT:o=t.getInt16(n,!0);return r&&(o=Math.max(o/32767,-1)),o;case e.UNSIGNED_SHORT:o=t.getUint16(n,!0);return r&&(o/=65535),o;case e.INT:return t.getInt32(n,!0);case e.UNSIGNED_INT:return t.getUint32(n,!0);case e.FLOAT:return t.getFloat32(n,!0);default:throw new Error("Invalid component type "+i)}},e.BYTE=5120,e.UNSIGNED_BYTE=5121,e.SHORT=5122,e.UNSIGNED_SHORT=5123,e.INT=5124,e.UNSIGNED_INT=5125,e.FLOAT=5126,e.PositionKind="position",e.NormalKind="normal",e.TangentKind="tangent",e.UVKind="uv",e.UV2Kind="uv2",e.UV3Kind="uv3",e.UV4Kind="uv4",e.UV5Kind="uv5",e.UV6Kind="uv6",e.ColorKind="color",e.MatricesIndicesKind="matricesIndices",e.MatricesWeightsKind="matricesWeights",e.MatricesIndicesExtraKind="matricesIndicesExtra",e.MatricesWeightsExtraKind="matricesWeightsExtra",e}()},function(e,t,i){"use strict";i.d(t,"b",function(){return R}),i.d(t,"c",function(){return M}),i.d(t,"a",function(){return D});var n=i(1),r=i(6),o=i(13),a=i(33),s=i(35),c=i(0),l=i(10),u=i(26),h=i(4),d=i(15),f=i(69),p=i(27),_=i(57),m=i(44),g=i(29),v=i(71),y=i(67),b=i(2),T=i(3),E=i(7),x=i(12),P=i(19),A=i(17),S=i(135),C=i(70),R=function(){},O=function(){this.visibleInstances={},this.batchCache=new M,this.instancesBufferSize=2048},M=function(){this.mustReturn=!1,this.visibleInstances=new Array,this.renderSelf=new Array,this.hardwareInstancedRendering=new Array},I=function(){this._areNormalsFrozen=!1,this._source=null,this.meshMap=null,this._preActivateId=-1,this._LODLevels=new Array,this._morphTargetManager=null},D=function(e){function t(i,n,r,o,c,l){void 0===n&&(n=null),void 0===r&&(r=null),void 0===o&&(o=null),void 0===l&&(l=!0);var u=e.call(this,i,n)||this;if(u._internalMeshDataInfo=new I,u.delayLoadState=b.a.DELAYLOADSTATE_NONE,u.instances=new Array,u._creationDataStorage=null,u._geometry=null,u._instanceDataStorage=new O,u._effectiveMaterial=null,u._shouldGenerateFlatShading=!1,u._originalBuilderSideOrientation=t.DEFAULTSIDE,u.overrideMaterialSideOrientation=null,n=u.getScene(),o){if(o._geometry&&o._geometry.applyToMesh(u),a.a.DeepCopy(o,u,["name","material","skeleton","instances","parent","uniqueId","source","metadata","hasLODLevels","geometry","isBlocked","areNormalsFrozen","onBeforeDrawObservable","onBeforeRenderObservable","onAfterRenderObservable","onBeforeDraw","onAfterWorldMatrixUpdateObservable","onCollideObservable","onCollisionPositionChangeObservable","onRebuildObservable","onDisposeObservable","lightSources","morphTargetManager"],["_poseMatrix"]),u._internalMeshDataInfo._source=o,n.useClonedMeshMap&&(o._internalMeshDataInfo.meshMap||(o._internalMeshDataInfo.meshMap={}),o._internalMeshDataInfo.meshMap[u.uniqueId]=u),u._originalBuilderSideOrientation=o._originalBuilderSideOrientation,u._creationDataStorage=o._creationDataStorage,o._ranges){var h=o._ranges;for(var i in h)h.hasOwnProperty(i)&&h[i]&&u.createAnimationRange(i,h[i].from,h[i].to)}var d;if(o.metadata&&o.metadata.clone?u.metadata=o.metadata.clone():u.metadata=o.metadata,s.a&&s.a.HasTags(o)&&s.a.AddTagsTo(u,s.a.GetTags(o,!0)),u.parent=o.parent,u.setPivotMatrix(o.getPivotMatrix()),u.id=i+"."+o.id,u.material=o.material,!c)for(var f=o.getDescendants(!0),p=0;p<f.length;p++){var _=f[p];_.clone&&_.clone(i+"."+_.name,u)}if(o.morphTargetManager&&(u.morphTargetManager=o.morphTargetManager),n.getPhysicsEngine){var m=n.getPhysicsEngine();if(l&&m){var g=m.getImpostorForPhysicsObject(o);g&&(u.physicsImpostor=g.clone(u))}}for(d=0;d<n.particleSystems.length;d++){var v=n.particleSystems[d];v.emitter===o&&v.clone(v.name,u)}u.refreshBoundingInfo(),u.computeWorldMatrix(!0)}return null!==r&&(u.parent=r),u._instanceDataStorage.hardwareInstancedRendering=u.getEngine().getCaps().instancedArrays,u}return Object(n.d)(t,e),t._GetDefaultSideOrientation=function(e){return e||t.FRONTSIDE},Object.defineProperty(t.prototype,"onBeforeRenderObservable",{get:function(){return this._internalMeshDataInfo._onBeforeRenderObservable||(this._internalMeshDataInfo._onBeforeRenderObservable=new r.c),this._internalMeshDataInfo._onBeforeRenderObservable},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"onBeforeBindObservable",{get:function(){return this._internalMeshDataInfo._onBeforeBindObservable||(this._internalMeshDataInfo._onBeforeBindObservable=new r.c),this._internalMeshDataInfo._onBeforeBindObservable},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"onAfterRenderObservable",{get:function(){return this._internalMeshDataInfo._onAfterRenderObservable||(this._internalMeshDataInfo._onAfterRenderObservable=new r.c),this._internalMeshDataInfo._onAfterRenderObservable},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"onBeforeDrawObservable",{get:function(){return this._internalMeshDataInfo._onBeforeDrawObservable||(this._internalMeshDataInfo._onBeforeDrawObservable=new r.c),this._internalMeshDataInfo._onBeforeDrawObservable},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"onBeforeDraw",{set:function(e){this._onBeforeDrawObserver&&this.onBeforeDrawObservable.remove(this._onBeforeDrawObserver),this._onBeforeDrawObserver=this.onBeforeDrawObservable.add(e)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"hasInstances",{get:function(){return this.instances.length>0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"morphTargetManager",{get:function(){return this._internalMeshDataInfo._morphTargetManager},set:function(e){this._internalMeshDataInfo._morphTargetManager!==e&&(this._internalMeshDataInfo._morphTargetManager=e,this._syncGeometryWithMorphTargetManager())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"source",{get:function(){return this._internalMeshDataInfo._source},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isUnIndexed",{get:function(){return this._unIndexed},set:function(e){this._unIndexed!==e&&(this._unIndexed=e,this._markSubMeshesAsAttributesDirty())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"worldMatrixInstancedBuffer",{get:function(){return this._instanceDataStorage.instancesData},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"manualUpdateOfWorldMatrixInstancedBuffer",{get:function(){return this._instanceDataStorage.manualUpdate},set:function(e){this._instanceDataStorage.manualUpdate=e},enumerable:!0,configurable:!0}),t.prototype.instantiateHierarchy=function(e,t,i){void 0===e&&(e=null);var n=!(this.getTotalVertices()>0)||t&&t.doNotInstantiate?this.clone("Clone of "+(this.name||this.id),e||this.parent,!0):this.createInstance("instance of "+(this.name||this.id));n&&(n.parent=e||this.parent,n.position=this.position.clone(),n.scaling=this.scaling.clone(),this.rotationQuaternion?n.rotationQuaternion=this.rotationQuaternion.clone():n.rotation=this.rotation.clone(),i&&i(this,n));for(var r=0,o=this.getChildTransformNodes(!0);r<o.length;r++){o[r].instantiateHierarchy(n,t,i)}return n},t.prototype.getClassName=function(){return"Mesh"},Object.defineProperty(t.prototype,"_isMesh",{get:function(){return!0},enumerable:!0,configurable:!0}),t.prototype.toString=function(t){var i=e.prototype.toString.call(this,t);if(i+=", n vertices: "+this.getTotalVertices(),i+=", parent: "+(this._waitingParentId?this._waitingParentId:this.parent?this.parent.name:"NONE"),this.animations)for(var n=0;n<this.animations.length;n++)i+=", animation[0]: "+this.animations[n].toString(t);if(t)if(this._geometry){var r=this.getIndices(),o=this.getVerticesData(h.b.PositionKind);o&&r&&(i+=", flat shading: "+(o.length/3===r.length?"YES":"NO"))}else i+=", flat shading: UNKNOWN";return i},t.prototype._unBindEffect=function(){e.prototype._unBindEffect.call(this);for(var t=0,i=this.instances;t<i.length;t++){i[t]._unBindEffect()}},Object.defineProperty(t.prototype,"hasLODLevels",{get:function(){return this._internalMeshDataInfo._LODLevels.length>0},enumerable:!0,configurable:!0}),t.prototype.getLODLevels=function(){return this._internalMeshDataInfo._LODLevels},t.prototype._sortLODLevels=function(){this._internalMeshDataInfo._LODLevels.sort(function(e,t){return e.distance<t.distance?1:e.distance>t.distance?-1:0})},t.prototype.addLODLevel=function(e,t){if(t&&t._masterMesh)return E.a.Warn("You cannot use a mesh as LOD level twice"),this;var i=new S.a(e,t);return this._internalMeshDataInfo._LODLevels.push(i),t&&(t._masterMesh=this),this._sortLODLevels(),this},t.prototype.getLODLevelAtDistance=function(e){for(var t=this._internalMeshDataInfo,i=0;i<t._LODLevels.length;i++){var n=t._LODLevels[i];if(n.distance===e)return n.mesh}return null},t.prototype.removeLODLevel=function(e){for(var t=this._internalMeshDataInfo,i=0;i<t._LODLevels.length;i++)t._LODLevels[i].mesh===e&&(t._LODLevels.splice(i,1),e&&(e._masterMesh=null));return this._sortLODLevels(),this},t.prototype.getLOD=function(e,t){var i,n=this._internalMeshDataInfo;if(!n._LODLevels||0===n._LODLevels.length)return this;t?i=t:i=this.getBoundingInfo().boundingSphere;var r=i.centerWorld.subtract(e.globalPosition).length();if(n._LODLevels[n._LODLevels.length-1].distance>r)return this.onLODLevelSelection&&this.onLODLevelSelection(r,this,this),this;for(var o=0;o<n._LODLevels.length;o++){var a=n._LODLevels[o];if(a.distance<r)return a.mesh&&(a.mesh._preActivate(),a.mesh._updateSubMeshesBoundingInfo(this.worldMatrixFromCache)),this.onLODLevelSelection&&this.onLODLevelSelection(r,this,a.mesh),a.mesh}return this.onLODLevelSelection&&this.onLODLevelSelection(r,this,this),this},Object.defineProperty(t.prototype,"geometry",{get:function(){return this._geometry},enumerable:!0,configurable:!0}),t.prototype.getTotalVertices=function(){return null===this._geometry||void 0===this._geometry?0:this._geometry.getTotalVertices()},t.prototype.getVerticesData=function(e,t,i){return this._geometry?this._geometry.getVerticesData(e,t,i):null},t.prototype.getVertexBuffer=function(e){return this._geometry?this._geometry.getVertexBuffer(e):null},t.prototype.isVerticesDataPresent=function(e){return this._geometry?this._geometry.isVerticesDataPresent(e):!!this._delayInfo&&-1!==this._delayInfo.indexOf(e)},t.prototype.isVertexBufferUpdatable=function(e){return this._geometry?this._geometry.isVertexBufferUpdatable(e):!!this._delayInfo&&-1!==this._delayInfo.indexOf(e)},t.prototype.getVerticesDataKinds=function(){if(!this._geometry){var e=new Array;return this._delayInfo&&this._delayInfo.forEach(function(t){e.push(t)}),e}return this._geometry.getVerticesDataKinds()},t.prototype.getTotalIndices=function(){return this._geometry?this._geometry.getTotalIndices():0},t.prototype.getIndices=function(e,t){return this._geometry?this._geometry.getIndices(e,t):[]},Object.defineProperty(t.prototype,"isBlocked",{get:function(){return null!==this._masterMesh&&void 0!==this._masterMesh},enumerable:!0,configurable:!0}),t.prototype.isReady=function(t,i){if(void 0===t&&(t=!1),void 0===i&&(i=!1),this.delayLoadState===b.a.DELAYLOADSTATE_LOADING)return!1;if(!e.prototype.isReady.call(this,t))return!1;if(!this.subMeshes||0===this.subMeshes.length)return!0;if(!t)return!0;var n=this.getEngine(),r=this.getScene(),o=i||n.getCaps().instancedArrays&&this.instances.length>0;this.computeWorldMatrix();var a=this.material||r.defaultMaterial;if(a)if(a._storeEffectOnSubMeshes)for(var s=0,c=this.subMeshes;s<c.length;s++){var l=(_=c[s]).getMaterial();if(l)if(l._storeEffectOnSubMeshes){if(!l.isReadyForSubMesh(this,_,o))return!1}else if(!l.isReady(this,o))return!1}else if(!a.isReady(this,o))return!1;for(var u=0,h=this.lightSources;u<h.length;u++){var d=h[u].getShadowGenerator();if(d)for(var f=0,p=this.subMeshes;f<p.length;f++){var _=p[f];if(!d.isReady(_,o))return!1}}for(var m=0,g=this._internalMeshDataInfo._LODLevels;m<g.length;m++){var v=g[m];if(v.mesh&&!v.mesh.isReady(o))return!1}return!0},Object.defineProperty(t.prototype,"areNormalsFrozen",{get:function(){return this._internalMeshDataInfo._areNormalsFrozen},enumerable:!0,configurable:!0}),t.prototype.freezeNormals=function(){return this._internalMeshDataInfo._areNormalsFrozen=!0,this},t.prototype.unfreezeNormals=function(){return this._internalMeshDataInfo._areNormalsFrozen=!1,this},Object.defineProperty(t.prototype,"overridenInstanceCount",{set:function(e){this._instanceDataStorage.overridenInstanceCount=e},enumerable:!0,configurable:!0}),t.prototype._preActivate=function(){var e=this._internalMeshDataInfo,t=this.getScene().getRenderId();return e._preActivateId===t?this:(e._preActivateId=t,this._instanceDataStorage.visibleInstances=null,this)},t.prototype._preActivateForIntermediateRendering=function(e){return this._instanceDataStorage.visibleInstances&&(this._instanceDataStorage.visibleInstances.intermediateDefaultRenderId=e),this},t.prototype._registerInstanceForRenderId=function(e,t){return this._instanceDataStorage.visibleInstances||(this._instanceDataStorage.visibleInstances={defaultRenderId:t,selfDefaultRenderId:this._renderId}),this._instanceDataStorage.visibleInstances[t]||(this._instanceDataStorage.visibleInstances[t]=new Array),this._instanceDataStorage.visibleInstances[t].push(e),this},t.prototype.refreshBoundingInfo=function(e){if(void 0===e&&(e=!1),this._boundingInfo&&this._boundingInfo.isLocked)return this;var t=this.geometry?this.geometry.boundingBias:null;return this._refreshBoundingInfo(this._getPositionData(e),t),this},t.prototype._createGlobalSubMesh=function(e){var t=this.getTotalVertices();if(!t||!this.getIndices())return null;if(this.subMeshes&&this.subMeshes.length>0){var i=this.getIndices();if(!i)return null;var n=i.length,r=!1;if(e)r=!0;else for(var o=0,a=this.subMeshes;o<a.length;o++){var s=a[o];if(s.indexStart+s.indexCount>=n){r=!0;break}if(s.verticesStart+s.verticesCount>=t){r=!0;break}}if(!r)return this.subMeshes[0]}return this.releaseSubMeshes(),new _.b(0,0,t,0,this.getTotalIndices(),this)},t.prototype.subdivide=function(e){if(!(e<1)){for(var t=this.getTotalIndices(),i=t/e|0,n=0;i%3!=0;)i++;this.releaseSubMeshes();for(var r=0;r<e&&!(n>=t);r++)_.b.CreateFromIndices(0,n,Math.min(i,t-n),this),n+=i;this.synchronizeInstances()}},t.prototype.setVerticesData=function(e,t,i,n){if(void 0===i&&(i=!1),this._geometry)this._geometry.setVerticesData(e,t,i,n);else{var r=new d.a;r.set(t,e);var o=this.getScene();new f.a(f.a.RandomId(),o,r,i,this)}return this},t.prototype.removeVerticesData=function(e){this._geometry&&this._geometry.removeVerticesData(e)},t.prototype.markVerticesDataAsUpdatable=function(e,t){void 0===t&&(t=!0);var i=this.getVertexBuffer(e);i&&i.isUpdatable()!==t&&this.setVerticesData(e,this.getVerticesData(e),t)},t.prototype.setVerticesBuffer=function(e){return this._geometry||(this._geometry=f.a.CreateGeometryForMesh(this)),this._geometry.setVerticesBuffer(e),this},t.prototype.updateVerticesData=function(e,t,i,n){return this._geometry?(n?(this.makeGeometryUnique(),this.updateVerticesData(e,t,i,!1)):this._geometry.updateVerticesData(e,t,i),this):this},t.prototype.updateMeshPositions=function(e,t){void 0===t&&(t=!0);var i=this.getVerticesData(h.b.PositionKind);if(!i)return this;if(e(i),this.updateVerticesData(h.b.PositionKind,i,!1,!1),t){var n=this.getIndices(),r=this.getVerticesData(h.b.NormalKind);if(!r)return this;d.a.ComputeNormals(i,n,r),this.updateVerticesData(h.b.NormalKind,r,!1,!1)}return this},t.prototype.makeGeometryUnique=function(){if(!this._geometry)return this;var e=this._geometry,t=this._geometry.copy(f.a.RandomId());return e.releaseForMesh(this,!0),t.applyToMesh(this),this},t.prototype.setIndices=function(e,t,i){if(void 0===t&&(t=null),void 0===i&&(i=!1),this._geometry)this._geometry.setIndices(e,t,i);else{var n=new d.a;n.indices=e;var r=this.getScene();new f.a(f.a.RandomId(),r,n,i,this)}return this},t.prototype.updateIndices=function(e,t,i){return void 0===i&&(i=!1),this._geometry?(this._geometry.updateIndices(e,t,i),this):this},t.prototype.toLeftHanded=function(){return this._geometry?(this._geometry.toLeftHanded(),this):this},t.prototype._bind=function(e,t,i){if(!this._geometry)return this;var n,r=this.getScene().getEngine();if(this._unIndexed)n=null;else switch(i){case g.a.PointFillMode:n=null;break;case g.a.WireFrameFillMode:n=e._getLinesIndexBuffer(this.getIndices(),r);break;default:case g.a.TriangleFillMode:n=this._geometry.getIndexBuffer()}return this._geometry._bind(t,n),this},t.prototype._draw=function(e,t,i){if(!this._geometry||!this._geometry.getVertexBuffers()||!this._unIndexed&&!this._geometry.getIndexBuffer())return this;this._internalMeshDataInfo._onBeforeDrawObservable&&this._internalMeshDataInfo._onBeforeDrawObservable.notifyObservers(this);var n=this.getScene().getEngine();return this._unIndexed||t==g.a.PointFillMode?n.drawArraysType(t,e.verticesStart,e.verticesCount,i):t==g.a.WireFrameFillMode?n.drawElementsType(t,0,e._linesIndexCount,i):n.drawElementsType(t,e.indexStart,e.indexCount,i),this},t.prototype.registerBeforeRender=function(e){return this.onBeforeRenderObservable.add(e),this},t.prototype.unregisterBeforeRender=function(e){return this.onBeforeRenderObservable.removeCallback(e),this},t.prototype.registerAfterRender=function(e){return this.onAfterRenderObservable.add(e),this},t.prototype.unregisterAfterRender=function(e){return this.onAfterRenderObservable.removeCallback(e),this},t.prototype._getInstancesRenderList=function(e,t){if(void 0===t&&(t=!1),this._instanceDataStorage.isFrozen&&this._instanceDataStorage.previousBatch)return this._instanceDataStorage.previousBatch;var i=this.getScene(),n=i._isInIntermediateRendering(),r=n?this._internalAbstractMeshDataInfo._onlyForInstancesIntermediate:this._internalAbstractMeshDataInfo._onlyForInstances,o=this._instanceDataStorage.batchCache;if(o.mustReturn=!1,o.renderSelf[e]=t||!r&&this.isEnabled()&&this.isVisible,o.visibleInstances[e]=null,this._instanceDataStorage.visibleInstances&&!t){var a=this._instanceDataStorage.visibleInstances,s=i.getRenderId(),c=n?a.intermediateDefaultRenderId:a.defaultRenderId;o.visibleInstances[e]=a[s],!o.visibleInstances[e]&&c&&(o.visibleInstances[e]=a[c])}return o.hardwareInstancedRendering[e]=!t&&this._instanceDataStorage.hardwareInstancedRendering&&null!==o.visibleInstances[e]&&void 0!==o.visibleInstances[e],this._instanceDataStorage.previousBatch=o,o},t.prototype._renderWithInstances=function(e,t,i,n,r){var o=i.visibleInstances[e._id];if(!o)return this;for(var a=this._instanceDataStorage,s=a.instancesBufferSize,c=a.instancesBuffer,l=16*(o.length+1)*4;a.instancesBufferSize<l;)a.instancesBufferSize*=2;a.instancesData&&s==a.instancesBufferSize||(a.instancesData=new Float32Array(a.instancesBufferSize/4));var u=0,d=0,f=i.renderSelf[e._id];if(this._instanceDataStorage.manualUpdate)d=(f?1:0)+o.length;else{var p=this._effectiveMesh.getWorldMatrix();if(f&&(p.copyToArray(a.instancesData,u),u+=16,d++),o)for(var _=0;_<o.length;_++){o[_].getWorldMatrix().copyToArray(a.instancesData,u),u+=16,d++}}return c&&s==a.instancesBufferSize?c.updateDirectly(a.instancesData,0,d):(c&&c.dispose(),c=new h.a(r,a.instancesData,!0,16,!1,!0),a.instancesBuffer=c,this.setVerticesBuffer(c.createVertexBuffer("world0",0,4)),this.setVerticesBuffer(c.createVertexBuffer("world1",4,4)),this.setVerticesBuffer(c.createVertexBuffer("world2",8,4)),this.setVerticesBuffer(c.createVertexBuffer("world3",12,4))),this._processInstancedBuffers(o,f),this.getScene()._activeIndices.addCount(e.indexCount*d,!1),this._bind(e,n,t),this._draw(e,t,d),r.unbindInstanceAttributes(),this},t.prototype._processInstancedBuffers=function(e,t){},t.prototype._processRendering=function(e,t,i,n,r,o,a){var s=this.getScene(),c=s.getEngine();if(r)this._renderWithInstances(e,i,n,t,c);else{var l=0;n.renderSelf[e._id]&&(o&&o(!1,this._effectiveMesh.getWorldMatrix(),a),l++,this._draw(e,i,this._instanceDataStorage.overridenInstanceCount));var u=n.visibleInstances[e._id];if(u){var h=u.length;l+=h;for(var d=0;d<h;d++){var f=u[d].getWorldMatrix();o&&o(!0,f,a),this._draw(e,i)}}s._activeIndices.addCount(e.indexCount*l,!1)}return this},t.prototype._rebuild=function(){this._instanceDataStorage.instancesBuffer&&(this._instanceDataStorage.instancesBuffer.dispose(),this._instanceDataStorage.instancesBuffer=null),e.prototype._rebuild.call(this)},t.prototype._freeze=function(){if(this.subMeshes){for(var e=0;e<this.subMeshes.length;e++)this._getInstancesRenderList(e);this._effectiveMaterial=null,this._instanceDataStorage.isFrozen=!0}},t.prototype._unFreeze=function(){this._instanceDataStorage.isFrozen=!1,this._instanceDataStorage.previousBatch=null},t.prototype.render=function(e,t,i){var n=this.getScene();if(this._internalAbstractMeshDataInfo._isActiveIntermediate?this._internalAbstractMeshDataInfo._isActiveIntermediate=!1:this._internalAbstractMeshDataInfo._isActive=!1,this._checkOcclusionQuery())return this;var r=this._getInstancesRenderList(e._id,!!i);if(r.mustReturn)return this;if(!this._geometry||!this._geometry.getVertexBuffers()||!this._unIndexed&&!this._geometry.getIndexBuffer())return this;this._internalMeshDataInfo._onBeforeRenderObservable&&this._internalMeshDataInfo._onBeforeRenderObservable.notifyObservers(this);var o,a=n.getEngine(),s=r.hardwareInstancedRendering[e._id],c=this._instanceDataStorage,l=e.getMaterial();if(!l)return this;if(!c.isFrozen||!this._effectiveMaterial||this._effectiveMaterial!==l){if(l._storeEffectOnSubMeshes){if(!l.isReadyForSubMesh(this,e,s))return this}else if(!l.isReady(this,s))return this;this._effectiveMaterial=l}t&&a.setAlphaMode(this._effectiveMaterial.alphaMode);for(var u=0,h=n._beforeRenderingMeshStage;u<h.length;u++){h[u].action(this,e,r)}if(!(o=this._effectiveMaterial._storeEffectOnSubMeshes?e.effect:this._effectiveMaterial.getEffect()))return this;var d,f=i||this._effectiveMesh;if(!c.isFrozen&&this._effectiveMaterial.backFaceCulling){var p=f._getWorldMatrixDeterminant();null==(d=this.overrideMaterialSideOrientation)&&(d=this._effectiveMaterial.sideOrientation),p<0&&(d=d===g.a.ClockWiseSideOrientation?g.a.CounterClockWiseSideOrientation:g.a.ClockWiseSideOrientation),c.sideOrientation=d}else d=c.sideOrientation;var _=this._effectiveMaterial._preBind(o,d);this._effectiveMaterial.forceDepthWrite&&a.setDepthWrite(!0);var m=n.forcePointsCloud?g.a.PointFillMode:n.forceWireframe?g.a.WireFrameFillMode:this._effectiveMaterial.fillMode;this._internalMeshDataInfo._onBeforeBindObservable&&this._internalMeshDataInfo._onBeforeBindObservable.notifyObservers(this),s||this._bind(e,o,m);var v=f.getWorldMatrix();this._effectiveMaterial._storeEffectOnSubMeshes?this._effectiveMaterial.bindForSubMesh(v,this,e):this._effectiveMaterial.bind(v,this),!this._effectiveMaterial.backFaceCulling&&this._effectiveMaterial.separateCullingPass&&(a.setState(!0,this._effectiveMaterial.zOffset,!1,!_),this._processRendering(e,o,m,r,s,this._onBeforeDraw,this._effectiveMaterial),a.setState(!0,this._effectiveMaterial.zOffset,!1,_)),this._processRendering(e,o,m,r,s,this._onBeforeDraw,this._effectiveMaterial),this._effectiveMaterial.unbind();for(var y=0,b=n._afterRenderingMeshStage;y<b.length;y++){b[y].action(this,e,r)}return this._internalMeshDataInfo._onAfterRenderObservable&&this._internalMeshDataInfo._onAfterRenderObservable.notifyObservers(this),this},t.prototype._onBeforeDraw=function(e,t,i){e&&i&&i.bindOnlyWorldMatrix(t)},t.prototype.cleanMatrixWeights=function(){this.isVerticesDataPresent(h.b.MatricesWeightsKind)&&(this.isVerticesDataPresent(h.b.MatricesWeightsExtraKind)?this.normalizeSkinWeightsAndExtra():this.normalizeSkinFourWeights())},t.prototype.normalizeSkinFourWeights=function(){for(var e=this.getVerticesData(h.b.MatricesWeightsKind),t=e.length,i=0;i<t;i+=4){var n=e[i]+e[i+1]+e[i+2]+e[i+3];if(0===n)e[i]=1;else{var r=1/n;e[i]*=r,e[i+1]*=r,e[i+2]*=r,e[i+3]*=r}}this.setVerticesData(h.b.MatricesWeightsKind,e)},t.prototype.normalizeSkinWeightsAndExtra=function(){for(var e=this.getVerticesData(h.b.MatricesWeightsExtraKind),t=this.getVerticesData(h.b.MatricesWeightsKind),i=t.length,n=0;n<i;n+=4){var r=t[n]+t[n+1]+t[n+2]+t[n+3];if(0===(r+=e[n]+e[n+1]+e[n+2]+e[n+3]))t[n]=1;else{var o=1/r;t[n]*=o,t[n+1]*=o,t[n+2]*=o,t[n+3]*=o,e[n]*=o,e[n+1]*=o,e[n+2]*=o,e[n+3]*=o}}this.setVerticesData(h.b.MatricesWeightsKind,t),this.setVerticesData(h.b.MatricesWeightsKind,e)},t.prototype.validateSkinning=function(){var e=this.getVerticesData(h.b.MatricesWeightsExtraKind),t=this.getVerticesData(h.b.MatricesWeightsKind);if(null===t||null==this.skeleton)return{skinned:!1,valid:!0,report:"not skinned"};for(var i=t.length,n=0,r=0,o=0,a=0,s=null===e?4:8,c=new Array,l=0;l<=s;l++)c[l]=0;for(l=0;l<i;l+=4){for(var u=t[l],d=u,f=0===d?0:1,p=1;p<s;p++){var _=p<4?t[l+p]:e[l+p-4];_>u&&n++,0!==_&&f++,d+=_,u=_}if(c[f]++,f>o&&(o=f),0===d)r++;else{var m=1/d,g=0;for(p=0;p<s;p++)g+=p<4?Math.abs(t[l+p]-t[l+p]*m):Math.abs(e[l+p-4]-e[l+p-4]*m);g>.001&&a++}}var v=this.skeleton.bones.length,y=this.getVerticesData(h.b.MatricesIndicesKind),b=this.getVerticesData(h.b.MatricesIndicesExtraKind),T=0;for(l=0;l<i;l++)for(p=0;p<s;p++){var E=p<4?y[p]:b[p-4];(E>=v||E<0)&&T++}return{skinned:!0,valid:0===r&&0===a&&0===T,report:"Number of Weights = "+i/4+"\nMaximum influences = "+o+"\nMissing Weights = "+r+"\nNot Sorted = "+n+"\nNot Normalized = "+a+"\nWeightCounts = ["+c+"]\nNumber of bones = "+v+"\nBad Bone Indices = "+T}},t.prototype._checkDelayState=function(){var e=this.getScene();return this._geometry?this._geometry.load(e):this.delayLoadState===b.a.DELAYLOADSTATE_NOTLOADED&&(this.delayLoadState=b.a.DELAYLOADSTATE_LOADING,this._queueLoad(e)),this},t.prototype._queueLoad=function(e){var t=this;e._addPendingData(this);var i=-1!==this.delayLoadingFile.indexOf(".babylonbinarymeshdata");return o.b.LoadFile(this.delayLoadingFile,function(i){i instanceof ArrayBuffer?t._delayLoadingFunction(i,t):t._delayLoadingFunction(JSON.parse(i),t),t.instances.forEach(function(e){e.refreshBoundingInfo(),e._syncSubMeshes()}),t.delayLoadState=b.a.DELAYLOADSTATE_LOADED,e._removePendingData(t)},function(){},e.offlineProvider,i),this},t.prototype.isInFrustum=function(t){return this.delayLoadState!==b.a.DELAYLOADSTATE_LOADING&&(!!e.prototype.isInFrustum.call(this,t)&&(this._checkDelayState(),!0))},t.prototype.setMaterialByID=function(e){var t,i=this.getScene().materials;for(t=i.length-1;t>-1;t--)if(i[t].id===e)return this.material=i[t],this;var n=this.getScene().multiMaterials;for(t=n.length-1;t>-1;t--)if(n[t].id===e)return this.material=n[t],this;return this},t.prototype.getAnimatables=function(){var e=new Array;return this.material&&e.push(this.material),this.skeleton&&e.push(this.skeleton),e},t.prototype.bakeTransformIntoVertices=function(e){if(!this.isVerticesDataPresent(h.b.PositionKind))return this;var t=this.subMeshes.splice(0);this._resetPointsArrayCache();var i,n=this.getVerticesData(h.b.PositionKind),r=new Array;for(i=0;i<n.length;i+=3)c.e.TransformCoordinates(c.e.FromArray(n,i),e).toArray(r,i);if(this.setVerticesData(h.b.PositionKind,r,this.getVertexBuffer(h.b.PositionKind).isUpdatable()),this.isVerticesDataPresent(h.b.NormalKind)){for(n=this.getVerticesData(h.b.NormalKind),r=[],i=0;i<n.length;i+=3)c.e.TransformNormal(c.e.FromArray(n,i),e).normalize().toArray(r,i);this.setVerticesData(h.b.NormalKind,r,this.getVertexBuffer(h.b.NormalKind).isUpdatable())}return e.m[0]*e.m[5]*e.m[10]<0&&this.flipFaces(),this.releaseSubMeshes(),this.subMeshes=t,this},t.prototype.bakeCurrentTransformIntoVertices=function(e){return void 0===e&&(e=!0),this.bakeTransformIntoVertices(this.computeWorldMatrix(!0)),this.resetLocalMatrix(e),this},Object.defineProperty(t.prototype,"_positions",{get:function(){return this._geometry?this._geometry._positions:null},enumerable:!0,configurable:!0}),t.prototype._resetPointsArrayCache=function(){return this._geometry&&this._geometry._resetPointsArrayCache(),this},t.prototype._generatePointsArray=function(){return!!this._geometry&&this._geometry._generatePointsArray()},t.prototype.clone=function(e,i,n,r){return void 0===e&&(e=""),void 0===i&&(i=null),void 0===r&&(r=!0),new t(e,this.getScene(),i,this,n,r)},t.prototype.dispose=function(t,i){void 0===i&&(i=!1),this.morphTargetManager=null,this._geometry&&this._geometry.releaseForMesh(this,!0);var n=this._internalMeshDataInfo;if(n._onBeforeDrawObservable&&n._onBeforeDrawObservable.clear(),n._onBeforeBindObservable&&n._onBeforeBindObservable.clear(),n._onBeforeRenderObservable&&n._onBeforeRenderObservable.clear(),n._onAfterRenderObservable&&n._onAfterRenderObservable.clear(),this._scene.useClonedMeshMap){if(n.meshMap)for(var r in n.meshMap){(s=n.meshMap[r])&&(s._internalMeshDataInfo._source=null,n.meshMap[r]=void 0)}n._source&&n._source._internalMeshDataInfo.meshMap&&(n._source._internalMeshDataInfo.meshMap[this.uniqueId]=void 0)}else for(var o=0,a=this.getScene().meshes;o<a.length;o++){var s;(s=a[o])._internalMeshDataInfo&&s._internalMeshDataInfo._source&&s._internalMeshDataInfo._source===this&&(s._internalMeshDataInfo._source=null)}n._source=null,this._disposeInstanceSpecificData(),e.prototype.dispose.call(this,t,i)},t.prototype._disposeInstanceSpecificData=function(){},t.prototype.applyDisplacementMap=function(e,t,i,n,r,a,s){var c=this;void 0===s&&(s=!1);var l=this.getScene();return o.b.LoadImage(e,function(e){var o=e.width,l=e.height,u=C.a.CreateCanvas(o,l).getContext("2d");u.drawImage(e,0,0);var h=u.getImageData(0,0,o,l).data;c.applyDisplacementMapFromBuffer(h,o,l,t,i,r,a,s),n&&n(c)},function(){},l.offlineProvider),this},t.prototype.applyDisplacementMapFromBuffer=function(e,t,i,n,r,o,a,s){if(void 0===s&&(s=!1),!this.isVerticesDataPresent(h.b.PositionKind)||!this.isVerticesDataPresent(h.b.NormalKind)||!this.isVerticesDataPresent(h.b.UVKind))return E.a.Warn("Cannot call applyDisplacementMap: Given mesh is not complete. Position, Normal or UV are missing"),this;var l=this.getVerticesData(h.b.PositionKind,!0,!0),u=this.getVerticesData(h.b.NormalKind),f=this.getVerticesData(h.b.UVKind),p=c.e.Zero(),_=c.e.Zero(),m=c.d.Zero();o=o||c.d.Zero(),a=a||new c.d(1,1);for(var g=0;g<l.length;g+=3){c.e.FromArrayToRef(l,g,p),c.e.FromArrayToRef(u,g,_),c.d.FromArrayToRef(f,g/3*2,m);var v=4*((Math.abs(m.x*a.x+o.x)*t%t|0)+(Math.abs(m.y*a.y+o.y)*i%i|0)*t),y=.3*(e[v]/255)+.59*(e[v+1]/255)+.11*(e[v+2]/255);_.normalize(),_.scaleInPlace(n+(r-n)*y),(p=p.add(_)).toArray(l,g)}return d.a.ComputeNormals(l,this.getIndices(),u),s?(this.setVerticesData(h.b.PositionKind,l),this.setVerticesData(h.b.NormalKind,u)):(this.updateVerticesData(h.b.PositionKind,l),this.updateVerticesData(h.b.NormalKind,u)),this},t.prototype.convertToFlatShadedMesh=function(){var e,t,i=this.getVerticesDataKinds(),n={},r={},o={},a=!1;for(e=0;e<i.length;e++){t=i[e];var s=this.getVertexBuffer(t);t!==h.b.NormalKind?(n[t]=s,r[t]=n[t].getData(),o[t]=[]):(a=s.isUpdatable(),i.splice(e,1),e--)}var l,u=this.subMeshes.slice(0),d=this.getIndices(),f=this.getTotalIndices();for(l=0;l<f;l++){var p=d[l];for(e=0;e<i.length;e++)for(var m=n[t=i[e]].getStrideSize(),g=0;g<m;g++)o[t].push(r[t][p*m+g])}var v=[],y=o[h.b.PositionKind];for(l=0;l<f;l+=3){d[l]=l,d[l+1]=l+1,d[l+2]=l+2;for(var b=c.e.FromArray(y,3*l),T=c.e.FromArray(y,3*(l+1)),E=c.e.FromArray(y,3*(l+2)),x=b.subtract(T),P=E.subtract(T),A=c.e.Normalize(c.e.Cross(x,P)),S=0;S<3;S++)v.push(A.x),v.push(A.y),v.push(A.z)}for(this.setIndices(d),this.setVerticesData(h.b.NormalKind,v,a),e=0;e<i.length;e++)t=i[e],this.setVerticesData(t,o[t],n[t].isUpdatable());this.releaseSubMeshes();for(var C=0;C<u.length;C++){var R=u[C];_.b.AddToMesh(R.materialIndex,R.indexStart,R.indexCount,R.indexStart,R.indexCount,this)}return this.synchronizeInstances(),this},t.prototype.convertToUnIndexedMesh=function(){var e,t,i=this.getVerticesDataKinds(),n={},r={},o={};for(e=0;e<i.length;e++){t=i[e];var a=this.getVertexBuffer(t);n[t]=a,r[t]=n[t].getData(),o[t]=[]}var s,c=this.subMeshes.slice(0),l=this.getIndices(),u=this.getTotalIndices();for(s=0;s<u;s++){var h=l[s];for(e=0;e<i.length;e++)for(var d=n[t=i[e]].getStrideSize(),f=0;f<d;f++)o[t].push(r[t][h*d+f])}for(s=0;s<u;s+=3)l[s]=s,l[s+1]=s+1,l[s+2]=s+2;for(this.setIndices(l),e=0;e<i.length;e++)t=i[e],this.setVerticesData(t,o[t],n[t].isUpdatable());this.releaseSubMeshes();for(var p=0;p<c.length;p++){var m=c[p];_.b.AddToMesh(m.materialIndex,m.indexStart,m.indexCount,m.indexStart,m.indexCount,this)}return this._unIndexed=!0,this.synchronizeInstances(),this},t.prototype.flipFaces=function(e){void 0===e&&(e=!1);var t,i,n=d.a.ExtractFromMesh(this);if(e&&this.isVerticesDataPresent(h.b.NormalKind)&&n.normals)for(t=0;t<n.normals.length;t++)n.normals[t]*=-1;if(n.indices)for(t=0;t<n.indices.length;t+=3)i=n.indices[t+1],n.indices[t+1]=n.indices[t+2],n.indices[t+2]=i;return n.applyToMesh(this,this.isVertexBufferUpdatable(h.b.PositionKind)),this},t.prototype.increaseVertices=function(e){var t=d.a.ExtractFromMesh(this),i=t.uvs,n=t.indices,r=t.positions,o=t.normals;if(null===n||null===r||null===o||null===i)E.a.Warn("VertexData contains null entries");else{for(var a,s,l=e+1,u=new Array,f=0;f<l+1;f++)u[f]=new Array;var p,_=new c.e(0,0,0),m=new c.e(0,0,0),g=new c.d(0,0),v=new Array,y=new Array,b=new Array,T=r.length,x=i.length;for(f=0;f<n.length;f+=3){y[0]=n[f],y[1]=n[f+1],y[2]=n[f+2];for(var P=0;P<3;P++)if(a=y[P],s=y[(P+1)%3],void 0===b[a]&&void 0===b[s]?(b[a]=new Array,b[s]=new Array):(void 0===b[a]&&(b[a]=new Array),void 0===b[s]&&(b[s]=new Array)),void 0===b[a][s]&&void 0===b[s][a]){b[a][s]=[],_.x=(r[3*s]-r[3*a])/l,_.y=(r[3*s+1]-r[3*a+1])/l,_.z=(r[3*s+2]-r[3*a+2])/l,m.x=(o[3*s]-o[3*a])/l,m.y=(o[3*s+1]-o[3*a+1])/l,m.z=(o[3*s+2]-o[3*a+2])/l,g.x=(i[2*s]-i[2*a])/l,g.y=(i[2*s+1]-i[2*a+1])/l,b[a][s].push(a);for(var A=1;A<l;A++)b[a][s].push(r.length/3),r[T]=r[3*a]+A*_.x,o[T++]=o[3*a]+A*m.x,r[T]=r[3*a+1]+A*_.y,o[T++]=o[3*a+1]+A*m.y,r[T]=r[3*a+2]+A*_.z,o[T++]=o[3*a+2]+A*m.z,i[x++]=i[2*a]+A*g.x,i[x++]=i[2*a+1]+A*g.y;b[a][s].push(s),b[s][a]=new Array,p=b[a][s].length;for(var S=0;S<p;S++)b[s][a][S]=b[a][s][p-1-S]}u[0][0]=n[f],u[1][0]=b[n[f]][n[f+1]][1],u[1][1]=b[n[f]][n[f+2]][1];for(A=2;A<l;A++){u[A][0]=b[n[f]][n[f+1]][A],u[A][A]=b[n[f]][n[f+2]][A],_.x=(r[3*u[A][A]]-r[3*u[A][0]])/A,_.y=(r[3*u[A][A]+1]-r[3*u[A][0]+1])/A,_.z=(r[3*u[A][A]+2]-r[3*u[A][0]+2])/A,m.x=(o[3*u[A][A]]-o[3*u[A][0]])/A,m.y=(o[3*u[A][A]+1]-o[3*u[A][0]+1])/A,m.z=(o[3*u[A][A]+2]-o[3*u[A][0]+2])/A,g.x=(i[2*u[A][A]]-i[2*u[A][0]])/A,g.y=(i[2*u[A][A]+1]-i[2*u[A][0]+1])/A;for(P=1;P<A;P++)u[A][P]=r.length/3,r[T]=r[3*u[A][0]]+P*_.x,o[T++]=o[3*u[A][0]]+P*m.x,r[T]=r[3*u[A][0]+1]+P*_.y,o[T++]=o[3*u[A][0]+1]+P*m.y,r[T]=r[3*u[A][0]+2]+P*_.z,o[T++]=o[3*u[A][0]+2]+P*m.z,i[x++]=i[2*u[A][0]]+P*g.x,i[x++]=i[2*u[A][0]+1]+P*g.y}u[l]=b[n[f+1]][n[f+2]],v.push(u[0][0],u[1][0],u[1][1]);for(A=1;A<l;A++){for(P=0;P<A;P++)v.push(u[A][P],u[A+1][P],u[A+1][P+1]),v.push(u[A][P],u[A+1][P+1],u[A][P+1]);v.push(u[A][P],u[A+1][P],u[A+1][P+1])}}t.indices=v,t.applyToMesh(this,this.isVertexBufferUpdatable(h.b.PositionKind))}},t.prototype.forceSharedVertices=function(){var e=d.a.ExtractFromMesh(this),t=e.uvs,i=e.indices,n=e.positions,r=e.colors;if(void 0===i||void 0===n||null===i||null===n)E.a.Warn("VertexData contains empty entries");else{for(var o,a,s=new Array,c=new Array,l=new Array,u=new Array,f=new Array,p=0,_=new Array,m=0;m<i.length;m+=3){a=[i[m],i[m+1],i[m+2]],f=new Array;for(var g=0;g<3;g++){f[g]="";for(var v=0;v<3;v++)Math.abs(n[3*a[g]+v])<1e-8&&(n[3*a[g]+v]=0),f[g]+=n[3*a[g]+v]+"|";f[g]=f[g].slice(0,-1)}if(f[0]!=f[1]&&f[0]!=f[2]&&f[1]!=f[2])for(g=0;g<3;g++){if((o=_.indexOf(f[g]))<0){_.push(f[g]),o=p++;for(v=0;v<3;v++)s.push(n[3*a[g]+v]);if(null!=r)for(v=0;v<4;v++)u.push(r[4*a[g]+v]);if(null!=t)for(v=0;v<2;v++)l.push(t[2*a[g]+v])}c.push(o)}}var y=new Array;d.a.ComputeNormals(s,c,y),e.positions=s,e.indices=c,e.normals=y,null!=t&&(e.uvs=l),null!=r&&(e.colors=u),e.applyToMesh(this,this.isVertexBufferUpdatable(h.b.PositionKind))}},t._instancedMeshFactory=function(e,t){throw P.a.WarnImport("InstancedMesh")},t._PhysicsImpostorParser=function(e,t,i){throw P.a.WarnImport("PhysicsImpostor")},t.prototype.createInstance=function(e){return t._instancedMeshFactory(e,this)},t.prototype.synchronizeInstances=function(){for(var e=0;e<this.instances.length;e++){this.instances[e]._syncSubMeshes()}return this},t.prototype.optimizeIndices=function(e){var t=this,i=this.getIndices(),n=this.getVerticesData(h.b.PositionKind);if(!n||!i)return this;for(var r=new Array,a=0;a<n.length;a+=3)r.push(c.e.FromArray(n,a));var s=new Array;return o.a.SyncAsyncForLoop(r.length,40,function(e){for(var t=r.length-1-e,i=r[t],n=0;n<t;++n){var o=r[n];if(i.equals(o)){s[t]=n;break}}},function(){for(var n=0;n<i.length;++n)i[n]=s[i[n]]||i[n];var r=t.subMeshes.slice(0);t.setIndices(i),t.subMeshes=r,e&&e(t)}),this},t.prototype.serialize=function(e){e.name=this.name,e.id=this.id,e.type=this.getClassName(),s.a&&s.a.HasTags(this)&&(e.tags=s.a.GetTags(this)),e.position=this.position.asArray(),this.rotationQuaternion?e.rotationQuaternion=this.rotationQuaternion.asArray():this.rotation&&(e.rotation=this.rotation.asArray()),e.scaling=this.scaling.asArray(),this._postMultiplyPivotMatrix?e.pivotMatrix=this.getPivotMatrix().asArray():e.localMatrix=this.getPivotMatrix().asArray(),e.isEnabled=this.isEnabled(!1),e.isVisible=this.isVisible,e.infiniteDistance=this.infiniteDistance,e.pickable=this.isPickable,e.receiveShadows=this.receiveShadows,e.billboardMode=this.billboardMode,e.visibility=this.visibility,e.checkCollisions=this.checkCollisions,e.isBlocker=this.isBlocker,e.overrideMaterialSideOrientation=this.overrideMaterialSideOrientation,this.parent&&(e.parentId=this.parent.id),e.isUnIndexed=this.isUnIndexed;var t=this._geometry;if(t){var i=t.id;e.geometryId=i,e.subMeshes=[];for(var n=0;n<this.subMeshes.length;n++){var r=this.subMeshes[n];e.subMeshes.push({materialIndex:r.materialIndex,verticesStart:r.verticesStart,verticesCount:r.verticesCount,indexStart:r.indexStart,indexCount:r.indexCount})}}if(this.material?this.material.doNotSerialize||(e.materialId=this.material.id):this.material=null,this.morphTargetManager&&(e.morphTargetManagerId=this.morphTargetManager.uniqueId),this.skeleton&&(e.skeletonId=this.skeleton.id),this.getScene()._getComponent(A.a.NAME_PHYSICSENGINE)){var o=this.getPhysicsImpostor();o&&(e.physicsMass=o.getParam("mass"),e.physicsFriction=o.getParam("friction"),e.physicsRestitution=o.getParam("mass"),e.physicsImpostor=o.type)}this.metadata&&(e.metadata=this.metadata),e.instances=[];for(var a=0;a<this.instances.length;a++){var c=this.instances[a];if(!c.doNotSerialize){var l={name:c.name,id:c.id,position:c.position.asArray(),scaling:c.scaling.asArray()};c.parent&&(l.parentId=c.parent.id),c.rotationQuaternion?l.rotationQuaternion=c.rotationQuaternion.asArray():c.rotation&&(l.rotation=c.rotation.asArray()),e.instances.push(l),T.a.AppendSerializedAnimations(c,l),l.ranges=c.serializeAnimationRanges()}}T.a.AppendSerializedAnimations(this,e),e.ranges=this.serializeAnimationRanges(),e.layerMask=this.layerMask,e.alphaIndex=this.alphaIndex,e.hasVertexAlpha=this.hasVertexAlpha,e.overlayAlpha=this.overlayAlpha,e.overlayColor=this.overlayColor.asArray(),e.renderOverlay=this.renderOverlay,e.applyFog=this.applyFog,this.actionManager&&(e.actions=this.actionManager.serialize(this.name))},t.prototype._syncGeometryWithMorphTargetManager=function(){if(this.geometry){this._markSubMeshesAsAttributesDirty();var e=this._internalMeshDataInfo._morphTargetManager;if(e&&e.vertexCount){if(e.vertexCount!==this.getTotalVertices())return E.a.Error("Mesh is incompatible with morph targets. Targets and mesh must all have the same vertices count."),void(this.morphTargetManager=null);for(var t=0;t<e.numInfluencers;t++){var i=e.getActiveTarget(t),n=i.getPositions();if(!n)return void E.a.Error("Invalid morph target. Target must have positions.");this.geometry.setVerticesData(h.b.PositionKind+t,n,!1,3);var r=i.getNormals();r&&this.geometry.setVerticesData(h.b.NormalKind+t,r,!1,3);var o=i.getTangents();o&&this.geometry.setVerticesData(h.b.TangentKind+t,o,!1,3);var a=i.getUVs();a&&this.geometry.setVerticesData(h.b.UVKind+"_"+t,a,!1,2)}}else for(t=0;this.geometry.isVerticesDataPresent(h.b.PositionKind+t);)this.geometry.removeVerticesData(h.b.PositionKind+t),this.geometry.isVerticesDataPresent(h.b.NormalKind+t)&&this.geometry.removeVerticesData(h.b.NormalKind+t),this.geometry.isVerticesDataPresent(h.b.TangentKind+t)&&this.geometry.removeVerticesData(h.b.TangentKind+t),this.geometry.isVerticesDataPresent(h.b.UVKind+t)&&this.geometry.removeVerticesData(h.b.UVKind+"_"+t),t++}},t.Parse=function(e,i,n){var r;if((r=e.type&&"GroundMesh"===e.type?t._GroundMeshParser(e,i):new t(e.name,i)).id=e.id,s.a&&s.a.AddTagsTo(r,e.tags),r.position=c.e.FromArray(e.position),void 0!==e.metadata&&(r.metadata=e.metadata),e.rotationQuaternion?r.rotationQuaternion=c.b.FromArray(e.rotationQuaternion):e.rotation&&(r.rotation=c.e.FromArray(e.rotation)),r.scaling=c.e.FromArray(e.scaling),e.localMatrix?r.setPreTransformMatrix(c.a.FromArray(e.localMatrix)):e.pivotMatrix&&r.setPivotMatrix(c.a.FromArray(e.pivotMatrix)),r.setEnabled(e.isEnabled),r.isVisible=e.isVisible,r.infiniteDistance=e.infiniteDistance,r.showBoundingBox=e.showBoundingBox,r.showSubMeshesBoundingBox=e.showSubMeshesBoundingBox,void 0!==e.applyFog&&(r.applyFog=e.applyFog),void 0!==e.pickable&&(r.isPickable=e.pickable),void 0!==e.alphaIndex&&(r.alphaIndex=e.alphaIndex),r.receiveShadows=e.receiveShadows,r.billboardMode=e.billboardMode,void 0!==e.visibility&&(r.visibility=e.visibility),r.checkCollisions=e.checkCollisions,r.overrideMaterialSideOrientation=e.overrideMaterialSideOrientation,void 0!==e.isBlocker&&(r.isBlocker=e.isBlocker),r._shouldGenerateFlatShading=e.useFlatShading,e.freezeWorldMatrix&&(r._waitingData.freezeWorldMatrix=e.freezeWorldMatrix),e.parentId&&(r._waitingParentId=e.parentId),void 0!==e.actions&&(r._waitingData.actions=e.actions),void 0!==e.overlayAlpha&&(r.overlayAlpha=e.overlayAlpha),void 0!==e.overlayColor&&(r.overlayColor=l.a.FromArray(e.overlayColor)),void 0!==e.renderOverlay&&(r.renderOverlay=e.renderOverlay),r.isUnIndexed=!!e.isUnIndexed,r.hasVertexAlpha=e.hasVertexAlpha,e.delayLoadingFile?(r.delayLoadState=b.a.DELAYLOADSTATE_NOTLOADED,r.delayLoadingFile=n+e.delayLoadingFile,r._boundingInfo=new m.a(c.e.FromArray(e.boundingBoxMinimum),c.e.FromArray(e.boundingBoxMaximum)),e._binaryInfo&&(r._binaryInfo=e._binaryInfo),r._delayInfo=[],e.hasUVs&&r._delayInfo.push(h.b.UVKind),e.hasUVs2&&r._delayInfo.push(h.b.UV2Kind),e.hasUVs3&&r._delayInfo.push(h.b.UV3Kind),e.hasUVs4&&r._delayInfo.push(h.b.UV4Kind),e.hasUVs5&&r._delayInfo.push(h.b.UV5Kind),e.hasUVs6&&r._delayInfo.push(h.b.UV6Kind),e.hasColors&&r._delayInfo.push(h.b.ColorKind),e.hasMatricesIndices&&r._delayInfo.push(h.b.MatricesIndicesKind),e.hasMatricesWeights&&r._delayInfo.push(h.b.MatricesWeightsKind),r._delayLoadingFunction=f.a._ImportGeometry,y.a.ForceFullSceneLoadingForIncremental&&r._checkDelayState()):f.a._ImportGeometry(e,r),e.materialId?r.setMaterialByID(e.materialId):r.material=null,e.morphTargetManagerId>-1&&(r.morphTargetManager=i.getMorphTargetManagerById(e.morphTargetManagerId)),e.skeletonId>-1&&(r.skeleton=i.getLastSkeletonByID(e.skeletonId),e.numBoneInfluencers&&(r.numBoneInfluencers=e.numBoneInfluencers)),e.animations){for(var o=0;o<e.animations.length;o++){var a=e.animations[o];(g=x.a.GetClass("BABYLON.Animation"))&&r.animations.push(g.Parse(a))}u.a.ParseAnimationRanges(r,e,i)}if(e.autoAnimate&&i.beginAnimation(r,e.autoAnimateFrom,e.autoAnimateTo,e.autoAnimateLoop,e.autoAnimateSpeed||1),e.layerMask&&!isNaN(e.layerMask)?r.layerMask=Math.abs(parseInt(e.layerMask)):r.layerMask=268435455,e.physicsImpostor&&t._PhysicsImpostorParser(i,r,e),e.lodMeshIds&&(r._waitingData.lods={ids:e.lodMeshIds,distances:e.lodDistances?e.lodDistances:null,coverages:e.lodCoverages?e.lodCoverages:null}),e.instances)for(var d=0;d<e.instances.length;d++){var p=e.instances[d],_=r.createInstance(p.name);if(p.id&&(_.id=p.id),s.a&&(p.tags?s.a.AddTagsTo(_,p.tags):s.a.AddTagsTo(_,e.tags)),_.position=c.e.FromArray(p.position),void 0!==p.metadata&&(_.metadata=p.metadata),p.parentId&&(_._waitingParentId=p.parentId),p.rotationQuaternion?_.rotationQuaternion=c.b.FromArray(p.rotationQuaternion):p.rotation&&(_.rotation=c.e.FromArray(p.rotation)),_.scaling=c.e.FromArray(p.scaling),null!=p.checkCollisions&&null!=p.checkCollisions&&(_.checkCollisions=p.checkCollisions),null!=p.pickable&&null!=p.pickable&&(_.isPickable=p.pickable),null!=p.showBoundingBox&&null!=p.showBoundingBox&&(_.showBoundingBox=p.showBoundingBox),null!=p.showSubMeshesBoundingBox&&null!=p.showSubMeshesBoundingBox&&(_.showSubMeshesBoundingBox=p.showSubMeshesBoundingBox),null!=p.alphaIndex&&null!=p.showSubMeshesBoundingBox&&(_.alphaIndex=p.alphaIndex),p.physicsImpostor&&t._PhysicsImpostorParser(i,_,p),p.animations){for(o=0;o<p.animations.length;o++){var g;a=p.animations[o],(g=x.a.GetClass("BABYLON.Animation"))&&_.animations.push(g.Parse(a))}u.a.ParseAnimationRanges(_,p,i),p.autoAnimate&&i.beginAnimation(_,p.autoAnimateFrom,p.autoAnimateTo,p.autoAnimateLoop,p.autoAnimateSpeed||1)}}return r},t.CreateRibbon=function(e,t,i,n,r,o,a,s,c){throw P.a.WarnImport("MeshBuilder")},t.CreateDisc=function(e,t,i,n,r,o){throw void 0===n&&(n=null),P.a.WarnImport("MeshBuilder")},t.CreateBox=function(e,t,i,n,r){throw void 0===i&&(i=null),P.a.WarnImport("MeshBuilder")},t.CreateSphere=function(e,t,i,n,r,o){throw P.a.WarnImport("MeshBuilder")},t.CreateHemisphere=function(e,t,i,n){throw P.a.WarnImport("MeshBuilder")},t.CreateCylinder=function(e,t,i,n,r,o,a,s,c){throw P.a.WarnImport("MeshBuilder")},t.CreateTorus=function(e,t,i,n,r,o,a){throw P.a.WarnImport("MeshBuilder")},t.CreateTorusKnot=function(e,t,i,n,r,o,a,s,c,l){throw P.a.WarnImport("MeshBuilder")},t.CreateLines=function(e,t,i,n,r){throw void 0===i&&(i=null),void 0===n&&(n=!1),void 0===r&&(r=null),P.a.WarnImport("MeshBuilder")},t.CreateDashedLines=function(e,t,i,n,r,o,a,s){throw void 0===o&&(o=null),P.a.WarnImport("MeshBuilder")},t.CreatePolygon=function(e,t,i,n,r,o,a){throw void 0===a&&(a=earcut),P.a.WarnImport("MeshBuilder")},t.ExtrudePolygon=function(e,t,i,n,r,o,a,s){throw void 0===s&&(s=earcut),P.a.WarnImport("MeshBuilder")},t.ExtrudeShape=function(e,t,i,n,r,o,a,s,c,l){throw void 0===a&&(a=null),P.a.WarnImport("MeshBuilder")},t.ExtrudeShapeCustom=function(e,t,i,n,r,o,a,s,c,l,u,h){throw P.a.WarnImport("MeshBuilder")},t.CreateLathe=function(e,t,i,n,r,o,a){throw P.a.WarnImport("MeshBuilder")},t.CreatePlane=function(e,t,i,n,r){throw P.a.WarnImport("MeshBuilder")},t.CreateGround=function(e,t,i,n,r,o){throw P.a.WarnImport("MeshBuilder")},t.CreateTiledGround=function(e,t,i,n,r,o,a,s,c){throw P.a.WarnImport("MeshBuilder")},t.CreateGroundFromHeightMap=function(e,t,i,n,r,o,a,s,c,l,u){throw P.a.WarnImport("MeshBuilder")},t.CreateTube=function(e,t,i,n,r,o,a,s,c,l){throw P.a.WarnImport("MeshBuilder")},t.CreatePolyhedron=function(e,t,i){throw P.a.WarnImport("MeshBuilder")},t.CreateIcoSphere=function(e,t,i){throw P.a.WarnImport("MeshBuilder")},t.CreateDecal=function(e,t,i,n,r,o){throw P.a.WarnImport("MeshBuilder")},t.prototype.setPositionsForCPUSkinning=function(){var e=this._internalMeshDataInfo;if(!e._sourcePositions){var t=this.getVerticesData(h.b.PositionKind);if(!t)return e._sourcePositions;e._sourcePositions=new Float32Array(t),this.isVertexBufferUpdatable(h.b.PositionKind)||this.setVerticesData(h.b.PositionKind,t,!0)}return e._sourcePositions},t.prototype.setNormalsForCPUSkinning=function(){var e=this._internalMeshDataInfo;if(!e._sourceNormals){var t=this.getVerticesData(h.b.NormalKind);if(!t)return e._sourceNormals;e._sourceNormals=new Float32Array(t),this.isVertexBufferUpdatable(h.b.NormalKind)||this.setVerticesData(h.b.NormalKind,t,!0)}return e._sourceNormals},t.prototype.applySkeleton=function(e){if(!this.geometry)return this;if(this.geometry._softwareSkinningFrameId==this.getScene().getFrameId())return this;if(this.geometry._softwareSkinningFrameId=this.getScene().getFrameId(),!this.isVerticesDataPresent(h.b.PositionKind))return this;if(!this.isVerticesDataPresent(h.b.NormalKind))return this;if(!this.isVerticesDataPresent(h.b.MatricesIndicesKind))return this;if(!this.isVerticesDataPresent(h.b.MatricesWeightsKind))return this;var t=this._internalMeshDataInfo;if(!t._sourcePositions){var i=this.subMeshes.slice();this.setPositionsForCPUSkinning(),this.subMeshes=i}t._sourceNormals||this.setNormalsForCPUSkinning();var n=this.getVerticesData(h.b.PositionKind);if(!n)return this;n instanceof Float32Array||(n=new Float32Array(n));var r=this.getVerticesData(h.b.NormalKind);if(!r)return this;r instanceof Float32Array||(r=new Float32Array(r));var o=this.getVerticesData(h.b.MatricesIndicesKind),a=this.getVerticesData(h.b.MatricesWeightsKind);if(!a||!o)return this;for(var s,l=this.numBoneInfluencers>4,u=l?this.getVerticesData(h.b.MatricesIndicesExtraKind):null,d=l?this.getVerticesData(h.b.MatricesWeightsExtraKind):null,f=e.getTransformMatrices(this),p=c.e.Zero(),_=new c.a,m=new c.a,g=0,v=0;v<n.length;v+=3,g+=4){var y;for(s=0;s<4;s++)(y=a[g+s])>0&&(c.a.FromFloat32ArrayToRefScaled(f,Math.floor(16*o[g+s]),y,m),_.addToSelf(m));if(l)for(s=0;s<4;s++)(y=d[g+s])>0&&(c.a.FromFloat32ArrayToRefScaled(f,Math.floor(16*u[g+s]),y,m),_.addToSelf(m));c.e.TransformCoordinatesFromFloatsToRef(t._sourcePositions[v],t._sourcePositions[v+1],t._sourcePositions[v+2],_,p),p.toArray(n,v),c.e.TransformNormalFromFloatsToRef(t._sourceNormals[v],t._sourceNormals[v+1],t._sourceNormals[v+2],_,p),p.toArray(r,v),_.reset()}return this.updateVerticesData(h.b.PositionKind,n),this.updateVerticesData(h.b.NormalKind,r),this},t.MinMax=function(e){var t=null,i=null;return e.forEach(function(e){var n=e.getBoundingInfo().boundingBox;t&&i?(t.minimizeInPlace(n.minimumWorld),i.maximizeInPlace(n.maximumWorld)):(t=n.minimumWorld,i=n.maximumWorld)}),t&&i?{min:t,max:i}:{min:c.e.Zero(),max:c.e.Zero()}},t.Center=function(e){var i=e instanceof Array?t.MinMax(e):e;return c.e.Center(i.min,i.max)},t.MergeMeshes=function(e,i,n,r,o,a){var s;if(void 0===i&&(i=!0),!n){var c=0;for(s=0;s<e.length;s++)if(e[s]&&(c+=e[s].getTotalVertices())>=65536)return E.a.Warn("Cannot merge meshes because resulting mesh will have more than 65536 vertices. Please use allow32BitsIndices = true to use 32 bits indices"),null}if(a){var l,u,h=null;o=!1}var f,p=new Array,m=new Array,g=null,y=new Array,b=null;for(s=0;s<e.length;s++)if(e[s]){var T=e[s];if(T.isAnInstance)return E.a.Warn("Cannot merge instance meshes."),null;var x=T.computeWorldMatrix(!0);if((f=d.a.ExtractFromMesh(T,!0,!0)).transform(x),g?g.merge(f,n):(g=f,b=T),o&&y.push(T.getTotalIndices()),a)if(T.material){var P=T.material;if(P instanceof v.a){for(u=0;u<P.subMaterials.length;u++)p.indexOf(P.subMaterials[u])<0&&p.push(P.subMaterials[u]);for(l=0;l<T.subMeshes.length;l++)m.push(p.indexOf(P.subMaterials[T.subMeshes[l].materialIndex])),y.push(T.subMeshes[l].indexCount)}else for(p.indexOf(P)<0&&p.push(P),l=0;l<T.subMeshes.length;l++)m.push(p.indexOf(P)),y.push(T.subMeshes[l].indexCount)}else for(l=0;l<T.subMeshes.length;l++)m.push(0),y.push(T.subMeshes[l].indexCount)}if(b=b,r||(r=new t(b.name+"_merged",b.getScene())),g.applyToMesh(r),r.checkCollisions=b.checkCollisions,i)for(s=0;s<e.length;s++)e[s]&&e[s].dispose();if(o||a){r.releaseSubMeshes(),s=0;for(var A=0;s<y.length;)_.b.CreateFromIndices(0,A,y[s],r),A+=y[s],s++}if(a){for((h=new v.a(b.name+"_merged",b.getScene())).subMaterials=p,l=0;l<r.subMeshes.length;l++)r.subMeshes[l].materialIndex=m[l];r.material=h}else r.material=b.material;return r},t.prototype.addInstance=function(e){e._indexInSourceMeshInstanceArray=this.instances.length,this.instances.push(e)},t.prototype.removeInstance=function(e){var t=e._indexInSourceMeshInstanceArray;if(-1!=t){if(t!==this.instances.length-1){var i=this.instances[this.instances.length-1];this.instances[t]=i,i._indexInSourceMeshInstanceArray=t}e._indexInSourceMeshInstanceArray=-1,this.instances.pop()}},t.FRONTSIDE=d.a.FRONTSIDE,t.BACKSIDE=d.a.BACKSIDE,t.DOUBLESIDE=d.a.DOUBLESIDE,t.DEFAULTSIDE=d.a.DEFAULTSIDE,t.NO_CAP=0,t.CAP_START=1,t.CAP_END=2,t.CAP_ALL=3,t.NO_FLIP=0,t.FLIP_TILE=1,t.ROTATE_TILE=2,t.FLIP_ROW=3,t.ROTATE_ROW=4,t.FLIP_N_ROTATE_TILE=5,t.FLIP_N_ROTATE_ROW=6,t.CENTER=0,t.LEFT=1,t.RIGHT=2,t.TOP=3,t.BOTTOM=4,t._GroundMeshParser=function(e,t){throw P.a.WarnImport("GroundMesh")},t}(p.a)},function(e,t,i){"use strict";i.d(t,"a",function(){return n}),i.d(t,"d",function(){return r}),i.d(t,"b",function(){return o}),i.d(t,"c",function(){return a});var n=function(){function e(e,t,i,n){void 0===t&&(t=!1),this.initalize(e,t,i,n)}return e.prototype.initalize=function(e,t,i,n){return void 0===t&&(t=!1),this.mask=e,this.skipNextObservers=t,this.target=i,this.currentTarget=n,this},e}(),r=function(e,t,i){void 0===i&&(i=null),this.callback=e,this.mask=t,this.scope=i,this._willBeUnregistered=!1,this.unregisterOnNextCall=!1},o=function(){function e(){}return e.prototype.dispose=function(){if(this._observers&&this._observables)for(var e=0;e<this._observers.length;e++)this._observables[e].remove(this._observers[e]);this._observers=null,this._observables=null},e.Watch=function(t,i,n,r){void 0===n&&(n=-1),void 0===r&&(r=null);var o=new e;o._observers=new Array,o._observables=t;for(var a=0,s=t;a<s.length;a++){var c=s[a].add(i,n,!1,r);c&&o._observers.push(c)}return o},e}(),a=function(){function e(e){this._observers=new Array,this._eventState=new n(0),e&&(this._onObserverAdded=e)}return Object.defineProperty(e.prototype,"observers",{get:function(){return this._observers},enumerable:!0,configurable:!0}),e.prototype.add=function(e,t,i,n,o){if(void 0===t&&(t=-1),void 0===i&&(i=!1),void 0===n&&(n=null),void 0===o&&(o=!1),!e)return null;var a=new r(e,t,n);return a.unregisterOnNextCall=o,i?this._observers.unshift(a):this._observers.push(a),this._onObserverAdded&&this._onObserverAdded(a),a},e.prototype.addOnce=function(e){return this.add(e,void 0,void 0,void 0,!0)},e.prototype.remove=function(e){return!!e&&(-1!==this._observers.indexOf(e)&&(this._deferUnregister(e),!0))},e.prototype.removeCallback=function(e,t){for(var i=0;i<this._observers.length;i++){var n=this._observers[i];if(!n._willBeUnregistered&&(n.callback===e&&(!t||t===n.scope)))return this._deferUnregister(n),!0}return!1},e.prototype._deferUnregister=function(e){var t=this;e.unregisterOnNextCall=!1,e._willBeUnregistered=!0,setTimeout(function(){t._remove(e)},0)},e.prototype._remove=function(e){if(!e)return!1;var t=this._observers.indexOf(e);return-1!==t&&(this._observers.splice(t,1),!0)},e.prototype.makeObserverTopPriority=function(e){this._remove(e),this._observers.unshift(e)},e.prototype.makeObserverBottomPriority=function(e){this._remove(e),this._observers.push(e)},e.prototype.notifyObservers=function(e,t,i,n){if(void 0===t&&(t=-1),!this._observers.length)return!0;var r=this._eventState;r.mask=t,r.target=i,r.currentTarget=n,r.skipNextObservers=!1,r.lastReturnValue=e;for(var o=0,a=this._observers;o<a.length;o++){var s=a[o];if(!s._willBeUnregistered&&(s.mask&t&&(s.scope?r.lastReturnValue=s.callback.apply(s.scope,[e,r]):r.lastReturnValue=s.callback(e,r),s.unregisterOnNextCall&&this._deferUnregister(s)),r.skipNextObservers))return!1}return!0},e.prototype.notifyObserversWithPromise=function(e,t,i,n){var r=this;void 0===t&&(t=-1);var o=Promise.resolve(e);if(!this._observers.length)return o;var a=this._eventState;return a.mask=t,a.target=i,a.currentTarget=n,a.skipNextObservers=!1,this._observers.forEach(function(i){a.skipNextObservers||i._willBeUnregistered||i.mask&t&&(o=i.scope?o.then(function(t){return a.lastReturnValue=t,i.callback.apply(i.scope,[e,a])}):o.then(function(t){return a.lastReturnValue=t,i.callback(e,a)}),i.unregisterOnNextCall&&r._deferUnregister(i))}),o.then(function(){return e})},e.prototype.notifyObserver=function(e,t,i){void 0===i&&(i=-1);var n=this._eventState;n.mask=i,n.skipNextObservers=!1,e.callback(t,n)},e.prototype.hasObservers=function(){return this._observers.length>0},e.prototype.clear=function(){this._observers=new Array,this._onObserverAdded=null},e.prototype.clone=function(){var t=new e;return t._observers=this._observers.slice(0),t},e.prototype.hasSpecificMask=function(e){void 0===e&&(e=-1);for(var t=0,i=this._observers;t<i.length;t++){var n=i[t];if(n.mask&e||n.mask===e)return!0}return!1},e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return n});var n=function(){function e(){}return e._AddLogEntry=function(t){e._LogCache=t+e._LogCache,e.OnNewCacheEntry&&e.OnNewCacheEntry(t)},e._FormatMessage=function(e){var t=function(e){return e<10?"0"+e:""+e},i=new Date;return"["+t(i.getHours())+":"+t(i.getMinutes())+":"+t(i.getSeconds())+"]: "+e},e._LogDisabled=function(e){},e._LogEnabled=function(t){var i=e._FormatMessage(t);console.log("BJS - "+i);var n="<div style='color:white'>"+i+"</div><br>";e._AddLogEntry(n)},e._WarnDisabled=function(e){},e._WarnEnabled=function(t){var i=e._FormatMessage(t);console.warn("BJS - "+i);var n="<div style='color:orange'>"+i+"</div><br>";e._AddLogEntry(n)},e._ErrorDisabled=function(e){},e._ErrorEnabled=function(t){e.errorsCount++;var i=e._FormatMessage(t);console.error("BJS - "+i);var n="<div style='color:red'>"+i+"</div><br>";e._AddLogEntry(n)},Object.defineProperty(e,"LogCache",{get:function(){return e._LogCache},enumerable:!0,configurable:!0}),e.ClearLogCache=function(){e._LogCache="",e.errorsCount=0},Object.defineProperty(e,"LogLevels",{set:function(t){(t&e.MessageLogLevel)===e.MessageLogLevel?e.Log=e._LogEnabled:e.Log=e._LogDisabled,(t&e.WarningLogLevel)===e.WarningLogLevel?e.Warn=e._WarnEnabled:e.Warn=e._WarnDisabled,(t&e.ErrorLogLevel)===e.ErrorLogLevel?e.Error=e._ErrorEnabled:e.Error=e._ErrorDisabled},enumerable:!0,configurable:!0}),e.NoneLogLevel=0,e.MessageLogLevel=1,e.WarningLogLevel=2,e.ErrorLogLevel=4,e.AllLogLevel=7,e._LogCache="",e.errorsCount=0,e.Log=e._LogEnabled,e.Warn=e._WarnEnabled,e.Error=e._ErrorEnabled,e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return c});var n=i(6),r=i(2),o=i(38),a=i(7),s=i(116),c=function(){function e(t,i,r,a,c,l,u,h,d,f){var p,_,m=this;if(void 0===a&&(a=null),void 0===l&&(l=null),void 0===u&&(u=null),void 0===h&&(h=null),void 0===d&&(d=null),this.name=null,this.defines="",this.onCompiled=null,this.onError=null,this.onBind=null,this.uniqueId=0,this.onCompileObservable=new n.c,this.onErrorObservable=new n.c,this._onBindObservable=null,this._wasPreviouslyReady=!1,this._bonesComputationForcedToCPU=!1,this._uniformBuffersNames={},this._samplers={},this._isReady=!1,this._compilationError="",this._allFallbacksProcessed=!1,this._uniforms={},this._key="",this._fallbacks=null,this._vertexSourceCode="",this._fragmentSourceCode="",this._vertexSourceCodeOverride="",this._fragmentSourceCodeOverride="",this._transformFeedbackVaryings=null,this._pipelineContext=null,this._valueCache={},this.name=t,i.attributes){var g=i;if(this._engine=r,this._attributesNames=g.attributes,this._uniformsNames=g.uniformsNames.concat(g.samplers),this._samplerList=g.samplers.slice(),this.defines=g.defines,this.onError=g.onError,this.onCompiled=g.onCompiled,this._fallbacks=g.fallbacks,this._indexParameters=g.indexParameters,this._transformFeedbackVaryings=g.transformFeedbackVaryings||null,g.uniformBuffersNames)for(var v=0;v<g.uniformBuffersNames.length;v++)this._uniformBuffersNames[g.uniformBuffersNames[v]]=v}else this._engine=c,this.defines=null==l?"":l,this._uniformsNames=r.concat(a),this._samplerList=a?a.slice():[],this._attributesNames=i,this.onError=d,this.onCompiled=h,this._indexParameters=f,this._fallbacks=u;this._attributeLocationByName={},this.uniqueId=e._uniqueIdSeed++;var y=o.a.IsWindowObjectExist()?this._engine.getHostDocument():null;t.vertexSource?p="source:"+t.vertexSource:t.vertexElement?(p=y?y.getElementById(t.vertexElement):null)||(p=t.vertexElement):p=t.vertex||t,t.fragmentSource?_="source:"+t.fragmentSource:t.fragmentElement?(_=y?y.getElementById(t.fragmentElement):null)||(_=t.fragmentElement):_=t.fragment||t;var b={defines:this.defines.split("\n"),indexParameters:this._indexParameters,isFragment:!1,shouldUseHighPrecisionShader:this._engine._shouldUseHighPrecisionShader,processor:this._engine._shaderProcessor,supportsUniformBuffers:this._engine.supportsUniformBuffers,shadersRepository:e.ShadersRepository,includesShadersStore:e.IncludesShadersStore,version:(100*this._engine.webGLVersion).toString(),platformName:this._engine.webGLVersion>=2?"WEBGL2":"WEBGL1"};this._loadShader(p,"Vertex","",function(e){m._loadShader(_,"Fragment","Pixel",function(i){s.a.Process(e,b,function(e){b.isFragment=!0,s.a.Process(i,b,function(i){m._useFinalCode(e,i,t)})})})})}return Object.defineProperty(e.prototype,"onBindObservable",{get:function(){return this._onBindObservable||(this._onBindObservable=new n.c),this._onBindObservable},enumerable:!0,configurable:!0}),e.prototype._useFinalCode=function(e,t,i){if(i){var n=i.vertexElement||i.vertex||i.spectorName||i,r=i.fragmentElement||i.fragment||i.spectorName||i;this._vertexSourceCode="#define SHADER_NAME vertex:"+n+"\n"+e,this._fragmentSourceCode="#define SHADER_NAME fragment:"+r+"\n"+t}else this._vertexSourceCode=e,this._fragmentSourceCode=t;this._prepareEffect()},Object.defineProperty(e.prototype,"key",{get:function(){return this._key},enumerable:!0,configurable:!0}),e.prototype.isReady=function(){try{return this._isReadyInternal()}catch(e){return!1}},e.prototype._isReadyInternal=function(){return!!this._isReady||!!this._pipelineContext&&this._pipelineContext.isReady},e.prototype.getEngine=function(){return this._engine},e.prototype.getPipelineContext=function(){return this._pipelineContext},e.prototype.getAttributesNames=function(){return this._attributesNames},e.prototype.getAttributeLocation=function(e){return this._attributes[e]},e.prototype.getAttributeLocationByName=function(e){return this._attributeLocationByName[e]},e.prototype.getAttributesCount=function(){return this._attributes.length},e.prototype.getUniformIndex=function(e){return this._uniformsNames.indexOf(e)},e.prototype.getUniform=function(e){return this._uniforms[e]},e.prototype.getSamplers=function(){return this._samplerList},e.prototype.getCompilationError=function(){return this._compilationError},e.prototype.allFallbacksProcessed=function(){return this._allFallbacksProcessed},e.prototype.executeWhenCompiled=function(e){var t=this;this.isReady()?e(this):(this.onCompileObservable.add(function(t){e(t)}),this._pipelineContext&&!this._pipelineContext.isAsync||setTimeout(function(){t._checkIsReady(null)},16))},e.prototype._checkIsReady=function(e){var t=this;try{if(this._isReadyInternal())return}catch(t){return void this._processCompilationErrors(t,e)}setTimeout(function(){t._checkIsReady(e)},16)},e.prototype._loadShader=function(t,i,n,r){var a;if("undefined"!=typeof HTMLElement&&t instanceof HTMLElement)return void r(o.a.GetDOMTextContent(t));"source:"!==t.substr(0,7)?"base64:"!==t.substr(0,7)?e.ShadersStore[t+i+"Shader"]?r(e.ShadersStore[t+i+"Shader"]):n&&e.ShadersStore[t+n+"Shader"]?r(e.ShadersStore[t+n+"Shader"]):(a="."===t[0]||"/"===t[0]||t.indexOf("http")>-1?t:e.ShadersRepository+t,this._engine._loadFile(a+"."+i.toLowerCase()+".fx",r)):r(window.atob(t.substr(7))):r(t.substr(7))},e.prototype._rebuildProgram=function(e,t,i,n){var o=this;this._isReady=!1,this._vertexSourceCodeOverride=e,this._fragmentSourceCodeOverride=t,this.onError=function(e,t){n&&n(t)},this.onCompiled=function(){var e=o.getEngine().scenes;if(e)for(var t=0;t<e.length;t++)e[t].markAllMaterialsAsDirty(r.a.MATERIAL_AllDirtyFlag);o._pipelineContext._handlesSpectorRebuildCallback(i)},this._fallbacks=null,this._prepareEffect()},e.prototype._prepareEffect=function(){var e=this,t=this._attributesNames,i=this.defines;this._valueCache={};var n=this._pipelineContext;try{var r=this._engine;this._pipelineContext=r.createPipelineContext();var o=this._rebuildProgram.bind(this);this._vertexSourceCodeOverride&&this._fragmentSourceCodeOverride?r._preparePipelineContext(this._pipelineContext,this._vertexSourceCodeOverride,this._fragmentSourceCodeOverride,!0,o,null,this._transformFeedbackVaryings):r._preparePipelineContext(this._pipelineContext,this._vertexSourceCode,this._fragmentSourceCode,!1,o,i,this._transformFeedbackVaryings),r._executeWhenRenderingStateIsCompiled(this._pipelineContext,function(){if(r.supportsUniformBuffers)for(var i in e._uniformBuffersNames)e.bindUniformBlock(i,e._uniformBuffersNames[i]);var o;if(r.getUniforms(e._pipelineContext,e._uniformsNames).forEach(function(t,i){e._uniforms[e._uniformsNames[i]]=t}),e._attributes=r.getAttributes(e._pipelineContext,t),t)for(var a=0;a<t.length;a++){var s=t[a];e._attributeLocationByName[s]=e._attributes[a]}for(o=0;o<e._samplerList.length;o++){null==e.getUniform(e._samplerList[o])&&(e._samplerList.splice(o,1),o--)}e._samplerList.forEach(function(t,i){e._samplers[t]=i}),r.bindSamplers(e),e._compilationError="",e._isReady=!0,e.onCompiled&&e.onCompiled(e),e.onCompileObservable.notifyObservers(e),e.onCompileObservable.clear(),e._fallbacks&&e._fallbacks.unBindMesh(),n&&e.getEngine()._deletePipelineContext(n)}),this._pipelineContext.isAsync&&this._checkIsReady(n)}catch(e){this._processCompilationErrors(e,n)}},e.prototype._processCompilationErrors=function(e,t){void 0===t&&(t=null),this._compilationError=e.message;var i=this._attributesNames,n=this._fallbacks;a.a.Error("Unable to compile effect:"),a.a.Error("Uniforms: "+this._uniformsNames.map(function(e){return" "+e})),a.a.Error("Attributes: "+i.map(function(e){return" "+e})),a.a.Error("Defines:\r\n"+this.defines),a.a.Error("Error: "+this._compilationError),t&&(this._pipelineContext=t,this._isReady=!0,this.onError&&this.onError(this,this._compilationError),this.onErrorObservable.notifyObservers(this)),n?(this._pipelineContext=null,n.hasMoreFallbacks?(this._allFallbacksProcessed=!1,a.a.Error("Trying next fallback."),this.defines=n.reduce(this.defines,this),this._prepareEffect()):(this._allFallbacksProcessed=!0,this.onError&&this.onError(this,this._compilationError),this.onErrorObservable.notifyObservers(this),this.onErrorObservable.clear(),this._fallbacks&&this._fallbacks.unBindMesh())):this._allFallbacksProcessed=!0},Object.defineProperty(e.prototype,"isSupported",{get:function(){return""===this._compilationError},enumerable:!0,configurable:!0}),e.prototype._bindTexture=function(e,t){this._engine._bindTexture(this._samplers[e],t)},e.prototype.setTexture=function(e,t){this._engine.setTexture(this._samplers[e],this._uniforms[e],t)},e.prototype.setDepthStencilTexture=function(e,t){this._engine.setDepthStencilTexture(this._samplers[e],this._uniforms[e],t)},e.prototype.setTextureArray=function(e,t){var i=e+"Ex";if(-1===this._samplerList.indexOf(i+"0")){for(var n=this._samplerList.indexOf(e),r=1;r<t.length;r++){var o=i+(r-1).toString();this._samplerList.splice(n+r,0,o)}for(var a=0,s=0,c=this._samplerList;s<c.length;s++){var l=c[s];this._samplers[l]=a,a+=1}}this._engine.setTextureArray(this._samplers[e],this._uniforms[e],t)},e.prototype.setTextureFromPostProcess=function(e,t){this._engine.setTextureFromPostProcess(this._samplers[e],t)},e.prototype.setTextureFromPostProcessOutput=function(e,t){this._engine.setTextureFromPostProcessOutput(this._samplers[e],t)},e.prototype._cacheMatrix=function(e,t){var i=this._valueCache[e],n=t.updateFlag;return(void 0===i||i!==n)&&(this._valueCache[e]=n,!0)},e.prototype._cacheFloat2=function(e,t,i){var n=this._valueCache[e];if(!n||2!==n.length)return n=[t,i],this._valueCache[e]=n,!0;var r=!1;return n[0]!==t&&(n[0]=t,r=!0),n[1]!==i&&(n[1]=i,r=!0),r},e.prototype._cacheFloat3=function(e,t,i,n){var r=this._valueCache[e];if(!r||3!==r.length)return r=[t,i,n],this._valueCache[e]=r,!0;var o=!1;return r[0]!==t&&(r[0]=t,o=!0),r[1]!==i&&(r[1]=i,o=!0),r[2]!==n&&(r[2]=n,o=!0),o},e.prototype._cacheFloat4=function(e,t,i,n,r){var o=this._valueCache[e];if(!o||4!==o.length)return o=[t,i,n,r],this._valueCache[e]=o,!0;var a=!1;return o[0]!==t&&(o[0]=t,a=!0),o[1]!==i&&(o[1]=i,a=!0),o[2]!==n&&(o[2]=n,a=!0),o[3]!==r&&(o[3]=r,a=!0),a},e.prototype.bindUniformBuffer=function(t,i){var n=this._uniformBuffersNames[i];void 0!==n&&e._baseCache[n]!==t&&(e._baseCache[n]=t,this._engine.bindUniformBufferBase(t,n))},e.prototype.bindUniformBlock=function(e,t){this._engine.bindUniformBlock(this._pipelineContext,e,t)},e.prototype.setInt=function(e,t){var i=this._valueCache[e];return void 0!==i&&i===t?this:(this._valueCache[e]=t,this._engine.setInt(this._uniforms[e],t),this)},e.prototype.setIntArray=function(e,t){return this._valueCache[e]=null,this._engine.setIntArray(this._uniforms[e],t),this},e.prototype.setIntArray2=function(e,t){return this._valueCache[e]=null,this._engine.setIntArray2(this._uniforms[e],t),this},e.prototype.setIntArray3=function(e,t){return this._valueCache[e]=null,this._engine.setIntArray3(this._uniforms[e],t),this},e.prototype.setIntArray4=function(e,t){return this._valueCache[e]=null,this._engine.setIntArray4(this._uniforms[e],t),this},e.prototype.setFloatArray=function(e,t){return this._valueCache[e]=null,this._engine.setArray(this._uniforms[e],t),this},e.prototype.setFloatArray2=function(e,t){return this._valueCache[e]=null,this._engine.setArray2(this._uniforms[e],t),this},e.prototype.setFloatArray3=function(e,t){return this._valueCache[e]=null,this._engine.setArray3(this._uniforms[e],t),this},e.prototype.setFloatArray4=function(e,t){return this._valueCache[e]=null,this._engine.setArray4(this._uniforms[e],t),this},e.prototype.setArray=function(e,t){return this._valueCache[e]=null,this._engine.setArray(this._uniforms[e],t),this},e.prototype.setArray2=function(e,t){return this._valueCache[e]=null,this._engine.setArray2(this._uniforms[e],t),this},e.prototype.setArray3=function(e,t){return this._valueCache[e]=null,this._engine.setArray3(this._uniforms[e],t),this},e.prototype.setArray4=function(e,t){return this._valueCache[e]=null,this._engine.setArray4(this._uniforms[e],t),this},e.prototype.setMatrices=function(e,t){return t?(this._valueCache[e]=null,this._engine.setMatrices(this._uniforms[e],t),this):this},e.prototype.setMatrix=function(e,t){return this._cacheMatrix(e,t)&&this._engine.setMatrices(this._uniforms[e],t.toArray()),this},e.prototype.setMatrix3x3=function(e,t){return this._valueCache[e]=null,this._engine.setMatrix3x3(this._uniforms[e],t),this},e.prototype.setMatrix2x2=function(e,t){return this._valueCache[e]=null,this._engine.setMatrix2x2(this._uniforms[e],t),this},e.prototype.setFloat=function(e,t){var i=this._valueCache[e];return void 0!==i&&i===t?this:(this._valueCache[e]=t,this._engine.setFloat(this._uniforms[e],t),this)},e.prototype.setBool=function(e,t){var i=this._valueCache[e];return void 0!==i&&i===t?this:(this._valueCache[e]=t,this._engine.setInt(this._uniforms[e],t?1:0),this)},e.prototype.setVector2=function(e,t){return this._cacheFloat2(e,t.x,t.y)&&this._engine.setFloat2(this._uniforms[e],t.x,t.y),this},e.prototype.setFloat2=function(e,t,i){return this._cacheFloat2(e,t,i)&&this._engine.setFloat2(this._uniforms[e],t,i),this},e.prototype.setVector3=function(e,t){return this._cacheFloat3(e,t.x,t.y,t.z)&&this._engine.setFloat3(this._uniforms[e],t.x,t.y,t.z),this},e.prototype.setFloat3=function(e,t,i,n){return this._cacheFloat3(e,t,i,n)&&this._engine.setFloat3(this._uniforms[e],t,i,n),this},e.prototype.setVector4=function(e,t){return this._cacheFloat4(e,t.x,t.y,t.z,t.w)&&this._engine.setFloat4(this._uniforms[e],t.x,t.y,t.z,t.w),this},e.prototype.setFloat4=function(e,t,i,n,r){return this._cacheFloat4(e,t,i,n,r)&&this._engine.setFloat4(this._uniforms[e],t,i,n,r),this},e.prototype.setColor3=function(e,t){return this._cacheFloat3(e,t.r,t.g,t.b)&&this._engine.setFloat3(this._uniforms[e],t.r,t.g,t.b),this},e.prototype.setColor4=function(e,t,i){return this._cacheFloat4(e,t.r,t.g,t.b,i)&&this._engine.setFloat4(this._uniforms[e],t.r,t.g,t.b,i),this},e.prototype.setDirectColor4=function(e,t){return this._cacheFloat4(e,t.r,t.g,t.b,t.a)&&this._engine.setFloat4(this._uniforms[e],t.r,t.g,t.b,t.a),this},e.prototype.dispose=function(){this._engine._releaseEffect(this)},e.RegisterShader=function(t,i,n){i&&(e.ShadersStore[t+"PixelShader"]=i),n&&(e.ShadersStore[t+"VertexShader"]=n)},e.ResetCache=function(){e._baseCache={}},e.ShadersRepository="src/Shaders/",e._uniqueIdSeed=0,e._baseCache={},e.ShadersStore={},e.IncludesShadersStore={},e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return _});var n=i(1),r=i(3),o=i(6),a=i(0),s=i(49),c=i(2),l=i(12),u=i(19),h=i(115),d=i(112),f=i(60),p=i(36),_=function(e){function t(i,n,r,a,s,l,u,d,f,p,_){void 0===r&&(r=!1),void 0===a&&(a=!0),void 0===s&&(s=t.TRILINEAR_SAMPLINGMODE),void 0===l&&(l=null),void 0===u&&(u=null),void 0===d&&(d=null),void 0===f&&(f=!1);var m=e.call(this,n&&"Scene"===n.getClassName()?n:null)||this;m.url=null,m.uOffset=0,m.vOffset=0,m.uScale=1,m.vScale=1,m.uAng=0,m.vAng=0,m.wAng=0,m.uRotationCenter=.5,m.vRotationCenter=.5,m.wRotationCenter=.5,m.inspectableCustomProperties=null,m._noMipmap=!1,m._invertY=!1,m._rowGenerationMatrix=null,m._cachedTextureMatrix=null,m._projectionModeMatrix=null,m._t0=null,m._t1=null,m._t2=null,m._cachedUOffset=-1,m._cachedVOffset=-1,m._cachedUScale=0,m._cachedVScale=0,m._cachedUAng=-1,m._cachedVAng=-1,m._cachedWAng=-1,m._cachedProjectionMatrixId=-1,m._cachedCoordinatesMode=-1,m._initialSamplingMode=t.BILINEAR_SAMPLINGMODE,m._buffer=null,m._deleteBuffer=!1,m._format=null,m._delayedOnLoad=null,m._delayedOnError=null,m.onLoadObservable=new o.c,m._isBlocking=!0,m.name=i||"",m.url=i,m._noMipmap=r,m._invertY=a,m._initialSamplingMode=s,m._buffer=d,m._deleteBuffer=f,m._mimeType=_,p&&(m._format=p);var g=m.getScene(),v=n&&n.getCaps?n:g?g.getEngine():null;if(!v)return m;v.onBeforeTextureInitObservable.notifyObservers(m);var y=function(){m._texture&&(m._texture._invertVScale&&(m.vScale*=-1,m.vOffset+=1),null!==m._texture._cachedWrapU&&(m.wrapU=m._texture._cachedWrapU,m._texture._cachedWrapU=null),null!==m._texture._cachedWrapV&&(m.wrapV=m._texture._cachedWrapV,m._texture._cachedWrapV=null),null!==m._texture._cachedWrapR&&(m.wrapR=m._texture._cachedWrapR,m._texture._cachedWrapR=null)),m.onLoadObservable.hasObservers()&&m.onLoadObservable.notifyObservers(m),l&&l(),!m.isBlocking&&g&&g.resetCachedMaterial()};return m.url?(m._texture=m._getFromCache(m.url,r,s,a),m._texture?m._texture.isReady?h.a.SetImmediate(function(){return y()}):m._texture.onLoadedObservable.add(y):g&&g.useDelayedTextureLoading?(m.delayLoadState=c.a.DELAYLOADSTATE_NOTLOADED,m._delayedOnLoad=y,m._delayedOnError=u):(m._texture=v.createTexture(m.url,r,a,g,s,y,u,m._buffer,void 0,m._format,null,_),f&&delete m._buffer),m):(m._delayedOnLoad=y,m._delayedOnError=u,m)}return Object(n.d)(t,e),Object.defineProperty(t.prototype,"noMipmap",{get:function(){return this._noMipmap},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isBlocking",{get:function(){return this._isBlocking},set:function(e){this._isBlocking=e},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"samplingMode",{get:function(){return this._texture?this._texture.samplingMode:this._initialSamplingMode},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"invertY",{get:function(){return this._invertY},enumerable:!0,configurable:!0}),t.prototype.updateURL=function(e,t,i){void 0===t&&(t=null),this.url&&(this.releaseInternalTexture(),this.getScene().markAllMaterialsAsDirty(c.a.MATERIAL_TextureDirtyFlag)),this.name&&!p.a.StartsWith(this.name,"data:")||(this.name=e),this.url=e,this._buffer=t,this.delayLoadState=c.a.DELAYLOADSTATE_NOTLOADED,i&&(this._delayedOnLoad=i),this.delayLoad()},t.prototype.delayLoad=function(){if(this.delayLoadState===c.a.DELAYLOADSTATE_NOTLOADED){var e=this.getScene();e&&(this.delayLoadState=c.a.DELAYLOADSTATE_LOADED,this._texture=this._getFromCache(this.url,this._noMipmap,this.samplingMode,this._invertY),this._texture?this._delayedOnLoad&&(this._texture.isReady?h.a.SetImmediate(this._delayedOnLoad):this._texture.onLoadedObservable.add(this._delayedOnLoad)):(this._texture=e.getEngine().createTexture(this.url,this._noMipmap,this._invertY,e,this.samplingMode,this._delayedOnLoad,this._delayedOnError,this._buffer,null,this._format,null,this._mimeType),this._deleteBuffer&&delete this._buffer),this._delayedOnLoad=null,this._delayedOnError=null)}},t.prototype._prepareRowForTextureGeneration=function(e,t,i,n){e*=this._cachedUScale,t*=this._cachedVScale,e-=this.uRotationCenter*this._cachedUScale,t-=this.vRotationCenter*this._cachedVScale,i-=this.wRotationCenter,a.e.TransformCoordinatesFromFloatsToRef(e,t,i,this._rowGenerationMatrix,n),n.x+=this.uRotationCenter*this._cachedUScale+this._cachedUOffset,n.y+=this.vRotationCenter*this._cachedVScale+this._cachedVOffset,n.z+=this.wRotationCenter},t.prototype.getTextureMatrix=function(e){var t=this;if(void 0===e&&(e=1),this.uOffset===this._cachedUOffset&&this.vOffset===this._cachedVOffset&&this.uScale*e===this._cachedUScale&&this.vScale===this._cachedVScale&&this.uAng===this._cachedUAng&&this.vAng===this._cachedVAng&&this.wAng===this._cachedWAng)return this._cachedTextureMatrix;this._cachedUOffset=this.uOffset,this._cachedVOffset=this.vOffset,this._cachedUScale=this.uScale*e,this._cachedVScale=this.vScale,this._cachedUAng=this.uAng,this._cachedVAng=this.vAng,this._cachedWAng=this.wAng,this._cachedTextureMatrix||(this._cachedTextureMatrix=a.a.Zero(),this._rowGenerationMatrix=new a.a,this._t0=a.e.Zero(),this._t1=a.e.Zero(),this._t2=a.e.Zero()),a.a.RotationYawPitchRollToRef(this.vAng,this.uAng,this.wAng,this._rowGenerationMatrix),this._prepareRowForTextureGeneration(0,0,0,this._t0),this._prepareRowForTextureGeneration(1,0,0,this._t1),this._prepareRowForTextureGeneration(0,1,0,this._t2),this._t1.subtractInPlace(this._t0),this._t2.subtractInPlace(this._t0),a.a.FromValuesToRef(this._t1.x,this._t1.y,this._t1.z,0,this._t2.x,this._t2.y,this._t2.z,0,this._t0.x,this._t0.y,this._t0.z,0,0,0,0,1,this._cachedTextureMatrix);var i=this.getScene();return i?(i.markAllMaterialsAsDirty(c.a.MATERIAL_TextureDirtyFlag,function(e){return e.hasTexture(t)}),this._cachedTextureMatrix):this._cachedTextureMatrix},t.prototype.getReflectionTextureMatrix=function(){var e=this,i=this.getScene();if(!i)return this._cachedTextureMatrix;if(this.uOffset===this._cachedUOffset&&this.vOffset===this._cachedVOffset&&this.uScale===this._cachedUScale&&this.vScale===this._cachedVScale&&this.coordinatesMode===this._cachedCoordinatesMode){if(this.coordinatesMode!==t.PROJECTION_MODE)return this._cachedTextureMatrix;if(this._cachedProjectionMatrixId===i.getProjectionMatrix().updateFlag)return this._cachedTextureMatrix}switch(this._cachedTextureMatrix||(this._cachedTextureMatrix=a.a.Zero()),this._projectionModeMatrix||(this._projectionModeMatrix=a.a.Zero()),this._cachedUOffset=this.uOffset,this._cachedVOffset=this.vOffset,this._cachedUScale=this.uScale,this._cachedVScale=this.vScale,this._cachedCoordinatesMode=this.coordinatesMode,this.coordinatesMode){case t.PLANAR_MODE:a.a.IdentityToRef(this._cachedTextureMatrix),this._cachedTextureMatrix[0]=this.uScale,this._cachedTextureMatrix[5]=this.vScale,this._cachedTextureMatrix[12]=this.uOffset,this._cachedTextureMatrix[13]=this.vOffset;break;case t.PROJECTION_MODE:a.a.FromValuesToRef(.5,0,0,0,0,-.5,0,0,0,0,0,0,.5,.5,1,1,this._projectionModeMatrix);var n=i.getProjectionMatrix();this._cachedProjectionMatrixId=n.updateFlag,n.multiplyToRef(this._projectionModeMatrix,this._cachedTextureMatrix);break;default:a.a.IdentityToRef(this._cachedTextureMatrix)}return i.markAllMaterialsAsDirty(c.a.MATERIAL_TextureDirtyFlag,function(t){return-1!==t.getActiveTextures().indexOf(e)}),this._cachedTextureMatrix},t.prototype.clone=function(){var e=this;return r.a.Clone(function(){return new t(e._texture?e._texture.url:null,e.getScene(),e._noMipmap,e._invertY,e.samplingMode,void 0,void 0,e._texture?e._texture._buffer:void 0)},this)},t.prototype.serialize=function(){var i=this.name;t.SerializeBuffers||p.a.StartsWith(this.name,"data:")&&(this.name="");var n=e.prototype.serialize.call(this);return n?(t.SerializeBuffers&&("string"==typeof this._buffer&&"data:"===this._buffer.substr(0,5)?(n.base64String=this._buffer,n.name=n.name.replace("data:","")):this.url&&p.a.StartsWith(this.url,"data:")&&this._buffer instanceof Uint8Array&&(n.base64String="data:image/png;base64,"+p.a.EncodeArrayBufferToBase64(this._buffer))),n.invertY=this._invertY,n.samplingMode=this.samplingMode,this.name=i,n):null},t.prototype.getClassName=function(){return"Texture"},t.prototype.dispose=function(){e.prototype.dispose.call(this),this.onLoadObservable.clear(),this._delayedOnLoad=null,this._delayedOnError=null},t.Parse=function(e,i,n){if(e.customType){var o=d.a.Instantiate(e.customType).Parse(e,i,n);return e.samplingMode&&o.updateSamplingMode&&o._samplingMode&&o._samplingMode!==e.samplingMode&&o.updateSamplingMode(e.samplingMode),o}if(e.isCube&&!e.isRenderTarget)return t._CubeTextureParser(e,i,n);if(!e.name&&!e.isRenderTarget)return null;var a=r.a.Parse(function(){var r,o=!0;if(e.noMipmap&&(o=!1),e.mirrorPlane){var a=t._CreateMirror(e.name,e.renderTargetSize,i,o);return a._waitingRenderList=e.renderList,a.mirrorPlane=f.a.FromArray(e.mirrorPlane),a}if(e.isRenderTarget){var s=null;if(e.isCube){if(i.reflectionProbes)for(var c=0;c<i.reflectionProbes.length;c++){var l=i.reflectionProbes[c];if(l.name===e.name)return l.cubeTexture}}else(s=t._CreateRenderTargetTexture(e.name,e.renderTargetSize,i,o))._waitingRenderList=e.renderList;return s}if(e.base64String)r=t.CreateFromBase64String(e.base64String,e.name,i,!o,e.invertY);else{var u=n+e.name;t.UseSerializedUrlIfAny&&e.url&&(u=e.url),r=new t(u,i,!o,e.invertY)}return r},e,i);if(a&&a._texture&&(a._texture._cachedWrapU=null,a._texture._cachedWrapV=null,a._texture._cachedWrapR=null),e.samplingMode){var s=e.samplingMode;a&&a.samplingMode!==s&&a.updateSamplingMode(s)}if(a&&e.animations)for(var c=0;c<e.animations.length;c++){var u=e.animations[c],h=l.a.GetClass("BABYLON.Animation");h&&a.animations.push(h.Parse(u))}return a},t.CreateFromBase64String=function(e,i,n,r,o,a,s,l,u){return void 0===a&&(a=t.TRILINEAR_SAMPLINGMODE),void 0===s&&(s=null),void 0===l&&(l=null),void 0===u&&(u=c.a.TEXTUREFORMAT_RGBA),new t("data:"+i,n,r,o,a,s,l,e,!1,u)},t.LoadFromDataString=function(e,i,n,r,o,a,s,l,u,h){return void 0===r&&(r=!1),void 0===o&&(o=!1),void 0===a&&(a=!0),void 0===s&&(s=t.TRILINEAR_SAMPLINGMODE),void 0===l&&(l=null),void 0===u&&(u=null),void 0===h&&(h=c.a.TEXTUREFORMAT_RGBA),"data:"!==e.substr(0,5)&&(e="data:"+e),new t(e,n,o,a,s,l,u,i,r,h)},t.SerializeBuffers=!0,t._CubeTextureParser=function(e,t,i){throw u.a.WarnImport("CubeTexture")},t._CreateMirror=function(e,t,i,n){throw u.a.WarnImport("MirrorTexture")},t._CreateRenderTargetTexture=function(e,t,i,n){throw u.a.WarnImport("RenderTargetTexture")},t.NEAREST_SAMPLINGMODE=c.a.TEXTURE_NEAREST_SAMPLINGMODE,t.NEAREST_NEAREST_MIPLINEAR=c.a.TEXTURE_NEAREST_NEAREST_MIPLINEAR,t.BILINEAR_SAMPLINGMODE=c.a.TEXTURE_BILINEAR_SAMPLINGMODE,t.LINEAR_LINEAR_MIPNEAREST=c.a.TEXTURE_LINEAR_LINEAR_MIPNEAREST,t.TRILINEAR_SAMPLINGMODE=c.a.TEXTURE_TRILINEAR_SAMPLINGMODE,t.LINEAR_LINEAR_MIPLINEAR=c.a.TEXTURE_LINEAR_LINEAR_MIPLINEAR,t.NEAREST_NEAREST_MIPNEAREST=c.a.TEXTURE_NEAREST_NEAREST_MIPNEAREST,t.NEAREST_LINEAR_MIPNEAREST=c.a.TEXTURE_NEAREST_LINEAR_MIPNEAREST,t.NEAREST_LINEAR_MIPLINEAR=c.a.TEXTURE_NEAREST_LINEAR_MIPLINEAR,t.NEAREST_LINEAR=c.a.TEXTURE_NEAREST_LINEAR,t.NEAREST_NEAREST=c.a.TEXTURE_NEAREST_NEAREST,t.LINEAR_NEAREST_MIPNEAREST=c.a.TEXTURE_LINEAR_NEAREST_MIPNEAREST,t.LINEAR_NEAREST_MIPLINEAR=c.a.TEXTURE_LINEAR_NEAREST_MIPLINEAR,t.LINEAR_LINEAR=c.a.TEXTURE_LINEAR_LINEAR,t.LINEAR_NEAREST=c.a.TEXTURE_LINEAR_NEAREST,t.EXPLICIT_MODE=c.a.TEXTURE_EXPLICIT_MODE,t.SPHERICAL_MODE=c.a.TEXTURE_SPHERICAL_MODE,t.PLANAR_MODE=c.a.TEXTURE_PLANAR_MODE,t.CUBIC_MODE=c.a.TEXTURE_CUBIC_MODE,t.PROJECTION_MODE=c.a.TEXTURE_PROJECTION_MODE,t.SKYBOX_MODE=c.a.TEXTURE_SKYBOX_MODE,t.INVCUBIC_MODE=c.a.TEXTURE_INVCUBIC_MODE,t.EQUIRECTANGULAR_MODE=c.a.TEXTURE_EQUIRECTANGULAR_MODE,t.FIXED_EQUIRECTANGULAR_MODE=c.a.TEXTURE_FIXED_EQUIRECTANGULAR_MODE,t.FIXED_EQUIRECTANGULAR_MIRRORED_MODE=c.a.TEXTURE_FIXED_EQUIRECTANGULAR_MIRRORED_MODE,t.CLAMP_ADDRESSMODE=c.a.TEXTURE_CLAMP_ADDRESSMODE,t.WRAP_ADDRESSMODE=c.a.TEXTURE_WRAP_ADDRESSMODE,t.MIRROR_ADDRESSMODE=c.a.TEXTURE_MIRROR_ADDRESSMODE,t.UseSerializedUrlIfAny=!1,Object(n.c)([Object(r.c)()],t.prototype,"url",void 0),Object(n.c)([Object(r.c)()],t.prototype,"uOffset",void 0),Object(n.c)([Object(r.c)()],t.prototype,"vOffset",void 0),Object(n.c)([Object(r.c)()],t.prototype,"uScale",void 0),Object(n.c)([Object(r.c)()],t.prototype,"vScale",void 0),Object(n.c)([Object(r.c)()],t.prototype,"uAng",void 0),Object(n.c)([Object(r.c)()],t.prototype,"vAng",void 0),Object(n.c)([Object(r.c)()],t.prototype,"wAng",void 0),Object(n.c)([Object(r.c)()],t.prototype,"uRotationCenter",void 0),Object(n.c)([Object(r.c)()],t.prototype,"vRotationCenter",void 0),Object(n.c)([Object(r.c)()],t.prototype,"wRotationCenter",void 0),Object(n.c)([Object(r.c)()],t.prototype,"isBlocking",null),t}(s.a);r.a._TextureParser=_.Parse},function(e,t,i){"use strict";i.d(t,"a",function(){return s}),i.d(t,"b",function(){return c}),i.d(t,"c",function(){return l});var n=i(14),r=i(28),o=i(42),a=i(12),s=function(){function e(e,t,i){void 0===e&&(e=0),void 0===t&&(t=0),void 0===i&&(i=0),this.r=e,this.g=t,this.b=i}return e.prototype.toString=function(){return"{R: "+this.r+" G:"+this.g+" B:"+this.b+"}"},e.prototype.getClassName=function(){return"Color3"},e.prototype.getHashCode=function(){var e=255*this.r|0;return e=397*(e=397*e^(255*this.g|0))^(255*this.b|0)},e.prototype.toArray=function(e,t){return void 0===t&&(t=0),e[t]=this.r,e[t+1]=this.g,e[t+2]=this.b,this},e.prototype.toColor4=function(e){return void 0===e&&(e=1),new c(this.r,this.g,this.b,e)},e.prototype.asArray=function(){var e=new Array;return this.toArray(e,0),e},e.prototype.toLuminance=function(){return.3*this.r+.59*this.g+.11*this.b},e.prototype.multiply=function(t){return new e(this.r*t.r,this.g*t.g,this.b*t.b)},e.prototype.multiplyToRef=function(e,t){return t.r=this.r*e.r,t.g=this.g*e.g,t.b=this.b*e.b,this},e.prototype.equals=function(e){return e&&this.r===e.r&&this.g===e.g&&this.b===e.b},e.prototype.equalsFloats=function(e,t,i){return this.r===e&&this.g===t&&this.b===i},e.prototype.scale=function(t){return new e(this.r*t,this.g*t,this.b*t)},e.prototype.scaleToRef=function(e,t){return t.r=this.r*e,t.g=this.g*e,t.b=this.b*e,this},e.prototype.scaleAndAddToRef=function(e,t){return t.r+=this.r*e,t.g+=this.g*e,t.b+=this.b*e,this},e.prototype.clampToRef=function(e,t,i){return void 0===e&&(e=0),void 0===t&&(t=1),i.r=n.a.Clamp(this.r,e,t),i.g=n.a.Clamp(this.g,e,t),i.b=n.a.Clamp(this.b,e,t),this},e.prototype.add=function(t){return new e(this.r+t.r,this.g+t.g,this.b+t.b)},e.prototype.addToRef=function(e,t){return t.r=this.r+e.r,t.g=this.g+e.g,t.b=this.b+e.b,this},e.prototype.subtract=function(t){return new e(this.r-t.r,this.g-t.g,this.b-t.b)},e.prototype.subtractToRef=function(e,t){return t.r=this.r-e.r,t.g=this.g-e.g,t.b=this.b-e.b,this},e.prototype.clone=function(){return new e(this.r,this.g,this.b)},e.prototype.copyFrom=function(e){return this.r=e.r,this.g=e.g,this.b=e.b,this},e.prototype.copyFromFloats=function(e,t,i){return this.r=e,this.g=t,this.b=i,this},e.prototype.set=function(e,t,i){return this.copyFromFloats(e,t,i)},e.prototype.toHexString=function(){var e=255*this.r|0,t=255*this.g|0,i=255*this.b|0;return"#"+n.a.ToHex(e)+n.a.ToHex(t)+n.a.ToHex(i)},e.prototype.toLinearSpace=function(){var t=new e;return this.toLinearSpaceToRef(t),t},e.prototype.toHSV=function(){var t=new e;return this.toHSVToRef(t),t},e.prototype.toHSVToRef=function(e){var t=this.r,i=this.g,n=this.b,r=Math.max(t,i,n),o=Math.min(t,i,n),a=0,s=0,c=r,l=r-o;0!==r&&(s=l/r),r!=o&&(r==t?(a=(i-n)/l,i<n&&(a+=6)):r==i?a=(n-t)/l+2:r==n&&(a=(t-i)/l+4),a*=60),e.r=a,e.g=s,e.b=c},e.prototype.toLinearSpaceToRef=function(e){return e.r=Math.pow(this.r,r.c),e.g=Math.pow(this.g,r.c),e.b=Math.pow(this.b,r.c),this},e.prototype.toGammaSpace=function(){var t=new e;return this.toGammaSpaceToRef(t),t},e.prototype.toGammaSpaceToRef=function(e){return e.r=Math.pow(this.r,r.b),e.g=Math.pow(this.g,r.b),e.b=Math.pow(this.b,r.b),this},e.HSVtoRGBToRef=function(e,t,i,n){var r=i*t,o=e/60,a=r*(1-Math.abs(o%2-1)),s=0,c=0,l=0;o>=0&&o<=1?(s=r,c=a):o>=1&&o<=2?(s=a,c=r):o>=2&&o<=3?(c=r,l=a):o>=3&&o<=4?(c=a,l=r):o>=4&&o<=5?(s=a,l=r):o>=5&&o<=6&&(s=r,l=a);var u=i-r;n.set(s+u,c+u,l+u)},e.FromHexString=function(t){if("#"!==t.substring(0,1)||7!==t.length)return new e(0,0,0);var i=parseInt(t.substring(1,3),16),n=parseInt(t.substring(3,5),16),r=parseInt(t.substring(5,7),16);return e.FromInts(i,n,r)},e.FromArray=function(t,i){return void 0===i&&(i=0),new e(t[i],t[i+1],t[i+2])},e.FromInts=function(t,i,n){return new e(t/255,i/255,n/255)},e.Lerp=function(t,i,n){var r=new e(0,0,0);return e.LerpToRef(t,i,n,r),r},e.LerpToRef=function(e,t,i,n){n.r=e.r+(t.r-e.r)*i,n.g=e.g+(t.g-e.g)*i,n.b=e.b+(t.b-e.b)*i},e.Red=function(){return new e(1,0,0)},e.Green=function(){return new e(0,1,0)},e.Blue=function(){return new e(0,0,1)},e.Black=function(){return new e(0,0,0)},Object.defineProperty(e,"BlackReadOnly",{get:function(){return e._BlackReadOnly},enumerable:!0,configurable:!0}),e.White=function(){return new e(1,1,1)},e.Purple=function(){return new e(.5,0,.5)},e.Magenta=function(){return new e(1,0,1)},e.Yellow=function(){return new e(1,1,0)},e.Gray=function(){return new e(.5,.5,.5)},e.Teal=function(){return new e(0,1,1)},e.Random=function(){return new e(Math.random(),Math.random(),Math.random())},e._BlackReadOnly=e.Black(),e}(),c=function(){function e(e,t,i,n){void 0===e&&(e=0),void 0===t&&(t=0),void 0===i&&(i=0),void 0===n&&(n=1),this.r=e,this.g=t,this.b=i,this.a=n}return e.prototype.addInPlace=function(e){return this.r+=e.r,this.g+=e.g,this.b+=e.b,this.a+=e.a,this},e.prototype.asArray=function(){var e=new Array;return this.toArray(e,0),e},e.prototype.toArray=function(e,t){return void 0===t&&(t=0),e[t]=this.r,e[t+1]=this.g,e[t+2]=this.b,e[t+3]=this.a,this},e.prototype.equals=function(e){return e&&this.r===e.r&&this.g===e.g&&this.b===e.b&&this.a===e.a},e.prototype.add=function(t){return new e(this.r+t.r,this.g+t.g,this.b+t.b,this.a+t.a)},e.prototype.subtract=function(t){return new e(this.r-t.r,this.g-t.g,this.b-t.b,this.a-t.a)},e.prototype.subtractToRef=function(e,t){return t.r=this.r-e.r,t.g=this.g-e.g,t.b=this.b-e.b,t.a=this.a-e.a,this},e.prototype.scale=function(t){return new e(this.r*t,this.g*t,this.b*t,this.a*t)},e.prototype.scaleToRef=function(e,t){return t.r=this.r*e,t.g=this.g*e,t.b=this.b*e,t.a=this.a*e,this},e.prototype.scaleAndAddToRef=function(e,t){return t.r+=this.r*e,t.g+=this.g*e,t.b+=this.b*e,t.a+=this.a*e,this},e.prototype.clampToRef=function(e,t,i){return void 0===e&&(e=0),void 0===t&&(t=1),i.r=n.a.Clamp(this.r,e,t),i.g=n.a.Clamp(this.g,e,t),i.b=n.a.Clamp(this.b,e,t),i.a=n.a.Clamp(this.a,e,t),this},e.prototype.multiply=function(t){return new e(this.r*t.r,this.g*t.g,this.b*t.b,this.a*t.a)},e.prototype.multiplyToRef=function(e,t){return t.r=this.r*e.r,t.g=this.g*e.g,t.b=this.b*e.b,t.a=this.a*e.a,t},e.prototype.toString=function(){return"{R: "+this.r+" G:"+this.g+" B:"+this.b+" A:"+this.a+"}"},e.prototype.getClassName=function(){return"Color4"},e.prototype.getHashCode=function(){var e=255*this.r|0;return e=397*(e=397*(e=397*e^(255*this.g|0))^(255*this.b|0))^(255*this.a|0)},e.prototype.clone=function(){return new e(this.r,this.g,this.b,this.a)},e.prototype.copyFrom=function(e){return this.r=e.r,this.g=e.g,this.b=e.b,this.a=e.a,this},e.prototype.copyFromFloats=function(e,t,i,n){return this.r=e,this.g=t,this.b=i,this.a=n,this},e.prototype.set=function(e,t,i,n){return this.copyFromFloats(e,t,i,n)},e.prototype.toHexString=function(){var e=255*this.r|0,t=255*this.g|0,i=255*this.b|0,r=255*this.a|0;return"#"+n.a.ToHex(e)+n.a.ToHex(t)+n.a.ToHex(i)+n.a.ToHex(r)},e.prototype.toLinearSpace=function(){var t=new e;return this.toLinearSpaceToRef(t),t},e.prototype.toLinearSpaceToRef=function(e){return e.r=Math.pow(this.r,r.c),e.g=Math.pow(this.g,r.c),e.b=Math.pow(this.b,r.c),e.a=this.a,this},e.prototype.toGammaSpace=function(){var t=new e;return this.toGammaSpaceToRef(t),t},e.prototype.toGammaSpaceToRef=function(e){return e.r=Math.pow(this.r,r.b),e.g=Math.pow(this.g,r.b),e.b=Math.pow(this.b,r.b),e.a=this.a,this},e.FromHexString=function(t){if("#"!==t.substring(0,1)||9!==t.length)return new e(0,0,0,0);var i=parseInt(t.substring(1,3),16),n=parseInt(t.substring(3,5),16),r=parseInt(t.substring(5,7),16),o=parseInt(t.substring(7,9),16);return e.FromInts(i,n,r,o)},e.Lerp=function(t,i,n){var r=new e(0,0,0,0);return e.LerpToRef(t,i,n,r),r},e.LerpToRef=function(e,t,i,n){n.r=e.r+(t.r-e.r)*i,n.g=e.g+(t.g-e.g)*i,n.b=e.b+(t.b-e.b)*i,n.a=e.a+(t.a-e.a)*i},e.FromColor3=function(t,i){return void 0===i&&(i=1),new e(t.r,t.g,t.b,i)},e.FromArray=function(t,i){return void 0===i&&(i=0),new e(t[i],t[i+1],t[i+2],t[i+3])},e.FromInts=function(t,i,n,r){return new e(t/255,i/255,n/255,r/255)},e.CheckColors4=function(e,t){if(e.length===3*t){for(var i=[],n=0;n<e.length;n+=3){var r=n/3*4;i[r]=e[n],i[r+1]=e[n+1],i[r+2]=e[n+2],i[r+3]=1}return i}return e},e}(),l=function(){function e(){}return e.Color3=o.a.BuildArray(3,s.Black),e.Color4=o.a.BuildArray(3,function(){return new c(0,0,0,0)}),e}();a.a.RegisteredTypes["BABYLON.Color3"]=s,a.a.RegisteredTypes["BABYLON.Color4"]=c},function(e,t,i){"use strict";var n=i(1),r=i(6),o=i(38),a=i(23),s=i(19),c=i(31),l=i(2),u=i(132),h=i(51),d=i(84),f=i(7);c.a.prototype.setAlphaConstants=function(e,t,i,n){this._alphaState.setAlphaBlendConstants(e,t,i,n)},c.a.prototype.setAlphaMode=function(e,t){if(void 0===t&&(t=!1),this._alphaMode!==e){switch(e){case l.a.ALPHA_DISABLE:this._alphaState.alphaBlend=!1;break;case l.a.ALPHA_PREMULTIPLIED:this._alphaState.setAlphaBlendFunctionParameters(this._gl.ONE,this._gl.ONE_MINUS_SRC_ALPHA,this._gl.ONE,this._gl.ONE),this._alphaState.alphaBlend=!0;break;case l.a.ALPHA_PREMULTIPLIED_PORTERDUFF:this._alphaState.setAlphaBlendFunctionParameters(this._gl.ONE,this._gl.ONE_MINUS_SRC_ALPHA,this._gl.ONE,this._gl.ONE_MINUS_SRC_ALPHA),this._alphaState.alphaBlend=!0;break;case l.a.ALPHA_COMBINE:this._alphaState.setAlphaBlendFunctionParameters(this._gl.SRC_ALPHA,this._gl.ONE_MINUS_SRC_ALPHA,this._gl.ONE,this._gl.ONE),this._alphaState.alphaBlend=!0;break;case l.a.ALPHA_ONEONE:this._alphaState.setAlphaBlendFunctionParameters(this._gl.ONE,this._gl.ONE,this._gl.ZERO,this._gl.ONE),this._alphaState.alphaBlend=!0;break;case l.a.ALPHA_ADD:this._alphaState.setAlphaBlendFunctionParameters(this._gl.SRC_ALPHA,this._gl.ONE,this._gl.ZERO,this._gl.ONE),this._alphaState.alphaBlend=!0;break;case l.a.ALPHA_SUBTRACT:this._alphaState.setAlphaBlendFunctionParameters(this._gl.ZERO,this._gl.ONE_MINUS_SRC_COLOR,this._gl.ONE,this._gl.ONE),this._alphaState.alphaBlend=!0;break;case l.a.ALPHA_MULTIPLY:this._alphaState.setAlphaBlendFunctionParameters(this._gl.DST_COLOR,this._gl.ZERO,this._gl.ONE,this._gl.ONE),this._alphaState.alphaBlend=!0;break;case l.a.ALPHA_MAXIMIZED:this._alphaState.setAlphaBlendFunctionParameters(this._gl.SRC_ALPHA,this._gl.ONE_MINUS_SRC_COLOR,this._gl.ONE,this._gl.ONE),this._alphaState.alphaBlend=!0;break;case l.a.ALPHA_INTERPOLATE:this._alphaState.setAlphaBlendFunctionParameters(this._gl.CONSTANT_COLOR,this._gl.ONE_MINUS_CONSTANT_COLOR,this._gl.CONSTANT_ALPHA,this._gl.ONE_MINUS_CONSTANT_ALPHA),this._alphaState.alphaBlend=!0;break;case l.a.ALPHA_SCREENMODE:this._alphaState.setAlphaBlendFunctionParameters(this._gl.ONE,this._gl.ONE_MINUS_SRC_COLOR,this._gl.ONE,this._gl.ONE_MINUS_SRC_ALPHA),this._alphaState.alphaBlend=!0;break;case l.a.ALPHA_ONEONE_ONEONE:this._alphaState.setAlphaBlendFunctionParameters(this._gl.ONE,this._gl.ONE,this._gl.ONE,this._gl.ONE),this._alphaState.alphaBlend=!0;break;case l.a.ALPHA_ALPHATOCOLOR:this._alphaState.setAlphaBlendFunctionParameters(this._gl.DST_ALPHA,this._gl.ONE,this._gl.ZERO,this._gl.ZERO),this._alphaState.alphaBlend=!0;break;case l.a.ALPHA_REVERSEONEMINUS:this._alphaState.setAlphaBlendFunctionParameters(this._gl.ONE_MINUS_DST_COLOR,this._gl.ONE_MINUS_SRC_COLOR,this._gl.ONE_MINUS_DST_ALPHA,this._gl.ONE_MINUS_SRC_ALPHA),this._alphaState.alphaBlend=!0;break;case l.a.ALPHA_SRC_DSTONEMINUSSRCALPHA:this._alphaState.setAlphaBlendFunctionParameters(this._gl.ONE,this._gl.ONE_MINUS_SRC_ALPHA,this._gl.ONE,this._gl.ONE_MINUS_SRC_ALPHA),this._alphaState.alphaBlend=!0;break;case l.a.ALPHA_ONEONE_ONEZERO:this._alphaState.setAlphaBlendFunctionParameters(this._gl.ONE,this._gl.ONE,this._gl.ONE,this._gl.ZERO),this._alphaState.alphaBlend=!0;break;case l.a.ALPHA_EXCLUSION:this._alphaState.setAlphaBlendFunctionParameters(this._gl.ONE_MINUS_DST_COLOR,this._gl.ONE_MINUS_SRC_COLOR,this._gl.ZERO,this._gl.ONE),this._alphaState.alphaBlend=!0}t||(this.depthCullingState.depthMask=e===l.a.ALPHA_DISABLE),this._alphaMode=e}},c.a.prototype.getAlphaMode=function(){return this._alphaMode},c.a.prototype.setAlphaEquation=function(e){if(this._alphaEquation!==e){switch(e){case l.a.ALPHA_EQUATION_ADD:this._alphaState.setAlphaEquationParameters(this._gl.FUNC_ADD,this._gl.FUNC_ADD);break;case l.a.ALPHA_EQUATION_SUBSTRACT:this._alphaState.setAlphaEquationParameters(this._gl.FUNC_SUBTRACT,this._gl.FUNC_SUBTRACT);break;case l.a.ALPHA_EQUATION_REVERSE_SUBTRACT:this._alphaState.setAlphaEquationParameters(this._gl.FUNC_REVERSE_SUBTRACT,this._gl.FUNC_REVERSE_SUBTRACT);break;case l.a.ALPHA_EQUATION_MAX:this._alphaState.setAlphaEquationParameters(this._gl.MAX,this._gl.MAX);break;case l.a.ALPHA_EQUATION_MIN:this._alphaState.setAlphaEquationParameters(this._gl.MIN,this._gl.MIN);break;case l.a.ALPHA_EQUATION_DARKEN:this._alphaState.setAlphaEquationParameters(this._gl.MIN,this._gl.FUNC_ADD)}this._alphaEquation=e}},c.a.prototype.getAlphaEquation=function(){return this._alphaEquation},i.d(t,"a",function(){return p});var p=function(e){function t(i,n,a,s){void 0===s&&(s=!1);var c=e.call(this,i,n,a,s)||this;if(c.enableOfflineSupport=!1,c.disableManifestCheck=!1,c.scenes=new Array,c.onNewSceneAddedObservable=new r.c,c.postProcesses=new Array,c.isPointerLock=!1,c.onResizeObservable=new r.c,c.onCanvasBlurObservable=new r.c,c.onCanvasFocusObservable=new r.c,c.onCanvasPointerOutObservable=new r.c,c.onBeginFrameObservable=new r.c,c.customAnimationFrameRequester=null,c.onEndFrameObservable=new r.c,c.onBeforeShaderCompilationObservable=new r.c,c.onAfterShaderCompilationObservable=new r.c,c._deterministicLockstep=!1,c._lockstepMaxSteps=4,c._timeStep=1/60,c._fps=60,c._deltaTime=0,c._drawCalls=new h.a,c.canvasTabIndex=1,c.disablePerformanceMonitorInBackground=!1,c._performanceMonitor=new u.a,!i)return c;if(a=c._creationOptions,t.Instances.push(c),i.getContext){var l=i;if(c._onCanvasFocus=function(){c.onCanvasFocusObservable.notifyObservers(c)},c._onCanvasBlur=function(){c.onCanvasBlurObservable.notifyObservers(c)},l.addEventListener("focus",c._onCanvasFocus),l.addEventListener("blur",c._onCanvasBlur),c._onBlur=function(){c.disablePerformanceMonitorInBackground&&c._performanceMonitor.disable(),c._windowIsBackground=!0},c._onFocus=function(){c.disablePerformanceMonitorInBackground&&c._performanceMonitor.enable(),c._windowIsBackground=!1},c._onCanvasPointerOut=function(e){c.onCanvasPointerOutObservable.notifyObservers(e)},l.addEventListener("pointerout",c._onCanvasPointerOut),o.a.IsWindowObjectExist()){var d=c.getHostWindow();d.addEventListener("blur",c._onBlur),d.addEventListener("focus",c._onFocus);var f=document;c._onFullscreenChange=function(){void 0!==f.fullscreen?c.isFullscreen=f.fullscreen:void 0!==f.mozFullScreen?c.isFullscreen=f.mozFullScreen:void 0!==f.webkitIsFullScreen?c.isFullscreen=f.webkitIsFullScreen:void 0!==f.msIsFullScreen&&(c.isFullscreen=f.msIsFullScreen),c.isFullscreen&&c._pointerLockRequested&&l&&t._RequestPointerlock(l)},document.addEventListener("fullscreenchange",c._onFullscreenChange,!1),document.addEventListener("mozfullscreenchange",c._onFullscreenChange,!1),document.addEventListener("webkitfullscreenchange",c._onFullscreenChange,!1),document.addEventListener("msfullscreenchange",c._onFullscreenChange,!1),c._onPointerLockChange=function(){c.isPointerLock=f.mozPointerLockElement===l||f.webkitPointerLockElement===l||f.msPointerLockElement===l||f.pointerLockElement===l},document.addEventListener("pointerlockchange",c._onPointerLockChange,!1),document.addEventListener("mspointerlockchange",c._onPointerLockChange,!1),document.addEventListener("mozpointerlockchange",c._onPointerLockChange,!1),document.addEventListener("webkitpointerlockchange",c._onPointerLockChange,!1),!t.audioEngine&&a.audioEngine&&t.AudioEngineFactory&&(t.audioEngine=t.AudioEngineFactory(c.getRenderingCanvas()))}c._connectVREvents(),c.enableOfflineSupport=void 0!==t.OfflineProviderFactory,a.doNotHandleTouchAction||c._disableTouchAction(),c._deterministicLockstep=!!a.deterministicLockstep,c._lockstepMaxSteps=a.lockstepMaxSteps||0,c._timeStep=a.timeStep||1/60}return c._prepareVRComponent(),a.autoEnableWebVR&&c.initWebVR(),c}return Object(n.d)(t,e),Object.defineProperty(t,"NpmPackage",{get:function(){return c.a.NpmPackage},enumerable:!0,configurable:!0}),Object.defineProperty(t,"Version",{get:function(){return c.a.Version},enumerable:!0,configurable:!0}),Object.defineProperty(t,"Instances",{get:function(){return a.a.Instances},enumerable:!0,configurable:!0}),Object.defineProperty(t,"LastCreatedEngine",{get:function(){return a.a.LastCreatedEngine},enumerable:!0,configurable:!0}),Object.defineProperty(t,"LastCreatedScene",{get:function(){return a.a.LastCreatedScene},enumerable:!0,configurable:!0}),t.MarkAllMaterialsAsDirty=function(e,i){for(var n=0;n<t.Instances.length;n++)for(var r=t.Instances[n],o=0;o<r.scenes.length;o++)r.scenes[o].markAllMaterialsAsDirty(e,i)},t.DefaultLoadingScreenFactory=function(e){throw s.a.WarnImport("LoadingScreen")},Object.defineProperty(t.prototype,"_supportsHardwareTextureRescaling",{get:function(){return!!t._RescalePostProcessFactory},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"performanceMonitor",{get:function(){return this._performanceMonitor},enumerable:!0,configurable:!0}),t.prototype.getInputElement=function(){return this._renderingCanvas},t.prototype.getAspectRatio=function(e,t){void 0===t&&(t=!1);var i=e.viewport;return this.getRenderWidth(t)*i.width/(this.getRenderHeight(t)*i.height)},t.prototype.getScreenAspectRatio=function(){return this.getRenderWidth(!0)/this.getRenderHeight(!0)},t.prototype.getRenderingCanvasClientRect=function(){return this._renderingCanvas?this._renderingCanvas.getBoundingClientRect():null},t.prototype.getInputElementClientRect=function(){return this._renderingCanvas?this.getInputElement().getBoundingClientRect():null},t.prototype.isDeterministicLockStep=function(){return this._deterministicLockstep},t.prototype.getLockstepMaxSteps=function(){return this._lockstepMaxSteps},t.prototype.getTimeStep=function(){return 1e3*this._timeStep},t.prototype.generateMipMapsForCubemap=function(e,t){if(void 0===t&&(t=!0),e.generateMipMaps){var i=this._gl;this._bindTextureDirectly(i.TEXTURE_CUBE_MAP,e,!0),i.generateMipmap(i.TEXTURE_CUBE_MAP),t&&this._bindTextureDirectly(i.TEXTURE_CUBE_MAP,null)}},t.prototype.setState=function(e,t,i,n){void 0===t&&(t=0),void 0===n&&(n=!1),(this._depthCullingState.cull!==e||i)&&(this._depthCullingState.cull=e);var r=this.cullBackFaces?this._gl.BACK:this._gl.FRONT;(this._depthCullingState.cullFace!==r||i)&&(this._depthCullingState.cullFace=r),this.setZOffset(t);var o=n?this._gl.CW:this._gl.CCW;(this._depthCullingState.frontFace!==o||i)&&(this._depthCullingState.frontFace=o)},t.prototype.setZOffset=function(e){this._depthCullingState.zOffset=e},t.prototype.getZOffset=function(){return this._depthCullingState.zOffset},t.prototype.setDepthBuffer=function(e){this._depthCullingState.depthTest=e},t.prototype.getDepthWrite=function(){return this._depthCullingState.depthMask},t.prototype.setDepthWrite=function(e){this._depthCullingState.depthMask=e},t.prototype.getStencilBuffer=function(){return this._stencilState.stencilTest},t.prototype.setStencilBuffer=function(e){this._stencilState.stencilTest=e},t.prototype.getStencilMask=function(){return this._stencilState.stencilMask},t.prototype.setStencilMask=function(e){this._stencilState.stencilMask=e},t.prototype.getStencilFunction=function(){return this._stencilState.stencilFunc},t.prototype.getStencilFunctionReference=function(){return this._stencilState.stencilFuncRef},t.prototype.getStencilFunctionMask=function(){return this._stencilState.stencilFuncMask},t.prototype.setStencilFunction=function(e){this._stencilState.stencilFunc=e},t.prototype.setStencilFunctionReference=function(e){this._stencilState.stencilFuncRef=e},t.prototype.setStencilFunctionMask=function(e){this._stencilState.stencilFuncMask=e},t.prototype.getStencilOperationFail=function(){return this._stencilState.stencilOpStencilFail},t.prototype.getStencilOperationDepthFail=function(){return this._stencilState.stencilOpDepthFail},t.prototype.getStencilOperationPass=function(){return this._stencilState.stencilOpStencilDepthPass},t.prototype.setStencilOperationFail=function(e){this._stencilState.stencilOpStencilFail=e},t.prototype.setStencilOperationDepthFail=function(e){this._stencilState.stencilOpDepthFail=e},t.prototype.setStencilOperationPass=function(e){this._stencilState.stencilOpStencilDepthPass=e},t.prototype.setDitheringState=function(e){e?this._gl.enable(this._gl.DITHER):this._gl.disable(this._gl.DITHER)},t.prototype.setRasterizerState=function(e){e?this._gl.disable(this._gl.RASTERIZER_DISCARD):this._gl.enable(this._gl.RASTERIZER_DISCARD)},t.prototype.getDepthFunction=function(){return this._depthCullingState.depthFunc},t.prototype.setDepthFunction=function(e){this._depthCullingState.depthFunc=e},t.prototype.setDepthFunctionToGreater=function(){this._depthCullingState.depthFunc=this._gl.GREATER},t.prototype.setDepthFunctionToGreaterOrEqual=function(){this._depthCullingState.depthFunc=this._gl.GEQUAL},t.prototype.setDepthFunctionToLess=function(){this._depthCullingState.depthFunc=this._gl.LESS},t.prototype.setDepthFunctionToLessOrEqual=function(){this._depthCullingState.depthFunc=this._gl.LEQUAL},t.prototype.cacheStencilState=function(){this._cachedStencilBuffer=this.getStencilBuffer(),this._cachedStencilFunction=this.getStencilFunction(),this._cachedStencilMask=this.getStencilMask(),this._cachedStencilOperationPass=this.getStencilOperationPass(),this._cachedStencilOperationFail=this.getStencilOperationFail(),this._cachedStencilOperationDepthFail=this.getStencilOperationDepthFail(),this._cachedStencilReference=this.getStencilFunctionReference()},t.prototype.restoreStencilState=function(){this.setStencilFunction(this._cachedStencilFunction),this.setStencilMask(this._cachedStencilMask),this.setStencilBuffer(this._cachedStencilBuffer),this.setStencilOperationPass(this._cachedStencilOperationPass),this.setStencilOperationFail(this._cachedStencilOperationFail),this.setStencilOperationDepthFail(this._cachedStencilOperationDepthFail),this.setStencilFunctionReference(this._cachedStencilReference)},t.prototype.setDirectViewport=function(e,t,i,n){var r=this._cachedViewport;return this._cachedViewport=null,this._viewport(e,t,i,n),r},t.prototype.scissorClear=function(e,t,i,n,r){this.enableScissor(e,t,i,n),this.clear(r,!0,!0,!0),this.disableScissor()},t.prototype.enableScissor=function(e,t,i,n){var r=this._gl;r.enable(r.SCISSOR_TEST),r.scissor(e,t,i,n)},t.prototype.disableScissor=function(){var e=this._gl;e.disable(e.SCISSOR_TEST)},t.prototype._reportDrawCall=function(){this._drawCalls.addCount(1,!1)},t.prototype.initWebVR=function(){throw s.a.WarnImport("WebVRCamera")},t.prototype._prepareVRComponent=function(){},t.prototype._connectVREvents=function(e,t){},t.prototype._submitVRFrame=function(){},t.prototype.disableVR=function(){},t.prototype.isVRPresenting=function(){return!1},t.prototype._requestVRFrame=function(){},t.prototype._loadFileAsync=function(e,t,i){var n=this;return new Promise(function(r,o){n._loadFile(e,function(e){r(e)},void 0,t,i,function(e,t){o(t)})})},t.prototype.getVertexShaderSource=function(e){var t=this._gl.getAttachedShaders(e);return t?this._gl.getShaderSource(t[0]):null},t.prototype.getFragmentShaderSource=function(e){var t=this._gl.getAttachedShaders(e);return t?this._gl.getShaderSource(t[1]):null},t.prototype.setDepthStencilTexture=function(e,t,i){void 0!==e&&(t&&(this._boundUniforms[e]=t),i&&i.depthStencilTexture?this._setTexture(e,i,!1,!0):this._setTexture(e,null))},t.prototype.setTextureFromPostProcess=function(e,t){this._bindTexture(e,t?t._textures.data[t._currentRenderTextureInd]:null)},t.prototype.setTextureFromPostProcessOutput=function(e,t){this._bindTexture(e,t?t._outputTexture:null)},t.prototype._convertRGBtoRGBATextureData=function(e,t,i,n){var r;r=n===l.a.TEXTURETYPE_FLOAT?new Float32Array(t*i*4):new Uint32Array(t*i*4);for(var o=0;o<t;o++)for(var a=0;a<i;a++){var s=3*(a*t+o),c=4*(a*t+o);r[c+0]=e[s+0],r[c+1]=e[s+1],r[c+2]=e[s+2],r[c+3]=1}return r},t.prototype._rebuildBuffers=function(){for(var t=0,i=this.scenes;t<i.length;t++){var n=i[t];n.resetCachedMaterial(),n._rebuildGeometries(),n._rebuildTextures()}e.prototype._rebuildBuffers.call(this)},t.prototype._renderFrame=function(){for(var e=0;e<this._activeRenderLoops.length;e++){(0,this._activeRenderLoops[e])()}},t.prototype._renderLoop=function(){if(!this._contextWasLost){var e=!0;!this.renderEvenInBackground&&this._windowIsBackground&&(e=!1),e&&(this.beginFrame(),this._renderViews()||this._renderFrame(),this.endFrame())}this._activeRenderLoops.length>0?this.customAnimationFrameRequester?(this.customAnimationFrameRequester.requestID=this._queueNewFrame(this.customAnimationFrameRequester.renderFunction||this._boundRenderFunction,this.customAnimationFrameRequester),this._frameHandler=this.customAnimationFrameRequester.requestID):this.isVRPresenting()?this._requestVRFrame():this._frameHandler=this._queueNewFrame(this._boundRenderFunction,this.getHostWindow()):this._renderingQueueLaunched=!1},t.prototype._renderViews=function(){return!1},t.prototype.switchFullscreen=function(e){this.isFullscreen?this.exitFullscreen():this.enterFullscreen(e)},t.prototype.enterFullscreen=function(e){this.isFullscreen||(this._pointerLockRequested=e,this._renderingCanvas&&t._RequestFullscreen(this._renderingCanvas))},t.prototype.exitFullscreen=function(){this.isFullscreen&&t._ExitFullscreen()},t.prototype.enterPointerlock=function(){this._renderingCanvas&&t._RequestPointerlock(this._renderingCanvas)},t.prototype.exitPointerlock=function(){t._ExitPointerlock()},t.prototype.beginFrame=function(){this._measureFps(),this.onBeginFrameObservable.notifyObservers(this),e.prototype.beginFrame.call(this)},t.prototype.endFrame=function(){e.prototype.endFrame.call(this),this._submitVRFrame(),this.onEndFrameObservable.notifyObservers(this)},t.prototype.resize=function(){this.isVRPresenting()||e.prototype.resize.call(this)},t.prototype.setSize=function(t,i){if(this._renderingCanvas&&(e.prototype.setSize.call(this,t,i),this.scenes)){for(var n=0;n<this.scenes.length;n++)for(var r=this.scenes[n],o=0;o<r.cameras.length;o++){r.cameras[o]._currentRenderId=0}this.onResizeObservable.hasObservers&&this.onResizeObservable.notifyObservers(this)}},t.prototype.updateDynamicVertexBuffer=function(e,t,i,n){this.bindArrayBuffer(e),void 0===i&&(i=0);var r=t.length||t.byteLength;void 0===n||n>=r&&0===i?t instanceof Array?this._gl.bufferSubData(this._gl.ARRAY_BUFFER,i,new Float32Array(t)):this._gl.bufferSubData(this._gl.ARRAY_BUFFER,i,t):t instanceof Array?this._gl.bufferSubData(this._gl.ARRAY_BUFFER,0,new Float32Array(t).subarray(i,i+n)):(t=t instanceof ArrayBuffer?new Uint8Array(t,i,n):new Uint8Array(t.buffer,t.byteOffset+i,n),this._gl.bufferSubData(this._gl.ARRAY_BUFFER,0,t)),this._resetVertexBufferBinding()},t.prototype._deletePipelineContext=function(t){var i=t;i&&i.program&&i.transformFeedback&&(this.deleteTransformFeedback(i.transformFeedback),i.transformFeedback=null),e.prototype._deletePipelineContext.call(this,t)},t.prototype.createShaderProgram=function(t,i,n,r,o,a){void 0===a&&(a=null),o=o||this._gl,this.onBeforeShaderCompilationObservable.notifyObservers(this);var s=e.prototype.createShaderProgram.call(this,t,i,n,r,o,a);return this.onAfterShaderCompilationObservable.notifyObservers(this),s},t.prototype._createShaderProgram=function(e,t,i,n,r){void 0===r&&(r=null);var o=n.createProgram();if(e.program=o,!o)throw new Error("Unable to create program");if(n.attachShader(o,t),n.attachShader(o,i),this.webGLVersion>1&&r){var a=this.createTransformFeedback();this.bindTransformFeedback(a),this.setTranformFeedbackVaryings(o,r),e.transformFeedback=a}return n.linkProgram(o),this.webGLVersion>1&&r&&this.bindTransformFeedback(null),e.context=n,e.vertexShader=t,e.fragmentShader=i,e.isParallelCompiled||this._finalizePipelineContext(e),o},t.prototype._releaseTexture=function(t){e.prototype._releaseTexture.call(this,t),this.scenes.forEach(function(e){e.postProcesses.forEach(function(e){e._outputTexture==t&&(e._outputTexture=null)}),e.cameras.forEach(function(e){e._postProcesses.forEach(function(e){e&&e._outputTexture==t&&(e._outputTexture=null)})})})},t.prototype._rescaleTexture=function(e,i,n,r,o){var a=this;this._gl.texParameteri(this._gl.TEXTURE_2D,this._gl.TEXTURE_MAG_FILTER,this._gl.LINEAR),this._gl.texParameteri(this._gl.TEXTURE_2D,this._gl.TEXTURE_MIN_FILTER,this._gl.LINEAR),this._gl.texParameteri(this._gl.TEXTURE_2D,this._gl.TEXTURE_WRAP_S,this._gl.CLAMP_TO_EDGE),this._gl.texParameteri(this._gl.TEXTURE_2D,this._gl.TEXTURE_WRAP_T,this._gl.CLAMP_TO_EDGE);var s=this.createRenderTargetTexture({width:i.width,height:i.height},{generateMipMaps:!1,type:l.a.TEXTURETYPE_UNSIGNED_INT,samplingMode:l.a.TEXTURE_BILINEAR_SAMPLINGMODE,generateDepthBuffer:!1,generateStencilBuffer:!1});!this._rescalePostProcess&&t._RescalePostProcessFactory&&(this._rescalePostProcess=t._RescalePostProcessFactory(this)),this._rescalePostProcess.getEffect().executeWhenCompiled(function(){a._rescalePostProcess.onApply=function(t){t._bindTexture("textureSampler",e)};var t=n;t||(t=a.scenes[a.scenes.length-1]),t.postProcessManager.directRender([a._rescalePostProcess],s,!0),a._bindTextureDirectly(a._gl.TEXTURE_2D,i,!0),a._gl.copyTexImage2D(a._gl.TEXTURE_2D,0,r,0,0,i.width,i.height,0),a.unBindFramebuffer(s),a._releaseTexture(s),o&&o()})},t.prototype.getFps=function(){return this._fps},t.prototype.getDeltaTime=function(){return this._deltaTime},t.prototype._measureFps=function(){this._performanceMonitor.sampleFrame(),this._fps=this._performanceMonitor.averageFPS,this._deltaTime=this._performanceMonitor.instantaneousFrameTime||0},t.prototype._uploadImageToTexture=function(e,t,i,n){void 0===i&&(i=0),void 0===n&&(n=0);var r=this._gl,o=this._getWebGLTextureType(e.type),a=this._getInternalFormat(e.format),s=this._getRGBABufferInternalSizedFormat(e.type,a),c=e.isCube?r.TEXTURE_CUBE_MAP:r.TEXTURE_2D;this._bindTextureDirectly(c,e,!0),this._unpackFlipY(e.invertY);var l=r.TEXTURE_2D;e.isCube&&(l=r.TEXTURE_CUBE_MAP_POSITIVE_X+i),r.texImage2D(l,n,s,a,o,t),this._bindTextureDirectly(c,null,!0)},t.prototype.updateDynamicIndexBuffer=function(e,t,i){var n;void 0===i&&(i=0),this._currentBoundBuffer[this._gl.ELEMENT_ARRAY_BUFFER]=null,this.bindIndexBuffer(e),n=t instanceof Uint16Array||t instanceof Uint32Array?t:e.is32Bits?new Uint32Array(t):new Uint16Array(t),this._gl.bufferData(this._gl.ELEMENT_ARRAY_BUFFER,n,this._gl.DYNAMIC_DRAW),this._resetIndexBufferBinding()},t.prototype.updateRenderTargetTextureSampleCount=function(e,t){if(this.webGLVersion<2||!e)return 1;if(e.samples===t)return t;var i=this._gl;if(t=Math.min(t,this.getCaps().maxMSAASamples),e._depthStencilBuffer&&(i.deleteRenderbuffer(e._depthStencilBuffer),e._depthStencilBuffer=null),e._MSAAFramebuffer&&(i.deleteFramebuffer(e._MSAAFramebuffer),e._MSAAFramebuffer=null),e._MSAARenderBuffer&&(i.deleteRenderbuffer(e._MSAARenderBuffer),e._MSAARenderBuffer=null),t>1&&i.renderbufferStorageMultisample){var n=i.createFramebuffer();if(!n)throw new Error("Unable to create multi sampled framebuffer");e._MSAAFramebuffer=n,this._bindUnboundFramebuffer(e._MSAAFramebuffer);var r=i.createRenderbuffer();if(!r)throw new Error("Unable to create multi sampled framebuffer");i.bindRenderbuffer(i.RENDERBUFFER,r),i.renderbufferStorageMultisample(i.RENDERBUFFER,t,this._getRGBAMultiSampleBufferFormat(e.type),e.width,e.height),i.framebufferRenderbuffer(i.FRAMEBUFFER,i.COLOR_ATTACHMENT0,i.RENDERBUFFER,r),e._MSAARenderBuffer=r}else this._bindUnboundFramebuffer(e._framebuffer);return e.samples=t,e._depthStencilBuffer=this._setupFramebufferDepthAttachments(e._generateStencilBuffer,e._generateDepthBuffer,e.width,e.height,t),this._bindUnboundFramebuffer(null),t},t.prototype.updateTextureComparisonFunction=function(e,t){if(1!==this.webGLVersion){var i=this._gl;e.isCube?(this._bindTextureDirectly(this._gl.TEXTURE_CUBE_MAP,e,!0),0===t?(i.texParameteri(i.TEXTURE_CUBE_MAP,i.TEXTURE_COMPARE_FUNC,l.a.LEQUAL),i.texParameteri(i.TEXTURE_CUBE_MAP,i.TEXTURE_COMPARE_MODE,i.NONE)):(i.texParameteri(i.TEXTURE_CUBE_MAP,i.TEXTURE_COMPARE_FUNC,t),i.texParameteri(i.TEXTURE_CUBE_MAP,i.TEXTURE_COMPARE_MODE,i.COMPARE_REF_TO_TEXTURE)),this._bindTextureDirectly(this._gl.TEXTURE_CUBE_MAP,null)):(this._bindTextureDirectly(this._gl.TEXTURE_2D,e,!0),0===t?(i.texParameteri(i.TEXTURE_2D,i.TEXTURE_COMPARE_FUNC,l.a.LEQUAL),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_COMPARE_MODE,i.NONE)):(i.texParameteri(i.TEXTURE_2D,i.TEXTURE_COMPARE_FUNC,t),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_COMPARE_MODE,i.COMPARE_REF_TO_TEXTURE)),this._bindTextureDirectly(this._gl.TEXTURE_2D,null)),e._comparisonFunction=t}else f.a.Error("WebGL 1 does not support texture comparison.")},t.prototype.createInstancesBuffer=function(e){var t=this._gl.createBuffer();if(!t)throw new Error("Unable to create instance buffer");var i=new d.a(t);return i.capacity=e,this.bindArrayBuffer(i),this._gl.bufferData(this._gl.ARRAY_BUFFER,e,this._gl.DYNAMIC_DRAW),i},t.prototype.deleteInstancesBuffer=function(e){this._gl.deleteBuffer(e)},t.prototype._clientWaitAsync=function(e,t,i){void 0===t&&(t=0),void 0===i&&(i=10);var n=this._gl;return new Promise(function(r,o){var a=function(){var s=n.clientWaitSync(e,t,0);s!=n.WAIT_FAILED?s!=n.TIMEOUT_EXPIRED?r():setTimeout(a,i):o()};a()})},t.prototype._readPixelsAsync=function(e,t,i,n,r,o,a){if(this._webGLVersion<2)throw new Error("_readPixelsAsync only work on WebGL2+");var s=this._gl,c=s.createBuffer();s.bindBuffer(s.PIXEL_PACK_BUFFER,c),s.bufferData(s.PIXEL_PACK_BUFFER,a.byteLength,s.STREAM_READ),s.readPixels(e,t,i,n,r,o,0),s.bindBuffer(s.PIXEL_PACK_BUFFER,null);var l=s.fenceSync(s.SYNC_GPU_COMMANDS_COMPLETE,0);return l?(s.flush(),this._clientWaitAsync(l,0,10).then(function(){return s.deleteSync(l),s.bindBuffer(s.PIXEL_PACK_BUFFER,c),s.getBufferSubData(s.PIXEL_PACK_BUFFER,0,a),s.bindBuffer(s.PIXEL_PACK_BUFFER,null),s.deleteBuffer(c),a})):null},t.prototype._readTexturePixels=function(e,t,i,n,r,o){void 0===n&&(n=-1),void 0===r&&(r=0),void 0===o&&(o=null);var a=this._gl;if(!this._dummyFramebuffer){var s=a.createFramebuffer();if(!s)throw new Error("Unable to create dummy framebuffer");this._dummyFramebuffer=s}a.bindFramebuffer(a.FRAMEBUFFER,this._dummyFramebuffer),n>-1?a.framebufferTexture2D(a.FRAMEBUFFER,a.COLOR_ATTACHMENT0,a.TEXTURE_CUBE_MAP_POSITIVE_X+n,e._webGLTexture,r):a.framebufferTexture2D(a.FRAMEBUFFER,a.COLOR_ATTACHMENT0,a.TEXTURE_2D,e._webGLTexture,r);var c=void 0!==e.type?this._getWebGLTextureType(e.type):a.UNSIGNED_BYTE;switch(c){case a.UNSIGNED_BYTE:o||(o=new Uint8Array(4*t*i)),c=a.UNSIGNED_BYTE;break;default:o||(o=new Float32Array(4*t*i)),c=a.FLOAT}return a.readPixels(0,0,t,i,a.RGBA,c,o),a.bindFramebuffer(a.FRAMEBUFFER,this._currentFramebuffer),o},t.prototype.dispose=function(){for(this.hideLoadingUI(),this.onNewSceneAddedObservable.clear();this.postProcesses.length;)this.postProcesses[0].dispose();for(this._rescalePostProcess&&this._rescalePostProcess.dispose();this.scenes.length;)this.scenes[0].dispose();1===t.Instances.length&&t.audioEngine&&t.audioEngine.dispose(),this._dummyFramebuffer&&this._gl.deleteFramebuffer(this._dummyFramebuffer),this.disableVR(),o.a.IsWindowObjectExist()&&(window.removeEventListener("blur",this._onBlur),window.removeEventListener("focus",this._onFocus),this._renderingCanvas&&(this._renderingCanvas.removeEventListener("focus",this._onCanvasFocus),this._renderingCanvas.removeEventListener("blur",this._onCanvasBlur),this._renderingCanvas.removeEventListener("pointerout",this._onCanvasPointerOut)),document.removeEventListener("fullscreenchange",this._onFullscreenChange),document.removeEventListener("mozfullscreenchange",this._onFullscreenChange),document.removeEventListener("webkitfullscreenchange",this._onFullscreenChange),document.removeEventListener("msfullscreenchange",this._onFullscreenChange),document.removeEventListener("pointerlockchange",this._onPointerLockChange),document.removeEventListener("mspointerlockchange",this._onPointerLockChange),document.removeEventListener("mozpointerlockchange",this._onPointerLockChange),document.removeEventListener("webkitpointerlockchange",this._onPointerLockChange)),e.prototype.dispose.call(this);var i=t.Instances.indexOf(this);i>=0&&t.Instances.splice(i,1),this.onResizeObservable.clear(),this.onCanvasBlurObservable.clear(),this.onCanvasFocusObservable.clear(),this.onCanvasPointerOutObservable.clear(),this.onBeginFrameObservable.clear(),this.onEndFrameObservable.clear()},t.prototype._disableTouchAction=function(){this._renderingCanvas&&this._renderingCanvas.setAttribute&&(this._renderingCanvas.setAttribute("touch-action","none"),this._renderingCanvas.style.touchAction="none",this._renderingCanvas.style.msTouchAction="none")},t.prototype.displayLoadingUI=function(){if(o.a.IsWindowObjectExist()){var e=this.loadingScreen;e&&e.displayLoadingUI()}},t.prototype.hideLoadingUI=function(){if(o.a.IsWindowObjectExist()){var e=this._loadingScreen;e&&e.hideLoadingUI()}},Object.defineProperty(t.prototype,"loadingScreen",{get:function(){return!this._loadingScreen&&this._renderingCanvas&&(this._loadingScreen=t.DefaultLoadingScreenFactory(this._renderingCanvas)),this._loadingScreen},set:function(e){this._loadingScreen=e},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"loadingUIText",{set:function(e){this.loadingScreen.loadingUIText=e},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"loadingUIBackgroundColor",{set:function(e){this.loadingScreen.loadingUIBackgroundColor=e},enumerable:!0,configurable:!0}),t._RequestPointerlock=function(e){e.requestPointerLock=e.requestPointerLock||e.msRequestPointerLock||e.mozRequestPointerLock||e.webkitRequestPointerLock,e.requestPointerLock&&e.requestPointerLock()},t._ExitPointerlock=function(){var e=document;document.exitPointerLock=document.exitPointerLock||e.msExitPointerLock||e.mozExitPointerLock||e.webkitExitPointerLock,document.exitPointerLock&&document.exitPointerLock()},t._RequestFullscreen=function(e){var t=e.requestFullscreen||e.msRequestFullscreen||e.webkitRequestFullscreen||e.mozRequestFullScreen;t&&t.call(e)},t._ExitFullscreen=function(){var e=document;document.exitFullscreen?document.exitFullscreen():e.mozCancelFullScreen?e.mozCancelFullScreen():e.webkitCancelFullScreen?e.webkitCancelFullScreen():e.msCancelFullScreen&&e.msCancelFullScreen()},t.ALPHA_DISABLE=l.a.ALPHA_DISABLE,t.ALPHA_ADD=l.a.ALPHA_ADD,t.ALPHA_COMBINE=l.a.ALPHA_COMBINE,t.ALPHA_SUBTRACT=l.a.ALPHA_SUBTRACT,t.ALPHA_MULTIPLY=l.a.ALPHA_MULTIPLY,t.ALPHA_MAXIMIZED=l.a.ALPHA_MAXIMIZED,t.ALPHA_ONEONE=l.a.ALPHA_ONEONE,t.ALPHA_PREMULTIPLIED=l.a.ALPHA_PREMULTIPLIED,t.ALPHA_PREMULTIPLIED_PORTERDUFF=l.a.ALPHA_PREMULTIPLIED_PORTERDUFF,t.ALPHA_INTERPOLATE=l.a.ALPHA_INTERPOLATE,t.ALPHA_SCREENMODE=l.a.ALPHA_SCREENMODE,t.DELAYLOADSTATE_NONE=l.a.DELAYLOADSTATE_NONE,t.DELAYLOADSTATE_LOADED=l.a.DELAYLOADSTATE_LOADED,t.DELAYLOADSTATE_LOADING=l.a.DELAYLOADSTATE_LOADING,t.DELAYLOADSTATE_NOTLOADED=l.a.DELAYLOADSTATE_NOTLOADED,t.NEVER=l.a.NEVER,t.ALWAYS=l.a.ALWAYS,t.LESS=l.a.LESS,t.EQUAL=l.a.EQUAL,t.LEQUAL=l.a.LEQUAL,t.GREATER=l.a.GREATER,t.GEQUAL=l.a.GEQUAL,t.NOTEQUAL=l.a.NOTEQUAL,t.KEEP=l.a.KEEP,t.REPLACE=l.a.REPLACE,t.INCR=l.a.INCR,t.DECR=l.a.DECR,t.INVERT=l.a.INVERT,t.INCR_WRAP=l.a.INCR_WRAP,t.DECR_WRAP=l.a.DECR_WRAP,t.TEXTURE_CLAMP_ADDRESSMODE=l.a.TEXTURE_CLAMP_ADDRESSMODE,t.TEXTURE_WRAP_ADDRESSMODE=l.a.TEXTURE_WRAP_ADDRESSMODE,t.TEXTURE_MIRROR_ADDRESSMODE=l.a.TEXTURE_MIRROR_ADDRESSMODE,t.TEXTUREFORMAT_ALPHA=l.a.TEXTUREFORMAT_ALPHA,t.TEXTUREFORMAT_LUMINANCE=l.a.TEXTUREFORMAT_LUMINANCE,t.TEXTUREFORMAT_LUMINANCE_ALPHA=l.a.TEXTUREFORMAT_LUMINANCE_ALPHA,t.TEXTUREFORMAT_RGB=l.a.TEXTUREFORMAT_RGB,t.TEXTUREFORMAT_RGBA=l.a.TEXTUREFORMAT_RGBA,t.TEXTUREFORMAT_RED=l.a.TEXTUREFORMAT_RED,t.TEXTUREFORMAT_R=l.a.TEXTUREFORMAT_R,t.TEXTUREFORMAT_RG=l.a.TEXTUREFORMAT_RG,t.TEXTUREFORMAT_RED_INTEGER=l.a.TEXTUREFORMAT_RED_INTEGER,t.TEXTUREFORMAT_R_INTEGER=l.a.TEXTUREFORMAT_R_INTEGER,t.TEXTUREFORMAT_RG_INTEGER=l.a.TEXTUREFORMAT_RG_INTEGER,t.TEXTUREFORMAT_RGB_INTEGER=l.a.TEXTUREFORMAT_RGB_INTEGER,t.TEXTUREFORMAT_RGBA_INTEGER=l.a.TEXTUREFORMAT_RGBA_INTEGER,t.TEXTURETYPE_UNSIGNED_BYTE=l.a.TEXTURETYPE_UNSIGNED_BYTE,t.TEXTURETYPE_UNSIGNED_INT=l.a.TEXTURETYPE_UNSIGNED_INT,t.TEXTURETYPE_FLOAT=l.a.TEXTURETYPE_FLOAT,t.TEXTURETYPE_HALF_FLOAT=l.a.TEXTURETYPE_HALF_FLOAT,t.TEXTURETYPE_BYTE=l.a.TEXTURETYPE_BYTE,t.TEXTURETYPE_SHORT=l.a.TEXTURETYPE_SHORT,t.TEXTURETYPE_UNSIGNED_SHORT=l.a.TEXTURETYPE_UNSIGNED_SHORT,t.TEXTURETYPE_INT=l.a.TEXTURETYPE_INT,t.TEXTURETYPE_UNSIGNED_INTEGER=l.a.TEXTURETYPE_UNSIGNED_INTEGER,t.TEXTURETYPE_UNSIGNED_SHORT_4_4_4_4=l.a.TEXTURETYPE_UNSIGNED_SHORT_4_4_4_4,t.TEXTURETYPE_UNSIGNED_SHORT_5_5_5_1=l.a.TEXTURETYPE_UNSIGNED_SHORT_5_5_5_1,t.TEXTURETYPE_UNSIGNED_SHORT_5_6_5=l.a.TEXTURETYPE_UNSIGNED_SHORT_5_6_5,t.TEXTURETYPE_UNSIGNED_INT_2_10_10_10_REV=l.a.TEXTURETYPE_UNSIGNED_INT_2_10_10_10_REV,t.TEXTURETYPE_UNSIGNED_INT_24_8=l.a.TEXTURETYPE_UNSIGNED_INT_24_8,t.TEXTURETYPE_UNSIGNED_INT_10F_11F_11F_REV=l.a.TEXTURETYPE_UNSIGNED_INT_10F_11F_11F_REV,t.TEXTURETYPE_UNSIGNED_INT_5_9_9_9_REV=l.a.TEXTURETYPE_UNSIGNED_INT_5_9_9_9_REV,t.TEXTURETYPE_FLOAT_32_UNSIGNED_INT_24_8_REV=l.a.TEXTURETYPE_FLOAT_32_UNSIGNED_INT_24_8_REV,t.TEXTURE_NEAREST_SAMPLINGMODE=l.a.TEXTURE_NEAREST_SAMPLINGMODE,t.TEXTURE_BILINEAR_SAMPLINGMODE=l.a.TEXTURE_BILINEAR_SAMPLINGMODE,t.TEXTURE_TRILINEAR_SAMPLINGMODE=l.a.TEXTURE_TRILINEAR_SAMPLINGMODE,t.TEXTURE_NEAREST_NEAREST_MIPLINEAR=l.a.TEXTURE_NEAREST_NEAREST_MIPLINEAR,t.TEXTURE_LINEAR_LINEAR_MIPNEAREST=l.a.TEXTURE_LINEAR_LINEAR_MIPNEAREST,t.TEXTURE_LINEAR_LINEAR_MIPLINEAR=l.a.TEXTURE_LINEAR_LINEAR_MIPLINEAR,t.TEXTURE_NEAREST_NEAREST_MIPNEAREST=l.a.TEXTURE_NEAREST_NEAREST_MIPNEAREST,t.TEXTURE_NEAREST_LINEAR_MIPNEAREST=l.a.TEXTURE_NEAREST_LINEAR_MIPNEAREST,t.TEXTURE_NEAREST_LINEAR_MIPLINEAR=l.a.TEXTURE_NEAREST_LINEAR_MIPLINEAR,t.TEXTURE_NEAREST_LINEAR=l.a.TEXTURE_NEAREST_LINEAR,t.TEXTURE_NEAREST_NEAREST=l.a.TEXTURE_NEAREST_NEAREST,t.TEXTURE_LINEAR_NEAREST_MIPNEAREST=l.a.TEXTURE_LINEAR_NEAREST_MIPNEAREST,t.TEXTURE_LINEAR_NEAREST_MIPLINEAR=l.a.TEXTURE_LINEAR_NEAREST_MIPLINEAR,t.TEXTURE_LINEAR_LINEAR=l.a.TEXTURE_LINEAR_LINEAR,t.TEXTURE_LINEAR_NEAREST=l.a.TEXTURE_LINEAR_NEAREST,t.TEXTURE_EXPLICIT_MODE=l.a.TEXTURE_EXPLICIT_MODE,t.TEXTURE_SPHERICAL_MODE=l.a.TEXTURE_SPHERICAL_MODE,t.TEXTURE_PLANAR_MODE=l.a.TEXTURE_PLANAR_MODE,t.TEXTURE_CUBIC_MODE=l.a.TEXTURE_CUBIC_MODE,t.TEXTURE_PROJECTION_MODE=l.a.TEXTURE_PROJECTION_MODE,t.TEXTURE_SKYBOX_MODE=l.a.TEXTURE_SKYBOX_MODE,t.TEXTURE_INVCUBIC_MODE=l.a.TEXTURE_INVCUBIC_MODE,t.TEXTURE_EQUIRECTANGULAR_MODE=l.a.TEXTURE_EQUIRECTANGULAR_MODE,t.TEXTURE_FIXED_EQUIRECTANGULAR_MODE=l.a.TEXTURE_FIXED_EQUIRECTANGULAR_MODE,t.TEXTURE_FIXED_EQUIRECTANGULAR_MIRRORED_MODE=l.a.TEXTURE_FIXED_EQUIRECTANGULAR_MIRRORED_MODE,t.SCALEMODE_FLOOR=l.a.SCALEMODE_FLOOR,t.SCALEMODE_NEAREST=l.a.SCALEMODE_NEAREST,t.SCALEMODE_CEILING=l.a.SCALEMODE_CEILING,t._RescalePostProcessFactory=null,t}(c.a)},function(e,t,i){"use strict";i.d(t,"a",function(){return n});var n=function(){function e(){}return e.GetClass=function(e){return this.RegisteredTypes&&this.RegisteredTypes[e]?this.RegisteredTypes[e]:null},e.RegisteredTypes={},e}()},function(e,t,i){"use strict";i.d(t,"b",function(){return m}),i.d(t,"c",function(){return g}),i.d(t,"a",function(){return v});var n=i(6),r=i(38),o=i(7),a=i(33),s=i(52),c=i(19),l=i(65),u=i(23),h=i(54),d=i(131),f=i(115),p=i(112),_=i(137),m=function(){function e(){}return Object.defineProperty(e,"BaseUrl",{get:function(){return h.a.BaseUrl},set:function(e){h.a.BaseUrl=e},enumerable:!0,configurable:!0}),Object.defineProperty(e,"DefaultRetryStrategy",{get:function(){return h.a.DefaultRetryStrategy},set:function(e){h.a.DefaultRetryStrategy=e},enumerable:!0,configurable:!0}),Object.defineProperty(e,"UseFallbackTexture",{get:function(){return u.a.UseFallbackTexture},set:function(e){u.a.UseFallbackTexture=e},enumerable:!0,configurable:!0}),Object.defineProperty(e,"RegisteredExternalClasses",{get:function(){return p.a.RegisteredExternalClasses},set:function(e){p.a.RegisteredExternalClasses=e},enumerable:!0,configurable:!0}),Object.defineProperty(e,"fallbackTexture",{get:function(){return u.a.FallbackTexture},set:function(e){u.a.FallbackTexture=e},enumerable:!0,configurable:!0}),e.FetchToRef=function(e,t,i,n,r,o){var a=4*((Math.abs(e)*i%i|0)+(Math.abs(t)*n%n|0)*i);o.r=r[a]/255,o.g=r[a+1]/255,o.b=r[a+2]/255,o.a=r[a+3]/255},e.Mix=function(e,t,i){return e*(1-i)+t*i},e.Instantiate=function(e){return p.a.Instantiate(e)},e.Slice=function(e,t,i){return e.slice?e.slice(t,i):Array.prototype.slice.call(e,t,i)},e.SetImmediate=function(e){f.a.SetImmediate(e)},e.IsExponentOfTwo=function(e){var t=1;do{t*=2}while(t<e);return t===e},e.FloatRound=function(t){return Math.fround?Math.fround(t):e._tmpFloatArray[0]=t},e.GetFilename=function(e){var t=e.lastIndexOf("/");return t<0?e:e.substring(t+1)},e.GetFolderPath=function(e,t){void 0===t&&(t=!1);var i=e.lastIndexOf("/");return i<0?t?e:"":e.substring(0,i+1)},e.ToDegrees=function(e){return 180*e/Math.PI},e.ToRadians=function(e){return e*Math.PI/180},e.MakeArray=function(e,t){return!0===t||void 0!==e&&null!=e?Array.isArray(e)?e:[e]:null},e.GetPointerPrefix=function(){var e="pointer";return r.a.IsWindowObjectExist()&&!window.PointerEvent&&r.a.IsNavigatorAvailable()&&!navigator.pointerEnabled&&(e="mouse"),e},e.SetCorsBehavior=function(e,t){h.a.SetCorsBehavior(e,t)},e.CleanUrl=function(e){return e=e.replace(/#/gm,"%23")},Object.defineProperty(e,"PreprocessUrl",{get:function(){return h.a.PreprocessUrl},set:function(e){h.a.PreprocessUrl=e},enumerable:!0,configurable:!0}),e.LoadImage=function(e,t,i,n,r){return h.a.LoadImage(e,t,i,n,r)},e.LoadFile=function(e,t,i,n,r,o){return h.a.LoadFile(e,t,i,n,r,o)},e.LoadFileAsync=function(e,t){return void 0===t&&(t=!0),new Promise(function(i,n){h.a.LoadFile(e,function(e){i(e)},void 0,void 0,t,function(e,t){n(t)})})},e.LoadScript=function(e,t,i,n){if(r.a.IsWindowObjectExist()){var o=document.getElementsByTagName("head")[0],a=document.createElement("script");a.setAttribute("type","text/javascript"),a.setAttribute("src",e),n&&(a.id=n),a.onload=function(){t&&t()},a.onerror=function(t){i&&i("Unable to load script '"+e+"'",t)},o.appendChild(a)}},e.LoadScriptAsync=function(e,t){var i=this;return new Promise(function(t,n){i.LoadScript(e,function(){t()},function(e,t){n(t)})})},e.ReadFileAsDataURL=function(e,t,i){var r=new FileReader,o={onCompleteObservable:new n.c,abort:function(){return r.abort()}};return r.onloadend=function(e){o.onCompleteObservable.notifyObservers(o)},r.onload=function(e){t(e.target.result)},r.onprogress=i,r.readAsDataURL(e),o},e.ReadFile=function(e,t,i,n,r){return h.a.ReadFile(e,t,i,n,r)},e.FileAsURL=function(e){var t=new Blob([e]);return(window.URL||window.webkitURL).createObjectURL(t)},e.Format=function(e,t){return void 0===t&&(t=2),e.toFixed(t)},e.DeepCopy=function(e,t,i,n){a.a.DeepCopy(e,t,i,n)},e.IsEmpty=function(e){for(var t in e)if(e.hasOwnProperty(t))return!1;return!0},e.RegisterTopRootEvents=function(e,t){for(var i=0;i<t.length;i++){var n=t[i];e.addEventListener(n.name,n.handler,!1);try{window.parent&&window.parent.addEventListener(n.name,n.handler,!1)}catch(e){}}},e.UnregisterTopRootEvents=function(e,t){for(var i=0;i<t.length;i++){var n=t[i];e.removeEventListener(n.name,n.handler);try{e.parent&&e.parent.removeEventListener(n.name,n.handler)}catch(e){}}},e.DumpFramebuffer=function(t,i,n,r,o,a){void 0===o&&(o="image/png");for(var s=4*t,c=i/2,l=n.readPixels(0,0,t,i),u=0;u<c;u++)for(var h=0;h<s;h++){var d=h+u*s,f=h+(i-u-1)*s,p=l[d];l[d]=l[f],l[f]=p}e._ScreenshotCanvas||(e._ScreenshotCanvas=document.createElement("canvas")),e._ScreenshotCanvas.width=t,e._ScreenshotCanvas.height=i;var _=e._ScreenshotCanvas.getContext("2d");if(_){var m=_.createImageData(t,i);m.data.set(l),_.putImageData(m,0,0),e.EncodeScreenshotCanvasData(r,o,a)}},e.ToBlob=function(e,t,i){void 0===i&&(i="image/png"),e.toBlob||(e.toBlob=function(e,t,i){var n=this;setTimeout(function(){for(var r=atob(n.toDataURL(t,i).split(",")[1]),o=r.length,a=new Uint8Array(o),s=0;s<o;s++)a[s]=r.charCodeAt(s);e(new Blob([a]))})}),e.toBlob(function(e){t(e)},i)},e.EncodeScreenshotCanvasData=function(t,i,n){(void 0===i&&(i="image/png"),t)?t(e._ScreenshotCanvas.toDataURL(i)):this.ToBlob(e._ScreenshotCanvas,function(t){if("download"in document.createElement("a")){if(!n){var i=new Date,r=(i.getFullYear()+"-"+(i.getMonth()+1)).slice(2)+"-"+i.getDate()+"_"+i.getHours()+"-"+("0"+i.getMinutes()).slice(-2);n="screenshot_"+r+".png"}e.Download(t,n)}else{var o=URL.createObjectURL(t),a=window.open("");if(!a)return;var s=a.document.createElement("img");s.onload=function(){URL.revokeObjectURL(o)},s.src=o,a.document.body.appendChild(s)}},i)},e.Download=function(e,t){if(navigator&&navigator.msSaveBlob)navigator.msSaveBlob(e,t);else{var i=window.URL.createObjectURL(e),n=document.createElement("a");document.body.appendChild(n),n.style.display="none",n.href=i,n.download=t,n.addEventListener("click",function(){n.parentElement&&n.parentElement.removeChild(n)}),n.click(),window.URL.revokeObjectURL(i)}},e.CreateScreenshot=function(e,t,i,n,r){throw void 0===r&&(r="image/png"),c.a.WarnImport("ScreenshotTools")},e.CreateScreenshotAsync=function(e,t,i,n){throw void 0===n&&(n="image/png"),c.a.WarnImport("ScreenshotTools")},e.CreateScreenshotUsingRenderTarget=function(e,t,i,n,r,o,a,s){throw void 0===r&&(r="image/png"),void 0===o&&(o=1),void 0===a&&(a=!1),c.a.WarnImport("ScreenshotTools")},e.CreateScreenshotUsingRenderTargetAsync=function(e,t,i,n,r,o,a){throw void 0===n&&(n="image/png"),void 0===r&&(r=1),void 0===o&&(o=!1),c.a.WarnImport("ScreenshotTools")},e.RandomId=function(){return _.a.RandomId()},e.IsBase64=function(e){return!(e.length<5)&&"data:"===e.substr(0,5)},e.DecodeBase64=function(e){for(var t=atob(e.split(",")[1]),i=t.length,n=new Uint8Array(new ArrayBuffer(i)),r=0;r<i;r++)n[r]=t.charCodeAt(r);return n.buffer},e.GetAbsoluteUrl=function(e){var t=document.createElement("a");return t.href=e,t.href},Object.defineProperty(e,"errorsCount",{get:function(){return o.a.errorsCount},enumerable:!0,configurable:!0}),e.Log=function(e){o.a.Log(e)},e.Warn=function(e){o.a.Warn(e)},e.Error=function(e){o.a.Error(e)},Object.defineProperty(e,"LogCache",{get:function(){return o.a.LogCache},enumerable:!0,configurable:!0}),e.ClearLogCache=function(){o.a.ClearLogCache()},Object.defineProperty(e,"LogLevels",{set:function(e){o.a.LogLevels=e},enumerable:!0,configurable:!0}),Object.defineProperty(e,"PerformanceLogLevel",{set:function(t){return(t&e.PerformanceUserMarkLogLevel)===e.PerformanceUserMarkLogLevel?(e.StartPerformanceCounter=e._StartUserMark,void(e.EndPerformanceCounter=e._EndUserMark)):(t&e.PerformanceConsoleLogLevel)===e.PerformanceConsoleLogLevel?(e.StartPerformanceCounter=e._StartPerformanceConsole,void(e.EndPerformanceCounter=e._EndPerformanceConsole)):(e.StartPerformanceCounter=e._StartPerformanceCounterDisabled,void(e.EndPerformanceCounter=e._EndPerformanceCounterDisabled))},enumerable:!0,configurable:!0}),e._StartPerformanceCounterDisabled=function(e,t){},e._EndPerformanceCounterDisabled=function(e,t){},e._StartUserMark=function(t,i){if(void 0===i&&(i=!0),!e._performance){if(!r.a.IsWindowObjectExist())return;e._performance=window.performance}i&&e._performance.mark&&e._performance.mark(t+"-Begin")},e._EndUserMark=function(t,i){void 0===i&&(i=!0),i&&e._performance.mark&&(e._performance.mark(t+"-End"),e._performance.measure(t,t+"-Begin",t+"-End"))},e._StartPerformanceConsole=function(t,i){void 0===i&&(i=!0),i&&(e._StartUserMark(t,i),console.time&&console.time(t))},e._EndPerformanceConsole=function(t,i){void 0===i&&(i=!0),i&&(e._EndUserMark(t,i),console.timeEnd(t))},Object.defineProperty(e,"Now",{get:function(){return s.a.Now},enumerable:!0,configurable:!0}),e.GetClassName=function(e,t){void 0===t&&(t=!1);var i=null;if(!t&&e.getClassName)i=e.getClassName();else{if(e instanceof Object)i=(t?e:Object.getPrototypeOf(e)).constructor.__bjsclassName__;i||(i=typeof e)}return i},e.First=function(e,t){for(var i=0,n=e;i<n.length;i++){var r=n[i];if(t(r))return r}return null},e.getFullClassName=function(e,t){void 0===t&&(t=!1);var i=null,n=null;if(!t&&e.getClassName)i=e.getClassName();else{if(e instanceof Object){var r=t?e:Object.getPrototypeOf(e);i=r.constructor.__bjsclassName__,n=r.constructor.__bjsmoduleName__}i||(i=typeof e)}return i?(null!=n?n+".":"")+i:null},e.DelayAsync=function(e){return new Promise(function(t){setTimeout(function(){t()},e)})},e.IsSafari=function(){return/^((?!chrome|android).)*safari/i.test(navigator.userAgent)},e.UseCustomRequestHeaders=!1,e.CustomRequestHeaders=l.a.CustomRequestHeaders,e.CorsBehavior="anonymous",e._tmpFloatArray=new Float32Array(1),e.GetDOMTextContent=r.a.GetDOMTextContent,e.NoneLogLevel=o.a.NoneLogLevel,e.MessageLogLevel=o.a.MessageLogLevel,e.WarningLogLevel=o.a.WarningLogLevel,e.ErrorLogLevel=o.a.ErrorLogLevel,e.AllLogLevel=o.a.AllLogLevel,e.IsWindowObjectExist=r.a.IsWindowObjectExist,e.PerformanceNoneLogLevel=0,e.PerformanceUserMarkLogLevel=1,e.PerformanceConsoleLogLevel=2,e.StartPerformanceCounter=e._StartPerformanceCounterDisabled,e.EndPerformanceCounter=e._EndPerformanceCounterDisabled,e}();function g(e,t){return function(i){i.__bjsclassName__=e,i.__bjsmoduleName__=null!=t?t:null}}var v=function(){function e(e,t,i,n){void 0===n&&(n=0),this.iterations=e,this.index=n-1,this._done=!1,this._fn=t,this._successCallback=i}return e.prototype.executeNext=function(){this._done||(this.index+1<this.iterations?(++this.index,this._fn(this)):this.breakLoop())},e.prototype.breakLoop=function(){this._done=!0,this._successCallback()},e.Run=function(t,i,n,r){void 0===r&&(r=0);var o=new e(t,i,n,r);return o.executeNext(),o},e.SyncAsyncForLoop=function(t,i,n,r,o,a){return void 0===a&&(a=0),e.Run(Math.ceil(t/i),function(e){o&&o()?e.breakLoop():setTimeout(function(){for(var r=0;r<i;++r){var a=e.index*i+r;if(a>=t)break;if(n(a),o&&o()){e.breakLoop();break}}e.executeNext()},a)},r)},e}();u.a.FallbackTexture="data:image/jpg;base64,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",d.a.Apply()},function(e,t,i){"use strict";i.d(t,"a",function(){return n});var n=function(){function e(){}return e.WithinEpsilon=function(e,t,i){void 0===i&&(i=1401298e-51);var n=e-t;return-i<=n&&n<=i},e.ToHex=function(e){var t=e.toString(16);return e<=15?("0"+t).toUpperCase():t.toUpperCase()},e.Sign=function(e){return 0===(e=+e)||isNaN(e)?e:e>0?1:-1},e.Clamp=function(e,t,i){return void 0===t&&(t=0),void 0===i&&(i=1),Math.min(i,Math.max(t,e))},e.Log2=function(e){return Math.log(e)*Math.LOG2E},e.Repeat=function(e,t){return e-Math.floor(e/t)*t},e.Normalize=function(e,t,i){return(e-t)/(i-t)},e.Denormalize=function(e,t,i){return e*(i-t)+t},e.DeltaAngle=function(t,i){var n=e.Repeat(i-t,360);return n>180&&(n-=360),n},e.PingPong=function(t,i){var n=e.Repeat(t,2*i);return i-Math.abs(n-i)},e.SmoothStep=function(t,i,n){var r=e.Clamp(n);return i*(r=-2*r*r*r+3*r*r)+t*(1-r)},e.MoveTowards=function(t,i,n){return Math.abs(i-t)<=n?i:t+e.Sign(i-t)*n},e.MoveTowardsAngle=function(t,i,n){var r=e.DeltaAngle(t,i),o=0;return-n<r&&r<n?o=i:(i=t+r,o=e.MoveTowards(t,i,n)),o},e.Lerp=function(e,t,i){return e+(t-e)*i},e.LerpAngle=function(t,i,n){var r=e.Repeat(i-t,360);return r>180&&(r-=360),t+r*e.Clamp(n)},e.InverseLerp=function(t,i,n){return t!=i?e.Clamp((n-t)/(i-t)):0},e.Hermite=function(e,t,i,n,r){var o=r*r,a=r*o;return e*(2*a-3*o+1)+i*(-2*a+3*o)+t*(a-2*o+r)+n*(a-o)},e.RandomRange=function(e,t){return e===t?e:Math.random()*(t-e)+e},e.RangeToPercent=function(e,t,i){return(e-t)/(i-t)},e.PercentToRange=function(e,t,i){return(i-t)*e+t},e.NormalizeRadians=function(t){return t-=e.TwoPi*Math.floor((t+Math.PI)/e.TwoPi)},e.TwoPi=2*Math.PI,e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return s});var n=i(0),r=i(4),o=i(19),a=i(10),s=function(){function e(){}return e.prototype.set=function(e,t){switch(t){case r.b.PositionKind:this.positions=e;break;case r.b.NormalKind:this.normals=e;break;case r.b.TangentKind:this.tangents=e;break;case r.b.UVKind:this.uvs=e;break;case r.b.UV2Kind:this.uvs2=e;break;case r.b.UV3Kind:this.uvs3=e;break;case r.b.UV4Kind:this.uvs4=e;break;case r.b.UV5Kind:this.uvs5=e;break;case r.b.UV6Kind:this.uvs6=e;break;case r.b.ColorKind:this.colors=e;break;case r.b.MatricesIndicesKind:this.matricesIndices=e;break;case r.b.MatricesWeightsKind:this.matricesWeights=e;break;case r.b.MatricesIndicesExtraKind:this.matricesIndicesExtra=e;break;case r.b.MatricesWeightsExtraKind:this.matricesWeightsExtra=e}},e.prototype.applyToMesh=function(e,t){return this._applyTo(e,t),this},e.prototype.applyToGeometry=function(e,t){return this._applyTo(e,t),this},e.prototype.updateMesh=function(e){return this._update(e),this},e.prototype.updateGeometry=function(e){return this._update(e),this},e.prototype._applyTo=function(e,t){return void 0===t&&(t=!1),this.positions&&e.setVerticesData(r.b.PositionKind,this.positions,t),this.normals&&e.setVerticesData(r.b.NormalKind,this.normals,t),this.tangents&&e.setVerticesData(r.b.TangentKind,this.tangents,t),this.uvs&&e.setVerticesData(r.b.UVKind,this.uvs,t),this.uvs2&&e.setVerticesData(r.b.UV2Kind,this.uvs2,t),this.uvs3&&e.setVerticesData(r.b.UV3Kind,this.uvs3,t),this.uvs4&&e.setVerticesData(r.b.UV4Kind,this.uvs4,t),this.uvs5&&e.setVerticesData(r.b.UV5Kind,this.uvs5,t),this.uvs6&&e.setVerticesData(r.b.UV6Kind,this.uvs6,t),this.colors&&e.setVerticesData(r.b.ColorKind,this.colors,t),this.matricesIndices&&e.setVerticesData(r.b.MatricesIndicesKind,this.matricesIndices,t),this.matricesWeights&&e.setVerticesData(r.b.MatricesWeightsKind,this.matricesWeights,t),this.matricesIndicesExtra&&e.setVerticesData(r.b.MatricesIndicesExtraKind,this.matricesIndicesExtra,t),this.matricesWeightsExtra&&e.setVerticesData(r.b.MatricesWeightsExtraKind,this.matricesWeightsExtra,t),this.indices?e.setIndices(this.indices,null,t):e.setIndices([],null),this},e.prototype._update=function(e,t,i){return this.positions&&e.updateVerticesData(r.b.PositionKind,this.positions,t,i),this.normals&&e.updateVerticesData(r.b.NormalKind,this.normals,t,i),this.tangents&&e.updateVerticesData(r.b.TangentKind,this.tangents,t,i),this.uvs&&e.updateVerticesData(r.b.UVKind,this.uvs,t,i),this.uvs2&&e.updateVerticesData(r.b.UV2Kind,this.uvs2,t,i),this.uvs3&&e.updateVerticesData(r.b.UV3Kind,this.uvs3,t,i),this.uvs4&&e.updateVerticesData(r.b.UV4Kind,this.uvs4,t,i),this.uvs5&&e.updateVerticesData(r.b.UV5Kind,this.uvs5,t,i),this.uvs6&&e.updateVerticesData(r.b.UV6Kind,this.uvs6,t,i),this.colors&&e.updateVerticesData(r.b.ColorKind,this.colors,t,i),this.matricesIndices&&e.updateVerticesData(r.b.MatricesIndicesKind,this.matricesIndices,t,i),this.matricesWeights&&e.updateVerticesData(r.b.MatricesWeightsKind,this.matricesWeights,t,i),this.matricesIndicesExtra&&e.updateVerticesData(r.b.MatricesIndicesExtraKind,this.matricesIndicesExtra,t,i),this.matricesWeightsExtra&&e.updateVerticesData(r.b.MatricesWeightsExtraKind,this.matricesWeightsExtra,t,i),this.indices&&e.setIndices(this.indices,null),this},e.prototype.transform=function(e){var t,i=e.m[0]*e.m[5]*e.m[10]<0,r=n.e.Zero();if(this.positions){var o=n.e.Zero();for(t=0;t<this.positions.length;t+=3)n.e.FromArrayToRef(this.positions,t,o),n.e.TransformCoordinatesToRef(o,e,r),this.positions[t]=r.x,this.positions[t+1]=r.y,this.positions[t+2]=r.z}if(this.normals){var a=n.e.Zero();for(t=0;t<this.normals.length;t+=3)n.e.FromArrayToRef(this.normals,t,a),n.e.TransformNormalToRef(a,e,r),this.normals[t]=r.x,this.normals[t+1]=r.y,this.normals[t+2]=r.z}if(this.tangents){var s=n.f.Zero(),c=n.f.Zero();for(t=0;t<this.tangents.length;t+=4)n.f.FromArrayToRef(this.tangents,t,s),n.f.TransformNormalToRef(s,e,c),this.tangents[t]=c.x,this.tangents[t+1]=c.y,this.tangents[t+2]=c.z,this.tangents[t+3]=c.w}if(i&&this.indices)for(t=0;t<this.indices.length;t+=3){var l=this.indices[t+1];this.indices[t+1]=this.indices[t+2],this.indices[t+2]=l}return this},e.prototype.merge=function(e,t){if(void 0===t&&(t=!1),this._validate(),e._validate(),!this.normals!=!e.normals||!this.tangents!=!e.tangents||!this.uvs!=!e.uvs||!this.uvs2!=!e.uvs2||!this.uvs3!=!e.uvs3||!this.uvs4!=!e.uvs4||!this.uvs5!=!e.uvs5||!this.uvs6!=!e.uvs6||!this.colors!=!e.colors||!this.matricesIndices!=!e.matricesIndices||!this.matricesWeights!=!e.matricesWeights||!this.matricesIndicesExtra!=!e.matricesIndicesExtra||!this.matricesWeightsExtra!=!e.matricesWeightsExtra)throw new Error("Cannot merge vertex data that do not have the same set of attributes");if(e.indices){this.indices||(this.indices=[]);var i=this.positions?this.positions.length/3:0;if(void 0!==this.indices.BYTES_PER_ELEMENT){var n=this.indices.length+e.indices.length,r=t||this.indices instanceof Uint32Array?new Uint32Array(n):new Uint16Array(n);r.set(this.indices);for(var o=this.indices.length,a=0;a<e.indices.length;a++)r[o+a]=e.indices[a]+i;this.indices=r}else for(a=0;a<e.indices.length;a++)this.indices.push(e.indices[a]+i)}return this.positions=this._mergeElement(this.positions,e.positions),this.normals=this._mergeElement(this.normals,e.normals),this.tangents=this._mergeElement(this.tangents,e.tangents),this.uvs=this._mergeElement(this.uvs,e.uvs),this.uvs2=this._mergeElement(this.uvs2,e.uvs2),this.uvs3=this._mergeElement(this.uvs3,e.uvs3),this.uvs4=this._mergeElement(this.uvs4,e.uvs4),this.uvs5=this._mergeElement(this.uvs5,e.uvs5),this.uvs6=this._mergeElement(this.uvs6,e.uvs6),this.colors=this._mergeElement(this.colors,e.colors),this.matricesIndices=this._mergeElement(this.matricesIndices,e.matricesIndices),this.matricesWeights=this._mergeElement(this.matricesWeights,e.matricesWeights),this.matricesIndicesExtra=this._mergeElement(this.matricesIndicesExtra,e.matricesIndicesExtra),this.matricesWeightsExtra=this._mergeElement(this.matricesWeightsExtra,e.matricesWeightsExtra),this},e.prototype._mergeElement=function(e,t){if(!e)return t;if(!t)return e;var i=t.length+e.length,n=e instanceof Float32Array,r=t instanceof Float32Array;if(n){var o=new Float32Array(i);return o.set(e),o.set(t,e.length),o}if(r){var a=e.slice(0),s=0;for(i=t.length;s<i;s++)a.push(t[s]);return a}return e.concat(t)},e.prototype._validate=function(){if(!this.positions)throw new Error("Positions are required");var e=function(e,t){var i=r.b.DeduceStride(e);if(t.length%i!=0)throw new Error("The "+e+"s array count must be a multiple of "+i);return t.length/i},t=e(r.b.PositionKind,this.positions),i=function(i,n){var r=e(i,n);if(r!==t)throw new Error("The "+i+"s element count ("+r+") does not match the positions count ("+t+")")};this.normals&&i(r.b.NormalKind,this.normals),this.tangents&&i(r.b.TangentKind,this.tangents),this.uvs&&i(r.b.UVKind,this.uvs),this.uvs2&&i(r.b.UV2Kind,this.uvs2),this.uvs3&&i(r.b.UV3Kind,this.uvs3),this.uvs4&&i(r.b.UV4Kind,this.uvs4),this.uvs5&&i(r.b.UV5Kind,this.uvs5),this.uvs6&&i(r.b.UV6Kind,this.uvs6),this.colors&&i(r.b.ColorKind,this.colors),this.matricesIndices&&i(r.b.MatricesIndicesKind,this.matricesIndices),this.matricesWeights&&i(r.b.MatricesWeightsKind,this.matricesWeights),this.matricesIndicesExtra&&i(r.b.MatricesIndicesExtraKind,this.matricesIndicesExtra),this.matricesWeightsExtra&&i(r.b.MatricesWeightsExtraKind,this.matricesWeightsExtra)},e.prototype.serialize=function(){var e=this.serialize();return this.positions&&(e.positions=this.positions),this.normals&&(e.normals=this.normals),this.tangents&&(e.tangents=this.tangents),this.uvs&&(e.uvs=this.uvs),this.uvs2&&(e.uvs2=this.uvs2),this.uvs3&&(e.uvs3=this.uvs3),this.uvs4&&(e.uvs4=this.uvs4),this.uvs5&&(e.uvs5=this.uvs5),this.uvs6&&(e.uvs6=this.uvs6),this.colors&&(e.colors=this.colors),this.matricesIndices&&(e.matricesIndices=this.matricesIndices,e.matricesIndices._isExpanded=!0),this.matricesWeights&&(e.matricesWeights=this.matricesWeights),this.matricesIndicesExtra&&(e.matricesIndicesExtra=this.matricesIndicesExtra,e.matricesIndicesExtra._isExpanded=!0),this.matricesWeightsExtra&&(e.matricesWeightsExtra=this.matricesWeightsExtra),e.indices=this.indices,e},e.ExtractFromMesh=function(t,i,n){return e._ExtractFrom(t,i,n)},e.ExtractFromGeometry=function(t,i,n){return e._ExtractFrom(t,i,n)},e._ExtractFrom=function(t,i,n){var o=new e;return t.isVerticesDataPresent(r.b.PositionKind)&&(o.positions=t.getVerticesData(r.b.PositionKind,i,n)),t.isVerticesDataPresent(r.b.NormalKind)&&(o.normals=t.getVerticesData(r.b.NormalKind,i,n)),t.isVerticesDataPresent(r.b.TangentKind)&&(o.tangents=t.getVerticesData(r.b.TangentKind,i,n)),t.isVerticesDataPresent(r.b.UVKind)&&(o.uvs=t.getVerticesData(r.b.UVKind,i,n)),t.isVerticesDataPresent(r.b.UV2Kind)&&(o.uvs2=t.getVerticesData(r.b.UV2Kind,i,n)),t.isVerticesDataPresent(r.b.UV3Kind)&&(o.uvs3=t.getVerticesData(r.b.UV3Kind,i,n)),t.isVerticesDataPresent(r.b.UV4Kind)&&(o.uvs4=t.getVerticesData(r.b.UV4Kind,i,n)),t.isVerticesDataPresent(r.b.UV5Kind)&&(o.uvs5=t.getVerticesData(r.b.UV5Kind,i,n)),t.isVerticesDataPresent(r.b.UV6Kind)&&(o.uvs6=t.getVerticesData(r.b.UV6Kind,i,n)),t.isVerticesDataPresent(r.b.ColorKind)&&(o.colors=t.getVerticesData(r.b.ColorKind,i,n)),t.isVerticesDataPresent(r.b.MatricesIndicesKind)&&(o.matricesIndices=t.getVerticesData(r.b.MatricesIndicesKind,i,n)),t.isVerticesDataPresent(r.b.MatricesWeightsKind)&&(o.matricesWeights=t.getVerticesData(r.b.MatricesWeightsKind,i,n)),t.isVerticesDataPresent(r.b.MatricesIndicesExtraKind)&&(o.matricesIndicesExtra=t.getVerticesData(r.b.MatricesIndicesExtraKind,i,n)),t.isVerticesDataPresent(r.b.MatricesWeightsExtraKind)&&(o.matricesWeightsExtra=t.getVerticesData(r.b.MatricesWeightsExtraKind,i,n)),o.indices=t.getIndices(i,n),o},e.CreateRibbon=function(e){throw o.a.WarnImport("ribbonBuilder")},e.CreateBox=function(e){throw o.a.WarnImport("boxBuilder")},e.CreateTiledBox=function(e){throw o.a.WarnImport("tiledBoxBuilder")},e.CreateTiledPlane=function(e){throw o.a.WarnImport("tiledPlaneBuilder")},e.CreateSphere=function(e){throw o.a.WarnImport("sphereBuilder")},e.CreateCylinder=function(e){throw o.a.WarnImport("cylinderBuilder")},e.CreateTorus=function(e){throw o.a.WarnImport("torusBuilder")},e.CreateLineSystem=function(e){throw o.a.WarnImport("linesBuilder")},e.CreateDashedLines=function(e){throw o.a.WarnImport("linesBuilder")},e.CreateGround=function(e){throw o.a.WarnImport("groundBuilder")},e.CreateTiledGround=function(e){throw o.a.WarnImport("groundBuilder")},e.CreateGroundFromHeightMap=function(e){throw o.a.WarnImport("groundBuilder")},e.CreatePlane=function(e){throw o.a.WarnImport("planeBuilder")},e.CreateDisc=function(e){throw o.a.WarnImport("discBuilder")},e.CreatePolygon=function(e,t,i,n,r,a){throw o.a.WarnImport("polygonBuilder")},e.CreateIcoSphere=function(e){throw o.a.WarnImport("icoSphereBuilder")},e.CreatePolyhedron=function(e){throw o.a.WarnImport("polyhedronBuilder")},e.CreateTorusKnot=function(e){throw o.a.WarnImport("torusKnotBuilder")},e.ComputeNormals=function(e,t,i,r){var o=0,a=0,s=0,c=0,l=0,u=0,h=0,d=0,f=0,p=0,_=0,m=0,g=0,v=0,y=0,b=0,T=0,E=0,x=0,P=0,A=!1,S=!1,C=!1,R=!1,O=1,M=0,I=null;if(r&&(A=!!r.facetNormals,S=!!r.facetPositions,C=!!r.facetPartitioning,O=!0===r.useRightHandedSystem?-1:1,M=r.ratio||0,R=!!r.depthSort,I=r.distanceTo,R)){void 0===I&&(I=n.e.Zero());var D=r.depthSortedFacets}var w=0,L=0,N=0,F=0;if(C&&r&&r.bbSize){var B=0,U=0,V=0,k=0,z=0,G=0,j=0,W=0,X=0,H=0,Y=0,K=0,Q=0,q=0,Z=0,J=0,$=r.bbSize.x>r.bbSize.y?r.bbSize.x:r.bbSize.y;$=$>r.bbSize.z?$:r.bbSize.z,w=r.subDiv.X*M/r.bbSize.x,L=r.subDiv.Y*M/r.bbSize.y,N=r.subDiv.Z*M/r.bbSize.z,F=r.subDiv.max*r.subDiv.max,r.facetPartitioning.length=0}for(o=0;o<e.length;o++)i[o]=0;var ee=t.length/3|0;for(o=0;o<ee;o++){if(g=(m=3*t[3*o])+1,v=m+2,b=(y=3*t[3*o+1])+1,T=y+2,x=(E=3*t[3*o+2])+1,P=E+2,a=e[m]-e[y],s=e[g]-e[b],c=e[v]-e[T],l=e[E]-e[y],u=e[x]-e[b],d=O*(s*(h=e[P]-e[T])-c*u),f=O*(c*l-a*h),p=O*(a*u-s*l),d/=_=0===(_=Math.sqrt(d*d+f*f+p*p))?1:_,f/=_,p/=_,A&&r&&(r.facetNormals[o].x=d,r.facetNormals[o].y=f,r.facetNormals[o].z=p),S&&r&&(r.facetPositions[o].x=(e[m]+e[y]+e[E])/3,r.facetPositions[o].y=(e[g]+e[b]+e[x])/3,r.facetPositions[o].z=(e[v]+e[T]+e[P])/3),C&&r&&(B=Math.floor((r.facetPositions[o].x-r.bInfo.minimum.x*M)*w),U=Math.floor((r.facetPositions[o].y-r.bInfo.minimum.y*M)*L),V=Math.floor((r.facetPositions[o].z-r.bInfo.minimum.z*M)*N),k=Math.floor((e[m]-r.bInfo.minimum.x*M)*w),z=Math.floor((e[g]-r.bInfo.minimum.y*M)*L),G=Math.floor((e[v]-r.bInfo.minimum.z*M)*N),j=Math.floor((e[y]-r.bInfo.minimum.x*M)*w),W=Math.floor((e[b]-r.bInfo.minimum.y*M)*L),X=Math.floor((e[T]-r.bInfo.minimum.z*M)*N),H=Math.floor((e[E]-r.bInfo.minimum.x*M)*w),Y=Math.floor((e[x]-r.bInfo.minimum.y*M)*L),K=Math.floor((e[P]-r.bInfo.minimum.z*M)*N),q=k+r.subDiv.max*z+F*G,Z=j+r.subDiv.max*W+F*X,J=H+r.subDiv.max*Y+F*K,Q=B+r.subDiv.max*U+F*V,r.facetPartitioning[Q]=r.facetPartitioning[Q]?r.facetPartitioning[Q]:new Array,r.facetPartitioning[q]=r.facetPartitioning[q]?r.facetPartitioning[q]:new Array,r.facetPartitioning[Z]=r.facetPartitioning[Z]?r.facetPartitioning[Z]:new Array,r.facetPartitioning[J]=r.facetPartitioning[J]?r.facetPartitioning[J]:new Array,r.facetPartitioning[q].push(o),Z!=q&&r.facetPartitioning[Z].push(o),J!=Z&&J!=q&&r.facetPartitioning[J].push(o),Q!=q&&Q!=Z&&Q!=J&&r.facetPartitioning[Q].push(o)),R&&r&&r.facetPositions){var te=D[o];te.ind=3*o,te.sqDistance=n.e.DistanceSquared(r.facetPositions[o],I)}i[m]+=d,i[g]+=f,i[v]+=p,i[y]+=d,i[b]+=f,i[T]+=p,i[E]+=d,i[x]+=f,i[P]+=p}for(o=0;o<i.length/3;o++)d=i[3*o],f=i[3*o+1],p=i[3*o+2],d/=_=0===(_=Math.sqrt(d*d+f*f+p*p))?1:_,f/=_,p/=_,i[3*o]=d,i[3*o+1]=f,i[3*o+2]=p},e._ComputeSides=function(t,i,r,o,a,s,c){var l,u,h=r.length,d=o.length;switch(t=t||e.DEFAULTSIDE){case e.FRONTSIDE:break;case e.BACKSIDE:var f;for(l=0;l<h;l+=3)f=r[l],r[l]=r[l+2],r[l+2]=f;for(u=0;u<d;u++)o[u]=-o[u];break;case e.DOUBLESIDE:for(var p=i.length,_=p/3,m=0;m<p;m++)i[p+m]=i[m];for(l=0;l<h;l+=3)r[l+h]=r[l+2]+_,r[l+1+h]=r[l+1]+_,r[l+2+h]=r[l]+_;for(u=0;u<d;u++)o[d+u]=-o[u];var g=a.length,v=0;for(v=0;v<g;v++)a[v+g]=a[v];for(s=s||new n.f(0,0,1,1),c=c||new n.f(0,0,1,1),v=0,l=0;l<g/2;l++)a[v]=s.x+(s.z-s.x)*a[v],a[v+1]=s.y+(s.w-s.y)*a[v+1],a[v+g]=c.x+(c.z-c.x)*a[v+g],a[v+g+1]=c.y+(c.w-c.y)*a[v+g+1],v+=2}},e.ImportVertexData=function(t,i){var n=new e,o=t.positions;o&&n.set(o,r.b.PositionKind);var s=t.normals;s&&n.set(s,r.b.NormalKind);var c=t.tangents;c&&n.set(c,r.b.TangentKind);var l=t.uvs;l&&n.set(l,r.b.UVKind);var u=t.uv2s;u&&n.set(u,r.b.UV2Kind);var h=t.uv3s;h&&n.set(h,r.b.UV3Kind);var d=t.uv4s;d&&n.set(d,r.b.UV4Kind);var f=t.uv5s;f&&n.set(f,r.b.UV5Kind);var p=t.uv6s;p&&n.set(p,r.b.UV6Kind);var _=t.colors;_&&n.set(a.b.CheckColors4(_,o.length/3),r.b.ColorKind);var m=t.matricesIndices;m&&n.set(m,r.b.MatricesIndicesKind);var g=t.matricesWeights;g&&n.set(g,r.b.MatricesWeightsKind);var v=t.indices;v&&(n.indices=v),i.setAllVerticesData(n,t.updatable)},e.FRONTSIDE=0,e.BACKSIDE=1,e.DOUBLESIDE=2,e.DEFAULTSIDE=0,e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return l});var n=i(7),r=i(18),o=i(23),a=i(4),s=i(50),c=i(10),l=function(){function e(){}return e.BindEyePosition=function(e,t){if(t._forcedViewPosition)e.setVector3("vEyePosition",t._forcedViewPosition);else{var i=t.activeCamera.globalPosition;i||(i=t.activeCamera.devicePosition),e.setVector3("vEyePosition",t._mirroredCameraPosition?t._mirroredCameraPosition:i)}},e.PrepareDefinesForMergedUV=function(e,t,i){t._needUVs=!0,t[i]=!0,e.getTextureMatrix().isIdentityAs3x2()?(t[i+"DIRECTUV"]=e.coordinatesIndex+1,0===e.coordinatesIndex?t.MAINUV1=!0:t.MAINUV2=!0):t[i+"DIRECTUV"]=0},e.BindTextureMatrix=function(e,t,i){var n=e.getTextureMatrix();t.updateMatrix(i+"Matrix",n)},e.GetFogState=function(e,t){return t.fogEnabled&&e.applyFog&&t.fogMode!==r.a.FOGMODE_NONE},e.PrepareDefinesForMisc=function(e,t,i,n,r,o,a){a._areMiscDirty&&(a.LOGARITHMICDEPTH=i,a.POINTSIZE=n,a.FOG=r&&this.GetFogState(e,t),a.NONUNIFORMSCALING=e.nonUniformScaling,a.ALPHATEST=o)},e.PrepareDefinesForFrameBoundValues=function(e,t,i,n,r){void 0===r&&(r=null);var o,a,s,c,l,u,h=!1;o=null==r?void 0!==e.clipPlane&&null!==e.clipPlane:r,a=null==r?void 0!==e.clipPlane2&&null!==e.clipPlane2:r,s=null==r?void 0!==e.clipPlane3&&null!==e.clipPlane3:r,c=null==r?void 0!==e.clipPlane4&&null!==e.clipPlane4:r,l=null==r?void 0!==e.clipPlane5&&null!==e.clipPlane5:r,u=null==r?void 0!==e.clipPlane6&&null!==e.clipPlane6:r,i.CLIPPLANE!==o&&(i.CLIPPLANE=o,h=!0),i.CLIPPLANE2!==a&&(i.CLIPPLANE2=a,h=!0),i.CLIPPLANE3!==s&&(i.CLIPPLANE3=s,h=!0),i.CLIPPLANE4!==c&&(i.CLIPPLANE4=c,h=!0),i.CLIPPLANE5!==l&&(i.CLIPPLANE5=l,h=!0),i.CLIPPLANE6!==u&&(i.CLIPPLANE6=u,h=!0),i.DEPTHPREPASS!==!t.getColorWrite()&&(i.DEPTHPREPASS=!i.DEPTHPREPASS,h=!0),i.INSTANCES!==n&&(i.INSTANCES=n,h=!0),h&&i.markAsUnprocessed()},e.PrepareDefinesForBones=function(e,t){if(e.useBones&&e.computeBonesUsingShaders&&e.skeleton){t.NUM_BONE_INFLUENCERS=e.numBoneInfluencers;var i=void 0!==t.BONETEXTURE;e.skeleton.isUsingTextureForMatrices&&i?t.BONETEXTURE=!0:(t.BonesPerMesh=e.skeleton.bones.length+1,t.BONETEXTURE=!i&&void 0)}else t.NUM_BONE_INFLUENCERS=0,t.BonesPerMesh=0},e.PrepareDefinesForMorphTargets=function(e,t){var i=e.morphTargetManager;i?(t.MORPHTARGETS_UV=i.supportsUVs&&t.UV1,t.MORPHTARGETS_TANGENT=i.supportsTangents&&t.TANGENT,t.MORPHTARGETS_NORMAL=i.supportsNormals&&t.NORMAL,t.MORPHTARGETS=i.numInfluencers>0,t.NUM_MORPH_INFLUENCERS=i.numInfluencers):(t.MORPHTARGETS_UV=!1,t.MORPHTARGETS_TANGENT=!1,t.MORPHTARGETS_NORMAL=!1,t.MORPHTARGETS=!1,t.NUM_MORPH_INFLUENCERS=0)},e.PrepareDefinesForAttributes=function(e,t,i,n,r,o){if(void 0===r&&(r=!1),void 0===o&&(o=!0),!t._areAttributesDirty&&t._needNormals===t._normals&&t._needUVs===t._uvs)return!1;if(t._normals=t._needNormals,t._uvs=t._needUVs,t.NORMAL=t._needNormals&&e.isVerticesDataPresent(a.b.NormalKind),t._needNormals&&e.isVerticesDataPresent(a.b.TangentKind)&&(t.TANGENT=!0),t._needUVs?(t.UV1=e.isVerticesDataPresent(a.b.UVKind),t.UV2=e.isVerticesDataPresent(a.b.UV2Kind)):(t.UV1=!1,t.UV2=!1),i){var s=e.useVertexColors&&e.isVerticesDataPresent(a.b.ColorKind);t.VERTEXCOLOR=s,t.VERTEXALPHA=e.hasVertexAlpha&&s&&o}return n&&this.PrepareDefinesForBones(e,t),r&&this.PrepareDefinesForMorphTargets(e,t),!0},e.PrepareDefinesForMultiview=function(e,t){if(e.activeCamera){var i=t.MULTIVIEW;t.MULTIVIEW=null!==e.activeCamera.outputRenderTarget&&e.activeCamera.outputRenderTarget.getViewCount()>1,t.MULTIVIEW!=i&&t.markAsUnprocessed()}},e.PrepareDefinesForLight=function(e,t,i,n,r,o,a){switch(a.needNormals=!0,void 0===r["LIGHT"+n]&&(a.needRebuild=!0),r["LIGHT"+n]=!0,r["SPOTLIGHT"+n]=!1,r["HEMILIGHT"+n]=!1,r["POINTLIGHT"+n]=!1,r["DIRLIGHT"+n]=!1,i.prepareLightSpecificDefines(r,n),r["LIGHT_FALLOFF_PHYSICAL"+n]=!1,r["LIGHT_FALLOFF_GLTF"+n]=!1,r["LIGHT_FALLOFF_STANDARD"+n]=!1,i.falloffType){case s.a.FALLOFF_GLTF:r["LIGHT_FALLOFF_GLTF"+n]=!0;break;case s.a.FALLOFF_PHYSICAL:r["LIGHT_FALLOFF_PHYSICAL"+n]=!0;break;case s.a.FALLOFF_STANDARD:r["LIGHT_FALLOFF_STANDARD"+n]=!0}if(o&&!i.specular.equalsFloats(0,0,0)&&(a.specularEnabled=!0),r["SHADOW"+n]=!1,r["SHADOWCSM"+n]=!1,r["SHADOWCSMDEBUG"+n]=!1,r["SHADOWCSMNUM_CASCADES"+n]=!1,r["SHADOWCSMUSESHADOWMAXZ"+n]=!1,r["SHADOWCSMNOBLEND"+n]=!1,r["SHADOWCSM_RIGHTHANDED"+n]=!1,r["SHADOWPCF"+n]=!1,r["SHADOWPCSS"+n]=!1,r["SHADOWPOISSON"+n]=!1,r["SHADOWESM"+n]=!1,r["SHADOWCUBE"+n]=!1,r["SHADOWLOWQUALITY"+n]=!1,r["SHADOWMEDIUMQUALITY"+n]=!1,t&&t.receiveShadows&&e.shadowsEnabled&&i.shadowEnabled){var c=i.getShadowGenerator();if(c){var l=c.getShadowMap();l&&l.renderList&&l.renderList.length>0&&(a.shadowEnabled=!0,c.prepareDefines(r,n))}}i.lightmapMode!=s.a.LIGHTMAP_DEFAULT?(a.lightmapMode=!0,r["LIGHTMAPEXCLUDED"+n]=!0,r["LIGHTMAPNOSPECULAR"+n]=i.lightmapMode==s.a.LIGHTMAP_SHADOWSONLY):(r["LIGHTMAPEXCLUDED"+n]=!1,r["LIGHTMAPNOSPECULAR"+n]=!1)},e.PrepareDefinesForLights=function(e,t,i,n,r,o){if(void 0===r&&(r=4),void 0===o&&(o=!1),!i._areLightsDirty)return i._needNormals;var a=0,s={needNormals:!1,needRebuild:!1,lightmapMode:!1,shadowEnabled:!1,specularEnabled:!1};if(e.lightsEnabled&&!o)for(var c=0,l=t.lightSources;c<l.length;c++){var u=l[c];if(this.PrepareDefinesForLight(e,t,u,a,i,n,s),++a===r)break}i.SPECULARTERM=s.specularEnabled,i.SHADOWS=s.shadowEnabled;for(var h=a;h<r;h++)void 0!==i["LIGHT"+h]&&(i["LIGHT"+h]=!1,i["HEMILIGHT"+h]=!1,i["POINTLIGHT"+h]=!1,i["DIRLIGHT"+h]=!1,i["SPOTLIGHT"+h]=!1,i["SHADOW"+h]=!1,i["SHADOWCSM"+h]=!1,i["SHADOWCSMDEBUG"+h]=!1,i["SHADOWCSMNUM_CASCADES"+h]=!1,i["SHADOWCSMUSESHADOWMAXZ"+h]=!1,i["SHADOWCSMNOBLEND"+h]=!1,i["SHADOWCSM_RIGHTHANDED"+h]=!1,i["SHADOWPCF"+h]=!1,i["SHADOWPCSS"+h]=!1,i["SHADOWPOISSON"+h]=!1,i["SHADOWESM"+h]=!1,i["SHADOWCUBE"+h]=!1,i["SHADOWLOWQUALITY"+h]=!1,i["SHADOWMEDIUMQUALITY"+h]=!1);var d=e.getEngine().getCaps();return void 0===i.SHADOWFLOAT&&(s.needRebuild=!0),i.SHADOWFLOAT=s.shadowEnabled&&(d.textureFloatRender&&d.textureFloatLinearFiltering||d.textureHalfFloatRender&&d.textureHalfFloatLinearFiltering),i.LIGHTMAPEXCLUDED=s.lightmapMode,s.needRebuild&&i.rebuild(),s.needNormals},e.PrepareUniformsAndSamplersForLight=function(e,t,i,n,r){void 0===r&&(r=null),t.push("vLightData"+e,"vLightDiffuse"+e,"vLightSpecular"+e,"vLightDirection"+e,"vLightFalloff"+e,"vLightGround"+e,"lightMatrix"+e,"shadowsInfo"+e,"depthValues"+e),r&&r.push("Light"+e),i.push("shadowSampler"+e),i.push("depthSampler"+e),t.push("viewFrustumZ"+e,"cascadeBlendFactor"+e,"lightSizeUVCorrection"+e,"depthCorrection"+e,"penumbraDarkness"+e,"frustumLengths"+e),n&&(i.push("projectionLightSampler"+e),t.push("textureProjectionMatrix"+e))},e.PrepareUniformsAndSamplersList=function(e,t,i,n){var r;void 0===n&&(n=4);var o=null;if(e.uniformsNames){var a=e;r=a.uniformsNames,o=a.uniformBuffersNames,t=a.samplers,i=a.defines,n=a.maxSimultaneousLights||0}else r=e,t||(t=[]);for(var s=0;s<n&&i["LIGHT"+s];s++)this.PrepareUniformsAndSamplersForLight(s,r,t,i["PROJECTEDLIGHTTEXTURE"+s],o);i.NUM_MORPH_INFLUENCERS&&r.push("morphTargetInfluences")},e.HandleFallbacksForShadows=function(e,t,i,n){void 0===i&&(i=4),void 0===n&&(n=0);for(var r=0,o=0;o<i&&e["LIGHT"+o];o++)o>0&&(r=n+o,t.addFallback(r,"LIGHT"+o)),e.SHADOWS||(e["SHADOW"+o]&&t.addFallback(n,"SHADOW"+o),e["SHADOWPCF"+o]&&t.addFallback(n,"SHADOWPCF"+o),e["SHADOWPCSS"+o]&&t.addFallback(n,"SHADOWPCSS"+o),e["SHADOWPOISSON"+o]&&t.addFallback(n,"SHADOWPOISSON"+o),e["SHADOWESM"+o]&&t.addFallback(n,"SHADOWESM"+o));return r++},e.PrepareAttributesForMorphTargetsInfluencers=function(e,t,i){this._TmpMorphInfluencers.NUM_MORPH_INFLUENCERS=i,this.PrepareAttributesForMorphTargets(e,t,this._TmpMorphInfluencers)},e.PrepareAttributesForMorphTargets=function(e,t,i){var r=i.NUM_MORPH_INFLUENCERS;if(r>0&&o.a.LastCreatedEngine)for(var s=o.a.LastCreatedEngine.getCaps().maxVertexAttribs,c=t.morphTargetManager,l=c&&c.supportsNormals&&i.NORMAL,u=c&&c.supportsTangents&&i.TANGENT,h=c&&c.supportsUVs&&i.UV1,d=0;d<r;d++)e.push(a.b.PositionKind+d),l&&e.push(a.b.NormalKind+d),u&&e.push(a.b.TangentKind+d),h&&e.push(a.b.UVKind+"_"+d),e.length>s&&n.a.Error("Cannot add more vertex attributes for mesh "+t.name)},e.PrepareAttributesForBones=function(e,t,i,n){i.NUM_BONE_INFLUENCERS>0&&(n.addCPUSkinningFallback(0,t),e.push(a.b.MatricesIndicesKind),e.push(a.b.MatricesWeightsKind),i.NUM_BONE_INFLUENCERS>4&&(e.push(a.b.MatricesIndicesExtraKind),e.push(a.b.MatricesWeightsExtraKind)))},e.PrepareAttributesForInstances=function(e,t){t.INSTANCES&&this.PushAttributesForInstances(e)},e.PushAttributesForInstances=function(e){e.push("world0"),e.push("world1"),e.push("world2"),e.push("world3")},e.BindLightProperties=function(e,t,i){e.transferToEffect(t,i+"")},e.BindLight=function(e,t,i,n,r,o){void 0===o&&(o=!1),e._bindLight(t,i,n,r,o)},e.BindLights=function(e,t,i,n,r,o){void 0===r&&(r=4),void 0===o&&(o=!1);for(var a=Math.min(t.lightSources.length,r),s=0;s<a;s++){var c=t.lightSources[s];this.BindLight(c,s,e,i,"boolean"==typeof n?n:n.SPECULARTERM,o)}},e.BindFogParameters=function(e,t,i,n){void 0===n&&(n=!1),e.fogEnabled&&t.applyFog&&e.fogMode!==r.a.FOGMODE_NONE&&(i.setFloat4("vFogInfos",e.fogMode,e.fogStart,e.fogEnd,e.fogDensity),n?(e.fogColor.toLinearSpaceToRef(this._tempFogColor),i.setColor3("vFogColor",this._tempFogColor)):i.setColor3("vFogColor",e.fogColor))},e.BindBonesParameters=function(e,t){if(t&&e&&(e.computeBonesUsingShaders&&t._bonesComputationForcedToCPU&&(e.computeBonesUsingShaders=!1),e.useBones&&e.computeBonesUsingShaders&&e.skeleton)){var i=e.skeleton;if(i.isUsingTextureForMatrices&&t.getUniformIndex("boneTextureWidth")>-1){var n=i.getTransformMatrixTexture(e);t.setTexture("boneSampler",n),t.setFloat("boneTextureWidth",4*(i.bones.length+1))}else{var r=i.getTransformMatrices(e);r&&t.setMatrices("mBones",r)}}},e.BindMorphTargetParameters=function(e,t){var i=e.morphTargetManager;e&&i&&t.setFloatArray("morphTargetInfluences",i.influences)},e.BindLogDepth=function(e,t,i){e.LOGARITHMICDEPTH&&t.setFloat("logarithmicDepthConstant",2/(Math.log(i.activeCamera.maxZ+1)/Math.LN2))},e.BindClipPlane=function(e,t){if(t.clipPlane){var i=t.clipPlane;e.setFloat4("vClipPlane",i.normal.x,i.normal.y,i.normal.z,i.d)}if(t.clipPlane2){i=t.clipPlane2;e.setFloat4("vClipPlane2",i.normal.x,i.normal.y,i.normal.z,i.d)}if(t.clipPlane3){i=t.clipPlane3;e.setFloat4("vClipPlane3",i.normal.x,i.normal.y,i.normal.z,i.d)}if(t.clipPlane4){i=t.clipPlane4;e.setFloat4("vClipPlane4",i.normal.x,i.normal.y,i.normal.z,i.d)}if(t.clipPlane5){i=t.clipPlane5;e.setFloat4("vClipPlane5",i.normal.x,i.normal.y,i.normal.z,i.d)}if(t.clipPlane6){i=t.clipPlane6;e.setFloat4("vClipPlane6",i.normal.x,i.normal.y,i.normal.z,i.d)}},e._TmpMorphInfluencers={NUM_MORPH_INFLUENCERS:0},e._tempFogColor=c.a.Black(),e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return r}),i.d(t,"b",function(){return o});var n=i(1),r=function(){function e(){}return e.NAME_EFFECTLAYER="EffectLayer",e.NAME_LAYER="Layer",e.NAME_LENSFLARESYSTEM="LensFlareSystem",e.NAME_BOUNDINGBOXRENDERER="BoundingBoxRenderer",e.NAME_PARTICLESYSTEM="ParticleSystem",e.NAME_GAMEPAD="Gamepad",e.NAME_SIMPLIFICATIONQUEUE="SimplificationQueue",e.NAME_GEOMETRYBUFFERRENDERER="GeometryBufferRenderer",e.NAME_DEPTHRENDERER="DepthRenderer",e.NAME_POSTPROCESSRENDERPIPELINEMANAGER="PostProcessRenderPipelineManager",e.NAME_SPRITE="Sprite",e.NAME_OUTLINERENDERER="Outline",e.NAME_PROCEDURALTEXTURE="ProceduralTexture",e.NAME_SHADOWGENERATOR="ShadowGenerator",e.NAME_OCTREE="Octree",e.NAME_PHYSICSENGINE="PhysicsEngine",e.NAME_AUDIO="Audio",e.STEP_ISREADYFORMESH_EFFECTLAYER=0,e.STEP_BEFOREEVALUATEACTIVEMESH_BOUNDINGBOXRENDERER=0,e.STEP_EVALUATESUBMESH_BOUNDINGBOXRENDERER=0,e.STEP_ACTIVEMESH_BOUNDINGBOXRENDERER=0,e.STEP_CAMERADRAWRENDERTARGET_EFFECTLAYER=1,e.STEP_BEFORECAMERADRAW_EFFECTLAYER=0,e.STEP_BEFORECAMERADRAW_LAYER=1,e.STEP_BEFORERENDERTARGETDRAW_LAYER=0,e.STEP_BEFORERENDERINGMESH_OUTLINE=0,e.STEP_AFTERRENDERINGMESH_OUTLINE=0,e.STEP_AFTERRENDERINGGROUPDRAW_EFFECTLAYER_DRAW=0,e.STEP_AFTERRENDERINGGROUPDRAW_BOUNDINGBOXRENDERER=1,e.STEP_BEFORECAMERAUPDATE_SIMPLIFICATIONQUEUE=0,e.STEP_BEFORECAMERAUPDATE_GAMEPAD=1,e.STEP_BEFORECLEAR_PROCEDURALTEXTURE=0,e.STEP_AFTERRENDERTARGETDRAW_LAYER=0,e.STEP_AFTERCAMERADRAW_EFFECTLAYER=0,e.STEP_AFTERCAMERADRAW_LENSFLARESYSTEM=1,e.STEP_AFTERCAMERADRAW_EFFECTLAYER_DRAW=2,e.STEP_AFTERCAMERADRAW_LAYER=3,e.STEP_AFTERRENDER_AUDIO=0,e.STEP_GATHERRENDERTARGETS_DEPTHRENDERER=0,e.STEP_GATHERRENDERTARGETS_GEOMETRYBUFFERRENDERER=1,e.STEP_GATHERRENDERTARGETS_SHADOWGENERATOR=2,e.STEP_GATHERRENDERTARGETS_POSTPROCESSRENDERPIPELINEMANAGER=3,e.STEP_GATHERACTIVECAMERARENDERTARGETS_DEPTHRENDERER=0,e.STEP_POINTERMOVE_SPRITE=0,e.STEP_POINTERDOWN_SPRITE=0,e.STEP_POINTERUP_SPRITE=0,e}(),o=function(e){function t(t){return e.apply(this,t)||this}return Object(n.d)(t,e),t.Create=function(){return Object.create(t.prototype)},t.prototype.registerStep=function(e,t,i){var n=0;for(Number.MAX_VALUE;n<this.length;n++){if(e<this[n].index)break}this.splice(n,0,{index:e,component:t,action:i.bind(t)})},t.prototype.clear=function(){this.length=0},t}(Array)},function(e,t,i){"use strict";var n=i(1),r=i(13),o=i(52),a=i(6),s=i(34),c=i(103),l=i(35),u=i(0),h=i(43),d=i(27),f=i(24),p=i(37),_=i(40),m=i(83),g=i(50),v=i(53),y=i(45),b=i(90),T=i(91),E=i(17),x=i(2),P=i(38),A=i(7),S=i(23),C=i(19),R=i(20),O=i(87),M=i(63),I=function(){function e(){this._singleClick=!1,this._doubleClick=!1,this._hasSwiped=!1,this._ignore=!1}return Object.defineProperty(e.prototype,"singleClick",{get:function(){return this._singleClick},set:function(e){this._singleClick=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"doubleClick",{get:function(){return this._doubleClick},set:function(e){this._doubleClick=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"hasSwiped",{get:function(){return this._hasSwiped},set:function(e){this._hasSwiped=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"ignore",{get:function(){return this._ignore},set:function(e){this._ignore=e},enumerable:!0,configurable:!0}),e}(),D=function(){function e(e){this._wheelEventName="",this._meshPickProceed=!1,this._currentPickResult=null,this._previousPickResult=null,this._totalPointersPressed=0,this._doubleClickOccured=!1,this._pointerX=0,this._pointerY=0,this._startingPointerPosition=new u.d(0,0),this._previousStartingPointerPosition=new u.d(0,0),this._startingPointerTime=0,this._previousStartingPointerTime=0,this._pointerCaptures={},this._scene=e}return Object.defineProperty(e.prototype,"meshUnderPointer",{get:function(){return this._pointerOverMesh},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"unTranslatedPointer",{get:function(){return new u.d(this._unTranslatedPointerX,this._unTranslatedPointerY)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"pointerX",{get:function(){return this._pointerX},set:function(e){this._pointerX=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"pointerY",{get:function(){return this._pointerY},set:function(e){this._pointerY=e},enumerable:!0,configurable:!0}),e.prototype._updatePointerPosition=function(e){var t=this._scene.getEngine().getInputElementClientRect();t&&(this._pointerX=e.clientX-t.left,this._pointerY=e.clientY-t.top,this._unTranslatedPointerX=this._pointerX,this._unTranslatedPointerY=this._pointerY)},e.prototype._processPointerMove=function(e,t){var i=this._scene,n=i.getEngine(),r=n.getInputElement();if(r){r.tabIndex=n.canvasTabIndex,i.doNotHandleCursors||(r.style.cursor=i.defaultCursor);var o=!!(e&&e.hit&&e.pickedMesh);o?(i.setPointerOverMesh(e.pickedMesh),this._pointerOverMesh&&this._pointerOverMesh.actionManager&&this._pointerOverMesh.actionManager.hasPointerTriggers&&(i.doNotHandleCursors||(this._pointerOverMesh.actionManager.hoverCursor?r.style.cursor=this._pointerOverMesh.actionManager.hoverCursor:r.style.cursor=i.hoverCursor))):i.setPointerOverMesh(null);for(var a=0,s=i._pointerMoveStage;a<s.length;a++){e=s[a].action(this._unTranslatedPointerX,this._unTranslatedPointerY,e,o,r)}if(e){var c=t.type===this._wheelEventName?R.a.POINTERWHEEL:R.a.POINTERMOVE;if(i.onPointerMove&&i.onPointerMove(t,e,c),i.onPointerObservable.hasObservers()){var l=new R.b(c,t,e);this._setRayOnPointerInfo(l),i.onPointerObservable.notifyObservers(l,c)}}}},e.prototype._setRayOnPointerInfo=function(e){var t=this._scene;e.pickInfo&&!e.pickInfo._pickingUnavailable&&(e.pickInfo.ray||(e.pickInfo.ray=t.createPickingRay(e.event.offsetX,e.event.offsetY,u.a.Identity(),t.activeCamera)))},e.prototype._checkPrePointerObservable=function(e,t,i){var n=this._scene,r=new R.d(i,t,this._unTranslatedPointerX,this._unTranslatedPointerY);return e&&(r.ray=e.ray),n.onPrePointerObservable.notifyObservers(r,i),!!r.skipOnPointerObservable},e.prototype.simulatePointerMove=function(e,t){var i=new PointerEvent("pointermove",t);this._checkPrePointerObservable(e,i,R.a.POINTERMOVE)||this._processPointerMove(e,i)},e.prototype.simulatePointerDown=function(e,t){var i=new PointerEvent("pointerdown",t);this._checkPrePointerObservable(e,i,R.a.POINTERDOWN)||this._processPointerDown(e,i)},e.prototype._processPointerDown=function(t,i){var n=this,r=this._scene;if(t&&t.hit&&t.pickedMesh){this._pickedDownMesh=t.pickedMesh;var o=t.pickedMesh._getActionManagerForTrigger();if(o){if(o.hasPickTriggers)switch(o.processTrigger(x.a.ACTION_OnPickDownTrigger,y.a.CreateNew(t.pickedMesh,i)),i.button){case 0:o.processTrigger(x.a.ACTION_OnLeftPickTrigger,y.a.CreateNew(t.pickedMesh,i));break;case 1:o.processTrigger(x.a.ACTION_OnCenterPickTrigger,y.a.CreateNew(t.pickedMesh,i));break;case 2:o.processTrigger(x.a.ACTION_OnRightPickTrigger,y.a.CreateNew(t.pickedMesh,i))}o.hasSpecificTrigger(x.a.ACTION_OnLongPressTrigger)&&window.setTimeout(function(){var t=r.pick(n._unTranslatedPointerX,n._unTranslatedPointerY,function(e){return e.isPickable&&e.isVisible&&e.isReady()&&e.actionManager&&e.actionManager.hasSpecificTrigger(x.a.ACTION_OnLongPressTrigger)&&e==n._pickedDownMesh},!1,r.cameraToUseForPointers);t&&t.hit&&t.pickedMesh&&o&&0!==n._totalPointersPressed&&Date.now()-n._startingPointerTime>e.LongPressDelay&&!n._isPointerSwiping()&&(n._startingPointerTime=0,o.processTrigger(x.a.ACTION_OnLongPressTrigger,y.a.CreateNew(t.pickedMesh,i)))},e.LongPressDelay)}}else for(var a=0,s=r._pointerDownStage;a<s.length;a++){t=s[a].action(this._unTranslatedPointerX,this._unTranslatedPointerY,t,i)}if(t){var c=R.a.POINTERDOWN;if(r.onPointerDown&&r.onPointerDown(i,t,c),r.onPointerObservable.hasObservers()){var l=new R.b(c,i,t);this._setRayOnPointerInfo(l),r.onPointerObservable.notifyObservers(l,c)}}},e.prototype._isPointerSwiping=function(){return Math.abs(this._startingPointerPosition.x-this._pointerX)>e.DragMovementThreshold||Math.abs(this._startingPointerPosition.y-this._pointerY)>e.DragMovementThreshold},e.prototype.simulatePointerUp=function(e,t,i){var n=new PointerEvent("pointerup",t),r=new I;i?r.doubleClick=!0:r.singleClick=!0,this._checkPrePointerObservable(e,n,R.a.POINTERUP)||this._processPointerUp(e,n,r)},e.prototype._processPointerUp=function(e,t,i){var n=this._scene;if(e&&e&&e.pickedMesh){if(this._pickedUpMesh=e.pickedMesh,this._pickedDownMesh===this._pickedUpMesh&&(n.onPointerPick&&n.onPointerPick(t,e),i.singleClick&&!i.ignore&&n.onPointerObservable.hasObservers())){var r=R.a.POINTERPICK,o=new R.b(r,t,e);this._setRayOnPointerInfo(o),n.onPointerObservable.notifyObservers(o,r)}var a=e.pickedMesh._getActionManagerForTrigger();if(a&&!i.ignore){a.processTrigger(x.a.ACTION_OnPickUpTrigger,y.a.CreateNew(e.pickedMesh,t)),!i.hasSwiped&&i.singleClick&&a.processTrigger(x.a.ACTION_OnPickTrigger,y.a.CreateNew(e.pickedMesh,t));var s=e.pickedMesh._getActionManagerForTrigger(x.a.ACTION_OnDoublePickTrigger);i.doubleClick&&s&&s.processTrigger(x.a.ACTION_OnDoublePickTrigger,y.a.CreateNew(e.pickedMesh,t))}}else if(!i.ignore)for(var c=0,l=n._pointerUpStage;c<l.length;c++){e=l[c].action(this._unTranslatedPointerX,this._unTranslatedPointerY,e,t)}if(this._pickedDownMesh&&this._pickedDownMesh!==this._pickedUpMesh){var u=this._pickedDownMesh._getActionManagerForTrigger(x.a.ACTION_OnPickOutTrigger);u&&u.processTrigger(x.a.ACTION_OnPickOutTrigger,y.a.CreateNew(this._pickedDownMesh,t))}var h=0;if(n.onPointerObservable.hasObservers()){if(!i.ignore&&!i.hasSwiped&&(i.singleClick&&n.onPointerObservable.hasSpecificMask(R.a.POINTERTAP)?h=R.a.POINTERTAP:i.doubleClick&&n.onPointerObservable.hasSpecificMask(R.a.POINTERDOUBLETAP)&&(h=R.a.POINTERDOUBLETAP),h)){o=new R.b(h,t,e);this._setRayOnPointerInfo(o),n.onPointerObservable.notifyObservers(o,h)}if(!i.ignore){h=R.a.POINTERUP;o=new R.b(h,t,e);this._setRayOnPointerInfo(o),n.onPointerObservable.notifyObservers(o,h)}}n.onPointerUp&&!i.ignore&&n.onPointerUp(t,e,h)},e.prototype.isPointerCaptured=function(e){return void 0===e&&(e=0),this._pointerCaptures[e]},e.prototype.attachControl=function(t,i,n,o){var a=this;void 0===t&&(t=!0),void 0===i&&(i=!0),void 0===n&&(n=!0),void 0===o&&(o=null);var s=this._scene;if(o||(o=s.getEngine().getInputElement()),o){var c,l=s.getEngine();this._initActionManager=function(e,t){if(!a._meshPickProceed){var i=s.pick(a._unTranslatedPointerX,a._unTranslatedPointerY,s.pointerDownPredicate,!1,s.cameraToUseForPointers);a._currentPickResult=i,i&&(e=i.hit&&i.pickedMesh?i.pickedMesh._getActionManagerForTrigger():null),a._meshPickProceed=!0}return e},this._delayedSimpleClick=function(t,i,n){(Date.now()-a._previousStartingPointerTime>e.DoubleClickDelay&&!a._doubleClickOccured||t!==a._previousButtonPressed)&&(a._doubleClickOccured=!1,i.singleClick=!0,i.ignore=!1,n(i,a._currentPickResult))},this._initClickEvent=function(t,i,n,r){var o=new I;a._currentPickResult=null;var s=null,c=t.hasSpecificMask(R.a.POINTERPICK)||i.hasSpecificMask(R.a.POINTERPICK)||t.hasSpecificMask(R.a.POINTERTAP)||i.hasSpecificMask(R.a.POINTERTAP)||t.hasSpecificMask(R.a.POINTERDOUBLETAP)||i.hasSpecificMask(R.a.POINTERDOUBLETAP);!c&&O.a&&(s=a._initActionManager(s,o))&&(c=s.hasPickTriggers);var l=!1;if(c){var u=n.button;if(o.hasSwiped=a._isPointerSwiping(),!o.hasSwiped){var h=!e.ExclusiveDoubleClickMode;h||(h=!t.hasSpecificMask(R.a.POINTERDOUBLETAP)&&!i.hasSpecificMask(R.a.POINTERDOUBLETAP))&&!O.a.HasSpecificTrigger(x.a.ACTION_OnDoublePickTrigger)&&(s=a._initActionManager(s,o))&&(h=!s.hasSpecificTrigger(x.a.ACTION_OnDoublePickTrigger)),h?(Date.now()-a._previousStartingPointerTime>e.DoubleClickDelay||u!==a._previousButtonPressed)&&(o.singleClick=!0,r(o,a._currentPickResult),l=!0):(a._previousDelayedSimpleClickTimeout=a._delayedSimpleClickTimeout,a._delayedSimpleClickTimeout=window.setTimeout(a._delayedSimpleClick.bind(a,u,o,r),e.DoubleClickDelay));var d=t.hasSpecificMask(R.a.POINTERDOUBLETAP)||i.hasSpecificMask(R.a.POINTERDOUBLETAP);!d&&O.a.HasSpecificTrigger(x.a.ACTION_OnDoublePickTrigger)&&(s=a._initActionManager(s,o))&&(d=s.hasSpecificTrigger(x.a.ACTION_OnDoublePickTrigger)),d&&(u===a._previousButtonPressed&&Date.now()-a._previousStartingPointerTime<e.DoubleClickDelay&&!a._doubleClickOccured?(o.hasSwiped||a._isPointerSwiping()?(a._doubleClickOccured=!1,a._previousStartingPointerTime=a._startingPointerTime,a._previousStartingPointerPosition.x=a._startingPointerPosition.x,a._previousStartingPointerPosition.y=a._startingPointerPosition.y,a._previousButtonPressed=u,e.ExclusiveDoubleClickMode?(a._previousDelayedSimpleClickTimeout&&clearTimeout(a._previousDelayedSimpleClickTimeout),a._previousDelayedSimpleClickTimeout=a._delayedSimpleClickTimeout,r(o,a._previousPickResult)):r(o,a._currentPickResult)):(a._previousStartingPointerTime=0,a._doubleClickOccured=!0,o.doubleClick=!0,o.ignore=!1,e.ExclusiveDoubleClickMode&&a._previousDelayedSimpleClickTimeout&&clearTimeout(a._previousDelayedSimpleClickTimeout),a._previousDelayedSimpleClickTimeout=a._delayedSimpleClickTimeout,r(o,a._currentPickResult)),l=!0):(a._doubleClickOccured=!1,a._previousStartingPointerTime=a._startingPointerTime,a._previousStartingPointerPosition.x=a._startingPointerPosition.x,a._previousStartingPointerPosition.y=a._startingPointerPosition.y,a._previousButtonPressed=u))}}l||r(o,a._currentPickResult)},this._onPointerMove=function(e){if(a._updatePointerPosition(e),!a._checkPrePointerObservable(null,e,e.type===a._wheelEventName?R.a.POINTERWHEEL:R.a.POINTERMOVE)&&(s.cameraToUseForPointers||s.activeCamera)){s.pointerMovePredicate||(s.pointerMovePredicate=function(e){return e.isPickable&&e.isVisible&&e.isReady()&&e.isEnabled()&&(e.enablePointerMoveEvents||s.constantlyUpdateMeshUnderPointer||null!=e._getActionManagerForTrigger())&&(!s.cameraToUseForPointers||0!=(s.cameraToUseForPointers.layerMask&e.layerMask))});var t=s.pick(a._unTranslatedPointerX,a._unTranslatedPointerY,s.pointerMovePredicate,!1,s.cameraToUseForPointers);a._processPointerMove(t,e)}},this._onPointerDown=function(e){if(a._totalPointersPressed++,a._pickedDownMesh=null,a._meshPickProceed=!1,a._updatePointerPosition(e),s.preventDefaultOnPointerDown&&o&&(e.preventDefault(),o.focus()),a._startingPointerPosition.x=a._pointerX,a._startingPointerPosition.y=a._pointerY,a._startingPointerTime=Date.now(),!a._checkPrePointerObservable(null,e,R.a.POINTERDOWN)&&(s.cameraToUseForPointers||s.activeCamera)){a._pointerCaptures[e.pointerId]=!0,s.pointerDownPredicate||(s.pointerDownPredicate=function(e){return e.isPickable&&e.isVisible&&e.isReady()&&e.isEnabled()&&(!s.cameraToUseForPointers||0!=(s.cameraToUseForPointers.layerMask&e.layerMask))}),a._pickedDownMesh=null;var t=s.pick(a._unTranslatedPointerX,a._unTranslatedPointerY,s.pointerDownPredicate,!1,s.cameraToUseForPointers);a._processPointerDown(t,e)}},this._onPointerUp=function(e){0!==a._totalPointersPressed&&(a._totalPointersPressed--,a._pickedUpMesh=null,a._meshPickProceed=!1,a._updatePointerPosition(e),s.preventDefaultOnPointerUp&&o&&(e.preventDefault(),o.focus()),a._initClickEvent(s.onPrePointerObservable,s.onPointerObservable,e,function(t,i){if(s.onPrePointerObservable.hasObservers()&&!t.ignore){if(!t.hasSwiped){if(t.singleClick&&s.onPrePointerObservable.hasSpecificMask(R.a.POINTERTAP)&&a._checkPrePointerObservable(null,e,R.a.POINTERTAP))return;if(t.doubleClick&&s.onPrePointerObservable.hasSpecificMask(R.a.POINTERDOUBLETAP)&&a._checkPrePointerObservable(null,e,R.a.POINTERDOUBLETAP))return}if(a._checkPrePointerObservable(null,e,R.a.POINTERUP))return}a._pointerCaptures[e.pointerId]&&(a._pointerCaptures[e.pointerId]=!1,(s.cameraToUseForPointers||s.activeCamera)&&(s.pointerUpPredicate||(s.pointerUpPredicate=function(e){return e.isPickable&&e.isVisible&&e.isReady()&&e.isEnabled()&&(!s.cameraToUseForPointers||0!=(s.cameraToUseForPointers.layerMask&e.layerMask))}),!a._meshPickProceed&&(O.a&&O.a.HasTriggers||s.onPointerObservable.hasObservers())&&a._initActionManager(null,t),i||(i=a._currentPickResult),a._processPointerUp(i,e,t),a._previousPickResult=a._currentPickResult))}))},this._onKeyDown=function(e){var t=M.a.KEYDOWN;if(s.onPreKeyboardObservable.hasObservers()){var i=new M.c(t,e);if(s.onPreKeyboardObservable.notifyObservers(i,t),i.skipOnPointerObservable)return}if(s.onKeyboardObservable.hasObservers()){i=new M.b(t,e);s.onKeyboardObservable.notifyObservers(i,t)}s.actionManager&&s.actionManager.processTrigger(x.a.ACTION_OnKeyDownTrigger,y.a.CreateNewFromScene(s,e))},this._onKeyUp=function(e){var t=M.a.KEYUP;if(s.onPreKeyboardObservable.hasObservers()){var i=new M.c(t,e);if(s.onPreKeyboardObservable.notifyObservers(i,t),i.skipOnPointerObservable)return}if(s.onKeyboardObservable.hasObservers()){i=new M.b(t,e);s.onKeyboardObservable.notifyObservers(i,t)}s.actionManager&&s.actionManager.processTrigger(x.a.ACTION_OnKeyUpTrigger,y.a.CreateNewFromScene(s,e))},this._onCanvasFocusObserver=l.onCanvasFocusObservable.add((c=function(){o&&(o.addEventListener("keydown",a._onKeyDown,!1),o.addEventListener("keyup",a._onKeyUp,!1))},document.activeElement===o&&c(),c)),this._onCanvasBlurObserver=l.onCanvasBlurObservable.add(function(){o&&(o.removeEventListener("keydown",a._onKeyDown),o.removeEventListener("keyup",a._onKeyUp))});var u=r.b.GetPointerPrefix();if(n&&(o.addEventListener(u+"move",this._onPointerMove,!1),this._wheelEventName="onwheel"in document.createElement("div")?"wheel":void 0!==document.onmousewheel?"mousewheel":"DOMMouseScroll",o.addEventListener(this._wheelEventName,this._onPointerMove,!1)),i&&o.addEventListener(u+"down",this._onPointerDown,!1),t){var h=s.getEngine().getHostWindow();h&&h.addEventListener(u+"up",this._onPointerUp,!1)}}},e.prototype.detachControl=function(){var e=r.b.GetPointerPrefix(),t=this._scene.getEngine().getInputElement(),i=this._scene.getEngine();t&&(t.removeEventListener(e+"move",this._onPointerMove),t.removeEventListener(this._wheelEventName,this._onPointerMove),t.removeEventListener(e+"down",this._onPointerDown),window.removeEventListener(e+"up",this._onPointerUp),this._onCanvasBlurObserver&&i.onCanvasBlurObservable.remove(this._onCanvasBlurObserver),this._onCanvasFocusObserver&&i.onCanvasFocusObservable.remove(this._onCanvasFocusObserver),t.removeEventListener("keydown",this._onKeyDown),t.removeEventListener("keyup",this._onKeyUp),this._scene.doNotHandleCursors||(t.style.cursor=this._scene.defaultCursor))},e.prototype.setPointerOverMesh=function(e){var t;this._pointerOverMesh!==e&&(this._pointerOverMesh&&(t=this._pointerOverMesh._getActionManagerForTrigger(x.a.ACTION_OnPointerOutTrigger))&&t.processTrigger(x.a.ACTION_OnPointerOutTrigger,y.a.CreateNew(this._pointerOverMesh)),this._pointerOverMesh=e,this._pointerOverMesh&&(t=this._pointerOverMesh._getActionManagerForTrigger(x.a.ACTION_OnPointerOverTrigger))&&t.processTrigger(x.a.ACTION_OnPointerOverTrigger,y.a.CreateNew(this._pointerOverMesh)))},e.prototype.getPointerOverMesh=function(){return this._pointerOverMesh},e.DragMovementThreshold=10,e.LongPressDelay=500,e.DoubleClickDelay=300,e.ExclusiveDoubleClickMode=!1,e}(),w=i(51),L=i(10),N=i(86),F=i(138),B=i(54);i.d(t,"a",function(){return U});var U=function(e){function t(i,r){var o=e.call(this)||this;o._inputManager=new D(o),o.cameraToUseForPointers=null,o._isScene=!0,o._blockEntityCollection=!1,o.autoClear=!0,o.autoClearDepthAndStencil=!0,o.clearColor=new L.b(.2,.2,.3,1),o.ambientColor=new L.a(0,0,0),o._environmentIntensity=1,o._forceWireframe=!1,o._skipFrustumClipping=!1,o._forcePointsCloud=!1,o.animationsEnabled=!0,o._animationPropertiesOverride=null,o.useConstantAnimationDeltaTime=!1,o.constantlyUpdateMeshUnderPointer=!1,o.hoverCursor="pointer",o.defaultCursor="",o.doNotHandleCursors=!1,o.preventDefaultOnPointerDown=!0,o.preventDefaultOnPointerUp=!0,o.metadata=null,o.reservedDataStore=null,o.disableOfflineSupportExceptionRules=new Array,o.onDisposeObservable=new a.c,o._onDisposeObserver=null,o.onBeforeRenderObservable=new a.c,o._onBeforeRenderObserver=null,o.onAfterRenderObservable=new a.c,o.onAfterRenderCameraObservable=new a.c,o._onAfterRenderObserver=null,o.onBeforeAnimationsObservable=new a.c,o.onAfterAnimationsObservable=new a.c,o.onBeforeDrawPhaseObservable=new a.c,o.onAfterDrawPhaseObservable=new a.c,o.onReadyObservable=new a.c,o.onBeforeCameraRenderObservable=new a.c,o._onBeforeCameraRenderObserver=null,o.onAfterCameraRenderObservable=new a.c,o._onAfterCameraRenderObserver=null,o.onBeforeActiveMeshesEvaluationObservable=new a.c,o.onAfterActiveMeshesEvaluationObservable=new a.c,o.onBeforeParticlesRenderingObservable=new a.c,o.onAfterParticlesRenderingObservable=new a.c,o.onDataLoadedObservable=new a.c,o.onNewCameraAddedObservable=new a.c,o.onCameraRemovedObservable=new a.c,o.onNewLightAddedObservable=new a.c,o.onLightRemovedObservable=new a.c,o.onNewGeometryAddedObservable=new a.c,o.onGeometryRemovedObservable=new a.c,o.onNewTransformNodeAddedObservable=new a.c,o.onTransformNodeRemovedObservable=new a.c,o.onNewMeshAddedObservable=new a.c,o.onMeshRemovedObservable=new a.c,o.onNewSkeletonAddedObservable=new a.c,o.onSkeletonRemovedObservable=new a.c,o.onNewMaterialAddedObservable=new a.c,o.onMaterialRemovedObservable=new a.c,o.onNewTextureAddedObservable=new a.c,o.onTextureRemovedObservable=new a.c,o.onBeforeRenderTargetsRenderObservable=new a.c,o.onAfterRenderTargetsRenderObservable=new a.c,o.onBeforeStepObservable=new a.c,o.onAfterStepObservable=new a.c,o.onActiveCameraChanged=new a.c,o.onBeforeRenderingGroupObservable=new a.c,o.onAfterRenderingGroupObservable=new a.c,o.onMeshImportedObservable=new a.c,o.onAnimationFileImportedObservable=new a.c,o._registeredForLateAnimationBindings=new s.b(256),o.onPrePointerObservable=new a.c,o.onPointerObservable=new a.c,o.onPreKeyboardObservable=new a.c,o.onKeyboardObservable=new a.c,o._useRightHandedSystem=!1,o._timeAccumulator=0,o._currentStepId=0,o._currentInternalStep=0,o._fogEnabled=!0,o._fogMode=t.FOGMODE_NONE,o.fogColor=new L.a(.2,.2,.3),o.fogDensity=.1,o.fogStart=0,o.fogEnd=1e3,o._shadowsEnabled=!0,o._lightsEnabled=!0,o.activeCameras=new Array,o._texturesEnabled=!0,o.particlesEnabled=!0,o.spritesEnabled=!0,o._skeletonsEnabled=!0,o.lensFlaresEnabled=!0,o.collisionsEnabled=!0,o.gravity=new u.e(0,-9.807,0),o.postProcessesEnabled=!0,o.postProcesses=new Array,o.renderTargetsEnabled=!0,o.dumpNextRenderTargets=!1,o.customRenderTargets=new Array,o.importedMeshesFiles=new Array,o.probesEnabled=!0,o._meshesForIntersections=new s.b(256),o.proceduralTexturesEnabled=!0,o._totalVertices=new w.a,o._activeIndices=new w.a,o._activeParticles=new w.a,o._activeBones=new w.a,o._animationTime=0,o.animationTimeScale=1,o._renderId=0,o._frameId=0,o._executeWhenReadyTimeoutId=-1,o._intermediateRendering=!1,o._viewUpdateFlag=-1,o._projectionUpdateFlag=-1,o._toBeDisposed=new Array(256),o._activeRequests=new Array,o._pendingData=new Array,o._isDisposed=!1,o.dispatchAllSubMeshesOfActiveMeshes=!1,o._activeMeshes=new s.a(256),o._processedMaterials=new s.a(256),o._renderTargets=new s.b(256),o._activeParticleSystems=new s.a(256),o._activeSkeletons=new s.b(32),o._softwareSkinnedMeshes=new s.b(32),o._activeAnimatables=new Array,o._transformMatrix=u.a.Zero(),o.requireLightSorting=!1,o._components=[],o._serializableComponents=[],o._transientComponents=[],o._beforeCameraUpdateStage=E.b.Create(),o._beforeClearStage=E.b.Create(),o._gatherRenderTargetsStage=E.b.Create(),o._gatherActiveCameraRenderTargetsStage=E.b.Create(),o._isReadyForMeshStage=E.b.Create(),o._beforeEvaluateActiveMeshStage=E.b.Create(),o._evaluateSubMeshStage=E.b.Create(),o._activeMeshStage=E.b.Create(),o._cameraDrawRenderTargetStage=E.b.Create(),o._beforeCameraDrawStage=E.b.Create(),o._beforeRenderTargetDrawStage=E.b.Create(),o._beforeRenderingGroupDrawStage=E.b.Create(),o._beforeRenderingMeshStage=E.b.Create(),o._afterRenderingMeshStage=E.b.Create(),o._afterRenderingGroupDrawStage=E.b.Create(),o._afterCameraDrawStage=E.b.Create(),o._afterRenderTargetDrawStage=E.b.Create(),o._afterRenderStage=E.b.Create(),o._pointerMoveStage=E.b.Create(),o._pointerDownStage=E.b.Create(),o._pointerUpStage=E.b.Create(),o.geometriesByUniqueId=null,o._defaultMeshCandidates={data:[],length:0},o._defaultSubMeshCandidates={data:[],length:0},o._preventFreeActiveMeshesAndRenderingGroups=!1,o._activeMeshesFrozen=!1,o._skipEvaluateActiveMeshesCompletely=!1,o._allowPostProcessClearColor=!0,o.getDeterministicFrameTime=function(){return o._engine.getTimeStep()},o._blockMaterialDirtyMechanism=!1;var c=Object(n.a)({useGeometryUniqueIdsMap:!0,useMaterialMeshMap:!0,useClonedMeshMap:!0,virtual:!1},r);return o._engine=i||S.a.LastCreatedEngine,c.virtual||(S.a._LastCreatedScene=o,o._engine.scenes.push(o)),o._uid=null,o._renderingManager=new T.b(o),b.a&&(o.postProcessManager=new b.a(o)),P.a.IsWindowObjectExist()&&o.attachControl(),o._createUbo(),_.a&&(o._imageProcessingConfiguration=new _.a),o.setDefaultCandidateProviders(),c.useGeometryUniqueIdsMap&&(o.geometriesByUniqueId={}),o.useMaterialMeshMap=c.useMaterialMeshMap,o.useClonedMeshMap=c.useClonedMeshMap,r&&r.virtual||o._engine.onNewSceneAddedObservable.notifyObservers(o),o}return Object(n.d)(t,e),t.DefaultMaterialFactory=function(e){throw C.a.WarnImport("StandardMaterial")},t.CollisionCoordinatorFactory=function(){throw C.a.WarnImport("DefaultCollisionCoordinator")},Object.defineProperty(t.prototype,"environmentTexture",{get:function(){return this._environmentTexture},set:function(e){this._environmentTexture!==e&&(this._environmentTexture=e,this.markAllMaterialsAsDirty(x.a.MATERIAL_TextureDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"environmentIntensity",{get:function(){return this._environmentIntensity},set:function(e){this._environmentIntensity!==e&&(this._environmentIntensity=e,this.markAllMaterialsAsDirty(x.a.MATERIAL_TextureDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"imageProcessingConfiguration",{get:function(){return this._imageProcessingConfiguration},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"forceWireframe",{get:function(){return this._forceWireframe},set:function(e){this._forceWireframe!==e&&(this._forceWireframe=e,this.markAllMaterialsAsDirty(x.a.MATERIAL_MiscDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"skipFrustumClipping",{get:function(){return this._skipFrustumClipping},set:function(e){this._skipFrustumClipping!==e&&(this._skipFrustumClipping=e)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"forcePointsCloud",{get:function(){return this._forcePointsCloud},set:function(e){this._forcePointsCloud!==e&&(this._forcePointsCloud=e,this.markAllMaterialsAsDirty(x.a.MATERIAL_MiscDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"animationPropertiesOverride",{get:function(){return this._animationPropertiesOverride},set:function(e){this._animationPropertiesOverride=e},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"onDispose",{set:function(e){this._onDisposeObserver&&this.onDisposeObservable.remove(this._onDisposeObserver),this._onDisposeObserver=this.onDisposeObservable.add(e)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"beforeRender",{set:function(e){this._onBeforeRenderObserver&&this.onBeforeRenderObservable.remove(this._onBeforeRenderObserver),e&&(this._onBeforeRenderObserver=this.onBeforeRenderObservable.add(e))},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"afterRender",{set:function(e){this._onAfterRenderObserver&&this.onAfterRenderObservable.remove(this._onAfterRenderObserver),e&&(this._onAfterRenderObserver=this.onAfterRenderObservable.add(e))},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"beforeCameraRender",{set:function(e){this._onBeforeCameraRenderObserver&&this.onBeforeCameraRenderObservable.remove(this._onBeforeCameraRenderObserver),this._onBeforeCameraRenderObserver=this.onBeforeCameraRenderObservable.add(e)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"afterCameraRender",{set:function(e){this._onAfterCameraRenderObserver&&this.onAfterCameraRenderObservable.remove(this._onAfterCameraRenderObserver),this._onAfterCameraRenderObserver=this.onAfterCameraRenderObservable.add(e)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"unTranslatedPointer",{get:function(){return this._inputManager.unTranslatedPointer},enumerable:!0,configurable:!0}),Object.defineProperty(t,"DragMovementThreshold",{get:function(){return D.DragMovementThreshold},set:function(e){D.DragMovementThreshold=e},enumerable:!0,configurable:!0}),Object.defineProperty(t,"LongPressDelay",{get:function(){return D.LongPressDelay},set:function(e){D.LongPressDelay=e},enumerable:!0,configurable:!0}),Object.defineProperty(t,"DoubleClickDelay",{get:function(){return D.DoubleClickDelay},set:function(e){D.DoubleClickDelay=e},enumerable:!0,configurable:!0}),Object.defineProperty(t,"ExclusiveDoubleClickMode",{get:function(){return D.ExclusiveDoubleClickMode},set:function(e){D.ExclusiveDoubleClickMode=e},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"useRightHandedSystem",{get:function(){return this._useRightHandedSystem},set:function(e){this._useRightHandedSystem!==e&&(this._useRightHandedSystem=e,this.markAllMaterialsAsDirty(x.a.MATERIAL_MiscDirtyFlag))},enumerable:!0,configurable:!0}),t.prototype.setStepId=function(e){this._currentStepId=e},t.prototype.getStepId=function(){return this._currentStepId},t.prototype.getInternalStep=function(){return this._currentInternalStep},Object.defineProperty(t.prototype,"fogEnabled",{get:function(){return this._fogEnabled},set:function(e){this._fogEnabled!==e&&(this._fogEnabled=e,this.markAllMaterialsAsDirty(x.a.MATERIAL_MiscDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"fogMode",{get:function(){return this._fogMode},set:function(e){this._fogMode!==e&&(this._fogMode=e,this.markAllMaterialsAsDirty(x.a.MATERIAL_MiscDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"shadowsEnabled",{get:function(){return this._shadowsEnabled},set:function(e){this._shadowsEnabled!==e&&(this._shadowsEnabled=e,this.markAllMaterialsAsDirty(x.a.MATERIAL_LightDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"lightsEnabled",{get:function(){return this._lightsEnabled},set:function(e){this._lightsEnabled!==e&&(this._lightsEnabled=e,this.markAllMaterialsAsDirty(x.a.MATERIAL_LightDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"activeCamera",{get:function(){return this._activeCamera},set:function(e){e!==this._activeCamera&&(this._activeCamera=e,this.onActiveCameraChanged.notifyObservers(this))},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"defaultMaterial",{get:function(){return this._defaultMaterial||(this._defaultMaterial=t.DefaultMaterialFactory(this)),this._defaultMaterial},set:function(e){this._defaultMaterial=e},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"texturesEnabled",{get:function(){return this._texturesEnabled},set:function(e){this._texturesEnabled!==e&&(this._texturesEnabled=e,this.markAllMaterialsAsDirty(x.a.MATERIAL_TextureDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"skeletonsEnabled",{get:function(){return this._skeletonsEnabled},set:function(e){this._skeletonsEnabled!==e&&(this._skeletonsEnabled=e,this.markAllMaterialsAsDirty(x.a.MATERIAL_AttributesDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"collisionCoordinator",{get:function(){return this._collisionCoordinator||(this._collisionCoordinator=t.CollisionCoordinatorFactory(),this._collisionCoordinator.init(this)),this._collisionCoordinator},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"frustumPlanes",{get:function(){return this._frustumPlanes},enumerable:!0,configurable:!0}),t.prototype._registerTransientComponents=function(){if(this._transientComponents.length>0){for(var e=0,t=this._transientComponents;e<t.length;e++){t[e].register()}this._transientComponents=[]}},t.prototype._addComponent=function(e){this._components.push(e),this._transientComponents.push(e);var t=e;t.addFromContainer&&t.serialize&&this._serializableComponents.push(t)},t.prototype._getComponent=function(e){for(var t=0,i=this._components;t<i.length;t++){var n=i[t];if(n.name===e)return n}return null},t.prototype.getClassName=function(){return"Scene"},t.prototype._getDefaultMeshCandidates=function(){return this._defaultMeshCandidates.data=this.meshes,this._defaultMeshCandidates.length=this.meshes.length,this._defaultMeshCandidates},t.prototype._getDefaultSubMeshCandidates=function(e){return this._defaultSubMeshCandidates.data=e.subMeshes,this._defaultSubMeshCandidates.length=e.subMeshes.length,this._defaultSubMeshCandidates},t.prototype.setDefaultCandidateProviders=function(){this.getActiveMeshCandidates=this._getDefaultMeshCandidates.bind(this),this.getActiveSubMeshCandidates=this._getDefaultSubMeshCandidates.bind(this),this.getIntersectingSubMeshCandidates=this._getDefaultSubMeshCandidates.bind(this),this.getCollidingSubMeshCandidates=this._getDefaultSubMeshCandidates.bind(this)},Object.defineProperty(t.prototype,"meshUnderPointer",{get:function(){return this._inputManager.meshUnderPointer},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"pointerX",{get:function(){return this._inputManager.pointerX},set:function(e){this._inputManager.pointerX=e},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"pointerY",{get:function(){return this._inputManager.pointerY},set:function(e){this._inputManager.pointerY=e},enumerable:!0,configurable:!0}),t.prototype.getCachedMaterial=function(){return this._cachedMaterial},t.prototype.getCachedEffect=function(){return this._cachedEffect},t.prototype.getCachedVisibility=function(){return this._cachedVisibility},t.prototype.isCachedMaterialInvalid=function(e,t,i){return void 0===i&&(i=1),this._cachedEffect!==t||this._cachedMaterial!==e||this._cachedVisibility!==i},t.prototype.getEngine=function(){return this._engine},t.prototype.getTotalVertices=function(){return this._totalVertices.current},Object.defineProperty(t.prototype,"totalVerticesPerfCounter",{get:function(){return this._totalVertices},enumerable:!0,configurable:!0}),t.prototype.getActiveIndices=function(){return this._activeIndices.current},Object.defineProperty(t.prototype,"totalActiveIndicesPerfCounter",{get:function(){return this._activeIndices},enumerable:!0,configurable:!0}),t.prototype.getActiveParticles=function(){return this._activeParticles.current},Object.defineProperty(t.prototype,"activeParticlesPerfCounter",{get:function(){return this._activeParticles},enumerable:!0,configurable:!0}),t.prototype.getActiveBones=function(){return this._activeBones.current},Object.defineProperty(t.prototype,"activeBonesPerfCounter",{get:function(){return this._activeBones},enumerable:!0,configurable:!0}),t.prototype.getActiveMeshes=function(){return this._activeMeshes},t.prototype.getAnimationRatio=function(){return void 0!==this._animationRatio?this._animationRatio:1},t.prototype.getRenderId=function(){return this._renderId},t.prototype.getFrameId=function(){return this._frameId},t.prototype.incrementRenderId=function(){this._renderId++},t.prototype._createUbo=function(){this._sceneUbo=new m.a(this._engine,void 0,!0),this._sceneUbo.addUniform("viewProjection",16),this._sceneUbo.addUniform("view",16)},t.prototype.simulatePointerMove=function(e,t){return this._inputManager.simulatePointerMove(e,t),this},t.prototype.simulatePointerDown=function(e,t){return this._inputManager.simulatePointerDown(e,t),this},t.prototype.simulatePointerUp=function(e,t,i){return this._inputManager.simulatePointerUp(e,t,i),this},t.prototype.isPointerCaptured=function(e){return void 0===e&&(e=0),this._inputManager.isPointerCaptured(e)},t.prototype.attachControl=function(e,t,i){void 0===e&&(e=!0),void 0===t&&(t=!0),void 0===i&&(i=!0),this._inputManager.attachControl(e,t,i)},t.prototype.detachControl=function(){this._inputManager.detachControl()},t.prototype.isReady=function(){if(this._isDisposed)return!1;var e,t=this.getEngine();if(!t.areAllEffectsReady())return!1;if(this._pendingData.length>0)return!1;for(e=0;e<this.meshes.length;e++){var i=this.meshes[e];if(i.isEnabled()&&(i.subMeshes&&0!==i.subMeshes.length)){if(!i.isReady(!0))return!1;for(var n="InstancedMesh"===i.getClassName()||"InstancedLinesMesh"===i.getClassName()||t.getCaps().instancedArrays&&i.instances.length>0,r=0,o=this._isReadyForMeshStage;r<o.length;r++){if(!o[r].action(i,n))return!1}}}for(e=0;e<this.geometries.length;e++){if(this.geometries[e].delayLoadState===x.a.DELAYLOADSTATE_LOADING)return!1}if(this.activeCameras&&this.activeCameras.length>0)for(var a=0,s=this.activeCameras;a<s.length;a++){if(!s[a].isReady(!0))return!1}else if(this.activeCamera&&!this.activeCamera.isReady(!0))return!1;for(var c=0,l=this.particleSystems;c<l.length;c++){if(!l[c].isReady())return!1}return!0},t.prototype.resetCachedMaterial=function(){this._cachedMaterial=null,this._cachedEffect=null,this._cachedVisibility=null},t.prototype.registerBeforeRender=function(e){this.onBeforeRenderObservable.add(e)},t.prototype.unregisterBeforeRender=function(e){this.onBeforeRenderObservable.removeCallback(e)},t.prototype.registerAfterRender=function(e){this.onAfterRenderObservable.add(e)},t.prototype.unregisterAfterRender=function(e){this.onAfterRenderObservable.removeCallback(e)},t.prototype._executeOnceBeforeRender=function(e){var t=this,i=function(){e(),setTimeout(function(){t.unregisterBeforeRender(i)})};this.registerBeforeRender(i)},t.prototype.executeOnceBeforeRender=function(e,t){var i=this;void 0!==t?setTimeout(function(){i._executeOnceBeforeRender(e)},t):this._executeOnceBeforeRender(e)},t.prototype._addPendingData=function(e){this._pendingData.push(e)},t.prototype._removePendingData=function(e){var t=this.isLoading,i=this._pendingData.indexOf(e);-1!==i&&this._pendingData.splice(i,1),t&&!this.isLoading&&this.onDataLoadedObservable.notifyObservers(this)},t.prototype.getWaitingItemsCount=function(){return this._pendingData.length},Object.defineProperty(t.prototype,"isLoading",{get:function(){return this._pendingData.length>0},enumerable:!0,configurable:!0}),t.prototype.executeWhenReady=function(e){var t=this;this.onReadyObservable.add(e),-1===this._executeWhenReadyTimeoutId&&(this._executeWhenReadyTimeoutId=setTimeout(function(){t._checkIsReady()},150))},t.prototype.whenReadyAsync=function(){var e=this;return new Promise(function(t){e.executeWhenReady(function(){t()})})},t.prototype._checkIsReady=function(){var e=this;return this._registerTransientComponents(),this.isReady()?(this.onReadyObservable.notifyObservers(this),this.onReadyObservable.clear(),void(this._executeWhenReadyTimeoutId=-1)):this._isDisposed?(this.onReadyObservable.clear(),void(this._executeWhenReadyTimeoutId=-1)):void(this._executeWhenReadyTimeoutId=setTimeout(function(){e._checkIsReady()},150))},Object.defineProperty(t.prototype,"animatables",{get:function(){return this._activeAnimatables},enumerable:!0,configurable:!0}),t.prototype.resetLastAnimationTimeFrame=function(){this._animationTimeLast=o.a.Now},t.prototype.getViewMatrix=function(){return this._viewMatrix},t.prototype.getProjectionMatrix=function(){return this._projectionMatrix},t.prototype.getTransformMatrix=function(){return this._transformMatrix},t.prototype.setTransformMatrix=function(e,t,i,n){this._viewUpdateFlag===e.updateFlag&&this._projectionUpdateFlag===t.updateFlag||(this._viewUpdateFlag=e.updateFlag,this._projectionUpdateFlag=t.updateFlag,this._viewMatrix=e,this._projectionMatrix=t,this._viewMatrix.multiplyToRef(this._projectionMatrix,this._transformMatrix),this._frustumPlanes?N.a.GetPlanesToRef(this._transformMatrix,this._frustumPlanes):this._frustumPlanes=N.a.GetPlanes(this._transformMatrix),this._multiviewSceneUbo&&this._multiviewSceneUbo.useUbo?this._updateMultiviewUbo(i,n):this._sceneUbo.useUbo&&(this._sceneUbo.updateMatrix("viewProjection",this._transformMatrix),this._sceneUbo.updateMatrix("view",this._viewMatrix),this._sceneUbo.update()))},t.prototype.getSceneUniformBuffer=function(){return this._multiviewSceneUbo?this._multiviewSceneUbo:this._sceneUbo},t.prototype.getUniqueId=function(){return F.a.UniqueId},t.prototype.addMesh=function(e,t){var i=this;void 0===t&&(t=!1),this._blockEntityCollection||(this.meshes.push(e),e._resyncLightSources(),e.parent||e._addToSceneRootNodes(),this.onNewMeshAddedObservable.notifyObservers(e),t&&e.getChildMeshes().forEach(function(e){i.addMesh(e)}))},t.prototype.removeMesh=function(e,t){var i=this;void 0===t&&(t=!1);var n=this.meshes.indexOf(e);return-1!==n&&(this.meshes[n]=this.meshes[this.meshes.length-1],this.meshes.pop(),e.parent||e._removeFromSceneRootNodes()),this.onMeshRemovedObservable.notifyObservers(e),t&&e.getChildMeshes().forEach(function(e){i.removeMesh(e)}),n},t.prototype.addTransformNode=function(e){this._blockEntityCollection||(e._indexInSceneTransformNodesArray=this.transformNodes.length,this.transformNodes.push(e),e.parent||e._addToSceneRootNodes(),this.onNewTransformNodeAddedObservable.notifyObservers(e))},t.prototype.removeTransformNode=function(e){var t=e._indexInSceneTransformNodesArray;if(-1!==t){if(t!==this.transformNodes.length-1){var i=this.transformNodes[this.transformNodes.length-1];this.transformNodes[t]=i,i._indexInSceneTransformNodesArray=t}e._indexInSceneTransformNodesArray=-1,this.transformNodes.pop(),e.parent||e._removeFromSceneRootNodes()}return this.onTransformNodeRemovedObservable.notifyObservers(e),t},t.prototype.removeSkeleton=function(e){var t=this.skeletons.indexOf(e);return-1!==t&&(this.skeletons.splice(t,1),this.onSkeletonRemovedObservable.notifyObservers(e)),t},t.prototype.removeMorphTargetManager=function(e){var t=this.morphTargetManagers.indexOf(e);return-1!==t&&this.morphTargetManagers.splice(t,1),t},t.prototype.removeLight=function(e){var t=this.lights.indexOf(e);if(-1!==t){for(var i=0,n=this.meshes;i<n.length;i++){n[i]._removeLightSource(e,!1)}this.lights.splice(t,1),this.sortLightsByPriority(),e.parent||e._removeFromSceneRootNodes()}return this.onLightRemovedObservable.notifyObservers(e),t},t.prototype.removeCamera=function(e){var t=this.cameras.indexOf(e);-1!==t&&(this.cameras.splice(t,1),e.parent||e._removeFromSceneRootNodes());var i=this.activeCameras.indexOf(e);return-1!==i&&this.activeCameras.splice(i,1),this.activeCamera===e&&(this.cameras.length>0?this.activeCamera=this.cameras[0]:this.activeCamera=null),this.onCameraRemovedObservable.notifyObservers(e),t},t.prototype.removeParticleSystem=function(e){var t=this.particleSystems.indexOf(e);return-1!==t&&this.particleSystems.splice(t,1),t},t.prototype.removeAnimation=function(e){var t=this.animations.indexOf(e);return-1!==t&&this.animations.splice(t,1),t},t.prototype.stopAnimation=function(e,t,i){},t.prototype.removeAnimationGroup=function(e){var t=this.animationGroups.indexOf(e);return-1!==t&&this.animationGroups.splice(t,1),t},t.prototype.removeMultiMaterial=function(e){var t=this.multiMaterials.indexOf(e);return-1!==t&&this.multiMaterials.splice(t,1),t},t.prototype.removeMaterial=function(e){var t=e._indexInSceneMaterialArray;if(-1!==t&&t<this.materials.length){if(t!==this.materials.length-1){var i=this.materials[this.materials.length-1];this.materials[t]=i,i._indexInSceneMaterialArray=t}e._indexInSceneMaterialArray=-1,this.materials.pop()}return this.onMaterialRemovedObservable.notifyObservers(e),t},t.prototype.removeActionManager=function(e){var t=this.actionManagers.indexOf(e);return-1!==t&&this.actionManagers.splice(t,1),t},t.prototype.removeTexture=function(e){var t=this.textures.indexOf(e);return-1!==t&&this.textures.splice(t,1),this.onTextureRemovedObservable.notifyObservers(e),t},t.prototype.addLight=function(e){if(!this._blockEntityCollection){this.lights.push(e),this.sortLightsByPriority(),e.parent||e._addToSceneRootNodes();for(var t=0,i=this.meshes;t<i.length;t++){var n=i[t];-1===n.lightSources.indexOf(e)&&(n.lightSources.push(e),n._resyncLightSources())}this.onNewLightAddedObservable.notifyObservers(e)}},t.prototype.sortLightsByPriority=function(){this.requireLightSorting&&this.lights.sort(g.a.CompareLightsPriority)},t.prototype.addCamera=function(e){this._blockEntityCollection||(this.cameras.push(e),this.onNewCameraAddedObservable.notifyObservers(e),e.parent||e._addToSceneRootNodes())},t.prototype.addSkeleton=function(e){this._blockEntityCollection||(this.skeletons.push(e),this.onNewSkeletonAddedObservable.notifyObservers(e))},t.prototype.addParticleSystem=function(e){this._blockEntityCollection||this.particleSystems.push(e)},t.prototype.addAnimation=function(e){this._blockEntityCollection||this.animations.push(e)},t.prototype.addAnimationGroup=function(e){this._blockEntityCollection||this.animationGroups.push(e)},t.prototype.addMultiMaterial=function(e){this._blockEntityCollection||this.multiMaterials.push(e)},t.prototype.addMaterial=function(e){this._blockEntityCollection||(e._indexInSceneMaterialArray=this.materials.length,this.materials.push(e),this.onNewMaterialAddedObservable.notifyObservers(e))},t.prototype.addMorphTargetManager=function(e){this._blockEntityCollection||this.morphTargetManagers.push(e)},t.prototype.addGeometry=function(e){this._blockEntityCollection||(this.geometriesByUniqueId&&(this.geometriesByUniqueId[e.uniqueId]=this.geometries.length),this.geometries.push(e))},t.prototype.addActionManager=function(e){this.actionManagers.push(e)},t.prototype.addTexture=function(e){this._blockEntityCollection||(this.textures.push(e),this.onNewTextureAddedObservable.notifyObservers(e))},t.prototype.switchActiveCamera=function(e,t){void 0===t&&(t=!0);var i=this._engine.getInputElement();i&&(this.activeCamera&&this.activeCamera.detachControl(i),this.activeCamera=e,t&&e.attachControl(i))},t.prototype.setActiveCameraByID=function(e){var t=this.getCameraByID(e);return t?(this.activeCamera=t,t):null},t.prototype.setActiveCameraByName=function(e){var t=this.getCameraByName(e);return t?(this.activeCamera=t,t):null},t.prototype.getAnimationGroupByName=function(e){for(var t=0;t<this.animationGroups.length;t++)if(this.animationGroups[t].name===e)return this.animationGroups[t];return null},t.prototype.getMaterialByUniqueID=function(e){for(var t=0;t<this.materials.length;t++)if(this.materials[t].uniqueId===e)return this.materials[t];return null},t.prototype.getMaterialByID=function(e){for(var t=0;t<this.materials.length;t++)if(this.materials[t].id===e)return this.materials[t];return null},t.prototype.getLastMaterialByID=function(e){for(var t=this.materials.length-1;t>=0;t--)if(this.materials[t].id===e)return this.materials[t];return null},t.prototype.getMaterialByName=function(e){for(var t=0;t<this.materials.length;t++)if(this.materials[t].name===e)return this.materials[t];return null},t.prototype.getTextureByUniqueID=function(e){for(var t=0;t<this.textures.length;t++)if(this.textures[t].uniqueId===e)return this.textures[t];return null},t.prototype.getCameraByID=function(e){for(var t=0;t<this.cameras.length;t++)if(this.cameras[t].id===e)return this.cameras[t];return null},t.prototype.getCameraByUniqueID=function(e){for(var t=0;t<this.cameras.length;t++)if(this.cameras[t].uniqueId===e)return this.cameras[t];return null},t.prototype.getCameraByName=function(e){for(var t=0;t<this.cameras.length;t++)if(this.cameras[t].name===e)return this.cameras[t];return null},t.prototype.getBoneByID=function(e){for(var t=0;t<this.skeletons.length;t++)for(var i=this.skeletons[t],n=0;n<i.bones.length;n++)if(i.bones[n].id===e)return i.bones[n];return null},t.prototype.getBoneByName=function(e){for(var t=0;t<this.skeletons.length;t++)for(var i=this.skeletons[t],n=0;n<i.bones.length;n++)if(i.bones[n].name===e)return i.bones[n];return null},t.prototype.getLightByName=function(e){for(var t=0;t<this.lights.length;t++)if(this.lights[t].name===e)return this.lights[t];return null},t.prototype.getLightByID=function(e){for(var t=0;t<this.lights.length;t++)if(this.lights[t].id===e)return this.lights[t];return null},t.prototype.getLightByUniqueID=function(e){for(var t=0;t<this.lights.length;t++)if(this.lights[t].uniqueId===e)return this.lights[t];return null},t.prototype.getParticleSystemByID=function(e){for(var t=0;t<this.particleSystems.length;t++)if(this.particleSystems[t].id===e)return this.particleSystems[t];return null},t.prototype.getGeometryByID=function(e){for(var t=0;t<this.geometries.length;t++)if(this.geometries[t].id===e)return this.geometries[t];return null},t.prototype._getGeometryByUniqueID=function(e){if(this.geometriesByUniqueId){var t=this.geometriesByUniqueId[e];if(void 0!==t)return this.geometries[t]}else for(var i=0;i<this.geometries.length;i++)if(this.geometries[i].uniqueId===e)return this.geometries[i];return null},t.prototype.pushGeometry=function(e,t){return!(!t&&this._getGeometryByUniqueID(e.uniqueId))&&(this.addGeometry(e),this.onNewGeometryAddedObservable.notifyObservers(e),!0)},t.prototype.removeGeometry=function(e){var t;if(this.geometriesByUniqueId){if(void 0===(t=this.geometriesByUniqueId[e.uniqueId]))return!1}else if((t=this.geometries.indexOf(e))<0)return!1;if(t!==this.geometries.length-1){var i=this.geometries[this.geometries.length-1];this.geometries[t]=i,this.geometriesByUniqueId&&(this.geometriesByUniqueId[i.uniqueId]=t,this.geometriesByUniqueId[e.uniqueId]=void 0)}return this.geometries.pop(),this.onGeometryRemovedObservable.notifyObservers(e),!0},t.prototype.getGeometries=function(){return this.geometries},t.prototype.getMeshByID=function(e){for(var t=0;t<this.meshes.length;t++)if(this.meshes[t].id===e)return this.meshes[t];return null},t.prototype.getMeshesByID=function(e){return this.meshes.filter(function(t){return t.id===e})},t.prototype.getTransformNodeByID=function(e){for(var t=0;t<this.transformNodes.length;t++)if(this.transformNodes[t].id===e)return this.transformNodes[t];return null},t.prototype.getTransformNodeByUniqueID=function(e){for(var t=0;t<this.transformNodes.length;t++)if(this.transformNodes[t].uniqueId===e)return this.transformNodes[t];return null},t.prototype.getTransformNodesByID=function(e){return this.transformNodes.filter(function(t){return t.id===e})},t.prototype.getMeshByUniqueID=function(e){for(var t=0;t<this.meshes.length;t++)if(this.meshes[t].uniqueId===e)return this.meshes[t];return null},t.prototype.getLastMeshByID=function(e){for(var t=this.meshes.length-1;t>=0;t--)if(this.meshes[t].id===e)return this.meshes[t];return null},t.prototype.getLastEntryByID=function(e){var t;for(t=this.meshes.length-1;t>=0;t--)if(this.meshes[t].id===e)return this.meshes[t];for(t=this.transformNodes.length-1;t>=0;t--)if(this.transformNodes[t].id===e)return this.transformNodes[t];for(t=this.cameras.length-1;t>=0;t--)if(this.cameras[t].id===e)return this.cameras[t];for(t=this.lights.length-1;t>=0;t--)if(this.lights[t].id===e)return this.lights[t];return null},t.prototype.getNodeByID=function(e){var t=this.getMeshByID(e);if(t)return t;var i=this.getTransformNodeByID(e);if(i)return i;var n=this.getLightByID(e);if(n)return n;var r=this.getCameraByID(e);if(r)return r;var o=this.getBoneByID(e);return o||null},t.prototype.getNodeByName=function(e){var t=this.getMeshByName(e);if(t)return t;var i=this.getTransformNodeByName(e);if(i)return i;var n=this.getLightByName(e);if(n)return n;var r=this.getCameraByName(e);if(r)return r;var o=this.getBoneByName(e);return o||null},t.prototype.getMeshByName=function(e){for(var t=0;t<this.meshes.length;t++)if(this.meshes[t].name===e)return this.meshes[t];return null},t.prototype.getTransformNodeByName=function(e){for(var t=0;t<this.transformNodes.length;t++)if(this.transformNodes[t].name===e)return this.transformNodes[t];return null},t.prototype.getLastSkeletonByID=function(e){for(var t=this.skeletons.length-1;t>=0;t--)if(this.skeletons[t].id===e)return this.skeletons[t];return null},t.prototype.getSkeletonByUniqueId=function(e){for(var t=0;t<this.skeletons.length;t++)if(this.skeletons[t].uniqueId===e)return this.skeletons[t];return null},t.prototype.getSkeletonById=function(e){for(var t=0;t<this.skeletons.length;t++)if(this.skeletons[t].id===e)return this.skeletons[t];return null},t.prototype.getSkeletonByName=function(e){for(var t=0;t<this.skeletons.length;t++)if(this.skeletons[t].name===e)return this.skeletons[t];return null},t.prototype.getMorphTargetManagerById=function(e){for(var t=0;t<this.morphTargetManagers.length;t++)if(this.morphTargetManagers[t].uniqueId===e)return this.morphTargetManagers[t];return null},t.prototype.getMorphTargetById=function(e){for(var t=0;t<this.morphTargetManagers.length;++t)for(var i=this.morphTargetManagers[t],n=0;n<i.numTargets;++n){var r=i.getTarget(n);if(r.id===e)return r}return null},t.prototype.isActiveMesh=function(e){return-1!==this._activeMeshes.indexOf(e)},Object.defineProperty(t.prototype,"uid",{get:function(){return this._uid||(this._uid=r.b.RandomId()),this._uid},enumerable:!0,configurable:!0}),t.prototype.addExternalData=function(e,t){return this._externalData||(this._externalData=new c.a),this._externalData.add(e,t)},t.prototype.getExternalData=function(e){return this._externalData?this._externalData.get(e):null},t.prototype.getOrAddExternalDataWithFactory=function(e,t){return this._externalData||(this._externalData=new c.a),this._externalData.getOrAddWithFactory(e,t)},t.prototype.removeExternalData=function(e){return this._externalData.remove(e)},t.prototype._evaluateSubMesh=function(e,t,i){if(i.hasInstances||i.isAnInstance||this.dispatchAllSubMeshesOfActiveMeshes||this._skipFrustumClipping||t.alwaysSelectAsActiveMesh||1===t.subMeshes.length||e.isInFrustum(this._frustumPlanes)){for(var n=0,r=this._evaluateSubMeshStage;n<r.length;n++){r[n].action(t,e)}var o=e.getMaterial();null!=o&&(o.hasRenderTargetTextures&&null!=o.getRenderTargetTextures&&-1===this._processedMaterials.indexOf(o)&&(this._processedMaterials.push(o),this._renderTargets.concatWithNoDuplicate(o.getRenderTargetTextures())),this._renderingManager.dispatch(e,t,o))}},t.prototype.freeProcessedMaterials=function(){this._processedMaterials.dispose()},Object.defineProperty(t.prototype,"blockfreeActiveMeshesAndRenderingGroups",{get:function(){return this._preventFreeActiveMeshesAndRenderingGroups},set:function(e){this._preventFreeActiveMeshesAndRenderingGroups!==e&&(e&&(this.freeActiveMeshes(),this.freeRenderingGroups()),this._preventFreeActiveMeshesAndRenderingGroups=e)},enumerable:!0,configurable:!0}),t.prototype.freeActiveMeshes=function(){if(!this.blockfreeActiveMeshesAndRenderingGroups&&(this._activeMeshes.dispose(),this.activeCamera&&this.activeCamera._activeMeshes&&this.activeCamera._activeMeshes.dispose(),this.activeCameras))for(var e=0;e<this.activeCameras.length;e++){var t=this.activeCameras[e];t&&t._activeMeshes&&t._activeMeshes.dispose()}},t.prototype.freeRenderingGroups=function(){if(!this.blockfreeActiveMeshesAndRenderingGroups&&(this._renderingManager&&this._renderingManager.freeRenderingGroups(),this.textures))for(var e=0;e<this.textures.length;e++){var t=this.textures[e];t&&t.renderList&&t.freeRenderingGroups()}},t.prototype._isInIntermediateRendering=function(){return this._intermediateRendering},t.prototype.freezeActiveMeshes=function(e){var t=this;return void 0===e&&(e=!1),this.executeWhenReady(function(){if(t.activeCamera){t._frustumPlanes||t.setTransformMatrix(t.activeCamera.getViewMatrix(),t.activeCamera.getProjectionMatrix()),t._evaluateActiveMeshes(),t._activeMeshesFrozen=!0,t._skipEvaluateActiveMeshesCompletely=e;for(var i=0;i<t._activeMeshes.length;i++)t._activeMeshes.data[i]._freeze()}}),this},t.prototype.unfreezeActiveMeshes=function(){for(var e=0;e<this.meshes.length;e++){var t=this.meshes[e];t._internalAbstractMeshDataInfo&&(t._internalAbstractMeshDataInfo._isActive=!1)}for(e=0;e<this._activeMeshes.length;e++)this._activeMeshes.data[e]._unFreeze();return this._activeMeshesFrozen=!1,this},t.prototype._evaluateActiveMeshes=function(){if(this._activeMeshesFrozen&&this._activeMeshes.length){if(!this._skipEvaluateActiveMeshesCompletely)for(var e=this._activeMeshes.length,t=0;t<e;t++){(a=this._activeMeshes.data[t]).computeWorldMatrix()}}else if(this.activeCamera){this.onBeforeActiveMeshesEvaluationObservable.notifyObservers(this),this.activeCamera._activeMeshes.reset(),this._activeMeshes.reset(),this._renderingManager.reset(),this._processedMaterials.reset(),this._activeParticleSystems.reset(),this._activeSkeletons.reset(),this._softwareSkinnedMeshes.reset();for(var i=0,n=this._beforeEvaluateActiveMeshStage;i<n.length;i++){n[i].action()}var r=this.getActiveMeshCandidates(),o=r.length;for(t=0;t<o;t++){var a;if(!(a=r.data[t]).isBlocked&&(this._totalVertices.addCount(a.getTotalVertices(),!1),a.isReady()&&a.isEnabled()&&0!==a.scaling.lengthSquared())){a.computeWorldMatrix(),a.actionManager&&a.actionManager.hasSpecificTriggers2(x.a.ACTION_OnIntersectionEnterTrigger,x.a.ACTION_OnIntersectionExitTrigger)&&this._meshesForIntersections.pushNoDuplicate(a);var s=this.customLODSelector?this.customLODSelector(a,this.activeCamera):a.getLOD(this.activeCamera);null!=s&&(s!==a&&s.billboardMode!==h.a.BILLBOARDMODE_NONE&&s.computeWorldMatrix(),a._preActivate(),a.isVisible&&a.visibility>0&&0!=(a.layerMask&this.activeCamera.layerMask)&&(this._skipFrustumClipping||a.alwaysSelectAsActiveMesh||a.isInFrustum(this._frustumPlanes))&&(this._activeMeshes.push(a),this.activeCamera._activeMeshes.push(a),s!==a&&s._activate(this._renderId,!1),a._activate(this._renderId,!1)&&(a.isAnInstance?a._internalAbstractMeshDataInfo._actAsRegularMesh&&(s=a):s._internalAbstractMeshDataInfo._onlyForInstances=!1,s._internalAbstractMeshDataInfo._isActive=!0,this._activeMesh(a,s)),a._postActivate()))}}if(this.onAfterActiveMeshesEvaluationObservable.notifyObservers(this),this.particlesEnabled){this.onBeforeParticlesRenderingObservable.notifyObservers(this);for(var c=0;c<this.particleSystems.length;c++){var l=this.particleSystems[c];if(l.isStarted()&&l.emitter){var u=l.emitter;u.position&&!u.isEnabled()||(this._activeParticleSystems.push(l),l.animate(),this._renderingManager.dispatchParticles(l))}}this.onAfterParticlesRenderingObservable.notifyObservers(this)}}},t.prototype._activeMesh=function(e,t){this._skeletonsEnabled&&null!==t.skeleton&&void 0!==t.skeleton&&(this._activeSkeletons.pushNoDuplicate(t.skeleton)&&t.skeleton.prepare(),t.computeBonesUsingShaders||this._softwareSkinnedMeshes.pushNoDuplicate(t));for(var i=0,n=this._activeMeshStage;i<n.length;i++){n[i].action(e,t)}if(null!=t&&void 0!==t.subMeshes&&null!==t.subMeshes&&t.subMeshes.length>0)for(var r=this.getActiveSubMeshCandidates(t),o=r.length,a=0;a<o;a++){var s=r.data[a];this._evaluateSubMesh(s,t,e)}},t.prototype.updateTransformMatrix=function(e){this.activeCamera&&this.setTransformMatrix(this.activeCamera.getViewMatrix(),this.activeCamera.getProjectionMatrix(e))},t.prototype._bindFrameBuffer=function(){if(this.activeCamera&&this.activeCamera._multiviewTexture)this.activeCamera._multiviewTexture._bindFrameBuffer();else if(this.activeCamera&&this.activeCamera.outputRenderTarget){if(this.getEngine().getCaps().multiview&&this.activeCamera.outputRenderTarget&&this.activeCamera.outputRenderTarget.getViewCount()>1)this.activeCamera.outputRenderTarget._bindFrameBuffer();else{var e=this.activeCamera.outputRenderTarget.getInternalTexture();e?this.getEngine().bindFramebuffer(e):A.a.Error("Camera contains invalid customDefaultRenderTarget")}}else this.getEngine().restoreDefaultFramebuffer()},t.prototype._renderForCamera=function(e,t){if(!e||!e._skipRendering){var i=this._engine;if(this._activeCamera=e,!this.activeCamera)throw new Error("Active camera not set");i.setViewport(this.activeCamera.viewport),this.resetCachedMaterial(),this._renderId++,this.getEngine().getCaps().multiview&&e.outputRenderTarget&&e.outputRenderTarget.getViewCount()>1?this.setTransformMatrix(e._rigCameras[0].getViewMatrix(),e._rigCameras[0].getProjectionMatrix(),e._rigCameras[1].getViewMatrix(),e._rigCameras[1].getProjectionMatrix()):this.updateTransformMatrix(),this.onBeforeCameraRenderObservable.notifyObservers(this.activeCamera),this._evaluateActiveMeshes();for(var n=0;n<this._softwareSkinnedMeshes.length;n++){var o=this._softwareSkinnedMeshes.data[n];o.applySkeleton(o.skeleton)}this.onBeforeRenderTargetsRenderObservable.notifyObservers(this),e.customRenderTargets&&e.customRenderTargets.length>0&&this._renderTargets.concatWithNoDuplicate(e.customRenderTargets),t&&t.customRenderTargets&&t.customRenderTargets.length>0&&this._renderTargets.concatWithNoDuplicate(t.customRenderTargets);for(var a=0,s=this._gatherActiveCameraRenderTargetsStage;a<s.length;a++){s[a].action(this._renderTargets)}if(this.renderTargetsEnabled){this._intermediateRendering=!0;var c=!1;if(this._renderTargets.length>0){r.b.StartPerformanceCounter("Render targets",this._renderTargets.length>0);for(var l=0;l<this._renderTargets.length;l++){var u=this._renderTargets.data[l];if(u._shouldRender()){this._renderId++;var h=u.activeCamera&&u.activeCamera!==this.activeCamera;u.render(h,this.dumpNextRenderTargets),c=!0}}r.b.EndPerformanceCounter("Render targets",this._renderTargets.length>0),this._renderId++}for(var d=0,f=this._cameraDrawRenderTargetStage;d<f.length;d++){c=f[d].action(this.activeCamera)||c}this._intermediateRendering=!1,this.activeCamera&&this.activeCamera.outputRenderTarget&&(c=!0),c&&this._bindFrameBuffer()}this.onAfterRenderTargetsRenderObservable.notifyObservers(this),this.postProcessManager&&!e._multiviewTexture&&this.postProcessManager._prepareFrame();for(var p=0,_=this._beforeCameraDrawStage;p<_.length;p++){_[p].action(this.activeCamera)}this.onBeforeDrawPhaseObservable.notifyObservers(this),this._renderingManager.render(null,null,!0,!0),this.onAfterDrawPhaseObservable.notifyObservers(this);for(var m=0,g=this._afterCameraDrawStage;m<g.length;m++){g[m].action(this.activeCamera)}this.postProcessManager&&!e._multiviewTexture&&this.postProcessManager._finalizeFrame(e.isIntermediate),this._renderTargets.reset(),this.onAfterCameraRenderObservable.notifyObservers(this.activeCamera)}},t.prototype._processSubCameras=function(e){if(e.cameraRigMode===f.a.RIG_MODE_NONE||e.outputRenderTarget&&e.outputRenderTarget.getViewCount()>1&&this.getEngine().getCaps().multiview)return this._renderForCamera(e),void this.onAfterRenderCameraObservable.notifyObservers(e);if(e._useMultiviewToSingleView)this._renderMultiviewToSingleView(e);else for(var t=0;t<e._rigCameras.length;t++)this._renderForCamera(e._rigCameras[t],e);this._activeCamera=e,this.setTransformMatrix(this._activeCamera.getViewMatrix(),this._activeCamera.getProjectionMatrix()),this.onAfterRenderCameraObservable.notifyObservers(e)},t.prototype._checkIntersections=function(){for(var e=0;e<this._meshesForIntersections.length;e++){var t=this._meshesForIntersections.data[e];if(t.actionManager)for(var i=0;t.actionManager&&i<t.actionManager.actions.length;i++){var n=t.actionManager.actions[i];if(n.trigger===x.a.ACTION_OnIntersectionEnterTrigger||n.trigger===x.a.ACTION_OnIntersectionExitTrigger){var r=n.getTriggerParameter(),o=r instanceof d.a?r:r.mesh,a=o.intersectsMesh(t,r.usePreciseIntersection),s=t._intersectionsInProgress.indexOf(o);a&&-1===s?n.trigger===x.a.ACTION_OnIntersectionEnterTrigger?(n._executeCurrent(y.a.CreateNew(t,void 0,o)),t._intersectionsInProgress.push(o)):n.trigger===x.a.ACTION_OnIntersectionExitTrigger&&t._intersectionsInProgress.push(o):!a&&s>-1&&(n.trigger===x.a.ACTION_OnIntersectionExitTrigger&&n._executeCurrent(y.a.CreateNew(t,void 0,o)),t.actionManager.hasSpecificTrigger(x.a.ACTION_OnIntersectionExitTrigger,function(e){var t=e instanceof d.a?e:e.mesh;return o===t})&&n.trigger!==x.a.ACTION_OnIntersectionExitTrigger||t._intersectionsInProgress.splice(s,1))}}}},t.prototype._advancePhysicsEngineStep=function(e){},t.prototype._animate=function(){},t.prototype.animate=function(){if(this._engine.isDeterministicLockStep()){var e=Math.max(t.MinDeltaTime,Math.min(this._engine.getDeltaTime(),t.MaxDeltaTime))+this._timeAccumulator,i=this._engine.getTimeStep(),n=1e3/i/1e3,r=0,o=this._engine.getLockstepMaxSteps(),a=Math.floor(e/i);for(a=Math.min(a,o);e>0&&r<a;)this.onBeforeStepObservable.notifyObservers(this),this._animationRatio=i*n,this._animate(),this.onAfterAnimationsObservable.notifyObservers(this),this._advancePhysicsEngineStep(i),this.onAfterStepObservable.notifyObservers(this),this._currentStepId++,r++,e-=i;this._timeAccumulator=e<0?0:e}else{e=this.useConstantAnimationDeltaTime?16:Math.max(t.MinDeltaTime,Math.min(this._engine.getDeltaTime(),t.MaxDeltaTime));this._animationRatio=.06*e,this._animate(),this.onAfterAnimationsObservable.notifyObservers(this),this._advancePhysicsEngineStep(e)}},t.prototype.render=function(e,t){if(void 0===e&&(e=!0),void 0===t&&(t=!1),!this.isDisposed){this._frameId++,this._registerTransientComponents(),this._activeParticles.fetchNewFrame(),this._totalVertices.fetchNewFrame(),this._activeIndices.fetchNewFrame(),this._activeBones.fetchNewFrame(),this._meshesForIntersections.reset(),this.resetCachedMaterial(),this.onBeforeAnimationsObservable.notifyObservers(this),this.actionManager&&this.actionManager.processTrigger(x.a.ACTION_OnEveryFrameTrigger),t||this.animate();for(var i=0,n=this._beforeCameraUpdateStage;i<n.length;i++){n[i].action()}if(e)if(this.activeCameras.length>0)for(var o=0;o<this.activeCameras.length;o++){var a=this.activeCameras[o];if(a.update(),a.cameraRigMode!==f.a.RIG_MODE_NONE)for(var s=0;s<a._rigCameras.length;s++)a._rigCameras[s].update()}else if(this.activeCamera&&(this.activeCamera.update(),this.activeCamera.cameraRigMode!==f.a.RIG_MODE_NONE))for(s=0;s<this.activeCamera._rigCameras.length;s++)this.activeCamera._rigCameras[s].update();this.onBeforeRenderObservable.notifyObservers(this),this.onBeforeRenderTargetsRenderObservable.notifyObservers(this);var c=this.getEngine(),l=this.activeCamera;if(this.renderTargetsEnabled){r.b.StartPerformanceCounter("Custom render targets",this.customRenderTargets.length>0),this._intermediateRendering=!0;for(var u=0;u<this.customRenderTargets.length;u++){var h=this.customRenderTargets[u];if(h._shouldRender()){if(this._renderId++,this.activeCamera=h.activeCamera||this.activeCamera,!this.activeCamera)throw new Error("Active camera not set");c.setViewport(this.activeCamera.viewport),this.updateTransformMatrix(),h.render(l!==this.activeCamera,this.dumpNextRenderTargets)}}r.b.EndPerformanceCounter("Custom render targets",this.customRenderTargets.length>0),this._intermediateRendering=!1,this._renderId++}this.activeCamera=l,this._bindFrameBuffer(),this.onAfterRenderTargetsRenderObservable.notifyObservers(this);for(var d=0,p=this._beforeClearStage;d<p.length;d++){p[d].action()}(this.autoClearDepthAndStencil||this.autoClear)&&this._engine.clear(this.clearColor,this.autoClear||this.forceWireframe||this.forcePointsCloud,this.autoClearDepthAndStencil,this.autoClearDepthAndStencil);for(var _=0,m=this._gatherRenderTargetsStage;_<m.length;_++){m[_].action(this._renderTargets)}if(this.activeCameras.length>0)for(o=0;o<this.activeCameras.length;o++)o>0&&this._engine.clear(null,!1,!0,!0),this._processSubCameras(this.activeCameras[o]);else{if(!this.activeCamera)throw new Error("No camera defined");this._processSubCameras(this.activeCamera)}this._checkIntersections();for(var g=0,v=this._afterRenderStage;g<v.length;g++){v[g].action()}if(this.afterRender&&this.afterRender(),this.onAfterRenderObservable.notifyObservers(this),this._toBeDisposed.length){for(s=0;s<this._toBeDisposed.length;s++){var y=this._toBeDisposed[s];y&&y.dispose()}this._toBeDisposed=[]}this.dumpNextRenderTargets&&(this.dumpNextRenderTargets=!1),this._activeBones.addCount(0,!0),this._activeIndices.addCount(0,!0),this._activeParticles.addCount(0,!0)}},t.prototype.freezeMaterials=function(){for(var e=0;e<this.materials.length;e++)this.materials[e].freeze()},t.prototype.unfreezeMaterials=function(){for(var e=0;e<this.materials.length;e++)this.materials[e].unfreeze()},t.prototype.dispose=function(){this.beforeRender=null,this.afterRender=null,S.a._LastCreatedScene===this&&(S.a._LastCreatedScene=null),this.skeletons=[],this.morphTargetManagers=[],this._transientComponents=[],this._isReadyForMeshStage.clear(),this._beforeEvaluateActiveMeshStage.clear(),this._evaluateSubMeshStage.clear(),this._activeMeshStage.clear(),this._cameraDrawRenderTargetStage.clear(),this._beforeCameraDrawStage.clear(),this._beforeRenderTargetDrawStage.clear(),this._beforeRenderingGroupDrawStage.clear(),this._beforeRenderingMeshStage.clear(),this._afterRenderingMeshStage.clear(),this._afterRenderingGroupDrawStage.clear(),this._afterCameraDrawStage.clear(),this._afterRenderTargetDrawStage.clear(),this._afterRenderStage.clear(),this._beforeCameraUpdateStage.clear(),this._beforeClearStage.clear(),this._gatherRenderTargetsStage.clear(),this._gatherActiveCameraRenderTargetsStage.clear(),this._pointerMoveStage.clear(),this._pointerDownStage.clear(),this._pointerUpStage.clear();for(var e=0,t=this._components;e<t.length;e++){t[e].dispose()}this.importedMeshesFiles=new Array,this.stopAllAnimations&&this.stopAllAnimations(),this.resetCachedMaterial(),this.activeCamera&&(this.activeCamera._activeMeshes.dispose(),this.activeCamera=null),this._activeMeshes.dispose(),this._renderingManager.dispose(),this._processedMaterials.dispose(),this._activeParticleSystems.dispose(),this._activeSkeletons.dispose(),this._softwareSkinnedMeshes.dispose(),this._renderTargets.dispose(),this._registeredForLateAnimationBindings.dispose(),this._meshesForIntersections.dispose(),this._toBeDisposed=[];for(var i=0,n=this._activeRequests;i<n.length;i++){n[i].abort()}this.onDisposeObservable.notifyObservers(this),this.onDisposeObservable.clear(),this.onBeforeRenderObservable.clear(),this.onAfterRenderObservable.clear(),this.onBeforeRenderTargetsRenderObservable.clear(),this.onAfterRenderTargetsRenderObservable.clear(),this.onAfterStepObservable.clear(),this.onBeforeStepObservable.clear(),this.onBeforeActiveMeshesEvaluationObservable.clear(),this.onAfterActiveMeshesEvaluationObservable.clear(),this.onBeforeParticlesRenderingObservable.clear(),this.onAfterParticlesRenderingObservable.clear(),this.onBeforeDrawPhaseObservable.clear(),this.onAfterDrawPhaseObservable.clear(),this.onBeforeAnimationsObservable.clear(),this.onAfterAnimationsObservable.clear(),this.onDataLoadedObservable.clear(),this.onBeforeRenderingGroupObservable.clear(),this.onAfterRenderingGroupObservable.clear(),this.onMeshImportedObservable.clear(),this.onBeforeCameraRenderObservable.clear(),this.onAfterCameraRenderObservable.clear(),this.onReadyObservable.clear(),this.onNewCameraAddedObservable.clear(),this.onCameraRemovedObservable.clear(),this.onNewLightAddedObservable.clear(),this.onLightRemovedObservable.clear(),this.onNewGeometryAddedObservable.clear(),this.onGeometryRemovedObservable.clear(),this.onNewTransformNodeAddedObservable.clear(),this.onTransformNodeRemovedObservable.clear(),this.onNewMeshAddedObservable.clear(),this.onMeshRemovedObservable.clear(),this.onNewSkeletonAddedObservable.clear(),this.onSkeletonRemovedObservable.clear(),this.onNewMaterialAddedObservable.clear(),this.onMaterialRemovedObservable.clear(),this.onNewTextureAddedObservable.clear(),this.onTextureRemovedObservable.clear(),this.onPrePointerObservable.clear(),this.onPointerObservable.clear(),this.onPreKeyboardObservable.clear(),this.onKeyboardObservable.clear(),this.onActiveCameraChanged.clear(),this.detachControl();var r,o=this._engine.getInputElement();if(o)for(r=0;r<this.cameras.length;r++)this.cameras[r].detachControl(o);for(;this.animationGroups.length;)this.animationGroups[0].dispose();for(;this.lights.length;)this.lights[0].dispose();for(;this.meshes.length;)this.meshes[0].dispose(!0);for(;this.transformNodes.length;)this.transformNodes[0].dispose(!0);for(;this.cameras.length;)this.cameras[0].dispose();for(this._defaultMaterial&&this._defaultMaterial.dispose();this.multiMaterials.length;)this.multiMaterials[0].dispose();for(;this.materials.length;)this.materials[0].dispose();for(;this.particleSystems.length;)this.particleSystems[0].dispose();for(;this.postProcesses.length;)this.postProcesses[0].dispose();for(;this.textures.length;)this.textures[0].dispose();this._sceneUbo.dispose(),this._multiviewSceneUbo&&this._multiviewSceneUbo.dispose(),this.postProcessManager.dispose(),(r=this._engine.scenes.indexOf(this))>-1&&this._engine.scenes.splice(r,1),this._engine.wipeCaches(!0),this._isDisposed=!0},Object.defineProperty(t.prototype,"isDisposed",{get:function(){return this._isDisposed},enumerable:!0,configurable:!0}),t.prototype.clearCachedVertexData=function(){for(var e=0;e<this.meshes.length;e++){var t=this.meshes[e].geometry;if(t)for(var i in t._indices=[],t._vertexBuffers)t._vertexBuffers.hasOwnProperty(i)&&(t._vertexBuffers[i]._buffer._data=null)}},t.prototype.cleanCachedTextureBuffer=function(){for(var e=0,t=this.textures;e<t.length;e++){var i=t[e];i._buffer&&(i._buffer=null)}},t.prototype.getWorldExtends=function(e){var t=new u.e(Number.MAX_VALUE,Number.MAX_VALUE,Number.MAX_VALUE),i=new u.e(-Number.MAX_VALUE,-Number.MAX_VALUE,-Number.MAX_VALUE);return e=e||function(){return!0},this.meshes.filter(e).forEach(function(e){if(e.computeWorldMatrix(!0),e.subMeshes&&0!==e.subMeshes.length&&!e.infiniteDistance){var n=e.getBoundingInfo(),r=n.boundingBox.minimumWorld,o=n.boundingBox.maximumWorld;u.e.CheckExtends(r,t,i),u.e.CheckExtends(o,t,i)}}),{min:t,max:i}},t.prototype.createPickingRay=function(e,t,i,n,r){throw void 0===r&&(r=!1),C.a.WarnImport("Ray")},t.prototype.createPickingRayToRef=function(e,t,i,n,r,o){throw void 0===o&&(o=!1),C.a.WarnImport("Ray")},t.prototype.createPickingRayInCameraSpace=function(e,t,i){throw C.a.WarnImport("Ray")},t.prototype.createPickingRayInCameraSpaceToRef=function(e,t,i,n){throw C.a.WarnImport("Ray")},t.prototype.pick=function(e,t,i,n,r,o){var a=new v.a;return a._pickingUnavailable=!0,a},t.prototype.pickWithRay=function(e,t,i,n){throw C.a.WarnImport("Ray")},t.prototype.multiPick=function(e,t,i,n,r){throw C.a.WarnImport("Ray")},t.prototype.multiPickWithRay=function(e,t,i){throw C.a.WarnImport("Ray")},t.prototype.setPointerOverMesh=function(e){this._inputManager.setPointerOverMesh(e)},t.prototype.getPointerOverMesh=function(){return this._inputManager.getPointerOverMesh()},t.prototype._rebuildGeometries=function(){for(var e=0,t=this.geometries;e<t.length;e++){t[e]._rebuild()}for(var i=0,n=this.meshes;i<n.length;i++){n[i]._rebuild()}this.postProcessManager&&this.postProcessManager._rebuild();for(var r=0,o=this._components;r<o.length;r++){o[r].rebuild()}for(var a=0,s=this.particleSystems;a<s.length;a++){s[a].rebuild()}},t.prototype._rebuildTextures=function(){for(var e=0,t=this.textures;e<t.length;e++){t[e]._rebuild()}this.markAllMaterialsAsDirty(x.a.MATERIAL_TextureDirtyFlag)},t.prototype._getByTags=function(e,t,i){if(void 0===t)return e;var n=[];for(var r in i=i||function(e){},e){var o=e[r];l.a&&l.a.MatchesQuery(o,t)&&(n.push(o),i(o))}return n},t.prototype.getMeshesByTags=function(e,t){return this._getByTags(this.meshes,e,t)},t.prototype.getCamerasByTags=function(e,t){return this._getByTags(this.cameras,e,t)},t.prototype.getLightsByTags=function(e,t){return this._getByTags(this.lights,e,t)},t.prototype.getMaterialByTags=function(e,t){return this._getByTags(this.materials,e,t).concat(this._getByTags(this.multiMaterials,e,t))},t.prototype.setRenderingOrder=function(e,t,i,n){void 0===t&&(t=null),void 0===i&&(i=null),void 0===n&&(n=null),this._renderingManager.setRenderingOrder(e,t,i,n)},t.prototype.setRenderingAutoClearDepthStencil=function(e,t,i,n){void 0===i&&(i=!0),void 0===n&&(n=!0),this._renderingManager.setRenderingAutoClearDepthStencil(e,t,i,n)},t.prototype.getAutoClearDepthStencilSetup=function(e){return this._renderingManager.getAutoClearDepthStencilSetup(e)},Object.defineProperty(t.prototype,"blockMaterialDirtyMechanism",{get:function(){return this._blockMaterialDirtyMechanism},set:function(e){this._blockMaterialDirtyMechanism!==e&&(this._blockMaterialDirtyMechanism=e,e||this.markAllMaterialsAsDirty(x.a.MATERIAL_AllDirtyFlag))},enumerable:!0,configurable:!0}),t.prototype.markAllMaterialsAsDirty=function(e,t){if(!this._blockMaterialDirtyMechanism)for(var i=0,n=this.materials;i<n.length;i++){var r=n[i];t&&!t(r)||r.markAsDirty(e)}},t.prototype._loadFile=function(e,t,i,n,r,o){var a=this,s=B.a.LoadFile(e,t,i,n?this.offlineProvider:void 0,r,o);return this._activeRequests.push(s),s.onCompleteObservable.add(function(e){a._activeRequests.splice(a._activeRequests.indexOf(e),1)}),s},t.prototype._loadFileAsync=function(e,t,i,n){var r=this;return new Promise(function(o,a){r._loadFile(e,function(e){o(e)},t,i,n,function(e,t){a(t)})})},t.prototype._requestFile=function(e,t,i,n,r,o,a){var s=this,c=B.a.RequestFile(e,t,i,n?this.offlineProvider:void 0,r,o,a);return this._activeRequests.push(c),c.onCompleteObservable.add(function(e){s._activeRequests.splice(s._activeRequests.indexOf(e),1)}),c},t.prototype._requestFileAsync=function(e,t,i,n,r){var o=this;return new Promise(function(a,s){o._requestFile(e,function(e){a(e)},t,i,n,function(e){s(e)},r)})},t.prototype._readFile=function(e,t,i,n,r){var o=this,a=B.a.ReadFile(e,t,i,n,r);return this._activeRequests.push(a),a.onCompleteObservable.add(function(e){o._activeRequests.splice(o._activeRequests.indexOf(e),1)}),a},t.prototype._readFileAsync=function(e,t,i){var n=this;return new Promise(function(r,o){n._readFile(e,function(e){r(e)},t,i,function(e){o(e)})})},t.FOGMODE_NONE=0,t.FOGMODE_EXP=1,t.FOGMODE_EXP2=2,t.FOGMODE_LINEAR=3,t.MinDeltaTime=1,t.MaxDeltaTime=1e3,t}(p.a)},function(e,t,i){"use strict";i.d(t,"a",function(){return n});var n=function(){function e(){}return e.WarnImport=function(e){return e+" needs to be imported before as it contains a side-effect required by your code."},e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return o}),i.d(t,"c",function(){return a}),i.d(t,"d",function(){return s}),i.d(t,"b",function(){return c});var n=i(1),r=i(0),o=function(){function e(){}return e.POINTERDOWN=1,e.POINTERUP=2,e.POINTERMOVE=4,e.POINTERWHEEL=8,e.POINTERPICK=16,e.POINTERTAP=32,e.POINTERDOUBLETAP=64,e}(),a=function(e,t){this.type=e,this.event=t},s=function(e){function t(t,i,n,o){var a=e.call(this,t,i)||this;return a.ray=null,a.skipOnPointerObservable=!1,a.localPosition=new r.d(n,o),a}return Object(n.d)(t,e),t}(a),c=function(e){function t(t,i,n){var r=e.call(this,t,i)||this;return r.pickInfo=n,r}return Object(n.d)(t,e),t}(a)},function(e,t,i){"use strict";i.d(t,"a",function(){return o});var n=i(11),r=i(2),o=function(){function e(){}return Object.defineProperty(e,"DiffuseTextureEnabled",{get:function(){return this._DiffuseTextureEnabled},set:function(e){this._DiffuseTextureEnabled!==e&&(this._DiffuseTextureEnabled=e,n.a.MarkAllMaterialsAsDirty(r.a.MATERIAL_TextureDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(e,"AmbientTextureEnabled",{get:function(){return this._AmbientTextureEnabled},set:function(e){this._AmbientTextureEnabled!==e&&(this._AmbientTextureEnabled=e,n.a.MarkAllMaterialsAsDirty(r.a.MATERIAL_TextureDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(e,"OpacityTextureEnabled",{get:function(){return this._OpacityTextureEnabled},set:function(e){this._OpacityTextureEnabled!==e&&(this._OpacityTextureEnabled=e,n.a.MarkAllMaterialsAsDirty(r.a.MATERIAL_TextureDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(e,"ReflectionTextureEnabled",{get:function(){return this._ReflectionTextureEnabled},set:function(e){this._ReflectionTextureEnabled!==e&&(this._ReflectionTextureEnabled=e,n.a.MarkAllMaterialsAsDirty(r.a.MATERIAL_TextureDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(e,"EmissiveTextureEnabled",{get:function(){return this._EmissiveTextureEnabled},set:function(e){this._EmissiveTextureEnabled!==e&&(this._EmissiveTextureEnabled=e,n.a.MarkAllMaterialsAsDirty(r.a.MATERIAL_TextureDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(e,"SpecularTextureEnabled",{get:function(){return this._SpecularTextureEnabled},set:function(e){this._SpecularTextureEnabled!==e&&(this._SpecularTextureEnabled=e,n.a.MarkAllMaterialsAsDirty(r.a.MATERIAL_TextureDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(e,"BumpTextureEnabled",{get:function(){return this._BumpTextureEnabled},set:function(e){this._BumpTextureEnabled!==e&&(this._BumpTextureEnabled=e,n.a.MarkAllMaterialsAsDirty(r.a.MATERIAL_TextureDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(e,"LightmapTextureEnabled",{get:function(){return this._LightmapTextureEnabled},set:function(e){this._LightmapTextureEnabled!==e&&(this._LightmapTextureEnabled=e,n.a.MarkAllMaterialsAsDirty(r.a.MATERIAL_TextureDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(e,"RefractionTextureEnabled",{get:function(){return this._RefractionTextureEnabled},set:function(e){this._RefractionTextureEnabled!==e&&(this._RefractionTextureEnabled=e,n.a.MarkAllMaterialsAsDirty(r.a.MATERIAL_TextureDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(e,"ColorGradingTextureEnabled",{get:function(){return this._ColorGradingTextureEnabled},set:function(e){this._ColorGradingTextureEnabled!==e&&(this._ColorGradingTextureEnabled=e,n.a.MarkAllMaterialsAsDirty(r.a.MATERIAL_TextureDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(e,"FresnelEnabled",{get:function(){return this._FresnelEnabled},set:function(e){this._FresnelEnabled!==e&&(this._FresnelEnabled=e,n.a.MarkAllMaterialsAsDirty(r.a.MATERIAL_FresnelDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(e,"ClearCoatTextureEnabled",{get:function(){return this._ClearCoatTextureEnabled},set:function(e){this._ClearCoatTextureEnabled!==e&&(this._ClearCoatTextureEnabled=e,n.a.MarkAllMaterialsAsDirty(r.a.MATERIAL_TextureDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(e,"ClearCoatBumpTextureEnabled",{get:function(){return this._ClearCoatBumpTextureEnabled},set:function(e){this._ClearCoatBumpTextureEnabled!==e&&(this._ClearCoatBumpTextureEnabled=e,n.a.MarkAllMaterialsAsDirty(r.a.MATERIAL_TextureDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(e,"ClearCoatTintTextureEnabled",{get:function(){return this._ClearCoatTintTextureEnabled},set:function(e){this._ClearCoatTintTextureEnabled!==e&&(this._ClearCoatTintTextureEnabled=e,n.a.MarkAllMaterialsAsDirty(r.a.MATERIAL_TextureDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(e,"SheenTextureEnabled",{get:function(){return this._SheenTextureEnabled},set:function(e){this._SheenTextureEnabled!==e&&(this._SheenTextureEnabled=e,n.a.MarkAllMaterialsAsDirty(r.a.MATERIAL_TextureDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(e,"AnisotropicTextureEnabled",{get:function(){return this._AnisotropicTextureEnabled},set:function(e){this._AnisotropicTextureEnabled!==e&&(this._AnisotropicTextureEnabled=e,n.a.MarkAllMaterialsAsDirty(r.a.MATERIAL_TextureDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(e,"ThicknessTextureEnabled",{get:function(){return this._ThicknessTextureEnabled},set:function(e){this._ThicknessTextureEnabled!==e&&(this._ThicknessTextureEnabled=e,n.a.MarkAllMaterialsAsDirty(r.a.MATERIAL_TextureDirtyFlag))},enumerable:!0,configurable:!0}),e._DiffuseTextureEnabled=!0,e._AmbientTextureEnabled=!0,e._OpacityTextureEnabled=!0,e._ReflectionTextureEnabled=!0,e._EmissiveTextureEnabled=!0,e._SpecularTextureEnabled=!0,e._BumpTextureEnabled=!0,e._LightmapTextureEnabled=!0,e._RefractionTextureEnabled=!0,e._ColorGradingTextureEnabled=!0,e._FresnelEnabled=!0,e._ClearCoatTextureEnabled=!0,e._ClearCoatBumpTextureEnabled=!0,e._ClearCoatTintTextureEnabled=!0,e._SheenTextureEnabled=!0,e._AnisotropicTextureEnabled=!0,e._ThicknessTextureEnabled=!0,e}()},function(e,t,i){"use strict";i.d(t,"b",function(){return n}),i.d(t,"a",function(){return o});var n,r=i(0);!function(e){e[e.LOCAL=0]="LOCAL",e[e.WORLD=1]="WORLD",e[e.BONE=2]="BONE"}(n||(n={}));var o=function(){function e(){}return e.X=new r.e(1,0,0),e.Y=new r.e(0,1,0),e.Z=new r.e(0,0,1),e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return n});var n=function(){function e(){}return Object.defineProperty(e,"LastCreatedEngine",{get:function(){return 0===this.Instances.length?null:this.Instances[this.Instances.length-1]},enumerable:!0,configurable:!0}),Object.defineProperty(e,"LastCreatedScene",{get:function(){return this._LastCreatedScene},enumerable:!0,configurable:!0}),e.Instances=new Array,e._LastCreatedScene=null,e.UseFallbackTexture=!0,e.FallbackTexture="",e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return _});var n=i(1),r=i(3),o=i(34),a=i(13),s=i(6),c=i(0),l=i(26),u=i(7),h=i(12),d=i(19),f=i(61),p=i(86),_=function(e){function t(i,n,r,a){void 0===a&&(a=!0);var l=e.call(this,i,r)||this;return l._position=c.e.Zero(),l.upVector=c.e.Up(),l.orthoLeft=null,l.orthoRight=null,l.orthoBottom=null,l.orthoTop=null,l.fov=.8,l.minZ=1,l.maxZ=1e4,l.inertia=.9,l.mode=t.PERSPECTIVE_CAMERA,l.isIntermediate=!1,l.viewport=new f.a(0,0,1,1),l.layerMask=268435455,l.fovMode=t.FOVMODE_VERTICAL_FIXED,l.cameraRigMode=t.RIG_MODE_NONE,l.customRenderTargets=new Array,l.outputRenderTarget=null,l.onViewMatrixChangedObservable=new s.c,l.onProjectionMatrixChangedObservable=new s.c,l.onAfterCheckInputsObservable=new s.c,l.onRestoreStateObservable=new s.c,l.isRigCamera=!1,l._rigCameras=new Array,l._webvrViewMatrix=c.a.Identity(),l._skipRendering=!1,l._projectionMatrix=new c.a,l._postProcesses=new Array,l._activeMeshes=new o.a(256),l._globalPosition=c.e.Zero(),l._computedViewMatrix=c.a.Identity(),l._doNotComputeProjectionMatrix=!1,l._transformMatrix=c.a.Zero(),l._refreshFrustumPlanes=!0,l._isCamera=!0,l._isLeftCamera=!1,l._isRightCamera=!1,l.getScene().addCamera(l),a&&!l.getScene().activeCamera&&(l.getScene().activeCamera=l),l.position=n,l}return Object(n.d)(t,e),Object.defineProperty(t.prototype,"position",{get:function(){return this._position},set:function(e){this._position=e},enumerable:!0,configurable:!0}),t.prototype.storeState=function(){return this._stateStored=!0,this._storedFov=this.fov,this},t.prototype._restoreStateValues=function(){return!!this._stateStored&&(this.fov=this._storedFov,!0)},t.prototype.restoreState=function(){return!!this._restoreStateValues()&&(this.onRestoreStateObservable.notifyObservers(this),!0)},t.prototype.getClassName=function(){return"Camera"},t.prototype.toString=function(e){var t="Name: "+this.name;if(t+=", type: "+this.getClassName(),this.animations)for(var i=0;i<this.animations.length;i++)t+=", animation[0]: "+this.animations[i].toString(e);return t},Object.defineProperty(t.prototype,"globalPosition",{get:function(){return this._globalPosition},enumerable:!0,configurable:!0}),t.prototype.getActiveMeshes=function(){return this._activeMeshes},t.prototype.isActiveMesh=function(e){return-1!==this._activeMeshes.indexOf(e)},t.prototype.isReady=function(t){if(void 0===t&&(t=!1),t)for(var i=0,n=this._postProcesses;i<n.length;i++){var r=n[i];if(r&&!r.isReady())return!1}return e.prototype.isReady.call(this,t)},t.prototype._initCache=function(){e.prototype._initCache.call(this),this._cache.position=new c.e(Number.MAX_VALUE,Number.MAX_VALUE,Number.MAX_VALUE),this._cache.upVector=new c.e(Number.MAX_VALUE,Number.MAX_VALUE,Number.MAX_VALUE),this._cache.mode=void 0,this._cache.minZ=void 0,this._cache.maxZ=void 0,this._cache.fov=void 0,this._cache.fovMode=void 0,this._cache.aspectRatio=void 0,this._cache.orthoLeft=void 0,this._cache.orthoRight=void 0,this._cache.orthoBottom=void 0,this._cache.orthoTop=void 0,this._cache.renderWidth=void 0,this._cache.renderHeight=void 0},t.prototype._updateCache=function(t){t||e.prototype._updateCache.call(this),this._cache.position.copyFrom(this.position),this._cache.upVector.copyFrom(this.upVector)},t.prototype._isSynchronized=function(){return this._isSynchronizedViewMatrix()&&this._isSynchronizedProjectionMatrix()},t.prototype._isSynchronizedViewMatrix=function(){return!!e.prototype._isSynchronized.call(this)&&(this._cache.position.equals(this.position)&&this._cache.upVector.equals(this.upVector)&&this.isSynchronizedWithParent())},t.prototype._isSynchronizedProjectionMatrix=function(){var e=this._cache.mode===this.mode&&this._cache.minZ===this.minZ&&this._cache.maxZ===this.maxZ;if(!e)return!1;var i=this.getEngine();return e=this.mode===t.PERSPECTIVE_CAMERA?this._cache.fov===this.fov&&this._cache.fovMode===this.fovMode&&this._cache.aspectRatio===i.getAspectRatio(this):this._cache.orthoLeft===this.orthoLeft&&this._cache.orthoRight===this.orthoRight&&this._cache.orthoBottom===this.orthoBottom&&this._cache.orthoTop===this.orthoTop&&this._cache.renderWidth===i.getRenderWidth()&&this._cache.renderHeight===i.getRenderHeight()},t.prototype.attachControl=function(e,t){},t.prototype.detachControl=function(e){},t.prototype.update=function(){this._checkInputs(),this.cameraRigMode!==t.RIG_MODE_NONE&&this._updateRigCameras()},t.prototype._checkInputs=function(){this.onAfterCheckInputsObservable.notifyObservers(this)},Object.defineProperty(t.prototype,"rigCameras",{get:function(){return this._rigCameras},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"rigPostProcess",{get:function(){return this._rigPostProcess},enumerable:!0,configurable:!0}),t.prototype._getFirstPostProcess=function(){for(var e=0;e<this._postProcesses.length;e++)if(null!==this._postProcesses[e])return this._postProcesses[e];return null},t.prototype._cascadePostProcessesToRigCams=function(){var e=this._getFirstPostProcess();e&&e.markTextureDirty();for(var t=0,i=this._rigCameras.length;t<i;t++){var n=this._rigCameras[t],r=n._rigPostProcess;if(r)"pass"===r.getEffectName()&&(n.isIntermediate=0===this._postProcesses.length),n._postProcesses=this._postProcesses.slice(0).concat(r),r.markTextureDirty();else n._postProcesses=this._postProcesses.slice(0)}},t.prototype.attachPostProcess=function(e,t){return void 0===t&&(t=null),!e.isReusable()&&this._postProcesses.indexOf(e)>-1?(u.a.Error("You're trying to reuse a post process not defined as reusable."),0):(null==t||t<0?this._postProcesses.push(e):null===this._postProcesses[t]?this._postProcesses[t]=e:this._postProcesses.splice(t,0,e),this._cascadePostProcessesToRigCams(),this._postProcesses.indexOf(e))},t.prototype.detachPostProcess=function(e){var t=this._postProcesses.indexOf(e);-1!==t&&(this._postProcesses[t]=null),this._cascadePostProcessesToRigCams()},t.prototype.getWorldMatrix=function(){return this._isSynchronizedViewMatrix()?this._worldMatrix:(this.getViewMatrix(),this._worldMatrix)},t.prototype._getViewMatrix=function(){return c.a.Identity()},t.prototype.getViewMatrix=function(e){return!e&&this._isSynchronizedViewMatrix()?this._computedViewMatrix:(this.updateCache(),this._computedViewMatrix=this._getViewMatrix(),this._currentRenderId=this.getScene().getRenderId(),this._childUpdateId++,this._refreshFrustumPlanes=!0,this._cameraRigParams&&this._cameraRigParams.vrPreViewMatrix&&this._computedViewMatrix.multiplyToRef(this._cameraRigParams.vrPreViewMatrix,this._computedViewMatrix),this.parent&&this.parent.onViewMatrixChangedObservable&&this.parent.onViewMatrixChangedObservable.notifyObservers(this.parent),this.onViewMatrixChangedObservable.notifyObservers(this),this._computedViewMatrix.invertToRef(this._worldMatrix),this._computedViewMatrix)},t.prototype.freezeProjectionMatrix=function(e){this._doNotComputeProjectionMatrix=!0,void 0!==e&&(this._projectionMatrix=e)},t.prototype.unfreezeProjectionMatrix=function(){this._doNotComputeProjectionMatrix=!1},t.prototype.getProjectionMatrix=function(e){if(this._doNotComputeProjectionMatrix||!e&&this._isSynchronizedProjectionMatrix())return this._projectionMatrix;this._cache.mode=this.mode,this._cache.minZ=this.minZ,this._cache.maxZ=this.maxZ,this._refreshFrustumPlanes=!0;var i=this.getEngine(),n=this.getScene();if(this.mode===t.PERSPECTIVE_CAMERA){this._cache.fov=this.fov,this._cache.fovMode=this.fovMode,this._cache.aspectRatio=i.getAspectRatio(this),this.minZ<=0&&(this.minZ=.1);var r=i.useReverseDepthBuffer;(n.useRightHandedSystem?r?c.a.PerspectiveFovReverseRHToRef:c.a.PerspectiveFovRHToRef:r?c.a.PerspectiveFovReverseLHToRef:c.a.PerspectiveFovLHToRef)(this.fov,i.getAspectRatio(this),this.minZ,this.maxZ,this._projectionMatrix,this.fovMode===t.FOVMODE_VERTICAL_FIXED)}else{var o=i.getRenderWidth()/2,a=i.getRenderHeight()/2;n.useRightHandedSystem?c.a.OrthoOffCenterRHToRef(this.orthoLeft||-o,this.orthoRight||o,this.orthoBottom||-a,this.orthoTop||a,this.minZ,this.maxZ,this._projectionMatrix):c.a.OrthoOffCenterLHToRef(this.orthoLeft||-o,this.orthoRight||o,this.orthoBottom||-a,this.orthoTop||a,this.minZ,this.maxZ,this._projectionMatrix),this._cache.orthoLeft=this.orthoLeft,this._cache.orthoRight=this.orthoRight,this._cache.orthoBottom=this.orthoBottom,this._cache.orthoTop=this.orthoTop,this._cache.renderWidth=i.getRenderWidth(),this._cache.renderHeight=i.getRenderHeight()}return this.onProjectionMatrixChangedObservable.notifyObservers(this),this._projectionMatrix},t.prototype.getTransformationMatrix=function(){return this._computedViewMatrix.multiplyToRef(this._projectionMatrix,this._transformMatrix),this._transformMatrix},t.prototype._updateFrustumPlanes=function(){this._refreshFrustumPlanes&&(this.getTransformationMatrix(),this._frustumPlanes?p.a.GetPlanesToRef(this._transformMatrix,this._frustumPlanes):this._frustumPlanes=p.a.GetPlanes(this._transformMatrix),this._refreshFrustumPlanes=!1)},t.prototype.isInFrustum=function(e,t){if(void 0===t&&(t=!1),this._updateFrustumPlanes(),t&&this.rigCameras.length>0){var i=!1;return this.rigCameras.forEach(function(t){t._updateFrustumPlanes(),i=i||e.isInFrustum(t._frustumPlanes)}),i}return e.isInFrustum(this._frustumPlanes)},t.prototype.isCompletelyInFrustum=function(e){return this._updateFrustumPlanes(),e.isCompletelyInFrustum(this._frustumPlanes)},t.prototype.getForwardRay=function(e,t,i){throw void 0===e&&(e=100),d.a.WarnImport("Ray")},t.prototype.dispose=function(i,n){for(void 0===n&&(n=!1),this.onViewMatrixChangedObservable.clear(),this.onProjectionMatrixChangedObservable.clear(),this.onAfterCheckInputsObservable.clear(),this.onRestoreStateObservable.clear(),this.inputs&&this.inputs.clear(),this.getScene().stopAnimation(this),this.getScene().removeCamera(this);this._rigCameras.length>0;){var r=this._rigCameras.pop();r&&r.dispose()}if(this._rigPostProcess)this._rigPostProcess.dispose(this),this._rigPostProcess=null,this._postProcesses=[];else if(this.cameraRigMode!==t.RIG_MODE_NONE)this._rigPostProcess=null,this._postProcesses=[];else for(var o=this._postProcesses.length;--o>=0;){var a=this._postProcesses[o];a&&a.dispose(this)}for(o=this.customRenderTargets.length;--o>=0;)this.customRenderTargets[o].dispose();this.customRenderTargets=[],this._activeMeshes.dispose(),e.prototype.dispose.call(this,i,n)},Object.defineProperty(t.prototype,"isLeftCamera",{get:function(){return this._isLeftCamera},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isRightCamera",{get:function(){return this._isRightCamera},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"leftCamera",{get:function(){return this._rigCameras.length<1?null:this._rigCameras[0]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"rightCamera",{get:function(){return this._rigCameras.length<2?null:this._rigCameras[1]},enumerable:!0,configurable:!0}),t.prototype.getLeftTarget=function(){return this._rigCameras.length<1?null:this._rigCameras[0].getTarget()},t.prototype.getRightTarget=function(){return this._rigCameras.length<2?null:this._rigCameras[1].getTarget()},t.prototype.setCameraRigMode=function(e,i){if(this.cameraRigMode!==e){for(;this._rigCameras.length>0;){var n=this._rigCameras.pop();n&&n.dispose()}if(this.cameraRigMode=e,this._cameraRigParams={},this._cameraRigParams.interaxialDistance=i.interaxialDistance||.0637,this._cameraRigParams.stereoHalfAngle=a.b.ToRadians(this._cameraRigParams.interaxialDistance/.0637),this.cameraRigMode!==t.RIG_MODE_NONE){var r=this.createRigCamera(this.name+"_L",0);r&&(r._isLeftCamera=!0);var o=this.createRigCamera(this.name+"_R",1);o&&(o._isRightCamera=!0),r&&o&&(this._rigCameras.push(r),this._rigCameras.push(o))}switch(this.cameraRigMode){case t.RIG_MODE_STEREOSCOPIC_ANAGLYPH:t._setStereoscopicAnaglyphRigMode(this);break;case t.RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_PARALLEL:case t.RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_CROSSEYED:case t.RIG_MODE_STEREOSCOPIC_OVERUNDER:case t.RIG_MODE_STEREOSCOPIC_INTERLACED:t._setStereoscopicRigMode(this);break;case t.RIG_MODE_VR:t._setVRRigMode(this,i);break;case t.RIG_MODE_WEBVR:t._setWebVRRigMode(this,i)}this._cascadePostProcessesToRigCams(),this.update()}},t._setStereoscopicRigMode=function(e){throw"Import Cameras/RigModes/stereoscopicRigMode before using stereoscopic rig mode"},t._setStereoscopicAnaglyphRigMode=function(e){throw"Import Cameras/RigModes/stereoscopicAnaglyphRigMode before using stereoscopic anaglyph rig mode"},t._setVRRigMode=function(e,t){throw"Import Cameras/RigModes/vrRigMode before using VR rig mode"},t._setWebVRRigMode=function(e,t){throw"Import Cameras/RigModes/WebVRRigMode before using Web VR rig mode"},t.prototype._getVRProjectionMatrix=function(){return c.a.PerspectiveFovLHToRef(this._cameraRigParams.vrMetrics.aspectRatioFov,this._cameraRigParams.vrMetrics.aspectRatio,this.minZ,this.maxZ,this._cameraRigParams.vrWorkMatrix),this._cameraRigParams.vrWorkMatrix.multiplyToRef(this._cameraRigParams.vrHMatrix,this._projectionMatrix),this._projectionMatrix},t.prototype._updateCameraRotationMatrix=function(){},t.prototype._updateWebVRCameraRotationMatrix=function(){},t.prototype._getWebVRProjectionMatrix=function(){return c.a.Identity()},t.prototype._getWebVRViewMatrix=function(){return c.a.Identity()},t.prototype.setCameraRigParameter=function(e,t){this._cameraRigParams||(this._cameraRigParams={}),this._cameraRigParams[e]=t,"interaxialDistance"===e&&(this._cameraRigParams.stereoHalfAngle=a.b.ToRadians(t/.0637))},t.prototype.createRigCamera=function(e,t){return null},t.prototype._updateRigCameras=function(){for(var e=0;e<this._rigCameras.length;e++)this._rigCameras[e].minZ=this.minZ,this._rigCameras[e].maxZ=this.maxZ,this._rigCameras[e].fov=this.fov,this._rigCameras[e].upVector.copyFrom(this.upVector);this.cameraRigMode===t.RIG_MODE_STEREOSCOPIC_ANAGLYPH&&(this._rigCameras[0].viewport=this._rigCameras[1].viewport=this.viewport)},t.prototype._setupInputs=function(){},t.prototype.serialize=function(){var e=r.a.Serialize(this);return e.type=this.getClassName(),this.parent&&(e.parentId=this.parent.id),this.inputs&&this.inputs.serialize(e),r.a.AppendSerializedAnimations(this,e),e.ranges=this.serializeAnimationRanges(),e},t.prototype.clone=function(e){return r.a.Clone(t.GetConstructorFromName(this.getClassName(),e,this.getScene(),this.interaxialDistance,this.isStereoscopicSideBySide),this)},t.prototype.getDirection=function(e){var t=c.e.Zero();return this.getDirectionToRef(e,t),t},Object.defineProperty(t.prototype,"absoluteRotation",{get:function(){var e=c.b.Zero();return this.getWorldMatrix().decompose(void 0,e),e},enumerable:!0,configurable:!0}),t.prototype.getDirectionToRef=function(e,t){c.e.TransformNormalToRef(e,this.getWorldMatrix(),t)},t.GetConstructorFromName=function(e,i,n,r,o){void 0===r&&(r=0),void 0===o&&(o=!0);var a=l.a.Construct(e,i,n,{interaxial_distance:r,isStereoscopicSideBySide:o});return a||function(){return t._createDefaultParsedCamera(i,n)}},t.prototype.computeWorldMatrix=function(){return this.getWorldMatrix()},t.Parse=function(e,i){var n=e.type,o=t.GetConstructorFromName(n,e.name,i,e.interaxial_distance,e.isStereoscopicSideBySide),a=r.a.Parse(o,e,i);if(e.parentId&&(a._waitingParentId=e.parentId),a.inputs&&(a.inputs.parse(e),a._setupInputs()),a.setPosition&&(a.position.copyFromFloats(0,0,0),a.setPosition(c.e.FromArray(e.position))),e.target&&a.setTarget&&a.setTarget(c.e.FromArray(e.target)),e.cameraRigMode){var s=e.interaxial_distance?{interaxialDistance:e.interaxial_distance}:{};a.setCameraRigMode(e.cameraRigMode,s)}if(e.animations){for(var u=0;u<e.animations.length;u++){var d=e.animations[u],f=h.a.GetClass("BABYLON.Animation");f&&a.animations.push(f.Parse(d))}l.a.ParseAnimationRanges(a,e,i)}return e.autoAnimate&&i.beginAnimation(a,e.autoAnimateFrom,e.autoAnimateTo,e.autoAnimateLoop,e.autoAnimateSpeed||1),a},t._createDefaultParsedCamera=function(e,t){throw d.a.WarnImport("UniversalCamera")},t.PERSPECTIVE_CAMERA=0,t.ORTHOGRAPHIC_CAMERA=1,t.FOVMODE_VERTICAL_FIXED=0,t.FOVMODE_HORIZONTAL_FIXED=1,t.RIG_MODE_NONE=0,t.RIG_MODE_STEREOSCOPIC_ANAGLYPH=10,t.RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_PARALLEL=11,t.RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_CROSSEYED=12,t.RIG_MODE_STEREOSCOPIC_OVERUNDER=13,t.RIG_MODE_STEREOSCOPIC_INTERLACED=14,t.RIG_MODE_VR=20,t.RIG_MODE_WEBVR=21,t.RIG_MODE_CUSTOM=22,t.ForceAttachControlToAlwaysPreventDefault=!1,Object(n.c)([Object(r.o)("position")],t.prototype,"_position",void 0),Object(n.c)([Object(r.o)()],t.prototype,"upVector",void 0),Object(n.c)([Object(r.c)()],t.prototype,"orthoLeft",void 0),Object(n.c)([Object(r.c)()],t.prototype,"orthoRight",void 0),Object(n.c)([Object(r.c)()],t.prototype,"orthoBottom",void 0),Object(n.c)([Object(r.c)()],t.prototype,"orthoTop",void 0),Object(n.c)([Object(r.c)()],t.prototype,"fov",void 0),Object(n.c)([Object(r.c)()],t.prototype,"minZ",void 0),Object(n.c)([Object(r.c)()],t.prototype,"maxZ",void 0),Object(n.c)([Object(r.c)()],t.prototype,"inertia",void 0),Object(n.c)([Object(r.c)()],t.prototype,"mode",void 0),Object(n.c)([Object(r.c)()],t.prototype,"layerMask",void 0),Object(n.c)([Object(r.c)()],t.prototype,"fovMode",void 0),Object(n.c)([Object(r.c)()],t.prototype,"cameraRigMode",void 0),Object(n.c)([Object(r.c)()],t.prototype,"interaxialDistance",void 0),Object(n.c)([Object(r.c)()],t.prototype,"isStereoscopicSideBySide",void 0),t}(l.a)},function(e,t,i){"use strict";i.d(t,"b",function(){return n}),i.d(t,"a",function(){return c});var n,r=i(6),o=i(95),a=i(2),s=i(19);!function(e){e[e.Unknown=0]="Unknown",e[e.Url=1]="Url",e[e.Temp=2]="Temp",e[e.Raw=3]="Raw",e[e.Dynamic=4]="Dynamic",e[e.RenderTarget=5]="RenderTarget",e[e.MultiRenderTarget=6]="MultiRenderTarget",e[e.Cube=7]="Cube",e[e.CubeRaw=8]="CubeRaw",e[e.CubePrefiltered=9]="CubePrefiltered",e[e.Raw3D=10]="Raw3D",e[e.Raw2DArray=11]="Raw2DArray",e[e.Depth=12]="Depth",e[e.CubeRawRGBD=13]="CubeRawRGBD"}(n||(n={}));var c=function(){function e(e,t,i){void 0===i&&(i=!1),this.isReady=!1,this.isCube=!1,this.is3D=!1,this.is2DArray=!1,this.isMultiview=!1,this.url="",this.samplingMode=-1,this.generateMipMaps=!1,this.samples=0,this.type=-1,this.format=-1,this.onLoadedObservable=new r.c,this.width=0,this.height=0,this.depth=0,this.baseWidth=0,this.baseHeight=0,this.baseDepth=0,this.invertY=!1,this._invertVScale=!1,this._associatedChannel=-1,this._source=n.Unknown,this._buffer=null,this._bufferView=null,this._bufferViewArray=null,this._bufferViewArrayArray=null,this._size=0,this._extension="",this._files=null,this._workingCanvas=null,this._workingContext=null,this._framebuffer=null,this._depthStencilBuffer=null,this._MSAAFramebuffer=null,this._MSAARenderBuffer=null,this._attachments=null,this._cachedCoordinatesMode=null,this._cachedWrapU=null,this._cachedWrapV=null,this._cachedWrapR=null,this._cachedAnisotropicFilteringLevel=null,this._isDisabled=!1,this._compression=null,this._generateStencilBuffer=!1,this._generateDepthBuffer=!1,this._comparisonFunction=0,this._sphericalPolynomial=null,this._lodGenerationScale=0,this._lodGenerationOffset=0,this._colorTextureArray=null,this._depthStencilTextureArray=null,this._lodTextureHigh=null,this._lodTextureMid=null,this._lodTextureLow=null,this._isRGBD=!1,this._linearSpecularLOD=!1,this._irradianceTexture=null,this._webGLTexture=null,this._references=1,this._engine=e,this._source=t,i||(this._webGLTexture=e._createTexture())}return e.prototype.getEngine=function(){return this._engine},Object.defineProperty(e.prototype,"source",{get:function(){return this._source},enumerable:!0,configurable:!0}),e.prototype.incrementReferences=function(){this._references++},e.prototype.updateSize=function(e,t,i){void 0===i&&(i=1),this.width=e,this.height=t,this.depth=i,this.baseWidth=e,this.baseHeight=t,this.baseDepth=i,this._size=e*t*i},e.prototype._rebuild=function(){var t,i=this;switch(this.isReady=!1,this._cachedCoordinatesMode=null,this._cachedWrapU=null,this._cachedWrapV=null,this._cachedAnisotropicFilteringLevel=null,this.source){case n.Temp:return;case n.Url:return void(t=this._engine.createTexture(this.url,!this.generateMipMaps,this.invertY,null,this.samplingMode,function(){t._swapAndDie(i),i.isReady=!0},null,this._buffer,void 0,this.format));case n.Raw:return(t=this._engine.createRawTexture(this._bufferView,this.baseWidth,this.baseHeight,this.format,this.generateMipMaps,this.invertY,this.samplingMode,this._compression))._swapAndDie(this),void(this.isReady=!0);case n.Raw3D:return(t=this._engine.createRawTexture3D(this._bufferView,this.baseWidth,this.baseHeight,this.baseDepth,this.format,this.generateMipMaps,this.invertY,this.samplingMode,this._compression))._swapAndDie(this),void(this.isReady=!0);case n.Raw2DArray:return(t=this._engine.createRawTexture2DArray(this._bufferView,this.baseWidth,this.baseHeight,this.baseDepth,this.format,this.generateMipMaps,this.invertY,this.samplingMode,this._compression))._swapAndDie(this),void(this.isReady=!0);case n.Dynamic:return(t=this._engine.createDynamicTexture(this.baseWidth,this.baseHeight,this.generateMipMaps,this.samplingMode))._swapAndDie(this),void this._engine.updateDynamicTexture(this,this._engine.getRenderingCanvas(),this.invertY,void 0,void 0,!0);case n.RenderTarget:var r=new o.a;if(r.generateDepthBuffer=this._generateDepthBuffer,r.generateMipMaps=this.generateMipMaps,r.generateStencilBuffer=this._generateStencilBuffer,r.samplingMode=this.samplingMode,r.type=this.type,this.isCube)t=this._engine.createRenderTargetCubeTexture(this.width,r);else{var s={width:this.width,height:this.height,layers:this.is2DArray?this.depth:void 0};t=this._engine.createRenderTargetTexture(s,r)}return t._swapAndDie(this),void(this.isReady=!0);case n.Depth:var c={bilinearFiltering:this.samplingMode!==a.a.TEXTURE_BILINEAR_SAMPLINGMODE,comparisonFunction:this._comparisonFunction,generateStencil:this._generateStencilBuffer,isCube:this.isCube},l={width:this.width,height:this.height,layers:this.is2DArray?this.depth:void 0};return(t=this._engine.createDepthStencilTexture(l,c))._swapAndDie(this),void(this.isReady=!0);case n.Cube:return void(t=this._engine.createCubeTexture(this.url,null,this._files,!this.generateMipMaps,function(){t._swapAndDie(i),i.isReady=!0},null,this.format,this._extension));case n.CubeRaw:return(t=this._engine.createRawCubeTexture(this._bufferViewArray,this.width,this.format,this.type,this.generateMipMaps,this.invertY,this.samplingMode,this._compression))._swapAndDie(this),void(this.isReady=!0);case n.CubeRawRGBD:return t=this._engine.createRawCubeTexture(null,this.width,this.format,this.type,this.generateMipMaps,this.invertY,this.samplingMode,this._compression),void e._UpdateRGBDAsync(t,this._bufferViewArrayArray,this._sphericalPolynomial,this._lodGenerationScale,this._lodGenerationOffset).then(function(){t._swapAndDie(i),i.isReady=!0});case n.CubePrefiltered:return void((t=this._engine.createPrefilteredCubeTexture(this.url,null,this._lodGenerationScale,this._lodGenerationOffset,function(e){e&&e._swapAndDie(i),i.isReady=!0},null,this.format,this._extension))._sphericalPolynomial=this._sphericalPolynomial)}},e.prototype._swapAndDie=function(e){e._webGLTexture=this._webGLTexture,e._isRGBD=this._isRGBD,this._framebuffer&&(e._framebuffer=this._framebuffer),this._depthStencilBuffer&&(e._depthStencilBuffer=this._depthStencilBuffer),e._depthStencilTexture=this._depthStencilTexture,this._lodTextureHigh&&(e._lodTextureHigh&&e._lodTextureHigh.dispose(),e._lodTextureHigh=this._lodTextureHigh),this._lodTextureMid&&(e._lodTextureMid&&e._lodTextureMid.dispose(),e._lodTextureMid=this._lodTextureMid),this._lodTextureLow&&(e._lodTextureLow&&e._lodTextureLow.dispose(),e._lodTextureLow=this._lodTextureLow),this._irradianceTexture&&(e._irradianceTexture&&e._irradianceTexture.dispose(),e._irradianceTexture=this._irradianceTexture);var t,i=this._engine.getLoadedTexturesCache();-1!==(t=i.indexOf(this))&&i.splice(t,1),-1===(t=i.indexOf(e))&&i.push(e)},e.prototype.dispose=function(){this._webGLTexture&&(this._references--,0===this._references&&(this._engine._releaseTexture(this),this._webGLTexture=null))},e._UpdateRGBDAsync=function(e,t,i,n,r){throw s.a.WarnImport("environmentTextureTools")},e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return l});var n=i(1),r=i(0),o=i(3),a=i(6),s=i(23),c=i(19),l=function(){function e(e,t){void 0===t&&(t=null),this.state="",this.metadata=null,this.reservedDataStore=null,this._doNotSerialize=!1,this._isDisposed=!1,this.animations=new Array,this._ranges={},this.onReady=null,this._isEnabled=!0,this._isParentEnabled=!0,this._isReady=!0,this._currentRenderId=-1,this._parentUpdateId=-1,this._childUpdateId=-1,this._waitingParentId=null,this._cache={},this._parentNode=null,this._children=null,this._worldMatrix=r.a.Identity(),this._worldMatrixDeterminant=0,this._worldMatrixDeterminantIsDirty=!0,this._sceneRootNodesIndex=-1,this._animationPropertiesOverride=null,this._isNode=!0,this.onDisposeObservable=new a.c,this._onDisposeObserver=null,this._behaviors=new Array,this.name=e,this.id=e,this._scene=t||s.a.LastCreatedScene,this.uniqueId=this._scene.getUniqueId(),this._initCache()}return e.AddNodeConstructor=function(e,t){this._NodeConstructors[e]=t},e.Construct=function(e,t,i,n){var r=this._NodeConstructors[e];return r?r(t,i,n):null},Object.defineProperty(e.prototype,"doNotSerialize",{get:function(){return!!this._doNotSerialize||!!this._parentNode&&this._parentNode.doNotSerialize},set:function(e){this._doNotSerialize=e},enumerable:!0,configurable:!0}),e.prototype.isDisposed=function(){return this._isDisposed},Object.defineProperty(e.prototype,"parent",{get:function(){return this._parentNode},set:function(e){if(this._parentNode!==e){var t=this._parentNode;if(this._parentNode&&void 0!==this._parentNode._children&&null!==this._parentNode._children){var i=this._parentNode._children.indexOf(this);-1!==i&&this._parentNode._children.splice(i,1),e||this._isDisposed||this._addToSceneRootNodes()}this._parentNode=e,this._parentNode&&(void 0!==this._parentNode._children&&null!==this._parentNode._children||(this._parentNode._children=new Array),this._parentNode._children.push(this),t||this._removeFromSceneRootNodes()),this._syncParentEnabledState()}},enumerable:!0,configurable:!0}),e.prototype._addToSceneRootNodes=function(){-1===this._sceneRootNodesIndex&&(this._sceneRootNodesIndex=this._scene.rootNodes.length,this._scene.rootNodes.push(this))},e.prototype._removeFromSceneRootNodes=function(){if(-1!==this._sceneRootNodesIndex){var e=this._scene.rootNodes,t=e.length-1;e[this._sceneRootNodesIndex]=e[t],e[this._sceneRootNodesIndex]._sceneRootNodesIndex=this._sceneRootNodesIndex,this._scene.rootNodes.pop(),this._sceneRootNodesIndex=-1}},Object.defineProperty(e.prototype,"animationPropertiesOverride",{get:function(){return this._animationPropertiesOverride?this._animationPropertiesOverride:this._scene.animationPropertiesOverride},set:function(e){this._animationPropertiesOverride=e},enumerable:!0,configurable:!0}),e.prototype.getClassName=function(){return"Node"},Object.defineProperty(e.prototype,"onDispose",{set:function(e){this._onDisposeObserver&&this.onDisposeObservable.remove(this._onDisposeObserver),this._onDisposeObserver=this.onDisposeObservable.add(e)},enumerable:!0,configurable:!0}),e.prototype.getScene=function(){return this._scene},e.prototype.getEngine=function(){return this._scene.getEngine()},e.prototype.addBehavior=function(e,t){var i=this;return void 0===t&&(t=!1),-1!==this._behaviors.indexOf(e)?this:(e.init(),this._scene.isLoading&&!t?this._scene.onDataLoadedObservable.addOnce(function(){e.attach(i)}):e.attach(this),this._behaviors.push(e),this)},e.prototype.removeBehavior=function(e){var t=this._behaviors.indexOf(e);return-1===t?this:(this._behaviors[t].detach(),this._behaviors.splice(t,1),this)},Object.defineProperty(e.prototype,"behaviors",{get:function(){return this._behaviors},enumerable:!0,configurable:!0}),e.prototype.getBehaviorByName=function(e){for(var t=0,i=this._behaviors;t<i.length;t++){var n=i[t];if(n.name===e)return n}return null},e.prototype.getWorldMatrix=function(){return this._currentRenderId!==this._scene.getRenderId()&&this.computeWorldMatrix(),this._worldMatrix},e.prototype._getWorldMatrixDeterminant=function(){return this._worldMatrixDeterminantIsDirty&&(this._worldMatrixDeterminantIsDirty=!1,this._worldMatrixDeterminant=this._worldMatrix.determinant()),this._worldMatrixDeterminant},Object.defineProperty(e.prototype,"worldMatrixFromCache",{get:function(){return this._worldMatrix},enumerable:!0,configurable:!0}),e.prototype._initCache=function(){this._cache={},this._cache.parent=void 0},e.prototype.updateCache=function(e){!e&&this.isSynchronized()||(this._cache.parent=this.parent,this._updateCache())},e.prototype._getActionManagerForTrigger=function(e,t){return void 0===t&&(t=!0),this.parent?this.parent._getActionManagerForTrigger(e,!1):null},e.prototype._updateCache=function(e){},e.prototype._isSynchronized=function(){return!0},e.prototype._markSyncedWithParent=function(){this._parentNode&&(this._parentUpdateId=this._parentNode._childUpdateId)},e.prototype.isSynchronizedWithParent=function(){return!this._parentNode||this._parentUpdateId===this._parentNode._childUpdateId&&this._parentNode.isSynchronized()},e.prototype.isSynchronized=function(){return this._cache.parent!=this._parentNode?(this._cache.parent=this._parentNode,!1):!(this._parentNode&&!this.isSynchronizedWithParent())&&this._isSynchronized()},e.prototype.isReady=function(e){return void 0===e&&(e=!1),this._isReady},e.prototype.isEnabled=function(e){return void 0===e&&(e=!0),!1===e?this._isEnabled:!!this._isEnabled&&this._isParentEnabled},e.prototype._syncParentEnabledState=function(){this._isParentEnabled=!this._parentNode||this._parentNode.isEnabled(),this._children&&this._children.forEach(function(e){e._syncParentEnabledState()})},e.prototype.setEnabled=function(e){this._isEnabled=e,this._syncParentEnabledState()},e.prototype.isDescendantOf=function(e){return!!this.parent&&(this.parent===e||this.parent.isDescendantOf(e))},e.prototype._getDescendants=function(e,t,i){if(void 0===t&&(t=!1),this._children)for(var n=0;n<this._children.length;n++){var r=this._children[n];i&&!i(r)||e.push(r),t||r._getDescendants(e,!1,i)}},e.prototype.getDescendants=function(e,t){var i=new Array;return this._getDescendants(i,e,t),i},e.prototype.getChildMeshes=function(e,t){var i=[];return this._getDescendants(i,e,function(e){return(!t||t(e))&&void 0!==e.cullingStrategy}),i},e.prototype.getChildren=function(e,t){return void 0===t&&(t=!0),this.getDescendants(t,e)},e.prototype._setReady=function(e){e!==this._isReady&&(e?(this.onReady&&this.onReady(this),this._isReady=!0):this._isReady=!1)},e.prototype.getAnimationByName=function(e){for(var t=0;t<this.animations.length;t++){var i=this.animations[t];if(i.name===e)return i}return null},e.prototype.createAnimationRange=function(t,i,n){if(!this._ranges[t]){this._ranges[t]=e._AnimationRangeFactory(t,i,n);for(var r=0,o=this.animations.length;r<o;r++)this.animations[r]&&this.animations[r].createRange(t,i,n)}},e.prototype.deleteAnimationRange=function(e,t){void 0===t&&(t=!0);for(var i=0,n=this.animations.length;i<n;i++)this.animations[i]&&this.animations[i].deleteRange(e,t);this._ranges[e]=null},e.prototype.getAnimationRange=function(e){return this._ranges[e]},e.prototype.getAnimationRanges=function(){var e,t=[];for(e in this._ranges)t.push(this._ranges[e]);return t},e.prototype.beginAnimation=function(e,t,i,n){var r=this.getAnimationRange(e);return r?this._scene.beginAnimation(this,r.from,r.to,t,i,n):null},e.prototype.serializeAnimationRanges=function(){var e=[];for(var t in this._ranges){var i=this._ranges[t];if(i){var n={};n.name=t,n.from=i.from,n.to=i.to,e.push(n)}}return e},e.prototype.computeWorldMatrix=function(e){return this._worldMatrix||(this._worldMatrix=r.a.Identity()),this._worldMatrix},e.prototype.dispose=function(e,t){if(void 0===t&&(t=!1),this._isDisposed=!0,!e)for(var i=0,n=this.getDescendants(!0);i<n.length;i++){n[i].dispose(e,t)}this.parent?this.parent=null:this._removeFromSceneRootNodes(),this.onDisposeObservable.notifyObservers(this),this.onDisposeObservable.clear();for(var r=0,o=this._behaviors;r<o.length;r++){o[r].detach()}this._behaviors=[]},e.ParseAnimationRanges=function(e,t,i){if(t.ranges)for(var n=0;n<t.ranges.length;n++){var r=t.ranges[n];e.createAnimationRange(r.name,r.from,r.to)}},e.prototype.getHierarchyBoundingVectors=function(e,t){var i,n;void 0===e&&(e=!0),void 0===t&&(t=null),this.getScene().incrementRenderId(),this.computeWorldMatrix(!0);if(this.getBoundingInfo&&this.subMeshes){var o=this.getBoundingInfo();i=o.boundingBox.minimumWorld.clone(),n=o.boundingBox.maximumWorld.clone()}else i=new r.e(Number.MAX_VALUE,Number.MAX_VALUE,Number.MAX_VALUE),n=new r.e(-Number.MAX_VALUE,-Number.MAX_VALUE,-Number.MAX_VALUE);if(e)for(var a=0,s=this.getDescendants(!1);a<s.length;a++){var c=s[a];if(c.computeWorldMatrix(!0),(!t||t(c))&&c.getBoundingInfo&&0!==c.getTotalVertices()){var l=c.getBoundingInfo().boundingBox,u=l.minimumWorld,h=l.maximumWorld;r.e.CheckExtends(u,i,n),r.e.CheckExtends(h,i,n)}}return{min:i,max:n}},e._AnimationRangeFactory=function(e,t,i){throw c.a.WarnImport("AnimationRange")},e._NodeConstructors={},Object(n.c)([Object(o.c)()],e.prototype,"name",void 0),Object(n.c)([Object(o.c)()],e.prototype,"id",void 0),Object(n.c)([Object(o.c)()],e.prototype,"uniqueId",void 0),Object(n.c)([Object(o.c)()],e.prototype,"state",void 0),Object(n.c)([Object(o.c)()],e.prototype,"metadata",void 0),e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return E});var n=i(1),r=i(13),o=i(6),a=i(0),s=i(11),c=i(4),l=i(15),u=i(43),h=i(53),d=i(44),f=i(2),p=i(133),_=i(19),m=i(110),g=i(10),v=i(28),y=i(22),b=function(){this.facetNb=0,this.partitioningSubdivisions=10,this.partitioningBBoxRatio=1.01,this.facetDataEnabled=!1,this.facetParameters={},this.bbSize=a.e.Zero(),this.subDiv={max:1,X:1,Y:1,Z:1},this.facetDepthSort=!1,this.facetDepthSortEnabled=!1},T=function(){this._hasVertexAlpha=!1,this._useVertexColors=!0,this._numBoneInfluencers=4,this._applyFog=!0,this._receiveShadows=!1,this._facetData=new b,this._visibility=1,this._skeleton=null,this._layerMask=268435455,this._computeBonesUsingShaders=!0,this._isActive=!1,this._onlyForInstances=!1,this._isActiveIntermediate=!1,this._onlyForInstancesIntermediate=!1,this._actAsRegularMesh=!1},E=function(e){function t(i,n){void 0===n&&(n=null);var r=e.call(this,i,n,!1)||this;return r._internalAbstractMeshDataInfo=new T,r.cullingStrategy=t.CULLINGSTRATEGY_BOUNDINGSPHERE_ONLY,r.onCollideObservable=new o.c,r.onCollisionPositionChangeObservable=new o.c,r.onMaterialChangedObservable=new o.c,r.definedFacingForward=!0,r._occlusionQuery=null,r._renderingGroup=null,r.alphaIndex=Number.MAX_VALUE,r.isVisible=!0,r.isPickable=!0,r.showSubMeshesBoundingBox=!1,r.isBlocker=!1,r.enablePointerMoveEvents=!1,r.renderingGroupId=0,r._material=null,r.outlineColor=g.a.Red(),r.outlineWidth=.02,r.overlayColor=g.a.Red(),r.overlayAlpha=.5,r.useOctreeForRenderingSelection=!0,r.useOctreeForPicking=!0,r.useOctreeForCollisions=!0,r.alwaysSelectAsActiveMesh=!1,r.doNotSyncBoundingInfo=!1,r.actionManager=null,r._meshCollisionData=new p.a,r.ellipsoid=new a.e(.5,1,.5),r.ellipsoidOffset=new a.e(0,0,0),r.edgesWidth=1,r.edgesColor=new g.b(1,0,0,1),r._edgesRenderer=null,r._masterMesh=null,r._boundingInfo=null,r._renderId=0,r._intersectionsInProgress=new Array,r._unIndexed=!1,r._lightSources=new Array,r._waitingData={lods:null,actions:null,freezeWorldMatrix:null},r._bonesTransformMatrices=null,r._transformMatrixTexture=null,r.onRebuildObservable=new o.c,r._onCollisionPositionChange=function(e,t,i){void 0===i&&(i=null),t.subtractToRef(r._meshCollisionData._oldPositionForCollisions,r._meshCollisionData._diffPositionForCollisions),r._meshCollisionData._diffPositionForCollisions.length()>s.a.CollisionsEpsilon&&r.position.addInPlace(r._meshCollisionData._diffPositionForCollisions),i&&r.onCollideObservable.notifyObservers(i),r.onCollisionPositionChangeObservable.notifyObservers(r.position)},r.getScene().addMesh(r),r._resyncLightSources(),r}return Object(n.d)(t,e),Object.defineProperty(t,"BILLBOARDMODE_NONE",{get:function(){return u.a.BILLBOARDMODE_NONE},enumerable:!0,configurable:!0}),Object.defineProperty(t,"BILLBOARDMODE_X",{get:function(){return u.a.BILLBOARDMODE_X},enumerable:!0,configurable:!0}),Object.defineProperty(t,"BILLBOARDMODE_Y",{get:function(){return u.a.BILLBOARDMODE_Y},enumerable:!0,configurable:!0}),Object.defineProperty(t,"BILLBOARDMODE_Z",{get:function(){return u.a.BILLBOARDMODE_Z},enumerable:!0,configurable:!0}),Object.defineProperty(t,"BILLBOARDMODE_ALL",{get:function(){return u.a.BILLBOARDMODE_ALL},enumerable:!0,configurable:!0}),Object.defineProperty(t,"BILLBOARDMODE_USE_POSITION",{get:function(){return u.a.BILLBOARDMODE_USE_POSITION},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"facetNb",{get:function(){return this._internalAbstractMeshDataInfo._facetData.facetNb},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"partitioningSubdivisions",{get:function(){return this._internalAbstractMeshDataInfo._facetData.partitioningSubdivisions},set:function(e){this._internalAbstractMeshDataInfo._facetData.partitioningSubdivisions=e},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"partitioningBBoxRatio",{get:function(){return this._internalAbstractMeshDataInfo._facetData.partitioningBBoxRatio},set:function(e){this._internalAbstractMeshDataInfo._facetData.partitioningBBoxRatio=e},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"mustDepthSortFacets",{get:function(){return this._internalAbstractMeshDataInfo._facetData.facetDepthSort},set:function(e){this._internalAbstractMeshDataInfo._facetData.facetDepthSort=e},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"facetDepthSortFrom",{get:function(){return this._internalAbstractMeshDataInfo._facetData.facetDepthSortFrom},set:function(e){this._internalAbstractMeshDataInfo._facetData.facetDepthSortFrom=e},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isFacetDataEnabled",{get:function(){return this._internalAbstractMeshDataInfo._facetData.facetDataEnabled},enumerable:!0,configurable:!0}),t.prototype._updateNonUniformScalingState=function(t){return!!e.prototype._updateNonUniformScalingState.call(this,t)&&(this._markSubMeshesAsMiscDirty(),!0)},Object.defineProperty(t.prototype,"onCollide",{set:function(e){this._meshCollisionData._onCollideObserver&&this.onCollideObservable.remove(this._meshCollisionData._onCollideObserver),this._meshCollisionData._onCollideObserver=this.onCollideObservable.add(e)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"onCollisionPositionChange",{set:function(e){this._meshCollisionData._onCollisionPositionChangeObserver&&this.onCollisionPositionChangeObservable.remove(this._meshCollisionData._onCollisionPositionChangeObserver),this._meshCollisionData._onCollisionPositionChangeObserver=this.onCollisionPositionChangeObservable.add(e)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"visibility",{get:function(){return this._internalAbstractMeshDataInfo._visibility},set:function(e){this._internalAbstractMeshDataInfo._visibility!==e&&(this._internalAbstractMeshDataInfo._visibility=e,this._markSubMeshesAsMiscDirty())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"material",{get:function(){return this._material},set:function(e){this._material!==e&&(this._material&&this._material.meshMap&&(this._material.meshMap[this.uniqueId]=void 0),this._material=e,e&&e.meshMap&&(e.meshMap[this.uniqueId]=this),this.onMaterialChangedObservable.hasObservers()&&this.onMaterialChangedObservable.notifyObservers(this),this.subMeshes&&this._unBindEffect())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"receiveShadows",{get:function(){return this._internalAbstractMeshDataInfo._receiveShadows},set:function(e){this._internalAbstractMeshDataInfo._receiveShadows!==e&&(this._internalAbstractMeshDataInfo._receiveShadows=e,this._markSubMeshesAsLightDirty())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"hasVertexAlpha",{get:function(){return this._internalAbstractMeshDataInfo._hasVertexAlpha},set:function(e){this._internalAbstractMeshDataInfo._hasVertexAlpha!==e&&(this._internalAbstractMeshDataInfo._hasVertexAlpha=e,this._markSubMeshesAsAttributesDirty(),this._markSubMeshesAsMiscDirty())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"useVertexColors",{get:function(){return this._internalAbstractMeshDataInfo._useVertexColors},set:function(e){this._internalAbstractMeshDataInfo._useVertexColors!==e&&(this._internalAbstractMeshDataInfo._useVertexColors=e,this._markSubMeshesAsAttributesDirty())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"computeBonesUsingShaders",{get:function(){return this._internalAbstractMeshDataInfo._computeBonesUsingShaders},set:function(e){this._internalAbstractMeshDataInfo._computeBonesUsingShaders!==e&&(this._internalAbstractMeshDataInfo._computeBonesUsingShaders=e,this._markSubMeshesAsAttributesDirty())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"numBoneInfluencers",{get:function(){return this._internalAbstractMeshDataInfo._numBoneInfluencers},set:function(e){this._internalAbstractMeshDataInfo._numBoneInfluencers!==e&&(this._internalAbstractMeshDataInfo._numBoneInfluencers=e,this._markSubMeshesAsAttributesDirty())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"applyFog",{get:function(){return this._internalAbstractMeshDataInfo._applyFog},set:function(e){this._internalAbstractMeshDataInfo._applyFog!==e&&(this._internalAbstractMeshDataInfo._applyFog=e,this._markSubMeshesAsMiscDirty())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"layerMask",{get:function(){return this._internalAbstractMeshDataInfo._layerMask},set:function(e){e!==this._internalAbstractMeshDataInfo._layerMask&&(this._internalAbstractMeshDataInfo._layerMask=e,this._resyncLightSources())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"collisionMask",{get:function(){return this._meshCollisionData._collisionMask},set:function(e){this._meshCollisionData._collisionMask=isNaN(e)?-1:e},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"collisionGroup",{get:function(){return this._meshCollisionData._collisionGroup},set:function(e){this._meshCollisionData._collisionGroup=isNaN(e)?-1:e},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"lightSources",{get:function(){return this._lightSources},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_positions",{get:function(){return null},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"skeleton",{get:function(){return this._internalAbstractMeshDataInfo._skeleton},set:function(e){var t=this._internalAbstractMeshDataInfo._skeleton;t&&t.needInitialSkinMatrix&&t._unregisterMeshWithPoseMatrix(this),e&&e.needInitialSkinMatrix&&e._registerMeshWithPoseMatrix(this),this._internalAbstractMeshDataInfo._skeleton=e,this._internalAbstractMeshDataInfo._skeleton||(this._bonesTransformMatrices=null),this._markSubMeshesAsAttributesDirty()},enumerable:!0,configurable:!0}),t.prototype.getClassName=function(){return"AbstractMesh"},t.prototype.toString=function(e){var t="Name: "+this.name+", isInstance: "+("InstancedMesh"!==this.getClassName()?"YES":"NO");t+=", # of submeshes: "+(this.subMeshes?this.subMeshes.length:0);var i=this._internalAbstractMeshDataInfo._skeleton;return i&&(t+=", skeleton: "+i.name),e&&(t+=", billboard mode: "+["NONE","X","Y",null,"Z",null,null,"ALL"][this.billboardMode],t+=", freeze wrld mat: "+(this._isWorldMatrixFrozen||this._waitingData.freezeWorldMatrix?"YES":"NO")),t},t.prototype._getEffectiveParent=function(){return this._masterMesh&&this.billboardMode!==u.a.BILLBOARDMODE_NONE?this._masterMesh:e.prototype._getEffectiveParent.call(this)},t.prototype._getActionManagerForTrigger=function(e,t){if(void 0===t&&(t=!0),this.actionManager&&(t||this.actionManager.isRecursive)){if(!e)return this.actionManager;if(this.actionManager.hasSpecificTrigger(e))return this.actionManager}return this.parent?this.parent._getActionManagerForTrigger(e,!1):null},t.prototype._rebuild=function(){if(this.onRebuildObservable.notifyObservers(this),this._occlusionQuery&&(this._occlusionQuery=null),this.subMeshes)for(var e=0,t=this.subMeshes;e<t.length;e++){t[e]._rebuild()}},t.prototype._resyncLightSources=function(){this._lightSources.length=0;for(var e=0,t=this.getScene().lights;e<t.length;e++){var i=t[e];i.isEnabled()&&(i.canAffectMesh(this)&&this._lightSources.push(i))}this._markSubMeshesAsLightDirty()},t.prototype._resyncLightSource=function(e){var t=e.isEnabled()&&e.canAffectMesh(this),i=this._lightSources.indexOf(e);if(-1===i){if(!t)return;this._lightSources.push(e)}else{if(t)return;this._lightSources.splice(i,1)}this._markSubMeshesAsLightDirty()},t.prototype._unBindEffect=function(){for(var e=0,t=this.subMeshes;e<t.length;e++){t[e].setEffect(null)}},t.prototype._removeLightSource=function(e,t){var i=this._lightSources.indexOf(e);-1!==i&&(this._lightSources.splice(i,1),this._markSubMeshesAsLightDirty(t))},t.prototype._markSubMeshesAsDirty=function(e){if(this.subMeshes)for(var t=0,i=this.subMeshes;t<i.length;t++){var n=i[t];n._materialDefines&&e(n._materialDefines)}},t.prototype._markSubMeshesAsLightDirty=function(e){void 0===e&&(e=!1),this._markSubMeshesAsDirty(function(t){return t.markAsLightDirty(e)})},t.prototype._markSubMeshesAsAttributesDirty=function(){this._markSubMeshesAsDirty(function(e){return e.markAsAttributesDirty()})},t.prototype._markSubMeshesAsMiscDirty=function(){if(this.subMeshes)for(var e=0,t=this.subMeshes;e<t.length;e++){var i=t[e].getMaterial();i&&i.markAsDirty(f.a.MATERIAL_MiscDirtyFlag)}},Object.defineProperty(t.prototype,"scaling",{get:function(){return this._scaling},set:function(e){this._scaling=e},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isBlocked",{get:function(){return!1},enumerable:!0,configurable:!0}),t.prototype.getLOD=function(e){return this},t.prototype.getTotalVertices=function(){return 0},t.prototype.getTotalIndices=function(){return 0},t.prototype.getIndices=function(){return null},t.prototype.getVerticesData=function(e){return null},t.prototype.setVerticesData=function(e,t,i,n){return this},t.prototype.updateVerticesData=function(e,t,i,n){return this},t.prototype.setIndices=function(e,t){return this},t.prototype.isVerticesDataPresent=function(e){return!1},t.prototype.getBoundingInfo=function(){return this._masterMesh?this._masterMesh.getBoundingInfo():(this._boundingInfo||this._updateBoundingInfo(),this._boundingInfo)},t.prototype.normalizeToUnitCube=function(t,i,n){return void 0===t&&(t=!0),void 0===i&&(i=!1),e.prototype.normalizeToUnitCube.call(this,t,i,n)},t.prototype.setBoundingInfo=function(e){return this._boundingInfo=e,this},Object.defineProperty(t.prototype,"useBones",{get:function(){return this.skeleton&&this.getScene().skeletonsEnabled&&this.isVerticesDataPresent(c.b.MatricesIndicesKind)&&this.isVerticesDataPresent(c.b.MatricesWeightsKind)},enumerable:!0,configurable:!0}),t.prototype._preActivate=function(){},t.prototype._preActivateForIntermediateRendering=function(e){},t.prototype._activate=function(e,t){return this._renderId=e,!0},t.prototype._postActivate=function(){},t.prototype._freeze=function(){},t.prototype._unFreeze=function(){},t.prototype.getWorldMatrix=function(){return this._masterMesh&&this.billboardMode===u.a.BILLBOARDMODE_NONE?this._masterMesh.getWorldMatrix():e.prototype.getWorldMatrix.call(this)},t.prototype._getWorldMatrixDeterminant=function(){return this._masterMesh?this._masterMesh._getWorldMatrixDeterminant():e.prototype._getWorldMatrixDeterminant.call(this)},Object.defineProperty(t.prototype,"isAnInstance",{get:function(){return!1},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"hasInstances",{get:function(){return!1},enumerable:!0,configurable:!0}),t.prototype.movePOV=function(e,t,i){return this.position.addInPlace(this.calcMovePOV(e,t,i)),this},t.prototype.calcMovePOV=function(e,t,i){var n=new a.a;(this.rotationQuaternion?this.rotationQuaternion:a.b.RotationYawPitchRoll(this.rotation.y,this.rotation.x,this.rotation.z)).toRotationMatrix(n);var r=a.e.Zero(),o=this.definedFacingForward?-1:1;return a.e.TransformCoordinatesFromFloatsToRef(e*o,t,i*o,n,r),r},t.prototype.rotatePOV=function(e,t,i){return this.rotation.addInPlace(this.calcRotatePOV(e,t,i)),this},t.prototype.calcRotatePOV=function(e,t,i){var n=this.definedFacingForward?1:-1;return new a.e(e*n,t,i*n)},t.prototype.refreshBoundingInfo=function(e){return void 0===e&&(e=!1),this._boundingInfo&&this._boundingInfo.isLocked?this:(this._refreshBoundingInfo(this._getPositionData(e),null),this)},t.prototype._refreshBoundingInfo=function(e,t){if(e){var i=Object(m.a)(e,0,this.getTotalVertices(),t);this._boundingInfo?this._boundingInfo.reConstruct(i.minimum,i.maximum):this._boundingInfo=new d.a(i.minimum,i.maximum)}if(this.subMeshes)for(var n=0;n<this.subMeshes.length;n++)this.subMeshes[n].refreshBoundingInfo(e);this._updateBoundingInfo()},t.prototype._getPositionData=function(e){var t=this.getVerticesData(c.b.PositionKind);if(t&&e&&this.skeleton){t=r.b.Slice(t),this._generatePointsArray();var i=this.getVerticesData(c.b.MatricesIndicesKind),n=this.getVerticesData(c.b.MatricesWeightsKind);if(n&&i){var o=this.numBoneInfluencers>4,s=o?this.getVerticesData(c.b.MatricesIndicesExtraKind):null,l=o?this.getVerticesData(c.b.MatricesWeightsExtraKind):null;this.skeleton.prepare();for(var u=this.skeleton.getTransformMatrices(this),h=a.c.Vector3[0],d=a.c.Matrix[0],f=a.c.Matrix[1],p=0,_=0;_<t.length;_+=3,p+=4){var m,g;for(d.reset(),m=0;m<4;m++)(g=n[p+m])>0&&(a.a.FromFloat32ArrayToRefScaled(u,Math.floor(16*i[p+m]),g,f),d.addToSelf(f));if(o)for(m=0;m<4;m++)(g=l[p+m])>0&&(a.a.FromFloat32ArrayToRefScaled(u,Math.floor(16*s[p+m]),g,f),d.addToSelf(f));a.e.TransformCoordinatesFromFloatsToRef(t[_],t[_+1],t[_+2],d,h),h.toArray(t,_),this._positions&&this._positions[_/3].copyFrom(h)}}}return t},t.prototype._updateBoundingInfo=function(){var e=this._effectiveMesh;return this._boundingInfo?this._boundingInfo.update(e.worldMatrixFromCache):this._boundingInfo=new d.a(this.absolutePosition,this.absolutePosition,e.worldMatrixFromCache),this._updateSubMeshesBoundingInfo(e.worldMatrixFromCache),this},t.prototype._updateSubMeshesBoundingInfo=function(e){if(!this.subMeshes)return this;for(var t=this.subMeshes.length,i=0;i<t;i++){var n=this.subMeshes[i];(t>1||!n.IsGlobal)&&n.updateBoundingInfo(e)}return this},t.prototype._afterComputeWorldMatrix=function(){this.doNotSyncBoundingInfo||this._updateBoundingInfo()},Object.defineProperty(t.prototype,"_effectiveMesh",{get:function(){return this.skeleton&&this.skeleton.overrideMesh||this},enumerable:!0,configurable:!0}),t.prototype.isInFrustum=function(e){return null!==this._boundingInfo&&this._boundingInfo.isInFrustum(e,this.cullingStrategy)},t.prototype.isCompletelyInFrustum=function(e){return null!==this._boundingInfo&&this._boundingInfo.isCompletelyInFrustum(e)},t.prototype.intersectsMesh=function(e,t,i){if(void 0===t&&(t=!1),!this._boundingInfo||!e._boundingInfo)return!1;if(this._boundingInfo.intersects(e._boundingInfo,t))return!0;if(i)for(var n=0,r=this.getChildMeshes();n<r.length;n++){if(r[n].intersectsMesh(e,t,!0))return!0}return!1},t.prototype.intersectsPoint=function(e){return!!this._boundingInfo&&this._boundingInfo.intersectsPoint(e)},Object.defineProperty(t.prototype,"checkCollisions",{get:function(){return this._meshCollisionData._checkCollisions},set:function(e){this._meshCollisionData._checkCollisions=e},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"collider",{get:function(){return this._meshCollisionData._collider},enumerable:!0,configurable:!0}),t.prototype.moveWithCollisions=function(e){this.getAbsolutePosition().addToRef(this.ellipsoidOffset,this._meshCollisionData._oldPositionForCollisions);var t=this.getScene().collisionCoordinator;return this._meshCollisionData._collider||(this._meshCollisionData._collider=t.createCollider()),this._meshCollisionData._collider._radius=this.ellipsoid,t.getNewPosition(this._meshCollisionData._oldPositionForCollisions,e,this._meshCollisionData._collider,3,this,this._onCollisionPositionChange,this.uniqueId),this},t.prototype._collideForSubMesh=function(e,t,i){if(this._generatePointsArray(),!this._positions)return this;if(!e._lastColliderWorldVertices||!e._lastColliderTransformMatrix.equals(t)){e._lastColliderTransformMatrix=t.clone(),e._lastColliderWorldVertices=[],e._trianglePlanes=[];for(var n=e.verticesStart,r=e.verticesStart+e.verticesCount,o=n;o<r;o++)e._lastColliderWorldVertices.push(a.e.TransformCoordinates(this._positions[o],t))}return i._collide(e._trianglePlanes,e._lastColliderWorldVertices,this.getIndices(),e.indexStart,e.indexStart+e.indexCount,e.verticesStart,!!e.getMaterial(),this),this},t.prototype._processCollisionsForSubMeshes=function(e,t){for(var i=this._scene.getCollidingSubMeshCandidates(this,e),n=i.length,r=0;r<n;r++){var o=i.data[r];n>1&&!o._checkCollision(e)||this._collideForSubMesh(o,t,e)}return this},t.prototype._checkCollision=function(e){if(!this._boundingInfo||!this._boundingInfo._checkCollision(e))return this;var t=a.c.Matrix[0],i=a.c.Matrix[1];return a.a.ScalingToRef(1/e._radius.x,1/e._radius.y,1/e._radius.z,t),this.worldMatrixFromCache.multiplyToRef(t,i),this._processCollisionsForSubMeshes(e,i),this},t.prototype._generatePointsArray=function(){return!1},t.prototype.intersects=function(e,t,i){var n=new h.a,r="InstancedLinesMesh"===this.getClassName()||"LinesMesh"===this.getClassName()?this.intersectionThreshold:0,o=this._boundingInfo;if(!(this.subMeshes&&o&&e.intersectsSphere(o.boundingSphere,r)&&e.intersectsBox(o.boundingBox,r)))return n;if(!this._generatePointsArray())return n;for(var s=null,c=this._scene.getIntersectingSubMeshCandidates(this,e),l=c.length,u=0;u<l;u++){var d=c.data[u];if(!(l>1)||d.canIntersects(e)){var f=d.intersects(e,this._positions,this.getIndices(),t,i);if(f&&(t||!s||f.distance<s.distance)&&((s=f).subMeshId=u,t))break}}if(s){var p=this.getWorldMatrix(),_=a.c.Vector3[0],m=a.c.Vector3[1];a.e.TransformCoordinatesToRef(e.origin,p,_),e.direction.scaleToRef(s.distance,m);var g=a.e.TransformNormal(m,p).addInPlace(_);return n.hit=!0,n.distance=a.e.Distance(_,g),n.pickedPoint=g,n.pickedMesh=this,n.bu=s.bu||0,n.bv=s.bv||0,n.faceId=s.faceId,n.subMeshId=s.subMeshId,n}return n},t.prototype.clone=function(e,t,i){return null},t.prototype.releaseSubMeshes=function(){if(this.subMeshes)for(;this.subMeshes.length;)this.subMeshes[0].dispose();else this.subMeshes=new Array;return this},t.prototype.dispose=function(t,i){var n,r=this;for(void 0===i&&(i=!1),this._scene.useMaterialMeshMap&&this._material&&this._material.meshMap&&(this._material.meshMap[this.uniqueId]=void 0),this.getScene().freeActiveMeshes(),this.getScene().freeRenderingGroups(),void 0!==this.actionManager&&null!==this.actionManager&&(this.actionManager.dispose(),this.actionManager=null),this._internalAbstractMeshDataInfo._skeleton=null,this._transformMatrixTexture&&(this._transformMatrixTexture.dispose(),this._transformMatrixTexture=null),n=0;n<this._intersectionsInProgress.length;n++){var o=this._intersectionsInProgress[n],a=o._intersectionsInProgress.indexOf(this);o._intersectionsInProgress.splice(a,1)}this._intersectionsInProgress=[],this.getScene().lights.forEach(function(e){var t=e.includedOnlyMeshes.indexOf(r);-1!==t&&e.includedOnlyMeshes.splice(t,1),-1!==(t=e.excludedMeshes.indexOf(r))&&e.excludedMeshes.splice(t,1);var i=e.getShadowGenerator();if(i){var n=i.getShadowMap();n&&n.renderList&&-1!==(t=n.renderList.indexOf(r))&&n.renderList.splice(t,1)}}),"InstancedMesh"===this.getClassName()&&"InstancedLinesMesh"===this.getClassName()||this.releaseSubMeshes();var s=this.getScene().getEngine();if(this._occlusionQuery&&(this.isOcclusionQueryInProgress=!1,s.deleteQuery(this._occlusionQuery),this._occlusionQuery=null),s.wipeCaches(),this.getScene().removeMesh(this),i&&this.material&&("MultiMaterial"===this.material.getClassName()?this.material.dispose(!1,!0,!0):this.material.dispose(!1,!0)),!t)for(n=0;n<this.getScene().particleSystems.length;n++)this.getScene().particleSystems[n].emitter===this&&(this.getScene().particleSystems[n].dispose(),n--);this._internalAbstractMeshDataInfo._facetData.facetDataEnabled&&this.disableFacetData(),this.onAfterWorldMatrixUpdateObservable.clear(),this.onCollideObservable.clear(),this.onCollisionPositionChangeObservable.clear(),this.onRebuildObservable.clear(),e.prototype.dispose.call(this,t,i)},t.prototype.addChild=function(e){return e.setParent(this),this},t.prototype.removeChild=function(e){return e.setParent(null),this},t.prototype._initFacetData=function(){var e=this._internalAbstractMeshDataInfo._facetData;e.facetNormals||(e.facetNormals=new Array),e.facetPositions||(e.facetPositions=new Array),e.facetPartitioning||(e.facetPartitioning=new Array),e.facetNb=this.getIndices().length/3|0,e.partitioningSubdivisions=e.partitioningSubdivisions?e.partitioningSubdivisions:10,e.partitioningBBoxRatio=e.partitioningBBoxRatio?e.partitioningBBoxRatio:1.01;for(var t=0;t<e.facetNb;t++)e.facetNormals[t]=a.e.Zero(),e.facetPositions[t]=a.e.Zero();return e.facetDataEnabled=!0,this},t.prototype.updateFacetData=function(){var e=this._internalAbstractMeshDataInfo._facetData;e.facetDataEnabled||this._initFacetData();var t=this.getVerticesData(c.b.PositionKind),i=this.getIndices(),n=this.getVerticesData(c.b.NormalKind),r=this.getBoundingInfo();if(e.facetDepthSort&&!e.facetDepthSortEnabled){if(e.facetDepthSortEnabled=!0,i instanceof Uint16Array)e.depthSortedIndices=new Uint16Array(i);else if(i instanceof Uint32Array)e.depthSortedIndices=new Uint32Array(i);else{for(var o=!1,s=0;s<i.length;s++)if(i[s]>65535){o=!0;break}e.depthSortedIndices=o?new Uint32Array(i):new Uint16Array(i)}if(e.facetDepthSortFunction=function(e,t){return t.sqDistance-e.sqDistance},!e.facetDepthSortFrom){var u=this.getScene().activeCamera;e.facetDepthSortFrom=u?u.position:a.e.Zero()}e.depthSortedFacets=[];for(var h=0;h<e.facetNb;h++){var d={ind:3*h,sqDistance:0};e.depthSortedFacets.push(d)}e.invertedMatrix=a.a.Identity(),e.facetDepthSortOrigin=a.e.Zero()}e.bbSize.x=r.maximum.x-r.minimum.x>v.a?r.maximum.x-r.minimum.x:v.a,e.bbSize.y=r.maximum.y-r.minimum.y>v.a?r.maximum.y-r.minimum.y:v.a,e.bbSize.z=r.maximum.z-r.minimum.z>v.a?r.maximum.z-r.minimum.z:v.a;var f=e.bbSize.x>e.bbSize.y?e.bbSize.x:e.bbSize.y;if(f=f>e.bbSize.z?f:e.bbSize.z,e.subDiv.max=e.partitioningSubdivisions,e.subDiv.X=Math.floor(e.subDiv.max*e.bbSize.x/f),e.subDiv.Y=Math.floor(e.subDiv.max*e.bbSize.y/f),e.subDiv.Z=Math.floor(e.subDiv.max*e.bbSize.z/f),e.subDiv.X=e.subDiv.X<1?1:e.subDiv.X,e.subDiv.Y=e.subDiv.Y<1?1:e.subDiv.Y,e.subDiv.Z=e.subDiv.Z<1?1:e.subDiv.Z,e.facetParameters.facetNormals=this.getFacetLocalNormals(),e.facetParameters.facetPositions=this.getFacetLocalPositions(),e.facetParameters.facetPartitioning=this.getFacetLocalPartitioning(),e.facetParameters.bInfo=r,e.facetParameters.bbSize=e.bbSize,e.facetParameters.subDiv=e.subDiv,e.facetParameters.ratio=this.partitioningBBoxRatio,e.facetParameters.depthSort=e.facetDepthSort,e.facetDepthSort&&e.facetDepthSortEnabled&&(this.computeWorldMatrix(!0),this._worldMatrix.invertToRef(e.invertedMatrix),a.e.TransformCoordinatesToRef(e.facetDepthSortFrom,e.invertedMatrix,e.facetDepthSortOrigin),e.facetParameters.distanceTo=e.facetDepthSortOrigin),e.facetParameters.depthSortedFacets=e.depthSortedFacets,l.a.ComputeNormals(t,i,n,e.facetParameters),e.facetDepthSort&&e.facetDepthSortEnabled){e.depthSortedFacets.sort(e.facetDepthSortFunction);var p=e.depthSortedIndices.length/3|0;for(h=0;h<p;h++){var _=e.depthSortedFacets[h].ind;e.depthSortedIndices[3*h]=i[_],e.depthSortedIndices[3*h+1]=i[_+1],e.depthSortedIndices[3*h+2]=i[_+2]}this.updateIndices(e.depthSortedIndices,void 0,!0)}return this},t.prototype.getFacetLocalNormals=function(){var e=this._internalAbstractMeshDataInfo._facetData;return e.facetNormals||this.updateFacetData(),e.facetNormals},t.prototype.getFacetLocalPositions=function(){var e=this._internalAbstractMeshDataInfo._facetData;return e.facetPositions||this.updateFacetData(),e.facetPositions},t.prototype.getFacetLocalPartitioning=function(){var e=this._internalAbstractMeshDataInfo._facetData;return e.facetPartitioning||this.updateFacetData(),e.facetPartitioning},t.prototype.getFacetPosition=function(e){var t=a.e.Zero();return this.getFacetPositionToRef(e,t),t},t.prototype.getFacetPositionToRef=function(e,t){var i=this.getFacetLocalPositions()[e],n=this.getWorldMatrix();return a.e.TransformCoordinatesToRef(i,n,t),this},t.prototype.getFacetNormal=function(e){var t=a.e.Zero();return this.getFacetNormalToRef(e,t),t},t.prototype.getFacetNormalToRef=function(e,t){var i=this.getFacetLocalNormals()[e];return a.e.TransformNormalToRef(i,this.getWorldMatrix(),t),this},t.prototype.getFacetsAtLocalCoordinates=function(e,t,i){var n=this.getBoundingInfo(),r=this._internalAbstractMeshDataInfo._facetData,o=Math.floor((e-n.minimum.x*r.partitioningBBoxRatio)*r.subDiv.X*r.partitioningBBoxRatio/r.bbSize.x),a=Math.floor((t-n.minimum.y*r.partitioningBBoxRatio)*r.subDiv.Y*r.partitioningBBoxRatio/r.bbSize.y),s=Math.floor((i-n.minimum.z*r.partitioningBBoxRatio)*r.subDiv.Z*r.partitioningBBoxRatio/r.bbSize.z);return o<0||o>r.subDiv.max||a<0||a>r.subDiv.max||s<0||s>r.subDiv.max?null:r.facetPartitioning[o+r.subDiv.max*a+r.subDiv.max*r.subDiv.max*s]},t.prototype.getClosestFacetAtCoordinates=function(e,t,i,n,r,o){void 0===r&&(r=!1),void 0===o&&(o=!0);var s=this.getWorldMatrix(),c=a.c.Matrix[5];s.invertToRef(c);var l=a.c.Vector3[8];a.e.TransformCoordinatesFromFloatsToRef(e,t,i,c,l);var u=this.getClosestFacetAtLocalCoordinates(l.x,l.y,l.z,n,r,o);return n&&a.e.TransformCoordinatesFromFloatsToRef(n.x,n.y,n.z,s,n),u},t.prototype.getClosestFacetAtLocalCoordinates=function(e,t,i,n,r,o){void 0===r&&(r=!1),void 0===o&&(o=!0);var a=null,s=0,c=0,l=0,u=0,h=0,d=0,f=0,p=0,_=this.getFacetLocalPositions(),m=this.getFacetLocalNormals(),g=this.getFacetsAtLocalCoordinates(e,t,i);if(!g)return null;for(var v,y,b,T=Number.MAX_VALUE,E=T,x=0;x<g.length;x++)y=m[v=g[x]],u=(e-(b=_[v]).x)*y.x+(t-b.y)*y.y+(i-b.z)*y.z,(!r||r&&o&&u>=0||r&&!o&&u<=0)&&(u=y.x*b.x+y.y*b.y+y.z*b.z,h=-(y.x*e+y.y*t+y.z*i-u)/(y.x*y.x+y.y*y.y+y.z*y.z),(E=(s=(d=e+y.x*h)-e)*s+(c=(f=t+y.y*h)-t)*c+(l=(p=i+y.z*h)-i)*l)<T&&(T=E,a=v,n&&(n.x=d,n.y=f,n.z=p)));return a},t.prototype.getFacetDataParameters=function(){return this._internalAbstractMeshDataInfo._facetData.facetParameters},t.prototype.disableFacetData=function(){var e=this._internalAbstractMeshDataInfo._facetData;return e.facetDataEnabled&&(e.facetDataEnabled=!1,e.facetPositions=new Array,e.facetNormals=new Array,e.facetPartitioning=new Array,e.facetParameters=null,e.depthSortedIndices=new Uint32Array(0)),this},t.prototype.updateIndices=function(e,t,i){return void 0===i&&(i=!1),this},t.prototype.createNormals=function(e){var t,i=this.getVerticesData(c.b.PositionKind),n=this.getIndices();return t=this.isVerticesDataPresent(c.b.NormalKind)?this.getVerticesData(c.b.NormalKind):[],l.a.ComputeNormals(i,n,t,{useRightHandedSystem:this.getScene().useRightHandedSystem}),this.setVerticesData(c.b.NormalKind,t,e),this},t.prototype.alignWithNormal=function(e,t){t||(t=y.a.Y);var i=a.c.Vector3[0],n=a.c.Vector3[1];return a.e.CrossToRef(t,e,n),a.e.CrossToRef(e,n,i),this.rotationQuaternion?a.b.RotationQuaternionFromAxisToRef(i,e,n,this.rotationQuaternion):a.e.RotationFromAxisToRef(i,e,n,this.rotation),this},t.prototype._checkOcclusionQuery=function(){return!1},t.prototype.disableEdgesRendering=function(){throw _.a.WarnImport("EdgesRenderer")},t.prototype.enableEdgesRendering=function(e,t){throw _.a.WarnImport("EdgesRenderer")},t.OCCLUSION_TYPE_NONE=0,t.OCCLUSION_TYPE_OPTIMISTIC=1,t.OCCLUSION_TYPE_STRICT=2,t.OCCLUSION_ALGORITHM_TYPE_ACCURATE=0,t.OCCLUSION_ALGORITHM_TYPE_CONSERVATIVE=1,t.CULLINGSTRATEGY_STANDARD=f.a.MESHES_CULLINGSTRATEGY_STANDARD,t.CULLINGSTRATEGY_BOUNDINGSPHERE_ONLY=f.a.MESHES_CULLINGSTRATEGY_BOUNDINGSPHERE_ONLY,t.CULLINGSTRATEGY_OPTIMISTIC_INCLUSION=f.a.MESHES_CULLINGSTRATEGY_OPTIMISTIC_INCLUSION,t.CULLINGSTRATEGY_OPTIMISTIC_INCLUSION_THEN_BSPHERE_ONLY=f.a.MESHES_CULLINGSTRATEGY_OPTIMISTIC_INCLUSION_THEN_BSPHERE_ONLY,t}(u.a)},function(e,t,i){"use strict";i.d(t,"b",function(){return n}),i.d(t,"c",function(){return r}),i.d(t,"a",function(){return o});var n=1/2.2,r=2.2,o=.001},function(e,t,i){"use strict";i.d(t,"a",function(){return f});var n=i(1),r=i(3),o=i(13),a=i(6),s=i(23),c=i(57),l=i(83),u=i(2),h=i(7),d=i(60),f=function(){function e(t,i,n){this.metadata=null,this.reservedDataStore=null,this.checkReadyOnEveryCall=!1,this.checkReadyOnlyOnce=!1,this.state="",this._alpha=1,this._backFaceCulling=!0,this.onCompiled=null,this.onError=null,this.getRenderTargetTextures=null,this.doNotSerialize=!1,this._storeEffectOnSubMeshes=!1,this.animations=null,this.onDisposeObservable=new a.c,this._onDisposeObserver=null,this._onUnBindObservable=null,this._onBindObserver=null,this._alphaMode=u.a.ALPHA_COMBINE,this._needDepthPrePass=!1,this.disableDepthWrite=!1,this.forceDepthWrite=!1,this.depthFunction=0,this.separateCullingPass=!1,this._fogEnabled=!0,this.pointSize=1,this.zOffset=0,this._effect=null,this._useUBO=!1,this._fillMode=e.TriangleFillMode,this._cachedDepthWriteState=!1,this._cachedDepthFunctionState=0,this._indexInSceneMaterialArray=-1,this.meshMap=null,this.name=t,this.id=t||o.b.RandomId(),this._scene=i||s.a.LastCreatedScene,this.uniqueId=this._scene.getUniqueId(),this._scene.useRightHandedSystem?this.sideOrientation=e.ClockWiseSideOrientation:this.sideOrientation=e.CounterClockWiseSideOrientation,this._uniformBuffer=new l.a(this._scene.getEngine()),this._useUBO=this.getScene().getEngine().supportsUniformBuffers,n||this._scene.addMaterial(this),this._scene.useMaterialMeshMap&&(this.meshMap={})}return Object.defineProperty(e.prototype,"alpha",{get:function(){return this._alpha},set:function(t){this._alpha!==t&&(this._alpha=t,this.markAsDirty(e.MiscDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"backFaceCulling",{get:function(){return this._backFaceCulling},set:function(t){this._backFaceCulling!==t&&(this._backFaceCulling=t,this.markAsDirty(e.TextureDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"hasRenderTargetTextures",{get:function(){return!1},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"onDispose",{set:function(e){this._onDisposeObserver&&this.onDisposeObservable.remove(this._onDisposeObserver),this._onDisposeObserver=this.onDisposeObservable.add(e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"onBindObservable",{get:function(){return this._onBindObservable||(this._onBindObservable=new a.c),this._onBindObservable},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"onBind",{set:function(e){this._onBindObserver&&this.onBindObservable.remove(this._onBindObserver),this._onBindObserver=this.onBindObservable.add(e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"onUnBindObservable",{get:function(){return this._onUnBindObservable||(this._onUnBindObservable=new a.c),this._onUnBindObservable},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"alphaMode",{get:function(){return this._alphaMode},set:function(t){this._alphaMode!==t&&(this._alphaMode=t,this.markAsDirty(e.TextureDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"needDepthPrePass",{get:function(){return this._needDepthPrePass},set:function(e){this._needDepthPrePass!==e&&(this._needDepthPrePass=e,this._needDepthPrePass&&(this.checkReadyOnEveryCall=!0))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"fogEnabled",{get:function(){return this._fogEnabled},set:function(t){this._fogEnabled!==t&&(this._fogEnabled=t,this.markAsDirty(e.MiscDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"wireframe",{get:function(){switch(this._fillMode){case e.WireFrameFillMode:case e.LineListDrawMode:case e.LineLoopDrawMode:case e.LineStripDrawMode:return!0}return this._scene.forceWireframe},set:function(t){this.fillMode=t?e.WireFrameFillMode:e.TriangleFillMode},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"pointsCloud",{get:function(){switch(this._fillMode){case e.PointFillMode:case e.PointListDrawMode:return!0}return this._scene.forcePointsCloud},set:function(t){this.fillMode=t?e.PointFillMode:e.TriangleFillMode},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"fillMode",{get:function(){return this._fillMode},set:function(t){this._fillMode!==t&&(this._fillMode=t,this.markAsDirty(e.MiscDirtyFlag))},enumerable:!0,configurable:!0}),e.prototype.toString=function(e){return"Name: "+this.name},e.prototype.getClassName=function(){return"Material"},Object.defineProperty(e.prototype,"isFrozen",{get:function(){return this.checkReadyOnlyOnce},enumerable:!0,configurable:!0}),e.prototype.freeze=function(){this.markDirty(),this.checkReadyOnlyOnce=!0},e.prototype.unfreeze=function(){this.markDirty(),this.checkReadyOnlyOnce=!1},e.prototype.isReady=function(e,t){return!0},e.prototype.isReadyForSubMesh=function(e,t,i){return!1},e.prototype.getEffect=function(){return this._effect},e.prototype.getScene=function(){return this._scene},e.prototype.needAlphaBlending=function(){return this.alpha<1},e.prototype.needAlphaBlendingForMesh=function(e){return this.needAlphaBlending()||e.visibility<1||e.hasVertexAlpha},e.prototype.needAlphaTesting=function(){return!1},e.prototype.getAlphaTestTexture=function(){return null},e.prototype.markDirty=function(){for(var e=0,t=this.getScene().meshes;e<t.length;e++){var i=t[e];if(i.subMeshes)for(var n=0,r=i.subMeshes;n<r.length;n++){var o=r[n];o.getMaterial()===this&&(o.effect&&(o.effect._wasPreviouslyReady=!1))}}},e.prototype._preBind=function(t,i){void 0===i&&(i=null);var n=this._scene.getEngine(),r=(null==i?this.sideOrientation:i)===e.ClockWiseSideOrientation;return n.enableEffect(t||this._effect),n.setState(this.backFaceCulling,this.zOffset,!1,r),r},e.prototype.bind=function(e,t){},e.prototype.bindForSubMesh=function(e,t,i){},e.prototype.bindOnlyWorldMatrix=function(e){},e.prototype.bindSceneUniformBuffer=function(e,t){t.bindToEffect(e,"Scene")},e.prototype.bindView=function(e){this._useUBO?this.bindSceneUniformBuffer(e,this.getScene().getSceneUniformBuffer()):e.setMatrix("view",this.getScene().getViewMatrix())},e.prototype.bindViewProjection=function(e){this._useUBO?this.bindSceneUniformBuffer(e,this.getScene().getSceneUniformBuffer()):e.setMatrix("viewProjection",this.getScene().getTransformMatrix())},e.prototype._shouldTurnAlphaTestOn=function(e){return!this.needAlphaBlendingForMesh(e)&&this.needAlphaTesting()},e.prototype._afterBind=function(e){if(this._scene._cachedMaterial=this,this._scene._cachedVisibility=e?e.visibility:1,this._onBindObservable&&e&&this._onBindObservable.notifyObservers(e),this.disableDepthWrite){var t=this._scene.getEngine();this._cachedDepthWriteState=t.getDepthWrite(),t.setDepthWrite(!1)}if(0!==this.depthFunction){t=this._scene.getEngine();this._cachedDepthFunctionState=t.getDepthFunction()||0,t.setDepthFunction(this.depthFunction)}},e.prototype.unbind=function(){(this._onUnBindObservable&&this._onUnBindObservable.notifyObservers(this),0!==this.depthFunction)&&this._scene.getEngine().setDepthFunction(this._cachedDepthFunctionState);this.disableDepthWrite&&this._scene.getEngine().setDepthWrite(this._cachedDepthWriteState)},e.prototype.getActiveTextures=function(){return[]},e.prototype.hasTexture=function(e){return!1},e.prototype.clone=function(e){return null},e.prototype.getBindedMeshes=function(){var e=this;if(this.meshMap){var t=new Array;for(var i in this.meshMap){var n=this.meshMap[i];n&&t.push(n)}return t}return this._scene.meshes.filter(function(t){return t.material===e})},e.prototype.forceCompilation=function(e,t,i,r){var o=this,a=Object(n.a)({clipPlane:!1,useInstances:!1},i),s=new c.a,l=this.getScene(),u=function(){if(o._scene&&o._scene.getEngine()){s._materialDefines&&(s._materialDefines._renderId=-1);var i=l.clipPlane;a.clipPlane&&(l.clipPlane=new d.a(0,0,0,1)),o._storeEffectOnSubMeshes?o.isReadyForSubMesh(e,s,a.useInstances)?t&&t(o):s.effect&&s.effect.getCompilationError()&&s.effect.allFallbacksProcessed()?r&&r(s.effect.getCompilationError()):setTimeout(u,16):o.isReady()?t&&t(o):setTimeout(u,16),a.clipPlane&&(l.clipPlane=i)}};u()},e.prototype.forceCompilationAsync=function(e,t){var i=this;return new Promise(function(n,r){i.forceCompilation(e,function(){n()},t,function(e){r(e)})})},e.prototype.markAsDirty=function(t){this.getScene().blockMaterialDirtyMechanism||(e._DirtyCallbackArray.length=0,t&e.TextureDirtyFlag&&e._DirtyCallbackArray.push(e._TextureDirtyCallBack),t&e.LightDirtyFlag&&e._DirtyCallbackArray.push(e._LightsDirtyCallBack),t&e.FresnelDirtyFlag&&e._DirtyCallbackArray.push(e._FresnelDirtyCallBack),t&e.AttributesDirtyFlag&&e._DirtyCallbackArray.push(e._AttributeDirtyCallBack),t&e.MiscDirtyFlag&&e._DirtyCallbackArray.push(e._MiscDirtyCallBack),e._DirtyCallbackArray.length&&this._markAllSubMeshesAsDirty(e._RunDirtyCallBacks),this.getScene().resetCachedMaterial())},e.prototype._markAllSubMeshesAsDirty=function(e){if(!this.getScene().blockMaterialDirtyMechanism)for(var t=0,i=this.getScene().meshes;t<i.length;t++){var n=i[t];if(n.subMeshes)for(var r=0,o=n.subMeshes;r<o.length;r++){var a=o[r];a.getMaterial()===this&&(a._materialDefines&&e(a._materialDefines))}}},e.prototype._markAllSubMeshesAsAllDirty=function(){this._markAllSubMeshesAsDirty(e._AllDirtyCallBack)},e.prototype._markAllSubMeshesAsImageProcessingDirty=function(){this._markAllSubMeshesAsDirty(e._ImageProcessingDirtyCallBack)},e.prototype._markAllSubMeshesAsTexturesDirty=function(){this._markAllSubMeshesAsDirty(e._TextureDirtyCallBack)},e.prototype._markAllSubMeshesAsFresnelDirty=function(){this._markAllSubMeshesAsDirty(e._FresnelDirtyCallBack)},e.prototype._markAllSubMeshesAsFresnelAndMiscDirty=function(){this._markAllSubMeshesAsDirty(e._FresnelAndMiscDirtyCallBack)},e.prototype._markAllSubMeshesAsLightsDirty=function(){this._markAllSubMeshesAsDirty(e._LightsDirtyCallBack)},e.prototype._markAllSubMeshesAsAttributesDirty=function(){this._markAllSubMeshesAsDirty(e._AttributeDirtyCallBack)},e.prototype._markAllSubMeshesAsMiscDirty=function(){this._markAllSubMeshesAsDirty(e._MiscDirtyCallBack)},e.prototype._markAllSubMeshesAsTexturesAndMiscDirty=function(){this._markAllSubMeshesAsDirty(e._TextureAndMiscDirtyCallBack)},e.prototype.dispose=function(e,t,i){var n=this.getScene();if(n.stopAnimation(this),n.freeProcessedMaterials(),n.removeMaterial(this),!0!==i)if(this.meshMap)for(var r in this.meshMap){(s=this.meshMap[r])&&(s.material=null,this.releaseVertexArrayObject(s,e))}else for(var o=0,a=n.meshes;o<a.length;o++){var s;(s=a[o]).material!==this||s.sourceMesh||(s.material=null,this.releaseVertexArrayObject(s,e))}this._uniformBuffer.dispose(),e&&this._effect&&(this._storeEffectOnSubMeshes||this._effect.dispose(),this._effect=null),this.onDisposeObservable.notifyObservers(this),this.onDisposeObservable.clear(),this._onBindObservable&&this._onBindObservable.clear(),this._onUnBindObservable&&this._onUnBindObservable.clear()},e.prototype.releaseVertexArrayObject=function(e,t){if(e.geometry){var i=e.geometry;if(this._storeEffectOnSubMeshes)for(var n=0,r=e.subMeshes;n<r.length;n++){var o=r[n];i._releaseVertexArrayObject(o._materialEffect),t&&o._materialEffect&&o._materialEffect.dispose()}else i._releaseVertexArrayObject(this._effect)}},e.prototype.serialize=function(){return r.a.Serialize(this)},e.Parse=function(e,t,i){if(e.customType){if("BABYLON.PBRMaterial"===e.customType&&e.overloadedAlbedo&&(e.customType="BABYLON.LegacyPBRMaterial",!BABYLON.LegacyPBRMaterial))return h.a.Error("Your scene is trying to load a legacy version of the PBRMaterial, please, include it from the materials library."),null}else e.customType="BABYLON.StandardMaterial";return o.b.Instantiate(e.customType).Parse(e,t,i)},e.TriangleFillMode=u.a.MATERIAL_TriangleFillMode,e.WireFrameFillMode=u.a.MATERIAL_WireFrameFillMode,e.PointFillMode=u.a.MATERIAL_PointFillMode,e.PointListDrawMode=u.a.MATERIAL_PointListDrawMode,e.LineListDrawMode=u.a.MATERIAL_LineListDrawMode,e.LineLoopDrawMode=u.a.MATERIAL_LineLoopDrawMode,e.LineStripDrawMode=u.a.MATERIAL_LineStripDrawMode,e.TriangleStripDrawMode=u.a.MATERIAL_TriangleStripDrawMode,e.TriangleFanDrawMode=u.a.MATERIAL_TriangleFanDrawMode,e.ClockWiseSideOrientation=u.a.MATERIAL_ClockWiseSideOrientation,e.CounterClockWiseSideOrientation=u.a.MATERIAL_CounterClockWiseSideOrientation,e.TextureDirtyFlag=u.a.MATERIAL_TextureDirtyFlag,e.LightDirtyFlag=u.a.MATERIAL_LightDirtyFlag,e.FresnelDirtyFlag=u.a.MATERIAL_FresnelDirtyFlag,e.AttributesDirtyFlag=u.a.MATERIAL_AttributesDirtyFlag,e.MiscDirtyFlag=u.a.MATERIAL_MiscDirtyFlag,e.AllDirtyFlag=u.a.MATERIAL_AllDirtyFlag,e._AllDirtyCallBack=function(e){return e.markAllAsDirty()},e._ImageProcessingDirtyCallBack=function(e){return e.markAsImageProcessingDirty()},e._TextureDirtyCallBack=function(e){return e.markAsTexturesDirty()},e._FresnelDirtyCallBack=function(e){return e.markAsFresnelDirty()},e._MiscDirtyCallBack=function(e){return e.markAsMiscDirty()},e._LightsDirtyCallBack=function(e){return e.markAsLightDirty()},e._AttributeDirtyCallBack=function(e){return e.markAsAttributesDirty()},e._FresnelAndMiscDirtyCallBack=function(t){e._FresnelDirtyCallBack(t),e._MiscDirtyCallBack(t)},e._TextureAndMiscDirtyCallBack=function(t){e._TextureDirtyCallBack(t),e._MiscDirtyCallBack(t)},e._DirtyCallbackArray=[],e._RunDirtyCallBacks=function(t){for(var i=0,n=e._DirtyCallbackArray;i<n.length;i++){(0,n[i])(t)}},Object(n.c)([Object(r.c)()],e.prototype,"id",void 0),Object(n.c)([Object(r.c)()],e.prototype,"uniqueId",void 0),Object(n.c)([Object(r.c)()],e.prototype,"name",void 0),Object(n.c)([Object(r.c)()],e.prototype,"checkReadyOnEveryCall",void 0),Object(n.c)([Object(r.c)()],e.prototype,"checkReadyOnlyOnce",void 0),Object(n.c)([Object(r.c)()],e.prototype,"state",void 0),Object(n.c)([Object(r.c)("alpha")],e.prototype,"_alpha",void 0),Object(n.c)([Object(r.c)("backFaceCulling")],e.prototype,"_backFaceCulling",void 0),Object(n.c)([Object(r.c)()],e.prototype,"sideOrientation",void 0),Object(n.c)([Object(r.c)("alphaMode")],e.prototype,"_alphaMode",void 0),Object(n.c)([Object(r.c)()],e.prototype,"_needDepthPrePass",void 0),Object(n.c)([Object(r.c)()],e.prototype,"disableDepthWrite",void 0),Object(n.c)([Object(r.c)()],e.prototype,"forceDepthWrite",void 0),Object(n.c)([Object(r.c)()],e.prototype,"depthFunction",void 0),Object(n.c)([Object(r.c)()],e.prototype,"separateCullingPass",void 0),Object(n.c)([Object(r.c)("fogEnabled")],e.prototype,"_fogEnabled",void 0),Object(n.c)([Object(r.c)()],e.prototype,"pointSize",void 0),Object(n.c)([Object(r.c)()],e.prototype,"zOffset",void 0),Object(n.c)([Object(r.c)()],e.prototype,"wireframe",null),Object(n.c)([Object(r.c)()],e.prototype,"pointsCloud",null),Object(n.c)([Object(r.c)()],e.prototype,"fillMode",null),e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return u});var n=i(7),r=i(42),o=i(0),a=i(27),s=i(5),c=i(47),l=i(22);s.a._PhysicsImpostorParser=function(e,t,i){return new u(t,i.physicsImpostor,{mass:i.physicsMass,friction:i.physicsFriction,restitution:i.physicsRestitution},e)};var u=function(){function e(e,t,i,r){var a=this;void 0===i&&(i={mass:0}),this.object=e,this.type=t,this._options=i,this._scene=r,this._pluginData={},this._bodyUpdateRequired=!1,this._onBeforePhysicsStepCallbacks=new Array,this._onAfterPhysicsStepCallbacks=new Array,this._onPhysicsCollideCallbacks=[],this._deltaPosition=o.e.Zero(),this._isDisposed=!1,this.soft=!1,this.segments=0,this._tmpQuat=new o.b,this._tmpQuat2=new o.b,this.beforeStep=function(){a._physicsEngine&&(a.object.translate(a._deltaPosition,-1),a._deltaRotationConjugated&&a.object.rotationQuaternion&&a.object.rotationQuaternion.multiplyToRef(a._deltaRotationConjugated,a.object.rotationQuaternion),a.object.computeWorldMatrix(!1),a.object.parent&&a.object.rotationQuaternion?(a.getParentsRotation(),a._tmpQuat.multiplyToRef(a.object.rotationQuaternion,a._tmpQuat)):a._tmpQuat.copyFrom(a.object.rotationQuaternion||new o.b),a._options.disableBidirectionalTransformation||a.object.rotationQuaternion&&a._physicsEngine.getPhysicsPlugin().setPhysicsBodyTransformation(a,a.object.getAbsolutePosition(),a._tmpQuat),a._onBeforePhysicsStepCallbacks.forEach(function(e){e(a)}))},this.afterStep=function(){a._physicsEngine&&(a._onAfterPhysicsStepCallbacks.forEach(function(e){e(a)}),a._physicsEngine.getPhysicsPlugin().setTransformationFromPhysicsBody(a),a.object.parent&&a.object.rotationQuaternion&&(a.getParentsRotation(),a._tmpQuat.conjugateInPlace(),a._tmpQuat.multiplyToRef(a.object.rotationQuaternion,a.object.rotationQuaternion)),a.object.setAbsolutePosition(a.object.position),a._deltaRotation&&a.object.rotationQuaternion&&a.object.rotationQuaternion.multiplyToRef(a._deltaRotation,a.object.rotationQuaternion),a.object.translate(a._deltaPosition,1))},this.onCollideEvent=null,this.onCollide=function(e){if((a._onPhysicsCollideCallbacks.length||a.onCollideEvent)&&a._physicsEngine){var t=a._physicsEngine.getImpostorWithPhysicsBody(e.body);t&&(a.onCollideEvent&&a.onCollideEvent(a,t),a._onPhysicsCollideCallbacks.filter(function(e){return-1!==e.otherImpostors.indexOf(t)}).forEach(function(e){e.callback(a,t)}))}},this.object?(this.object.parent&&0!==i.mass&&n.a.Warn("A physics impostor has been created for an object which has a parent. Babylon physics currently works in local space so unexpected issues may occur."),!this._scene&&e.getScene&&(this._scene=e.getScene()),this._scene&&(this.type>100&&(this.soft=!0),this._physicsEngine=this._scene.getPhysicsEngine(),this._physicsEngine?(this.object.rotationQuaternion||(this.object.rotation?this.object.rotationQuaternion=o.b.RotationYawPitchRoll(this.object.rotation.y,this.object.rotation.x,this.object.rotation.z):this.object.rotationQuaternion=new o.b),this._options.mass=void 0===i.mass?0:i.mass,this._options.friction=void 0===i.friction?.2:i.friction,this._options.restitution=void 0===i.restitution?.2:i.restitution,this.soft&&(this._options.mass=this._options.mass>0?this._options.mass:1,this._options.pressure=void 0===i.pressure?200:i.pressure,this._options.stiffness=void 0===i.stiffness?1:i.stiffness,this._options.velocityIterations=void 0===i.velocityIterations?20:i.velocityIterations,this._options.positionIterations=void 0===i.positionIterations?20:i.positionIterations,this._options.fixedPoints=void 0===i.fixedPoints?0:i.fixedPoints,this._options.margin=void 0===i.margin?0:i.margin,this._options.damping=void 0===i.damping?0:i.damping,this._options.path=void 0===i.path?null:i.path,this._options.shape=void 0===i.shape?null:i.shape),this._joints=[],!this.object.parent||this._options.ignoreParent?this._init():this.object.parent.physicsImpostor&&n.a.Warn("You must affect impostors to children before affecting impostor to parent.")):n.a.Error("Physics not enabled. Please use scene.enablePhysics(...) before creating impostors."))):n.a.Error("No object was provided. A physics object is obligatory")}return Object.defineProperty(e.prototype,"isDisposed",{get:function(){return this._isDisposed},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"mass",{get:function(){return this._physicsEngine?this._physicsEngine.getPhysicsPlugin().getBodyMass(this):0},set:function(e){this.setMass(e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"friction",{get:function(){return this._physicsEngine?this._physicsEngine.getPhysicsPlugin().getBodyFriction(this):0},set:function(e){this._physicsEngine&&this._physicsEngine.getPhysicsPlugin().setBodyFriction(this,e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"restitution",{get:function(){return this._physicsEngine?this._physicsEngine.getPhysicsPlugin().getBodyRestitution(this):0},set:function(e){this._physicsEngine&&this._physicsEngine.getPhysicsPlugin().setBodyRestitution(this,e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"pressure",{get:function(){if(!this._physicsEngine)return 0;var e=this._physicsEngine.getPhysicsPlugin();return e.setBodyPressure?e.getBodyPressure(this):0},set:function(e){if(this._physicsEngine){var t=this._physicsEngine.getPhysicsPlugin();t.setBodyPressure&&t.setBodyPressure(this,e)}},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"stiffness",{get:function(){if(!this._physicsEngine)return 0;var e=this._physicsEngine.getPhysicsPlugin();return e.getBodyStiffness?e.getBodyStiffness(this):0},set:function(e){if(this._physicsEngine){var t=this._physicsEngine.getPhysicsPlugin();t.setBodyStiffness&&t.setBodyStiffness(this,e)}},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"velocityIterations",{get:function(){if(!this._physicsEngine)return 0;var e=this._physicsEngine.getPhysicsPlugin();return e.getBodyVelocityIterations?e.getBodyVelocityIterations(this):0},set:function(e){if(this._physicsEngine){var t=this._physicsEngine.getPhysicsPlugin();t.setBodyVelocityIterations&&t.setBodyVelocityIterations(this,e)}},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"positionIterations",{get:function(){if(!this._physicsEngine)return 0;var e=this._physicsEngine.getPhysicsPlugin();return e.getBodyPositionIterations?e.getBodyPositionIterations(this):0},set:function(e){if(this._physicsEngine){var t=this._physicsEngine.getPhysicsPlugin();t.setBodyPositionIterations&&t.setBodyPositionIterations(this,e)}},enumerable:!0,configurable:!0}),e.prototype._init=function(){this._physicsEngine&&(this._physicsEngine.removeImpostor(this),this.physicsBody=null,this._parent=this._parent||this._getPhysicsParent(),this._isDisposed||this.parent&&!this._options.ignoreParent||this._physicsEngine.addImpostor(this))},e.prototype._getPhysicsParent=function(){return this.object.parent instanceof a.a?this.object.parent.physicsImpostor:null},e.prototype.isBodyInitRequired=function(){return this._bodyUpdateRequired||!this._physicsBody&&!this._parent},e.prototype.setScalingUpdated=function(){this.forceUpdate()},e.prototype.forceUpdate=function(){this._init(),this.parent&&!this._options.ignoreParent&&this.parent.forceUpdate()},Object.defineProperty(e.prototype,"physicsBody",{get:function(){return this._parent&&!this._options.ignoreParent?this._parent.physicsBody:this._physicsBody},set:function(e){this._physicsBody&&this._physicsEngine&&this._physicsEngine.getPhysicsPlugin().removePhysicsBody(this),this._physicsBody=e,this.resetUpdateFlags()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"parent",{get:function(){return!this._options.ignoreParent&&this._parent?this._parent:null},set:function(e){this._parent=e},enumerable:!0,configurable:!0}),e.prototype.resetUpdateFlags=function(){this._bodyUpdateRequired=!1},e.prototype.getObjectExtendSize=function(){if(this.object.getBoundingInfo){var t=this.object.rotationQuaternion;this.object.rotationQuaternion=e.IDENTITY_QUATERNION,this.object.computeWorldMatrix&&this.object.computeWorldMatrix(!0);var i=this.object.getBoundingInfo().boundingBox.extendSizeWorld.scale(2);return this.object.rotationQuaternion=t,this.object.computeWorldMatrix&&this.object.computeWorldMatrix(!0),i}return e.DEFAULT_OBJECT_SIZE},e.prototype.getObjectCenter=function(){return this.object.getBoundingInfo?this.object.getBoundingInfo().boundingBox.centerWorld:this.object.position},e.prototype.getParam=function(e){return this._options[e]},e.prototype.setParam=function(e,t){this._options[e]=t,this._bodyUpdateRequired=!0},e.prototype.setMass=function(e){this.getParam("mass")!==e&&this.setParam("mass",e),this._physicsEngine&&this._physicsEngine.getPhysicsPlugin().setBodyMass(this,e)},e.prototype.getLinearVelocity=function(){return this._physicsEngine?this._physicsEngine.getPhysicsPlugin().getLinearVelocity(this):o.e.Zero()},e.prototype.setLinearVelocity=function(e){this._physicsEngine&&this._physicsEngine.getPhysicsPlugin().setLinearVelocity(this,e)},e.prototype.getAngularVelocity=function(){return this._physicsEngine?this._physicsEngine.getPhysicsPlugin().getAngularVelocity(this):o.e.Zero()},e.prototype.setAngularVelocity=function(e){this._physicsEngine&&this._physicsEngine.getPhysicsPlugin().setAngularVelocity(this,e)},e.prototype.executeNativeFunction=function(e){this._physicsEngine&&e(this._physicsEngine.getPhysicsPlugin().world,this.physicsBody)},e.prototype.registerBeforePhysicsStep=function(e){this._onBeforePhysicsStepCallbacks.push(e)},e.prototype.unregisterBeforePhysicsStep=function(e){var t=this._onBeforePhysicsStepCallbacks.indexOf(e);t>-1?this._onBeforePhysicsStepCallbacks.splice(t,1):n.a.Warn("Function to remove was not found")},e.prototype.registerAfterPhysicsStep=function(e){this._onAfterPhysicsStepCallbacks.push(e)},e.prototype.unregisterAfterPhysicsStep=function(e){var t=this._onAfterPhysicsStepCallbacks.indexOf(e);t>-1?this._onAfterPhysicsStepCallbacks.splice(t,1):n.a.Warn("Function to remove was not found")},e.prototype.registerOnPhysicsCollide=function(e,t){var i=e instanceof Array?e:[e];this._onPhysicsCollideCallbacks.push({callback:t,otherImpostors:i})},e.prototype.unregisterOnPhysicsCollide=function(e,t){var i=e instanceof Array?e:[e],r=-1;this._onPhysicsCollideCallbacks.some(function(e,n){if(e.callback===t&&e.otherImpostors.length===i.length){var o=e.otherImpostors.every(function(e){return i.indexOf(e)>-1});return o&&(r=n),o}return!1})?this._onPhysicsCollideCallbacks.splice(r,1):n.a.Warn("Function to remove was not found")},e.prototype.getParentsRotation=function(){var e=this.object.parent;for(this._tmpQuat.copyFromFloats(0,0,0,1);e;)e.rotationQuaternion?this._tmpQuat2.copyFrom(e.rotationQuaternion):o.b.RotationYawPitchRollToRef(e.rotation.y,e.rotation.x,e.rotation.z,this._tmpQuat2),this._tmpQuat.multiplyToRef(this._tmpQuat2,this._tmpQuat),e=e.parent;return this._tmpQuat},e.prototype.applyForce=function(e,t){return this._physicsEngine&&this._physicsEngine.getPhysicsPlugin().applyForce(this,e,t),this},e.prototype.applyImpulse=function(e,t){return this._physicsEngine&&this._physicsEngine.getPhysicsPlugin().applyImpulse(this,e,t),this},e.prototype.createJoint=function(e,t,i){var n=new c.e(t,i);return this.addJoint(e,n),this},e.prototype.addJoint=function(e,t){return this._joints.push({otherImpostor:e,joint:t}),this._physicsEngine&&this._physicsEngine.addJoint(this,e,t),this},e.prototype.addAnchor=function(e,t,i,n,r){if(!this._physicsEngine)return this;var o=this._physicsEngine.getPhysicsPlugin();return o.appendAnchor?(this._physicsEngine&&o.appendAnchor(this,e,t,i,n,r),this):this},e.prototype.addHook=function(e,t,i,n){if(!this._physicsEngine)return this;var r=this._physicsEngine.getPhysicsPlugin();return r.appendAnchor?(this._physicsEngine&&r.appendHook(this,e,t,i,n),this):this},e.prototype.sleep=function(){return this._physicsEngine&&this._physicsEngine.getPhysicsPlugin().sleepBody(this),this},e.prototype.wakeUp=function(){return this._physicsEngine&&this._physicsEngine.getPhysicsPlugin().wakeUpBody(this),this},e.prototype.clone=function(t){return t?new e(t,this.type,this._options,this._scene):null},e.prototype.dispose=function(){var e=this;this._physicsEngine&&(this._joints.forEach(function(t){e._physicsEngine&&e._physicsEngine.removeJoint(e,t.otherImpostor,t.joint)}),this._physicsEngine.removeImpostor(this),this.parent&&this.parent.forceUpdate(),this._isDisposed=!0)},e.prototype.setDeltaPosition=function(e){this._deltaPosition.copyFrom(e)},e.prototype.setDeltaRotation=function(e){this._deltaRotation||(this._deltaRotation=new o.b),this._deltaRotation.copyFrom(e),this._deltaRotationConjugated=this._deltaRotation.conjugate()},e.prototype.getBoxSizeToRef=function(e){return this._physicsEngine&&this._physicsEngine.getPhysicsPlugin().getBoxSizeToRef(this,e),this},e.prototype.getRadius=function(){return this._physicsEngine?this._physicsEngine.getPhysicsPlugin().getRadius(this):0},e.prototype.syncBoneWithImpostor=function(t,i,n,r,o){var a=e._tmpVecs[0],s=this.object;if(s.rotationQuaternion)if(o){var c=e._tmpQuat;s.rotationQuaternion.multiplyToRef(o,c),t.setRotationQuaternion(c,l.b.WORLD,i)}else t.setRotationQuaternion(s.rotationQuaternion,l.b.WORLD,i);a.x=0,a.y=0,a.z=0,n&&(a.x=n.x,a.y=n.y,a.z=n.z,t.getDirectionToRef(a,i,a),null==r&&(r=n.length()),a.x*=r,a.y*=r,a.z*=r),t.getParent()?(a.addInPlace(s.getAbsolutePosition()),t.setAbsolutePosition(a,i)):(i.setAbsolutePosition(s.getAbsolutePosition()),i.position.x-=a.x,i.position.y-=a.y,i.position.z-=a.z)},e.prototype.syncImpostorWithBone=function(t,i,n,r,o,a){var s=this.object;if(s.rotationQuaternion)if(o){var c=e._tmpQuat;t.getRotationQuaternionToRef(l.b.WORLD,i,c),c.multiplyToRef(o,s.rotationQuaternion)}else t.getRotationQuaternionToRef(l.b.WORLD,i,s.rotationQuaternion);var u=e._tmpVecs[0],h=e._tmpVecs[1];a||((a=e._tmpVecs[2]).x=0,a.y=1,a.z=0),t.getDirectionToRef(a,i,h),t.getAbsolutePositionToRef(i,u),null==r&&n&&(r=n.length()),null!=r&&(u.x+=h.x*r,u.y+=h.y*r,u.z+=h.z*r),s.setAbsolutePosition(u)},e.DEFAULT_OBJECT_SIZE=new o.e(1,1,1),e.IDENTITY_QUATERNION=o.b.Identity(),e._tmpVecs=r.a.BuildArray(3,o.e.Zero),e._tmpQuat=o.b.Identity(),e.NoImpostor=0,e.SphereImpostor=1,e.BoxImpostor=2,e.PlaneImpostor=3,e.MeshImpostor=4,e.CapsuleImpostor=6,e.CylinderImpostor=7,e.ParticleImpostor=8,e.HeightmapImpostor=9,e.ConvexHullImpostor=10,e.CustomImpostor=100,e.RopeImpostor=101,e.ClothImpostor=102,e.SoftbodyImpostor=103,e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return y});var n=i(23),r=i(8),o=i(19),a=i(6),s=i(127),c=i(128),l=i(129),u=i(2),h=i(25),d=i(7),f=i(38),p=i(109),_=i(84),m=i(130),g=i(70),v=function(){},y=function(){function e(t,i,n,r){var o=this;void 0===r&&(r=!1),this.forcePOTTextures=!1,this.isFullscreen=!1,this.cullBackFaces=!0,this.renderEvenInBackground=!0,this.preventCacheWipeBetweenFrames=!1,this.validateShaderPrograms=!1,this.useReverseDepthBuffer=!1,this.disableUniformBuffers=!1,this._uniformBuffers=new Array,this._webGLVersion=1,this._windowIsBackground=!1,this._highPrecisionShadersAllowed=!0,this._badOS=!1,this._badDesktopOS=!1,this._renderingQueueLaunched=!1,this._activeRenderLoops=new Array,this.onContextLostObservable=new a.c,this.onContextRestoredObservable=new a.c,this._contextWasLost=!1,this._doNotHandleContextLost=!1,this.disableVertexArrayObjects=!1,this._colorWrite=!0,this._colorWriteChanged=!0,this._depthCullingState=new s.a,this._stencilState=new c.a,this._alphaState=new l.a,this._alphaMode=u.a.ALPHA_ADD,this._alphaEquation=u.a.ALPHA_DISABLE,this._internalTexturesCache=new Array,this._activeChannel=0,this._currentTextureChannel=-1,this._boundTexturesCache={},this._compiledEffects={},this._vertexAttribArraysEnabled=[],this._uintIndicesCurrentlySet=!1,this._currentBoundBuffer=new Array,this._currentFramebuffer=null,this._currentBufferPointers=new Array,this._currentInstanceLocations=new Array,this._currentInstanceBuffers=new Array,this._vaoRecordInProgress=!1,this._mustWipeVertexAttributes=!1,this._nextFreeTextureSlots=new Array,this._maxSimultaneousTextures=0,this._activeRequests=new Array,this._texturesSupported=new Array,this.premultipliedAlpha=!0,this.onBeforeTextureInitObservable=new a.c,this._viewportCached={x:0,y:0,z:0,w:0},this._unpackFlipYCached=null,this.enableUnpackFlipYCached=!0,this._getDepthStencilBuffer=function(e,t,i,n,r,a){var s=o._gl,c=s.createRenderbuffer();return s.bindRenderbuffer(s.RENDERBUFFER,c),i>1&&s.renderbufferStorageMultisample?s.renderbufferStorageMultisample(s.RENDERBUFFER,i,r,e,t):s.renderbufferStorage(s.RENDERBUFFER,n,e,t),s.framebufferRenderbuffer(s.FRAMEBUFFER,a,s.RENDERBUFFER,c),s.bindRenderbuffer(s.RENDERBUFFER,null),c},this._boundUniforms={};var h=null;if(t){if(n=n||{},t.getContext){if(h=t,this._renderingCanvas=h,null!=i&&(n.antialias=i),void 0===n.deterministicLockstep&&(n.deterministicLockstep=!1),void 0===n.lockstepMaxSteps&&(n.lockstepMaxSteps=4),void 0===n.timeStep&&(n.timeStep=1/60),void 0===n.preserveDrawingBuffer&&(n.preserveDrawingBuffer=!1),void 0===n.audioEngine&&(n.audioEngine=!0),void 0===n.stencil&&(n.stencil=!0),!1===n.premultipliedAlpha&&(this.premultipliedAlpha=!1),this._doNotHandleContextLost=!!n.doNotHandleContextLost,navigator&&navigator.userAgent)for(var _=navigator.userAgent,m=0,g=e.ExceptionList;m<g.length;m++){var y=g[m],b=y.key,T=y.targets;if(new RegExp(b).test(_)){if(y.capture&&y.captureConstraint){var E=y.capture,x=y.captureConstraint,P=new RegExp(E).exec(_);if(P&&P.length>0)if(parseInt(P[P.length-1])>=x)continue}for(var A=0,S=T;A<S.length;A++){switch(S[A]){case"uniformBuffer":this.disableUniformBuffers=!0;break;case"vao":this.disableVertexArrayObjects=!0}}}}if(this._doNotHandleContextLost||(this._onContextLost=function(e){e.preventDefault(),o._contextWasLost=!0,d.a.Warn("WebGL context lost."),o.onContextLostObservable.notifyObservers(o)},this._onContextRestored=function(){setTimeout(function(){o._initGLContext(),o._rebuildEffects(),o._rebuildInternalTextures(),o._rebuildBuffers(),o.wipeCaches(!0),d.a.Warn("WebGL context successfully restored."),o.onContextRestoredObservable.notifyObservers(o),o._contextWasLost=!1},0)},h.addEventListener("webglcontextlost",this._onContextLost,!1),h.addEventListener("webglcontextrestored",this._onContextRestored,!1),n.powerPreference="high-performance"),!n.disableWebGL2Support)try{this._gl=h.getContext("webgl2",n)||h.getContext("experimental-webgl2",n),this._gl&&(this._webGLVersion=2,this._gl.deleteQuery||(this._webGLVersion=1))}catch(e){}if(!this._gl){if(!h)throw new Error("The provided canvas is null or undefined.");try{this._gl=h.getContext("webgl",n)||h.getContext("experimental-webgl",n)}catch(e){throw new Error("WebGL not supported")}}if(!this._gl)throw new Error("WebGL not supported")}else{this._gl=t,this._renderingCanvas=this._gl.canvas,this._gl.renderbufferStorageMultisample&&(this._webGLVersion=2);var C=this._gl.getContextAttributes();C&&(n.stencil=C.stencil)}this._gl.pixelStorei(this._gl.UNPACK_COLORSPACE_CONVERSION_WEBGL,this._gl.NONE),void 0!==n.useHighPrecisionFloats&&(this._highPrecisionShadersAllowed=n.useHighPrecisionFloats);var R=f.a.IsWindowObjectExist()&&window.devicePixelRatio||1,O=n.limitDeviceRatio||R;this._hardwareScalingLevel=r?1/Math.min(O,R):1,this.resize(),this._isStencilEnable=!!n.stencil,this._initGLContext();for(var M=0;M<this._caps.maxVertexAttribs;M++)this._currentBufferPointers[M]=new v;this.webGLVersion>1&&(this._shaderProcessor=new p.a),this._badOS=/iPad/i.test(navigator.userAgent)||/iPhone/i.test(navigator.userAgent),this._badDesktopOS=/^((?!chrome|android).)*safari/i.test(navigator.userAgent),this._creationOptions=n,console.log("Babylon.js v"+e.Version+" - "+this.description)}}return Object.defineProperty(e,"NpmPackage",{get:function(){return"babylonjs@4.1.0"},enumerable:!0,configurable:!0}),Object.defineProperty(e,"Version",{get:function(){return"4.1.0"},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"description",{get:function(){var e="WebGL"+this.webGLVersion;return this._caps.parallelShaderCompile&&(e+=" - Parallel shader compilation"),e},enumerable:!0,configurable:!0}),Object.defineProperty(e,"ShadersRepository",{get:function(){return r.a.ShadersRepository},set:function(e){r.a.ShadersRepository=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"supportsUniformBuffers",{get:function(){return this.webGLVersion>1&&!this.disableUniformBuffers},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_shouldUseHighPrecisionShader",{get:function(){return!(!this._caps.highPrecisionShaderSupported||!this._highPrecisionShadersAllowed)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"needPOTTextures",{get:function(){return this._webGLVersion<2||this.forcePOTTextures},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"doNotHandleContextLost",{get:function(){return this._doNotHandleContextLost},set:function(e){this._doNotHandleContextLost=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_supportsHardwareTextureRescaling",{get:function(){return!1},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"framebufferDimensionsObject",{set:function(e){this._framebufferDimensionsObject=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"texturesSupported",{get:function(){return this._texturesSupported},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"textureFormatInUse",{get:function(){return this._textureFormatInUse},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"currentViewport",{get:function(){return this._cachedViewport},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"emptyTexture",{get:function(){return this._emptyTexture||(this._emptyTexture=this.createRawTexture(new Uint8Array(4),1,1,u.a.TEXTUREFORMAT_RGBA,!1,!1,u.a.TEXTURE_NEAREST_SAMPLINGMODE)),this._emptyTexture},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"emptyTexture3D",{get:function(){return this._emptyTexture3D||(this._emptyTexture3D=this.createRawTexture3D(new Uint8Array(4),1,1,1,u.a.TEXTUREFORMAT_RGBA,!1,!1,u.a.TEXTURE_NEAREST_SAMPLINGMODE)),this._emptyTexture3D},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"emptyTexture2DArray",{get:function(){return this._emptyTexture2DArray||(this._emptyTexture2DArray=this.createRawTexture2DArray(new Uint8Array(4),1,1,1,u.a.TEXTUREFORMAT_RGBA,!1,!1,u.a.TEXTURE_NEAREST_SAMPLINGMODE)),this._emptyTexture2DArray},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"emptyCubeTexture",{get:function(){if(!this._emptyCubeTexture){var e=new Uint8Array(4),t=[e,e,e,e,e,e];this._emptyCubeTexture=this.createRawCubeTexture(t,1,u.a.TEXTUREFORMAT_RGBA,u.a.TEXTURETYPE_UNSIGNED_INT,!1,!1,u.a.TEXTURE_NEAREST_SAMPLINGMODE)}return this._emptyCubeTexture},enumerable:!0,configurable:!0}),e.prototype._rebuildInternalTextures=function(){for(var e=0,t=this._internalTexturesCache.slice();e<t.length;e++){t[e]._rebuild()}},e.prototype._rebuildEffects=function(){for(var e in this._compiledEffects){this._compiledEffects[e]._prepareEffect()}r.a.ResetCache()},e.prototype.areAllEffectsReady=function(){for(var e in this._compiledEffects){if(!this._compiledEffects[e].isReady())return!1}return!0},e.prototype._rebuildBuffers=function(){for(var e=0,t=this._uniformBuffers;e<t.length;e++){t[e]._rebuild()}},e.prototype._initGLContext=function(){this._caps={maxTexturesImageUnits:this._gl.getParameter(this._gl.MAX_TEXTURE_IMAGE_UNITS),maxCombinedTexturesImageUnits:this._gl.getParameter(this._gl.MAX_COMBINED_TEXTURE_IMAGE_UNITS),maxVertexTextureImageUnits:this._gl.getParameter(this._gl.MAX_VERTEX_TEXTURE_IMAGE_UNITS),maxTextureSize:this._gl.getParameter(this._gl.MAX_TEXTURE_SIZE),maxSamples:this._webGLVersion>1?this._gl.getParameter(this._gl.MAX_SAMPLES):1,maxCubemapTextureSize:this._gl.getParameter(this._gl.MAX_CUBE_MAP_TEXTURE_SIZE),maxRenderTextureSize:this._gl.getParameter(this._gl.MAX_RENDERBUFFER_SIZE),maxVertexAttribs:this._gl.getParameter(this._gl.MAX_VERTEX_ATTRIBS),maxVaryingVectors:this._gl.getParameter(this._gl.MAX_VARYING_VECTORS),maxFragmentUniformVectors:this._gl.getParameter(this._gl.MAX_FRAGMENT_UNIFORM_VECTORS),maxVertexUniformVectors:this._gl.getParameter(this._gl.MAX_VERTEX_UNIFORM_VECTORS),parallelShaderCompile:this._gl.getExtension("KHR_parallel_shader_compile"),standardDerivatives:this._webGLVersion>1||null!==this._gl.getExtension("OES_standard_derivatives"),maxAnisotropy:1,astc:this._gl.getExtension("WEBGL_compressed_texture_astc")||this._gl.getExtension("WEBKIT_WEBGL_compressed_texture_astc"),s3tc:this._gl.getExtension("WEBGL_compressed_texture_s3tc")||this._gl.getExtension("WEBKIT_WEBGL_compressed_texture_s3tc"),pvrtc:this._gl.getExtension("WEBGL_compressed_texture_pvrtc")||this._gl.getExtension("WEBKIT_WEBGL_compressed_texture_pvrtc"),etc1:this._gl.getExtension("WEBGL_compressed_texture_etc1")||this._gl.getExtension("WEBKIT_WEBGL_compressed_texture_etc1"),etc2:this._gl.getExtension("WEBGL_compressed_texture_etc")||this._gl.getExtension("WEBKIT_WEBGL_compressed_texture_etc")||this._gl.getExtension("WEBGL_compressed_texture_es3_0"),textureAnisotropicFilterExtension:this._gl.getExtension("EXT_texture_filter_anisotropic")||this._gl.getExtension("WEBKIT_EXT_texture_filter_anisotropic")||this._gl.getExtension("MOZ_EXT_texture_filter_anisotropic"),uintIndices:this._webGLVersion>1||null!==this._gl.getExtension("OES_element_index_uint"),fragmentDepthSupported:this._webGLVersion>1||null!==this._gl.getExtension("EXT_frag_depth"),highPrecisionShaderSupported:!1,timerQuery:this._gl.getExtension("EXT_disjoint_timer_query_webgl2")||this._gl.getExtension("EXT_disjoint_timer_query"),canUseTimestampForTimerQuery:!1,drawBuffersExtension:!1,maxMSAASamples:1,colorBufferFloat:this._webGLVersion>1&&this._gl.getExtension("EXT_color_buffer_float"),textureFloat:!!(this._webGLVersion>1||this._gl.getExtension("OES_texture_float")),textureHalfFloat:!!(this._webGLVersion>1||this._gl.getExtension("OES_texture_half_float")),textureHalfFloatRender:!1,textureFloatLinearFiltering:!1,textureFloatRender:!1,textureHalfFloatLinearFiltering:!1,vertexArrayObject:!1,instancedArrays:!1,textureLOD:!!(this._webGLVersion>1||this._gl.getExtension("EXT_shader_texture_lod")),blendMinMax:!1,multiview:this._gl.getExtension("OVR_multiview2"),oculusMultiview:this._gl.getExtension("OCULUS_multiview"),depthTextureExtension:!1},this._glVersion=this._gl.getParameter(this._gl.VERSION);var e=this._gl.getExtension("WEBGL_debug_renderer_info");if(null!=e&&(this._glRenderer=this._gl.getParameter(e.UNMASKED_RENDERER_WEBGL),this._glVendor=this._gl.getParameter(e.UNMASKED_VENDOR_WEBGL)),this._glVendor||(this._glVendor="Unknown vendor"),this._glRenderer||(this._glRenderer="Unknown renderer"),this._gl.HALF_FLOAT_OES=36193,34842!==this._gl.RGBA16F&&(this._gl.RGBA16F=34842),34836!==this._gl.RGBA32F&&(this._gl.RGBA32F=34836),35056!==this._gl.DEPTH24_STENCIL8&&(this._gl.DEPTH24_STENCIL8=35056),this._caps.timerQuery&&(1===this._webGLVersion&&(this._gl.getQuery=this._caps.timerQuery.getQueryEXT.bind(this._caps.timerQuery)),this._caps.canUseTimestampForTimerQuery=this._gl.getQuery(this._caps.timerQuery.TIMESTAMP_EXT,this._caps.timerQuery.QUERY_COUNTER_BITS_EXT)>0),this._caps.maxAnisotropy=this._caps.textureAnisotropicFilterExtension?this._gl.getParameter(this._caps.textureAnisotropicFilterExtension.MAX_TEXTURE_MAX_ANISOTROPY_EXT):0,this._caps.textureFloatLinearFiltering=!(!this._caps.textureFloat||!this._gl.getExtension("OES_texture_float_linear")),this._caps.textureFloatRender=!(!this._caps.textureFloat||!this._canRenderToFloatFramebuffer()),this._caps.textureHalfFloatLinearFiltering=!!(this._webGLVersion>1||this._caps.textureHalfFloat&&this._gl.getExtension("OES_texture_half_float_linear")),this._webGLVersion>1&&(this._gl.HALF_FLOAT_OES=5131),this._caps.textureHalfFloatRender=this._caps.textureHalfFloat&&this._canRenderToHalfFloatFramebuffer(),this._webGLVersion>1)this._caps.drawBuffersExtension=!0,this._caps.maxMSAASamples=this._gl.getParameter(this._gl.MAX_SAMPLES);else{var t=this._gl.getExtension("WEBGL_draw_buffers");if(null!==t){this._caps.drawBuffersExtension=!0,this._gl.drawBuffers=t.drawBuffersWEBGL.bind(t),this._gl.DRAW_FRAMEBUFFER=this._gl.FRAMEBUFFER;for(var i=0;i<16;i++)this._gl["COLOR_ATTACHMENT"+i+"_WEBGL"]=t["COLOR_ATTACHMENT"+i+"_WEBGL"]}}if(this._webGLVersion>1)this._caps.depthTextureExtension=!0;else{var n=this._gl.getExtension("WEBGL_depth_texture");null!=n&&(this._caps.depthTextureExtension=!0,this._gl.UNSIGNED_INT_24_8=n.UNSIGNED_INT_24_8_WEBGL)}if(this.disableVertexArrayObjects)this._caps.vertexArrayObject=!1;else if(this._webGLVersion>1)this._caps.vertexArrayObject=!0;else{var r=this._gl.getExtension("OES_vertex_array_object");null!=r&&(this._caps.vertexArrayObject=!0,this._gl.createVertexArray=r.createVertexArrayOES.bind(r),this._gl.bindVertexArray=r.bindVertexArrayOES.bind(r),this._gl.deleteVertexArray=r.deleteVertexArrayOES.bind(r))}if(this._webGLVersion>1)this._caps.instancedArrays=!0;else{var o=this._gl.getExtension("ANGLE_instanced_arrays");null!=o?(this._caps.instancedArrays=!0,this._gl.drawArraysInstanced=o.drawArraysInstancedANGLE.bind(o),this._gl.drawElementsInstanced=o.drawElementsInstancedANGLE.bind(o),this._gl.vertexAttribDivisor=o.vertexAttribDivisorANGLE.bind(o)):this._caps.instancedArrays=!1}if(this._caps.astc&&this.texturesSupported.push("-astc.ktx"),this._caps.s3tc&&this.texturesSupported.push("-dxt.ktx"),this._caps.pvrtc&&this.texturesSupported.push("-pvrtc.ktx"),this._caps.etc2&&this.texturesSupported.push("-etc2.ktx"),this._caps.etc1&&this.texturesSupported.push("-etc1.ktx"),this._gl.getShaderPrecisionFormat){var a=this._gl.getShaderPrecisionFormat(this._gl.VERTEX_SHADER,this._gl.HIGH_FLOAT),s=this._gl.getShaderPrecisionFormat(this._gl.FRAGMENT_SHADER,this._gl.HIGH_FLOAT);a&&s&&(this._caps.highPrecisionShaderSupported=0!==a.precision&&0!==s.precision)}if(this._webGLVersion>1)this._caps.blendMinMax=!0;else{var c=this._gl.getExtension("EXT_blend_minmax");null!=c&&(this._caps.blendMinMax=!0,this._gl.MAX=c.MAX_EXT,this._gl.MIN=c.MIN_EXT)}this._depthCullingState.depthTest=!0,this._depthCullingState.depthFunc=this._gl.LEQUAL,this._depthCullingState.depthMask=!0,this._maxSimultaneousTextures=this._caps.maxCombinedTexturesImageUnits;for(var l=0;l<this._maxSimultaneousTextures;l++)this._nextFreeTextureSlots.push(l)},Object.defineProperty(e.prototype,"webGLVersion",{get:function(){return this._webGLVersion},enumerable:!0,configurable:!0}),e.prototype.getClassName=function(){return"ThinEngine"},Object.defineProperty(e.prototype,"isStencilEnable",{get:function(){return this._isStencilEnable},enumerable:!0,configurable:!0}),e.prototype._prepareWorkingCanvas=function(){if(!this._workingCanvas){this._workingCanvas=g.a.CreateCanvas(1,1);var e=this._workingCanvas.getContext("2d");e&&(this._workingContext=e)}},e.prototype.resetTextureCache=function(){for(var e in this._boundTexturesCache)this._boundTexturesCache.hasOwnProperty(e)&&(this._boundTexturesCache[e]=null);this._currentTextureChannel=-1},e.prototype.getGlInfo=function(){return{vendor:this._glVendor,renderer:this._glRenderer,version:this._glVersion}},e.prototype.setHardwareScalingLevel=function(e){this._hardwareScalingLevel=e,this.resize()},e.prototype.getHardwareScalingLevel=function(){return this._hardwareScalingLevel},e.prototype.getLoadedTexturesCache=function(){return this._internalTexturesCache},e.prototype.getCaps=function(){return this._caps},e.prototype.stopRenderLoop=function(e){if(e){var t=this._activeRenderLoops.indexOf(e);t>=0&&this._activeRenderLoops.splice(t,1)}else this._activeRenderLoops=[]},e.prototype._renderLoop=function(){if(!this._contextWasLost){var e=!0;if(!this.renderEvenInBackground&&this._windowIsBackground&&(e=!1),e){this.beginFrame();for(var t=0;t<this._activeRenderLoops.length;t++){(0,this._activeRenderLoops[t])()}this.endFrame()}}this._activeRenderLoops.length>0?this._frameHandler=this._queueNewFrame(this._boundRenderFunction,this.getHostWindow()):this._renderingQueueLaunched=!1},e.prototype.getRenderingCanvas=function(){return this._renderingCanvas},e.prototype.getHostWindow=function(){return f.a.IsWindowObjectExist()?this._renderingCanvas&&this._renderingCanvas.ownerDocument&&this._renderingCanvas.ownerDocument.defaultView?this._renderingCanvas.ownerDocument.defaultView:window:null},e.prototype.getRenderWidth=function(e){return void 0===e&&(e=!1),!e&&this._currentRenderTarget?this._currentRenderTarget.width:this._framebufferDimensionsObject?this._framebufferDimensionsObject.framebufferWidth:this._gl.drawingBufferWidth},e.prototype.getRenderHeight=function(e){return void 0===e&&(e=!1),!e&&this._currentRenderTarget?this._currentRenderTarget.height:this._framebufferDimensionsObject?this._framebufferDimensionsObject.framebufferHeight:this._gl.drawingBufferHeight},e.prototype._queueNewFrame=function(t,i){return e.QueueNewFrame(t,i)},e.prototype.runRenderLoop=function(e){-1===this._activeRenderLoops.indexOf(e)&&(this._activeRenderLoops.push(e),this._renderingQueueLaunched||(this._renderingQueueLaunched=!0,this._boundRenderFunction=this._renderLoop.bind(this),this._frameHandler=this._queueNewFrame(this._boundRenderFunction,this.getHostWindow())))},e.prototype.clear=function(e,t,i,n){void 0===n&&(n=!1),this.applyStates();var r=0;t&&e&&(this._gl.clearColor(e.r,e.g,e.b,void 0!==e.a?e.a:1),r|=this._gl.COLOR_BUFFER_BIT),i&&(this.useReverseDepthBuffer?(this._depthCullingState.depthFunc=this._gl.GREATER,this._gl.clearDepth(0)):this._gl.clearDepth(1),r|=this._gl.DEPTH_BUFFER_BIT),n&&(this._gl.clearStencil(0),r|=this._gl.STENCIL_BUFFER_BIT),this._gl.clear(r)},e.prototype._viewport=function(e,t,i,n){e===this._viewportCached.x&&t===this._viewportCached.y&&i===this._viewportCached.z&&n===this._viewportCached.w||(this._viewportCached.x=e,this._viewportCached.y=t,this._viewportCached.z=i,this._viewportCached.w=n,this._gl.viewport(e,t,i,n))},e.prototype.setViewport=function(e,t,i){var n=t||this.getRenderWidth(),r=i||this.getRenderHeight(),o=e.x||0,a=e.y||0;this._cachedViewport=e,this._viewport(o*n,a*r,n*e.width,r*e.height)},e.prototype.beginFrame=function(){},e.prototype.endFrame=function(){this._badOS&&this.flushFramebuffer()},e.prototype.resize=function(){var e,t;f.a.IsWindowObjectExist()?(e=this._renderingCanvas?this._renderingCanvas.clientWidth:window.innerWidth,t=this._renderingCanvas?this._renderingCanvas.clientHeight:window.innerHeight):(e=this._renderingCanvas?this._renderingCanvas.width:100,t=this._renderingCanvas?this._renderingCanvas.height:100),this.setSize(e/this._hardwareScalingLevel,t/this._hardwareScalingLevel)},e.prototype.setSize=function(e,t){this._renderingCanvas&&(e|=0,t|=0,this._renderingCanvas.width===e&&this._renderingCanvas.height===t||(this._renderingCanvas.width=e,this._renderingCanvas.height=t))},e.prototype.bindFramebuffer=function(e,t,i,n,r,o,a){void 0===t&&(t=0),void 0===o&&(o=0),void 0===a&&(a=0),this._currentRenderTarget&&this.unBindFramebuffer(this._currentRenderTarget),this._currentRenderTarget=e,this._bindUnboundFramebuffer(e._MSAAFramebuffer?e._MSAAFramebuffer:e._framebuffer);var s=this._gl;e.is2DArray?s.framebufferTextureLayer(s.FRAMEBUFFER,s.COLOR_ATTACHMENT0,e._webGLTexture,o,a):e.isCube&&s.framebufferTexture2D(s.FRAMEBUFFER,s.COLOR_ATTACHMENT0,s.TEXTURE_CUBE_MAP_POSITIVE_X+t,e._webGLTexture,o);var c=e._depthStencilTexture;if(c){var l=c._generateStencilBuffer?s.DEPTH_STENCIL_ATTACHMENT:s.DEPTH_ATTACHMENT;e.is2DArray?s.framebufferTextureLayer(s.FRAMEBUFFER,l,c._webGLTexture,o,a):e.isCube?s.framebufferTexture2D(s.FRAMEBUFFER,l,s.TEXTURE_CUBE_MAP_POSITIVE_X+t,c._webGLTexture,o):s.framebufferTexture2D(s.FRAMEBUFFER,l,s.TEXTURE_2D,c._webGLTexture,o)}this._cachedViewport&&!r?this.setViewport(this._cachedViewport,i,n):(i||(i=e.width,o&&(i/=Math.pow(2,o))),n||(n=e.height,o&&(n/=Math.pow(2,o))),this._viewport(0,0,i,n)),this.wipeCaches()},e.prototype._bindUnboundFramebuffer=function(e){this._currentFramebuffer!==e&&(this._gl.bindFramebuffer(this._gl.FRAMEBUFFER,e),this._currentFramebuffer=e)},e.prototype.unBindFramebuffer=function(e,t,i){void 0===t&&(t=!1),this._currentRenderTarget=null;var n=this._gl;e._MSAAFramebuffer&&(n.bindFramebuffer(n.READ_FRAMEBUFFER,e._MSAAFramebuffer),n.bindFramebuffer(n.DRAW_FRAMEBUFFER,e._framebuffer),n.blitFramebuffer(0,0,e.width,e.height,0,0,e.width,e.height,n.COLOR_BUFFER_BIT,n.NEAREST)),!e.generateMipMaps||t||e.isCube||(this._bindTextureDirectly(n.TEXTURE_2D,e,!0),n.generateMipmap(n.TEXTURE_2D),this._bindTextureDirectly(n.TEXTURE_2D,null)),i&&(e._MSAAFramebuffer&&this._bindUnboundFramebuffer(e._framebuffer),i()),this._bindUnboundFramebuffer(null)},e.prototype.flushFramebuffer=function(){this._gl.flush()},e.prototype.restoreDefaultFramebuffer=function(){this._currentRenderTarget?this.unBindFramebuffer(this._currentRenderTarget):this._bindUnboundFramebuffer(null),this._cachedViewport&&this.setViewport(this._cachedViewport),this.wipeCaches()},e.prototype._resetVertexBufferBinding=function(){this.bindArrayBuffer(null),this._cachedVertexBuffers=null},e.prototype.createVertexBuffer=function(e){return this._createVertexBuffer(e,this._gl.STATIC_DRAW)},e.prototype._createVertexBuffer=function(e,t){var i=this._gl.createBuffer();if(!i)throw new Error("Unable to create vertex buffer");var n=new _.a(i);return this.bindArrayBuffer(n),e instanceof Array?this._gl.bufferData(this._gl.ARRAY_BUFFER,new Float32Array(e),this._gl.STATIC_DRAW):this._gl.bufferData(this._gl.ARRAY_BUFFER,e,this._gl.STATIC_DRAW),this._resetVertexBufferBinding(),n.references=1,n},e.prototype.createDynamicVertexBuffer=function(e){return this._createVertexBuffer(e,this._gl.DYNAMIC_DRAW)},e.prototype._resetIndexBufferBinding=function(){this.bindIndexBuffer(null),this._cachedIndexBuffer=null},e.prototype.createIndexBuffer=function(e,t){var i=this._gl.createBuffer(),n=new _.a(i);if(!i)throw new Error("Unable to create index buffer");this.bindIndexBuffer(n);var r=this._normalizeIndexData(e);return this._gl.bufferData(this._gl.ELEMENT_ARRAY_BUFFER,r,t?this._gl.DYNAMIC_DRAW:this._gl.STATIC_DRAW),this._resetIndexBufferBinding(),n.references=1,n.is32Bits=4===r.BYTES_PER_ELEMENT,n},e.prototype._normalizeIndexData=function(e){if(e instanceof Uint16Array)return e;if(this._caps.uintIndices){if(e instanceof Uint32Array)return e;for(var t=0;t<e.length;t++)if(e[t]>=65535)return new Uint32Array(e);return new Uint16Array(e)}return new Uint16Array(e)},e.prototype.bindArrayBuffer=function(e){this._vaoRecordInProgress||this._unbindVertexArrayObject(),this.bindBuffer(e,this._gl.ARRAY_BUFFER)},e.prototype.bindUniformBlock=function(e,t,i){var n=e.program,r=this._gl.getUniformBlockIndex(n,t);this._gl.uniformBlockBinding(n,r,i)},e.prototype.bindIndexBuffer=function(e){this._vaoRecordInProgress||this._unbindVertexArrayObject(),this.bindBuffer(e,this._gl.ELEMENT_ARRAY_BUFFER)},e.prototype.bindBuffer=function(e,t){(this._vaoRecordInProgress||this._currentBoundBuffer[t]!==e)&&(this._gl.bindBuffer(t,e?e.underlyingResource:null),this._currentBoundBuffer[t]=e)},e.prototype.updateArrayBuffer=function(e){this._gl.bufferSubData(this._gl.ARRAY_BUFFER,0,e)},e.prototype._vertexAttribPointer=function(e,t,i,n,r,o,a){var s=this._currentBufferPointers[t],c=!1;s.active?(s.buffer!==e&&(s.buffer=e,c=!0),s.size!==i&&(s.size=i,c=!0),s.type!==n&&(s.type=n,c=!0),s.normalized!==r&&(s.normalized=r,c=!0),s.stride!==o&&(s.stride=o,c=!0),s.offset!==a&&(s.offset=a,c=!0)):(c=!0,s.active=!0,s.index=t,s.size=i,s.type=n,s.normalized=r,s.stride=o,s.offset=a,s.buffer=e),(c||this._vaoRecordInProgress)&&(this.bindArrayBuffer(e),this._gl.vertexAttribPointer(t,i,n,r,o,a))},e.prototype._bindIndexBufferWithCache=function(e){null!=e&&this._cachedIndexBuffer!==e&&(this._cachedIndexBuffer=e,this.bindIndexBuffer(e),this._uintIndicesCurrentlySet=e.is32Bits)},e.prototype._bindVertexBuffersAttributes=function(e,t){var i=t.getAttributesNames();this._vaoRecordInProgress||this._unbindVertexArrayObject(),this.unbindAllAttributes();for(var n=0;n<i.length;n++){var r=t.getAttributeLocation(n);if(r>=0){var o=e[i[n]];if(!o)continue;this._gl.enableVertexAttribArray(r),this._vaoRecordInProgress||(this._vertexAttribArraysEnabled[r]=!0);var a=o.getBuffer();a&&(this._vertexAttribPointer(a,r,o.getSize(),o.type,o.normalized,o.byteStride,o.byteOffset),o.getIsInstanced()&&(this._gl.vertexAttribDivisor(r,o.getInstanceDivisor()),this._vaoRecordInProgress||(this._currentInstanceLocations.push(r),this._currentInstanceBuffers.push(a))))}}},e.prototype.recordVertexArrayObject=function(e,t,i){var n=this._gl.createVertexArray();return this._vaoRecordInProgress=!0,this._gl.bindVertexArray(n),this._mustWipeVertexAttributes=!0,this._bindVertexBuffersAttributes(e,i),this.bindIndexBuffer(t),this._vaoRecordInProgress=!1,this._gl.bindVertexArray(null),n},e.prototype.bindVertexArrayObject=function(e,t){this._cachedVertexArrayObject!==e&&(this._cachedVertexArrayObject=e,this._gl.bindVertexArray(e),this._cachedVertexBuffers=null,this._cachedIndexBuffer=null,this._uintIndicesCurrentlySet=null!=t&&t.is32Bits,this._mustWipeVertexAttributes=!0)},e.prototype.bindBuffersDirectly=function(e,t,i,n,r){if(this._cachedVertexBuffers!==e||this._cachedEffectForVertexBuffers!==r){this._cachedVertexBuffers=e,this._cachedEffectForVertexBuffers=r;var o=r.getAttributesCount();this._unbindVertexArrayObject(),this.unbindAllAttributes();for(var a=0,s=0;s<o;s++)if(s<i.length){var c=r.getAttributeLocation(s);c>=0&&(this._gl.enableVertexAttribArray(c),this._vertexAttribArraysEnabled[c]=!0,this._vertexAttribPointer(e,c,i[s],this._gl.FLOAT,!1,n,a)),a+=4*i[s]}}this._bindIndexBufferWithCache(t)},e.prototype._unbindVertexArrayObject=function(){this._cachedVertexArrayObject&&(this._cachedVertexArrayObject=null,this._gl.bindVertexArray(null))},e.prototype.bindBuffers=function(e,t,i){this._cachedVertexBuffers===e&&this._cachedEffectForVertexBuffers===i||(this._cachedVertexBuffers=e,this._cachedEffectForVertexBuffers=i,this._bindVertexBuffersAttributes(e,i)),this._bindIndexBufferWithCache(t)},e.prototype.unbindInstanceAttributes=function(){for(var e,t=0,i=this._currentInstanceLocations.length;t<i;t++){var n=this._currentInstanceBuffers[t];e!=n&&n.references&&(e=n,this.bindArrayBuffer(n));var r=this._currentInstanceLocations[t];this._gl.vertexAttribDivisor(r,0)}this._currentInstanceBuffers.length=0,this._currentInstanceLocations.length=0},e.prototype.releaseVertexArrayObject=function(e){this._gl.deleteVertexArray(e)},e.prototype._releaseBuffer=function(e){return e.references--,0===e.references&&(this._deleteBuffer(e),!0)},e.prototype._deleteBuffer=function(e){this._gl.deleteBuffer(e.underlyingResource)},e.prototype.updateAndBindInstancesBuffer=function(e,t,i){if(this.bindArrayBuffer(e),t&&this._gl.bufferSubData(this._gl.ARRAY_BUFFER,0,t),void 0!==i[0].index)this.bindInstancesBuffer(e,i,!0);else for(var n=0;n<4;n++){var r=i[n];this._vertexAttribArraysEnabled[r]||(this._gl.enableVertexAttribArray(r),this._vertexAttribArraysEnabled[r]=!0),this._vertexAttribPointer(e,r,4,this._gl.FLOAT,!1,64,16*n),this._gl.vertexAttribDivisor(r,1),this._currentInstanceLocations.push(r),this._currentInstanceBuffers.push(e)}},e.prototype.bindInstancesBuffer=function(e,t,i){void 0===i&&(i=!0),this.bindArrayBuffer(e);var n=0;if(i)for(var r=0;r<t.length;r++){n+=4*(o=t[r]).attributeSize}for(r=0;r<t.length;r++){var o;void 0===(o=t[r]).index&&(o.index=this._currentEffect.getAttributeLocationByName(o.attributeName)),this._vertexAttribArraysEnabled[o.index]||(this._gl.enableVertexAttribArray(o.index),this._vertexAttribArraysEnabled[o.index]=!0),this._vertexAttribPointer(e,o.index,o.attributeSize,o.attributeType||this._gl.FLOAT,o.normalized||!1,n,o.offset),this._gl.vertexAttribDivisor(o.index,void 0===o.divisor?1:o.divisor),this._currentInstanceLocations.push(o.index),this._currentInstanceBuffers.push(e)}},e.prototype.disableInstanceAttributeByName=function(e){if(this._currentEffect){var t=this._currentEffect.getAttributeLocationByName(e);this.disableInstanceAttribute(t)}},e.prototype.disableInstanceAttribute=function(e){for(var t,i=!1;-1!==(t=this._currentInstanceLocations.indexOf(e));)this._currentInstanceLocations.splice(t,1),this._currentInstanceBuffers.splice(t,1),i=!0,t=this._currentInstanceLocations.indexOf(e);i&&(this._gl.vertexAttribDivisor(e,0),this.disableAttributeByIndex(e))},e.prototype.disableAttributeByIndex=function(e){this._gl.disableVertexAttribArray(e),this._vertexAttribArraysEnabled[e]=!1,this._currentBufferPointers[e].active=!1},e.prototype.draw=function(e,t,i,n){this.drawElementsType(e?u.a.MATERIAL_TriangleFillMode:u.a.MATERIAL_WireFrameFillMode,t,i,n)},e.prototype.drawPointClouds=function(e,t,i){this.drawArraysType(u.a.MATERIAL_PointFillMode,e,t,i)},e.prototype.drawUnIndexed=function(e,t,i,n){this.drawArraysType(e?u.a.MATERIAL_TriangleFillMode:u.a.MATERIAL_WireFrameFillMode,t,i,n)},e.prototype.drawElementsType=function(e,t,i,n){this.applyStates(),this._reportDrawCall();var r=this._drawMode(e),o=this._uintIndicesCurrentlySet?this._gl.UNSIGNED_INT:this._gl.UNSIGNED_SHORT,a=this._uintIndicesCurrentlySet?4:2;n?this._gl.drawElementsInstanced(r,i,o,t*a,n):this._gl.drawElements(r,i,o,t*a)},e.prototype.drawArraysType=function(e,t,i,n){this.applyStates(),this._reportDrawCall();var r=this._drawMode(e);n?this._gl.drawArraysInstanced(r,t,i,n):this._gl.drawArrays(r,t,i)},e.prototype._drawMode=function(e){switch(e){case u.a.MATERIAL_TriangleFillMode:return this._gl.TRIANGLES;case u.a.MATERIAL_PointFillMode:return this._gl.POINTS;case u.a.MATERIAL_WireFrameFillMode:return this._gl.LINES;case u.a.MATERIAL_PointListDrawMode:return this._gl.POINTS;case u.a.MATERIAL_LineListDrawMode:return this._gl.LINES;case u.a.MATERIAL_LineLoopDrawMode:return this._gl.LINE_LOOP;case u.a.MATERIAL_LineStripDrawMode:return this._gl.LINE_STRIP;case u.a.MATERIAL_TriangleStripDrawMode:return this._gl.TRIANGLE_STRIP;case u.a.MATERIAL_TriangleFanDrawMode:return this._gl.TRIANGLE_FAN;default:return this._gl.TRIANGLES}},e.prototype._reportDrawCall=function(){},e.prototype._releaseEffect=function(e){this._compiledEffects[e._key]&&(delete this._compiledEffects[e._key],this._deletePipelineContext(e.getPipelineContext()))},e.prototype._deletePipelineContext=function(e){var t=e;t&&t.program&&(t.program.__SPECTOR_rebuildProgram=null,this._gl.deleteProgram(t.program))},e.prototype.createEffect=function(e,t,i,n,o,a,s,c,l){var u=(e.vertexElement||e.vertex||e)+"+"+(e.fragmentElement||e.fragment||e)+"@"+(o||t.defines);if(this._compiledEffects[u]){var h=this._compiledEffects[u];return s&&h.isReady()&&s(h),h}var d=new r.a(e,t,i,n,this,o,a,s,c,l);return d._key=u,this._compiledEffects[u]=d,d},e._ConcatenateShader=function(e,t,i){return void 0===i&&(i=""),i+(t?t+"\n":"")+e},e.prototype._compileShader=function(t,i,n,r){return this._compileRawShader(e._ConcatenateShader(t,n,r),i)},e.prototype._compileRawShader=function(e,t){var i=this._gl,n=i.createShader("vertex"===t?i.VERTEX_SHADER:i.FRAGMENT_SHADER);if(!n)throw new Error("Something went wrong while compile the shader.");return i.shaderSource(n,e),i.compileShader(n),n},e.prototype.createRawShaderProgram=function(e,t,i,n,r){void 0===r&&(r=null),n=n||this._gl;var o=this._compileRawShader(t,"vertex"),a=this._compileRawShader(i,"fragment");return this._createShaderProgram(e,o,a,n,r)},e.prototype.createShaderProgram=function(e,t,i,n,r,o){void 0===o&&(o=null),r=r||this._gl;var a=this._webGLVersion>1?"#version 300 es\n#define WEBGL2 \n":"",s=this._compileShader(t,"vertex",n,a),c=this._compileShader(i,"fragment",n,a);return this._createShaderProgram(e,s,c,r,o)},e.prototype.createPipelineContext=function(){var e=new m.a;return e.engine=this,this._caps.parallelShaderCompile&&(e.isParallelCompiled=!0),e},e.prototype._createShaderProgram=function(e,t,i,n,r){void 0===r&&(r=null);var o=n.createProgram();if(e.program=o,!o)throw new Error("Unable to create program");return n.attachShader(o,t),n.attachShader(o,i),n.linkProgram(o),e.context=n,e.vertexShader=t,e.fragmentShader=i,e.isParallelCompiled||this._finalizePipelineContext(e),o},e.prototype._finalizePipelineContext=function(e){var t=e.context,i=e.vertexShader,n=e.fragmentShader,r=e.program;if(!t.getProgramParameter(r,t.LINK_STATUS)){var o,a;if(!this._gl.getShaderParameter(i,this._gl.COMPILE_STATUS))if(o=this._gl.getShaderInfoLog(i))throw e.vertexCompilationError=o,new Error("VERTEX SHADER "+o);if(!this._gl.getShaderParameter(n,this._gl.COMPILE_STATUS))if(o=this._gl.getShaderInfoLog(n))throw e.fragmentCompilationError=o,new Error("FRAGMENT SHADER "+o);if(a=t.getProgramInfoLog(r))throw e.programLinkError=a,new Error(a)}if(this.validateShaderPrograms&&(t.validateProgram(r),!t.getProgramParameter(r,t.VALIDATE_STATUS)&&(a=t.getProgramInfoLog(r))))throw e.programValidationError=a,new Error(a);t.deleteShader(i),t.deleteShader(n),e.vertexShader=void 0,e.fragmentShader=void 0,e.onCompiled&&(e.onCompiled(),e.onCompiled=void 0)},e.prototype._preparePipelineContext=function(e,t,i,n,r,o,a){var s=e;s.program=n?this.createRawShaderProgram(s,t,i,void 0,a):this.createShaderProgram(s,t,i,o,void 0,a),s.program.__SPECTOR_rebuildProgram=r},e.prototype._isRenderingStateCompiled=function(e){var t=e;return!!this._gl.getProgramParameter(t.program,this._caps.parallelShaderCompile.COMPLETION_STATUS_KHR)&&(this._finalizePipelineContext(t),!0)},e.prototype._executeWhenRenderingStateIsCompiled=function(e,t){var i=e;if(i.isParallelCompiled){var n=i.onCompiled;i.onCompiled=n?function(){n(),t()}:t}else t()},e.prototype.getUniforms=function(e,t){for(var i=new Array,n=e,r=0;r<t.length;r++)i.push(this._gl.getUniformLocation(n.program,t[r]));return i},e.prototype.getAttributes=function(e,t){for(var i=[],n=e,r=0;r<t.length;r++)try{i.push(this._gl.getAttribLocation(n.program,t[r]))}catch(e){i.push(-1)}return i},e.prototype.enableEffect=function(e){e&&e!==this._currentEffect&&(this.bindSamplers(e),this._currentEffect=e,e.onBind&&e.onBind(e),e._onBindObservable&&e._onBindObservable.notifyObservers(e))},e.prototype.setInt=function(e,t){e&&this._gl.uniform1i(e,t)},e.prototype.setIntArray=function(e,t){e&&this._gl.uniform1iv(e,t)},e.prototype.setIntArray2=function(e,t){e&&t.length%2==0&&this._gl.uniform2iv(e,t)},e.prototype.setIntArray3=function(e,t){e&&t.length%3==0&&this._gl.uniform3iv(e,t)},e.prototype.setIntArray4=function(e,t){e&&t.length%4==0&&this._gl.uniform4iv(e,t)},e.prototype.setArray=function(e,t){e&&this._gl.uniform1fv(e,t)},e.prototype.setArray2=function(e,t){e&&t.length%2==0&&this._gl.uniform2fv(e,t)},e.prototype.setArray3=function(e,t){e&&t.length%3==0&&this._gl.uniform3fv(e,t)},e.prototype.setArray4=function(e,t){e&&t.length%4==0&&this._gl.uniform4fv(e,t)},e.prototype.setMatrices=function(e,t){e&&this._gl.uniformMatrix4fv(e,!1,t)},e.prototype.setMatrix3x3=function(e,t){e&&this._gl.uniformMatrix3fv(e,!1,t)},e.prototype.setMatrix2x2=function(e,t){e&&this._gl.uniformMatrix2fv(e,!1,t)},e.prototype.setFloat=function(e,t){e&&this._gl.uniform1f(e,t)},e.prototype.setFloat2=function(e,t,i){e&&this._gl.uniform2f(e,t,i)},e.prototype.setFloat3=function(e,t,i,n){e&&this._gl.uniform3f(e,t,i,n)},e.prototype.setFloat4=function(e,t,i,n,r){e&&this._gl.uniform4f(e,t,i,n,r)},e.prototype.applyStates=function(){if(this._depthCullingState.apply(this._gl),this._stencilState.apply(this._gl),this._alphaState.apply(this._gl),this._colorWriteChanged){this._colorWriteChanged=!1;var e=this._colorWrite;this._gl.colorMask(e,e,e,e)}},e.prototype.setColorWrite=function(e){e!==this._colorWrite&&(this._colorWriteChanged=!0,this._colorWrite=e)},e.prototype.getColorWrite=function(){return this._colorWrite},Object.defineProperty(e.prototype,"depthCullingState",{get:function(){return this._depthCullingState},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"alphaState",{get:function(){return this._alphaState},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"stencilState",{get:function(){return this._stencilState},enumerable:!0,configurable:!0}),e.prototype.clearInternalTexturesCache=function(){this._internalTexturesCache=[]},e.prototype.wipeCaches=function(e){this.preventCacheWipeBetweenFrames&&!e||(this._currentEffect=null,this._viewportCached.x=0,this._viewportCached.y=0,this._viewportCached.z=0,this._viewportCached.w=0,this._unbindVertexArrayObject(),e&&(this._currentProgram=null,this.resetTextureCache(),this._stencilState.reset(),this._depthCullingState.reset(),this._depthCullingState.depthFunc=this._gl.LEQUAL,this._alphaState.reset(),this._alphaMode=u.a.ALPHA_ADD,this._alphaEquation=u.a.ALPHA_DISABLE,this._colorWrite=!0,this._colorWriteChanged=!0,this._unpackFlipYCached=null,this._gl.pixelStorei(this._gl.UNPACK_COLORSPACE_CONVERSION_WEBGL,this._gl.NONE),this._gl.pixelStorei(this._gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL,0),this._mustWipeVertexAttributes=!0,this.unbindAllAttributes()),this._resetVertexBufferBinding(),this._cachedIndexBuffer=null,this._cachedEffectForVertexBuffers=null,this.bindIndexBuffer(null))},e.prototype._getSamplingParameters=function(e,t){var i=this._gl,n=i.NEAREST,r=i.NEAREST;switch(e){case u.a.TEXTURE_LINEAR_LINEAR_MIPNEAREST:n=i.LINEAR,r=t?i.LINEAR_MIPMAP_NEAREST:i.LINEAR;break;case u.a.TEXTURE_LINEAR_LINEAR_MIPLINEAR:n=i.LINEAR,r=t?i.LINEAR_MIPMAP_LINEAR:i.LINEAR;break;case u.a.TEXTURE_NEAREST_NEAREST_MIPLINEAR:n=i.NEAREST,r=t?i.NEAREST_MIPMAP_LINEAR:i.NEAREST;break;case u.a.TEXTURE_NEAREST_NEAREST_MIPNEAREST:n=i.NEAREST,r=t?i.NEAREST_MIPMAP_NEAREST:i.NEAREST;break;case u.a.TEXTURE_NEAREST_LINEAR_MIPNEAREST:n=i.NEAREST,r=t?i.LINEAR_MIPMAP_NEAREST:i.LINEAR;break;case u.a.TEXTURE_NEAREST_LINEAR_MIPLINEAR:n=i.NEAREST,r=t?i.LINEAR_MIPMAP_LINEAR:i.LINEAR;break;case u.a.TEXTURE_NEAREST_LINEAR:n=i.NEAREST,r=i.LINEAR;break;case u.a.TEXTURE_NEAREST_NEAREST:n=i.NEAREST,r=i.NEAREST;break;case u.a.TEXTURE_LINEAR_NEAREST_MIPNEAREST:n=i.LINEAR,r=t?i.NEAREST_MIPMAP_NEAREST:i.NEAREST;break;case u.a.TEXTURE_LINEAR_NEAREST_MIPLINEAR:n=i.LINEAR,r=t?i.NEAREST_MIPMAP_LINEAR:i.NEAREST;break;case u.a.TEXTURE_LINEAR_LINEAR:n=i.LINEAR,r=i.LINEAR;break;case u.a.TEXTURE_LINEAR_NEAREST:n=i.LINEAR,r=i.NEAREST}return{min:r,mag:n}},e.prototype._createTexture=function(){var e=this._gl.createTexture();if(!e)throw new Error("Unable to create texture");return e},e.prototype.createTexture=function(t,i,r,o,a,s,c,l,d,f,p,_){var m=this;void 0===a&&(a=u.a.TEXTURE_TRILINEAR_SAMPLINGMODE),void 0===s&&(s=null),void 0===c&&(c=null),void 0===l&&(l=null),void 0===d&&(d=null),void 0===f&&(f=null),void 0===p&&(p=null);for(var g=String(t),v="data:"===g.substr(0,5),y="blob:"===g.substr(0,5),b=v&&-1!==g.indexOf(";base64,"),T=d||new h.a(this,h.b.Url),E=g.lastIndexOf("."),x=p||(E>-1?g.substring(E).toLowerCase():""),P=null,A=0,S=e._TextureLoaders;A<S.length;A++){var C=S[A];if(C.canLoad(x)){P=C;break}}o&&o._addPendingData(T),T.url=g,T.generateMipMaps=!i,T.samplingMode=a,T.invertY=r,this._doNotHandleContextLost||(T._buffer=l);var R=null;s&&!d&&(R=T.onLoadedObservable.add(s)),d||this._internalTexturesCache.push(T);var O=function(e,t){o&&o._removePendingData(T),R&&T.onLoadedObservable.remove(R),n.a.UseFallbackTexture?m.createTexture(n.a.FallbackTexture,i,T.invertY,o,a,null,c,l,T):c&&c(e||"Unknown error",t)};if(P){var M=function(e){P.loadData(e,T,function(e,t,i,n,r,s){s?O("TextureLoader failed to load data"):m._prepareWebGLTexture(T,o,e,t,T.invertY,!i,n,function(){return r(),!1},a)})};l?l instanceof ArrayBuffer?M(new Uint8Array(l)):ArrayBuffer.isView(l)?M(l):c&&c("Unable to load: only ArrayBuffer or ArrayBufferView is supported",null):this._loadFile(g,function(e){return M(new Uint8Array(e))},void 0,o?o.offlineProvider:void 0,!0,function(e,t){O("Unable to load "+(e&&e.responseURL,t))})}else{var I=function(e){y&&!m._doNotHandleContextLost&&(T._buffer=e),m._prepareWebGLTexture(T,o,e.width,e.height,T.invertY,i,!1,function(t,i,n){var r=m._gl,a=e.width===t&&e.height===i,s=f?m._getInternalFormat(f):".jpg"===x?r.RGB:r.RGBA;if(a)return r.texImage2D(r.TEXTURE_2D,0,s,s,r.UNSIGNED_BYTE,e),!1;var c=m._caps.maxTextureSize;if(e.width>c||e.height>c||!m._supportsHardwareTextureRescaling)return m._prepareWorkingCanvas(),!(!m._workingCanvas||!m._workingContext)&&(m._workingCanvas.width=t,m._workingCanvas.height=i,m._workingContext.drawImage(e,0,0,e.width,e.height,0,0,t,i),r.texImage2D(r.TEXTURE_2D,0,s,s,r.UNSIGNED_BYTE,m._workingCanvas),T.width=t,T.height=i,!1);var l=new h.a(m,h.b.Temp);return m._bindTextureDirectly(r.TEXTURE_2D,l,!0),r.texImage2D(r.TEXTURE_2D,0,s,s,r.UNSIGNED_BYTE,e),m._rescaleTexture(l,T,o,s,function(){m._releaseTexture(l),m._bindTextureDirectly(r.TEXTURE_2D,T,!0),n()}),!0},a)};!v||b?l&&(l.decoding||l.close)?I(l):e._FileToolsLoadImage(g,I,O,o?o.offlineProvider:null,_):"string"==typeof l||l instanceof ArrayBuffer||ArrayBuffer.isView(l)||l instanceof Blob?e._FileToolsLoadImage(l,I,O,o?o.offlineProvider:null,_):l&&I(l)}return T},e._FileToolsLoadImage=function(e,t,i,n,r){throw o.a.WarnImport("FileTools")},e.prototype._rescaleTexture=function(e,t,i,n,r){},e.prototype.createRawTexture=function(e,t,i,n,r,a,s,c,l){throw void 0===c&&(c=null),void 0===l&&(l=u.a.TEXTURETYPE_UNSIGNED_INT),o.a.WarnImport("Engine.RawTexture")},e.prototype.createRawCubeTexture=function(e,t,i,n,r,a,s,c){throw void 0===c&&(c=null),o.a.WarnImport("Engine.RawTexture")},e.prototype.createRawTexture3D=function(e,t,i,n,r,a,s,c,l,h){throw void 0===l&&(l=null),void 0===h&&(h=u.a.TEXTURETYPE_UNSIGNED_INT),o.a.WarnImport("Engine.RawTexture")},e.prototype.createRawTexture2DArray=function(e,t,i,n,r,a,s,c,l,h){throw void 0===l&&(l=null),void 0===h&&(h=u.a.TEXTURETYPE_UNSIGNED_INT),o.a.WarnImport("Engine.RawTexture")},e.prototype._unpackFlipY=function(e){this._unpackFlipYCached!==e&&(this._gl.pixelStorei(this._gl.UNPACK_FLIP_Y_WEBGL,e?1:0),this.enableUnpackFlipYCached&&(this._unpackFlipYCached=e))},e.prototype._getUnpackAlignement=function(){return this._gl.getParameter(this._gl.UNPACK_ALIGNMENT)},e.prototype._getTextureTarget=function(e){return e.isCube?this._gl.TEXTURE_CUBE_MAP:e.is3D?this._gl.TEXTURE_3D:e.is2DArray||e.isMultiview?this._gl.TEXTURE_2D_ARRAY:this._gl.TEXTURE_2D},e.prototype.updateTextureSamplingMode=function(e,t,i){void 0===i&&(i=!1);var n=this._getTextureTarget(t),r=this._getSamplingParameters(e,t.generateMipMaps||i);this._setTextureParameterInteger(n,this._gl.TEXTURE_MAG_FILTER,r.mag,t),this._setTextureParameterInteger(n,this._gl.TEXTURE_MIN_FILTER,r.min),i&&(t.generateMipMaps=!0,this._gl.generateMipmap(n)),this._bindTextureDirectly(n,null),t.samplingMode=e},e.prototype.updateTextureWrappingMode=function(e,t,i,n){void 0===i&&(i=null),void 0===n&&(n=null);var r=this._getTextureTarget(e);null!==t&&(this._setTextureParameterInteger(r,this._gl.TEXTURE_WRAP_S,this._getTextureWrapMode(t),e),e._cachedWrapU=t),null!==i&&(this._setTextureParameterInteger(r,this._gl.TEXTURE_WRAP_T,this._getTextureWrapMode(i),e),e._cachedWrapV=i),(e.is2DArray||e.is3D)&&null!==n&&(this._setTextureParameterInteger(r,this._gl.TEXTURE_WRAP_R,this._getTextureWrapMode(n),e),e._cachedWrapR=n),this._bindTextureDirectly(r,null)},e.prototype._setupDepthStencilTexture=function(e,t,i,n,r){var o=t.width||t,a=t.height||t,s=t.layers||0;e.baseWidth=o,e.baseHeight=a,e.width=o,e.height=a,e.is2DArray=s>0,e.depth=s,e.isReady=!0,e.samples=1,e.generateMipMaps=!1,e._generateDepthBuffer=!0,e._generateStencilBuffer=i,e.samplingMode=n?u.a.TEXTURE_BILINEAR_SAMPLINGMODE:u.a.TEXTURE_NEAREST_SAMPLINGMODE,e.type=u.a.TEXTURETYPE_UNSIGNED_INT,e._comparisonFunction=r;var c=this._gl,l=this._getTextureTarget(e),h=this._getSamplingParameters(e.samplingMode,!1);c.texParameteri(l,c.TEXTURE_MAG_FILTER,h.mag),c.texParameteri(l,c.TEXTURE_MIN_FILTER,h.min),c.texParameteri(l,c.TEXTURE_WRAP_S,c.CLAMP_TO_EDGE),c.texParameteri(l,c.TEXTURE_WRAP_T,c.CLAMP_TO_EDGE),0===r?(c.texParameteri(l,c.TEXTURE_COMPARE_FUNC,u.a.LEQUAL),c.texParameteri(l,c.TEXTURE_COMPARE_MODE,c.NONE)):(c.texParameteri(l,c.TEXTURE_COMPARE_FUNC,r),c.texParameteri(l,c.TEXTURE_COMPARE_MODE,c.COMPARE_REF_TO_TEXTURE))},e.prototype._uploadCompressedDataToTextureDirectly=function(e,t,i,n,r,o,a){void 0===o&&(o=0),void 0===a&&(a=0);var s=this._gl,c=s.TEXTURE_2D;e.isCube&&(c=s.TEXTURE_CUBE_MAP_POSITIVE_X+o),this._gl.compressedTexImage2D(c,a,t,i,n,0,r)},e.prototype._uploadDataToTextureDirectly=function(e,t,i,n,r,o){void 0===i&&(i=0),void 0===n&&(n=0),void 0===o&&(o=!1);var a=this._gl,s=this._getWebGLTextureType(e.type),c=this._getInternalFormat(e.format),l=void 0===r?this._getRGBABufferInternalSizedFormat(e.type,e.format):this._getInternalFormat(r);this._unpackFlipY(e.invertY);var u=a.TEXTURE_2D;e.isCube&&(u=a.TEXTURE_CUBE_MAP_POSITIVE_X+i);var h=Math.round(Math.log(e.width)*Math.LOG2E),d=Math.round(Math.log(e.height)*Math.LOG2E),f=o?e.width:Math.pow(2,Math.max(h-n,0)),p=o?e.height:Math.pow(2,Math.max(d-n,0));a.texImage2D(u,n,l,f,p,0,c,s,t)},e.prototype.updateTextureData=function(e,t,i,n,r,o,a,s){void 0===a&&(a=0),void 0===s&&(s=0);var c=this._gl,l=this._getWebGLTextureType(e.type),u=this._getInternalFormat(e.format);this._unpackFlipY(e.invertY);var h=c.TEXTURE_2D;e.isCube&&(h=c.TEXTURE_CUBE_MAP_POSITIVE_X+a),c.texSubImage2D(h,s,i,n,r,o,u,l,t)},e.prototype._uploadArrayBufferViewToTexture=function(e,t,i,n){void 0===i&&(i=0),void 0===n&&(n=0);var r=this._gl,o=e.isCube?r.TEXTURE_CUBE_MAP:r.TEXTURE_2D;this._bindTextureDirectly(o,e,!0),this._uploadDataToTextureDirectly(e,t,i,n),this._bindTextureDirectly(o,null,!0)},e.prototype._prepareWebGLTextureContinuation=function(e,t,i,n,r){var o=this._gl;if(o){var a=this._getSamplingParameters(r,!i);o.texParameteri(o.TEXTURE_2D,o.TEXTURE_MAG_FILTER,a.mag),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_MIN_FILTER,a.min),i||n||o.generateMipmap(o.TEXTURE_2D),this._bindTextureDirectly(o.TEXTURE_2D,null),t&&t._removePendingData(e),e.onLoadedObservable.notifyObservers(e),e.onLoadedObservable.clear()}},e.prototype._prepareWebGLTexture=function(t,i,n,r,o,a,s,c,l){var h=this;void 0===l&&(l=u.a.TEXTURE_TRILINEAR_SAMPLINGMODE);var d=this.getCaps().maxTextureSize,f=Math.min(d,this.needPOTTextures?e.GetExponentOfTwo(n,d):n),p=Math.min(d,this.needPOTTextures?e.GetExponentOfTwo(r,d):r),_=this._gl;_&&(t._webGLTexture?(this._bindTextureDirectly(_.TEXTURE_2D,t,!0),this._unpackFlipY(void 0===o||!!o),t.baseWidth=n,t.baseHeight=r,t.width=f,t.height=p,t.isReady=!0,c(f,p,function(){h._prepareWebGLTextureContinuation(t,i,a,s,l)})||this._prepareWebGLTextureContinuation(t,i,a,s,l)):i&&i._removePendingData(t))},e.prototype._setupFramebufferDepthAttachments=function(e,t,i,n,r){void 0===r&&(r=1);var o=this._gl;if(e&&t)return this._getDepthStencilBuffer(i,n,r,o.DEPTH_STENCIL,o.DEPTH24_STENCIL8,o.DEPTH_STENCIL_ATTACHMENT);if(t){var a=o.DEPTH_COMPONENT16;return this._webGLVersion>1&&(a=o.DEPTH_COMPONENT32F),this._getDepthStencilBuffer(i,n,r,a,a,o.DEPTH_ATTACHMENT)}return e?this._getDepthStencilBuffer(i,n,r,o.STENCIL_INDEX8,o.STENCIL_INDEX8,o.STENCIL_ATTACHMENT):null},e.prototype._releaseFramebufferObjects=function(e){var t=this._gl;e._framebuffer&&(t.deleteFramebuffer(e._framebuffer),e._framebuffer=null),e._depthStencilBuffer&&(t.deleteRenderbuffer(e._depthStencilBuffer),e._depthStencilBuffer=null),e._MSAAFramebuffer&&(t.deleteFramebuffer(e._MSAAFramebuffer),e._MSAAFramebuffer=null),e._MSAARenderBuffer&&(t.deleteRenderbuffer(e._MSAARenderBuffer),e._MSAARenderBuffer=null)},e.prototype._releaseTexture=function(e){this._releaseFramebufferObjects(e),this._deleteTexture(e._webGLTexture),this.unbindAllTextures();var t=this._internalTexturesCache.indexOf(e);-1!==t&&this._internalTexturesCache.splice(t,1),e._lodTextureHigh&&e._lodTextureHigh.dispose(),e._lodTextureMid&&e._lodTextureMid.dispose(),e._lodTextureLow&&e._lodTextureLow.dispose(),e._irradianceTexture&&e._irradianceTexture.dispose()},e.prototype._deleteTexture=function(e){this._gl.deleteTexture(e)},e.prototype._setProgram=function(e){this._currentProgram!==e&&(this._gl.useProgram(e),this._currentProgram=e)},e.prototype.bindSamplers=function(e){var t=e.getPipelineContext();this._setProgram(t.program);for(var i=e.getSamplers(),n=0;n<i.length;n++){var r=e.getUniform(i[n]);r&&(this._boundUniforms[n]=r)}this._currentEffect=null},e.prototype._activateCurrentTexture=function(){this._currentTextureChannel!==this._activeChannel&&(this._gl.activeTexture(this._gl.TEXTURE0+this._activeChannel),this._currentTextureChannel=this._activeChannel)},e.prototype._bindTextureDirectly=function(e,t,i,n){void 0===i&&(i=!1),void 0===n&&(n=!1);var r=!1,o=t&&t._associatedChannel>-1;return i&&o&&(this._activeChannel=t._associatedChannel),this._boundTexturesCache[this._activeChannel]!==t||n?(this._activateCurrentTexture(),t&&t.isMultiview?this._gl.bindTexture(e,t?t._colorTextureArray:null):this._gl.bindTexture(e,t?t._webGLTexture:null),this._boundTexturesCache[this._activeChannel]=t,t&&(t._associatedChannel=this._activeChannel)):i&&(r=!0,this._activateCurrentTexture()),o&&!i&&this._bindSamplerUniformToChannel(t._associatedChannel,this._activeChannel),r},e.prototype._bindTexture=function(e,t){void 0!==e&&(t&&(t._associatedChannel=e),this._activeChannel=e,this._bindTextureDirectly(this._gl.TEXTURE_2D,t))},e.prototype.unbindAllTextures=function(){for(var e=0;e<this._maxSimultaneousTextures;e++)this._activeChannel=e,this._bindTextureDirectly(this._gl.TEXTURE_2D,null),this._bindTextureDirectly(this._gl.TEXTURE_CUBE_MAP,null),this.webGLVersion>1&&(this._bindTextureDirectly(this._gl.TEXTURE_3D,null),this._bindTextureDirectly(this._gl.TEXTURE_2D_ARRAY,null))},e.prototype.setTexture=function(e,t,i){void 0!==e&&(t&&(this._boundUniforms[e]=t),this._setTexture(e,i))},e.prototype._bindSamplerUniformToChannel=function(e,t){var i=this._boundUniforms[e];i&&i._currentState!==t&&(this._gl.uniform1i(i,t),i._currentState=t)},e.prototype._getTextureWrapMode=function(e){switch(e){case u.a.TEXTURE_WRAP_ADDRESSMODE:return this._gl.REPEAT;case u.a.TEXTURE_CLAMP_ADDRESSMODE:return this._gl.CLAMP_TO_EDGE;case u.a.TEXTURE_MIRROR_ADDRESSMODE:return this._gl.MIRRORED_REPEAT}return this._gl.REPEAT},e.prototype._setTexture=function(e,t,i,n){if(void 0===i&&(i=!1),void 0===n&&(n=!1),!t)return null!=this._boundTexturesCache[e]&&(this._activeChannel=e,this._bindTextureDirectly(this._gl.TEXTURE_2D,null),this._bindTextureDirectly(this._gl.TEXTURE_CUBE_MAP,null),this.webGLVersion>1&&(this._bindTextureDirectly(this._gl.TEXTURE_3D,null),this._bindTextureDirectly(this._gl.TEXTURE_2D_ARRAY,null))),!1;if(t.video)this._activeChannel=e,t.update();else if(t.delayLoadState===u.a.DELAYLOADSTATE_NOTLOADED)return t.delayLoad(),!1;var r;r=n?t.depthStencilTexture:t.isReady()?t.getInternalTexture():t.isCube?this.emptyCubeTexture:t.is3D?this.emptyTexture3D:t.is2DArray?this.emptyTexture2DArray:this.emptyTexture,!i&&r&&(r._associatedChannel=e);var o=!0;this._boundTexturesCache[e]===r&&(i||this._bindSamplerUniformToChannel(r._associatedChannel,e),o=!1),this._activeChannel=e;var a=this._getTextureTarget(r);if(o&&this._bindTextureDirectly(a,r,i),r&&!r.isMultiview){if(r.isCube&&r._cachedCoordinatesMode!==t.coordinatesMode){r._cachedCoordinatesMode=t.coordinatesMode;var s=t.coordinatesMode!==u.a.TEXTURE_CUBIC_MODE&&t.coordinatesMode!==u.a.TEXTURE_SKYBOX_MODE?u.a.TEXTURE_WRAP_ADDRESSMODE:u.a.TEXTURE_CLAMP_ADDRESSMODE;t.wrapU=s,t.wrapV=s}r._cachedWrapU!==t.wrapU&&(r._cachedWrapU=t.wrapU,this._setTextureParameterInteger(a,this._gl.TEXTURE_WRAP_S,this._getTextureWrapMode(t.wrapU),r)),r._cachedWrapV!==t.wrapV&&(r._cachedWrapV=t.wrapV,this._setTextureParameterInteger(a,this._gl.TEXTURE_WRAP_T,this._getTextureWrapMode(t.wrapV),r)),r.is3D&&r._cachedWrapR!==t.wrapR&&(r._cachedWrapR=t.wrapR,this._setTextureParameterInteger(a,this._gl.TEXTURE_WRAP_R,this._getTextureWrapMode(t.wrapR),r)),this._setAnisotropicLevel(a,r,t.anisotropicFilteringLevel)}return!0},e.prototype.setTextureArray=function(e,t,i){if(void 0!==e&&t){this._textureUnits&&this._textureUnits.length===i.length||(this._textureUnits=new Int32Array(i.length));for(var n=0;n<i.length;n++){var r=i[n].getInternalTexture();r?(this._textureUnits[n]=e+n,r._associatedChannel=e+n):this._textureUnits[n]=-1}this._gl.uniform1iv(t,this._textureUnits);for(var o=0;o<i.length;o++)this._setTexture(this._textureUnits[o],i[o],!0)}},e.prototype._setAnisotropicLevel=function(e,t,i){var n=this._caps.textureAnisotropicFilterExtension;t.samplingMode!==u.a.TEXTURE_LINEAR_LINEAR_MIPNEAREST&&t.samplingMode!==u.a.TEXTURE_LINEAR_LINEAR_MIPLINEAR&&t.samplingMode!==u.a.TEXTURE_LINEAR_LINEAR&&(i=1),n&&t._cachedAnisotropicFilteringLevel!==i&&(this._setTextureParameterFloat(e,n.TEXTURE_MAX_ANISOTROPY_EXT,Math.min(i,this._caps.maxAnisotropy),t),t._cachedAnisotropicFilteringLevel=i)},e.prototype._setTextureParameterFloat=function(e,t,i,n){this._bindTextureDirectly(e,n,!0,!0),this._gl.texParameterf(e,t,i)},e.prototype._setTextureParameterInteger=function(e,t,i,n){n&&this._bindTextureDirectly(e,n,!0,!0),this._gl.texParameteri(e,t,i)},e.prototype.unbindAllAttributes=function(){if(this._mustWipeVertexAttributes){this._mustWipeVertexAttributes=!1;for(var e=0;e<this._caps.maxVertexAttribs;e++)this.disableAttributeByIndex(e)}else{e=0;for(var t=this._vertexAttribArraysEnabled.length;e<t;e++)e>=this._caps.maxVertexAttribs||!this._vertexAttribArraysEnabled[e]||this.disableAttributeByIndex(e)}},e.prototype.releaseEffects=function(){for(var e in this._compiledEffects){var t=this._compiledEffects[e].getPipelineContext();this._deletePipelineContext(t)}this._compiledEffects={}},e.prototype.dispose=function(){this.stopRenderLoop(),this.onBeforeTextureInitObservable&&this.onBeforeTextureInitObservable.clear(),this._emptyTexture&&(this._releaseTexture(this._emptyTexture),this._emptyTexture=null),this._emptyCubeTexture&&(this._releaseTexture(this._emptyCubeTexture),this._emptyCubeTexture=null),this.releaseEffects(),this.unbindAllAttributes(),this._boundUniforms=[],f.a.IsWindowObjectExist()&&this._renderingCanvas&&(this._doNotHandleContextLost||(this._renderingCanvas.removeEventListener("webglcontextlost",this._onContextLost),this._renderingCanvas.removeEventListener("webglcontextrestored",this._onContextRestored))),this._workingCanvas=null,this._workingContext=null,this._currentBufferPointers=[],this._renderingCanvas=null,this._currentProgram=null,this._boundRenderFunction=null,r.a.ResetCache();for(var e=0,t=this._activeRequests;e<t.length;e++){t[e].abort()}},e.prototype.attachContextLostEvent=function(e){this._renderingCanvas&&this._renderingCanvas.addEventListener("webglcontextlost",e,!1)},e.prototype.attachContextRestoredEvent=function(e){this._renderingCanvas&&this._renderingCanvas.addEventListener("webglcontextrestored",e,!1)},e.prototype.getError=function(){return this._gl.getError()},e.prototype._canRenderToFloatFramebuffer=function(){return this._webGLVersion>1?this._caps.colorBufferFloat:this._canRenderToFramebuffer(u.a.TEXTURETYPE_FLOAT)},e.prototype._canRenderToHalfFloatFramebuffer=function(){return this._webGLVersion>1?this._caps.colorBufferFloat:this._canRenderToFramebuffer(u.a.TEXTURETYPE_HALF_FLOAT)},e.prototype._canRenderToFramebuffer=function(e){for(var t=this._gl;t.getError()!==t.NO_ERROR;);var i=!0,n=t.createTexture();t.bindTexture(t.TEXTURE_2D,n),t.texImage2D(t.TEXTURE_2D,0,this._getRGBABufferInternalSizedFormat(e),1,1,0,t.RGBA,this._getWebGLTextureType(e),null),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MIN_FILTER,t.NEAREST),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MAG_FILTER,t.NEAREST);var r=t.createFramebuffer();t.bindFramebuffer(t.FRAMEBUFFER,r),t.framebufferTexture2D(t.FRAMEBUFFER,t.COLOR_ATTACHMENT0,t.TEXTURE_2D,n,0);var o=t.checkFramebufferStatus(t.FRAMEBUFFER);if((i=(i=i&&o===t.FRAMEBUFFER_COMPLETE)&&t.getError()===t.NO_ERROR)&&(t.clear(t.COLOR_BUFFER_BIT),i=i&&t.getError()===t.NO_ERROR),i){t.bindFramebuffer(t.FRAMEBUFFER,null);var a=t.RGBA,s=t.UNSIGNED_BYTE,c=new Uint8Array(4);t.readPixels(0,0,1,1,a,s,c),i=i&&t.getError()===t.NO_ERROR}for(t.deleteTexture(n),t.deleteFramebuffer(r),t.bindFramebuffer(t.FRAMEBUFFER,null);!i&&t.getError()!==t.NO_ERROR;);return i},e.prototype._getWebGLTextureType=function(e){if(1===this._webGLVersion){switch(e){case u.a.TEXTURETYPE_FLOAT:return this._gl.FLOAT;case u.a.TEXTURETYPE_HALF_FLOAT:return this._gl.HALF_FLOAT_OES;case u.a.TEXTURETYPE_UNSIGNED_BYTE:return this._gl.UNSIGNED_BYTE;case u.a.TEXTURETYPE_UNSIGNED_SHORT_4_4_4_4:return this._gl.UNSIGNED_SHORT_4_4_4_4;case u.a.TEXTURETYPE_UNSIGNED_SHORT_5_5_5_1:return this._gl.UNSIGNED_SHORT_5_5_5_1;case u.a.TEXTURETYPE_UNSIGNED_SHORT_5_6_5:return this._gl.UNSIGNED_SHORT_5_6_5}return this._gl.UNSIGNED_BYTE}switch(e){case u.a.TEXTURETYPE_BYTE:return this._gl.BYTE;case u.a.TEXTURETYPE_UNSIGNED_BYTE:return this._gl.UNSIGNED_BYTE;case u.a.TEXTURETYPE_SHORT:return this._gl.SHORT;case u.a.TEXTURETYPE_UNSIGNED_SHORT:return this._gl.UNSIGNED_SHORT;case u.a.TEXTURETYPE_INT:return this._gl.INT;case u.a.TEXTURETYPE_UNSIGNED_INTEGER:return this._gl.UNSIGNED_INT;case u.a.TEXTURETYPE_FLOAT:return this._gl.FLOAT;case u.a.TEXTURETYPE_HALF_FLOAT:return this._gl.HALF_FLOAT;case u.a.TEXTURETYPE_UNSIGNED_SHORT_4_4_4_4:return this._gl.UNSIGNED_SHORT_4_4_4_4;case u.a.TEXTURETYPE_UNSIGNED_SHORT_5_5_5_1:return this._gl.UNSIGNED_SHORT_5_5_5_1;case u.a.TEXTURETYPE_UNSIGNED_SHORT_5_6_5:return this._gl.UNSIGNED_SHORT_5_6_5;case u.a.TEXTURETYPE_UNSIGNED_INT_2_10_10_10_REV:return this._gl.UNSIGNED_INT_2_10_10_10_REV;case u.a.TEXTURETYPE_UNSIGNED_INT_24_8:return this._gl.UNSIGNED_INT_24_8;case u.a.TEXTURETYPE_UNSIGNED_INT_10F_11F_11F_REV:return this._gl.UNSIGNED_INT_10F_11F_11F_REV;case u.a.TEXTURETYPE_UNSIGNED_INT_5_9_9_9_REV:return this._gl.UNSIGNED_INT_5_9_9_9_REV;case u.a.TEXTURETYPE_FLOAT_32_UNSIGNED_INT_24_8_REV:return this._gl.FLOAT_32_UNSIGNED_INT_24_8_REV}return this._gl.UNSIGNED_BYTE},e.prototype._getInternalFormat=function(e){var t=this._gl.RGBA;switch(e){case u.a.TEXTUREFORMAT_ALPHA:t=this._gl.ALPHA;break;case u.a.TEXTUREFORMAT_LUMINANCE:t=this._gl.LUMINANCE;break;case u.a.TEXTUREFORMAT_LUMINANCE_ALPHA:t=this._gl.LUMINANCE_ALPHA;break;case u.a.TEXTUREFORMAT_RED:t=this._gl.RED;break;case u.a.TEXTUREFORMAT_RG:t=this._gl.RG;break;case u.a.TEXTUREFORMAT_RGB:t=this._gl.RGB;break;case u.a.TEXTUREFORMAT_RGBA:t=this._gl.RGBA}if(this._webGLVersion>1)switch(e){case u.a.TEXTUREFORMAT_RED_INTEGER:t=this._gl.RED_INTEGER;break;case u.a.TEXTUREFORMAT_RG_INTEGER:t=this._gl.RG_INTEGER;break;case u.a.TEXTUREFORMAT_RGB_INTEGER:t=this._gl.RGB_INTEGER;break;case u.a.TEXTUREFORMAT_RGBA_INTEGER:t=this._gl.RGBA_INTEGER}return t},e.prototype._getRGBABufferInternalSizedFormat=function(e,t){if(1===this._webGLVersion){if(void 0!==t)switch(t){case u.a.TEXTUREFORMAT_ALPHA:return this._gl.ALPHA;case u.a.TEXTUREFORMAT_LUMINANCE:return this._gl.LUMINANCE;case u.a.TEXTUREFORMAT_LUMINANCE_ALPHA:return this._gl.LUMINANCE_ALPHA;case u.a.TEXTUREFORMAT_RGB:return this._gl.RGB}return this._gl.RGBA}switch(e){case u.a.TEXTURETYPE_BYTE:switch(t){case u.a.TEXTUREFORMAT_RED:return this._gl.R8_SNORM;case u.a.TEXTUREFORMAT_RG:return this._gl.RG8_SNORM;case u.a.TEXTUREFORMAT_RGB:return this._gl.RGB8_SNORM;case u.a.TEXTUREFORMAT_RED_INTEGER:return this._gl.R8I;case u.a.TEXTUREFORMAT_RG_INTEGER:return this._gl.RG8I;case u.a.TEXTUREFORMAT_RGB_INTEGER:return this._gl.RGB8I;case u.a.TEXTUREFORMAT_RGBA_INTEGER:return this._gl.RGBA8I;default:return this._gl.RGBA8_SNORM}case u.a.TEXTURETYPE_UNSIGNED_BYTE:switch(t){case u.a.TEXTUREFORMAT_RED:return this._gl.R8;case u.a.TEXTUREFORMAT_RG:return this._gl.RG8;case u.a.TEXTUREFORMAT_RGB:return this._gl.RGB8;case u.a.TEXTUREFORMAT_RGBA:return this._gl.RGBA8;case u.a.TEXTUREFORMAT_RED_INTEGER:return this._gl.R8UI;case u.a.TEXTUREFORMAT_RG_INTEGER:return this._gl.RG8UI;case u.a.TEXTUREFORMAT_RGB_INTEGER:return this._gl.RGB8UI;case u.a.TEXTUREFORMAT_RGBA_INTEGER:return this._gl.RGBA8UI;case u.a.TEXTUREFORMAT_ALPHA:return this._gl.ALPHA;case u.a.TEXTUREFORMAT_LUMINANCE:return this._gl.LUMINANCE;case u.a.TEXTUREFORMAT_LUMINANCE_ALPHA:return this._gl.LUMINANCE_ALPHA;default:return this._gl.RGBA8}case u.a.TEXTURETYPE_SHORT:switch(t){case u.a.TEXTUREFORMAT_RED_INTEGER:return this._gl.R16I;case u.a.TEXTUREFORMAT_RG_INTEGER:return this._gl.RG16I;case u.a.TEXTUREFORMAT_RGB_INTEGER:return this._gl.RGB16I;case u.a.TEXTUREFORMAT_RGBA_INTEGER:default:return this._gl.RGBA16I}case u.a.TEXTURETYPE_UNSIGNED_SHORT:switch(t){case u.a.TEXTUREFORMAT_RED_INTEGER:return this._gl.R16UI;case u.a.TEXTUREFORMAT_RG_INTEGER:return this._gl.RG16UI;case u.a.TEXTUREFORMAT_RGB_INTEGER:return this._gl.RGB16UI;case u.a.TEXTUREFORMAT_RGBA_INTEGER:default:return this._gl.RGBA16UI}case u.a.TEXTURETYPE_INT:switch(t){case u.a.TEXTUREFORMAT_RED_INTEGER:return this._gl.R32I;case u.a.TEXTUREFORMAT_RG_INTEGER:return this._gl.RG32I;case u.a.TEXTUREFORMAT_RGB_INTEGER:return this._gl.RGB32I;case u.a.TEXTUREFORMAT_RGBA_INTEGER:default:return this._gl.RGBA32I}case u.a.TEXTURETYPE_UNSIGNED_INTEGER:switch(t){case u.a.TEXTUREFORMAT_RED_INTEGER:return this._gl.R32UI;case u.a.TEXTUREFORMAT_RG_INTEGER:return this._gl.RG32UI;case u.a.TEXTUREFORMAT_RGB_INTEGER:return this._gl.RGB32UI;case u.a.TEXTUREFORMAT_RGBA_INTEGER:default:return this._gl.RGBA32UI}case u.a.TEXTURETYPE_FLOAT:switch(t){case u.a.TEXTUREFORMAT_RED:return this._gl.R32F;case u.a.TEXTUREFORMAT_RG:return this._gl.RG32F;case u.a.TEXTUREFORMAT_RGB:return this._gl.RGB32F;case u.a.TEXTUREFORMAT_RGBA:default:return this._gl.RGBA32F}case u.a.TEXTURETYPE_HALF_FLOAT:switch(t){case u.a.TEXTUREFORMAT_RED:return this._gl.R16F;case u.a.TEXTUREFORMAT_RG:return this._gl.RG16F;case u.a.TEXTUREFORMAT_RGB:return this._gl.RGB16F;case u.a.TEXTUREFORMAT_RGBA:default:return this._gl.RGBA16F}case u.a.TEXTURETYPE_UNSIGNED_SHORT_5_6_5:return this._gl.RGB565;case u.a.TEXTURETYPE_UNSIGNED_INT_10F_11F_11F_REV:return this._gl.R11F_G11F_B10F;case u.a.TEXTURETYPE_UNSIGNED_INT_5_9_9_9_REV:return this._gl.RGB9_E5;case u.a.TEXTURETYPE_UNSIGNED_SHORT_4_4_4_4:return this._gl.RGBA4;case u.a.TEXTURETYPE_UNSIGNED_SHORT_5_5_5_1:return this._gl.RGB5_A1;case u.a.TEXTURETYPE_UNSIGNED_INT_2_10_10_10_REV:switch(t){case u.a.TEXTUREFORMAT_RGBA:return this._gl.RGB10_A2;case u.a.TEXTUREFORMAT_RGBA_INTEGER:return this._gl.RGB10_A2UI;default:return this._gl.RGB10_A2}}return this._gl.RGBA8},e.prototype._getRGBAMultiSampleBufferFormat=function(e){return e===u.a.TEXTURETYPE_FLOAT?this._gl.RGBA32F:e===u.a.TEXTURETYPE_HALF_FLOAT?this._gl.RGBA16F:this._gl.RGBA8},e.prototype._loadFile=function(t,i,n,r,o,a){var s=this,c=e._FileToolsLoadFile(t,i,n,r,o,a);return this._activeRequests.push(c),c.onCompleteObservable.add(function(e){s._activeRequests.splice(s._activeRequests.indexOf(e),1)}),c},e._FileToolsLoadFile=function(e,t,i,n,r,a){throw o.a.WarnImport("FileTools")},e.prototype.readPixels=function(e,t,i,n,r){void 0===r&&(r=!0);var o=r?4:3,a=r?this._gl.RGBA:this._gl.RGB,s=new Uint8Array(n*i*o);return this._gl.readPixels(e,t,i,n,a,this._gl.UNSIGNED_BYTE,s),s},e.isSupported=function(){if(null===this._isSupported)try{var e=g.a.CreateCanvas(1,1),t=e.getContext("webgl")||e.getContext("experimental-webgl");this._isSupported=null!=t&&!!window.WebGLRenderingContext}catch(e){this._isSupported=!1}return this._isSupported},e.CeilingPOT=function(e){return e--,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e},e.FloorPOT=function(e){return e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,(e|=e>>16)-(e>>1)},e.NearestPOT=function(t){var i=e.CeilingPOT(t),n=e.FloorPOT(t);return i-t>t-n?n:i},e.GetExponentOfTwo=function(t,i,n){var r;switch(void 0===n&&(n=u.a.SCALEMODE_NEAREST),n){case u.a.SCALEMODE_FLOOR:r=e.FloorPOT(t);break;case u.a.SCALEMODE_NEAREST:r=e.NearestPOT(t);break;case u.a.SCALEMODE_CEILING:default:r=e.CeilingPOT(t)}return Math.min(r,i)},e.QueueNewFrame=function(e,t){return f.a.IsWindowObjectExist()?(t||(t=window),t.requestAnimationFrame?t.requestAnimationFrame(e):t.msRequestAnimationFrame?t.msRequestAnimationFrame(e):t.webkitRequestAnimationFrame?t.webkitRequestAnimationFrame(e):t.mozRequestAnimationFrame?t.mozRequestAnimationFrame(e):t.oRequestAnimationFrame?t.oRequestAnimationFrame(e):window.setTimeout(e,16)):"undefined"!=typeof requestAnimationFrame?requestAnimationFrame(e):setTimeout(e,16)},e.prototype.getHostDocument=function(){return this._renderingCanvas&&this._renderingCanvas.ownerDocument?this._renderingCanvas.ownerDocument:document},e.ExceptionList=[{key:"Chrome/63.0",capture:"63\\.0\\.3239\\.(\\d+)",captureConstraint:108,targets:["uniformBuffer"]},{key:"Firefox/58",capture:null,captureConstraint:null,targets:["uniformBuffer"]},{key:"Firefox/59",capture:null,captureConstraint:null,targets:["uniformBuffer"]},{key:"Chrome/72.+?Mobile",capture:null,captureConstraint:null,targets:["vao"]},{key:"Chrome/73.+?Mobile",capture:null,captureConstraint:null,targets:["vao"]},{key:"Chrome/74.+?Mobile",capture:null,captureConstraint:null,targets:["vao"]},{key:"Mac OS.+Chrome/71",capture:null,captureConstraint:null,targets:["vao"]},{key:"Mac OS.+Chrome/72",capture:null,captureConstraint:null,targets:["vao"]}],e._TextureLoaders=[],e.CollisionsEpsilon=.001,e._isSupported=null,e}()},function(e,t,i){"use strict";var n=i(1),r=i(3),o=i(34),a=i(18),s=i(0),c=i(10),l=i(4),u=i(40),h=i(73),d=i(81),f=i(16),p=i(9),_=i(12),m=i(21),g=i(8),v="uniform vec4 vDiffuseColor;\n#ifdef SPECULARTERM\nuniform vec4 vSpecularColor;\n#endif\nuniform vec3 vEmissiveColor;\nuniform float visibility;\n\n#ifdef DIFFUSE\nuniform vec2 vDiffuseInfos;\n#endif\n#ifdef AMBIENT\nuniform vec2 vAmbientInfos;\n#endif\n#ifdef OPACITY\nuniform vec2 vOpacityInfos;\n#endif\n#ifdef EMISSIVE\nuniform vec2 vEmissiveInfos;\n#endif\n#ifdef LIGHTMAP\nuniform vec2 vLightmapInfos;\n#endif\n#ifdef BUMP\nuniform vec3 vBumpInfos;\nuniform vec2 vTangentSpaceParams;\n#endif\n#if defined(REFLECTIONMAP_SPHERICAL) || defined(REFLECTIONMAP_PROJECTION) || defined(REFRACTION)\nuniform mat4 view;\n#endif\n#ifdef REFRACTION\nuniform vec4 vRefractionInfos;\n#ifndef REFRACTIONMAP_3D\nuniform mat4 refractionMatrix;\n#endif\n#ifdef REFRACTIONFRESNEL\nuniform vec4 refractionLeftColor;\nuniform vec4 refractionRightColor;\n#endif\n#endif\n#if defined(SPECULAR) && defined(SPECULARTERM)\nuniform vec2 vSpecularInfos;\n#endif\n#ifdef DIFFUSEFRESNEL\nuniform vec4 diffuseLeftColor;\nuniform vec4 diffuseRightColor;\n#endif\n#ifdef OPACITYFRESNEL\nuniform vec4 opacityParts;\n#endif\n#ifdef EMISSIVEFRESNEL\nuniform vec4 emissiveLeftColor;\nuniform vec4 emissiveRightColor;\n#endif\n\n#ifdef REFLECTION\nuniform vec2 vReflectionInfos;\n#if defined(REFLECTIONMAP_PLANAR) || defined(REFLECTIONMAP_CUBIC) || defined(REFLECTIONMAP_PROJECTION) || defined(REFLECTIONMAP_EQUIRECTANGULAR) || defined(REFLECTIONMAP_SPHERICAL) || defined(REFLECTIONMAP_SKYBOX)\nuniform mat4 reflectionMatrix;\n#endif\n#ifndef REFLECTIONMAP_SKYBOX\n#if defined(USE_LOCAL_REFLECTIONMAP_CUBIC) && defined(REFLECTIONMAP_CUBIC)\nuniform vec3 vReflectionPosition;\nuniform vec3 vReflectionSize;\n#endif\n#endif\n#ifdef REFLECTIONFRESNEL\nuniform vec4 reflectionLeftColor;\nuniform vec4 reflectionRightColor;\n#endif\n#endif";g.a.IncludesShadersStore.defaultFragmentDeclaration=v;var y="layout(std140,column_major) uniform;\nuniform Material\n{\nvec4 diffuseLeftColor;\nvec4 diffuseRightColor;\nvec4 opacityParts;\nvec4 reflectionLeftColor;\nvec4 reflectionRightColor;\nvec4 refractionLeftColor;\nvec4 refractionRightColor;\nvec4 emissiveLeftColor;\nvec4 emissiveRightColor;\nvec2 vDiffuseInfos;\nvec2 vAmbientInfos;\nvec2 vOpacityInfos;\nvec2 vReflectionInfos;\nvec3 vReflectionPosition;\nvec3 vReflectionSize;\nvec2 vEmissiveInfos;\nvec2 vLightmapInfos;\nvec2 vSpecularInfos;\nvec3 vBumpInfos;\nmat4 diffuseMatrix;\nmat4 ambientMatrix;\nmat4 opacityMatrix;\nmat4 reflectionMatrix;\nmat4 emissiveMatrix;\nmat4 lightmapMatrix;\nmat4 specularMatrix;\nmat4 bumpMatrix;\nvec2 vTangentSpaceParams;\nfloat pointSize;\nmat4 refractionMatrix;\nvec4 vRefractionInfos;\nvec4 vSpecularColor;\nvec3 vEmissiveColor;\nfloat visibility;\nvec4 vDiffuseColor;\n};\nuniform Scene {\nmat4 viewProjection;\n#ifdef MULTIVIEW\nmat4 viewProjectionR;\n#endif\nmat4 view;\n};\n";g.a.IncludesShadersStore.defaultUboDeclaration=y;i(58),i(97),i(98),i(139),i(117),i(145),i(118),i(99),i(100),i(119),i(106),i(107),i(113),i(101),i(120),i(146),i(121),i(140),i(122);var b="#include<__decl__defaultFragment>\n#if defined(BUMP) || !defined(NORMAL)\n#extension GL_OES_standard_derivatives : enable\n#endif\n#define CUSTOM_FRAGMENT_BEGIN\n#ifdef LOGARITHMICDEPTH\n#extension GL_EXT_frag_depth : enable\n#endif\n\n#define RECIPROCAL_PI2 0.15915494\nuniform vec3 vEyePosition;\nuniform vec3 vAmbientColor;\n\nvarying vec3 vPositionW;\n#ifdef NORMAL\nvarying vec3 vNormalW;\n#endif\n#ifdef VERTEXCOLOR\nvarying vec4 vColor;\n#endif\n#ifdef MAINUV1\nvarying vec2 vMainUV1;\n#endif\n#ifdef MAINUV2\nvarying vec2 vMainUV2;\n#endif\n\n#include<helperFunctions>\n\n#include<__decl__lightFragment>[0..maxSimultaneousLights]\n#include<lightsFragmentFunctions>\n#include<shadowsFragmentFunctions>\n\n#ifdef DIFFUSE\n#if DIFFUSEDIRECTUV == 1\n#define vDiffuseUV vMainUV1\n#elif DIFFUSEDIRECTUV == 2\n#define vDiffuseUV vMainUV2\n#else\nvarying vec2 vDiffuseUV;\n#endif\nuniform sampler2D diffuseSampler;\n#endif\n#ifdef AMBIENT\n#if AMBIENTDIRECTUV == 1\n#define vAmbientUV vMainUV1\n#elif AMBIENTDIRECTUV == 2\n#define vAmbientUV vMainUV2\n#else\nvarying vec2 vAmbientUV;\n#endif\nuniform sampler2D ambientSampler;\n#endif\n#ifdef OPACITY\n#if OPACITYDIRECTUV == 1\n#define vOpacityUV vMainUV1\n#elif OPACITYDIRECTUV == 2\n#define vOpacityUV vMainUV2\n#else\nvarying vec2 vOpacityUV;\n#endif\nuniform sampler2D opacitySampler;\n#endif\n#ifdef EMISSIVE\n#if EMISSIVEDIRECTUV == 1\n#define vEmissiveUV vMainUV1\n#elif EMISSIVEDIRECTUV == 2\n#define vEmissiveUV vMainUV2\n#else\nvarying vec2 vEmissiveUV;\n#endif\nuniform sampler2D emissiveSampler;\n#endif\n#ifdef LIGHTMAP\n#if LIGHTMAPDIRECTUV == 1\n#define vLightmapUV vMainUV1\n#elif LIGHTMAPDIRECTUV == 2\n#define vLightmapUV vMainUV2\n#else\nvarying vec2 vLightmapUV;\n#endif\nuniform sampler2D lightmapSampler;\n#endif\n#ifdef REFRACTION\n#ifdef REFRACTIONMAP_3D\nuniform samplerCube refractionCubeSampler;\n#else\nuniform sampler2D refraction2DSampler;\n#endif\n#endif\n#if defined(SPECULAR) && defined(SPECULARTERM)\n#if SPECULARDIRECTUV == 1\n#define vSpecularUV vMainUV1\n#elif SPECULARDIRECTUV == 2\n#define vSpecularUV vMainUV2\n#else\nvarying vec2 vSpecularUV;\n#endif\nuniform sampler2D specularSampler;\n#endif\n#ifdef ALPHATEST\nuniform float alphaCutOff;\n#endif\n\n#include<fresnelFunction>\n\n#ifdef REFLECTION\n#ifdef REFLECTIONMAP_3D\nuniform samplerCube reflectionCubeSampler;\n#else\nuniform sampler2D reflection2DSampler;\n#endif\n#ifdef REFLECTIONMAP_SKYBOX\nvarying vec3 vPositionUVW;\n#else\n#if defined(REFLECTIONMAP_EQUIRECTANGULAR_FIXED) || defined(REFLECTIONMAP_MIRROREDEQUIRECTANGULAR_FIXED)\nvarying vec3 vDirectionW;\n#endif\n#endif\n#include<reflectionFunction>\n#endif\n#include<imageProcessingDeclaration>\n#include<imageProcessingFunctions>\n#include<bumpFragmentFunctions>\n#include<clipPlaneFragmentDeclaration>\n#include<logDepthDeclaration>\n#include<fogFragmentDeclaration>\n#define CUSTOM_FRAGMENT_DEFINITIONS\nvoid main(void) {\n#define CUSTOM_FRAGMENT_MAIN_BEGIN\n#include<clipPlaneFragment>\nvec3 viewDirectionW=normalize(vEyePosition-vPositionW);\n\nvec4 baseColor=vec4(1.,1.,1.,1.);\nvec3 diffuseColor=vDiffuseColor.rgb;\n\nfloat alpha=vDiffuseColor.a;\n\n#ifdef NORMAL\nvec3 normalW=normalize(vNormalW);\n#else\nvec3 normalW=normalize(-cross(dFdx(vPositionW),dFdy(vPositionW)));\n#endif\n#include<bumpFragment>\n#ifdef TWOSIDEDLIGHTING\nnormalW=gl_FrontFacing ? normalW : -normalW;\n#endif\n#ifdef DIFFUSE\nbaseColor=texture2D(diffuseSampler,vDiffuseUV+uvOffset);\n#ifdef ALPHATEST\nif (baseColor.a<alphaCutOff)\ndiscard;\n#endif\n#ifdef ALPHAFROMDIFFUSE\nalpha*=baseColor.a;\n#endif\n#define CUSTOM_FRAGMENT_UPDATE_ALPHA\nbaseColor.rgb*=vDiffuseInfos.y;\n#endif\n#include<depthPrePass>\n#ifdef VERTEXCOLOR\nbaseColor.rgb*=vColor.rgb;\n#endif\n#define CUSTOM_FRAGMENT_UPDATE_DIFFUSE\n\nvec3 baseAmbientColor=vec3(1.,1.,1.);\n#ifdef AMBIENT\nbaseAmbientColor=texture2D(ambientSampler,vAmbientUV+uvOffset).rgb*vAmbientInfos.y;\n#endif\n#define CUSTOM_FRAGMENT_BEFORE_LIGHTS\n\n#ifdef SPECULARTERM\nfloat glossiness=vSpecularColor.a;\nvec3 specularColor=vSpecularColor.rgb;\n#ifdef SPECULAR\nvec4 specularMapColor=texture2D(specularSampler,vSpecularUV+uvOffset);\nspecularColor=specularMapColor.rgb;\n#ifdef GLOSSINESS\nglossiness=glossiness*specularMapColor.a;\n#endif\n#endif\n#else\nfloat glossiness=0.;\n#endif\n\nvec3 diffuseBase=vec3(0.,0.,0.);\nlightingInfo info;\n#ifdef SPECULARTERM\nvec3 specularBase=vec3(0.,0.,0.);\n#endif\nfloat shadow=1.;\n#ifdef LIGHTMAP\nvec3 lightmapColor=texture2D(lightmapSampler,vLightmapUV+uvOffset).rgb*vLightmapInfos.y;\n#endif\n#include<lightFragment>[0..maxSimultaneousLights]\n\nvec3 refractionColor=vec3(0.,0.,0.);\n#ifdef REFRACTION\nvec3 refractionVector=normalize(refract(-viewDirectionW,normalW,vRefractionInfos.y));\n#ifdef REFRACTIONMAP_3D\nrefractionVector.y=refractionVector.y*vRefractionInfos.w;\nif (dot(refractionVector,viewDirectionW)<1.0) {\nrefractionColor=textureCube(refractionCubeSampler,refractionVector).rgb;\n}\n#else\nvec3 vRefractionUVW=vec3(refractionMatrix*(view*vec4(vPositionW+refractionVector*vRefractionInfos.z,1.0)));\nvec2 refractionCoords=vRefractionUVW.xy/vRefractionUVW.z;\nrefractionCoords.y=1.0-refractionCoords.y;\nrefractionColor=texture2D(refraction2DSampler,refractionCoords).rgb;\n#endif\n#ifdef IS_REFRACTION_LINEAR\nrefractionColor=toGammaSpace(refractionColor);\n#endif\nrefractionColor*=vRefractionInfos.x;\n#endif\n\nvec3 reflectionColor=vec3(0.,0.,0.);\n#ifdef REFLECTION\nvec3 vReflectionUVW=computeReflectionCoords(vec4(vPositionW,1.0),normalW);\n#ifdef REFLECTIONMAP_3D\n#ifdef ROUGHNESS\nfloat bias=vReflectionInfos.y;\n#ifdef SPECULARTERM\n#ifdef SPECULAR\n#ifdef GLOSSINESS\nbias*=(1.0-specularMapColor.a);\n#endif\n#endif\n#endif\nreflectionColor=textureCube(reflectionCubeSampler,vReflectionUVW,bias).rgb;\n#else\nreflectionColor=textureCube(reflectionCubeSampler,vReflectionUVW).rgb;\n#endif\n#else\nvec2 coords=vReflectionUVW.xy;\n#ifdef REFLECTIONMAP_PROJECTION\ncoords/=vReflectionUVW.z;\n#endif\ncoords.y=1.0-coords.y;\nreflectionColor=texture2D(reflection2DSampler,coords).rgb;\n#endif\n#ifdef IS_REFLECTION_LINEAR\nreflectionColor=toGammaSpace(reflectionColor);\n#endif\nreflectionColor*=vReflectionInfos.x;\n#ifdef REFLECTIONFRESNEL\nfloat reflectionFresnelTerm=computeFresnelTerm(viewDirectionW,normalW,reflectionRightColor.a,reflectionLeftColor.a);\n#ifdef REFLECTIONFRESNELFROMSPECULAR\n#ifdef SPECULARTERM\nreflectionColor*=specularColor.rgb*(1.0-reflectionFresnelTerm)+reflectionFresnelTerm*reflectionRightColor.rgb;\n#else\nreflectionColor*=reflectionLeftColor.rgb*(1.0-reflectionFresnelTerm)+reflectionFresnelTerm*reflectionRightColor.rgb;\n#endif\n#else\nreflectionColor*=reflectionLeftColor.rgb*(1.0-reflectionFresnelTerm)+reflectionFresnelTerm*reflectionRightColor.rgb;\n#endif\n#endif\n#endif\n#ifdef REFRACTIONFRESNEL\nfloat refractionFresnelTerm=computeFresnelTerm(viewDirectionW,normalW,refractionRightColor.a,refractionLeftColor.a);\nrefractionColor*=refractionLeftColor.rgb*(1.0-refractionFresnelTerm)+refractionFresnelTerm*refractionRightColor.rgb;\n#endif\n#ifdef OPACITY\nvec4 opacityMap=texture2D(opacitySampler,vOpacityUV+uvOffset);\n#ifdef OPACITYRGB\nopacityMap.rgb=opacityMap.rgb*vec3(0.3,0.59,0.11);\nalpha*=(opacityMap.x+opacityMap.y+opacityMap.z)* vOpacityInfos.y;\n#else\nalpha*=opacityMap.a*vOpacityInfos.y;\n#endif\n#endif\n#ifdef VERTEXALPHA\nalpha*=vColor.a;\n#endif\n#ifdef OPACITYFRESNEL\nfloat opacityFresnelTerm=computeFresnelTerm(viewDirectionW,normalW,opacityParts.z,opacityParts.w);\nalpha+=opacityParts.x*(1.0-opacityFresnelTerm)+opacityFresnelTerm*opacityParts.y;\n#endif\n\nvec3 emissiveColor=vEmissiveColor;\n#ifdef EMISSIVE\nemissiveColor+=texture2D(emissiveSampler,vEmissiveUV+uvOffset).rgb*vEmissiveInfos.y;\n#endif\n#ifdef EMISSIVEFRESNEL\nfloat emissiveFresnelTerm=computeFresnelTerm(viewDirectionW,normalW,emissiveRightColor.a,emissiveLeftColor.a);\nemissiveColor*=emissiveLeftColor.rgb*(1.0-emissiveFresnelTerm)+emissiveFresnelTerm*emissiveRightColor.rgb;\n#endif\n\n#ifdef DIFFUSEFRESNEL\nfloat diffuseFresnelTerm=computeFresnelTerm(viewDirectionW,normalW,diffuseRightColor.a,diffuseLeftColor.a);\ndiffuseBase*=diffuseLeftColor.rgb*(1.0-diffuseFresnelTerm)+diffuseFresnelTerm*diffuseRightColor.rgb;\n#endif\n\n#ifdef EMISSIVEASILLUMINATION\nvec3 finalDiffuse=clamp(diffuseBase*diffuseColor+vAmbientColor,0.0,1.0)*baseColor.rgb;\n#else\n#ifdef LINKEMISSIVEWITHDIFFUSE\nvec3 finalDiffuse=clamp((diffuseBase+emissiveColor)*diffuseColor+vAmbientColor,0.0,1.0)*baseColor.rgb;\n#else\nvec3 finalDiffuse=clamp(diffuseBase*diffuseColor+emissiveColor+vAmbientColor,0.0,1.0)*baseColor.rgb;\n#endif\n#endif\n#ifdef SPECULARTERM\nvec3 finalSpecular=specularBase*specularColor;\n#ifdef SPECULAROVERALPHA\nalpha=clamp(alpha+dot(finalSpecular,vec3(0.3,0.59,0.11)),0.,1.);\n#endif\n#else\nvec3 finalSpecular=vec3(0.0);\n#endif\n#ifdef REFLECTIONOVERALPHA\nalpha=clamp(alpha+dot(reflectionColor,vec3(0.3,0.59,0.11)),0.,1.);\n#endif\n\n#ifdef EMISSIVEASILLUMINATION\nvec4 color=vec4(clamp(finalDiffuse*baseAmbientColor+finalSpecular+reflectionColor+emissiveColor+refractionColor,0.0,1.0),alpha);\n#else\nvec4 color=vec4(finalDiffuse*baseAmbientColor+finalSpecular+reflectionColor+refractionColor,alpha);\n#endif\n\n#ifdef LIGHTMAP\n#ifndef LIGHTMAPEXCLUDED\n#ifdef USELIGHTMAPASSHADOWMAP\ncolor.rgb*=lightmapColor;\n#else\ncolor.rgb+=lightmapColor;\n#endif\n#endif\n#endif\n#define CUSTOM_FRAGMENT_BEFORE_FOG\ncolor.rgb=max(color.rgb,0.);\n#include<logDepthFragment>\n#include<fogFragment>\n\n\n#ifdef IMAGEPROCESSINGPOSTPROCESS\ncolor.rgb=toLinearSpace(color.rgb);\n#else\n#ifdef IMAGEPROCESSING\ncolor.rgb=toLinearSpace(color.rgb);\ncolor=applyImageProcessing(color);\n#endif\n#endif\ncolor.a*=visibility;\n#ifdef PREMULTIPLYALPHA\n\ncolor.rgb*=color.a;\n#endif\n#define CUSTOM_FRAGMENT_BEFORE_FRAGCOLOR\ngl_FragColor=color;\n}\n";g.a.ShadersStore.defaultPixelShader=b;var T="\nuniform mat4 viewProjection;\nuniform mat4 view;\n#ifdef DIFFUSE\nuniform mat4 diffuseMatrix;\nuniform vec2 vDiffuseInfos;\n#endif\n#ifdef AMBIENT\nuniform mat4 ambientMatrix;\nuniform vec2 vAmbientInfos;\n#endif\n#ifdef OPACITY\nuniform mat4 opacityMatrix;\nuniform vec2 vOpacityInfos;\n#endif\n#ifdef EMISSIVE\nuniform vec2 vEmissiveInfos;\nuniform mat4 emissiveMatrix;\n#endif\n#ifdef LIGHTMAP\nuniform vec2 vLightmapInfos;\nuniform mat4 lightmapMatrix;\n#endif\n#if defined(SPECULAR) && defined(SPECULARTERM)\nuniform vec2 vSpecularInfos;\nuniform mat4 specularMatrix;\n#endif\n#ifdef BUMP\nuniform vec3 vBumpInfos;\nuniform mat4 bumpMatrix;\n#endif\n#ifdef REFLECTION\nuniform mat4 reflectionMatrix;\n#endif\n#ifdef POINTSIZE\nuniform float pointSize;\n#endif\n";g.a.IncludesShadersStore.defaultVertexDeclaration=T;i(74),i(77),i(147),i(108),i(123),i(88),i(89),i(94),i(78),i(75),i(141),i(102),i(142),i(124);g.a.IncludesShadersStore.pointCloudVertex="#ifdef POINTSIZE\ngl_PointSize=pointSize;\n#endif";i(143);var E="#include<__decl__defaultVertex>\n\n#define CUSTOM_VERTEX_BEGIN\nattribute vec3 position;\n#ifdef NORMAL\nattribute vec3 normal;\n#endif\n#ifdef TANGENT\nattribute vec4 tangent;\n#endif\n#ifdef UV1\nattribute vec2 uv;\n#endif\n#ifdef UV2\nattribute vec2 uv2;\n#endif\n#ifdef VERTEXCOLOR\nattribute vec4 color;\n#endif\n#include<helperFunctions>\n#include<bonesDeclaration>\n\n#include<instancesDeclaration>\n#ifdef MAINUV1\nvarying vec2 vMainUV1;\n#endif\n#ifdef MAINUV2\nvarying vec2 vMainUV2;\n#endif\n#if defined(DIFFUSE) && DIFFUSEDIRECTUV == 0\nvarying vec2 vDiffuseUV;\n#endif\n#if defined(AMBIENT) && AMBIENTDIRECTUV == 0\nvarying vec2 vAmbientUV;\n#endif\n#if defined(OPACITY) && OPACITYDIRECTUV == 0\nvarying vec2 vOpacityUV;\n#endif\n#if defined(EMISSIVE) && EMISSIVEDIRECTUV == 0\nvarying vec2 vEmissiveUV;\n#endif\n#if defined(LIGHTMAP) && LIGHTMAPDIRECTUV == 0\nvarying vec2 vLightmapUV;\n#endif\n#if defined(SPECULAR) && defined(SPECULARTERM) && SPECULARDIRECTUV == 0\nvarying vec2 vSpecularUV;\n#endif\n#if defined(BUMP) && BUMPDIRECTUV == 0\nvarying vec2 vBumpUV;\n#endif\n\nvarying vec3 vPositionW;\n#ifdef NORMAL\nvarying vec3 vNormalW;\n#endif\n#ifdef VERTEXCOLOR\nvarying vec4 vColor;\n#endif\n#include<bumpVertexDeclaration>\n#include<clipPlaneVertexDeclaration>\n#include<fogVertexDeclaration>\n#include<__decl__lightFragment>[0..maxSimultaneousLights]\n#include<morphTargetsVertexGlobalDeclaration>\n#include<morphTargetsVertexDeclaration>[0..maxSimultaneousMorphTargets]\n#ifdef REFLECTIONMAP_SKYBOX\nvarying vec3 vPositionUVW;\n#endif\n#if defined(REFLECTIONMAP_EQUIRECTANGULAR_FIXED) || defined(REFLECTIONMAP_MIRROREDEQUIRECTANGULAR_FIXED)\nvarying vec3 vDirectionW;\n#endif\n#include<logDepthDeclaration>\n#define CUSTOM_VERTEX_DEFINITIONS\nvoid main(void) {\n#define CUSTOM_VERTEX_MAIN_BEGIN\nvec3 positionUpdated=position;\n#ifdef NORMAL\nvec3 normalUpdated=normal;\n#endif\n#ifdef TANGENT\nvec4 tangentUpdated=tangent;\n#endif\n#ifdef UV1\nvec2 uvUpdated=uv;\n#endif\n#include<morphTargetsVertex>[0..maxSimultaneousMorphTargets]\n#ifdef REFLECTIONMAP_SKYBOX\nvPositionUVW=positionUpdated;\n#endif\n#define CUSTOM_VERTEX_UPDATE_POSITION\n#define CUSTOM_VERTEX_UPDATE_NORMAL\n#include<instancesVertex>\n#include<bonesVertex>\nvec4 worldPos=finalWorld*vec4(positionUpdated,1.0);\n#ifdef MULTIVIEW\nif (gl_ViewID_OVR == 0u) {\ngl_Position=viewProjection*worldPos;\n} else {\ngl_Position=viewProjectionR*worldPos;\n}\n#else\ngl_Position=viewProjection*worldPos;\n#endif\nvPositionW=vec3(worldPos);\n#ifdef NORMAL\nmat3 normalWorld=mat3(finalWorld);\n#ifdef NONUNIFORMSCALING\nnormalWorld=transposeMat3(inverseMat3(normalWorld));\n#endif\nvNormalW=normalize(normalWorld*normalUpdated);\n#endif\n#if defined(REFLECTIONMAP_EQUIRECTANGULAR_FIXED) || defined(REFLECTIONMAP_MIRROREDEQUIRECTANGULAR_FIXED)\nvDirectionW=normalize(vec3(finalWorld*vec4(positionUpdated,0.0)));\n#endif\n\n#ifndef UV1\nvec2 uvUpdated=vec2(0.,0.);\n#endif\n#ifndef UV2\nvec2 uv2=vec2(0.,0.);\n#endif\n#ifdef MAINUV1\nvMainUV1=uvUpdated;\n#endif\n#ifdef MAINUV2\nvMainUV2=uv2;\n#endif\n#if defined(DIFFUSE) && DIFFUSEDIRECTUV == 0\nif (vDiffuseInfos.x == 0.)\n{\nvDiffuseUV=vec2(diffuseMatrix*vec4(uvUpdated,1.0,0.0));\n}\nelse\n{\nvDiffuseUV=vec2(diffuseMatrix*vec4(uv2,1.0,0.0));\n}\n#endif\n#if defined(AMBIENT) && AMBIENTDIRECTUV == 0\nif (vAmbientInfos.x == 0.)\n{\nvAmbientUV=vec2(ambientMatrix*vec4(uvUpdated,1.0,0.0));\n}\nelse\n{\nvAmbientUV=vec2(ambientMatrix*vec4(uv2,1.0,0.0));\n}\n#endif\n#if defined(OPACITY) && OPACITYDIRECTUV == 0\nif (vOpacityInfos.x == 0.)\n{\nvOpacityUV=vec2(opacityMatrix*vec4(uvUpdated,1.0,0.0));\n}\nelse\n{\nvOpacityUV=vec2(opacityMatrix*vec4(uv2,1.0,0.0));\n}\n#endif\n#if defined(EMISSIVE) && EMISSIVEDIRECTUV == 0\nif (vEmissiveInfos.x == 0.)\n{\nvEmissiveUV=vec2(emissiveMatrix*vec4(uvUpdated,1.0,0.0));\n}\nelse\n{\nvEmissiveUV=vec2(emissiveMatrix*vec4(uv2,1.0,0.0));\n}\n#endif\n#if defined(LIGHTMAP) && LIGHTMAPDIRECTUV == 0\nif (vLightmapInfos.x == 0.)\n{\nvLightmapUV=vec2(lightmapMatrix*vec4(uvUpdated,1.0,0.0));\n}\nelse\n{\nvLightmapUV=vec2(lightmapMatrix*vec4(uv2,1.0,0.0));\n}\n#endif\n#if defined(SPECULAR) && defined(SPECULARTERM) && SPECULARDIRECTUV == 0\nif (vSpecularInfos.x == 0.)\n{\nvSpecularUV=vec2(specularMatrix*vec4(uvUpdated,1.0,0.0));\n}\nelse\n{\nvSpecularUV=vec2(specularMatrix*vec4(uv2,1.0,0.0));\n}\n#endif\n#if defined(BUMP) && BUMPDIRECTUV == 0\nif (vBumpInfos.x == 0.)\n{\nvBumpUV=vec2(bumpMatrix*vec4(uvUpdated,1.0,0.0));\n}\nelse\n{\nvBumpUV=vec2(bumpMatrix*vec4(uv2,1.0,0.0));\n}\n#endif\n#include<bumpVertex>\n#include<clipPlaneVertex>\n#include<fogVertex>\n#include<shadowsVertex>[0..maxSimultaneousLights]\n#ifdef VERTEXCOLOR\n\nvColor=color;\n#endif\n#include<pointCloudVertex>\n#include<logDepthVertex>\n#define CUSTOM_VERTEX_MAIN_END\n}\n";g.a.ShadersStore.defaultVertexShader=E;var x=i(2),P=i(64);i.d(t,"b",function(){return A}),i.d(t,"a",function(){return S});var A=function(e){function t(){var t=e.call(this)||this;return t.MAINUV1=!1,t.MAINUV2=!1,t.DIFFUSE=!1,t.DIFFUSEDIRECTUV=0,t.AMBIENT=!1,t.AMBIENTDIRECTUV=0,t.OPACITY=!1,t.OPACITYDIRECTUV=0,t.OPACITYRGB=!1,t.REFLECTION=!1,t.EMISSIVE=!1,t.EMISSIVEDIRECTUV=0,t.SPECULAR=!1,t.SPECULARDIRECTUV=0,t.BUMP=!1,t.BUMPDIRECTUV=0,t.PARALLAX=!1,t.PARALLAXOCCLUSION=!1,t.SPECULAROVERALPHA=!1,t.CLIPPLANE=!1,t.CLIPPLANE2=!1,t.CLIPPLANE3=!1,t.CLIPPLANE4=!1,t.CLIPPLANE5=!1,t.CLIPPLANE6=!1,t.ALPHATEST=!1,t.DEPTHPREPASS=!1,t.ALPHAFROMDIFFUSE=!1,t.POINTSIZE=!1,t.FOG=!1,t.SPECULARTERM=!1,t.DIFFUSEFRESNEL=!1,t.OPACITYFRESNEL=!1,t.REFLECTIONFRESNEL=!1,t.REFRACTIONFRESNEL=!1,t.EMISSIVEFRESNEL=!1,t.FRESNEL=!1,t.NORMAL=!1,t.UV1=!1,t.UV2=!1,t.VERTEXCOLOR=!1,t.VERTEXALPHA=!1,t.NUM_BONE_INFLUENCERS=0,t.BonesPerMesh=0,t.BONETEXTURE=!1,t.INSTANCES=!1,t.GLOSSINESS=!1,t.ROUGHNESS=!1,t.EMISSIVEASILLUMINATION=!1,t.LINKEMISSIVEWITHDIFFUSE=!1,t.REFLECTIONFRESNELFROMSPECULAR=!1,t.LIGHTMAP=!1,t.LIGHTMAPDIRECTUV=0,t.OBJECTSPACE_NORMALMAP=!1,t.USELIGHTMAPASSHADOWMAP=!1,t.REFLECTIONMAP_3D=!1,t.REFLECTIONMAP_SPHERICAL=!1,t.REFLECTIONMAP_PLANAR=!1,t.REFLECTIONMAP_CUBIC=!1,t.USE_LOCAL_REFLECTIONMAP_CUBIC=!1,t.REFLECTIONMAP_PROJECTION=!1,t.REFLECTIONMAP_SKYBOX=!1,t.REFLECTIONMAP_EXPLICIT=!1,t.REFLECTIONMAP_EQUIRECTANGULAR=!1,t.REFLECTIONMAP_EQUIRECTANGULAR_FIXED=!1,t.REFLECTIONMAP_MIRROREDEQUIRECTANGULAR_FIXED=!1,t.INVERTCUBICMAP=!1,t.LOGARITHMICDEPTH=!1,t.REFRACTION=!1,t.REFRACTIONMAP_3D=!1,t.REFLECTIONOVERALPHA=!1,t.TWOSIDEDLIGHTING=!1,t.SHADOWFLOAT=!1,t.MORPHTARGETS=!1,t.MORPHTARGETS_NORMAL=!1,t.MORPHTARGETS_TANGENT=!1,t.MORPHTARGETS_UV=!1,t.NUM_MORPH_INFLUENCERS=0,t.NONUNIFORMSCALING=!1,t.PREMULTIPLYALPHA=!1,t.IMAGEPROCESSING=!1,t.VIGNETTE=!1,t.VIGNETTEBLENDMODEMULTIPLY=!1,t.VIGNETTEBLENDMODEOPAQUE=!1,t.TONEMAPPING=!1,t.TONEMAPPING_ACES=!1,t.CONTRAST=!1,t.COLORCURVES=!1,t.COLORGRADING=!1,t.COLORGRADING3D=!1,t.SAMPLER3DGREENDEPTH=!1,t.SAMPLER3DBGRMAP=!1,t.IMAGEPROCESSINGPOSTPROCESS=!1,t.MULTIVIEW=!1,t.IS_REFLECTION_LINEAR=!1,t.IS_REFRACTION_LINEAR=!1,t.EXPOSURE=!1,t.rebuild(),t}return Object(n.d)(t,e),t.prototype.setReflectionMode=function(e){for(var t=0,i=["REFLECTIONMAP_CUBIC","REFLECTIONMAP_EXPLICIT","REFLECTIONMAP_PLANAR","REFLECTIONMAP_PROJECTION","REFLECTIONMAP_PROJECTION","REFLECTIONMAP_SKYBOX","REFLECTIONMAP_SPHERICAL","REFLECTIONMAP_EQUIRECTANGULAR","REFLECTIONMAP_EQUIRECTANGULAR_FIXED","REFLECTIONMAP_MIRROREDEQUIRECTANGULAR_FIXED"];t<i.length;t++){var n=i[t];this[n]=n===e}},t}(h.a),S=function(e){function t(i,n){var r=e.call(this,i,n)||this;return r._diffuseTexture=null,r._ambientTexture=null,r._opacityTexture=null,r._reflectionTexture=null,r._emissiveTexture=null,r._specularTexture=null,r._bumpTexture=null,r._lightmapTexture=null,r._refractionTexture=null,r.ambientColor=new c.a(0,0,0),r.diffuseColor=new c.a(1,1,1),r.specularColor=new c.a(1,1,1),r.emissiveColor=new c.a(0,0,0),r.specularPower=64,r._useAlphaFromDiffuseTexture=!1,r._useEmissiveAsIllumination=!1,r._linkEmissiveWithDiffuse=!1,r._useSpecularOverAlpha=!1,r._useReflectionOverAlpha=!1,r._disableLighting=!1,r._useObjectSpaceNormalMap=!1,r._useParallax=!1,r._useParallaxOcclusion=!1,r.parallaxScaleBias=.05,r._roughness=0,r.indexOfRefraction=.98,r.invertRefractionY=!0,r.alphaCutOff=.4,r._useLightmapAsShadowmap=!1,r._useReflectionFresnelFromSpecular=!1,r._useGlossinessFromSpecularMapAlpha=!1,r._maxSimultaneousLights=4,r._invertNormalMapX=!1,r._invertNormalMapY=!1,r._twoSidedLighting=!1,r._renderTargets=new o.a(16),r._worldViewProjectionMatrix=s.a.Zero(),r._globalAmbientColor=new c.a(0,0,0),r._rebuildInParallel=!1,r._attachImageProcessingConfiguration(null),r.getRenderTargetTextures=function(){return r._renderTargets.reset(),t.ReflectionTextureEnabled&&r._reflectionTexture&&r._reflectionTexture.isRenderTarget&&r._renderTargets.push(r._reflectionTexture),t.RefractionTextureEnabled&&r._refractionTexture&&r._refractionTexture.isRenderTarget&&r._renderTargets.push(r._refractionTexture),r._renderTargets},r}return Object(n.d)(t,e),Object.defineProperty(t.prototype,"imageProcessingConfiguration",{get:function(){return this._imageProcessingConfiguration},set:function(e){this._attachImageProcessingConfiguration(e),this._markAllSubMeshesAsTexturesDirty()},enumerable:!0,configurable:!0}),t.prototype._attachImageProcessingConfiguration=function(e){var t=this;e!==this._imageProcessingConfiguration&&(this._imageProcessingConfiguration&&this._imageProcessingObserver&&this._imageProcessingConfiguration.onUpdateParameters.remove(this._imageProcessingObserver),this._imageProcessingConfiguration=e||this.getScene().imageProcessingConfiguration,this._imageProcessingConfiguration&&(this._imageProcessingObserver=this._imageProcessingConfiguration.onUpdateParameters.add(function(){t._markAllSubMeshesAsImageProcessingDirty()})))},Object.defineProperty(t.prototype,"cameraColorCurvesEnabled",{get:function(){return this.imageProcessingConfiguration.colorCurvesEnabled},set:function(e){this.imageProcessingConfiguration.colorCurvesEnabled=e},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"cameraColorGradingEnabled",{get:function(){return this.imageProcessingConfiguration.colorGradingEnabled},set:function(e){this.imageProcessingConfiguration.colorGradingEnabled=e},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"cameraToneMappingEnabled",{get:function(){return this._imageProcessingConfiguration.toneMappingEnabled},set:function(e){this._imageProcessingConfiguration.toneMappingEnabled=e},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"cameraExposure",{get:function(){return this._imageProcessingConfiguration.exposure},set:function(e){this._imageProcessingConfiguration.exposure=e},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"cameraContrast",{get:function(){return this._imageProcessingConfiguration.contrast},set:function(e){this._imageProcessingConfiguration.contrast=e},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"cameraColorGradingTexture",{get:function(){return this._imageProcessingConfiguration.colorGradingTexture},set:function(e){this._imageProcessingConfiguration.colorGradingTexture=e},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"cameraColorCurves",{get:function(){return this._imageProcessingConfiguration.colorCurves},set:function(e){this._imageProcessingConfiguration.colorCurves=e},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"hasRenderTargetTextures",{get:function(){return!!(t.ReflectionTextureEnabled&&this._reflectionTexture&&this._reflectionTexture.isRenderTarget)||!!(t.RefractionTextureEnabled&&this._refractionTexture&&this._refractionTexture.isRenderTarget)},enumerable:!0,configurable:!0}),t.prototype.getClassName=function(){return"StandardMaterial"},Object.defineProperty(t.prototype,"useLogarithmicDepth",{get:function(){return this._useLogarithmicDepth},set:function(e){this._useLogarithmicDepth=e&&this.getScene().getEngine().getCaps().fragmentDepthSupported,this._markAllSubMeshesAsMiscDirty()},enumerable:!0,configurable:!0}),t.prototype.needAlphaBlending=function(){return this.alpha<1||null!=this._opacityTexture||this._shouldUseAlphaFromDiffuseTexture()||this._opacityFresnelParameters&&this._opacityFresnelParameters.isEnabled},t.prototype.needAlphaTesting=function(){return null!=this._diffuseTexture&&this._diffuseTexture.hasAlpha},t.prototype._shouldUseAlphaFromDiffuseTexture=function(){return null!=this._diffuseTexture&&this._diffuseTexture.hasAlpha&&this._useAlphaFromDiffuseTexture},t.prototype.getAlphaTestTexture=function(){return this._diffuseTexture},t.prototype.isReadyForSubMesh=function(e,i,n){if(void 0===n&&(n=!1),i.effect&&this.isFrozen&&i.effect._wasPreviouslyReady)return!0;i._materialDefines||(i._materialDefines=new A);var r=this.getScene(),o=i._materialDefines;if(!this.checkReadyOnEveryCall&&i.effect&&o._renderId===r.getRenderId())return!0;var a=r.getEngine();if(o._needNormals=f.a.PrepareDefinesForLights(r,e,o,!0,this._maxSimultaneousLights,this._disableLighting),f.a.PrepareDefinesForMultiview(r,o),o._areTexturesDirty){if(o._needUVs=!1,o.MAINUV1=!1,o.MAINUV2=!1,r.texturesEnabled){if(this._diffuseTexture&&t.DiffuseTextureEnabled){if(!this._diffuseTexture.isReadyOrNotBlocking())return!1;f.a.PrepareDefinesForMergedUV(this._diffuseTexture,o,"DIFFUSE")}else o.DIFFUSE=!1;if(this._ambientTexture&&t.AmbientTextureEnabled){if(!this._ambientTexture.isReadyOrNotBlocking())return!1;f.a.PrepareDefinesForMergedUV(this._ambientTexture,o,"AMBIENT")}else o.AMBIENT=!1;if(this._opacityTexture&&t.OpacityTextureEnabled){if(!this._opacityTexture.isReadyOrNotBlocking())return!1;f.a.PrepareDefinesForMergedUV(this._opacityTexture,o,"OPACITY"),o.OPACITYRGB=this._opacityTexture.getAlphaFromRGB}else o.OPACITY=!1;if(this._reflectionTexture&&t.ReflectionTextureEnabled){if(!this._reflectionTexture.isReadyOrNotBlocking())return!1;switch(o._needNormals=!0,o.REFLECTION=!0,o.ROUGHNESS=this._roughness>0,o.REFLECTIONOVERALPHA=this._useReflectionOverAlpha,o.INVERTCUBICMAP=this._reflectionTexture.coordinatesMode===p.a.INVCUBIC_MODE,o.REFLECTIONMAP_3D=this._reflectionTexture.isCube,this._reflectionTexture.coordinatesMode){case p.a.EXPLICIT_MODE:o.setReflectionMode("REFLECTIONMAP_EXPLICIT");break;case p.a.PLANAR_MODE:o.setReflectionMode("REFLECTIONMAP_PLANAR");break;case p.a.PROJECTION_MODE:o.setReflectionMode("REFLECTIONMAP_PROJECTION");break;case p.a.SKYBOX_MODE:o.setReflectionMode("REFLECTIONMAP_SKYBOX");break;case p.a.SPHERICAL_MODE:o.setReflectionMode("REFLECTIONMAP_SPHERICAL");break;case p.a.EQUIRECTANGULAR_MODE:o.setReflectionMode("REFLECTIONMAP_EQUIRECTANGULAR");break;case p.a.FIXED_EQUIRECTANGULAR_MODE:o.setReflectionMode("REFLECTIONMAP_EQUIRECTANGULAR_FIXED");break;case p.a.FIXED_EQUIRECTANGULAR_MIRRORED_MODE:o.setReflectionMode("REFLECTIONMAP_MIRROREDEQUIRECTANGULAR_FIXED");break;case p.a.CUBIC_MODE:case p.a.INVCUBIC_MODE:default:o.setReflectionMode("REFLECTIONMAP_CUBIC")}o.USE_LOCAL_REFLECTIONMAP_CUBIC=!!this._reflectionTexture.boundingBoxSize}else o.REFLECTION=!1;if(this._emissiveTexture&&t.EmissiveTextureEnabled){if(!this._emissiveTexture.isReadyOrNotBlocking())return!1;f.a.PrepareDefinesForMergedUV(this._emissiveTexture,o,"EMISSIVE")}else o.EMISSIVE=!1;if(this._lightmapTexture&&t.LightmapTextureEnabled){if(!this._lightmapTexture.isReadyOrNotBlocking())return!1;f.a.PrepareDefinesForMergedUV(this._lightmapTexture,o,"LIGHTMAP"),o.USELIGHTMAPASSHADOWMAP=this._useLightmapAsShadowmap}else o.LIGHTMAP=!1;if(this._specularTexture&&t.SpecularTextureEnabled){if(!this._specularTexture.isReadyOrNotBlocking())return!1;f.a.PrepareDefinesForMergedUV(this._specularTexture,o,"SPECULAR"),o.GLOSSINESS=this._useGlossinessFromSpecularMapAlpha}else o.SPECULAR=!1;if(r.getEngine().getCaps().standardDerivatives&&this._bumpTexture&&t.BumpTextureEnabled){if(!this._bumpTexture.isReady())return!1;f.a.PrepareDefinesForMergedUV(this._bumpTexture,o,"BUMP"),o.PARALLAX=this._useParallax,o.PARALLAXOCCLUSION=this._useParallaxOcclusion,o.OBJECTSPACE_NORMALMAP=this._useObjectSpaceNormalMap}else o.BUMP=!1;if(this._refractionTexture&&t.RefractionTextureEnabled){if(!this._refractionTexture.isReadyOrNotBlocking())return!1;o._needUVs=!0,o.REFRACTION=!0,o.REFRACTIONMAP_3D=this._refractionTexture.isCube}else o.REFRACTION=!1;o.TWOSIDEDLIGHTING=!this._backFaceCulling&&this._twoSidedLighting}else o.DIFFUSE=!1,o.AMBIENT=!1,o.OPACITY=!1,o.REFLECTION=!1,o.EMISSIVE=!1,o.LIGHTMAP=!1,o.BUMP=!1,o.REFRACTION=!1;o.ALPHAFROMDIFFUSE=this._shouldUseAlphaFromDiffuseTexture(),o.EMISSIVEASILLUMINATION=this._useEmissiveAsIllumination,o.LINKEMISSIVEWITHDIFFUSE=this._linkEmissiveWithDiffuse,o.SPECULAROVERALPHA=this._useSpecularOverAlpha,o.PREMULTIPLYALPHA=this.alphaMode===x.a.ALPHA_PREMULTIPLIED||this.alphaMode===x.a.ALPHA_PREMULTIPLIED_PORTERDUFF}if(o._areImageProcessingDirty&&this._imageProcessingConfiguration){if(!this._imageProcessingConfiguration.isReady())return!1;this._imageProcessingConfiguration.prepareDefines(o),o.IS_REFLECTION_LINEAR=null!=this.reflectionTexture&&!this.reflectionTexture.gammaSpace,o.IS_REFRACTION_LINEAR=null!=this.refractionTexture&&!this.refractionTexture.gammaSpace}if(o._areFresnelDirty&&(t.FresnelEnabled?(this._diffuseFresnelParameters||this._opacityFresnelParameters||this._emissiveFresnelParameters||this._refractionFresnelParameters||this._reflectionFresnelParameters)&&(o.DIFFUSEFRESNEL=this._diffuseFresnelParameters&&this._diffuseFresnelParameters.isEnabled,o.OPACITYFRESNEL=this._opacityFresnelParameters&&this._opacityFresnelParameters.isEnabled,o.REFLECTIONFRESNEL=this._reflectionFresnelParameters&&this._reflectionFresnelParameters.isEnabled,o.REFLECTIONFRESNELFROMSPECULAR=this._useReflectionFresnelFromSpecular,o.REFRACTIONFRESNEL=this._refractionFresnelParameters&&this._refractionFresnelParameters.isEnabled,o.EMISSIVEFRESNEL=this._emissiveFresnelParameters&&this._emissiveFresnelParameters.isEnabled,o._needNormals=!0,o.FRESNEL=!0):o.FRESNEL=!1),f.a.PrepareDefinesForMisc(e,r,this._useLogarithmicDepth,this.pointsCloud,this.fogEnabled,this._shouldTurnAlphaTestOn(e),o),f.a.PrepareDefinesForAttributes(e,o,!0,!0,!0),f.a.PrepareDefinesForFrameBoundValues(r,a,o,n),o.isDirty){var s=o._areLightsDisposed;o.markAsProcessed();var c=new P.a;o.REFLECTION&&c.addFallback(0,"REFLECTION"),o.SPECULAR&&c.addFallback(0,"SPECULAR"),o.BUMP&&c.addFallback(0,"BUMP"),o.PARALLAX&&c.addFallback(1,"PARALLAX"),o.PARALLAXOCCLUSION&&c.addFallback(0,"PARALLAXOCCLUSION"),o.SPECULAROVERALPHA&&c.addFallback(0,"SPECULAROVERALPHA"),o.FOG&&c.addFallback(1,"FOG"),o.POINTSIZE&&c.addFallback(0,"POINTSIZE"),o.LOGARITHMICDEPTH&&c.addFallback(0,"LOGARITHMICDEPTH"),f.a.HandleFallbacksForShadows(o,c,this._maxSimultaneousLights),o.SPECULARTERM&&c.addFallback(0,"SPECULARTERM"),o.DIFFUSEFRESNEL&&c.addFallback(1,"DIFFUSEFRESNEL"),o.OPACITYFRESNEL&&c.addFallback(2,"OPACITYFRESNEL"),o.REFLECTIONFRESNEL&&c.addFallback(3,"REFLECTIONFRESNEL"),o.EMISSIVEFRESNEL&&c.addFallback(4,"EMISSIVEFRESNEL"),o.FRESNEL&&c.addFallback(4,"FRESNEL"),o.MULTIVIEW&&c.addFallback(0,"MULTIVIEW");var h=[l.b.PositionKind];o.NORMAL&&h.push(l.b.NormalKind),o.UV1&&h.push(l.b.UVKind),o.UV2&&h.push(l.b.UV2Kind),o.VERTEXCOLOR&&h.push(l.b.ColorKind),f.a.PrepareAttributesForBones(h,e,o,c),f.a.PrepareAttributesForInstances(h,o),f.a.PrepareAttributesForMorphTargets(h,e,o);var d="default",_=["world","view","viewProjection","vEyePosition","vLightsType","vAmbientColor","vDiffuseColor","vSpecularColor","vEmissiveColor","visibility","vFogInfos","vFogColor","pointSize","vDiffuseInfos","vAmbientInfos","vOpacityInfos","vReflectionInfos","vEmissiveInfos","vSpecularInfos","vBumpInfos","vLightmapInfos","vRefractionInfos","mBones","vClipPlane","vClipPlane2","vClipPlane3","vClipPlane4","vClipPlane5","vClipPlane6","diffuseMatrix","ambientMatrix","opacityMatrix","reflectionMatrix","emissiveMatrix","specularMatrix","bumpMatrix","normalMatrix","lightmapMatrix","refractionMatrix","diffuseLeftColor","diffuseRightColor","opacityParts","reflectionLeftColor","reflectionRightColor","emissiveLeftColor","emissiveRightColor","refractionLeftColor","refractionRightColor","vReflectionPosition","vReflectionSize","logarithmicDepthConstant","vTangentSpaceParams","alphaCutOff","boneTextureWidth"],m=["diffuseSampler","ambientSampler","opacitySampler","reflectionCubeSampler","reflection2DSampler","emissiveSampler","specularSampler","bumpSampler","lightmapSampler","refractionCubeSampler","refraction2DSampler","boneSampler"],g=["Material","Scene"];u.a&&(u.a.PrepareUniforms(_,o),u.a.PrepareSamplers(m,o)),f.a.PrepareUniformsAndSamplersList({uniformsNames:_,uniformBuffersNames:g,samplers:m,defines:o,maxSimultaneousLights:this._maxSimultaneousLights}),this.customShaderNameResolve&&(d=this.customShaderNameResolve(d,_,g,m,o));var v=o.toString(),y=i.effect,b=r.getEngine().createEffect(d,{attributes:h,uniformsNames:_,uniformBuffersNames:g,samplers:m,defines:v,fallbacks:c,onCompiled:this.onCompiled,onError:this.onError,indexParameters:{maxSimultaneousLights:this._maxSimultaneousLights,maxSimultaneousMorphTargets:o.NUM_MORPH_INFLUENCERS}},a);if(b)if(this.allowShaderHotSwapping&&y&&!b.isReady()){if(b=y,this._rebuildInParallel=!0,o.markAsUnprocessed(),s)return o._areLightsDisposed=!0,!1}else this._rebuildInParallel=!1,r.resetCachedMaterial(),i.setEffect(b,o),this.buildUniformLayout()}return!(!i.effect||!i.effect.isReady())&&(o._renderId=r.getRenderId(),i.effect._wasPreviouslyReady=!0,!0)},t.prototype.buildUniformLayout=function(){var e=this._uniformBuffer;e.addUniform("diffuseLeftColor",4),e.addUniform("diffuseRightColor",4),e.addUniform("opacityParts",4),e.addUniform("reflectionLeftColor",4),e.addUniform("reflectionRightColor",4),e.addUniform("refractionLeftColor",4),e.addUniform("refractionRightColor",4),e.addUniform("emissiveLeftColor",4),e.addUniform("emissiveRightColor",4),e.addUniform("vDiffuseInfos",2),e.addUniform("vAmbientInfos",2),e.addUniform("vOpacityInfos",2),e.addUniform("vReflectionInfos",2),e.addUniform("vReflectionPosition",3),e.addUniform("vReflectionSize",3),e.addUniform("vEmissiveInfos",2),e.addUniform("vLightmapInfos",2),e.addUniform("vSpecularInfos",2),e.addUniform("vBumpInfos",3),e.addUniform("diffuseMatrix",16),e.addUniform("ambientMatrix",16),e.addUniform("opacityMatrix",16),e.addUniform("reflectionMatrix",16),e.addUniform("emissiveMatrix",16),e.addUniform("lightmapMatrix",16),e.addUniform("specularMatrix",16),e.addUniform("bumpMatrix",16),e.addUniform("vTangentSpaceParams",2),e.addUniform("pointSize",1),e.addUniform("refractionMatrix",16),e.addUniform("vRefractionInfos",4),e.addUniform("vSpecularColor",4),e.addUniform("vEmissiveColor",3),e.addUniform("visibility",1),e.addUniform("vDiffuseColor",4),e.create()},t.prototype.unbind=function(){if(this._activeEffect){var t=!1;this._reflectionTexture&&this._reflectionTexture.isRenderTarget&&(this._activeEffect.setTexture("reflection2DSampler",null),t=!0),this._refractionTexture&&this._refractionTexture.isRenderTarget&&(this._activeEffect.setTexture("refraction2DSampler",null),t=!0),t&&this._markAllSubMeshesAsTexturesDirty()}e.prototype.unbind.call(this)},t.prototype.bindForSubMesh=function(e,i,n){var r=this.getScene(),o=n._materialDefines;if(o){var s=n.effect;if(s){this._activeEffect=s,o.INSTANCES||this.bindOnlyWorldMatrix(e),o.OBJECTSPACE_NORMALMAP&&(e.toNormalMatrix(this._normalMatrix),this.bindOnlyNormalMatrix(this._normalMatrix));var l=this._mustRebind(r,s,i.visibility);f.a.BindBonesParameters(i,s);var u=this._uniformBuffer;if(l){if(u.bindToEffect(s,"Material"),this.bindViewProjection(s),!u.useUbo||!this.isFrozen||!u.isSync){if(t.FresnelEnabled&&o.FRESNEL&&(this.diffuseFresnelParameters&&this.diffuseFresnelParameters.isEnabled&&(u.updateColor4("diffuseLeftColor",this.diffuseFresnelParameters.leftColor,this.diffuseFresnelParameters.power),u.updateColor4("diffuseRightColor",this.diffuseFresnelParameters.rightColor,this.diffuseFresnelParameters.bias)),this.opacityFresnelParameters&&this.opacityFresnelParameters.isEnabled&&u.updateColor4("opacityParts",new c.a(this.opacityFresnelParameters.leftColor.toLuminance(),this.opacityFresnelParameters.rightColor.toLuminance(),this.opacityFresnelParameters.bias),this.opacityFresnelParameters.power),this.reflectionFresnelParameters&&this.reflectionFresnelParameters.isEnabled&&(u.updateColor4("reflectionLeftColor",this.reflectionFresnelParameters.leftColor,this.reflectionFresnelParameters.power),u.updateColor4("reflectionRightColor",this.reflectionFresnelParameters.rightColor,this.reflectionFresnelParameters.bias)),this.refractionFresnelParameters&&this.refractionFresnelParameters.isEnabled&&(u.updateColor4("refractionLeftColor",this.refractionFresnelParameters.leftColor,this.refractionFresnelParameters.power),u.updateColor4("refractionRightColor",this.refractionFresnelParameters.rightColor,this.refractionFresnelParameters.bias)),this.emissiveFresnelParameters&&this.emissiveFresnelParameters.isEnabled&&(u.updateColor4("emissiveLeftColor",this.emissiveFresnelParameters.leftColor,this.emissiveFresnelParameters.power),u.updateColor4("emissiveRightColor",this.emissiveFresnelParameters.rightColor,this.emissiveFresnelParameters.bias))),r.texturesEnabled){if(this._diffuseTexture&&t.DiffuseTextureEnabled&&(u.updateFloat2("vDiffuseInfos",this._diffuseTexture.coordinatesIndex,this._diffuseTexture.level),f.a.BindTextureMatrix(this._diffuseTexture,u,"diffuse"),this._diffuseTexture.hasAlpha&&s.setFloat("alphaCutOff",this.alphaCutOff)),this._ambientTexture&&t.AmbientTextureEnabled&&(u.updateFloat2("vAmbientInfos",this._ambientTexture.coordinatesIndex,this._ambientTexture.level),f.a.BindTextureMatrix(this._ambientTexture,u,"ambient")),this._opacityTexture&&t.OpacityTextureEnabled&&(u.updateFloat2("vOpacityInfos",this._opacityTexture.coordinatesIndex,this._opacityTexture.level),f.a.BindTextureMatrix(this._opacityTexture,u,"opacity")),this._reflectionTexture&&t.ReflectionTextureEnabled&&(u.updateFloat2("vReflectionInfos",this._reflectionTexture.level,this.roughness),u.updateMatrix("reflectionMatrix",this._reflectionTexture.getReflectionTextureMatrix()),this._reflectionTexture.boundingBoxSize)){var h=this._reflectionTexture;u.updateVector3("vReflectionPosition",h.boundingBoxPosition),u.updateVector3("vReflectionSize",h.boundingBoxSize)}if(this._emissiveTexture&&t.EmissiveTextureEnabled&&(u.updateFloat2("vEmissiveInfos",this._emissiveTexture.coordinatesIndex,this._emissiveTexture.level),f.a.BindTextureMatrix(this._emissiveTexture,u,"emissive")),this._lightmapTexture&&t.LightmapTextureEnabled&&(u.updateFloat2("vLightmapInfos",this._lightmapTexture.coordinatesIndex,this._lightmapTexture.level),f.a.BindTextureMatrix(this._lightmapTexture,u,"lightmap")),this._specularTexture&&t.SpecularTextureEnabled&&(u.updateFloat2("vSpecularInfos",this._specularTexture.coordinatesIndex,this._specularTexture.level),f.a.BindTextureMatrix(this._specularTexture,u,"specular")),this._bumpTexture&&r.getEngine().getCaps().standardDerivatives&&t.BumpTextureEnabled&&(u.updateFloat3("vBumpInfos",this._bumpTexture.coordinatesIndex,1/this._bumpTexture.level,this.parallaxScaleBias),f.a.BindTextureMatrix(this._bumpTexture,u,"bump"),r._mirroredCameraPosition?u.updateFloat2("vTangentSpaceParams",this._invertNormalMapX?1:-1,this._invertNormalMapY?1:-1):u.updateFloat2("vTangentSpaceParams",this._invertNormalMapX?-1:1,this._invertNormalMapY?-1:1)),this._refractionTexture&&t.RefractionTextureEnabled){var d=1;this._refractionTexture.isCube||(u.updateMatrix("refractionMatrix",this._refractionTexture.getReflectionTextureMatrix()),this._refractionTexture.depth&&(d=this._refractionTexture.depth)),u.updateFloat4("vRefractionInfos",this._refractionTexture.level,this.indexOfRefraction,d,this.invertRefractionY?-1:1)}}this.pointsCloud&&u.updateFloat("pointSize",this.pointSize),o.SPECULARTERM&&u.updateColor4("vSpecularColor",this.specularColor,this.specularPower),u.updateColor3("vEmissiveColor",t.EmissiveTextureEnabled?this.emissiveColor:c.a.BlackReadOnly),u.updateFloat("visibility",i.visibility),u.updateColor4("vDiffuseColor",this.diffuseColor,this.alpha)}if(r.texturesEnabled&&(this._diffuseTexture&&t.DiffuseTextureEnabled&&s.setTexture("diffuseSampler",this._diffuseTexture),this._ambientTexture&&t.AmbientTextureEnabled&&s.setTexture("ambientSampler",this._ambientTexture),this._opacityTexture&&t.OpacityTextureEnabled&&s.setTexture("opacitySampler",this._opacityTexture),this._reflectionTexture&&t.ReflectionTextureEnabled&&(this._reflectionTexture.isCube?s.setTexture("reflectionCubeSampler",this._reflectionTexture):s.setTexture("reflection2DSampler",this._reflectionTexture)),this._emissiveTexture&&t.EmissiveTextureEnabled&&s.setTexture("emissiveSampler",this._emissiveTexture),this._lightmapTexture&&t.LightmapTextureEnabled&&s.setTexture("lightmapSampler",this._lightmapTexture),this._specularTexture&&t.SpecularTextureEnabled&&s.setTexture("specularSampler",this._specularTexture),this._bumpTexture&&r.getEngine().getCaps().standardDerivatives&&t.BumpTextureEnabled&&s.setTexture("bumpSampler",this._bumpTexture),this._refractionTexture&&t.RefractionTextureEnabled)){d=1;this._refractionTexture.isCube?s.setTexture("refractionCubeSampler",this._refractionTexture):s.setTexture("refraction2DSampler",this._refractionTexture)}f.a.BindClipPlane(s,r),r.ambientColor.multiplyToRef(this.ambientColor,this._globalAmbientColor),f.a.BindEyePosition(s,r),s.setColor3("vAmbientColor",this._globalAmbientColor)}!l&&this.isFrozen||(r.lightsEnabled&&!this._disableLighting&&f.a.BindLights(r,i,s,o,this._maxSimultaneousLights,this._rebuildInParallel),(r.fogEnabled&&i.applyFog&&r.fogMode!==a.a.FOGMODE_NONE||this._reflectionTexture||this._refractionTexture)&&this.bindView(s),f.a.BindFogParameters(r,i,s),o.NUM_MORPH_INFLUENCERS&&f.a.BindMorphTargetParameters(i,s),this.useLogarithmicDepth&&f.a.BindLogDepth(o,s,r),this._imageProcessingConfiguration&&!this._imageProcessingConfiguration.applyByPostProcess&&this._imageProcessingConfiguration.bind(this._activeEffect)),u.update(),this._afterBind(i,this._activeEffect)}}},t.prototype.getAnimatables=function(){var e=[];return this._diffuseTexture&&this._diffuseTexture.animations&&this._diffuseTexture.animations.length>0&&e.push(this._diffuseTexture),this._ambientTexture&&this._ambientTexture.animations&&this._ambientTexture.animations.length>0&&e.push(this._ambientTexture),this._opacityTexture&&this._opacityTexture.animations&&this._opacityTexture.animations.length>0&&e.push(this._opacityTexture),this._reflectionTexture&&this._reflectionTexture.animations&&this._reflectionTexture.animations.length>0&&e.push(this._reflectionTexture),this._emissiveTexture&&this._emissiveTexture.animations&&this._emissiveTexture.animations.length>0&&e.push(this._emissiveTexture),this._specularTexture&&this._specularTexture.animations&&this._specularTexture.animations.length>0&&e.push(this._specularTexture),this._bumpTexture&&this._bumpTexture.animations&&this._bumpTexture.animations.length>0&&e.push(this._bumpTexture),this._lightmapTexture&&this._lightmapTexture.animations&&this._lightmapTexture.animations.length>0&&e.push(this._lightmapTexture),this._refractionTexture&&this._refractionTexture.animations&&this._refractionTexture.animations.length>0&&e.push(this._refractionTexture),e},t.prototype.getActiveTextures=function(){var t=e.prototype.getActiveTextures.call(this);return this._diffuseTexture&&t.push(this._diffuseTexture),this._ambientTexture&&t.push(this._ambientTexture),this._opacityTexture&&t.push(this._opacityTexture),this._reflectionTexture&&t.push(this._reflectionTexture),this._emissiveTexture&&t.push(this._emissiveTexture),this._specularTexture&&t.push(this._specularTexture),this._bumpTexture&&t.push(this._bumpTexture),this._lightmapTexture&&t.push(this._lightmapTexture),this._refractionTexture&&t.push(this._refractionTexture),t},t.prototype.hasTexture=function(t){return!!e.prototype.hasTexture.call(this,t)||(this._diffuseTexture===t||(this._ambientTexture===t||(this._opacityTexture===t||(this._reflectionTexture===t||(this._emissiveTexture===t||(this._specularTexture===t||(this._bumpTexture===t||(this._lightmapTexture===t||this._refractionTexture===t))))))))},t.prototype.dispose=function(t,i){i&&(this._diffuseTexture&&this._diffuseTexture.dispose(),this._ambientTexture&&this._ambientTexture.dispose(),this._opacityTexture&&this._opacityTexture.dispose(),this._reflectionTexture&&this._reflectionTexture.dispose(),this._emissiveTexture&&this._emissiveTexture.dispose(),this._specularTexture&&this._specularTexture.dispose(),this._bumpTexture&&this._bumpTexture.dispose(),this._lightmapTexture&&this._lightmapTexture.dispose(),this._refractionTexture&&this._refractionTexture.dispose()),this._imageProcessingConfiguration&&this._imageProcessingObserver&&this._imageProcessingConfiguration.onUpdateParameters.remove(this._imageProcessingObserver),e.prototype.dispose.call(this,t,i)},t.prototype.clone=function(e){var i=this,n=r.a.Clone(function(){return new t(e,i.getScene())},this);return n.name=e,n.id=e,n},t.prototype.serialize=function(){return r.a.Serialize(this)},t.Parse=function(e,i,n){return r.a.Parse(function(){return new t(e.name,i)},e,i,n)},Object.defineProperty(t,"DiffuseTextureEnabled",{get:function(){return m.a.DiffuseTextureEnabled},set:function(e){m.a.DiffuseTextureEnabled=e},enumerable:!0,configurable:!0}),Object.defineProperty(t,"AmbientTextureEnabled",{get:function(){return m.a.AmbientTextureEnabled},set:function(e){m.a.AmbientTextureEnabled=e},enumerable:!0,configurable:!0}),Object.defineProperty(t,"OpacityTextureEnabled",{get:function(){return m.a.OpacityTextureEnabled},set:function(e){m.a.OpacityTextureEnabled=e},enumerable:!0,configurable:!0}),Object.defineProperty(t,"ReflectionTextureEnabled",{get:function(){return m.a.ReflectionTextureEnabled},set:function(e){m.a.ReflectionTextureEnabled=e},enumerable:!0,configurable:!0}),Object.defineProperty(t,"EmissiveTextureEnabled",{get:function(){return m.a.EmissiveTextureEnabled},set:function(e){m.a.EmissiveTextureEnabled=e},enumerable:!0,configurable:!0}),Object.defineProperty(t,"SpecularTextureEnabled",{get:function(){return m.a.SpecularTextureEnabled},set:function(e){m.a.SpecularTextureEnabled=e},enumerable:!0,configurable:!0}),Object.defineProperty(t,"BumpTextureEnabled",{get:function(){return m.a.BumpTextureEnabled},set:function(e){m.a.BumpTextureEnabled=e},enumerable:!0,configurable:!0}),Object.defineProperty(t,"LightmapTextureEnabled",{get:function(){return m.a.LightmapTextureEnabled},set:function(e){m.a.LightmapTextureEnabled=e},enumerable:!0,configurable:!0}),Object.defineProperty(t,"RefractionTextureEnabled",{get:function(){return m.a.RefractionTextureEnabled},set:function(e){m.a.RefractionTextureEnabled=e},enumerable:!0,configurable:!0}),Object.defineProperty(t,"ColorGradingTextureEnabled",{get:function(){return m.a.ColorGradingTextureEnabled},set:function(e){m.a.ColorGradingTextureEnabled=e},enumerable:!0,configurable:!0}),Object.defineProperty(t,"FresnelEnabled",{get:function(){return m.a.FresnelEnabled},set:function(e){m.a.FresnelEnabled=e},enumerable:!0,configurable:!0}),Object(n.c)([Object(r.m)("diffuseTexture")],t.prototype,"_diffuseTexture",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsTexturesAndMiscDirty")],t.prototype,"diffuseTexture",void 0),Object(n.c)([Object(r.m)("ambientTexture")],t.prototype,"_ambientTexture",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsTexturesDirty")],t.prototype,"ambientTexture",void 0),Object(n.c)([Object(r.m)("opacityTexture")],t.prototype,"_opacityTexture",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsTexturesAndMiscDirty")],t.prototype,"opacityTexture",void 0),Object(n.c)([Object(r.m)("reflectionTexture")],t.prototype,"_reflectionTexture",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsTexturesDirty")],t.prototype,"reflectionTexture",void 0),Object(n.c)([Object(r.m)("emissiveTexture")],t.prototype,"_emissiveTexture",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsTexturesDirty")],t.prototype,"emissiveTexture",void 0),Object(n.c)([Object(r.m)("specularTexture")],t.prototype,"_specularTexture",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsTexturesDirty")],t.prototype,"specularTexture",void 0),Object(n.c)([Object(r.m)("bumpTexture")],t.prototype,"_bumpTexture",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsTexturesDirty")],t.prototype,"bumpTexture",void 0),Object(n.c)([Object(r.m)("lightmapTexture")],t.prototype,"_lightmapTexture",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsTexturesDirty")],t.prototype,"lightmapTexture",void 0),Object(n.c)([Object(r.m)("refractionTexture")],t.prototype,"_refractionTexture",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsTexturesDirty")],t.prototype,"refractionTexture",void 0),Object(n.c)([Object(r.e)("ambient")],t.prototype,"ambientColor",void 0),Object(n.c)([Object(r.e)("diffuse")],t.prototype,"diffuseColor",void 0),Object(n.c)([Object(r.e)("specular")],t.prototype,"specularColor",void 0),Object(n.c)([Object(r.e)("emissive")],t.prototype,"emissiveColor",void 0),Object(n.c)([Object(r.c)()],t.prototype,"specularPower",void 0),Object(n.c)([Object(r.c)("useAlphaFromDiffuseTexture")],t.prototype,"_useAlphaFromDiffuseTexture",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsTexturesDirty")],t.prototype,"useAlphaFromDiffuseTexture",void 0),Object(n.c)([Object(r.c)("useEmissiveAsIllumination")],t.prototype,"_useEmissiveAsIllumination",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsTexturesDirty")],t.prototype,"useEmissiveAsIllumination",void 0),Object(n.c)([Object(r.c)("linkEmissiveWithDiffuse")],t.prototype,"_linkEmissiveWithDiffuse",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsTexturesDirty")],t.prototype,"linkEmissiveWithDiffuse",void 0),Object(n.c)([Object(r.c)("useSpecularOverAlpha")],t.prototype,"_useSpecularOverAlpha",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsTexturesDirty")],t.prototype,"useSpecularOverAlpha",void 0),Object(n.c)([Object(r.c)("useReflectionOverAlpha")],t.prototype,"_useReflectionOverAlpha",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsTexturesDirty")],t.prototype,"useReflectionOverAlpha",void 0),Object(n.c)([Object(r.c)("disableLighting")],t.prototype,"_disableLighting",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsLightsDirty")],t.prototype,"disableLighting",void 0),Object(n.c)([Object(r.c)("useObjectSpaceNormalMap")],t.prototype,"_useObjectSpaceNormalMap",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsTexturesDirty")],t.prototype,"useObjectSpaceNormalMap",void 0),Object(n.c)([Object(r.c)("useParallax")],t.prototype,"_useParallax",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsTexturesDirty")],t.prototype,"useParallax",void 0),Object(n.c)([Object(r.c)("useParallaxOcclusion")],t.prototype,"_useParallaxOcclusion",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsTexturesDirty")],t.prototype,"useParallaxOcclusion",void 0),Object(n.c)([Object(r.c)()],t.prototype,"parallaxScaleBias",void 0),Object(n.c)([Object(r.c)("roughness")],t.prototype,"_roughness",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsTexturesDirty")],t.prototype,"roughness",void 0),Object(n.c)([Object(r.c)()],t.prototype,"indexOfRefraction",void 0),Object(n.c)([Object(r.c)()],t.prototype,"invertRefractionY",void 0),Object(n.c)([Object(r.c)()],t.prototype,"alphaCutOff",void 0),Object(n.c)([Object(r.c)("useLightmapAsShadowmap")],t.prototype,"_useLightmapAsShadowmap",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsTexturesDirty")],t.prototype,"useLightmapAsShadowmap",void 0),Object(n.c)([Object(r.h)("diffuseFresnelParameters")],t.prototype,"_diffuseFresnelParameters",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsFresnelDirty")],t.prototype,"diffuseFresnelParameters",void 0),Object(n.c)([Object(r.h)("opacityFresnelParameters")],t.prototype,"_opacityFresnelParameters",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsFresnelAndMiscDirty")],t.prototype,"opacityFresnelParameters",void 0),Object(n.c)([Object(r.h)("reflectionFresnelParameters")],t.prototype,"_reflectionFresnelParameters",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsFresnelDirty")],t.prototype,"reflectionFresnelParameters",void 0),Object(n.c)([Object(r.h)("refractionFresnelParameters")],t.prototype,"_refractionFresnelParameters",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsFresnelDirty")],t.prototype,"refractionFresnelParameters",void 0),Object(n.c)([Object(r.h)("emissiveFresnelParameters")],t.prototype,"_emissiveFresnelParameters",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsFresnelDirty")],t.prototype,"emissiveFresnelParameters",void 0),Object(n.c)([Object(r.c)("useReflectionFresnelFromSpecular")],t.prototype,"_useReflectionFresnelFromSpecular",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsFresnelDirty")],t.prototype,"useReflectionFresnelFromSpecular",void 0),Object(n.c)([Object(r.c)("useGlossinessFromSpecularMapAlpha")],t.prototype,"_useGlossinessFromSpecularMapAlpha",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsTexturesDirty")],t.prototype,"useGlossinessFromSpecularMapAlpha",void 0),Object(n.c)([Object(r.c)("maxSimultaneousLights")],t.prototype,"_maxSimultaneousLights",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsLightsDirty")],t.prototype,"maxSimultaneousLights",void 0),Object(n.c)([Object(r.c)("invertNormalMapX")],t.prototype,"_invertNormalMapX",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsTexturesDirty")],t.prototype,"invertNormalMapX",void 0),Object(n.c)([Object(r.c)("invertNormalMapY")],t.prototype,"_invertNormalMapY",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsTexturesDirty")],t.prototype,"invertNormalMapY",void 0),Object(n.c)([Object(r.c)("twoSidedLighting")],t.prototype,"_twoSidedLighting",void 0),Object(n.c)([Object(r.b)("_markAllSubMeshesAsTexturesDirty")],t.prototype,"twoSidedLighting",void 0),Object(n.c)([Object(r.c)()],t.prototype,"useLogarithmicDepth",null),t}(d.a);_.a.RegisteredTypes["BABYLON.StandardMaterial"]=S,a.a.DefaultMaterialFactory=function(e){return new S("default material",e)}},function(e,t,i){"use strict";i.d(t,"a",function(){return o});var n=i(36),r=function(e,t){return e?e.getClassName&&"Mesh"===e.getClassName()?null:e.getClassName&&"SubMesh"===e.getClassName()?e.clone(t):e.clone?e.clone():null:null},o=function(){function e(){}return e.DeepCopy=function(e,t,i,o){for(var a in e)if(("_"!==a[0]||o&&-1!==o.indexOf(a))&&!(n.a.EndsWith(a,"Observable")||i&&-1!==i.indexOf(a))){var s=e[a],c=typeof s;if("function"!==c)try{if("object"===c)if(s instanceof Array){if(t[a]=[],s.length>0)if("object"==typeof s[0])for(var l=0;l<s.length;l++){var u=r(s[l],t);-1===t[a].indexOf(u)&&t[a].push(u)}else t[a]=s.slice(0)}else t[a]=r(s,t);else t[a]=s}catch(e){}}},e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return r}),i.d(t,"b",function(){return o});var n=i(1),r=function(){function e(t){this.length=0,this.data=new Array(t),this._id=e._GlobalId++}return e.prototype.push=function(e){this.data[this.length++]=e,this.length>this.data.length&&(this.data.length*=2)},e.prototype.forEach=function(e){for(var t=0;t<this.length;t++)e(this.data[t])},e.prototype.sort=function(e){this.data.sort(e)},e.prototype.reset=function(){this.length=0},e.prototype.dispose=function(){this.reset(),this.data&&(this.data.length=0,this.data=[])},e.prototype.concat=function(e){if(0!==e.length){this.length+e.length>this.data.length&&(this.data.length=2*(this.length+e.length));for(var t=0;t<e.length;t++)this.data[this.length++]=(e.data||e)[t]}},e.prototype.indexOf=function(e){var t=this.data.indexOf(e);return t>=this.length?-1:t},e.prototype.contains=function(e){return-1!==this.indexOf(e)},e._GlobalId=0,e}(),o=function(e){function t(){var t=null!==e&&e.apply(this,arguments)||this;return t._duplicateId=0,t}return Object(n.d)(t,e),t.prototype.push=function(t){e.prototype.push.call(this,t),t.__smartArrayFlags||(t.__smartArrayFlags={}),t.__smartArrayFlags[this._id]=this._duplicateId},t.prototype.pushNoDuplicate=function(e){return(!e.__smartArrayFlags||e.__smartArrayFlags[this._id]!==this._duplicateId)&&(this.push(e),!0)},t.prototype.reset=function(){e.prototype.reset.call(this),this._duplicateId++},t.prototype.concatWithNoDuplicate=function(e){if(0!==e.length){this.length+e.length>this.data.length&&(this.data.length=2*(this.length+e.length));for(var t=0;t<e.length;t++){var i=(e.data||e)[t];this.pushNoDuplicate(i)}}},t}(r)},function(e,t,i){"use strict";i.d(t,"a",function(){return r});var n=i(125),r=function(){function e(){}return e.EnableFor=function(t){t._tags=t._tags||{},t.hasTags=function(){return e.HasTags(t)},t.addTags=function(i){return e.AddTagsTo(t,i)},t.removeTags=function(i){return e.RemoveTagsFrom(t,i)},t.matchesTagsQuery=function(i){return e.MatchesQuery(t,i)}},e.DisableFor=function(e){delete e._tags,delete e.hasTags,delete e.addTags,delete e.removeTags,delete e.matchesTagsQuery},e.HasTags=function(e){if(!e._tags)return!1;var t=e._tags;for(var i in t)if(t.hasOwnProperty(i))return!0;return!1},e.GetTags=function(e,t){if(void 0===t&&(t=!0),!e._tags)return null;if(t){var i=[];for(var n in e._tags)e._tags.hasOwnProperty(n)&&!0===e._tags[n]&&i.push(n);return i.join(" ")}return e._tags},e.AddTagsTo=function(t,i){i&&("string"==typeof i&&i.split(" ").forEach(function(i,n,r){e._AddTagTo(t,i)}))},e._AddTagTo=function(t,i){""!==(i=i.trim())&&"true"!==i&&"false"!==i&&(i.match(/[\s]/)||i.match(/^([!]|([|]|[&]){2})/)||(e.EnableFor(t),t._tags[i]=!0))},e.RemoveTagsFrom=function(t,i){if(e.HasTags(t)){var n=i.split(" ");for(var r in n)e._RemoveTagFrom(t,n[r])}},e._RemoveTagFrom=function(e,t){delete e._tags[t]},e.MatchesQuery=function(t,i){return void 0===i||(""===i?e.HasTags(t):n.a.Eval(i,function(i){return e.HasTags(t)&&t._tags[i]}))},e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return n});var n=function(){function e(){}return e.EndsWith=function(e,t){return-1!==e.indexOf(t,e.length-t.length)},e.StartsWith=function(e,t){return 0===e.indexOf(t)},e.Decode=function(e){if("undefined"!=typeof TextDecoder)return(new TextDecoder).decode(e);for(var t="",i=0;i<e.byteLength;i++)t+=String.fromCharCode(e[i]);return t},e.EncodeArrayBufferToBase64=function(e){for(var t,i,n,r,o,a,s,c="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",l="",u=0,h=ArrayBuffer.isView(e)?new Uint8Array(e.buffer,e.byteOffset,e.byteLength):new Uint8Array(e);u<h.length;)r=(t=h[u++])>>2,o=(3&t)<<4|(i=u<h.length?h[u++]:Number.NaN)>>4,a=(15&i)<<2|(n=u<h.length?h[u++]:Number.NaN)>>6,s=63&n,isNaN(i)?a=s=64:isNaN(n)&&(s=64),l+=c.charAt(r)+c.charAt(o)+c.charAt(a)+c.charAt(s);return l},e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return n});var n=function(){function e(){this.rootNodes=new Array,this.cameras=new Array,this.lights=new Array,this.meshes=new Array,this.skeletons=new Array,this.particleSystems=new Array,this.animations=[],this.animationGroups=new Array,this.multiMaterials=new Array,this.materials=new Array,this.morphTargetManagers=new Array,this.geometries=new Array,this.transformNodes=new Array,this.actionManagers=new Array,this.textures=new Array,this.environmentTexture=null}return e.AddParser=function(e,t){this._BabylonFileParsers[e]=t},e.GetParser=function(e){return this._BabylonFileParsers[e]?this._BabylonFileParsers[e]:null},e.AddIndividualParser=function(e,t){this._IndividualBabylonFileParsers[e]=t},e.GetIndividualParser=function(e){return this._IndividualBabylonFileParsers[e]?this._IndividualBabylonFileParsers[e]:null},e.Parse=function(e,t,i,n){for(var r in this._BabylonFileParsers)this._BabylonFileParsers.hasOwnProperty(r)&&this._BabylonFileParsers[r](e,t,i,n)},e.prototype.getNodes=function(){var e=new Array;return e=(e=(e=(e=e.concat(this.meshes)).concat(this.lights)).concat(this.cameras)).concat(this.transformNodes),this.skeletons.forEach(function(t){return e=e.concat(t.bones)}),e},e._BabylonFileParsers={},e._IndividualBabylonFileParsers={},e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return n});var n=function(){function e(){}return e.IsWindowObjectExist=function(){return"undefined"!=typeof window},e.IsNavigatorAvailable=function(){return"undefined"!=typeof navigator},e.GetDOMTextContent=function(e){for(var t="",i=e.firstChild;i;)3===i.nodeType&&(t+=i.textContent),i=i.nextSibling;return t},e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return l});var n=i(42),r=i(0),o=i(53),a=i(105),s=i(18),c=i(24),l=function(){function e(e,t,i){void 0===i&&(i=Number.MAX_VALUE),this.origin=e,this.direction=t,this.length=i}return e.prototype.intersectsBoxMinMax=function(t,i,n){void 0===n&&(n=0);var r,o,a,s,c=e.TmpVector3[0].copyFromFloats(t.x-n,t.y-n,t.z-n),l=e.TmpVector3[1].copyFromFloats(i.x+n,i.y+n,i.z+n),u=0,h=Number.MAX_VALUE;if(Math.abs(this.direction.x)<1e-7){if(this.origin.x<c.x||this.origin.x>l.x)return!1}else if(r=1/this.direction.x,o=(c.x-this.origin.x)*r,(a=(l.x-this.origin.x)*r)===-1/0&&(a=1/0),o>a&&(s=o,o=a,a=s),(u=Math.max(o,u))>(h=Math.min(a,h)))return!1;if(Math.abs(this.direction.y)<1e-7){if(this.origin.y<c.y||this.origin.y>l.y)return!1}else if(r=1/this.direction.y,o=(c.y-this.origin.y)*r,(a=(l.y-this.origin.y)*r)===-1/0&&(a=1/0),o>a&&(s=o,o=a,a=s),(u=Math.max(o,u))>(h=Math.min(a,h)))return!1;if(Math.abs(this.direction.z)<1e-7){if(this.origin.z<c.z||this.origin.z>l.z)return!1}else if(r=1/this.direction.z,o=(c.z-this.origin.z)*r,(a=(l.z-this.origin.z)*r)===-1/0&&(a=1/0),o>a&&(s=o,o=a,a=s),(u=Math.max(o,u))>(h=Math.min(a,h)))return!1;return!0},e.prototype.intersectsBox=function(e,t){return void 0===t&&(t=0),this.intersectsBoxMinMax(e.minimum,e.maximum,t)},e.prototype.intersectsSphere=function(e,t){void 0===t&&(t=0);var i=e.center.x-this.origin.x,n=e.center.y-this.origin.y,r=e.center.z-this.origin.z,o=i*i+n*n+r*r,a=e.radius+t,s=a*a;if(o<=s)return!0;var c=i*this.direction.x+n*this.direction.y+r*this.direction.z;return!(c<0)&&o-c*c<=s},e.prototype.intersectsTriangle=function(t,i,n){var o=e.TmpVector3[0],s=e.TmpVector3[1],c=e.TmpVector3[2],l=e.TmpVector3[3],u=e.TmpVector3[4];i.subtractToRef(t,o),n.subtractToRef(t,s),r.e.CrossToRef(this.direction,s,c);var h=r.e.Dot(o,c);if(0===h)return null;var d=1/h;this.origin.subtractToRef(t,l);var f=r.e.Dot(l,c)*d;if(f<0||f>1)return null;r.e.CrossToRef(l,o,u);var p=r.e.Dot(this.direction,u)*d;if(p<0||f+p>1)return null;var _=r.e.Dot(s,u)*d;return _>this.length?null:new a.a(1-f-p,f,_)},e.prototype.intersectsPlane=function(e){var t,i=r.e.Dot(e.normal,this.direction);if(Math.abs(i)<9.99999997475243e-7)return null;var n=r.e.Dot(e.normal,this.origin);return(t=(-e.d-n)/i)<0?t<-9.99999997475243e-7?null:0:t},e.prototype.intersectsAxis=function(e,t){switch(void 0===t&&(t=0),e){case"y":return(i=(this.origin.y-t)/this.direction.y)>0?null:new r.e(this.origin.x+this.direction.x*-i,t,this.origin.z+this.direction.z*-i);case"x":return(i=(this.origin.x-t)/this.direction.x)>0?null:new r.e(t,this.origin.y+this.direction.y*-i,this.origin.z+this.direction.z*-i);case"z":var i;return(i=(this.origin.z-t)/this.direction.z)>0?null:new r.e(this.origin.x+this.direction.x*-i,this.origin.y+this.direction.y*-i,t);default:return null}},e.prototype.intersectsMesh=function(t,i){var n=r.c.Matrix[0];return t.getWorldMatrix().invertToRef(n),this._tmpRay?e.TransformToRef(this,n,this._tmpRay):this._tmpRay=e.Transform(this,n),t.intersects(this._tmpRay,i)},e.prototype.intersectsMeshes=function(e,t,i){i?i.length=0:i=[];for(var n=0;n<e.length;n++){var r=this.intersectsMesh(e[n],t);r.hit&&i.push(r)}return i.sort(this._comparePickingInfo),i},e.prototype._comparePickingInfo=function(e,t){return e.distance<t.distance?-1:e.distance>t.distance?1:0},e.prototype.intersectionSegment=function(t,i,n){var o=this.origin,a=r.c.Vector3[0],s=r.c.Vector3[1],c=r.c.Vector3[2],l=r.c.Vector3[3];i.subtractToRef(t,a),this.direction.scaleToRef(e.rayl,c),o.addToRef(c,s),t.subtractToRef(o,l);var u,h,d,f,p=r.e.Dot(a,a),_=r.e.Dot(a,c),m=r.e.Dot(c,c),g=r.e.Dot(a,l),v=r.e.Dot(c,l),y=p*m-_*_,b=y,T=y;y<e.smallnum?(h=0,b=1,f=v,T=m):(f=p*v-_*g,(h=_*v-m*g)<0?(h=0,f=v,T=m):h>b&&(h=b,f=v+_,T=m)),f<0?(f=0,-g<0?h=0:-g>p?h=b:(h=-g,b=p)):f>T&&(f=T,-g+_<0?h=0:-g+_>p?h=b:(h=-g+_,b=p)),u=Math.abs(h)<e.smallnum?0:h/b,d=Math.abs(f)<e.smallnum?0:f/T;var E=r.c.Vector3[4];c.scaleToRef(d,E);var x=r.c.Vector3[5];a.scaleToRef(u,x),x.addInPlace(l);var P=r.c.Vector3[6];return x.subtractToRef(E,P),d>0&&d<=this.length&&P.lengthSquared()<n*n?x.length():-1},e.prototype.update=function(e,t,i,n,r,o,a){return this.unprojectRayToRef(e,t,i,n,r,o,a),this},e.Zero=function(){return new e(r.e.Zero(),r.e.Zero())},e.CreateNew=function(t,i,n,r,o,a,s){return e.Zero().update(t,i,n,r,o,a,s)},e.CreateNewFromTo=function(t,i,n){void 0===n&&(n=r.a.IdentityReadOnly);var o=i.subtract(t),a=Math.sqrt(o.x*o.x+o.y*o.y+o.z*o.z);return o.normalize(),e.Transform(new e(t,o,a),n)},e.Transform=function(t,i){var n=new e(new r.e(0,0,0),new r.e(0,0,0));return e.TransformToRef(t,i,n),n},e.TransformToRef=function(e,t,i){r.e.TransformCoordinatesToRef(e.origin,t,i.origin),r.e.TransformNormalToRef(e.direction,t,i.direction),i.length=e.length;var n=i.direction,o=n.length();if(0!==o&&1!==o){var a=1/o;n.x*=a,n.y*=a,n.z*=a,i.length*=o}},e.prototype.unprojectRayToRef=function(e,t,i,n,o,a,s){var c=r.c.Matrix[0];o.multiplyToRef(a,c),c.multiplyToRef(s,c),c.invert();var l=r.c.Vector3[0];l.x=e/i*2-1,l.y=-(t/n*2-1),l.z=-1;var u=r.c.Vector3[1].copyFromFloats(l.x,l.y,1),h=r.c.Vector3[2],d=r.c.Vector3[3];r.e._UnprojectFromInvertedMatrixToRef(l,c,h),r.e._UnprojectFromInvertedMatrixToRef(u,c,d),this.origin.copyFrom(h),d.subtractToRef(h,this.direction),this.direction.normalize()},e.TmpVector3=n.a.BuildArray(6,r.e.Zero),e.smallnum=1e-8,e.rayl=1e9,e}();s.a.prototype.createPickingRay=function(e,t,i,n,r){void 0===r&&(r=!1);var o=l.Zero();return this.createPickingRayToRef(e,t,i,o,n,r),o},s.a.prototype.createPickingRayToRef=function(e,t,i,n,o,a){void 0===a&&(a=!1);var s=this.getEngine();if(!o){if(!this.activeCamera)return this;o=this.activeCamera}var c=o.viewport.toGlobal(s.getRenderWidth(),s.getRenderHeight());return e=e/s.getHardwareScalingLevel()-c.x,t=t/s.getHardwareScalingLevel()-(s.getRenderHeight()-c.y-c.height),n.update(e,t,c.width,c.height,i||r.a.IdentityReadOnly,a?r.a.IdentityReadOnly:o.getViewMatrix(),o.getProjectionMatrix()),this},s.a.prototype.createPickingRayInCameraSpace=function(e,t,i){var n=l.Zero();return this.createPickingRayInCameraSpaceToRef(e,t,n,i),n},s.a.prototype.createPickingRayInCameraSpaceToRef=function(e,t,i,n){if(!o.a)return this;var a=this.getEngine();if(!n){if(!this.activeCamera)throw new Error("Active camera not set");n=this.activeCamera}var s=n.viewport.toGlobal(a.getRenderWidth(),a.getRenderHeight()),c=r.a.Identity();return e=e/a.getHardwareScalingLevel()-s.x,t=t/a.getHardwareScalingLevel()-(a.getRenderHeight()-s.y-s.height),i.update(e,t,s.width,s.height,c,c,n.getProjectionMatrix()),this},s.a.prototype._internalPick=function(e,t,i,n){if(!o.a)return null;for(var r=null,a=0;a<this.meshes.length;a++){var s=this.meshes[a];if(t){if(!t(s))continue}else if(!s.isEnabled()||!s.isVisible||!s.isPickable)continue;var c=e(s.getWorldMatrix()),l=s.intersects(c,i,n);if(l&&l.hit&&((i||null==r||!(l.distance>=r.distance))&&(r=l,i)))break}return r||new o.a},s.a.prototype._internalMultiPick=function(e,t,i){if(!o.a)return null;for(var n=new Array,r=0;r<this.meshes.length;r++){var a=this.meshes[r];if(t){if(!t(a))continue}else if(!a.isEnabled()||!a.isVisible||!a.isPickable)continue;var s=e(a.getWorldMatrix()),c=a.intersects(s,!1,i);c&&c.hit&&n.push(c)}return n},s.a.prototype.pick=function(e,t,i,n,a,s){var c=this;if(!o.a)return null;var u=this._internalPick(function(i){return c._tempPickingRay||(c._tempPickingRay=l.Zero()),c.createPickingRayToRef(e,t,i,c._tempPickingRay,a||null),c._tempPickingRay},i,n,s);return u&&(u.ray=this.createPickingRay(e,t,r.a.Identity(),a||null)),u},s.a.prototype.pickWithRay=function(e,t,i,n){var o=this,a=this._internalPick(function(t){return o._pickWithRayInverseMatrix||(o._pickWithRayInverseMatrix=r.a.Identity()),t.invertToRef(o._pickWithRayInverseMatrix),o._cachedRayForTransform||(o._cachedRayForTransform=l.Zero()),l.TransformToRef(e,o._pickWithRayInverseMatrix,o._cachedRayForTransform),o._cachedRayForTransform},t,i,n);return a&&(a.ray=e),a},s.a.prototype.multiPick=function(e,t,i,n,r){var o=this;return this._internalMultiPick(function(i){return o.createPickingRay(e,t,i,n||null)},i,r)},s.a.prototype.multiPickWithRay=function(e,t,i){var n=this;return this._internalMultiPick(function(t){return n._pickWithRayInverseMatrix||(n._pickWithRayInverseMatrix=r.a.Identity()),t.invertToRef(n._pickWithRayInverseMatrix),n._cachedRayForTransform||(n._cachedRayForTransform=l.Zero()),l.TransformToRef(e,n._pickWithRayInverseMatrix,n._cachedRayForTransform),n._cachedRayForTransform},t,i)},c.a.prototype.getForwardRay=function(e,t,i){void 0===e&&(e=100),t||(t=this.getWorldMatrix()),i||(i=this.position);var n=this._scene.useRightHandedSystem?new r.e(0,0,-1):new r.e(0,0,1),o=r.e.TransformNormal(n,t),a=r.e.Normalize(o);return new l(i,a,e)}},function(e,t,i){"use strict";i.d(t,"b",function(){return u}),i.d(t,"a",function(){return h});var n=i(1),r=i(3),o=i(6),a=i(13),s=i(10),c=i(73),l=i(111),u=function(e){function t(){var t=e.call(this)||this;return t.IMAGEPROCESSING=!1,t.VIGNETTE=!1,t.VIGNETTEBLENDMODEMULTIPLY=!1,t.VIGNETTEBLENDMODEOPAQUE=!1,t.TONEMAPPING=!1,t.TONEMAPPING_ACES=!1,t.CONTRAST=!1,t.COLORCURVES=!1,t.COLORGRADING=!1,t.COLORGRADING3D=!1,t.SAMPLER3DGREENDEPTH=!1,t.SAMPLER3DBGRMAP=!1,t.IMAGEPROCESSINGPOSTPROCESS=!1,t.EXPOSURE=!1,t.rebuild(),t}return Object(n.d)(t,e),t}(c.a),h=function(){function e(){this.colorCurves=new l.a,this._colorCurvesEnabled=!1,this._colorGradingEnabled=!1,this._colorGradingWithGreenDepth=!0,this._colorGradingBGR=!0,this._exposure=1,this._toneMappingEnabled=!1,this._toneMappingType=e.TONEMAPPING_STANDARD,this._contrast=1,this.vignetteStretch=0,this.vignetteCentreX=0,this.vignetteCentreY=0,this.vignetteWeight=1.5,this.vignetteColor=new s.b(0,0,0,0),this.vignetteCameraFov=.5,this._vignetteBlendMode=e.VIGNETTEMODE_MULTIPLY,this._vignetteEnabled=!1,this._applyByPostProcess=!1,this._isEnabled=!0,this.onUpdateParameters=new o.c}return Object.defineProperty(e.prototype,"colorCurvesEnabled",{get:function(){return this._colorCurvesEnabled},set:function(e){this._colorCurvesEnabled!==e&&(this._colorCurvesEnabled=e,this._updateParameters())},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"colorGradingTexture",{get:function(){return this._colorGradingTexture},set:function(e){this._colorGradingTexture!==e&&(this._colorGradingTexture=e,this._updateParameters())},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"colorGradingEnabled",{get:function(){return this._colorGradingEnabled},set:function(e){this._colorGradingEnabled!==e&&(this._colorGradingEnabled=e,this._updateParameters())},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"colorGradingWithGreenDepth",{get:function(){return this._colorGradingWithGreenDepth},set:function(e){this._colorGradingWithGreenDepth!==e&&(this._colorGradingWithGreenDepth=e,this._updateParameters())},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"colorGradingBGR",{get:function(){return this._colorGradingBGR},set:function(e){this._colorGradingBGR!==e&&(this._colorGradingBGR=e,this._updateParameters())},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"exposure",{get:function(){return this._exposure},set:function(e){this._exposure!==e&&(this._exposure=e,this._updateParameters())},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"toneMappingEnabled",{get:function(){return this._toneMappingEnabled},set:function(e){this._toneMappingEnabled!==e&&(this._toneMappingEnabled=e,this._updateParameters())},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"toneMappingType",{get:function(){return this._toneMappingType},set:function(e){this._toneMappingType!==e&&(this._toneMappingType=e,this._updateParameters())},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"contrast",{get:function(){return this._contrast},set:function(e){this._contrast!==e&&(this._contrast=e,this._updateParameters())},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"vignetteBlendMode",{get:function(){return this._vignetteBlendMode},set:function(e){this._vignetteBlendMode!==e&&(this._vignetteBlendMode=e,this._updateParameters())},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"vignetteEnabled",{get:function(){return this._vignetteEnabled},set:function(e){this._vignetteEnabled!==e&&(this._vignetteEnabled=e,this._updateParameters())},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"applyByPostProcess",{get:function(){return this._applyByPostProcess},set:function(e){this._applyByPostProcess!==e&&(this._applyByPostProcess=e,this._updateParameters())},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"isEnabled",{get:function(){return this._isEnabled},set:function(e){this._isEnabled!==e&&(this._isEnabled=e,this._updateParameters())},enumerable:!0,configurable:!0}),e.prototype._updateParameters=function(){this.onUpdateParameters.notifyObservers(this)},e.prototype.getClassName=function(){return"ImageProcessingConfiguration"},e.PrepareUniforms=function(e,t){t.EXPOSURE&&e.push("exposureLinear"),t.CONTRAST&&e.push("contrast"),t.COLORGRADING&&e.push("colorTransformSettings"),t.VIGNETTE&&(e.push("vInverseScreenSize"),e.push("vignetteSettings1"),e.push("vignetteSettings2")),t.COLORCURVES&&l.a.PrepareUniforms(e)},e.PrepareSamplers=function(e,t){t.COLORGRADING&&e.push("txColorTransform")},e.prototype.prepareDefines=function(t,i){if(void 0===i&&(i=!1),i!==this.applyByPostProcess||!this._isEnabled)return t.VIGNETTE=!1,t.TONEMAPPING=!1,t.TONEMAPPING_ACES=!1,t.CONTRAST=!1,t.EXPOSURE=!1,t.COLORCURVES=!1,t.COLORGRADING=!1,t.COLORGRADING3D=!1,t.IMAGEPROCESSING=!1,void(t.IMAGEPROCESSINGPOSTPROCESS=this.applyByPostProcess&&this._isEnabled);switch(t.VIGNETTE=this.vignetteEnabled,t.VIGNETTEBLENDMODEMULTIPLY=this.vignetteBlendMode===e._VIGNETTEMODE_MULTIPLY,t.VIGNETTEBLENDMODEOPAQUE=!t.VIGNETTEBLENDMODEMULTIPLY,t.TONEMAPPING=this.toneMappingEnabled,this._toneMappingType){case e.TONEMAPPING_ACES:t.TONEMAPPING_ACES=!0;break;default:t.TONEMAPPING_ACES=!1}t.CONTRAST=1!==this.contrast,t.EXPOSURE=1!==this.exposure,t.COLORCURVES=this.colorCurvesEnabled&&!!this.colorCurves,t.COLORGRADING=this.colorGradingEnabled&&!!this.colorGradingTexture,t.COLORGRADING?t.COLORGRADING3D=this.colorGradingTexture.is3D:t.COLORGRADING3D=!1,t.SAMPLER3DGREENDEPTH=this.colorGradingWithGreenDepth,t.SAMPLER3DBGRMAP=this.colorGradingBGR,t.IMAGEPROCESSINGPOSTPROCESS=this.applyByPostProcess,t.IMAGEPROCESSING=t.VIGNETTE||t.TONEMAPPING||t.CONTRAST||t.EXPOSURE||t.COLORCURVES||t.COLORGRADING},e.prototype.isReady=function(){return!this.colorGradingEnabled||!this.colorGradingTexture||this.colorGradingTexture.isReady()},e.prototype.bind=function(e,t){if(this._colorCurvesEnabled&&this.colorCurves&&l.a.Bind(this.colorCurves,e),this._vignetteEnabled){var i=1/e.getEngine().getRenderWidth(),n=1/e.getEngine().getRenderHeight();e.setFloat2("vInverseScreenSize",i,n);var r=null!=t?t:n/i,o=Math.tan(.5*this.vignetteCameraFov),s=o*r,c=Math.sqrt(s*o);s=a.b.Mix(s,c,this.vignetteStretch),o=a.b.Mix(o,c,this.vignetteStretch),e.setFloat4("vignetteSettings1",s,o,-s*this.vignetteCentreX,-o*this.vignetteCentreY);var u=-2*this.vignetteWeight;e.setFloat4("vignetteSettings2",this.vignetteColor.r,this.vignetteColor.g,this.vignetteColor.b,u)}if(e.setFloat("exposureLinear",this.exposure),e.setFloat("contrast",this.contrast),this.colorGradingTexture){e.setTexture("txColorTransform",this.colorGradingTexture);var h=this.colorGradingTexture.getSize().height;e.setFloat4("colorTransformSettings",(h-1)/h,.5/h,h,this.colorGradingTexture.level)}},e.prototype.clone=function(){return r.a.Clone(function(){return new e},this)},e.prototype.serialize=function(){return r.a.Serialize(this)},e.Parse=function(t){return r.a.Parse(function(){return new e},t,null,null)},Object.defineProperty(e,"VIGNETTEMODE_MULTIPLY",{get:function(){return this._VIGNETTEMODE_MULTIPLY},enumerable:!0,configurable:!0}),Object.defineProperty(e,"VIGNETTEMODE_OPAQUE",{get:function(){return this._VIGNETTEMODE_OPAQUE},enumerable:!0,configurable:!0}),e.TONEMAPPING_STANDARD=0,e.TONEMAPPING_ACES=1,e._VIGNETTEMODE_MULTIPLY=0,e._VIGNETTEMODE_OPAQUE=1,Object(n.c)([Object(r.g)()],e.prototype,"colorCurves",void 0),Object(n.c)([Object(r.c)()],e.prototype,"_colorCurvesEnabled",void 0),Object(n.c)([Object(r.m)("colorGradingTexture")],e.prototype,"_colorGradingTexture",void 0),Object(n.c)([Object(r.c)()],e.prototype,"_colorGradingEnabled",void 0),Object(n.c)([Object(r.c)()],e.prototype,"_colorGradingWithGreenDepth",void 0),Object(n.c)([Object(r.c)()],e.prototype,"_colorGradingBGR",void 0),Object(n.c)([Object(r.c)()],e.prototype,"_exposure",void 0),Object(n.c)([Object(r.c)()],e.prototype,"_toneMappingEnabled",void 0),Object(n.c)([Object(r.c)()],e.prototype,"_toneMappingType",void 0),Object(n.c)([Object(r.c)()],e.prototype,"_contrast",void 0),Object(n.c)([Object(r.c)()],e.prototype,"vignetteStretch",void 0),Object(n.c)([Object(r.c)()],e.prototype,"vignetteCentreX",void 0),Object(n.c)([Object(r.c)()],e.prototype,"vignetteCentreY",void 0),Object(n.c)([Object(r.c)()],e.prototype,"vignetteWeight",void 0),Object(n.c)([Object(r.f)()],e.prototype,"vignetteColor",void 0),Object(n.c)([Object(r.c)()],e.prototype,"vignetteCameraFov",void 0),Object(n.c)([Object(r.c)()],e.prototype,"_vignetteBlendMode",void 0),Object(n.c)([Object(r.c)()],e.prototype,"_vignetteEnabled",void 0),Object(n.c)([Object(r.c)()],e.prototype,"_applyByPostProcess",void 0),Object(n.c)([Object(r.c)()],e.prototype,"_isEnabled",void 0),e}();r.a._ImageProcessingConfigurationParser=h.Parse},function(e,t,i){"use strict";i.d(t,"a",function(){return u});var n=i(18),r=i(6),o=i(20),a=i(23),s=i(80),c=i(0),l=i(10),u=function(){function e(e,t){var i=this;void 0===t&&(t=!0),this.originalScene=e,this._pointerCaptures={},this._lastPointerEvents={},this._sharedGizmoLight=null,this._renderCamera=null,this.pickUtilitySceneFirst=!0,this.shouldRender=!0,this.onlyCheckPointerDownEvents=!0,this.processAllEvents=!1,this.onPointerOutObservable=new r.c,this.utilityLayerScene=new n.a(e.getEngine(),{virtual:!0}),this.utilityLayerScene.useRightHandedSystem=e.useRightHandedSystem,this.utilityLayerScene._allowPostProcessClearColor=!1,this.utilityLayerScene.detachControl(),t&&(this._originalPointerObserver=e.onPrePointerObservable.add(function(t,n){if(i.utilityLayerScene.activeCamera&&(i.processAllEvents||t.type===o.a.POINTERMOVE||t.type===o.a.POINTERUP||t.type===o.a.POINTERDOWN)){i.utilityLayerScene.pointerX=e.pointerX,i.utilityLayerScene.pointerY=e.pointerY;var r=t.event;if(e.isPointerCaptured(r.pointerId))i._pointerCaptures[r.pointerId]=!1;else{var a=t.ray?i.utilityLayerScene.pickWithRay(t.ray):i.utilityLayerScene.pick(e.pointerX,e.pointerY);if(!t.ray&&a&&(t.ray=a.ray),i.utilityLayerScene.onPrePointerObservable.notifyObservers(t),i.onlyCheckPointerDownEvents&&t.type!=o.a.POINTERDOWN)return t.skipOnPointerObservable||i.utilityLayerScene.onPointerObservable.notifyObservers(new o.b(t.type,t.event,a)),void(t.type===o.a.POINTERUP&&i._pointerCaptures[r.pointerId]&&(i._pointerCaptures[r.pointerId]=!1));if(i.utilityLayerScene.autoClearDepthAndStencil||i.pickUtilitySceneFirst)a&&a.hit&&(t.skipOnPointerObservable||i.utilityLayerScene.onPointerObservable.notifyObservers(new o.b(t.type,t.event,a)),t.skipOnPointerObservable=!0);else{var s=t.ray?e.pickWithRay(t.ray):e.pick(e.pointerX,e.pointerY),c=t.event;s&&a&&(0===a.distance&&s.pickedMesh?i.mainSceneTrackerPredicate&&i.mainSceneTrackerPredicate(s.pickedMesh)?(i._notifyObservers(t,s,c),t.skipOnPointerObservable=!0):t.type===o.a.POINTERDOWN?i._pointerCaptures[c.pointerId]=!0:i._lastPointerEvents[c.pointerId]&&(i.onPointerOutObservable.notifyObservers(c.pointerId),delete i._lastPointerEvents[c.pointerId]):!i._pointerCaptures[c.pointerId]&&(a.distance<s.distance||0===s.distance)?(i._notifyObservers(t,a,c),t.skipOnPointerObservable||(t.skipOnPointerObservable=a.distance>0)):!i._pointerCaptures[c.pointerId]&&a.distance>s.distance&&(i.mainSceneTrackerPredicate&&i.mainSceneTrackerPredicate(s.pickedMesh)?(i._notifyObservers(t,s,c),t.skipOnPointerObservable=!0):i._lastPointerEvents[c.pointerId]&&(i.onPointerOutObservable.notifyObservers(c.pointerId),delete i._lastPointerEvents[c.pointerId])),t.type===o.a.POINTERUP&&i._pointerCaptures[c.pointerId]&&(i._pointerCaptures[c.pointerId]=!1))}}}}),this._originalPointerObserver&&e.onPrePointerObservable.makeObserverTopPriority(this._originalPointerObserver)),this.utilityLayerScene.autoClear=!1,this._afterRenderObserver=this.originalScene.onAfterCameraRenderObservable.add(function(e){i.shouldRender&&e==i.getRenderCamera()&&i.render()}),this._sceneDisposeObserver=this.originalScene.onDisposeObservable.add(function(){i.dispose()}),this._updateCamera()}return e.prototype.getRenderCamera=function(e){if(this._renderCamera)return this._renderCamera;var t=void 0;return t=this.originalScene.activeCameras.length>1?this.originalScene.activeCameras[this.originalScene.activeCameras.length-1]:this.originalScene.activeCamera,e&&t&&t.isRigCamera?t.rigParent:t},e.prototype.setRenderCamera=function(e){this._renderCamera=e},e.prototype._getSharedGizmoLight=function(){return this._sharedGizmoLight||(this._sharedGizmoLight=new s.a("shared gizmo light",new c.e(0,1,0),this.utilityLayerScene),this._sharedGizmoLight.intensity=2,this._sharedGizmoLight.groundColor=l.a.Gray()),this._sharedGizmoLight},Object.defineProperty(e,"DefaultUtilityLayer",{get:function(){return null==e._DefaultUtilityLayer&&(e._DefaultUtilityLayer=new e(a.a.LastCreatedScene),e._DefaultUtilityLayer.originalScene.onDisposeObservable.addOnce(function(){e._DefaultUtilityLayer=null})),e._DefaultUtilityLayer},enumerable:!0,configurable:!0}),Object.defineProperty(e,"DefaultKeepDepthUtilityLayer",{get:function(){return null==e._DefaultKeepDepthUtilityLayer&&(e._DefaultKeepDepthUtilityLayer=new e(a.a.LastCreatedScene),e._DefaultKeepDepthUtilityLayer.utilityLayerScene.autoClearDepthAndStencil=!1,e._DefaultKeepDepthUtilityLayer.originalScene.onDisposeObservable.addOnce(function(){e._DefaultKeepDepthUtilityLayer=null})),e._DefaultKeepDepthUtilityLayer},enumerable:!0,configurable:!0}),e.prototype._notifyObservers=function(e,t,i){e.skipOnPointerObservable||(this.utilityLayerScene.onPointerObservable.notifyObservers(new o.b(e.type,e.event,t)),this._lastPointerEvents[i.pointerId]=!0)},e.prototype.render=function(){if(this._updateCamera(),this.utilityLayerScene.activeCamera){var e=this.utilityLayerScene.activeCamera.getScene(),t=this.utilityLayerScene.activeCamera;t._scene=this.utilityLayerScene,t.leftCamera&&(t.leftCamera._scene=this.utilityLayerScene),t.rightCamera&&(t.rightCamera._scene=this.utilityLayerScene),this.utilityLayerScene.render(!1),t._scene=e,t.leftCamera&&(t.leftCamera._scene=e),t.rightCamera&&(t.rightCamera._scene=e)}},e.prototype.dispose=function(){this.onPointerOutObservable.clear(),this._afterRenderObserver&&this.originalScene.onAfterCameraRenderObservable.remove(this._afterRenderObserver),this._sceneDisposeObserver&&this.originalScene.onDisposeObservable.remove(this._sceneDisposeObserver),this._originalPointerObserver&&this.originalScene.onPrePointerObservable.remove(this._originalPointerObserver),this.utilityLayerScene.dispose()},e.prototype._updateCamera=function(){this.utilityLayerScene.cameraToUseForPointers=this.getRenderCamera(),this.utilityLayerScene.activeCamera=this.getRenderCamera()},e._DefaultUtilityLayer=null,e._DefaultKeepDepthUtilityLayer=null,e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return n});var n=function(){function e(){}return e.BuildArray=function(e,t){for(var i=[],n=0;n<e;++n)i.push(t());return i},e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return l});var n=i(1),r=i(3),o=i(6),a=i(0),s=i(26),c=i(22),l=function(e){function t(i,n,r){void 0===n&&(n=null),void 0===r&&(r=!0);var s=e.call(this,i,n)||this;return s._forward=new a.e(0,0,1),s._forwardInverted=new a.e(0,0,-1),s._up=new a.e(0,1,0),s._right=new a.e(1,0,0),s._rightInverted=new a.e(-1,0,0),s._position=a.e.Zero(),s._rotation=a.e.Zero(),s._rotationQuaternion=null,s._scaling=a.e.One(),s._isDirty=!1,s._transformToBoneReferal=null,s._isAbsoluteSynced=!1,s._billboardMode=t.BILLBOARDMODE_NONE,s._preserveParentRotationForBillboard=!1,s.scalingDeterminant=1,s._infiniteDistance=!1,s.ignoreNonUniformScaling=!1,s.reIntegrateRotationIntoRotationQuaternion=!1,s._poseMatrix=null,s._localMatrix=a.a.Zero(),s._usePivotMatrix=!1,s._absolutePosition=a.e.Zero(),s._absoluteScaling=a.e.Zero(),s._absoluteRotationQuaternion=a.b.Identity(),s._pivotMatrix=a.a.Identity(),s._postMultiplyPivotMatrix=!1,s._isWorldMatrixFrozen=!1,s._indexInSceneTransformNodesArray=-1,s.onAfterWorldMatrixUpdateObservable=new o.c,s._nonUniformScaling=!1,r&&s.getScene().addTransformNode(s),s}return Object(n.d)(t,e),Object.defineProperty(t.prototype,"billboardMode",{get:function(){return this._billboardMode},set:function(e){this._billboardMode!==e&&(this._billboardMode=e)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"preserveParentRotationForBillboard",{get:function(){return this._preserveParentRotationForBillboard},set:function(e){e!==this._preserveParentRotationForBillboard&&(this._preserveParentRotationForBillboard=e)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"infiniteDistance",{get:function(){return this._infiniteDistance},set:function(e){this._infiniteDistance!==e&&(this._infiniteDistance=e)},enumerable:!0,configurable:!0}),t.prototype.getClassName=function(){return"TransformNode"},Object.defineProperty(t.prototype,"position",{get:function(){return this._position},set:function(e){this._position=e,this._isDirty=!0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"rotation",{get:function(){return this._rotation},set:function(e){this._rotation=e,this._rotationQuaternion=null,this._isDirty=!0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"scaling",{get:function(){return this._scaling},set:function(e){this._scaling=e,this._isDirty=!0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"rotationQuaternion",{get:function(){return this._rotationQuaternion},set:function(e){this._rotationQuaternion=e,e&&this._rotation.setAll(0),this._isDirty=!0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"forward",{get:function(){return a.e.Normalize(a.e.TransformNormal(this.getScene().useRightHandedSystem?this._forwardInverted:this._forward,this.getWorldMatrix()))},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"up",{get:function(){return a.e.Normalize(a.e.TransformNormal(this._up,this.getWorldMatrix()))},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"right",{get:function(){return a.e.Normalize(a.e.TransformNormal(this.getScene().useRightHandedSystem?this._rightInverted:this._right,this.getWorldMatrix()))},enumerable:!0,configurable:!0}),t.prototype.updatePoseMatrix=function(e){return this._poseMatrix?(this._poseMatrix.copyFrom(e),this):(this._poseMatrix=e.clone(),this)},t.prototype.getPoseMatrix=function(){return this._poseMatrix||(this._poseMatrix=a.a.Identity()),this._poseMatrix},t.prototype._isSynchronized=function(){var e=this._cache;if(this.billboardMode!==e.billboardMode||this.billboardMode!==t.BILLBOARDMODE_NONE)return!1;if(e.pivotMatrixUpdated)return!1;if(this.infiniteDistance)return!1;if(!e.position.equals(this._position))return!1;if(this._rotationQuaternion){if(!e.rotationQuaternion.equals(this._rotationQuaternion))return!1}else if(!e.rotation.equals(this._rotation))return!1;return!!e.scaling.equals(this._scaling)},t.prototype._initCache=function(){e.prototype._initCache.call(this);var t=this._cache;t.localMatrixUpdated=!1,t.position=a.e.Zero(),t.scaling=a.e.Zero(),t.rotation=a.e.Zero(),t.rotationQuaternion=new a.b(0,0,0,0),t.billboardMode=-1,t.infiniteDistance=!1},t.prototype.markAsDirty=function(e){return this._currentRenderId=Number.MAX_VALUE,this._isDirty=!0,this},Object.defineProperty(t.prototype,"absolutePosition",{get:function(){return this._absolutePosition},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"absoluteScaling",{get:function(){return this._syncAbsoluteScalingAndRotation(),this._absoluteScaling},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"absoluteRotationQuaternion",{get:function(){return this._syncAbsoluteScalingAndRotation(),this._absoluteRotationQuaternion},enumerable:!0,configurable:!0}),t.prototype.setPreTransformMatrix=function(e){return this.setPivotMatrix(e,!1)},t.prototype.setPivotMatrix=function(e,t){return void 0===t&&(t=!0),this._pivotMatrix.copyFrom(e),this._usePivotMatrix=!this._pivotMatrix.isIdentity(),this._cache.pivotMatrixUpdated=!0,this._postMultiplyPivotMatrix=t,this._postMultiplyPivotMatrix&&(this._pivotMatrixInverse?this._pivotMatrix.invertToRef(this._pivotMatrixInverse):this._pivotMatrixInverse=a.a.Invert(this._pivotMatrix)),this},t.prototype.getPivotMatrix=function(){return this._pivotMatrix},t.prototype.instantiateHierarchy=function(e,t,i){void 0===e&&(e=null);var n=this.clone("Clone of "+(this.name||this.id),e||this.parent,!0);n&&i&&i(this,n);for(var r=0,o=this.getChildTransformNodes(!0);r<o.length;r++){o[r].instantiateHierarchy(n,t,i)}return n},t.prototype.freezeWorldMatrix=function(e){return void 0===e&&(e=null),e?this._worldMatrix=e:(this._isWorldMatrixFrozen=!1,this.computeWorldMatrix(!0)),this._isDirty=!1,this._isWorldMatrixFrozen=!0,this},t.prototype.unfreezeWorldMatrix=function(){return this._isWorldMatrixFrozen=!1,this.computeWorldMatrix(!0),this},Object.defineProperty(t.prototype,"isWorldMatrixFrozen",{get:function(){return this._isWorldMatrixFrozen},enumerable:!0,configurable:!0}),t.prototype.getAbsolutePosition=function(){return this.computeWorldMatrix(),this._absolutePosition},t.prototype.setAbsolutePosition=function(e){if(!e)return this;var t,i,n;if(void 0===e.x){if(arguments.length<3)return this;t=arguments[0],i=arguments[1],n=arguments[2]}else t=e.x,i=e.y,n=e.z;if(this.parent){var r=a.c.Matrix[0];this.parent.getWorldMatrix().invertToRef(r),a.e.TransformCoordinatesFromFloatsToRef(t,i,n,r,this.position)}else this.position.x=t,this.position.y=i,this.position.z=n;return this},t.prototype.setPositionWithLocalVector=function(e){return this.computeWorldMatrix(),this.position=a.e.TransformNormal(e,this._localMatrix),this},t.prototype.getPositionExpressedInLocalSpace=function(){this.computeWorldMatrix();var e=a.c.Matrix[0];return this._localMatrix.invertToRef(e),a.e.TransformNormal(this.position,e)},t.prototype.locallyTranslate=function(e){return this.computeWorldMatrix(!0),this.position=a.e.TransformCoordinates(e,this._localMatrix),this},t.prototype.lookAt=function(e,i,n,r,o){void 0===i&&(i=0),void 0===n&&(n=0),void 0===r&&(r=0),void 0===o&&(o=c.b.LOCAL);var s=t._lookAtVectorCache,l=o===c.b.LOCAL?this.position:this.getAbsolutePosition();if(e.subtractToRef(l,s),this.setDirection(s,i,n,r),o===c.b.WORLD&&this.parent)if(this.rotationQuaternion){var u=a.c.Matrix[0];this.rotationQuaternion.toRotationMatrix(u);var h=a.c.Matrix[1];this.parent.getWorldMatrix().getRotationMatrixToRef(h),h.invert(),u.multiplyToRef(h,u),this.rotationQuaternion.fromRotationMatrix(u)}else{var d=a.c.Quaternion[0];a.b.FromEulerVectorToRef(this.rotation,d);u=a.c.Matrix[0];d.toRotationMatrix(u);h=a.c.Matrix[1];this.parent.getWorldMatrix().getRotationMatrixToRef(h),h.invert(),u.multiplyToRef(h,u),d.fromRotationMatrix(u),d.toEulerAnglesToRef(this.rotation)}return this},t.prototype.getDirection=function(e){var t=a.e.Zero();return this.getDirectionToRef(e,t),t},t.prototype.getDirectionToRef=function(e,t){return a.e.TransformNormalToRef(e,this.getWorldMatrix(),t),this},t.prototype.setDirection=function(e,t,i,n){void 0===t&&(t=0),void 0===i&&(i=0),void 0===n&&(n=0);var r=-Math.atan2(e.z,e.x)+Math.PI/2,o=Math.sqrt(e.x*e.x+e.z*e.z),s=-Math.atan2(e.y,o);return this.rotationQuaternion?a.b.RotationYawPitchRollToRef(r+t,s+i,n,this.rotationQuaternion):(this.rotation.x=s+i,this.rotation.y=r+t,this.rotation.z=n),this},t.prototype.setPivotPoint=function(e,t){void 0===t&&(t=c.b.LOCAL),0==this.getScene().getRenderId()&&this.computeWorldMatrix(!0);var i=this.getWorldMatrix();if(t==c.b.WORLD){var n=a.c.Matrix[0];i.invertToRef(n),e=a.e.TransformCoordinates(e,n)}return this.setPivotMatrix(a.a.Translation(-e.x,-e.y,-e.z),!0)},t.prototype.getPivotPoint=function(){var e=a.e.Zero();return this.getPivotPointToRef(e),e},t.prototype.getPivotPointToRef=function(e){return e.x=-this._pivotMatrix.m[12],e.y=-this._pivotMatrix.m[13],e.z=-this._pivotMatrix.m[14],this},t.prototype.getAbsolutePivotPoint=function(){var e=a.e.Zero();return this.getAbsolutePivotPointToRef(e),e},t.prototype.getAbsolutePivotPointToRef=function(e){return e.x=this._pivotMatrix.m[12],e.y=this._pivotMatrix.m[13],e.z=this._pivotMatrix.m[14],this.getPivotPointToRef(e),a.e.TransformCoordinatesToRef(e,this.getWorldMatrix(),e),this},t.prototype.setParent=function(e){if(!e&&!this.parent)return this;var t=a.c.Quaternion[0],i=a.c.Vector3[0],n=a.c.Vector3[1];if(e){var r=a.c.Matrix[0],o=a.c.Matrix[1];this.computeWorldMatrix(!0),e.computeWorldMatrix(!0),e.getWorldMatrix().invertToRef(o),this.getWorldMatrix().multiplyToRef(o,r),r.decompose(n,t,i)}else this.computeWorldMatrix(!0),this.getWorldMatrix().decompose(n,t,i);return this.rotationQuaternion?this.rotationQuaternion.copyFrom(t):t.toEulerAnglesToRef(this.rotation),this.scaling.copyFrom(n),this.position.copyFrom(i),this.parent=e,this},Object.defineProperty(t.prototype,"nonUniformScaling",{get:function(){return this._nonUniformScaling},enumerable:!0,configurable:!0}),t.prototype._updateNonUniformScalingState=function(e){return this._nonUniformScaling!==e&&(this._nonUniformScaling=e,!0)},t.prototype.attachToBone=function(e,t){return this._transformToBoneReferal=t,this.parent=e,e.getWorldMatrix().determinant()<0&&(this.scalingDeterminant*=-1),this},t.prototype.detachFromBone=function(){return this.parent?(this.parent.getWorldMatrix().determinant()<0&&(this.scalingDeterminant*=-1),this._transformToBoneReferal=null,this.parent=null,this):this},t.prototype.rotate=function(e,i,n){var r;if(e.normalize(),this.rotationQuaternion||(this.rotationQuaternion=this.rotation.toQuaternion(),this.rotation.setAll(0)),n&&n!==c.b.LOCAL){if(this.parent){var o=a.c.Matrix[0];this.parent.getWorldMatrix().invertToRef(o),e=a.e.TransformNormal(e,o)}(r=a.b.RotationAxisToRef(e,i,t._rotationAxisCache)).multiplyToRef(this.rotationQuaternion,this.rotationQuaternion)}else r=a.b.RotationAxisToRef(e,i,t._rotationAxisCache),this.rotationQuaternion.multiplyToRef(r,this.rotationQuaternion);return this},t.prototype.rotateAround=function(e,t,i){t.normalize(),this.rotationQuaternion||(this.rotationQuaternion=a.b.RotationYawPitchRoll(this.rotation.y,this.rotation.x,this.rotation.z),this.rotation.setAll(0));var n=a.c.Vector3[0],r=a.c.Vector3[1],o=a.c.Vector3[2],s=a.c.Quaternion[0],c=a.c.Matrix[0],l=a.c.Matrix[1],u=a.c.Matrix[2],h=a.c.Matrix[3];return e.subtractToRef(this.position,n),a.a.TranslationToRef(n.x,n.y,n.z,c),a.a.TranslationToRef(-n.x,-n.y,-n.z,l),a.a.RotationAxisToRef(t,i,u),l.multiplyToRef(u,h),h.multiplyToRef(c,h),h.decompose(r,s,o),this.position.addInPlace(o),s.multiplyToRef(this.rotationQuaternion,this.rotationQuaternion),this},t.prototype.translate=function(e,t,i){var n=e.scale(t);if(i&&i!==c.b.LOCAL)this.setAbsolutePosition(this.getAbsolutePosition().add(n));else{var r=this.getPositionExpressedInLocalSpace().add(n);this.setPositionWithLocalVector(r)}return this},t.prototype.addRotation=function(e,t,i){var n;this.rotationQuaternion?n=this.rotationQuaternion:(n=a.c.Quaternion[1],a.b.RotationYawPitchRollToRef(this.rotation.y,this.rotation.x,this.rotation.z,n));var r=a.c.Quaternion[0];return a.b.RotationYawPitchRollToRef(t,e,i,r),n.multiplyInPlace(r),this.rotationQuaternion||n.toEulerAnglesToRef(this.rotation),this},t.prototype._getEffectiveParent=function(){return this.parent},t.prototype.computeWorldMatrix=function(e){if(this._isWorldMatrixFrozen&&!this._isDirty)return this._worldMatrix;var i=this.getScene().getRenderId();if(!this._isDirty&&!e&&this.isSynchronized())return this._currentRenderId=i,this._worldMatrix;var n=this.getScene().activeCamera,r=0!=(this._billboardMode&t.BILLBOARDMODE_USE_POSITION),o=this._billboardMode!==t.BILLBOARDMODE_NONE&&!this.preserveParentRotationForBillboard;o&&n&&r&&(this.lookAt(n.position),(this.billboardMode&t.BILLBOARDMODE_X)!==t.BILLBOARDMODE_X&&(this.rotation.x=0),(this.billboardMode&t.BILLBOARDMODE_Y)!==t.BILLBOARDMODE_Y&&(this.rotation.y=0),(this.billboardMode&t.BILLBOARDMODE_Z)!==t.BILLBOARDMODE_Z&&(this.rotation.z=0)),this._updateCache();var s=this._cache;s.pivotMatrixUpdated=!1,s.billboardMode=this.billboardMode,s.infiniteDistance=this.infiniteDistance,this._currentRenderId=i,this._childUpdateId++,this._isDirty=!1;var c=this._getEffectiveParent(),l=s.scaling,u=s.position;if(this._infiniteDistance)if(!this.parent&&n){var h=n.getWorldMatrix(),d=new a.e(h.m[12],h.m[13],h.m[14]);u.copyFromFloats(this._position.x+d.x,this._position.y+d.y,this._position.z+d.z)}else u.copyFrom(this._position);else u.copyFrom(this._position);l.copyFromFloats(this._scaling.x*this.scalingDeterminant,this._scaling.y*this.scalingDeterminant,this._scaling.z*this.scalingDeterminant);var f=s.rotationQuaternion;if(this._rotationQuaternion){if(this.reIntegrateRotationIntoRotationQuaternion)this.rotation.lengthSquared()&&(this._rotationQuaternion.multiplyInPlace(a.b.RotationYawPitchRoll(this._rotation.y,this._rotation.x,this._rotation.z)),this._rotation.copyFromFloats(0,0,0));f.copyFrom(this._rotationQuaternion)}else a.b.RotationYawPitchRollToRef(this._rotation.y,this._rotation.x,this._rotation.z,f),s.rotation.copyFrom(this._rotation);if(this._usePivotMatrix){var p=a.c.Matrix[1];a.a.ScalingToRef(l.x,l.y,l.z,p);var _=a.c.Matrix[0];f.toRotationMatrix(_),this._pivotMatrix.multiplyToRef(p,a.c.Matrix[4]),a.c.Matrix[4].multiplyToRef(_,this._localMatrix),this._postMultiplyPivotMatrix&&this._localMatrix.multiplyToRef(this._pivotMatrixInverse,this._localMatrix),this._localMatrix.addTranslationFromFloats(u.x,u.y,u.z)}else a.a.ComposeToRef(l,f,u,this._localMatrix);if(c&&c.getWorldMatrix){if(e&&c.computeWorldMatrix(),o){this._transformToBoneReferal?c.getWorldMatrix().multiplyToRef(this._transformToBoneReferal.getWorldMatrix(),a.c.Matrix[7]):a.c.Matrix[7].copyFrom(c.getWorldMatrix());var m=a.c.Vector3[5],g=a.c.Vector3[6];a.c.Matrix[7].decompose(g,void 0,m),a.a.ScalingToRef(g.x,g.y,g.z,a.c.Matrix[7]),a.c.Matrix[7].setTranslation(m),this._localMatrix.multiplyToRef(a.c.Matrix[7],this._worldMatrix)}else this._transformToBoneReferal?(this._localMatrix.multiplyToRef(c.getWorldMatrix(),a.c.Matrix[6]),a.c.Matrix[6].multiplyToRef(this._transformToBoneReferal.getWorldMatrix(),this._worldMatrix)):this._localMatrix.multiplyToRef(c.getWorldMatrix(),this._worldMatrix);this._markSyncedWithParent()}else this._worldMatrix.copyFrom(this._localMatrix);if(o&&n&&this.billboardMode&&!r){var v=a.c.Vector3[0];if(this._worldMatrix.getTranslationToRef(v),a.c.Matrix[1].copyFrom(n.getViewMatrix()),a.c.Matrix[1].setTranslationFromFloats(0,0,0),a.c.Matrix[1].invertToRef(a.c.Matrix[0]),(this.billboardMode&t.BILLBOARDMODE_ALL)!==t.BILLBOARDMODE_ALL){a.c.Matrix[0].decompose(void 0,a.c.Quaternion[0],void 0);var y=a.c.Vector3[1];a.c.Quaternion[0].toEulerAnglesToRef(y),(this.billboardMode&t.BILLBOARDMODE_X)!==t.BILLBOARDMODE_X&&(y.x=0),(this.billboardMode&t.BILLBOARDMODE_Y)!==t.BILLBOARDMODE_Y&&(y.y=0),(this.billboardMode&t.BILLBOARDMODE_Z)!==t.BILLBOARDMODE_Z&&(y.z=0),a.a.RotationYawPitchRollToRef(y.y,y.x,y.z,a.c.Matrix[0])}this._worldMatrix.setTranslationFromFloats(0,0,0),this._worldMatrix.multiplyToRef(a.c.Matrix[0],this._worldMatrix),this._worldMatrix.setTranslation(a.c.Vector3[0])}return this.ignoreNonUniformScaling?this._updateNonUniformScalingState(!1):this._scaling.isNonUniform?this._updateNonUniformScalingState(!0):c&&c._nonUniformScaling?this._updateNonUniformScalingState(c._nonUniformScaling):this._updateNonUniformScalingState(!1),this._afterComputeWorldMatrix(),this._absolutePosition.copyFromFloats(this._worldMatrix.m[12],this._worldMatrix.m[13],this._worldMatrix.m[14]),this._isAbsoluteSynced=!1,this.onAfterWorldMatrixUpdateObservable.notifyObservers(this),this._poseMatrix||(this._poseMatrix=a.a.Invert(this._worldMatrix)),this._worldMatrixDeterminantIsDirty=!0,this._worldMatrix},t.prototype.resetLocalMatrix=function(e){if(void 0===e&&(e=!0),this.computeWorldMatrix(),e)for(var t=this.getChildren(),i=0;i<t.length;++i){var n=t[i];if(n){n.computeWorldMatrix();var r=a.c.Matrix[0];n._localMatrix.multiplyToRef(this._localMatrix,r);var o=a.c.Quaternion[0];r.decompose(n.scaling,o,n.position),n.rotationQuaternion?n.rotationQuaternion=o:o.toEulerAnglesToRef(n.rotation)}}this.scaling.copyFromFloats(1,1,1),this.position.copyFromFloats(0,0,0),this.rotation.copyFromFloats(0,0,0),this.rotationQuaternion&&(this.rotationQuaternion=a.b.Identity()),this._worldMatrix=a.a.Identity()},t.prototype._afterComputeWorldMatrix=function(){},t.prototype.registerAfterWorldMatrixUpdate=function(e){return this.onAfterWorldMatrixUpdateObservable.add(e),this},t.prototype.unregisterAfterWorldMatrixUpdate=function(e){return this.onAfterWorldMatrixUpdateObservable.removeCallback(e),this},t.prototype.getPositionInCameraSpace=function(e){return void 0===e&&(e=null),e||(e=this.getScene().activeCamera),a.e.TransformCoordinates(this.absolutePosition,e.getViewMatrix())},t.prototype.getDistanceToCamera=function(e){return void 0===e&&(e=null),e||(e=this.getScene().activeCamera),this.absolutePosition.subtract(e.globalPosition).length()},t.prototype.clone=function(e,i,n){var o=this,a=r.a.Clone(function(){return new t(e,o.getScene())},this);if(a.name=e,a.id=e,i&&(a.parent=i),!n)for(var s=this.getDescendants(!0),c=0;c<s.length;c++){var l=s[c];l.clone&&l.clone(e+"."+l.name,a)}return a},t.prototype.serialize=function(e){var t=r.a.Serialize(this,e);return t.type=this.getClassName(),this.parent&&(t.parentId=this.parent.id),t.localMatrix=this.getPivotMatrix().asArray(),t.isEnabled=this.isEnabled(),this.parent&&(t.parentId=this.parent.id),t},t.Parse=function(e,i,n){var o=r.a.Parse(function(){return new t(e.name,i)},e,i,n);return e.localMatrix?o.setPreTransformMatrix(a.a.FromArray(e.localMatrix)):e.pivotMatrix&&o.setPivotMatrix(a.a.FromArray(e.pivotMatrix)),o.setEnabled(e.isEnabled),e.parentId&&(o._waitingParentId=e.parentId),o},t.prototype.getChildTransformNodes=function(e,i){var n=[];return this._getDescendants(n,e,function(e){return(!i||i(e))&&e instanceof t}),n},t.prototype.dispose=function(t,i){if(void 0===i&&(i=!1),this.getScene().stopAnimation(this),this.getScene().removeTransformNode(this),this.onAfterWorldMatrixUpdateObservable.clear(),t)for(var n=0,r=this.getChildTransformNodes(!0);n<r.length;n++){var o=r[n];o.parent=null,o.computeWorldMatrix(!0)}e.prototype.dispose.call(this,t,i)},t.prototype.normalizeToUnitCube=function(e,t,i){void 0===e&&(e=!0),void 0===t&&(t=!1);var n=null,r=null;t&&(this.rotationQuaternion?(r=this.rotationQuaternion.clone(),this.rotationQuaternion.copyFromFloats(0,0,0,1)):this.rotation&&(n=this.rotation.clone(),this.rotation.copyFromFloats(0,0,0)));var o=this.getHierarchyBoundingVectors(e,i),a=o.max.subtract(o.min),s=Math.max(a.x,a.y,a.z);if(0===s)return this;var c=1/s;return this.scaling.scaleInPlace(c),t&&(this.rotationQuaternion&&r?this.rotationQuaternion.copyFrom(r):this.rotation&&n&&this.rotation.copyFrom(n)),this},t.prototype._syncAbsoluteScalingAndRotation=function(){this._isAbsoluteSynced||(this._worldMatrix.decompose(this._absoluteScaling,this._absoluteRotationQuaternion),this._isAbsoluteSynced=!0)},t.BILLBOARDMODE_NONE=0,t.BILLBOARDMODE_X=1,t.BILLBOARDMODE_Y=2,t.BILLBOARDMODE_Z=4,t.BILLBOARDMODE_ALL=7,t.BILLBOARDMODE_USE_POSITION=128,t._lookAtVectorCache=new a.e(0,0,0),t._rotationAxisCache=new a.b,Object(n.c)([Object(r.o)("position")],t.prototype,"_position",void 0),Object(n.c)([Object(r.o)("rotation")],t.prototype,"_rotation",void 0),Object(n.c)([Object(r.l)("rotationQuaternion")],t.prototype,"_rotationQuaternion",void 0),Object(n.c)([Object(r.o)("scaling")],t.prototype,"_scaling",void 0),Object(n.c)([Object(r.c)("billboardMode")],t.prototype,"_billboardMode",void 0),Object(n.c)([Object(r.c)()],t.prototype,"scalingDeterminant",void 0),Object(n.c)([Object(r.c)("infiniteDistance")],t.prototype,"_infiniteDistance",void 0),Object(n.c)([Object(r.c)()],t.prototype,"ignoreNonUniformScaling",void 0),Object(n.c)([Object(r.c)()],t.prototype,"reIntegrateRotationIntoRotationQuaternion",void 0),t}(s.a)},function(e,t,i){"use strict";i.d(t,"a",function(){return d});var n=i(42),r=i(0),o=i(2),a=i(96),s=i(104),c={min:0,max:0},l={min:0,max:0},u=function(e,t,i){var n=r.e.Dot(t.centerWorld,e),o=Math.abs(r.e.Dot(t.directions[0],e))*t.extendSize.x+Math.abs(r.e.Dot(t.directions[1],e))*t.extendSize.y+Math.abs(r.e.Dot(t.directions[2],e))*t.extendSize.z;i.min=n-o,i.max=n+o},h=function(e,t,i){return u(e,t,c),u(e,i,l),!(c.min>l.max||l.min>c.max)},d=function(){function e(e,t,i){this._isLocked=!1,this.boundingBox=new a.a(e,t,i),this.boundingSphere=new s.a(e,t,i)}return e.prototype.reConstruct=function(e,t,i){this.boundingBox.reConstruct(e,t,i),this.boundingSphere.reConstruct(e,t,i)},Object.defineProperty(e.prototype,"minimum",{get:function(){return this.boundingBox.minimum},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"maximum",{get:function(){return this.boundingBox.maximum},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"isLocked",{get:function(){return this._isLocked},set:function(e){this._isLocked=e},enumerable:!0,configurable:!0}),e.prototype.update=function(e){this._isLocked||(this.boundingBox._update(e),this.boundingSphere._update(e))},e.prototype.centerOn=function(t,i){var n=e.TmpVector3[0].copyFrom(t).subtractInPlace(i),r=e.TmpVector3[1].copyFrom(t).addInPlace(i);return this.boundingBox.reConstruct(n,r,this.boundingBox.getWorldMatrix()),this.boundingSphere.reConstruct(n,r,this.boundingBox.getWorldMatrix()),this},e.prototype.scale=function(e){return this.boundingBox.scale(e),this.boundingSphere.scale(e),this},e.prototype.isInFrustum=function(e,t){return void 0===t&&(t=o.a.MESHES_CULLINGSTRATEGY_STANDARD),!(t!==o.a.MESHES_CULLINGSTRATEGY_OPTIMISTIC_INCLUSION&&t!==o.a.MESHES_CULLINGSTRATEGY_OPTIMISTIC_INCLUSION_THEN_BSPHERE_ONLY||!this.boundingSphere.isCenterInFrustum(e))||!!this.boundingSphere.isInFrustum(e)&&(!(t!==o.a.MESHES_CULLINGSTRATEGY_BOUNDINGSPHERE_ONLY&&t!==o.a.MESHES_CULLINGSTRATEGY_OPTIMISTIC_INCLUSION_THEN_BSPHERE_ONLY)||this.boundingBox.isInFrustum(e))},Object.defineProperty(e.prototype,"diagonalLength",{get:function(){var t=this.boundingBox;return t.maximumWorld.subtractToRef(t.minimumWorld,e.TmpVector3[0]).length()},enumerable:!0,configurable:!0}),e.prototype.isCompletelyInFrustum=function(e){return this.boundingBox.isCompletelyInFrustum(e)},e.prototype._checkCollision=function(e){return e._canDoCollision(this.boundingSphere.centerWorld,this.boundingSphere.radiusWorld,this.boundingBox.minimumWorld,this.boundingBox.maximumWorld)},e.prototype.intersectsPoint=function(e){return!!this.boundingSphere.centerWorld&&(!!this.boundingSphere.intersectsPoint(e)&&!!this.boundingBox.intersectsPoint(e))},e.prototype.intersects=function(e,t){if(!s.a.Intersects(this.boundingSphere,e.boundingSphere))return!1;if(!a.a.Intersects(this.boundingBox,e.boundingBox))return!1;if(!t)return!0;var i=this.boundingBox,n=e.boundingBox;return!!h(i.directions[0],i,n)&&(!!h(i.directions[1],i,n)&&(!!h(i.directions[2],i,n)&&(!!h(n.directions[0],i,n)&&(!!h(n.directions[1],i,n)&&(!!h(n.directions[2],i,n)&&(!!h(r.e.Cross(i.directions[0],n.directions[0]),i,n)&&(!!h(r.e.Cross(i.directions[0],n.directions[1]),i,n)&&(!!h(r.e.Cross(i.directions[0],n.directions[2]),i,n)&&(!!h(r.e.Cross(i.directions[1],n.directions[0]),i,n)&&(!!h(r.e.Cross(i.directions[1],n.directions[1]),i,n)&&(!!h(r.e.Cross(i.directions[1],n.directions[2]),i,n)&&(!!h(r.e.Cross(i.directions[2],n.directions[0]),i,n)&&(!!h(r.e.Cross(i.directions[2],n.directions[1]),i,n)&&!!h(r.e.Cross(i.directions[2],n.directions[2]),i,n))))))))))))))},e.TmpVector3=n.a.BuildArray(2,r.e.Zero),e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return n});var n=function(){function e(e,t,i,n,r,o){this.source=e,this.pointerX=t,this.pointerY=i,this.meshUnderPointer=n,this.sourceEvent=r,this.additionalData=o}return e.CreateNew=function(t,i,n){var r=t.getScene();return new e(t,r.pointerX,r.pointerY,r.meshUnderPointer||t,i,n)},e.CreateNewFromSprite=function(t,i,n,r){return new e(t,i.pointerX,i.pointerY,i.meshUnderPointer,n,r)},e.CreateNewFromScene=function(t,i){return new e(null,t.pointerX,t.pointerY,t.meshUnderPointer,i)},e.CreateNewFromPrimitive=function(t,i,n,r){return new e(t,i.x,i.y,null,n,r)},e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return c});var n=i(0),r=i(5),o=i(15),a=i(92),s=i(4);o.a.CreateLineSystem=function(e){for(var t=[],i=[],n=e.lines,r=e.colors,a=[],s=0,c=0;c<n.length;c++)for(var l=n[c],u=0;u<l.length;u++){if(i.push(l[u].x,l[u].y,l[u].z),r){var h=r[c];a.push(h[u].r,h[u].g,h[u].b,h[u].a)}u>0&&(t.push(s-1),t.push(s)),s++}var d=new o.a;return d.indices=t,d.positions=i,r&&(d.colors=a),d},o.a.CreateDashedLines=function(e){var t,i,r=e.dashSize||3,a=e.gapSize||1,s=e.dashNb||200,c=e.points,l=new Array,u=new Array,h=n.e.Zero(),d=0,f=0,p=0,_=0,m=0;for(m=0;m<c.length-1;m++)c[m+1].subtractToRef(c[m],h),d+=h.length();for(i=r*(t=d/s)/(r+a),m=0;m<c.length-1;m++){c[m+1].subtractToRef(c[m],h),f=Math.floor(h.length()/t),h.normalize();for(var g=0;g<f;g++)p=t*g,l.push(c[m].x+p*h.x,c[m].y+p*h.y,c[m].z+p*h.z),l.push(c[m].x+(p+i)*h.x,c[m].y+(p+i)*h.y,c[m].z+(p+i)*h.z),u.push(_,_+1),_+=2}var v=new o.a;return v.positions=l,v.indices=u,v},r.a.CreateLines=function(e,t,i,n,r){void 0===i&&(i=null),void 0===n&&(n=!1),void 0===r&&(r=null);var o={points:t,updatable:n,instance:r};return c.CreateLines(e,o,i)},r.a.CreateDashedLines=function(e,t,i,n,r,o,a,s){void 0===o&&(o=null);var l={points:t,dashSize:i,gapSize:n,dashNb:r,updatable:a,instance:s};return c.CreateDashedLines(e,l,o)};var c=function(){function e(){}return e.CreateLineSystem=function(e,t,i){var n=t.instance,r=t.lines,c=t.colors;if(n){var l,u,h=n.getVerticesData(s.b.PositionKind);c&&(l=n.getVerticesData(s.b.ColorKind));for(var d=0,f=0,p=0;p<r.length;p++)for(var _=r[p],m=0;m<_.length;m++)h[d]=_[m].x,h[d+1]=_[m].y,h[d+2]=_[m].z,c&&l&&(u=c[p],l[f]=u[m].r,l[f+1]=u[m].g,l[f+2]=u[m].b,l[f+3]=u[m].a,f+=4),d+=3;return n.updateVerticesData(s.b.PositionKind,h,!1,!1),c&&l&&n.updateVerticesData(s.b.ColorKind,l,!1,!1),n}var g=!!c,v=new a.b(e,i,null,void 0,void 0,g,t.useVertexAlpha);return o.a.CreateLineSystem(t).applyToMesh(v,t.updatable),v},e.CreateLines=function(t,i,n){void 0===n&&(n=null);var r=i.colors?[i.colors]:null;return e.CreateLineSystem(t,{lines:[i.points],updatable:i.updatable,instance:i.instance,colors:r,useVertexAlpha:i.useVertexAlpha},n)},e.CreateDashedLines=function(e,t,i){void 0===i&&(i=null);var s=t.points,c=t.instance,l=t.gapSize||1,u=t.dashSize||3;if(c){return c.updateMeshPositions(function(e){var t,i,r=n.e.Zero(),o=e.length/6,a=0,l=0,u=0,h=0,d=0,f=0;for(d=0;d<s.length-1;d++)s[d+1].subtractToRef(s[d],r),a+=r.length();t=a/o;var p=c._creationDataStorage.dashSize;for(i=p*t/(p+c._creationDataStorage.gapSize),d=0;d<s.length-1;d++)for(s[d+1].subtractToRef(s[d],r),l=Math.floor(r.length()/t),r.normalize(),f=0;f<l&&h<e.length;)u=t*f,e[h]=s[d].x+u*r.x,e[h+1]=s[d].y+u*r.y,e[h+2]=s[d].z+u*r.z,e[h+3]=s[d].x+(u+i)*r.x,e[h+4]=s[d].y+(u+i)*r.y,e[h+5]=s[d].z+(u+i)*r.z,h+=6,f++;for(;h<e.length;)e[h]=s[d].x,e[h+1]=s[d].y,e[h+2]=s[d].z,h+=3},!1),c}var h=new a.b(e,i,null,void 0,void 0,void 0,t.useVertexAlpha);return o.a.CreateDashedLines(t).applyToMesh(h,t.updatable),h._creationDataStorage=new r.b,h._creationDataStorage.dashSize=u,h._creationDataStorage.gapSize=l,h},e}()},function(e,t,i){"use strict";i.d(t,"e",function(){return r}),i.d(t,"a",function(){return o}),i.d(t,"d",function(){return a}),i.d(t,"c",function(){return s}),i.d(t,"b",function(){return c});var n=i(1),r=function(){function e(e,t){this.type=e,this.jointData=t,t.nativeParams=t.nativeParams||{}}return Object.defineProperty(e.prototype,"physicsJoint",{get:function(){return this._physicsJoint},set:function(e){this._physicsJoint,this._physicsJoint=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"physicsPlugin",{set:function(e){this._physicsPlugin=e},enumerable:!0,configurable:!0}),e.prototype.executeNativeFunction=function(e){e(this._physicsPlugin.world,this._physicsJoint)},e.DistanceJoint=0,e.HingeJoint=1,e.BallAndSocketJoint=2,e.WheelJoint=3,e.SliderJoint=4,e.PrismaticJoint=5,e.UniversalJoint=6,e.Hinge2Joint=e.WheelJoint,e.PointToPointJoint=8,e.SpringJoint=9,e.LockJoint=10,e}(),o=function(e){function t(t){return e.call(this,r.DistanceJoint,t)||this}return Object(n.d)(t,e),t.prototype.updateDistance=function(e,t){this._physicsPlugin.updateDistanceJoint(this,e,t)},t}(r),a=function(e){function t(t,i){return e.call(this,t,i)||this}return Object(n.d)(t,e),t.prototype.setMotor=function(e,t){this._physicsPlugin.setMotor(this,e||0,t)},t.prototype.setLimit=function(e,t){this._physicsPlugin.setLimit(this,e,t)},t}(r),s=function(e){function t(t){return e.call(this,r.HingeJoint,t)||this}return Object(n.d)(t,e),t.prototype.setMotor=function(e,t){this._physicsPlugin.setMotor(this,e||0,t)},t.prototype.setLimit=function(e,t){this._physicsPlugin.setLimit(this,e,t)},t}(a),c=function(e){function t(t){return e.call(this,r.Hinge2Joint,t)||this}return Object(n.d)(t,e),t.prototype.setMotor=function(e,t,i){void 0===i&&(i=0),this._physicsPlugin.setMotor(this,e||0,t,i)},t.prototype.setLimit=function(e,t,i){void 0===i&&(i=0),this._physicsPlugin.setLimit(this,e,t,i)},t}(a)},function(e,t,i){"use strict";i.d(t,"a",function(){return a});var n=i(0),r=i(5),o=i(15);o.a.CreateSphere=function(e){for(var t=e.segments||32,i=e.diameterX||e.diameter||1,r=e.diameterY||e.diameter||1,a=e.diameterZ||e.diameter||1,s=e.arc&&(e.arc<=0||e.arc>1)?1:e.arc||1,c=e.slice&&e.slice<=0?1:e.slice||1,l=0===e.sideOrientation?0:e.sideOrientation||o.a.DEFAULTSIDE,u=new n.e(i/2,r/2,a/2),h=2+t,d=2*h,f=[],p=[],_=[],m=[],g=0;g<=h;g++){for(var v=g/h,y=v*Math.PI*c,b=0;b<=d;b++){var T=b/d,E=T*Math.PI*2*s,x=n.a.RotationZ(-y),P=n.a.RotationY(E),A=n.e.TransformCoordinates(n.e.Up(),x),S=n.e.TransformCoordinates(A,P),C=S.multiply(u),R=S.divide(u).normalize();p.push(C.x,C.y,C.z),_.push(R.x,R.y,R.z),m.push(T,v)}if(g>0)for(var O=p.length/3,M=O-2*(d+1);M+d+2<O;M++)f.push(M),f.push(M+1),f.push(M+d+1),f.push(M+d+1),f.push(M+1),f.push(M+d+2)}o.a._ComputeSides(l,p,f,_,m,e.frontUVs,e.backUVs);var I=new o.a;return I.indices=f,I.positions=p,I.normals=_,I.uvs=m,I},r.a.CreateSphere=function(e,t,i,n,r,o){var s={segments:t,diameterX:i,diameterY:i,diameterZ:i,sideOrientation:o,updatable:r};return a.CreateSphere(e,s,n)};var a=function(){function e(){}return e.CreateSphere=function(e,t,i){void 0===i&&(i=null);var n=new r.a(e,i);return t.sideOrientation=r.a._GetDefaultSideOrientation(t.sideOrientation),n._originalBuilderSideOrientation=t.sideOrientation,o.a.CreateSphere(t).applyToMesh(n,t.updatable),n},e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return h});var n=i(1),r=i(3),o=i(6),a=i(0),s=i(23),c=i(2),l=i(137),u=i(68),h=(i(54),function(){function e(t){this.metadata=null,this.reservedDataStore=null,this._hasAlpha=!1,this.getAlphaFromRGB=!1,this.level=1,this.coordinatesIndex=0,this._coordinatesMode=c.a.TEXTURE_EXPLICIT_MODE,this.wrapU=c.a.TEXTURE_WRAP_ADDRESSMODE,this.wrapV=c.a.TEXTURE_WRAP_ADDRESSMODE,this.wrapR=c.a.TEXTURE_WRAP_ADDRESSMODE,this.anisotropicFilteringLevel=e.DEFAULT_ANISOTROPIC_FILTERING_LEVEL,this.gammaSpace=!0,this.invertZ=!1,this.lodLevelInAlpha=!1,this.isRenderTarget=!1,this.animations=new Array,this.onDisposeObservable=new o.c,this._onDisposeObserver=null,this.delayLoadState=c.a.DELAYLOADSTATE_NONE,this._scene=null,this._texture=null,this._uid=null,this._cachedSize=u.a.Zero(),this._scene=t||s.a.LastCreatedScene,this._scene&&(this.uniqueId=this._scene.getUniqueId(),this._scene.addTexture(this)),this._uid=null}return Object.defineProperty(e.prototype,"hasAlpha",{get:function(){return this._hasAlpha},set:function(e){this._hasAlpha!==e&&(this._hasAlpha=e,this._scene&&this._scene.markAllMaterialsAsDirty(c.a.MATERIAL_TextureDirtyFlag|c.a.MATERIAL_MiscDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"coordinatesMode",{get:function(){return this._coordinatesMode},set:function(e){this._coordinatesMode!==e&&(this._coordinatesMode=e,this._scene&&this._scene.markAllMaterialsAsDirty(c.a.MATERIAL_TextureDirtyFlag))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"isCube",{get:function(){return!!this._texture&&this._texture.isCube},set:function(e){this._texture&&(this._texture.isCube=e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"is3D",{get:function(){return!!this._texture&&this._texture.is3D},set:function(e){this._texture&&(this._texture.is3D=e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"is2DArray",{get:function(){return!!this._texture&&this._texture.is2DArray},set:function(e){this._texture&&(this._texture.is2DArray=e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"isRGBD",{get:function(){return null!=this._texture&&this._texture._isRGBD},set:function(e){this._texture&&(this._texture._isRGBD=e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"noMipmap",{get:function(){return!1},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"lodGenerationOffset",{get:function(){return this._texture?this._texture._lodGenerationOffset:0},set:function(e){this._texture&&(this._texture._lodGenerationOffset=e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"lodGenerationScale",{get:function(){return this._texture?this._texture._lodGenerationScale:0},set:function(e){this._texture&&(this._texture._lodGenerationScale=e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"linearSpecularLOD",{get:function(){return!!this._texture&&this._texture._linearSpecularLOD},set:function(e){this._texture&&(this._texture._linearSpecularLOD=e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"irradianceTexture",{get:function(){return this._texture?this._texture._irradianceTexture:null},set:function(e){this._texture&&(this._texture._irradianceTexture=e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"uid",{get:function(){return this._uid||(this._uid=l.a.RandomId()),this._uid},enumerable:!0,configurable:!0}),e.prototype.toString=function(){return this.name},e.prototype.getClassName=function(){return"BaseTexture"},Object.defineProperty(e.prototype,"onDispose",{set:function(e){this._onDisposeObserver&&this.onDisposeObservable.remove(this._onDisposeObserver),this._onDisposeObserver=this.onDisposeObservable.add(e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"isBlocking",{get:function(){return!0},enumerable:!0,configurable:!0}),e.prototype.getScene=function(){return this._scene},e.prototype.getTextureMatrix=function(){return a.a.IdentityReadOnly},e.prototype.getReflectionTextureMatrix=function(){return a.a.IdentityReadOnly},e.prototype.getInternalTexture=function(){return this._texture},e.prototype.isReadyOrNotBlocking=function(){return!this.isBlocking||this.isReady()},e.prototype.isReady=function(){return this.delayLoadState===c.a.DELAYLOADSTATE_NOTLOADED?(this.delayLoad(),!1):!!this._texture&&this._texture.isReady},e.prototype.getSize=function(){if(this._texture){if(this._texture.width)return this._cachedSize.width=this._texture.width,this._cachedSize.height=this._texture.height,this._cachedSize;if(this._texture._size)return this._cachedSize.width=this._texture._size,this._cachedSize.height=this._texture._size,this._cachedSize}return this._cachedSize},e.prototype.getBaseSize=function(){return this.isReady()&&this._texture?this._texture._size?new u.a(this._texture._size,this._texture._size):new u.a(this._texture.baseWidth,this._texture.baseHeight):u.a.Zero()},e.prototype.updateSamplingMode=function(e){if(this._texture){var t=this.getScene();t&&t.getEngine().updateTextureSamplingMode(e,this._texture)}},e.prototype.scale=function(e){},Object.defineProperty(e.prototype,"canRescale",{get:function(){return!1},enumerable:!0,configurable:!0}),e.prototype._getFromCache=function(e,t,i,n){if(!this._scene)return null;for(var r=this._scene.getEngine().getLoadedTexturesCache(),o=0;o<r.length;o++){var a=r[o];if(!(void 0!==n&&n!==a.invertY||a.url!==e||a.generateMipMaps!==!t||i&&i!==a.samplingMode))return a.incrementReferences(),a}return null},e.prototype._rebuild=function(){},e.prototype.delayLoad=function(){},e.prototype.clone=function(){return null},Object.defineProperty(e.prototype,"textureType",{get:function(){return this._texture&&void 0!==this._texture.type?this._texture.type:c.a.TEXTURETYPE_UNSIGNED_INT},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"textureFormat",{get:function(){return this._texture&&void 0!==this._texture.format?this._texture.format:c.a.TEXTUREFORMAT_RGBA},enumerable:!0,configurable:!0}),e.prototype._markAllSubMeshesAsTexturesDirty=function(){var e=this.getScene();e&&e.markAllMaterialsAsDirty(c.a.MATERIAL_TextureDirtyFlag)},e.prototype.readPixels=function(e,t,i){if(void 0===e&&(e=0),void 0===t&&(t=0),void 0===i&&(i=null),!this._texture)return null;var n=this.getSize(),r=n.width,o=n.height,a=this.getScene();if(!a)return null;var s=a.getEngine();return 0!=t&&(r/=Math.pow(2,t),o/=Math.pow(2,t),r=Math.round(r),o=Math.round(o)),this._texture.isCube?s._readTexturePixels(this._texture,r,o,e,t,i):s._readTexturePixels(this._texture,r,o,-1,t,i)},e.prototype.releaseInternalTexture=function(){this._texture&&(this._texture.dispose(),this._texture=null)},Object.defineProperty(e.prototype,"_lodTextureHigh",{get:function(){return this._texture?this._texture._lodTextureHigh:null},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_lodTextureMid",{get:function(){return this._texture?this._texture._lodTextureMid:null},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_lodTextureLow",{get:function(){return this._texture?this._texture._lodTextureLow:null},enumerable:!0,configurable:!0}),e.prototype.dispose=function(){if(this._scene){this._scene.stopAnimation&&this._scene.stopAnimation(this),this._scene._removePendingData(this);var e=this._scene.textures.indexOf(this);e>=0&&this._scene.textures.splice(e,1),this._scene.onTextureRemovedObservable.notifyObservers(this)}void 0!==this._texture&&(this.releaseInternalTexture(),this.onDisposeObservable.notifyObservers(this),this.onDisposeObservable.clear())},e.prototype.serialize=function(){if(!this.name)return null;var e=r.a.Serialize(this);return r.a.AppendSerializedAnimations(this,e),e},e.WhenAllReady=function(e,t){var i=e.length;if(0!==i)for(var n,r,o=function(){if((n=e[a]).isReady())0==--i&&t();else if(r=n.onLoadObservable){var o=function(){r.removeCallback(o),0==--i&&t()};r.add(o)}},a=0;a<e.length;a++)o();else t()},e.DEFAULT_ANISOTROPIC_FILTERING_LEVEL=4,Object(n.c)([Object(r.c)()],e.prototype,"uniqueId",void 0),Object(n.c)([Object(r.c)()],e.prototype,"name",void 0),Object(n.c)([Object(r.c)()],e.prototype,"metadata",void 0),Object(n.c)([Object(r.c)("hasAlpha")],e.prototype,"_hasAlpha",void 0),Object(n.c)([Object(r.c)()],e.prototype,"getAlphaFromRGB",void 0),Object(n.c)([Object(r.c)()],e.prototype,"level",void 0),Object(n.c)([Object(r.c)()],e.prototype,"coordinatesIndex",void 0),Object(n.c)([Object(r.c)("coordinatesMode")],e.prototype,"_coordinatesMode",void 0),Object(n.c)([Object(r.c)()],e.prototype,"wrapU",void 0),Object(n.c)([Object(r.c)()],e.prototype,"wrapV",void 0),Object(n.c)([Object(r.c)()],e.prototype,"wrapR",void 0),Object(n.c)([Object(r.c)()],e.prototype,"anisotropicFilteringLevel",void 0),Object(n.c)([Object(r.c)()],e.prototype,"isCube",null),Object(n.c)([Object(r.c)()],e.prototype,"is3D",null),Object(n.c)([Object(r.c)()],e.prototype,"is2DArray",null),Object(n.c)([Object(r.c)(),Object(r.b)("_markAllSubMeshesAsTexturesDirty")],e.prototype,"gammaSpace",void 0),Object(n.c)([Object(r.c)()],e.prototype,"invertZ",void 0),Object(n.c)([Object(r.c)()],e.prototype,"lodLevelInAlpha",void 0),Object(n.c)([Object(r.c)()],e.prototype,"lodGenerationOffset",null),Object(n.c)([Object(r.c)()],e.prototype,"lodGenerationScale",null),Object(n.c)([Object(r.c)()],e.prototype,"linearSpecularLOD",null),Object(n.c)([Object(r.m)()],e.prototype,"irradianceTexture",null),Object(n.c)([Object(r.c)()],e.prototype,"isRenderTarget",void 0),e}())},function(e,t,i){"use strict";i.d(t,"a",function(){return u});var n=i(1),r=i(3),o=i(0),a=i(10),s=i(26),c=i(83),l=i(12),u=function(e){function t(i,n){var r=e.call(this,i,n)||this;return r.diffuse=new a.a(1,1,1),r.specular=new a.a(1,1,1),r.falloffType=t.FALLOFF_DEFAULT,r.intensity=1,r._range=Number.MAX_VALUE,r._inverseSquaredRange=0,r._photometricScale=1,r._intensityMode=t.INTENSITYMODE_AUTOMATIC,r._radius=1e-5,r.renderPriority=0,r._shadowEnabled=!0,r._excludeWithLayerMask=0,r._includeOnlyWithLayerMask=0,r._lightmapMode=0,r._excludedMeshesIds=new Array,r._includedOnlyMeshesIds=new Array,r._isLight=!0,r.getScene().addLight(r),r._uniformBuffer=new c.a(r.getScene().getEngine()),r._buildUniformLayout(),r.includedOnlyMeshes=new Array,r.excludedMeshes=new Array,r._resyncMeshes(),r}return Object(n.d)(t,e),Object.defineProperty(t.prototype,"range",{get:function(){return this._range},set:function(e){this._range=e,this._inverseSquaredRange=1/(this.range*this.range)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"intensityMode",{get:function(){return this._intensityMode},set:function(e){this._intensityMode=e,this._computePhotometricScale()},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"radius",{get:function(){return this._radius},set:function(e){this._radius=e,this._computePhotometricScale()},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"shadowEnabled",{get:function(){return this._shadowEnabled},set:function(e){this._shadowEnabled!==e&&(this._shadowEnabled=e,this._markMeshesAsLightDirty())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"includedOnlyMeshes",{get:function(){return this._includedOnlyMeshes},set:function(e){this._includedOnlyMeshes=e,this._hookArrayForIncludedOnly(e)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"excludedMeshes",{get:function(){return this._excludedMeshes},set:function(e){this._excludedMeshes=e,this._hookArrayForExcluded(e)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"excludeWithLayerMask",{get:function(){return this._excludeWithLayerMask},set:function(e){this._excludeWithLayerMask=e,this._resyncMeshes()},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"includeOnlyWithLayerMask",{get:function(){return this._includeOnlyWithLayerMask},set:function(e){this._includeOnlyWithLayerMask=e,this._resyncMeshes()},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"lightmapMode",{get:function(){return this._lightmapMode},set:function(e){this._lightmapMode!==e&&(this._lightmapMode=e,this._markMeshesAsLightDirty())},enumerable:!0,configurable:!0}),t.prototype.transferTexturesToEffect=function(e,t){return this},t.prototype._bindLight=function(e,t,i,n,r){void 0===r&&(r=!1);var o=e.toString(),s=!1;if(!r||!this._uniformBuffer._alreadyBound){if(this._uniformBuffer.bindToEffect(i,"Light"+o),this._renderId!==t.getRenderId()||!this._uniformBuffer.useUbo){this._renderId=t.getRenderId();var c=this.getScaledIntensity();this.transferToEffect(i,o),this.diffuse.scaleToRef(c,a.c.Color3[0]),this._uniformBuffer.updateColor4("vLightDiffuse",a.c.Color3[0],this.range,o),n&&(this.specular.scaleToRef(c,a.c.Color3[1]),this._uniformBuffer.updateColor4("vLightSpecular",a.c.Color3[1],this.radius,o)),s=!0}if(this.transferTexturesToEffect(i,o),t.shadowsEnabled&&this.shadowEnabled){var l=this.getShadowGenerator();l&&(l.bindShadowLight(o,i),s=!0)}s&&this._uniformBuffer.update()}},t.prototype.getClassName=function(){return"Light"},t.prototype.toString=function(e){var t="Name: "+this.name;if(t+=", type: "+["Point","Directional","Spot","Hemispheric"][this.getTypeID()],this.animations)for(var i=0;i<this.animations.length;i++)t+=", animation[0]: "+this.animations[i].toString(e);return t},t.prototype._syncParentEnabledState=function(){e.prototype._syncParentEnabledState.call(this),this.isDisposed()||this._resyncMeshes()},t.prototype.setEnabled=function(t){e.prototype.setEnabled.call(this,t),this._resyncMeshes()},t.prototype.getShadowGenerator=function(){return this._shadowGenerator},t.prototype.getAbsolutePosition=function(){return o.e.Zero()},t.prototype.canAffectMesh=function(e){return!e||!(this.includedOnlyMeshes&&this.includedOnlyMeshes.length>0&&-1===this.includedOnlyMeshes.indexOf(e))&&(!(this.excludedMeshes&&this.excludedMeshes.length>0&&-1!==this.excludedMeshes.indexOf(e))&&((0===this.includeOnlyWithLayerMask||0!=(this.includeOnlyWithLayerMask&e.layerMask))&&!(0!==this.excludeWithLayerMask&&this.excludeWithLayerMask&e.layerMask)))},t.CompareLightsPriority=function(e,t){return e.shadowEnabled!==t.shadowEnabled?(t.shadowEnabled?1:0)-(e.shadowEnabled?1:0):t.renderPriority-e.renderPriority},t.prototype.dispose=function(t,i){void 0===i&&(i=!1),this._shadowGenerator&&(this._shadowGenerator.dispose(),this._shadowGenerator=null),this.getScene().stopAnimation(this);for(var n=0,r=this.getScene().meshes;n<r.length;n++){r[n]._removeLightSource(this,!0)}this._uniformBuffer.dispose(),this.getScene().removeLight(this),e.prototype.dispose.call(this,t,i)},t.prototype.getTypeID=function(){return 0},t.prototype.getScaledIntensity=function(){return this._photometricScale*this.intensity},t.prototype.clone=function(e){var i=t.GetConstructorFromName(this.getTypeID(),e,this.getScene());return i?r.a.Clone(i,this):null},t.prototype.serialize=function(){var e=r.a.Serialize(this);return e.type=this.getTypeID(),this.parent&&(e.parentId=this.parent.id),this.excludedMeshes.length>0&&(e.excludedMeshesIds=[],this.excludedMeshes.forEach(function(t){e.excludedMeshesIds.push(t.id)})),this.includedOnlyMeshes.length>0&&(e.includedOnlyMeshesIds=[],this.includedOnlyMeshes.forEach(function(t){e.includedOnlyMeshesIds.push(t.id)})),r.a.AppendSerializedAnimations(this,e),e.ranges=this.serializeAnimationRanges(),e},t.GetConstructorFromName=function(e,t,i){var n=s.a.Construct("Light_Type_"+e,t,i);return n||null},t.Parse=function(e,i){var n=t.GetConstructorFromName(e.type,e.name,i);if(!n)return null;var o=r.a.Parse(n,e,i);if(e.excludedMeshesIds&&(o._excludedMeshesIds=e.excludedMeshesIds),e.includedOnlyMeshesIds&&(o._includedOnlyMeshesIds=e.includedOnlyMeshesIds),e.parentId&&(o._waitingParentId=e.parentId),void 0!==e.falloffType&&(o.falloffType=e.falloffType),void 0!==e.lightmapMode&&(o.lightmapMode=e.lightmapMode),e.animations){for(var a=0;a<e.animations.length;a++){var c=e.animations[a],u=l.a.GetClass("BABYLON.Animation");u&&o.animations.push(u.Parse(c))}s.a.ParseAnimationRanges(o,e,i)}return e.autoAnimate&&i.beginAnimation(o,e.autoAnimateFrom,e.autoAnimateTo,e.autoAnimateLoop,e.autoAnimateSpeed||1),o},t.prototype._hookArrayForExcluded=function(e){var t=this,i=e.push;e.push=function(){for(var n=[],r=0;r<arguments.length;r++)n[r]=arguments[r];for(var o=i.apply(e,n),a=0,s=n;a<s.length;a++){var c=s[a];c._resyncLightSource(t)}return o};var n=e.splice;e.splice=function(i,r){for(var o=n.apply(e,[i,r]),a=0,s=o;a<s.length;a++){s[a]._resyncLightSource(t)}return o};for(var r=0,o=e;r<o.length;r++){o[r]._resyncLightSource(this)}},t.prototype._hookArrayForIncludedOnly=function(e){var t=this,i=e.push;e.push=function(){for(var n=[],r=0;r<arguments.length;r++)n[r]=arguments[r];var o=i.apply(e,n);return t._resyncMeshes(),o};var n=e.splice;e.splice=function(i,r){var o=n.apply(e,[i,r]);return t._resyncMeshes(),o},this._resyncMeshes()},t.prototype._resyncMeshes=function(){for(var e=0,t=this.getScene().meshes;e<t.length;e++){t[e]._resyncLightSource(this)}},t.prototype._markMeshesAsLightDirty=function(){for(var e=0,t=this.getScene().meshes;e<t.length;e++){var i=t[e];-1!==i.lightSources.indexOf(this)&&i._markSubMeshesAsLightDirty()}},t.prototype._computePhotometricScale=function(){this._photometricScale=this._getPhotometricScale(),this.getScene().resetCachedMaterial()},t.prototype._getPhotometricScale=function(){var e=0,i=this.getTypeID(),n=this.intensityMode;switch(n===t.INTENSITYMODE_AUTOMATIC&&(n=i===t.LIGHTTYPEID_DIRECTIONALLIGHT?t.INTENSITYMODE_ILLUMINANCE:t.INTENSITYMODE_LUMINOUSINTENSITY),i){case t.LIGHTTYPEID_POINTLIGHT:case t.LIGHTTYPEID_SPOTLIGHT:switch(n){case t.INTENSITYMODE_LUMINOUSPOWER:e=1/(4*Math.PI);break;case t.INTENSITYMODE_LUMINOUSINTENSITY:e=1;break;case t.INTENSITYMODE_LUMINANCE:e=this.radius*this.radius}break;case t.LIGHTTYPEID_DIRECTIONALLIGHT:switch(n){case t.INTENSITYMODE_ILLUMINANCE:e=1;break;case t.INTENSITYMODE_LUMINANCE:var r=this.radius;r=Math.max(r,.001),e=2*Math.PI*(1-Math.cos(r))}break;case t.LIGHTTYPEID_HEMISPHERICLIGHT:e=1}return e},t.prototype._reorderLightsInScene=function(){var e=this.getScene();0!=this._renderPriority&&(e.requireLightSorting=!0),this.getScene().sortLightsByPriority()},t.FALLOFF_DEFAULT=0,t.FALLOFF_PHYSICAL=1,t.FALLOFF_GLTF=2,t.FALLOFF_STANDARD=3,t.LIGHTMAP_DEFAULT=0,t.LIGHTMAP_SPECULAR=1,t.LIGHTMAP_SHADOWSONLY=2,t.INTENSITYMODE_AUTOMATIC=0,t.INTENSITYMODE_LUMINOUSPOWER=1,t.INTENSITYMODE_LUMINOUSINTENSITY=2,t.INTENSITYMODE_ILLUMINANCE=3,t.INTENSITYMODE_LUMINANCE=4,t.LIGHTTYPEID_POINTLIGHT=0,t.LIGHTTYPEID_DIRECTIONALLIGHT=1,t.LIGHTTYPEID_SPOTLIGHT=2,t.LIGHTTYPEID_HEMISPHERICLIGHT=3,Object(n.c)([Object(r.e)()],t.prototype,"diffuse",void 0),Object(n.c)([Object(r.e)()],t.prototype,"specular",void 0),Object(n.c)([Object(r.c)()],t.prototype,"falloffType",void 0),Object(n.c)([Object(r.c)()],t.prototype,"intensity",void 0),Object(n.c)([Object(r.c)()],t.prototype,"range",null),Object(n.c)([Object(r.c)()],t.prototype,"intensityMode",null),Object(n.c)([Object(r.c)()],t.prototype,"radius",null),Object(n.c)([Object(r.c)()],t.prototype,"_renderPriority",void 0),Object(n.c)([Object(r.b)("_reorderLightsInScene")],t.prototype,"renderPriority",void 0),Object(n.c)([Object(r.c)("shadowEnabled")],t.prototype,"_shadowEnabled",void 0),Object(n.c)([Object(r.c)("excludeWithLayerMask")],t.prototype,"_excludeWithLayerMask",void 0),Object(n.c)([Object(r.c)("includeOnlyWithLayerMask")],t.prototype,"_includeOnlyWithLayerMask",void 0),Object(n.c)([Object(r.c)("lightmapMode")],t.prototype,"_lightmapMode",void 0),t}(s.a)},function(e,t,i){"use strict";i.d(t,"a",function(){return r});var n=i(52),r=function(){function e(){this._startMonitoringTime=0,this._min=0,this._max=0,this._average=0,this._lastSecAverage=0,this._current=0,this._totalValueCount=0,this._totalAccumulated=0,this._lastSecAccumulated=0,this._lastSecTime=0,this._lastSecValueCount=0}return Object.defineProperty(e.prototype,"min",{get:function(){return this._min},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"max",{get:function(){return this._max},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"average",{get:function(){return this._average},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"lastSecAverage",{get:function(){return this._lastSecAverage},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"current",{get:function(){return this._current},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"total",{get:function(){return this._totalAccumulated},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"count",{get:function(){return this._totalValueCount},enumerable:!0,configurable:!0}),e.prototype.fetchNewFrame=function(){this._totalValueCount++,this._current=0,this._lastSecValueCount++},e.prototype.addCount=function(t,i){e.Enabled&&(this._current+=t,i&&this._fetchResult())},e.prototype.beginMonitoring=function(){e.Enabled&&(this._startMonitoringTime=n.a.Now)},e.prototype.endMonitoring=function(t){if(void 0===t&&(t=!0),e.Enabled){t&&this.fetchNewFrame();var i=n.a.Now;this._current=i-this._startMonitoringTime,t&&this._fetchResult()}},e.prototype._fetchResult=function(){this._totalAccumulated+=this._current,this._lastSecAccumulated+=this._current,this._min=Math.min(this._min,this._current),this._max=Math.max(this._max,this._current),this._average=this._totalAccumulated/this._totalValueCount;var e=n.a.Now;e-this._lastSecTime>1e3&&(this._lastSecAverage=this._lastSecAccumulated/this._lastSecValueCount,this._lastSecTime=e,this._lastSecAccumulated=0,this._lastSecValueCount=0)},e.Enabled=!0,e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return r});var n=i(38),r=function(){function e(){}return Object.defineProperty(e,"Now",{get:function(){return n.a.IsWindowObjectExist()&&window.performance&&window.performance.now?window.performance.now():Date.now()},enumerable:!0,configurable:!0}),e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return o});var n=i(0),r=i(4),o=function(){function e(){this._pickingUnavailable=!1,this.hit=!1,this.distance=0,this.pickedPoint=null,this.pickedMesh=null,this.bu=0,this.bv=0,this.faceId=-1,this.subMeshId=0,this.pickedSprite=null,this.originMesh=null,this.ray=null}return e.prototype.getNormal=function(e,t){if(void 0===e&&(e=!1),void 0===t&&(t=!0),!this.pickedMesh||!this.pickedMesh.isVerticesDataPresent(r.b.NormalKind))return null;var i,o=this.pickedMesh.getIndices();if(!o)return null;if(t){var a=this.pickedMesh.getVerticesData(r.b.NormalKind),s=n.e.FromArray(a,3*o[3*this.faceId]),c=n.e.FromArray(a,3*o[3*this.faceId+1]),l=n.e.FromArray(a,3*o[3*this.faceId+2]);s=s.scale(this.bu),c=c.scale(this.bv),l=l.scale(1-this.bu-this.bv),i=new n.e(s.x+c.x+l.x,s.y+c.y+l.y,s.z+c.z+l.z)}else{var u=this.pickedMesh.getVerticesData(r.b.PositionKind),h=n.e.FromArray(u,3*o[3*this.faceId]),d=n.e.FromArray(u,3*o[3*this.faceId+1]),f=n.e.FromArray(u,3*o[3*this.faceId+2]),p=h.subtract(d),_=f.subtract(d);i=n.e.Cross(p,_)}if(e){var m=this.pickedMesh.getWorldMatrix();this.pickedMesh.nonUniformScaling&&(n.c.Matrix[0].copyFrom(m),(m=n.c.Matrix[0]).setTranslationFromFloats(0,0,0),m.invert(),m.transposeToRef(n.c.Matrix[1]),m=n.c.Matrix[1]),i=n.e.TransformNormal(i,m)}return i.normalize(),i},e.prototype.getTextureCoordinates=function(){if(!this.pickedMesh||!this.pickedMesh.isVerticesDataPresent(r.b.UVKind))return null;var e=this.pickedMesh.getIndices();if(!e)return null;var t=this.pickedMesh.getVerticesData(r.b.UVKind);if(!t)return null;var i=n.d.FromArray(t,2*e[3*this.faceId]),o=n.d.FromArray(t,2*e[3*this.faceId+1]),a=n.d.FromArray(t,2*e[3*this.faceId+2]);return i=i.scale(this.bu),o=o.scale(this.bv),a=a.scale(1-this.bu-this.bv),new n.d(i.x+o.x+a.x,i.y+o.y+a.y)},e}()},function(e,t,i){"use strict";var n=i(1),r=i(65),o=i(38),a=i(6),s=i(76),c=i(126),l=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return Object(n.d)(t,e),t._setPrototypeOf=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e},t}(Error),u=i(36),h=i(31),d=i(116);i.d(t,"b",function(){return f}),i.d(t,"d",function(){return p}),i.d(t,"c",function(){return _}),i.d(t,"a",function(){return m});var f=function(e){function t(i,n){var o=e.call(this,i)||this;return o.name="LoadFileError",l._setPrototypeOf(o,t.prototype),n instanceof r.a?o.request=n:o.file=n,o}return Object(n.d)(t,e),t}(l),p=function(e){function t(i,n){var r=e.call(this,i)||this;return r.request=n,r.name="RequestFileError",l._setPrototypeOf(r,t.prototype),r}return Object(n.d)(t,e),t}(l),_=function(e){function t(i,n){var r=e.call(this,i)||this;return r.file=n,r.name="ReadFileError",l._setPrototypeOf(r,t.prototype),r}return Object(n.d)(t,e),t}(l),m=function(){function e(){}return e._CleanUrl=function(e){return e=e.replace(/#/gm,"%23")},e.SetCorsBehavior=function(t,i){if((!t||0!==t.indexOf("data:"))&&e.CorsBehavior)if("string"==typeof e.CorsBehavior||this.CorsBehavior instanceof String)i.crossOrigin=e.CorsBehavior;else{var n=e.CorsBehavior(t);n&&(i.crossOrigin=n)}},e.LoadImage=function(t,i,n,r,o){var a;void 0===o&&(o="");var c=!1;if(t instanceof ArrayBuffer||ArrayBuffer.isView(t)?"undefined"!=typeof Blob?(a=URL.createObjectURL(new Blob([t],{type:o})),c=!0):a="data:"+o+";base64,"+u.a.EncodeArrayBufferToBase64(t):t instanceof Blob?(a=URL.createObjectURL(t),c=!0):(a=e._CleanUrl(t),a=e.PreprocessUrl(t)),"undefined"==typeof Image)return e.LoadFile(a,function(e){createImageBitmap(new Blob([e],{type:o})).then(function(e){i(e),c&&URL.revokeObjectURL(a)}).catch(function(e){n&&n("Error while trying to load image: "+t,e)})},void 0,r||void 0,!0,function(e,i){n&&n("Error while trying to load image: "+t,i)}),null;var l=new Image;e.SetCorsBehavior(a,l);var h=function(){l.removeEventListener("load",h),l.removeEventListener("error",d),i(l),c&&l.src&&URL.revokeObjectURL(l.src)},d=function(e){l.removeEventListener("load",h),l.removeEventListener("error",d),n&&n("Error while trying to load image: "+t,e),c&&l.src&&URL.revokeObjectURL(l.src)};l.addEventListener("load",h),l.addEventListener("error",d);var f=function(){l.src=a};if("data:"!==a.substr(0,5)&&r&&r.enableTexturesOffline)r.open(function(){r&&r.loadImage(a,l)},f);else{if(-1!==a.indexOf("file:")){var p=decodeURIComponent(a.substring(5).toLowerCase());if(s.a.FilesToLoad[p]){try{var _;try{_=URL.createObjectURL(s.a.FilesToLoad[p])}catch(e){_=URL.createObjectURL(s.a.FilesToLoad[p])}l.src=_,c=!0}catch(e){l.src=""}return l}}f()}return l},e.ReadFile=function(e,t,i,n,r){var o=new FileReader,s={onCompleteObservable:new a.c,abort:function(){return o.abort()}};return o.onloadend=function(e){return s.onCompleteObservable.notifyObservers(s)},r&&(o.onerror=function(t){r(new _("Unable to read "+e.name,e))}),o.onload=function(e){t(e.target.result)},i&&(o.onprogress=i),n?o.readAsArrayBuffer(e):o.readAsText(e),s},e.LoadFile=function(t,i,n,r,o,a){if(-1!==t.indexOf("file:")){var c=decodeURIComponent(t.substring(5).toLowerCase());0===c.indexOf("./")&&(c=c.substring(2));var l=s.a.FilesToLoad[c];if(l)return e.ReadFile(l,i,n,o,a?function(e){return a(void 0,new f(e.message,e.file))}:void 0)}return e.RequestFile(t,function(e,t){i(e,t?t.responseURL:void 0)},n,r,o,a?function(e){a(e.request,new f(e.message,e.request))}:void 0)},e.RequestFile=function(t,i,n,s,c,l,u){t=e._CleanUrl(t),t=e.PreprocessUrl(t);var h=e.BaseUrl+t,d=!1,f={onCompleteObservable:new a.c,abort:function(){return d=!0}},_=function(){var t=new r.a,a=null;f.abort=function(){d=!0,t.readyState!==(XMLHttpRequest.DONE||4)&&t.abort(),null!==a&&(clearTimeout(a),a=null)};var s=function(_){t.open("GET",h),u&&u(t),c&&(t.responseType="arraybuffer"),n&&t.addEventListener("progress",n);var m=function(){t.removeEventListener("loadend",m),f.onCompleteObservable.notifyObservers(f),f.onCompleteObservable.clear()};t.addEventListener("loadend",m);var g=function(){if(!d&&t.readyState===(XMLHttpRequest.DONE||4)){if(t.removeEventListener("readystatechange",g),t.status>=200&&t.status<300||0===t.status&&(!o.a.IsWindowObjectExist()||e.IsFileURL()))return void i(c?t.response:t.responseText,t);var n=e.DefaultRetryStrategy;if(n){var u=n(h,t,_);if(-1!==u)return t.removeEventListener("loadend",m),t=new r.a,void(a=setTimeout(function(){return s(_+1)},u))}var f=new p("Error status: "+t.status+" "+t.statusText+" - Unable to load "+h,t);l&&l(f)}};t.addEventListener("readystatechange",g),t.send()};s(0)};if(s&&s.enableSceneOffline){var m=function(e){e&&e.status>400?l&&l(e):_()};s.open(function(){s&&s.loadFile(e.BaseUrl+t,function(e){d||i(e),f.onCompleteObservable.notifyObservers(f)},n?function(e){d||n(e)}:void 0,m,c)},m)}else _();return f},e.IsFileURL=function(){return"file:"===location.protocol},e.DefaultRetryStrategy=c.a.ExponentialBackoff(),e.BaseUrl="",e.CorsBehavior="anonymous",e.PreprocessUrl=function(e){return e},e}();h.a._FileToolsLoadImage=m.LoadImage.bind(m),h.a._FileToolsLoadFile=m.LoadFile.bind(m),d.a._FileToolsLoadFile=m.LoadFile.bind(m)},function(e,t,i){"use strict";i.d(t,"a",function(){return r});var n=i(0),r=function(){function e(){}return e._RemoveAndStorePivotPoint=function(t){t&&0===e._PivotCached&&(t.getPivotPointToRef(e._OldPivotPoint),e._OldPivotPoint.equalsToFloats(0,0,0)||(t.setPivotMatrix(n.a.IdentityReadOnly),e._OldPivotPoint.subtractToRef(t.getPivotPoint(),e._PivotTranslation),e._PivotTmpVector.copyFromFloats(1,1,1),e._PivotTmpVector.subtractInPlace(t.scaling),e._PivotTmpVector.multiplyInPlace(e._PivotTranslation),t.position.addInPlace(e._PivotTmpVector))),e._PivotCached++},e._RestorePivotPoint=function(t){t&&!e._OldPivotPoint.equalsToFloats(0,0,0)&&1===e._PivotCached&&(t.setPivotPoint(e._OldPivotPoint),e._PivotTmpVector.copyFromFloats(1,1,1),e._PivotTmpVector.subtractInPlace(t.scaling),e._PivotTmpVector.multiplyInPlace(e._PivotTranslation),t.position.subtractInPlace(e._PivotTmpVector)),this._PivotCached--},e._PivotCached=0,e._OldPivotPoint=new n.e,e._PivotTranslation=new n.e,e._PivotTmpVector=new n.e,e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return a});var n=i(0),r=i(5),o=i(41),a=function(){function e(e){var t=this;void 0===e&&(e=o.a.DefaultUtilityLayer),this.gizmoLayer=e,this._attachedMesh=null,this.scaleRatio=1,this._customMeshSet=!1,this.updateGizmoRotationToMatchAttachedMesh=!0,this.updateGizmoPositionToMatchAttachedMesh=!0,this.updateScale=!0,this._interactionsEnabled=!0,this._tempVector=new n.e,this._rootMesh=new r.a("gizmoRootNode",e.utilityLayerScene),this._rootMesh.rotationQuaternion=n.b.Identity(),this._beforeRenderObserver=this.gizmoLayer.utilityLayerScene.onBeforeRenderObservable.add(function(){t._update()})}return Object.defineProperty(e.prototype,"attachedMesh",{get:function(){return this._attachedMesh},set:function(e){this._attachedMesh=e,this._rootMesh.setEnabled(!!e),this._attachedMeshChanged(e)},enumerable:!0,configurable:!0}),e.prototype.setCustomMesh=function(e){if(e.getScene()!=this.gizmoLayer.utilityLayerScene)throw"When setting a custom mesh on a gizmo, the custom meshes scene must be the same as the gizmos (eg. gizmo.gizmoLayer.utilityLayerScene)";this._rootMesh.getChildMeshes().forEach(function(e){e.dispose()}),e.parent=this._rootMesh,this._customMeshSet=!0},e.prototype._attachedMeshChanged=function(e){},e.prototype._update=function(){if(this.attachedMesh){var e=this.attachedMesh._effectiveMesh||this.attachedMesh;if(this.updateGizmoPositionToMatchAttachedMesh&&this._rootMesh.position.copyFrom(e.absolutePosition),this.updateGizmoRotationToMatchAttachedMesh?e.getWorldMatrix().decompose(void 0,this._rootMesh.rotationQuaternion):this._rootMesh.rotationQuaternion.set(0,0,0,1),this.updateScale){var t=this.gizmoLayer.utilityLayerScene.activeCamera,i=t.globalPosition;t.devicePosition&&(i=t.devicePosition),this._rootMesh.position.subtractToRef(i,this._tempVector);var n=this._tempVector.length()*this.scaleRatio;this._rootMesh.scaling.set(n,n,n),e._getWorldMatrixDeterminant()<0&&(this._rootMesh.scaling.y*=-1)}else this._rootMesh.scaling.setAll(this.scaleRatio)}},e.prototype.dispose=function(){this._rootMesh.dispose(),this._beforeRenderObserver&&this.gizmoLayer.utilityLayerScene.onBeforeRenderObservable.remove(this._beforeRenderObserver)},e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return l}),i.d(t,"b",function(){return u});var n=i(1),r=i(4),o=i(105),a=i(44),s=i(2),c=i(110),l=function(){function e(){this._materialDefines=null,this._materialEffect=null}return Object.defineProperty(e.prototype,"materialDefines",{get:function(){return this._materialDefines},set:function(e){this._materialDefines=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"effect",{get:function(){return this._materialEffect},enumerable:!0,configurable:!0}),e.prototype.setEffect=function(e,t){void 0===t&&(t=null),this._materialEffect!==e?(this._materialDefines=t,this._materialEffect=e):e||(this._materialDefines=null)},e}(),u=function(e){function t(t,i,n,r,o,a,s,c){void 0===c&&(c=!0);var l=e.call(this)||this;return l.materialIndex=t,l.verticesStart=i,l.verticesCount=n,l.indexStart=r,l.indexCount=o,l._linesIndexCount=0,l._linesIndexBuffer=null,l._lastColliderWorldVertices=null,l._lastColliderTransformMatrix=null,l._renderId=0,l._alphaIndex=0,l._distanceToCamera=0,l._currentMaterial=null,l._mesh=a,l._renderingMesh=s||a,a.subMeshes.push(l),l._trianglePlanes=[],l._id=a.subMeshes.length-1,c&&(l.refreshBoundingInfo(),a.computeWorldMatrix(!0)),l}return Object(n.d)(t,e),t.AddToMesh=function(e,i,n,r,o,a,s,c){return void 0===c&&(c=!0),new t(e,i,n,r,o,a,s,c)},Object.defineProperty(t.prototype,"IsGlobal",{get:function(){return 0===this.verticesStart&&this.verticesCount===this._mesh.getTotalVertices()},enumerable:!0,configurable:!0}),t.prototype.getBoundingInfo=function(){return this.IsGlobal?this._mesh.getBoundingInfo():this._boundingInfo},t.prototype.setBoundingInfo=function(e){return this._boundingInfo=e,this},t.prototype.getMesh=function(){return this._mesh},t.prototype.getRenderingMesh=function(){return this._renderingMesh},t.prototype.getMaterial=function(){var e=this._renderingMesh.material;if(null==e)return this._mesh.getScene().defaultMaterial;if(e.getSubMaterial){var t=e.getSubMaterial(this.materialIndex);return this._currentMaterial!==t&&(this._currentMaterial=t,this._materialDefines=null),t}return e},t.prototype.refreshBoundingInfo=function(e){if(void 0===e&&(e=null),this._lastColliderWorldVertices=null,this.IsGlobal||!this._renderingMesh||!this._renderingMesh.geometry)return this;if(e||(e=this._renderingMesh.getVerticesData(r.b.PositionKind)),!e)return this._boundingInfo=this._mesh.getBoundingInfo(),this;var t,i=this._renderingMesh.getIndices();if(0===this.indexStart&&this.indexCount===i.length){var n=this._renderingMesh.getBoundingInfo();t={minimum:n.minimum.clone(),maximum:n.maximum.clone()}}else t=Object(c.b)(e,i,this.indexStart,this.indexCount,this._renderingMesh.geometry.boundingBias);return this._boundingInfo?this._boundingInfo.reConstruct(t.minimum,t.maximum):this._boundingInfo=new a.a(t.minimum,t.maximum),this},t.prototype._checkCollision=function(e){return this.getBoundingInfo()._checkCollision(e)},t.prototype.updateBoundingInfo=function(e){var t=this.getBoundingInfo();return t||(this.refreshBoundingInfo(),t=this.getBoundingInfo()),t&&t.update(e),this},t.prototype.isInFrustum=function(e){var t=this.getBoundingInfo();return!!t&&t.isInFrustum(e,this._mesh.cullingStrategy)},t.prototype.isCompletelyInFrustum=function(e){var t=this.getBoundingInfo();return!!t&&t.isCompletelyInFrustum(e)},t.prototype.render=function(e){return this._renderingMesh.render(this,e,this._mesh._internalAbstractMeshDataInfo._actAsRegularMesh?this._mesh:void 0),this},t.prototype._getLinesIndexBuffer=function(e,t){if(!this._linesIndexBuffer){for(var i=[],n=this.indexStart;n<this.indexStart+this.indexCount;n+=3)i.push(e[n],e[n+1],e[n+1],e[n+2],e[n+2],e[n]);this._linesIndexBuffer=t.createIndexBuffer(i),this._linesIndexCount=i.length}return this._linesIndexBuffer},t.prototype.canIntersects=function(e){var t=this.getBoundingInfo();return!!t&&e.intersectsBox(t.boundingBox)},t.prototype.intersects=function(e,t,i,n,r){var o=this.getMaterial();if(!o)return null;var a=3,c=!1;switch(o.fillMode){case s.a.MATERIAL_PointListDrawMode:case s.a.MATERIAL_LineListDrawMode:case s.a.MATERIAL_LineLoopDrawMode:case s.a.MATERIAL_LineStripDrawMode:case s.a.MATERIAL_TriangleFanDrawMode:return null;case s.a.MATERIAL_TriangleStripDrawMode:a=1,c=!0}return"InstancedLinesMesh"===this._mesh.getClassName()||"LinesMesh"===this._mesh.getClassName()?i.length?this._intersectLines(e,t,i,this._mesh.intersectionThreshold,n):this._intersectUnIndexedLines(e,t,i,this._mesh.intersectionThreshold,n):!i.length&&this._mesh._unIndexed?this._intersectUnIndexedTriangles(e,t,i,n,r):this._intersectTriangles(e,t,i,a,c,n,r)},t.prototype._intersectLines=function(e,t,i,n,r){for(var a=null,s=this.indexStart;s<this.indexStart+this.indexCount;s+=2){var c=t[i[s]],l=t[i[s+1]],u=e.intersectionSegment(c,l,n);if(!(u<0)&&((r||!a||u<a.distance)&&((a=new o.a(null,null,u)).faceId=s/2,r)))break}return a},t.prototype._intersectUnIndexedLines=function(e,t,i,n,r){for(var a=null,s=this.verticesStart;s<this.verticesStart+this.verticesCount;s+=2){var c=t[s],l=t[s+1],u=e.intersectionSegment(c,l,n);if(!(u<0)&&((r||!a||u<a.distance)&&((a=new o.a(null,null,u)).faceId=s/2,r)))break}return a},t.prototype._intersectTriangles=function(e,t,i,n,r,o,a){for(var s=null,c=-1,l=this.indexStart;l<this.indexStart+this.indexCount;l+=n){c++;var u=i[l],h=i[l+1],d=i[l+2];if(r&&4294967295===d)l+=2;else{var f=t[u],p=t[h],_=t[d];if(!a||a(f,p,_,e)){var m=e.intersectsTriangle(f,p,_);if(m){if(m.distance<0)continue;if((o||!s||m.distance<s.distance)&&((s=m).faceId=c,o))break}}}}return s},t.prototype._intersectUnIndexedTriangles=function(e,t,i,n,r){for(var o=null,a=this.verticesStart;a<this.verticesStart+this.verticesCount;a+=3){var s=t[a],c=t[a+1],l=t[a+2];if(!r||r(s,c,l,e)){var u=e.intersectsTriangle(s,c,l);if(u){if(u.distance<0)continue;if((n||!o||u.distance<o.distance)&&((o=u).faceId=a/3,n))break}}}return o},t.prototype._rebuild=function(){this._linesIndexBuffer&&(this._linesIndexBuffer=null)},t.prototype.clone=function(e,i){var n=new t(this.materialIndex,this.verticesStart,this.verticesCount,this.indexStart,this.indexCount,e,i,!1);if(!this.IsGlobal){var r=this.getBoundingInfo();if(!r)return n;n._boundingInfo=new a.a(r.minimum,r.maximum)}return n},t.prototype.dispose=function(){this._linesIndexBuffer&&(this._mesh.getScene().getEngine()._releaseBuffer(this._linesIndexBuffer),this._linesIndexBuffer=null);var e=this._mesh.subMeshes.indexOf(this);this._mesh.subMeshes.splice(e,1)},t.prototype.getClassName=function(){return"SubMesh"},t.CreateFromIndices=function(e,i,n,r,o){for(var a=Number.MAX_VALUE,s=-Number.MAX_VALUE,c=(o||r).getIndices(),l=i;l<i+n;l++){var u=c[l];u<a&&(a=u),u>s&&(s=u)}return new t(e,a,s-a+1,i,n,r,o)},t}(l)},function(e,t,i){"use strict";var n="helperFunctions",r="const float PI=3.1415926535897932384626433832795;\nconst float LinearEncodePowerApprox=2.2;\nconst float GammaEncodePowerApprox=1.0/LinearEncodePowerApprox;\nconst vec3 LuminanceEncodeApprox=vec3(0.2126,0.7152,0.0722);\nconst float Epsilon=0.0000001;\n#define saturate(x) clamp(x,0.0,1.0)\n#define absEps(x) abs(x)+Epsilon\n#define maxEps(x) max(x,Epsilon)\n#define saturateEps(x) clamp(x,Epsilon,1.0)\nmat3 transposeMat3(mat3 inMatrix) {\nvec3 i0=inMatrix[0];\nvec3 i1=inMatrix[1];\nvec3 i2=inMatrix[2];\nmat3 outMatrix=mat3(\nvec3(i0.x,i1.x,i2.x),\nvec3(i0.y,i1.y,i2.y),\nvec3(i0.z,i1.z,i2.z)\n);\nreturn outMatrix;\n}\n\nmat3 inverseMat3(mat3 inMatrix) {\nfloat a00=inMatrix[0][0],a01=inMatrix[0][1],a02=inMatrix[0][2];\nfloat a10=inMatrix[1][0],a11=inMatrix[1][1],a12=inMatrix[1][2];\nfloat a20=inMatrix[2][0],a21=inMatrix[2][1],a22=inMatrix[2][2];\nfloat b01=a22*a11-a12*a21;\nfloat b11=-a22*a10+a12*a20;\nfloat b21=a21*a10-a11*a20;\nfloat det=a00*b01+a01*b11+a02*b21;\nreturn mat3(b01,(-a22*a01+a02*a21),(a12*a01-a02*a11),\nb11,(a22*a00-a02*a20),(-a12*a00+a02*a10),\nb21,(-a21*a00+a01*a20),(a11*a00-a01*a10))/det;\n}\nvec3 toLinearSpace(vec3 color)\n{\nreturn pow(color,vec3(LinearEncodePowerApprox));\n}\nvec3 toGammaSpace(vec3 color)\n{\nreturn pow(color,vec3(GammaEncodePowerApprox));\n}\nfloat toGammaSpace(float color)\n{\nreturn pow(color,GammaEncodePowerApprox);\n}\nfloat square(float value)\n{\nreturn value*value;\n}\nfloat pow5(float value) {\nfloat sq=value*value;\nreturn sq*sq*value;\n}\nfloat getLuminance(vec3 color)\n{\nreturn clamp(dot(color,LuminanceEncodeApprox),0.,1.);\n}\n\nfloat getRand(vec2 seed) {\nreturn fract(sin(dot(seed.xy ,vec2(12.9898,78.233)))*43758.5453);\n}\nfloat dither(vec2 seed,float varianceAmount) {\nfloat rand=getRand(seed);\nfloat dither=mix(-varianceAmount/255.0,varianceAmount/255.0,rand);\nreturn dither;\n}\n\nconst float rgbdMaxRange=255.0;\nvec4 toRGBD(vec3 color) {\nfloat maxRGB=maxEps(max(color.r,max(color.g,color.b)));\nfloat D=max(rgbdMaxRange/maxRGB,1.);\nD=clamp(floor(D)/255.0,0.,1.);\n\nvec3 rgb=color.rgb*D;\n\nrgb=toGammaSpace(rgb);\nreturn vec4(rgb,D);\n}\nvec3 fromRGBD(vec4 rgbd) {\n\nrgbd.rgb=toLinearSpace(rgbd.rgb);\n\nreturn rgbd.rgb/rgbd.a;\n}\n";i(8).a.IncludesShadersStore[n]=r},function(e,t,i){"use strict";i.d(t,"a",function(){return l});var n=i(0),r=i(10),o=i(5),a=i(15),s=i(18),c=i(22);a.a.CreateCylinder=function(e){var t=e.height||2,i=0===e.diameterTop?0:e.diameterTop||e.diameter||1,s=0===e.diameterBottom?0:e.diameterBottom||e.diameter||1;i=i||1e-5,s=s||1e-5;var l,u=e.tessellation||24,h=e.subdivisions||1,d=!!e.hasRings,f=!!e.enclose,p=0===e.cap?0:e.cap||o.a.CAP_ALL,_=e.arc&&(e.arc<=0||e.arc>1)?1:e.arc||1,m=0===e.sideOrientation?0:e.sideOrientation||a.a.DEFAULTSIDE,g=e.faceUV||new Array(3),v=e.faceColors,y=2+(1+(1!==_&&f?2:0))*(d?h:1);for(l=0;l<y;l++)v&&void 0===v[l]&&(v[l]=new r.b(1,1,1,1));for(l=0;l<y;l++)g&&void 0===g[l]&&(g[l]=new n.f(0,0,1,1));var b,T,E,x,P,A,S=new Array,C=new Array,R=new Array,O=new Array,M=new Array,I=2*Math.PI*_/u,D=(s-i)/2/t,w=n.e.Zero(),L=n.e.Zero(),N=n.e.Zero(),F=n.e.Zero(),B=n.e.Zero(),U=c.a.Y,V=1,k=1,z=0,G=0;for(x=0;x<=h;x++)for(E=((T=x/h)*(i-s)+s)/2,V=d&&0!==x&&x!==h?2:1,A=0;A<V;A++){for(d&&(k+=A),f&&(k+=2*A),P=0;P<=u;P++)b=P*I,w.x=Math.cos(-b)*E,w.y=-t/2+T*t,w.z=Math.sin(-b)*E,0===i&&x===h?(L.x=R[R.length-3*(u+1)],L.y=R[R.length-3*(u+1)+1],L.z=R[R.length-3*(u+1)+2]):(L.x=w.x,L.z=w.z,L.y=Math.sqrt(L.x*L.x+L.z*L.z)*D,L.normalize()),0===P&&(N.copyFrom(w),F.copyFrom(L)),C.push(w.x,w.y,w.z),R.push(L.x,L.y,L.z),G=d?z!==k?g[k].y:g[k].w:g[k].y+(g[k].w-g[k].y)*T,O.push(g[k].x+(g[k].z-g[k].x)*P/u,G),v&&M.push(v[k].r,v[k].g,v[k].b,v[k].a);1!==_&&f&&(C.push(w.x,w.y,w.z),C.push(0,w.y,0),C.push(0,w.y,0),C.push(N.x,N.y,N.z),n.e.CrossToRef(U,L,B),B.normalize(),R.push(B.x,B.y,B.z,B.x,B.y,B.z),n.e.CrossToRef(F,U,B),B.normalize(),R.push(B.x,B.y,B.z,B.x,B.y,B.z),G=d?z!==k?g[k+1].y:g[k+1].w:g[k+1].y+(g[k+1].w-g[k+1].y)*T,O.push(g[k+1].x,G),O.push(g[k+1].z,G),G=d?z!==k?g[k+2].y:g[k+2].w:g[k+2].y+(g[k+2].w-g[k+2].y)*T,O.push(g[k+2].x,G),O.push(g[k+2].z,G),v&&(M.push(v[k+1].r,v[k+1].g,v[k+1].b,v[k+1].a),M.push(v[k+1].r,v[k+1].g,v[k+1].b,v[k+1].a),M.push(v[k+2].r,v[k+2].g,v[k+2].b,v[k+2].a),M.push(v[k+2].r,v[k+2].g,v[k+2].b,v[k+2].a))),z!==k&&(z=k)}var j=1!==_&&f?u+4:u;for(x=0,k=0;k<h;k++){var W=0,X=0,H=0,Y=0;for(P=0;P<u;P++)W=x*(j+1)+P,X=(x+1)*(j+1)+P,H=x*(j+1)+(P+1),Y=(x+1)*(j+1)+(P+1),S.push(W,X,H),S.push(Y,H,X);1!==_&&f&&(S.push(W+2,X+2,H+2),S.push(Y+2,H+2,X+2),S.push(W+4,X+4,H+4),S.push(Y+4,H+4,X+4)),x=d?x+2:x+1}var K=function(e){var r=e?i/2:s/2;if(0!==r){var o,a,c,l=e?g[y-1]:g[0],h=null;v&&(h=e?v[y-1]:v[0]);var d=C.length/3,f=e?t/2:-t/2,p=new n.e(0,f,0);C.push(p.x,p.y,p.z),R.push(0,e?1:-1,0),O.push(l.x+.5*(l.z-l.x),l.y+.5*(l.w-l.y)),h&&M.push(h.r,h.g,h.b,h.a);var m=new n.d(.5,.5);for(c=0;c<=u;c++){o=2*Math.PI*c*_/u;var b=Math.cos(-o),T=Math.sin(-o);a=new n.e(b*r,f,T*r);var E=new n.d(b*m.x+.5,T*m.y+.5);C.push(a.x,a.y,a.z),R.push(0,e?1:-1,0),O.push(l.x+(l.z-l.x)*E.x,l.y+(l.w-l.y)*E.y),h&&M.push(h.r,h.g,h.b,h.a)}for(c=0;c<u;c++)e?(S.push(d),S.push(d+(c+2)),S.push(d+(c+1))):(S.push(d),S.push(d+(c+1)),S.push(d+(c+2)))}};p!==o.a.CAP_START&&p!==o.a.CAP_ALL||K(!1),p!==o.a.CAP_END&&p!==o.a.CAP_ALL||K(!0),a.a._ComputeSides(m,C,S,R,O,e.frontUVs,e.backUVs);var Q=new a.a;return Q.indices=S,Q.positions=C,Q.normals=R,Q.uvs=O,v&&(Q.colors=M),Q},o.a.CreateCylinder=function(e,t,i,n,r,a,c,u,h){void 0!==c&&c instanceof s.a||(void 0!==c&&(h=u||o.a.DEFAULTSIDE,u=c),c=a,a=1);var d={height:t,diameterTop:i,diameterBottom:n,tessellation:r,subdivisions:a,sideOrientation:h,updatable:u};return l.CreateCylinder(e,d,c)};var l=function(){function e(){}return e.CreateCylinder=function(e,t,i){var n=new o.a(e,i);return t.sideOrientation=o.a._GetDefaultSideOrientation(t.sideOrientation),n._originalBuilderSideOrientation=t.sideOrientation,a.a.CreateCylinder(t).applyToMesh(n,t.updatable),n},e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return r});var n=i(0),r=function(){function e(e,t,i,r){this.normal=new n.e(e,t,i),this.d=r}return e.prototype.asArray=function(){return[this.normal.x,this.normal.y,this.normal.z,this.d]},e.prototype.clone=function(){return new e(this.normal.x,this.normal.y,this.normal.z,this.d)},e.prototype.getClassName=function(){return"Plane"},e.prototype.getHashCode=function(){var e=this.normal.getHashCode();return e=397*e^(0|this.d)},e.prototype.normalize=function(){var e=Math.sqrt(this.normal.x*this.normal.x+this.normal.y*this.normal.y+this.normal.z*this.normal.z),t=0;return 0!==e&&(t=1/e),this.normal.x*=t,this.normal.y*=t,this.normal.z*=t,this.d*=t,this},e.prototype.transform=function(t){var i=e._TmpMatrix;n.a.TransposeToRef(t,i);var r=i.m,o=this.normal.x,a=this.normal.y,s=this.normal.z,c=this.d;return new e(o*r[0]+a*r[1]+s*r[2]+c*r[3],o*r[4]+a*r[5]+s*r[6]+c*r[7],o*r[8]+a*r[9]+s*r[10]+c*r[11],o*r[12]+a*r[13]+s*r[14]+c*r[15])},e.prototype.dotCoordinate=function(e){return this.normal.x*e.x+this.normal.y*e.y+this.normal.z*e.z+this.d},e.prototype.copyFromPoints=function(e,t,i){var n,r=t.x-e.x,o=t.y-e.y,a=t.z-e.z,s=i.x-e.x,c=i.y-e.y,l=i.z-e.z,u=o*l-a*c,h=a*s-r*l,d=r*c-o*s,f=Math.sqrt(u*u+h*h+d*d);return n=0!==f?1/f:0,this.normal.x=u*n,this.normal.y=h*n,this.normal.z=d*n,this.d=-(this.normal.x*e.x+this.normal.y*e.y+this.normal.z*e.z),this},e.prototype.isFrontFacingTo=function(e,t){return n.e.Dot(this.normal,e)<=t},e.prototype.signedDistanceTo=function(e){return n.e.Dot(e,this.normal)+this.d},e.FromArray=function(t){return new e(t[0],t[1],t[2],t[3])},e.FromPoints=function(t,i,n){var r=new e(0,0,0,0);return r.copyFromPoints(t,i,n),r},e.FromPositionAndNormal=function(t,i){var n=new e(0,0,0,0);return i.normalize(),n.normal=i,n.d=-(i.x*t.x+i.y*t.y+i.z*t.z),n},e.SignedDistanceToPlaneFromPositionAndNormal=function(e,t,i){var r=-(t.x*e.x+t.y*e.y+t.z*e.z);return n.e.Dot(i,t)+r},e._TmpMatrix=n.a.Identity(),e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return n});var n=function(){function e(e,t,i,n){this.x=e,this.y=t,this.width=i,this.height=n}return e.prototype.toGlobal=function(t,i){return new e(this.x*t,this.y*i,this.width*t,this.height*i)},e.prototype.toGlobalToRef=function(e,t,i){return i.x=this.x*e,i.y=this.y*t,i.width=this.width*e,i.height=this.height*t,this},e.prototype.clone=function(){return new e(this.x,this.y,this.width,this.height)},e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return u});var n=i(5),r=i(18),o=i(6),a=i(0),s=i(20),c=i(39),l=i(55),u=(i(79),function(){function e(e){this._useAlternatePickedPointAboveMaxDragAngleDragSpeed=-1.1,this.maxDragAngle=0,this._useAlternatePickedPointAboveMaxDragAngle=!1,this.currentDraggingPointerID=-1,this.dragging=!1,this.dragDeltaRatio=.2,this.updateDragPlane=!0,this._debugMode=!1,this._moving=!1,this.onDragObservable=new o.c,this.onDragStartObservable=new o.c,this.onDragEndObservable=new o.c,this.moveAttached=!0,this.enabled=!0,this.startAndReleaseDragOnPointerEvents=!0,this.detachCameraControls=!0,this.useObjectOrientationForDragging=!0,this.validateDrag=function(e){return!0},this._tmpVector=new a.e(0,0,0),this._alternatePickedPoint=new a.e(0,0,0),this._worldDragAxis=new a.e(0,0,0),this._targetPosition=new a.e(0,0,0),this._attachedElement=null,this._startDragRay=new c.a(new a.e,new a.e),this._lastPointerRay={},this._dragDelta=new a.e,this._pointA=new a.e(0,0,0),this._pointB=new a.e(0,0,0),this._pointC=new a.e(0,0,0),this._lineA=new a.e(0,0,0),this._lineB=new a.e(0,0,0),this._localAxis=new a.e(0,0,0),this._lookAt=new a.e(0,0,0),this._options=e||{};var t=0;if(this._options.dragAxis&&t++,this._options.dragPlaneNormal&&t++,t>1)throw"Multiple drag modes specified in dragBehavior options. Only one expected"}return Object.defineProperty(e.prototype,"options",{get:function(){return this._options},set:function(e){this._options=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"name",{get:function(){return"PointerDrag"},enumerable:!0,configurable:!0}),e.prototype.init=function(){},e.prototype.attach=function(t,i){var o=this;this._scene=t.getScene(),this.attachedNode=t,e._planeScene||(this._debugMode?e._planeScene=this._scene:(e._planeScene=new r.a(this._scene.getEngine(),{virtual:!0}),e._planeScene.detachControl(),this._scene.onDisposeObservable.addOnce(function(){e._planeScene.dispose(),e._planeScene=null}))),this._dragPlane=n.a.CreatePlane("pointerDragPlane",this._debugMode?1:1e4,e._planeScene,!1,n.a.DOUBLESIDE),this.lastDragPosition=new a.e(0,0,0);var u=i||function(e){return o.attachedNode==e||e.isDescendantOf(o.attachedNode)};this._pointerObserver=this._scene.onPointerObservable.add(function(t,i){if(o.enabled)if(t.type==s.a.POINTERDOWN)o.startAndReleaseDragOnPointerEvents&&!o.dragging&&t.pickInfo&&t.pickInfo.hit&&t.pickInfo.pickedMesh&&t.pickInfo.pickedPoint&&t.pickInfo.ray&&u(t.pickInfo.pickedMesh)&&o._startDrag(t.event.pointerId,t.pickInfo.ray,t.pickInfo.pickedPoint);else if(t.type==s.a.POINTERUP)o.startAndReleaseDragOnPointerEvents&&o.currentDraggingPointerID==t.event.pointerId&&o.releaseDrag();else if(t.type==s.a.POINTERMOVE){var n=t.event.pointerId;o.currentDraggingPointerID===e._AnyMouseID&&n!==e._AnyMouseID&&"mouse"==t.event.pointerType&&(o._lastPointerRay[o.currentDraggingPointerID]&&(o._lastPointerRay[n]=o._lastPointerRay[o.currentDraggingPointerID],delete o._lastPointerRay[o.currentDraggingPointerID]),o.currentDraggingPointerID=n),o._lastPointerRay[n]||(o._lastPointerRay[n]=new c.a(new a.e,new a.e)),t.pickInfo&&t.pickInfo.ray&&(o._lastPointerRay[n].origin.copyFrom(t.pickInfo.ray.origin),o._lastPointerRay[n].direction.copyFrom(t.pickInfo.ray.direction),o.currentDraggingPointerID==n&&o.dragging&&o._moveDrag(t.pickInfo.ray))}}),this._beforeRenderObserver=this._scene.onBeforeRenderObservable.add(function(){o._moving&&o.moveAttached&&(l.a._RemoveAndStorePivotPoint(o.attachedNode),o._targetPosition.subtractToRef(o.attachedNode.absolutePosition,o._tmpVector),o._tmpVector.scaleInPlace(o.dragDeltaRatio),o.attachedNode.getAbsolutePosition().addToRef(o._tmpVector,o._tmpVector),o.validateDrag(o._tmpVector)&&o.attachedNode.setAbsolutePosition(o._tmpVector),l.a._RestorePivotPoint(o.attachedNode))})},e.prototype.releaseDrag=function(){this.dragging&&(this.onDragEndObservable.notifyObservers({dragPlanePoint:this.lastDragPosition,pointerId:this.currentDraggingPointerID}),this.dragging=!1),this.currentDraggingPointerID=-1,this._moving=!1,this.detachCameraControls&&this._attachedElement&&this._scene.activeCamera&&!this._scene.activeCamera.leftCamera&&this._scene.activeCamera.attachControl(this._attachedElement,!this._scene.activeCamera.inputs||this._scene.activeCamera.inputs.noPreventDefault)},e.prototype.startDrag=function(t,i,n){void 0===t&&(t=e._AnyMouseID),this._startDrag(t,i,n);var r=this._lastPointerRay[t];t===e._AnyMouseID&&(r=this._lastPointerRay[Object.keys(this._lastPointerRay)[0]]),r&&this._moveDrag(r)},e.prototype._startDrag=function(e,t,i){if(this._scene.activeCamera&&!this.dragging&&this.attachedNode){l.a._RemoveAndStorePivotPoint(this.attachedNode),t?(this._startDragRay.direction.copyFrom(t.direction),this._startDragRay.origin.copyFrom(t.origin)):(this._startDragRay.origin.copyFrom(this._scene.activeCamera.position),this.attachedNode.getWorldMatrix().getTranslationToRef(this._tmpVector),this._tmpVector.subtractToRef(this._scene.activeCamera.position,this._startDragRay.direction)),this._updateDragPlanePosition(this._startDragRay,i||this._tmpVector);var n=this._pickWithRayOnDragPlane(this._startDragRay);n&&(this.dragging=!0,this.currentDraggingPointerID=e,this.lastDragPosition.copyFrom(n),this.onDragStartObservable.notifyObservers({dragPlanePoint:n,pointerId:this.currentDraggingPointerID}),this._targetPosition.copyFrom(this.attachedNode.absolutePosition),this.detachCameraControls&&this._scene.activeCamera&&this._scene.activeCamera.inputs&&!this._scene.activeCamera.leftCamera&&(this._scene.activeCamera.inputs.attachedElement?(this._attachedElement=this._scene.activeCamera.inputs.attachedElement,this._scene.activeCamera.detachControl(this._scene.activeCamera.inputs.attachedElement)):this._attachedElement=null)),l.a._RestorePivotPoint(this.attachedNode)}},e.prototype._moveDrag=function(e){this._moving=!0;var t=this._pickWithRayOnDragPlane(e);if(t){this.updateDragPlane&&this._updateDragPlanePosition(e,t);var i=0;this._options.dragAxis?(this.useObjectOrientationForDragging?a.e.TransformCoordinatesToRef(this._options.dragAxis,this.attachedNode.getWorldMatrix().getRotationMatrix(),this._worldDragAxis):this._worldDragAxis.copyFrom(this._options.dragAxis),t.subtractToRef(this.lastDragPosition,this._tmpVector),i=a.e.Dot(this._tmpVector,this._worldDragAxis),this._worldDragAxis.scaleToRef(i,this._dragDelta)):(i=this._dragDelta.length(),t.subtractToRef(this.lastDragPosition,this._dragDelta)),this._targetPosition.addInPlace(this._dragDelta),this.onDragObservable.notifyObservers({dragDistance:i,delta:this._dragDelta,dragPlanePoint:t,dragPlaneNormal:this._dragPlane.forward,pointerId:this.currentDraggingPointerID}),this.lastDragPosition.copyFrom(t)}},e.prototype._pickWithRayOnDragPlane=function(t){var i=this;if(!t)return null;var n=Math.acos(a.e.Dot(this._dragPlane.forward,t.direction));if(n>Math.PI/2&&(n=Math.PI-n),this.maxDragAngle>0&&n>this.maxDragAngle){if(this._useAlternatePickedPointAboveMaxDragAngle){this._tmpVector.copyFrom(t.direction),this.attachedNode.absolutePosition.subtractToRef(t.origin,this._alternatePickedPoint),this._alternatePickedPoint.normalize(),this._alternatePickedPoint.scaleInPlace(this._useAlternatePickedPointAboveMaxDragAngleDragSpeed*a.e.Dot(this._alternatePickedPoint,this._tmpVector)),this._tmpVector.addInPlace(this._alternatePickedPoint);var r=a.e.Dot(this._dragPlane.forward,this._tmpVector);return this._dragPlane.forward.scaleToRef(-r,this._alternatePickedPoint),this._alternatePickedPoint.addInPlace(this._tmpVector),this._alternatePickedPoint.addInPlace(this.attachedNode.absolutePosition),this._alternatePickedPoint}return null}var o=e._planeScene.pickWithRay(t,function(e){return e==i._dragPlane});return o&&o.hit&&o.pickedMesh&&o.pickedPoint?o.pickedPoint:null},e.prototype._updateDragPlanePosition=function(e,t){this._pointA.copyFrom(t),this._options.dragAxis?(this.useObjectOrientationForDragging?a.e.TransformCoordinatesToRef(this._options.dragAxis,this.attachedNode.getWorldMatrix().getRotationMatrix(),this._localAxis):this._localAxis.copyFrom(this._options.dragAxis),this._pointA.addToRef(this._localAxis,this._pointB),e.origin.subtractToRef(this._pointA,this._pointC),this._pointA.addToRef(this._pointC.normalize(),this._pointC),this._pointB.subtractToRef(this._pointA,this._lineA),this._pointC.subtractToRef(this._pointA,this._lineB),a.e.CrossToRef(this._lineA,this._lineB,this._lookAt),a.e.CrossToRef(this._lineA,this._lookAt,this._lookAt),this._lookAt.normalize(),this._dragPlane.position.copyFrom(this._pointA),this._pointA.addToRef(this._lookAt,this._lookAt),this._dragPlane.lookAt(this._lookAt)):this._options.dragPlaneNormal?(this.useObjectOrientationForDragging?a.e.TransformCoordinatesToRef(this._options.dragPlaneNormal,this.attachedNode.getWorldMatrix().getRotationMatrix(),this._localAxis):this._localAxis.copyFrom(this._options.dragPlaneNormal),this._dragPlane.position.copyFrom(this._pointA),this._pointA.addToRef(this._localAxis,this._lookAt),this._dragPlane.lookAt(this._lookAt)):(this._dragPlane.position.copyFrom(this._pointA),this._dragPlane.lookAt(e.origin)),this._dragPlane.position.copyFrom(this.attachedNode.absolutePosition),this._dragPlane.computeWorldMatrix(!0)},e.prototype.detach=function(){this._pointerObserver&&this._scene.onPointerObservable.remove(this._pointerObserver),this._beforeRenderObserver&&this._scene.onBeforeRenderObservable.remove(this._beforeRenderObserver),this.releaseDrag()},e._AnyMouseID=-2,e}())},function(e,t,i){"use strict";i.d(t,"a",function(){return r}),i.d(t,"b",function(){return o}),i.d(t,"c",function(){return a});var n=i(1),r=function(){function e(){}return e.KEYDOWN=1,e.KEYUP=2,e}(),o=function(e,t){this.type=e,this.event=t},a=function(e){function t(t,i){var n=e.call(this,t,i)||this;return n.type=t,n.event=i,n.skipOnPointerObservable=!1,n}return Object(n.d)(t,e),t}(o)},function(e,t,i){"use strict";i.d(t,"a",function(){return n});var n=function(){function e(){this._defines={},this._currentRank=32,this._maxRank=-1,this._mesh=null}return e.prototype.unBindMesh=function(){this._mesh=null},e.prototype.addFallback=function(e,t){this._defines[e]||(e<this._currentRank&&(this._currentRank=e),e>this._maxRank&&(this._maxRank=e),this._defines[e]=new Array),this._defines[e].push(t)},e.prototype.addCPUSkinningFallback=function(e,t){this._mesh=t,e<this._currentRank&&(this._currentRank=e),e>this._maxRank&&(this._maxRank=e)},Object.defineProperty(e.prototype,"hasMoreFallbacks",{get:function(){return this._currentRank<=this._maxRank},enumerable:!0,configurable:!0}),e.prototype.reduce=function(e,t){if(this._mesh&&this._mesh.computeBonesUsingShaders&&this._mesh.numBoneInfluencers>0){this._mesh.computeBonesUsingShaders=!1,e=e.replace("#define NUM_BONE_INFLUENCERS "+this._mesh.numBoneInfluencers,"#define NUM_BONE_INFLUENCERS 0"),t._bonesComputationForcedToCPU=!0;for(var i=this._mesh.getScene(),n=0;n<i.meshes.length;n++){var r=i.meshes[n];if(r.material){if(r.computeBonesUsingShaders&&0!==r.numBoneInfluencers)if(r.material.getEffect()===t)r.computeBonesUsingShaders=!1;else if(r.subMeshes)for(var o=0,a=r.subMeshes;o<a.length;o++){if(a[o].effect===t){r.computeBonesUsingShaders=!1;break}}}else!this._mesh.material&&r.computeBonesUsingShaders&&r.numBoneInfluencers>0&&(r.computeBonesUsingShaders=!1)}}else{var s=this._defines[this._currentRank];if(s)for(n=0;n<s.length;n++)e=e.replace("#define "+s[n],"");this._currentRank++}return e},e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return n});var n=function(){function e(){this._xhr=new XMLHttpRequest}return e.prototype._injectCustomRequestHeaders=function(){for(var t in e.CustomRequestHeaders){var i=e.CustomRequestHeaders[t];i&&this._xhr.setRequestHeader(t,i)}},Object.defineProperty(e.prototype,"onprogress",{get:function(){return this._xhr.onprogress},set:function(e){this._xhr.onprogress=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"readyState",{get:function(){return this._xhr.readyState},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"status",{get:function(){return this._xhr.status},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"statusText",{get:function(){return this._xhr.statusText},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"response",{get:function(){return this._xhr.response},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"responseURL",{get:function(){return this._xhr.responseURL},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"responseText",{get:function(){return this._xhr.responseText},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"responseType",{get:function(){return this._xhr.responseType},set:function(e){this._xhr.responseType=e},enumerable:!0,configurable:!0}),e.prototype.addEventListener=function(e,t,i){this._xhr.addEventListener(e,t,i)},e.prototype.removeEventListener=function(e,t,i){this._xhr.removeEventListener(e,t,i)},e.prototype.abort=function(){this._xhr.abort()},e.prototype.send=function(t){e.CustomRequestHeaders&&this._injectCustomRequestHeaders(),this._xhr.send(t)},e.prototype.open=function(t,i){for(var n=0,r=e.CustomRequestModifiers;n<r.length;n++){(0,r[n])(this._xhr,i)}return i=(i=i.replace("file:http:","http:")).replace("file:https:","https:"),this._xhr.open(t,i,!0)},e.prototype.setRequestHeader=function(e,t){this._xhr.setRequestHeader(e,t)},e.prototype.getResponseHeader=function(e){return this._xhr.getResponseHeader(e)},e.CustomRequestHeaders={},e.CustomRequestModifiers=new Array,e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return s});var n=i(0),r=i(10),o=i(5),a=i(15);a.a.CreateBox=function(e){var t,i=[0,1,2,0,2,3,4,5,6,4,6,7,8,9,10,8,10,11,12,13,14,12,14,15,16,17,18,16,18,19,20,21,22,20,22,23],o=[0,0,1,0,0,1,0,0,1,0,0,1,0,0,-1,0,0,-1,0,0,-1,0,0,-1,1,0,0,1,0,0,1,0,0,1,0,0,-1,0,0,-1,0,0,-1,0,0,-1,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,-1,0,0,-1,0,0,-1,0,0,-1,0],s=[],c=e.width||e.size||1,l=e.height||e.size||1,u=e.depth||e.size||1,h=e.wrap||!1,d=void 0===e.topBaseAt?1:e.topBaseAt,f=void 0===e.bottomBaseAt?0:e.bottomBaseAt,p=[2,0,3,1][d=(d+4)%4],_=[2,0,1,3][f=(f+4)%4],m=[1,-1,1,-1,-1,1,-1,1,1,1,1,1,1,1,-1,-1,1,-1,-1,-1,-1,1,-1,-1,1,1,-1,1,-1,-1,1,-1,1,1,1,1,-1,1,1,-1,-1,1,-1,-1,-1,-1,1,-1,-1,1,1,-1,1,-1,1,1,-1,1,1,1,1,-1,1,1,-1,-1,-1,-1,-1,-1,-1,1];if(h){i=[2,3,0,2,0,1,4,5,6,4,6,7,9,10,11,9,11,8,12,14,15,12,13,14],m=[-1,1,1,1,1,1,1,-1,1,-1,-1,1,1,1,-1,-1,1,-1,-1,-1,-1,1,-1,-1,1,1,1,1,1,-1,1,-1,-1,1,-1,1,-1,1,-1,-1,1,1,-1,-1,1,-1,-1,-1];for(var g=[[1,1,1],[-1,1,1],[-1,1,-1],[1,1,-1]],v=[[-1,-1,1],[1,-1,1],[1,-1,-1],[-1,-1,-1]],y=[17,18,19,16],b=[22,23,20,21];p>0;)g.unshift(g.pop()),y.unshift(y.pop()),p--;for(;_>0;)v.unshift(v.pop()),b.unshift(b.pop()),_--;g=g.flat(),v=v.flat(),m=m.concat(g).concat(v),i.push(y[0],y[2],y[3],y[0],y[1],y[2]),i.push(b[0],b[2],b[3],b[0],b[1],b[2])}var T=[c/2,l/2,u/2];t=m.reduce(function(e,t,i){return e.concat(t*T[i%3])},[]);for(var E=0===e.sideOrientation?0:e.sideOrientation||a.a.DEFAULTSIDE,x=e.faceUV||new Array(6),P=e.faceColors,A=[],S=0;S<6;S++)void 0===x[S]&&(x[S]=new n.f(0,0,1,1)),P&&void 0===P[S]&&(P[S]=new r.b(1,1,1,1));for(var C=0;C<6;C++)if(s.push(x[C].z,x[C].w),s.push(x[C].x,x[C].w),s.push(x[C].x,x[C].y),s.push(x[C].z,x[C].y),P)for(var R=0;R<4;R++)A.push(P[C].r,P[C].g,P[C].b,P[C].a);a.a._ComputeSides(E,t,i,o,s,e.frontUVs,e.backUVs);var O=new a.a;if(O.indices=i,O.positions=t,O.normals=o,O.uvs=s,P){var M=E===a.a.DOUBLESIDE?A.concat(A):A;O.colors=M}return O},o.a.CreateBox=function(e,t,i,n,r){void 0===i&&(i=null);var o={size:t,sideOrientation:r,updatable:n};return s.CreateBox(e,o,i)};var s=function(){function e(){}return e.CreateBox=function(e,t,i){void 0===i&&(i=null);var n=new o.a(e,i);return t.sideOrientation=o.a._GetDefaultSideOrientation(t.sideOrientation),n._originalBuilderSideOrientation=t.sideOrientation,a.a.CreateBox(t).applyToMesh(n,t.updatable),n},e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return r});var n=i(2),r=function(){function e(){}return Object.defineProperty(e,"ForceFullSceneLoadingForIncremental",{get:function(){return e._ForceFullSceneLoadingForIncremental},set:function(t){e._ForceFullSceneLoadingForIncremental=t},enumerable:!0,configurable:!0}),Object.defineProperty(e,"ShowLoadingScreen",{get:function(){return e._ShowLoadingScreen},set:function(t){e._ShowLoadingScreen=t},enumerable:!0,configurable:!0}),Object.defineProperty(e,"loggingLevel",{get:function(){return e._loggingLevel},set:function(t){e._loggingLevel=t},enumerable:!0,configurable:!0}),Object.defineProperty(e,"CleanBoneMatrixWeights",{get:function(){return e._CleanBoneMatrixWeights},set:function(t){e._CleanBoneMatrixWeights=t},enumerable:!0,configurable:!0}),e._ForceFullSceneLoadingForIncremental=!1,e._ShowLoadingScreen=!0,e._CleanBoneMatrixWeights=!1,e._loggingLevel=n.a.SCENELOADER_NO_LOGGING,e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return n});var n=function(){function e(e,t){this.width=e,this.height=t}return e.prototype.toString=function(){return"{W: "+this.width+", H: "+this.height+"}"},e.prototype.getClassName=function(){return"Size"},e.prototype.getHashCode=function(){var e=0|this.width;return e=397*e^(0|this.height)},e.prototype.copyFrom=function(e){this.width=e.width,this.height=e.height},e.prototype.copyFromFloats=function(e,t){return this.width=e,this.height=t,this},e.prototype.set=function(e,t){return this.copyFromFloats(e,t)},e.prototype.multiplyByFloats=function(t,i){return new e(this.width*t,this.height*i)},e.prototype.clone=function(){return new e(this.width,this.height)},e.prototype.equals=function(e){return!!e&&(this.width===e.width&&this.height===e.height)},Object.defineProperty(e.prototype,"surface",{get:function(){return this.width*this.height},enumerable:!0,configurable:!0}),e.Zero=function(){return new e(0,0)},e.prototype.add=function(t){return new e(this.width+t.width,this.height+t.height)},e.prototype.subtract=function(t){return new e(this.width-t.width,this.height-t.height)},e.Lerp=function(t,i,n){return new e(t.width+(i.width-t.width)*n,t.height+(i.height-t.height)*n)},e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return p});var n=i(0),r=i(10),o=i(15),a=i(4),s=i(57),c=i(67),l=i(44),u=i(2),h=i(13),d=i(35),f=i(110),p=function(){function e(e,t,i,n,r){void 0===n&&(n=!1),void 0===r&&(r=null),this.delayLoadState=u.a.DELAYLOADSTATE_NONE,this._totalVertices=0,this._isDisposed=!1,this._indexBufferIsUpdatable=!1,this.id=e,this.uniqueId=t.getUniqueId(),this._engine=t.getEngine(),this._meshes=[],this._scene=t,this._vertexBuffers={},this._indices=[],this._updatable=n,i?this.setAllVerticesData(i,n):(this._totalVertices=0,this._indices=[]),this._engine.getCaps().vertexArrayObject&&(this._vertexArrayObjects={}),r&&(this.applyToMesh(r),r.computeWorldMatrix(!0))}return Object.defineProperty(e.prototype,"boundingBias",{get:function(){return this._boundingBias},set:function(e){this._boundingBias?this._boundingBias.copyFrom(e):this._boundingBias=e.clone(),this._updateBoundingInfo(!0,null)},enumerable:!0,configurable:!0}),e.CreateGeometryForMesh=function(t){var i=new e(e.RandomId(),t.getScene());return i.applyToMesh(t),i},Object.defineProperty(e.prototype,"extend",{get:function(){return this._extend},enumerable:!0,configurable:!0}),e.prototype.getScene=function(){return this._scene},e.prototype.getEngine=function(){return this._engine},e.prototype.isReady=function(){return this.delayLoadState===u.a.DELAYLOADSTATE_LOADED||this.delayLoadState===u.a.DELAYLOADSTATE_NONE},Object.defineProperty(e.prototype,"doNotSerialize",{get:function(){for(var e=0;e<this._meshes.length;e++)if(!this._meshes[e].doNotSerialize)return!1;return!0},enumerable:!0,configurable:!0}),e.prototype._rebuild=function(){for(var e in this._vertexArrayObjects&&(this._vertexArrayObjects={}),0!==this._meshes.length&&this._indices&&(this._indexBuffer=this._engine.createIndexBuffer(this._indices)),this._vertexBuffers){this._vertexBuffers[e]._rebuild()}},e.prototype.setAllVerticesData=function(e,t){e.applyToGeometry(this,t),this.notifyUpdate()},e.prototype.setVerticesData=function(e,t,i,n){void 0===i&&(i=!1);var r=new a.b(this._engine,t,e,i,0===this._meshes.length,n);this.setVerticesBuffer(r)},e.prototype.removeVerticesData=function(e){this._vertexBuffers[e]&&(this._vertexBuffers[e].dispose(),delete this._vertexBuffers[e])},e.prototype.setVerticesBuffer=function(e,t){void 0===t&&(t=null);var i=e.getKind();if(this._vertexBuffers[i]&&this._vertexBuffers[i].dispose(),this._vertexBuffers[i]=e,i===a.b.PositionKind){var n=e.getData();null!=t?this._totalVertices=t:null!=n&&(this._totalVertices=n.length/(e.byteStride/4)),this._updateExtend(n),this._resetPointsArrayCache();for(var r=this._meshes,o=r.length,s=0;s<o;s++){var c=r[s];c._boundingInfo=new l.a(this._extend.minimum,this._extend.maximum),c._createGlobalSubMesh(!1),c.computeWorldMatrix(!0)}}this.notifyUpdate(i),this._vertexArrayObjects&&(this._disposeVertexArrayObjects(),this._vertexArrayObjects={})},e.prototype.updateVerticesDataDirectly=function(e,t,i,n){void 0===n&&(n=!1);var r=this.getVertexBuffer(e);r&&(r.updateDirectly(t,i,n),this.notifyUpdate(e))},e.prototype.updateVerticesData=function(e,t,i){void 0===i&&(i=!1);var n=this.getVertexBuffer(e);n&&(n.update(t),e===a.b.PositionKind&&this._updateBoundingInfo(i,t),this.notifyUpdate(e))},e.prototype._updateBoundingInfo=function(e,t){if(e&&this._updateExtend(t),this._resetPointsArrayCache(),e)for(var i=0,n=this._meshes;i<n.length;i++){var r=n[i];r._boundingInfo?r._boundingInfo.reConstruct(this._extend.minimum,this._extend.maximum):r._boundingInfo=new l.a(this._extend.minimum,this._extend.maximum);for(var o=0,a=r.subMeshes;o<a.length;o++){a[o].refreshBoundingInfo()}}},e.prototype._bind=function(e,t){if(e){void 0===t&&(t=this._indexBuffer);var i=this.getVertexBuffers();i&&(t==this._indexBuffer&&this._vertexArrayObjects?(this._vertexArrayObjects[e.key]||(this._vertexArrayObjects[e.key]=this._engine.recordVertexArrayObject(i,t,e)),this._engine.bindVertexArrayObject(this._vertexArrayObjects[e.key],t)):this._engine.bindBuffers(i,t,e))}},e.prototype.getTotalVertices=function(){return this.isReady()?this._totalVertices:0},e.prototype.getVerticesData=function(e,t,i){var n=this.getVertexBuffer(e);if(!n)return null;var r=n.getData();if(!r)return null;var o=n.getSize()*a.b.GetTypeByteLength(n.type),s=this._totalVertices*n.getSize();if(n.type!==a.b.FLOAT||n.byteStride!==o){var c=[];return n.forEach(s,function(e){return c.push(e)}),c}if(!(r instanceof Array||r instanceof Float32Array)||0!==n.byteOffset||r.length!==s){if(r instanceof Array){var l=n.byteOffset/4;return h.b.Slice(r,l,l+s)}if(r instanceof ArrayBuffer)return new Float32Array(r,n.byteOffset,s);l=r.byteOffset+n.byteOffset;if(i||t&&1!==this._meshes.length){var u=new Float32Array(s),d=new Float32Array(r.buffer,l,s);return u.set(d),u}return new Float32Array(r.buffer,l,s)}return i||t&&1!==this._meshes.length?h.b.Slice(r):r},e.prototype.isVertexBufferUpdatable=function(e){var t=this._vertexBuffers[e];return!!t&&t.isUpdatable()},e.prototype.getVertexBuffer=function(e){return this.isReady()?this._vertexBuffers[e]:null},e.prototype.getVertexBuffers=function(){return this.isReady()?this._vertexBuffers:null},e.prototype.isVerticesDataPresent=function(e){return this._vertexBuffers?void 0!==this._vertexBuffers[e]:!!this._delayInfo&&-1!==this._delayInfo.indexOf(e)},e.prototype.getVerticesDataKinds=function(){var e,t=[];if(!this._vertexBuffers&&this._delayInfo)for(e in this._delayInfo)t.push(e);else for(e in this._vertexBuffers)t.push(e);return t},e.prototype.updateIndices=function(e,t,i){if(void 0===i&&(i=!1),this._indexBuffer)if(this._indexBufferIsUpdatable){var n=e.length!==this._indices.length;if(i||(this._indices=e.slice()),this._engine.updateDynamicIndexBuffer(this._indexBuffer,e,t),n)for(var r=0,o=this._meshes;r<o.length;r++){o[r]._createGlobalSubMesh(!0)}}else this.setIndices(e,null,!0)},e.prototype.setIndices=function(e,t,i){void 0===t&&(t=null),void 0===i&&(i=!1),this._indexBuffer&&this._engine._releaseBuffer(this._indexBuffer),this._disposeVertexArrayObjects(),this._indices=e,this._indexBufferIsUpdatable=i,0!==this._meshes.length&&this._indices&&(this._indexBuffer=this._engine.createIndexBuffer(this._indices,i)),null!=t&&(this._totalVertices=t);for(var n=0,r=this._meshes;n<r.length;n++){r[n]._createGlobalSubMesh(!0)}this.notifyUpdate()},e.prototype.getTotalIndices=function(){return this.isReady()?this._indices.length:0},e.prototype.getIndices=function(e,t){if(!this.isReady())return null;var i=this._indices;if(t||e&&1!==this._meshes.length){for(var n=i.length,r=[],o=0;o<n;o++)r.push(i[o]);return r}return i},e.prototype.getIndexBuffer=function(){return this.isReady()?this._indexBuffer:null},e.prototype._releaseVertexArrayObject=function(e){void 0===e&&(e=null),e&&this._vertexArrayObjects&&this._vertexArrayObjects[e.key]&&(this._engine.releaseVertexArrayObject(this._vertexArrayObjects[e.key]),delete this._vertexArrayObjects[e.key])},e.prototype.releaseForMesh=function(e,t){var i=this._meshes,n=i.indexOf(e);-1!==n&&(i.splice(n,1),e._geometry=null,0===i.length&&t&&this.dispose())},e.prototype.applyToMesh=function(e){if(e._geometry!==this){var t=e._geometry;t&&t.releaseForMesh(e);var i=this._meshes;e._geometry=this,this._scene.pushGeometry(this),i.push(e),this.isReady()?this._applyToMesh(e):e._boundingInfo=this._boundingInfo}},e.prototype._updateExtend=function(e){void 0===e&&(e=null),e||(e=this.getVerticesData(a.b.PositionKind)),this._extend=Object(f.a)(e,0,this._totalVertices,this.boundingBias,3)},e.prototype._applyToMesh=function(e){var t=this._meshes.length;for(var i in this._vertexBuffers){1===t&&this._vertexBuffers[i].create();var n=this._vertexBuffers[i].getBuffer();n&&(n.references=t),i===a.b.PositionKind&&(this._extend||this._updateExtend(),e._boundingInfo=new l.a(this._extend.minimum,this._extend.maximum),e._createGlobalSubMesh(!1),e._updateBoundingInfo())}1===t&&this._indices&&this._indices.length>0&&(this._indexBuffer=this._engine.createIndexBuffer(this._indices)),this._indexBuffer&&(this._indexBuffer.references=t),e._syncGeometryWithMorphTargetManager(),e.synchronizeInstances()},e.prototype.notifyUpdate=function(e){this.onGeometryUpdated&&this.onGeometryUpdated(this,e);for(var t=0,i=this._meshes;t<i.length;t++){i[t]._markSubMeshesAsAttributesDirty()}},e.prototype.load=function(e,t){this.delayLoadState!==u.a.DELAYLOADSTATE_LOADING&&(this.isReady()?t&&t():(this.delayLoadState=u.a.DELAYLOADSTATE_LOADING,this._queueLoad(e,t)))},e.prototype._queueLoad=function(e,t){var i=this;this.delayLoadingFile&&(e._addPendingData(this),e._loadFile(this.delayLoadingFile,function(n){if(i._delayLoadingFunction){i._delayLoadingFunction(JSON.parse(n),i),i.delayLoadState=u.a.DELAYLOADSTATE_LOADED,i._delayInfo=[],e._removePendingData(i);for(var r=i._meshes,o=r.length,a=0;a<o;a++)i._applyToMesh(r[a]);t&&t()}},void 0,!0))},e.prototype.toLeftHanded=function(){var e=this.getIndices(!1);if(null!=e&&e.length>0){for(var t=0;t<e.length;t+=3){var i=e[t+0];e[t+0]=e[t+2],e[t+2]=i}this.setIndices(e)}var n=this.getVerticesData(a.b.PositionKind,!1);if(null!=n&&n.length>0){for(t=0;t<n.length;t+=3)n[t+2]=-n[t+2];this.setVerticesData(a.b.PositionKind,n,!1)}var r=this.getVerticesData(a.b.NormalKind,!1);if(null!=r&&r.length>0){for(t=0;t<r.length;t+=3)r[t+2]=-r[t+2];this.setVerticesData(a.b.NormalKind,r,!1)}},e.prototype._resetPointsArrayCache=function(){this._positions=null},e.prototype._generatePointsArray=function(){if(this._positions)return!0;var e=this.getVerticesData(a.b.PositionKind);if(!e||0===e.length)return!1;this._positions=[];for(var t=0;t<e.length;t+=3)this._positions.push(n.e.FromArray(e,t));return!0},e.prototype.isDisposed=function(){return this._isDisposed},e.prototype._disposeVertexArrayObjects=function(){if(this._vertexArrayObjects){for(var e in this._vertexArrayObjects)this._engine.releaseVertexArrayObject(this._vertexArrayObjects[e]);this._vertexArrayObjects={}}},e.prototype.dispose=function(){var e,t=this._meshes,i=t.length;for(e=0;e<i;e++)this.releaseForMesh(t[e]);for(var n in this._meshes=[],this._disposeVertexArrayObjects(),this._vertexBuffers)this._vertexBuffers[n].dispose();this._vertexBuffers={},this._totalVertices=0,this._indexBuffer&&this._engine._releaseBuffer(this._indexBuffer),this._indexBuffer=null,this._indices=[],this.delayLoadState=u.a.DELAYLOADSTATE_NONE,this.delayLoadingFile=null,this._delayLoadingFunction=null,this._delayInfo=[],this._boundingInfo=null,this._scene.removeGeometry(this),this._isDisposed=!0},e.prototype.copy=function(t){var i=new o.a;i.indices=[];var n=this.getIndices();if(n)for(var r=0;r<n.length;r++)i.indices.push(n[r]);var a,s=!1,c=!1;for(a in this._vertexBuffers){var u=this.getVerticesData(a);if(u&&(u instanceof Float32Array?i.set(new Float32Array(u),a):i.set(u.slice(0),a),!c)){var h=this.getVertexBuffer(a);h&&(c=!(s=h.isUpdatable()))}}var d=new e(t,this._scene,i,s);for(a in d.delayLoadState=this.delayLoadState,d.delayLoadingFile=this.delayLoadingFile,d._delayLoadingFunction=this._delayLoadingFunction,this._delayInfo)d._delayInfo=d._delayInfo||[],d._delayInfo.push(a);return d._boundingInfo=new l.a(this._extend.minimum,this._extend.maximum),d},e.prototype.serialize=function(){var e={};return e.id=this.id,e.updatable=this._updatable,d.a&&d.a.HasTags(this)&&(e.tags=d.a.GetTags(this)),e},e.prototype.toNumberArray=function(e){return Array.isArray(e)?e:Array.prototype.slice.call(e)},e.prototype.serializeVerticeData=function(){var e=this.serialize();return this.isVerticesDataPresent(a.b.PositionKind)&&(e.positions=this.toNumberArray(this.getVerticesData(a.b.PositionKind)),this.isVertexBufferUpdatable(a.b.PositionKind)&&(e.positions._updatable=!0)),this.isVerticesDataPresent(a.b.NormalKind)&&(e.normals=this.toNumberArray(this.getVerticesData(a.b.NormalKind)),this.isVertexBufferUpdatable(a.b.NormalKind)&&(e.normals._updatable=!0)),this.isVerticesDataPresent(a.b.TangentKind)&&(e.tangets=this.toNumberArray(this.getVerticesData(a.b.TangentKind)),this.isVertexBufferUpdatable(a.b.TangentKind)&&(e.tangets._updatable=!0)),this.isVerticesDataPresent(a.b.UVKind)&&(e.uvs=this.toNumberArray(this.getVerticesData(a.b.UVKind)),this.isVertexBufferUpdatable(a.b.UVKind)&&(e.uvs._updatable=!0)),this.isVerticesDataPresent(a.b.UV2Kind)&&(e.uv2s=this.toNumberArray(this.getVerticesData(a.b.UV2Kind)),this.isVertexBufferUpdatable(a.b.UV2Kind)&&(e.uv2s._updatable=!0)),this.isVerticesDataPresent(a.b.UV3Kind)&&(e.uv3s=this.toNumberArray(this.getVerticesData(a.b.UV3Kind)),this.isVertexBufferUpdatable(a.b.UV3Kind)&&(e.uv3s._updatable=!0)),this.isVerticesDataPresent(a.b.UV4Kind)&&(e.uv4s=this.toNumberArray(this.getVerticesData(a.b.UV4Kind)),this.isVertexBufferUpdatable(a.b.UV4Kind)&&(e.uv4s._updatable=!0)),this.isVerticesDataPresent(a.b.UV5Kind)&&(e.uv5s=this.toNumberArray(this.getVerticesData(a.b.UV5Kind)),this.isVertexBufferUpdatable(a.b.UV5Kind)&&(e.uv5s._updatable=!0)),this.isVerticesDataPresent(a.b.UV6Kind)&&(e.uv6s=this.toNumberArray(this.getVerticesData(a.b.UV6Kind)),this.isVertexBufferUpdatable(a.b.UV6Kind)&&(e.uv6s._updatable=!0)),this.isVerticesDataPresent(a.b.ColorKind)&&(e.colors=this.toNumberArray(this.getVerticesData(a.b.ColorKind)),this.isVertexBufferUpdatable(a.b.ColorKind)&&(e.colors._updatable=!0)),this.isVerticesDataPresent(a.b.MatricesIndicesKind)&&(e.matricesIndices=this.toNumberArray(this.getVerticesData(a.b.MatricesIndicesKind)),e.matricesIndices._isExpanded=!0,this.isVertexBufferUpdatable(a.b.MatricesIndicesKind)&&(e.matricesIndices._updatable=!0)),this.isVerticesDataPresent(a.b.MatricesWeightsKind)&&(e.matricesWeights=this.toNumberArray(this.getVerticesData(a.b.MatricesWeightsKind)),this.isVertexBufferUpdatable(a.b.MatricesWeightsKind)&&(e.matricesWeights._updatable=!0)),e.indices=this.toNumberArray(this.getIndices()),e},e.ExtractFromMesh=function(e,t){var i=e._geometry;return i?i.copy(t):null},e.RandomId=function(){return h.b.RandomId()},e._ImportGeometry=function(t,i){var n=i.getScene(),o=t.geometryId;if(o){var c=n.getGeometryByID(o);c&&c.applyToMesh(i)}else if(t instanceof ArrayBuffer){var l=i._binaryInfo;if(l.positionsAttrDesc&&l.positionsAttrDesc.count>0){var u=new Float32Array(t,l.positionsAttrDesc.offset,l.positionsAttrDesc.count);i.setVerticesData(a.b.PositionKind,u,!1)}if(l.normalsAttrDesc&&l.normalsAttrDesc.count>0){var h=new Float32Array(t,l.normalsAttrDesc.offset,l.normalsAttrDesc.count);i.setVerticesData(a.b.NormalKind,h,!1)}if(l.tangetsAttrDesc&&l.tangetsAttrDesc.count>0){var d=new Float32Array(t,l.tangetsAttrDesc.offset,l.tangetsAttrDesc.count);i.setVerticesData(a.b.TangentKind,d,!1)}if(l.uvsAttrDesc&&l.uvsAttrDesc.count>0){var f=new Float32Array(t,l.uvsAttrDesc.offset,l.uvsAttrDesc.count);i.setVerticesData(a.b.UVKind,f,!1)}if(l.uvs2AttrDesc&&l.uvs2AttrDesc.count>0){var p=new Float32Array(t,l.uvs2AttrDesc.offset,l.uvs2AttrDesc.count);i.setVerticesData(a.b.UV2Kind,p,!1)}if(l.uvs3AttrDesc&&l.uvs3AttrDesc.count>0){var _=new Float32Array(t,l.uvs3AttrDesc.offset,l.uvs3AttrDesc.count);i.setVerticesData(a.b.UV3Kind,_,!1)}if(l.uvs4AttrDesc&&l.uvs4AttrDesc.count>0){var m=new Float32Array(t,l.uvs4AttrDesc.offset,l.uvs4AttrDesc.count);i.setVerticesData(a.b.UV4Kind,m,!1)}if(l.uvs5AttrDesc&&l.uvs5AttrDesc.count>0){var g=new Float32Array(t,l.uvs5AttrDesc.offset,l.uvs5AttrDesc.count);i.setVerticesData(a.b.UV5Kind,g,!1)}if(l.uvs6AttrDesc&&l.uvs6AttrDesc.count>0){var v=new Float32Array(t,l.uvs6AttrDesc.offset,l.uvs6AttrDesc.count);i.setVerticesData(a.b.UV6Kind,v,!1)}if(l.colorsAttrDesc&&l.colorsAttrDesc.count>0){var y=new Float32Array(t,l.colorsAttrDesc.offset,l.colorsAttrDesc.count);i.setVerticesData(a.b.ColorKind,y,!1,l.colorsAttrDesc.stride)}if(l.matricesIndicesAttrDesc&&l.matricesIndicesAttrDesc.count>0){for(var b=new Int32Array(t,l.matricesIndicesAttrDesc.offset,l.matricesIndicesAttrDesc.count),T=[],E=0;E<b.length;E++){var x=b[E];T.push(255&x),T.push((65280&x)>>8),T.push((16711680&x)>>16),T.push(x>>24)}i.setVerticesData(a.b.MatricesIndicesKind,T,!1)}if(l.matricesWeightsAttrDesc&&l.matricesWeightsAttrDesc.count>0){var P=new Float32Array(t,l.matricesWeightsAttrDesc.offset,l.matricesWeightsAttrDesc.count);i.setVerticesData(a.b.MatricesWeightsKind,P,!1)}if(l.indicesAttrDesc&&l.indicesAttrDesc.count>0){var A=new Int32Array(t,l.indicesAttrDesc.offset,l.indicesAttrDesc.count);i.setIndices(A,null)}if(l.subMeshesAttrDesc&&l.subMeshesAttrDesc.count>0){var S=new Int32Array(t,l.subMeshesAttrDesc.offset,5*l.subMeshesAttrDesc.count);i.subMeshes=[];for(E=0;E<l.subMeshesAttrDesc.count;E++){var C=S[5*E+0],R=S[5*E+1],O=S[5*E+2],M=S[5*E+3],I=S[5*E+4];s.b.AddToMesh(C,R,O,M,I,i)}}}else if(t.positions&&t.normals&&t.indices){if(i.setVerticesData(a.b.PositionKind,t.positions,t.positions._updatable),i.setVerticesData(a.b.NormalKind,t.normals,t.normals._updatable),t.tangents&&i.setVerticesData(a.b.TangentKind,t.tangents,t.tangents._updatable),t.uvs&&i.setVerticesData(a.b.UVKind,t.uvs,t.uvs._updatable),t.uvs2&&i.setVerticesData(a.b.UV2Kind,t.uvs2,t.uvs2._updatable),t.uvs3&&i.setVerticesData(a.b.UV3Kind,t.uvs3,t.uvs3._updatable),t.uvs4&&i.setVerticesData(a.b.UV4Kind,t.uvs4,t.uvs4._updatable),t.uvs5&&i.setVerticesData(a.b.UV5Kind,t.uvs5,t.uvs5._updatable),t.uvs6&&i.setVerticesData(a.b.UV6Kind,t.uvs6,t.uvs6._updatable),t.colors&&i.setVerticesData(a.b.ColorKind,r.b.CheckColors4(t.colors,t.positions.length/3),t.colors._updatable),t.matricesIndices)if(t.matricesIndices._isExpanded)delete t.matricesIndices._isExpanded,i.setVerticesData(a.b.MatricesIndicesKind,t.matricesIndices,t.matricesIndices._updatable);else{for(T=[],E=0;E<t.matricesIndices.length;E++){var D=t.matricesIndices[E];T.push(255&D),T.push((65280&D)>>8),T.push((16711680&D)>>16),T.push(D>>24)}i.setVerticesData(a.b.MatricesIndicesKind,T,t.matricesIndices._updatable)}if(t.matricesIndicesExtra)if(t.matricesIndicesExtra._isExpanded)delete t.matricesIndices._isExpanded,i.setVerticesData(a.b.MatricesIndicesExtraKind,t.matricesIndicesExtra,t.matricesIndicesExtra._updatable);else{for(T=[],E=0;E<t.matricesIndicesExtra.length;E++){D=t.matricesIndicesExtra[E];T.push(255&D),T.push((65280&D)>>8),T.push((16711680&D)>>16),T.push(D>>24)}i.setVerticesData(a.b.MatricesIndicesExtraKind,T,t.matricesIndicesExtra._updatable)}t.matricesWeights&&(e._CleanMatricesWeights(t,i),i.setVerticesData(a.b.MatricesWeightsKind,t.matricesWeights,t.matricesWeights._updatable)),t.matricesWeightsExtra&&i.setVerticesData(a.b.MatricesWeightsExtraKind,t.matricesWeightsExtra,t.matricesWeights._updatable),i.setIndices(t.indices,null)}if(t.subMeshes){i.subMeshes=[];for(var w=0;w<t.subMeshes.length;w++){var L=t.subMeshes[w];s.b.AddToMesh(L.materialIndex,L.verticesStart,L.verticesCount,L.indexStart,L.indexCount,i)}}i._shouldGenerateFlatShading&&(i.convertToFlatShadedMesh(),delete i._shouldGenerateFlatShading),i.computeWorldMatrix(!0),n.onMeshImportedObservable.notifyObservers(i)},e._CleanMatricesWeights=function(e,t){if(c.a.CleanBoneMatrixWeights){var i=0;if(e.skeletonId>-1){var n=t.getScene().getLastSkeletonByID(e.skeletonId);if(n){i=n.bones.length;for(var r=t.getVerticesData(a.b.MatricesIndicesKind),o=t.getVerticesData(a.b.MatricesIndicesExtraKind),s=e.matricesWeights,l=e.matricesWeightsExtra,u=e.numBoneInfluencer,h=s.length,d=0;d<h;d+=4){for(var f=0,p=-1,_=0;_<4;_++){f+=m=s[d+_],m<.001&&p<0&&(p=_)}if(l)for(_=0;_<4;_++){var m;f+=m=l[d+_],m<.001&&p<0&&(p=_+4)}if((p<0||p>u-1)&&(p=u-1),f>.001){var g=1/f;for(_=0;_<4;_++)s[d+_]*=g;if(l)for(_=0;_<4;_++)l[d+_]*=g}else p>=4?(l[d+p-4]=1-f,o[d+p-4]=i):(s[d+p]=1-f,r[d+p]=i)}t.setVerticesData(a.b.MatricesIndicesKind,r),e.matricesWeightsExtra&&t.setVerticesData(a.b.MatricesIndicesExtraKind,o)}}}},e.Parse=function(t,i,r){if(i.getGeometryByID(t.id))return null;var s=new e(t.id,i,void 0,t.updatable);return d.a&&d.a.AddTagsTo(s,t.tags),t.delayLoadingFile?(s.delayLoadState=u.a.DELAYLOADSTATE_NOTLOADED,s.delayLoadingFile=r+t.delayLoadingFile,s._boundingInfo=new l.a(n.e.FromArray(t.boundingBoxMinimum),n.e.FromArray(t.boundingBoxMaximum)),s._delayInfo=[],t.hasUVs&&s._delayInfo.push(a.b.UVKind),t.hasUVs2&&s._delayInfo.push(a.b.UV2Kind),t.hasUVs3&&s._delayInfo.push(a.b.UV3Kind),t.hasUVs4&&s._delayInfo.push(a.b.UV4Kind),t.hasUVs5&&s._delayInfo.push(a.b.UV5Kind),t.hasUVs6&&s._delayInfo.push(a.b.UV6Kind),t.hasColors&&s._delayInfo.push(a.b.ColorKind),t.hasMatricesIndices&&s._delayInfo.push(a.b.MatricesIndicesKind),t.hasMatricesWeights&&s._delayInfo.push(a.b.MatricesWeightsKind),s._delayLoadingFunction=o.a.ImportVertexData):o.a.ImportVertexData(t,s),i.pushGeometry(s,!0),s},e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return n});var n=function(){function e(){}return e.CreateCanvas=function(e,t){if("undefined"==typeof document)return new OffscreenCanvas(e,t);var i=document.createElement("canvas");return i.width=e,i.height=t,i},e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return s});var n=i(1),r=i(29),o=i(35),a=i(12),s=function(e){function t(t,i){var n=e.call(this,t,i,!0)||this;return i.multiMaterials.push(n),n.subMaterials=new Array,n._storeEffectOnSubMeshes=!0,n}return Object(n.d)(t,e),Object.defineProperty(t.prototype,"subMaterials",{get:function(){return this._subMaterials},set:function(e){this._subMaterials=e,this._hookArray(e)},enumerable:!0,configurable:!0}),t.prototype.getChildren=function(){return this.subMaterials},t.prototype._hookArray=function(e){var t=this,i=e.push;e.push=function(){for(var n=[],r=0;r<arguments.length;r++)n[r]=arguments[r];var o=i.apply(e,n);return t._markAllSubMeshesAsTexturesDirty(),o};var n=e.splice;e.splice=function(i,r){var o=n.apply(e,[i,r]);return t._markAllSubMeshesAsTexturesDirty(),o}},t.prototype.getSubMaterial=function(e){return e<0||e>=this.subMaterials.length?this.getScene().defaultMaterial:this.subMaterials[e]},t.prototype.getActiveTextures=function(){var t;return(t=e.prototype.getActiveTextures.call(this)).concat.apply(t,this.subMaterials.map(function(e){return e?e.getActiveTextures():[]}))},t.prototype.getClassName=function(){return"MultiMaterial"},t.prototype.isReadyForSubMesh=function(e,t,i){for(var n=0;n<this.subMaterials.length;n++){var r=this.subMaterials[n];if(r){if(r._storeEffectOnSubMeshes){if(!r.isReadyForSubMesh(e,t,i))return!1;continue}if(!r.isReady(e))return!1}}return!0},t.prototype.clone=function(e,i){for(var n=new t(e,this.getScene()),r=0;r<this.subMaterials.length;r++){var o=null,a=this.subMaterials[r];o=i&&a?a.clone(e+"-"+a.name):this.subMaterials[r],n.subMaterials.push(o)}return n},t.prototype.serialize=function(){var e={};e.name=this.name,e.id=this.id,o.a&&(e.tags=o.a.GetTags(this)),e.materials=[];for(var t=0;t<this.subMaterials.length;t++){var i=this.subMaterials[t];i?e.materials.push(i.id):e.materials.push(null)}return e},t.prototype.dispose=function(t,i,n){var r=this.getScene();if(r){if(n)for(var o=0;o<this.subMaterials.length;o++){var a=this.subMaterials[o];a&&a.dispose(t,i)}(o=r.multiMaterials.indexOf(this))>=0&&r.multiMaterials.splice(o,1),e.prototype.dispose.call(this,t,i)}},t.ParseMultiMaterial=function(e,i){var n=new t(e.name,i);n.id=e.id,o.a&&o.a.AddTagsTo(n,e.tags);for(var r=0;r<e.materials.length;r++){var a=e.materials[r];a?n.subMaterials.push(i.getLastMaterialByID(a)):n.subMaterials.push(null)}return n},t}(r.a);a.a.RegisteredTypes["BABYLON.MultiMaterial"]=s},function(e,t,i){"use strict";i.d(t,"a",function(){return f});var n=i(1),r=i(6),o=i(0),a=i(43),s=i(59),c=i(62),l=i(56),u=i(41),h=i(32),d=i(10),f=function(e){function t(i,n,a,s){void 0===n&&(n=d.a.Gray()),void 0===a&&(a=u.a.DefaultUtilityLayer),void 0===s&&(s=null);var l=e.call(this,a)||this;l._pointerObserver=null,l.snapDistance=0,l.onSnapObservable=new r.c,l._isEnabled=!0,l._parent=null,l._parent=s,l._coloredMaterial=new h.a("",a.utilityLayerScene),l._coloredMaterial.diffuseColor=n,l._coloredMaterial.specularColor=n.subtract(new d.a(.1,.1,.1)),l._hoverMaterial=new h.a("",a.utilityLayerScene),l._hoverMaterial.diffuseColor=n.add(new d.a(.3,.3,.3)),l._arrow=t._CreateArrow(a.utilityLayerScene,l._coloredMaterial),l._arrow.lookAt(l._rootMesh.position.add(i)),l._arrow.scaling.scaleInPlace(1/3),l._arrow.parent=l._rootMesh;var f=0,p=new o.e,_={snapDistance:0};l.dragBehavior=new c.a({dragAxis:i}),l.dragBehavior.moveAttached=!1,l._rootMesh.addBehavior(l.dragBehavior);var m=new o.e,g=new o.a;l.dragBehavior.onDragObservable.add(function(e){if(l.attachedMesh)if(l.attachedMesh.parent?(l.attachedMesh.parent.computeWorldMatrix().invertToRef(g),g.setTranslationFromFloats(0,0,0),o.e.TransformCoordinatesToRef(e.delta,g,m)):m.copyFrom(e.delta),0==l.snapDistance)l.attachedMesh.position.addInPlace(m);else if(f+=e.dragDistance,Math.abs(f)>l.snapDistance){var t=Math.floor(Math.abs(f)/l.snapDistance);f%=l.snapDistance,m.normalizeToRef(p),p.scaleInPlace(l.snapDistance*t),l.attachedMesh.position.addInPlace(p),_.snapDistance=l.snapDistance*t,l.onSnapObservable.notifyObservers(_)}}),l._pointerObserver=a.utilityLayerScene.onPointerObservable.add(function(e){if(!l._customMeshSet){var t=e.pickInfo&&-1!=l._rootMesh.getChildMeshes().indexOf(e.pickInfo.pickedMesh)?l._hoverMaterial:l._coloredMaterial;l._rootMesh.getChildMeshes().forEach(function(e){e.material=t,e.color&&(e.color=t.diffuseColor)})}});var v=a._getSharedGizmoLight();return v.includedOnlyMeshes=v.includedOnlyMeshes.concat(l._rootMesh.getChildMeshes(!1)),l}return Object(n.d)(t,e),t._CreateArrow=function(e,t){var i=new a.a("arrow",e),n=s.a.CreateCylinder("cylinder",{diameterTop:0,height:.075,diameterBottom:.0375,tessellation:96},e),r=s.a.CreateCylinder("cylinder",{diameterTop:.005,height:.275,diameterBottom:.005,tessellation:96},e);return r.material=t,n.parent=i,r.parent=i,n.material=t,n.rotation.x=Math.PI/2,n.position.z+=.3,r.position.z+=.1375,r.rotation.x=Math.PI/2,i},t._CreateArrowInstance=function(e,t){for(var i=new a.a("arrow",e),n=0,r=t.getChildMeshes();n<r.length;n++){var o=r[n];o.createInstance(o.name).parent=i}return i},t.prototype._attachedMeshChanged=function(e){this.dragBehavior&&(this.dragBehavior.enabled=!!e)},Object.defineProperty(t.prototype,"isEnabled",{get:function(){return this._isEnabled},set:function(e){this._isEnabled=e,e?this._parent&&(this.attachedMesh=this._parent.attachedMesh):this.attachedMesh=null},enumerable:!0,configurable:!0}),t.prototype.dispose=function(){this.onSnapObservable.clear(),this.gizmoLayer.utilityLayerScene.onPointerObservable.remove(this._pointerObserver),this.dragBehavior.detach(),this._arrow&&this._arrow.dispose(),[this._coloredMaterial,this._hoverMaterial].forEach(function(e){e&&e.dispose()}),e.prototype.dispose.call(this)},t}(l.a)},function(e,t,i){"use strict";i.d(t,"a",function(){return n});var n=function(){function e(){this._isDirty=!0,this._areLightsDirty=!0,this._areLightsDisposed=!1,this._areAttributesDirty=!0,this._areTexturesDirty=!0,this._areFresnelDirty=!0,this._areMiscDirty=!0,this._areImageProcessingDirty=!0,this._normals=!1,this._uvs=!1,this._needNormals=!1,this._needUVs=!1}return Object.defineProperty(e.prototype,"isDirty",{get:function(){return this._isDirty},enumerable:!0,configurable:!0}),e.prototype.markAsProcessed=function(){this._isDirty=!1,this._areAttributesDirty=!1,this._areTexturesDirty=!1,this._areFresnelDirty=!1,this._areLightsDirty=!1,this._areLightsDisposed=!1,this._areMiscDirty=!1,this._areImageProcessingDirty=!1},e.prototype.markAsUnprocessed=function(){this._isDirty=!0},e.prototype.markAllAsDirty=function(){this._areTexturesDirty=!0,this._areAttributesDirty=!0,this._areLightsDirty=!0,this._areFresnelDirty=!0,this._areMiscDirty=!0,this._areImageProcessingDirty=!0,this._isDirty=!0},e.prototype.markAsImageProcessingDirty=function(){this._areImageProcessingDirty=!0,this._isDirty=!0},e.prototype.markAsLightDirty=function(e){void 0===e&&(e=!1),this._areLightsDirty=!0,this._areLightsDisposed=this._areLightsDisposed||e,this._isDirty=!0},e.prototype.markAsAttributesDirty=function(){this._areAttributesDirty=!0,this._isDirty=!0},e.prototype.markAsTexturesDirty=function(){this._areTexturesDirty=!0,this._isDirty=!0},e.prototype.markAsFresnelDirty=function(){this._areFresnelDirty=!0,this._isDirty=!0},e.prototype.markAsMiscDirty=function(){this._areMiscDirty=!0,this._isDirty=!0},e.prototype.rebuild=function(){this._keys&&delete this._keys,this._keys=[];for(var e=0,t=Object.keys(this);e<t.length;e++){var i=t[e];"_"!==i[0]&&this._keys.push(i)}},e.prototype.isEqual=function(e){if(this._keys.length!==e._keys.length)return!1;for(var t=0;t<this._keys.length;t++){var i=this._keys[t];if(this[i]!==e[i])return!1}return!0},e.prototype.cloneTo=function(e){this._keys.length!==e._keys.length&&(e._keys=this._keys.slice(0));for(var t=0;t<this._keys.length;t++){var i=this._keys[t];e[i]=this[i]}},e.prototype.reset=function(){for(var e=0;e<this._keys.length;e++){var t=this._keys[e];switch(typeof this[t]){case"number":this[t]=0;break;case"string":this[t]="";break;default:this[t]=!1}}},e.prototype.toString=function(){for(var e="",t=0;t<this._keys.length;t++){var i=this._keys[t],n=this[i];switch(typeof n){case"number":case"string":e+="#define "+i+" "+n+"\n";break;default:n&&(e+="#define "+i+"\n")}}return e},e}()},function(e,t,i){"use strict";var n="bonesDeclaration",r="#if NUM_BONE_INFLUENCERS>0\n#ifdef BONETEXTURE\nuniform sampler2D boneSampler;\nuniform float boneTextureWidth;\n#else\nuniform mat4 mBones[BonesPerMesh];\n#endif\nattribute vec4 matricesIndices;\nattribute vec4 matricesWeights;\n#if NUM_BONE_INFLUENCERS>4\nattribute vec4 matricesIndicesExtra;\nattribute vec4 matricesWeightsExtra;\n#endif\n#ifdef BONETEXTURE\nmat4 readMatrixFromRawSampler(sampler2D smp,float index)\n{\nfloat offset=index*4.0;\nfloat dx=1.0/boneTextureWidth;\nvec4 m0=texture2D(smp,vec2(dx*(offset+0.5),0.));\nvec4 m1=texture2D(smp,vec2(dx*(offset+1.5),0.));\nvec4 m2=texture2D(smp,vec2(dx*(offset+2.5),0.));\nvec4 m3=texture2D(smp,vec2(dx*(offset+3.5),0.));\nreturn mat4(m0,m1,m2,m3);\n}\n#endif\n#endif";i(8).a.IncludesShadersStore[n]=r},function(e,t,i){"use strict";var n="#if NUM_BONE_INFLUENCERS>0\nmat4 influence;\n#ifdef BONETEXTURE\ninfluence=readMatrixFromRawSampler(boneSampler,matricesIndices[0])*matricesWeights[0];\n#if NUM_BONE_INFLUENCERS>1\ninfluence+=readMatrixFromRawSampler(boneSampler,matricesIndices[1])*matricesWeights[1];\n#endif\n#if NUM_BONE_INFLUENCERS>2\ninfluence+=readMatrixFromRawSampler(boneSampler,matricesIndices[2])*matricesWeights[2];\n#endif\n#if NUM_BONE_INFLUENCERS>3\ninfluence+=readMatrixFromRawSampler(boneSampler,matricesIndices[3])*matricesWeights[3];\n#endif\n#if NUM_BONE_INFLUENCERS>4\ninfluence+=readMatrixFromRawSampler(boneSampler,matricesIndicesExtra[0])*matricesWeightsExtra[0];\n#endif\n#if NUM_BONE_INFLUENCERS>5\ninfluence+=readMatrixFromRawSampler(boneSampler,matricesIndicesExtra[1])*matricesWeightsExtra[1];\n#endif\n#if NUM_BONE_INFLUENCERS>6\ninfluence+=readMatrixFromRawSampler(boneSampler,matricesIndicesExtra[2])*matricesWeightsExtra[2];\n#endif\n#if NUM_BONE_INFLUENCERS>7\ninfluence+=readMatrixFromRawSampler(boneSampler,matricesIndicesExtra[3])*matricesWeightsExtra[3];\n#endif\n#else\ninfluence=mBones[int(matricesIndices[0])]*matricesWeights[0];\n#if NUM_BONE_INFLUENCERS>1\ninfluence+=mBones[int(matricesIndices[1])]*matricesWeights[1];\n#endif\n#if NUM_BONE_INFLUENCERS>2\ninfluence+=mBones[int(matricesIndices[2])]*matricesWeights[2];\n#endif\n#if NUM_BONE_INFLUENCERS>3\ninfluence+=mBones[int(matricesIndices[3])]*matricesWeights[3];\n#endif\n#if NUM_BONE_INFLUENCERS>4\ninfluence+=mBones[int(matricesIndicesExtra[0])]*matricesWeightsExtra[0];\n#endif\n#if NUM_BONE_INFLUENCERS>5\ninfluence+=mBones[int(matricesIndicesExtra[1])]*matricesWeightsExtra[1];\n#endif\n#if NUM_BONE_INFLUENCERS>6\ninfluence+=mBones[int(matricesIndicesExtra[2])]*matricesWeightsExtra[2];\n#endif\n#if NUM_BONE_INFLUENCERS>7\ninfluence+=mBones[int(matricesIndicesExtra[3])]*matricesWeightsExtra[3];\n#endif\n#endif\nfinalWorld=finalWorld*influence;\n#endif";i(8).a.IncludesShadersStore.bonesVertex=n},function(e,t,i){"use strict";i.d(t,"a",function(){return n});var n=function(){function e(){}return e.FilesToLoad={},e}()},function(e,t,i){"use strict";var n="instancesDeclaration",r="#ifdef INSTANCES\nattribute vec4 world0;\nattribute vec4 world1;\nattribute vec4 world2;\nattribute vec4 world3;\n#else\nuniform mat4 world;\n#endif";i(8).a.IncludesShadersStore[n]=r},function(e,t,i){"use strict";var n="instancesVertex",r="#ifdef INSTANCES\nmat4 finalWorld=mat4(world0,world1,world2,world3);\n#else\nmat4 finalWorld=world;\n#endif";i(8).a.IncludesShadersStore[n]=r},function(e,t,i){"use strict";i.d(t,"a",function(){return o});var n=i(5),r=i(15);r.a.CreatePlane=function(e){var t=[],i=[],n=[],o=[],a=e.width||e.size||1,s=e.height||e.size||1,c=0===e.sideOrientation?0:e.sideOrientation||r.a.DEFAULTSIDE,l=a/2,u=s/2;i.push(-l,-u,0),n.push(0,0,-1),o.push(0,0),i.push(l,-u,0),n.push(0,0,-1),o.push(1,0),i.push(l,u,0),n.push(0,0,-1),o.push(1,1),i.push(-l,u,0),n.push(0,0,-1),o.push(0,1),t.push(0),t.push(1),t.push(2),t.push(0),t.push(2),t.push(3),r.a._ComputeSides(c,i,t,n,o,e.frontUVs,e.backUVs);var h=new r.a;return h.indices=t,h.positions=i,h.normals=n,h.uvs=o,h},n.a.CreatePlane=function(e,t,i,n,r){var a={size:t,width:t,height:t,sideOrientation:r,updatable:n};return o.CreatePlane(e,a,i)};var o=function(){function e(){}return e.CreatePlane=function(e,t,i){void 0===i&&(i=null);var o=new n.a(e,i);return t.sideOrientation=n.a._GetDefaultSideOrientation(t.sideOrientation),o._originalBuilderSideOrientation=t.sideOrientation,r.a.CreatePlane(t).applyToMesh(o,t.updatable),t.sourcePlane&&(o.translate(t.sourcePlane.normal,-t.sourcePlane.d),o.setDirection(t.sourcePlane.normal.scale(-1))),o},e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return l});var n=i(1),r=i(3),o=i(0),a=i(10),s=i(26),c=i(50);s.a.AddNodeConstructor("Light_Type_3",function(e,t){return function(){return new l(e,o.e.Zero(),t)}});var l=function(e){function t(t,i,n){var r=e.call(this,t,n)||this;return r.groundColor=new a.a(0,0,0),r.direction=i||o.e.Up(),r}return Object(n.d)(t,e),t.prototype._buildUniformLayout=function(){this._uniformBuffer.addUniform("vLightData",4),this._uniformBuffer.addUniform("vLightDiffuse",4),this._uniformBuffer.addUniform("vLightSpecular",4),this._uniformBuffer.addUniform("vLightGround",3),this._uniformBuffer.addUniform("shadowsInfo",3),this._uniformBuffer.addUniform("depthValues",2),this._uniformBuffer.create()},t.prototype.getClassName=function(){return"HemisphericLight"},t.prototype.setDirectionToTarget=function(e){return this.direction=o.e.Normalize(e.subtract(o.e.Zero())),this.direction},t.prototype.getShadowGenerator=function(){return null},t.prototype.transferToEffect=function(e,t){var i=o.e.Normalize(this.direction);return this._uniformBuffer.updateFloat4("vLightData",i.x,i.y,i.z,0,t),this._uniformBuffer.updateColor3("vLightGround",this.groundColor.scale(this.intensity),t),this},t.prototype.transferToNodeMaterialEffect=function(e,t){var i=o.e.Normalize(this.direction);return e.setFloat3(t,i.x,i.y,i.z),this},t.prototype.computeWorldMatrix=function(){return this._worldMatrix||(this._worldMatrix=o.a.Identity()),this._worldMatrix},t.prototype.getTypeID=function(){return c.a.LIGHTTYPEID_HEMISPHERICLIGHT},t.prototype.prepareLightSpecificDefines=function(e,t){e["HEMILIGHT"+t]=!0},Object(n.c)([Object(r.e)()],t.prototype,"groundColor",void 0),Object(n.c)([Object(r.o)()],t.prototype,"direction",void 0),t}(c.a)},function(e,t,i){"use strict";i.d(t,"a",function(){return o});var n=i(1),r=i(0),o=function(e){function t(t,i){var n=e.call(this,t,i)||this;return n._normalMatrix=new r.a,n.allowShaderHotSwapping=!0,n._storeEffectOnSubMeshes=!0,n}return Object(n.d)(t,e),t.prototype.getEffect=function(){return this._activeEffect},t.prototype.isReady=function(e,t){return!!e&&(!e.subMeshes||0===e.subMeshes.length||this.isReadyForSubMesh(e,e.subMeshes[0],t))},t.prototype.bindOnlyWorldMatrix=function(e){this._activeEffect.setMatrix("world",e)},t.prototype.bindOnlyNormalMatrix=function(e){this._activeEffect.setMatrix("normalMatrix",e)},t.prototype.bind=function(e,t){t&&this.bindForSubMesh(e,t,t.subMeshes[0])},t.prototype._afterBind=function(t,i){void 0===i&&(i=null),e.prototype._afterBind.call(this,t),this.getScene()._cachedEffect=i},t.prototype._mustRebind=function(e,t,i){return void 0===i&&(i=1),e.isCachedMaterialInvalid(this,t,i)},t}(i(29).a)},function(e,t,i){"use strict";i.d(t,"a",function(){return f});var n=i(1),r=i(3),o=i(0),a=i(4),s=i(9),c=i(16),l=i(29),u=i(12),h=i(10),d=i(64),f=function(e){function t(t,i,r,a){void 0===a&&(a={});var s=e.call(this,t,i)||this;return s._textures={},s._textureArrays={},s._floats={},s._ints={},s._floatsArrays={},s._colors3={},s._colors3Arrays={},s._colors4={},s._colors4Arrays={},s._vectors2={},s._vectors3={},s._vectors4={},s._matrices={},s._matrixArrays={},s._matrices3x3={},s._matrices2x2={},s._vectors2Arrays={},s._vectors3Arrays={},s._vectors4Arrays={},s._cachedWorldViewMatrix=new o.a,s._cachedWorldViewProjectionMatrix=new o.a,s._multiview=!1,s._shaderPath=r,s._options=Object(n.a)({needAlphaBlending:!1,needAlphaTesting:!1,attributes:["position","normal","uv"],uniforms:["worldViewProjection"],uniformBuffers:[],samplers:[],defines:[]},a),s}return Object(n.d)(t,e),Object.defineProperty(t.prototype,"shaderPath",{get:function(){return this._shaderPath},set:function(e){this._shaderPath=e},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"options",{get:function(){return this._options},enumerable:!0,configurable:!0}),t.prototype.getClassName=function(){return"ShaderMaterial"},t.prototype.needAlphaBlending=function(){return this.alpha<1||this._options.needAlphaBlending},t.prototype.needAlphaTesting=function(){return this._options.needAlphaTesting},t.prototype._checkUniform=function(e){-1===this._options.uniforms.indexOf(e)&&this._options.uniforms.push(e)},t.prototype.setTexture=function(e,t){return-1===this._options.samplers.indexOf(e)&&this._options.samplers.push(e),this._textures[e]=t,this},t.prototype.setTextureArray=function(e,t){return-1===this._options.samplers.indexOf(e)&&this._options.samplers.push(e),this._checkUniform(e),this._textureArrays[e]=t,this},t.prototype.setFloat=function(e,t){return this._checkUniform(e),this._floats[e]=t,this},t.prototype.setInt=function(e,t){return this._checkUniform(e),this._ints[e]=t,this},t.prototype.setFloats=function(e,t){return this._checkUniform(e),this._floatsArrays[e]=t,this},t.prototype.setColor3=function(e,t){return this._checkUniform(e),this._colors3[e]=t,this},t.prototype.setColor3Array=function(e,t){return this._checkUniform(e),this._colors3Arrays[e]=t.reduce(function(e,t){return t.toArray(e,e.length),e},[]),this},t.prototype.setColor4=function(e,t){return this._checkUniform(e),this._colors4[e]=t,this},t.prototype.setColor4Array=function(e,t){return this._checkUniform(e),this._colors4Arrays[e]=t.reduce(function(e,t){return t.toArray(e,e.length),e},[]),this},t.prototype.setVector2=function(e,t){return this._checkUniform(e),this._vectors2[e]=t,this},t.prototype.setVector3=function(e,t){return this._checkUniform(e),this._vectors3[e]=t,this},t.prototype.setVector4=function(e,t){return this._checkUniform(e),this._vectors4[e]=t,this},t.prototype.setMatrix=function(e,t){return this._checkUniform(e),this._matrices[e]=t,this},t.prototype.setMatrices=function(e,t){this._checkUniform(e);for(var i=new Float32Array(16*t.length),n=0;n<t.length;n++){t[n].copyToArray(i,16*n)}return this._matrixArrays[e]=i,this},t.prototype.setMatrix3x3=function(e,t){return this._checkUniform(e),this._matrices3x3[e]=t,this},t.prototype.setMatrix2x2=function(e,t){return this._checkUniform(e),this._matrices2x2[e]=t,this},t.prototype.setArray2=function(e,t){return this._checkUniform(e),this._vectors2Arrays[e]=t,this},t.prototype.setArray3=function(e,t){return this._checkUniform(e),this._vectors3Arrays[e]=t,this},t.prototype.setArray4=function(e,t){return this._checkUniform(e),this._vectors4Arrays[e]=t,this},t.prototype._checkCache=function(e,t){return!e||(!this._effect||-1!==this._effect.defines.indexOf("#define INSTANCES")===t)},t.prototype.isReadyForSubMesh=function(e,t,i){return this.isReady(e,i)},t.prototype.isReady=function(e,t){if(this._effect&&this.isFrozen&&this._effect._wasPreviouslyReady)return!0;var i=this.getScene(),n=i.getEngine();if(!this.checkReadyOnEveryCall&&this._renderId===i.getRenderId()&&this._checkCache(e,t))return!0;var r=[],o=[],s=new d.a;n.getCaps().multiview&&i.activeCamera&&i.activeCamera.outputRenderTarget&&i.activeCamera.outputRenderTarget.getViewCount()>1&&(this._multiview=!0,r.push("#define MULTIVIEW"),-1!==this._options.uniforms.indexOf("viewProjection")&&-1===this._options.uniforms.push("viewProjectionR")&&this._options.uniforms.push("viewProjectionR"));for(var l=0;l<this._options.defines.length;l++)r.push(this._options.defines[l]);for(l=0;l<this._options.attributes.length;l++)o.push(this._options.attributes[l]);if(e&&e.isVerticesDataPresent(a.b.ColorKind)&&(o.push(a.b.ColorKind),r.push("#define VERTEXCOLOR")),t&&(r.push("#define INSTANCES"),c.a.PushAttributesForInstances(o)),e&&e.useBones&&e.computeBonesUsingShaders&&e.skeleton){o.push(a.b.MatricesIndicesKind),o.push(a.b.MatricesWeightsKind),e.numBoneInfluencers>4&&(o.push(a.b.MatricesIndicesExtraKind),o.push(a.b.MatricesWeightsExtraKind));var u=e.skeleton;r.push("#define NUM_BONE_INFLUENCERS "+e.numBoneInfluencers),s.addCPUSkinningFallback(0,e),u.isUsingTextureForMatrices?(r.push("#define BONETEXTURE"),-1===this._options.uniforms.indexOf("boneTextureWidth")&&this._options.uniforms.push("boneTextureWidth"),-1===this._options.samplers.indexOf("boneSampler")&&this._options.samplers.push("boneSampler")):(r.push("#define BonesPerMesh "+(u.bones.length+1)),-1===this._options.uniforms.indexOf("mBones")&&this._options.uniforms.push("mBones"))}else r.push("#define NUM_BONE_INFLUENCERS 0");for(var h in this._textures)if(!this._textures[h].isReady())return!1;e&&this._shouldTurnAlphaTestOn(e)&&r.push("#define ALPHATEST");var f=this._effect,p=r.join("\n");return this._effect=n.createEffect(this._shaderPath,{attributes:o,uniformsNames:this._options.uniforms,uniformBuffersNames:this._options.uniformBuffers,samplers:this._options.samplers,defines:p,fallbacks:s,onCompiled:this.onCompiled,onError:this.onError},n),!!this._effect.isReady()&&(f!==this._effect&&i.resetCachedMaterial(),this._renderId=i.getRenderId(),this._effect._wasPreviouslyReady=!0,!0)},t.prototype.bindOnlyWorldMatrix=function(e){var t=this.getScene();this._effect&&(-1!==this._options.uniforms.indexOf("world")&&this._effect.setMatrix("world",e),-1!==this._options.uniforms.indexOf("worldView")&&(e.multiplyToRef(t.getViewMatrix(),this._cachedWorldViewMatrix),this._effect.setMatrix("worldView",this._cachedWorldViewMatrix)),-1!==this._options.uniforms.indexOf("worldViewProjection")&&(e.multiplyToRef(t.getTransformMatrix(),this._cachedWorldViewProjectionMatrix),this._effect.setMatrix("worldViewProjection",this._cachedWorldViewProjectionMatrix)))},t.prototype.bind=function(e,t){if(this.bindOnlyWorldMatrix(e),this._effect&&this.getScene().getCachedMaterial()!==this){var i;for(i in-1!==this._options.uniforms.indexOf("view")&&this._effect.setMatrix("view",this.getScene().getViewMatrix()),-1!==this._options.uniforms.indexOf("projection")&&this._effect.setMatrix("projection",this.getScene().getProjectionMatrix()),-1!==this._options.uniforms.indexOf("viewProjection")&&(this._effect.setMatrix("viewProjection",this.getScene().getTransformMatrix()),this._multiview&&this._effect.setMatrix("viewProjectionR",this.getScene()._transformMatrixR)),this.getScene().activeCamera&&-1!==this._options.uniforms.indexOf("cameraPosition")&&this._effect.setVector3("cameraPosition",this.getScene().activeCamera.globalPosition),c.a.BindBonesParameters(t,this._effect),this._textures)this._effect.setTexture(i,this._textures[i]);for(i in this._textureArrays)this._effect.setTextureArray(i,this._textureArrays[i]);for(i in this._ints)this._effect.setInt(i,this._ints[i]);for(i in this._floats)this._effect.setFloat(i,this._floats[i]);for(i in this._floatsArrays)this._effect.setArray(i,this._floatsArrays[i]);for(i in this._colors3)this._effect.setColor3(i,this._colors3[i]);for(i in this._colors3Arrays)this._effect.setArray3(i,this._colors3Arrays[i]);for(i in this._colors4){var n=this._colors4[i];this._effect.setFloat4(i,n.r,n.g,n.b,n.a)}for(i in this._colors4Arrays)this._effect.setArray4(i,this._colors4Arrays[i]);for(i in this._vectors2)this._effect.setVector2(i,this._vectors2[i]);for(i in this._vectors3)this._effect.setVector3(i,this._vectors3[i]);for(i in this._vectors4)this._effect.setVector4(i,this._vectors4[i]);for(i in this._matrices)this._effect.setMatrix(i,this._matrices[i]);for(i in this._matrixArrays)this._effect.setMatrices(i,this._matrixArrays[i]);for(i in this._matrices3x3)this._effect.setMatrix3x3(i,this._matrices3x3[i]);for(i in this._matrices2x2)this._effect.setMatrix2x2(i,this._matrices2x2[i]);for(i in this._vectors2Arrays)this._effect.setArray2(i,this._vectors2Arrays[i]);for(i in this._vectors3Arrays)this._effect.setArray3(i,this._vectors3Arrays[i]);for(i in this._vectors4Arrays)this._effect.setArray4(i,this._vectors4Arrays[i])}this._afterBind(t)},t.prototype.getActiveTextures=function(){var t=e.prototype.getActiveTextures.call(this);for(var i in this._textures)t.push(this._textures[i]);for(var i in this._textureArrays)for(var n=this._textureArrays[i],r=0;r<n.length;r++)t.push(n[r]);return t},t.prototype.hasTexture=function(t){if(e.prototype.hasTexture.call(this,t))return!0;for(var i in this._textures)if(this._textures[i]===t)return!0;for(var i in this._textureArrays)for(var n=this._textureArrays[i],r=0;r<n.length;r++)if(n[r]===t)return!0;return!1},t.prototype.clone=function(e){var i=this,o=r.a.Clone(function(){return new t(e,i.getScene(),i._shaderPath,i._options)},this);for(var a in o.name=e,o.id=e,"object"==typeof o._shaderPath&&(o._shaderPath=Object(n.a)({},o._shaderPath)),this._options=Object(n.a)({},this._options),Object.keys(this._options).forEach(function(e){var t=i._options[e];Array.isArray(t)&&(i._options[e]=t.slice(0))}),this._textures)o.setTexture(a,this._textures[a]);for(var a in this._floats)o.setFloat(a,this._floats[a]);for(var a in this._floatsArrays)o.setFloats(a,this._floatsArrays[a]);for(var a in this._colors3)o.setColor3(a,this._colors3[a]);for(var a in this._colors4)o.setColor4(a,this._colors4[a]);for(var a in this._vectors2)o.setVector2(a,this._vectors2[a]);for(var a in this._vectors3)o.setVector3(a,this._vectors3[a]);for(var a in this._vectors4)o.setVector4(a,this._vectors4[a]);for(var a in this._matrices)o.setMatrix(a,this._matrices[a]);for(var a in this._matrices3x3)o.setMatrix3x3(a,this._matrices3x3[a]);for(var a in this._matrices2x2)o.setMatrix2x2(a,this._matrices2x2[a]);return o},t.prototype.dispose=function(t,i,n){if(i){var r;for(r in this._textures)this._textures[r].dispose();for(r in this._textureArrays)for(var o=this._textureArrays[r],a=0;a<o.length;a++)o[a].dispose()}this._textures={},e.prototype.dispose.call(this,t,i,n)},t.prototype.serialize=function(){var e,t=r.a.Serialize(this);for(e in t.customType="BABYLON.ShaderMaterial",t.options=this._options,t.shaderPath=this._shaderPath,t.textures={},this._textures)t.textures[e]=this._textures[e].serialize();for(e in t.textureArrays={},this._textureArrays){t.textureArrays[e]=[];for(var i=this._textureArrays[e],n=0;n<i.length;n++)t.textureArrays[e].push(i[n].serialize())}for(e in t.floats={},this._floats)t.floats[e]=this._floats[e];for(e in t.FloatArrays={},this._floatsArrays)t.FloatArrays[e]=this._floatsArrays[e];for(e in t.colors3={},this._colors3)t.colors3[e]=this._colors3[e].asArray();for(e in t.colors3Arrays={},this._colors3Arrays)t.colors3Arrays[e]=this._colors3Arrays[e];for(e in t.colors4={},this._colors4)t.colors4[e]=this._colors4[e].asArray();for(e in t.colors4Arrays={},this._colors4Arrays)t.colors4Arrays[e]=this._colors4Arrays[e];for(e in t.vectors2={},this._vectors2)t.vectors2[e]=this._vectors2[e].asArray();for(e in t.vectors3={},this._vectors3)t.vectors3[e]=this._vectors3[e].asArray();for(e in t.vectors4={},this._vectors4)t.vectors4[e]=this._vectors4[e].asArray();for(e in t.matrices={},this._matrices)t.matrices[e]=this._matrices[e].asArray();for(e in t.matrixArray={},this._matrixArrays)t.matrixArray[e]=this._matrixArrays[e];for(e in t.matrices3x3={},this._matrices3x3)t.matrices3x3[e]=this._matrices3x3[e];for(e in t.matrices2x2={},this._matrices2x2)t.matrices2x2[e]=this._matrices2x2[e];for(e in t.vectors2Arrays={},this._vectors2Arrays)t.vectors2Arrays[e]=this._vectors2Arrays[e];for(e in t.vectors3Arrays={},this._vectors3Arrays)t.vectors3Arrays[e]=this._vectors3Arrays[e];for(e in t.vectors4Arrays={},this._vectors4Arrays)t.vectors4Arrays[e]=this._vectors4Arrays[e];return t},t.Parse=function(e,i,n){var a,c=r.a.Parse(function(){return new t(e.name,i,e.shaderPath,e.options)},e,i,n);for(a in e.textures)c.setTexture(a,s.a.Parse(e.textures[a],i,n));for(a in e.textureArrays){for(var l=e.textureArrays[a],u=new Array,d=0;d<l.length;d++)u.push(s.a.Parse(l[d],i,n));c.setTextureArray(a,u)}for(a in e.floats)c.setFloat(a,e.floats[a]);for(a in e.floatsArrays)c.setFloats(a,e.floatsArrays[a]);for(a in e.colors3)c.setColor3(a,h.a.FromArray(e.colors3[a]));for(a in e.colors3Arrays){var f=e.colors3Arrays[a].reduce(function(e,t,i){return i%3==0?e.push([t]):e[e.length-1].push(t),e},[]).map(function(e){return h.a.FromArray(e)});c.setColor3Array(a,f)}for(a in e.colors4)c.setColor4(a,h.b.FromArray(e.colors4[a]));for(a in e.colors4Arrays){f=e.colors4Arrays[a].reduce(function(e,t,i){return i%4==0?e.push([t]):e[e.length-1].push(t),e},[]).map(function(e){return h.b.FromArray(e)});c.setColor4Array(a,f)}for(a in e.vectors2)c.setVector2(a,o.d.FromArray(e.vectors2[a]));for(a in e.vectors3)c.setVector3(a,o.e.FromArray(e.vectors3[a]));for(a in e.vectors4)c.setVector4(a,o.f.FromArray(e.vectors4[a]));for(a in e.matrices)c.setMatrix(a,o.a.FromArray(e.matrices[a]));for(a in e.matrixArray)c._matrixArrays[a]=new Float32Array(e.matrixArray[a]);for(a in e.matrices3x3)c.setMatrix3x3(a,e.matrices3x3[a]);for(a in e.matrices2x2)c.setMatrix2x2(a,e.matrices2x2[a]);for(a in e.vectors2Arrays)c.setArray2(a,e.vectors2Arrays[a]);for(a in e.vectors3Arrays)c.setArray3(a,e.vectors3Arrays[a]);for(a in e.vectors4Arrays)c.setArray4(a,e.vectors4Arrays[a]);return c},t}(l.a);u.a.RegisteredTypes["BABYLON.ShaderMaterial"]=f},function(e,t,i){"use strict";var n=i(7),r=i(31),o=i(84);r.a.prototype.createUniformBuffer=function(e){var t=this._gl.createBuffer();if(!t)throw new Error("Unable to create uniform buffer");var i=new o.a(t);return this.bindUniformBuffer(i),e instanceof Float32Array?this._gl.bufferData(this._gl.UNIFORM_BUFFER,e,this._gl.STATIC_DRAW):this._gl.bufferData(this._gl.UNIFORM_BUFFER,new Float32Array(e),this._gl.STATIC_DRAW),this.bindUniformBuffer(null),i.references=1,i},r.a.prototype.createDynamicUniformBuffer=function(e){var t=this._gl.createBuffer();if(!t)throw new Error("Unable to create dynamic uniform buffer");var i=new o.a(t);return this.bindUniformBuffer(i),e instanceof Float32Array?this._gl.bufferData(this._gl.UNIFORM_BUFFER,e,this._gl.DYNAMIC_DRAW):this._gl.bufferData(this._gl.UNIFORM_BUFFER,new Float32Array(e),this._gl.DYNAMIC_DRAW),this.bindUniformBuffer(null),i.references=1,i},r.a.prototype.updateUniformBuffer=function(e,t,i,n){this.bindUniformBuffer(e),void 0===i&&(i=0),void 0===n?t instanceof Float32Array?this._gl.bufferSubData(this._gl.UNIFORM_BUFFER,i,t):this._gl.bufferSubData(this._gl.UNIFORM_BUFFER,i,new Float32Array(t)):t instanceof Float32Array?this._gl.bufferSubData(this._gl.UNIFORM_BUFFER,0,t.subarray(i,i+n)):this._gl.bufferSubData(this._gl.UNIFORM_BUFFER,0,new Float32Array(t).subarray(i,i+n)),this.bindUniformBuffer(null)},r.a.prototype.bindUniformBuffer=function(e){this._gl.bindBuffer(this._gl.UNIFORM_BUFFER,e?e.underlyingResource:null)},r.a.prototype.bindUniformBufferBase=function(e,t){this._gl.bindBufferBase(this._gl.UNIFORM_BUFFER,t,e?e.underlyingResource:null)},r.a.prototype.bindUniformBlock=function(e,t,i){var n=e.program,r=this._gl.getUniformBlockIndex(n,t);this._gl.uniformBlockBinding(n,r,i)},i.d(t,"a",function(){return a});var a=function(){function e(e,t,i){this._alreadyBound=!1,this._valueCache={},this._engine=e,this._noUBO=!e.supportsUniformBuffers,this._dynamic=i,this._data=t||[],this._uniformLocations={},this._uniformSizes={},this._uniformLocationPointer=0,this._needSync=!1,this._noUBO?(this.updateMatrix3x3=this._updateMatrix3x3ForEffect,this.updateMatrix2x2=this._updateMatrix2x2ForEffect,this.updateFloat=this._updateFloatForEffect,this.updateFloat2=this._updateFloat2ForEffect,this.updateFloat3=this._updateFloat3ForEffect,this.updateFloat4=this._updateFloat4ForEffect,this.updateMatrix=this._updateMatrixForEffect,this.updateVector3=this._updateVector3ForEffect,this.updateVector4=this._updateVector4ForEffect,this.updateColor3=this._updateColor3ForEffect,this.updateColor4=this._updateColor4ForEffect):(this._engine._uniformBuffers.push(this),this.updateMatrix3x3=this._updateMatrix3x3ForUniform,this.updateMatrix2x2=this._updateMatrix2x2ForUniform,this.updateFloat=this._updateFloatForUniform,this.updateFloat2=this._updateFloat2ForUniform,this.updateFloat3=this._updateFloat3ForUniform,this.updateFloat4=this._updateFloat4ForUniform,this.updateMatrix=this._updateMatrixForUniform,this.updateVector3=this._updateVector3ForUniform,this.updateVector4=this._updateVector4ForUniform,this.updateColor3=this._updateColor3ForUniform,this.updateColor4=this._updateColor4ForUniform)}return Object.defineProperty(e.prototype,"useUbo",{get:function(){return!this._noUBO},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"isSync",{get:function(){return!this._needSync},enumerable:!0,configurable:!0}),e.prototype.isDynamic=function(){return void 0!==this._dynamic},e.prototype.getData=function(){return this._bufferData},e.prototype.getBuffer=function(){return this._buffer},e.prototype._fillAlignment=function(e){var t;if(t=e<=2?e:4,this._uniformLocationPointer%t!=0){var i=this._uniformLocationPointer;this._uniformLocationPointer+=t-this._uniformLocationPointer%t;for(var n=this._uniformLocationPointer-i,r=0;r<n;r++)this._data.push(0)}},e.prototype.addUniform=function(e,t){if(!this._noUBO&&void 0===this._uniformLocations[e]){var i;if(t instanceof Array)t=(i=t).length;else{t=t,i=[];for(var n=0;n<t;n++)i.push(0)}this._fillAlignment(t),this._uniformSizes[e]=t,this._uniformLocations[e]=this._uniformLocationPointer,this._uniformLocationPointer+=t;for(n=0;n<t;n++)this._data.push(i[n]);this._needSync=!0}},e.prototype.addMatrix=function(e,t){this.addUniform(e,Array.prototype.slice.call(t.toArray()))},e.prototype.addFloat2=function(e,t,i){var n=[t,i];this.addUniform(e,n)},e.prototype.addFloat3=function(e,t,i,n){var r=[t,i,n];this.addUniform(e,r)},e.prototype.addColor3=function(e,t){var i=new Array;t.toArray(i),this.addUniform(e,i)},e.prototype.addColor4=function(e,t,i){var n=new Array;t.toArray(n),n.push(i),this.addUniform(e,n)},e.prototype.addVector3=function(e,t){var i=new Array;t.toArray(i),this.addUniform(e,i)},e.prototype.addMatrix3x3=function(e){this.addUniform(e,12)},e.prototype.addMatrix2x2=function(e){this.addUniform(e,8)},e.prototype.create=function(){this._noUBO||this._buffer||(this._fillAlignment(4),this._bufferData=new Float32Array(this._data),this._rebuild(),this._needSync=!0)},e.prototype._rebuild=function(){!this._noUBO&&this._bufferData&&(this._dynamic?this._buffer=this._engine.createDynamicUniformBuffer(this._bufferData):this._buffer=this._engine.createUniformBuffer(this._bufferData))},e.prototype.update=function(){this._buffer?(this._dynamic||this._needSync)&&(this._engine.updateUniformBuffer(this._buffer,this._bufferData),this._needSync=!1):this.create()},e.prototype.updateUniform=function(e,t,i){var r=this._uniformLocations[e];if(void 0===r){if(this._buffer)return void n.a.Error("Cannot add an uniform after UBO has been created.");this.addUniform(e,i),r=this._uniformLocations[e]}if(this._buffer||this.create(),this._dynamic)for(a=0;a<i;a++)this._bufferData[r+a]=t[a];else{for(var o=!1,a=0;a<i;a++)16!==i&&this._bufferData[r+a]===t[a]||(o=!0,this._bufferData[r+a]=t[a]);this._needSync=this._needSync||o}},e.prototype._cacheMatrix=function(e,t){var i=this._valueCache[e],n=t.updateFlag;return(void 0===i||i!==n)&&(this._valueCache[e]=n,!0)},e.prototype._updateMatrix3x3ForUniform=function(t,i){for(var n=0;n<3;n++)e._tempBuffer[4*n]=i[3*n],e._tempBuffer[4*n+1]=i[3*n+1],e._tempBuffer[4*n+2]=i[3*n+2],e._tempBuffer[4*n+3]=0;this.updateUniform(t,e._tempBuffer,12)},e.prototype._updateMatrix3x3ForEffect=function(e,t){this._currentEffect.setMatrix3x3(e,t)},e.prototype._updateMatrix2x2ForEffect=function(e,t){this._currentEffect.setMatrix2x2(e,t)},e.prototype._updateMatrix2x2ForUniform=function(t,i){for(var n=0;n<2;n++)e._tempBuffer[4*n]=i[2*n],e._tempBuffer[4*n+1]=i[2*n+1],e._tempBuffer[4*n+2]=0,e._tempBuffer[4*n+3]=0;this.updateUniform(t,e._tempBuffer,8)},e.prototype._updateFloatForEffect=function(e,t){this._currentEffect.setFloat(e,t)},e.prototype._updateFloatForUniform=function(t,i){e._tempBuffer[0]=i,this.updateUniform(t,e._tempBuffer,1)},e.prototype._updateFloat2ForEffect=function(e,t,i,n){void 0===n&&(n=""),this._currentEffect.setFloat2(e+n,t,i)},e.prototype._updateFloat2ForUniform=function(t,i,n){e._tempBuffer[0]=i,e._tempBuffer[1]=n,this.updateUniform(t,e._tempBuffer,2)},e.prototype._updateFloat3ForEffect=function(e,t,i,n,r){void 0===r&&(r=""),this._currentEffect.setFloat3(e+r,t,i,n)},e.prototype._updateFloat3ForUniform=function(t,i,n,r){e._tempBuffer[0]=i,e._tempBuffer[1]=n,e._tempBuffer[2]=r,this.updateUniform(t,e._tempBuffer,3)},e.prototype._updateFloat4ForEffect=function(e,t,i,n,r,o){void 0===o&&(o=""),this._currentEffect.setFloat4(e+o,t,i,n,r)},e.prototype._updateFloat4ForUniform=function(t,i,n,r,o){e._tempBuffer[0]=i,e._tempBuffer[1]=n,e._tempBuffer[2]=r,e._tempBuffer[3]=o,this.updateUniform(t,e._tempBuffer,4)},e.prototype._updateMatrixForEffect=function(e,t){this._currentEffect.setMatrix(e,t)},e.prototype._updateMatrixForUniform=function(e,t){this._cacheMatrix(e,t)&&this.updateUniform(e,t.toArray(),16)},e.prototype._updateVector3ForEffect=function(e,t){this._currentEffect.setVector3(e,t)},e.prototype._updateVector3ForUniform=function(t,i){i.toArray(e._tempBuffer),this.updateUniform(t,e._tempBuffer,3)},e.prototype._updateVector4ForEffect=function(e,t){this._currentEffect.setVector4(e,t)},e.prototype._updateVector4ForUniform=function(t,i){i.toArray(e._tempBuffer),this.updateUniform(t,e._tempBuffer,4)},e.prototype._updateColor3ForEffect=function(e,t,i){void 0===i&&(i=""),this._currentEffect.setColor3(e+i,t)},e.prototype._updateColor3ForUniform=function(t,i){i.toArray(e._tempBuffer),this.updateUniform(t,e._tempBuffer,3)},e.prototype._updateColor4ForEffect=function(e,t,i,n){void 0===n&&(n=""),this._currentEffect.setColor4(e+n,t,i)},e.prototype._updateColor4ForUniform=function(t,i,n){i.toArray(e._tempBuffer),e._tempBuffer[3]=n,this.updateUniform(t,e._tempBuffer,4)},e.prototype.setTexture=function(e,t){this._currentEffect.setTexture(e,t)},e.prototype.updateUniformDirectly=function(e,t){this.updateUniform(e,t,t.length),this.update()},e.prototype.bindToEffect=function(e,t){this._currentEffect=e,!this._noUBO&&this._buffer&&(this._alreadyBound=!0,e.bindUniformBuffer(this._buffer,t))},e.prototype.dispose=function(){if(!this._noUBO){var e=this._engine._uniformBuffers,t=e.indexOf(this);-1!==t&&(e[t]=e[e.length-1],e.pop()),this._buffer&&this._engine._releaseBuffer(this._buffer)&&(this._buffer=null)}},e._MAX_UNIFORM_SIZE=256,e._tempBuffer=new Float32Array(e._MAX_UNIFORM_SIZE),e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return r});var n=i(1),r=function(e){function t(t){var i=e.call(this)||this;return i._buffer=t,i}return Object(n.d)(t,e),Object.defineProperty(t.prototype,"underlyingResource",{get:function(){return this._buffer},enumerable:!0,configurable:!0}),t}(i(85).a)},function(e,t,i){"use strict";i.d(t,"a",function(){return n});var n=function(){function e(){this.references=0,this.capacity=0,this.is32Bits=!1}return Object.defineProperty(e.prototype,"underlyingResource",{get:function(){return null},enumerable:!0,configurable:!0}),e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return r});var n=i(60),r=function(){function e(){}return e.GetPlanes=function(t){for(var i=[],r=0;r<6;r++)i.push(new n.a(0,0,0,0));return e.GetPlanesToRef(t,i),i},e.GetNearPlaneToRef=function(e,t){var i=e.m;t.normal.x=i[3]+i[2],t.normal.y=i[7]+i[6],t.normal.z=i[11]+i[10],t.d=i[15]+i[14],t.normalize()},e.GetFarPlaneToRef=function(e,t){var i=e.m;t.normal.x=i[3]-i[2],t.normal.y=i[7]-i[6],t.normal.z=i[11]-i[10],t.d=i[15]-i[14],t.normalize()},e.GetLeftPlaneToRef=function(e,t){var i=e.m;t.normal.x=i[3]+i[0],t.normal.y=i[7]+i[4],t.normal.z=i[11]+i[8],t.d=i[15]+i[12],t.normalize()},e.GetRightPlaneToRef=function(e,t){var i=e.m;t.normal.x=i[3]-i[0],t.normal.y=i[7]-i[4],t.normal.z=i[11]-i[8],t.d=i[15]-i[12],t.normalize()},e.GetTopPlaneToRef=function(e,t){var i=e.m;t.normal.x=i[3]-i[1],t.normal.y=i[7]-i[5],t.normal.z=i[11]-i[9],t.d=i[15]-i[13],t.normalize()},e.GetBottomPlaneToRef=function(e,t){var i=e.m;t.normal.x=i[3]+i[1],t.normal.y=i[7]+i[5],t.normal.z=i[11]+i[9],t.d=i[15]+i[13],t.normalize()},e.GetPlanesToRef=function(t,i){e.GetNearPlaneToRef(t,i[0]),e.GetFarPlaneToRef(t,i[1]),e.GetLeftPlaneToRef(t,i[2]),e.GetRightPlaneToRef(t,i[3]),e.GetTopPlaneToRef(t,i[4]),e.GetBottomPlaneToRef(t,i[5])},e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return r});var n=i(2),r=function(){function e(){this.hoverCursor="",this.actions=new Array,this.isRecursive=!1}return Object.defineProperty(e,"HasTriggers",{get:function(){for(var t in e.Triggers)if(e.Triggers.hasOwnProperty(t))return!0;return!1},enumerable:!0,configurable:!0}),Object.defineProperty(e,"HasPickTriggers",{get:function(){for(var t in e.Triggers)if(e.Triggers.hasOwnProperty(t)){var i=parseInt(t);if(i>=n.a.ACTION_OnPickTrigger&&i<=n.a.ACTION_OnPickUpTrigger)return!0}return!1},enumerable:!0,configurable:!0}),e.HasSpecificTrigger=function(t){for(var i in e.Triggers){if(e.Triggers.hasOwnProperty(i))if(parseInt(i)===t)return!0}return!1},e.Triggers={},e}()},function(e,t,i){"use strict";var n="morphTargetsVertexGlobalDeclaration",r="#ifdef MORPHTARGETS\nuniform float morphTargetInfluences[NUM_MORPH_INFLUENCERS];\n#endif";i(8).a.IncludesShadersStore[n]=r},function(e,t,i){"use strict";var n="morphTargetsVertexDeclaration",r="#ifdef MORPHTARGETS\nattribute vec3 position{X};\n#ifdef MORPHTARGETS_NORMAL\nattribute vec3 normal{X};\n#endif\n#ifdef MORPHTARGETS_TANGENT\nattribute vec3 tangent{X};\n#endif\n#ifdef MORPHTARGETS_UV\nattribute vec2 uv_{X};\n#endif\n#endif";i(8).a.IncludesShadersStore[n]=r},function(e,t,i){"use strict";i.d(t,"a",function(){return a});var n=i(29),r=i(4),o=i(2),a=function(){function e(e){this._vertexBuffers={},this._scene=e}return e.prototype._prepareBuffers=function(){if(!this._vertexBuffers[r.b.PositionKind]){var e=[];e.push(1,1),e.push(-1,1),e.push(-1,-1),e.push(1,-1),this._vertexBuffers[r.b.PositionKind]=new r.b(this._scene.getEngine(),e,r.b.PositionKind,!1,!1,2),this._buildIndexBuffer()}},e.prototype._buildIndexBuffer=function(){var e=[];e.push(0),e.push(1),e.push(2),e.push(0),e.push(2),e.push(3),this._indexBuffer=this._scene.getEngine().createIndexBuffer(e)},e.prototype._rebuild=function(){var e=this._vertexBuffers[r.b.PositionKind];e&&(e._rebuild(),this._buildIndexBuffer())},e.prototype._prepareFrame=function(e,t){void 0===e&&(e=null),void 0===t&&(t=null);var i=this._scene.activeCamera;return!!i&&(!(!(t=t||i._postProcesses.filter(function(e){return null!=e}))||0===t.length||!this._scene.postProcessesEnabled)&&(t[0].activate(i,e,null!=t),!0))},e.prototype.directRender=function(e,t,i,r,o){void 0===t&&(t=null),void 0===i&&(i=!1),void 0===r&&(r=0),void 0===o&&(o=0);for(var a=this._scene.getEngine(),s=0;s<e.length;s++){s<e.length-1?e[s+1].activate(this._scene.activeCamera,t):t?a.bindFramebuffer(t,r,void 0,void 0,i,o):a.restoreDefaultFramebuffer();var c=e[s],l=c.apply();l&&(c.onBeforeRenderObservable.notifyObservers(l),this._prepareBuffers(),a.bindBuffers(this._vertexBuffers,this._indexBuffer,l),a.drawElementsType(n.a.TriangleFillMode,0,6),c.onAfterRenderObservable.notifyObservers(l))}a.setDepthBuffer(!0),a.setDepthWrite(!0)},e.prototype._finalizeFrame=function(e,t,i,r,a){void 0===a&&(a=!1);var s=this._scene.activeCamera;if(s&&0!==(r=r||s._postProcesses.filter(function(e){return null!=e})).length&&this._scene.postProcessesEnabled){for(var c=this._scene.getEngine(),l=0,u=r.length;l<u;l++){var h=r[l];if(l<u-1?h._outputTexture=r[l+1].activate(s,t):t?(c.bindFramebuffer(t,i,void 0,void 0,a),h._outputTexture=t):(c.restoreDefaultFramebuffer(),h._outputTexture=null),e)break;var d=h.apply();d&&(h.onBeforeRenderObservable.notifyObservers(d),this._prepareBuffers(),c.bindBuffers(this._vertexBuffers,this._indexBuffer,d),c.drawElementsType(n.a.TriangleFillMode,0,6),h.onAfterRenderObservable.notifyObservers(d))}c.setDepthBuffer(!0),c.setDepthWrite(!0),c.setAlphaMode(o.a.ALPHA_DISABLE)}},e.prototype.dispose=function(){var e=this._vertexBuffers[r.b.PositionKind];e&&(e.dispose(),this._vertexBuffers[r.b.PositionKind]=null),this._indexBuffer&&(this._scene.getEngine()._releaseBuffer(this._indexBuffer),this._indexBuffer=null)},e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return r}),i.d(t,"b",function(){return o});var n=i(134),r=function(){},o=function(){function e(t){this._useSceneAutoClearSetup=!1,this._renderingGroups=new Array,this._autoClearDepthStencil={},this._customOpaqueSortCompareFn={},this._customAlphaTestSortCompareFn={},this._customTransparentSortCompareFn={},this._renderingGroupInfo=new r,this._scene=t;for(var i=e.MIN_RENDERINGGROUPS;i<e.MAX_RENDERINGGROUPS;i++)this._autoClearDepthStencil[i]={autoClear:!0,depth:!0,stencil:!0}}return e.prototype._clearDepthStencilBuffer=function(e,t){void 0===e&&(e=!0),void 0===t&&(t=!0),this._depthStencilBufferAlreadyCleaned||(this._scene.getEngine().clear(null,!1,e,t),this._depthStencilBufferAlreadyCleaned=!0)},e.prototype.render=function(t,i,n,r){var o=this._renderingGroupInfo;if(o.scene=this._scene,o.camera=this._scene.activeCamera,this._scene.spriteManagers&&r)for(var a=0;a<this._scene.spriteManagers.length;a++){var s=this._scene.spriteManagers[a];this.dispatchSprites(s)}for(a=e.MIN_RENDERINGGROUPS;a<e.MAX_RENDERINGGROUPS;a++){this._depthStencilBufferAlreadyCleaned=a===e.MIN_RENDERINGGROUPS;var c=this._renderingGroups[a];if(c){var l=Math.pow(2,a);if(o.renderingGroupId=a,this._scene.onBeforeRenderingGroupObservable.notifyObservers(o,l),e.AUTOCLEAR){var u=this._useSceneAutoClearSetup?this._scene.getAutoClearDepthStencilSetup(a):this._autoClearDepthStencil[a];u&&u.autoClear&&this._clearDepthStencilBuffer(u.depth,u.stencil)}for(var h=0,d=this._scene._beforeRenderingGroupDrawStage;h<d.length;h++){d[h].action(a)}c.render(t,r,n,i);for(var f=0,p=this._scene._afterRenderingGroupDrawStage;f<p.length;f++){p[f].action(a)}this._scene.onAfterRenderingGroupObservable.notifyObservers(o,l)}}},e.prototype.reset=function(){for(var t=e.MIN_RENDERINGGROUPS;t<e.MAX_RENDERINGGROUPS;t++){var i=this._renderingGroups[t];i&&i.prepare()}},e.prototype.dispose=function(){this.freeRenderingGroups(),this._renderingGroups.length=0,this._renderingGroupInfo=null},e.prototype.freeRenderingGroups=function(){for(var t=e.MIN_RENDERINGGROUPS;t<e.MAX_RENDERINGGROUPS;t++){var i=this._renderingGroups[t];i&&i.dispose()}},e.prototype._prepareRenderingGroup=function(e){void 0===this._renderingGroups[e]&&(this._renderingGroups[e]=new n.a(e,this._scene,this._customOpaqueSortCompareFn[e],this._customAlphaTestSortCompareFn[e],this._customTransparentSortCompareFn[e]))},e.prototype.dispatchSprites=function(e){var t=e.renderingGroupId||0;this._prepareRenderingGroup(t),this._renderingGroups[t].dispatchSprites(e)},e.prototype.dispatchParticles=function(e){var t=e.renderingGroupId||0;this._prepareRenderingGroup(t),this._renderingGroups[t].dispatchParticles(e)},e.prototype.dispatch=function(e,t,i){void 0===t&&(t=e.getMesh());var n=t.renderingGroupId||0;this._prepareRenderingGroup(n),this._renderingGroups[n].dispatch(e,t,i)},e.prototype.setRenderingOrder=function(e,t,i,n){if(void 0===t&&(t=null),void 0===i&&(i=null),void 0===n&&(n=null),this._customOpaqueSortCompareFn[e]=t,this._customAlphaTestSortCompareFn[e]=i,this._customTransparentSortCompareFn[e]=n,this._renderingGroups[e]){var r=this._renderingGroups[e];r.opaqueSortCompareFn=this._customOpaqueSortCompareFn[e],r.alphaTestSortCompareFn=this._customAlphaTestSortCompareFn[e],r.transparentSortCompareFn=this._customTransparentSortCompareFn[e]}},e.prototype.setRenderingAutoClearDepthStencil=function(e,t,i,n){void 0===i&&(i=!0),void 0===n&&(n=!0),this._autoClearDepthStencil[e]={autoClear:t,depth:i,stencil:n}},e.prototype.getAutoClearDepthStencilSetup=function(e){return this._autoClearDepthStencil[e]},e.MAX_RENDERINGGROUPS=4,e.MIN_RENDERINGGROUPS=0,e.AUTOCLEAR=!0,e}()},function(e,t,i){"use strict";i.d(t,"b",function(){return h}),i.d(t,"a",function(){return d});var n=i(1),r=i(10),o=i(4),a=i(5),s=i(136),c=i(29),l=i(82),u=i(16),h=(i(148),i(149),function(e){function t(t,i,n,a,s,c,u){void 0===i&&(i=null),void 0===n&&(n=null),void 0===a&&(a=null);var h=e.call(this,t,i,n,a,s)||this;h.useVertexColor=c,h.useVertexAlpha=u,h.color=new r.a(1,1,1),h.alpha=1,a&&(h.color=a.color.clone(),h.alpha=a.alpha,h.useVertexColor=a.useVertexColor,h.useVertexAlpha=a.useVertexAlpha),h.intersectionThreshold=.1;var d={attributes:[o.b.PositionKind,"world0","world1","world2","world3"],uniforms:["vClipPlane","vClipPlane2","vClipPlane3","vClipPlane4","vClipPlane5","vClipPlane6","world","viewProjection"],needAlphaBlending:!0,defines:[]};return!1===u&&(d.needAlphaBlending=!1),c?(d.defines.push("#define VERTEXCOLOR"),d.attributes.push(o.b.ColorKind)):(d.uniforms.push("color"),h.color4=new r.b),h._colorShader=new l.a("colorShader",h.getScene(),"color",d),h}return Object(n.d)(t,e),t.prototype._addClipPlaneDefine=function(e){var t="#define "+e;-1===this._colorShader.options.defines.indexOf(t)&&this._colorShader.options.defines.push(t)},t.prototype._removeClipPlaneDefine=function(e){var t="#define "+e,i=this._colorShader.options.defines.indexOf(t);-1!==i&&this._colorShader.options.defines.splice(i,1)},t.prototype.isReady=function(){var t=this.getScene();return t.clipPlane?this._addClipPlaneDefine("CLIPPLANE"):this._removeClipPlaneDefine("CLIPPLANE"),t.clipPlane2?this._addClipPlaneDefine("CLIPPLANE2"):this._removeClipPlaneDefine("CLIPPLANE2"),t.clipPlane3?this._addClipPlaneDefine("CLIPPLANE3"):this._removeClipPlaneDefine("CLIPPLANE3"),t.clipPlane4?this._addClipPlaneDefine("CLIPPLANE4"):this._removeClipPlaneDefine("CLIPPLANE4"),t.clipPlane5?this._addClipPlaneDefine("CLIPPLANE5"):this._removeClipPlaneDefine("CLIPPLANE5"),t.clipPlane6?this._addClipPlaneDefine("CLIPPLANE6"):this._removeClipPlaneDefine("CLIPPLANE6"),!!this._colorShader.isReady()&&e.prototype.isReady.call(this)},t.prototype.getClassName=function(){return"LinesMesh"},Object.defineProperty(t.prototype,"material",{get:function(){return this._colorShader},set:function(e){},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"checkCollisions",{get:function(){return!1},enumerable:!0,configurable:!0}),t.prototype._bind=function(e,t,i){if(!this._geometry)return this;var n=this._colorShader.getEffect(),r=this.isUnIndexed?null:this._geometry.getIndexBuffer();if(this._geometry._bind(n,r),!this.useVertexColor){var o=this.color,a=o.r,s=o.g,c=o.b;this.color4.set(a,s,c,this.alpha),this._colorShader.setColor4("color",this.color4)}return u.a.BindClipPlane(n,this.getScene()),this},t.prototype._draw=function(e,t,i){if(!this._geometry||!this._geometry.getVertexBuffers()||!this._unIndexed&&!this._geometry.getIndexBuffer())return this;var n=this.getScene().getEngine();return this._unIndexed?n.drawArraysType(c.a.LineListDrawMode,e.verticesStart,e.verticesCount,i):n.drawElementsType(c.a.LineListDrawMode,e.indexStart,e.indexCount,i),this},t.prototype.dispose=function(t){this._colorShader.dispose(!1,!1,!0),e.prototype.dispose.call(this,t)},t.prototype.clone=function(e,i,n){return void 0===i&&(i=null),new t(e,this.getScene(),i,this,n)},t.prototype.createInstance=function(e){return new d(e,this)},t}(a.a)),d=function(e){function t(t,i){var n=e.call(this,t,i)||this;return n.intersectionThreshold=i.intersectionThreshold,n}return Object(n.d)(t,e),t.prototype.getClassName=function(){return"InstancedLinesMesh"},t}(s.a)},function(e,t,i){"use strict";i.r(t);var n,r=i(0),o=i(32),a=i(72),s=i(10),c=function(){function e(t,i,n,c,l,u){if(void 0===i&&(i=1),void 0===n&&(n=2),this._scaleLinesFactor=4,this._instanced=!1,this.scaleLines=1,this.scaleLines=i,!c){var h=new o.a("",t);h.disableLighting=!0,h.emissiveColor=s.a.Red().scale(.5),c=a.a._CreateArrow(t,h)}if(!l){var d=new o.a("",t);d.disableLighting=!0,d.emissiveColor=s.a.Green().scale(.5),l=a.a._CreateArrow(t,d)}if(!u){var f=new o.a("",t);f.disableLighting=!0,f.emissiveColor=s.a.Blue().scale(.5),u=a.a._CreateArrow(t,f)}this._xAxis=c,this._xAxis.scaling.setAll(this.scaleLines*this._scaleLinesFactor),this._yAxis=l,this._yAxis.scaling.setAll(this.scaleLines*this._scaleLinesFactor),this._zAxis=u,this._zAxis.scaling.setAll(this.scaleLines*this._scaleLinesFactor),null!=n&&(e._SetRenderingGroupId(this._xAxis,n),e._SetRenderingGroupId(this._yAxis,n),e._SetRenderingGroupId(this._zAxis,n)),this.scene=t,this.update(new r.e,r.e.Right(),r.e.Up(),r.e.Forward())}return Object.defineProperty(e.prototype,"xAxis",{get:function(){return this._xAxis},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"yAxis",{get:function(){return this._yAxis},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"zAxis",{get:function(){return this._zAxis},enumerable:!0,configurable:!0}),e.prototype.update=function(e,t,i,n){this._xAxis.position.copyFrom(e),this._xAxis.setDirection(t),this._xAxis.scaling.setAll(this.scaleLines*this._scaleLinesFactor),this._yAxis.position.copyFrom(e),this._yAxis.setDirection(i),this._yAxis.scaling.setAll(this.scaleLines*this._scaleLinesFactor),this._zAxis.position.copyFrom(e),this._zAxis.setDirection(n),this._zAxis.scaling.setAll(this.scaleLines*this._scaleLinesFactor)},e.prototype.createInstance=function(){var t=a.a._CreateArrowInstance(this.scene,this._xAxis),i=a.a._CreateArrowInstance(this.scene,this._yAxis),n=a.a._CreateArrowInstance(this.scene,this._zAxis),r=new e(this.scene,this.scaleLines,null,t,i,n);return r._instanced=!0,r},e.prototype.dispose=function(){this._xAxis&&(this._xAxis.dispose(!1,!this._instanced),delete this._xAxis),this._yAxis&&(this._yAxis.dispose(!1,!this._instanced),delete this._yAxis),this._zAxis&&(this._zAxis.dispose(!1,!this._instanced),delete this._zAxis),delete this.scene},e._SetRenderingGroupId=function(e,t){e.getChildMeshes().forEach(function(e){e.renderingGroupId=t})},e}(),l=i(1),u=i(22),h=function(e){function t(t,i,n,o){void 0===o&&(o=1);var a=e.call(this,t,o)||this;return a.pos=r.e.Zero(),a.xaxis=r.e.Zero(),a.yaxis=r.e.Zero(),a.zaxis=r.e.Zero(),a.mesh=n,a.bone=i,a}return Object(l.d)(t,e),t.prototype.update=function(){if(this.mesh&&this.bone){var t=this.bone;t._markAsDirtyAndCompose(),t.getAbsolutePositionToRef(this.mesh,this.pos),t.getDirectionToRef(u.a.X,this.mesh,this.xaxis),t.getDirectionToRef(u.a.Y,this.mesh,this.yaxis),t.getDirectionToRef(u.a.Z,this.mesh,this.zaxis),e.prototype.update.call(this,this.pos,this.xaxis,this.yaxis,this.zaxis)}},t.prototype.dispose=function(){this.mesh&&(this.mesh=null,this.bone=null,e.prototype.dispose.call(this))},t}(c),d=i(13),f=i(6),p=i(18),_=i(11);Object.defineProperty(p.a.prototype,"debugLayer",{get:function(){return this._debugLayer||(this._debugLayer=new m(this)),this._debugLayer},enumerable:!0,configurable:!0}),function(e){e[e.Properties=0]="Properties",e[e.Debug=1]="Debug",e[e.Statistics=2]="Statistics",e[e.Tools=3]="Tools",e[e.Settings=4]="Settings"}(n||(n={}));var m=function(){function e(e){var t=this;this.BJSINSPECTOR=this._getGlobalInspector(),this._scene=e,this._scene.onDisposeObservable.add(function(){t._scene._debugLayer&&t._scene._debugLayer.hide()})}return Object.defineProperty(e.prototype,"onPropertyChangedObservable",{get:function(){return this.BJSINSPECTOR&&this.BJSINSPECTOR.Inspector?this.BJSINSPECTOR.Inspector.OnPropertyChangedObservable:(this._onPropertyChangedObservable||(this._onPropertyChangedObservable=new f.c),this._onPropertyChangedObservable)},enumerable:!0,configurable:!0}),e.prototype._createInspector=function(e){if(!this.isVisible()){if(this._onPropertyChangedObservable){for(var t=0,i=this._onPropertyChangedObservable.observers;t<i.length;t++){var n=i[t];this.BJSINSPECTOR.Inspector.OnPropertyChangedObservable.add(n)}this._onPropertyChangedObservable.clear(),this._onPropertyChangedObservable=void 0}var r=Object(l.a)({overlay:!1,showExplorer:!0,showInspector:!0,embedMode:!1,handleResize:!0,enablePopup:!0},e);this.BJSINSPECTOR=this.BJSINSPECTOR||this._getGlobalInspector(),this.BJSINSPECTOR.Inspector.Show(this._scene,r)}},e.prototype.select=function(e,t){this.BJSINSPECTOR&&(this.BJSINSPECTOR.Inspector.MarkLineContainerTitleForHighlighting(t),this.BJSINSPECTOR.Inspector.OnSelectionChangeObservable.notifyObservers(e))},e.prototype._getGlobalInspector=function(){return"undefined"!=typeof INSPECTOR?INSPECTOR:"undefined"!=typeof BABYLON&&void 0!==BABYLON.Inspector?BABYLON:void 0},e.prototype.isVisible=function(){return this.BJSINSPECTOR&&this.BJSINSPECTOR.Inspector.IsVisible},e.prototype.hide=function(){this.BJSINSPECTOR&&this.BJSINSPECTOR.Inspector.Hide()},e.prototype.show=function(t){var i=this;return new Promise(function(n,r){if(void 0===i.BJSINSPECTOR){var o=t&&t.inspectorURL?t.inspectorURL:e.InspectorURL;d.b.LoadScript(o,function(){i._createInspector(t),n(i)})}else i._createInspector(t),n(i)})},e.InspectorURL="https://unpkg.com/babylonjs-inspector@"+_.a.Version+"/babylon.inspector.bundle.js",e}(),g=i(5),v=i(66),y=i(48),b=i(23),T=i(30),E=i(41),x=i(59),P=function(){function e(e){this._impostors=[],this._meshes=[],this._numMeshes=0,this._debugMeshMeshes=new Array,this._scene=e||b.a.LastCreatedScene;var t=this._scene.getPhysicsEngine();t&&(this._physicsEnginePlugin=t.getPhysicsPlugin()),this._utilityLayer=new E.a(this._scene,!1),this._utilityLayer.pickUtilitySceneFirst=!1,this._utilityLayer.utilityLayerScene.autoClearDepthAndStencil=!0}return e.prototype._updateDebugMeshes=function(){for(var e=this._physicsEnginePlugin,t=0;t<this._numMeshes;t++){var i=this._impostors[t];if(i)if(i.isDisposed)this.hideImpostor(this._impostors[t--]);else{if(i.type===T.a.MeshImpostor)continue;var n=this._meshes[t];n&&e&&e.syncMeshWithImpostor(n,i)}}},e.prototype.showImpostor=function(e,t){if(!this._scene)return null;for(var i=0;i<this._numMeshes;i++)if(this._impostors[i]==e)return null;var n=this._getDebugMesh(e,t);return n&&(this._impostors[this._numMeshes]=e,this._meshes[this._numMeshes]=n,0===this._numMeshes&&(this._renderFunction=this._updateDebugMeshes.bind(this),this._scene.registerBeforeRender(this._renderFunction)),this._numMeshes++),n},e.prototype.hideImpostor=function(e){if(e&&this._scene&&this._utilityLayer){for(var t=!1,i=this._utilityLayer.utilityLayerScene,n=0;n<this._numMeshes;n++)if(this._impostors[n]==e){var r=this._meshes[n];if(!r)continue;i.removeMesh(r),r.dispose();var o=this._debugMeshMeshes.indexOf(r);o>-1&&this._debugMeshMeshes.splice(o,1),this._numMeshes--,this._numMeshes>0?(this._meshes[n]=this._meshes[this._numMeshes],this._impostors[n]=this._impostors[this._numMeshes],this._meshes[this._numMeshes]=null,this._impostors[this._numMeshes]=null):(this._meshes[0]=null,this._impostors[0]=null),t=!0;break}t&&0===this._numMeshes&&this._scene.unregisterBeforeRender(this._renderFunction)}},e.prototype._getDebugMaterial=function(e){return this._debugMaterial||(this._debugMaterial=new o.a("",e),this._debugMaterial.wireframe=!0,this._debugMaterial.emissiveColor=s.a.White(),this._debugMaterial.disableLighting=!0),this._debugMaterial},e.prototype._getDebugBoxMesh=function(e){return this._debugBoxMesh||(this._debugBoxMesh=v.a.CreateBox("physicsBodyBoxViewMesh",{size:1},e),this._debugBoxMesh.rotationQuaternion=r.b.Identity(),this._debugBoxMesh.material=this._getDebugMaterial(e),this._debugBoxMesh.setEnabled(!1)),this._debugBoxMesh.createInstance("physicsBodyBoxViewInstance")},e.prototype._getDebugSphereMesh=function(e){return this._debugSphereMesh||(this._debugSphereMesh=y.a.CreateSphere("physicsBodySphereViewMesh",{diameter:1},e),this._debugSphereMesh.rotationQuaternion=r.b.Identity(),this._debugSphereMesh.material=this._getDebugMaterial(e),this._debugSphereMesh.setEnabled(!1)),this._debugSphereMesh.createInstance("physicsBodyBoxViewInstance")},e.prototype._getDebugCylinderMesh=function(e){return this._debugCylinderMesh||(this._debugCylinderMesh=x.a.CreateCylinder("physicsBodyCylinderViewMesh",{diameterTop:1,diameterBottom:1,height:1},e),this._debugCylinderMesh.rotationQuaternion=r.b.Identity(),this._debugCylinderMesh.material=this._getDebugMaterial(e),this._debugCylinderMesh.setEnabled(!1)),this._debugCylinderMesh.createInstance("physicsBodyBoxViewInstance")},e.prototype._getDebugMeshMesh=function(e,t){var i=new g.a(e.name,t,null,e);return i.position=r.e.Zero(),i.setParent(e),i.material=this._getDebugMaterial(t),this._debugMeshMeshes.push(i),i},e.prototype._getDebugMesh=function(e,t){var i=this;if(!this._utilityLayer)return null;if(t&&t.parent&&t.parent.physicsImpostor)return null;var n=null,r=this._utilityLayer.utilityLayerScene;switch(e.type){case T.a.BoxImpostor:n=this._getDebugBoxMesh(r),e.getBoxSizeToRef(n.scaling);break;case T.a.SphereImpostor:n=this._getDebugSphereMesh(r);var o=e.getRadius();n.scaling.x=2*o,n.scaling.y=2*o,n.scaling.z=2*o;break;case T.a.MeshImpostor:t&&(n=this._getDebugMeshMesh(t,r));break;case T.a.NoImpostor:if(t)t.getChildMeshes().filter(function(e){return e.physicsImpostor?1:0}).forEach(function(e){i._getDebugBoxMesh(r).parent=e});break;case T.a.CylinderImpostor:n=this._getDebugCylinderMesh(r);var a=e.object.getBoundingInfo();n.scaling.x=a.boundingBox.maximum.x-a.boundingBox.minimum.x,n.scaling.y=a.boundingBox.maximum.y-a.boundingBox.minimum.y,n.scaling.z=a.boundingBox.maximum.z-a.boundingBox.minimum.z}return n},e.prototype.dispose=function(){for(var e=this._numMeshes,t=0;t<e;t++)this.hideImpostor(this._impostors[0]);this._debugBoxMesh&&this._debugBoxMesh.dispose(),this._debugSphereMesh&&this._debugSphereMesh.dispose(),this._debugCylinderMesh&&this._debugCylinderMesh.dispose(),this._debugMaterial&&this._debugMaterial.dispose(),this._impostors.length=0,this._scene=null,this._physicsEnginePlugin=null,this._utilityLayer&&(this._utilityLayer.dispose(),this._utilityLayer=null)},e}(),A=i(46),S=function(){function e(e){this.ray=e}return e.CreateAndShow=function(t,i,n){var r=new e(t);return r.show(i,n),r},e.prototype.show=function(e,t){if(!this._renderFunction&&this.ray){var i=this.ray;this._renderFunction=this._render.bind(this),this._scene=e,this._renderPoints=[i.origin,i.origin.add(i.direction.scale(i.length))],this._renderLine=g.a.CreateLines("ray",this._renderPoints,e,!0),this._renderFunction&&this._scene.registerBeforeRender(this._renderFunction)}t&&this._renderLine&&this._renderLine.color.copyFrom(t)},e.prototype.hide=function(){this._renderFunction&&this._scene&&(this._scene.unregisterBeforeRender(this._renderFunction),this._scene=null,this._renderFunction=null,this._renderLine&&(this._renderLine.dispose(),this._renderLine=null),this._renderPoints=[])},e.prototype._render=function(){var e=this.ray;if(e){var t=this._renderPoints[1],i=Math.min(e.length,1e6);t.copyFrom(e.direction),t.scaleInPlace(i),t.addInPlace(e.origin),g.a.CreateLines("ray",this._renderPoints,this._scene,!0,this._renderLine)}},e.prototype.attachToMesh=function(e,t,i,n){this._attachedToMesh=e;var o=this.ray;o&&(o.direction||(o.direction=r.e.Zero()),o.origin||(o.origin=r.e.Zero()),n&&(o.length=n),i||(i=r.e.Zero()),t||(t=new r.e(0,0,-1)),this._meshSpaceDirection?(this._meshSpaceDirection.copyFrom(t),this._meshSpaceOrigin.copyFrom(i)):(this._meshSpaceDirection=t.clone(),this._meshSpaceOrigin=i.clone()),this._updateToMeshFunction||(this._updateToMeshFunction=this._updateToMesh.bind(this),this._attachedToMesh.getScene().registerBeforeRender(this._updateToMeshFunction)),this._updateToMesh())},e.prototype.detachFromMesh=function(){this._attachedToMesh&&(this._updateToMeshFunction&&this._attachedToMesh.getScene().unregisterBeforeRender(this._updateToMeshFunction),this._attachedToMesh=null,this._updateToMeshFunction=null)},e.prototype._updateToMesh=function(){var e=this.ray;this._attachedToMesh&&e&&(this._attachedToMesh._isDisposed?this.detachFromMesh():(this._attachedToMesh.getDirectionToRef(this._meshSpaceDirection,e.direction),r.e.TransformCoordinatesToRef(this._meshSpaceOrigin,this._attachedToMesh.getWorldMatrix(),e.origin)))},e.prototype.dispose=function(){this.hide(),this.detachFromMesh(),this.ray=null},e}(),C=function(){function e(e,t,i,n,r){void 0===n&&(n=!0),void 0===r&&(r=1),this.skeleton=e,this.mesh=t,this.autoUpdateBonesMatrices=n,this.renderingGroupId=r,this.color=s.a.White(),this._debugLines=new Array,this._isEnabled=!1,this._scene=i,this._utilityLayer=new E.a(this._scene,!1),this._utilityLayer.pickUtilitySceneFirst=!1,this._utilityLayer.utilityLayerScene.autoClearDepthAndStencil=!0,this.update(),this._renderFunction=this.update.bind(this)}return Object.defineProperty(e.prototype,"debugMesh",{get:function(){return this._debugMesh},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"isEnabled",{get:function(){return this._isEnabled},set:function(e){this._isEnabled!==e&&(this._isEnabled=e,e?this._scene.registerBeforeRender(this._renderFunction):this._scene.unregisterBeforeRender(this._renderFunction))},enumerable:!0,configurable:!0}),e.prototype._getBonePosition=function(e,t,i,n,o,a){void 0===n&&(n=0),void 0===o&&(o=0),void 0===a&&(a=0);var s=r.c.Matrix[0],c=t.getParent();if(s.copyFrom(t.getLocalMatrix()),0!==n||0!==o||0!==a){var l=r.c.Matrix[1];r.a.IdentityToRef(l),l.setTranslationFromFloats(n,o,a),l.multiplyToRef(s,s)}c&&s.multiplyToRef(c.getAbsoluteTransform(),s),s.multiplyToRef(i,s),e.x=s.m[12],e.y=s.m[13],e.z=s.m[14]},e.prototype._getLinesForBonesWithLength=function(e,t){for(var i=e.length,n=this.mesh._effectiveMesh.position,o=0;o<i;o++){var a=e[o],s=this._debugLines[o];s||(s=[r.e.Zero(),r.e.Zero()],this._debugLines[o]=s),this._getBonePosition(s[0],a,t),this._getBonePosition(s[1],a,t,0,a.length,0),s[0].subtractInPlace(n),s[1].subtractInPlace(n)}},e.prototype._getLinesForBonesNoLength=function(e,t){for(var i=e.length,n=0,o=this.mesh._effectiveMesh,a=o.position,s=i-1;s>=0;s--){var c=e[s],l=c.getParent();if(l){var u=this._debugLines[n];u||(u=[r.e.Zero(),r.e.Zero()],this._debugLines[n]=u),c.getAbsolutePositionToRef(o,u[0]),l.getAbsolutePositionToRef(o,u[1]),u[0].subtractInPlace(a),u[1].subtractInPlace(a),n++}}},e.prototype.update=function(){if(this._utilityLayer){this.autoUpdateBonesMatrices&&this.skeleton.computeAbsoluteTransforms();var e=this.mesh._effectiveMesh;void 0===this.skeleton.bones[0].length?this._getLinesForBonesNoLength(this.skeleton.bones,e.getWorldMatrix()):this._getLinesForBonesWithLength(this.skeleton.bones,e.getWorldMatrix());var t=this._utilityLayer.utilityLayerScene;this._debugMesh?A.a.CreateLineSystem("",{lines:this._debugLines,updatable:!0,instance:this._debugMesh},t):(this._debugMesh=A.a.CreateLineSystem("",{lines:this._debugLines,updatable:!0,instance:null},t),this._debugMesh.renderingGroupId=this.renderingGroupId),this._debugMesh.position.copyFrom(this.mesh.position),this._debugMesh.color=this.color}},e.prototype.dispose=function(){this.isEnabled=!1,this._debugMesh&&(this.isEnabled=!1,this._debugMesh.dispose(),this._debugMesh=null),this._utilityLayer&&(this._utilityLayer.dispose(),this._utilityLayer=null)},e}();i.d(t,"AxesViewer",function(){return c}),i.d(t,"BoneAxesViewer",function(){return h}),i.d(t,"DebugLayerTab",function(){return n}),i.d(t,"DebugLayer",function(){return m}),i.d(t,"PhysicsViewer",function(){return P}),i.d(t,"RayHelper",function(){return S}),i.d(t,"SkeletonViewer",function(){return C})},function(e,t,i){"use strict";var n="morphTargetsVertex",r="#ifdef MORPHTARGETS\npositionUpdated+=(position{X}-position)*morphTargetInfluences[{X}];\n#ifdef MORPHTARGETS_NORMAL\nnormalUpdated+=(normal{X}-normal)*morphTargetInfluences[{X}];\n#endif\n#ifdef MORPHTARGETS_TANGENT\ntangentUpdated.xyz+=(tangent{X}-tangent.xyz)*morphTargetInfluences[{X}];\n#endif\n#ifdef MORPHTARGETS_UV\nuvUpdated+=(uv_{X}-uv)*morphTargetInfluences[{X}];\n#endif\n#endif";i(8).a.IncludesShadersStore[n]=r},function(e,t,i){"use strict";i.d(t,"a",function(){return n});var n=function(){}},function(e,t,i){"use strict";i.d(t,"a",function(){return a});var n=i(42),r=i(0),o=i(28),a=function(){function e(e,t,i){this.vectors=n.a.BuildArray(8,r.e.Zero),this.center=r.e.Zero(),this.centerWorld=r.e.Zero(),this.extendSize=r.e.Zero(),this.extendSizeWorld=r.e.Zero(),this.directions=n.a.BuildArray(3,r.e.Zero),this.vectorsWorld=n.a.BuildArray(8,r.e.Zero),this.minimumWorld=r.e.Zero(),this.maximumWorld=r.e.Zero(),this.minimum=r.e.Zero(),this.maximum=r.e.Zero(),this.reConstruct(e,t,i)}return e.prototype.reConstruct=function(e,t,i){var n=e.x,o=e.y,a=e.z,s=t.x,c=t.y,l=t.z,u=this.vectors;this.minimum.copyFromFloats(n,o,a),this.maximum.copyFromFloats(s,c,l),u[0].copyFromFloats(n,o,a),u[1].copyFromFloats(s,c,l),u[2].copyFromFloats(s,o,a),u[3].copyFromFloats(n,c,a),u[4].copyFromFloats(n,o,l),u[5].copyFromFloats(s,c,a),u[6].copyFromFloats(n,c,l),u[7].copyFromFloats(s,o,l),t.addToRef(e,this.center).scaleInPlace(.5),t.subtractToRef(e,this.extendSize).scaleInPlace(.5),this._worldMatrix=i||r.a.IdentityReadOnly,this._update(this._worldMatrix)},e.prototype.scale=function(t){var i=e.TmpVector3,n=this.maximum.subtractToRef(this.minimum,i[0]),r=n.length();n.normalizeFromLength(r);var o=r*t,a=n.scaleInPlace(.5*o),s=this.center.subtractToRef(a,i[1]),c=this.center.addToRef(a,i[2]);return this.reConstruct(s,c,this._worldMatrix),this},e.prototype.getWorldMatrix=function(){return this._worldMatrix},e.prototype._update=function(e){var t=this.minimumWorld,i=this.maximumWorld,n=this.directions,o=this.vectorsWorld,a=this.vectors;if(e.isIdentity()){t.copyFrom(this.minimum),i.copyFrom(this.maximum);for(s=0;s<8;++s)o[s].copyFrom(a[s]);this.extendSizeWorld.copyFrom(this.extendSize),this.centerWorld.copyFrom(this.center)}else{t.setAll(Number.MAX_VALUE),i.setAll(-Number.MAX_VALUE);for(var s=0;s<8;++s){var c=o[s];r.e.TransformCoordinatesToRef(a[s],e,c),t.minimizeInPlace(c),i.maximizeInPlace(c)}i.subtractToRef(t,this.extendSizeWorld).scaleInPlace(.5),i.addToRef(t,this.centerWorld).scaleInPlace(.5)}r.e.FromArrayToRef(e.m,0,n[0]),r.e.FromArrayToRef(e.m,4,n[1]),r.e.FromArrayToRef(e.m,8,n[2]),this._worldMatrix=e},e.prototype.isInFrustum=function(t){return e.IsInFrustum(this.vectorsWorld,t)},e.prototype.isCompletelyInFrustum=function(t){return e.IsCompletelyInFrustum(this.vectorsWorld,t)},e.prototype.intersectsPoint=function(e){var t=this.minimumWorld,i=this.maximumWorld,n=t.x,r=t.y,a=t.z,s=i.x,c=i.y,l=i.z,u=e.x,h=e.y,d=e.z,f=-o.a;return!(s-u<f||f>u-n)&&(!(c-h<f||f>h-r)&&!(l-d<f||f>d-a))},e.prototype.intersectsSphere=function(t){return e.IntersectsSphere(this.minimumWorld,this.maximumWorld,t.centerWorld,t.radiusWorld)},e.prototype.intersectsMinMax=function(e,t){var i=this.minimumWorld,n=this.maximumWorld,r=i.x,o=i.y,a=i.z,s=n.x,c=n.y,l=n.z,u=e.x,h=e.y,d=e.z,f=t.x,p=t.y,_=t.z;return!(s<u||r>f)&&(!(c<h||o>p)&&!(l<d||a>_))},e.Intersects=function(e,t){return e.intersectsMinMax(t.minimumWorld,t.maximumWorld)},e.IntersectsSphere=function(t,i,n,o){var a=e.TmpVector3[0];return r.e.ClampToRef(n,t,i,a),r.e.DistanceSquared(n,a)<=o*o},e.IsCompletelyInFrustum=function(e,t){for(var i=0;i<6;++i)for(var n=t[i],r=0;r<8;++r)if(n.dotCoordinate(e[r])<0)return!1;return!0},e.IsInFrustum=function(e,t){for(var i=0;i<6;++i){for(var n=!0,r=t[i],o=0;o<8;++o)if(r.dotCoordinate(e[o])>=0){n=!1;break}if(n)return!1}return!0},e.TmpVector3=n.a.BuildArray(3,r.e.Zero),e}()},function(e,t,i){"use strict";var n="lightFragmentDeclaration",r="#ifdef LIGHT{X}\nuniform vec4 vLightData{X};\nuniform vec4 vLightDiffuse{X};\n#ifdef SPECULARTERM\nuniform vec4 vLightSpecular{X};\n#else\nvec4 vLightSpecular{X}=vec4(0.);\n#endif\n#ifdef SHADOW{X}\n#ifdef SHADOWCSM{X}\nuniform mat4 lightMatrix{X}[SHADOWCSMNUM_CASCADES{X}];\nuniform float viewFrustumZ{X}[SHADOWCSMNUM_CASCADES{X}];\nuniform float frustumLengths{X}[SHADOWCSMNUM_CASCADES{X}];\nuniform float cascadeBlendFactor{X};\nvarying vec4 vPositionFromLight{X}[SHADOWCSMNUM_CASCADES{X}];\nvarying float vDepthMetric{X}[SHADOWCSMNUM_CASCADES{X}];\nvarying vec4 vPositionFromCamera{X};\n#if defined(SHADOWPCSS{X})\nuniform highp sampler2DArrayShadow shadowSampler{X};\nuniform highp sampler2DArray depthSampler{X};\nuniform vec2 lightSizeUVCorrection{X}[SHADOWCSMNUM_CASCADES{X}];\nuniform float depthCorrection{X}[SHADOWCSMNUM_CASCADES{X}];\nuniform float penumbraDarkness{X};\n#elif defined(SHADOWPCF{X})\nuniform highp sampler2DArrayShadow shadowSampler{X};\n#else\nuniform highp sampler2DArray shadowSampler{X};\n#endif\n#ifdef SHADOWCSMDEBUG{X}\nconst vec3 vCascadeColorsMultiplier{X}[8]=vec3[8]\n(\nvec3 ( 1.5,0.0,0.0 ),\nvec3 ( 0.0,1.5,0.0 ),\nvec3 ( 0.0,0.0,5.5 ),\nvec3 ( 1.5,0.0,5.5 ),\nvec3 ( 1.5,1.5,0.0 ),\nvec3 ( 1.0,1.0,1.0 ),\nvec3 ( 0.0,1.0,5.5 ),\nvec3 ( 0.5,3.5,0.75 )\n);\nvec3 shadowDebug{X};\n#endif\n#ifdef SHADOWCSMUSESHADOWMAXZ{X}\nint index{X}=-1;\n#else\nint index{X}=SHADOWCSMNUM_CASCADES{X}-1;\n#endif\nfloat diff{X}=0.;\n#elif defined(SHADOWCUBE{X})\nuniform samplerCube shadowSampler{X};\n#else\nvarying vec4 vPositionFromLight{X};\nvarying float vDepthMetric{X};\n#if defined(SHADOWPCSS{X})\nuniform highp sampler2DShadow shadowSampler{X};\nuniform highp sampler2D depthSampler{X};\n#elif defined(SHADOWPCF{X})\nuniform highp sampler2DShadow shadowSampler{X};\n#else\nuniform sampler2D shadowSampler{X};\n#endif\nuniform mat4 lightMatrix{X};\n#endif\nuniform vec4 shadowsInfo{X};\nuniform vec2 depthValues{X};\n#endif\n#ifdef SPOTLIGHT{X}\nuniform vec4 vLightDirection{X};\nuniform vec4 vLightFalloff{X};\n#elif defined(POINTLIGHT{X})\nuniform vec4 vLightFalloff{X};\n#elif defined(HEMILIGHT{X})\nuniform vec3 vLightGround{X};\n#endif\n#ifdef PROJECTEDLIGHTTEXTURE{X}\nuniform mat4 textureProjectionMatrix{X};\nuniform sampler2D projectionLightSampler{X};\n#endif\n#endif";i(8).a.IncludesShadersStore[n]=r},function(e,t,i){"use strict";var n="lightUboDeclaration",r="#ifdef LIGHT{X}\nuniform Light{X}\n{\nvec4 vLightData;\nvec4 vLightDiffuse;\nvec4 vLightSpecular;\n#ifdef SPOTLIGHT{X}\nvec4 vLightDirection;\nvec4 vLightFalloff;\n#elif defined(POINTLIGHT{X})\nvec4 vLightFalloff;\n#elif defined(HEMILIGHT{X})\nvec3 vLightGround;\n#endif\nvec4 shadowsInfo;\nvec2 depthValues;\n} light{X};\n#ifdef PROJECTEDLIGHTTEXTURE{X}\nuniform mat4 textureProjectionMatrix{X};\nuniform sampler2D projectionLightSampler{X};\n#endif\n#ifdef SHADOW{X}\n#ifdef SHADOWCSM{X}\nuniform mat4 lightMatrix{X}[SHADOWCSMNUM_CASCADES{X}];\nuniform float viewFrustumZ{X}[SHADOWCSMNUM_CASCADES{X}];\nuniform float frustumLengths{X}[SHADOWCSMNUM_CASCADES{X}];\nuniform float cascadeBlendFactor{X};\nvarying vec4 vPositionFromLight{X}[SHADOWCSMNUM_CASCADES{X}];\nvarying float vDepthMetric{X}[SHADOWCSMNUM_CASCADES{X}];\nvarying vec4 vPositionFromCamera{X};\n#if defined(SHADOWPCSS{X})\nuniform highp sampler2DArrayShadow shadowSampler{X};\nuniform highp sampler2DArray depthSampler{X};\nuniform vec2 lightSizeUVCorrection{X}[SHADOWCSMNUM_CASCADES{X}];\nuniform float depthCorrection{X}[SHADOWCSMNUM_CASCADES{X}];\nuniform float penumbraDarkness{X};\n#elif defined(SHADOWPCF{X})\nuniform highp sampler2DArrayShadow shadowSampler{X};\n#else\nuniform highp sampler2DArray shadowSampler{X};\n#endif\n#ifdef SHADOWCSMDEBUG{X}\nconst vec3 vCascadeColorsMultiplier{X}[8]=vec3[8]\n(\nvec3 ( 1.5,0.0,0.0 ),\nvec3 ( 0.0,1.5,0.0 ),\nvec3 ( 0.0,0.0,5.5 ),\nvec3 ( 1.5,0.0,5.5 ),\nvec3 ( 1.5,1.5,0.0 ),\nvec3 ( 1.0,1.0,1.0 ),\nvec3 ( 0.0,1.0,5.5 ),\nvec3 ( 0.5,3.5,0.75 )\n);\nvec3 shadowDebug{X};\n#endif\n#ifdef SHADOWCSMUSESHADOWMAXZ{X}\nint index{X}=-1;\n#else\nint index{X}=SHADOWCSMNUM_CASCADES{X}-1;\n#endif\nfloat diff{X}=0.;\n#elif defined(SHADOWCUBE{X})\nuniform samplerCube shadowSampler{X};\n#else\nvarying vec4 vPositionFromLight{X};\nvarying float vDepthMetric{X};\n#if defined(SHADOWPCSS{X})\nuniform highp sampler2DShadow shadowSampler{X};\nuniform highp sampler2D depthSampler{X};\n#elif defined(SHADOWPCF{X})\nuniform highp sampler2DShadow shadowSampler{X};\n#else\nuniform sampler2D shadowSampler{X};\n#endif\nuniform mat4 lightMatrix{X};\n#endif\n#endif\n#endif";i(8).a.IncludesShadersStore[n]=r},function(e,t,i){"use strict";var n="imageProcessingDeclaration",r="#ifdef EXPOSURE\nuniform float exposureLinear;\n#endif\n#ifdef CONTRAST\nuniform float contrast;\n#endif\n#ifdef VIGNETTE\nuniform vec2 vInverseScreenSize;\nuniform vec4 vignetteSettings1;\nuniform vec4 vignetteSettings2;\n#endif\n#ifdef COLORCURVES\nuniform vec4 vCameraColorCurveNegative;\nuniform vec4 vCameraColorCurveNeutral;\nuniform vec4 vCameraColorCurvePositive;\n#endif\n#ifdef COLORGRADING\n#ifdef COLORGRADING3D\nuniform highp sampler3D txColorTransform;\n#else\nuniform sampler2D txColorTransform;\n#endif\nuniform vec4 colorTransformSettings;\n#endif";i(8).a.IncludesShadersStore[n]=r},function(e,t,i){"use strict";var n="imageProcessingFunctions",r="#if defined(COLORGRADING) && !defined(COLORGRADING3D)\n\nvec3 sampleTexture3D(sampler2D colorTransform,vec3 color,vec2 sampler3dSetting)\n{\nfloat sliceSize=2.0*sampler3dSetting.x;\n#ifdef SAMPLER3DGREENDEPTH\nfloat sliceContinuous=(color.g-sampler3dSetting.x)*sampler3dSetting.y;\n#else\nfloat sliceContinuous=(color.b-sampler3dSetting.x)*sampler3dSetting.y;\n#endif\nfloat sliceInteger=floor(sliceContinuous);\n\n\nfloat sliceFraction=sliceContinuous-sliceInteger;\n#ifdef SAMPLER3DGREENDEPTH\nvec2 sliceUV=color.rb;\n#else\nvec2 sliceUV=color.rg;\n#endif\nsliceUV.x*=sliceSize;\nsliceUV.x+=sliceInteger*sliceSize;\nsliceUV=saturate(sliceUV);\nvec4 slice0Color=texture2D(colorTransform,sliceUV);\nsliceUV.x+=sliceSize;\nsliceUV=saturate(sliceUV);\nvec4 slice1Color=texture2D(colorTransform,sliceUV);\nvec3 result=mix(slice0Color.rgb,slice1Color.rgb,sliceFraction);\n#ifdef SAMPLER3DBGRMAP\ncolor.rgb=result.rgb;\n#else\ncolor.rgb=result.bgr;\n#endif\nreturn color;\n}\n#endif\n#ifdef TONEMAPPING_ACES\n\n\n\n\n\nconst mat3 ACESInputMat=mat3(\nvec3(0.59719,0.07600,0.02840),\nvec3(0.35458,0.90834,0.13383),\nvec3(0.04823,0.01566,0.83777)\n);\n\nconst mat3 ACESOutputMat=mat3(\nvec3( 1.60475,-0.10208,-0.00327),\nvec3(-0.53108,1.10813,-0.07276),\nvec3(-0.07367,-0.00605,1.07602)\n);\nvec3 RRTAndODTFit(vec3 v)\n{\nvec3 a=v*(v+0.0245786)-0.000090537;\nvec3 b=v*(0.983729*v+0.4329510)+0.238081;\nreturn a/b;\n}\nvec3 ACESFitted(vec3 color)\n{\ncolor=ACESInputMat*color;\n\ncolor=RRTAndODTFit(color);\ncolor=ACESOutputMat*color;\n\ncolor=saturate(color);\nreturn color;\n}\n#endif\nvec4 applyImageProcessing(vec4 result) {\n#ifdef EXPOSURE\nresult.rgb*=exposureLinear;\n#endif\n#ifdef VIGNETTE\n\nvec2 viewportXY=gl_FragCoord.xy*vInverseScreenSize;\nviewportXY=viewportXY*2.0-1.0;\nvec3 vignetteXY1=vec3(viewportXY*vignetteSettings1.xy+vignetteSettings1.zw,1.0);\nfloat vignetteTerm=dot(vignetteXY1,vignetteXY1);\nfloat vignette=pow(vignetteTerm,vignetteSettings2.w);\n\nvec3 vignetteColor=vignetteSettings2.rgb;\n#ifdef VIGNETTEBLENDMODEMULTIPLY\nvec3 vignetteColorMultiplier=mix(vignetteColor,vec3(1,1,1),vignette);\nresult.rgb*=vignetteColorMultiplier;\n#endif\n#ifdef VIGNETTEBLENDMODEOPAQUE\nresult.rgb=mix(vignetteColor,result.rgb,vignette);\n#endif\n#endif\n#ifdef TONEMAPPING\n#ifdef TONEMAPPING_ACES\nresult.rgb=ACESFitted(result.rgb);\n#else\nconst float tonemappingCalibration=1.590579;\nresult.rgb=1.0-exp2(-tonemappingCalibration*result.rgb);\n#endif\n#endif\n\nresult.rgb=toGammaSpace(result.rgb);\nresult.rgb=saturate(result.rgb);\n#ifdef CONTRAST\n\nvec3 resultHighContrast=result.rgb*result.rgb*(3.0-2.0*result.rgb);\nif (contrast<1.0) {\n\nresult.rgb=mix(vec3(0.5,0.5,0.5),result.rgb,contrast);\n} else {\n\nresult.rgb=mix(result.rgb,resultHighContrast,contrast-1.0);\n}\n#endif\n\n#ifdef COLORGRADING\nvec3 colorTransformInput=result.rgb*colorTransformSettings.xxx+colorTransformSettings.yyy;\n#ifdef COLORGRADING3D\nvec3 colorTransformOutput=texture(txColorTransform,colorTransformInput).rgb;\n#else\nvec3 colorTransformOutput=sampleTexture3D(txColorTransform,colorTransformInput,colorTransformSettings.yz).rgb;\n#endif\nresult.rgb=mix(result.rgb,colorTransformOutput,colorTransformSettings.www);\n#endif\n#ifdef COLORCURVES\n\nfloat luma=getLuminance(result.rgb);\nvec2 curveMix=clamp(vec2(luma*3.0-1.5,luma*-3.0+1.5),vec2(0.0),vec2(1.0));\nvec4 colorCurve=vCameraColorCurveNeutral+curveMix.x*vCameraColorCurvePositive-curveMix.y*vCameraColorCurveNegative;\nresult.rgb*=colorCurve.rgb;\nresult.rgb=mix(vec3(luma),result.rgb,colorCurve.a);\n#endif\nreturn result;\n}";i(8).a.IncludesShadersStore[n]=r},function(e,t,i){"use strict";var n="clipPlaneFragment",r="#ifdef CLIPPLANE\nif (fClipDistance>0.0)\n{\ndiscard;\n}\n#endif\n#ifdef CLIPPLANE2\nif (fClipDistance2>0.0)\n{\ndiscard;\n}\n#endif\n#ifdef CLIPPLANE3\nif (fClipDistance3>0.0)\n{\ndiscard;\n}\n#endif\n#ifdef CLIPPLANE4\nif (fClipDistance4>0.0)\n{\ndiscard;\n}\n#endif\n#ifdef CLIPPLANE5\nif (fClipDistance5>0.0)\n{\ndiscard;\n}\n#endif\n#ifdef CLIPPLANE6\nif (fClipDistance6>0.0)\n{\ndiscard;\n}\n#endif";i(8).a.IncludesShadersStore[n]=r},function(e,t,i){"use strict";var n="clipPlaneVertex",r="#ifdef CLIPPLANE\nfClipDistance=dot(worldPos,vClipPlane);\n#endif\n#ifdef CLIPPLANE2\nfClipDistance2=dot(worldPos,vClipPlane2);\n#endif\n#ifdef CLIPPLANE3\nfClipDistance3=dot(worldPos,vClipPlane3);\n#endif\n#ifdef CLIPPLANE4\nfClipDistance4=dot(worldPos,vClipPlane4);\n#endif\n#ifdef CLIPPLANE5\nfClipDistance5=dot(worldPos,vClipPlane5);\n#endif\n#ifdef CLIPPLANE6\nfClipDistance6=dot(worldPos,vClipPlane6);\n#endif";i(8).a.IncludesShadersStore[n]=r},function(e,t,i){"use strict";i.d(t,"a",function(){return n});var n=function(){function e(){this._count=0,this._data={}}return e.prototype.copyFrom=function(e){var t=this;this.clear(),e.forEach(function(e,i){return t.add(e,i)})},e.prototype.get=function(e){var t=this._data[e];if(void 0!==t)return t},e.prototype.getOrAddWithFactory=function(e,t){var i=this.get(e);return void 0!==i?i:((i=t(e))&&this.add(e,i),i)},e.prototype.getOrAdd=function(e,t){var i=this.get(e);return void 0!==i?i:(this.add(e,t),t)},e.prototype.contains=function(e){return void 0!==this._data[e]},e.prototype.add=function(e,t){return void 0===this._data[e]&&(this._data[e]=t,++this._count,!0)},e.prototype.set=function(e,t){return void 0!==this._data[e]&&(this._data[e]=t,!0)},e.prototype.getAndRemove=function(e){var t=this.get(e);return void 0!==t?(delete this._data[e],--this._count,t):null},e.prototype.remove=function(e){return!!this.contains(e)&&(delete this._data[e],--this._count,!0)},e.prototype.clear=function(){this._data={},this._count=0},Object.defineProperty(e.prototype,"count",{get:function(){return this._count},enumerable:!0,configurable:!0}),e.prototype.forEach=function(e){for(var t in this._data){e(t,this._data[t])}},e.prototype.first=function(e){for(var t in this._data){var i=e(t,this._data[t]);if(i)return i}return null},e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return o});var n=i(42),r=i(0),o=function(){function e(e,t,i){this.center=r.e.Zero(),this.centerWorld=r.e.Zero(),this.minimum=r.e.Zero(),this.maximum=r.e.Zero(),this.reConstruct(e,t,i)}return e.prototype.reConstruct=function(e,t,i){this.minimum.copyFrom(e),this.maximum.copyFrom(t);var n=r.e.Distance(e,t);t.addToRef(e,this.center).scaleInPlace(.5),this.radius=.5*n,this._update(i||r.a.IdentityReadOnly)},e.prototype.scale=function(t){var i=this.radius*t,n=e.TmpVector3,r=n[0].setAll(i),o=this.center.subtractToRef(r,n[1]),a=this.center.addToRef(r,n[2]);return this.reConstruct(o,a,this._worldMatrix),this},e.prototype.getWorldMatrix=function(){return this._worldMatrix},e.prototype._update=function(t){if(t.isIdentity())this.centerWorld.copyFrom(this.center),this.radiusWorld=this.radius;else{r.e.TransformCoordinatesToRef(this.center,t,this.centerWorld);var i=e.TmpVector3[0];r.e.TransformNormalFromFloatsToRef(1,1,1,t,i),this.radiusWorld=Math.max(Math.abs(i.x),Math.abs(i.y),Math.abs(i.z))*this.radius}},e.prototype.isInFrustum=function(e){for(var t=this.centerWorld,i=this.radiusWorld,n=0;n<6;n++)if(e[n].dotCoordinate(t)<=-i)return!1;return!0},e.prototype.isCenterInFrustum=function(e){for(var t=this.centerWorld,i=0;i<6;i++)if(e[i].dotCoordinate(t)<0)return!1;return!0},e.prototype.intersectsPoint=function(e){var t=r.e.DistanceSquared(this.centerWorld,e);return!(this.radiusWorld*this.radiusWorld<t)},e.Intersects=function(e,t){var i=r.e.DistanceSquared(e.centerWorld,t.centerWorld),n=e.radiusWorld+t.radiusWorld;return!(n*n<i)},e.TmpVector3=n.a.BuildArray(3,r.e.Zero),e}()},function(e,t,i){"use strict";i.d(t,"a",function(){return n});var n=function(e,t,i){this.bu=e,this.bv=t,this.distance=i,this.faceId=0,this.subMeshId=0}},function(e,t,i){"use strict";var n="clipPlaneFragmentDeclaration",r="#ifdef CLIPPLANE\nvarying float fClipDistance;\n#endif\n#ifdef CLIPPLANE2\nvarying float fClipDistance2;\n#endif\n#ifdef CLIPPLANE3\nvarying float fClipDistance3;\n#endif\n#ifdef CLIPPLANE4\nvarying float fClipDistance4;\n#endif\n#ifdef CLIPPLANE5\nvarying float fClipDistance5;\n#endif\n#ifdef CLIPPLANE6\nvarying float fClipDistance6;\n#endif";i(8).a.IncludesShadersStore[n]=r},function(e,t,i){"use strict";var n="logDepthDeclaration",r="#ifdef LOGARITHMICDEPTH\nuniform float logarithmicDepthConstant;\nvarying float vFragmentDepth;\n#endif";i(8).a.IncludesShadersStore[n]=r},function(e,t,i){"use strict";var n="clipPlaneVertexDeclaration",r="#ifdef CLIPPLANE\nuniform vec4 vClipPlane;\nvarying float fClipDistance;\n#endif\n#ifdef CLIPPLANE2\nuniform vec4 vClipPlane2;\nvarying float fClipDistance2;\n#endif\n#ifdef CLIPPLANE3\nuniform vec4 vClipPlane3;\nvarying float fClipDistance3;\n#endif\n#ifdef CLIPPLANE4\nuniform vec4 vClipPlane4;\nvarying float fClipDistance4;\n#endif\n#ifdef CLIPPLANE5\nuniform vec4 vClipPlane5;\nvarying float fClipDistance5;\n#endif\n#ifdef CLIPPLANE6\nuniform vec4 vClipPlane6;\nvarying float fClipDistance6;\n#endif";i(8).a.IncludesShadersStore[n]=r},function(e,t,i){"use strict";i.d(t,"a",function(){return n});var n=function(){function e(){}return e.prototype.attributeProcessor=function(e){return e.replace("attribute","in")},e.prototype.varyingProcessor=function(e,t){return e.replace("varying",t?"in":"out")},e.prototype.postProcessor=function(e,t,i){var n=-1!==e.search(/#extension.+GL_EXT_draw_buffers.+require/);if(e=(e=e.replace(/#extension.+(GL_OVR_multiview2|GL_OES_standard_derivatives|GL_EXT_shader_texture_lod|GL_EXT_frag_depth|GL_EXT_draw_buffers).+(enable|require)/g,"")).replace(/texture2D\s*\(/g,"texture("),i)e=(e=(e=(e=(e=(e=(e=e.replace(/texture2DLodEXT\s*\(/g,"textureLod(")).replace(/textureCubeLodEXT\s*\(/g,"textureLod(")).replace(/textureCube\s*\(/g,"texture(")).replace(/gl_FragDepthEXT/g,"gl_FragDepth")).replace(/gl_FragColor/g,"glFragColor")).replace(/gl_FragData/g,"glFragData")).replace(/void\s+?main\s*\(/g,(n?"":"out vec4 glFragColor;\n")+"void main(");else if(-1!==t.indexOf("#define MULTIVIEW"))return"#extension GL_OVR_multiview2 : require\nlayout (num_views = 2) in;\n"+e;return e},e}()},function(e,t,i){"use strict";i.d(t,"b",function(){return r}),i.d(t,"a",function(){return o});var n=i(0);function r(e,t,i,r,o){void 0===o&&(o=null);for(var a=new n.e(Number.MAX_VALUE,Number.MAX_VALUE,Number.MAX_VALUE),s=new n.e(-Number.MAX_VALUE,-Number.MAX_VALUE,-Number.MAX_VALUE),c=i;c<i+r;c++){var l=3*t[c],u=e[l],h=e[l+1],d=e[l+2];a.minimizeInPlaceFromFloats(u,h,d),s.maximizeInPlaceFromFloats(u,h,d)}return o&&(a.x-=a.x*o.x+o.y,a.y-=a.y*o.x+o.y,a.z-=a.z*o.x+o.y,s.x+=s.x*o.x+o.y,s.y+=s.y*o.x+o.y,s.z+=s.z*o.x+o.y),{minimum:a,maximum:s}}function o(e,t,i,r,o){void 0===r&&(r=null);var a=new n.e(Number.MAX_VALUE,Number.MAX_VALUE,Number.MAX_VALUE),s=new n.e(-Number.MAX_VALUE,-Number.MAX_VALUE,-Number.MAX_VALUE);o||(o=3);for(var c=t,l=t*o;c<t+i;c++,l+=o){var u=e[l],h=e[l+1],d=e[l+2];a.minimizeInPlaceFromFloats(u,h,d),s.maximizeInPlaceFromFloats(u,h,d)}return r&&(a.x-=a.x*r.x+r.y,a.y-=a.y*r.x+r.y,a.z-=a.z*r.x+r.y,s.x+=s.x*r.x+r.y,s.y+=s.y*r.x+r.y,s.z+=s.z*r.x+r.y),{minimum:a,maximum:s}}},function(e,t,i){"use strict";i.d(t,"a",function(){return a});var n=i(1),r=i(3),o=i(10),a=function(){function e(){this._dirty=!0,this._tempColor=new o.b(0,0,0,0),this._globalCurve=new o.b(0,0,0,0),this._highlightsCurve=new o.b(0,0,0,0),this._midtonesCurve=new o.b(0,0,0,0),this._shadowsCurve=new o.b(0,0,0,0),this._positiveCurve=new o.b(0,0,0,0),this._negativeCurve=new o.b(0,0,0,0),this._globalHue=30,this._globalDensity=0,this._globalSaturation=0,this._globalExposure=0,this._highlightsHue=30,this._highlightsDensity=0,this._highlightsSaturation=0,this._highlightsExposure=0,this._midtonesHue=30,this._midtonesDensity=0,this._midtonesSaturation=0,this._midtonesExposure=0,this._shadowsHue=30,this._shadowsDensity=0,this._shadowsSaturation=0,this._shadowsExposure=0}return Object.defineProperty(e.prototype,"globalHue",{get:function(){return this._globalHue},set:function(e){this._globalHue=e,this._dirty=!0},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"globalDensity",{get:function(){return this._globalDensity},set:function(e){this._globalDensity=e,this._dirty=!0},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"globalSaturation",{get:function(){return this._globalSaturation},set:function(e){this._globalSaturation=e,this._dirty=!0},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"globalExposure",{get:function(){return this._globalExposure},set:function(e){this._globalExposure=e,this._dirty=!0},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"highlightsHue",{get:function(){return this._highlightsHue},set:function(e){this._highlightsHue=e,this._dirty=!0},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"highlightsDensity",{get:function(){return this._highlightsDensity},set:function(e){this._highlightsDensity=e,this._dirty=!0},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"highlightsSaturation",{get:function(){return this._highlightsSaturation},set:function(e){this._highlightsSaturation=e,this._dirty=!0},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"highlightsExposure",{get:function(){return this._highlightsExposure},set:function(e){this._highlightsExposure=e,this._dirty=!0},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"midtonesHue",{get:function(){return this._midtonesHue},set:function(e){this._midtonesHue=e,this._dirty=!0},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"midtonesDensity",{get:function(){return this._midtonesDensity},set:function(e){this._midtonesDensity=e,this._dirty=!0},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"midtonesSaturation",{get:function(){return this._midtonesSaturation},set:function(e){this._midtonesSaturation=e,this._dirty=!0},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"midtonesExposure",{get:function(){return this._midtonesExposure},set:function(e){this._midtonesExposure=e,this._dirty=!0},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"shadowsHue",{get:function(){return this._shadowsHue},set:function(e){this._shadowsHue=e,this._dirty=!0},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"shadowsDensity",{get:function(){return this._shadowsDensity},set:function(e){this._shadowsDensity=e,this._dirty=!0},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"shadowsSaturation",{get:function(){return this._shadowsSaturation},set:function(e){this._shadowsSaturation=e,this._dirty=!0},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"shadowsExposure",{get:function(){return this._shadowsExposure},set:function(e){this._shadowsExposure=e,this._dirty=!0},enumerable:!0,configurable:!0}),e.prototype.getClassName=function(){return"ColorCurves"},e.Bind=function(e,t,i,n,r){void 0===i&&(i="vCameraColorCurvePositive"),void 0===n&&(n="vCameraColorCurveNeutral"),void 0===r&&(r="vCameraColorCurveNegative"),e._dirty&&(e._dirty=!1,e.getColorGradingDataToRef(e._globalHue,e._globalDensity,e._globalSaturation,e._globalExposure,e._globalCurve),e.getColorGradingDataToRef(e._highlightsHue,e._highlightsDensity,e._highlightsSaturation,e._highlightsExposure,e._tempColor),e._tempColor.multiplyToRef(e._globalCurve,e._highlightsCurve),e.getColorGradingDataToRef(e._midtonesHue,e._midtonesDensity,e._midtonesSaturation,e._midtonesExposure,e._tempColor),e._tempColor.multiplyToRef(e._globalCurve,e._midtonesCurve),e.getColorGradingDataToRef(e._shadowsHue,e._shadowsDensity,e._shadowsSaturation,e._shadowsExposure,e._tempColor),e._tempColor.multiplyToRef(e._globalCurve,e._shadowsCurve),e._highlightsCurve.subtractToRef(e._midtonesCurve,e._positiveCurve),e._midtonesCurve.subtractToRef(e._shadowsCurve,e._negativeCurve)),t&&(t.setFloat4(i,e._positiveCurve.r,e._positiveCurve.g,e._positiveCurve.b,e._positiveCurve.a),t.setFloat4(n,e._midtonesCurve.r,e._midtonesCurve.g,e._midtonesCurve.b,e._midtonesCurve.a),t.setFloat4(r,e._negativeCurve.r,e._negativeCurve.g,e._negativeCurve.b,e._negativeCurve.a))},e.PrepareUniforms=function(e){e.push("vCameraColorCurveNeutral","vCameraColorCurvePositive","vCameraColorCurveNegative")},e.prototype.getColorGradingDataToRef=function(t,i,n,r,o){null!=t&&(t=e.clamp(t,0,360),i=e.clamp(i,-100,100),n=e.clamp(n,-100,100),r=e.clamp(r,-100,100),i=e.applyColorGradingSliderNonlinear(i),i*=.5,r=e.applyColorGradingSliderNonlinear(r),i<0&&(i*=-1,t=(t+180)%360),e.fromHSBToRef(t,i,50+.25*r,o),o.scaleToRef(2,o),o.a=1+.01*n)},e.applyColorGradingSliderNonlinear=function(e){e/=100;var t=Math.abs(e);return t=Math.pow(t,2),e<0&&(t*=-1),t*=100},e.fromHSBToRef=function(t,i,n,r){var o=e.clamp(t,0,360),a=e.clamp(i/100,0,1),s=e.clamp(n/100,0,1);if(0===a)r.r=s,r.g=s,r.b=s;else{o/=60;var c=Math.floor(o),l=o-c,u=s*(1-a),h=s*(1-a*l),d=s*(1-a*(1-l));switch(c){case 0:r.r=s,r.g=d,r.b=u;break;case 1:r.r=h,r.g=s,r.b=u;break;case 2:r.r=u,r.g=s,r.b=d;break;case 3:r.r=u,r.g=h,r.b=s;break;case 4:r.r=d,r.g=u,r.b=s;break;default:r.r=s,r.g=u,r.b=h}}r.a=1},e.clamp=function(e,t,i){return Math.min(Math.max(e,t),i)},e.prototype.clone=function(){return r.a.Clone(function(){return new e},this)},e.prototype.serialize=function(){return r.a.Serialize(this)},e.Parse=function(t){return r.a.Parse(function(){return new e},t,null,null)},Object(n.c)([Object(r.c)()],e.prototype,"_globalHue",void 0),Object(n.c)([Object(r.c)()],e.prototype,"_globalDensity",void 0),Object(n.c)([Object(r.c)()],e.prototype,"_globalSaturation",void 0),Object(n.c)([Object(r.c)()],e.prototype,"_globalExposure",void 0),Object(n.c)([Object(r.c)()],e.prototype,"_highlightsHue",void 0),Object(n.c)([Object(r.c)()],e.prototype,"_highlightsDensity",void 0),Object(n.c)([Object(r.c)()],e.prototype,"_highlightsSaturation",void 0),Object(n.c)([Object(r.c)()],e.prototype,"_highlightsExposure",void 0),Object(n.c)([Object(r.c)()],e.prototype,"_midtonesHue",void 0),Object(n.c)([Object(r.c)()],e.prototype,"_midtonesDensity",void 0),Object(n.c)([Object(r.c)()],e.prototype,"_midtonesSaturation",void 0),Object(n.c)([Object(r.c)()],e.prototype,"_midtonesExposure",void 0),e}();r.a._ColorCurvesParser=a.Parse},function(e,t,i){"use strict";i.d(t,"a",function(){return o});var n=i(7),r=i(12),o=function(){function e(){}return e.Instantiate=function(e){if(this.RegisteredExternalClasses&&this.RegisteredExternalClasses[e])return this.RegisteredExternalClasses[e];var t=r.a.GetClass(e);if(t)return t;n.a.Warn(e+" not found, you may have missed an import.");for(var i=e.split("."),o=window||this,a=0,s=i.length;a<s;a++)o=o[i[a]];return"function"!=typeof o?null:o},e.RegisteredExternalClasses={},e}()},function(e,t,i){"use strict";var n="fogFragmentDeclaration",r="#ifdef FOG\n#define FOGMODE_NONE 0.\n#define FOGMODE_EXP 1.\n#define FOGMODE_EXP2 2.\n#define FOGMODE_LINEAR 3.\n#define E 2.71828\nuniform vec4 vFogInfos;\nuniform vec3 vFogColor;\nvarying vec3 vFogDistance;\nfloat CalcFogFactor()\n{\nfloat fogCoeff=1.0;\nfloat fogStart=vFogInfos.y;\nfloat fogEnd=vFogInfos.z;\nfloat fogDensity=vFogInfos.w;\nfloat fogDistance=length(vFogDistance);\nif (FOGMODE_LINEAR == vFogInfos.x)\n{\nfogCoeff=(fogEnd-fogDistance)/(fogEnd-fogStart);\n}\nelse if (FOGMODE_EXP == vFogInfos.x)\n{\nfogCoeff=1.0/pow(E,fogDistance*fogDensity);\n}\nelse if (FOGMODE_EXP2 == vFogInfos.x)\n{\nfogCoeff=1.0/pow(E,fogDistance*fogDistance*fogDensity*fogDensity);\n}\nreturn clamp(fogCoeff,0.0,1.0);\n}\n#endif";i(8).a.IncludesShadersStore[n]=r},function(e,t,i){"use strict";i.r(t);var n=i(37),r=i(87),o=i(6),a=i(0),s=i(10),c=i(12),l=function(){function e(e,t){this.triggerOptions=e,this.onBeforeExecuteObservable=new o.c,e.parameter?(this.trigger=e.trigger,this._triggerParameter=e.parameter):e.trigger?this.trigger=e.trigger:this.trigger=e,this._nextActiveAction=this,this._condition=t}return e.prototype._prepare=function(){},e.prototype.getTriggerParameter=function(){return this._triggerParameter},e.prototype._executeCurrent=function(e){if(this._nextActiveAction._condition){var t=this._nextActiveAction._condition,i=this._actionManager.getScene().getRenderId();if(t._evaluationId===i){if(!t._currentResult)return}else{if(t._evaluationId=i,!t.isValid())return void(t._currentResult=!1);t._currentResult=!0}}this.onBeforeExecuteObservable.notifyObservers(this),this._nextActiveAction.execute(e),this.skipToNextActiveAction()},e.prototype.execute=function(e){},e.prototype.skipToNextActiveAction=function(){this._nextActiveAction._child?(this._nextActiveAction._child._actionManager||(this._nextActiveAction._child._actionManager=this._actionManager),this._nextActiveAction=this._nextActiveAction._child):this._nextActiveAction=this},e.prototype.then=function(e){return this._child=e,e._actionManager=this._actionManager,e._prepare(),e},e.prototype._getProperty=function(e){return this._actionManager._getProperty(e)},e.prototype._getEffectiveTarget=function(e,t){return this._actionManager._getEffectiveTarget(e,t)},e.prototype.serialize=function(e){},e.prototype._serialize=function(e,t){var i={type:1,children:[],name:e.name,properties:e.properties||[]};if(this._child&&this._child.serialize(i),this._condition){var n=this._condition.serialize();return n.children.push(i),t&&t.children.push(n),n}return t&&t.children.push(i),i},e._SerializeValueAsString=function(e){return"number"==typeof e?e.toString():"boolean"==typeof e?e?"true":"false":e instanceof a.d?e.x+", "+e.y:e instanceof a.e?e.x+", "+e.y+", "+e.z:e instanceof s.a?e.r+", "+e.g+", "+e.b:e instanceof s.b?e.r+", "+e.g+", "+e.b+", "+e.a:e},e._GetTargetProperty=function(e){return{name:"target",targetType:e._isMesh?"MeshProperties":e._isLight?"LightProperties":e._isCamera?"CameraProperties":"SceneProperties",value:e._isScene?"Scene":e.name}},e}();c.a.RegisteredTypes["BABYLON.Action"]=l;var u=i(45),h=i(1),d=function(){function e(e){this._actionManager=e}return e.prototype.isValid=function(){return!0},e.prototype._getProperty=function(e){return this._actionManager._getProperty(e)},e.prototype._getEffectiveTarget=function(e,t){return this._actionManager._getEffectiveTarget(e,t)},e.prototype.serialize=function(){},e.prototype._serialize=function(e){return{type:2,children:[],name:e.name,properties:e.properties}},e}(),f=function(e){function t(i,n,r,o,a){void 0===a&&(a=t.IsEqual);var s=e.call(this,i)||this;return s.propertyPath=r,s.value=o,s.operator=a,s._target=n,s._effectiveTarget=s._getEffectiveTarget(n,s.propertyPath),s._property=s._getProperty(s.propertyPath),s}return Object(h.d)(t,e),Object.defineProperty(t,"IsEqual",{get:function(){return t._IsEqual},enumerable:!0,configurable:!0}),Object.defineProperty(t,"IsDifferent",{get:function(){return t._IsDifferent},enumerable:!0,configurable:!0}),Object.defineProperty(t,"IsGreater",{get:function(){return t._IsGreater},enumerable:!0,configurable:!0}),Object.defineProperty(t,"IsLesser",{get:function(){return t._IsLesser},enumerable:!0,configurable:!0}),t.prototype.isValid=function(){switch(this.operator){case t.IsGreater:return this._effectiveTarget[this._property]>this.value;case t.IsLesser:return this._effectiveTarget[this._property]<this.value;case t.IsEqual:case t.IsDifferent:var e;return e=this.value.equals?this.value.equals(this._effectiveTarget[this._property]):this.value===this._effectiveTarget[this._property],this.operator===t.IsEqual?e:!e}return!1},t.prototype.serialize=function(){return this._serialize({name:"ValueCondition",properties:[l._GetTargetProperty(this._target),{name:"propertyPath",value:this.propertyPath},{name:"value",value:l._SerializeValueAsString(this.value)},{name:"operator",value:t.GetOperatorName(this.operator)}]})},t.GetOperatorName=function(e){switch(e){case t._IsEqual:return"IsEqual";case t._IsDifferent:return"IsDifferent";case t._IsGreater:return"IsGreater";case t._IsLesser:return"IsLesser";default:return""}},t._IsEqual=0,t._IsDifferent=1,t._IsGreater=2,t._IsLesser=3,t}(d),p=function(e){function t(t,i){var n=e.call(this,t)||this;return n.predicate=i,n}return Object(h.d)(t,e),t.prototype.isValid=function(){return this.predicate()},t}(d),_=function(e){function t(t,i,n){var r=e.call(this,t)||this;return r.value=n,r._target=i,r}return Object(h.d)(t,e),t.prototype.isValid=function(){return this._target.state===this.value},t.prototype.serialize=function(){return this._serialize({name:"StateCondition",properties:[l._GetTargetProperty(this._target),{name:"value",value:this.value}]})},t}(d);c.a.RegisteredTypes["BABYLON.ValueCondition"]=f,c.a.RegisteredTypes["BABYLON.PredicateCondition"]=p,c.a.RegisteredTypes["BABYLON.StateCondition"]=_;var m=i(7),g=i(2),v=function(e){function t(t,i,n,r){var o=e.call(this,t,r)||this;return o.propertyPath=n,o._target=o._effectiveTarget=i,o}return Object(h.d)(t,e),t.prototype._prepare=function(){this._effectiveTarget=this._getEffectiveTarget(this._effectiveTarget,this.propertyPath),this._property=this._getProperty(this.propertyPath)},t.prototype.execute=function(){this._effectiveTarget[this._property]=!this._effectiveTarget[this._property]},t.prototype.serialize=function(t){return e.prototype._serialize.call(this,{name:"SwitchBooleanAction",properties:[l._GetTargetProperty(this._target),{name:"propertyPath",value:this.propertyPath}]},t)},t}(l),y=function(e){function t(t,i,n,r){var o=e.call(this,t,r)||this;return o.value=n,o._target=i,o}return Object(h.d)(t,e),t.prototype.execute=function(){this._target.state=this.value},t.prototype.serialize=function(t){return e.prototype._serialize.call(this,{name:"SetStateAction",properties:[l._GetTargetProperty(this._target),{name:"value",value:this.value}]},t)},t}(l),b=function(e){function t(t,i,n,r,o){var a=e.call(this,t,o)||this;return a.propertyPath=n,a.value=r,a._target=a._effectiveTarget=i,a}return Object(h.d)(t,e),t.prototype._prepare=function(){this._effectiveTarget=this._getEffectiveTarget(this._effectiveTarget,this.propertyPath),this._property=this._getProperty(this.propertyPath)},t.prototype.execute=function(){this._effectiveTarget[this._property]=this.value,this._target.markAsDirty&&this._target.markAsDirty(this._property)},t.prototype.serialize=function(t){return e.prototype._serialize.call(this,{name:"SetValueAction",properties:[l._GetTargetProperty(this._target),{name:"propertyPath",value:this.propertyPath},{name:"value",value:l._SerializeValueAsString(this.value)}]},t)},t}(l),T=function(e){function t(t,i,n,r,o){var a=e.call(this,t,o)||this;return a.propertyPath=n,a.value=r,a._target=a._effectiveTarget=i,a}return Object(h.d)(t,e),t.prototype._prepare=function(){this._effectiveTarget=this._getEffectiveTarget(this._effectiveTarget,this.propertyPath),this._property=this._getProperty(this.propertyPath),"number"!=typeof this._effectiveTarget[this._property]&&m.a.Warn("Warning: IncrementValueAction can only be used with number values")},t.prototype.execute=function(){this._effectiveTarget[this._property]+=this.value,this._target.markAsDirty&&this._target.markAsDirty(this._property)},t.prototype.serialize=function(t){return e.prototype._serialize.call(this,{name:"IncrementValueAction",properties:[l._GetTargetProperty(this._target),{name:"propertyPath",value:this.propertyPath},{name:"value",value:l._SerializeValueAsString(this.value)}]},t)},t}(l),E=function(e){function t(t,i,n,r,o,a){var s=e.call(this,t,a)||this;return s.from=n,s.to=r,s.loop=o,s._target=i,s}return Object(h.d)(t,e),t.prototype._prepare=function(){},t.prototype.execute=function(){this._actionManager.getScene().beginAnimation(this._target,this.from,this.to,this.loop)},t.prototype.serialize=function(t){return e.prototype._serialize.call(this,{name:"PlayAnimationAction",properties:[l._GetTargetProperty(this._target),{name:"from",value:String(this.from)},{name:"to",value:String(this.to)},{name:"loop",value:l._SerializeValueAsString(this.loop)||!1}]},t)},t}(l),x=function(e){function t(t,i,n){var r=e.call(this,t,n)||this;return r._target=i,r}return Object(h.d)(t,e),t.prototype._prepare=function(){},t.prototype.execute=function(){this._actionManager.getScene().stopAnimation(this._target)},t.prototype.serialize=function(t){return e.prototype._serialize.call(this,{name:"StopAnimationAction",properties:[l._GetTargetProperty(this._target)]},t)},t}(l),P=function(e){function t(t,i){return void 0===t&&(t=g.a.ACTION_NothingTrigger),e.call(this,t,i)||this}return Object(h.d)(t,e),t.prototype.execute=function(){},t.prototype.serialize=function(t){return e.prototype._serialize.call(this,{name:"DoNothingAction",properties:[]},t)},t}(l),A=function(e){function t(t,i,n){var r=e.call(this,t,n)||this;return r.children=i,r}return Object(h.d)(t,e),t.prototype._prepare=function(){for(var e=0;e<this.children.length;e++)this.children[e]._actionManager=this._actionManager,this.children[e]._prepare()},t.prototype.execute=function(e){for(var t=0;t<this.children.length;t++)this.children[t].execute(e)},t.prototype.serialize=function(t){for(var i=e.prototype._serialize.call(this,{name:"CombineAction",properties:[],combine:[]},t),n=0;n<this.children.length;n++)i.combine.push(this.children[n].serialize(null));return i},t}(l),S=function(e){function t(t,i,n){var r=e.call(this,t,n)||this;return r.func=i,r}return Object(h.d)(t,e),t.prototype.execute=function(e){this.func(e)},t}(l),C=function(e){function t(t,i,n,r){var o=e.call(this,t,r)||this;return o._target=i,o._parent=n,o}return Object(h.d)(t,e),t.prototype._prepare=function(){},t.prototype.execute=function(){if(this._target.parent!==this._parent){var e=this._parent.getWorldMatrix().clone();e.invert(),this._target.position=a.e.TransformCoordinates(this._target.position,e),this._target.parent=this._parent}},t.prototype.serialize=function(t){return e.prototype._serialize.call(this,{name:"SetParentAction",properties:[l._GetTargetProperty(this._target),l._GetTargetProperty(this._parent)]},t)},t}(l);c.a.RegisteredTypes["BABYLON.SetParentAction"]=C,c.a.RegisteredTypes["BABYLON.ExecuteCodeAction"]=S,c.a.RegisteredTypes["BABYLON.DoNothingAction"]=P,c.a.RegisteredTypes["BABYLON.StopAnimationAction"]=x,c.a.RegisteredTypes["BABYLON.PlayAnimationAction"]=E,c.a.RegisteredTypes["BABYLON.IncrementValueAction"]=T,c.a.RegisteredTypes["BABYLON.SetValueAction"]=b,c.a.RegisteredTypes["BABYLON.SetStateAction"]=y,c.a.RegisteredTypes["BABYLON.SetParentAction"]=C;var R=i(23),O=i(33),M=function(e){function t(t){var i=e.call(this)||this;return i._scene=t||R.a.LastCreatedScene,t.actionManagers.push(i),i}return Object(h.d)(t,e),t.prototype.dispose=function(){for(var e=this._scene.actionManagers.indexOf(this),i=0;i<this.actions.length;i++){var n=this.actions[i];t.Triggers[n.trigger]--,0===t.Triggers[n.trigger]&&delete t.Triggers[n.trigger]}e>-1&&this._scene.actionManagers.splice(e,1)},t.prototype.getScene=function(){return this._scene},t.prototype.hasSpecificTriggers=function(e){for(var t=0;t<this.actions.length;t++){var i=this.actions[t];if(e.indexOf(i.trigger)>-1)return!0}return!1},t.prototype.hasSpecificTriggers2=function(e,t){for(var i=0;i<this.actions.length;i++){var n=this.actions[i];if(e==n.trigger||t==n.trigger)return!0}return!1},t.prototype.hasSpecificTrigger=function(e,t){for(var i=0;i<this.actions.length;i++){var n=this.actions[i];if(n.trigger===e){if(!t)return!0;if(t(n.getTriggerParameter()))return!0}}return!1},Object.defineProperty(t.prototype,"hasPointerTriggers",{get:function(){for(var e=0;e<this.actions.length;e++){var i=this.actions[e];if(i.trigger>=t.OnPickTrigger&&i.trigger<=t.OnPointerOutTrigger)return!0}return!1},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"hasPickTriggers",{get:function(){for(var e=0;e<this.actions.length;e++){var i=this.actions[e];if(i.trigger>=t.OnPickTrigger&&i.trigger<=t.OnPickUpTrigger)return!0}return!1},enumerable:!0,configurable:!0}),t.prototype.registerAction=function(e){return e.trigger===t.OnEveryFrameTrigger&&this.getScene().actionManager!==this?(m.a.Warn("OnEveryFrameTrigger can only be used with scene.actionManager"),null):(this.actions.push(e),t.Triggers[e.trigger]?t.Triggers[e.trigger]++:t.Triggers[e.trigger]=1,e._actionManager=this,e._prepare(),e)},t.prototype.unregisterAction=function(e){var i=this.actions.indexOf(e);return-1!==i&&(this.actions.splice(i,1),t.Triggers[e.trigger]-=1,0===t.Triggers[e.trigger]&&delete t.Triggers[e.trigger],delete e._actionManager,!0)},t.prototype.processTrigger=function(e,i){for(var n=0;n<this.actions.length;n++){var r=this.actions[n];if(r.trigger===e){if(i&&(e===t.OnKeyUpTrigger||e===t.OnKeyDownTrigger)){var o=r.getTriggerParameter();if(o&&o!==i.sourceEvent.keyCode){if(!o.toLowerCase)continue;var a=o.toLowerCase();if(a!==i.sourceEvent.key){var s=i.sourceEvent.charCode?i.sourceEvent.charCode:i.sourceEvent.keyCode;if(String.fromCharCode(s).toLowerCase()!==a)continue}}}r._executeCurrent(i)}}},t.prototype._getEffectiveTarget=function(e,t){for(var i=t.split("."),n=0;n<i.length-1;n++)e=e[i[n]];return e},t.prototype._getProperty=function(e){var t=e.split(".");return t[t.length-1]},t.prototype.serialize=function(e){for(var i={children:new Array,name:e,type:3,properties:new Array},n=0;n<this.actions.length;n++){var r={type:0,children:new Array,name:t.GetTriggerName(this.actions[n].trigger),properties:new Array},o=this.actions[n].triggerOptions;if(o&&"number"!=typeof o)if(o.parameter instanceof Node)r.properties.push(l._GetTargetProperty(o.parameter));else{var a={};O.a.DeepCopy(o.parameter,a,["mesh"]),o.parameter&&o.parameter.mesh&&(a._meshId=o.parameter.mesh.id),r.properties.push({name:"parameter",targetType:null,value:a})}this.actions[n].serialize(r),i.children.push(r)}return i},t.Parse=function(e,i,n){var r=new t(n);null===i?n.actionManager=r:i.actionManager=r;for(var o=function(e,t,i,n){if(null===n){var r=parseFloat(t);return"true"===t||"false"===t?"true"===t:isNaN(r)?t:r}for(var o=n.split("."),c=t.split(","),l=0;l<o.length;l++)i=i[o[l]];if("boolean"==typeof i)return"true"===c[0];if("string"==typeof i)return c[0];var u=new Array;for(l=0;l<c.length;l++)u.push(parseFloat(c[l]));return i instanceof a.e?a.e.FromArray(u):i instanceof a.f?a.f.FromArray(u):i instanceof s.a?s.a.FromArray(u):i instanceof s.b?s.b.FromArray(u):parseFloat(c[0])},l=function(e,i,a,s,u){if(void 0===u&&(u=null),!e.detached){var h=new Array,p=null,_=null,m=e.combine&&e.combine.length>0;if(2===e.type?h.push(r):h.push(i),m){for(var g=new Array,v=0;v<e.combine.length;v++)l(e.combine[v],t.NothingTrigger,a,s,g);h.push(g)}else for(var y=0;y<e.properties.length;y++){var b=e.properties[y].value,T=e.properties[y].name,E=e.properties[y].targetType;"target"===T?b=p=null!==E&&"SceneProperties"===E?n:n.getNodeByName(b):"parent"===T?b=n.getNodeByName(b):"sound"===T?n.getSoundByName&&(b=n.getSoundByName(b)):"propertyPath"!==T?b=2===e.type&&"operator"===T?f[b]:o(0,b,p,"value"===T?_:null):_=b,h.push(b)}if(null===u?h.push(a):h.push(null),"InterpolateValueAction"===e.name){var x=h[h.length-2];h[h.length-1]=x,h[h.length-2]=a}var A=function(e,t){var i=c.a.GetClass("BABYLON."+e);if(i){var n=Object.create(i.prototype);return n.constructor.apply(n,t),n}}(e.name,h);if(A instanceof d&&null!==a){var S=new P(i,a);s?s.then(S):r.registerAction(S),s=S}null===u?A instanceof d?(a=A,A=s):(a=null,s?s.then(A):r.registerAction(A)):u.push(A);for(y=0;y<e.children.length;y++)l(e.children[y],i,a,A,null)}},u=0;u<e.children.length;u++){var h,p=e.children[u];if(p.properties.length>0){var _=p.properties[0].value,m=null===p.properties[0].targetType?_:n.getMeshByName(_);m._meshId&&(m.mesh=n.getMeshByID(m._meshId)),h={trigger:t[p.name],parameter:m}}else h=t[p.name];for(var g=0;g<p.children.length;g++)p.detached||l(p.children[g],h,null,null)}},t.GetTriggerName=function(e){switch(e){case 0:return"NothingTrigger";case 1:return"OnPickTrigger";case 2:return"OnLeftPickTrigger";case 3:return"OnRightPickTrigger";case 4:return"OnCenterPickTrigger";case 5:return"OnPickDownTrigger";case 6:return"OnPickUpTrigger";case 7:return"OnLongPressTrigger";case 8:return"OnPointerOverTrigger";case 9:return"OnPointerOutTrigger";case 10:return"OnEveryFrameTrigger";case 11:return"OnIntersectionEnterTrigger";case 12:return"OnIntersectionExitTrigger";case 13:return"OnKeyDownTrigger";case 14:return"OnKeyUpTrigger";case 15:return"OnPickOutTrigger";default:return""}},t.NothingTrigger=g.a.ACTION_NothingTrigger,t.OnPickTrigger=g.a.ACTION_OnPickTrigger,t.OnLeftPickTrigger=g.a.ACTION_OnLeftPickTrigger,t.OnRightPickTrigger=g.a.ACTION_OnRightPickTrigger,t.OnCenterPickTrigger=g.a.ACTION_OnCenterPickTrigger,t.OnPickDownTrigger=g.a.ACTION_OnPickDownTrigger,t.OnDoublePickTrigger=g.a.ACTION_OnDoublePickTrigger,t.OnPickUpTrigger=g.a.ACTION_OnPickUpTrigger,t.OnPickOutTrigger=g.a.ACTION_OnPickOutTrigger,t.OnLongPressTrigger=g.a.ACTION_OnLongPressTrigger,t.OnPointerOverTrigger=g.a.ACTION_OnPointerOverTrigger,t.OnPointerOutTrigger=g.a.ACTION_OnPointerOutTrigger,t.OnEveryFrameTrigger=g.a.ACTION_OnEveryFrameTrigger,t.OnIntersectionEnterTrigger=g.a.ACTION_OnIntersectionEnterTrigger,t.OnIntersectionExitTrigger=g.a.ACTION_OnIntersectionExitTrigger,t.OnKeyDownTrigger=g.a.ACTION_OnKeyDownTrigger,t.OnKeyUpTrigger=15,t}(r.a),I=function(e){function t(t,i,n){var r=e.call(this,t,n)||this;return r._sound=i,r}return Object(h.d)(t,e),t.prototype._prepare=function(){},t.prototype.execute=function(){void 0!==this._sound&&this._sound.play()},t.prototype.serialize=function(t){return e.prototype._serialize.call(this,{name:"PlaySoundAction",properties:[{name:"sound",value:this._sound.name}]},t)},t}(l),D=function(e){function t(t,i,n){var r=e.call(this,t,n)||this;return r._sound=i,r}return Object(h.d)(t,e),t.prototype._prepare=function(){},t.prototype.execute=function(){void 0!==this._sound&&this._sound.stop()},t.prototype.serialize=function(t){return e.prototype._serialize.call(this,{name:"StopSoundAction",properties:[{name:"sound",value:this._sound.name}]},t)},t}(l);c.a.RegisteredTypes["BABYLON.PlaySoundAction"]=D,c.a.RegisteredTypes["BABYLON.StopSoundAction"]=D;var w,L=i(14),N=i(3);!function(e){e[e.STEP=1]="STEP"}(w||(w={}));var F=function(){function e(e,t,i){this.name=e,this.from=t,this.to=i}return e.prototype.clone=function(){return new e(this.name,this.from,this.to)},e}(),B=i(26),U=i(68),V=function(){},k=function(){function e(t,i,n,r,o,a){this.name=t,this.targetProperty=i,this.framePerSecond=n,this.dataType=r,this.loopMode=o,this.enableBlending=a,this._runtimeAnimations=new Array,this._events=new Array,this.blendingSpeed=.01,this._ranges={},this.targetPropertyPath=i.split("."),this.dataType=r,this.loopMode=void 0===o?e.ANIMATIONLOOPMODE_CYCLE:o}return e._PrepareAnimation=function(t,i,n,r,o,c,l,u){var h=void 0;if(!isNaN(parseFloat(o))&&isFinite(o)?h=e.ANIMATIONTYPE_FLOAT:o instanceof a.b?h=e.ANIMATIONTYPE_QUATERNION:o instanceof a.e?h=e.ANIMATIONTYPE_VECTOR3:o instanceof a.d?h=e.ANIMATIONTYPE_VECTOR2:o instanceof s.a?h=e.ANIMATIONTYPE_COLOR3:o instanceof s.b?h=e.ANIMATIONTYPE_COLOR4:o instanceof U.a&&(h=e.ANIMATIONTYPE_SIZE),null==h)return null;var d=new e(t,i,n,h,l),f=[{frame:0,value:o},{frame:r,value:c}];return d.setKeys(f),void 0!==u&&d.setEasingFunction(u),d},e.CreateAnimation=function(t,i,n,r){var o=new e(t+"Animation",t,n,i,e.ANIMATIONLOOPMODE_CONSTANT);return o.setEasingFunction(r),o},e.CreateAndStartAnimation=function(t,i,n,r,o,a,s,c,l,u){var h=e._PrepareAnimation(t,n,r,o,a,s,c,l);return h?i.getScene().beginDirectAnimation(i,[h],0,o,1===h.loopMode,1,u):null},e.CreateAndStartHierarchyAnimation=function(t,i,n,r,o,a,s,c,l,u,h){var d=e._PrepareAnimation(t,r,o,a,s,c,l,u);return d?i.getScene().beginDirectHierarchyAnimation(i,n,[d],0,a,1===d.loopMode,1,h):null},e.CreateMergeAndStartAnimation=function(t,i,n,r,o,a,s,c,l,u){var h=e._PrepareAnimation(t,n,r,o,a,s,c,l);return h?(i.animations.push(h),i.getScene().beginAnimation(i,0,o,1===h.loopMode,1,u)):null},e.TransitionTo=function(e,t,i,n,r,o,a,s){if(void 0===s&&(s=null),a<=0)return i[e]=t,s&&s(),null;var c=r*(a/1e3);o.setKeys([{frame:0,value:i[e].clone?i[e].clone():i[e]},{frame:c,value:t}]),i.animations||(i.animations=[]),i.animations.push(o);var l=n.beginAnimation(i,0,c,!1);return l.onAnimationEnd=s,l},Object.defineProperty(e.prototype,"runtimeAnimations",{get:function(){return this._runtimeAnimations},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"hasRunningRuntimeAnimations",{get:function(){for(var e=0,t=this._runtimeAnimations;e<t.length;e++){if(!t[e].isStopped)return!0}return!1},enumerable:!0,configurable:!0}),e.prototype.toString=function(e){var t="Name: "+this.name+", property: "+this.targetProperty;if(t+=", datatype: "+["Float","Vector3","Quaternion","Matrix","Color3","Vector2"][this.dataType],t+=", nKeys: "+(this._keys?this._keys.length:"none"),t+=", nRanges: "+(this._ranges?Object.keys(this._ranges).length:"none"),e){t+=", Ranges: {";var i=!0;for(var n in this._ranges)i&&(t+=", ",i=!1),t+=n;t+="}"}return t},e.prototype.addEvent=function(e){this._events.push(e)},e.prototype.removeEvents=function(e){for(var t=0;t<this._events.length;t++)this._events[t].frame===e&&(this._events.splice(t,1),t--)},e.prototype.getEvents=function(){return this._events},e.prototype.createRange=function(e,t,i){this._ranges[e]||(this._ranges[e]=new F(e,t,i))},e.prototype.deleteRange=function(e,t){void 0===t&&(t=!0);var i=this._ranges[e];if(i){if(t)for(var n=i.from,r=i.to,o=this._keys.length-1;o>=0;o--)this._keys[o].frame>=n&&this._keys[o].frame<=r&&this._keys.splice(o,1);this._ranges[e]=null}},e.prototype.getRange=function(e){return this._ranges[e]},e.prototype.getKeys=function(){return this._keys},e.prototype.getHighestFrame=function(){for(var e=0,t=0,i=this._keys.length;t<i;t++)e<this._keys[t].frame&&(e=this._keys[t].frame);return e},e.prototype.getEasingFunction=function(){return this._easingFunction},e.prototype.setEasingFunction=function(e){this._easingFunction=e},e.prototype.floatInterpolateFunction=function(e,t,i){return L.a.Lerp(e,t,i)},e.prototype.floatInterpolateFunctionWithTangents=function(e,t,i,n,r){return L.a.Hermite(e,t,i,n,r)},e.prototype.quaternionInterpolateFunction=function(e,t,i){return a.b.Slerp(e,t,i)},e.prototype.quaternionInterpolateFunctionWithTangents=function(e,t,i,n,r){return a.b.Hermite(e,t,i,n,r).normalize()},e.prototype.vector3InterpolateFunction=function(e,t,i){return a.e.Lerp(e,t,i)},e.prototype.vector3InterpolateFunctionWithTangents=function(e,t,i,n,r){return a.e.Hermite(e,t,i,n,r)},e.prototype.vector2InterpolateFunction=function(e,t,i){return a.d.Lerp(e,t,i)},e.prototype.vector2InterpolateFunctionWithTangents=function(e,t,i,n,r){return a.d.Hermite(e,t,i,n,r)},e.prototype.sizeInterpolateFunction=function(e,t,i){return U.a.Lerp(e,t,i)},e.prototype.color3InterpolateFunction=function(e,t,i){return s.a.Lerp(e,t,i)},e.prototype.color4InterpolateFunction=function(e,t,i){return s.b.Lerp(e,t,i)},e.prototype._getKeyValue=function(e){return"function"==typeof e?e():e},e.prototype._interpolate=function(t,i){if(i.loopMode===e.ANIMATIONLOOPMODE_CONSTANT&&i.repeatCount>0)return i.highLimitValue.clone?i.highLimitValue.clone():i.highLimitValue;var n=this._keys;if(1===n.length)return this._getKeyValue(n[0].value);var r=i.key;if(n[r].frame>=t)for(;r-1>=0&&n[r].frame>=t;)r--;for(var o=r;o<n.length;o++){var a=n[o+1];if(a.frame>=t){i.key=o;var s=n[o],c=this._getKeyValue(s.value);if(s.interpolation===w.STEP)return c;var l=this._getKeyValue(a.value),u=void 0!==s.outTangent&&void 0!==a.inTangent,h=a.frame-s.frame,d=(t-s.frame)/h,f=this.getEasingFunction();switch(null!=f&&(d=f.ease(d)),this.dataType){case e.ANIMATIONTYPE_FLOAT:var p=u?this.floatInterpolateFunctionWithTangents(c,s.outTangent*h,l,a.inTangent*h,d):this.floatInterpolateFunction(c,l,d);switch(i.loopMode){case e.ANIMATIONLOOPMODE_CYCLE:case e.ANIMATIONLOOPMODE_CONSTANT:return p;case e.ANIMATIONLOOPMODE_RELATIVE:return i.offsetValue*i.repeatCount+p}break;case e.ANIMATIONTYPE_QUATERNION:var _=u?this.quaternionInterpolateFunctionWithTangents(c,s.outTangent.scale(h),l,a.inTangent.scale(h),d):this.quaternionInterpolateFunction(c,l,d);switch(i.loopMode){case e.ANIMATIONLOOPMODE_CYCLE:case e.ANIMATIONLOOPMODE_CONSTANT:return _;case e.ANIMATIONLOOPMODE_RELATIVE:return _.addInPlace(i.offsetValue.scale(i.repeatCount))}return _;case e.ANIMATIONTYPE_VECTOR3:var m=u?this.vector3InterpolateFunctionWithTangents(c,s.outTangent.scale(h),l,a.inTangent.scale(h),d):this.vector3InterpolateFunction(c,l,d);switch(i.loopMode){case e.ANIMATIONLOOPMODE_CYCLE:case e.ANIMATIONLOOPMODE_CONSTANT:return m;case e.ANIMATIONLOOPMODE_RELATIVE:return m.add(i.offsetValue.scale(i.repeatCount))}case e.ANIMATIONTYPE_VECTOR2:var g=u?this.vector2InterpolateFunctionWithTangents(c,s.outTangent.scale(h),l,a.inTangent.scale(h),d):this.vector2InterpolateFunction(c,l,d);switch(i.loopMode){case e.ANIMATIONLOOPMODE_CYCLE:case e.ANIMATIONLOOPMODE_CONSTANT:return g;case e.ANIMATIONLOOPMODE_RELATIVE:return g.add(i.offsetValue.scale(i.repeatCount))}case e.ANIMATIONTYPE_SIZE:switch(i.loopMode){case e.ANIMATIONLOOPMODE_CYCLE:case e.ANIMATIONLOOPMODE_CONSTANT:return this.sizeInterpolateFunction(c,l,d);case e.ANIMATIONLOOPMODE_RELATIVE:return this.sizeInterpolateFunction(c,l,d).add(i.offsetValue.scale(i.repeatCount))}case e.ANIMATIONTYPE_COLOR3:switch(i.loopMode){case e.ANIMATIONLOOPMODE_CYCLE:case e.ANIMATIONLOOPMODE_CONSTANT:return this.color3InterpolateFunction(c,l,d);case e.ANIMATIONLOOPMODE_RELATIVE:return this.color3InterpolateFunction(c,l,d).add(i.offsetValue.scale(i.repeatCount))}case e.ANIMATIONTYPE_COLOR4:switch(i.loopMode){case e.ANIMATIONLOOPMODE_CYCLE:case e.ANIMATIONLOOPMODE_CONSTANT:return this.color4InterpolateFunction(c,l,d);case e.ANIMATIONLOOPMODE_RELATIVE:return this.color4InterpolateFunction(c,l,d).add(i.offsetValue.scale(i.repeatCount))}case e.ANIMATIONTYPE_MATRIX:switch(i.loopMode){case e.ANIMATIONLOOPMODE_CYCLE:case e.ANIMATIONLOOPMODE_CONSTANT:if(e.AllowMatricesInterpolation)return this.matrixInterpolateFunction(c,l,d,i.workValue);case e.ANIMATIONLOOPMODE_RELATIVE:return c}}break}}return this._getKeyValue(n[n.length-1].value)},e.prototype.matrixInterpolateFunction=function(t,i,n,r){return e.AllowMatrixDecomposeForInterpolation?r?(a.a.DecomposeLerpToRef(t,i,n,r),r):a.a.DecomposeLerp(t,i,n):r?(a.a.LerpToRef(t,i,n,r),r):a.a.Lerp(t,i,n)},e.prototype.clone=function(){var t=new e(this.name,this.targetPropertyPath.join("."),this.framePerSecond,this.dataType,this.loopMode);if(t.enableBlending=this.enableBlending,t.blendingSpeed=this.blendingSpeed,this._keys&&t.setKeys(this._keys),this._ranges)for(var i in t._ranges={},this._ranges){var n=this._ranges[i];n&&(t._ranges[i]=n.clone())}return t},e.prototype.setKeys=function(e){this._keys=e.slice(0)},e.prototype.serialize=function(){var t={};t.name=this.name,t.property=this.targetProperty,t.framePerSecond=this.framePerSecond,t.dataType=this.dataType,t.loopBehavior=this.loopMode,t.enableBlending=this.enableBlending,t.blendingSpeed=this.blendingSpeed;var i=this.dataType;t.keys=[];for(var n=this.getKeys(),r=0;r<n.length;r++){var o=n[r],a={};switch(a.frame=o.frame,i){case e.ANIMATIONTYPE_FLOAT:a.values=[o.value];break;case e.ANIMATIONTYPE_QUATERNION:case e.ANIMATIONTYPE_MATRIX:case e.ANIMATIONTYPE_VECTOR3:case e.ANIMATIONTYPE_COLOR3:case e.ANIMATIONTYPE_COLOR4:a.values=o.value.asArray()}t.keys.push(a)}for(var s in t.ranges=[],this._ranges){var c=this._ranges[s];if(c){var l={};l.name=s,l.from=c.from,l.to=c.to,t.ranges.push(l)}}return t},e._UniversalLerp=function(e,t,i){var n=e.constructor;return n.Lerp?n.Lerp(e,t,i):n.Slerp?n.Slerp(e,t,i):e.toFixed?e*(1-i)+i*t:t},e.Parse=function(t){var i,n,r=new e(t.name,t.property,t.framePerSecond,t.dataType,t.loopBehavior),o=t.dataType,c=[];for(t.enableBlending&&(r.enableBlending=t.enableBlending),t.blendingSpeed&&(r.blendingSpeed=t.blendingSpeed),n=0;n<t.keys.length;n++){var l,u,h=t.keys[n];switch(o){case e.ANIMATIONTYPE_FLOAT:i=h.values[0],h.values.length>=1&&(l=h.values[1]),h.values.length>=2&&(u=h.values[2]);break;case e.ANIMATIONTYPE_QUATERNION:if(i=a.b.FromArray(h.values),h.values.length>=8){var d=a.b.FromArray(h.values.slice(4,8));d.equals(a.b.Zero())||(l=d)}if(h.values.length>=12){var f=a.b.FromArray(h.values.slice(8,12));f.equals(a.b.Zero())||(u=f)}break;case e.ANIMATIONTYPE_MATRIX:i=a.a.FromArray(h.values);break;case e.ANIMATIONTYPE_COLOR3:i=s.a.FromArray(h.values);break;case e.ANIMATIONTYPE_COLOR4:i=s.b.FromArray(h.values);break;case e.ANIMATIONTYPE_VECTOR3:default:i=a.e.FromArray(h.values)}var p={};p.frame=h.frame,p.value=i,null!=l&&(p.inTangent=l),null!=u&&(p.outTangent=u),c.push(p)}if(r.setKeys(c),t.ranges)for(n=0;n<t.ranges.length;n++)i=t.ranges[n],r.createRange(i.name,i.from,i.to);return r},e.AppendSerializedAnimations=function(e,t){N.a.AppendSerializedAnimations(e,t)},e.AllowMatricesInterpolation=!1,e.AllowMatrixDecomposeForInterpolation=!0,e.ANIMATIONTYPE_FLOAT=0,e.ANIMATIONTYPE_VECTOR3=1,e.ANIMATIONTYPE_QUATERNION=2,e.ANIMATIONTYPE_MATRIX=3,e.ANIMATIONTYPE_COLOR3=4,e.ANIMATIONTYPE_COLOR4=7,e.ANIMATIONTYPE_VECTOR2=5,e.ANIMATIONTYPE_SIZE=6,e.ANIMATIONLOOPMODE_RELATIVE=0,e.ANIMATIONLOOPMODE_CYCLE=1,e.ANIMATIONLOOPMODE_CONSTANT=2,e}();c.a.RegisteredTypes["BABYLON.Animation"]=k,B.a._AnimationRangeFactory=function(e,t,i){return new F(e,t,i)};var z=function(e){function t(t,i,n,r,a,s,c,l){void 0===a&&(a=1e3);var u=e.call(this,t,s)||this;return u.duration=1e3,u.onInterpolationDoneObservable=new o.c,u.propertyPath=n,u.value=r,u.duration=a,u.stopOtherAnimations=c,u.onInterpolationDone=l,u._target=u._effectiveTarget=i,u}return Object(h.d)(t,e),t.prototype._prepare=function(){this._effectiveTarget=this._getEffectiveTarget(this._effectiveTarget,this.propertyPath),this._property=this._getProperty(this.propertyPath)},t.prototype.execute=function(){var e,t=this,i=this._actionManager.getScene(),n=[{frame:0,value:this._effectiveTarget[this._property]},{frame:100,value:this.value}];if("number"==typeof this.value)e=k.ANIMATIONTYPE_FLOAT;else if(this.value instanceof s.a)e=k.ANIMATIONTYPE_COLOR3;else if(this.value instanceof a.e)e=k.ANIMATIONTYPE_VECTOR3;else if(this.value instanceof a.a)e=k.ANIMATIONTYPE_MATRIX;else{if(!(this.value instanceof a.b))return void m.a.Warn("InterpolateValueAction: Unsupported type ("+typeof this.value+")");e=k.ANIMATIONTYPE_QUATERNION}var r=new k("InterpolateValueAction",this._property,1e3/this.duration*100,e,k.ANIMATIONLOOPMODE_CONSTANT);r.setKeys(n),this.stopOtherAnimations&&i.stopAnimation(this._effectiveTarget);i.beginDirectAnimation(this._effectiveTarget,[r],0,100,!1,1,function(){t.onInterpolationDoneObservable.notifyObservers(t),t.onInterpolationDone&&t.onInterpolationDone()})},t.prototype.serialize=function(t){return e.prototype._serialize.call(this,{name:"InterpolateValueAction",properties:[l._GetTargetProperty(this._target),{name:"propertyPath",value:this.propertyPath},{name:"value",value:l._SerializeValueAsString(this.value)},{name:"duration",value:l._SerializeValueAsString(this.duration)},{name:"stopOtherAnimations",value:l._SerializeValueAsString(this.stopOtherAnimations)||!1}]},t)},t}(l);c.a.RegisteredTypes["BABYLON.InterpolateValueAction"]=z;var G=Object.freeze(new a.b(0,0,0,0)),j=Object.freeze(a.e.Zero()),W=Object.freeze(a.d.Zero()),X=Object.freeze(U.a.Zero()),H=Object.freeze(s.a.Black()),Y=function(){function e(e,t,i,n){var r=this;if(this._events=new Array,this._currentFrame=0,this._originalValue=new Array,this._originalBlendValue=null,this._offsetsCache={},this._highLimitsCache={},this._stopped=!1,this._blendingFactor=0,this._currentValue=null,this._currentActiveTarget=null,this._directTarget=null,this._targetPath="",this._weight=1,this._ratioOffset=0,this._previousDelay=0,this._previousRatio=0,this._targetIsArray=!1,this._animation=t,this._target=e,this._scene=i,this._host=n,this._activeTargets=[],t._runtimeAnimations.push(this),this._animationState={key:0,repeatCount:0,loopMode:this._getCorrectLoopMode()},this._animation.dataType===k.ANIMATIONTYPE_MATRIX&&(this._animationState.workValue=a.a.Zero()),this._keys=this._animation.getKeys(),this._minFrame=this._keys[0].frame,this._maxFrame=this._keys[this._keys.length-1].frame,this._minValue=this._keys[0].value,this._maxValue=this._keys[this._keys.length-1].value,0!==this._minFrame){var o={frame:0,value:this._minValue};this._keys.splice(0,0,o)}if(this._target instanceof Array){for(var s=0,c=0,l=this._target;c<l.length;c++){var u=l[c];this._preparePath(u,s),this._getOriginalValues(s),s++}this._targetIsArray=!0}else this._preparePath(this._target),this._getOriginalValues(),this._targetIsArray=!1,this._directTarget=this._activeTargets[0];var h=t.getEvents();h&&h.length>0&&h.forEach(function(e){r._events.push(e._clone())}),this._enableBlending=e&&e.animationPropertiesOverride?e.animationPropertiesOverride.enableBlending:this._animation.enableBlending}return Object.defineProperty(e.prototype,"currentFrame",{get:function(){return this._currentFrame},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"weight",{get:function(){return this._weight},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"currentValue",{get:function(){return this._currentValue},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"targetPath",{get:function(){return this._targetPath},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"target",{get:function(){return this._currentActiveTarget},enumerable:!0,configurable:!0}),e.prototype._preparePath=function(e,t){void 0===t&&(t=0);var i=this._animation.targetPropertyPath;if(i.length>1){for(var n=e[i[0]],r=1;r<i.length-1;r++)n=n[i[r]];this._targetPath=i[i.length-1],this._activeTargets[t]=n}else this._targetPath=i[0],this._activeTargets[t]=e},Object.defineProperty(e.prototype,"animation",{get:function(){return this._animation},enumerable:!0,configurable:!0}),e.prototype.reset=function(e){if(void 0===e&&(e=!1),e)if(this._target instanceof Array)for(var t=0,i=0,n=this._target;i<n.length;i++){var r=n[i];void 0!==this._originalValue[t]&&this._setValue(r,this._activeTargets[t],this._originalValue[t],-1,t),t++}else void 0!==this._originalValue[0]&&this._setValue(this._target,this._directTarget,this._originalValue[0],-1,0);this._offsetsCache={},this._highLimitsCache={},this._currentFrame=0,this._blendingFactor=0;for(t=0;t<this._events.length;t++)this._events[t].isDone=!1},e.prototype.isStopped=function(){return this._stopped},e.prototype.dispose=function(){var e=this._animation.runtimeAnimations.indexOf(this);e>-1&&this._animation.runtimeAnimations.splice(e,1)},e.prototype.setValue=function(e,t){if(this._targetIsArray)for(var i=0;i<this._target.length;i++){var n=this._target[i];this._setValue(n,this._activeTargets[i],e,t,i)}else this._setValue(this._target,this._directTarget,e,t,0)},e.prototype._getOriginalValues=function(e){var t;void 0===e&&(e=0);var i=this._activeTargets[e];(t=i.getRestPose&&"_matrix"===this._targetPath?i.getRestPose():i[this._targetPath])&&t.clone?this._originalValue[e]=t.clone():this._originalValue[e]=t},e.prototype._setValue=function(e,t,i,n,r){if(this._currentActiveTarget=t,this._weight=n,this._enableBlending&&this._blendingFactor<=1){if(!this._originalBlendValue){var o=t[this._targetPath];o.clone?this._originalBlendValue=o.clone():this._originalBlendValue=o}this._originalBlendValue.m?k.AllowMatrixDecomposeForInterpolation?this._currentValue?a.a.DecomposeLerpToRef(this._originalBlendValue,i,this._blendingFactor,this._currentValue):this._currentValue=a.a.DecomposeLerp(this._originalBlendValue,i,this._blendingFactor):this._currentValue?a.a.LerpToRef(this._originalBlendValue,i,this._blendingFactor,this._currentValue):this._currentValue=a.a.Lerp(this._originalBlendValue,i,this._blendingFactor):this._currentValue=k._UniversalLerp(this._originalBlendValue,i,this._blendingFactor);var s=e&&e.animationPropertiesOverride?e.animationPropertiesOverride.blendingSpeed:this._animation.blendingSpeed;this._blendingFactor+=s}else this._currentValue=i;-1!==n?this._scene._registerTargetForLateAnimationBinding(this,this._originalValue[r]):t[this._targetPath]=this._currentValue,e.markAsDirty&&e.markAsDirty(this._animation.targetProperty)},e.prototype._getCorrectLoopMode=function(){return this._target&&this._target.animationPropertiesOverride?this._target.animationPropertiesOverride.loopMode:this._animation.loopMode},e.prototype.goToFrame=function(e){var t=this._animation.getKeys();e<t[0].frame?e=t[0].frame:e>t[t.length-1].frame&&(e=t[t.length-1].frame);var i=this._events;if(i.length)for(var n=0;n<i.length;n++)i[n].onlyOnce||(i[n].isDone=i[n].frame<e);this._currentFrame=e;var r=this._animation._interpolate(e,this._animationState);this.setValue(r,-1)},e.prototype._prepareForSpeedRatioChange=function(e){var t=this._previousDelay*(this._animation.framePerSecond*e)/1e3;this._ratioOffset=this._previousRatio-t},e.prototype.animate=function(e,t,i,n,r,o){void 0===o&&(o=-1);var a=this._animation,s=a.targetPropertyPath;if(!s||s.length<1)return this._stopped=!0,!1;var c=!0;(t<this._minFrame||t>this._maxFrame)&&(t=this._minFrame),(i<this._minFrame||i>this._maxFrame)&&(i=this._maxFrame);var l,u,h=i-t,d=e*(a.framePerSecond*r)/1e3+this._ratioOffset,f=0;if(this._previousDelay=e,this._previousRatio=d,!n&&i>=t&&d>=h)c=!1,f=a._getKeyValue(this._maxValue);else if(!n&&t>=i&&d<=h)c=!1,f=a._getKeyValue(this._minValue);else if(this._animationState.loopMode!==k.ANIMATIONLOOPMODE_CYCLE){var p=i.toString()+t.toString();if(!this._offsetsCache[p]){this._animationState.repeatCount=0,this._animationState.loopMode=k.ANIMATIONLOOPMODE_CYCLE;var _=a._interpolate(t,this._animationState),m=a._interpolate(i,this._animationState);switch(this._animationState.loopMode=this._getCorrectLoopMode(),a.dataType){case k.ANIMATIONTYPE_FLOAT:this._offsetsCache[p]=m-_;break;case k.ANIMATIONTYPE_QUATERNION:this._offsetsCache[p]=m.subtract(_);break;case k.ANIMATIONTYPE_VECTOR3:this._offsetsCache[p]=m.subtract(_);case k.ANIMATIONTYPE_VECTOR2:this._offsetsCache[p]=m.subtract(_);case k.ANIMATIONTYPE_SIZE:this._offsetsCache[p]=m.subtract(_);case k.ANIMATIONTYPE_COLOR3:this._offsetsCache[p]=m.subtract(_)}this._highLimitsCache[p]=m}f=this._highLimitsCache[p],l=this._offsetsCache[p]}if(void 0===l)switch(a.dataType){case k.ANIMATIONTYPE_FLOAT:l=0;break;case k.ANIMATIONTYPE_QUATERNION:l=G;break;case k.ANIMATIONTYPE_VECTOR3:l=j;break;case k.ANIMATIONTYPE_VECTOR2:l=W;break;case k.ANIMATIONTYPE_SIZE:l=X;break;case k.ANIMATIONTYPE_COLOR3:l=H}if(this._host&&this._host.syncRoot){var g=this._host.syncRoot;u=t+(i-t)*((g.masterFrame-g.fromFrame)/(g.toFrame-g.fromFrame))}else u=c&&0!==h?t+d%h:i;var v=this._events;if((h>0&&this.currentFrame>u||h<0&&this.currentFrame<u)&&(this._onLoop(),v.length))for(var y=0;y<v.length;y++)v[y].onlyOnce||(v[y].isDone=!1);this._currentFrame=u,this._animationState.repeatCount=0===h?0:d/h>>0,this._animationState.highLimitValue=f,this._animationState.offsetValue=l;var b=a._interpolate(u,this._animationState);if(this.setValue(b,o),v.length)for(y=0;y<v.length;y++)if(h>0&&u>=v[y].frame&&v[y].frame>=t||h<0&&u<=v[y].frame&&v[y].frame<=t){var T=v[y];T.isDone||(T.onlyOnce&&(v.splice(y,1),y--),T.isDone=!0,T.action(u))}return c||(this._stopped=!0),c},e}(),K=i(18),Q=i(52),q=i(42),Z=i(22),J=function(e){function t(t,i,n,r,o,s,c){void 0===n&&(n=null),void 0===r&&(r=null),void 0===o&&(o=null),void 0===s&&(s=null),void 0===c&&(c=null);var l=e.call(this,t,i.getScene())||this;return l.name=t,l.children=new Array,l.animations=new Array,l._index=null,l._absoluteTransform=new a.a,l._invertedAbsoluteTransform=new a.a,l._scalingDeterminant=1,l._worldTransform=new a.a,l._needToDecompose=!0,l._needToCompose=!1,l._linkedTransformNode=null,l._waitingTransformNodeId=null,l._skeleton=i,l._localMatrix=r?r.clone():a.a.Identity(),l._restPose=o||l._localMatrix.clone(),l._baseMatrix=s||l._localMatrix.clone(),l._index=c,i.bones.push(l),l.setParent(n,!1),(s||r)&&l._updateDifferenceMatrix(),l}return Object(h.d)(t,e),Object.defineProperty(t.prototype,"_matrix",{get:function(){return this._compose(),this._localMatrix},set:function(e){this._localMatrix.copyFrom(e),this._needToDecompose=!0},enumerable:!0,configurable:!0}),t.prototype.getClassName=function(){return"Bone"},t.prototype.getSkeleton=function(){return this._skeleton},t.prototype.getParent=function(){return this._parent},t.prototype.getChildren=function(){return this.children},t.prototype.getIndex=function(){return null===this._index?this.getSkeleton().bones.indexOf(this):this._index},t.prototype.setParent=function(e,t){if(void 0===t&&(t=!0),this._parent!==e){if(this._parent){var i=this._parent.children.indexOf(this);-1!==i&&this._parent.children.splice(i,1)}this._parent=e,this._parent&&this._parent.children.push(this),t&&this._updateDifferenceMatrix(),this.markAsDirty()}},t.prototype.getLocalMatrix=function(){return this._compose(),this._localMatrix},t.prototype.getBaseMatrix=function(){return this._baseMatrix},t.prototype.getRestPose=function(){return this._restPose},t.prototype.getWorldMatrix=function(){return this._worldTransform},t.prototype.returnToRest=function(){this.updateMatrix(this._restPose.clone())},t.prototype.getInvertedAbsoluteTransform=function(){return this._invertedAbsoluteTransform},t.prototype.getAbsoluteTransform=function(){return this._absoluteTransform},t.prototype.linkTransformNode=function(e){this._linkedTransformNode&&this._skeleton._numBonesWithLinkedTransformNode--,this._linkedTransformNode=e,this._linkedTransformNode&&this._skeleton._numBonesWithLinkedTransformNode++},t.prototype.getTransformNode=function(){return this._linkedTransformNode},Object.defineProperty(t.prototype,"position",{get:function(){return this._decompose(),this._localPosition},set:function(e){this._decompose(),this._localPosition.copyFrom(e),this._markAsDirtyAndCompose()},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"rotation",{get:function(){return this.getRotation()},set:function(e){this.setRotation(e)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"rotationQuaternion",{get:function(){return this._decompose(),this._localRotation},set:function(e){this.setRotationQuaternion(e)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"scaling",{get:function(){return this.getScale()},set:function(e){this.setScale(e)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"animationPropertiesOverride",{get:function(){return this._skeleton.animationPropertiesOverride},enumerable:!0,configurable:!0}),t.prototype._decompose=function(){this._needToDecompose&&(this._needToDecompose=!1,this._localScaling||(this._localScaling=a.e.Zero(),this._localRotation=a.b.Zero(),this._localPosition=a.e.Zero()),this._localMatrix.decompose(this._localScaling,this._localRotation,this._localPosition))},t.prototype._compose=function(){this._needToCompose&&(this._localScaling?(this._needToCompose=!1,a.a.ComposeToRef(this._localScaling,this._localRotation,this._localPosition,this._localMatrix)):this._needToCompose=!1)},t.prototype.updateMatrix=function(e,t,i){void 0===t&&(t=!0),void 0===i&&(i=!0),this._baseMatrix.copyFrom(e),t&&this._updateDifferenceMatrix(),i?(this._localMatrix.copyFrom(e),this._markAsDirtyAndDecompose()):this.markAsDirty()},t.prototype._updateDifferenceMatrix=function(e,t){if(void 0===t&&(t=!0),e||(e=this._baseMatrix),this._parent?e.multiplyToRef(this._parent._absoluteTransform,this._absoluteTransform):this._absoluteTransform.copyFrom(e),this._absoluteTransform.invertToRef(this._invertedAbsoluteTransform),t)for(var i=0;i<this.children.length;i++)this.children[i]._updateDifferenceMatrix();this._scalingDeterminant=this._absoluteTransform.determinant()<0?-1:1},t.prototype.markAsDirty=function(){this._currentRenderId++,this._childUpdateId++,this._skeleton._markAsDirty()},t.prototype._markAsDirtyAndCompose=function(){this.markAsDirty(),this._needToCompose=!0},t.prototype._markAsDirtyAndDecompose=function(){this.markAsDirty(),this._needToDecompose=!0},t.prototype.translate=function(e,i,n){void 0===i&&(i=Z.b.LOCAL);var r=this.getLocalMatrix();if(i==Z.b.LOCAL)r.addAtIndex(12,e.x),r.addAtIndex(13,e.y),r.addAtIndex(14,e.z);else{var o=null;n&&(o=n.getWorldMatrix()),this._skeleton.computeAbsoluteTransforms();var s=t._tmpMats[0],c=t._tmpVecs[0];this._parent&&(n&&o?(s.copyFrom(this._parent.getAbsoluteTransform()),s.multiplyToRef(o,s)):s.copyFrom(this._parent.getAbsoluteTransform())),s.setTranslationFromFloats(0,0,0),s.invert(),a.e.TransformCoordinatesToRef(e,s,c),r.addAtIndex(12,c.x),r.addAtIndex(13,c.y),r.addAtIndex(14,c.z)}this._markAsDirtyAndDecompose()},t.prototype.setPosition=function(e,i,n){void 0===i&&(i=Z.b.LOCAL);var r=this.getLocalMatrix();if(i==Z.b.LOCAL)r.setTranslationFromFloats(e.x,e.y,e.z);else{var o=null;n&&(o=n.getWorldMatrix()),this._skeleton.computeAbsoluteTransforms();var s=t._tmpMats[0],c=t._tmpVecs[0];this._parent&&(n&&o?(s.copyFrom(this._parent.getAbsoluteTransform()),s.multiplyToRef(o,s)):s.copyFrom(this._parent.getAbsoluteTransform())),s.invert(),a.e.TransformCoordinatesToRef(e,s,c),r.setTranslationFromFloats(c.x,c.y,c.z)}this._markAsDirtyAndDecompose()},t.prototype.setAbsolutePosition=function(e,t){this.setPosition(e,Z.b.WORLD,t)},t.prototype.scale=function(e,i,n,r){void 0===r&&(r=!1);var o=this.getLocalMatrix(),s=t._tmpMats[0];a.a.ScalingToRef(e,i,n,s),s.multiplyToRef(o,o),s.invert();for(var c=0,l=this.children;c<l.length;c++){var u=(f=l[c]).getLocalMatrix();u.multiplyToRef(s,u),u.multiplyAtIndex(12,e),u.multiplyAtIndex(13,i),u.multiplyAtIndex(14,n),f._markAsDirtyAndDecompose()}if(this._markAsDirtyAndDecompose(),r)for(var h=0,d=this.children;h<d.length;h++){var f;(f=d[h]).scale(e,i,n,r)}},t.prototype.setScale=function(e){this._decompose(),this._localScaling.copyFrom(e),this._markAsDirtyAndCompose()},t.prototype.getScale=function(){return this._decompose(),this._localScaling},t.prototype.getScaleToRef=function(e){this._decompose(),e.copyFrom(this._localScaling)},t.prototype.setYawPitchRoll=function(e,i,n,r,o){if(void 0===r&&(r=Z.b.LOCAL),r===Z.b.LOCAL){var s=t._tmpQuat;return a.b.RotationYawPitchRollToRef(e,i,n,s),void this.setRotationQuaternion(s,r,o)}var c=t._tmpMats[0];if(this._getNegativeRotationToRef(c,o)){var l=t._tmpMats[1];a.a.RotationYawPitchRollToRef(e,i,n,l),c.multiplyToRef(l,l),this._rotateWithMatrix(l,r,o)}},t.prototype.rotate=function(e,i,n,r){void 0===n&&(n=Z.b.LOCAL);var o=t._tmpMats[0];o.setTranslationFromFloats(0,0,0),a.a.RotationAxisToRef(e,i,o),this._rotateWithMatrix(o,n,r)},t.prototype.setAxisAngle=function(e,i,n,r){if(void 0===n&&(n=Z.b.LOCAL),n===Z.b.LOCAL){var o=t._tmpQuat;return a.b.RotationAxisToRef(e,i,o),void this.setRotationQuaternion(o,n,r)}var s=t._tmpMats[0];if(this._getNegativeRotationToRef(s,r)){var c=t._tmpMats[1];a.a.RotationAxisToRef(e,i,c),s.multiplyToRef(c,c),this._rotateWithMatrix(c,n,r)}},t.prototype.setRotation=function(e,t,i){void 0===t&&(t=Z.b.LOCAL),this.setYawPitchRoll(e.y,e.x,e.z,t,i)},t.prototype.setRotationQuaternion=function(e,i,n){if(void 0===i&&(i=Z.b.LOCAL),i===Z.b.LOCAL)return this._decompose(),this._localRotation.copyFrom(e),void this._markAsDirtyAndCompose();var r=t._tmpMats[0];if(this._getNegativeRotationToRef(r,n)){var o=t._tmpMats[1];a.a.FromQuaternionToRef(e,o),r.multiplyToRef(o,o),this._rotateWithMatrix(o,i,n)}},t.prototype.setRotationMatrix=function(e,i,n){if(void 0===i&&(i=Z.b.LOCAL),i===Z.b.LOCAL){var r=t._tmpQuat;return a.b.FromRotationMatrixToRef(e,r),void this.setRotationQuaternion(r,i,n)}var o=t._tmpMats[0];if(this._getNegativeRotationToRef(o,n)){var s=t._tmpMats[1];s.copyFrom(e),o.multiplyToRef(e,s),this._rotateWithMatrix(s,i,n)}},t.prototype._rotateWithMatrix=function(e,i,n){void 0===i&&(i=Z.b.LOCAL);var r=this.getLocalMatrix(),o=r.m[12],a=r.m[13],s=r.m[14],c=this.getParent(),l=t._tmpMats[3],u=t._tmpMats[4];c&&i==Z.b.WORLD?(n?(l.copyFrom(n.getWorldMatrix()),c.getAbsoluteTransform().multiplyToRef(l,l)):l.copyFrom(c.getAbsoluteTransform()),u.copyFrom(l),u.invert(),r.multiplyToRef(l,r),r.multiplyToRef(e,r),r.multiplyToRef(u,r)):i==Z.b.WORLD&&n?(l.copyFrom(n.getWorldMatrix()),u.copyFrom(l),u.invert(),r.multiplyToRef(l,r),r.multiplyToRef(e,r),r.multiplyToRef(u,r)):r.multiplyToRef(e,r),r.setTranslationFromFloats(o,a,s),this.computeAbsoluteTransforms(),this._markAsDirtyAndDecompose()},t.prototype._getNegativeRotationToRef=function(e,i){var n=t._tmpMats[2];return e.copyFrom(this.getAbsoluteTransform()),i&&(e.multiplyToRef(i.getWorldMatrix(),e),a.a.ScalingToRef(i.scaling.x,i.scaling.y,i.scaling.z,n)),e.invert(),!isNaN(e.m[0])&&(n.multiplyAtIndex(0,this._scalingDeterminant),e.multiplyToRef(n,e),!0)},t.prototype.getPosition=function(e,t){void 0===e&&(e=Z.b.LOCAL),void 0===t&&(t=null);var i=a.e.Zero();return this.getPositionToRef(e,t,i),i},t.prototype.getPositionToRef=function(e,i,n){if(void 0===e&&(e=Z.b.LOCAL),e==Z.b.LOCAL){var r=this.getLocalMatrix();n.x=r.m[12],n.y=r.m[13],n.z=r.m[14]}else{var o=null;i&&(o=i.getWorldMatrix()),this._skeleton.computeAbsoluteTransforms();var a=t._tmpMats[0];i&&o?(a.copyFrom(this.getAbsoluteTransform()),a.multiplyToRef(o,a)):a=this.getAbsoluteTransform(),n.x=a.m[12],n.y=a.m[13],n.z=a.m[14]}},t.prototype.getAbsolutePosition=function(e){void 0===e&&(e=null);var t=a.e.Zero();return this.getPositionToRef(Z.b.WORLD,e,t),t},t.prototype.getAbsolutePositionToRef=function(e,t){this.getPositionToRef(Z.b.WORLD,e,t)},t.prototype.computeAbsoluteTransforms=function(){if(this._compose(),this._parent)this._localMatrix.multiplyToRef(this._parent._absoluteTransform,this._absoluteTransform);else{this._absoluteTransform.copyFrom(this._localMatrix);var e=this._skeleton.getPoseMatrix();e&&this._absoluteTransform.multiplyToRef(e,this._absoluteTransform)}for(var t=this.children,i=t.length,n=0;n<i;n++)t[n].computeAbsoluteTransforms()},t.prototype.getDirection=function(e,t){void 0===t&&(t=null);var i=a.e.Zero();return this.getDirectionToRef(e,t,i),i},t.prototype.getDirectionToRef=function(e,i,n){void 0===i&&(i=null);var r=null;i&&(r=i.getWorldMatrix()),this._skeleton.computeAbsoluteTransforms();var o=t._tmpMats[0];o.copyFrom(this.getAbsoluteTransform()),i&&r&&o.multiplyToRef(r,o),a.e.TransformNormalToRef(e,o,n),n.normalize()},t.prototype.getRotation=function(e,t){void 0===e&&(e=Z.b.LOCAL),void 0===t&&(t=null);var i=a.e.Zero();return this.getRotationToRef(e,t,i),i},t.prototype.getRotationToRef=function(e,i,n){void 0===e&&(e=Z.b.LOCAL),void 0===i&&(i=null);var r=t._tmpQuat;this.getRotationQuaternionToRef(e,i,r),r.toEulerAnglesToRef(n)},t.prototype.getRotationQuaternion=function(e,t){void 0===e&&(e=Z.b.LOCAL),void 0===t&&(t=null);var i=a.b.Identity();return this.getRotationQuaternionToRef(e,t,i),i},t.prototype.getRotationQuaternionToRef=function(e,i,n){if(void 0===e&&(e=Z.b.LOCAL),void 0===i&&(i=null),e==Z.b.LOCAL)this._decompose(),n.copyFrom(this._localRotation);else{var r=t._tmpMats[0],o=this.getAbsoluteTransform();i?o.multiplyToRef(i.getWorldMatrix(),r):r.copyFrom(o),r.multiplyAtIndex(0,this._scalingDeterminant),r.multiplyAtIndex(1,this._scalingDeterminant),r.multiplyAtIndex(2,this._scalingDeterminant),r.decompose(void 0,n,void 0)}},t.prototype.getRotationMatrix=function(e,t){void 0===e&&(e=Z.b.LOCAL);var i=a.a.Identity();return this.getRotationMatrixToRef(e,t,i),i},t.prototype.getRotationMatrixToRef=function(e,i,n){if(void 0===e&&(e=Z.b.LOCAL),e==Z.b.LOCAL)this.getLocalMatrix().getRotationMatrixToRef(n);else{var r=t._tmpMats[0],o=this.getAbsoluteTransform();i?o.multiplyToRef(i.getWorldMatrix(),r):r.copyFrom(o),r.multiplyAtIndex(0,this._scalingDeterminant),r.multiplyAtIndex(1,this._scalingDeterminant),r.multiplyAtIndex(2,this._scalingDeterminant),r.getRotationMatrixToRef(n)}},t.prototype.getAbsolutePositionFromLocal=function(e,t){void 0===t&&(t=null);var i=a.e.Zero();return this.getAbsolutePositionFromLocalToRef(e,t,i),i},t.prototype.getAbsolutePositionFromLocalToRef=function(e,i,n){void 0===i&&(i=null);var r=null;i&&(r=i.getWorldMatrix()),this._skeleton.computeAbsoluteTransforms();var o=t._tmpMats[0];i&&r?(o.copyFrom(this.getAbsoluteTransform()),o.multiplyToRef(r,o)):o=this.getAbsoluteTransform(),a.e.TransformCoordinatesToRef(e,o,n)},t.prototype.getLocalPositionFromAbsolute=function(e,t){void 0===t&&(t=null);var i=a.e.Zero();return this.getLocalPositionFromAbsoluteToRef(e,t,i),i},t.prototype.getLocalPositionFromAbsoluteToRef=function(e,i,n){void 0===i&&(i=null);var r=null;i&&(r=i.getWorldMatrix()),this._skeleton.computeAbsoluteTransforms();var o=t._tmpMats[0];o.copyFrom(this.getAbsoluteTransform()),i&&r&&o.multiplyToRef(r,o),o.invert(),a.e.TransformCoordinatesToRef(e,o,n)},t._tmpVecs=q.a.BuildArray(2,a.e.Zero),t._tmpQuat=a.b.Identity(),t._tmpMats=q.a.BuildArray(5,a.a.Identity),t}(B.a),$=function(){function e(e,t,i,n,r,a,s,c,l){void 0===i&&(i=0),void 0===n&&(n=100),void 0===r&&(r=!1),void 0===a&&(a=1),this.target=t,this.fromFrame=i,this.toFrame=n,this.loopAnimation=r,this.onAnimationEnd=s,this.onAnimationLoop=l,this._localDelayOffset=null,this._pausedDelay=null,this._runtimeAnimations=new Array,this._paused=!1,this._speedRatio=1,this._weight=-1,this._syncRoot=null,this.disposeOnEnd=!0,this.animationStarted=!1,this.onAnimationEndObservable=new o.c,this.onAnimationLoopObservable=new o.c,this._scene=e,c&&this.appendAnimations(t,c),this._speedRatio=a,e._activeAnimatables.push(this)}return Object.defineProperty(e.prototype,"syncRoot",{get:function(){return this._syncRoot},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"masterFrame",{get:function(){return 0===this._runtimeAnimations.length?0:this._runtimeAnimations[0].currentFrame},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"weight",{get:function(){return this._weight},set:function(e){this._weight=-1!==e?Math.min(Math.max(e,0),1):-1},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"speedRatio",{get:function(){return this._speedRatio},set:function(e){for(var t=0;t<this._runtimeAnimations.length;t++){this._runtimeAnimations[t]._prepareForSpeedRatioChange(e)}this._speedRatio=e},enumerable:!0,configurable:!0}),e.prototype.syncWith=function(e){if(this._syncRoot=e,e){var t=this._scene._activeAnimatables.indexOf(this);t>-1&&(this._scene._activeAnimatables.splice(t,1),this._scene._activeAnimatables.push(this))}return this},e.prototype.getAnimations=function(){return this._runtimeAnimations},e.prototype.appendAnimations=function(e,t){for(var i=this,n=0;n<t.length;n++){var r=t[n],o=new Y(e,r,this._scene,this);o._onLoop=function(){i.onAnimationLoopObservable.notifyObservers(i),i.onAnimationLoop&&i.onAnimationLoop()},this._runtimeAnimations.push(o)}},e.prototype.getAnimationByTargetProperty=function(e){for(var t=this._runtimeAnimations,i=0;i<t.length;i++)if(t[i].animation.targetProperty===e)return t[i].animation;return null},e.prototype.getRuntimeAnimationByTargetProperty=function(e){for(var t=this._runtimeAnimations,i=0;i<t.length;i++)if(t[i].animation.targetProperty===e)return t[i];return null},e.prototype.reset=function(){for(var e=this._runtimeAnimations,t=0;t<e.length;t++)e[t].reset(!0);this._localDelayOffset=null,this._pausedDelay=null},e.prototype.enableBlending=function(e){for(var t=this._runtimeAnimations,i=0;i<t.length;i++)t[i].animation.enableBlending=!0,t[i].animation.blendingSpeed=e},e.prototype.disableBlending=function(){for(var e=this._runtimeAnimations,t=0;t<e.length;t++)e[t].animation.enableBlending=!1},e.prototype.goToFrame=function(e){var t=this._runtimeAnimations;if(t[0]){var i=t[0].animation.framePerSecond,n=e-t[0].currentFrame,r=0!==this.speedRatio?1e3*n/(i*this.speedRatio):0;null===this._localDelayOffset&&(this._localDelayOffset=0),this._localDelayOffset-=r}for(var o=0;o<t.length;o++)t[o].goToFrame(e)},e.prototype.pause=function(){this._paused||(this._paused=!0)},e.prototype.restart=function(){this._paused=!1},e.prototype._raiseOnAnimationEnd=function(){this.onAnimationEnd&&this.onAnimationEnd(),this.onAnimationEndObservable.notifyObservers(this)},e.prototype.stop=function(e,t){if(e||t){var i=this._scene._activeAnimatables.indexOf(this);if(i>-1){for(var n=(o=this._runtimeAnimations).length-1;n>=0;n--){var r=o[n];e&&r.animation.name!=e||(t&&!t(r.target)||(r.dispose(),o.splice(n,1)))}0==o.length&&(this._scene._activeAnimatables.splice(i,1),this._raiseOnAnimationEnd())}}else{if((n=this._scene._activeAnimatables.indexOf(this))>-1){this._scene._activeAnimatables.splice(n,1);var o=this._runtimeAnimations;for(n=0;n<o.length;n++)o[n].dispose();this._raiseOnAnimationEnd()}}},e.prototype.waitAsync=function(){var e=this;return new Promise(function(t,i){e.onAnimationEndObservable.add(function(){t(e)},void 0,void 0,e,!0)})},e.prototype._animate=function(e){if(this._paused)return this.animationStarted=!1,null===this._pausedDelay&&(this._pausedDelay=e),!0;if(null===this._localDelayOffset?(this._localDelayOffset=e,this._pausedDelay=null):null!==this._pausedDelay&&(this._localDelayOffset+=e-this._pausedDelay,this._pausedDelay=null),0===this._weight)return!0;var t,i=!1,n=this._runtimeAnimations;for(t=0;t<n.length;t++){var r=n[t].animate(e-this._localDelayOffset,this.fromFrame,this.toFrame,this.loopAnimation,this._speedRatio,this._weight);i=i||r}if(this.animationStarted=i,!i){if(this.disposeOnEnd)for(t=this._scene._activeAnimatables.indexOf(this),this._scene._activeAnimatables.splice(t,1),t=0;t<n.length;t++)n[t].dispose();this._raiseOnAnimationEnd(),this.disposeOnEnd&&(this.onAnimationEnd=null,this.onAnimationLoop=null,this.onAnimationLoopObservable.clear(),this.onAnimationEndObservable.clear())}return i},e}();K.a.prototype._animate=function(){if(this.animationsEnabled){var e=Q.a.Now;if(!this._animationTimeLast){if(this._pendingData.length>0)return;this._animationTimeLast=e}this.deltaTime=this.useConstantAnimationDeltaTime?16:(e-this._animationTimeLast)*this.animationTimeScale,this._animationTimeLast=e;var t=this._activeAnimatables;if(0!==t.length){this._animationTime+=this.deltaTime;for(var i=this._animationTime,n=0;n<t.length;n++){var r=t[n];!r._animate(i)&&r.disposeOnEnd&&n--}this._processLateAnimationBindings()}}},K.a.prototype.beginWeightedAnimation=function(e,t,i,n,r,o,a,s,c,l){void 0===n&&(n=1),void 0===o&&(o=1);var u=this.beginAnimation(e,t,i,r,o,a,s,!1,c,l);return u.weight=n,u},K.a.prototype.beginAnimation=function(e,t,i,n,r,o,a,s,c,l){void 0===r&&(r=1),void 0===s&&(s=!0),t>i&&r>0&&(r*=-1),s&&this.stopAnimation(e,void 0,c),a||(a=new $(this,e,t,i,n,r,o,void 0,l));var u=!c||c(e);if(e.animations&&u&&a.appendAnimations(e,e.animations),e.getAnimatables)for(var h=e.getAnimatables(),d=0;d<h.length;d++)this.beginAnimation(h[d],t,i,n,r,o,a,s,c,l);return a.reset(),a},K.a.prototype.beginHierarchyAnimation=function(e,t,i,n,r,o,a,s,c,l,u){void 0===o&&(o=1),void 0===c&&(c=!0);var h=e.getDescendants(t),d=[];d.push(this.beginAnimation(e,i,n,r,o,a,s,c,l));for(var f=0,p=h;f<p.length;f++){var _=p[f];d.push(this.beginAnimation(_,i,n,r,o,a,s,c,l))}return d},K.a.prototype.beginDirectAnimation=function(e,t,i,n,r,o,a,s){return void 0===o&&(o=1),i>n&&o>0&&(o*=-1),new $(this,e,i,n,r,o,a,t,s)},K.a.prototype.beginDirectHierarchyAnimation=function(e,t,i,n,r,o,a,s,c){var l=e.getDescendants(t),u=[];u.push(this.beginDirectAnimation(e,i,n,r,o,a,s,c));for(var h=0,d=l;h<d.length;h++){var f=d[h];u.push(this.beginDirectAnimation(f,i,n,r,o,a,s,c))}return u},K.a.prototype.getAnimatableByTarget=function(e){for(var t=0;t<this._activeAnimatables.length;t++)if(this._activeAnimatables[t].target===e)return this._activeAnimatables[t];return null},K.a.prototype.getAllAnimatablesByTarget=function(e){for(var t=[],i=0;i<this._activeAnimatables.length;i++)this._activeAnimatables[i].target===e&&t.push(this._activeAnimatables[i]);return t},K.a.prototype.stopAnimation=function(e,t,i){for(var n=0,r=this.getAllAnimatablesByTarget(e);n<r.length;n++){r[n].stop(t,i)}},K.a.prototype.stopAllAnimations=function(){if(this._activeAnimatables){for(var e=0;e<this._activeAnimatables.length;e++)this._activeAnimatables[e].stop();this._activeAnimatables=[]}for(var t=0,i=this.animationGroups;t<i.length;t++){i[t].stop()}},K.a.prototype._registerTargetForLateAnimationBinding=function(e,t){var i=e.target;this._registeredForLateAnimationBindings.pushNoDuplicate(i),i._lateAnimationHolders||(i._lateAnimationHolders={}),i._lateAnimationHolders[e.targetPath]||(i._lateAnimationHolders[e.targetPath]={totalWeight:0,animations:[],originalValue:t}),i._lateAnimationHolders[e.targetPath].animations.push(e),i._lateAnimationHolders[e.targetPath].totalWeight+=e.weight},K.a.prototype._processLateAnimationBindingsForMatrices=function(e){var t=1,i=a.c.Vector3[0],n=a.c.Vector3[1],r=a.c.Quaternion[0],o=0,s=e.animations[0],c=e.originalValue,l=1;if(e.totalWeight<1)c.decompose(n,r,i),l=1-e.totalWeight;else if(o=1,t=e.totalWeight,s.currentValue.decompose(n,r,i),1==(l=s.weight/t))return s.currentValue;n.scaleInPlace(l),i.scaleInPlace(l),r.scaleInPlace(l);for(var u=o;u<e.animations.length;u++){var h=e.animations[u],d=(l=h.weight/t,a.c.Vector3[2]),f=a.c.Vector3[3],p=a.c.Quaternion[1];h.currentValue.decompose(f,p,d),f.scaleAndAddToRef(l,n),p.scaleAndAddToRef(l,r),d.scaleAndAddToRef(l,i)}var _=s._animationState.workValue;return a.a.ComposeToRef(n,r,i,_),_},K.a.prototype._processLateAnimationBindingsForQuaternions=function(e,t){var i=e.animations[0],n=e.originalValue;if(1===e.animations.length)return a.b.SlerpToRef(n,i.currentValue,Math.min(1,e.totalWeight),t),t;var r,o,s=1;if(e.totalWeight<1){var c=1-e.totalWeight;o=[],(r=[]).push(n),o.push(c)}else{if(2===e.animations.length)return a.b.SlerpToRef(e.animations[0].currentValue,e.animations[1].currentValue,e.animations[1].weight/e.totalWeight,t),t;r=[],o=[],s=e.totalWeight}for(var l=0;l<e.animations.length;l++){var u=e.animations[l];r.push(u.currentValue),o.push(u.weight/s)}for(var h=0,d=null,f=0;f<r.length;)d?(h+=o[f],a.b.SlerpToRef(d,r[f],o[f]/h,d),f++):(a.b.SlerpToRef(r[f],r[f+1],o[f+1]/(o[f]+o[f+1]),t),d=t,h=o[f]+o[f+1],f+=2);return d},K.a.prototype._processLateAnimationBindings=function(){if(this._registeredForLateAnimationBindings.length){for(var e=0;e<this._registeredForLateAnimationBindings.length;e++){var t=this._registeredForLateAnimationBindings.data[e];for(var i in t._lateAnimationHolders){var n=t._lateAnimationHolders[i],r=n.animations[0],o=n.originalValue,s=k.AllowMatrixDecomposeForInterpolation&&o.m,c=t[i];if(s)c=this._processLateAnimationBindingsForMatrices(n);else if(void 0!==o.w)c=this._processLateAnimationBindingsForQuaternions(n,c||a.b.Identity());else{var l=0,u=1;if(n.totalWeight<1)c=o.scale?o.scale(1-n.totalWeight):o*(1-n.totalWeight);else{u=n.totalWeight;var h=r.weight/u;c=1!==h?r.currentValue.scale?r.currentValue.scale(h):r.currentValue*h:r.currentValue,l=1}for(var d=l;d<n.animations.length;d++){var f=n.animations[d],p=f.weight/u;f.currentValue.scaleAndAddToRef?f.currentValue.scaleAndAddToRef(p,c):c+=f.currentValue*p}}t[i]=c}t._lateAnimationHolders={}}this._registeredForLateAnimationBindings.reset()}},J.prototype.copyAnimationRange=function(e,t,i,n,r){void 0===n&&(n=!1),void 0===r&&(r=null),0===this.animations.length&&(this.animations.push(new k(this.name,"_matrix",e.animations[0].framePerSecond,k.ANIMATIONTYPE_MATRIX,0)),this.animations[0].setKeys([]));var o=e.animations[0].getRange(t);if(!o)return!1;for(var a,s,c,l=o.from,u=o.to,h=e.animations[0].getKeys(),d=e.length,f=e.getParent(),p=this.getParent(),_=n&&f&&d&&this.length&&d!==this.length,m=_&&p&&f?p.length/f.length:1,g=n&&!p&&r&&(1!==r.x||1!==r.y||1!==r.z),v=this.animations[0].getKeys(),y=0,b=h.length;y<b;y++)(a=h[y]).frame>=l&&a.frame<=u&&(n?(c=a.value.clone(),_?(s=c.getTranslation(),c.setTranslation(s.scaleInPlace(m))):g&&r?(s=c.getTranslation(),c.setTranslation(s.multiplyInPlace(r))):c=a.value):c=a.value,v.push({frame:a.frame+i,value:c}));return this.animations[0].createRange(t,l+i,u+i),!0};var ee,te=function(){function e(){}return e.prototype.serialize=function(){var e={};return e.animation=this.animation.serialize(),e.targetId=this.target.id,e},e}(),ie=function(){function e(e,t){void 0===t&&(t=null),this.name=e,this._targetedAnimations=new Array,this._animatables=new Array,this._from=Number.MAX_VALUE,this._to=-Number.MAX_VALUE,this._speedRatio=1,this._loopAnimation=!1,this.onAnimationEndObservable=new o.c,this.onAnimationLoopObservable=new o.c,this.onAnimationGroupLoopObservable=new o.c,this.onAnimationGroupEndObservable=new o.c,this.onAnimationGroupPauseObservable=new o.c,this.onAnimationGroupPlayObservable=new o.c,this._scene=t||R.a.LastCreatedScene,this.uniqueId=this._scene.getUniqueId(),this._scene.animationGroups.push(this)}return Object.defineProperty(e.prototype,"from",{get:function(){return this._from},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"to",{get:function(){return this._to},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"isStarted",{get:function(){return this._isStarted},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"isPlaying",{get:function(){return this._isStarted&&!this._isPaused},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"speedRatio",{get:function(){return this._speedRatio},set:function(e){if(this._speedRatio!==e){this._speedRatio=e;for(var t=0;t<this._animatables.length;t++){this._animatables[t].speedRatio=this._speedRatio}}},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"loopAnimation",{get:function(){return this._loopAnimation},set:function(e){if(this._loopAnimation!==e){this._loopAnimation=e;for(var t=0;t<this._animatables.length;t++){this._animatables[t].loopAnimation=this._loopAnimation}}},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"targetedAnimations",{get:function(){return this._targetedAnimations},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"animatables",{get:function(){return this._animatables},enumerable:!0,configurable:!0}),e.prototype.addTargetedAnimation=function(e,t){var i=new te;i.animation=e,i.target=t;var n=e.getKeys();return this._from>n[0].frame&&(this._from=n[0].frame),this._to<n[n.length-1].frame&&(this._to=n[n.length-1].frame),this._targetedAnimations.push(i),i},e.prototype.normalize=function(e,t){void 0===e&&(e=null),void 0===t&&(t=null),null==e&&(e=this._from),null==t&&(t=this._to);for(var i=0;i<this._targetedAnimations.length;i++){var n=this._targetedAnimations[i].animation.getKeys(),r=n[0],o=n[n.length-1];if(r.frame>e){var a={frame:e,value:r.value,inTangent:r.inTangent,outTangent:r.outTangent,interpolation:r.interpolation};n.splice(0,0,a)}if(o.frame<t){a={frame:t,value:o.value,inTangent:o.outTangent,outTangent:o.outTangent,interpolation:o.interpolation};n.push(a)}}return this._from=e,this._to=t,this},e.prototype._processLoop=function(e,t,i){var n=this;e.onAnimationLoop=function(){n.onAnimationLoopObservable.notifyObservers(t),n._animationLoopFlags[i]||(n._animationLoopFlags[i]=!0,n._animationLoopCount++,n._animationLoopCount===n._targetedAnimations.length&&(n.onAnimationGroupLoopObservable.notifyObservers(n),n._animationLoopCount=0,n._animationLoopFlags=[]))}},e.prototype.start=function(e,t,i,n){var r=this;if(void 0===e&&(e=!1),void 0===t&&(t=1),this._isStarted||0===this._targetedAnimations.length)return this;this._loopAnimation=e,this._animationLoopCount=0,this._animationLoopFlags=[];for(var o=function(){var o=a._targetedAnimations[s],c=a._scene.beginDirectAnimation(o.target,[o.animation],void 0!==i?i:a._from,void 0!==n?n:a._to,e,t);c.onAnimationEnd=function(){r.onAnimationEndObservable.notifyObservers(o),r._checkAnimationGroupEnded(c)},a._processLoop(c,o,s),a._animatables.push(c)},a=this,s=0;s<this._targetedAnimations.length;s++)o();if(this._speedRatio=t,void 0!==i&&void 0!==n)if(i<n&&this._speedRatio<0){var c=n;n=i,i=c}else i>n&&this._speedRatio>0&&(this._speedRatio=-t);return this._isStarted=!0,this._isPaused=!1,this.onAnimationGroupPlayObservable.notifyObservers(this),this},e.prototype.pause=function(){if(!this._isStarted)return this;this._isPaused=!0;for(var e=0;e<this._animatables.length;e++){this._animatables[e].pause()}return this.onAnimationGroupPauseObservable.notifyObservers(this),this},e.prototype.play=function(e){return this.isStarted&&this._animatables.length===this._targetedAnimations.length?(void 0!==e&&(this.loopAnimation=e),this.restart()):(this.stop(),this.start(e,this._speedRatio)),this._isPaused=!1,this},e.prototype.reset=function(){if(!this._isStarted)return this;for(var e=0;e<this._animatables.length;e++){this._animatables[e].reset()}return this},e.prototype.restart=function(){if(!this._isStarted)return this;for(var e=0;e<this._animatables.length;e++){this._animatables[e].restart()}return this.onAnimationGroupPlayObservable.notifyObservers(this),this},e.prototype.stop=function(){if(!this._isStarted)return this;for(var e=this._animatables.slice(),t=0;t<e.length;t++)e[t].stop();return this._isStarted=!1,this},e.prototype.setWeightForAllAnimatables=function(e){for(var t=0;t<this._animatables.length;t++){this._animatables[t].weight=e}return this},e.prototype.syncAllAnimationsWith=function(e){for(var t=0;t<this._animatables.length;t++){this._animatables[t].syncWith(e)}return this},e.prototype.goToFrame=function(e){if(!this._isStarted)return this;for(var t=0;t<this._animatables.length;t++){this._animatables[t].goToFrame(e)}return this},e.prototype.dispose=function(){this._targetedAnimations=[],this._animatables=[];var e=this._scene.animationGroups.indexOf(this);e>-1&&this._scene.animationGroups.splice(e,1),this.onAnimationEndObservable.clear(),this.onAnimationGroupEndObservable.clear(),this.onAnimationGroupPauseObservable.clear(),this.onAnimationGroupPlayObservable.clear(),this.onAnimationLoopObservable.clear(),this.onAnimationGroupLoopObservable.clear()},e.prototype._checkAnimationGroupEnded=function(e){var t=this._animatables.indexOf(e);t>-1&&this._animatables.splice(t,1),0===this._animatables.length&&(this._isStarted=!1,this.onAnimationGroupEndObservable.notifyObservers(this))},e.prototype.clone=function(t,i){for(var n=new e(t||this.name,this._scene),r=0,o=this._targetedAnimations;r<o.length;r++){var a=o[r];n.addTargetedAnimation(a.animation.clone(),i?i(a.target):a.target)}return n},e.prototype.serialize=function(){var e={};e.name=this.name,e.from=this.from,e.to=this.to,e.targetedAnimations=[];for(var t=0;t<this.targetedAnimations.length;t++){var i=this.targetedAnimations[t];e.targetedAnimations[t]=i.serialize()}return e},e.Parse=function(t,i){for(var n=new e(t.name,i),r=0;r<t.targetedAnimations.length;r++){var o=t.targetedAnimations[r],a=k.Parse(o.animation),s=o.targetId;if("influence"===o.animation.property){var c=i.getMorphTargetById(s);c&&n.addTargetedAnimation(a,c)}else{var l=i.getNodeByID(s);null!=l&&n.addTargetedAnimation(a,l)}}return null!==t.from&&null!==t.to&&n.normalize(t.from,t.to),n},e.prototype.getClassName=function(){return"AnimationGroup"},e.prototype.toString=function(e){var t="Name: "+this.name;return t+=", type: "+this.getClassName(),e&&(t+=", from: "+this._from,t+=", to: "+this._to,t+=", isStarted: "+this._isStarted,t+=", speedRatio: "+this._speedRatio,t+=", targetedAnimations length: "+this._targetedAnimations.length,t+=", animatables length: "+this._animatables),t},e}(),ne=function(){this.enableBlending=!1,this.blendingSpeed=.01,this.loopMode=k.ANIMATIONLOOPMODE_CYCLE},re=i(28);!function(e){e[e.CW=0]="CW",e[e.CCW=1]="CCW"}(ee||(ee={}));var oe=function(){function e(){}return e.Interpolate=function(e,t,i,n,r){for(var o=1-3*n+3*t,a=3*n-6*t,s=3*t,c=e,l=0;l<5;l++){var u=c*c;c-=(o*(u*c)+a*u+s*c-e)*(1/(3*o*u+2*a*c+s)),c=Math.min(1,Math.max(0,c))}return 3*Math.pow(1-c,2)*c*i+3*(1-c)*Math.pow(c,2)*r+Math.pow(c,3)},e}(),ae=function(){function e(e){this._radians=e,this._radians<0&&(this._radians+=2*Math.PI)}return e.prototype.degrees=function(){return 180*this._radians/Math.PI},e.prototype.radians=function(){return this._radians},e.BetweenTwoPoints=function(t,i){var n=i.subtract(t);return new e(Math.atan2(n.y,n.x))},e.FromRadians=function(t){return new e(t)},e.FromDegrees=function(t){return new e(t*Math.PI/180)},e}(),se=function(e,t,i){this.startPoint=e,this.midPoint=t,this.endPoint=i;var n=Math.pow(t.x,2)+Math.pow(t.y,2),r=(Math.pow(e.x,2)+Math.pow(e.y,2)-n)/2,o=(n-Math.pow(i.x,2)-Math.pow(i.y,2))/2,s=(e.x-t.x)*(t.y-i.y)-(t.x-i.x)*(e.y-t.y);this.centerPoint=new a.d((r*(t.y-i.y)-o*(e.y-t.y))/s,((e.x-t.x)*o-(t.x-i.x)*r)/s),this.radius=this.centerPoint.subtract(this.startPoint).length(),this.startAngle=ae.BetweenTwoPoints(this.centerPoint,this.startPoint);var c=this.startAngle.degrees(),l=ae.BetweenTwoPoints(this.centerPoint,this.midPoint).degrees(),u=ae.BetweenTwoPoints(this.centerPoint,this.endPoint).degrees();l-c>180&&(l-=360),l-c<-180&&(l+=360),u-l>180&&(u-=360),u-l<-180&&(u+=360),this.orientation=l-c<0?ee.CW:ee.CCW,this.angle=ae.FromDegrees(this.orientation===ee.CW?c-u:u-c)},ce=function(){function e(e,t){this._points=new Array,this._length=0,this.closed=!1,this._points.push(new a.d(e,t))}return e.prototype.addLineTo=function(e,t){if(this.closed)return this;var i=new a.d(e,t),n=this._points[this._points.length-1];return this._points.push(i),this._length+=i.subtract(n).length(),this},e.prototype.addArcTo=function(e,t,i,n,r){if(void 0===r&&(r=36),this.closed)return this;var o=this._points[this._points.length-1],s=new a.d(e,t),c=new a.d(i,n),l=new se(o,s,c),u=l.angle.radians()/r;l.orientation===ee.CW&&(u*=-1);for(var h=l.startAngle.radians()+u,d=0;d<r;d++){var f=Math.cos(h)*l.radius+l.centerPoint.x,p=Math.sin(h)*l.radius+l.centerPoint.y;this.addLineTo(f,p),h+=u}return this},e.prototype.close=function(){return this.closed=!0,this},e.prototype.length=function(){var e=this._length;if(this.closed){var t=this._points[this._points.length-1];e+=this._points[0].subtract(t).length()}return e},e.prototype.getPoints=function(){return this._points},e.prototype.getPointAtLengthPosition=function(e){if(e<0||e>1)return a.d.Zero();for(var t=e*this.length(),i=0,n=0;n<this._points.length;n++){var r=(n+1)%this._points.length,o=this._points[n],s=this._points[r].subtract(o),c=s.length()+i;if(t>=i&&t<=c){var l=s.normalize(),u=t-i;return new a.d(o.x+l.x*u,o.y+l.y*u)}i=c}return a.d.Zero()},e.StartingAt=function(t,i){return new e(t,i)},e}(),le=function(){function e(e,t,i,n){void 0===t&&(t=null),void 0===n&&(n=!1),this.path=e,this._curve=new Array,this._distances=new Array,this._tangents=new Array,this._normals=new Array,this._binormals=new Array,this._pointAtData={id:0,point:a.e.Zero(),previousPointArrayIndex:0,position:0,subPosition:0,interpolateReady:!1,interpolationMatrix:a.a.Identity()};for(var r=0;r<e.length;r++)this._curve[r]=e[r].clone();this._raw=i||!1,this._alignTangentsWithPath=n,this._compute(t,n)}return e.prototype.getCurve=function(){return this._curve},e.prototype.getPoints=function(){return this._curve},e.prototype.length=function(){return this._distances[this._distances.length-1]},e.prototype.getTangents=function(){return this._tangents},e.prototype.getNormals=function(){return this._normals},e.prototype.getBinormals=function(){return this._binormals},e.prototype.getDistances=function(){return this._distances},e.prototype.getPointAt=function(e){return this._updatePointAtData(e).point},e.prototype.getTangentAt=function(e,t){return void 0===t&&(t=!1),this._updatePointAtData(e,t),t?a.e.TransformCoordinates(a.e.Forward(),this._pointAtData.interpolationMatrix):this._tangents[this._pointAtData.previousPointArrayIndex]},e.prototype.getNormalAt=function(e,t){return void 0===t&&(t=!1),this._updatePointAtData(e,t),t?a.e.TransformCoordinates(a.e.Right(),this._pointAtData.interpolationMatrix):this._normals[this._pointAtData.previousPointArrayIndex]},e.prototype.getBinormalAt=function(e,t){return void 0===t&&(t=!1),this._updatePointAtData(e,t),t?a.e.TransformCoordinates(a.e.UpReadOnly,this._pointAtData.interpolationMatrix):this._binormals[this._pointAtData.previousPointArrayIndex]},e.prototype.getDistanceAt=function(e){return this.length()*e},e.prototype.getPreviousPointIndexAt=function(e){return this._updatePointAtData(e),this._pointAtData.previousPointArrayIndex},e.prototype.getSubPositionAt=function(e){return this._updatePointAtData(e),this._pointAtData.subPosition},e.prototype.getClosestPositionTo=function(e){for(var t=Number.MAX_VALUE,i=0,n=0;n<this._curve.length-1;n++){var r=this._curve[n+0],o=this._curve[n+1].subtract(r).normalize(),s=this._distances[n+1]-this._distances[n+0],c=Math.min(Math.max(a.e.Dot(o,e.subtract(r).normalize()),0)*a.e.Distance(r,e)/s,1),l=a.e.Distance(r.add(o.scale(c*s)),e);l<t&&(t=l,i=(this._distances[n+0]+s*c)/this.length())}return i},e.prototype.slice=function(t,i){if(void 0===t&&(t=0),void 0===i&&(i=1),t<0&&(t=1- -1*t%1),i<0&&(i=1- -1*i%1),t>i){var n=t;t=i,i=n}var r=this.getCurve(),o=this.getPointAt(t),a=this.getPreviousPointIndexAt(t),s=this.getPointAt(i),c=this.getPreviousPointIndexAt(i)+1,l=[];return 0!==t&&(a++,l.push(o)),l.push.apply(l,r.slice(a,c)),1===i&&1!==t||l.push(s),new e(l,this.getNormalAt(t),this._raw,this._alignTangentsWithPath)},e.prototype.update=function(e,t,i){void 0===t&&(t=null),void 0===i&&(i=!1);for(var n=0;n<e.length;n++)this._curve[n].x=e[n].x,this._curve[n].y=e[n].y,this._curve[n].z=e[n].z;return this._compute(t,i),this},e.prototype._compute=function(e,t){void 0===t&&(t=!1);var i=this._curve.length;this._tangents[0]=this._getFirstNonNullVector(0),this._raw||this._tangents[0].normalize(),this._tangents[i-1]=this._curve[i-1].subtract(this._curve[i-2]),this._raw||this._tangents[i-1].normalize();var n,r,o,s,c,l=this._tangents[0],u=this._normalVector(l,e);this._normals[0]=u,this._raw||this._normals[0].normalize(),this._binormals[0]=a.e.Cross(l,this._normals[0]),this._raw||this._binormals[0].normalize(),this._distances[0]=0;for(var h=1;h<i;h++)n=this._getLastNonNullVector(h),h<i-1&&(r=this._getFirstNonNullVector(h),this._tangents[h]=t?r:n.add(r),this._tangents[h].normalize()),this._distances[h]=this._distances[h-1]+n.length(),o=this._tangents[h],c=this._binormals[h-1],this._normals[h]=a.e.Cross(c,o),this._raw||(0===this._normals[h].length()?(s=this._normals[h-1],this._normals[h]=s.clone()):this._normals[h].normalize()),this._binormals[h]=a.e.Cross(o,this._normals[h]),this._raw||this._binormals[h].normalize();this._pointAtData.id=NaN},e.prototype._getFirstNonNullVector=function(e){for(var t=1,i=this._curve[e+t].subtract(this._curve[e]);0===i.length()&&e+t+1<this._curve.length;)t++,i=this._curve[e+t].subtract(this._curve[e]);return i},e.prototype._getLastNonNullVector=function(e){for(var t=1,i=this._curve[e].subtract(this._curve[e-t]);0===i.length()&&e>t+1;)t++,i=this._curve[e].subtract(this._curve[e-t]);return i},e.prototype._normalVector=function(e,t){var i,n,r=e.length();(0===r&&(r=1),null==t)?(n=L.a.WithinEpsilon(Math.abs(e.y)/r,1,re.a)?L.a.WithinEpsilon(Math.abs(e.x)/r,1,re.a)?L.a.WithinEpsilon(Math.abs(e.z)/r,1,re.a)?a.e.Zero():new a.e(0,0,1):new a.e(1,0,0):new a.e(0,-1,0),i=a.e.Cross(e,n)):(i=a.e.Cross(e,t),a.e.CrossToRef(i,e,i));return i.normalize(),i},e.prototype._updatePointAtData=function(e,t){if(void 0===t&&(t=!1),this._pointAtData.id===e)return this._pointAtData.interpolateReady||this._updateInterpolationMatrix(),this._pointAtData;this._pointAtData.id=e;var i=this.getPoints();if(e<=0)return this._setPointAtData(0,0,i[0],0,t);if(e>=1)return this._setPointAtData(1,1,i[i.length-1],i.length-1,t);for(var n,r=i[0],o=0,s=e*this.length(),c=1;c<i.length;c++){n=i[c];var l=a.e.Distance(r,n);if((o+=l)===s)return this._setPointAtData(e,1,n,c,t);if(o>s){var u=(o-s)/l,h=r.subtract(n),d=n.add(h.scaleInPlace(u));return this._setPointAtData(e,1-u,d,c-1,t)}r=n}return this._pointAtData},e.prototype._setPointAtData=function(e,t,i,n,r){return this._pointAtData.point=i,this._pointAtData.position=e,this._pointAtData.subPosition=t,this._pointAtData.previousPointArrayIndex=n,this._pointAtData.interpolateReady=r,r&&this._updateInterpolationMatrix(),this._pointAtData},e.prototype._updateInterpolationMatrix=function(){this._pointAtData.interpolationMatrix=a.a.Identity();var e=this._pointAtData.previousPointArrayIndex;if(e!==this._tangents.length-1){var t=e+1,i=this._tangents[e].clone(),n=this._normals[e].clone(),r=this._binormals[e].clone(),o=this._tangents[t].clone(),s=this._normals[t].clone(),c=this._binormals[t].clone(),l=a.b.RotationQuaternionFromAxis(n,r,i),u=a.b.RotationQuaternionFromAxis(s,c,o);a.b.Slerp(l,u,this._pointAtData.subPosition).toRotationMatrix(this._pointAtData.interpolationMatrix)}},e}(),ue=function(){function e(e){this._length=0,this._points=e,this._length=this._computeLength(e)}return e.CreateQuadraticBezier=function(t,i,n,r){r=r>2?r:3;for(var o=new Array,s=function(e,t,i,n){return(1-e)*(1-e)*t+2*e*(1-e)*i+e*e*n},c=0;c<=r;c++)o.push(new a.e(s(c/r,t.x,i.x,n.x),s(c/r,t.y,i.y,n.y),s(c/r,t.z,i.z,n.z)));return new e(o)},e.CreateCubicBezier=function(t,i,n,r,o){o=o>3?o:4;for(var s=new Array,c=function(e,t,i,n,r){return(1-e)*(1-e)*(1-e)*t+3*e*(1-e)*(1-e)*i+3*e*e*(1-e)*n+e*e*e*r},l=0;l<=o;l++)s.push(new a.e(c(l/o,t.x,i.x,n.x,r.x),c(l/o,t.y,i.y,n.y,r.y),c(l/o,t.z,i.z,n.z,r.z)));return new e(s)},e.CreateHermiteSpline=function(t,i,n,r,o){for(var s=new Array,c=1/o,l=0;l<=o;l++)s.push(a.e.Hermite(t,i,n,r,l*c));return new e(s)},e.CreateCatmullRomSpline=function(t,i,n){var r=new Array,o=1/i,s=0;if(n){for(var c=t.length,l=0;l<c;l++){s=0;for(var u=0;u<i;u++)r.push(a.e.CatmullRom(t[l%c],t[(l+1)%c],t[(l+2)%c],t[(l+3)%c],s)),s+=o}r.push(r[0])}else{var h=new Array;h.push(t[0].clone()),Array.prototype.push.apply(h,t),h.push(t[t.length-1].clone());for(l=0;l<h.length-3;l++){s=0;for(u=0;u<i;u++)r.push(a.e.CatmullRom(h[l],h[l+1],h[l+2],h[l+3],s)),s+=o}l--,r.push(a.e.CatmullRom(h[l],h[l+1],h[l+2],h[l+3],s))}return new e(r)},e.prototype.getPoints=function(){return this._points},e.prototype.length=function(){return this._length},e.prototype.continue=function(t){for(var i=this._points[this._points.length-1],n=this._points.slice(),r=t.getPoints(),o=1;o<r.length;o++)n.push(r[o].subtract(r[0]).add(i));return new e(n)},e.prototype._computeLength=function(e){for(var t=0,i=1;i<e.length;i++)t+=e[i].subtract(e[i-1]).length();return t},e}(),he=function(){function e(){this._easingMode=e.EASINGMODE_EASEIN}return e.prototype.setEasingMode=function(e){var t=Math.min(Math.max(e,0),2);this._easingMode=t},e.prototype.getEasingMode=function(){return this._easingMode},e.prototype.easeInCore=function(e){throw new Error("You must implement this method")},e.prototype.ease=function(t){switch(this._easingMode){case e.EASINGMODE_EASEIN:return this.easeInCore(t);case e.EASINGMODE_EASEOUT:return 1-this.easeInCore(1-t)}return t>=.5?.5*(1-this.easeInCore(2*(1-t)))+.5:.5*this.easeInCore(2*t)},e.EASINGMODE_EASEIN=0,e.EASINGMODE_EASEOUT=1,e.EASINGMODE_EASEINOUT=2,e}(),de=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return Object(h.d)(t,e),t.prototype.easeInCore=function(e){return e=Math.max(0,Math.min(1,e)),1-Math.sqrt(1-e*e)},t}(he),fe=function(e){function t(t){void 0===t&&(t=1);var i=e.call(this)||this;return i.amplitude=t,i}return Object(h.d)(t,e),t.prototype.easeInCore=function(e){var t=Math.max(0,this.amplitude);return Math.pow(e,3)-e*t*Math.sin(3.141592653589793*e)},t}(he),pe=function(e){function t(t,i){void 0===t&&(t=3),void 0===i&&(i=2);var n=e.call(this)||this;return n.bounces=t,n.bounciness=i,n}return Object(h.d)(t,e),t.prototype.easeInCore=function(e){var t=Math.max(0,this.bounces),i=this.bounciness;i<=1&&(i=1.001);var n=Math.pow(i,t),r=1-i,o=(1-n)/r+.5*n,a=e*o,s=Math.log(-a*(1-i)+1)/Math.log(i),c=Math.floor(s),l=c+1,u=(1-Math.pow(i,c))/(r*o),h=.5*(u+(1-Math.pow(i,l))/(r*o)),d=e-h,f=h-u;return-Math.pow(1/i,t-c)/(f*f)*(d-f)*(d+f)},t}(he),_e=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return Object(h.d)(t,e),t.prototype.easeInCore=function(e){return e*e*e},t}(he),me=function(e){function t(t,i){void 0===t&&(t=3),void 0===i&&(i=3);var n=e.call(this)||this;return n.oscillations=t,n.springiness=i,n}return Object(h.d)(t,e),t.prototype.easeInCore=function(e){var t=Math.max(0,this.oscillations),i=Math.max(0,this.springiness);return(0==i?e:(Math.exp(i*e)-1)/(Math.exp(i)-1))*Math.sin((6.283185307179586*t+1.5707963267948966)*e)},t}(he),ge=function(e){function t(t){void 0===t&&(t=2);var i=e.call(this)||this;return i.exponent=t,i}return Object(h.d)(t,e),t.prototype.easeInCore=function(e){return this.exponent<=0?e:(Math.exp(this.exponent*e)-1)/(Math.exp(this.exponent)-1)},t}(he),ve=function(e){function t(t){void 0===t&&(t=2);var i=e.call(this)||this;return i.power=t,i}return Object(h.d)(t,e),t.prototype.easeInCore=function(e){var t=Math.max(0,this.power);return Math.pow(e,t)},t}(he),ye=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return Object(h.d)(t,e),t.prototype.easeInCore=function(e){return e*e},t}(he),be=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return Object(h.d)(t,e),t.prototype.easeInCore=function(e){return e*e*e*e},t}(he),Te=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return Object(h.d)(t,e),t.prototype.easeInCore=function(e){return e*e*e*e*e},t}(he),Ee=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return Object(h.d)(t,e),t.prototype.easeInCore=function(e){return 1-Math.sin(1.5707963267948966*(1-e))},t}(he),xe=function(e){function t(t,i,n,r){void 0===t&&(t=0),void 0===i&&(i=0),void 0===n&&(n=1),void 0===r&&(r=1);var o=e.call(this)||this;return o.x1=t,o.y1=i,o.x2=n,o.y2=r,o}return Object(h.d)(t,e),t.prototype.easeInCore=function(e){return oe.Interpolate(e,this.x1,this.y1,this.x2,this.y2)},t}(he),Pe=function(){function e(e,t,i){this.frame=e,this.action=t,this.onlyOnce=i,this.isDone=!1}return e.prototype._clone=function(){return new e(this.frame,this.action,this.onlyOnce)},e}(),Ae=i(5),Se=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return Object(h.d)(t,e),t}(n.a),Ce=function(){this.rootNodes=[],this.skeletons=[],this.animationGroups=[]},Re=function(e){function t(t){var i=e.call(this)||this;return i._wasAddedToScene=!1,i.scene=t,i.sounds=[],i.effectLayers=[],i.layers=[],i.lensFlareSystems=[],i.proceduralTextures=[],i.reflectionProbes=[],t.onDisposeObservable.add(function(){i._wasAddedToScene||i.dispose()}),i}return Object(h.d)(t,e),t.prototype.instantiateModelsToScene=function(e,t){var i=this;void 0===t&&(t=!1);var n={},r={},o=new Ce,a=[],s=[],c={doNotInstantiate:!0},l=function(t,i){if(n[t.uniqueId]=i.uniqueId,r[i.uniqueId]=i,e&&(i.name=e(t.name)),i instanceof Ae.a){var o=i;if(o.morphTargetManager){var a=t.morphTargetManager;o.morphTargetManager=a.clone();for(var s=0;s<a.numTargets;s++){var c=a.getTarget(s),l=o.morphTargetManager.getTarget(s);n[c.uniqueId]=l.uniqueId,r[l.uniqueId]=l}}}};return this.transformNodes.forEach(function(e){if(!e.parent){var t=e.instantiateHierarchy(null,c,function(e,t){l(e,t)});t&&o.rootNodes.push(t)}}),this.meshes.forEach(function(a){if(!a.parent){var u=a.instantiateHierarchy(null,c,function(o,a){if(l(o,a),a.material){var c=a;if(c.material)if(t){var u=o.material;if(-1===s.indexOf(u)){var h=u.clone(e?e(u.name):"Clone of "+u.name);if(s.push(u),n[u.uniqueId]=h.uniqueId,r[h.uniqueId]=h,"MultiMaterial"===u.getClassName())for(var d=0,f=u.subMaterials;d<f.length;d++){var p=f[d];p&&(h=p.clone(e?e(p.name):"Clone of "+p.name),s.push(p),n[p.uniqueId]=h.uniqueId,r[h.uniqueId]=h)}}c.material=r[n[u.uniqueId]]}else"MultiMaterial"===c.material.getClassName()?-1===i.scene.multiMaterials.indexOf(c.material)&&i.scene.addMultiMaterial(c.material):-1===i.scene.materials.indexOf(c.material)&&i.scene.addMaterial(c.material)}});u&&o.rootNodes.push(u)}}),this.skeletons.forEach(function(t){var s=t.clone(e?e(t.name):"Clone of "+t.name);t.overrideMesh&&(s.overrideMesh=r[n[t.overrideMesh.uniqueId]]);for(var c=0,l=i.meshes;c<l.length;c++){var u=l[c];if(u.skeleton===t&&!u.isAnInstance){if(r[n[u.uniqueId]].skeleton=s,-1!==a.indexOf(s))continue;a.push(s);for(var h=0,d=s.bones;h<d.length;h++){var f=d[h];f._linkedTransformNode&&(f._linkedTransformNode=r[n[f._linkedTransformNode.uniqueId]])}}}o.skeletons.push(s)}),this.animationGroups.forEach(function(e){var t=e.clone(e.name,function(e){return r[n[e.uniqueId]]||e});o.animationGroups.push(t)}),o},t.prototype.addAllToScene=function(){var e=this;this._wasAddedToScene=!0,this.cameras.forEach(function(t){e.scene.addCamera(t)}),this.lights.forEach(function(t){e.scene.addLight(t)}),this.meshes.forEach(function(t){e.scene.addMesh(t)}),this.skeletons.forEach(function(t){e.scene.addSkeleton(t)}),this.animations.forEach(function(t){e.scene.addAnimation(t)}),this.animationGroups.forEach(function(t){e.scene.addAnimationGroup(t)}),this.multiMaterials.forEach(function(t){e.scene.addMultiMaterial(t)}),this.materials.forEach(function(t){e.scene.addMaterial(t)}),this.morphTargetManagers.forEach(function(t){e.scene.addMorphTargetManager(t)}),this.geometries.forEach(function(t){e.scene.addGeometry(t)}),this.transformNodes.forEach(function(t){e.scene.addTransformNode(t)}),this.actionManagers.forEach(function(t){e.scene.addActionManager(t)}),this.textures.forEach(function(t){e.scene.addTexture(t)}),this.reflectionProbes.forEach(function(t){e.scene.addReflectionProbe(t)}),this.environmentTexture&&(this.scene.environmentTexture=this.environmentTexture);for(var t=0,i=this.scene._serializableComponents;t<i.length;t++){i[t].addFromContainer(this)}},t.prototype.removeAllFromScene=function(){var e=this;this._wasAddedToScene=!1,this.cameras.forEach(function(t){e.scene.removeCamera(t)}),this.lights.forEach(function(t){e.scene.removeLight(t)}),this.meshes.forEach(function(t){e.scene.removeMesh(t)}),this.skeletons.forEach(function(t){e.scene.removeSkeleton(t)}),this.animations.forEach(function(t){e.scene.removeAnimation(t)}),this.animationGroups.forEach(function(t){e.scene.removeAnimationGroup(t)}),this.multiMaterials.forEach(function(t){e.scene.removeMultiMaterial(t)}),this.materials.forEach(function(t){e.scene.removeMaterial(t)}),this.morphTargetManagers.forEach(function(t){e.scene.removeMorphTargetManager(t)}),this.geometries.forEach(function(t){e.scene.removeGeometry(t)}),this.transformNodes.forEach(function(t){e.scene.removeTransformNode(t)}),this.actionManagers.forEach(function(t){e.scene.removeActionManager(t)}),this.textures.forEach(function(t){e.scene.removeTexture(t)}),this.reflectionProbes.forEach(function(t){e.scene.removeReflectionProbe(t)}),this.environmentTexture===this.scene.environmentTexture&&(this.scene.environmentTexture=null);for(var t=0,i=this.scene._serializableComponents;t<i.length;t++){i[t].removeFromContainer(this)}},t.prototype.dispose=function(){this.cameras.forEach(function(e){e.dispose()}),this.cameras=[],this.lights.forEach(function(e){e.dispose()}),this.lights=[],this.meshes.forEach(function(e){e.dispose()}),this.meshes=[],this.skeletons.forEach(function(e){e.dispose()}),this.skeletons=[],this.animationGroups.forEach(function(e){e.dispose()}),this.animationGroups=[],this.multiMaterials.forEach(function(e){e.dispose()}),this.multiMaterials=[],this.materials.forEach(function(e){e.dispose()}),this.materials=[],this.geometries.forEach(function(e){e.dispose()}),this.geometries=[],this.transformNodes.forEach(function(e){e.dispose()}),this.transformNodes=[],this.actionManagers.forEach(function(e){e.dispose()}),this.actionManagers=[],this.textures.forEach(function(e){e.dispose()}),this.textures=[],this.reflectionProbes.forEach(function(e){e.dispose()}),this.reflectionProbes=[],this.environmentTexture&&(this.environmentTexture.dispose(),this.environmentTexture=null);for(var e=0,t=this.scene._serializableComponents;e<t.length;e++){t[e].removeFromContainer(this,!0)}},t.prototype._moveAssets=function(e,t,i){if(e)for(var n=0,r=e;n<r.length;n++){var o=r[n],a=!0;if(i)for(var s=0,c=i;s<c.length;s++){if(o===c[s]){a=!1;break}}a&&t.push(o)}},t.prototype.moveAllFromScene=function(e){for(var t in this._wasAddedToScene=!1,void 0===e&&(e=new Se),this)this.hasOwnProperty(t)&&(this[t]=this[t]||("environmentTexture"===t?null:[]),this._moveAssets(this.scene[t],this[t],e[t]));this.removeAllFromScene()},t.prototype.createRootMesh=function(){var e=new Ae.a("assetContainerRootMesh",this.scene);return this.meshes.forEach(function(t){t.parent||e.addChild(t)}),this.meshes.unshift(e),e},t.prototype.mergeAnimationsTo=function(e,t,i){if(void 0===e&&(e=R.a.LastCreatedScene),void 0===i&&(i=null),e){var n=i||function(t){return e.getBoneByName(t.name)||e.getNodeByName(t.name)};this.getNodes().forEach(function(e){var t=n(e);if(null!==t){for(var i=function(e){for(var i=0,n=t.animations.filter(function(t){return t.targetProperty===e.targetProperty});i<n.length;i++){var r=n[i],o=t.animations.indexOf(r,0);o>-1&&t.animations.splice(o,1)}},r=0,o=e.animations;r<o.length;r++){i(o[r])}t.animations=t.animations.concat(e.animations)}}),this.animationGroups.slice().forEach(function(e){e.clone(e.name,n),e.animatables.forEach(function(e){e.stop()})}),t.forEach(function(t){var i=n(t.target);i&&(e.beginAnimation(i,t.fromFrame,t.toFrame,t.loopAnimation,t.speedRatio,t.onAnimationEnd?t.onAnimationEnd:void 0,void 0,!0,void 0,t.onAnimationLoop?t.onAnimationLoop:void 0),e.stopAnimation(t.target))})}else m.a.Error("No scene available to merge animations to")},t}(n.a),Oe=i(11),Me=function(){function e(e){this.SMOOTHING=.75,this.FFT_SIZE=512,this.BARGRAPHAMPLITUDE=256,this.DEBUGCANVASPOS={x:20,y:20},this.DEBUGCANVASSIZE={width:320,height:200},this._scene=e,this._audioEngine=Oe.a.audioEngine,this._audioEngine.canUseWebAudio&&this._audioEngine.audioContext&&(this._webAudioAnalyser=this._audioEngine.audioContext.createAnalyser(),this._webAudioAnalyser.minDecibels=-140,this._webAudioAnalyser.maxDecibels=0,this._byteFreqs=new Uint8Array(this._webAudioAnalyser.frequencyBinCount),this._byteTime=new Uint8Array(this._webAudioAnalyser.frequencyBinCount),this._floatFreqs=new Float32Array(this._webAudioAnalyser.frequencyBinCount))}return e.prototype.getFrequencyBinCount=function(){return this._audioEngine.canUseWebAudio?this._webAudioAnalyser.frequencyBinCount:0},e.prototype.getByteFrequencyData=function(){return this._audioEngine.canUseWebAudio&&(this._webAudioAnalyser.smoothingTimeConstant=this.SMOOTHING,this._webAudioAnalyser.fftSize=this.FFT_SIZE,this._webAudioAnalyser.getByteFrequencyData(this._byteFreqs)),this._byteFreqs},e.prototype.getByteTimeDomainData=function(){return this._audioEngine.canUseWebAudio&&(this._webAudioAnalyser.smoothingTimeConstant=this.SMOOTHING,this._webAudioAnalyser.fftSize=this.FFT_SIZE,this._webAudioAnalyser.getByteTimeDomainData(this._byteTime)),this._byteTime},e.prototype.getFloatFrequencyData=function(){return this._audioEngine.canUseWebAudio&&(this._webAudioAnalyser.smoothingTimeConstant=this.SMOOTHING,this._webAudioAnalyser.fftSize=this.FFT_SIZE,this._webAudioAnalyser.getFloatFrequencyData(this._floatFreqs)),this._floatFreqs},e.prototype.drawDebugCanvas=function(){var e=this;if(this._audioEngine.canUseWebAudio&&(this._debugCanvas||(this._debugCanvas=document.createElement("canvas"),this._debugCanvas.width=this.DEBUGCANVASSIZE.width,this._debugCanvas.height=this.DEBUGCANVASSIZE.height,this._debugCanvas.style.position="absolute",this._debugCanvas.style.top=this.DEBUGCANVASPOS.y+"px",this._debugCanvas.style.left=this.DEBUGCANVASPOS.x+"px",this._debugCanvasContext=this._debugCanvas.getContext("2d"),document.body.appendChild(this._debugCanvas),this._registerFunc=function(){e.drawDebugCanvas()},this._scene.registerBeforeRender(this._registerFunc)),this._registerFunc&&this._debugCanvasContext)){var t=this.getByteFrequencyData();this._debugCanvasContext.fillStyle="rgb(0, 0, 0)",this._debugCanvasContext.fillRect(0,0,this.DEBUGCANVASSIZE.width,this.DEBUGCANVASSIZE.height);for(var i=0;i<this.getFrequencyBinCount();i++){var n=t[i]/this.BARGRAPHAMPLITUDE,r=this.DEBUGCANVASSIZE.height*n,o=this.DEBUGCANVASSIZE.height-r-1,a=this.DEBUGCANVASSIZE.width/this.getFrequencyBinCount(),s=i/this.getFrequencyBinCount()*360;this._debugCanvasContext.fillStyle="hsl("+s+", 100%, 50%)",this._debugCanvasContext.fillRect(i*a,o,a,r)}}},e.prototype.stopDebugCanvas=function(){this._debugCanvas&&(this._registerFunc&&(this._scene.unregisterBeforeRender(this._registerFunc),this._registerFunc=null),document.body.removeChild(this._debugCanvas),this._debugCanvas=null,this._debugCanvasContext=null)},e.prototype.connectAudioNodes=function(e,t){this._audioEngine.canUseWebAudio&&(e.connect(this._webAudioAnalyser),this._webAudioAnalyser.connect(t))},e.prototype.dispose=function(){this._audioEngine.canUseWebAudio&&this._webAudioAnalyser.disconnect()},e}();Oe.a.AudioEngineFactory=function(e){return new Ie(e)};var Ie=function(){function e(e){var t=this;void 0===e&&(e=null),this._audioContext=null,this._audioContextInitialized=!1,this._muteButton=null,this.canUseWebAudio=!1,this.WarnedWebAudioUnsupported=!1,this.isMP3supported=!1,this.isOGGsupported=!1,this.unlocked=!0,this.useCustomUnlockedButton=!1,this.onAudioUnlockedObservable=new o.c,this.onAudioLockedObservable=new o.c,this._tryToRun=!1,this._onResize=function(){t._moveButtonToTopLeft()},void 0===window.AudioContext&&void 0===window.webkitAudioContext||(window.AudioContext=window.AudioContext||window.webkitAudioContext,this.canUseWebAudio=!0);var i=document.createElement("audio");this._hostElement=e;try{i&&i.canPlayType&&i.canPlayType('audio/mpeg; codecs="mp3"').replace(/^no$/,"")&&(this.isMP3supported=!0)}catch(e){}try{i&&i.canPlayType&&i.canPlayType('audio/ogg; codecs="vorbis"').replace(/^no$/,"")&&(this.isOGGsupported=!0)}catch(e){}}return Object.defineProperty(e.prototype,"audioContext",{get:function(){return this._audioContextInitialized?this.unlocked||this._muteButton||this._displayMuteButton():this._initializeAudioContext(),this._audioContext},enumerable:!0,configurable:!0}),e.prototype.lock=function(){this._triggerSuspendedState()},e.prototype.unlock=function(){this._triggerRunningState()},e.prototype._resumeAudioContext=function(){var e;return this._audioContext.resume&&(e=this._audioContext.resume()),e||Promise.resolve()},e.prototype._initializeAudioContext=function(){try{this.canUseWebAudio&&(this._audioContext=new AudioContext,this.masterGain=this._audioContext.createGain(),this.masterGain.gain.value=1,this.masterGain.connect(this._audioContext.destination),this._audioContextInitialized=!0,"running"===this._audioContext.state&&this._triggerRunningState())}catch(e){this.canUseWebAudio=!1,m.a.Error("Web Audio: "+e.message)}},e.prototype._triggerRunningState=function(){var e=this;this._tryToRun||(this._tryToRun=!0,this._resumeAudioContext().then(function(){e._tryToRun=!1,e._muteButton&&e._hideMuteButton()}).catch(function(){e._tryToRun=!1,e.unlocked=!1}),this.unlocked=!0,this.onAudioUnlockedObservable.notifyObservers(this))},e.prototype._triggerSuspendedState=function(){this.unlocked=!1,this.onAudioLockedObservable.notifyObservers(this),this._displayMuteButton()},e.prototype._displayMuteButton=function(){var e=this;if(!this.useCustomUnlockedButton&&!this._muteButton){this._muteButton=document.createElement("BUTTON"),this._muteButton.className="babylonUnmuteIcon",this._muteButton.id="babylonUnmuteIconBtn",this._muteButton.title="Unmute";var t=".babylonUnmuteIcon { position: absolute; left: 20px; top: 20px; height: 40px; width: 60px; background-color: rgba(51,51,51,0.7); background-image: url("+(window.SVGSVGElement?"data:image/svg+xml;charset=UTF-8,%3Csvg%20version%3D%221.1%22%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2239%22%20height%3D%2232%22%20viewBox%3D%220%200%2039%2032%22%3E%3Cpath%20fill%3D%22white%22%20d%3D%22M9.625%2018.938l-0.031%200.016h-4.953q-0.016%200-0.031-0.016v-12.453q0-0.016%200.031-0.016h4.953q0.031%200%200.031%200.016v12.453zM12.125%207.688l8.719-8.703v27.453l-8.719-8.719-0.016-0.047v-9.938zM23.359%207.875l1.406-1.406%204.219%204.203%204.203-4.203%201.422%201.406-4.219%204.219%204.219%204.203-1.484%201.359-4.141-4.156-4.219%204.219-1.406-1.422%204.219-4.203z%22%3E%3C%2Fpath%3E%3C%2Fsvg%3E":"https://cdn.babylonjs.com/Assets/audio.png")+");  background-size: 80%; background-repeat:no-repeat; background-position: center; background-position-y: 4px; border: none; outline: none; transition: transform 0.125s ease-out; cursor: pointer; z-index: 9999; } .babylonUnmuteIcon:hover { transform: scale(1.05) } .babylonUnmuteIcon:active { background-color: rgba(51,51,51,1) }",i=document.createElement("style");i.appendChild(document.createTextNode(t)),document.getElementsByTagName("head")[0].appendChild(i),document.body.appendChild(this._muteButton),this._moveButtonToTopLeft(),this._muteButton.addEventListener("touchend",function(){e._triggerRunningState()},!0),this._muteButton.addEventListener("click",function(){e._triggerRunningState()},!0),window.addEventListener("resize",this._onResize)}},e.prototype._moveButtonToTopLeft=function(){this._hostElement&&this._muteButton&&(this._muteButton.style.top=this._hostElement.offsetTop+20+"px",this._muteButton.style.left=this._hostElement.offsetLeft+20+"px")},e.prototype._hideMuteButton=function(){this._muteButton&&(document.body.removeChild(this._muteButton),this._muteButton=null)},e.prototype.dispose=function(){this.canUseWebAudio&&this._audioContextInitialized&&(this._connectedAnalyser&&this._audioContext&&(this._connectedAnalyser.stopDebugCanvas(),this._connectedAnalyser.dispose(),this.masterGain.disconnect(),this.masterGain.connect(this._audioContext.destination),this._connectedAnalyser=null),this.masterGain.gain.value=1),this.WarnedWebAudioUnsupported=!1,this._hideMuteButton(),window.removeEventListener("resize",this._onResize),this.onAudioUnlockedObservable.clear(),this.onAudioLockedObservable.clear()},e.prototype.getGlobalVolume=function(){return this.canUseWebAudio&&this._audioContextInitialized?this.masterGain.gain.value:-1},e.prototype.setGlobalVolume=function(e){this.canUseWebAudio&&this._audioContextInitialized&&(this.masterGain.gain.value=e)},e.prototype.connectToAnalyser=function(e){this._connectedAnalyser&&this._connectedAnalyser.stopDebugCanvas(),this.canUseWebAudio&&this._audioContextInitialized&&this._audioContext&&(this._connectedAnalyser=e,this.masterGain.disconnect(),this._connectedAnalyser.connectAudioNodes(this.masterGain,this._audioContext.destination))},e}(),De=i(13),we=i(19),Le=function(){function e(t,i,n,r,s){var c=this;if(void 0===r&&(r=null),this.autoplay=!1,this.loop=!1,this.useCustomAttenuation=!1,this.isPlaying=!1,this.isPaused=!1,this.spatialSound=!1,this.refDistance=1,this.rolloffFactor=1,this.maxDistance=100,this.distanceModel="linear",this.onEndedObservable=new o.c,this._panningModel="equalpower",this._playbackRate=1,this._streaming=!1,this._startTime=0,this._startOffset=0,this._position=a.e.Zero(),this._positionInEmitterSpace=!1,this._localDirection=new a.e(1,0,0),this._volume=1,this._isReadyToPlay=!1,this._isDirectional=!1,this._coneInnerAngle=360,this._coneOuterAngle=360,this._coneOuterGain=0,this._isOutputConnected=!1,this._urlType="Unknown",this.name=t,this._scene=n,e._SceneComponentInitialization(n),this._readyToPlayCallback=r,this._customAttenuationFunction=function(e,t,i,n,r){return t<i?e*(1-t/i):0},s&&(this.autoplay=s.autoplay||!1,this.loop=s.loop||!1,void 0!==s.volume&&(this._volume=s.volume),this.spatialSound=s.spatialSound||!1,this.maxDistance=s.maxDistance||100,this.useCustomAttenuation=s.useCustomAttenuation||!1,this.rolloffFactor=s.rolloffFactor||1,this.refDistance=s.refDistance||1,this.distanceModel=s.distanceModel||"linear",this._playbackRate=s.playbackRate||1,this._streaming=s.streaming||!1,this._length=s.length,this._offset=s.offset),Oe.a.audioEngine.canUseWebAudio&&Oe.a.audioEngine.audioContext){this._soundGain=Oe.a.audioEngine.audioContext.createGain(),this._soundGain.gain.value=this._volume,this._inputAudioNode=this._soundGain,this._outputAudioNode=this._soundGain,this.spatialSound&&this._createSpatialParameters(),this._scene.mainSoundTrack.AddSound(this);var l=!0;if(i)try{"string"==typeof i?this._urlType="String":i instanceof ArrayBuffer?this._urlType="ArrayBuffer":i instanceof MediaStream?this._urlType="MediaStream":Array.isArray(i)&&(this._urlType="Array");var u=[],h=!1;switch(this._urlType){case"MediaStream":this._streaming=!0,this._isReadyToPlay=!0,this._streamingSource=Oe.a.audioEngine.audioContext.createMediaStreamSource(i),this.autoplay&&this.play(0,this._offset,this._length),this._readyToPlayCallback&&this._readyToPlayCallback();break;case"ArrayBuffer":i.byteLength>0&&(h=!0,this._soundLoaded(i));break;case"String":u.push(i);case"Array":0===u.length&&(u=i);for(var d=0;d<u.length;d++){var f=u[d];if(h=s&&s.skipCodecCheck||-1!==f.indexOf(".mp3",f.length-4)&&Oe.a.audioEngine.isMP3supported||-1!==f.indexOf(".ogg",f.length-4)&&Oe.a.audioEngine.isOGGsupported||-1!==f.indexOf(".wav",f.length-4)||-1!==f.indexOf("blob:")){this._streaming?(this._htmlAudioElement=new Audio(f),this._htmlAudioElement.controls=!1,this._htmlAudioElement.loop=this.loop,De.b.SetCorsBehavior(f,this._htmlAudioElement),this._htmlAudioElement.preload="auto",this._htmlAudioElement.addEventListener("canplaythrough",function(){c._isReadyToPlay=!0,c.autoplay&&c.play(0,c._offset,c._length),c._readyToPlayCallback&&c._readyToPlayCallback()}),document.body.appendChild(this._htmlAudioElement),this._htmlAudioElement.load()):this._scene._loadFile(f,function(e){c._soundLoaded(e)},void 0,!0,!0,function(e){e&&m.a.Error("XHR "+e.status+" error on: "+f+"."),m.a.Error("Sound creation aborted."),c._scene.mainSoundTrack.RemoveSound(c)});break}}break;default:l=!1}l?h||(this._isReadyToPlay=!0,this._readyToPlayCallback&&window.setTimeout(function(){c._readyToPlayCallback&&c._readyToPlayCallback()},1e3)):m.a.Error("Parameter must be a URL to the sound, an Array of URLs (.mp3 & .ogg) or an ArrayBuffer of the sound.")}catch(e){m.a.Error("Unexpected error. Sound creation aborted."),this._scene.mainSoundTrack.RemoveSound(this)}}else this._scene.mainSoundTrack.AddSound(this),Oe.a.audioEngine.WarnedWebAudioUnsupported||(m.a.Error("Web Audio is not supported by your browser."),Oe.a.audioEngine.WarnedWebAudioUnsupported=!0),this._readyToPlayCallback&&window.setTimeout(function(){c._readyToPlayCallback&&c._readyToPlayCallback()},1e3)}return e.prototype.dispose=function(){Oe.a.audioEngine.canUseWebAudio&&(this.isPlaying&&this.stop(),this._isReadyToPlay=!1,-1===this.soundTrackId?this._scene.mainSoundTrack.RemoveSound(this):this._scene.soundTracks&&this._scene.soundTracks[this.soundTrackId].RemoveSound(this),this._soundGain&&(this._soundGain.disconnect(),this._soundGain=null),this._soundPanner&&(this._soundPanner.disconnect(),this._soundPanner=null),this._soundSource&&(this._soundSource.disconnect(),this._soundSource=null),this._audioBuffer=null,this._htmlAudioElement&&(this._htmlAudioElement.pause(),this._htmlAudioElement.src="",document.body.removeChild(this._htmlAudioElement)),this._streamingSource&&this._streamingSource.disconnect(),this._connectedTransformNode&&this._registerFunc&&(this._connectedTransformNode.unregisterAfterWorldMatrixUpdate(this._registerFunc),this._connectedTransformNode=null))},e.prototype.isReady=function(){return this._isReadyToPlay},e.prototype._soundLoaded=function(e){var t=this;Oe.a.audioEngine.audioContext&&Oe.a.audioEngine.audioContext.decodeAudioData(e,function(e){t._audioBuffer=e,t._isReadyToPlay=!0,t.autoplay&&t.play(0,t._offset,t._length),t._readyToPlayCallback&&t._readyToPlayCallback()},function(e){m.a.Error("Error while decoding audio data for: "+t.name+" / Error: "+e)})},e.prototype.setAudioBuffer=function(e){Oe.a.audioEngine.canUseWebAudio&&(this._audioBuffer=e,this._isReadyToPlay=!0)},e.prototype.updateOptions=function(e){e&&(this.loop=e.loop||this.loop,this.maxDistance=e.maxDistance||this.maxDistance,this.useCustomAttenuation=e.useCustomAttenuation||this.useCustomAttenuation,this.rolloffFactor=e.rolloffFactor||this.rolloffFactor,this.refDistance=e.refDistance||this.refDistance,this.distanceModel=e.distanceModel||this.distanceModel,this._playbackRate=e.playbackRate||this._playbackRate,this._length=e.length?e.length/1e3:void 0,this._offset=e.offset?e.offset/1e3:void 0,this._updateSpatialParameters(),this.isPlaying&&(this._streaming&&this._htmlAudioElement?this._htmlAudioElement.playbackRate=this._playbackRate:this._soundSource&&(this._soundSource.playbackRate.value=this._playbackRate)))},e.prototype._createSpatialParameters=function(){Oe.a.audioEngine.canUseWebAudio&&Oe.a.audioEngine.audioContext&&(this._scene.headphone&&(this._panningModel="HRTF"),this._soundPanner=Oe.a.audioEngine.audioContext.createPanner(),this._updateSpatialParameters(),this._soundPanner.connect(this._outputAudioNode),this._inputAudioNode=this._soundPanner)},e.prototype._updateSpatialParameters=function(){this.spatialSound&&this._soundPanner&&(this.useCustomAttenuation?(this._soundPanner.distanceModel="linear",this._soundPanner.maxDistance=Number.MAX_VALUE,this._soundPanner.refDistance=1,this._soundPanner.rolloffFactor=1,this._soundPanner.panningModel=this._panningModel):(this._soundPanner.distanceModel=this.distanceModel,this._soundPanner.maxDistance=this.maxDistance,this._soundPanner.refDistance=this.refDistance,this._soundPanner.rolloffFactor=this.rolloffFactor,this._soundPanner.panningModel=this._panningModel))},e.prototype.switchPanningModelToHRTF=function(){this._panningModel="HRTF",this._switchPanningModel()},e.prototype.switchPanningModelToEqualPower=function(){this._panningModel="equalpower",this._switchPanningModel()},e.prototype._switchPanningModel=function(){Oe.a.audioEngine.canUseWebAudio&&this.spatialSound&&this._soundPanner&&(this._soundPanner.panningModel=this._panningModel)},e.prototype.connectToSoundTrackAudioNode=function(e){Oe.a.audioEngine.canUseWebAudio&&(this._isOutputConnected&&this._outputAudioNode.disconnect(),this._outputAudioNode.connect(e),this._isOutputConnected=!0)},e.prototype.setDirectionalCone=function(e,t,i){t<e?m.a.Error("setDirectionalCone(): outer angle of the cone must be superior or equal to the inner angle."):(this._coneInnerAngle=e,this._coneOuterAngle=t,this._coneOuterGain=i,this._isDirectional=!0,this.isPlaying&&this.loop&&(this.stop(),this.play(0,this._offset,this._length)))},Object.defineProperty(e.prototype,"directionalConeInnerAngle",{get:function(){return this._coneInnerAngle},set:function(e){if(e!=this._coneInnerAngle){if(this._coneOuterAngle<e)return void m.a.Error("directionalConeInnerAngle: outer angle of the cone must be superior or equal to the inner angle.");this._coneInnerAngle=e,Oe.a.audioEngine.canUseWebAudio&&this.spatialSound&&this._soundPanner&&(this._soundPanner.coneInnerAngle=this._coneInnerAngle)}},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"directionalConeOuterAngle",{get:function(){return this._coneOuterAngle},set:function(e){if(e!=this._coneOuterAngle){if(e<this._coneInnerAngle)return void m.a.Error("directionalConeOuterAngle: outer angle of the cone must be superior or equal to the inner angle.");this._coneOuterAngle=e,Oe.a.audioEngine.canUseWebAudio&&this.spatialSound&&this._soundPanner&&(this._soundPanner.coneOuterAngle=this._coneOuterAngle)}},enumerable:!0,configurable:!0}),e.prototype.setPosition=function(e){this._position=e,Oe.a.audioEngine.canUseWebAudio&&this.spatialSound&&this._soundPanner&&!isNaN(this._position.x)&&!isNaN(this._position.y)&&!isNaN(this._position.z)&&this._soundPanner.setPosition(this._position.x,this._position.y,this._position.z)},e.prototype.setLocalDirectionToMesh=function(e){this._localDirection=e,Oe.a.audioEngine.canUseWebAudio&&this._connectedTransformNode&&this.isPlaying&&this._updateDirection()},e.prototype._updateDirection=function(){if(this._connectedTransformNode&&this._soundPanner){var e=this._connectedTransformNode.getWorldMatrix(),t=a.e.TransformNormal(this._localDirection,e);t.normalize(),this._soundPanner.setOrientation(t.x,t.y,t.z)}},e.prototype.updateDistanceFromListener=function(){if(Oe.a.audioEngine.canUseWebAudio&&this._connectedTransformNode&&this.useCustomAttenuation&&this._soundGain&&this._scene.activeCamera){var e=this._connectedTransformNode.getDistanceToCamera(this._scene.activeCamera);this._soundGain.gain.value=this._customAttenuationFunction(this._volume,e,this.maxDistance,this.refDistance,this.rolloffFactor)}},e.prototype.setAttenuationFunction=function(e){this._customAttenuationFunction=e},e.prototype.play=function(e,t,i){var n=this;if(this._isReadyToPlay&&this._scene.audioEnabled&&Oe.a.audioEngine.audioContext)try{this._startOffset<0&&(e=-this._startOffset,this._startOffset=0);var r=e?Oe.a.audioEngine.audioContext.currentTime+e:Oe.a.audioEngine.audioContext.currentTime;if(this._soundSource&&this._streamingSource||this.spatialSound&&this._soundPanner&&(isNaN(this._position.x)||isNaN(this._position.y)||isNaN(this._position.z)||this._soundPanner.setPosition(this._position.x,this._position.y,this._position.z),this._isDirectional&&(this._soundPanner.coneInnerAngle=this._coneInnerAngle,this._soundPanner.coneOuterAngle=this._coneOuterAngle,this._soundPanner.coneOuterGain=this._coneOuterGain,this._connectedTransformNode?this._updateDirection():this._soundPanner.setOrientation(this._localDirection.x,this._localDirection.y,this._localDirection.z))),this._streaming){if(this._streamingSource||(this._streamingSource=Oe.a.audioEngine.audioContext.createMediaElementSource(this._htmlAudioElement),this._htmlAudioElement.onended=function(){n._onended()},this._htmlAudioElement.playbackRate=this._playbackRate),this._streamingSource.disconnect(),this._streamingSource.connect(this._inputAudioNode),this._htmlAudioElement)(o=function(){if(Oe.a.audioEngine.unlocked){var e=n._htmlAudioElement.play();void 0!==e&&e.catch(function(e){Oe.a.audioEngine.lock(),(n.loop||n.autoplay)&&Oe.a.audioEngine.onAudioUnlockedObservable.addOnce(function(){o()})})}else(n.loop||n.autoplay)&&Oe.a.audioEngine.onAudioUnlockedObservable.addOnce(function(){o()})})()}else{var o=function(){if(Oe.a.audioEngine.audioContext){i=i||n._length,t=t||n._offset,n._soundSource=Oe.a.audioEngine.audioContext.createBufferSource(),n._soundSource.buffer=n._audioBuffer,n._soundSource.connect(n._inputAudioNode),n._soundSource.loop=n.loop,void 0!==t&&(n._soundSource.loopStart=t),void 0!==i&&(n._soundSource.loopEnd=(0|t)+i),n._soundSource.playbackRate.value=n._playbackRate,n._soundSource.onended=function(){n._onended()},r=e?Oe.a.audioEngine.audioContext.currentTime+e:Oe.a.audioEngine.audioContext.currentTime;var o=n.isPaused?n._startOffset%n._soundSource.buffer.duration:t||0;n._soundSource.start(r,o,n.loop?void 0:i)}};"suspended"===Oe.a.audioEngine.audioContext.state?setTimeout(function(){"suspended"===Oe.a.audioEngine.audioContext.state?(Oe.a.audioEngine.lock(),(n.loop||n.autoplay)&&Oe.a.audioEngine.onAudioUnlockedObservable.addOnce(function(){o()})):o()},500):o()}this._startTime=r,this.isPlaying=!0,this.isPaused=!1}catch(e){m.a.Error("Error while trying to play audio: "+this.name+", "+e.message)}},e.prototype._onended=function(){this.isPlaying=!1,this.onended&&this.onended(),this.onEndedObservable.notifyObservers(this)},e.prototype.stop=function(e){var t=this;if(this.isPlaying)if(this._streaming)this._htmlAudioElement?(this._htmlAudioElement.pause(),this._htmlAudioElement.currentTime>0&&(this._htmlAudioElement.currentTime=0)):this._streamingSource.disconnect(),this.isPlaying=!1;else if(Oe.a.audioEngine.audioContext&&this._soundSource){var i=e?Oe.a.audioEngine.audioContext.currentTime+e:Oe.a.audioEngine.audioContext.currentTime;this._soundSource.stop(i),this._soundSource.onended=function(){t.isPlaying=!1},this.isPaused||(this._startOffset=0)}},e.prototype.pause=function(){this.isPlaying&&(this.isPaused=!0,this._streaming?this._htmlAudioElement?this._htmlAudioElement.pause():this._streamingSource.disconnect():Oe.a.audioEngine.audioContext&&(this.stop(0),this._startOffset+=Oe.a.audioEngine.audioContext.currentTime-this._startTime))},e.prototype.setVolume=function(e,t){Oe.a.audioEngine.canUseWebAudio&&this._soundGain&&(t&&Oe.a.audioEngine.audioContext?(this._soundGain.gain.cancelScheduledValues(Oe.a.audioEngine.audioContext.currentTime),this._soundGain.gain.setValueAtTime(this._soundGain.gain.value,Oe.a.audioEngine.audioContext.currentTime),this._soundGain.gain.linearRampToValueAtTime(e,Oe.a.audioEngine.audioContext.currentTime+t)):this._soundGain.gain.value=e),this._volume=e},e.prototype.setPlaybackRate=function(e){this._playbackRate=e,this.isPlaying&&(this._streaming&&this._htmlAudioElement?this._htmlAudioElement.playbackRate=this._playbackRate:this._soundSource&&(this._soundSource.playbackRate.value=this._playbackRate))},e.prototype.getVolume=function(){return this._volume},e.prototype.attachToMesh=function(e){var t=this;this._connectedTransformNode&&this._registerFunc&&(this._connectedTransformNode.unregisterAfterWorldMatrixUpdate(this._registerFunc),this._registerFunc=null),this._connectedTransformNode=e,this.spatialSound||(this.spatialSound=!0,this._createSpatialParameters(),this.isPlaying&&this.loop&&(this.stop(),this.play(0,this._offset,this._length))),this._onRegisterAfterWorldMatrixUpdate(this._connectedTransformNode),this._registerFunc=function(e){return t._onRegisterAfterWorldMatrixUpdate(e)},this._connectedTransformNode.registerAfterWorldMatrixUpdate(this._registerFunc)},e.prototype.detachFromMesh=function(){this._connectedTransformNode&&this._registerFunc&&(this._connectedTransformNode.unregisterAfterWorldMatrixUpdate(this._registerFunc),this._registerFunc=null,this._connectedTransformNode=null)},e.prototype._onRegisterAfterWorldMatrixUpdate=function(e){if(e.getBoundingInfo){var t=e;if(this._positionInEmitterSpace)t.worldMatrixFromCache.invertToRef(a.c.Matrix[0]),this.setPosition(a.c.Matrix[0].getTranslation());else{var i=t.getBoundingInfo();this.setPosition(i.boundingSphere.centerWorld)}Oe.a.audioEngine.canUseWebAudio&&this._isDirectional&&this.isPlaying&&this._updateDirection()}},e.prototype.clone=function(){var t=this;if(this._streaming)return null;var i=function(){t._isReadyToPlay?(r._audioBuffer=t.getAudioBuffer(),r._isReadyToPlay=!0,r.autoplay&&r.play(0,t._offset,t._length)):window.setTimeout(i,300)},n={autoplay:this.autoplay,loop:this.loop,volume:this._volume,spatialSound:this.spatialSound,maxDistance:this.maxDistance,useCustomAttenuation:this.useCustomAttenuation,rolloffFactor:this.rolloffFactor,refDistance:this.refDistance,distanceModel:this.distanceModel},r=new e(this.name+"_cloned",new ArrayBuffer(0),this._scene,null,n);return this.useCustomAttenuation&&r.setAttenuationFunction(this._customAttenuationFunction),r.setPosition(this._position),r.setPlaybackRate(this._playbackRate),i(),r},e.prototype.getAudioBuffer=function(){return this._audioBuffer},e.prototype.serialize=function(){var e={name:this.name,url:this.name,autoplay:this.autoplay,loop:this.loop,volume:this._volume,spatialSound:this.spatialSound,maxDistance:this.maxDistance,rolloffFactor:this.rolloffFactor,refDistance:this.refDistance,distanceModel:this.distanceModel,playbackRate:this._playbackRate,panningModel:this._panningModel,soundTrackId:this.soundTrackId};return this.spatialSound&&(this._connectedTransformNode&&(e.connectedMeshId=this._connectedTransformNode.id),e.position=this._position.asArray(),e.refDistance=this.refDistance,e.distanceModel=this.distanceModel,e.isDirectional=this._isDirectional,e.localDirectionToMesh=this._localDirection.asArray(),e.coneInnerAngle=this._coneInnerAngle,e.coneOuterAngle=this._coneOuterAngle,e.coneOuterGain=this._coneOuterGain),e},e.Parse=function(t,i,n,r){var o,s=t.name;o=t.url?n+t.url:n+s;var c,l={autoplay:t.autoplay,loop:t.loop,volume:t.volume,spatialSound:t.spatialSound,maxDistance:t.maxDistance,rolloffFactor:t.rolloffFactor,refDistance:t.refDistance,distanceModel:t.distanceModel,playbackRate:t.playbackRate};if(r){var u=function(){r._isReadyToPlay?(c._audioBuffer=r.getAudioBuffer(),c._isReadyToPlay=!0,c.autoplay&&c.play(0,c._offset,c._length)):window.setTimeout(u,300)};c=new e(s,new ArrayBuffer(0),i,null,l),u()}else c=new e(s,o,i,function(){i._removePendingData(c)},l),i._addPendingData(c);if(t.position){var h=a.e.FromArray(t.position);c.setPosition(h)}if(t.isDirectional&&(c.setDirectionalCone(t.coneInnerAngle||360,t.coneOuterAngle||360,t.coneOuterGain||0),t.localDirectionToMesh)){var d=a.e.FromArray(t.localDirectionToMesh);c.setLocalDirectionToMesh(d)}if(t.connectedMeshId){var f=i.getMeshByID(t.connectedMeshId);f&&c.attachToMesh(f)}return c},e._SceneComponentInitialization=function(e){throw we.a.WarnImport("AudioSceneComponent")},e}(),Ne=function(){function e(e,t){void 0===t&&(t={}),this.id=-1,this._isInitialized=!1,this._scene=e,this.soundCollection=new Array,this._options=t,!this._options.mainTrack&&this._scene.soundTracks&&(this._scene.soundTracks.push(this),this.id=this._scene.soundTracks.length-1)}return e.prototype._initializeSoundTrackAudioGraph=function(){Oe.a.audioEngine.canUseWebAudio&&Oe.a.audioEngine.audioContext&&(this._outputAudioNode=Oe.a.audioEngine.audioContext.createGain(),this._outputAudioNode.connect(Oe.a.audioEngine.masterGain),this._options&&this._options.volume&&(this._outputAudioNode.gain.value=this._options.volume),this._isInitialized=!0)},e.prototype.dispose=function(){if(Oe.a.audioEngine&&Oe.a.audioEngine.canUseWebAudio){for(this._connectedAnalyser&&this._connectedAnalyser.stopDebugCanvas();this.soundCollection.length;)this.soundCollection[0].dispose();this._outputAudioNode&&this._outputAudioNode.disconnect(),this._outputAudioNode=null}},e.prototype.AddSound=function(e){this._isInitialized||this._initializeSoundTrackAudioGraph(),Oe.a.audioEngine.canUseWebAudio&&this._outputAudioNode&&e.connectToSoundTrackAudioNode(this._outputAudioNode),e.soundTrackId&&(-1===e.soundTrackId?this._scene.mainSoundTrack.RemoveSound(e):this._scene.soundTracks&&this._scene.soundTracks[e.soundTrackId].RemoveSound(e)),this.soundCollection.push(e),e.soundTrackId=this.id},e.prototype.RemoveSound=function(e){var t=this.soundCollection.indexOf(e);-1!==t&&this.soundCollection.splice(t,1)},e.prototype.setVolume=function(e){Oe.a.audioEngine.canUseWebAudio&&this._outputAudioNode&&(this._outputAudioNode.gain.value=e)},e.prototype.switchPanningModelToHRTF=function(){if(Oe.a.audioEngine.canUseWebAudio)for(var e=0;e<this.soundCollection.length;e++)this.soundCollection[e].switchPanningModelToHRTF()},e.prototype.switchPanningModelToEqualPower=function(){if(Oe.a.audioEngine.canUseWebAudio)for(var e=0;e<this.soundCollection.length;e++)this.soundCollection[e].switchPanningModelToEqualPower()},e.prototype.connectToAnalyser=function(e){this._connectedAnalyser&&this._connectedAnalyser.stopDebugCanvas(),this._connectedAnalyser=e,Oe.a.audioEngine.canUseWebAudio&&this._outputAudioNode&&(this._outputAudioNode.disconnect(),this._connectedAnalyser.connectAudioNodes(this._outputAudioNode,Oe.a.audioEngine.masterGain))},e}(),Fe=i(17);n.a.AddParser(Fe.a.NAME_AUDIO,function(e,t,i,n){var r,o=[];if(i.sounds=i.sounds||[],void 0!==e.sounds&&null!==e.sounds)for(var a=0,s=e.sounds.length;a<s;a++){var c=e.sounds[a];Oe.a.audioEngine.canUseWebAudio?(c.url||(c.url=c.name),o[c.url]?i.sounds.push(Le.Parse(c,t,n,o[c.url])):(r=Le.Parse(c,t,n),o[c.url]=r,i.sounds.push(r))):i.sounds.push(new Le(c.name,null,t))}o=[]}),Object.defineProperty(K.a.prototype,"mainSoundTrack",{get:function(){var e=this._getComponent(Fe.a.NAME_AUDIO);return e||(e=new Be(this),this._addComponent(e)),this._mainSoundTrack||(this._mainSoundTrack=new Ne(this,{mainTrack:!0})),this._mainSoundTrack},enumerable:!0,configurable:!0}),K.a.prototype.getSoundByName=function(e){var t;for(t=0;t<this.mainSoundTrack.soundCollection.length;t++)if(this.mainSoundTrack.soundCollection[t].name===e)return this.mainSoundTrack.soundCollection[t];if(this.soundTracks)for(var i=0;i<this.soundTracks.length;i++)for(t=0;t<this.soundTracks[i].soundCollection.length;t++)if(this.soundTracks[i].soundCollection[t].name===e)return this.soundTracks[i].soundCollection[t];return null},Object.defineProperty(K.a.prototype,"audioEnabled",{get:function(){var e=this._getComponent(Fe.a.NAME_AUDIO);return e||(e=new Be(this),this._addComponent(e)),e.audioEnabled},set:function(e){var t=this._getComponent(Fe.a.NAME_AUDIO);t||(t=new Be(this),this._addComponent(t)),e?t.enableAudio():t.disableAudio()},enumerable:!0,configurable:!0}),Object.defineProperty(K.a.prototype,"headphone",{get:function(){var e=this._getComponent(Fe.a.NAME_AUDIO);return e||(e=new Be(this),this._addComponent(e)),e.headphone},set:function(e){var t=this._getComponent(Fe.a.NAME_AUDIO);t||(t=new Be(this),this._addComponent(t)),e?t.switchAudioModeForHeadphones():t.switchAudioModeForNormalSpeakers()},enumerable:!0,configurable:!0}),Object.defineProperty(K.a.prototype,"audioListenerPositionProvider",{get:function(){var e=this._getComponent(Fe.a.NAME_AUDIO);return e||(e=new Be(this),this._addComponent(e)),e.audioListenerPositionProvider},set:function(e){var t=this._getComponent(Fe.a.NAME_AUDIO);if(t||(t=new Be(this),this._addComponent(t)),"function"!=typeof e)throw new Error("The value passed to [Scene.audioListenerPositionProvider] must be a function that returns a Vector3");t.audioListenerPositionProvider=e},enumerable:!0,configurable:!0}),Object.defineProperty(K.a.prototype,"audioPositioningRefreshRate",{get:function(){var e=this._getComponent(Fe.a.NAME_AUDIO);return e||(e=new Be(this),this._addComponent(e)),e.audioPositioningRefreshRate},set:function(e){var t=this._getComponent(Fe.a.NAME_AUDIO);t||(t=new Be(this),this._addComponent(t)),t.audioPositioningRefreshRate=e},enumerable:!0,configurable:!0});var Be=function(){function e(e){this.name=Fe.a.NAME_AUDIO,this._audioEnabled=!0,this._headphone=!1,this.audioPositioningRefreshRate=500,this._audioListenerPositionProvider=null,this._cachedCameraDirection=new a.e,this._cachedCameraPosition=new a.e,this._lastCheck=0,this.scene=e,e.soundTracks=new Array,e.sounds=new Array}return Object.defineProperty(e.prototype,"audioEnabled",{get:function(){return this._audioEnabled},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"headphone",{get:function(){return this._headphone},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"audioListenerPositionProvider",{get:function(){return this._audioListenerPositionProvider},set:function(e){this._audioListenerPositionProvider=e},enumerable:!0,configurable:!0}),e.prototype.register=function(){this.scene._afterRenderStage.registerStep(Fe.a.STEP_AFTERRENDER_AUDIO,this,this._afterRender)},e.prototype.rebuild=function(){},e.prototype.serialize=function(e){if(e.sounds=[],this.scene.soundTracks)for(var t=0;t<this.scene.soundTracks.length;t++)for(var i=this.scene.soundTracks[t],n=0;n<i.soundCollection.length;n++)e.sounds.push(i.soundCollection[n].serialize())},e.prototype.addFromContainer=function(e){var t=this;e.sounds&&e.sounds.forEach(function(e){e.play(),e.autoplay=!0,t.scene.mainSoundTrack.AddSound(e)})},e.prototype.removeFromContainer=function(e,t){var i=this;void 0===t&&(t=!1),e.sounds&&e.sounds.forEach(function(e){e.stop(),e.autoplay=!1,i.scene.mainSoundTrack.RemoveSound(e),t&&e.dispose()})},e.prototype.dispose=function(){var e=this.scene;if(e._mainSoundTrack&&e.mainSoundTrack.dispose(),e.soundTracks)for(var t=0;t<e.soundTracks.length;t++)e.soundTracks[t].dispose()},e.prototype.disableAudio=function(){var e,t=this.scene;for(this._audioEnabled=!1,Oe.a.audioEngine&&Oe.a.audioEngine.audioContext&&Oe.a.audioEngine.audioContext.suspend(),e=0;e<t.mainSoundTrack.soundCollection.length;e++)t.mainSoundTrack.soundCollection[e].pause();if(t.soundTracks)for(e=0;e<t.soundTracks.length;e++)for(var i=0;i<t.soundTracks[e].soundCollection.length;i++)t.soundTracks[e].soundCollection[i].pause()},e.prototype.enableAudio=function(){var e,t=this.scene;for(this._audioEnabled=!0,Oe.a.audioEngine&&Oe.a.audioEngine.audioContext&&Oe.a.audioEngine.audioContext.resume(),e=0;e<t.mainSoundTrack.soundCollection.length;e++)t.mainSoundTrack.soundCollection[e].isPaused&&t.mainSoundTrack.soundCollection[e].play();if(t.soundTracks)for(e=0;e<t.soundTracks.length;e++)for(var i=0;i<t.soundTracks[e].soundCollection.length;i++)t.soundTracks[e].soundCollection[i].isPaused&&t.soundTracks[e].soundCollection[i].play()},e.prototype.switchAudioModeForHeadphones=function(){var e=this.scene;if(this._headphone=!0,e.mainSoundTrack.switchPanningModelToHRTF(),e.soundTracks)for(var t=0;t<e.soundTracks.length;t++)e.soundTracks[t].switchPanningModelToHRTF()},e.prototype.switchAudioModeForNormalSpeakers=function(){var e=this.scene;if(this._headphone=!1,e.mainSoundTrack.switchPanningModelToEqualPower(),e.soundTracks)for(var t=0;t<e.soundTracks.length;t++)e.soundTracks[t].switchPanningModelToEqualPower()},e.prototype._afterRender=function(){var e=Q.a.Now;if(!(this._lastCheck&&e-this._lastCheck<this.audioPositioningRefreshRate)){this._lastCheck=e;var t=this.scene;if(this._audioEnabled&&t._mainSoundTrack&&t.soundTracks&&(0!==t._mainSoundTrack.soundCollection.length||1!==t.soundTracks.length)){var i=Oe.a.audioEngine;if(i.audioContext){if(this._audioListenerPositionProvider){var n=this._audioListenerPositionProvider();n.x=n.x||0,n.y=n.y||0,n.z=n.z||0,i.audioContext.listener.setPosition(n.x,n.y,n.z)}else{var r;if(r=t.activeCameras.length>0?t.activeCameras[0]:t.activeCamera){this._cachedCameraPosition.equals(r.globalPosition)||(this._cachedCameraPosition.copyFrom(r.globalPosition),i.audioContext.listener.setPosition(r.globalPosition.x,r.globalPosition.y,r.globalPosition.z)),r.rigCameras&&r.rigCameras.length>0&&(r=r.rigCameras[0]);var o=a.a.Invert(r.getViewMatrix()),s=a.e.TransformNormal(new a.e(0,0,-1),o);s.normalize(),isNaN(s.x)||isNaN(s.y)||isNaN(s.z)||this._cachedCameraDirection.equals(s)||(this._cachedCameraDirection.copyFrom(s),i.audioContext.listener.setOrientation(s.x,s.y,s.z,0,1,0))}else i.audioContext.listener.setPosition(0,0,0)}var c;for(c=0;c<t.mainSoundTrack.soundCollection.length;c++){var l=t.mainSoundTrack.soundCollection[c];l.useCustomAttenuation&&l.updateDistanceFromListener()}if(t.soundTracks)for(c=0;c<t.soundTracks.length;c++)for(var u=0;u<t.soundTracks[c].soundCollection.length;u++)(l=t.soundTracks[c].soundCollection[u]).useCustomAttenuation&&l.updateDistanceFromListener()}}}},e}();Le._SceneComponentInitialization=function(e){var t=e._getComponent(Fe.a.NAME_AUDIO);t||(t=new Be(e),e._addComponent(t))};var Ue=function(){function e(e,t,i){var n=this;if(this.loop=!1,this._coneInnerAngle=360,this._coneOuterAngle=360,this._volume=1,this.isPlaying=!1,this.isPaused=!1,this._sounds=[],this._weights=[],t.length!==i.length)throw new Error("Sounds length does not equal weights length");this.loop=e,this._weights=i;for(var r=0,o=0,a=i;o<a.length;o++){r+=a[o]}for(var s=r>0?1/r:0,c=0;c<this._weights.length;c++)this._weights[c]*=s;this._sounds=t;for(var l=0,u=this._sounds;l<u.length;l++){u[l].onEndedObservable.add(function(){n._onended()})}}return Object.defineProperty(e.prototype,"directionalConeInnerAngle",{get:function(){return this._coneInnerAngle},set:function(e){if(e!==this._coneInnerAngle){if(this._coneOuterAngle<e)return void m.a.Error("directionalConeInnerAngle: outer angle of the cone must be superior or equal to the inner angle.");this._coneInnerAngle=e;for(var t=0,i=this._sounds;t<i.length;t++){i[t].directionalConeInnerAngle=e}}},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"directionalConeOuterAngle",{get:function(){return this._coneOuterAngle},set:function(e){if(e!==this._coneOuterAngle){if(e<this._coneInnerAngle)return void m.a.Error("directionalConeOuterAngle: outer angle of the cone must be superior or equal to the inner angle.");this._coneOuterAngle=e;for(var t=0,i=this._sounds;t<i.length;t++){i[t].directionalConeOuterAngle=e}}},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"volume",{get:function(){return this._volume},set:function(e){if(e!==this._volume)for(var t=0,i=this._sounds;t<i.length;t++){i[t].setVolume(e)}},enumerable:!0,configurable:!0}),e.prototype._onended=function(){void 0!==this._currentIndex&&(this._sounds[this._currentIndex].autoplay=!1),this.loop&&this.isPlaying?this.play():this.isPlaying=!1},e.prototype.pause=function(){this.isPaused=!0,void 0!==this._currentIndex&&this._sounds[this._currentIndex].pause()},e.prototype.stop=function(){this.isPlaying=!1,void 0!==this._currentIndex&&this._sounds[this._currentIndex].stop()},e.prototype.play=function(e){if(!this.isPaused){this.stop();for(var t=Math.random(),i=0,n=0;n<this._weights.length;n++)if(t<=(i+=this._weights[n])){this._currentIndex=n;break}}var r=this._sounds[this._currentIndex];r.isReady()?r.play(0,this.isPaused?void 0:e):r.autoplay=!0,this.isPlaying=!0,this.isPaused=!1},e}(),Ve=i(20),ke=function(){function e(){this._zoomStopsAnimation=!1,this._idleRotationSpeed=.05,this._idleRotationWaitTime=2e3,this._idleRotationSpinupTime=2e3,this._isPointerDown=!1,this._lastFrameTime=null,this._lastInteractionTime=-1/0,this._cameraRotationSpeed=0,this._lastFrameRadius=0}return Object.defineProperty(e.prototype,"name",{get:function(){return"AutoRotation"},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"zoomStopsAnimation",{get:function(){return this._zoomStopsAnimation},set:function(e){this._zoomStopsAnimation=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"idleRotationSpeed",{get:function(){return this._idleRotationSpeed},set:function(e){this._idleRotationSpeed=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"idleRotationWaitTime",{get:function(){return this._idleRotationWaitTime},set:function(e){this._idleRotationWaitTime=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"idleRotationSpinupTime",{get:function(){return this._idleRotationSpinupTime},set:function(e){this._idleRotationSpinupTime=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"rotationInProgress",{get:function(){return Math.abs(this._cameraRotationSpeed)>0},enumerable:!0,configurable:!0}),e.prototype.init=function(){},e.prototype.attach=function(e){var t=this;this._attachedCamera=e;var i=this._attachedCamera.getScene();this._onPrePointerObservableObserver=i.onPrePointerObservable.add(function(e){e.type!==Ve.a.POINTERDOWN?e.type===Ve.a.POINTERUP&&(t._isPointerDown=!1):t._isPointerDown=!0}),this._onAfterCheckInputsObserver=e.onAfterCheckInputsObservable.add(function(){var e=Q.a.Now,i=0;null!=t._lastFrameTime&&(i=e-t._lastFrameTime),t._lastFrameTime=e,t._applyUserInteraction();var n=e-t._lastInteractionTime-t._idleRotationWaitTime,r=Math.max(Math.min(n/t._idleRotationSpinupTime,1),0);t._cameraRotationSpeed=t._idleRotationSpeed*r,t._attachedCamera&&(t._attachedCamera.alpha-=t._cameraRotationSpeed*(i/1e3))})},e.prototype.detach=function(){if(this._attachedCamera){var e=this._attachedCamera.getScene();this._onPrePointerObservableObserver&&e.onPrePointerObservable.remove(this._onPrePointerObservableObserver),this._attachedCamera.onAfterCheckInputsObservable.remove(this._onAfterCheckInputsObserver),this._attachedCamera=null}},e.prototype._userIsZooming=function(){return!!this._attachedCamera&&0!==this._attachedCamera.inertialRadiusOffset},e.prototype._shouldAnimationStopForInteraction=function(){if(!this._attachedCamera)return!1;var e=!1;return this._lastFrameRadius===this._attachedCamera.radius&&0!==this._attachedCamera.inertialRadiusOffset&&(e=!0),this._lastFrameRadius=this._attachedCamera.radius,this._zoomStopsAnimation?e:this._userIsZooming()},e.prototype._applyUserInteraction=function(){this._userIsMoving()&&!this._shouldAnimationStopForInteraction()&&(this._lastInteractionTime=Q.a.Now)},e.prototype._userIsMoving=function(){return!!this._attachedCamera&&(0!==this._attachedCamera.inertialAlphaOffset||0!==this._attachedCamera.inertialBetaOffset||0!==this._attachedCamera.inertialRadiusOffset||0!==this._attachedCamera.inertialPanningX||0!==this._attachedCamera.inertialPanningY||this._isPointerDown)},e}(),ze=function(){function e(){this.transitionDuration=450,this.lowerRadiusTransitionRange=2,this.upperRadiusTransitionRange=-2,this._autoTransitionRange=!1,this._radiusIsAnimating=!1,this._radiusBounceTransition=null,this._animatables=new Array}return Object.defineProperty(e.prototype,"name",{get:function(){return"Bouncing"},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"autoTransitionRange",{get:function(){return this._autoTransitionRange},set:function(e){var t=this;if(this._autoTransitionRange!==e){this._autoTransitionRange=e;var i=this._attachedCamera;i&&(e?this._onMeshTargetChangedObserver=i.onMeshTargetChangedObservable.add(function(e){if(e){e.computeWorldMatrix(!0);var i=e.getBoundingInfo().diagonalLength;t.lowerRadiusTransitionRange=.05*i,t.upperRadiusTransitionRange=.05*i}}):this._onMeshTargetChangedObserver&&i.onMeshTargetChangedObservable.remove(this._onMeshTargetChangedObserver))}},enumerable:!0,configurable:!0}),e.prototype.init=function(){},e.prototype.attach=function(e){var t=this;this._attachedCamera=e,this._onAfterCheckInputsObserver=e.onAfterCheckInputsObservable.add(function(){t._attachedCamera&&(t._isRadiusAtLimit(t._attachedCamera.lowerRadiusLimit)&&t._applyBoundRadiusAnimation(t.lowerRadiusTransitionRange),t._isRadiusAtLimit(t._attachedCamera.upperRadiusLimit)&&t._applyBoundRadiusAnimation(t.upperRadiusTransitionRange))})},e.prototype.detach=function(){this._attachedCamera&&(this._onAfterCheckInputsObserver&&this._attachedCamera.onAfterCheckInputsObservable.remove(this._onAfterCheckInputsObserver),this._onMeshTargetChangedObserver&&this._attachedCamera.onMeshTargetChangedObservable.remove(this._onMeshTargetChangedObserver),this._attachedCamera=null)},e.prototype._isRadiusAtLimit=function(e){return!!this._attachedCamera&&(this._attachedCamera.radius===e&&!this._radiusIsAnimating)},e.prototype._applyBoundRadiusAnimation=function(t){var i=this;if(this._attachedCamera){this._radiusBounceTransition||(e.EasingFunction.setEasingMode(e.EasingMode),this._radiusBounceTransition=k.CreateAnimation("radius",k.ANIMATIONTYPE_FLOAT,60,e.EasingFunction)),this._cachedWheelPrecision=this._attachedCamera.wheelPrecision,this._attachedCamera.wheelPrecision=1/0,this._attachedCamera.inertialRadiusOffset=0,this.stopAllAnimations(),this._radiusIsAnimating=!0;var n=k.TransitionTo("radius",this._attachedCamera.radius+t,this._attachedCamera,this._attachedCamera.getScene(),60,this._radiusBounceTransition,this.transitionDuration,function(){return i._clearAnimationLocks()});n&&this._animatables.push(n)}},e.prototype._clearAnimationLocks=function(){this._radiusIsAnimating=!1,this._attachedCamera&&(this._attachedCamera.wheelPrecision=this._cachedWheelPrecision)},e.prototype.stopAllAnimations=function(){for(this._attachedCamera&&(this._attachedCamera.animations=[]);this._animatables.length;)this._animatables[0].onAnimationEnd=null,this._animatables[0].stop(),this._animatables.shift()},e.EasingFunction=new fe(.3),e.EasingMode=he.EASINGMODE_EASEOUT,e}(),Ge=function(){function e(){this._mode=e.FitFrustumSidesMode,this._radiusScale=1,this._positionScale=.5,this._defaultElevation=.3,this._elevationReturnTime=1500,this._elevationReturnWaitTime=1e3,this._zoomStopsAnimation=!1,this._framingTime=1500,this.autoCorrectCameraLimitsAndSensibility=!0,this._isPointerDown=!1,this._lastInteractionTime=-1/0,this._animatables=new Array,this._betaIsAnimating=!1}return Object.defineProperty(e.prototype,"name",{get:function(){return"Framing"},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"mode",{get:function(){return this._mode},set:function(e){this._mode=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"radiusScale",{get:function(){return this._radiusScale},set:function(e){this._radiusScale=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"positionScale",{get:function(){return this._positionScale},set:function(e){this._positionScale=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"defaultElevation",{get:function(){return this._defaultElevation},set:function(e){this._defaultElevation=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"elevationReturnTime",{get:function(){return this._elevationReturnTime},set:function(e){this._elevationReturnTime=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"elevationReturnWaitTime",{get:function(){return this._elevationReturnWaitTime},set:function(e){this._elevationReturnWaitTime=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"zoomStopsAnimation",{get:function(){return this._zoomStopsAnimation},set:function(e){this._zoomStopsAnimation=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"framingTime",{get:function(){return this._framingTime},set:function(e){this._framingTime=e},enumerable:!0,configurable:!0}),e.prototype.init=function(){},e.prototype.attach=function(t){var i=this;this._attachedCamera=t;var n=this._attachedCamera.getScene();e.EasingFunction.setEasingMode(e.EasingMode),this._onPrePointerObservableObserver=n.onPrePointerObservable.add(function(e){e.type!==Ve.a.POINTERDOWN?e.type===Ve.a.POINTERUP&&(i._isPointerDown=!1):i._isPointerDown=!0}),this._onMeshTargetChangedObserver=t.onMeshTargetChangedObservable.add(function(e){e&&i.zoomOnMesh(e)}),this._onAfterCheckInputsObserver=t.onAfterCheckInputsObservable.add(function(){i._applyUserInteraction(),i._maintainCameraAboveGround()})},e.prototype.detach=function(){if(this._attachedCamera){var e=this._attachedCamera.getScene();this._onPrePointerObservableObserver&&e.onPrePointerObservable.remove(this._onPrePointerObservableObserver),this._onAfterCheckInputsObserver&&this._attachedCamera.onAfterCheckInputsObservable.remove(this._onAfterCheckInputsObserver),this._onMeshTargetChangedObserver&&this._attachedCamera.onMeshTargetChangedObservable.remove(this._onMeshTargetChangedObserver),this._attachedCamera=null}},e.prototype.zoomOnMesh=function(e,t,i){void 0===t&&(t=!1),void 0===i&&(i=null),e.computeWorldMatrix(!0);var n=e.getBoundingInfo().boundingBox;this.zoomOnBoundingInfo(n.minimumWorld,n.maximumWorld,t,i)},e.prototype.zoomOnMeshHierarchy=function(e,t,i){void 0===t&&(t=!1),void 0===i&&(i=null),e.computeWorldMatrix(!0);var n=e.getHierarchyBoundingVectors(!0);this.zoomOnBoundingInfo(n.min,n.max,t,i)},e.prototype.zoomOnMeshesHierarchy=function(e,t,i){void 0===t&&(t=!1),void 0===i&&(i=null);for(var n=new a.e(Number.MAX_VALUE,Number.MAX_VALUE,Number.MAX_VALUE),r=new a.e(-Number.MAX_VALUE,-Number.MAX_VALUE,-Number.MAX_VALUE),o=0;o<e.length;o++){var s=e[o].getHierarchyBoundingVectors(!0);a.e.CheckExtends(s.min,n,r),a.e.CheckExtends(s.max,n,r)}this.zoomOnBoundingInfo(n,r,t,i)},e.prototype.zoomOnBoundingInfo=function(t,i,n,r){var o,s=this;if(void 0===n&&(n=!1),void 0===r&&(r=null),this._attachedCamera){var c=t.y,l=c+(i.y-c)*this._positionScale,u=i.subtract(t).scale(.5);if(n)o=new a.e(0,l,0);else{var h=t.add(u);o=new a.e(h.x,l,h.z)}this._vectorTransition||(this._vectorTransition=k.CreateAnimation("target",k.ANIMATIONTYPE_VECTOR3,60,e.EasingFunction)),this._betaIsAnimating=!0;var d=k.TransitionTo("target",o,this._attachedCamera,this._attachedCamera.getScene(),60,this._vectorTransition,this._framingTime);d&&this._animatables.push(d);var f=0;if(this._mode===e.FitFrustumSidesMode){var p=this._calculateLowerRadiusFromModelBoundingSphere(t,i);this.autoCorrectCameraLimitsAndSensibility&&(this._attachedCamera.lowerRadiusLimit=u.length()+this._attachedCamera.minZ),f=p}else this._mode===e.IgnoreBoundsSizeMode&&(f=this._calculateLowerRadiusFromModelBoundingSphere(t,i),this.autoCorrectCameraLimitsAndSensibility&&null===this._attachedCamera.lowerRadiusLimit&&(this._attachedCamera.lowerRadiusLimit=this._attachedCamera.minZ));if(this.autoCorrectCameraLimitsAndSensibility){var _=i.subtract(t).length();this._attachedCamera.panningSensibility=5e3/_,this._attachedCamera.wheelPrecision=100/f}this._radiusTransition||(this._radiusTransition=k.CreateAnimation("radius",k.ANIMATIONTYPE_FLOAT,60,e.EasingFunction)),(d=k.TransitionTo("radius",f,this._attachedCamera,this._attachedCamera.getScene(),60,this._radiusTransition,this._framingTime,function(){s.stopAllAnimations(),r&&r(),s._attachedCamera&&s._attachedCamera.useInputToRestoreState&&s._attachedCamera.storeState()}))&&this._animatables.push(d)}},e.prototype._calculateLowerRadiusFromModelBoundingSphere=function(t,i){var n=i.subtract(t).length(),r=this._getFrustumSlope(),o=.5*n*this._radiusScale,a=o*Math.sqrt(1+1/(r.x*r.x)),s=o*Math.sqrt(1+1/(r.y*r.y)),c=Math.max(a,s),l=this._attachedCamera;return l?(l.lowerRadiusLimit&&this._mode===e.IgnoreBoundsSizeMode&&(c=c<l.lowerRadiusLimit?l.lowerRadiusLimit:c),l.upperRadiusLimit&&(c=c>l.upperRadiusLimit?l.upperRadiusLimit:c),c):0},e.prototype._maintainCameraAboveGround=function(){var t=this;if(!(this._elevationReturnTime<0)){var i=Q.a.Now-this._lastInteractionTime,n=.5*Math.PI-this._defaultElevation,r=.5*Math.PI;if(this._attachedCamera&&!this._betaIsAnimating&&this._attachedCamera.beta>r&&i>=this._elevationReturnWaitTime){this._betaIsAnimating=!0,this.stopAllAnimations(),this._betaTransition||(this._betaTransition=k.CreateAnimation("beta",k.ANIMATIONTYPE_FLOAT,60,e.EasingFunction));var o=k.TransitionTo("beta",n,this._attachedCamera,this._attachedCamera.getScene(),60,this._betaTransition,this._elevationReturnTime,function(){t._clearAnimationLocks(),t.stopAllAnimations()});o&&this._animatables.push(o)}}},e.prototype._getFrustumSlope=function(){var e=this._attachedCamera;if(!e)return a.d.Zero();var t=e.getScene().getEngine().getAspectRatio(e),i=Math.tan(e.fov/2),n=i*t;return new a.d(n,i)},e.prototype._clearAnimationLocks=function(){this._betaIsAnimating=!1},e.prototype._applyUserInteraction=function(){this.isUserIsMoving&&(this._lastInteractionTime=Q.a.Now,this.stopAllAnimations(),this._clearAnimationLocks())},e.prototype.stopAllAnimations=function(){for(this._attachedCamera&&(this._attachedCamera.animations=[]);this._animatables.length;)this._animatables[0]&&(this._animatables[0].onAnimationEnd=null,this._animatables[0].stop()),this._animatables.shift()},Object.defineProperty(e.prototype,"isUserIsMoving",{get:function(){return!!this._attachedCamera&&(0!==this._attachedCamera.inertialAlphaOffset||0!==this._attachedCamera.inertialBetaOffset||0!==this._attachedCamera.inertialRadiusOffset||0!==this._attachedCamera.inertialPanningX||0!==this._attachedCamera.inertialPanningY||this._isPointerDown)},enumerable:!0,configurable:!0}),e.EasingFunction=new ge,e.EasingMode=he.EASINGMODE_EASEINOUT,e.IgnoreBoundsSizeMode=0,e.FitFrustumSidesMode=1,e}(),je=function(e,t,i,n){void 0===t&&(t=new a.e),void 0===i&&(i=0),void 0===n&&(n=!1),this.direction=e,this.rotatedDirection=t,this.diff=i,this.ignore=n},We=function(){function e(e){this.ui=e,this.name="AttachToBoxBehavior",this.distanceAwayFromFace=.15,this.distanceAwayFromBottomOfFace=.15,this._faceVectors=[new je(a.e.Up()),new je(a.e.Down()),new je(a.e.Left()),new je(a.e.Right()),new je(a.e.Forward()),new je(a.e.Forward().scaleInPlace(-1))],this._tmpMatrix=new a.a,this._tmpVector=new a.e,this._zeroVector=a.e.Zero(),this._lookAtTmpMatrix=new a.a}return e.prototype.init=function(){},e.prototype._closestFace=function(e){var t=this;return this._faceVectors.forEach(function(i){t._target.rotationQuaternion||(t._target.rotationQuaternion=a.b.RotationYawPitchRoll(t._target.rotation.y,t._target.rotation.x,t._target.rotation.z)),t._target.rotationQuaternion.toRotationMatrix(t._tmpMatrix),a.e.TransformCoordinatesToRef(i.direction,t._tmpMatrix,i.rotatedDirection),i.diff=a.e.GetAngleBetweenVectors(i.rotatedDirection,e,a.e.Cross(i.rotatedDirection,e))}),this._faceVectors.reduce(function(e,t){return e.ignore?t:t.ignore?e:e.diff<t.diff?e:t},this._faceVectors[0])},e.prototype._lookAtToRef=function(e,t,i){void 0===t&&(t=new a.e(0,1,0)),a.a.LookAtLHToRef(this._zeroVector,e,t,this._lookAtTmpMatrix),this._lookAtTmpMatrix.invert(),a.b.FromRotationMatrixToRef(this._lookAtTmpMatrix,i)},e.prototype.attach=function(e){var t=this;this._target=e,this._scene=this._target.getScene(),this._onRenderObserver=this._scene.onBeforeRenderObservable.add(function(){if(t._scene.activeCamera){var i=t._scene.activeCamera.position;t._scene.activeCamera.devicePosition&&(i=t._scene.activeCamera.devicePosition);var n=t._closestFace(i.subtract(e.position));t._scene.activeCamera.leftCamera?t._scene.activeCamera.leftCamera.computeWorldMatrix().getRotationMatrixToRef(t._tmpMatrix):t._scene.activeCamera.computeWorldMatrix().getRotationMatrixToRef(t._tmpMatrix),a.e.TransformCoordinatesToRef(a.e.Up(),t._tmpMatrix,t._tmpVector),t._faceVectors.forEach(function(e){n.direction.x&&e.direction.x&&(e.ignore=!0),n.direction.y&&e.direction.y&&(e.ignore=!0),n.direction.z&&e.direction.z&&(e.ignore=!0)});var r=t._closestFace(t._tmpVector);t._faceVectors.forEach(function(e){e.ignore=!1}),t.ui.position.copyFrom(e.position),n.direction.x&&(n.rotatedDirection.scaleToRef(e.scaling.x/2+t.distanceAwayFromFace,t._tmpVector),t.ui.position.addInPlace(t._tmpVector)),n.direction.y&&(n.rotatedDirection.scaleToRef(e.scaling.y/2+t.distanceAwayFromFace,t._tmpVector),t.ui.position.addInPlace(t._tmpVector)),n.direction.z&&(n.rotatedDirection.scaleToRef(e.scaling.z/2+t.distanceAwayFromFace,t._tmpVector),t.ui.position.addInPlace(t._tmpVector)),t.ui.rotationQuaternion||(t.ui.rotationQuaternion=a.b.RotationYawPitchRoll(t.ui.rotation.y,t.ui.rotation.x,t.ui.rotation.z)),n.rotatedDirection.scaleToRef(-1,t._tmpVector),t._lookAtToRef(t._tmpVector,r.rotatedDirection,t.ui.rotationQuaternion),r.direction.x&&t.ui.up.scaleToRef(t.distanceAwayFromBottomOfFace-e.scaling.x/2,t._tmpVector),r.direction.y&&t.ui.up.scaleToRef(t.distanceAwayFromBottomOfFace-e.scaling.y/2,t._tmpVector),r.direction.z&&t.ui.up.scaleToRef(t.distanceAwayFromBottomOfFace-e.scaling.z/2,t._tmpVector),t.ui.position.addInPlace(t._tmpVector)}})},e.prototype.detach=function(){this._scene.onBeforeRenderObservable.remove(this._onRenderObserver)},e}(),Xe=function(){function e(){var e=this;this.delay=0,this.fadeInTime=300,this._millisecondsPerFrame=1e3/60,this._hovered=!1,this._hoverValue=0,this._ownerNode=null,this._update=function(){if(e._ownerNode){if(e._hoverValue+=e._hovered?e._millisecondsPerFrame:-e._millisecondsPerFrame,e._setAllVisibility(e._ownerNode,(e._hoverValue-e.delay)/e.fadeInTime),e._ownerNode.visibility>1)return e._setAllVisibility(e._ownerNode,1),void(e._hoverValue=e.fadeInTime+e.delay);if(e._ownerNode.visibility<0&&(e._setAllVisibility(e._ownerNode,0),e._hoverValue<0))return void(e._hoverValue=0);setTimeout(e._update,e._millisecondsPerFrame)}}}return Object.defineProperty(e.prototype,"name",{get:function(){return"FadeInOut"},enumerable:!0,configurable:!0}),e.prototype.init=function(){},e.prototype.attach=function(e){this._ownerNode=e,this._setAllVisibility(this._ownerNode,0)},e.prototype.detach=function(){this._ownerNode=null},e.prototype.fadeIn=function(e){this._hovered=e,this._update()},e.prototype._setAllVisibility=function(e,t){var i=this;e.visibility=t,e.getChildMeshes().forEach(function(e){i._setAllVisibility(e,t)})},e}(),He=i(62),Ye=function(){function e(){this._startDistance=0,this._initialScale=new a.e(0,0,0),this._targetScale=new a.e(0,0,0),this._sceneRenderObserver=null,this._dragBehaviorA=new He.a({}),this._dragBehaviorA.moveAttached=!1,this._dragBehaviorB=new He.a({}),this._dragBehaviorB.moveAttached=!1}return Object.defineProperty(e.prototype,"name",{get:function(){return"MultiPointerScale"},enumerable:!0,configurable:!0}),e.prototype.init=function(){},e.prototype._getCurrentDistance=function(){return this._dragBehaviorA.lastDragPosition.subtract(this._dragBehaviorB.lastDragPosition).length()},e.prototype.attach=function(e){var t=this;this._ownerNode=e,this._dragBehaviorA.onDragStartObservable.add(function(i){t._dragBehaviorA.dragging&&t._dragBehaviorB.dragging&&(t._dragBehaviorA.currentDraggingPointerID==t._dragBehaviorB.currentDraggingPointerID?t._dragBehaviorA.releaseDrag():(t._initialScale.copyFrom(e.scaling),t._startDistance=t._getCurrentDistance()))}),this._dragBehaviorB.onDragStartObservable.add(function(i){t._dragBehaviorA.dragging&&t._dragBehaviorB.dragging&&(t._dragBehaviorA.currentDraggingPointerID==t._dragBehaviorB.currentDraggingPointerID?t._dragBehaviorB.releaseDrag():(t._initialScale.copyFrom(e.scaling),t._startDistance=t._getCurrentDistance()))}),[this._dragBehaviorA,this._dragBehaviorB].forEach(function(e){e.onDragObservable.add(function(){if(t._dragBehaviorA.dragging&&t._dragBehaviorB.dragging){var e=t._getCurrentDistance()/t._startDistance;t._initialScale.scaleToRef(e,t._targetScale)}})}),e.addBehavior(this._dragBehaviorA),e.addBehavior(this._dragBehaviorB),this._sceneRenderObserver=e.getScene().onBeforeRenderObservable.add(function(){if(t._dragBehaviorA.dragging&&t._dragBehaviorB.dragging){var i=t._targetScale.subtract(e.scaling).scaleInPlace(.1);i.length()>.01&&e.scaling.addInPlace(i)}})},e.prototype.detach=function(){var e=this;this._ownerNode.getScene().onBeforeRenderObservable.remove(this._sceneRenderObserver),[this._dragBehaviorA,this._dragBehaviorB].forEach(function(t){t.onDragStartObservable.clear(),t.onDragObservable.clear(),e._ownerNode.removeBehavior(t)})},e}(),Ke=i(27),Qe=i(24),qe=i(55),Ze=function(){function e(){this._sceneRenderObserver=null,this._targetPosition=new a.e(0,0,0),this._moving=!1,this._startingOrientation=new a.b,this.zDragFactor=3,this.rotateDraggedObject=!0,this.dragging=!1,this.dragDeltaRatio=.2,this.currentDraggingPointerID=-1,this.detachCameraControls=!0,this.onDragStartObservable=new o.c,this.onDragEndObservable=new o.c}return Object.defineProperty(e.prototype,"name",{get:function(){return"SixDofDrag"},enumerable:!0,configurable:!0}),e.prototype.init=function(){},Object.defineProperty(e.prototype,"_pointerCamera",{get:function(){return this._scene.cameraToUseForPointers?this._scene.cameraToUseForPointers:this._scene.activeCamera},enumerable:!0,configurable:!0}),e.prototype.attach=function(t){var i=this;this._ownerNode=t,this._scene=this._ownerNode.getScene(),e._virtualScene||(e._virtualScene=new K.a(this._scene.getEngine()),e._virtualScene.detachControl(),this._scene.getEngine().scenes.pop());var n=null,r=new a.e(0,0,0);this._virtualOriginMesh=new Ke.a("",e._virtualScene),this._virtualOriginMesh.rotationQuaternion=new a.b,this._virtualDragMesh=new Ke.a("",e._virtualScene),this._virtualDragMesh.rotationQuaternion=new a.b;var o=null;this._pointerObserver=this._scene.onPointerObservable.add(function(e,t){if(e.type==Ve.a.POINTERDOWN){if(!i.dragging&&e.pickInfo&&e.pickInfo.hit&&e.pickInfo.pickedMesh&&e.pickInfo.ray&&(h=e.pickInfo.pickedMesh,i._ownerNode==h||h.isDescendantOf(i._ownerNode))){i._pointerCamera&&i._pointerCamera.cameraRigMode==Qe.a.RIG_MODE_NONE&&e.pickInfo.ray.origin.copyFrom(i._pointerCamera.globalPosition),n=i._ownerNode,qe.a._RemoveAndStorePivotPoint(n),r.copyFrom(e.pickInfo.ray.origin),i._virtualOriginMesh.position.copyFrom(e.pickInfo.ray.origin),i._virtualOriginMesh.lookAt(e.pickInfo.ray.origin.add(e.pickInfo.ray.direction)),i._virtualOriginMesh.removeChild(i._virtualDragMesh),n.computeWorldMatrix(),i._virtualDragMesh.position.copyFrom(n.absolutePosition),n.rotationQuaternion||(n.rotationQuaternion=a.b.RotationYawPitchRoll(n.rotation.y,n.rotation.x,n.rotation.z));var s=n.parent;n.setParent(null),i._virtualDragMesh.rotationQuaternion.copyFrom(n.rotationQuaternion),n.setParent(s),i._virtualOriginMesh.addChild(i._virtualDragMesh),i._targetPosition.copyFrom(i._virtualDragMesh.absolutePosition),i.dragging=!0,i.currentDraggingPointerID=e.event.pointerId,i.detachCameraControls&&i._pointerCamera&&!i._pointerCamera.leftCamera&&(i._pointerCamera.inputs.attachedElement?(o=i._pointerCamera.inputs.attachedElement,i._pointerCamera.detachControl(i._pointerCamera.inputs.attachedElement)):o=null),qe.a._RestorePivotPoint(n),i.onDragStartObservable.notifyObservers({})}}else if(e.type==Ve.a.POINTERUP)i.currentDraggingPointerID==e.event.pointerId&&(i.dragging=!1,i._moving=!1,i.currentDraggingPointerID=-1,n=null,i._virtualOriginMesh.removeChild(i._virtualDragMesh),i.detachCameraControls&&o&&i._pointerCamera&&!i._pointerCamera.leftCamera&&i._pointerCamera.attachControl(o,!0),i.onDragEndObservable.notifyObservers({}));else if(e.type==Ve.a.POINTERMOVE&&i.currentDraggingPointerID==e.event.pointerId&&i.dragging&&e.pickInfo&&e.pickInfo.ray&&n){var c=i.zDragFactor;i._pointerCamera&&i._pointerCamera.cameraRigMode==Qe.a.RIG_MODE_NONE&&(e.pickInfo.ray.origin.copyFrom(i._pointerCamera.globalPosition),c=0);var l=e.pickInfo.ray.origin.subtract(r);r.copyFrom(e.pickInfo.ray.origin);var u=-a.e.Dot(l,e.pickInfo.ray.direction);i._virtualOriginMesh.addChild(i._virtualDragMesh),i._virtualDragMesh.position.z-=i._virtualDragMesh.position.z<1?u*i.zDragFactor:u*c*i._virtualDragMesh.position.z,i._virtualDragMesh.position.z<0&&(i._virtualDragMesh.position.z=0),i._virtualOriginMesh.position.copyFrom(e.pickInfo.ray.origin),i._virtualOriginMesh.lookAt(e.pickInfo.ray.origin.add(e.pickInfo.ray.direction)),i._virtualOriginMesh.removeChild(i._virtualDragMesh),i._targetPosition.copyFrom(i._virtualDragMesh.absolutePosition),n.parent&&a.e.TransformCoordinatesToRef(i._targetPosition,a.a.Invert(n.parent.getWorldMatrix()),i._targetPosition),i._moving||i._startingOrientation.copyFrom(i._virtualDragMesh.rotationQuaternion),i._moving=!0}var h});var s=new a.b;this._sceneRenderObserver=t.getScene().onBeforeRenderObservable.add(function(){if(i.dragging&&i._moving&&n){if(qe.a._RemoveAndStorePivotPoint(n),n.position.addInPlace(i._targetPosition.subtract(n.position).scale(i.dragDeltaRatio)),i.rotateDraggedObject){s.copyFrom(i._startingOrientation),s.x=-s.x,s.y=-s.y,s.z=-s.z,i._virtualDragMesh.rotationQuaternion.multiplyToRef(s,s),a.b.RotationYawPitchRollToRef(s.toEulerAngles("xyz").y,0,0,s),s.multiplyToRef(i._startingOrientation,s);var e=n.parent;(!e||e.scaling&&!e.scaling.isNonUniformWithinEpsilon(.001))&&(n.setParent(null),a.b.SlerpToRef(n.rotationQuaternion,s,i.dragDeltaRatio,n.rotationQuaternion),n.setParent(e))}qe.a._RestorePivotPoint(n)}})},e.prototype.detach=function(){this._scene&&this._scene.onPointerObservable.remove(this._pointerObserver),this._ownerNode&&this._ownerNode.getScene().onBeforeRenderObservable.remove(this._sceneRenderObserver),this._virtualOriginMesh&&this._virtualOriginMesh.dispose(),this._virtualDragMesh&&this._virtualDragMesh.dispose(),this.onDragEndObservable.clear(),this.onDragStartObservable.clear()},e}(),Je=function(){function e(e,t,i){if(this.targetPosition=a.e.Zero(),this.poleTargetPosition=a.e.Zero(),this.poleTargetLocalOffset=a.e.Zero(),this.poleAngle=0,this.slerpAmount=1,this._bone1Quat=a.b.Identity(),this._bone1Mat=a.a.Identity(),this._bone2Ang=Math.PI,this._maxAngle=Math.PI,this._rightHandedSystem=!1,this._bendAxis=a.e.Right(),this._slerping=!1,this._adjustRoll=0,this._bone2=t,this._bone1=t.getParent(),this._bone1){this.mesh=e;var n=t.getPosition();if(t.getAbsoluteTransform().determinant()>0&&(this._rightHandedSystem=!0,this._bendAxis.x=0,this._bendAxis.y=0,this._bendAxis.z=-1,n.x>n.y&&n.x>n.z&&(this._adjustRoll=.5*Math.PI,this._bendAxis.z=1)),this._bone1.length){var r=this._bone1.getScale(),o=this._bone2.getScale();this._bone1Length=this._bone1.length*r.y*this.mesh.scaling.y,this._bone2Length=this._bone2.length*o.y*this.mesh.scaling.y}else if(this._bone1.children[0]){e.computeWorldMatrix(!0);var s=this._bone2.children[0].getAbsolutePosition(e),c=this._bone2.getAbsolutePosition(e),l=this._bone1.getAbsolutePosition(e);this._bone1Length=a.e.Distance(s,c),this._bone2Length=a.e.Distance(c,l)}this._bone1.getRotationMatrixToRef(Z.b.WORLD,e,this._bone1Mat),this.maxAngle=Math.PI,i&&(i.targetMesh&&(this.targetMesh=i.targetMesh,this.targetMesh.computeWorldMatrix(!0)),i.poleTargetMesh?(this.poleTargetMesh=i.poleTargetMesh,this.poleTargetMesh.computeWorldMatrix(!0)):i.poleTargetBone?this.poleTargetBone=i.poleTargetBone:this._bone1.getParent()&&(this.poleTargetBone=this._bone1.getParent()),i.poleTargetLocalOffset&&this.poleTargetLocalOffset.copyFrom(i.poleTargetLocalOffset),i.poleAngle&&(this.poleAngle=i.poleAngle),i.bendAxis&&this._bendAxis.copyFrom(i.bendAxis),i.maxAngle&&(this.maxAngle=i.maxAngle),i.slerpAmount&&(this.slerpAmount=i.slerpAmount))}}return Object.defineProperty(e.prototype,"maxAngle",{get:function(){return this._maxAngle},set:function(e){this._setMaxAngle(e)},enumerable:!0,configurable:!0}),e.prototype._setMaxAngle=function(e){e<0&&(e=0),(e>Math.PI||null==e)&&(e=Math.PI),this._maxAngle=e;var t=this._bone1Length,i=this._bone2Length;this._maxReach=Math.sqrt(t*t+i*i-2*t*i*Math.cos(e))},e.prototype.update=function(){var t=this._bone1;if(t){var i=this.targetPosition,n=this.poleTargetPosition,r=e._tmpMats[0],o=e._tmpMats[1];this.targetMesh&&i.copyFrom(this.targetMesh.getAbsolutePosition()),this.poleTargetBone?this.poleTargetBone.getAbsolutePositionFromLocalToRef(this.poleTargetLocalOffset,this.mesh,n):this.poleTargetMesh&&a.e.TransformCoordinatesToRef(this.poleTargetLocalOffset,this.poleTargetMesh.getWorldMatrix(),n);var s=e._tmpVecs[0],c=e._tmpVecs[1],l=e._tmpVecs[2],u=e._tmpVecs[3],h=e._tmpVecs[4],d=e._tmpQuat;t.getAbsolutePositionToRef(this.mesh,s),n.subtractToRef(s,h),0==h.x&&0==h.y&&0==h.z?h.y=1:h.normalize(),i.subtractToRef(s,u),u.normalize(),a.e.CrossToRef(u,h,c),c.normalize(),a.e.CrossToRef(u,c,l),l.normalize(),a.a.FromXYZAxesToRef(l,u,c,r);var f=this._bone1Length,p=this._bone2Length,_=a.e.Distance(s,i);this._maxReach>0&&(_=Math.min(this._maxReach,_));var m=(p*p+_*_-f*f)/(2*p*_),g=(_*_+f*f-p*p)/(2*_*f);m>1&&(m=1),g>1&&(g=1),m<-1&&(m=-1),g<-1&&(g=-1);var v=Math.acos(m),y=Math.acos(g),b=-v-y;if(this._rightHandedSystem)a.a.RotationYawPitchRollToRef(0,0,this._adjustRoll,o),o.multiplyToRef(r,r),a.a.RotationAxisToRef(this._bendAxis,y,o),o.multiplyToRef(r,r);else{var T=e._tmpVecs[5];T.copyFrom(this._bendAxis),T.x*=-1,a.a.RotationAxisToRef(T,-y,o),o.multiplyToRef(r,r)}this.poleAngle&&(a.a.RotationAxisToRef(u,this.poleAngle,o),r.multiplyToRef(o,r)),this._bone1&&(this.slerpAmount<1?(this._slerping||a.b.FromRotationMatrixToRef(this._bone1Mat,this._bone1Quat),a.b.FromRotationMatrixToRef(r,d),a.b.SlerpToRef(this._bone1Quat,d,this.slerpAmount,this._bone1Quat),b=this._bone2Ang*(1-this.slerpAmount)+b*this.slerpAmount,this._bone1.setRotationQuaternion(this._bone1Quat,Z.b.WORLD,this.mesh),this._slerping=!0):(this._bone1.setRotationMatrix(r,Z.b.WORLD,this.mesh),this._bone1Mat.copyFrom(r),this._slerping=!1)),this._bone2.setAxisAngle(this._bendAxis,b,Z.b.LOCAL),this._bone2Ang=b}},e._tmpVecs=[a.e.Zero(),a.e.Zero(),a.e.Zero(),a.e.Zero(),a.e.Zero(),a.e.Zero()],e._tmpQuat=a.b.Identity(),e._tmpMats=[a.a.Identity(),a.a.Identity()],e}(),$e=function(){function e(e,t,i,n){if(this.upAxis=a.e.Up(),this.upAxisSpace=Z.b.LOCAL,this.adjustYaw=0,this.adjustPitch=0,this.adjustRoll=0,this.slerpAmount=1,this._boneQuat=a.b.Identity(),this._slerping=!1,this._firstFrameSkipped=!1,this._fowardAxis=a.e.Forward(),this.mesh=e,this.bone=t,this.target=i,n&&(n.adjustYaw&&(this.adjustYaw=n.adjustYaw),n.adjustPitch&&(this.adjustPitch=n.adjustPitch),n.adjustRoll&&(this.adjustRoll=n.adjustRoll),null!=n.maxYaw?this.maxYaw=n.maxYaw:this.maxYaw=Math.PI,null!=n.minYaw?this.minYaw=n.minYaw:this.minYaw=-Math.PI,null!=n.maxPitch?this.maxPitch=n.maxPitch:this.maxPitch=Math.PI,null!=n.minPitch?this.minPitch=n.minPitch:this.minPitch=-Math.PI,null!=n.slerpAmount&&(this.slerpAmount=n.slerpAmount),null!=n.upAxis&&(this.upAxis=n.upAxis),null!=n.upAxisSpace&&(this.upAxisSpace=n.upAxisSpace),null!=n.yawAxis||null!=n.pitchAxis)){var r=Z.a.Y,o=Z.a.X;null!=n.yawAxis&&(r=n.yawAxis.clone()).normalize(),null!=n.pitchAxis&&(o=n.pitchAxis.clone()).normalize();var s=a.e.Cross(o,r);this._transformYawPitch=a.a.Identity(),a.a.FromXYZAxesToRef(o,r,s,this._transformYawPitch),this._transformYawPitchInv=this._transformYawPitch.clone(),this._transformYawPitch.invert()}t.getParent()||this.upAxisSpace!=Z.b.BONE||(this.upAxisSpace=Z.b.LOCAL)}return Object.defineProperty(e.prototype,"minYaw",{get:function(){return this._minYaw},set:function(e){this._minYaw=e,this._minYawSin=Math.sin(e),this._minYawCos=Math.cos(e),null!=this._maxYaw&&(this._midYawConstraint=.5*this._getAngleDiff(this._minYaw,this._maxYaw)+this._minYaw,this._yawRange=this._maxYaw-this._minYaw)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"maxYaw",{get:function(){return this._maxYaw},set:function(e){this._maxYaw=e,this._maxYawSin=Math.sin(e),this._maxYawCos=Math.cos(e),null!=this._minYaw&&(this._midYawConstraint=.5*this._getAngleDiff(this._minYaw,this._maxYaw)+this._minYaw,this._yawRange=this._maxYaw-this._minYaw)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"minPitch",{get:function(){return this._minPitch},set:function(e){this._minPitch=e,this._minPitchTan=Math.tan(e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"maxPitch",{get:function(){return this._maxPitch},set:function(e){this._maxPitch=e,this._maxPitchTan=Math.tan(e)},enumerable:!0,configurable:!0}),e.prototype.update=function(){if(this.slerpAmount<1&&!this._firstFrameSkipped)this._firstFrameSkipped=!0;else{var t=this.bone,i=e._tmpVecs[0];t.getAbsolutePositionToRef(this.mesh,i);var n=this.target,r=e._tmpMats[0],o=e._tmpMats[1],s=this.mesh,c=t.getParent(),l=e._tmpVecs[1];l.copyFrom(this.upAxis),this.upAxisSpace==Z.b.BONE&&c?(this._transformYawPitch&&a.e.TransformCoordinatesToRef(l,this._transformYawPitchInv,l),c.getDirectionToRef(l,this.mesh,l)):this.upAxisSpace==Z.b.LOCAL&&(s.getDirectionToRef(l,l),1==s.scaling.x&&1==s.scaling.y&&1==s.scaling.z||l.normalize());var u=!1,h=!1;if(this._maxYaw==Math.PI&&this._minYaw==-Math.PI||(u=!0),this._maxPitch==Math.PI&&this._minPitch==-Math.PI||(h=!0),u||h){var d=e._tmpMats[2],f=e._tmpMats[3];if(this.upAxisSpace==Z.b.BONE&&1==l.y&&c)c.getRotationMatrixToRef(Z.b.WORLD,this.mesh,d);else if(this.upAxisSpace!=Z.b.LOCAL||1!=l.y||c){(_=e._tmpVecs[2]).copyFrom(this._fowardAxis),this._transformYawPitch&&a.e.TransformCoordinatesToRef(_,this._transformYawPitchInv,_),c?c.getDirectionToRef(_,this.mesh,_):s.getDirectionToRef(_,_);var p=a.e.Cross(l,_);p.normalize();var _=a.e.Cross(p,l);a.a.FromXYZAxesToRef(p,l,_,d)}else d.copyFrom(s.getWorldMatrix());d.invertToRef(f);var m=null;if(h){var g=e._tmpVecs[3];n.subtractToRef(i,g),a.e.TransformCoordinatesToRef(g,f,g),m=Math.sqrt(g.x*g.x+g.z*g.z);var v=Math.atan2(g.y,m),y=v;v>this._maxPitch?(g.y=this._maxPitchTan*m,y=this._maxPitch):v<this._minPitch&&(g.y=this._minPitchTan*m,y=this._minPitch),v!=y&&(a.e.TransformCoordinatesToRef(g,d,g),g.addInPlace(i),n=g)}if(u){g=e._tmpVecs[4];n.subtractToRef(i,g),a.e.TransformCoordinatesToRef(g,f,g);var b=Math.atan2(g.x,g.z),T=b;if((b>this._maxYaw||b<this._minYaw)&&(null==m&&(m=Math.sqrt(g.x*g.x+g.z*g.z)),this._yawRange>Math.PI?this._isAngleBetween(b,this._maxYaw,this._midYawConstraint)?(g.z=this._maxYawCos*m,g.x=this._maxYawSin*m,T=this._maxYaw):this._isAngleBetween(b,this._midYawConstraint,this._minYaw)&&(g.z=this._minYawCos*m,g.x=this._minYawSin*m,T=this._minYaw):b>this._maxYaw?(g.z=this._maxYawCos*m,g.x=this._maxYawSin*m,T=this._maxYaw):b<this._minYaw&&(g.z=this._minYawCos*m,g.x=this._minYawSin*m,T=this._minYaw)),this._slerping&&this._yawRange>Math.PI){var E=e._tmpVecs[8];E.copyFrom(Z.a.Z),this._transformYawPitch&&a.e.TransformCoordinatesToRef(E,this._transformYawPitchInv,E);var x=e._tmpMats[4];this._boneQuat.toRotationMatrix(x),this.mesh.getWorldMatrix().multiplyToRef(x,x),a.e.TransformCoordinatesToRef(E,x,E),a.e.TransformCoordinatesToRef(E,f,E);var P=Math.atan2(E.x,E.z);if(this._getAngleBetween(P,b)>this._getAngleBetween(P,this._midYawConstraint)){null==m&&(m=Math.sqrt(g.x*g.x+g.z*g.z));var A=this._getAngleBetween(P,this._maxYaw);this._getAngleBetween(P,this._minYaw)<A?(T=P+.75*Math.PI,g.z=Math.cos(T)*m,g.x=Math.sin(T)*m):(T=P-.75*Math.PI,g.z=Math.cos(T)*m,g.x=Math.sin(T)*m)}}b!=T&&(a.e.TransformCoordinatesToRef(g,d,g),g.addInPlace(i),n=g)}}var S=e._tmpVecs[5],C=e._tmpVecs[6],R=e._tmpVecs[7],O=e._tmpQuat;n.subtractToRef(i,S),S.normalize(),a.e.CrossToRef(l,S,C),C.normalize(),a.e.CrossToRef(S,C,R),R.normalize(),a.a.FromXYZAxesToRef(C,R,S,r),0===C.x&&0===C.y&&0===C.z||0===R.x&&0===R.y&&0===R.z||0===S.x&&0===S.y&&0===S.z||((this.adjustYaw||this.adjustPitch||this.adjustRoll)&&(a.a.RotationYawPitchRollToRef(this.adjustYaw,this.adjustPitch,this.adjustRoll,o),o.multiplyToRef(r,r)),this.slerpAmount<1?(this._slerping||this.bone.getRotationQuaternionToRef(Z.b.WORLD,this.mesh,this._boneQuat),this._transformYawPitch&&this._transformYawPitch.multiplyToRef(r,r),a.b.FromRotationMatrixToRef(r,O),a.b.SlerpToRef(this._boneQuat,O,this.slerpAmount,this._boneQuat),this.bone.setRotationQuaternion(this._boneQuat,Z.b.WORLD,this.mesh),this._slerping=!0):(this._transformYawPitch&&this._transformYawPitch.multiplyToRef(r,r),this.bone.setRotationMatrix(r,Z.b.WORLD,this.mesh),this._slerping=!1))}},e.prototype._getAngleDiff=function(e,t){var i=t-e;return(i%=2*Math.PI)>Math.PI?i-=2*Math.PI:i<-Math.PI&&(i+=2*Math.PI),i},e.prototype._getAngleBetween=function(e,t){var i=0;return(i=(e=(e%=2*Math.PI)<0?e+2*Math.PI:e)<(t=(t%=2*Math.PI)<0?t+2*Math.PI:t)?t-e:e-t)>Math.PI&&(i=2*Math.PI-i),i},e.prototype._isAngleBetween=function(e,t,i){if(e=(e%=2*Math.PI)<0?e+2*Math.PI:e,(t=(t%=2*Math.PI)<0?t+2*Math.PI:t)<(i=(i%=2*Math.PI)<0?i+2*Math.PI:i)){if(e>t&&e<i)return!0}else if(e>i&&e<t)return!0;return!1},e._tmpVecs=q.a.BuildArray(10,a.e.Zero),e._tmpQuat=a.b.Identity(),e._tmpMats=q.a.BuildArray(5,a.a.Identity),e}(),et=i(9),tt=i(25);function it(e){return function(t,i,n,r,o,a,s,c,l,u){void 0===l&&(l=null),void 0===u&&(u=g.a.TEXTURETYPE_UNSIGNED_INT);var h=e?this._gl.TEXTURE_3D:this._gl.TEXTURE_2D_ARRAY,d=e?tt.b.Raw3D:tt.b.Raw2DArray,f=new tt.a(this,d);f.baseWidth=i,f.baseHeight=n,f.baseDepth=r,f.width=i,f.height=n,f.depth=r,f.format=o,f.type=u,f.generateMipMaps=a,f.samplingMode=c,e?f.is3D=!0:f.is2DArray=!0,this._doNotHandleContextLost||(f._bufferView=t),e?this.updateRawTexture3D(f,t,o,s,l,u):this.updateRawTexture2DArray(f,t,o,s,l,u),this._bindTextureDirectly(h,f,!0);var p=this._getSamplingParameters(c,a);return this._gl.texParameteri(h,this._gl.TEXTURE_MAG_FILTER,p.mag),this._gl.texParameteri(h,this._gl.TEXTURE_MIN_FILTER,p.min),a&&this._gl.generateMipmap(h),this._bindTextureDirectly(h,null),this._internalTexturesCache.push(f),f}}function nt(e){return function(t,i,n,r,o,a){void 0===o&&(o=null),void 0===a&&(a=g.a.TEXTURETYPE_UNSIGNED_INT);var s=e?this._gl.TEXTURE_3D:this._gl.TEXTURE_2D_ARRAY,c=this._getWebGLTextureType(a),l=this._getInternalFormat(n),u=this._getRGBABufferInternalSizedFormat(a,n);this._bindTextureDirectly(s,t,!0),this._unpackFlipY(void 0===r||!!r),this._doNotHandleContextLost||(t._bufferView=i,t.format=n,t.invertY=r,t._compression=o),t.width%4!=0&&this._gl.pixelStorei(this._gl.UNPACK_ALIGNMENT,1),o&&i?this._gl.compressedTexImage3D(s,0,this.getCaps().s3tc[o],t.width,t.height,t.depth,0,i):this._gl.texImage3D(s,0,u,t.width,t.height,t.depth,0,l,c,i),t.generateMipMaps&&this._gl.generateMipmap(s),this._bindTextureDirectly(s,null),t.isReady=!0}}Oe.a.prototype.updateRawTexture=function(e,t,i,n,r,o){if(void 0===r&&(r=null),void 0===o&&(o=g.a.TEXTURETYPE_UNSIGNED_INT),e){var a=this._getRGBABufferInternalSizedFormat(o,i),s=this._getInternalFormat(i),c=this._getWebGLTextureType(o);this._bindTextureDirectly(this._gl.TEXTURE_2D,e,!0),this._unpackFlipY(void 0===n||!!n),this._doNotHandleContextLost||(e._bufferView=t,e.format=i,e.type=o,e.invertY=n,e._compression=r),e.width%4!=0&&this._gl.pixelStorei(this._gl.UNPACK_ALIGNMENT,1),r&&t?this._gl.compressedTexImage2D(this._gl.TEXTURE_2D,0,this.getCaps().s3tc[r],e.width,e.height,0,t):this._gl.texImage2D(this._gl.TEXTURE_2D,0,a,e.width,e.height,0,s,c,t),e.generateMipMaps&&this._gl.generateMipmap(this._gl.TEXTURE_2D),this._bindTextureDirectly(this._gl.TEXTURE_2D,null),e.isReady=!0}},Oe.a.prototype.createRawTexture=function(e,t,i,n,r,o,a,s,c){void 0===s&&(s=null),void 0===c&&(c=g.a.TEXTURETYPE_UNSIGNED_INT);var l=new tt.a(this,tt.b.Raw);l.baseWidth=t,l.baseHeight=i,l.width=t,l.height=i,l.format=n,l.generateMipMaps=r,l.samplingMode=a,l.invertY=o,l._compression=s,l.type=c,this._doNotHandleContextLost||(l._bufferView=e),this.updateRawTexture(l,e,n,o,s,c),this._bindTextureDirectly(this._gl.TEXTURE_2D,l,!0);var u=this._getSamplingParameters(a,r);return this._gl.texParameteri(this._gl.TEXTURE_2D,this._gl.TEXTURE_MAG_FILTER,u.mag),this._gl.texParameteri(this._gl.TEXTURE_2D,this._gl.TEXTURE_MIN_FILTER,u.min),r&&this._gl.generateMipmap(this._gl.TEXTURE_2D),this._bindTextureDirectly(this._gl.TEXTURE_2D,null),this._internalTexturesCache.push(l),l},Oe.a.prototype.createRawCubeTexture=function(e,t,i,n,r,o,a,s){void 0===s&&(s=null);var c=this._gl,l=new tt.a(this,tt.b.CubeRaw);l.isCube=!0,l.format=i,l.type=n,this._doNotHandleContextLost||(l._bufferViewArray=e);var u=this._getWebGLTextureType(n),h=this._getInternalFormat(i);h===c.RGB&&(h=c.RGBA),u!==c.FLOAT||this._caps.textureFloatLinearFiltering?u!==this._gl.HALF_FLOAT_OES||this._caps.textureHalfFloatLinearFiltering?u!==c.FLOAT||this._caps.textureFloatRender?u!==c.HALF_FLOAT||this._caps.colorBufferFloat||(r=!1,m.a.Warn("Render to half float textures is not supported. Mipmap generation forced to false.")):(r=!1,m.a.Warn("Render to float textures is not supported. Mipmap generation forced to false.")):(r=!1,a=g.a.TEXTURE_NEAREST_SAMPLINGMODE,m.a.Warn("Half float texture filtering is not supported. Mipmap generation and sampling mode are forced to false and TEXTURE_NEAREST_SAMPLINGMODE, respectively.")):(r=!1,a=g.a.TEXTURE_NEAREST_SAMPLINGMODE,m.a.Warn("Float texture filtering is not supported. Mipmap generation and sampling mode are forced to false and TEXTURE_NEAREST_SAMPLINGMODE, respectively."));var d=t,f=d;l.width=d,l.height=f,!this.needPOTTextures||De.b.IsExponentOfTwo(l.width)&&De.b.IsExponentOfTwo(l.height)||(r=!1),e&&this.updateRawCubeTexture(l,e,i,n,o,s),this._bindTextureDirectly(this._gl.TEXTURE_CUBE_MAP,l,!0),e&&r&&this._gl.generateMipmap(this._gl.TEXTURE_CUBE_MAP);var p=this._getSamplingParameters(a,r);return c.texParameteri(c.TEXTURE_CUBE_MAP,c.TEXTURE_MAG_FILTER,p.mag),c.texParameteri(c.TEXTURE_CUBE_MAP,c.TEXTURE_MIN_FILTER,p.min),c.texParameteri(c.TEXTURE_CUBE_MAP,c.TEXTURE_WRAP_S,c.CLAMP_TO_EDGE),c.texParameteri(c.TEXTURE_CUBE_MAP,c.TEXTURE_WRAP_T,c.CLAMP_TO_EDGE),this._bindTextureDirectly(c.TEXTURE_CUBE_MAP,null),l.generateMipMaps=r,l},Oe.a.prototype.updateRawCubeTexture=function(e,t,i,n,r,o,a){void 0===o&&(o=null),void 0===a&&(a=0),e._bufferViewArray=t,e.format=i,e.type=n,e.invertY=r,e._compression=o;var s=this._gl,c=this._getWebGLTextureType(n),l=this._getInternalFormat(i),u=this._getRGBABufferInternalSizedFormat(n),h=!1;l===s.RGB&&(l=s.RGBA,h=!0),this._bindTextureDirectly(s.TEXTURE_CUBE_MAP,e,!0),this._unpackFlipY(void 0===r||!!r),e.width%4!=0&&s.pixelStorei(s.UNPACK_ALIGNMENT,1);for(var d=0;d<6;d++){var f=t[d];o?s.compressedTexImage2D(s.TEXTURE_CUBE_MAP_POSITIVE_X+d,a,this.getCaps().s3tc[o],e.width,e.height,0,f):(h&&(f=this._convertRGBtoRGBATextureData(f,e.width,e.height,n)),s.texImage2D(s.TEXTURE_CUBE_MAP_POSITIVE_X+d,a,u,e.width,e.height,0,l,c,f))}(!this.needPOTTextures||De.b.IsExponentOfTwo(e.width)&&De.b.IsExponentOfTwo(e.height))&&e.generateMipMaps&&0===a&&this._gl.generateMipmap(this._gl.TEXTURE_CUBE_MAP),this._bindTextureDirectly(this._gl.TEXTURE_CUBE_MAP,null),e.isReady=!0},Oe.a.prototype.createRawCubeTextureFromUrl=function(e,t,i,n,r,o,a,s,c,l,u,h){var d=this;void 0===c&&(c=null),void 0===l&&(l=null),void 0===u&&(u=g.a.TEXTURE_TRILINEAR_SAMPLINGMODE),void 0===h&&(h=!1);var f=this._gl,p=this.createRawCubeTexture(null,i,n,r,!o,h,u,null);t._addPendingData(p),p.url=e,this._internalTexturesCache.push(p);return this._loadFile(e,function(e){!function(e){var i=p.width,o=a(e);if(o){if(s){var l=d._getWebGLTextureType(r),u=d._getInternalFormat(n),_=d._getRGBABufferInternalSizedFormat(r),m=!1;u===f.RGB&&(u=f.RGBA,m=!0),d._bindTextureDirectly(f.TEXTURE_CUBE_MAP,p,!0),d._unpackFlipY(!1);for(var g=s(o),v=0;v<g.length;v++)for(var y=i>>v,b=0;b<6;b++){var T=g[v][b];m&&(T=d._convertRGBtoRGBATextureData(T,y,y,r)),f.texImage2D(b,v,_,y,y,0,u,l,T)}d._bindTextureDirectly(f.TEXTURE_CUBE_MAP,null)}else d.updateRawCubeTexture(p,o,n,r,h);p.isReady=!0,t._removePendingData(p),c&&c()}}(e)},void 0,t.offlineProvider,!0,function(e,i){t._removePendingData(p),l&&e&&l(e.status+" "+e.statusText,i)}),p},Oe.a.prototype.createRawTexture2DArray=it(!1),Oe.a.prototype.createRawTexture3D=it(!0),Oe.a.prototype.updateRawTexture2DArray=nt(!1),Oe.a.prototype.updateRawTexture3D=nt(!0);var rt=function(e){function t(t,i,n,r,o,a,s,c,l){void 0===a&&(a=!0),void 0===s&&(s=!1),void 0===c&&(c=g.a.TEXTURE_TRILINEAR_SAMPLINGMODE),void 0===l&&(l=g.a.TEXTURETYPE_UNSIGNED_INT);var u=e.call(this,null,o,!a,s)||this;return u.format=r,u._engine=o.getEngine(),u._texture=o.getEngine().createRawTexture(t,i,n,r,a,s,c,null,l),u.wrapU=et.a.CLAMP_ADDRESSMODE,u.wrapV=et.a.CLAMP_ADDRESSMODE,u}return Object(h.d)(t,e),t.prototype.update=function(e){this._engine.updateRawTexture(this._texture,e,this._texture.format,this._texture.invertY,null,this._texture.type)},t.CreateLuminanceTexture=function(e,i,n,r,o,a,s){return void 0===o&&(o=!0),void 0===a&&(a=!1),void 0===s&&(s=g.a.TEXTURE_TRILINEAR_SAMPLINGMODE),new t(e,i,n,g.a.TEXTUREFORMAT_LUMINANCE,r,o,a,s)},t.CreateLuminanceAlphaTexture=function(e,i,n,r,o,a,s){return void 0===o&&(o=!0),void 0===a&&(a=!1),void 0===s&&(s=g.a.TEXTURE_TRILINEAR_SAMPLINGMODE),new t(e,i,n,g.a.TEXTUREFORMAT_LUMINANCE_ALPHA,r,o,a,s)},t.CreateAlphaTexture=function(e,i,n,r,o,a,s){return void 0===o&&(o=!0),void 0===a&&(a=!1),void 0===s&&(s=g.a.TEXTURE_TRILINEAR_SAMPLINGMODE),new t(e,i,n,g.a.TEXTUREFORMAT_ALPHA,r,o,a,s)},t.CreateRGBTexture=function(e,i,n,r,o,a,s,c){return void 0===o&&(o=!0),void 0===a&&(a=!1),void 0===s&&(s=g.a.TEXTURE_TRILINEAR_SAMPLINGMODE),void 0===c&&(c=g.a.TEXTURETYPE_UNSIGNED_INT),new t(e,i,n,g.a.TEXTUREFORMAT_RGB,r,o,a,s,c)},t.CreateRGBATexture=function(e,i,n,r,o,a,s,c){return void 0===o&&(o=!0),void 0===a&&(a=!1),void 0===s&&(s=g.a.TEXTURE_TRILINEAR_SAMPLINGMODE),void 0===c&&(c=g.a.TEXTURETYPE_UNSIGNED_INT),new t(e,i,n,g.a.TEXTUREFORMAT_RGBA,r,o,a,s,c)},t.CreateRTexture=function(e,i,n,r,o,a,s,c){return void 0===o&&(o=!0),void 0===a&&(a=!1),void 0===s&&(s=et.a.TRILINEAR_SAMPLINGMODE),void 0===c&&(c=g.a.TEXTURETYPE_FLOAT),new t(e,i,n,g.a.TEXTUREFORMAT_R,r,o,a,s,c)},t}(et.a),ot=function(){function e(e,t,i){this.name=e,this.id=t,this.bones=new Array,this.needInitialSkinMatrix=!1,this.overrideMesh=null,this._isDirty=!0,this._meshesWithPoseMatrix=new Array,this._identity=a.a.Identity(),this._ranges={},this._lastAbsoluteTransformsUpdateId=-1,this._canUseTextureForBones=!1,this._uniqueId=0,this._numBonesWithLinkedTransformNode=0,this._hasWaitingData=null,this.doNotSerialize=!1,this._useTextureToStoreBoneMatrices=!0,this._animationPropertiesOverride=null,this.onBeforeComputeObservable=new o.c,this.bones=[],this._scene=i||R.a.LastCreatedScene,this._uniqueId=this._scene.getUniqueId(),this._scene.addSkeleton(this),this._isDirty=!0;var n=this._scene.getEngine().getCaps();this._canUseTextureForBones=n.textureFloat&&n.maxVertexTextureImageUnits>0}return Object.defineProperty(e.prototype,"useTextureToStoreBoneMatrices",{get:function(){return this._useTextureToStoreBoneMatrices},set:function(e){this._useTextureToStoreBoneMatrices=e,this._markAsDirty()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"animationPropertiesOverride",{get:function(){return this._animationPropertiesOverride?this._animationPropertiesOverride:this._scene.animationPropertiesOverride},set:function(e){this._animationPropertiesOverride=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"isUsingTextureForMatrices",{get:function(){return this.useTextureToStoreBoneMatrices&&this._canUseTextureForBones},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"uniqueId",{get:function(){return this._uniqueId},enumerable:!0,configurable:!0}),e.prototype.getClassName=function(){return"Skeleton"},e.prototype.getChildren=function(){return this.bones.filter(function(e){return!e.getParent()})},e.prototype.getTransformMatrices=function(e){return this.needInitialSkinMatrix&&e._bonesTransformMatrices?e._bonesTransformMatrices:(this._transformMatrices||this.prepare(),this._transformMatrices)},e.prototype.getTransformMatrixTexture=function(e){return this.needInitialSkinMatrix&&e._transformMatrixTexture?e._transformMatrixTexture:this._transformMatrixTexture},e.prototype.getScene=function(){return this._scene},e.prototype.toString=function(e){var t="Name: "+this.name+", nBones: "+this.bones.length;if(t+=", nAnimationRanges: "+(this._ranges?Object.keys(this._ranges).length:"none"),e){t+=", Ranges: {";var i=!0;for(var n in this._ranges)i&&(t+=", ",i=!1),t+=n;t+="}"}return t},e.prototype.getBoneIndexByName=function(e){for(var t=0,i=this.bones.length;t<i;t++)if(this.bones[t].name===e)return t;return-1},e.prototype.createAnimationRange=function(e,t,i){if(!this._ranges[e]){this._ranges[e]=new F(e,t,i);for(var n=0,r=this.bones.length;n<r;n++)this.bones[n].animations[0]&&this.bones[n].animations[0].createRange(e,t,i)}},e.prototype.deleteAnimationRange=function(e,t){void 0===t&&(t=!0);for(var i=0,n=this.bones.length;i<n;i++)this.bones[i].animations[0]&&this.bones[i].animations[0].deleteRange(e,t);this._ranges[e]=null},e.prototype.getAnimationRange=function(e){return this._ranges[e]},e.prototype.getAnimationRanges=function(){var e,t=[];for(e in this._ranges)t.push(this._ranges[e]);return t},e.prototype.copyAnimationRange=function(e,t,i){if(void 0===i&&(i=!1),this._ranges[t]||!e.getAnimationRange(t))return!1;var n,r,o=!0,a=this._getHighestAnimationFrame()+1,s={},c=e.bones;for(r=0,n=c.length;r<n;r++)s[c[r].name]=c[r];this.bones.length!==c.length&&(m.a.Warn("copyAnimationRange: this rig has "+this.bones.length+"