(function() {
    // 戦闘ログのテキストを非表示
    Window_BattleLog.prototype.addText = function(text) {};

    // displayAction も無効化（ログ出さない）
    Window_BattleLog.prototype.displayAction = function(subject, item) {};

    // スプライトセット共有
    var _Scene_Battle_createSpriteset = Scene_Battle.prototype.createSpriteset;
    Scene_Battle.prototype.createSpriteset = function() {
        _Scene_Battle_createSpriteset.call(this);
        Window_BattleLog.prototype._spriteset = this._spriteset;
    };

    // アニメーションの終了を待つ独自コマンドを登録
    Window_BattleLog.prototype.commandWaitForAnimation = function() {
        this.setWaitMode('animation');
    };

    // push() で呼び出せるようマップに登録（←ここが重要）
    Window_BattleLog.prototype._commands = Window_BattleLog.prototype._commands || {};
    Window_BattleLog.prototype._commands['waitForAnimation'] = Window_BattleLog.prototype.commandWaitForAnimation;

    // waitMode: animation の待機処理
    const _updateWaitMode = Window_BattleLog.prototype.updateWaitMode;
    Window_BattleLog.prototype.updateWaitMode = function() {
        if (this._waitMode === 'animation') {
            return this._spriteset && this._spriteset.isAnimationPlaying();
        }
        return _updateWaitMode.call(this);
    };

    // アクション結果表示：演出後にダメージ表示
    Window_BattleLog.prototype.displayActionResults = function(subject, target) {
        const result = target.result();
        if (result.used) {
            this.push('pushBaseLine');
            this.push('waitForAnimation', target);  // ←ここで演出後まで待機

            if (result.critical) {
                this.push('popupCritical', target);
                this.push('wait');
            }

            if (result.evaded) {
                this.push('popupEvade', target);
                this.push('wait');
            } else if (result.missed) {
                this.push('popupMiss', target);
                this.push('wait');
            }

            this.push('popupDamage', target);
            this.push('wait');
            this.push('popBaseLine');
        }
    };

    // 各種ポップアップ演出
    Window_BattleLog.prototype.popupCritical = function(target) {
        SoundManager.playCritical();
        target.startDamagePopup();
    };

    Window_BattleLog.prototype.popupMiss = function(target) {
        SoundManager.playMiss();
        target.startDamagePopup();
    };

    Window_BattleLog.prototype.popupEvade = function(target) {
        SoundManager.playEvasion();
        target.startDamagePopup();
    };

    Window_BattleLog.prototype.popupDamage = function(target) {
        SoundManager.playDamage();
        target.startDamagePopup();
    };
})();
