/*:
 * @target MZ
 * @plugindesc 背景黒幕を保持しつつ画像をその上に表示するZ順制御版相変わらず使い所の狭い…
 * @author C&B
 *
 * @command SetVisuals
 * @desc 背景と装飾画像を指定（img/pictures/）

 * @arg background
 * @type file
 * @dir img/pictures/
 * @desc 背景画像（左上0,0）

 * @arg overlay
 * @type file
 * @dir img/pictures/
 * @desc 装飾画像（左上20,20）
 */

(() => {
  let _bgImage = "";
  let _fgImage = "";

  PluginManager.registerCommand("BarebonesMenuOverlay", "SetVisuals", args => {
    _bgImage = args.background || "";
    _fgImage = args.overlay || "";
  });

  class TransparentMenuCommandWindow extends Window_MenuCommand {
    initialize(rect) { super.initialize(rect); }
    itemHeight() { return super.itemHeight() + 100; }
    drawItemBackground() {}
  }

  const Scene_BarebonesMenu = class extends Scene_MenuBase {
    create() {
      super.create();
      if (this._backgroundSprite) {
        this.setChildIndex(this._backgroundSprite, 0); 
      }
      this.createBackgroundImages();
      this.createCommandWindow();
      this.createGoldWindow();
      this.bringTextWindowsToFront();
    }

    createStatusWindow() {}

    createBackgroundImages() {
      if (_bgImage) {
        const bg = new Sprite(ImageManager.loadPicture(_bgImage));
        bg.x = 80; bg.y = 25;
        bg.opacity = 255;
        bg.alpha = 1.0;
        bg.blendMode = PIXI.BLEND_MODES.NORMAL;
        this.addChildAt(bg, 1); 
      }
      if (_fgImage) {
        const fg = new Sprite(ImageManager.loadPicture(_fgImage));
        fg.x = 120; fg.y = 140;
        fg.opacity = 255;
        fg.alpha = 1.0;
        fg.blendMode = PIXI.BLEND_MODES.NORMAL;
        this.addChildAt(fg, 2);
      }
    }

    createCommandWindow() {
      const ww = 240;
      const wh = (Window_Base.prototype.lineHeight.call(this) + 100) * 4 + 200;
      const wx = Graphics.boxWidth - ww - 20;
      const wy = 40;
      const rect = new Rectangle(wx, wy, ww, wh);
      const win = new TransparentMenuCommandWindow(rect);

      win.clearCommandList();
      win.addCommand("アイテム", "item", $gameParty.exists());
      win.addCommand("オプション", "options", true);
      win.addCommand("セーブ", "save", $gameSystem.isSaveEnabled() && !$gameParty.inBattle());
      win.addCommand("ゲーム終了", "gameEnd", true);

      win.setHandler("item", () => SceneManager.push(Scene_Item));
      win.setHandler("options", () => SceneManager.push(Scene_Options));
      win.setHandler("save", () => SceneManager.push(Scene_Save));
      win.setHandler("gameEnd", () => SceneManager.push(Scene_GameEnd));
      win.setHandler("cancel", this.popScene.bind(this));

      win.opacity = 0;
      win.backOpacity = 0;
      win.contentsOpacity = 255;
      this._commandWindow = win;
      this.addWindow(win);
    }

    createGoldWindow() {
      const ww = 320;
      const wh = this.calcWindowHeight(1, false) + 20;
      const wx = Graphics.boxWidth - ww - 20;
      const wy = Graphics.boxHeight - wh - 20;
      const gold = new Window_Gold(new Rectangle(wx, wy, ww, wh));
      gold.opacity = 0;
      gold.backOpacity = 0;
      gold.contentsOpacity = 255;
      gold.setCursorFixed(true);
      gold.setCursorAll(false);
      gold.deactivate();
      gold.select(-1);
      gold._downArrowSprite.visible = false;
      gold.drawItemBackground = function () {};
      this._goldWindow = gold;
      this.addWindow(gold);
    }

    bringTextWindowsToFront() {
      if (this._commandWindow && this.children.includes(this._commandWindow)) {
        this.setChildIndex(this._commandWindow, this.children.length - 1);
      }
      if (this._goldWindow && this.children.includes(this._goldWindow)) {
        this.setChildIndex(this._goldWindow, this.children.length - 1);
      }
    }
  };

  Scene_Menu = Scene_BarebonesMenu;
})();
