/*:
 * @target MZ
 * @plugindesc 変数9/10を使ったシンプルHPゲージ（中央表示、色変化、幅500、フォント30、0で非表示、透明ウィンドウ）使い道の狭いプラグイン
 * @author C&B
 *
 * @command ShowGauge
 * @text ゲージ表示ON
 * @desc HPゲージを表示します
 *
 * @command HideGauge
 * @text ゲージ表示OFF
 * @desc HPゲージを非表示にします
 */

(() => {
  const pluginName = "SimpleHPGauge_Variable9_10";
  let gaugeVisible = false;

  PluginManager.registerCommand(pluginName, "ShowGauge", () => {
    gaugeVisible = true;
    const win = SceneManager._scene?._hpGaugeWindow;
    if (win) win.visible = true;
  });

  PluginManager.registerCommand(pluginName, "HideGauge", () => {
    gaugeVisible = false;
    const win = SceneManager._scene?._hpGaugeWindow;
    if (win) win.visible = false;
  });

  class Window_SimpleHPGauge extends Window_Base {
    constructor() {
      const w = 800;
      const h = 100;
      const x = Math.floor((1920 - w) / 2);
      const y = 10;
      super(new Rectangle(x, y, w, h));
      this._lastHP = null;
      
      // ウィンドウ背景を透明にする
      this.setBackgroundType(2); // 2 = 透明
      
      this.refresh();
    }

    refresh() {
      this.contents.clear();

      let hp = $gameVariables.value(9);
      let max = Math.max($gameVariables.value(10) || 1, 1);
      if (typeof hp !== "number" || typeof max !== "number") return;

      if (hp > max) {
        hp = max;
        $gameVariables.setValue(9, hp);
      }

      const ratio = hp / max;
      const gaugeW = 500;
      const gaugeH = 40;
      const gaugeX = 20;
      const gaugeY = 20;

      let color = "#22ff44";
      let textColor = ColorManager.textColor(3); // 緑

      if (ratio <= 0.25) {
        color = "#ff4444";
        textColor = ColorManager.textColor(2);
      } else if (ratio <= 0.5) {
        color = "#ffff66";
        textColor = ColorManager.textColor(6);
      }

      this.contents.fillRect(gaugeX, gaugeY, Math.floor(ratio * gaugeW), gaugeH, color);
      this.contents.strokeRect(gaugeX, gaugeY, gaugeW, gaugeH, "#ffffff");

      this.contents.fontSize = 36; // ✅ フォント30
      this.contents.fontFace = 'AprilGothicOne'; 
      const textX = gaugeX + gaugeW + 20;
      const textY = gaugeY + 5;
      const text = `${hp}`;
      const sep = ` / ${max}`;
      const textW = this.textWidth(text);

      this.changeTextColor(textColor);
      this.drawText(text, textX, textY, textW);
      this.changeTextColor(ColorManager.normalColor());
      this.drawText(sep, textX + textW, textY, this.width - textX - textW);
      this.resetTextColor();
    }

    update() {
      super.update();
      this.visible = gaugeVisible;

      const hp = $gameVariables.value(9);
      if (typeof hp !== "number") return;

      if (this._lastHP !== hp) {
        if (hp <= 0 && gaugeVisible) {
          gaugeVisible = false;
          this.visible = false;
        }
        this._lastHP = hp;
        this.refresh();
      }
    }
  }

  const _Scene_Map_createAllWindows = Scene_Map.prototype.createAllWindows;
  Scene_Map.prototype.createAllWindows = function () {
    _Scene_Map_createAllWindows.call(this);
    this._hpGaugeWindow = new Window_SimpleHPGauge();
    this._hpGaugeWindow.visible = gaugeVisible;
    this.addChild(this._hpGaugeWindow);
  };

  const _Scene_Map_update = Scene_Map.prototype.update;
  Scene_Map.prototype.update = function () {
    _Scene_Map_update.call(this);
    this._hpGaugeWindow?.update();
  };
})();