/*:
 * @target MZ
 * @plugindesc 「残りターン◯」を x20 y20 に表示。変数8を反映し、プラグインコマンドで表示ON/OFF制御可能。透明ウィンドウ。使い道の狭いプラグイン
 * @author C&B
 *
 * @command ShowTurnWindow
 * @text ターン表示ON
 * @desc 残りターンウィンドウを表示します
 *
 * @command HideTurnWindow
 * @text ターン表示OFF
 * @desc 残りターンウィンドウを非表示にします
 */

(() => {
  const pluginName = "TurnDisplayWindow";
  let turnWindowVisible = false;

  PluginManager.registerCommand(pluginName, "ShowTurnWindow", () => {
    turnWindowVisible = true;
  });

  PluginManager.registerCommand(pluginName, "HideTurnWindow", () => {
    turnWindowVisible = false;
  });

  class Window_TurnDisplay extends Window_Base {
    constructor() {
      const x = 20;
      const y = 20;
      const width = 320;
      const height = 90;
      super(new Rectangle(x, y, width, height));
      this._lastTurn = null;
      
      // ウィンドウ背景を透明にする
      this.setBackgroundType(2); // 2 = 透明
      
      this.refresh();
    }

    refresh() {
      const turn = $gameVariables.value(8);
      if (this._lastTurn === turn) return;
      this.contents.clear();
      this.contents.fontSize = 42;
      this.contents.fontFace = "AprilGothicOne";
    
      // ✅ 色を変える
      if (turn >= 3) {
        this.changeTextColor(ColorManager.textColor(3)); // 緑
      } else if (turn === 2) {
        this.changeTextColor(ColorManager.textColor(6)); // 黄色
      } else {
        this.changeTextColor(ColorManager.textColor(2)); // 赤
      }
    
      this.drawText(`残りターン　${turn}`, 0, 20, this.contents.width, "left");
      this.resetTextColor(); // 念のため色を元に戻す
      this._lastTurn = turn;
    }

    update() {
      super.update();
      this.visible = turnWindowVisible;

      if (this._fontReadyWait > 0) {
        this._fontReadyWait--;
        if (this._fontReadyWait === 0) this.refresh(); // ✅ フォント待ち完了 → 再描画
        return;
      }

      const turn = $gameVariables.value(8);
      if (this._lastTurn !== turn) {
        this.refresh();
      }
    }
  }

  const _Scene_Map_start = Scene_Map.prototype.start;
  Scene_Map.prototype.start = function () {
    _Scene_Map_start.call(this);
    this._turnWindow = new Window_TurnDisplay();
    this.addChild(this._turnWindow);
  };
})();