/*:
 * @target MZ
 * @plugindesc 変数9が変動したときリアクション（Shake / SE / アニメ）を起こす使い道の狭いプラグイン
 * @author C&B
 *
 * @command EnableReaction
 * @text リアクション有効化
 * @desc 変数9の変動に反応する機能をONにします
 *
 * @command DisableReaction
 * @text リアクション無効化
 * @desc 変数9の変動に反応する機能をOFFにします
 */

(() => {
  const pluginName = "Variable9Reaction";
  let reactionEnabled = false;
  let lastValue = null;

  PluginManager.registerCommand(pluginName, "EnableReaction", () => {
    reactionEnabled = true;
    lastValue = $gameVariables.value(9);
  });

  PluginManager.registerCommand(pluginName, "DisableReaction", () => {
    reactionEnabled = false;
  });

  const _Scene_Map_update = Scene_Map.prototype.update;
  Scene_Map.prototype.update = function () {
    _Scene_Map_update.call(this);
    if (!reactionEnabled) return;

    const cur = $gameVariables.value(9);
    if (typeof cur !== "number") return;

    if (lastValue === null) {
      lastValue = cur;
      return;
    }

    if (cur !== lastValue) {
      if (cur < lastValue) {
        // 📉 減ったとき：Shake + SE
        $gameScreen.startShake(2, 2, 30);
        AudioManager.playSe({ name: "Damage1", volume: 90, pitch: 100, pan: 0 });
      } else if (cur > lastValue) {
        // 📈 増えたとき：アニメ44
        playCenterAnimation(44);
      }

      if (cur <= 0) {
        // 🩸 0以下：アニメ118（中央）
        playCenterAnimation(118);
      }

      lastValue = cur;
    }
  };

  function playCenterAnimation(id) {
    const animation = $dataAnimations[id];
    if (!animation) return;

    const sprite = new Sprite();
    sprite.x = 960; // 横1920中央
    sprite.y = 540; // 縦1080中央
    SceneManager._scene.addChild(sprite);

    const animSprite = new Sprite_Animation();
    animSprite.setup([sprite], animation, false, 0);
    SceneManager._scene.addChild(animSprite);
  }
})();
