/*:
 * @target MZ
 * @plugindesc regionId:99 に「ca」で始まるイベントを互いに上下左右2マス以上離して配置（なんでかって言うとイベ上の説明読みにくいため）
 * @author C&B
 */

(() => {
  let _wasTransferring = false;

  function isIsolated(x, y, placed) {
    return placed.every(ev => {
      const dx = Math.abs(ev.x - x);
      const dy = Math.abs(ev.y - y);
      return dx > 2 || dy > 2;
    });
  }

  function getValidTiles(placed) {
    const tiles = [];
    for (let x = 0; x < $gameMap.width(); x++) {
      for (let y = 0; y < $gameMap.height(); y++) {
        if (
          $gameMap.regionId(x, y) === 99 &&
          $gameMap.isPassable(x, y, 2) &&
          !$gameMap.eventsXy(x, y).length &&
          isIsolated(x, y, placed)
        ) {
          tiles.push({ x, y });
        }
      }
    }
    return tiles;
  }

  function warpCaEventsToRegion99() {
    const all = $gameMap.events();
    const targets = all.filter(ev => ev?.event()?.name?.startsWith("ca"));
    const placed = [];

    for (const ev of targets) {
      const tiles = getValidTiles(placed);
      if (tiles.length === 0) break;
      const pos = tiles[Math.random() * tiles.length | 0];
      ev.setTransparent(true);
      ev.locate(pos.x, pos.y);
      ev.setTransparent(false);
      placed.push(ev);
    }

    SceneManager._scene._spriteset?.createCharacters?.();
  }

  const _Scene_Map_start = Scene_Map.prototype.start;
  Scene_Map.prototype.start = function () {
    _Scene_Map_start.call(this);
    if (_wasTransferring) warpCaEventsToRegion99();
  };

  const _Game_Player_performTransfer = Game_Player.prototype.performTransfer;
  Game_Player.prototype.performTransfer = function () {
    _wasTransferring = true;
    _Game_Player_performTransfer.call(this);
  };

  const _Scene_Map_update = Scene_Map.prototype.update;
  Scene_Map.prototype.update = function () {
    _Scene_Map_update.call(this);
    if (_wasTransferring && !$gamePlayer.isTransferring()) {
      _wasTransferring = false;
    }
  };
})();
