//=============================================================================
// 変数表示プラグイン
// variable_display_plugin.js
//=============================================================================

/*:ja
 * @target MZ
 * @plugindesc 変数0016表示プラグイン v1.0.0
 * @author C&B
 * @version 1.0.0
 * @description 変数0016の値を画面中央に表示し、0.8秒でフェードアウトします。
 *
 * @help variable_display_plugin.js
 * 
 * このプラグインは変数0016の値を画面中央に表示する機能を提供します。
 * 
 * プラグインコマンド:
 * - 変数0016表示: 変数0016の値を画面中央に表示し、0.8秒でフェードアウトします。
 * 
 * @command 変数0016表示
 * @text 変数0016表示
 * @desc 変数0016の値を画面中央に表示します
 */

(() => {
    'use strict';

    const pluginName = 'variable_display_plugin';
    
    // プラグインコマンドの登録
    PluginManager.registerCommand(pluginName, "変数0016表示", args => {
        showVariable0016();
    });

    // 変数0016を表示する関数
    function showVariable0016() {
        // 変数0016の値を取得
        const variableValue = $gameVariables.value(16);
        
        // 表示用のスプライトを作成
        const sprite = new Sprite();
        const bitmap = new Bitmap(600, 300); // フォント拡大に合わせてサイズ拡大
        sprite.bitmap = bitmap;
        
        // 画面中央から150ピクセル上に配置
        sprite.x = (Graphics.width - 600) / 2;
        sprite.y = (Graphics.height - 300) / 2 - 150;
        
        // テキスト描画設定
        bitmap.fontSize = 150; // 50の3倍
        bitmap.textColor = '#ffffff';
        bitmap.outlineColor = '#000000';
        bitmap.outlineWidth = 4;
        
        // 画面中央にテキストを描画
        const text = String(variableValue);
        const textWidth = bitmap.measureTextWidth(text);
        const x = (600 - textWidth) / 2;
        const y = (300 - 150) / 2;
        
        bitmap.drawText(text, x, y, textWidth, 150, 'center');
        
        // 現在のシーンのスプライトセットに追加
        if (SceneManager._scene._spriteset) {
            SceneManager._scene._spriteset.addChild(sprite);
        } else {
            SceneManager._scene.addChild(sprite);
        }
        
        // フェードアウトアニメーション
        let fadeTime = 0;
        const maxFadeTime = 48; // 0.8秒 (60fps × 0.8)
        
        const fadeUpdate = () => {
            fadeTime++;
            
            if (fadeTime <= maxFadeTime) {
                // アルファ値を徐々に下げる
                sprite.alpha = 1 - (fadeTime / maxFadeTime);
                requestAnimationFrame(fadeUpdate);
            } else {
                // フェードアウト完了後、スプライトを削除
                if (sprite.parent) {
                    sprite.parent.removeChild(sprite);
                }
                sprite.bitmap.destroy();
            }
        };
        
        // フェードアウト開始
        fadeUpdate();
    }

    // スクリプトコマンドからも呼び出せるようにグローバル関数として登録
    window.showVariable0016 = showVariable0016;
})();