/*=============================================================================
AB_TurnEndAutoSkillState.js
----------------------------------------------------------------------------
 (C)2022 Anti-Belphetan
 This software is released under the MIT License.
 http://opensource.org/licenses/mit-license.php
----------------------------------------------------------------------------
 Version
 1.0.0 2022/12/09 新規作成
 1.0.1 2023/06/05 全体対象にするとダメージ表示がアニメーションとずれるのに対応
----------------------------------------------------------------------------
 [HP]   : http://kilisamenosekai.web.fc2.com/
 [Twitter]: https://twitter.com/AntiBelphetan
 =============================================================================*/

/*:
 * @target MZ
 * @plugindesc ターン終了時スキル自動発動ステート
 * @author アンチベルフェタン
 * @url http://kilisamenosekai.web.fc2.com/
 *
 *
 * @help AB_TurnEndAutoSkillState.js[ターン終了時スキル自動発動ステート]
 *
 * 毎ターン終了時、自動でスキルが発動するステートが作成できます。
 * かかっている本人が覚えていなくても、行動出来ない状態でも発動します。
 * ステートのメモにタグで設定できます。
 *
 * <autoSkillTurnEnd:114>
 * ----------------------------------------------------------------------------------------------------------------------------------------------------
 */
 (() => {

var parameters = PluginManager.parameters('AB_TurnEndAutoSkillState');
var TURNENDSKILL_PHASE = "TURNEND_SKILL";

var AB_TURNENDAUTOSKILLSTATE_BattleManager_startTurn = BattleManager.startTurn ;
BattleManager.startTurn = function() {
    AB_TURNENDAUTOSKILLSTATE_BattleManager_startTurn.call(this);
    this._autoSkillTurnEndSet = false;
    this._actionAutoSkillTurnEndBattlers = [];
};

var AB_TURNENDAUTOSKILLSTATE_BattleManager_endTurn = BattleManager.endTurn ;
BattleManager.endTurn = function() {
    if(!this._autoSkillTurnEndSet){
        this.makeAutoSkillTurnEndOrders();
        this._autoSkillTurnEndSet = true;
    }
    this._subject = this.getNextAutoSkillTurnEndSubject();
    if (this._subject) {
        this.processAutoSkillTurnEnd();
    }else{
        AB_TURNENDAUTOSKILLSTATE_BattleManager_endTurn.call(this);    
    }
};

BattleManager.processAutoSkillTurnEnd = function() {
    const subject = this._subject;
    const action = subject.currentAction();
    if (action) {
        action.prepare();
        if (action.isValidAutoSkill()) {
            this.startAction();
            this._phase = TURNENDSKILL_PHASE;
        }
        subject.removeCurrentAction();   
    } else {
        this.endAction();
        this._subject = null;
    }
};

var AB_TURNENDAUTOSKILLSTATE_BattleManager_updatePhase = BattleManager.updatePhase ;
BattleManager.updatePhase = function(timeActive) {
    if(this._phase == TURNENDSKILL_PHASE){
        if(!this.isBusy()){
            this.updateAction();
        }
    }else{
        AB_TURNENDAUTOSKILLSTATE_BattleManager_updatePhase.call(this,timeActive);
    }
};

Game_Action.prototype.isValidAutoSkill = function() {

    return (this._forcing && this.item() );
};

BattleManager.getNextAutoSkillTurnEndSubject = function() {
    for (;;) {
        const battler = this._actionAutoSkillTurnEndBattlers.shift();
        if (!battler) {
            return null;
        }
        if (battler.isBattleMember() && battler.isAlive()) {
            return battler;
        }
    }
};

BattleManager.makeAutoSkillTurnEndOrders = function() {
    const battlers = [];
    for (const battler of $gameParty.battleMembers()) {
        for (const state of battler.states()) {
            if(state.meta.autoSkillTurnEnd){
                battler.CreateAutoSkillAction(Number(state.meta.autoSkillTurnEnd));
            }
            if(battler._actions.length > 0)
            {
                battlers.push(battler);
            }
        }
    }
    for (const battler of $gameTroop.members()) {
        for (const state of battler.states()) {
            if(state.meta.autoSkillTurnEnd){
                battler.CreateAutoSkillAction(Number(state.meta.autoSkillTurnEnd));
            }
            if(battler._actions.length > 0)
            {
                battlers.push(battler);
            }
        }
    }
    for (const battler of battlers) {
        battler.makeSpeed();
    }
    battlers.sort((a, b) => b.speed() - a.speed());
    this._actionAutoSkillTurnEndBattlers = battlers;
};

Game_Battler.prototype.CreateAutoSkillAction = function(skillId) {
    var action = new Game_Action(this, true);
    action.setSkill(skillId);
    action.setTarget(this._lastTargetIndex);
    this._actions.push(action);
};

})();