//=============================================================================
// keke_PattoMute - パッとミュート
// バージョン: 1.1.2
//=============================================================================
// Copyright (c) 2021 ケケー
// Released under the MIT license
// http://opensource.org/licenses/mit-license.php
//=============================================================================

/*:
 * @target MZ
 * @plugindesc ゲームの音を1ボタンでミュートする
 * @author ケケー
 * @url https://kekeelabo.com
 * 
 *
 *
 * @help
 * 【ver.1.1.2】
 * キーボードの M を押すとゲームの音が消える
 * もう一度押すと元に戻る
 * 起動時からミュートにしておくことも可能
 * ツクールMZ/MV両対応
 *
 *【利用規約】
 * MITライセンスのもと、自由に使ってくれて大丈夫です
 * 
 * 
 * 
 * Mute the game sound by pressing M on the keyboard
 * Press again to undo
 * It is also possible to mute from the start
 * Compatible with both Maker MZ/MV
 *
 *【terms of service】
 * Feel free to use it under the MIT license.
 * 
 * 
 * 
 * @param 起動時にミュート
 * @desc ゲーム起動時にミュートにする
 * @type boolean
 * @default false
 */



(() => {
    //- プラグイン名
    const pluginName = document.currentScript.src.match(/^.*\/(.*).js$/)[1];


    //- パラメータ受け取り
    let parameters = PluginManager.parameters(pluginName);

    let keke_muteOnBoot = parameters["起動時にミュート"];
    keke_muteOnBoot = keke_muteOnBoot == "true" ? true : false;

    parameters = null;
    

    //- 新しいキーを追加
    Input.keyMapper['77'] = 'm';


    //- 起動時にミュート(コア追加)
    const _Scene_Boot_start = Scene_Boot.prototype.start;
    Scene_Boot.prototype.start = function() {
        _Scene_Boot_start.apply(this);
        if (keke_muteOnBoot) {
            // MVの場合
            if (typeof(ColorManager) == "undefined") {
                AudioManager.masterVolume = 0;
            // MZの場合
            } else {
                muteOn();
            }
        }
    };


    //- ミュートの更新-MV(コア追加)
    if (typeof(ColorManager) == "undefined") {
    const _Scene_Base_update = Scene_Base.prototype.update;
    Scene_Base.prototype.update = function() {
        _Scene_Base_update.call(this);
        if (Input.isTriggered('m')) {
            let masterVol = AudioManager.masterVolume;
            if (masterVol) {
                AudioManager.masterVolume = 0;
            } else {
                AudioManager.masterVolume = 1;
            }
        };
    };
    };
    
    
    //- ミュートの更新-MZ(コア追加)
    if (typeof(ColorManager) != "undefined") {
    const _Scene_Base_update = Scene_Base.prototype.update;
    Scene_Base.prototype.update = function() {
        _Scene_Base_update.call(this);
        if (Input.isTriggered('m')) {
            let mute = $gameTemp._muteKe;
            if (!mute) {
                muteOn();
            } else {
                muteOff();
            }
        };
    };
    };


    //- ミュートオン
    function muteOn() {
        $gameTemp._bgmVolPreKe = AudioManager.bgmVolume;
        $gameTemp._bgsVolPreKe = AudioManager.bgsVolume;
        $gameTemp._meVolPreKe = AudioManager.meVolume;
        $gameTemp._seVolPreKe = AudioManager.seVolume;
        AudioManager.bgmVolume = 0;
        AudioManager.bgsVolume = 0;
        AudioManager.meVolume = 0;
        AudioManager.seVolume = 0;
        $gameTemp._muteKe = true
    };


    //- ミュートオフ
    function muteOff() {
        AudioManager.bgmVolume = $gameTemp._bgmVolPreKe;
        AudioManager.bgsVolume = $gameTemp._bgsVolPreKe;
        AudioManager.meVolume = $gameTemp._meVolPreKe;
        AudioManager.seVolume = $gameTemp._seVolPreKe;
        $gameTemp._muteKe = null;
    };

})();