/*:
 * @target MV
 * @plugindesc 1.0.0 用 CBR_eroStatus 替换默认状态栏
 * @author Custom (基于 CBR_eroStatus)
 *
 * @help OverrideStatus.js
 * 无参数。只需放在 CBR_eroStatus_main.js 下方启用。
 * 点击菜单“状态”即打开 CBR 自定义屏。
 */

(() => {
    'use strict';

    // 1. 重定向默认 status 命令到 Scene_EroStatus
    const _Scene_Menu_onStatusSelect = Scene_Menu.prototype.onStatusSelect;
    Scene_Menu.prototype.onStatusSelect = function() {
        SceneManager.push(Scene_EroStatus);
    };

    // 2. 移除 CBR 添加的 eroStatus 命令
    const _Window_MenuCommand_makeCommandList = Window_MenuCommand.prototype.makeCommandList;
    Window_MenuCommand.prototype.makeCommandList = function() {
        _Window_MenuCommand_makeCommandList.call(this);
        const list = this._list;
        const index = list.indexOf('eroStatus');
        if (index !== -1) {
            list.splice(index, 1);
            this.createContents();
            this.drawAllItems();
        }
    };
})();