//=================================================================================================
// WE_Task.js
//=================================================================================================
/*:
* @plugindesc 任务数据+窗口+场景。
* @author 芯☆淡茹水
* @help
* ☆ 任务编辑 ☆
* 1，所有任务编辑在 数据库-公共事件 里， 公共事件ID 就是该 任务的ID。
*
* 2，主线/支线 任务区分 => 在 公共事件 任意位置写 注释：<MainTask>  表示为 主线任务，
*    未写的，默认为 支线任务 。
*
* 3，任务描述 的编辑 =>  在 公共事件 任意位置写 注释：<Des> ,后面写任务描述内容，
*    编写的文本与对话框一样，支持符号。
*
* 4，任务完成条件 的编辑 => 在 公共事件 任意位置写 注释，条件分为以下三种：
*
*    A  杀敌数   =>  写注释：<KM:id=n>
*       id :敌人ID。
*       n  :需要消灭的数量。
*       例: 需要消灭 5 号敌人 10 个 => 注释：<KM:5=10>
*
*    B  变量值   =>  写注释：<VL:id=n>
*       id :变量ID。
*       n  :需要的值。
*       例: 需要 12 号变量值达到 5  => 注释：<VL:12=5>
*
*    C  开关的 开/闭 状态   =>  写注释：<SW:id>
*       id :开关ID。
*       例: 需要 8 号开关打开 => 注释：<SW:8>
*
* 5，第 4 条设置的 变量/开关 条件，都会显示在任务界面里。
*    开关/变量就直接显示其名字 ，所以取开关/变量名字稍微考虑着任务的显示问题，
*    比如给开关取名字： 与村长对话 
*    比如给变量取名字： 需要药水的数量
*
* 6，任务奖励 的编辑。
*    任务用插件命令完成它后，会自动运行这个任务（公共事件），所以，奖品的编辑
*    为正常的事件项。
*
*    显示到任务界面的事件项有：
*    A  增加某变量值。
*    B  增加金钱。
*    C  增加物品。
*    D  增加武器。
*    E  增加防具。
*    F  增加经验。
*
*    任务界面显示奖品，会以 图标+名字+数量 的形式显示。
*    金钱与经验图标，该插件设置项有设置。
*    变量的图标设置 =>  变量名^图标序号
*    比如设置某变量为 88 号图标，命名 => 帮派贡献度^88
*
*
* ☆ 插件命令 ☆
* 1，接取一个任务 => TakeTask id
*    id :任务ID（公共事件ID）
*    例：接取第 22 号任务 => TakeTask 22
*    ＜若任务之前已经接取，此条命令无效＞
*
* 2，重新再次接已经完成的任务 => ReTakeTask id
*    id :任务ID（公共事件ID）
*   例：再次接取第 8 号任务 => ReTakeTask 8
*    ＜若任务未接取，此条命令无效＞
*    ＜若任务未完成，此条命令无效＞
*    ＜此条命令会自动将任务条件的 变量归 0 ，开关关闭＞
*
* 3，完成任务 => CptTask id
*    id :任务ID（公共事件ID）
*    例：完成第 15 号任务 => cptTask 15
*    ＜若任务未接取，此条命令无效＞
*    ＜若任务任意条件未满足，此条命令无效＞
*
* 4，强制完成任务 => ForceCptTask id
*    id :任务ID（公共事件ID）
*   ＜若任务未接取，此条命令无效＞
*   ＜此命令忽视任务的条件，满足或未满足条件时都会完成＞
*
*
* ☆ 脚本判断 ☆
* 1，判断一个任务是否接取 => 事件-条件-脚本：$gameParty.hasTask(id);
*    id :任务ID（公共事件ID）
*    例：判断是否接取了 8 号任务 => 事件-条件-脚本：$gameParty.hasTask(8);
*
* 2，判断一个任务是否满足所以条件 => 事件-条件-脚本：$gameParty.isTaskMeet(id);
*    id :任务ID（公共事件ID）
*    例：判断 15 号任务所有条件是否满足达成 => 
*       事件-条件-脚本：$gameParty.isTaskMeet(15);
*
* 3，判断任务某个子任务是否满足条件 => 事件-条件-脚本：$gameParty.isChildMeet(id, n);
*    id :任务ID（公共事件ID）
*    n  :子任务序号。
*    例：判断 13 号任务的第 1 个子任务是否满足条件 => 
*       事件-条件-脚本：$gameParty.isChildMeet(13, 1);
*
*
*
*
*
* @param goldIcon
* @desc 金钱图标序号。
* @default 314
*
* @param expIcon
* @desc 经验图标序号。
* @default 70
*
* @param sysColor
* @desc 系统文字颜色号。
* @default 20
*
* @param nameColor
* @desc 任务名字颜色号。
* @default 11
*/
//=================================================================================================
var XdRsData = XdRsData || {};
XdRsData.weTask = XdRsData.weTask || {};
XdRsData.weTask.params = PluginManager.parameters('XdRs_WE_Task');
XdRsData.weTask.getIconIndex = function(type) {
    return +(this.params[type+'Icon'] || 0);
};
XdRsData.weTask.getColor = function(sym) {
    return +(this.params[sym+'Color'] || 0);
};
XdRsData.weTask.codeData = function() {
    return [122,125,126,127,128,315];
};
XdRsData.weTask.isItemCode = function(code) {
    return this.codeData().contains(code);
};
XdRsData.weTask.getType = function(list) {
    var index = this.codeData().indexOf(list.code)
    return ['VL','GD','IM','WP','AM','EX'][index];
};
XdRsData.weTask.getId = function(list) {
    return [125, 315].contains(list.code) ? 0 : list.parameters[0];
};
XdRsData.weTask.getNum = function(list) {
    if (list.code === 125) return list.parameters[2];
    if ([122, 315].contains(list.code)) return list.parameters[4];
    return list.parameters[3];
};
//=================================================================================================
XdRsData.weTask.BMgainRewards = BattleManager.gainRewards;
BattleManager.gainRewards = function() {
    XdRsData.weTask.BMgainRewards.call(this);
    $gameTroop.members().forEach(function(m){
        m.isDead() && $gameSystem.addkilledNum(m.enemyId());
    });
};
//=================================================================================================
Game_System.prototype.killRecord = function() {
    return this._killRecord || {};
};
Game_System.prototype.killedNum = function(enemyId) {
    return this.killRecord()[enemyId] || 0;
};
Game_System.prototype.totalKilledNum = function() {
    var data = Object.keys(this.killRecord()).map(function(id){
        return this.killRecord()[id];
    }, this);
    return eval(data.join('+')) || 0;
};
Game_System.prototype.addkilledNum = function(enemyId) {
    this._killRecord = this._killRecord || {};
    this._killRecord[enemyId] = (this._killRecord[enemyId] || 0) + 1;
};
//=================================================================================================
function XdRs_Item() {
    this.initialize.apply(this, arguments);
}
XdRs_Item.prototype.initialize = function(list) {
    this._type    = XdRsData.weTask.getType(list);
    this._dataId  = XdRsData.weTask.getId(list);
    this._dataNum = XdRsData.weTask.getNum(list);
};
XdRs_Item.prototype.item = function() {
    switch(this._type) {
        case 'IM' : return $dataItems[this._dataId];
        case 'WP' : return $dataWeapons[this._dataId];
        case 'AM' : return $dataArmors[this._dataId];
    }
    return null;
};
XdRs_Item.prototype.valName = function() {
    var text = $dataSystem.variables[this._dataId];
    return text.split(/\^/)[0] || '';
};
XdRs_Item.prototype.valIconIndex = function() {
    var text = $dataSystem.variables[this._dataId];
    return +(text.split(/\^/)[1] || 0);
};
XdRs_Item.prototype.iconIndex = function() {
    if (this.item()) return this.item().iconIndex;
    switch(this._type) {
        case 'GD' : return XdRsData.weTask.getIconIndex('gold');
        case 'EX' : return XdRsData.weTask.getIconIndex('exp');
        case 'VL' : return this.valIconIndex();
    }
};
XdRs_Item.prototype.name = function() {
    if (this.item()) return this.item().name;
    switch(this._type) {
        case 'GD' : return TextManager.currencyUnit;
        case 'EX' : return TextManager.exp;
        case 'VL' : return this.valName();
    }
};
XdRs_Item.prototype.numText = function() {
    return (this.item() ? 'x ' : '+ ') + this._dataNum;
};
//=================================================================================================
function Task_Condition() {
    this.initialize.apply(this, arguments);
}
Task_Condition.prototype.initialize = function(type, dataId, dataMax) {
    this._type = type;
    this._dataId = dataId;
    this._dataMax = dataMax;
    this.setup();
};
Task_Condition.prototype.setup = function() {
    this._killData = this._type === 'KM' ? this.killedNum() : 0;
    switch(this._type) {
        case 'VL' : return $gameVariables.setValue(this._dataId, 0);
        case 'SW' : return $gameSwitches.setValue(this._dataId, false);
    }
};
Task_Condition.prototype.killedNum = function() {
    return $gameSystem.killedNum(this._dataId);
};
Task_Condition.prototype.nowKilled = function() {
    return this.killedNum() - this._killData;
};
Task_Condition.prototype.nowNum = function() {
    switch(this._type) {
        case 'KM' : return Math.min(this.nowKilled(), this._dataMax);
        case 'VL' : return Math.min($gameVariables.value(this._dataId), this._dataMax);
        case 'SW' : return $gameSwitches.value(this._dataId) ? 1 : 0;
    }
    return ''; 
};
Task_Condition.prototype.maxNum = function() {
    return this._type === 'SW' ? 1 : this._dataMax;
};
Task_Condition.prototype.frontText = function() {
    switch(this._type) {
        case 'KM' : return gl_translate('消灭敌人<' + $dataEnemies[this._dataId].name+'> :');
        case 'VL' : return $dataSystem.variables[this._dataId] + ' :';
        case 'SW' : return $dataSystem.switches[this._dataId] + ' :';
    }
    return '';
};
Task_Condition.prototype.numText = function() {
    return ''+this.nowNum()+'/'+this.maxNum();
};
Task_Condition.prototype.text = function() {
    return this.frontText() + this.numText();
};
Task_Condition.prototype.isMeet = function() {
    switch(this._type) {
        case 'KM' : return this.nowKilled() >= this._dataMax;
        case 'VL' : return $gameVariables.value(this._dataId) >= this._dataMax;
        case 'SW' : return $gameSwitches.value(this._dataId);
    }
    return false;
};
Task_Condition.prototype.rate = function(max) {
    return this.nowNum() / this.maxNum() * max;
};
//=================================================================================================
function Game_Task() {
    this.initialize.apply(this, arguments);
}
Game_Task.prototype.initialize = function(eventId) {
    this._eventId = eventId;
    this.initData();
};
Game_Task.prototype.event = function() {
    return $dataCommonEvents[this._eventId];
};
Game_Task.prototype.initData = function() {
    this._type = this.isMainTask() ? 0 : 1;
    this._finished = false;
    this._conditions = [];
    this._prizies = [];
    this.event().list.forEach(this.analysisList.bind(this));
};
Game_Task.prototype.analysisList = function(list) {
    if (XdRsData.weTask.isItemCode(list.code)) {
        this._prizies.push(new XdRs_Item(list));
    }
    if (list.code === 108) {
        this.cndSymData().forEach(function(sym){
            var text = this.getCndNote(list, sym);
            if (text) {
                var id  = this.getCndId(sym, text);
                var num = this.getCndNum(sym, text);
                this._conditions.push(new Task_Condition(sym, id, num));
            }
        }, this);
    }
};
Game_Task.prototype.cndSymData = function() {
    return ['KM','VL','SW'];
};
Game_Task.prototype.isMainTask = function() {
    return this.event().list.some(function(l){
        return l.code === 108 && /<MainTask>/.test(l.parameters[0]);
    });
};
Game_Task.prototype.getCndNote = function(list, sym) {
    var reg = new RegExp('<'+sym+':(\\S+)>');
    return list.parameters[0].match(reg) ? RegExp.$1 : null;
};
Game_Task.prototype.getCndId = function(sym, text) {
    return sym === 'SW' ? +text : +(text.split(/=/)[0] || 0);
};
Game_Task.prototype.getCndNum = function(sym, text) {
    return sym === 'SW' ? 0 : +(text.split(/=/)[1] || 0);
};
Game_Task.prototype.id = function() {
    return this._eventId;
};
Game_Task.prototype.name = function() {
    return this.event().name;
};
Game_Task.prototype.des = function() {
    var list = this.event().list.filter(function(l){
        return l.code === 108 && l.parameters[0].match(/<Des>/);
    }).shift();
    if (!list) return '';
    var text = list.parameters[0].replace(/<Des>/, '');
    var index = this.event().list.indexOf(list);
    for (var i=index;i<this.event().list.length;i++){
        if (i === index) continue;
        var n_list = this.event().list[i];
        if (n_list.code === 408) {
            text += '\n' + n_list.parameters[0];
        }
    }
    return text;
};
Game_Task.prototype.type = function() {
    return this._type;
};
Game_Task.prototype.prizies = function() {
    return this._prizies;
};
Game_Task.prototype.conditions = function() {
    return this._conditions;
};
Game_Task.prototype.cptRate = function() {
    var max = 100 / (this.conditions().length || 1);
    var arr = this.conditions().map(function(c){return c.rate(max);});
    return eval(arr.join('+')) || 0;
};
Game_Task.prototype.isMeetConditions = function(unCnt) {
    if (!this.conditions().length || unCnt) return true;
    return this.conditions().every(function(c){return c.isMeet();});
};
Game_Task.prototype.isChildMeet = function(index) {
    var cdt = this.conditions()[index];
    return cdt && cdt.isMeet();
};
Game_Task.prototype.haveFinished = function() {
    return this._finished;
};

Game_Task.prototype.complete = function(unCnt) {
    if (this.haveFinished() || !this.isMeetConditions(unCnt)) return;
    this._finished = true;
    $gameTemp.reserveCommonEvent(this._eventId);
	let rs = 0;
	if($gamePlayer.finishedMap == undefined ||$gamePlayer.finishedMap == null){
		$gamePlayer.finishedMap = {};
	}else{
		rs = $gamePlayer.finishedMap[this._eventId]
	}
	$gamePlayer.finishedMap[this._eventId] = (rs + 1);
};

Game_Task.prototype.reTake = function() {
    this._finished = false;
    this._conditions.forEach(function(c){c.setup();});
};
//=================================================================================================
XdRsData.weTask.GPinitAllItems = Game_Party.prototype.initAllItems;
Game_Party.prototype.initAllItems = function() {
    XdRsData.weTask.GPinitAllItems.call(this);
    this._tasks = [];
};
Game_Party.prototype.tasks = function() {
    return this._tasks;
};
Game_Party.prototype.getTask = function(id) {
    return this._tasks.filter(function(t){ return t.id() === id; }).shift();
};
Game_Party.prototype.hasTask = function(id) {
    return !!this.getTask(id);
};
Game_Party.prototype.isTaskMeet = function(id) {
    var task = this.getTask(id);
    return task && task.isMeetConditions();
};
Game_Party.prototype.isChildMeet = function(id, n) {
    var task = this.getTask(id);
    return task && task.isChildMeet(n-1);
};
Game_Party.prototype.takeTask = function(id) {
    if (this.hasTask(id)) return;
    this._tasks.push(new Game_Task(id));
};

Game_Party.prototype.isFinishedTask = function(id) {
	if(!this.hasTask(id)){
		return false;
	}
	let _task = this.getTask(id);
	return _task.haveFinished();
};


Game_Party.prototype.hasBeenFinishedTask = function(id) {
	if($gamePlayer.finishedMap == undefined || $gamePlayer.finishedMap ==null){
		return false;
	}
	let rs = $gameParty.finishedMap[id];
	return (rs != undefined && rs != null && rs > 0);
};


Game_Party.prototype.getFinishedTaskCnt = function(id) {
	if(!hasBeenFinishedTask(id)){
		return 0;
	}
	return $gameParty.finishedMap[id];
};


Game_Party.prototype.reTakeTask = function(id) {
    var task = this.getTask(id);
    task && task.haveFinished() && task.reTake();
};
Game_Party.prototype.completeTask = function(id, unCnt) {
    var task = this.getTask(id);
    task && task.complete(unCnt);
};
Game_Party.prototype.taskNumText = function(type) {
    var tasks = this.tasks().filter(function(t){ return t.type() === type;});
    var fsTasks = tasks.filter(function(t){ return t.haveFinished();});
    return ''+fsTasks.length +'/' + tasks.length;
};
//=================================================================================================
XdRsData.weTask.GIpluginCommand = Game_Interpreter.prototype.pluginCommand;
Game_Interpreter.prototype.pluginCommand = function(command, args) {
    XdRsData.weTask.GIpluginCommand.call(this, command, args);
    command === 'TakeTask'     && $gameParty.takeTask(+args[0]);
    command === 'ReTakeTask'   && $gameParty.reTakeTask(+args[0]);
    command === 'CptTask'      && $gameParty.completeTask(+args[0]);
    command === 'ForceCptTask' && $gameParty.completeTask(+args[0], true);
};
//=================================================================================================
function XdRs_TaskList() {
    this.initialize.apply(this, arguments);
}
XdRs_TaskList.prototype = Object.create(Ui_Window.prototype);
XdRs_TaskList.prototype.constructor = XdRs_TaskList;
XdRs_TaskList.prototype.initialize = function() {
    this._type = 0;
    this._typeIndex = 0;
    var x = (Graphics.width - 504) / 2;
    var y = (Graphics.height - 354) / 2;
    Ui_Window.prototype.initialize.call(this, x, y, new Rectangle(1450,496,504,354), 'Ui_Menu1');
    this.refresh();
};
XdRs_TaskList.prototype.addCursor = function() {
    this._cursor = new Ui_Cursor();
    this.refreshCursorLocation();
    this.addChild(this._cursor);
};
XdRs_TaskList.prototype.createButtons = function() {
    this.createPageButtons(32,198,472,198);
    this._pageL.setPressMethod(this.inputOnKeyLeft.bind(this));
    this._pageR.setPressMethod(this.inputOnKeyRight.bind(this));
};
XdRs_TaskList.prototype.refreshCursorLocation = function() {
    if (!this._cursor) return;
    var x = this._type ? 48 : this._typeIndex * 208 + 84;
    var y = this._type ? this._index * 26 + 56 : 12;
    this._cursor.move(x, y);
};
XdRs_TaskList.prototype.maxItems = function() {
    return 6;
};
XdRs_TaskList.prototype.items = function() {
    return $gameParty.tasks().filter(function(t){
        return t.type() === this._typeIndex;
    }, this);
};
XdRs_TaskList.prototype.item = function() {
    return this._type ? Ui_Window.prototype.item.call(this) : null;
};
XdRs_TaskList.prototype.refresh = function() {
    Ui_Window.prototype.refresh.call(this);
    this.drawTaskDes();
};
XdRs_TaskList.prototype.refreshIndexChanged = function() {
    Ui_Window.prototype.refreshIndexChanged.call(this);
    this.drawTaskDes();
};
XdRs_TaskList.prototype.textExWidth = function() {
    return 442;
};
XdRs_TaskList.prototype.drawPage = function() {
    this.drawPageMessage(220, 322);
};
XdRs_TaskList.prototype.drawItem = function(index) {
    var item = this.pageItems()[index];
    if (!item) return;
    var rect = this.itemRect(index);
    this.changeFontColor();
    this.drawText(item.name(), rect.x, rect.y, rect.width);
    var text  = item.haveFinished() ? '已完成' : '完成度:'+item.cptRate() + '%';
    var color = item.haveFinished() ? 'rgb(0,200,0)' : 'rgb(255,200,0)';
    this.changeTextColor(color);
    this.drawText(text, rect.x, rect.y, rect.width, 'right');
};
XdRs_TaskList.prototype.drawTaskDes = function() {
    this.clearRect(52, 230, 396, 88);
    if (!this.item()) return;
    this.drawTextEx(this.item().des(), 64, 230);
};
XdRs_TaskList.prototype.changeType = function(type, okSound) {
    var lastType = this._type;
    this._type = type;
    if (lastType !== this._type) {
        okSound ? SoundManager.playOk() : SoundManager.playCancel();
        this._index = 0;
        this.setupWait();
        this.refresh();
        this.refreshCursorLocation();
    }
};
XdRs_TaskList.prototype.selectTypeIndex = function(index) {
    var lastIndex = this._typeIndex;
    this._typeIndex = index;
    if (lastIndex !== this._typeIndex) {
        SoundManager.playCursor();
        this.refresh();
        this.refreshCursorLocation();
    }
};
XdRs_TaskList.prototype.rollTypeIndex = function() {
    var index = (this._typeIndex + 1) % 2;
    this.selectTypeIndex(index);
};
XdRs_TaskList.prototype.itemRect = function(index) {
    return new Rectangle(80, index * 26 + 60, 356, 26);
};
XdRs_TaskList.prototype.typeLocalRect = function(index) {
    var x = this.localX();
    var y = this.localY();
    return new Rectangle(index * 208 + 110 + x, 12 + y, 72, 34);
};
XdRs_TaskList.prototype.inputOnOk = function() {
    this._type ? this.callOkHandler() : this.changeType(1, true);
};
XdRs_TaskList.prototype.inputOnCancel = function() {
    this._type ? this.changeType(0) : this.callCancelHandler();
};
XdRs_TaskList.prototype.inputOnKeyUp = function() {
    this._type && this.rollIndex(0);
};
XdRs_TaskList.prototype.inputOnKeyDown = function() {
    this._type && this.rollIndex(1);
};
XdRs_TaskList.prototype.inputOnKeyLeft = function() {
    this._type ? this.turnPage(0) : this.rollTypeIndex();
};
XdRs_TaskList.prototype.inputOnKeyRight = function() {
    this._type ? this.turnPage(1) : this.rollTypeIndex();
};
XdRs_TaskList.prototype.touchTypeAction = function() {
    for (var i=0;i<2;i++) {
        if (TouchInput.inRect(this.typeLocalRect(i))) {
            if (this._typeIndex === i) return this.changeType(1, true);
            if (this._typeIndex !== i) return this.selectTypeIndex(i);
        }
    }
};
XdRs_TaskList.prototype.touchItemAction = function() {
    this._type ? Ui_Window.prototype.touchItemAction.call(this) : this.touchTypeAction();
};
//=================================================================================================
function XdRs_TaskMessage() {
    this.initialize.apply(this, arguments);
}
XdRs_TaskMessage.prototype = Object.create(Ui_Window.prototype);
XdRs_TaskMessage.prototype.constructor = XdRs_TaskMessage;
XdRs_TaskMessage.prototype.initialize = function() {
    var x = (Graphics.width - 488) / 2;
    var y = (Graphics.height - 376) / 2;
    Ui_Window.prototype.initialize.call(this, x, y, new Rectangle(968,40,488,376), 'Ui_Menu1');
    this.setTask(null);
};
XdRs_TaskMessage.prototype.lineHeight = function(task) {
    return 24;
};
XdRs_TaskMessage.prototype.setTask = function(task) {
    var lastTask = this._task;
    this._task = task;
    lastTask !== this._task && this.refreshTaskChanged();
};
XdRs_TaskMessage.prototype.refreshTaskChanged = function() {
    this._task ? this.show() : this.hide();
    this._task ? this.activate() : this.deactivate();
    this.refresh();
};
XdRs_TaskMessage.prototype.textExWidth = function() {
    return 472;
};
XdRs_TaskMessage.prototype.drawOther = function() {
    if (!this._task) return;
    this.drawSysWord();
    this.drawTaskName();
    this.drawTaskDes();
    this.drawTaskCpt();
    this.drawTaskPrizies();
};
XdRs_TaskMessage.prototype.drawSysWord = function() {
    this.changeFontSize(22);
    this.changeFontColor(XdRsData.weTask.getColor('sys'));
    this.contents.drawText('任务描述:', 244, 60, 160, 30);
    this.contents.drawText('完成条件:', 20,  60, 160, 30);
    this.contents.drawText('任务奖励:', 20, 200, 160, 30);
};
XdRs_TaskMessage.prototype.drawTaskName = function() {
    this.changeFontSize(24);
    this.changeFontColor(XdRsData.weTask.getColor('name'));
    this.contents.drawText(this._task.name(), 0, 18, 488, 30, 'center');
};
XdRs_TaskMessage.prototype.drawTaskDes = function() {
    this.changeFontSize(20);
    this.changeFontColor();
    this.drawTextEx(this._task.des(), 260, 90);
};
XdRs_TaskMessage.prototype.drawTaskCpt = function() {
    this.changeFontSize(18);
    for (var i=0;i<this._task.conditions().length;i++) {
        var cpt = this._task.conditions()[i];
        this.changeFontColor();
        this.contents.drawText(cpt.frontText(), 26, i*24+94, 192, 24);
        var color = cpt.isMeet() ? 'rgb(0,200,0)' : 'rgb(255,200,0)';
        this.changeTextColor(color);
        this.contents.drawText(cpt.numText(), 26, i*24+94, 192, 24, 'right');
    }
};
XdRs_TaskMessage.prototype.drawTaskPrizies = function() {
    this.changeFontSize(18);
    this.changeFontColor();
    for (var i=0;i<this._task.prizies().length;i++) {
        var prize = this._task.prizies()[i];
        this.zoomOutIcon(26, i*26+232, prize.iconIndex(), 26);
        this.contents.drawText(prize.name(), 56, i*26+232, 192, 26);
        this.contents.drawText(prize.numText(), 56, i*26+232, 192, 26, 'right');
    }
};
//=================================================================================================
function Window_TaskType() {
    this.initialize.apply(this, arguments);
}
Window_TaskType.prototype = Object.create(Window_Command.prototype);
Window_TaskType.prototype.constructor = Window_TaskType;
Window_TaskType.prototype.initialize = function() {
    var x = (Graphics.width - 750) / 2;
    Window_Command.prototype.initialize.call(this, x, 33);
    this.activate();
};
Window_TaskType.prototype.windowWidth = function() {
    return 750;
};
Window_TaskType.prototype.windowHeight = function() {
    return 72;
};
Window_TaskType.prototype.numVisibleRows = function() {
    return 1;
};
Window_TaskType.prototype.maxCols = function() {
    return 2;
};
Window_TaskType.prototype.itemTextAlign = function() {
    return 'center';
};
Window_TaskType.prototype.makeCommandList = function() {
    this.addCommand('{未完成的任务}', 'tasks', true);
    this.addCommand('{已完成的任务}', 'finish', true);
};
Window_TaskType.prototype.setListWindow = function(window) {
    this._listWindow = window;
};
Window_TaskType.prototype.update = function() {
    Window_Command.prototype.update.call(this);
    this._listWindow && this._listWindow.setTaskType(this._index);
};
//=================================================================================================
function Window_TaskList() {
    this.initialize.apply(this, arguments);
}
Window_TaskList.prototype = Object.create(Window_Selectable.prototype);
Window_TaskList.prototype.constructor = Window_TaskList;
Window_TaskList.prototype.initialize = function() {
    var x = (Graphics.width - 750) / 2;
    Window_Selectable.prototype.initialize.call(this, x, 105, 320, 486);
    this._taskType = 0;
    this._data = [];
    this.refresh();
};
Window_TaskList.prototype.maxItems = function() {
    return this._data ? this._data.length : 1;
};
Window_TaskList.prototype.setType = function(type) {
    if (this._taskType !== type) {
        this._taskType = type;
        this.refresh();
    }
};
Window_TaskList.prototype.setInfoWindow = function(infoWindow) {
    this._infoWindow = infoWindow;
};
Window_TaskList.prototype.setTaskType = function(type) {
    if (this._taskType !== type) {
        this._taskType = type;
        this.refresh();
    }
};
Window_TaskList.prototype.refresh = function() {
    this.contents.clear();
    this.makeItemList();
    this.drawAllItems();
};
Window_TaskList.prototype.item = function() {
    var index = this.index();
    return this._data && index >= 0 ? this._data[index] : null;
};
Window_TaskList.prototype.includes = function(task) {
    return !!task;
};
Window_TaskList.prototype.makeItemList = function() {
    this._data = [];
    var arr = $gameParty.tasks().filter(function(task) {
        if (!this._taskType) return !task.haveFinished();
        else return task.haveFinished();
    }, this);
    this._data = arr.filter(function(task) {
        return this.includes(task);
    }, this);
};
Window_TaskList.prototype.drawItem = function(index) {
    var task = this._data[index];
    if (task) {
        var rect = this.itemRect(index);
        var color = task.haveFinished() ? 'rgb(0,200,0)' : 'rgb(255,255,255)';
        this.changeTextColor(color);
        this.drawText(task.name(), rect.x, rect.y, rect.width);;
    }
};
Window_TaskList.prototype.update = function() {
    Window_Selectable.prototype.update.call(this);
    this._infoWindow && this._infoWindow.setTask(this.item());
};
//=================================================================================================
function Window_TaskInfo() {
    this.initialize.apply(this, arguments);
}
Window_TaskInfo.prototype = Object.create(Window_Base.prototype);
Window_TaskInfo.prototype.constructor = Window_TaskInfo;
Window_TaskInfo.prototype.initialize = function() {
    var x = (Graphics.width - 750) / 2 + 310;
    Window_Base.prototype.initialize.call(this, x, 105, 440, 486);
    this._task = null;
    this.refresh();
};
Window_TaskInfo.prototype.lineHeight = function() {
    return 30;
};
Window_TaskInfo.prototype.standardFontSize = function() {
    return 20;
};
Window_TaskInfo.prototype.setTask = function(task) {
    if (this._task !== task) {
        this._task = task;
        this.refresh();
    }
};
Window_TaskInfo.prototype.refresh = function() {
    this.contents.clear();
    this.drawSysWord();
    if (!this._task) return;
    this.drawTaskDes();
    this.drawTaskTag();
    this.drawTaskCpt();
    this.drawTaskPrizies();
};
Window_TaskInfo.prototype.drawSysWord = function() {
    this.contents.fontSize = 22;
    var color = this.textColor(XdRsData.weTask.getColor('sys'));
    this.changeTextColor(color);
    this.contents.drawText(gl_translate('{任务描述}:'), 10, 0, 160, 30);
    this.contents.drawText(gl_translate('{完成条件}:'), 10, 180, 160, 30);
    this.contents.drawText(gl_translate('{任务奖励}:'), 10, 300, 160, 30);
};
Window_TaskInfo.prototype.drawTaskDes = function() {
    this.contents.fontSize = 20;
    this.changeTextColor('rgb(255,255,255)');
    this.drawTextEx(gl_translate(this._task.des()), 20, 30);
};
Window_TaskInfo.prototype.drawTaskTag = function() {
    if (!this._task.haveFinished()) return;
    this.contents.fontSize = 20;
    this.changeTextColor('rgb(0,200,0)');
    this.drawText(gl_translate('<{已完成}>'), 300, 0, 120);
};
Window_TaskInfo.prototype.drawTaskCpt = function() {
    this.contents.fontSize = 18;
    for (var i=0;i<this._task.conditions().length;i++) {
        var cpt = this._task.conditions()[i];
        this.changeTextColor('rgb(255,255,255)');
        this.contents.drawText(cpt.frontText(), 20, i*24+210, 220, 24);
        var color = cpt.isMeet() ? 'rgb(0,200,0)' : 'rgb(255,200,0)';
        this.changeTextColor(color);
        this.contents.drawText(cpt.numText(), 20, i*24+210, 220, 24, 'right');
    }
};
Window_TaskInfo.prototype.drawTaskPrizies = function() {
    this.contents.fontSize = 18;
    this.changeTextColor('rgb(255,255,255)');
    for (var i=0;i<this._task.prizies().length;i++) {
        var prize = this._task.prizies()[i];
        this.zoomOutIcon(20, i*26+330, prize.iconIndex(), 26);
        this.contents.drawText(gl_translate(prize.name()), 56, i*26+330, 192, 26);
        this.contents.drawText(prize.numText(), 56, i*26+330, 192, 26, 'right');
    }
};
Window_TaskInfo.prototype.zoomOutIcon = function(x, y, iconIndex, size) {
    Ui_Window.prototype.zoomOutIcon.call(this, x, y, iconIndex, size);
};
//=================================================================================================
function Scene_Task() {
    this.initialize.apply(this, arguments);
}
Scene_Task.prototype = Object.create(Scene_ItemBase.prototype);
Scene_Task.prototype.constructor = Scene_Task;
Scene_Task.prototype.initialize = function() {
    Scene_ItemBase.prototype.initialize.call(this);
};
Scene_Task.prototype.create = function() {
    Scene_ItemBase.prototype.create.call(this);
    this.createTypeWindow();
    this.createListWindow();
    this.createInfoWindow();
};
Scene_Task.prototype.createTypeWindow = function() {
    this._typeWindow = new Window_TaskType();
    this._typeWindow.setHandler('ok',      this.onTypeOk.bind(this));
    this._typeWindow.setHandler('cancel',  this.popScene.bind(this));
    this.addChild(this._typeWindow);
};
Scene_Task.prototype.createListWindow = function() {
    this._listWindow = new Window_TaskList();
    this._listWindow.setHandler('cancel',  this.onListCancel.bind(this));
    this._typeWindow.setListWindow(this._listWindow);
    this.addChild(this._listWindow);
};
Scene_Task.prototype.createInfoWindow = function() {
    this._infoWindow = new Window_TaskInfo();
    this._listWindow.setInfoWindow(this._infoWindow);
    this.addChild(this._infoWindow);
};
Scene_Task.prototype.onTypeOk = function() {
    this._listWindow.activate();
    this._listWindow.select(0);
};
Scene_Task.prototype.onListCancel = function() {
    this._typeWindow.activate();
    this._listWindow.select(-1);
};
//=================================================================================================
// end
//=================================================================================================