var GL_LANGUAGE = 'jp';


var LANG_WEBSTORE_ID = -10000;


var Load_Language = function(){
	if (StorageManager.isLocalMode()) {
		var fs = require("fs");
		// 读取文件
		fs.readFile('data/language.so', 'utf8', function(err, data) {
			if (err) {
				//console.error(err);
			} else {
				//console.log(data);
				GL_LANGUAGE = data;
				//InitLanguage();
			}
		});
	}else{
		
		//var json = JsonEx.stringify(gameData);
		try{
			var data = localStorage.getItem(LANG_WEBSTORE_ID);
			var json = LZString.decompressFromBase64(data);
			var langData = JsonEx.parse(json);
			GL_LANGUAGE = langData["lang"];
		}catch(e){
			try{
				var xhr = new XMLHttpRequest();
				var str = "";
				//data/md5.txt
				xhr.open('GET', "data/language.so" ,false);
				//xhr.responseType = "arraybuffer";
				xhr.overrideMimeType('text/plain; charset=utf-8');
				xhr.onload = function() {
					if (xhr.status < 400) {
						var txt = xhr.response;
						GL_LANGUAGE = txt;	
						//InitLanguage();
					}
				}
				xhr.send();
			}catch(ex){}
		}
	}
}

var Save_Language = function(lan){
	if (StorageManager.isLocalMode()	) {
		var fs = require("fs");
		fs.writeFile('data/language.so', lan, function(err) {
			if (err) {
				//console.error(err);
			} else {
				//console.log('File written successfully');
			}
		});
	}else{
		var langData = {};
		langData["lang"] = lan;
		// 将gameData对象转换为JSON字符串
		var json = JsonEx.stringify(langData);
		// 使用LZString库将JSON字符串压缩并编码
		var data = LZString.compressToBase64(json);
		// 将数据存储到WebStorage中，key为-1000
		localStorage.setItem(LANG_WEBSTORE_ID, data);
	}
}

Load_Language();

var InitLanguage = function(lang,m){
	languageMap[lang] = m;
}

// languageMap.js
var languageMap ={

};